/*
 * Decompiled with CFR 0.152.
 */
package japicmp.util;

import japicmp.util.TypeNameHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class MemberValueHelper {
    private MemberValueHelper() {
    }

    public static String formatMemberValue(MemberValue value, boolean shorten) {
        if (value instanceof AnnotationMemberValue) {
            Annotation annotation = ((AnnotationMemberValue)value).getValue();
            Set<String> names = annotation.getMemberNames();
            String typeName = TypeNameHelper.formatTypeName(annotation.getTypeName(), Collections.emptyList(), shorten);
            if (names.isEmpty()) {
                return typeName;
            }
            return typeName + "(" + names.stream().map(annotation::getMemberValue).map(Object::toString).collect(Collectors.joining(", ")) + ")";
        }
        if (value instanceof ArrayMemberValue) {
            return "{" + Arrays.stream(((ArrayMemberValue)value).getValue()).map(x -> MemberValueHelper.formatMemberValue(x, shorten)).collect(Collectors.joining(", ")) + "}";
        }
        if (value instanceof BooleanMemberValue) {
            return Boolean.toString(((BooleanMemberValue)value).getValue());
        }
        if (value instanceof ByteMemberValue) {
            return Byte.toString(((ByteMemberValue)value).getValue());
        }
        if (value instanceof CharMemberValue) {
            return Character.toString(((CharMemberValue)value).getValue());
        }
        if (value instanceof FloatMemberValue) {
            return Float.toString(((FloatMemberValue)value).getValue());
        }
        if (value instanceof DoubleMemberValue) {
            return Double.toString(((DoubleMemberValue)value).getValue());
        }
        if (value instanceof ShortMemberValue) {
            return Short.toString(((ShortMemberValue)value).getValue());
        }
        if (value instanceof IntegerMemberValue) {
            return Integer.toString(((IntegerMemberValue)value).getValue());
        }
        if (value instanceof LongMemberValue) {
            return Long.toString(((LongMemberValue)value).getValue());
        }
        if (value instanceof EnumMemberValue) {
            return shorten ? ((EnumMemberValue)value).getValue() : value.toString();
        }
        if (value instanceof StringMemberValue) {
            return "\"" + ((StringMemberValue)value).getValue() + "\"";
        }
        if (value instanceof ClassMemberValue) {
            return TypeNameHelper.formatTypeName(((ClassMemberValue)value).getValue(), Collections.emptyList(), shorten);
        }
        return value.toString();
    }
}

