/*
 * Decompiled with CFR 0.152.
 */
package japicmp.util;

import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.config.Options;
import japicmp.model.AbstractModifier;
import japicmp.model.AccessModifier;
import japicmp.model.BridgeModifier;
import japicmp.model.FinalModifier;
import japicmp.model.JApiAttribute;
import japicmp.model.JApiCanBeSynthetic;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiHasAccessModifier;
import japicmp.model.JApiModifier;
import japicmp.model.JApiModifierBase;
import japicmp.model.StaticModifier;
import japicmp.model.SyntheticAttribute;
import japicmp.model.SyntheticModifier;
import japicmp.model.TransientModifier;
import japicmp.model.VolatileModifier;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;

public class ModifierHelper {
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_SYNTHETIC = 4096;
    private static final List<? extends JApiModifierBase> IGNORED_MODIFIERS = Arrays.asList(AbstractModifier.NON_ABSTRACT, AccessModifier.PACKAGE_PROTECTED, BridgeModifier.NON_BRIDGE, FinalModifier.NON_FINAL, StaticModifier.NON_STATIC, SyntheticModifier.NON_SYNTHETIC, TransientModifier.NON_TRANSIENT, VolatileModifier.NON_VOLATILE);

    private ModifierHelper() {
    }

    public static boolean matchesModifierLevel(AccessModifier modifierLevelOfElement, AccessModifier modifierLevel) {
        return modifierLevelOfElement.getLevel() >= modifierLevel.getLevel();
    }

    public static boolean matchesModifierLevel(int modifierOfElement, AccessModifier modifierLevel) {
        AccessModifier modifierLevelOfElement = ModifierHelper.translateToModifierLevel(modifierOfElement);
        return ModifierHelper.matchesModifierLevel(modifierLevelOfElement, modifierLevel);
    }

    public static AccessModifier translateToModifierLevel(int modifier) {
        if (Modifier.isPublic(modifier)) {
            return AccessModifier.PUBLIC;
        }
        if (Modifier.isProtected(modifier)) {
            return AccessModifier.PROTECTED;
        }
        if (Modifier.isPrivate(modifier)) {
            return AccessModifier.PRIVATE;
        }
        return AccessModifier.PACKAGE_PROTECTED;
    }

    public static boolean isNotPrivate(JApiHasAccessModifier jApiHasAccessModifier) {
        JApiModifier<AccessModifier> accessModifier = jApiHasAccessModifier.getAccessModifier();
        return accessModifier.getOldModifier().isPresent() && accessModifier.getNewModifier().isPresent() ? accessModifier.getNewModifier().get().getLevel() > AccessModifier.PRIVATE.getLevel() || accessModifier.getOldModifier().get().getLevel() > AccessModifier.PRIVATE.getLevel() : (!accessModifier.getOldModifier().isPresent() && accessModifier.getNewModifier().isPresent() ? accessModifier.getNewModifier().get().getLevel() > AccessModifier.PRIVATE.getLevel() : accessModifier.getOldModifier().isPresent() && !accessModifier.getNewModifier().isPresent() && accessModifier.getOldModifier().get().getLevel() > AccessModifier.PRIVATE.getLevel());
    }

    public static boolean hasModifierLevelDecreased(JApiHasAccessModifier hasAccessModifier) {
        JApiModifier<AccessModifier> accessModifier = hasAccessModifier.getAccessModifier();
        if (accessModifier.getOldModifier().isPresent() && accessModifier.getNewModifier().isPresent()) {
            AccessModifier oldModifier = accessModifier.getOldModifier().get();
            AccessModifier newModifier = accessModifier.getNewModifier().get();
            if (newModifier.getLevel() < oldModifier.getLevel()) {
                return true;
            }
        }
        return false;
    }

    public static boolean matchesModifierLevel(JApiHasAccessModifier hasAccessModifier, AccessModifier accessModifierParam) {
        AccessModifier newModifier;
        AccessModifier oldModifier;
        JApiModifier<AccessModifier> accessModifier = hasAccessModifier.getAccessModifier();
        if (accessModifier.getOldModifier().isPresent() && ModifierHelper.matchesModifierLevel(oldModifier = accessModifier.getOldModifier().get(), accessModifierParam)) {
            return true;
        }
        return accessModifier.getNewModifier().isPresent() && ModifierHelper.matchesModifierLevel(newModifier = accessModifier.getNewModifier().get(), accessModifierParam);
    }

    public static <T extends JApiModifierBase> JApiModifier<T> extractModifierFromClass(Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional, ExtractModifierFromClassCallback<T> callback) {
        if (oldClassOptional.isPresent() && newClassOptional.isPresent()) {
            T newClassModifier;
            CtClass oldClass = oldClassOptional.get();
            CtClass newClass = newClassOptional.get();
            T oldClassModifier = callback.getModifierForOld(oldClass);
            if (oldClassModifier != (newClassModifier = callback.getModifierForNew(newClass))) {
                return new JApiModifier<T>(Optional.of(oldClassModifier), Optional.of(newClassModifier), JApiChangeStatus.MODIFIED);
            }
            return new JApiModifier<T>(Optional.of(oldClassModifier), Optional.of(newClassModifier), JApiChangeStatus.UNCHANGED);
        }
        if (oldClassOptional.isPresent()) {
            CtClass oldClass = oldClassOptional.get();
            T oldClassModifier = callback.getModifierForOld(oldClass);
            return new JApiModifier<T>(Optional.of(oldClassModifier), Optional.empty(), JApiChangeStatus.REMOVED);
        }
        if (newClassOptional.isPresent()) {
            CtClass newClass = newClassOptional.get();
            T newClassModifier = callback.getModifierForNew(newClass);
            return new JApiModifier(Optional.empty(), Optional.of(newClassModifier), JApiChangeStatus.NEW);
        }
        return new JApiModifier(Optional.empty(), Optional.empty(), JApiChangeStatus.UNCHANGED);
    }

    public static <T extends JApiModifierBase> JApiModifier<T> extractModifierFromBehavior(Optional<? extends CtBehavior> oldClassOptional, Optional<? extends CtBehavior> newClassOptional, ExtractModifierFromBehaviorCallback<T> callback) {
        if (oldClassOptional.isPresent() && newClassOptional.isPresent()) {
            T newClassModifier;
            CtBehavior oldClass = oldClassOptional.get();
            CtBehavior newClass = newClassOptional.get();
            T oldClassModifier = callback.getModifierForOld(oldClass);
            if (oldClassModifier != (newClassModifier = callback.getModifierForNew(newClass))) {
                return new JApiModifier<T>(Optional.of(oldClassModifier), Optional.of(newClassModifier), JApiChangeStatus.MODIFIED);
            }
            return new JApiModifier<T>(Optional.of(oldClassModifier), Optional.of(newClassModifier), JApiChangeStatus.UNCHANGED);
        }
        if (oldClassOptional.isPresent()) {
            CtBehavior oldClass = oldClassOptional.get();
            T oldClassModifier = callback.getModifierForOld(oldClass);
            return new JApiModifier<T>(Optional.of(oldClassModifier), Optional.empty(), JApiChangeStatus.REMOVED);
        }
        if (newClassOptional.isPresent()) {
            CtBehavior newClass = newClassOptional.get();
            T newClassModifier = callback.getModifierForNew(newClass);
            return new JApiModifier(Optional.empty(), Optional.of(newClassModifier), JApiChangeStatus.NEW);
        }
        return new JApiModifier(Optional.empty(), Optional.empty(), JApiChangeStatus.UNCHANGED);
    }

    public static <T extends JApiModifierBase> JApiModifier<T> extractModifierFromField(Optional<CtField> oldFieldOptional, Optional<CtField> newFieldOptional, ExtractModifierFromFieldCallback<T> callback) {
        if (oldFieldOptional.isPresent() && newFieldOptional.isPresent()) {
            T newFieldModifier;
            CtField oldField = oldFieldOptional.get();
            CtField newField = newFieldOptional.get();
            T oldFieldModifier = callback.getModifierForOld(oldField);
            if (oldFieldModifier != (newFieldModifier = callback.getModifierForNew(newField))) {
                return new JApiModifier<T>(Optional.of(oldFieldModifier), Optional.of(newFieldModifier), JApiChangeStatus.MODIFIED);
            }
            return new JApiModifier<T>(Optional.of(oldFieldModifier), Optional.of(newFieldModifier), JApiChangeStatus.UNCHANGED);
        }
        if (oldFieldOptional.isPresent()) {
            CtField oldField = oldFieldOptional.get();
            T oldFieldModifier = callback.getModifierForOld(oldField);
            return new JApiModifier<T>(Optional.of(oldFieldModifier), Optional.empty(), JApiChangeStatus.REMOVED);
        }
        if (newFieldOptional.isPresent()) {
            CtField newField = newFieldOptional.get();
            T newFieldModifier = callback.getModifierForNew(newField);
            return new JApiModifier(Optional.empty(), Optional.of(newFieldModifier), JApiChangeStatus.NEW);
        }
        return new JApiModifier(Optional.empty(), Optional.empty(), JApiChangeStatus.UNCHANGED);
    }

    public static boolean isBridge(int modifier) {
        return (modifier & 0x40) != 0;
    }

    public static boolean isSynthetic(int modifier) {
        return (modifier & 0x1000) != 0;
    }

    public static boolean includeSynthetic(JApiCanBeSynthetic jApiCanBeSynthetic, JarArchiveComparatorOptions options) {
        return options.isIncludeSynthetic() || !ModifierHelper.isSynthetic(jApiCanBeSynthetic);
    }

    public static boolean includeSynthetic(JApiCanBeSynthetic jApiCanBeSynthetic, Options options) {
        return !ModifierHelper.isSynthetic(jApiCanBeSynthetic) || options.isIncludeSynthetic();
    }

    public static boolean isSynthetic(JApiCanBeSynthetic jApiClass) {
        boolean isSynthetic = false;
        JApiModifier<SyntheticModifier> syntheticModifier = jApiClass.getSyntheticModifier();
        JApiAttribute<SyntheticAttribute> syntheticAttribute = jApiClass.getSyntheticAttribute();
        boolean hasSyntheticModifier = ModifierHelper.hasSyntheticModifier(syntheticModifier);
        boolean hasSyntheticAttribute = ModifierHelper.hasSyntheticAttribute(syntheticAttribute);
        if (hasSyntheticModifier || hasSyntheticAttribute) {
            isSynthetic = true;
        }
        return isSynthetic;
    }

    public static Optional<String> getOldModifierName(JApiModifier<? extends Enum<? extends Enum<?>>> modifier) {
        return ModifierHelper.getModifierName(modifier.getOldModifier());
    }

    public static Optional<String> getNewModifierName(JApiModifier<? extends Enum<? extends Enum<?>>> modifier) {
        return ModifierHelper.getModifierName(modifier.getNewModifier());
    }

    private static Optional<String> getModifierName(Optional<? extends Enum<?>> modifier) {
        return !modifier.isPresent() || IGNORED_MODIFIERS.contains(modifier.get()) ? Optional.empty() : Optional.of(modifier.get().name().toLowerCase());
    }

    private static boolean hasSyntheticAttribute(JApiAttribute<SyntheticAttribute> syntheticAttribute) {
        SyntheticAttribute newAttribute;
        boolean hasSyntheticAttribute = false;
        if (syntheticAttribute.getOldAttribute().isPresent() && syntheticAttribute.getNewAttribute().isPresent()) {
            SyntheticAttribute oldAttribute = syntheticAttribute.getOldAttribute().get();
            SyntheticAttribute newAttribute2 = syntheticAttribute.getNewAttribute().get();
            if (oldAttribute == SyntheticAttribute.SYNTHETIC && newAttribute2 == SyntheticAttribute.SYNTHETIC) {
                hasSyntheticAttribute = true;
            }
        } else if (syntheticAttribute.getOldAttribute().isPresent()) {
            SyntheticAttribute oldAttribute = syntheticAttribute.getOldAttribute().get();
            if (oldAttribute == SyntheticAttribute.SYNTHETIC) {
                hasSyntheticAttribute = true;
            }
        } else if (syntheticAttribute.getNewAttribute().isPresent() && (newAttribute = syntheticAttribute.getNewAttribute().get()) == SyntheticAttribute.SYNTHETIC) {
            hasSyntheticAttribute = true;
        }
        return hasSyntheticAttribute;
    }

    private static boolean hasSyntheticModifier(JApiModifier<SyntheticModifier> syntheticModifier) {
        SyntheticModifier newModifier;
        boolean hasSyntheticModifier = false;
        if (syntheticModifier.getOldModifier().isPresent() && syntheticModifier.getNewModifier().isPresent()) {
            SyntheticModifier oldModifier = syntheticModifier.getOldModifier().get();
            SyntheticModifier newModifier2 = syntheticModifier.getNewModifier().get();
            if (oldModifier == SyntheticModifier.SYNTHETIC && newModifier2 == SyntheticModifier.SYNTHETIC) {
                hasSyntheticModifier = true;
            }
        } else if (syntheticModifier.getOldModifier().isPresent()) {
            SyntheticModifier oldModifier = syntheticModifier.getOldModifier().get();
            if (oldModifier == SyntheticModifier.SYNTHETIC) {
                hasSyntheticModifier = true;
            }
        } else if (syntheticModifier.getNewModifier().isPresent() && (newModifier = syntheticModifier.getNewModifier().get()) == SyntheticModifier.SYNTHETIC) {
            hasSyntheticModifier = true;
        }
        return hasSyntheticModifier;
    }

    public static interface ExtractModifierFromFieldCallback<T extends JApiModifierBase> {
        public T getModifierForOld(CtField var1);

        public T getModifierForNew(CtField var1);
    }

    public static interface ExtractModifierFromBehaviorCallback<T extends JApiModifierBase> {
        public T getModifierForOld(CtBehavior var1);

        public T getModifierForNew(CtBehavior var1);
    }

    public static interface ExtractModifierFromClassCallback<T extends JApiModifierBase> {
        public T getModifierForOld(CtClass var1);

        public T getModifierForNew(CtClass var1);
    }
}

