/*
 * Decompiled with CFR 0.152.
 */
package japicmp.util;

import japicmp.model.JApiBehavior;
import japicmp.model.JApiGenericTemplate;
import japicmp.model.JApiGenericType;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiHasGenericTemplates;
import japicmp.model.JApiParameter;
import japicmp.model.VarargsModifier;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TypeNameHelper {
    private static final String STR_ARRAY = "[]";
    private static final String STR_VARARGS = "...";

    private TypeNameHelper() {
    }

    public static String formatGenericTemplate(String name, String type, List<JApiGenericType> genericTypes, boolean shorten) {
        return type == null ? name : name + " extends " + TypeNameHelper.formatTypeName(type, genericTypes, shorten);
    }

    public static String formatTypeName(String typeName, List<JApiGenericType> genericTypes, int maxLength) {
        if (typeName == null || typeName.isEmpty() || typeName.equals("n.a.")) {
            return typeName;
        }
        return TypeNameHelper.truncateTypeName(typeName, maxLength) + TypeNameHelper.formatGenericTypes(genericTypes, maxLength);
    }

    public static String formatTypeName(String typeName, JApiHasChangeStatus hasChangeStatus, JApiHasGenericTemplates hasGenericTemplates, int maxLength) {
        if (typeName == null || typeName.isEmpty() || typeName.equals("n.a.")) {
            return typeName;
        }
        return TypeNameHelper.truncateTypeName(typeName, maxLength) + (hasGenericTemplates == null ? "" : TypeNameHelper.formatGenericTemplates(hasChangeStatus, hasGenericTemplates.getGenericTemplates(), maxLength));
    }

    public static String formatTypeName(String type, List<JApiGenericType> genericTypes, boolean shorten) {
        return TypeNameHelper.formatTypeName(type, genericTypes, shorten ? 32 : -1);
    }

    public static String formatTypeName(String typeName, JApiHasChangeStatus hasChangeStatus, JApiHasGenericTemplates hasGenericTemplates, boolean shorten) {
        return TypeNameHelper.formatTypeName(typeName, hasChangeStatus, hasGenericTemplates, shorten ? 32 : -1);
    }

    public static String formatParameterTypeName(JApiBehavior method, JApiParameter parameter, Optional<VarargsModifier> varargs, List<JApiGenericType> genericTypes, boolean shorten) {
        String type = parameter.getType();
        List<JApiParameter> params = method.getParameters();
        if (type.endsWith(STR_ARRAY) && parameter == params.get(params.size() - 1) && varargs.orElse(VarargsModifier.NON_VARARGS) == VarargsModifier.VARARGS) {
            return TypeNameHelper.formatTypeName(type.substring(0, type.length() - 2) + STR_VARARGS, genericTypes, shorten);
        }
        return TypeNameHelper.formatTypeName(type, genericTypes, shorten);
    }

    private static String formatGenericTypes(List<JApiGenericType> genericTypes, int maxLength) {
        if (genericTypes == null || genericTypes.isEmpty()) {
            return "";
        }
        return "<" + genericTypes.stream().map(x -> TypeNameHelper.formatGenericType(x, maxLength)).collect(Collectors.joining(", ")) + ">";
    }

    private static String formatGenericTemplates(JApiHasChangeStatus hasChangeStatus, List<JApiGenericTemplate> genericTemplates, int maxLength) {
        if (genericTemplates == null || genericTemplates.isEmpty()) {
            return "";
        }
        return "<" + genericTemplates.stream().map(x -> TypeNameHelper.formatGenericTemplate(hasChangeStatus, x, maxLength)).collect(Collectors.joining(", ")) + ">";
    }

    private static String formatGenericType(JApiGenericType genericType, int maxLength) {
        switch (genericType.getGenericWildCard()) {
            case NONE: {
                return TypeNameHelper.formatTypeName(genericType.getType(), genericType.getGenericTypes(), maxLength);
            }
            default: {
                return "?";
            }
            case EXTENDS: {
                return "? extends " + TypeNameHelper.formatTypeName(genericType.getType(), genericType.getGenericTypes(), maxLength);
            }
            case SUPER: 
        }
        return "? super " + TypeNameHelper.formatTypeName(genericType.getType(), genericType.getGenericTypes(), maxLength);
    }

    private static String formatGenericTemplate(JApiHasChangeStatus hasChangeStatus, JApiGenericTemplate genericTemplate, int maxLength) {
        String name = genericTemplate.getName();
        String type = null;
        List<JApiGenericType> genericTypes = null;
        if (maxLength <= 0) {
            switch (hasChangeStatus.getChangeStatus()) {
                default: {
                    if (genericTemplate.getNewTypeOptional().isPresent()) {
                        type = genericTemplate.getNewType();
                        genericTypes = genericTemplate.getNewGenericTypes();
                        break;
                    }
                }
                case UNCHANGED: 
                case REMOVED: {
                    if (!genericTemplate.getOldTypeOptional().isPresent()) break;
                    type = genericTemplate.getOldType();
                    genericTypes = genericTemplate.getOldGenericTypes();
                }
            }
        }
        if (type == null) {
            return name;
        }
        return name + " extends " + TypeNameHelper.formatTypeName(type, genericTypes, maxLength);
    }

    private static String truncateTypeName(String typeName, int maxLength) {
        int dot;
        if (maxLength < 3) {
            return typeName;
        }
        int dollar = typeName.lastIndexOf(36);
        int pos = Integer.max(dollar, dot = (typeName.endsWith(STR_VARARGS) ? typeName.substring(0, typeName.length() - 3) : typeName).lastIndexOf(46));
        String name = pos > 0 ? typeName.substring(pos + 1) : typeName;
        int length = name.length();
        if (length > maxLength) {
            int half = maxLength / 2;
            return name.substring(0, maxLength - half - 1) + '\u2026' + name.substring(length - half);
        }
        return name;
    }
}

