/*
 * Decompiled with CFR 0.152.
 */
package japicmp.versioning;

import java.util.Optional;

public class SemanticVersion {
    private final int major;
    private final int minor;
    private final int patch;

    public SemanticVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticVersion that = (SemanticVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public Optional<ChangeType> computeChangeType(SemanticVersion version) {
        if (this.major != version.major) {
            return Optional.of(ChangeType.MAJOR);
        }
        if (this.minor != version.minor) {
            return Optional.of(ChangeType.MINOR);
        }
        if (this.patch != version.patch) {
            return Optional.of(ChangeType.PATCH);
        }
        return Optional.of(ChangeType.UNCHANGED);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public static enum ChangeType {
        MAJOR(3),
        MINOR(2),
        PATCH(1),
        UNCHANGED(0);

        private final int rank;

        private ChangeType(int rank) {
            this.rank = rank;
        }

        public int getRank() {
            return this.rank;
        }
    }
}

