/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import jogamp.common.Debug;

public class Bitstream<T> {
    private static final boolean DEBUG = Debug.debug("Bitstream");
    public static final int EOS = -1;
    private ByteStream<T> bytes;
    private int bitBuffer;
    private int bitsDataMark;
    private int bitCount;
    private int bitsCountMark;
    private boolean outputMode;
    private boolean throwIOExceptionOnEOF;
    private static final String strZeroPadding = "0000000000000000000000000000000000000000000000000000000000000000";

    public Bitstream(ByteStream<T> byteStream, boolean bl) throws IllegalArgumentException {
        this.bytes = byteStream;
        this.outputMode = bl;
        this.resetLocal();
        this.validateMode();
        this.throwIOExceptionOnEOF = false;
    }

    private final void resetLocal() {
        this.bitBuffer = 0;
        this.bitCount = 0;
        this.bitsDataMark = 0;
        this.bitsCountMark = -1;
    }

    private final void validateMode() throws IllegalArgumentException {
        if (!this.canInput() && !this.canOutput()) {
            throw new IllegalArgumentException("stream can neither input nor output: " + this);
        }
        if (this.outputMode && !this.canOutput()) {
            throw new IllegalArgumentException("stream cannot output as requested: " + this);
        }
        if (!this.outputMode && !this.canInput()) {
            throw new IllegalArgumentException("stream cannot input as requested: " + this);
        }
    }

    public final void setThrowIOExceptionOnEOF(boolean bl) {
        this.throwIOExceptionOnEOF = bl;
    }

    public final boolean getThrowIOExceptionOnEOF() {
        return this.throwIOExceptionOnEOF;
    }

    public final void setStream(T t, boolean bl) throws IllegalArgumentException, IOException {
        if (null != this.bytes && this.outputMode) {
            this.flush();
        }
        this.bytes.setStream(t);
        this.outputMode = bl;
        this.resetLocal();
        this.validateMode();
    }

    public final ByteStream<T> getStream() {
        return this.bytes;
    }

    public final T getSubStream() {
        return this.bytes.getStream();
    }

    public final void close() throws IOException {
        if (null != this.bytes && this.outputMode) {
            this.flush();
        }
        this.bytes.close();
        this.bytes = null;
        this.resetLocal();
    }

    public final int flush() throws IllegalStateException, IOException {
        if (!this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in output-mode: " + this);
        }
        this.bytes.flush();
        if (0 != this.bitCount) {
            int n = this.bytes.write((byte)this.bitBuffer);
            this.bitBuffer = 0;
            this.bitCount = 0;
            if (-1 == n) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            }
        }
        return 0;
    }

    public final boolean canInput() {
        return null != this.bytes ? this.bytes.canInput() : false;
    }

    public final boolean canOutput() {
        return null != this.bytes ? this.bytes.canOutput() : false;
    }

    public final void mark(int n) throws IllegalStateException {
        if (this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        this.bytes.mark(n);
        this.bitsDataMark = this.bitBuffer;
        this.bitsCountMark = this.bitCount;
    }

    public final void reset() throws IllegalStateException, IOException {
        if (this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        if (0 > this.bitsCountMark) {
            throw new IllegalStateException("markpos not set: " + this);
        }
        this.bytes.reset();
        this.bitBuffer = this.bitsDataMark;
        this.bitCount = this.bitsCountMark;
    }

    public final int getBitCount() {
        return this.bitCount;
    }

    public final int getLastBitPos() {
        return 7 - this.bitCount;
    }

    public final int getBitPosition() {
        if (0 == this.bitCount) {
            return 0;
        }
        return 8 - this.bitCount;
    }

    public final int getBitBuffer() {
        return this.bitBuffer;
    }

    public final long position() {
        if (null == this.bytes) {
            return -1L;
        }
        if (0 == this.bitCount) {
            return this.bytes.position() << 3;
        }
        long l = this.bytes.position() - (long)(this.outputMode ? 0 : 1);
        return (l << 3) + 8L - (long)this.bitCount;
    }

    public final int readBit(boolean bl) throws IllegalStateException, IOException {
        if (this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        if (bl) {
            if (0 < this.bitCount) {
                --this.bitCount;
                return this.bitBuffer >>> this.bitCount & 1;
            }
            this.bitBuffer = this.bytes.read();
            if (-1 == this.bitBuffer) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            }
            this.bitCount = 7;
            return this.bitBuffer >>> 7;
        }
        if (0 < this.bitCount) {
            --this.bitCount;
            return this.bitBuffer >>> 7 - this.bitCount & 1;
        }
        this.bitBuffer = this.bytes.read();
        if (-1 == this.bitBuffer) {
            if (this.throwIOExceptionOnEOF) {
                throw new IOException("EOS " + this);
            }
            return -1;
        }
        this.bitCount = 7;
        return this.bitBuffer & 1;
    }

    public final int writeBit(boolean bl, int n) throws IllegalStateException, IOException {
        if (!this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in output-mode: " + this);
        }
        if (bl) {
            if (0 < this.bitCount) {
                --this.bitCount;
                this.bitBuffer |= (1 & n) << this.bitCount;
                if (0 == this.bitCount) {
                    int n2 = this.bytes.write((byte)this.bitBuffer);
                    if (this.throwIOExceptionOnEOF && -1 == n2) {
                        throw new IOException("EOS " + this);
                    }
                    return n2;
                }
            } else {
                this.bitCount = 7;
                this.bitBuffer = (1 & n) << 7;
            }
        } else if (0 < this.bitCount) {
            --this.bitCount;
            this.bitBuffer |= (1 & n) << 7 - this.bitCount;
            if (0 == this.bitCount) {
                int n3 = this.bytes.write((byte)this.bitBuffer);
                if (this.throwIOExceptionOnEOF && -1 == n3) {
                    throw new IOException("EOS " + this);
                }
                return n3;
            }
        } else {
            this.bitCount = 7;
            this.bitBuffer = 1 & n;
        }
        return this.bitBuffer;
    }

    public long skip(long l) throws IllegalStateException, IOException {
        if (null == this.bytes) {
            throw new IllegalStateException("closed: " + this);
        }
        if (DEBUG) {
            System.err.println("Bitstream.skip.0: " + l + " - " + this.toStringImpl());
        }
        if (l > 0L) {
            int n;
            long l2;
            long l3;
            long l4;
            long l5;
            if (l <= (long)this.bitCount) {
                this.bitCount -= (int)l;
                if (DEBUG) {
                    System.err.println("Bitstream.skip.F_N1: " + l + " - " + this.toStringImpl());
                }
                return l;
            }
            if (this.outputMode) {
                if (0 < this.bitCount && -1 == this.bytes.write((byte)this.bitBuffer)) {
                    return 0L;
                }
                this.bitBuffer = 0;
            }
            if ((l5 = ((l4 = this.bytes.skip(l3 = (l2 = l - (long)this.bitCount) >>> 3)) << 3) + (long)(n = (int)(l2 - (l3 << 3))) + (long)this.bitCount) < l) {
                this.bitCount = 0;
                this.bitBuffer = 0;
                if (DEBUG) {
                    System.err.println("Bitstream.skip.F_EOS: " + l + " - " + this.toStringImpl());
                }
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return l5;
            }
            this.bitCount = 8 - n & 7;
            int n2 = 0;
            if (!this.outputMode && 0 < this.bitCount) {
                this.bitBuffer = this.bytes.read();
                if (-1 == this.bitBuffer) {
                    n2 = this.bitCount;
                    this.bitCount = 0;
                }
            }
            if (DEBUG) {
                System.err.println("Bitstream.skip.F_N2: " + l + ", notReadBits " + n2 + " - " + this.toStringImpl());
            }
            return l5 - (long)n2;
        }
        return 0L;
    }

    public int readBits31(boolean bl, int n) throws IllegalArgumentException, IOException {
        int n2;
        int n3;
        if (31 < n) {
            throw new IllegalArgumentException("n > 31: " + n);
        }
        if (this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        if (!bl || 0 == n) {
            int n4 = 0;
            int n5 = n;
            while (--n5 >= 0) {
                int n6 = this.readBit(bl);
                if (-1 == n6) {
                    return -1;
                }
                n4 |= n6 << n5;
            }
            return n4;
        }
        int n7 = n;
        int n8 = Math.min(n7, this.bitCount);
        if (0 < n8) {
            n3 = (1 << n8) - 1;
            this.bitCount -= n8;
            n2 = (n3 & this.bitBuffer >>> this.bitCount) << (n7 -= n8);
            if (0 == n7) {
                return n2;
            }
        } else {
            n2 = 0;
        }
        assert (0 == this.bitCount);
        do {
            this.bitBuffer = this.bytes.read();
            if (-1 == this.bitBuffer) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            }
            n3 = Math.min(n7, 8);
            int n9 = (1 << n3) - 1;
            this.bitCount = 8 - n3;
            n2 |= (n9 & this.bitBuffer >>> this.bitCount) << (n7 -= n3);
        } while (0 < n7);
        return n2;
    }

    public int writeBits31(boolean bl, int n, int n2) throws IllegalStateException, IllegalArgumentException, IOException {
        if (31 < n) {
            throw new IllegalArgumentException("n > 31: " + n);
        }
        if (!this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in output-mode: " + this);
        }
        if (!bl || 0 == n) {
            int n3 = n;
            while (--n3 >= 0) {
                int n4 = this.writeBit(bl, n2 >>> n3 & 1);
                if (-1 != n4) continue;
                return -1;
            }
        } else {
            int n5;
            int n6 = n;
            int n7 = Math.min(n6, this.bitCount);
            if (0 < n7) {
                n5 = (1 << n7) - 1;
                this.bitCount -= n7;
                this.bitBuffer |= (n5 & n2 >> (n6 -= n7)) << this.bitCount;
                if (0 == this.bitCount && -1 == this.bytes.write((byte)this.bitBuffer)) {
                    if (this.throwIOExceptionOnEOF) {
                        throw new IOException("EOS " + this);
                    }
                    return -1;
                }
                if (0 == n6) {
                    return n2;
                }
            }
            assert (0 == this.bitCount);
            do {
                n5 = Math.min(n6, 8);
                int n8 = (1 << n5) - 1;
                this.bitCount = 8 - n5;
                this.bitBuffer = (n8 & n2 >> (n6 -= n5)) << this.bitCount;
                if (0 != this.bitCount || -1 != this.bytes.write((byte)this.bitBuffer)) continue;
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            } while (0 < n6);
        }
        return n2;
    }

    public final int readUInt8(boolean bl) throws IllegalStateException, IOException {
        if (0 == this.bitCount && bl) {
            if (this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in input-mode: " + this);
            }
            int n = this.bytes.read();
            if (this.throwIOExceptionOnEOF && -1 == n) {
                throw new IOException("EOS " + this);
            }
            return n;
        }
        return this.readBits31(bl, 8);
    }

    public final int writeInt8(boolean bl, byte by) throws IllegalStateException, IOException {
        if (0 == this.bitCount && bl) {
            if (!this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in output-mode: " + this);
            }
            int n = this.bytes.write(by);
            if (this.throwIOExceptionOnEOF && -1 == n) {
                throw new IOException("EOS " + this);
            }
            return n;
        }
        return this.writeBits31(bl, 8, by);
    }

    public final int readUInt16(boolean bl, boolean bl2) throws IllegalStateException, IOException {
        if (0 == this.bitCount && bl) {
            int n;
            if (this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in input-mode: " + this);
            }
            int n2 = this.bytes.read();
            int n3 = n = -1 != n2 ? this.bytes.read() : -1;
            if (-1 == n) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            }
            if (bl2) {
                return n2 << 8 | n;
            }
            return n << 8 | n2;
        }
        int n = this.readBits31(bl, 16);
        if (-1 == n) {
            return -1;
        }
        if (bl2) {
            return n;
        }
        int n4 = 0xFF & n >>> 8;
        int n5 = 0xFF & n;
        return n5 << 8 | n4;
    }

    public static final int readUInt16(boolean bl, byte[] byArray, int n) throws IndexOutOfBoundsException {
        Bitstream.checkBounds(byArray, n, 2);
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        if (bl) {
            return n2 << 8 | n3;
        }
        return n3 << 8 | n2;
    }

    public final int writeInt16(boolean bl, boolean bl2, short s) throws IllegalStateException, IOException {
        if (0 == this.bitCount && bl) {
            byte by;
            byte by2;
            if (!this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in output-mode: " + this);
            }
            byte by3 = (byte)(0xFF & s >>> 8);
            byte by4 = (byte)(0xFF & s);
            if (bl2) {
                by2 = by3;
                by = by4;
            } else {
                by2 = by4;
                by = by3;
            }
            if (-1 != this.bytes.write(by2) && -1 != this.bytes.write(by)) {
                return s;
            }
            if (this.throwIOExceptionOnEOF) {
                throw new IOException("EOS " + this);
            }
            return -1;
        }
        if (bl2) {
            return this.writeBits31(bl, 16, s);
        }
        int n = 0xFF & s >>> 8;
        int n2 = 0xFF & s;
        return this.writeBits31(bl, 16, n2 << 8 | n);
    }

    public final long readUInt32(boolean bl, boolean bl2) throws IllegalStateException, IOException {
        int n;
        if (0 == this.bitCount && bl) {
            int n2;
            if (this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in input-mode: " + this);
            }
            int n3 = this.bytes.read();
            int n4 = -1 != n3 ? this.bytes.read() : -1;
            int n5 = -1 != n4 ? this.bytes.read() : -1;
            int n6 = n2 = -1 != n5 ? this.bytes.read() : -1;
            if (-1 == n2) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1L;
            }
            if (bl2) {
                return 0xFFFFFFFFL & (long)(n3 << 24 | n4 << 16 | n5 << 8 | n2);
            }
            return 0xFFFFFFFFL & (long)(n2 << 24 | n5 << 16 | n4 << 8 | n3);
        }
        int n7 = this.readBits31(bl, 16);
        int n8 = n = -1 != n7 ? this.readBits31(bl, 16) : -1;
        if (-1 == n) {
            return -1L;
        }
        if (bl2) {
            return 0xFFFFFFFFL & (long)(n7 << 16 | n);
        }
        int n9 = 0xFF & n7 >>> 8;
        int n10 = 0xFF & n7;
        int n11 = 0xFF & n >>> 8;
        int n12 = 0xFF & n;
        return 0xFFFFFFFFL & (long)(n12 << 24 | n11 << 16 | n10 << 8 | n9);
    }

    public static final long readUInt32(boolean bl, byte[] byArray, int n) throws IndexOutOfBoundsException {
        Bitstream.checkBounds(byArray, n, 4);
        byte by = byArray[n];
        byte by2 = byArray[n + 1];
        byte by3 = byArray[n + 2];
        byte by4 = byArray[n + 3];
        if (bl) {
            return 0xFFFFFFFFL & (long)(by << 24 | by2 << 16 | by3 << 8 | by4);
        }
        return 0xFFFFFFFFL & (long)(by4 << 24 | by3 << 16 | by2 << 8 | by);
    }

    public final int writeInt32(boolean bl, boolean bl2, int n) throws IllegalStateException, IOException {
        if (0 == this.bitCount && bl) {
            byte by;
            byte by2;
            byte by3;
            byte by4;
            if (!this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in output-mode: " + this);
            }
            byte by5 = (byte)(0xFF & n >>> 24);
            byte by6 = (byte)(0xFF & n >>> 16);
            byte by7 = (byte)(0xFF & n >>> 8);
            byte by8 = (byte)(0xFF & n);
            if (bl2) {
                by4 = by5;
                by3 = by6;
                by2 = by7;
                by = by8;
            } else {
                by4 = by8;
                by3 = by7;
                by2 = by6;
                by = by5;
            }
            if (-1 != this.bytes.write(by4) && -1 != this.bytes.write(by3) && -1 != this.bytes.write(by2) && -1 != this.bytes.write(by)) {
                return n;
            }
            if (this.throwIOExceptionOnEOF) {
                throw new IOException("EOS " + this);
            }
            return -1;
        }
        if (bl2) {
            int n2 = 0xFFFF & n >>> 16;
            int n3 = 0xFFFF & n;
            if (-1 != this.writeBits31(bl, 16, n2) && -1 != this.writeBits31(bl, 16, n3)) {
                return n;
            }
            return -1;
        }
        int n4 = 0xFF & n >>> 24;
        int n5 = 0xFF & n >>> 16;
        int n6 = 0xFF & n;
        int n7 = 0xFF & n >>> 8;
        if (-1 != this.writeBits31(bl, 16, n6 << 8 | n7) && -1 != this.writeBits31(bl, 16, n5 << 8 | n4)) {
            return n;
        }
        return -1;
    }

    public static final long toUInt32Long(int n) {
        return 0xFFFFFFFFL & (long)n;
    }

    public static final int toUInt32Int(int n) {
        return Bitstream.uint32LongToInt(Bitstream.toUInt32Long(n));
    }

    public static final int uint32LongToInt(long l) {
        if (Integer.MAX_VALUE >= l) {
            return (int)l;
        }
        return -1;
    }

    public String toString() {
        return String.format("Bitstream[%s]", this.toStringImpl());
    }

    protected String toStringImpl() {
        long l;
        String string;
        if (null == this.bytes) {
            string = "closed";
            l = -1L;
        } else {
            string = this.outputMode ? "output" : "input";
            l = this.bytes.position();
        }
        return String.format("%s, pos %d [byteP %d, bitCnt %d], bitbuf %s", string, this.position(), l, this.bitCount, Bitstream.toHexBinString(this.bitBuffer, 8));
    }

    public static String toBinString(int n, int n2) {
        if (0 == n2) {
            return "";
        }
        int n3 = (int)((1L << n2) - 1L);
        String string = Integer.toBinaryString(n3 & n);
        return strZeroPadding.substring(0, n2 - string.length()) + string;
    }

    public static String toHexBinString(int n, int n2) {
        int n3 = 0 == n2 ? 2 : (n2 + 3) / 4;
        return String.format("[%0" + n3 + "X, %s]", n, Bitstream.toBinString(n, n2));
    }

    public static void checkBounds(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException {
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Buffer of size " + byArray.length + " cannot hold offset " + n + " + remaining " + n2);
        }
    }

    public static class ByteOutputStream
    implements ByteStream<OutputStream> {
        private BufferedOutputStream media;
        private long pos = 0L;

        public ByteOutputStream(OutputStream outputStream) {
            this.setStream(outputStream);
        }

        @Override
        public void setStream(OutputStream outputStream) {
            this.media = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : (null != outputStream ? new BufferedOutputStream(outputStream) : null);
            this.pos = 0L;
        }

        @Override
        public void close() throws IOException {
            if (null != this.media) {
                this.media.close();
                this.media = null;
            }
        }

        @Override
        public void flush() throws IOException {
            if (null != this.media) {
                this.media.flush();
            }
        }

        @Override
        public boolean canInput() {
            return false;
        }

        @Override
        public boolean canOutput() {
            return true;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long skip(long l) throws IOException {
            long l2;
            for (l2 = l; l2 > 0L; --l2) {
                this.media.write(0);
            }
            long l3 = l - l2;
            this.pos += l3;
            return l3;
        }

        @Override
        public OutputStream getStream() {
            return this.media;
        }

        @Override
        public void mark(int n) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("not allowed with output stream");
        }

        @Override
        public void reset() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("not allowed with output stream");
        }

        @Override
        public int read() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("not allowed with output stream");
        }

        @Override
        public int write(byte by) throws IOException {
            int n = 0xFF & by;
            this.media.write(n);
            if (DEBUG) {
                System.err.println("u8[" + this.pos + "] <- " + Bitstream.toHexBinString(n, 8));
            }
            ++this.pos;
            return n;
        }
    }

    public static class ByteInputStream
    implements ByteStream<InputStream> {
        private BufferedInputStream media;
        private long pos;
        private long posMark;

        public ByteInputStream(InputStream inputStream) {
            this.setStream(inputStream);
        }

        @Override
        public void setStream(InputStream inputStream) {
            this.media = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : (null != inputStream ? new BufferedInputStream(inputStream) : null);
            this.pos = 0L;
            this.posMark = -1L;
        }

        @Override
        public InputStream getStream() {
            return this.media;
        }

        @Override
        public void close() throws IOException {
            if (null != this.media) {
                this.media.close();
                this.media = null;
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean canInput() {
            return true;
        }

        @Override
        public boolean canOutput() {
            return false;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = this.media.skip(l);
            this.pos += l2;
            return l2;
        }

        @Override
        public void mark(int n) {
            this.media.mark(n);
            this.posMark = this.pos;
        }

        @Override
        public void reset() throws IllegalStateException, IOException {
            if (0L > this.posMark) {
                throw new IllegalStateException("markpos not set");
            }
            if (DEBUG) {
                System.err.println("rewind: " + this.pos + " -> " + this.posMark);
            }
            this.media.reset();
            this.pos = this.posMark;
        }

        @Override
        public int read() throws IOException {
            int n = this.media.read();
            if (DEBUG) {
                if (-1 != n) {
                    System.err.println("u8[" + this.pos + "] -> " + Bitstream.toHexBinString(n, 8));
                } else {
                    System.err.println("u8[" + this.pos + "] -> EOS");
                }
            }
            if (-1 != n) {
                ++this.pos;
            }
            return n;
        }

        @Override
        public int write(byte by) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("not allowed with input stream");
        }
    }

    public static class ByteBufferStream
    implements ByteStream<ByteBuffer> {
        private ByteBuffer media;
        private int pos;
        private int posMark;

        public ByteBufferStream(ByteBuffer byteBuffer) {
            this.setStream(byteBuffer);
        }

        @Override
        public void setStream(ByteBuffer byteBuffer) {
            this.media = byteBuffer;
            this.pos = 0;
            this.posMark = -1;
        }

        @Override
        public ByteBuffer getStream() {
            return this.media;
        }

        @Override
        public void close() {
            this.media = null;
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean canInput() {
            return true;
        }

        @Override
        public boolean canOutput() {
            return true;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long skip(long l) {
            long l2;
            if (l >= 0L) {
                int n = this.media.limit() - this.pos;
                l2 = Math.min(n, (int)l);
            } else {
                int n = (int)l * -1;
                l2 = -1 * Math.min(this.pos, n);
            }
            this.pos = (int)((long)this.pos + l2);
            return l2;
        }

        @Override
        public void mark(int n) {
            this.posMark = this.pos;
        }

        @Override
        public void reset() throws IllegalStateException {
            if (0 > this.posMark) {
                throw new IllegalStateException("markpos not set");
            }
            if (DEBUG) {
                System.err.println("rewind: " + this.pos + " -> " + this.posMark);
            }
            this.media.position(this.posMark);
            this.pos = this.posMark;
        }

        @Override
        public int read() {
            int n = this.media.limit() > this.pos ? 0xFF & this.media.get(this.pos++) : -1;
            if (DEBUG) {
                if (-1 != n) {
                    System.err.println("u8[" + (this.pos - 1) + "] -> " + Bitstream.toHexBinString(n, 8));
                } else {
                    System.err.println("u8[" + (this.pos - 0) + "] -> EOS");
                }
            }
            return n;
        }

        @Override
        public int write(byte by) {
            int n;
            if (this.media.limit() > this.pos) {
                this.media.put(this.pos++, by);
                n = 0xFF & by;
            } else {
                n = -1;
            }
            if (DEBUG) {
                if (-1 != n) {
                    System.err.println("u8[" + (this.pos - 1) + "] <- " + Bitstream.toHexBinString(n, 8));
                } else {
                    System.err.println("u8[" + (this.pos - 0) + "] <- EOS");
                }
            }
            return n;
        }
    }

    public static class ByteArrayStream
    implements ByteStream<byte[]> {
        private byte[] media;
        private int pos;
        private int posMark;

        public ByteArrayStream(byte[] byArray) {
            this.setStream(byArray);
        }

        @Override
        public void setStream(byte[] byArray) {
            this.media = byArray;
            this.pos = 0;
            this.posMark = -1;
        }

        @Override
        public byte[] getStream() {
            return this.media;
        }

        @Override
        public void close() {
            this.media = null;
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean canInput() {
            return true;
        }

        @Override
        public boolean canOutput() {
            return true;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long skip(long l) {
            long l2;
            if (l >= 0L) {
                int n = this.media.length - this.pos;
                l2 = Math.min(n, (int)l);
            } else {
                int n = (int)l * -1;
                l2 = -1 * Math.min(this.pos, n);
            }
            this.pos = (int)((long)this.pos + l2);
            return l2;
        }

        @Override
        public void mark(int n) {
            this.posMark = this.pos;
        }

        @Override
        public void reset() throws IllegalStateException {
            if (0 > this.posMark) {
                throw new IllegalStateException("markpos not set");
            }
            if (DEBUG) {
                System.err.println("rewind: " + this.pos + " -> " + this.posMark);
            }
            this.pos = this.posMark;
        }

        @Override
        public int read() {
            int n = this.media.length > this.pos ? 0xFF & this.media[this.pos++] : -1;
            if (DEBUG) {
                if (-1 != n) {
                    System.err.println("u8[" + (this.pos - 1) + "] -> " + Bitstream.toHexBinString(n, 8));
                } else {
                    System.err.println("u8[" + (this.pos - 0) + "] -> EOS");
                }
            }
            return n;
        }

        @Override
        public int write(byte by) {
            int n;
            if (this.media.length > this.pos) {
                this.media[this.pos++] = by;
                n = 0xFF & by;
            } else {
                n = -1;
            }
            if (DEBUG) {
                if (-1 != n) {
                    System.err.println("u8[" + (this.pos - 1) + "] <- " + Bitstream.toHexBinString(n, 8));
                } else {
                    System.err.println("u8[" + (this.pos - 0) + "] <- EOS");
                }
            }
            return n;
        }
    }

    public static interface ByteStream<T> {
        public void setStream(T var1);

        public T getStream();

        public void close() throws IOException;

        public void flush() throws IOException;

        public boolean canInput();

        public boolean canOutput();

        public long position();

        public long skip(long var1) throws IOException;

        public void mark(int var1) throws UnsupportedOperationException;

        public void reset() throws UnsupportedOperationException, IllegalStateException, IOException;

        public int read() throws UnsupportedOperationException, IOException;

        public int write(byte var1) throws UnsupportedOperationException, IOException;
    }
}

