/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.SecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jogamp.common.Debug;

public class JarUtil {
    private static final boolean DEBUG = Debug.debug("JarUtil");
    private static final int BUFFER_SIZE = 4096;
    private static Resolver resolver;

    public static void setResolver(Resolver resolver) throws IllegalArgumentException, IllegalStateException, SecurityException {
        if (resolver == null) {
            throw new IllegalArgumentException("Null Resolver passed");
        }
        if (JarUtil.resolver != null) {
            throw new IllegalStateException("Resolver already set!");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        JarUtil.resolver = resolver;
    }

    public static boolean hasJarURI(String string, ClassLoader classLoader) {
        try {
            return null != JarUtil.getJarURI(string, classLoader);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static URI getJarURI(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        URI uRI;
        if (null == string || null == classLoader) {
            throw new IllegalArgumentException("null arguments: clazzBinName " + string + ", cl " + classLoader);
        }
        URL uRL = IOUtil.getClassURL(string, classLoader);
        String string2 = uRL.getProtocol();
        if (!(null == resolver || string2.equals("jar") || string2.equals("file") || string2.equals("http") || string2.equals("https"))) {
            URL uRL2 = resolver.resolve(uRL);
            uRI = uRL2.toURI();
            if (DEBUG) {
                System.err.println("getJarURI Resolver: " + uRL + "\n\t-> " + uRL2 + "\n\t-> " + uRI);
            }
        } else {
            uRI = uRL.toURI();
            if (DEBUG) {
                System.err.println("getJarURI Default " + uRL + "\n\t-> " + uRI);
            }
        }
        if (!uRI.getScheme().equals("jar")) {
            throw new IllegalArgumentException("URI is not using scheme jar: <" + uRI + ">");
        }
        if (DEBUG) {
            System.err.println("getJarURI res: " + string + " -> " + uRL + " -> " + uRI);
        }
        return uRI;
    }

    public static String getJarBasename(URI uRI) throws IllegalArgumentException {
        if (null == uRI) {
            throw new IllegalArgumentException("URI is null");
        }
        if (!uRI.getScheme().equals("jar")) {
            throw new IllegalArgumentException("URI is not using scheme jar: <" + uRI + ">");
        }
        String string = uRI.getSchemeSpecificPart();
        int n = string.lastIndexOf(33);
        if (0 > n) {
            throw new IllegalArgumentException("URI does not contain jar uri terminator '!', in <" + uRI + ">");
        }
        string = string.substring(0, n);
        n = string.lastIndexOf(47);
        if (0 > n && 0 > (n = string.lastIndexOf(58))) {
            throw new IllegalArgumentException("URI does not contain protocol terminator ':', in <" + uRI + ">");
        }
        if (0 >= (string = string.substring(n + 1)).lastIndexOf(".jar")) {
            throw new IllegalArgumentException("No Jar name in <" + uRI + ">");
        }
        if (DEBUG) {
            System.err.println("getJarName res: " + string);
        }
        return string;
    }

    public static String getJarBasename(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        return JarUtil.getJarBasename(JarUtil.getJarURI(string, classLoader));
    }

    public static URI getJarSubURI(URI uRI) throws IllegalArgumentException, URISyntaxException {
        if (null == uRI) {
            throw new IllegalArgumentException("URI is null");
        }
        if (!uRI.getScheme().equals("jar")) {
            throw new IllegalArgumentException("URI is not a using scheme jar: <" + uRI + ">");
        }
        String string = uRI.getRawSchemeSpecificPart();
        int n = string.lastIndexOf(33);
        if (0 > n) {
            throw new IllegalArgumentException("JAR URI does not contain jar uri terminator '!', uri <" + uRI + ">");
        }
        String string2 = string.substring(0, n);
        if (0 >= string2.lastIndexOf(".jar")) {
            throw new IllegalArgumentException("No Jar name in <" + uRI + ">");
        }
        if (DEBUG) {
            System.err.println("getJarSubURI res: " + uRI + " -> " + string + " -> " + string2);
        }
        return new URI(string2);
    }

    public static String getJarEntry(URI uRI) {
        if (null == uRI) {
            throw new IllegalArgumentException("URI is null");
        }
        if (!uRI.getScheme().equals("jar")) {
            throw new IllegalArgumentException("URI is not a using scheme jar: <" + uRI + ">");
        }
        String string = uRI.getSchemeSpecificPart();
        int n = string.lastIndexOf(33);
        if (0 <= n) {
            String string2 = string.substring(n + 1);
            if (DEBUG) {
                System.err.println("getJarEntry res: " + uRI + " -> " + string + " -> " + n + " -> " + string2);
            }
            return string2;
        }
        throw new IllegalArgumentException("JAR URI does not contain jar uri terminator '!', uri <" + uRI + ">");
    }

    public static URI getJarSubURI(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        return JarUtil.getJarSubURI(JarUtil.getJarURI(string, classLoader));
    }

    public static URI getJarFileURI(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        if (null == string || null == classLoader) {
            throw new IllegalArgumentException("null arguments: clazzBinName " + string + ", cl " + classLoader);
        }
        URI uRI = new URI("jar:" + JarUtil.getJarSubURI(string, classLoader).toString() + "!/");
        if (DEBUG) {
            System.err.println("getJarFileURI res: " + uRI);
        }
        return uRI;
    }

    public static URI getJarFileURI(URI uRI, String string) throws IllegalArgumentException, URISyntaxException {
        if (null == uRI || null == string) {
            throw new IllegalArgumentException("null arguments: baseURI " + uRI + ", jarFileName " + string);
        }
        return new URI("jar:" + uRI.toString() + string + "!/");
    }

    public static URI getJarFileURI(URI uRI) throws IllegalArgumentException, URISyntaxException {
        if (null == uRI) {
            throw new IllegalArgumentException("jarSubURI is null");
        }
        return new URI("jar:" + uRI.toString() + "!/");
    }

    public static URI getJarFileURI(String string) throws IllegalArgumentException, URISyntaxException {
        if (null == string) {
            throw new IllegalArgumentException("jarSubURIS is null");
        }
        return new URI("jar:" + string + "!/");
    }

    public static URI getJarEntryURI(URI uRI, String string) throws IllegalArgumentException, URISyntaxException {
        if (null == string) {
            throw new IllegalArgumentException("jarEntry is null");
        }
        return new URI(uRI.toString() + string);
    }

    public static JarFile getJarFile(String string, ClassLoader classLoader) throws IOException, IllegalArgumentException, URISyntaxException {
        return JarUtil.getJarFile(JarUtil.getJarFileURI(string, classLoader));
    }

    public static JarFile getJarFile(URI uRI) throws IOException, IllegalArgumentException, URISyntaxException {
        URLConnection uRLConnection;
        if (null == uRI) {
            throw new IllegalArgumentException("null jarFileURI");
        }
        if (DEBUG) {
            System.err.println("getJarFile.0: " + uRI.toString());
        }
        URL uRL = uRI.toURL();
        if (DEBUG) {
            System.err.println("getJarFile.1: " + uRL.toString());
        }
        if ((uRLConnection = uRL.openConnection()) instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            if (DEBUG) {
                System.err.println("getJarFile res: " + jarFile.getName());
            }
            return jarFile;
        }
        if (DEBUG) {
            System.err.println("getJarFile res: NULL");
        }
        return null;
    }

    public static URI getRelativeOf(Class<?> clazz, String string, String string2) throws IllegalArgumentException, IOException, URISyntaxException {
        URI uRI;
        ClassLoader classLoader = clazz.getClassLoader();
        URI uRI2 = JarUtil.getJarURI(clazz.getName(), classLoader);
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: (classFromJavaJar " + clazz + ", classJarURI " + uRI2 + ", cutOffInclSubDir " + string + ", relResPath " + string2 + "): ");
        }
        if (null == (uRI = JarUtil.getJarSubURI(uRI2))) {
            throw new IllegalArgumentException("JarSubURI is null of: " + uRI2);
        }
        String string3 = IOUtil.getURIDirname(uRI.toString());
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: uri " + uRI.toString() + " -> " + string3);
        }
        String string4 = string3.endsWith(string) ? string3 + string2 : string3 + string + string2;
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: ...  -> " + string4);
        }
        URI uRI3 = JarUtil.getJarFileURI(string4);
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: fin " + uRI3);
        }
        return uRI3;
    }

    public static Map<String, String> getNativeLibNames(JarFile jarFile) {
        if (DEBUG) {
            System.err.println("JarUtil: getNativeLibNames: " + jarFile);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            String string2 = NativeLibrary.isValidNativeLibraryName(string, false);
            if (null == string2) continue;
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int extract(File file, Map<String, String> map, JarFile jarFile, String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (DEBUG) {
            System.err.println("JarUtil: extract: " + jarFile.getName() + " -> " + file + ", extractNativeLibraries " + bl + " (" + string + ")" + ", extractClassFiles " + bl2 + ", extractOtherFiles " + bl3);
        }
        int n = 0;
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            boolean bl4;
            boolean bl5;
            boolean bl6;
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName();
            String string3 = NativeLibrary.isValidNativeLibraryName(string2, false);
            boolean bl7 = bl6 = null != string3;
            if (bl6) {
                if (!bl) {
                    if (!DEBUG) continue;
                    System.err.println("JarUtil: JarEntry : " + string2 + " native-lib skipped, skip all native libs");
                    continue;
                }
                if (null != string) {
                    String string4;
                    String string5;
                    try {
                        string5 = IOUtil.slashify(string, false, true);
                        string4 = IOUtil.getDirname(string2);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new IOException(uRISyntaxException);
                    }
                    if (!string5.equals(string4)) {
                        if (!DEBUG) continue;
                        System.err.println("JarUtil: JarEntry : " + string2 + " native-lib skipped, not in path: " + string5);
                        continue;
                    }
                }
            }
            if ((bl5 = string2.endsWith(".class")) && !bl2) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string2 + " class-file skipped");
                continue;
            }
            if (!(bl6 || bl5 || bl3)) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string2 + " other-file skipped");
                continue;
            }
            boolean bl8 = string2.endsWith("/");
            boolean bl9 = bl4 = string2.indexOf(47) == -1 && string2.indexOf(File.separatorChar) == -1;
            if (DEBUG) {
                System.err.println("JarUtil: JarEntry : isNativeLib " + bl6 + ", isClassFile " + bl5 + ", isDir " + bl8 + ", isRootEntry " + bl4);
            }
            File file2 = new File(file, string2);
            if (bl8) {
                if (DEBUG) {
                    System.err.println("JarUtil: MKDIR: " + string2 + " -> " + file2);
                }
                file2.mkdirs();
                continue;
            }
            File file3 = new File(file2.getParent());
            if (!file3.exists()) {
                if (DEBUG) {
                    System.err.println("JarUtil: MKDIR (parent): " + string2 + " -> " + file3);
                }
                file3.mkdirs();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            int n2 = -1;
            try {
                n2 = IOUtil.copyStream2Stream(4096, bufferedInputStream, bufferedOutputStream, -1);
            }
            finally {
                ((InputStream)bufferedInputStream).close();
                ((OutputStream)bufferedOutputStream).close();
            }
            boolean bl10 = false;
            if (n2 > 0) {
                ++n;
                if (bl6 && (bl4 || !map.containsKey(string3))) {
                    map.put(string3, file2.getAbsolutePath());
                    bl10 = true;
                    JarUtil.fixNativeLibAttribs(file2);
                }
            }
            if (!DEBUG) continue;
            System.err.println("JarUtil: EXTRACT[" + n + "]: [" + string3 + " -> ] " + string2 + " -> " + file2 + ": " + n2 + " bytes, addedAsNativeLib: " + bl10);
        }
        return n;
    }

    private static final void fixNativeLibAttribs(File file) {
        block4: {
            if (Platform.OSType.MACOS == Platform.getOSType()) {
                String string = file.getAbsolutePath();
                try {
                    JarUtil.fixNativeLibAttribs(string);
                    if (DEBUG) {
                        System.err.println("JarUtil.fixNativeLibAttribs: " + string + " - OK");
                    }
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block4;
                    System.err.println("JarUtil.fixNativeLibAttribs: " + string + " - " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
                }
            }
        }
    }

    private static native boolean fixNativeLibAttribs(String var0);

    public static final void validateCertificates(Certificate[] certificateArray, JarFile jarFile) throws IOException, SecurityException {
        if (DEBUG) {
            System.err.println("JarUtil: validateCertificates: " + jarFile.getName());
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Null certificates passed");
        }
        byte[] byArray = new byte[1024];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory() || jarEntry.getName().startsWith("META-INF/")) continue;
            JarUtil.validateCertificate(certificateArray, jarFile, jarEntry, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void validateCertificate(Certificate[] certificateArray, JarFile jarFile, JarEntry jarEntry, byte[] byArray) throws IOException, SecurityException {
        if (DEBUG) {
            System.err.println("JarUtil: validate JarEntry : " + jarEntry.getName());
        }
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        try {
            while (inputStream.read(byArray) > 0) {
            }
        }
        finally {
            inputStream.close();
        }
        Certificate[] certificateArray2 = jarEntry.getCertificates();
        if (certificateArray2 == null || certificateArray2.length == 0) {
            throw new SecurityException("no certificate for " + jarEntry.getName() + " in " + jarFile.getName());
        }
        if (!SecurityUtil.equals(certificateArray, certificateArray2)) {
            throw new SecurityException("certificates not equal for " + jarEntry.getName() + " in " + jarFile.getName());
        }
    }

    public static interface Resolver {
        public URL resolve(URL var1);
    }
}

