/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import jogamp.common.Debug;
import jogamp.common.os.MachineDescriptionRuntime;
import jogamp.common.os.elf.ElfHeader;
import jogamp.common.os.elf.SectionArmAttributes;
import jogamp.common.os.elf.SectionHeader;

public abstract class PlatformPropsImpl {
    static final boolean DEBUG;
    public static final VersionNumber Version16;
    public static final VersionNumber Version17;
    public static final String OS;
    public static final String OS_lower;
    public static final String OS_VERSION;
    public static final VersionNumber OS_VERSION_NUMBER;
    public static final String ARCH;
    public static final String ARCH_lower;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VENDOR_URL;
    public static final String JAVA_VERSION;
    public static final VersionNumber JAVA_VERSION_NUMBER;
    public static final int JAVA_VERSION_UPDATE;
    public static final String JAVA_VM_NAME;
    public static final String JAVA_RUNTIME_NAME;
    public static final boolean JAVA_SE;
    public static final boolean JAVA_6;
    public static final String NEWLINE;
    public static final boolean LITTLE_ENDIAN;
    static final Platform.CPUType sCpuType;
    public static final Platform.CPUType CPU_ARCH;
    public static final Platform.ABIType ABI_TYPE;
    public static final Platform.OSType OS_TYPE;
    public static final String os_and_arch;

    protected PlatformPropsImpl() {
    }

    private static final String getJavaRuntimeNameImpl() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.runtime.name");
            }
        });
    }

    private static final boolean initIsJavaSE() {
        if (null != JAVA_RUNTIME_NAME && JAVA_RUNTIME_NAME.indexOf("Java SE") != -1) {
            return true;
        }
        try {
            Class.forName("java.nio.LongBuffer");
            Class.forName("java.nio.DoubleBuffer");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static final boolean queryIsLittleEndianImpl() {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        intBuffer.put(0, 168496141);
        return 3085 == shortBuffer.get(0);
    }

    private static final Platform.CPUType getCPUTypeImpl(String string) {
        if (string.equals("x86") || string.equals("i386") || string.equals("i486") || string.equals("i586") || string.equals("i686")) {
            return Platform.CPUType.X86_32;
        }
        if (string.equals("x86_64") || string.equals("amd64")) {
            return Platform.CPUType.X86_64;
        }
        if (string.equals("ia64")) {
            return Platform.CPUType.IA64;
        }
        if (string.equals("arm")) {
            return Platform.CPUType.ARM;
        }
        if (string.equals("armv5l")) {
            return Platform.CPUType.ARMv5;
        }
        if (string.equals("armv6l")) {
            return Platform.CPUType.ARMv6;
        }
        if (string.equals("armv7l") || string.equals("armeabi") || string.equals("armeabi-v7a")) {
            return Platform.CPUType.ARMv7;
        }
        if (string.equals("sparc")) {
            return Platform.CPUType.SPARC_32;
        }
        if (string.equals("sparcv9")) {
            return Platform.CPUType.SPARCV9_64;
        }
        if (string.equals("pa_risc2.0")) {
            return Platform.CPUType.PA_RISC2_0;
        }
        if (string.equals("ppc")) {
            return Platform.CPUType.PPC;
        }
        if (string.equals("mips")) {
            return Platform.CPUType.MIPS_32;
        }
        throw new RuntimeException("Please port CPU detection to your platform (" + OS_lower + "/" + string + ")");
    }

    private static final boolean contains(String string, String[] stringArray) {
        if (null != string && null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static final ElfHeader queryABITypeImpl(final Platform.OSType oSType, final Platform.CPUType[] cPUTypeArray, final Platform.ABIType[] aBITypeArray) {
        return AccessController.doPrivileged(new PrivilegedAction<ElfHeader>(){

            @Override
            public ElfHeader run() {
                ElfHeader elfHeader;
                block8: {
                    elfHeader = null;
                    try {
                        File file = null;
                        if (Platform.OSType.ANDROID == oSType) {
                            file = new File(NativeLibrary.findLibrary("gluegen-rt", PlatformPropsImpl.class.getClassLoader()));
                        } else {
                            if (Platform.OSType.LINUX == oSType && !PlatformPropsImpl.checkFileReadAccess(file = new File("/proc/self/exe"))) {
                                file = null;
                            }
                            if (null == file) {
                                file = PlatformPropsImpl.findSysLib("java");
                            }
                            if (null == file) {
                                file = PlatformPropsImpl.findSysLib("jvm");
                            }
                        }
                        if (null != file) {
                            elfHeader = PlatformPropsImpl.queryABITypeImpl(file, cPUTypeArray, aBITypeArray);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG) break block8;
                        throwable.printStackTrace();
                    }
                }
                return elfHeader;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ElfHeader queryABITypeImpl(File file, Platform.CPUType[] cPUTypeArray, Platform.ABIType[] aBITypeArray) {
        ElfHeader elfHeader = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            ElfHeader elfHeader2 = ElfHeader.read(randomAccessFile);
            if (DEBUG) {
                System.err.println("ELF: Got HDR " + file + ": " + elfHeader2);
            }
            if (elfHeader2.isArm()) {
                boolean bl = false;
                SectionHeader sectionHeader = elfHeader2.getSectionHeader(0x70000003);
                if (null != sectionHeader) {
                    SectionArmAttributes.Attribute attribute;
                    if (DEBUG) {
                        System.err.println("ELF: Got ARM Attribs Section Header: " + sectionHeader);
                    }
                    SectionArmAttributes sectionArmAttributes = (SectionArmAttributes)sectionHeader.readSection(randomAccessFile);
                    if (DEBUG) {
                        System.err.println("ELF: Got ARM Attribs Section Block : " + sectionArmAttributes);
                    }
                    if (null != (attribute = sectionArmAttributes.get(SectionArmAttributes.Tag.ABI_VFP_args))) {
                        bl = SectionArmAttributes.abiVFPArgsAcceptsVFPVariant(attribute.getULEB128());
                    }
                }
                cPUTypeArray[0] = Platform.CPUType.ARM;
                Platform.ABIType aBIType = aBITypeArray[0] = bl ? Platform.ABIType.EABI_GNU_ARMHF : Platform.ABIType.EABI_GNU_ARMEL;
                if (DEBUG) {
                    System.err.println("ELF: abiARM, abiVFPArgsAcceptsVFPVariant " + bl);
                }
            } else if (elfHeader2.isX86_64()) {
                cPUTypeArray[0] = Platform.CPUType.X86_64;
                aBITypeArray[0] = Platform.ABIType.GENERIC_ABI;
            } else if (elfHeader2.isX86_32()) {
                cPUTypeArray[0] = Platform.CPUType.X86_32;
                aBITypeArray[0] = Platform.ABIType.GENERIC_ABI;
            } else if (elfHeader2.isIA64()) {
                cPUTypeArray[0] = Platform.CPUType.IA64;
                aBITypeArray[0] = Platform.ABIType.GENERIC_ABI;
            } else if (elfHeader2.isMips()) {
                cPUTypeArray[0] = Platform.CPUType.MIPS_32;
                aBITypeArray[0] = Platform.ABIType.GENERIC_ABI;
            }
            elfHeader = elfHeader2;
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                System.err.println("Caught: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        finally {
            if (null != randomAccessFile) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (DEBUG) {
            System.err.println("ELF: res " + elfHeader + ", cpuType " + (Object)((Object)cPUTypeArray[0]) + ", abiType " + (Object)((Object)aBITypeArray[0]));
        }
        return elfHeader;
    }

    private static boolean checkFileReadAccess(File file) {
        try {
            return file.isFile() && file.canRead();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static File findSysLib(String string) {
        ClassLoader classLoader = PlatformPropsImpl.class.getClassLoader();
        List<String> list = NativeLibrary.enumerateLibraryPaths(string, string, string, true, classLoader);
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            File file = new File(string2);
            if (DEBUG) {
                System.err.println("findSysLib #" + i + ": test " + file);
            }
            if (PlatformPropsImpl.checkFileReadAccess(file)) {
                return file;
            }
            if (!DEBUG) continue;
            System.err.println("findSysLib #" + i + ": " + file + " not readable");
        }
        return null;
    }

    private static final Platform.OSType getOSTypeImpl(String string, boolean bl) throws RuntimeException {
        if (bl) {
            return Platform.OSType.ANDROID;
        }
        if (string.startsWith("linux")) {
            return Platform.OSType.LINUX;
        }
        if (string.startsWith("freebsd")) {
            return Platform.OSType.FREEBSD;
        }
        if (string.startsWith("android")) {
            return Platform.OSType.ANDROID;
        }
        if (string.startsWith("mac os x") || string.startsWith("darwin")) {
            return Platform.OSType.MACOS;
        }
        if (string.startsWith("sunos")) {
            return Platform.OSType.SUNOS;
        }
        if (string.startsWith("hp-ux")) {
            return Platform.OSType.HPUX;
        }
        if (string.startsWith("windows")) {
            return Platform.OSType.WINDOWS;
        }
        if (string.startsWith("kd")) {
            return Platform.OSType.OPENKODE;
        }
        throw new RuntimeException("Please port OS detection to your platform (" + OS_lower + "/" + ARCH_lower + ")");
    }

    public static void initSingleton() {
    }

    public static final String getOSAndArch(Platform.OSType oSType, Platform.CPUType cPUType, Platform.ABIType aBIType) {
        String string;
        String string2;
        String string3;
        switch (cPUType) {
            case X86_32: {
                string3 = "i586";
                break;
            }
            case ARM: 
            case ARMv5: 
            case ARMv6: 
            case ARMv7: {
                if (Platform.ABIType.EABI_GNU_ARMHF == aBIType) {
                    string3 = "armv6hf";
                    break;
                }
                string3 = "armv6";
                break;
            }
            case SPARC_32: {
                string3 = "sparc";
                break;
            }
            case PPC: {
                string3 = "ppc";
                break;
            }
            case X86_64: {
                string3 = "amd64";
                break;
            }
            case IA64: {
                string3 = "ia64";
                break;
            }
            case SPARCV9_64: {
                string3 = "sparcv9";
                break;
            }
            case PA_RISC2_0: {
                string3 = "risc2.0";
                break;
            }
            default: {
                throw new InternalError("Complete case block");
            }
        }
        switch (oSType) {
            case ANDROID: {
                string2 = "android";
                string = string3;
                break;
            }
            case MACOS: {
                string2 = "macosx";
                string = "universal";
                break;
            }
            case WINDOWS: {
                string2 = "windows";
                string = string3;
                break;
            }
            case OPENKODE: {
                string2 = "openkode";
                string = string3;
                break;
            }
            case LINUX: {
                string2 = "linux";
                string = string3;
                break;
            }
            case FREEBSD: {
                string2 = "freebsd";
                string = string3;
                break;
            }
            case SUNOS: {
                string2 = "solaris";
                string = string3;
                break;
            }
            case HPUX: {
                string2 = "hpux";
                string = "hppa";
                break;
            }
            default: {
                throw new InternalError("Complete case block");
            }
        }
        return string2 + "-" + string;
    }

    static {
        boolean bl;
        Platform.ABIType[] aBITypeArray;
        Platform.CPUType[] cPUTypeArray;
        ElfHeader elfHeader;
        Object object;
        Object object2;
        int n;
        DEBUG = Debug.debug("Platform");
        Version16 = new VersionNumber(1, 6, 0);
        Version17 = new VersionNumber(1, 7, 0);
        boolean bl2 = AndroidVersion.isAvailable;
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_VENDOR_URL = System.getProperty("java.vendor.url");
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_VERSION_NUMBER = new VersionNumber(JAVA_VERSION);
        int n2 = JAVA_VERSION.lastIndexOf("-u");
        if (0 < n2) {
            n = 2;
        } else {
            n2 = JAVA_VERSION.lastIndexOf("_");
            n = 1;
        }
        if (0 < n2) {
            object2 = JAVA_VERSION.substring(n2 + n);
            object = new VersionNumber((String)object2);
            JAVA_VERSION_UPDATE = object.getMajor();
        } else {
            JAVA_VERSION_UPDATE = 0;
        }
        JAVA_VM_NAME = System.getProperty("java.vm.name");
        JAVA_RUNTIME_NAME = PlatformPropsImpl.getJavaRuntimeNameImpl();
        JAVA_SE = PlatformPropsImpl.initIsJavaSE();
        JAVA_6 = JAVA_SE && (bl2 || JAVA_VERSION_NUMBER.compareTo(Version16) >= 0);
        NEWLINE = System.getProperty("line.separator");
        OS = System.getProperty("os.name");
        OS_lower = OS.toLowerCase();
        OS_VERSION = System.getProperty("os.version");
        OS_VERSION_NUMBER = new VersionNumber(OS_VERSION);
        OS_TYPE = PlatformPropsImpl.getOSTypeImpl(OS_lower, bl2);
        LITTLE_ENDIAN = PlatformPropsImpl.queryIsLittleEndianImpl();
        String string = System.getProperty("os.arch");
        String string2 = string.toLowerCase();
        sCpuType = PlatformPropsImpl.getCPUTypeImpl(string2);
        if (DEBUG) {
            System.err.println("Platform.Soft: str " + string + ", cpuType " + (Object)((Object)sCpuType));
        }
        if (null != (elfHeader = PlatformPropsImpl.queryABITypeImpl(OS_TYPE, cPUTypeArray = new Platform.CPUType[]{null}, aBITypeArray = new Platform.ABIType[]{null})) && null != cPUTypeArray[0] && null != aBITypeArray[0]) {
            object2 = cPUTypeArray[0];
            object = aBITypeArray[0];
            if (bl2) {
                Platform.CPUFamily cPUFamily;
                if (DEBUG) {
                    System.err.println("Android: CPU_ABI1 str " + AndroidVersion.CPU_ABI + ", cpu " + (Object)((Object)AndroidVersion.CPU_TYPE) + ", abi " + (Object)((Object)AndroidVersion.ABI_TYPE));
                    System.err.println("Android: CPU_ABI2 str " + AndroidVersion.CPU_ABI2 + ", cpu " + (Object)((Object)AndroidVersion.CPU_TYPE2) + ", abi " + (Object)((Object)AndroidVersion.ABI_TYPE2));
                }
                Platform.CPUFamily cPUFamily2 = null != AndroidVersion.CPU_TYPE ? AndroidVersion.CPU_TYPE.family : null;
                Platform.CPUFamily cPUFamily3 = cPUFamily = null != AndroidVersion.CPU_TYPE2 ? AndroidVersion.CPU_TYPE2.family : null;
                bl = ((Platform.CPUType)((Object)object2)).family == cPUFamily2 || ((Platform.CPUType)((Object)object2)).family == cPUFamily;
            } else {
                bl = ((Platform.CPUType)((Object)object2)).family == PlatformPropsImpl.sCpuType.family;
            }
            if (DEBUG) {
                System.err.println("Platform.Elf: cpuType " + object2 + ", abiType " + object + ", valid " + bl);
            }
        } else {
            object2 = null;
            object = null;
            bl = false;
            if (DEBUG) {
                System.err.println("Platform.Elf: n/a");
            }
        }
        if (bl2) {
            if (bl) {
                if (((Platform.CPUType)((Object)object2)).family == AndroidVersion.CPU_TYPE.family) {
                    ARCH = AndroidVersion.CPU_ABI;
                    CPU_ARCH = AndroidVersion.CPU_TYPE;
                } else {
                    ARCH = AndroidVersion.CPU_ABI2;
                    CPU_ARCH = AndroidVersion.CPU_TYPE2;
                }
                ABI_TYPE = object;
            } else if (AndroidVersion.CPU_TYPE.family == Platform.CPUFamily.ARM || null == AndroidVersion.CPU_TYPE2) {
                ARCH = AndroidVersion.CPU_ABI;
                CPU_ARCH = AndroidVersion.CPU_TYPE;
                ABI_TYPE = AndroidVersion.ABI_TYPE;
            } else {
                ARCH = AndroidVersion.CPU_ABI2;
                CPU_ARCH = AndroidVersion.CPU_TYPE2;
                ABI_TYPE = AndroidVersion.ABI_TYPE2;
            }
            ARCH_lower = ARCH;
        } else {
            ARCH = string;
            ARCH_lower = string2;
            if (bl && Platform.CPUFamily.ARM == ((Platform.CPUType)((Object)object2)).family) {
                CPU_ARCH = object2;
                ABI_TYPE = object;
            } else {
                CPU_ARCH = sCpuType;
                ABI_TYPE = Platform.ABIType.GENERIC_ABI;
            }
        }
        MachineDescriptionRuntime.notifyPropsInitialized();
        os_and_arch = PlatformPropsImpl.getOSAndArch(OS_TYPE, CPU_ARCH, ABI_TYPE);
    }

    public static class OSXVersion {
        public static final VersionNumber Tiger = new VersionNumber(10, 4, 0);
        public static final VersionNumber Lion = new VersionNumber(10, 7, 0);
        public static final VersionNumber Mavericks = new VersionNumber(10, 9, 0);
    }
}

