/* Generated by bsincgen, do not edit! */
#pragma once

static_assert(BSINC_SCALE_COUNT == 16, "Unexpected BSINC_SCALE_COUNT value!");
static_assert(BSINC_PHASE_COUNT == 32, "Unexpected BSINC_PHASE_COUNT value!");

namespace {

struct BSincTable {
    const float scaleBase, scaleRange;
    const unsigned int m[BSINC_SCALE_COUNT];
    const unsigned int filterOffset[BSINC_SCALE_COUNT];
    const float *Tab;
};

/* This 23rd order filter has a rejection of -60dB, yielding a transition width
 * of ~0.158 (normalized frequency). Order increases when downsampling to a
 * limit of one octave, after which the quality of the filter (transition
 * width) suffers to reduce the CPU cost. The bandlimiting will cut all sound
 * after downsampling by ~3.67 octaves.
 */
alignas(16) constexpr float bsinc24_tab[81920] = {
    /*  0, 0 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.796439624e-04f, -7.229492121e-04f, -9.648886183e-04f, -1.152303939e-03f, -1.213307251e-03f, -1.059372565e-03f, -5.898051232e-04f, +3.014766656e-04f, +1.717195100e-03f, +3.746628758e-03f, +6.455051836e-03f, +9.873721368e-03f, +1.399149756e-02f, +1.874912662e-02f, +2.403703938e-02f, +2.969723410e-02f, +3.552944303e-02f, +4.130136645e-02f, +4.676233873e-02f, +5.165941558e-02f, +5.575458332e-02f, +5.884162493e-02f, +6.076115668e-02f, +6.141247912e-02f, +6.076115668e-02f, +5.884162493e-02f, +5.575458332e-02f, +5.165941558e-02f, +4.676233873e-02f, +4.130136645e-02f, +3.552944303e-02f, +2.969723410e-02f, +2.403703938e-02f, +1.874912662e-02f, +1.399149756e-02f, +9.873721368e-03f, +6.455051836e-03f, +3.746628758e-03f, +1.717195100e-03f, +3.014766656e-04f, -5.898051232e-04f, -1.059372565e-03f, -1.213307251e-03f, -1.152303939e-03f, -9.648886183e-04f, -7.229492121e-04f, -4.796439624e-04f, -2.694957250e-04f,
    +7.201639933e-06f, +7.808824226e-06f, +7.060810728e-06f, +4.363309672e-06f, -8.494304210e-07f, -9.042191405e-06f, -2.050403146e-05f, -3.527979396e-05f, -5.311682607e-05f, -7.343513463e-05f, -9.532739769e-05f, -1.175924836e-04f, -1.388026701e-04f, -1.574009775e-04f, -1.718213704e-04f, -1.806214921e-04f, -1.826154788e-04f, -1.769935670e-04f, -1.634158161e-04f, -1.420693226e-04f, -1.136816124e-04f, -7.948714106e-05f, -4.114853805e-05f, -6.388853996e-07f, +3.990461040e-05f, +7.834217668e-05f, +1.126932717e-04f, +1.412836031e-04f, +1.628639195e-04f, +1.766901015e-04f, +1.825581262e-04f, +1.807921168e-04f, +1.721884081e-04f, +1.579228174e-04f, +1.394316620e-04f, +1.182791553e-04f, +9.602447380e-05f, +7.410099365e-05f, +5.371811474e-05f, +3.579302665e-05f, +2.091612006e-05f, +9.349966785e-06f, +1.058315911e-06f, -4.241239355e-06f, -7.009111338e-06f, -7.809025104e-06f, -7.235395433e-06f, -5.850110091e-06f,
    /*  0, 1 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.724423225e-04f, -7.151403879e-04f, -9.578278075e-04f, -1.147940629e-03f, -1.214156681e-03f, -1.068414757e-03f, -6.103091546e-04f, +2.661968716e-04f, +1.664078274e-03f, +3.673193623e-03f, +6.359724439e-03f, +9.756128885e-03f, +1.385269489e-02f, +1.859172564e-02f, +2.386521801e-02f, +2.951661261e-02f, +3.534682755e-02f, +4.112437288e-02f, +4.659892291e-02f, +5.151734626e-02f, +5.564090171e-02f, +5.876213779e-02f, +6.072000814e-02f, +6.141184024e-02f, +6.080106129e-02f, +5.891996710e-02f, +5.586727659e-02f, +5.180069918e-02f, +4.692520265e-02f, +4.147805655e-02f, +3.571200116e-02f, +2.987802621e-02f, +2.420922778e-02f, +1.890704943e-02f, +1.413092922e-02f, +9.992000524e-03f, +6.551076310e-03f, +3.820729751e-03f, +1.770913215e-03f, +3.372696922e-04f, -5.688890031e-04f, -1.050022599e-03f, -1.212248935e-03f, -1.156545178e-03f, -9.718977296e-04f, -7.307582372e-04f, -4.868793578e-04f, -2.753458351e-04f,
    +7.167114757e-06f, +7.807302866e-06f, +7.110604110e-06f, +4.482915520e-06f, -6.434694612e-07f, -8.737628506e-06f, -2.009520355e-05f, -3.476957772e-05f, -5.251798750e-05f, -7.277083693e-05f, -9.463070442e-05f, -1.169047926e-04f, -1.381711284e-04f, -1.568750475e-04f, -1.714488231e-04f, -1.804441899e-04f, -1.826653555e-04f, -1.772892198e-04f, -1.639600817e-04f, -1.428481242e-04f, -1.146642473e-04f, -8.062803289e-05f, -4.239033203e-05f, -1.916622938e-06f, +3.865861306e-05f, +7.719319639e-05f, +1.116992702e-04f, +1.404909963e-04f, +1.623044060e-04f, +1.763788209e-04f, +1.824932796e-04f, +1.809560329e-04f, +1.725498952e-04f, +1.584405205e-04f, +1.400580555e-04f, +1.189647611e-04f, +9.672189189e-05f, +7.476838129e-05f, +5.432183054e-05f, +3.630926307e-05f, +2.133146638e-05f, +9.660960103e-06f, +1.270137912e-06f, -4.116688316e-06f, -6.955487723e-06f, -7.807887439e-06f, -7.268365081e-06f, -5.900645350e-06f,
    /*  0, 2 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.652752077e-04f, -7.073330850e-04f, -9.507172034e-04f, -1.143457714e-03f, -1.214800150e-03f, -1.077152385e-03f, -6.304043582e-04f, +2.314272939e-04f, +1.611560287e-03f, +3.600422786e-03f, +6.265093734e-03f, +9.639224092e-03f, +1.371452376e-02f, +1.843485059e-02f, +2.369376918e-02f, +2.933616842e-02f, +3.516416220e-02f, +4.094708366e-02f, +4.643496283e-02f, +5.137449813e-02f, +5.552623746e-02f, +5.868150975e-02f, +6.067761781e-02f, +6.140992362e-02f, +6.083971990e-02f, +5.899716030e-02f, +5.597897586e-02f, +5.194119018e-02f, +4.708750705e-02f, +4.165443537e-02f, +3.589449444e-02f, +3.005898225e-02f, +2.438177768e-02f, +1.906548995e-02f, +1.427098728e-02f, +1.011096528e-02f, +6.647798202e-03f, +3.895498133e-03f, +1.825235046e-03f, +3.735789553e-04f, -5.475575367e-04f, -1.040361638e-03f, -1.210978797e-03f, -1.160661867e-03f, -9.788532173e-04f, -7.385661247e-04f, -4.941477229e-04f, -2.812464804e-04f,
    +7.131836001e-06f, +7.804479049e-06f, +7.158509723e-06f, +4.600073246e-06f, -4.404208828e-07f, -8.436272395e-06f, -1.968963904e-05f, -3.426239038e-05f, -5.192162170e-05f, -7.210813297e-05f, -9.393443463e-05f, -1.162161284e-04f, -1.375370856e-04f, -1.563450745e-04f, -1.710708076e-04f, -1.802602417e-04f, -1.827077745e-04f, -1.775770628e-04f, -1.644967024e-04f, -1.436199778e-04f, -1.156411315e-04f, -8.176479580e-05f, -4.362992850e-05f, -3.194260694e-06f, +3.741061019e-05f, +7.604025715e-05f, +1.106996535e-04f, +1.396915333e-04f, +1.617372905e-04f, +1.760597234e-04f, +1.824209217e-04f, +1.811132097e-04f, +1.729057912e-04f, +1.589540398e-04f, +1.406818019e-04f, +1.196492544e-04f, +9.741961088e-05f, +7.543726457e-05f, +5.492795017e-05f, +3.682849015e-05f, +2.175006713e-05f, +9.975176579e-06f, +1.484908233e-06f, -3.989640402e-06f, -6.899921698e-06f, -7.805393139e-06f, -7.300532620e-06f, -5.950853705e-06f,
    /*  0, 3 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.581433717e-04f, -6.995286060e-04f, -9.435586937e-04f, -1.138857640e-03f, -1.215240571e-03f, -1.085588658e-03f, -6.500939972e-04f, +1.971649035e-04f, +1.559638665e-03f, +3.528314653e-03f, +6.171159300e-03f, +9.523007964e-03f, +1.357698668e-02f, +1.827850552e-02f, +2.352269837e-02f, +2.915590817e-02f, +3.498145442e-02f, +4.076950660e-02f, +4.627046613e-02f, +5.123087815e-02f, +5.541059633e-02f, +5.859974496e-02f, +6.063398788e-02f, +6.140672936e-02f, +6.087713051e-02f, +5.907320056e-02f, +5.608967552e-02f, +5.208088171e-02f, +4.724924434e-02f, +4.183049510e-02f, +3.607691536e-02f, +3.024009546e-02f, +2.455468347e-02f, +1.922444399e-02f, +1.441166908e-02f, +1.023061454e-02f, +6.745217813e-03f, +3.970935397e-03f, +1.880162996e-03f, +4.104074455e-04f, -5.258074696e-04f, -1.030386462e-03f, -1.209493888e-03f, -1.164651507e-03f, -9.857531390e-04f, -7.463715178e-04f, -5.014482555e-04f, -2.871973341e-04f,
    +7.095819678e-06f, +7.800370763e-06f, +7.204545832e-06f, +4.714799292e-06f, -2.402723706e-07f, -8.138117147e-06f, -1.928734033e-05f, -3.375824403e-05f, -5.132775100e-05f, -7.144705488e-05f, -9.323862873e-05f, -1.155265373e-04f, -1.369005902e-04f, -1.558111055e-04f, -1.706873651e-04f, -1.800696793e-04f, -1.827427547e-04f, -1.778570993e-04f, -1.650256649e-04f, -1.443848538e-04f, -1.166122207e-04f, -8.289737375e-05f, -4.486726377e-05f, -4.471732158e-06f, +3.616066610e-05f, +7.488341620e-05f, +1.096944677e-04f, +1.388852458e-04f, +1.611625883e-04f, +1.757328077e-04f, +1.823410354e-04f, +1.812636169e-04f, +1.732560555e-04f, +1.594633288e-04f, +1.413028526e-04f, +1.203325886e-04f, +9.811758948e-05f, +7.610761022e-05f, +5.553645002e-05f, +3.735069452e-05f, +2.217191876e-05f, +1.029262119e-05f, +1.702638511e-06f, -3.860079559e-06f, -6.842395104e-06f, -7.801524077e-06f, -7.331881716e-06f, -6.000721856e-06f,
    /*  0, 4 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.510475520e-04f, -6.917282352e-04f, -9.363541479e-04f, -1.134142841e-03f, -1.215480844e-03f, -1.093726775e-03f, -6.693813375e-04f, +1.634066595e-04f, +1.508310914e-03f, +3.456867598e-03f, +6.077920671e-03f, +9.407481427e-03f, +1.344008609e-02f, +1.812269441e-02f, +2.335201101e-02f, +2.897583849e-02f, +3.479871167e-02f, +4.059164950e-02f, +4.610544046e-02f, +5.108649330e-02f, +5.529398411e-02f, +5.851684758e-02f, +6.058912062e-02f, +6.140225762e-02f, +6.091329118e-02f, +5.914808397e-02f, +5.619936998e-02f, +5.221976696e-02f, +4.741040693e-02f, +4.200622791e-02f, +3.625925639e-02f, +3.042135907e-02f, +2.472793953e-02f, +1.938390732e-02f, +1.455297193e-02f, +1.035094713e-02f, +6.843335402e-03f, +4.047043008e-03f, +1.935699446e-03f, +4.477581400e-04f, -5.036355508e-04f, -1.020093841e-03f, -1.207791250e-03f, -1.168511587e-03f, -9.925955341e-04f, -7.541730419e-04f, -5.087801372e-04f, -2.931980560e-04f,
    +7.059081716e-06f, +7.794995958e-06f, +7.248730722e-06f, +4.827110191e-06f, -4.301144525e-08f, -7.843156605e-06f, -1.888830955e-05f, -3.325715046e-05f, -5.073639743e-05f, -7.078763450e-05f, -9.254332692e-05f, -1.148360655e-04f, -1.362616909e-04f, -1.552731878e-04f, -1.702985375e-04f, -1.798725349e-04f, -1.827703153e-04f, -1.781293332e-04f, -1.655469566e-04f, -1.451427229e-04f, -1.175774709e-04f, -8.402571100e-05f, -4.610227435e-05f, -5.748970827e-06f, +3.490884522e-05f, +7.372273107e-05f, +1.086837592e-04f, +1.380721657e-04f, +1.605803153e-04f, +1.753980729e-04f, +1.822536042e-04f, +1.814072243e-04f, +1.736006478e-04f, +1.599683410e-04f, +1.419211588e-04f, +1.210147169e-04f, +9.881578617e-05f, +7.677938468e-05f, +5.614730615e-05f, +3.787586248e-05f, +2.259701741e-05f, +1.061329869e-05f, +1.923340206e-06f, -3.727989835e-06f, -6.782889817e-06f, -7.796262099e-06f, -7.362395954e-06f, -6.050236397e-06f,
    /*  0, 5 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.439884703e-04f, -6.839332393e-04f, -9.291054171e-04f, -1.129315731e-03f, -1.215523855e-03f, -1.101569931e-03f, -6.882696471e-04f, +1.301495090e-04f, +1.457574517e-03f, +3.386079964e-03f, +5.985377344e-03f, +9.292645361e-03f, +1.330382439e-02f, +1.796742122e-02f, +2.318171247e-02f, +2.879596596e-02f, +3.461594135e-02f, +4.041352017e-02f, +4.593989350e-02f, +5.094135058e-02f, +5.517640664e-02f, +5.843282187e-02f, +6.054301834e-02f, +6.139650865e-02f, +6.094820002e-02f, +5.922180670e-02f, +5.630805374e-02f, +5.235783912e-02f, +4.757098725e-02f, +4.218162598e-02f, +3.644151000e-02f, +3.060276630e-02f, +2.490154017e-02f, +1.954387566e-02f, +1.469489309e-02f, +1.047196184e-02f, +6.942151189e-03f, +4.123822392e-03f, +1.991846752e-03f, +4.856340025e-04f, -4.810385334e-04f, -1.009480542e-03f, -1.205867910e-03f, -1.172239576e-03f, -9.993784239e-04f, -7.619693040e-04f, -5.161425332e-04f, -2.992482924e-04f,
    +7.021637960e-06f, +7.788372543e-06f, +7.291082698e-06f, +4.937022566e-06f, +1.513745344e-07f, -7.551384381e-06f, -1.849254854e-05f, -3.275912115e-05f, -5.014758269e-05f, -7.012990339e-05f, -9.184856916e-05f, -1.141447587e-04f, -1.356204362e-04f, -1.547313687e-04f, -1.699043667e-04f, -1.796688410e-04f, -1.827904761e-04f, -1.783937689e-04f, -1.660605652e-04f, -1.458935566e-04f, -1.185368387e-04f, -8.514975212e-05f, -4.733489691e-05f, -7.025910221e-06f, +3.365521214e-05f, +7.255825958e-05f, +1.076675748e-04f, +1.372523257e-04f, +1.599904879e-04f, +1.750555188e-04f, +1.821586121e-04f, +1.815440025e-04f, +1.739395284e-04f, +1.604690300e-04f, +1.425366721e-04f, +1.216955923e-04f, +9.951415924e-05f, +7.745255413e-05f, +5.676049434e-05f, +3.840398002e-05f, +2.302535893e-05f, +1.093721356e-05f, +2.147024604e-06f, -3.593355386e-06f, -6.721387745e-06f, -7.789589021e-06f, -7.392058845e-06f, -6.099383813e-06f,
    /*  0, 6 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.369668323e-04f, -6.761448667e-04f, -9.218143344e-04f, -1.124378708e-03f, -1.215372481e-03f, -1.109121316e-03f, -7.067621956e-04f, +9.739038789e-05f, +1.407426934e-03f, +3.315950061e-03f, +5.893528775e-03f, +9.178500602e-03f, +1.316820396e-02f, +1.781268985e-02f, +2.301180811e-02f, +2.861629712e-02f, +3.443315088e-02f, +4.023512640e-02f, +4.577383294e-02f, +5.079545702e-02f, +5.505786980e-02f, +5.834767212e-02f, +6.049568345e-02f, +6.138948274e-02f, +6.098185524e-02f, +5.929436496e-02f, +5.641572132e-02f, +5.249509145e-02f, +4.773097773e-02f, +4.235668150e-02f, +3.662366861e-02f, +3.078431030e-02f, +2.507547970e-02f, +1.970434469e-02f, +1.483742976e-02f, +1.059365744e-02f, +7.041665348e-03f, +4.201274946e-03f, +2.048607246e-03f, +5.240379825e-04f, -4.580131745e-04f, -9.985433285e-04f, -1.203720885e-03f, -1.175832932e-03f, -1.006099812e-03f, -7.697588930e-04f, -5.235345920e-04f, -3.053476762e-04f,
    +6.983504168e-06f, +7.780518386e-06f, +7.331620083e-06f, +5.044553124e-06f, +3.428983692e-07f, -7.262793860e-06f, -1.810005886e-05f, -3.226416726e-05f, -4.956132816e-05f, -6.947389279e-05f, -9.115439517e-05f, -1.134526627e-04f, -1.349768747e-04f, -1.541856957e-04f, -1.695048947e-04f, -1.794586306e-04f, -1.828032572e-04f, -1.786504114e-04f, -1.665664791e-04f, -1.466373266e-04f, -1.194902810e-04f, -8.626944199e-05f, -4.856506828e-05f, -8.302483877e-06f, +3.239983159e-05f, +7.139005983e-05f, +1.066459616e-04f, +1.364257588e-04f, +1.593931230e-04f, +1.747051455e-04f, +1.820560435e-04f, +1.816739221e-04f, +1.742726574e-04f, +1.609653496e-04f, +1.431493437e-04f, +1.223751678e-04f, +1.002126668e-04f, +7.812708446e-05f, +5.737599002e-05f, +3.893503281e-05f, +2.345693889e-05f, +1.126437005e-05f, +2.373702808e-06f, -3.456160473e-06f, -6.657870832e-06f, -7.781486633e-06f, -7.420853824e-06f, -6.148150484e-06f,
    /*  0, 7 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.299833282e-04f, -6.683643483e-04f, -9.144827144e-04f, -1.119334155e-03f, -1.215029582e-03f, -1.116384110e-03f, -7.248622545e-04f, +6.512622063e-05f, +1.357865606e-03f, +3.246476168e-03f, +5.802374380e-03f, +9.065047940e-03f, +1.303322708e-02f, +1.765850416e-02f, +2.284230321e-02f, +2.843683849e-02f, +3.425034762e-02f, +4.005647599e-02f, +4.560726646e-02f, +5.064881970e-02f, +5.493837952e-02f, +5.826140268e-02f, +6.044711838e-02f, +6.138118026e-02f, +6.101425507e-02f, +5.936575502e-02f, +5.652236728e-02f, +5.263151721e-02f, +4.789037086e-02f, +4.253138664e-02f, +3.680572465e-02f, +3.096598422e-02f, +2.524975236e-02f, +1.986531004e-02f, +1.498057911e-02f, +1.071603260e-02f, +7.141878015e-03f, +4.279402031e-03f, +2.105983236e-03f, +5.629730153e-04f, -4.345562356e-04f, -9.872789584e-04f, -1.201347182e-03f, -1.179289092e-03f, -1.012757683e-03f, -7.775403796e-04f, -5.309554459e-04f, -3.114958267e-04f,
    +6.944696012e-06f, +7.771451312e-06f, +7.370361214e-06f, +5.149718660e-06f, +5.315730174e-07f, -6.977378204e-06f, -1.771084180e-05f, -3.177229965e-05f, -4.897765493e-05f, -6.881963368e-05f, -9.046084446e-05f, -1.127598233e-04f, -1.343310549e-04f, -1.536362162e-04f, -1.691001640e-04f, -1.792419368e-04f, -1.828086792e-04f, -1.788992659e-04f, -1.670646871e-04f, -1.473740055e-04f, -1.204377551e-04f, -8.738472583e-05f, -4.979272550e-05f, -9.578625365e-06f, +3.114276840e-05f, +7.021819019e-05f, +1.056189673e-04f, +1.355924986e-04f, +1.587882379e-04f, +1.743469537e-04f, +1.819458831e-04f, +1.817969543e-04f, +1.745999956e-04f, +1.614572536e-04f, +1.437591249e-04f, +1.230533962e-04f, +1.009112666e-04f, +7.880294129e-05f, +5.799376832e-05f, +3.946900620e-05f, +2.389175254e-05f, +1.159477218e-05f, +2.603385740e-06f, -3.316389466e-06f, -6.592321062e-06f, -7.771936700e-06f, -7.448764252e-06f, -6.196522682e-06f,
    /*  0, 8 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.230386322e-04f, -6.605928970e-04f, -9.071123531e-04f, -1.114184437e-03f, -1.214498009e-03f, -1.123361488e-03f, -7.425730963e-04f, +3.335392098e-05f, +1.308887951e-03f, +3.177656534e-03f, +5.711913535e-03f, +8.952288116e-03f, +1.289889603e-02f, +1.750486794e-02f, +2.267320305e-02f, +2.825759655e-02f, +3.406753894e-02f, +3.987757672e-02f, +4.544020177e-02f, +5.050144569e-02f, +5.481794176e-02f, +5.817401795e-02f, +6.039732565e-02f, +6.137160163e-02f, +6.104539784e-02f, +5.943597321e-02f, +5.662798625e-02f, +5.276710971e-02f, +4.804915909e-02f, +4.270573360e-02f, +3.698767054e-02f, +3.114778118e-02f, +2.542435236e-02f, +2.002676730e-02f, +1.512433823e-02f, +1.083908600e-02f, +7.242789281e-03f, +4.358204972e-03f, +2.163977005e-03f, +6.024420215e-04f, -4.106644831e-04f, -9.756841862e-04f, -1.198743797e-03f, -1.182605482e-03f, -1.019350004e-03f, -7.853123163e-04f, -5.384042101e-04f, -3.176923494e-04f,
    +6.905229076e-06f, +7.761189099e-06f, +7.407324442e-06f, +5.252536049e-06f, +7.174115923e-07f, -6.695130348e-06f, -1.732489835e-05f, -3.128352883e-05f, -4.839658372e-05f, -6.816715673e-05f, -8.976795629e-05f, -1.120662859e-04f, -1.336830254e-04f, -1.530829779e-04f, -1.686902173e-04f, -1.790187932e-04f, -1.828067631e-04f, -1.791403384e-04f, -1.675551786e-04f, -1.481035659e-04f, -1.213792189e-04f, -8.849554918e-05f, -5.101780578e-05f, -1.085426828e-05f, +2.988408757e-05f, +6.904270931e-05f, +1.045866398e-04f, +1.347525789e-04f, +1.581758507e-04f, +1.739809448e-04f, +1.818281164e-04f, +1.819130706e-04f, +1.749215037e-04f, +1.619446962e-04f, +1.443659673e-04f, +1.237302304e-04f, +1.016099164e-04f, +7.948008996e-05f, +5.861380406e-05f, +4.000588521e-05f, +2.432979486e-05f, +1.192842370e-05f, +2.836084140e-06f, -3.174026850e-06f, -6.524720458e-06f, -7.760920964e-06f, -7.475773419e-06f, -6.244486575e-06f,
    /*  0, 9 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.161334031e-04f, -6.528317079e-04f, -8.997050287e-04f, -1.108931901e-03f, -1.213780598e-03f, -1.130056618e-03f, -7.598979946e-04f, +2.070392152e-06f, +1.260491367e-03f, +3.109489377e-03f, +5.622145579e-03f, +8.840221830e-03f, +1.276521300e-02f, +1.735178496e-02f, +2.250451283e-02f, +2.807857776e-02f, +3.388473218e-02f, +3.969843638e-02f, +4.527264659e-02f, +5.035334212e-02f, +5.469656255e-02f, +5.808552240e-02f, +6.034630785e-02f, +6.136074737e-02f, +6.107528192e-02f, +5.950501592e-02f, +5.673257289e-02f, +5.290186229e-02f, +4.820733494e-02f, +4.287971454e-02f, +3.716949865e-02f, +3.132969425e-02f, +2.559927386e-02f, +2.018871199e-02f, +1.526870420e-02f, +1.096281623e-02f, +7.344399198e-03f, +4.437685062e-03f, +2.222590809e-03f, +6.424479067e-04f, -3.863346882e-04f, -9.637557625e-04f, -1.195907712e-03f, -1.185779509e-03f, -1.025874724e-03f, -7.930732373e-04f, -5.458799835e-04f, -3.239368359e-04f,
    +6.865118852e-06f, +7.749749481e-06f, +7.442528130e-06f, +5.353022246e-06f, +9.004273601e-07f, -6.416043006e-06f, -1.694222924e-05f, -3.079786504e-05f, -4.781813497e-05f, -6.751649231e-05f, -8.907576968e-05f, -1.113720959e-04f, -1.330328344e-04f, -1.525260286e-04f, -1.682750973e-04f, -1.787892338e-04f, -1.827975304e-04f, -1.793736353e-04f, -1.680379435e-04f, -1.488259813e-04f, -1.223146305e-04f, -8.960185788e-05f, -5.224024653e-05f, -1.212934627e-05f, +2.862385418e-05f, +6.786367609e-05f, +1.035490276e-04f, +1.339060344e-04f, +1.575559798e-04f, +1.736071204e-04f, +1.817027291e-04f, +1.820222430e-04f, +1.752371429e-04f, +1.624276316e-04f, +1.449698222e-04f, +1.244056229e-04f, +1.023085737e-04f, +8.015849554e-05f, +5.923607174e-05f, +4.054565455e-05f, +2.477106051e-05f, +1.226532812e-05f, +3.071808559e-06f, -3.029057220e-06f, -6.455051086e-06f, -7.748421147e-06f, -7.501864540e-06f, -6.292028226e-06f,
    /*  0,10 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.092682842e-04f, -6.450819584e-04f, -8.922625006e-04f, -1.103578878e-03f, -1.212880170e-03f, -1.136472661e-03f, -7.768402239e-04f, -2.872747289e-05f, +1.212673232e-03f, +3.041972885e-03f, +5.533069809e-03f, +8.728849735e-03f, +1.263218017e-02f, +1.719925894e-02f, +2.233623773e-02f, +2.789978852e-02f, +3.370193465e-02f, +3.951906275e-02f, +4.510460865e-02f, +5.020451614e-02f, +5.457424791e-02f, +5.799592054e-02f, +6.029406760e-02f, +6.134861802e-02f, +6.110390578e-02f, +5.957287960e-02f, +5.683612192e-02f, +5.303576832e-02f, +4.836489092e-02f, +4.305332166e-02f, +3.735120138e-02f, +3.151171649e-02f, +2.577451100e-02f, +2.035113962e-02f, +1.541367402e-02f, +1.108722185e-02f, +7.446707771e-03f, +4.517843558e-03f, +2.281826881e-03f, +6.829935612e-04f, -3.615636277e-04f, -9.514904344e-04f, -1.192835904e-03f, -1.188808566e-03f, -1.032329775e-03f, -8.008216584e-04f, -5.533818481e-04f, -3.302288642e-04f,
    +6.824380746e-06f, +7.737150143e-06f, +7.475990650e-06f, +5.451194286e-06f, +1.080633738e-06f, -6.140108674e-06f, -1.656283491e-05f, -3.031531818e-05f, -4.724232877e-05f, -6.686767051e-05f, -8.838432342e-05f, -1.106772984e-04f, -1.323805306e-04f, -1.519654159e-04f, -1.678548470e-04f, -1.785532927e-04f, -1.827810030e-04f, -1.795991635e-04f, -1.685129721e-04f, -1.495412255e-04f, -1.232439486e-04f, -9.070359815e-05f, -5.345998535e-05f, -1.340379299e-05f, +2.736213345e-05f, +6.668114971e-05f, +1.025061794e-04f, +1.330529000e-04f, +1.569286442e-04f, +1.732254828e-04f, +1.815697075e-04f, +1.821244437e-04f, +1.755468747e-04f, +1.629060141e-04f, +1.455706410e-04f, +1.250795263e-04f, +1.030071957e-04f, +8.083812284e-05f, +5.986054554e-05f, +4.108829861e-05f, +2.521554387e-05f, +1.260548869e-05f, +3.310569361e-06f, -2.881465290e-06f, -6.383295056e-06f, -7.734418951e-06f, -7.527020764e-06f, -6.339133594e-06f,
    /*  0,11 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -4.024439035e-04f, -6.373448083e-04f, -8.847865099e-04f, -1.098127684e-03f, -1.211799537e-03f, -1.142612770e-03f, -7.934030588e-04f, -5.904279106e-05f, +1.165430903e-03f, +2.975105214e-03f, +5.444685486e-03f, +8.618172436e-03f, +1.249979964e-02f, +1.704729352e-02f, +2.216838289e-02f, +2.772123523e-02f, +3.351915364e-02f, +3.933946359e-02f, +4.493609568e-02f, +5.005497492e-02f, +5.445100397e-02f, +5.790521695e-02f, +6.024060761e-02f, +6.133521423e-02f, +6.113126791e-02f, +5.963956075e-02f, +5.693862809e-02f, +5.316882122e-02f, +4.852181957e-02f, +4.322654714e-02f, +3.753277109e-02f, +3.169384093e-02f, +2.595005788e-02f, +2.051404564e-02f, +1.555924466e-02f, +1.121230138e-02f, +7.549714967e-03f, +4.598681680e-03f, +2.341687426e-03f, +7.240818599e-04f, -3.363480838e-04f, -9.388849457e-04f, -1.189525335e-03f, -1.191690031e-03f, -1.038713070e-03f, -8.085560774e-04f, -5.609088688e-04f, -3.365679977e-04f,
    +6.783030070e-06f, +7.723408718e-06f, +7.507730380e-06f, +5.547069277e-06f, +1.258044290e-06f, -5.867319628e-06f, -1.618671553e-05f, -2.983589784e-05f, -4.666918493e-05f, -6.622072111e-05f, -8.769365605e-05f, -1.099819384e-04f, -1.317261621e-04f, -1.514011878e-04f, -1.674295098e-04f, -1.783110046e-04f, -1.827572033e-04f, -1.798169304e-04f, -1.689802556e-04f, -1.502492729e-04f, -1.241671324e-04f, -9.180071650e-05f, -5.467696004e-05f, -1.467754219e-05f, +2.609899070e-05f, +6.549518960e-05f, +1.014581444e-04f, +1.321932110e-04f, +1.562938633e-04f, +1.728360349e-04f, +1.814290384e-04f, +1.822196454e-04f, +1.758506607e-04f, +1.633797983e-04f, +1.461683752e-04f, +1.257518931e-04f, +1.037057395e-04f, +8.151893637e-05f, +6.048719935e-05f, +4.163380147e-05f, +2.566323901e-05f, +1.294890841e-05f, +3.552376721e-06f, -2.731235893e-06f, -6.309434527e-06f, -7.718896060e-06f, -7.551225169e-06f, -6.385788534e-06f,
    /*  0,12 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.956608734e-04f, -6.296213996e-04f, -8.772787795e-04f, -1.092580615e-03f, -1.210541492e-03f, -1.148480090e-03f, -8.095897743e-04f, -8.887868891e-05f, +1.118761719e-03f, +2.908884493e-03f, +5.356991830e-03f, +8.508190498e-03f, +1.236807348e-02f, +1.689589233e-02f, +2.200095338e-02f, +2.754292423e-02f, +3.333639644e-02f, +3.915964666e-02f, +4.476711542e-02f, +4.990472564e-02f, +5.432683683e-02f, +5.781341623e-02f, +6.018593065e-02f, +6.132053668e-02f, +6.115736690e-02f, +5.970505594e-02f, +5.704008624e-02f, +5.330101443e-02f, +4.867811343e-02f, +4.339938318e-02f, +3.771420013e-02f, +3.187606058e-02f, +2.612590854e-02f, +2.067742544e-02f, +1.570541304e-02f, +1.133805327e-02f, +7.653420706e-03f, +4.680200617e-03f, +2.402174625e-03f, +7.657156613e-04f, -3.106848448e-04f, -9.259360373e-04f, -1.185972958e-03f, -1.194421267e-03f, -1.045022505e-03f, -8.162749735e-04f, -5.684600940e-04f, -3.429537863e-04f,
    +6.741082046e-06f, +7.708542790e-06f, +7.537765705e-06f, +5.640664402e-06f, +1.432672729e-06f, -5.597667930e-06f, -1.581387101e-05f, -2.935961333e-05f, -4.609872289e-05f, -6.557567358e-05f, -8.700380586e-05f, -1.092860609e-04f, -1.310697774e-04f, -1.508333922e-04f, -1.669991291e-04f, -1.780624044e-04f, -1.827261540e-04f, -1.800269439e-04f, -1.694397852e-04f, -1.509500984e-04f, -1.250841413e-04f, -9.289315982e-05f, -5.589110862e-05f, -1.595052764e-05f, +2.483449136e-05f, +6.430585546e-05f, +1.004049721e-04f, +1.313270034e-04f, +1.556516572e-04f, +1.724387800e-04f, +1.812807091e-04f, +1.823078213e-04f, +1.761484629e-04f, +1.638489388e-04f, +1.467629763e-04f, +1.264226756e-04f, +1.044041619e-04f, +8.220090042e-05f, +6.111600674e-05f, +4.218214685e-05f, +2.611413971e-05f, +1.329559004e-05f, +3.797240619e-06f, -2.578353981e-06f, -6.233451705e-06f, -7.701834142e-06f, -7.574460766e-06f, -6.431978801e-06f,
    /*  0,13 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.889197914e-04f, -6.219128568e-04f, -8.697410138e-04f, -1.086939950e-03f, -1.209108819e-03f, -1.154077757e-03f, -8.254036453e-04f, -1.182383022e-04f, +1.072662996e-03f, +2.843308820e-03f, +5.269988024e-03f, +8.398904437e-03f, +1.223700370e-02f, +1.674505894e-02f, +2.183395425e-02f, +2.736486182e-02f, +3.315367029e-02f, +3.897961971e-02f, +4.459767564e-02f, +4.975377555e-02f, +5.420175269e-02f, +5.772052307e-02f, +6.013003955e-02f, +6.130458616e-02f, +6.118220139e-02f, +5.976936179e-02f, +5.714049121e-02f, +5.343234143e-02f, +4.883376509e-02f, +4.357182196e-02f, +3.789548084e-02f, +3.205836840e-02f, +2.630205700e-02f, +2.084127438e-02f, +1.585217601e-02f, +1.146447595e-02f, +7.757824868e-03f, +4.762401517e-03f, +2.463290632e-03f, +8.078978082e-04f, -2.845707051e-04f, -9.126404473e-04f, -1.182175717e-03f, -1.196999621e-03f, -1.051255956e-03f, -8.239768076e-04f, -5.760345548e-04f, -3.493857651e-04f,
    +6.698551799e-06f, +7.692569891e-06f, +7.566115013e-06f, +5.731996914e-06f, +1.604532908e-06f, -5.331145428e-06f, -1.544430097e-05f, -2.888647360e-05f, -4.553096181e-05f, -6.493255712e-05f, -8.631481091e-05f, -1.085897106e-04f, -1.304114247e-04f, -1.502620772e-04f, -1.665637486e-04f, -1.778075273e-04f, -1.826878783e-04f, -1.802292123e-04f, -1.698915531e-04f, -1.516436772e-04f, -1.259949353e-04f, -9.398087530e-05f, -5.710236930e-05f, -1.722268318e-05f, +2.356870096e-05f, +6.311320721e-05f, +9.934671235e-05f, +1.304543135e-04f, +1.550020465e-04f, +1.720337218e-04f, +1.811247071e-04f, +1.823889449e-04f, +1.764402438e-04f, +1.643133904e-04f, +1.473543959e-04f, +1.270918263e-04f, +1.051024197e-04f, +8.288397896e-05f, +6.174694096e-05f, +4.273331820e-05f, +2.656823942e-05f, +1.364553606e-05f, +4.045170841e-06f, -2.422804631e-06f, -6.155328848e-06f, -7.683214852e-06f, -7.596710501e-06f, -6.477690047e-06f,
    /*  0,14 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.822212396e-04f, -6.142202869e-04f, -8.621748988e-04f, -1.081207953e-03f, -1.207504287e-03f, -1.159408903e-03f, -8.408479463e-04f, -1.471247758e-04f, +1.027132034e-03f, +2.778376263e-03f, +5.183673213e-03f, +8.290314726e-03f, +1.210659227e-02f, +1.659479686e-02f, +2.166739050e-02f, +2.718705429e-02f, +3.297098241e-02f, +3.879939050e-02f, +4.442778408e-02f, +4.960213187e-02f, +5.407575776e-02f, +5.762654220e-02f, +6.007293718e-02f, +6.128736347e-02f, +6.120577010e-02f, +5.983247500e-02f, +5.723983792e-02f, +5.356279575e-02f, +4.898876714e-02f, +4.374385568e-02f, +3.807660555e-02f, +3.224075735e-02f, +2.647849724e-02f, +2.100558777e-02f, +1.599953041e-02f, +1.159156778e-02f, +7.862927288e-03f, +4.845285496e-03f, +2.525037573e-03f, +8.506311264e-04f, -2.580024657e-04f, -8.989949112e-04f, -1.178130546e-03f, -1.199422426e-03f, -1.057411285e-03f, -8.316600224e-04f, -5.836312653e-04f, -3.558634551e-04f,
    +6.655454364e-06f, +7.675507496e-06f, +7.592796692e-06f, +5.821084136e-06f, +1.773638826e-06f, -5.067743758e-06f, -1.507800476e-05f, -2.841648733e-05f, -4.496592050e-05f, -6.429140060e-05f, -8.562670900e-05f, -1.078929320e-04f, -1.297511522e-04f, -1.496872908e-04f, -1.661234121e-04f, -1.775464088e-04f, -1.826423998e-04f, -1.804237446e-04f, -1.703355517e-04f, -1.523299854e-04f, -1.268994749e-04f, -9.506381053e-05f, -5.831068052e-05f, -1.849394269e-05f, +2.230168514e-05f, +6.191730505e-05f, +9.828341550e-05f, +1.295751782e-04f, +1.543450521e-04f, +1.716208647e-04f, +1.809610208e-04f, +1.824629900e-04f, +1.767259657e-04f, +1.647731083e-04f, +1.479425855e-04f, +1.277592971e-04f, +1.058004694e-04f, +8.356813575e-05f, +6.237997497e-05f, +4.328729862e-05f, +2.702553133e-05f, +1.399874871e-05f, +4.296176977e-06f, -2.264573046e-06f, -6.075048267e-06f, -7.663019833e-06f, -7.617957255e-06f, -6.522907823e-06f,
    /*  0,15 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.755657852e-04f, -6.065447794e-04f, -8.545821021e-04f, -1.075386869e-03f, -1.205730648e-03f, -1.164476647e-03f, -8.559259511e-04f, -1.755412632e-04f, +9.821661133e-04f, +2.714084862e-03f, +5.098046504e-03f, +8.182421794e-03f, +1.197684112e-02f, +1.644510957e-02f, +2.150126709e-02f, +2.700950789e-02f, +3.278834001e-02f, +3.861896676e-02f, +4.425744853e-02f, +4.944980188e-02f, +5.394885828e-02f, +5.753147838e-02f, +6.001462650e-02f, +6.126886953e-02f, +6.122807178e-02f, +5.989439231e-02f, +5.733812134e-02f, +5.369237093e-02f, +4.914311219e-02f, +4.391547655e-02f, +3.825756657e-02f, +3.242322034e-02f, +2.665522321e-02f, +2.117036087e-02f, +1.614747299e-02f, +1.171932707e-02f, +7.968727757e-03f, +4.928853632e-03f, +2.587417548e-03f, +8.939184250e-04f, -2.309769343e-04f, -8.849961625e-04f, -1.173834369e-03f, -1.201686999e-03f, -1.063486334e-03f, -8.393230423e-04f, -5.912492225e-04f, -3.623863630e-04f,
    +6.611804677e-06f, +7.657373026e-06f, +7.617829132e-06f, +5.907943456e-06f, +1.940004617e-06f, -4.807454348e-06f, -1.471498148e-05f, -2.794966288e-05f, -4.440361746e-05f, -6.365223261e-05f, -8.493953768e-05f, -1.071957695e-04f, -1.290890081e-04f, -1.491090813e-04f, -1.656781636e-04f, -1.772790849e-04f, -1.825897425e-04f, -1.806105501e-04f, -1.707717740e-04f, -1.530089992e-04f, -1.277977209e-04f, -9.614191340e-05f, -5.951598093e-05f, -1.976424015e-05f, +2.103350960e-05f, +6.071820940e-05f, +9.721513218e-05f, +1.286896348e-04f, +1.536806957e-04f, +1.712002137e-04f, +1.807896387e-04f, +1.825299310e-04f, +1.770055917e-04f, +1.652280476e-04f, +1.485274967e-04f, +1.284250404e-04f, +1.064982673e-04f, +8.425333425e-05f, +6.301508140e-05f, +4.384407088e-05f, +2.748600830e-05f, +1.435522994e-05f, +4.550268416e-06f, -2.103644554e-06f, -5.992592328e-06f, -7.641230718e-06f, -7.638183844e-06f, -6.567617582e-06f,
    /*  0,16 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.689539805e-04f, -5.988874064e-04f, -8.469642730e-04f, -1.069478926e-03f, -1.203790643e-03f, -1.169284101e-03f, -8.706409326e-04f, -2.034909260e-04f, +9.377624959e-04f, +2.650432629e-03f, +5.013106966e-03f, +8.075226025e-03f, +1.184775211e-02f, +1.629600049e-02f, +2.133558892e-02f, +2.683222880e-02f, +3.260575027e-02f, +3.843835620e-02f, +4.408667676e-02f, +4.929679288e-02f, +5.382106056e-02f, +5.743533647e-02f, +5.995511052e-02f, +6.124910529e-02f, +6.124910529e-02f, +5.995511052e-02f, +5.743533647e-02f, +5.382106056e-02f, +4.929679288e-02f, +4.408667676e-02f, +3.843835620e-02f, +3.260575027e-02f, +2.683222880e-02f, +2.133558892e-02f, +1.629600049e-02f, +1.184775211e-02f, +8.075226025e-03f, +5.013106966e-03f, +2.650432629e-03f, +9.377624959e-04f, -2.034909260e-04f, -8.706409326e-04f, -1.169284101e-03f, -1.203790643e-03f, -1.069478926e-03f, -8.469642730e-04f, -5.988874064e-04f, -3.689539805e-04f,
    +6.567617582e-06f, +7.638183844e-06f, +7.641230718e-06f, +5.992592328e-06f, +2.103644554e-06f, -4.550268416e-06f, -1.435522994e-05f, -2.748600830e-05f, -4.384407088e-05f, -6.301508140e-05f, -8.425333425e-05f, -1.064982673e-04f, -1.284250404e-04f, -1.485274967e-04f, -1.652280476e-04f, -1.770055917e-04f, -1.825299310e-04f, -1.807896387e-04f, -1.712002137e-04f, -1.536806957e-04f, -1.286896348e-04f, -9.721513218e-05f, -6.071820940e-05f, -2.103350960e-05f, +1.976424015e-05f, +5.951598093e-05f, +9.614191340e-05f, +1.277977209e-04f, +1.530089992e-04f, +1.707717740e-04f, +1.806105501e-04f, +1.825897425e-04f, +1.772790849e-04f, +1.656781636e-04f, +1.491090813e-04f, +1.290890081e-04f, +1.071957695e-04f, +8.493953768e-05f, +6.365223261e-05f, +4.440361746e-05f, +2.794966288e-05f, +1.471498148e-05f, +4.807454348e-06f, -1.940004617e-06f, -5.907943456e-06f, -7.617829132e-06f, -7.657373026e-06f, -6.611804677e-06f,
    /*  0,17 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.623863630e-04f, -5.912492225e-04f, -8.393230423e-04f, -1.063486334e-03f, -1.201686999e-03f, -1.173834369e-03f, -8.849961625e-04f, -2.309769343e-04f, +8.939184250e-04f, +2.587417548e-03f, +4.928853632e-03f, +7.968727757e-03f, +1.171932707e-02f, +1.614747299e-02f, +2.117036087e-02f, +2.665522321e-02f, +3.242322034e-02f, +3.825756657e-02f, +4.391547655e-02f, +4.914311219e-02f, +5.369237093e-02f, +5.733812134e-02f, +5.989439231e-02f, +6.122807178e-02f, +6.126886953e-02f, +6.001462650e-02f, +5.753147838e-02f, +5.394885828e-02f, +4.944980188e-02f, +4.425744853e-02f, +3.861896676e-02f, +3.278834001e-02f, +2.700950789e-02f, +2.150126709e-02f, +1.644510957e-02f, +1.197684112e-02f, +8.182421794e-03f, +5.098046504e-03f, +2.714084862e-03f, +9.821661133e-04f, -1.755412632e-04f, -8.559259511e-04f, -1.164476647e-03f, -1.205730648e-03f, -1.075386869e-03f, -8.545821021e-04f, -6.065447794e-04f, -3.755657852e-04f,
    +6.522907823e-06f, +7.617957255e-06f, +7.663019833e-06f, +6.075048267e-06f, +2.264573046e-06f, -4.296176977e-06f, -1.399874871e-05f, -2.702553133e-05f, -4.328729862e-05f, -6.237997497e-05f, -8.356813575e-05f, -1.058004694e-04f, -1.277592971e-04f, -1.479425855e-04f, -1.647731083e-04f, -1.767259657e-04f, -1.824629900e-04f, -1.809610208e-04f, -1.716208647e-04f, -1.543450521e-04f, -1.295751782e-04f, -9.828341550e-05f, -6.191730505e-05f, -2.230168514e-05f, +1.849394269e-05f, +5.831068052e-05f, +9.506381053e-05f, +1.268994749e-04f, +1.523299854e-04f, +1.703355517e-04f, +1.804237446e-04f, +1.826423998e-04f, +1.775464088e-04f, +1.661234121e-04f, +1.496872908e-04f, +1.297511522e-04f, +1.078929320e-04f, +8.562670900e-05f, +6.429140060e-05f, +4.496592050e-05f, +2.841648733e-05f, +1.507800476e-05f, +5.067743758e-06f, -1.773638826e-06f, -5.821084136e-06f, -7.592796692e-06f, -7.675507496e-06f, -6.655454364e-06f,
    /*  0,18 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.558634551e-04f, -5.836312653e-04f, -8.316600224e-04f, -1.057411285e-03f, -1.199422426e-03f, -1.178130546e-03f, -8.989949112e-04f, -2.580024657e-04f, +8.506311264e-04f, +2.525037573e-03f, +4.845285496e-03f, +7.862927288e-03f, +1.159156778e-02f, +1.599953041e-02f, +2.100558777e-02f, +2.647849724e-02f, +3.224075735e-02f, +3.807660555e-02f, +4.374385568e-02f, +4.898876714e-02f, +5.356279575e-02f, +5.723983792e-02f, +5.983247500e-02f, +6.120577010e-02f, +6.128736347e-02f, +6.007293718e-02f, +5.762654220e-02f, +5.407575776e-02f, +4.960213187e-02f, +4.442778408e-02f, +3.879939050e-02f, +3.297098241e-02f, +2.718705429e-02f, +2.166739050e-02f, +1.659479686e-02f, +1.210659227e-02f, +8.290314726e-03f, +5.183673213e-03f, +2.778376263e-03f, +1.027132034e-03f, -1.471247758e-04f, -8.408479463e-04f, -1.159408903e-03f, -1.207504287e-03f, -1.081207953e-03f, -8.621748988e-04f, -6.142202869e-04f, -3.822212396e-04f,
    +6.477690047e-06f, +7.596710501e-06f, +7.683214852e-06f, +6.155328848e-06f, +2.422804631e-06f, -4.045170841e-06f, -1.364553606e-05f, -2.656823942e-05f, -4.273331820e-05f, -6.174694096e-05f, -8.288397896e-05f, -1.051024197e-04f, -1.270918263e-04f, -1.473543959e-04f, -1.643133904e-04f, -1.764402438e-04f, -1.823889449e-04f, -1.811247071e-04f, -1.720337218e-04f, -1.550020465e-04f, -1.304543135e-04f, -9.934671235e-05f, -6.311320721e-05f, -2.356870096e-05f, +1.722268318e-05f, +5.710236930e-05f, +9.398087530e-05f, +1.259949353e-04f, +1.516436772e-04f, +1.698915531e-04f, +1.802292123e-04f, +1.826878783e-04f, +1.778075273e-04f, +1.665637486e-04f, +1.502620772e-04f, +1.304114247e-04f, +1.085897106e-04f, +8.631481091e-05f, +6.493255712e-05f, +4.553096181e-05f, +2.888647360e-05f, +1.544430097e-05f, +5.331145428e-06f, -1.604532908e-06f, -5.731996914e-06f, -7.566115013e-06f, -7.692569891e-06f, -6.698551799e-06f,
    /*  0,19 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.493857651e-04f, -5.760345548e-04f, -8.239768076e-04f, -1.051255956e-03f, -1.196999621e-03f, -1.182175717e-03f, -9.126404473e-04f, -2.845707051e-04f, +8.078978082e-04f, +2.463290632e-03f, +4.762401517e-03f, +7.757824868e-03f, +1.146447595e-02f, +1.585217601e-02f, +2.084127438e-02f, +2.630205700e-02f, +3.205836840e-02f, +3.789548084e-02f, +4.357182196e-02f, +4.883376509e-02f, +5.343234143e-02f, +5.714049121e-02f, +5.976936179e-02f, +6.118220139e-02f, +6.130458616e-02f, +6.013003955e-02f, +5.772052307e-02f, +5.420175269e-02f, +4.975377555e-02f, +4.459767564e-02f, +3.897961971e-02f, +3.315367029e-02f, +2.736486182e-02f, +2.183395425e-02f, +1.674505894e-02f, +1.223700370e-02f, +8.398904437e-03f, +5.269988024e-03f, +2.843308820e-03f, +1.072662996e-03f, -1.182383022e-04f, -8.254036453e-04f, -1.154077757e-03f, -1.209108819e-03f, -1.086939950e-03f, -8.697410138e-04f, -6.219128568e-04f, -3.889197914e-04f,
    +6.431978801e-06f, +7.574460766e-06f, +7.701834142e-06f, +6.233451705e-06f, +2.578353981e-06f, -3.797240619e-06f, -1.329559004e-05f, -2.611413971e-05f, -4.218214685e-05f, -6.111600674e-05f, -8.220090042e-05f, -1.044041619e-04f, -1.264226756e-04f, -1.467629763e-04f, -1.638489388e-04f, -1.761484629e-04f, -1.823078213e-04f, -1.812807091e-04f, -1.724387800e-04f, -1.556516572e-04f, -1.313270034e-04f, -1.004049721e-04f, -6.430585546e-05f, -2.483449136e-05f, +1.595052764e-05f, +5.589110862e-05f, +9.289315982e-05f, +1.250841413e-04f, +1.509500984e-04f, +1.694397852e-04f, +1.800269439e-04f, +1.827261540e-04f, +1.780624044e-04f, +1.669991291e-04f, +1.508333922e-04f, +1.310697774e-04f, +1.092860609e-04f, +8.700380586e-05f, +6.557567358e-05f, +4.609872289e-05f, +2.935961333e-05f, +1.581387101e-05f, +5.597667930e-06f, -1.432672729e-06f, -5.640664402e-06f, -7.537765705e-06f, -7.708542790e-06f, -6.741082046e-06f,
    /*  0,20 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.429537863e-04f, -5.684600940e-04f, -8.162749735e-04f, -1.045022505e-03f, -1.194421267e-03f, -1.185972958e-03f, -9.259360373e-04f, -3.106848448e-04f, +7.657156613e-04f, +2.402174625e-03f, +4.680200617e-03f, +7.653420706e-03f, +1.133805327e-02f, +1.570541304e-02f, +2.067742544e-02f, +2.612590854e-02f, +3.187606058e-02f, +3.771420013e-02f, +4.339938318e-02f, +4.867811343e-02f, +5.330101443e-02f, +5.704008624e-02f, +5.970505594e-02f, +6.115736690e-02f, +6.132053668e-02f, +6.018593065e-02f, +5.781341623e-02f, +5.432683683e-02f, +4.990472564e-02f, +4.476711542e-02f, +3.915964666e-02f, +3.333639644e-02f, +2.754292423e-02f, +2.200095338e-02f, +1.689589233e-02f, +1.236807348e-02f, +8.508190498e-03f, +5.356991830e-03f, +2.908884493e-03f, +1.118761719e-03f, -8.887868891e-05f, -8.095897743e-04f, -1.148480090e-03f, -1.210541492e-03f, -1.092580615e-03f, -8.772787795e-04f, -6.296213996e-04f, -3.956608734e-04f,
    +6.385788534e-06f, +7.551225169e-06f, +7.718896060e-06f, +6.309434527e-06f, +2.731235893e-06f, -3.552376721e-06f, -1.294890841e-05f, -2.566323901e-05f, -4.163380147e-05f, -6.048719935e-05f, -8.151893637e-05f, -1.037057395e-04f, -1.257518931e-04f, -1.461683752e-04f, -1.633797983e-04f, -1.758506607e-04f, -1.822196454e-04f, -1.814290384e-04f, -1.728360349e-04f, -1.562938633e-04f, -1.321932110e-04f, -1.014581444e-04f, -6.549518960e-05f, -2.609899070e-05f, +1.467754219e-05f, +5.467696004e-05f, +9.180071650e-05f, +1.241671324e-04f, +1.502492729e-04f, +1.689802556e-04f, +1.798169304e-04f, +1.827572033e-04f, +1.783110046e-04f, +1.674295098e-04f, +1.514011878e-04f, +1.317261621e-04f, +1.099819384e-04f, +8.769365605e-05f, +6.622072111e-05f, +4.666918493e-05f, +2.983589784e-05f, +1.618671553e-05f, +5.867319628e-06f, -1.258044290e-06f, -5.547069277e-06f, -7.507730380e-06f, -7.723408718e-06f, -6.783030070e-06f,
    /*  0,21 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.365679977e-04f, -5.609088688e-04f, -8.085560774e-04f, -1.038713070e-03f, -1.191690031e-03f, -1.189525335e-03f, -9.388849457e-04f, -3.363480838e-04f, +7.240818599e-04f, +2.341687426e-03f, +4.598681680e-03f, +7.549714967e-03f, +1.121230138e-02f, +1.555924466e-02f, +2.051404564e-02f, +2.595005788e-02f, +3.169384093e-02f, +3.753277109e-02f, +4.322654714e-02f, +4.852181957e-02f, +5.316882122e-02f, +5.693862809e-02f, +5.963956075e-02f, +6.113126791e-02f, +6.133521423e-02f, +6.024060761e-02f, +5.790521695e-02f, +5.445100397e-02f, +5.005497492e-02f, +4.493609568e-02f, +3.933946359e-02f, +3.351915364e-02f, +2.772123523e-02f, +2.216838289e-02f, +1.704729352e-02f, +1.249979964e-02f, +8.618172436e-03f, +5.444685486e-03f, +2.975105214e-03f, +1.165430903e-03f, -5.904279106e-05f, -7.934030588e-04f, -1.142612770e-03f, -1.211799537e-03f, -1.098127684e-03f, -8.847865099e-04f, -6.373448083e-04f, -4.024439035e-04f,
    +6.339133594e-06f, +7.527020764e-06f, +7.734418951e-06f, +6.383295056e-06f, +2.881465290e-06f, -3.310569361e-06f, -1.260548869e-05f, -2.521554387e-05f, -4.108829861e-05f, -5.986054554e-05f, -8.083812284e-05f, -1.030071957e-04f, -1.250795263e-04f, -1.455706410e-04f, -1.629060141e-04f, -1.755468747e-04f, -1.821244437e-04f, -1.815697075e-04f, -1.732254828e-04f, -1.569286442e-04f, -1.330529000e-04f, -1.025061794e-04f, -6.668114971e-05f, -2.736213345e-05f, +1.340379299e-05f, +5.345998535e-05f, +9.070359815e-05f, +1.232439486e-04f, +1.495412255e-04f, +1.685129721e-04f, +1.795991635e-04f, +1.827810030e-04f, +1.785532927e-04f, +1.678548470e-04f, +1.519654159e-04f, +1.323805306e-04f, +1.106772984e-04f, +8.838432342e-05f, +6.686767051e-05f, +4.724232877e-05f, +3.031531818e-05f, +1.656283491e-05f, +6.140108674e-06f, -1.080633738e-06f, -5.451194286e-06f, -7.475990650e-06f, -7.737150143e-06f, -6.824380746e-06f,
    /*  0,22 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.302288642e-04f, -5.533818481e-04f, -8.008216584e-04f, -1.032329775e-03f, -1.188808566e-03f, -1.192835904e-03f, -9.514904344e-04f, -3.615636277e-04f, +6.829935612e-04f, +2.281826881e-03f, +4.517843558e-03f, +7.446707771e-03f, +1.108722185e-02f, +1.541367402e-02f, +2.035113962e-02f, +2.577451100e-02f, +3.151171649e-02f, +3.735120138e-02f, +4.305332166e-02f, +4.836489092e-02f, +5.303576832e-02f, +5.683612192e-02f, +5.957287960e-02f, +6.110390578e-02f, +6.134861802e-02f, +6.029406760e-02f, +5.799592054e-02f, +5.457424791e-02f, +5.020451614e-02f, +4.510460865e-02f, +3.951906275e-02f, +3.370193465e-02f, +2.789978852e-02f, +2.233623773e-02f, +1.719925894e-02f, +1.263218017e-02f, +8.728849735e-03f, +5.533069809e-03f, +3.041972885e-03f, +1.212673232e-03f, -2.872747289e-05f, -7.768402239e-04f, -1.136472661e-03f, -1.212880170e-03f, -1.103578878e-03f, -8.922625006e-04f, -6.450819584e-04f, -4.092682842e-04f,
    +6.292028226e-06f, +7.501864540e-06f, +7.748421147e-06f, +6.455051086e-06f, +3.029057220e-06f, -3.071808559e-06f, -1.226532812e-05f, -2.477106051e-05f, -4.054565455e-05f, -5.923607174e-05f, -8.015849554e-05f, -1.023085737e-04f, -1.244056229e-04f, -1.449698222e-04f, -1.624276316e-04f, -1.752371429e-04f, -1.820222430e-04f, -1.817027291e-04f, -1.736071204e-04f, -1.575559798e-04f, -1.339060344e-04f, -1.035490276e-04f, -6.786367609e-05f, -2.862385418e-05f, +1.212934627e-05f, +5.224024653e-05f, +8.960185788e-05f, +1.223146305e-04f, +1.488259813e-04f, +1.680379435e-04f, +1.793736353e-04f, +1.827975304e-04f, +1.787892338e-04f, +1.682750973e-04f, +1.525260286e-04f, +1.330328344e-04f, +1.113720959e-04f, +8.907576968e-05f, +6.751649231e-05f, +4.781813497e-05f, +3.079786504e-05f, +1.694222924e-05f, +6.416043006e-06f, -9.004273601e-07f, -5.353022246e-06f, -7.442528130e-06f, -7.749749481e-06f, -6.865118852e-06f,
    /*  0,23 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.239368359e-04f, -5.458799835e-04f, -7.930732373e-04f, -1.025874724e-03f, -1.185779509e-03f, -1.195907712e-03f, -9.637557625e-04f, -3.863346882e-04f, +6.424479067e-04f, +2.222590809e-03f, +4.437685062e-03f, +7.344399198e-03f, +1.096281623e-02f, +1.526870420e-02f, +2.018871199e-02f, +2.559927386e-02f, +3.132969425e-02f, +3.716949865e-02f, +4.287971454e-02f, +4.820733494e-02f, +5.290186229e-02f, +5.673257289e-02f, +5.950501592e-02f, +6.107528192e-02f, +6.136074737e-02f, +6.034630785e-02f, +5.808552240e-02f, +5.469656255e-02f, +5.035334212e-02f, +4.527264659e-02f, +3.969843638e-02f, +3.388473218e-02f, +2.807857776e-02f, +2.250451283e-02f, +1.735178496e-02f, +1.276521300e-02f, +8.840221830e-03f, +5.622145579e-03f, +3.109489377e-03f, +1.260491367e-03f, +2.070392152e-06f, -7.598979946e-04f, -1.130056618e-03f, -1.213780598e-03f, -1.108931901e-03f, -8.997050287e-04f, -6.528317079e-04f, -4.161334031e-04f,
    +6.244486575e-06f, +7.475773419e-06f, +7.760920964e-06f, +6.524720458e-06f, +3.174026850e-06f, -2.836084140e-06f, -1.192842370e-05f, -2.432979486e-05f, -4.000588521e-05f, -5.861380406e-05f, -7.948008996e-05f, -1.016099164e-04f, -1.237302304e-04f, -1.443659673e-04f, -1.619446962e-04f, -1.749215037e-04f, -1.819130706e-04f, -1.818281164e-04f, -1.739809448e-04f, -1.581758507e-04f, -1.347525789e-04f, -1.045866398e-04f, -6.904270931e-05f, -2.988408757e-05f, +1.085426828e-05f, +5.101780578e-05f, +8.849554918e-05f, +1.213792189e-04f, +1.481035659e-04f, +1.675551786e-04f, +1.791403384e-04f, +1.828067631e-04f, +1.790187932e-04f, +1.686902173e-04f, +1.530829779e-04f, +1.336830254e-04f, +1.120662859e-04f, +8.976795629e-05f, +6.816715673e-05f, +4.839658372e-05f, +3.128352883e-05f, +1.732489835e-05f, +6.695130348e-06f, -7.174115923e-07f, -5.252536049e-06f, -7.407324442e-06f, -7.761189099e-06f, -6.905229076e-06f,
    /*  0,24 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.176923494e-04f, -5.384042101e-04f, -7.853123163e-04f, -1.019350004e-03f, -1.182605482e-03f, -1.198743797e-03f, -9.756841862e-04f, -4.106644831e-04f, +6.024420215e-04f, +2.163977005e-03f, +4.358204972e-03f, +7.242789281e-03f, +1.083908600e-02f, +1.512433823e-02f, +2.002676730e-02f, +2.542435236e-02f, +3.114778118e-02f, +3.698767054e-02f, +4.270573360e-02f, +4.804915909e-02f, +5.276710971e-02f, +5.662798625e-02f, +5.943597321e-02f, +6.104539784e-02f, +6.137160163e-02f, +6.039732565e-02f, +5.817401795e-02f, +5.481794176e-02f, +5.050144569e-02f, +4.544020177e-02f, +3.987757672e-02f, +3.406753894e-02f, +2.825759655e-02f, +2.267320305e-02f, +1.750486794e-02f, +1.289889603e-02f, +8.952288116e-03f, +5.711913535e-03f, +3.177656534e-03f, +1.308887951e-03f, +3.335392098e-05f, -7.425730963e-04f, -1.123361488e-03f, -1.214498009e-03f, -1.114184437e-03f, -9.071123531e-04f, -6.605928970e-04f, -4.230386322e-04f,
    +6.196522682e-06f, +7.448764252e-06f, +7.771936700e-06f, +6.592321062e-06f, +3.316389466e-06f, -2.603385740e-06f, -1.159477218e-05f, -2.389175254e-05f, -3.946900620e-05f, -5.799376832e-05f, -7.880294129e-05f, -1.009112666e-04f, -1.230533962e-04f, -1.437591249e-04f, -1.614572536e-04f, -1.745999956e-04f, -1.817969543e-04f, -1.819458831e-04f, -1.743469537e-04f, -1.587882379e-04f, -1.355924986e-04f, -1.056189673e-04f, -7.021819019e-05f, -3.114276840e-05f, +9.578625365e-06f, +4.979272550e-05f, +8.738472583e-05f, +1.204377551e-04f, +1.473740055e-04f, +1.670646871e-04f, +1.788992659e-04f, +1.828086792e-04f, +1.792419368e-04f, +1.691001640e-04f, +1.536362162e-04f, +1.343310549e-04f, +1.127598233e-04f, +9.046084446e-05f, +6.881963368e-05f, +4.897765493e-05f, +3.177229965e-05f, +1.771084180e-05f, +6.977378204e-06f, -5.315730174e-07f, -5.149718660e-06f, -7.370361214e-06f, -7.771451312e-06f, -6.944696012e-06f,
    /*  0,25 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.114958267e-04f, -5.309554459e-04f, -7.775403796e-04f, -1.012757683e-03f, -1.179289092e-03f, -1.201347182e-03f, -9.872789584e-04f, -4.345562356e-04f, +5.629730153e-04f, +2.105983236e-03f, +4.279402031e-03f, +7.141878015e-03f, +1.071603260e-02f, +1.498057911e-02f, +1.986531004e-02f, +2.524975236e-02f, +3.096598422e-02f, +3.680572465e-02f, +4.253138664e-02f, +4.789037086e-02f, +5.263151721e-02f, +5.652236728e-02f, +5.936575502e-02f, +6.101425507e-02f, +6.138118026e-02f, +6.044711838e-02f, +5.826140268e-02f, +5.493837952e-02f, +5.064881970e-02f, +4.560726646e-02f, +4.005647599e-02f, +3.425034762e-02f, +2.843683849e-02f, +2.284230321e-02f, +1.765850416e-02f, +1.303322708e-02f, +9.065047940e-03f, +5.802374380e-03f, +3.246476168e-03f, +1.357865606e-03f, +6.512622063e-05f, -7.248622545e-04f, -1.116384110e-03f, -1.215029582e-03f, -1.119334155e-03f, -9.144827144e-04f, -6.683643483e-04f, -4.299833282e-04f,
    +6.148150484e-06f, +7.420853824e-06f, +7.781486633e-06f, +6.657870832e-06f, +3.456160473e-06f, -2.373702808e-06f, -1.126437005e-05f, -2.345693889e-05f, -3.893503281e-05f, -5.737599002e-05f, -7.812708446e-05f, -1.002126668e-04f, -1.223751678e-04f, -1.431493437e-04f, -1.609653496e-04f, -1.742726574e-04f, -1.816739221e-04f, -1.820560435e-04f, -1.747051455e-04f, -1.593931230e-04f, -1.364257588e-04f, -1.066459616e-04f, -7.139005983e-05f, -3.239983159e-05f, +8.302483877e-06f, +4.856506828e-05f, +8.626944199e-05f, +1.194902810e-04f, +1.466373266e-04f, +1.665664791e-04f, +1.786504114e-04f, +1.828032572e-04f, +1.794586306e-04f, +1.695048947e-04f, +1.541856957e-04f, +1.349768747e-04f, +1.134526627e-04f, +9.115439517e-05f, +6.947389279e-05f, +4.956132816e-05f, +3.226416726e-05f, +1.810005886e-05f, +7.262793860e-06f, -3.428983692e-07f, -5.044553124e-06f, -7.331620083e-06f, -7.780518386e-06f, -6.983504168e-06f,
    /*  0,26 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -3.053476762e-04f, -5.235345920e-04f, -7.697588930e-04f, -1.006099812e-03f, -1.175832932e-03f, -1.203720885e-03f, -9.985433285e-04f, -4.580131745e-04f, +5.240379825e-04f, +2.048607246e-03f, +4.201274946e-03f, +7.041665348e-03f, +1.059365744e-02f, +1.483742976e-02f, +1.970434469e-02f, +2.507547970e-02f, +3.078431030e-02f, +3.662366861e-02f, +4.235668150e-02f, +4.773097773e-02f, +5.249509145e-02f, +5.641572132e-02f, +5.929436496e-02f, +6.098185524e-02f, +6.138948274e-02f, +6.049568345e-02f, +5.834767212e-02f, +5.505786980e-02f, +5.079545702e-02f, +4.577383294e-02f, +4.023512640e-02f, +3.443315088e-02f, +2.861629712e-02f, +2.301180811e-02f, +1.781268985e-02f, +1.316820396e-02f, +9.178500602e-03f, +5.893528775e-03f, +3.315950061e-03f, +1.407426934e-03f, +9.739038789e-05f, -7.067621956e-04f, -1.109121316e-03f, -1.215372481e-03f, -1.124378708e-03f, -9.218143344e-04f, -6.761448667e-04f, -4.369668323e-04f,
    +6.099383813e-06f, +7.392058845e-06f, +7.789589021e-06f, +6.721387745e-06f, +3.593355386e-06f, -2.147024604e-06f, -1.093721356e-05f, -2.302535893e-05f, -3.840398002e-05f, -5.676049434e-05f, -7.745255413e-05f, -9.951415924e-05f, -1.216955923e-04f, -1.425366721e-04f, -1.604690300e-04f, -1.739395284e-04f, -1.815440025e-04f, -1.821586121e-04f, -1.750555188e-04f, -1.599904879e-04f, -1.372523257e-04f, -1.076675748e-04f, -7.255825958e-05f, -3.365521214e-05f, +7.025910221e-06f, +4.733489691e-05f, +8.514975212e-05f, +1.185368387e-04f, +1.458935566e-04f, +1.660605652e-04f, +1.783937689e-04f, +1.827904761e-04f, +1.796688410e-04f, +1.699043667e-04f, +1.547313687e-04f, +1.356204362e-04f, +1.141447587e-04f, +9.184856916e-05f, +7.012990339e-05f, +5.014758269e-05f, +3.275912115e-05f, +1.849254854e-05f, +7.551384381e-06f, -1.513745344e-07f, -4.937022566e-06f, -7.291082698e-06f, -7.788372543e-06f, -7.021637960e-06f,
    /*  0,27 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -2.992482924e-04f, -5.161425332e-04f, -7.619693040e-04f, -9.993784239e-04f, -1.172239576e-03f, -1.205867910e-03f, -1.009480542e-03f, -4.810385334e-04f, +4.856340025e-04f, +1.991846752e-03f, +4.123822392e-03f, +6.942151189e-03f, +1.047196184e-02f, +1.469489309e-02f, +1.954387566e-02f, +2.490154017e-02f, +3.060276630e-02f, +3.644151000e-02f, +4.218162598e-02f, +4.757098725e-02f, +5.235783912e-02f, +5.630805374e-02f, +5.922180670e-02f, +6.094820002e-02f, +6.139650865e-02f, +6.054301834e-02f, +5.843282187e-02f, +5.517640664e-02f, +5.094135058e-02f, +4.593989350e-02f, +4.041352017e-02f, +3.461594135e-02f, +2.879596596e-02f, +2.318171247e-02f, +1.796742122e-02f, +1.330382439e-02f, +9.292645361e-03f, +5.985377344e-03f, +3.386079964e-03f, +1.457574517e-03f, +1.301495090e-04f, -6.882696471e-04f, -1.101569931e-03f, -1.215523855e-03f, -1.129315731e-03f, -9.291054171e-04f, -6.839332393e-04f, -4.439884703e-04f,
    +6.050236397e-06f, +7.362395954e-06f, +7.796262099e-06f, +6.782889817e-06f, +3.727989835e-06f, -1.923340206e-06f, -1.061329869e-05f, -2.259701741e-05f, -3.787586248e-05f, -5.614730615e-05f, -7.677938468e-05f, -9.881578617e-05f, -1.210147169e-04f, -1.419211588e-04f, -1.599683410e-04f, -1.736006478e-04f, -1.814072243e-04f, -1.822536042e-04f, -1.753980729e-04f, -1.605803153e-04f, -1.380721657e-04f, -1.086837592e-04f, -7.372273107e-05f, -3.490884522e-05f, +5.748970827e-06f, +4.610227435e-05f, +8.402571100e-05f, +1.175774709e-04f, +1.451427229e-04f, +1.655469566e-04f, +1.781293332e-04f, +1.827703153e-04f, +1.798725349e-04f, +1.702985375e-04f, +1.552731878e-04f, +1.362616909e-04f, +1.148360655e-04f, +9.254332692e-05f, +7.078763450e-05f, +5.073639743e-05f, +3.325715046e-05f, +1.888830955e-05f, +7.843156605e-06f, +4.301144525e-08f, -4.827110191e-06f, -7.248730722e-06f, -7.794995958e-06f, -7.059081716e-06f,
    /*  0,28 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -2.931980560e-04f, -5.087801372e-04f, -7.541730419e-04f, -9.925955341e-04f, -1.168511587e-03f, -1.207791250e-03f, -1.020093841e-03f, -5.036355508e-04f, +4.477581400e-04f, +1.935699446e-03f, +4.047043008e-03f, +6.843335402e-03f, +1.035094713e-02f, +1.455297193e-02f, +1.938390732e-02f, +2.472793953e-02f, +3.042135907e-02f, +3.625925639e-02f, +4.200622791e-02f, +4.741040693e-02f, +5.221976696e-02f, +5.619936998e-02f, +5.914808397e-02f, +6.091329118e-02f, +6.140225762e-02f, +6.058912062e-02f, +5.851684758e-02f, +5.529398411e-02f, +5.108649330e-02f, +4.610544046e-02f, +4.059164950e-02f, +3.479871167e-02f, +2.897583849e-02f, +2.335201101e-02f, +1.812269441e-02f, +1.344008609e-02f, +9.407481427e-03f, +6.077920671e-03f, +3.456867598e-03f, +1.508310914e-03f, +1.634066595e-04f, -6.693813375e-04f, -1.093726775e-03f, -1.215480844e-03f, -1.134142841e-03f, -9.363541479e-04f, -6.917282352e-04f, -4.510475520e-04f,
    +6.000721856e-06f, +7.331881716e-06f, +7.801524077e-06f, +6.842395104e-06f, +3.860079559e-06f, -1.702638511e-06f, -1.029262119e-05f, -2.217191876e-05f, -3.735069452e-05f, -5.553645002e-05f, -7.610761022e-05f, -9.811758948e-05f, -1.203325886e-04f, -1.413028526e-04f, -1.594633288e-04f, -1.732560555e-04f, -1.812636169e-04f, -1.823410354e-04f, -1.757328077e-04f, -1.611625883e-04f, -1.388852458e-04f, -1.096944677e-04f, -7.488341620e-05f, -3.616066610e-05f, +4.471732158e-06f, +4.486726377e-05f, +8.289737375e-05f, +1.166122207e-04f, +1.443848538e-04f, +1.650256649e-04f, +1.778570993e-04f, +1.827427547e-04f, +1.800696793e-04f, +1.706873651e-04f, +1.558111055e-04f, +1.369005902e-04f, +1.155265373e-04f, +9.323862873e-05f, +7.144705488e-05f, +5.132775100e-05f, +3.375824403e-05f, +1.928734033e-05f, +8.138117147e-06f, +2.402723706e-07f, -4.714799292e-06f, -7.204545832e-06f, -7.800370763e-06f, -7.095819678e-06f,
    /*  0,29 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -2.871973341e-04f, -5.014482555e-04f, -7.463715178e-04f, -9.857531390e-04f, -1.164651507e-03f, -1.209493888e-03f, -1.030386462e-03f, -5.258074696e-04f, +4.104074455e-04f, +1.880162996e-03f, +3.970935397e-03f, +6.745217813e-03f, +1.023061454e-02f, +1.441166908e-02f, +1.922444399e-02f, +2.455468347e-02f, +3.024009546e-02f, +3.607691536e-02f, +4.183049510e-02f, +4.724924434e-02f, +5.208088171e-02f, +5.608967552e-02f, +5.907320056e-02f, +6.087713051e-02f, +6.140672936e-02f, +6.063398788e-02f, +5.859974496e-02f, +5.541059633e-02f, +5.123087815e-02f, +4.627046613e-02f, +4.076950660e-02f, +3.498145442e-02f, +2.915590817e-02f, +2.352269837e-02f, +1.827850552e-02f, +1.357698668e-02f, +9.523007964e-03f, +6.171159300e-03f, +3.528314653e-03f, +1.559638665e-03f, +1.971649035e-04f, -6.500939972e-04f, -1.085588658e-03f, -1.215240571e-03f, -1.138857640e-03f, -9.435586937e-04f, -6.995286060e-04f, -4.581433717e-04f,
    +5.950853705e-06f, +7.300532620e-06f, +7.805393139e-06f, +6.899921698e-06f, +3.989640402e-06f, -1.484908233e-06f, -9.975176579e-06f, -2.175006713e-05f, -3.682849015e-05f, -5.492795017e-05f, -7.543726457e-05f, -9.741961088e-05f, -1.196492544e-04f, -1.406818019e-04f, -1.589540398e-04f, -1.729057912e-04f, -1.811132097e-04f, -1.824209217e-04f, -1.760597234e-04f, -1.617372905e-04f, -1.396915333e-04f, -1.106996535e-04f, -7.604025715e-05f, -3.741061019e-05f, +3.194260694e-06f, +4.362992850e-05f, +8.176479580e-05f, +1.156411315e-04f, +1.436199778e-04f, +1.644967024e-04f, +1.775770628e-04f, +1.827077745e-04f, +1.802602417e-04f, +1.710708076e-04f, +1.563450745e-04f, +1.375370856e-04f, +1.162161284e-04f, +9.393443463e-05f, +7.210813297e-05f, +5.192162170e-05f, +3.426239038e-05f, +1.968963904e-05f, +8.436272395e-06f, +4.404208828e-07f, -4.600073246e-06f, -7.158509723e-06f, -7.804479049e-06f, -7.131836001e-06f,
    /*  0,30 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -2.812464804e-04f, -4.941477229e-04f, -7.385661247e-04f, -9.788532173e-04f, -1.160661867e-03f, -1.210978797e-03f, -1.040361638e-03f, -5.475575367e-04f, +3.735789553e-04f, +1.825235046e-03f, +3.895498133e-03f, +6.647798202e-03f, +1.011096528e-02f, +1.427098728e-02f, +1.906548995e-02f, +2.438177768e-02f, +3.005898225e-02f, +3.589449444e-02f, +4.165443537e-02f, +4.708750705e-02f, +5.194119018e-02f, +5.597897586e-02f, +5.899716030e-02f, +6.083971990e-02f, +6.140992362e-02f, +6.067761781e-02f, +5.868150975e-02f, +5.552623746e-02f, +5.137449813e-02f, +4.643496283e-02f, +4.094708366e-02f, +3.516416220e-02f, +2.933616842e-02f, +2.369376918e-02f, +1.843485059e-02f, +1.371452376e-02f, +9.639224092e-03f, +6.265093734e-03f, +3.600422786e-03f, +1.611560287e-03f, +2.314272939e-04f, -6.304043582e-04f, -1.077152385e-03f, -1.214800150e-03f, -1.143457714e-03f, -9.507172034e-04f, -7.073330850e-04f, -4.652752077e-04f,
    +5.900645350e-06f, +7.268365081e-06f, +7.807887439e-06f, +6.955487723e-06f, +4.116688316e-06f, -1.270137912e-06f, -9.660960103e-06f, -2.133146638e-05f, -3.630926307e-05f, -5.432183054e-05f, -7.476838129e-05f, -9.672189189e-05f, -1.189647611e-04f, -1.400580555e-04f, -1.584405205e-04f, -1.725498952e-04f, -1.809560329e-04f, -1.824932796e-04f, -1.763788209e-04f, -1.623044060e-04f, -1.404909963e-04f, -1.116992702e-04f, -7.719319639e-05f, -3.865861306e-05f, +1.916622938e-06f, +4.239033203e-05f, +8.062803289e-05f, +1.146642473e-04f, +1.428481242e-04f, +1.639600817e-04f, +1.772892198e-04f, +1.826653555e-04f, +1.804441899e-04f, +1.714488231e-04f, +1.568750475e-04f, +1.381711284e-04f, +1.169047926e-04f, +9.463070442e-05f, +7.277083693e-05f, +5.251798750e-05f, +3.476957772e-05f, +2.009520355e-05f, +8.737628506e-06f, +6.434694612e-07f, -4.482915520e-06f, -7.110604110e-06f, -7.807302866e-06f, -7.167114757e-06f,
    /*  0,31 (48) */
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    -2.753458351e-04f, -4.868793578e-04f, -7.307582372e-04f, -9.718977296e-04f, -1.156545178e-03f, -1.212248935e-03f, -1.050022599e-03f, -5.688890031e-04f, +3.372696922e-04f, +1.770913215e-03f, +3.820729751e-03f, +6.551076310e-03f, +9.992000524e-03f, +1.413092922e-02f, +1.890704943e-02f, +2.420922778e-02f, +2.987802621e-02f, +3.571200116e-02f, +4.147805655e-02f, +4.692520265e-02f, +5.180069918e-02f, +5.586727659e-02f, +5.891996710e-02f, +6.080106129e-02f, +6.141184024e-02f, +6.072000814e-02f, +5.876213779e-02f, +5.564090171e-02f, +5.151734626e-02f, +4.659892291e-02f, +4.112437288e-02f, +3.534682755e-02f, +2.951661261e-02f, +2.386521801e-02f, +1.859172564e-02f, +1.385269489e-02f, +9.756128885e-03f, +6.359724439e-03f, +3.673193623e-03f, +1.664078274e-03f, +2.661968716e-04f, -6.103091546e-04f, -1.068414757e-03f, -1.214156681e-03f, -1.147940629e-03f, -9.578278075e-04f, -7.151403879e-04f, -4.724423225e-04f,
    +5.850110091e-06f, +7.235395433e-06f, +7.809025104e-06f, +7.009111338e-06f, +4.241239355e-06f, -1.058315911e-06f, -9.349966785e-06f, -2.091612006e-05f, -3.579302665e-05f, -5.371811474e-05f, -7.410099365e-05f, -9.602447380e-05f, -1.182791553e-04f, -1.394316620e-04f, -1.579228174e-04f, -1.721884081e-04f, -1.807921168e-04f, -1.825581262e-04f, -1.766901015e-04f, -1.628639195e-04f, -1.412836031e-04f, -1.126932717e-04f, -7.834217668e-05f, -3.990461040e-05f, +6.388853996e-07f, +4.114853805e-05f, +7.948714106e-05f, +1.136816124e-04f, +1.420693226e-04f, +1.634158161e-04f, +1.769935670e-04f, +1.826154788e-04f, +1.806214921e-04f, +1.718213704e-04f, +1.574009775e-04f, +1.388026701e-04f, +1.175924836e-04f, +9.532739769e-05f, +7.343513463e-05f, +5.311682607e-05f, +3.527979396e-05f, +2.050403146e-05f, +9.042191405e-06f, +8.494304210e-07f, -4.363309672e-06f, -7.060810728e-06f, -7.808824226e-06f, -7.201639933e-06f,
    /*  1, 0 (48) */
    -4.796439624e-04f, -7.229492121e-04f, -9.648886183e-04f, -1.152303939e-03f, -1.213307251e-03f, -1.059372565e-03f, -5.898051232e-04f, +3.014766656e-04f, +1.717195100e-03f, +3.746628758e-03f, +6.455051836e-03f, +9.873721368e-03f, +1.399149756e-02f, +1.874912662e-02f, +2.403703938e-02f, +2.969723410e-02f, +3.552944303e-02f, +4.130136645e-02f, +4.676233873e-02f, +5.165941558e-02f, +5.575458332e-02f, +5.884162493e-02f, +6.076115668e-02f, +6.141247912e-02f, +6.076115668e-02f, +5.884162493e-02f, +5.575458332e-02f, +5.165941558e-02f, +4.676233873e-02f, +4.130136645e-02f, +3.552944303e-02f, +2.969723410e-02f, +2.403703938e-02f, +1.874912662e-02f, +1.399149756e-02f, +9.873721368e-03f, +6.455051836e-03f, +3.746628758e-03f, +1.717195100e-03f, +3.014766656e-04f, -5.898051232e-04f, -1.059372565e-03f, -1.213307251e-03f, -1.152303939e-03f, -9.648886183e-04f, -7.229492121e-04f, -4.796439624e-04f, -2.694957250e-04f,
    +7.201639933e-06f, +7.808824226e-06f, +7.060810728e-06f, +4.363309672e-06f, -8.494304210e-07f, -9.042191405e-06f, -2.050403146e-05f, -3.527979396e-05f, -5.311682607e-05f, -7.343513463e-05f, -9.532739769e-05f, -1.175924836e-04f, -1.388026701e-04f, -1.574009775e-04f, -1.718213704e-04f, -1.806214921e-04f, -1.826154788e-04f, -1.769935670e-04f, -1.634158161e-04f, -1.420693226e-04f, -1.136816124e-04f, -7.948714106e-05f, -4.114853805e-05f, -6.388853996e-07f, +3.990461040e-05f, +7.834217668e-05f, +1.126932717e-04f, +1.412836031e-04f, +1.628639195e-04f, +1.766901015e-04f, +1.825581262e-04f, +1.807921168e-04f, +1.721884081e-04f, +1.579228174e-04f, +1.394316620e-04f, +1.182791553e-04f, +9.602447380e-05f, +7.410099365e-05f, +5.371811474e-05f, +3.579302665e-05f, +2.091612006e-05f, +9.349966785e-06f, +1.058315911e-06f, -4.241239355e-06f, -7.009111338e-06f, -7.809025104e-06f, -7.235395433e-06f, -5.850110091e-06f,
    +7.400711575e-04f, +1.375020608e-03f, +2.149280883e-03f, +2.889370620e-03f, +3.314167096e-03f, +3.062969010e-03f, +1.758157367e-03f, -9.035293376e-04f, -5.046849967e-03f, -1.052447103e-02f, -1.686036328e-02f, -2.325321288e-02f, -2.865282346e-02f, -3.190731847e-02f, -3.196179918e-02f, -2.807404400e-02f, -2.000388698e-02f, -8.133017718e-03f, +6.517945993e-03f, +2.238959427e-02f, +3.759199639e-02f, +5.018871167e-02f, +5.850644264e-02f, +6.141247912e-02f, +5.850644264e-02f, +5.018871167e-02f, +3.759199639e-02f, +2.238959427e-02f, +6.517945993e-03f, -8.133017718e-03f, -2.000388698e-02f, -2.807404400e-02f, -3.196179918e-02f, -3.190731847e-02f, -2.865282346e-02f, -2.325321288e-02f, -1.686036328e-02f, -1.052447103e-02f, -5.046849967e-03f, -9.035293376e-04f, +1.758157367e-03f, +3.062969010e-03f, +3.314167096e-03f, +2.889370620e-03f, +2.149280883e-03f, +1.375020608e-03f, +7.400711575e-04f, +3.136419749e-04f,
    -1.659937380e-05f, -2.256041491e-05f, -2.486780869e-05f, -2.006906889e-05f, -5.045062098e-06f, +2.191765594e-05f, +6.008443510e-05f, +1.055682666e-04f, +1.512517643e-04f, +1.875167265e-04f, +2.037839118e-04f, +1.906528266e-04f, +1.422374703e-04f, +5.817440947e-05f, -5.522355901e-05f, -1.850656642e-04f, -3.133868468e-04f, -4.199011281e-04f, -4.855454817e-04f, -4.961329892e-04f, -4.453540068e-04f, -3.364549421e-04f, -1.821741084e-04f, -2.871243403e-06f, +1.768283313e-04f, +3.322313388e-04f, +4.427876402e-04f, +4.954835019e-04f, +4.867652811e-04f, +4.226610826e-04f, +3.171517381e-04f, +1.892017453e-04f, +5.911498836e-05f, -5.502368951e-05f, -1.401349478e-04f, -1.896917185e-04f, -2.038605671e-04f, -1.883821463e-04f, -1.525821837e-04f, -1.070377027e-04f, -6.142412938e-05f, -2.295246704e-05f, +4.386614560e-06f, +1.976802667e-05f, +2.484354255e-05f, +2.270517913e-05f, +1.680953745e-05f, +1.011663066e-05f,
    /*  1, 1 (48) */
    -4.724423225e-04f, -7.151403879e-04f, -9.578278075e-04f, -1.147940629e-03f, -1.214156681e-03f, -1.068414757e-03f, -6.103091546e-04f, +2.661968716e-04f, +1.664078274e-03f, +3.673193623e-03f, +6.359724439e-03f, +9.756128885e-03f, +1.385269489e-02f, +1.859172564e-02f, +2.386521801e-02f, +2.951661261e-02f, +3.534682755e-02f, +4.112437288e-02f, +4.659892291e-02f, +5.151734626e-02f, +5.564090171e-02f, +5.876213779e-02f, +6.072000814e-02f, +6.141184024e-02f, +6.080106129e-02f, +5.891996710e-02f, +5.586727659e-02f, +5.180069918e-02f, +4.692520265e-02f, +4.147805655e-02f, +3.571200116e-02f, +2.987802621e-02f, +2.420922778e-02f, +1.890704943e-02f, +1.413092922e-02f, +9.992000524e-03f, +6.551076310e-03f, +3.820729751e-03f, +1.770913215e-03f, +3.372696922e-04f, -5.688890031e-04f, -1.050022599e-03f, -1.212248935e-03f, -1.156545178e-03f, -9.718977296e-04f, -7.307582372e-04f, -4.868793578e-04f, -2.753458351e-04f,
    +7.167114757e-06f, +7.807302866e-06f, +7.110604110e-06f, +4.482915520e-06f, -6.434694612e-07f, -8.737628506e-06f, -2.009520355e-05f, -3.476957772e-05f, -5.251798750e-05f, -7.277083693e-05f, -9.463070442e-05f, -1.169047926e-04f, -1.381711284e-04f, -1.568750475e-04f, -1.714488231e-04f, -1.804441899e-04f, -1.826653555e-04f, -1.772892198e-04f, -1.639600817e-04f, -1.428481242e-04f, -1.146642473e-04f, -8.062803289e-05f, -4.239033203e-05f, -1.916622938e-06f, +3.865861306e-05f, +7.719319639e-05f, +1.116992702e-04f, +1.404909963e-04f, +1.623044060e-04f, +1.763788209e-04f, +1.824932796e-04f, +1.809560329e-04f, +1.725498952e-04f, +1.584405205e-04f, +1.400580555e-04f, +1.189647611e-04f, +9.672189189e-05f, +7.476838129e-05f, +5.432183054e-05f, +3.630926307e-05f, +2.133146638e-05f, +9.660960103e-06f, +1.270137912e-06f, -4.116688316e-06f, -6.955487723e-06f, -7.807887439e-06f, -7.268365081e-06f, -5.900645350e-06f,
    +7.234717837e-04f, +1.352460193e-03f, +2.124413074e-03f, +2.869301551e-03f, +3.309122034e-03f, +3.084886666e-03f, +1.818241802e-03f, -7.979610710e-04f, -4.895598203e-03f, -1.033695430e-02f, -1.665657936e-02f, -2.306256005e-02f, -2.851058599e-02f, -3.184914406e-02f, -3.201702274e-02f, -2.825910966e-02f, -2.031727383e-02f, -8.552918846e-03f, +6.032400511e-03f, +2.189346129e-02f, +3.714664238e-02f, +4.985225673e-02f, +5.832426853e-02f, +6.140960788e-02f, +5.868327097e-02f, +5.052094301e-02f, +3.803478403e-02f, +2.288507778e-02f, +7.004711274e-03f, -7.710356635e-03f, -1.968673524e-02f, -2.788484225e-02f, -3.190268420e-02f, -3.196234216e-02f, -2.879295841e-02f, -2.344290460e-02f, -1.706422384e-02f, -1.071285317e-02f, -5.199432151e-03f, -1.010567040e-03f, +1.696733238e-03f, +3.040016543e-03f, +3.318553711e-03f, +2.909138647e-03f, +2.174124425e-03f, +1.397725787e-03f, +7.568806949e-04f, +3.237586056e-04f,
    -1.638859383e-05f, -2.241212896e-05f, -2.488511074e-05f, -2.036001099e-05f, -5.691648011e-06f, +2.089404958e-05f, +5.875215808e-05f, +1.040992379e-04f, +1.499122321e-04f, +1.866316842e-04f, +2.036782580e-04f, +1.915790189e-04f, +1.443046239e-04f, +6.129593148e-05f, -5.134861502e-05f, -1.809282955e-04f, -3.096005616e-04f, -4.171008580e-04f, -4.842712606e-04f, -4.967217519e-04f, -4.478628235e-04f, -3.406335909e-04f, -1.874950937e-04f, -8.613337121e-06f, +1.714584810e-04f, +3.279633107e-04f, +4.401639799e-04f, +4.947732413e-04f, +4.879303311e-04f, +4.253801896e-04f, +3.208946069e-04f, +1.933359288e-04f, +6.302241295e-05f, -5.184407396e-05f, -1.379971457e-04f, -1.886955890e-04f, -2.039079747e-04f, -1.892276213e-04f, -1.539031669e-04f, -1.085072808e-04f, -6.277106912e-05f, -2.399841424e-05f, +3.716284432e-06f, +1.945680269e-05f, +2.481220449e-05f, +2.284631865e-05f, +1.701900789e-05f, +1.031543611e-05f,
    /*  1, 2 (48) */
    -4.652752077e-04f, -7.073330850e-04f, -9.507172034e-04f, -1.143457714e-03f, -1.214800150e-03f, -1.077152385e-03f, -6.304043582e-04f, +2.314272939e-04f, +1.611560287e-03f, +3.600422786e-03f, +6.265093734e-03f, +9.639224092e-03f, +1.371452376e-02f, +1.843485059e-02f, +2.369376918e-02f, +2.933616842e-02f, +3.516416220e-02f, +4.094708366e-02f, +4.643496283e-02f, +5.137449813e-02f, +5.552623746e-02f, +5.868150975e-02f, +6.067761781e-02f, +6.140992362e-02f, +6.083971990e-02f, +5.899716030e-02f, +5.597897586e-02f, +5.194119018e-02f, +4.708750705e-02f, +4.165443537e-02f, +3.589449444e-02f, +3.005898225e-02f, +2.438177768e-02f, +1.906548995e-02f, +1.427098728e-02f, +1.011096528e-02f, +6.647798202e-03f, +3.895498133e-03f, +1.825235046e-03f, +3.735789553e-04f, -5.475575367e-04f, -1.040361638e-03f, -1.210978797e-03f, -1.160661867e-03f, -9.788532173e-04f, -7.385661247e-04f, -4.941477229e-04f, -2.812464804e-04f,
    +7.131836001e-06f, +7.804479049e-06f, +7.158509723e-06f, +4.600073246e-06f, -4.404208828e-07f, -8.436272395e-06f, -1.968963904e-05f, -3.426239038e-05f, -5.192162170e-05f, -7.210813297e-05f, -9.393443463e-05f, -1.162161284e-04f, -1.375370856e-04f, -1.563450745e-04f, -1.710708076e-04f, -1.802602417e-04f, -1.827077745e-04f, -1.775770628e-04f, -1.644967024e-04f, -1.436199778e-04f, -1.156411315e-04f, -8.176479580e-05f, -4.362992850e-05f, -3.194260694e-06f, +3.741061019e-05f, +7.604025715e-05f, +1.106996535e-04f, +1.396915333e-04f, +1.617372905e-04f, +1.760597234e-04f, +1.824209217e-04f, +1.811132097e-04f, +1.729057912e-04f, +1.589540398e-04f, +1.406818019e-04f, +1.196492544e-04f, +9.741961088e-05f, +7.543726457e-05f, +5.492795017e-05f, +3.682849015e-05f, +2.175006713e-05f, +9.975176579e-06f, +1.484908233e-06f, -3.989640402e-06f, -6.899921698e-06f, -7.805393139e-06f, -7.300532620e-06f, -5.950853705e-06f,
    +7.070831898e-04f, +1.330048064e-03f, +2.099527963e-03f, +2.848941540e-03f, +3.303430386e-03f, +3.105780715e-03f, +1.876993960e-03f, -6.938618331e-04f, -4.745685971e-03f, -1.015032262e-02f, -1.645290111e-02f, -2.287098103e-02f, -2.836628136e-02f, -3.178784813e-02f, -3.206837136e-02f, -2.844003796e-02f, -2.062687439e-02f, -8.970019704e-03f, +5.548129250e-03f, +2.139673953e-02f, +3.669877956e-02f, +4.951162314e-02f, +5.813677344e-02f, +6.140099454e-02f, +5.885472945e-02f, +5.084890632e-02f, +3.847494801e-02f, +2.337985102e-02f, +7.492641605e-03f, -7.284976446e-03f, -1.936584064e-02f, -2.769150633e-02f, -3.183966178e-02f, -3.201418624e-02f, -2.893095555e-02f, -2.363160019e-02f, -1.726813182e-02f, -1.090208080e-02f, -5.353335318e-03f, -1.119074321e-03f, +1.633962169e-03f, +3.016018128e-03f, +3.322269995e-03f, +2.928595450e-03f, +2.198936630e-03f, +1.420572106e-03f, +7.738997028e-04f, +3.340740417e-04f,
    -1.617727343e-05f, -2.226042371e-05f, -2.489555680e-05f, -2.064093598e-05f, -6.326395649e-06f, +1.988171347e-05f, +5.742746693e-05f, +1.026308797e-04f, +1.485639094e-04f, +1.857273426e-04f, +2.035438583e-04f, +1.924704065e-04f, +1.463363255e-04f, +6.438795966e-05f, -4.749064148e-05f, -1.767902467e-04f, -3.057935123e-04f, -4.142608086e-04f, -4.829429533e-04f, -4.972498479e-04f, -4.503138436e-04f, -3.447667631e-04f, -1.927905726e-04f, -1.435425164e-05f, +1.660652804e-04f, +3.236513949e-04f, +4.374832914e-04f, +4.940021681e-04f, +4.890403118e-04f, +4.280579225e-04f, +3.246148259e-04f, +1.974676028e-04f, +6.694533766e-05f, -4.863587167e-05f, -1.358241603e-04f, -1.876643381e-04f, -2.039258891e-04f, -1.900528304e-04f, -1.552143899e-04f, -1.099767330e-04f, -6.412507928e-05f, -2.505542575e-05f, +3.034053170e-06f, +1.913531668e-05f, +2.477368699e-05f, +2.298372996e-05f, +1.722770722e-05f, +1.051543136e-05f,
    /*  1, 3 (48) */
    -4.581433717e-04f, -6.995286060e-04f, -9.435586937e-04f, -1.138857640e-03f, -1.215240571e-03f, -1.085588658e-03f, -6.500939972e-04f, +1.971649035e-04f, +1.559638665e-03f, +3.528314653e-03f, +6.171159300e-03f, +9.523007964e-03f, +1.357698668e-02f, +1.827850552e-02f, +2.352269837e-02f, +2.915590817e-02f, +3.498145442e-02f, +4.076950660e-02f, +4.627046613e-02f, +5.123087815e-02f, +5.541059633e-02f, +5.859974496e-02f, +6.063398788e-02f, +6.140672936e-02f, +6.087713051e-02f, +5.907320056e-02f, +5.608967552e-02f, +5.208088171e-02f, +4.724924434e-02f, +4.183049510e-02f, +3.607691536e-02f, +3.024009546e-02f, +2.455468347e-02f, +1.922444399e-02f, +1.441166908e-02f, +1.023061454e-02f, +6.745217813e-03f, +3.970935397e-03f, +1.880162996e-03f, +4.104074455e-04f, -5.258074696e-04f, -1.030386462e-03f, -1.209493888e-03f, -1.164651507e-03f, -9.857531390e-04f, -7.463715178e-04f, -5.014482555e-04f, -2.871973341e-04f,
    +7.095819678e-06f, +7.800370763e-06f, +7.204545832e-06f, +4.714799292e-06f, -2.402723706e-07f, -8.138117147e-06f, -1.928734033e-05f, -3.375824403e-05f, -5.132775100e-05f, -7.144705488e-05f, -9.323862873e-05f, -1.155265373e-04f, -1.369005902e-04f, -1.558111055e-04f, -1.706873651e-04f, -1.800696793e-04f, -1.827427547e-04f, -1.778570993e-04f, -1.650256649e-04f, -1.443848538e-04f, -1.166122207e-04f, -8.289737375e-05f, -4.486726377e-05f, -4.471732158e-06f, +3.616066610e-05f, +7.488341620e-05f, +1.096944677e-04f, +1.388852458e-04f, +1.611625883e-04f, +1.757328077e-04f, +1.823410354e-04f, +1.812636169e-04f, +1.732560555e-04f, +1.594633288e-04f, +1.413028526e-04f, +1.203325886e-04f, +9.811758948e-05f, +7.610761022e-05f, +5.553645002e-05f, +3.735069452e-05f, +2.217191876e-05f, +1.029262119e-05f, +1.702638511e-06f, -3.860079559e-06f, -6.842395104e-06f, -7.801524077e-06f, -7.331881716e-06f, -6.000721856e-06f,
    +6.909059164e-04f, +1.307787641e-03f, +2.074632406e-03f, +2.828300604e-03f, +3.297103990e-03f, +3.125662429e-03f, +1.934421427e-03f, -5.912309534e-04f, -4.597122062e-03f, -9.964595275e-03f, -1.624935725e-02f, -2.267851063e-02f, -2.821994504e-02f, -3.172346017e-02f, -3.211586200e-02f, -2.861682821e-02f, -2.093266790e-02f, -9.384280512e-03f, +5.065186297e-03f, +2.089948969e-02f, +3.624846571e-02f, +4.916685638e-02f, +5.794398287e-02f, +6.138664029e-02f, +5.902079474e-02f, +5.117255772e-02f, +3.891243130e-02f, +2.387385319e-02f, +7.981681917e-03f, -6.856918523e-03f, -1.904122581e-02f, -2.749403872e-02f, -3.177271645e-02f, -3.206282211e-02f, -2.906677971e-02f, -2.381926452e-02f, -1.747205771e-02f, -1.109213363e-02f, -5.508549708e-03f, -1.229051054e-03f, +1.569837089e-03f, +2.990962703e-03f, +3.325304048e-03f, +2.947730766e-03f, +2.223710317e-03f, +1.443555836e-03f, +7.911274100e-04f, +3.445894731e-04f,
    -1.596548744e-05f, -2.210540102e-05f, -2.489925524e-05f, -2.091192815e-05f, -6.949330726e-06f, +1.888071007e-05f, +5.611052704e-05f, +1.011634523e-04f, +1.472071174e-04f, +1.848040261e-04f, +2.033809683e-04f, +1.933271055e-04f, +1.483324988e-04f, +6.745020468e-05f, -4.365011838e-05f, -1.726521230e-04f, -3.019663296e-04f, -4.113815210e-04f, -4.815609030e-04f, -4.977173448e-04f, -4.527068295e-04f, -3.488539443e-04f, -1.980598351e-04f, -2.009320106e-05f, +1.606494561e-04f, +3.192961356e-04f, +4.347458496e-04f, +4.931702526e-04f, +4.900949110e-04f, +4.306937594e-04f, +3.283117689e-04f, +2.015961528e-04f, +7.088326246e-05f, -4.539939795e-05f, -1.336160942e-04f, -1.865978710e-04f, -2.039140682e-04f, -1.908574537e-04f, -1.565155274e-04f, -1.114457889e-04f, -6.548598165e-05f, -2.612342670e-05f, +2.339904673e-06f, +1.880348977e-05f, +2.472788286e-05f, +2.311730902e-05f, +1.743555650e-05f, +1.071657227e-05f,
    /*  1, 4 (48) */
    -4.510475520e-04f, -6.917282352e-04f, -9.363541479e-04f, -1.134142841e-03f, -1.215480844e-03f, -1.093726775e-03f, -6.693813375e-04f, +1.634066595e-04f, +1.508310914e-03f, +3.456867598e-03f, +6.077920671e-03f, +9.407481427e-03f, +1.344008609e-02f, +1.812269441e-02f, +2.335201101e-02f, +2.897583849e-02f, +3.479871167e-02f, +4.059164950e-02f, +4.610544046e-02f, +5.108649330e-02f, +5.529398411e-02f, +5.851684758e-02f, +6.058912062e-02f, +6.140225762e-02f, +6.091329118e-02f, +5.914808397e-02f, +5.619936998e-02f, +5.221976696e-02f, +4.741040693e-02f, +4.200622791e-02f, +3.625925639e-02f, +3.042135907e-02f, +2.472793953e-02f, +1.938390732e-02f, +1.455297193e-02f, +1.035094713e-02f, +6.843335402e-03f, +4.047043008e-03f, +1.935699446e-03f, +4.477581400e-04f, -5.036355508e-04f, -1.020093841e-03f, -1.207791250e-03f, -1.168511587e-03f, -9.925955341e-04f, -7.541730419e-04f, -5.087801372e-04f, -2.931980560e-04f,
    +7.059081716e-06f, +7.794995958e-06f, +7.248730722e-06f, +4.827110191e-06f, -4.301144525e-08f, -7.843156605e-06f, -1.888830955e-05f, -3.325715046e-05f, -5.073639743e-05f, -7.078763450e-05f, -9.254332692e-05f, -1.148360655e-04f, -1.362616909e-04f, -1.552731878e-04f, -1.702985375e-04f, -1.798725349e-04f, -1.827703153e-04f, -1.781293332e-04f, -1.655469566e-04f, -1.451427229e-04f, -1.175774709e-04f, -8.402571100e-05f, -4.610227435e-05f, -5.748970827e-06f, +3.490884522e-05f, +7.372273107e-05f, +1.086837592e-04f, +1.380721657e-04f, +1.605803153e-04f, +1.753980729e-04f, +1.822536042e-04f, +1.814072243e-04f, +1.736006478e-04f, +1.599683410e-04f, +1.419211588e-04f, +1.210147169e-04f, +9.881578617e-05f, +7.677938468e-05f, +5.614730615e-05f, +3.787586248e-05f, +2.259701741e-05f, +1.061329869e-05f, +1.923340206e-06f, -3.727989835e-06f, -6.782889817e-06f, -7.796262099e-06f, -7.362395954e-06f, -6.050236397e-06f,
    +6.749404290e-04f, +1.285682239e-03f, +2.049733151e-03f, +2.807388676e-03f, +3.290154659e-03f, +3.144543139e-03f, +1.990531954e-03f, -4.900675011e-04f, -4.449914944e-03f, -9.779791249e-03f, -1.604597628e-02f, -2.248518352e-02f, -2.807161254e-02f, -3.165600997e-02f, -3.215951212e-02f, -2.878948033e-02f, -2.123463423e-02f, -9.795662033e-03f, +4.583625394e-03f, +2.040177234e-02f, +3.579575888e-02f, +4.881800243e-02f, +5.774592303e-02f, +6.136654709e-02f, +5.918144419e-02f, +5.149185385e-02f, +3.934717715e-02f, +2.436702344e-02f, +8.471776828e-03f, -6.426224764e-03f, -1.871291404e-02f, -2.729244257e-02f, -3.170183318e-02f, -3.210822151e-02f, -2.920039581e-02f, -2.400586239e-02f, -1.767597177e-02f, -1.128299108e-02f, -5.665065235e-03f, -1.340496843e-03f, +1.504351108e-03f, +2.964839276e-03f, +3.327643953e-03f, +2.966534256e-03f, +2.248438199e-03f, +1.466673145e-03f, +8.085629665e-04f, +3.553060453e-04f,
    -1.575330966e-05f, -2.194716213e-05f, -2.489631464e-05f, -2.117307309e-05f, -7.560481282e-06f, +1.789109874e-05f, +5.480150053e-05f, +9.969721340e-05f, +1.458421761e-04f, +1.838620601e-04f, +2.031898472e-04f, +1.941492378e-04f, +1.502930739e-04f, +7.048238377e-05f, -3.982752051e-05f, -1.685145269e-04f, -2.981196454e-04f, -4.084635409e-04f, -4.801254603e-04f, -4.981243193e-04f, -4.550415531e-04f, -3.528946277e-04f, -2.033021755e-04f, -2.582939980e-05f, +1.552117387e-04f, +3.148980846e-04f, +4.319519384e-04f, +4.922774745e-04f, +4.910938247e-04f, +4.332871834e-04f, +3.319848116e-04f, +2.057209625e-04f, +7.483568249e-05f, -4.213497453e-05f, -1.313730568e-04f, -1.854960989e-04f, -2.038722735e-04f, -1.916411728e-04f, -1.578062534e-04f, -1.129141757e-04f, -6.685359483e-05f, -2.720233902e-05f, +1.633825320e-06f, +1.846124455e-05f, +2.467468530e-05f, +2.324695131e-05f, +1.764247584e-05f, +1.091881357e-05f,
    /*  1, 5 (48) */
    -4.439884703e-04f, -6.839332393e-04f, -9.291054171e-04f, -1.129315731e-03f, -1.215523855e-03f, -1.101569931e-03f, -6.882696471e-04f, +1.301495090e-04f, +1.457574517e-03f, +3.386079964e-03f, +5.985377344e-03f, +9.292645361e-03f, +1.330382439e-02f, +1.796742122e-02f, +2.318171247e-02f, +2.879596596e-02f, +3.461594135e-02f, +4.041352017e-02f, +4.593989350e-02f, +5.094135058e-02f, +5.517640664e-02f, +5.843282187e-02f, +6.054301834e-02f, +6.139650865e-02f, +6.094820002e-02f, +5.922180670e-02f, +5.630805374e-02f, +5.235783912e-02f, +4.757098725e-02f, +4.218162598e-02f, +3.644151000e-02f, +3.060276630e-02f, +2.490154017e-02f, +1.954387566e-02f, +1.469489309e-02f, +1.047196184e-02f, +6.942151189e-03f, +4.123822392e-03f, +1.991846752e-03f, +4.856340025e-04f, -4.810385334e-04f, -1.009480542e-03f, -1.205867910e-03f, -1.172239576e-03f, -9.993784239e-04f, -7.619693040e-04f, -5.161425332e-04f, -2.992482924e-04f,
    +7.021637960e-06f, +7.788372543e-06f, +7.291082698e-06f, +4.937022566e-06f, +1.513745344e-07f, -7.551384381e-06f, -1.849254854e-05f, -3.275912115e-05f, -5.014758269e-05f, -7.012990339e-05f, -9.184856916e-05f, -1.141447587e-04f, -1.356204362e-04f, -1.547313687e-04f, -1.699043667e-04f, -1.796688410e-04f, -1.827904761e-04f, -1.783937689e-04f, -1.660605652e-04f, -1.458935566e-04f, -1.185368387e-04f, -8.514975212e-05f, -4.733489691e-05f, -7.025910221e-06f, +3.365521214e-05f, +7.255825958e-05f, +1.076675748e-04f, +1.372523257e-04f, +1.599904879e-04f, +1.750555188e-04f, +1.821586121e-04f, +1.815440025e-04f, +1.739395284e-04f, +1.604690300e-04f, +1.425366721e-04f, +1.216955923e-04f, +9.951415924e-05f, +7.745255413e-05f, +5.676049434e-05f, +3.840398002e-05f, +2.302535893e-05f, +1.093721356e-05f, +2.147024604e-06f, -3.593355386e-06f, -6.721387745e-06f, -7.789589021e-06f, -7.392058845e-06f, -6.099383813e-06f,
    +6.591871193e-04f, +1.263735077e-03f, +2.024836836e-03f, +2.786215603e-03f, +3.282594178e-03f, +3.162434237e-03f, +2.045333455e-03f, -3.903702877e-04f, -4.304072768e-03f, -9.595929189e-03f, -1.584278643e-02f, -2.229103428e-02f, -2.792131946e-02f, -3.158552758e-02f, -3.219933964e-02f, -2.895799486e-02f, -2.153275388e-02f, -1.020412557e-02f, +4.103499934e-03f, +1.990364802e-02f, +3.534071733e-02f, +4.846510781e-02f, +5.754262086e-02f, +6.134071769e-02f, +5.933665593e-02f, +5.180675194e-02f, +3.977912909e-02f, +2.485930091e-02f, +8.962870652e-03f, -5.992937580e-03f, -1.838092923e-02f, -2.708672161e-02f, -3.162699750e-02f, -3.215035648e-02f, -2.933176886e-02f, -2.419135849e-02f, -1.787984405e-02f, -1.147463225e-02f, -5.822871489e-03f, -1.453411019e-03f, +1.437497513e-03f, +2.937636937e-03f, +3.329277778e-03f, +2.984995501e-03f, +2.273112885e-03f, +1.489920096e-03f, +8.262054424e-04f, +3.662248589e-04f,
    -1.554081285e-05f, -2.178580768e-05f, -2.488684375e-05f, -2.142445762e-05f, -8.159877660e-06f, +1.691293576e-05f, +5.350054635e-05f, +9.823241829e-05f, +1.444694044e-04f, +1.829017706e-04f, +2.029707573e-04f, +1.949369302e-04f, +1.522179874e-04f, +7.348422069e-05f, -3.602331742e-05f, -1.643780583e-04f, -2.942540920e-04f, -4.055074182e-04f, -4.786369835e-04f, -4.984708574e-04f, -4.573177959e-04f, -3.568883141e-04f, -2.085168925e-04f, -3.156206276e-05f, +1.497528627e-04f, +3.104578006e-04f, +4.291018512e-04f, +4.913238229e-04f, +4.920367567e-04f, +4.358376830e-04f, +3.356333310e-04f, +2.098414137e-04f, +7.880208811e-05f, -3.884292954e-05f, -1.290951640e-04f, -1.843589381e-04f, -2.038002702e-04f, -1.924036704e-04f, -1.590862412e-04f, -1.143816183e-04f, -6.822773425e-05f, -2.829208151e-05f, +9.158039886e-07f, +1.810850509e-05f, +2.461398792e-05f, +2.337255185e-05f, +1.784838432e-05f, +1.112210891e-05f,
    /*  1, 6 (48) */
    -4.369668323e-04f, -6.761448667e-04f, -9.218143344e-04f, -1.124378708e-03f, -1.215372481e-03f, -1.109121316e-03f, -7.067621956e-04f, +9.739038789e-05f, +1.407426934e-03f, +3.315950061e-03f, +5.893528775e-03f, +9.178500602e-03f, +1.316820396e-02f, +1.781268985e-02f, +2.301180811e-02f, +2.861629712e-02f, +3.443315088e-02f, +4.023512640e-02f, +4.577383294e-02f, +5.079545702e-02f, +5.505786980e-02f, +5.834767212e-02f, +6.049568345e-02f, +6.138948274e-02f, +6.098185524e-02f, +5.929436496e-02f, +5.641572132e-02f, +5.249509145e-02f, +4.773097773e-02f, +4.235668150e-02f, +3.662366861e-02f, +3.078431030e-02f, +2.507547970e-02f, +1.970434469e-02f, +1.483742976e-02f, +1.059365744e-02f, +7.041665348e-03f, +4.201274946e-03f, +2.048607246e-03f, +5.240379825e-04f, -4.580131745e-04f, -9.985433285e-04f, -1.203720885e-03f, -1.175832932e-03f, -1.006099812e-03f, -7.697588930e-04f, -5.235345920e-04f, -3.053476762e-04f,
    +6.983504168e-06f, +7.780518386e-06f, +7.331620083e-06f, +5.044553124e-06f, +3.428983692e-07f, -7.262793860e-06f, -1.810005886e-05f, -3.226416726e-05f, -4.956132816e-05f, -6.947389279e-05f, -9.115439517e-05f, -1.134526627e-04f, -1.349768747e-04f, -1.541856957e-04f, -1.695048947e-04f, -1.794586306e-04f, -1.828032572e-04f, -1.786504114e-04f, -1.665664791e-04f, -1.466373266e-04f, -1.194902810e-04f, -8.626944199e-05f, -4.856506828e-05f, -8.302483877e-06f, +3.239983159e-05f, +7.139005983e-05f, +1.066459616e-04f, +1.364257588e-04f, +1.593931230e-04f, +1.747051455e-04f, +1.820560435e-04f, +1.816739221e-04f, +1.742726574e-04f, +1.609653496e-04f, +1.431493437e-04f, +1.223751678e-04f, +1.002126668e-04f, +7.812708446e-05f, +5.737599002e-05f, +3.893503281e-05f, +2.345693889e-05f, +1.126437005e-05f, +2.373702808e-06f, -3.456160473e-06f, -6.657870832e-06f, -7.781486633e-06f, -7.420853824e-06f, -6.148150484e-06f,
    +6.436463064e-04f, +1.241949270e-03f, +1.999949993e-03f, +2.764791145e-03f, +3.274434301e-03f, +3.179347173e-03f, +2.098834001e-03f, -2.921378694e-04f, -4.159603364e-03f, -9.413027418e-03f, -1.563981567e-02f, -2.209609735e-02f, -2.776910148e-02f, -3.151204336e-02f, -3.223536296e-02f, -2.912237291e-02f, -2.182700797e-02f, -1.060963299e-02f, +3.624862950e-03f, +1.940517716e-02f, +3.488339953e-02f, +4.810821949e-02f, +5.733410396e-02f, +6.130915563e-02f, +5.948640879e-02f, +5.211720974e-02f, +4.020823094e-02f, +2.535062474e-02f, +9.454907409e-03f, -5.557099897e-03f, -1.804529590e-02f, -2.687688019e-02f, -3.154819541e-02f, -3.218919941e-02f, -2.946086403e-02f, -2.437571743e-02f, -1.808364432e-02f, -1.166703592e-02f, -5.981957730e-03f, -1.567792637e-03f, +1.369269778e-03f, +2.909344855e-03f, +3.330193582e-03f, +3.003104006e-03f, +2.297726873e-03f, +1.513292648e-03f, +8.440538267e-04f, +3.773469678e-04f,
    -1.532806871e-05f, -2.162143767e-05f, -2.487095151e-05f, -2.166616976e-05f, -8.747552469e-06f, +1.594627439e-05f, +5.220782014e-05f, +9.676931944e-05f, +1.430891199e-04f, +1.819234847e-04f, +2.027239640e-04f, +1.956903147e-04f, +1.541071826e-04f, +7.645544584e-05f, -3.223797337e-05f, -1.602433145e-04f, -2.903703028e-04f, -4.025137075e-04f, -4.770958382e-04f, -4.987570545e-04f, -4.595353487e-04f, -3.608345123e-04f, -2.137032898e-04f, -3.729040543e-05f, +1.442735657e-04f, +3.059758495e-04f, +4.261958904e-04f, +4.903092966e-04f, +4.929234191e-04f, +4.383447518e-04f, +3.392567061e-04f, +2.139568862e-04f, +8.278196499e-05f, -3.552359748e-05f, -1.267825385e-04f, -1.831863109e-04f, -2.036978274e-04f, -1.931446308e-04f, -1.603551633e-04f, -1.158478390e-04f, -6.960821217e-05f, -2.939256978e-05f, +1.858320897e-07f, +1.774519696e-05f, +2.454568474e-05f, +2.349400520e-05f, +1.805320008e-05f, +1.132641078e-05f,
    /*  1, 7 (48) */
    -4.299833282e-04f, -6.683643483e-04f, -9.144827144e-04f, -1.119334155e-03f, -1.215029582e-03f, -1.116384110e-03f, -7.248622545e-04f, +6.512622063e-05f, +1.357865606e-03f, +3.246476168e-03f, +5.802374380e-03f, +9.065047940e-03f, +1.303322708e-02f, +1.765850416e-02f, +2.284230321e-02f, +2.843683849e-02f, +3.425034762e-02f, +4.005647599e-02f, +4.560726646e-02f, +5.064881970e-02f, +5.493837952e-02f, +5.826140268e-02f, +6.044711838e-02f, +6.138118026e-02f, +6.101425507e-02f, +5.936575502e-02f, +5.652236728e-02f, +5.263151721e-02f, +4.789037086e-02f, +4.253138664e-02f, +3.680572465e-02f, +3.096598422e-02f, +2.524975236e-02f, +1.986531004e-02f, +1.498057911e-02f, +1.071603260e-02f, +7.141878015e-03f, +4.279402031e-03f, +2.105983236e-03f, +5.629730153e-04f, -4.345562356e-04f, -9.872789584e-04f, -1.201347182e-03f, -1.179289092e-03f, -1.012757683e-03f, -7.775403796e-04f, -5.309554459e-04f, -3.114958267e-04f,
    +6.944696012e-06f, +7.771451312e-06f, +7.370361214e-06f, +5.149718660e-06f, +5.315730174e-07f, -6.977378204e-06f, -1.771084180e-05f, -3.177229965e-05f, -4.897765493e-05f, -6.881963368e-05f, -9.046084446e-05f, -1.127598233e-04f, -1.343310549e-04f, -1.536362162e-04f, -1.691001640e-04f, -1.792419368e-04f, -1.828086792e-04f, -1.788992659e-04f, -1.670646871e-04f, -1.473740055e-04f, -1.204377551e-04f, -8.738472583e-05f, -4.979272550e-05f, -9.578625365e-06f, +3.114276840e-05f, +7.021819019e-05f, +1.056189673e-04f, +1.355924986e-04f, +1.587882379e-04f, +1.743469537e-04f, +1.819458831e-04f, +1.817969543e-04f, +1.745999956e-04f, +1.614572536e-04f, +1.437591249e-04f, +1.230533962e-04f, +1.009112666e-04f, +7.880294129e-05f, +5.799376832e-05f, +3.946900620e-05f, +2.389175254e-05f, +1.159477218e-05f, +2.603385740e-06f, -3.316389466e-06f, -6.592321062e-06f, -7.771936700e-06f, -7.448764252e-06f, -6.196522682e-06f,
    +6.283182377e-04f, +1.220327832e-03f, +1.975079041e-03f, +2.743124976e-03f, +3.265686748e-03f, +3.195293448e-03f, +2.151041821e-03f, -1.953685500e-04f, -4.016514244e-03f, -9.231103934e-03f, -1.543709171e-02f, -2.190040704e-02f, -2.761499429e-02f, -3.143558792e-02f, -3.226760093e-02f, -2.928261623e-02f, -2.211737827e-02f, -1.101214670e-02f, +3.147767112e-03f, +1.890642011e-02f, +3.442386419e-02f, +4.774738498e-02f, +5.712040067e-02f, +6.127186522e-02f, +5.963068236e-02f, +5.242318559e-02f, +4.063442683e-02f, +2.584093403e-02f, +9.947830828e-03f, -5.118755146e-03f, -1.770603919e-02f, -2.666292331e-02f, -3.146541345e-02f, -3.222472301e-02f, -2.958764656e-02f, -2.455890374e-02f, -1.828734215e-02f, -1.186018055e-02f, -6.142312893e-03f, -1.683640476e-03f, +1.299661566e-03f, +2.879952286e-03f, +3.330379414e-03f, +3.020849203e-03f, +2.322272557e-03f, +1.536786653e-03f, +8.621070268e-04f, +3.886733786e-04f,
    -1.511514789e-05f, -2.145415145e-05f, -2.484874698e-05f, -2.189829870e-05f, -9.323540560e-06f, +1.499116485e-05f, +5.092347434e-05f, +9.530816669e-05f, +1.417016390e-04f, +1.809275301e-04f, +2.024497358e-04f, +1.964095286e-04f, +1.559606090e-04f, +7.939579618e-05f, -2.847194725e-05f, -1.561108897e-04f, -2.864689115e-04f, -3.994829673e-04f, -4.755023974e-04f, -4.989830154e-04f, -4.616940118e-04f, -3.647327390e-04f, -2.188606756e-04f, -4.301364407e-05f, +1.387745892e-04f, +3.014528043e-04f, +4.232343676e-04f, +4.892339038e-04f, +4.937535320e-04f, +4.408078890e-04f, +3.428543174e-04f, +2.180667583e-04f, +8.677479417e-05f, -3.217731919e-05f, -1.244353095e-04f, -1.819781453e-04f, -2.035647178e-04f, -1.938637399e-04f, -1.616126915e-04f, -1.173125582e-04f, -7.099483771e-05f, -3.050371628e-05f, -5.560964085e-07f, +1.737124731e-05f, +2.446967027e-05f, +2.361120550e-05f, +1.825684027e-05f, +1.153167060e-05f,
    /*  1, 8 (48) */
    -4.230386322e-04f, -6.605928970e-04f, -9.071123531e-04f, -1.114184437e-03f, -1.214498009e-03f, -1.123361488e-03f, -7.425730963e-04f, +3.335392098e-05f, +1.308887951e-03f, +3.177656534e-03f, +5.711913535e-03f, +8.952288116e-03f, +1.289889603e-02f, +1.750486794e-02f, +2.267320305e-02f, +2.825759655e-02f, +3.406753894e-02f, +3.987757672e-02f, +4.544020177e-02f, +5.050144569e-02f, +5.481794176e-02f, +5.817401795e-02f, +6.039732565e-02f, +6.137160163e-02f, +6.104539784e-02f, +5.943597321e-02f, +5.662798625e-02f, +5.276710971e-02f, +4.804915909e-02f, +4.270573360e-02f, +3.698767054e-02f, +3.114778118e-02f, +2.542435236e-02f, +2.002676730e-02f, +1.512433823e-02f, +1.083908600e-02f, +7.242789281e-03f, +4.358204972e-03f, +2.163977005e-03f, +6.024420215e-04f, -4.106644831e-04f, -9.756841862e-04f, -1.198743797e-03f, -1.182605482e-03f, -1.019350004e-03f, -7.853123163e-04f, -5.384042101e-04f, -3.176923494e-04f,
    +6.905229076e-06f, +7.761189099e-06f, +7.407324442e-06f, +5.252536049e-06f, +7.174115923e-07f, -6.695130348e-06f, -1.732489835e-05f, -3.128352883e-05f, -4.839658372e-05f, -6.816715673e-05f, -8.976795629e-05f, -1.120662859e-04f, -1.336830254e-04f, -1.530829779e-04f, -1.686902173e-04f, -1.790187932e-04f, -1.828067631e-04f, -1.791403384e-04f, -1.675551786e-04f, -1.481035659e-04f, -1.213792189e-04f, -8.849554918e-05f, -5.101780578e-05f, -1.085426828e-05f, +2.988408757e-05f, +6.904270931e-05f, +1.045866398e-04f, +1.347525789e-04f, +1.581758507e-04f, +1.739809448e-04f, +1.818281164e-04f, +1.819130706e-04f, +1.749215037e-04f, +1.619446962e-04f, +1.443659673e-04f, +1.237302304e-04f, +1.016099164e-04f, +7.948008996e-05f, +5.861380406e-05f, +4.000588521e-05f, +2.432979486e-05f, +1.192842370e-05f, +2.836084140e-06f, -3.174026850e-06f, -6.524720458e-06f, -7.760920964e-06f, -7.475773419e-06f, -6.244486575e-06f,
    +6.132030899e-04f, +1.198873681e-03f, +1.950230294e-03f, +2.721226677e-03f, +3.256363208e-03f, +3.210284612e-03f, +2.201965296e-03f, -1.000603833e-04f, -3.874812605e-03f, -9.050176404e-03f, -1.523464198e-02f, -2.170399751e-02f, -2.745903369e-02f, -3.135619212e-02f, -3.229607288e-02f, -2.943872712e-02f, -2.240384718e-02f, -1.141162967e-02f, +2.672264714e-03f, +1.840743709e-02f, +3.396217017e-02f, +4.738265224e-02f, +5.690154000e-02f, +6.122885158e-02f, +5.976945695e-02f, +5.272463839e-02f, +4.105766120e-02f, +2.633016794e-02f, +1.044158436e-02f, -4.677947257e-03f, -1.736318488e-02f, -2.644485655e-02f, -3.137863865e-02f, -3.225690033e-02f, -2.971208187e-02f, -2.474088189e-02f, -1.849090686e-02f, -1.205404429e-02f, -6.303925585e-03f, -1.800953034e-03f, +1.228666729e-03f, +2.849448569e-03f, +3.329823318e-03f, +3.038220450e-03f, +2.346742228e-03f, +1.560397859e-03f, +8.803638670e-04f, +4.002050492e-04f,
    -1.490211996e-05f, -2.128404769e-05f, -2.482033930e-05f, -2.212093478e-05f, -9.887878991e-06f, +1.404765433e-05f, +4.964765813e-05f, +9.384920717e-05f, +1.403072766e-04f, +1.799142352e-04f, +2.021483440e-04f, +1.970947142e-04f, +1.577782226e-04f, +8.230501533e-05f, -2.472569254e-05f, -1.519813755e-04f, -2.825505523e-04f, -3.964157603e-04f, -4.738570412e-04f, -4.991488536e-04f, -4.637935950e-04f, -3.685825189e-04f, -2.239883633e-04f, -4.873099576e-05f, +1.332566780e-04f, +2.968892447e-04f, +4.202176034e-04f, +4.880976622e-04f, +4.945268237e-04f, +4.432265991e-04f, +3.464255475e-04f, +2.221704064e-04f, +9.078005214e-05f, -2.880444182e-05f, -1.220536131e-04f, -1.807343748e-04f, -2.034007180e-04f, -1.945606850e-04f, -1.628584972e-04f, -1.187754937e-04f, -7.238741685e-05f, -3.162543024e-05f, -1.309984952e-06f, +1.698658485e-05f, +2.438583951e-05f, +2.372404648e-05f, +1.845922109e-05f, +1.173783863e-05f,
    /*  1, 9 (48) */
    -4.161334031e-04f, -6.528317079e-04f, -8.997050287e-04f, -1.108931901e-03f, -1.213780598e-03f, -1.130056618e-03f, -7.598979946e-04f, +2.070392152e-06f, +1.260491367e-03f, +3.109489377e-03f, +5.622145579e-03f, +8.840221830e-03f, +1.276521300e-02f, +1.735178496e-02f, +2.250451283e-02f, +2.807857776e-02f, +3.388473218e-02f, +3.969843638e-02f, +4.527264659e-02f, +5.035334212e-02f, +5.469656255e-02f, +5.808552240e-02f, +6.034630785e-02f, +6.136074737e-02f, +6.107528192e-02f, +5.950501592e-02f, +5.673257289e-02f, +5.290186229e-02f, +4.820733494e-02f, +4.287971454e-02f, +3.716949865e-02f, +3.132969425e-02f, +2.559927386e-02f, +2.018871199e-02f, +1.526870420e-02f, +1.096281623e-02f, +7.344399198e-03f, +4.437685062e-03f, +2.222590809e-03f, +6.424479067e-04f, -3.863346882e-04f, -9.637557625e-04f, -1.195907712e-03f, -1.185779509e-03f, -1.025874724e-03f, -7.930732373e-04f, -5.458799835e-04f, -3.239368359e-04f,
    +6.865118852e-06f, +7.749749481e-06f, +7.442528130e-06f, +5.353022246e-06f, +9.004273601e-07f, -6.416043006e-06f, -1.694222924e-05f, -3.079786504e-05f, -4.781813497e-05f, -6.751649231e-05f, -8.907576968e-05f, -1.113720959e-04f, -1.330328344e-04f, -1.525260286e-04f, -1.682750973e-04f, -1.787892338e-04f, -1.827975304e-04f, -1.793736353e-04f, -1.680379435e-04f, -1.488259813e-04f, -1.223146305e-04f, -8.960185788e-05f, -5.224024653e-05f, -1.212934627e-05f, +2.862385418e-05f, +6.786367609e-05f, +1.035490276e-04f, +1.339060344e-04f, +1.575559798e-04f, +1.736071204e-04f, +1.817027291e-04f, +1.820222430e-04f, +1.752371429e-04f, +1.624276316e-04f, +1.449698222e-04f, +1.244056229e-04f, +1.023085737e-04f, +8.015849554e-05f, +5.923607174e-05f, +4.054565455e-05f, +2.477106051e-05f, +1.226532812e-05f, +3.071808559e-06f, -3.029057220e-06f, -6.455051086e-06f, -7.748421147e-06f, -7.501864540e-06f, -6.292028226e-06f,
    +5.983009699e-04f, +1.177589633e-03f, +1.925409955e-03f, +2.699105742e-03f, +3.246475329e-03f, +3.224332267e-03f, +2.251612954e-03f, -6.211176122e-06f, -3.734505328e-03f, -8.870262169e-03f, -1.503249363e-02f, -2.150690279e-02f, -2.730125546e-02f, -3.127388711e-02f, -3.232079857e-02f, -2.959070849e-02f, -2.268639774e-02f, -1.180804543e-02f, +2.198407673e-03f, +1.790828824e-02f, +3.349837658e-02f, +4.701406972e-02f, +5.667755164e-02f, +6.118012058e-02f, +5.990271363e-02f, +5.302152764e-02f, +4.147787880e-02f, +2.681826560e-02f, +1.093611118e-02f, -4.234720657e-03f, -1.701675933e-02f, -2.622268614e-02f, -3.128785860e-02f, -3.228570477e-02f, -2.983413549e-02f, -2.492161626e-02f, -1.869430758e-02f, -1.224860498e-02f, -6.466784082e-03f, -1.919728528e-03f, +1.156279312e-03f, +2.817823139e-03f, +3.328513333e-03f, +3.055207035e-03f, +2.371128067e-03f, +1.584121905e-03f, +8.988230881e-04f, +4.119428878e-04f,
    -1.468905343e-05f, -2.111122436e-05f, -2.478583769e-05f, -2.233416943e-05f, -1.044060700e-05f, +1.311578707e-05f, +4.838051740e-05f, +9.239268525e-05f, +1.389063463e-04f, +1.788839288e-04f, +2.018200630e-04f, +1.977460188e-04f, +1.595599860e-04f, +8.518285353e-05f, -2.099965721e-05f, -1.478553601e-04f, -2.786158599e-04f, -3.933126532e-04f, -4.721601571e-04f, -4.992546924e-04f, -4.658339177e-04f, -3.723833847e-04f, -2.290856711e-04f, -5.444167862e-05f, +1.277205798e-04f, +2.922857573e-04f, +4.171459276e-04f, +4.869005993e-04f, +4.952430311e-04f, +4.456003923e-04f, +3.499697813e-04f, +2.262672056e-04f, +9.479721092e-05f, -2.540531878e-05f, -1.196375918e-04f, -1.794549389e-04f, -2.032056088e-04f, -1.952351551e-04f, -1.640922509e-04f, -1.202363612e-04f, -7.378575245e-05f, -3.275761770e-05f, -2.075834377e-06f, +1.659113991e-05f, +2.429408800e-05f, +2.383242151e-05f, +1.866025781e-05f, +1.194486404e-05f,
    /*  1,10 (48) */
    -4.092682842e-04f, -6.450819584e-04f, -8.922625006e-04f, -1.103578878e-03f, -1.212880170e-03f, -1.136472661e-03f, -7.768402239e-04f, -2.872747289e-05f, +1.212673232e-03f, +3.041972885e-03f, +5.533069809e-03f, +8.728849735e-03f, +1.263218017e-02f, +1.719925894e-02f, +2.233623773e-02f, +2.789978852e-02f, +3.370193465e-02f, +3.951906275e-02f, +4.510460865e-02f, +5.020451614e-02f, +5.457424791e-02f, +5.799592054e-02f, +6.029406760e-02f, +6.134861802e-02f, +6.110390578e-02f, +5.957287960e-02f, +5.683612192e-02f, +5.303576832e-02f, +4.836489092e-02f, +4.305332166e-02f, +3.735120138e-02f, +3.151171649e-02f, +2.577451100e-02f, +2.035113962e-02f, +1.541367402e-02f, +1.108722185e-02f, +7.446707771e-03f, +4.517843558e-03f, +2.281826881e-03f, +6.829935612e-04f, -3.615636277e-04f, -9.514904344e-04f, -1.192835904e-03f, -1.188808566e-03f, -1.032329775e-03f, -8.008216584e-04f, -5.533818481e-04f, -3.302288642e-04f,
    +6.824380746e-06f, +7.737150143e-06f, +7.475990650e-06f, +5.451194286e-06f, +1.080633738e-06f, -6.140108674e-06f, -1.656283491e-05f, -3.031531818e-05f, -4.724232877e-05f, -6.686767051e-05f, -8.838432342e-05f, -1.106772984e-04f, -1.323805306e-04f, -1.519654159e-04f, -1.678548470e-04f, -1.785532927e-04f, -1.827810030e-04f, -1.795991635e-04f, -1.685129721e-04f, -1.495412255e-04f, -1.232439486e-04f, -9.070359815e-05f, -5.345998535e-05f, -1.340379299e-05f, +2.736213345e-05f, +6.668114971e-05f, +1.025061794e-04f, +1.330529000e-04f, +1.569286442e-04f, +1.732254828e-04f, +1.815697075e-04f, +1.821244437e-04f, +1.755468747e-04f, +1.629060141e-04f, +1.455706410e-04f, +1.250795263e-04f, +1.030071957e-04f, +8.083812284e-05f, +5.986054554e-05f, +4.108829861e-05f, +2.521554387e-05f, +1.260548869e-05f, +3.310569361e-06f, -2.881465290e-06f, -6.383295056e-06f, -7.734418951e-06f, -7.527020764e-06f, -6.339133594e-06f,
    +5.836119165e-04f, +1.156478409e-03f, +1.900624117e-03f, +2.676771573e-03f, +3.236034722e-03f, +3.237448054e-03f, +2.299993471e-03f, +8.618150913e-05f, -3.595598982e-03f, -8.691378240e-03f, -1.483067357e-02f, -2.130915678e-02f, -2.714169548e-02f, -3.118870425e-02f, -3.234179823e-02f, -2.973856385e-02f, -2.296501360e-02f, -1.220135808e-02f, +1.726247516e-03f, +1.740903355e-02f, +3.303254266e-02f, +4.664168634e-02f, +5.644846596e-02f, +6.112567891e-02f, +6.003043421e-02f, +5.331381339e-02f, +4.189502473e-02f, +2.730516620e-02f, +1.143135421e-02f, -3.789120265e-03f, -1.666678955e-02f, -2.599641894e-02f, -3.119306139e-02f, -3.231111009e-02f, -2.995377308e-02f, -2.510107120e-02f, -1.889751319e-02f, -1.244384013e-02f, -6.630876333e-03f, -2.039964889e-03f, +1.082493559e-03f, +2.785065521e-03f, +3.326437498e-03f, +3.071798175e-03f, +2.395422155e-03f, +1.607954327e-03f, +9.174833459e-04f, +4.238877519e-04f,
    -1.447601573e-05f, -2.093577875e-05f, -2.474535144e-05f, -2.253809516e-05f, -1.098176596e-05f, +1.219560428e-05f, +4.712219483e-05f, +9.093884253e-05f, +1.374991601e-04f, +1.778369407e-04f, +2.014651700e-04f, +1.983635946e-04f, +1.613058679e-04f, +8.802906768e-05f, -1.729428370e-05f, -1.437334289e-04f, -2.746654690e-04f, -3.901742165e-04f, -4.704121395e-04f, -4.993006637e-04f, -4.678148086e-04f, -3.761348771e-04f, -2.341519224e-04f, -6.014491190e-05f, +1.221670459e-04f, +2.876429354e-04f, +4.140196788e-04f, +4.856427518e-04f, +4.959018989e-04f, +4.479287843e-04f, +3.534864055e-04f, +2.303565294e-04f, +9.882573812e-05f, -2.198030972e-05f, -1.171873950e-04f, -1.781397830e-04f, -2.029791747e-04f, -1.958868412e-04f, -1.653136230e-04f, -1.216948744e-04f, -7.518964427e-05f, -3.390018149e-05f, -2.853642879e-06f, +1.618484449e-05f, +2.419431183e-05f, +2.393622360e-05f, +1.885986474e-05f, +1.215269488e-05f,
    /*  1,11 (48) */
    -4.024439035e-04f, -6.373448083e-04f, -8.847865099e-04f, -1.098127684e-03f, -1.211799537e-03f, -1.142612770e-03f, -7.934030588e-04f, -5.904279106e-05f, +1.165430903e-03f, +2.975105214e-03f, +5.444685486e-03f, +8.618172436e-03f, +1.249979964e-02f, +1.704729352e-02f, +2.216838289e-02f, +2.772123523e-02f, +3.351915364e-02f, +3.933946359e-02f, +4.493609568e-02f, +5.005497492e-02f, +5.445100397e-02f, +5.790521695e-02f, +6.024060761e-02f, +6.133521423e-02f, +6.113126791e-02f, +5.963956075e-02f, +5.693862809e-02f, +5.316882122e-02f, +4.852181957e-02f, +4.322654714e-02f, +3.753277109e-02f, +3.169384093e-02f, +2.595005788e-02f, +2.051404564e-02f, +1.555924466e-02f, +1.121230138e-02f, +7.549714967e-03f, +4.598681680e-03f, +2.341687426e-03f, +7.240818599e-04f, -3.363480838e-04f, -9.388849457e-04f, -1.189525335e-03f, -1.191690031e-03f, -1.038713070e-03f, -8.085560774e-04f, -5.609088688e-04f, -3.365679977e-04f,
    +6.783030070e-06f, +7.723408718e-06f, +7.507730380e-06f, +5.547069277e-06f, +1.258044290e-06f, -5.867319628e-06f, -1.618671553e-05f, -2.983589784e-05f, -4.666918493e-05f, -6.622072111e-05f, -8.769365605e-05f, -1.099819384e-04f, -1.317261621e-04f, -1.514011878e-04f, -1.674295098e-04f, -1.783110046e-04f, -1.827572033e-04f, -1.798169304e-04f, -1.689802556e-04f, -1.502492729e-04f, -1.241671324e-04f, -9.180071650e-05f, -5.467696004e-05f, -1.467754219e-05f, +2.609899070e-05f, +6.549518960e-05f, +1.014581444e-04f, +1.321932110e-04f, +1.562938633e-04f, +1.728360349e-04f, +1.814290384e-04f, +1.822196454e-04f, +1.758506607e-04f, +1.633797983e-04f, +1.461683752e-04f, +1.257518931e-04f, +1.037057395e-04f, +8.151893637e-05f, +6.048719935e-05f, +4.163380147e-05f, +2.566323901e-05f, +1.294890841e-05f, +3.552376721e-06f, -2.731235893e-06f, -6.309434527e-06f, -7.718896060e-06f, -7.551225169e-06f, -6.385788534e-06f,
    +5.691359007e-04f, +1.135542630e-03f, +1.875878766e-03f, +2.654233478e-03f, +3.225052956e-03f, +3.249643658e-03f, +2.347115666e-03f, +1.771203517e-04f, -3.458099822e-03f, -8.513541299e-03f, -1.462920840e-02f, -2.111079318e-02f, -2.698038961e-02f, -3.110067518e-02f, -3.235909251e-02f, -2.988229728e-02f, -2.323967906e-02f, -1.259153230e-02f, +1.255835377e-03f, +1.690973288e-02f, +3.256472785e-02f, +4.626555146e-02f, +5.621431404e-02f, +6.106553399e-02f, +6.015260125e-02f, +5.360145633e-02f, +4.230904441e-02f, +2.779080895e-02f, +1.192725611e-02f, -3.341191481e-03f, -1.631330314e-02f, -2.576606241e-02f, -3.109423565e-02f, -3.233309040e-02f, -3.007096047e-02f, -2.527921098e-02f, -1.910049237e-02f, -1.263972698e-02f, -6.796189956e-03f, -2.161659764e-03f, +1.007303915e-03f, +2.751165340e-03f, +3.323583856e-03f, +3.087983019e-03f, +2.419616467e-03f, +1.631890550e-03f, +9.363432107e-04f, +4.360404467e-04f,
    -1.426307319e-05f, -2.075780740e-05f, -2.469898981e-05f, -2.273280550e-05f, -1.151139937e-05f, +1.128714424e-05f, +4.587282982e-05f, +8.948791782e-05f, +1.360860288e-04f, +1.767736006e-04f, +2.010839449e-04f, +1.989475989e-04f, +1.630158436e-04f, +9.084342132e-05f, -1.361000888e-05f, -1.396161639e-04f, -2.707000147e-04f, -3.870010247e-04f, -4.686133899e-04f, -4.992869089e-04f, -4.697361063e-04f, -3.798365454e-04f, -2.391864458e-04f, -6.583991611e-05f, +1.165968301e-04f, +2.829613790e-04f, +4.108392049e-04f, +4.843241664e-04f, +4.965031808e-04f, +4.502112968e-04f, +3.569748093e-04f, +2.344377501e-04f, +1.028650970e-04f, -1.852978049e-05f, -1.147031788e-04f, -1.767888582e-04f, -2.027212045e-04f, -1.965154358e-04f, -1.665222834e-04f, -1.231507447e-04f, -7.659888899e-05f, -3.505302122e-05f, -3.643405993e-06f, +1.576763225e-05f, +2.408640770e-05f, +2.403534541e-05f, +1.905795531e-05f, +1.236127806e-05f,
    /*  1,12 (48) */
    -3.956608734e-04f, -6.296213996e-04f, -8.772787795e-04f, -1.092580615e-03f, -1.210541492e-03f, -1.148480090e-03f, -8.095897743e-04f, -8.887868891e-05f, +1.118761719e-03f, +2.908884493e-03f, +5.356991830e-03f, +8.508190498e-03f, +1.236807348e-02f, +1.689589233e-02f, +2.200095338e-02f, +2.754292423e-02f, +3.333639644e-02f, +3.915964666e-02f, +4.476711542e-02f, +4.990472564e-02f, +5.432683683e-02f, +5.781341623e-02f, +6.018593065e-02f, +6.132053668e-02f, +6.115736690e-02f, +5.970505594e-02f, +5.704008624e-02f, +5.330101443e-02f, +4.867811343e-02f, +4.339938318e-02f, +3.771420013e-02f, +3.187606058e-02f, +2.612590854e-02f, +2.067742544e-02f, +1.570541304e-02f, +1.133805327e-02f, +7.653420706e-03f, +4.680200617e-03f, +2.402174625e-03f, +7.657156613e-04f, -3.106848448e-04f, -9.259360373e-04f, -1.185972958e-03f, -1.194421267e-03f, -1.045022505e-03f, -8.162749735e-04f, -5.684600940e-04f, -3.429537863e-04f,
    +6.741082046e-06f, +7.708542790e-06f, +7.537765705e-06f, +5.640664402e-06f, +1.432672729e-06f, -5.597667930e-06f, -1.581387101e-05f, -2.935961333e-05f, -4.609872289e-05f, -6.557567358e-05f, -8.700380586e-05f, -1.092860609e-04f, -1.310697774e-04f, -1.508333922e-04f, -1.669991291e-04f, -1.780624044e-04f, -1.827261540e-04f, -1.800269439e-04f, -1.694397852e-04f, -1.509500984e-04f, -1.250841413e-04f, -9.289315982e-05f, -5.589110862e-05f, -1.595052764e-05f, +2.483449136e-05f, +6.430585546e-05f, +1.004049721e-04f, +1.313270034e-04f, +1.556516572e-04f, +1.724387800e-04f, +1.812807091e-04f, +1.823078213e-04f, +1.761484629e-04f, +1.638489388e-04f, +1.467629763e-04f, +1.264226756e-04f, +1.044041619e-04f, +8.220090042e-05f, +6.111600674e-05f, +4.218214685e-05f, +2.611413971e-05f, +1.329559004e-05f, +3.797240619e-06f, -2.578353981e-06f, -6.233451705e-06f, -7.701834142e-06f, -7.574460766e-06f, -6.431978801e-06f,
    +5.548728275e-04f, +1.114784822e-03f, +1.851179776e-03f, +2.631500672e-03f, +3.213541556e-03f, +3.260930802e-03f, +2.392988496e-03f, +2.666082695e-04f, -3.322013793e-03f, -8.336767698e-03f, -1.442812445e-02f, -2.091184558e-02f, -2.681737377e-02f, -3.100983176e-02f, -3.237270252e-02f, -3.002191345e-02f, -2.351037908e-02f, -1.297853332e-02f, +7.872219866e-04f, +1.641044598e-02f, +3.209499175e-02f, +4.588571491e-02f, +5.597512760e-02f, +6.099969408e-02f, +6.026919808e-02f, +5.388441771e-02f, +4.271988361e-02f, +2.827513312e-02f, +1.242375929e-02f, -2.890980184e-03f, -1.595632833e-02f, -2.553162466e-02f, -3.099137055e-02f, -3.235162018e-02f, -3.018566365e-02f, -2.545599984e-02f, -1.930321357e-02f, -1.283624241e-02f, -6.962712239e-03f, -2.284810508e-03f, +9.307050260e-04f, +2.716112319e-03f, +3.319940450e-03f, +3.103750651e-03f, +2.443702875e-03f, +1.655925896e-03f, +9.554011660e-04f, +4.484017248e-04f,
    -1.405029109e-05f, -2.057740610e-05f, -2.464686208e-05f, -2.291839499e-05f, -1.202955281e-05f, +1.039044230e-05f, +4.463255849e-05f, +8.804014709e-05f, +1.346672613e-04f, +1.756942389e-04f, +2.006766703e-04f, +1.994981936e-04f, +1.646898946e-04f, +9.362568470e-05f, -9.947263949e-06f, -1.355041440e-04f, -2.667201318e-04f, -3.837936558e-04f, -4.667643167e-04f, -4.992135781e-04f, -4.715976586e-04f, -3.834879467e-04f, -2.441885755e-04f, -7.152591317e-05f, +1.110106893e-04f, +2.782416943e-04f, +4.076048624e-04f, +4.829448989e-04f, +4.970466386e-04f, +4.524474573e-04f, +3.604343844e-04f, +2.385102389e-04f, +1.069147467e-04f, -1.505410309e-05f, -1.121851058e-04f, -1.754021216e-04f, -2.024314911e-04f, -1.971206335e-04f, -1.677179014e-04f, -1.246036813e-04f, -7.801328021e-05f, -3.621603328e-05f, -4.445116563e-06f, +1.533943858e-05f, +2.397027294e-05f, +2.412967932e-05f, +1.925444200e-05f, +1.257055940e-05f,
    /*  1,13 (48) */
    -3.889197914e-04f, -6.219128568e-04f, -8.697410138e-04f, -1.086939950e-03f, -1.209108819e-03f, -1.154077757e-03f, -8.254036453e-04f, -1.182383022e-04f, +1.072662996e-03f, +2.843308820e-03f, +5.269988024e-03f, +8.398904437e-03f, +1.223700370e-02f, +1.674505894e-02f, +2.183395425e-02f, +2.736486182e-02f, +3.315367029e-02f, +3.897961971e-02f, +4.459767564e-02f, +4.975377555e-02f, +5.420175269e-02f, +5.772052307e-02f, +6.013003955e-02f, +6.130458616e-02f, +6.118220139e-02f, +5.976936179e-02f, +5.714049121e-02f, +5.343234143e-02f, +4.883376509e-02f, +4.357182196e-02f, +3.789548084e-02f, +3.205836840e-02f, +2.630205700e-02f, +2.084127438e-02f, +1.585217601e-02f, +1.146447595e-02f, +7.757824868e-03f, +4.762401517e-03f, +2.463290632e-03f, +8.078978082e-04f, -2.845707051e-04f, -9.126404473e-04f, -1.182175717e-03f, -1.196999621e-03f, -1.051255956e-03f, -8.239768076e-04f, -5.760345548e-04f, -3.493857651e-04f,
    +6.698551799e-06f, +7.692569891e-06f, +7.566115013e-06f, +5.731996914e-06f, +1.604532908e-06f, -5.331145428e-06f, -1.544430097e-05f, -2.888647360e-05f, -4.553096181e-05f, -6.493255712e-05f, -8.631481091e-05f, -1.085897106e-04f, -1.304114247e-04f, -1.502620772e-04f, -1.665637486e-04f, -1.778075273e-04f, -1.826878783e-04f, -1.802292123e-04f, -1.698915531e-04f, -1.516436772e-04f, -1.259949353e-04f, -9.398087530e-05f, -5.710236930e-05f, -1.722268318e-05f, +2.356870096e-05f, +6.311320721e-05f, +9.934671235e-05f, +1.304543135e-04f, +1.550020465e-04f, +1.720337218e-04f, +1.811247071e-04f, +1.823889449e-04f, +1.764402438e-04f, +1.643133904e-04f, +1.473543959e-04f, +1.270918263e-04f, +1.051024197e-04f, +8.288397896e-05f, +6.174694096e-05f, +4.273331820e-05f, +2.656823942e-05f, +1.364553606e-05f, +4.045170841e-06f, -2.422804631e-06f, -6.155328848e-06f, -7.683214852e-06f, -7.596710501e-06f, -6.477690047e-06f,
    +5.408225365e-04f, +1.094207416e-03f, +1.826532914e-03f, +2.608582277e-03f, +3.201512003e-03f, +3.271321245e-03f, +2.437621054e-03f, +3.546484166e-04f, -3.187346532e-03f, -8.161073460e-03f, -1.422744778e-02f, -2.071234739e-02f, -2.665268387e-02f, -3.091620608e-02f, -3.238264978e-02f, -3.015741759e-02f, -2.377709921e-02f, -1.336232698e-02f, +3.204576699e-04f, +1.591123240e-02f, +3.162339409e-02f, +4.550222697e-02f, +5.573093902e-02f, +6.092816816e-02f, +6.038020877e-02f, +5.416265940e-02f, +4.312748847e-02f, +2.875807801e-02f, +1.292080593e-02f, -2.438532727e-03f, -1.559589395e-02f, -2.529311442e-02f, -3.088445581e-02f, -3.236667428e-02f, -3.029784876e-02f, -2.563140196e-02f, -1.950564506e-02f, -1.303336304e-02f, -7.130430141e-03f, -2.409414189e-03f, +8.526917458e-04f, +2.679896285e-03f, +3.315495333e-03f, +3.119090090e-03f, +2.467673148e-03f, +1.680055575e-03f, +9.746556080e-04f, +4.609722842e-04f,
    -1.383773357e-05f, -2.039466990e-05f, -2.458907746e-05f, -2.309495914e-05f, -1.253627391e-05f, +9.505530872e-06f, +4.340151373e-05f, +8.659576347e-05f, +1.332431650e-04f, +1.745991863e-04f, +2.002436315e-04f, +2.000155457e-04f, +1.663280088e-04f, +9.637563473e-05f, -6.306474398e-06f, -1.313979444e-04f, -2.627264553e-04f, -3.805526914e-04f, -4.648653351e-04f, -4.990808307e-04f, -4.733993232e-04f, -3.870886467e-04f, -2.491576510e-04f, -7.720212654e-05f, +1.054093829e-04f, +2.734844944e-04f, +4.043170167e-04f, +4.815050153e-04f, +4.975320429e-04f, +4.546367993e-04f, +3.638645247e-04f, +2.425733656e-04f, +1.109741421e-04f, -1.155365566e-05f, -1.096333455e-04f, -1.739795362e-04f, -2.021098317e-04f, -1.977021306e-04f, -1.689001464e-04f, -1.260533915e-04f, -7.943260847e-05f, -3.738911081e-05f, -5.258764720e-06f, +1.490020064e-05f, +2.384580553e-05f, +2.421911742e-05f, +1.944923643e-05f, +1.278048359e-05f,
    /*  1,14 (48) */
    -3.822212396e-04f, -6.142202869e-04f, -8.621748988e-04f, -1.081207953e-03f, -1.207504287e-03f, -1.159408903e-03f, -8.408479463e-04f, -1.471247758e-04f, +1.027132034e-03f, +2.778376263e-03f, +5.183673213e-03f, +8.290314726e-03f, +1.210659227e-02f, +1.659479686e-02f, +2.166739050e-02f, +2.718705429e-02f, +3.297098241e-02f, +3.879939050e-02f, +4.442778408e-02f, +4.960213187e-02f, +5.407575776e-02f, +5.762654220e-02f, +6.007293718e-02f, +6.128736347e-02f, +6.120577010e-02f, +5.983247500e-02f, +5.723983792e-02f, +5.356279575e-02f, +4.898876714e-02f, +4.374385568e-02f, +3.807660555e-02f, +3.224075735e-02f, +2.647849724e-02f, +2.100558777e-02f, +1.599953041e-02f, +1.159156778e-02f, +7.862927288e-03f, +4.845285496e-03f, +2.525037573e-03f, +8.506311264e-04f, -2.580024657e-04f, -8.989949112e-04f, -1.178130546e-03f, -1.199422426e-03f, -1.057411285e-03f, -8.316600224e-04f, -5.836312653e-04f, -3.558634551e-04f,
    +6.655454364e-06f, +7.675507496e-06f, +7.592796692e-06f, +5.821084136e-06f, +1.773638826e-06f, -5.067743758e-06f, -1.507800476e-05f, -2.841648733e-05f, -4.496592050e-05f, -6.429140060e-05f, -8.562670900e-05f, -1.078929320e-04f, -1.297511522e-04f, -1.496872908e-04f, -1.661234121e-04f, -1.775464088e-04f, -1.826423998e-04f, -1.804237446e-04f, -1.703355517e-04f, -1.523299854e-04f, -1.268994749e-04f, -9.506381053e-05f, -5.831068052e-05f, -1.849394269e-05f, +2.230168514e-05f, +6.191730505e-05f, +9.828341550e-05f, +1.295751782e-04f, +1.543450521e-04f, +1.716208647e-04f, +1.809610208e-04f, +1.824629900e-04f, +1.767259657e-04f, +1.647731083e-04f, +1.479425855e-04f, +1.277592971e-04f, +1.058004694e-04f, +8.356813575e-05f, +6.237997497e-05f, +4.328729862e-05f, +2.702553133e-05f, +1.399874871e-05f, +4.296176977e-06f, -2.264573046e-06f, -6.075048267e-06f, -7.663019833e-06f, -7.617957255e-06f, -6.522907823e-06f,
    +5.269848029e-04f, +1.073812746e-03f, +1.801943836e-03f, +2.585487318e-03f, +3.188975729e-03f, +3.280826776e-03f, +2.481022568e-03f, +4.412441800e-04f, -3.054103367e-03f, -7.986474273e-03f, -1.402720415e-02f, -2.051233184e-02f, -2.648635586e-02f, -3.081983044e-02f, -3.238895626e-02f, -3.028881553e-02f, -2.403982567e-02f, -1.374287967e-02f, -1.444076651e-04f, +1.541215157e-02f, +3.114999476e-02f, +4.511513832e-02f, +5.548178137e-02f, +6.085096604e-02f, +6.048561815e-02f, +5.443614390e-02f, +4.353180549e-02f, +2.923958303e-02f, +1.341833798e-02f, -1.983895928e-03f, -1.523202942e-02f, -2.505054105e-02f, -3.077348167e-02f, -3.237822794e-02f, -3.040748210e-02f, -2.580538150e-02f, -1.970775489e-02f, -1.323106518e-02f, -7.299330287e-03f, -2.535467581e-03f, +7.732591374e-04f, +2.642507175e-03f, +3.310236568e-03f, +3.133990291e-03f, +2.491518953e-03f, +1.704274692e-03f, +9.941048444e-04f, +4.737527678e-04f,
    -1.362546371e-05f, -2.020969306e-05f, -2.452574511e-05f, -2.326259437e-05f, -1.303161231e-05f, +8.632439490e-06f, +4.217982515e-05f, +8.515499721e-05f, +1.318140456e-04f, +1.734887737e-04f, +1.997851162e-04f, +2.004998266e-04f, +1.679301801e-04f, +9.909305502e-05f, -2.688059979e-06f, -1.272981371e-04f, -2.587196197e-04f, -3.772787163e-04f, -4.629168670e-04f, -4.988888348e-04f, -4.751409672e-04f, -3.906382195e-04f, -2.540930173e-04f, -8.286778134e-05f, +9.979367328e-05f, +2.686903983e-04f, +4.009760422e-04f, +4.800045906e-04f, +4.979591725e-04f, +4.567788623e-04f, +3.672646271e-04f, +2.466264993e-04f, +1.150427340e-04f, -8.028822401e-06f, -1.070480740e-04f, -1.725210712e-04f, -2.017560275e-04f, -1.982596258e-04f, -1.700686873e-04f, -1.274995807e-04f, -8.085666129e-05f, -3.857214372e-05f, -6.084337856e-06f, +1.444985736e-05f, +2.371290417e-05f, +2.430355154e-05f, +1.964224932e-05f, +1.299099421e-05f,
    /*  1,15 (48) */
    -3.755657852e-04f, -6.065447794e-04f, -8.545821021e-04f, -1.075386869e-03f, -1.205730648e-03f, -1.164476647e-03f, -8.559259511e-04f, -1.755412632e-04f, +9.821661133e-04f, +2.714084862e-03f, +5.098046504e-03f, +8.182421794e-03f, +1.197684112e-02f, +1.644510957e-02f, +2.150126709e-02f, +2.700950789e-02f, +3.278834001e-02f, +3.861896676e-02f, +4.425744853e-02f, +4.944980188e-02f, +5.394885828e-02f, +5.753147838e-02f, +6.001462650e-02f, +6.126886953e-02f, +6.122807178e-02f, +5.989439231e-02f, +5.733812134e-02f, +5.369237093e-02f, +4.914311219e-02f, +4.391547655e-02f, +3.825756657e-02f, +3.242322034e-02f, +2.665522321e-02f, +2.117036087e-02f, +1.614747299e-02f, +1.171932707e-02f, +7.968727757e-03f, +4.928853632e-03f, +2.587417548e-03f, +8.939184250e-04f, -2.309769343e-04f, -8.849961625e-04f, -1.173834369e-03f, -1.201686999e-03f, -1.063486334e-03f, -8.393230423e-04f, -5.912492225e-04f, -3.623863630e-04f,
    +6.611804677e-06f, +7.657373026e-06f, +7.617829132e-06f, +5.907943456e-06f, +1.940004617e-06f, -4.807454348e-06f, -1.471498148e-05f, -2.794966288e-05f, -4.440361746e-05f, -6.365223261e-05f, -8.493953768e-05f, -1.071957695e-04f, -1.290890081e-04f, -1.491090813e-04f, -1.656781636e-04f, -1.772790849e-04f, -1.825897425e-04f, -1.806105501e-04f, -1.707717740e-04f, -1.530089992e-04f, -1.277977209e-04f, -9.614191340e-05f, -5.951598093e-05f, -1.976424015e-05f, +2.103350960e-05f, +6.071820940e-05f, +9.721513218e-05f, +1.286896348e-04f, +1.536806957e-04f, +1.712002137e-04f, +1.807896387e-04f, +1.825299310e-04f, +1.770055917e-04f, +1.652280476e-04f, +1.485274967e-04f, +1.284250404e-04f, +1.064982673e-04f, +8.425333425e-05f, +6.301508140e-05f, +4.384407088e-05f, +2.748600830e-05f, +1.435522994e-05f, +4.550268416e-06f, -2.103644554e-06f, -5.992592328e-06f, -7.641230718e-06f, -7.638183844e-06f, -6.567617582e-06f,
    +5.133593392e-04f, +1.053603053e-03f, +1.777418091e-03f, +2.562224724e-03f, +3.175944117e-03f, +3.289459215e-03f, +2.523202393e-03f, +5.263991772e-04f, -2.922289321e-03f, -7.812985500e-03f, -1.382741904e-02f, -2.031183202e-02f, -2.631842568e-02f, -3.072073739e-02f, -3.239164432e-02f, -3.041611367e-02f, -2.429854529e-02f, -1.412015839e-02f, -6.073245321e-04f, +1.491326273e-02f, +3.067485380e-02f, +4.472450010e-02f, +5.522768835e-02f, +6.076809826e-02f, +6.058541183e-02f, +5.470483430e-02f, +4.393278153e-02f, +2.971958762e-02f, +1.391629715e-02f, -1.527117065e-03f, -1.486476480e-02f, -2.480391455e-02f, -3.065843893e-02f, -3.238625676e-02f, -3.051453018e-02f, -2.597790257e-02f, -1.990951092e-02f, -1.342932480e-02f, -7.469398974e-03f, -2.662967162e-03f, +6.924024761e-04f, +2.603935031e-03f, +3.304152230e-03f, +3.148440148e-03f, +2.515231857e-03f, +1.728578244e-03f, +1.013747094e-03f, +4.867437620e-04f,
    -1.341354347e-05f, -2.002256905e-05f, -2.445697407e-05f, -2.342139801e-05f, -1.351561964e-05f, +7.771194801e-06f, +4.096761910e-05f, +8.371807564e-05f, +1.303802073e-04f, +1.723633322e-04f, +1.993014146e-04f, +2.009512126e-04f, +1.694964089e-04f, +1.017777359e-04f, +9.075653692e-07f, -1.232052905e-04f, -2.547002593e-04f, -3.739723191e-04f, -4.609193410e-04f, -4.986377677e-04f, -4.768224673e-04f, -3.941362476e-04f, -2.589940252e-04f, -8.852210449e-05f, +9.416432483e-05f, +2.638600314e-04f, +3.975823219e-04f, +4.784437097e-04f, +4.983278153e-04f, +4.588731922e-04f, +3.706340911e-04f, +2.506690081e-04f, +1.191199691e-04f, -4.479993558e-06f, -1.044294743e-04f, -1.710267017e-04f, -2.013698844e-04f, -1.987928195e-04f, -1.712231930e-04f, -1.289419522e-04f, -8.228522318e-05f, -3.976501868e-05f, -6.921820601e-06f, +1.398834949e-05f, +2.357146827e-05f, +2.438287329e-05f, +1.983339052e-05f, +1.320203372e-05f,
    /*  1,16 (48) */
    -3.689539805e-04f, -5.988874064e-04f, -8.469642730e-04f, -1.069478926e-03f, -1.203790643e-03f, -1.169284101e-03f, -8.706409326e-04f, -2.034909260e-04f, +9.377624959e-04f, +2.650432629e-03f, +5.013106966e-03f, +8.075226025e-03f, +1.184775211e-02f, +1.629600049e-02f, +2.133558892e-02f, +2.683222880e-02f, +3.260575027e-02f, +3.843835620e-02f, +4.408667676e-02f, +4.929679288e-02f, +5.382106056e-02f, +5.743533647e-02f, +5.995511052e-02f, +6.124910529e-02f, +6.124910529e-02f, +5.995511052e-02f, +5.743533647e-02f, +5.382106056e-02f, +4.929679288e-02f, +4.408667676e-02f, +3.843835620e-02f, +3.260575027e-02f, +2.683222880e-02f, +2.133558892e-02f, +1.629600049e-02f, +1.184775211e-02f, +8.075226025e-03f, +5.013106966e-03f, +2.650432629e-03f, +9.377624959e-04f, -2.034909260e-04f, -8.706409326e-04f, -1.169284101e-03f, -1.203790643e-03f, -1.069478926e-03f, -8.469642730e-04f, -5.988874064e-04f, -3.689539805e-04f,
    +6.567617582e-06f, +7.638183844e-06f, +7.641230718e-06f, +5.992592328e-06f, +2.103644554e-06f, -4.550268416e-06f, -1.435522994e-05f, -2.748600830e-05f, -4.384407088e-05f, -6.301508140e-05f, -8.425333425e-05f, -1.064982673e-04f, -1.284250404e-04f, -1.485274967e-04f, -1.652280476e-04f, -1.770055917e-04f, -1.825299310e-04f, -1.807896387e-04f, -1.712002137e-04f, -1.536806957e-04f, -1.286896348e-04f, -9.721513218e-05f, -6.071820940e-05f, -2.103350960e-05f, +1.976424015e-05f, +5.951598093e-05f, +9.614191340e-05f, +1.277977209e-04f, +1.530089992e-04f, +1.707717740e-04f, +1.806105501e-04f, +1.825897425e-04f, +1.772790849e-04f, +1.656781636e-04f, +1.491090813e-04f, +1.290890081e-04f, +1.071957695e-04f, +8.493953768e-05f, +6.365223261e-05f, +4.440361746e-05f, +2.794966288e-05f, +1.471498148e-05f, +4.807454348e-06f, -1.940004617e-06f, -5.907943456e-06f, -7.617829132e-06f, -7.657373026e-06f, -6.611804677e-06f,
    +4.999457957e-04f, +1.033580484e-03f, +1.752961117e-03f, +2.538803326e-03f, +3.162428497e-03f, +3.297230410e-03f, +2.564170012e-03f, +6.101172529e-04f, -2.791909114e-03f, -7.640622167e-03f, -1.362811762e-02f, -2.011088080e-02f, -2.614892927e-02f, -3.061895965e-02f, -3.239073675e-02f, -3.053931896e-02f, -2.455324555e-02f, -1.449413070e-02f, -1.068243873e-03f, +1.441462496e-02f, +3.019803133e-02f, +4.433036385e-02f, +5.496869433e-02f, +6.067957615e-02f, +6.067957615e-02f, +5.496869433e-02f, +4.433036385e-02f, +3.019803133e-02f, +1.441462496e-02f, -1.068243873e-03f, -1.449413070e-02f, -2.455324555e-02f, -3.053931896e-02f, -3.239073675e-02f, -3.061895965e-02f, -2.614892927e-02f, -2.011088080e-02f, -1.362811762e-02f, -7.640622167e-03f, -2.791909114e-03f, +6.101172529e-04f, +2.564170012e-03f, +3.297230410e-03f, +3.162428497e-03f, +2.538803326e-03f, +1.752961117e-03f, +1.033580484e-03f, +4.999457957e-04f,
    -1.320203372e-05f, -1.983339052e-05f, -2.438287329e-05f, -2.357146827e-05f, -1.398834949e-05f, +6.921820601e-06f, +3.976501868e-05f, +8.228522318e-05f, +1.289419522e-04f, +1.712231930e-04f, +1.987928195e-04f, +2.013698844e-04f, +1.710267017e-04f, +1.044294743e-04f, +4.479993558e-06f, -1.191199691e-04f, -2.506690081e-04f, -3.706340911e-04f, -4.588731922e-04f, -4.983278153e-04f, -4.784437097e-04f, -3.975823219e-04f, -2.638600314e-04f, -9.416432483e-05f, +8.852210449e-05f, +2.589940252e-04f, +3.941362476e-04f, +4.768224673e-04f, +4.986377677e-04f, +4.609193410e-04f, +3.739723191e-04f, +2.547002593e-04f, +1.232052905e-04f, -9.075653692e-07f, -1.017777359e-04f, -1.694964089e-04f, -2.009512126e-04f, -1.993014146e-04f, -1.723633322e-04f, -1.303802073e-04f, -8.371807564e-05f, -4.096761910e-05f, -7.771194801e-06f, +1.351561964e-05f, +2.342139801e-05f, +2.445697407e-05f, +2.002256905e-05f, +1.341354347e-05f,
    /*  1,17 (48) */
    -3.623863630e-04f, -5.912492225e-04f, -8.393230423e-04f, -1.063486334e-03f, -1.201686999e-03f, -1.173834369e-03f, -8.849961625e-04f, -2.309769343e-04f, +8.939184250e-04f, +2.587417548e-03f, +4.928853632e-03f, +7.968727757e-03f, +1.171932707e-02f, +1.614747299e-02f, +2.117036087e-02f, +2.665522321e-02f, +3.242322034e-02f, +3.825756657e-02f, +4.391547655e-02f, +4.914311219e-02f, +5.369237093e-02f, +5.733812134e-02f, +5.989439231e-02f, +6.122807178e-02f, +6.126886953e-02f, +6.001462650e-02f, +5.753147838e-02f, +5.394885828e-02f, +4.944980188e-02f, +4.425744853e-02f, +3.861896676e-02f, +3.278834001e-02f, +2.700950789e-02f, +2.150126709e-02f, +1.644510957e-02f, +1.197684112e-02f, +8.182421794e-03f, +5.098046504e-03f, +2.714084862e-03f, +9.821661133e-04f, -1.755412632e-04f, -8.559259511e-04f, -1.164476647e-03f, -1.205730648e-03f, -1.075386869e-03f, -8.545821021e-04f, -6.065447794e-04f, -3.755657852e-04f,
    +6.522907823e-06f, +7.617957255e-06f, +7.663019833e-06f, +6.075048267e-06f, +2.264573046e-06f, -4.296176977e-06f, -1.399874871e-05f, -2.702553133e-05f, -4.328729862e-05f, -6.237997497e-05f, -8.356813575e-05f, -1.058004694e-04f, -1.277592971e-04f, -1.479425855e-04f, -1.647731083e-04f, -1.767259657e-04f, -1.824629900e-04f, -1.809610208e-04f, -1.716208647e-04f, -1.543450521e-04f, -1.295751782e-04f, -9.828341550e-05f, -6.191730505e-05f, -2.230168514e-05f, +1.849394269e-05f, +5.831068052e-05f, +9.506381053e-05f, +1.268994749e-04f, +1.523299854e-04f, +1.703355517e-04f, +1.804237446e-04f, +1.826423998e-04f, +1.775464088e-04f, +1.661234121e-04f, +1.496872908e-04f, +1.297511522e-04f, +1.078929320e-04f, +8.562670900e-05f, +6.429140060e-05f, +4.496592050e-05f, +2.841648733e-05f, +1.507800476e-05f, +5.067743758e-06f, -1.773638826e-06f, -5.821084136e-06f, -7.592796692e-06f, -7.675507496e-06f, -6.655454364e-06f,
    +4.867437620e-04f, +1.013747094e-03f, +1.728578244e-03f, +2.515231857e-03f, +3.148440148e-03f, +3.304152230e-03f, +2.603935031e-03f, +6.924024761e-04f, -2.662967162e-03f, -7.469398974e-03f, -1.342932480e-02f, -1.990951092e-02f, -2.597790257e-02f, -3.051453018e-02f, -3.238625676e-02f, -3.065843893e-02f, -2.480391455e-02f, -1.486476480e-02f, -1.527117065e-03f, +1.391629715e-02f, +2.971958762e-02f, +4.393278153e-02f, +5.470483430e-02f, +6.058541183e-02f, +6.076809826e-02f, +5.522768835e-02f, +4.472450010e-02f, +3.067485380e-02f, +1.491326273e-02f, -6.073245321e-04f, -1.412015839e-02f, -2.429854529e-02f, -3.041611367e-02f, -3.239164432e-02f, -3.072073739e-02f, -2.631842568e-02f, -2.031183202e-02f, -1.382741904e-02f, -7.812985500e-03f, -2.922289321e-03f, +5.263991772e-04f, +2.523202393e-03f, +3.289459215e-03f, +3.175944117e-03f, +2.562224724e-03f, +1.777418091e-03f, +1.053603053e-03f, +5.133593392e-04f,
    -1.299099421e-05f, -1.964224932e-05f, -2.430355154e-05f, -2.371290417e-05f, -1.444985736e-05f, +6.084337856e-06f, +3.857214372e-05f, +8.085666129e-05f, +1.274995807e-04f, +1.700686873e-04f, +1.982596258e-04f, +2.017560275e-04f, +1.725210712e-04f, +1.070480740e-04f, +8.028822401e-06f, -1.150427340e-04f, -2.466264993e-04f, -3.672646271e-04f, -4.567788623e-04f, -4.979591725e-04f, -4.800045906e-04f, -4.009760422e-04f, -2.686903983e-04f, -9.979367328e-05f, +8.286778134e-05f, +2.540930173e-04f, +3.906382195e-04f, +4.751409672e-04f, +4.988888348e-04f, +4.629168670e-04f, +3.772787163e-04f, +2.587196197e-04f, +1.272981371e-04f, +2.688059979e-06f, -9.909305502e-05f, -1.679301801e-04f, -2.004998266e-04f, -1.997851162e-04f, -1.734887737e-04f, -1.318140456e-04f, -8.515499721e-05f, -4.217982515e-05f, -8.632439490e-06f, +1.303161231e-05f, +2.326259437e-05f, +2.452574511e-05f, +2.020969306e-05f, +1.362546371e-05f,
    /*  1,18 (48) */
    -3.558634551e-04f, -5.836312653e-04f, -8.316600224e-04f, -1.057411285e-03f, -1.199422426e-03f, -1.178130546e-03f, -8.989949112e-04f, -2.580024657e-04f, +8.506311264e-04f, +2.525037573e-03f, +4.845285496e-03f, +7.862927288e-03f, +1.159156778e-02f, +1.599953041e-02f, +2.100558777e-02f, +2.647849724e-02f, +3.224075735e-02f, +3.807660555e-02f, +4.374385568e-02f, +4.898876714e-02f, +5.356279575e-02f, +5.723983792e-02f, +5.983247500e-02f, +6.120577010e-02f, +6.128736347e-02f, +6.007293718e-02f, +5.762654220e-02f, +5.407575776e-02f, +4.960213187e-02f, +4.442778408e-02f, +3.879939050e-02f, +3.297098241e-02f, +2.718705429e-02f, +2.166739050e-02f, +1.659479686e-02f, +1.210659227e-02f, +8.290314726e-03f, +5.183673213e-03f, +2.778376263e-03f, +1.027132034e-03f, -1.471247758e-04f, -8.408479463e-04f, -1.159408903e-03f, -1.207504287e-03f, -1.081207953e-03f, -8.621748988e-04f, -6.142202869e-04f, -3.822212396e-04f,
    +6.477690047e-06f, +7.596710501e-06f, +7.683214852e-06f, +6.155328848e-06f, +2.422804631e-06f, -4.045170841e-06f, -1.364553606e-05f, -2.656823942e-05f, -4.273331820e-05f, -6.174694096e-05f, -8.288397896e-05f, -1.051024197e-04f, -1.270918263e-04f, -1.473543959e-04f, -1.643133904e-04f, -1.764402438e-04f, -1.823889449e-04f, -1.811247071e-04f, -1.720337218e-04f, -1.550020465e-04f, -1.304543135e-04f, -9.934671235e-05f, -6.311320721e-05f, -2.356870096e-05f, +1.722268318e-05f, +5.710236930e-05f, +9.398087530e-05f, +1.259949353e-04f, +1.516436772e-04f, +1.698915531e-04f, +1.802292123e-04f, +1.826878783e-04f, +1.778075273e-04f, +1.665637486e-04f, +1.502620772e-04f, +1.304114247e-04f, +1.085897106e-04f, +8.631481091e-05f, +6.493255712e-05f, +4.553096181e-05f, +2.888647360e-05f, +1.544430097e-05f, +5.331145428e-06f, -1.604532908e-06f, -5.731996914e-06f, -7.566115013e-06f, -7.692569891e-06f, -6.698551799e-06f,
    +4.737527678e-04f, +9.941048444e-04f, +1.704274692e-03f, +2.491518953e-03f, +3.133990291e-03f, +3.310236568e-03f, +2.642507175e-03f, +7.732591374e-04f, -2.535467581e-03f, -7.299330287e-03f, -1.323106518e-02f, -1.970775489e-02f, -2.580538150e-02f, -3.040748210e-02f, -3.237822794e-02f, -3.077348167e-02f, -2.505054105e-02f, -1.523202942e-02f, -1.983895928e-03f, +1.341833798e-02f, +2.923958303e-02f, +4.353180549e-02f, +5.443614390e-02f, +6.048561815e-02f, +6.085096604e-02f, +5.548178137e-02f, +4.511513832e-02f, +3.114999476e-02f, +1.541215157e-02f, -1.444076651e-04f, -1.374287967e-02f, -2.403982567e-02f, -3.028881553e-02f, -3.238895626e-02f, -3.081983044e-02f, -2.648635586e-02f, -2.051233184e-02f, -1.402720415e-02f, -7.986474273e-03f, -3.054103367e-03f, +4.412441800e-04f, +2.481022568e-03f, +3.280826776e-03f, +3.188975729e-03f, +2.585487318e-03f, +1.801943836e-03f, +1.073812746e-03f, +5.269848029e-04f,
    -1.278048359e-05f, -1.944923643e-05f, -2.421911742e-05f, -2.384580553e-05f, -1.490020064e-05f, +5.258764720e-06f, +3.738911081e-05f, +7.943260847e-05f, +1.260533915e-04f, +1.689001464e-04f, +1.977021306e-04f, +2.021098317e-04f, +1.739795362e-04f, +1.096333455e-04f, +1.155365566e-05f, -1.109741421e-04f, -2.425733656e-04f, -3.638645247e-04f, -4.546367993e-04f, -4.975320429e-04f, -4.815050153e-04f, -4.043170167e-04f, -2.734844944e-04f, -1.054093829e-04f, +7.720212654e-05f, +2.491576510e-04f, +3.870886467e-04f, +4.733993232e-04f, +4.990808307e-04f, +4.648653351e-04f, +3.805526914e-04f, +2.627264553e-04f, +1.313979444e-04f, +6.306474398e-06f, -9.637563473e-05f, -1.663280088e-04f, -2.000155457e-04f, -2.002436315e-04f, -1.745991863e-04f, -1.332431650e-04f, -8.659576347e-05f, -4.340151373e-05f, -9.505530872e-06f, +1.253627391e-05f, +2.309495914e-05f, +2.458907746e-05f, +2.039466990e-05f, +1.383773357e-05f,
    /*  1,19 (48) */
    -3.493857651e-04f, -5.760345548e-04f, -8.239768076e-04f, -1.051255956e-03f, -1.196999621e-03f, -1.182175717e-03f, -9.126404473e-04f, -2.845707051e-04f, +8.078978082e-04f, +2.463290632e-03f, +4.762401517e-03f, +7.757824868e-03f, +1.146447595e-02f, +1.585217601e-02f, +2.084127438e-02f, +2.630205700e-02f, +3.205836840e-02f, +3.789548084e-02f, +4.357182196e-02f, +4.883376509e-02f, +5.343234143e-02f, +5.714049121e-02f, +5.976936179e-02f, +6.118220139e-02f, +6.130458616e-02f, +6.013003955e-02f, +5.772052307e-02f, +5.420175269e-02f, +4.975377555e-02f, +4.459767564e-02f, +3.897961971e-02f, +3.315367029e-02f, +2.736486182e-02f, +2.183395425e-02f, +1.674505894e-02f, +1.223700370e-02f, +8.398904437e-03f, +5.269988024e-03f, +2.843308820e-03f, +1.072662996e-03f, -1.182383022e-04f, -8.254036453e-04f, -1.154077757e-03f, -1.209108819e-03f, -1.086939950e-03f, -8.697410138e-04f, -6.219128568e-04f, -3.889197914e-04f,
    +6.431978801e-06f, +7.574460766e-06f, +7.701834142e-06f, +6.233451705e-06f, +2.578353981e-06f, -3.797240619e-06f, -1.329559004e-05f, -2.611413971e-05f, -4.218214685e-05f, -6.111600674e-05f, -8.220090042e-05f, -1.044041619e-04f, -1.264226756e-04f, -1.467629763e-04f, -1.638489388e-04f, -1.761484629e-04f, -1.823078213e-04f, -1.812807091e-04f, -1.724387800e-04f, -1.556516572e-04f, -1.313270034e-04f, -1.004049721e-04f, -6.430585546e-05f, -2.483449136e-05f, +1.595052764e-05f, +5.589110862e-05f, +9.289315982e-05f, +1.250841413e-04f, +1.509500984e-04f, +1.694397852e-04f, +1.800269439e-04f, +1.827261540e-04f, +1.780624044e-04f, +1.669991291e-04f, +1.508333922e-04f, +1.310697774e-04f, +1.092860609e-04f, +8.700380586e-05f, +6.557567358e-05f, +4.609872289e-05f, +2.935961333e-05f, +1.581387101e-05f, +5.597667930e-06f, -1.432672729e-06f, -5.640664402e-06f, -7.537765705e-06f, -7.708542790e-06f, -6.741082046e-06f,
    +4.609722842e-04f, +9.746556080e-04f, +1.680055575e-03f, +2.467673148e-03f, +3.119090090e-03f, +3.315495333e-03f, +2.679896285e-03f, +8.526917458e-04f, -2.409414189e-03f, -7.130430141e-03f, -1.303336304e-02f, -1.950564506e-02f, -2.563140196e-02f, -3.029784876e-02f, -3.236667428e-02f, -3.088445581e-02f, -2.529311442e-02f, -1.559589395e-02f, -2.438532727e-03f, +1.292080593e-02f, +2.875807801e-02f, +4.312748847e-02f, +5.416265940e-02f, +6.038020877e-02f, +6.092816816e-02f, +5.573093902e-02f, +4.550222697e-02f, +3.162339409e-02f, +1.591123240e-02f, +3.204576699e-04f, -1.336232698e-02f, -2.377709921e-02f, -3.015741759e-02f, -3.238264978e-02f, -3.091620608e-02f, -2.665268387e-02f, -2.071234739e-02f, -1.422744778e-02f, -8.161073460e-03f, -3.187346532e-03f, +3.546484166e-04f, +2.437621054e-03f, +3.271321245e-03f, +3.201512003e-03f, +2.608582277e-03f, +1.826532914e-03f, +1.094207416e-03f, +5.408225365e-04f,
    -1.257055940e-05f, -1.925444200e-05f, -2.412967932e-05f, -2.397027294e-05f, -1.533943858e-05f, +4.445116563e-06f, +3.621603328e-05f, +7.801328021e-05f, +1.246036813e-04f, +1.677179014e-04f, +1.971206335e-04f, +2.024314911e-04f, +1.754021216e-04f, +1.121851058e-04f, +1.505410309e-05f, -1.069147467e-04f, -2.385102389e-04f, -3.604343844e-04f, -4.524474573e-04f, -4.970466386e-04f, -4.829448989e-04f, -4.076048624e-04f, -2.782416943e-04f, -1.110106893e-04f, +7.152591317e-05f, +2.441885755e-04f, +3.834879467e-04f, +4.715976586e-04f, +4.992135781e-04f, +4.667643167e-04f, +3.837936558e-04f, +2.667201318e-04f, +1.355041440e-04f, +9.947263949e-06f, -9.362568470e-05f, -1.646898946e-04f, -1.994981936e-04f, -2.006766703e-04f, -1.756942389e-04f, -1.346672613e-04f, -8.804014709e-05f, -4.463255849e-05f, -1.039044230e-05f, +1.202955281e-05f, +2.291839499e-05f, +2.464686208e-05f, +2.057740610e-05f, +1.405029109e-05f,
    /*  1,20 (48) */
    -3.429537863e-04f, -5.684600940e-04f, -8.162749735e-04f, -1.045022505e-03f, -1.194421267e-03f, -1.185972958e-03f, -9.259360373e-04f, -3.106848448e-04f, +7.657156613e-04f, +2.402174625e-03f, +4.680200617e-03f, +7.653420706e-03f, +1.133805327e-02f, +1.570541304e-02f, +2.067742544e-02f, +2.612590854e-02f, +3.187606058e-02f, +3.771420013e-02f, +4.339938318e-02f, +4.867811343e-02f, +5.330101443e-02f, +5.704008624e-02f, +5.970505594e-02f, +6.115736690e-02f, +6.132053668e-02f, +6.018593065e-02f, +5.781341623e-02f, +5.432683683e-02f, +4.990472564e-02f, +4.476711542e-02f, +3.915964666e-02f, +3.333639644e-02f, +2.754292423e-02f, +2.200095338e-02f, +1.689589233e-02f, +1.236807348e-02f, +8.508190498e-03f, +5.356991830e-03f, +2.908884493e-03f, +1.118761719e-03f, -8.887868891e-05f, -8.095897743e-04f, -1.148480090e-03f, -1.210541492e-03f, -1.092580615e-03f, -8.772787795e-04f, -6.296213996e-04f, -3.956608734e-04f,
    +6.385788534e-06f, +7.551225169e-06f, +7.718896060e-06f, +6.309434527e-06f, +2.731235893e-06f, -3.552376721e-06f, -1.294890841e-05f, -2.566323901e-05f, -4.163380147e-05f, -6.048719935e-05f, -8.151893637e-05f, -1.037057395e-04f, -1.257518931e-04f, -1.461683752e-04f, -1.633797983e-04f, -1.758506607e-04f, -1.822196454e-04f, -1.814290384e-04f, -1.728360349e-04f, -1.562938633e-04f, -1.321932110e-04f, -1.014581444e-04f, -6.549518960e-05f, -2.609899070e-05f, +1.467754219e-05f, +5.467696004e-05f, +9.180071650e-05f, +1.241671324e-04f, +1.502492729e-04f, +1.689802556e-04f, +1.798169304e-04f, +1.827572033e-04f, +1.783110046e-04f, +1.674295098e-04f, +1.514011878e-04f, +1.317261621e-04f, +1.099819384e-04f, +8.769365605e-05f, +6.622072111e-05f, +4.666918493e-05f, +2.983589784e-05f, +1.618671553e-05f, +5.867319628e-06f, -1.258044290e-06f, -5.547069277e-06f, -7.507730380e-06f, -7.723408718e-06f, -6.783030070e-06f,
    +4.484017248e-04f, +9.554011660e-04f, +1.655925896e-03f, +2.443702875e-03f, +3.103750651e-03f, +3.319940450e-03f, +2.716112319e-03f, +9.307050260e-04f, -2.284810508e-03f, -6.962712239e-03f, -1.283624241e-02f, -1.930321357e-02f, -2.545599984e-02f, -3.018566365e-02f, -3.235162018e-02f, -3.099137055e-02f, -2.553162466e-02f, -1.595632833e-02f, -2.890980184e-03f, +1.242375929e-02f, +2.827513312e-02f, +4.271988361e-02f, +5.388441771e-02f, +6.026919808e-02f, +6.099969408e-02f, +5.597512760e-02f, +4.588571491e-02f, +3.209499175e-02f, +1.641044598e-02f, +7.872219866e-04f, -1.297853332e-02f, -2.351037908e-02f, -3.002191345e-02f, -3.237270252e-02f, -3.100983176e-02f, -2.681737377e-02f, -2.091184558e-02f, -1.442812445e-02f, -8.336767698e-03f, -3.322013793e-03f, +2.666082695e-04f, +2.392988496e-03f, +3.260930802e-03f, +3.213541556e-03f, +2.631500672e-03f, +1.851179776e-03f, +1.114784822e-03f, +5.548728275e-04f,
    -1.236127806e-05f, -1.905795531e-05f, -2.403534541e-05f, -2.408640770e-05f, -1.576763225e-05f, +3.643405993e-06f, +3.505302122e-05f, +7.659888899e-05f, +1.231507447e-04f, +1.665222834e-04f, +1.965154358e-04f, +2.027212045e-04f, +1.767888582e-04f, +1.147031788e-04f, +1.852978049e-05f, -1.028650970e-04f, -2.344377501e-04f, -3.569748093e-04f, -4.502112968e-04f, -4.965031808e-04f, -4.843241664e-04f, -4.108392049e-04f, -2.829613790e-04f, -1.165968301e-04f, +6.583991611e-05f, +2.391864458e-04f, +3.798365454e-04f, +4.697361063e-04f, +4.992869089e-04f, +4.686133899e-04f, +3.870010247e-04f, +2.707000147e-04f, +1.396161639e-04f, +1.361000888e-05f, -9.084342132e-05f, -1.630158436e-04f, -1.989475989e-04f, -2.010839449e-04f, -1.767736006e-04f, -1.360860288e-04f, -8.948791782e-05f, -4.587282982e-05f, -1.128714424e-05f, +1.151139937e-05f, +2.273280550e-05f, +2.469898981e-05f, +2.075780740e-05f, +1.426307319e-05f,
    /*  1,21 (48) */
    -3.365679977e-04f, -5.609088688e-04f, -8.085560774e-04f, -1.038713070e-03f, -1.191690031e-03f, -1.189525335e-03f, -9.388849457e-04f, -3.363480838e-04f, +7.240818599e-04f, +2.341687426e-03f, +4.598681680e-03f, +7.549714967e-03f, +1.121230138e-02f, +1.555924466e-02f, +2.051404564e-02f, +2.595005788e-02f, +3.169384093e-02f, +3.753277109e-02f, +4.322654714e-02f, +4.852181957e-02f, +5.316882122e-02f, +5.693862809e-02f, +5.963956075e-02f, +6.113126791e-02f, +6.133521423e-02f, +6.024060761e-02f, +5.790521695e-02f, +5.445100397e-02f, +5.005497492e-02f, +4.493609568e-02f, +3.933946359e-02f, +3.351915364e-02f, +2.772123523e-02f, +2.216838289e-02f, +1.704729352e-02f, +1.249979964e-02f, +8.618172436e-03f, +5.444685486e-03f, +2.975105214e-03f, +1.165430903e-03f, -5.904279106e-05f, -7.934030588e-04f, -1.142612770e-03f, -1.211799537e-03f, -1.098127684e-03f, -8.847865099e-04f, -6.373448083e-04f, -4.024439035e-04f,
    +6.339133594e-06f, +7.527020764e-06f, +7.734418951e-06f, +6.383295056e-06f, +2.881465290e-06f, -3.310569361e-06f, -1.260548869e-05f, -2.521554387e-05f, -4.108829861e-05f, -5.986054554e-05f, -8.083812284e-05f, -1.030071957e-04f, -1.250795263e-04f, -1.455706410e-04f, -1.629060141e-04f, -1.755468747e-04f, -1.821244437e-04f, -1.815697075e-04f, -1.732254828e-04f, -1.569286442e-04f, -1.330529000e-04f, -1.025061794e-04f, -6.668114971e-05f, -2.736213345e-05f, +1.340379299e-05f, +5.345998535e-05f, +9.070359815e-05f, +1.232439486e-04f, +1.495412255e-04f, +1.685129721e-04f, +1.795991635e-04f, +1.827810030e-04f, +1.785532927e-04f, +1.678548470e-04f, +1.519654159e-04f, +1.323805306e-04f, +1.106772984e-04f, +8.838432342e-05f, +6.686767051e-05f, +4.724232877e-05f, +3.031531818e-05f, +1.656283491e-05f, +6.140108674e-06f, -1.080633738e-06f, -5.451194286e-06f, -7.475990650e-06f, -7.737150143e-06f, -6.824380746e-06f,
    +4.360404467e-04f, +9.363432107e-04f, +1.631890550e-03f, +2.419616467e-03f, +3.087983019e-03f, +3.323583856e-03f, +2.751165340e-03f, +1.007303915e-03f, -2.161659764e-03f, -6.796189956e-03f, -1.263972698e-02f, -1.910049237e-02f, -2.527921098e-02f, -3.007096047e-02f, -3.233309040e-02f, -3.109423565e-02f, -2.576606241e-02f, -1.631330314e-02f, -3.341191481e-03f, +1.192725611e-02f, +2.779080895e-02f, +4.230904441e-02f, +5.360145633e-02f, +6.015260125e-02f, +6.106553399e-02f, +5.621431404e-02f, +4.626555146e-02f, +3.256472785e-02f, +1.690973288e-02f, +1.255835377e-03f, -1.259153230e-02f, -2.323967906e-02f, -2.988229728e-02f, -3.235909251e-02f, -3.110067518e-02f, -2.698038961e-02f, -2.111079318e-02f, -1.462920840e-02f, -8.513541299e-03f, -3.458099822e-03f, +1.771203517e-04f, +2.347115666e-03f, +3.249643658e-03f, +3.225052956e-03f, +2.654233478e-03f, +1.875878766e-03f, +1.135542630e-03f, +5.691359007e-04f,
    -1.215269488e-05f, -1.885986474e-05f, -2.393622360e-05f, -2.419431183e-05f, -1.618484449e-05f, +2.853642879e-06f, +3.390018149e-05f, +7.518964427e-05f, +1.216948744e-04f, +1.653136230e-04f, +1.958868412e-04f, +2.029791747e-04f, +1.781397830e-04f, +1.171873950e-04f, +2.198030972e-05f, -9.882573812e-05f, -2.303565294e-04f, -3.534864055e-04f, -4.479287843e-04f, -4.959018989e-04f, -4.856427518e-04f, -4.140196788e-04f, -2.876429354e-04f, -1.221670459e-04f, +6.014491190e-05f, +2.341519224e-04f, +3.761348771e-04f, +4.678148086e-04f, +4.993006637e-04f, +4.704121395e-04f, +3.901742165e-04f, +2.746654690e-04f, +1.437334289e-04f, +1.729428370e-05f, -8.802906768e-05f, -1.613058679e-04f, -1.983635946e-04f, -2.014651700e-04f, -1.778369407e-04f, -1.374991601e-04f, -9.093884253e-05f, -4.712219483e-05f, -1.219560428e-05f, +1.098176596e-05f, +2.253809516e-05f, +2.474535144e-05f, +2.093577875e-05f, +1.447601573e-05f,
    /*  1,22 (48) */
    -3.302288642e-04f, -5.533818481e-04f, -8.008216584e-04f, -1.032329775e-03f, -1.188808566e-03f, -1.192835904e-03f, -9.514904344e-04f, -3.615636277e-04f, +6.829935612e-04f, +2.281826881e-03f, +4.517843558e-03f, +7.446707771e-03f, +1.108722185e-02f, +1.541367402e-02f, +2.035113962e-02f, +2.577451100e-02f, +3.151171649e-02f, +3.735120138e-02f, +4.305332166e-02f, +4.836489092e-02f, +5.303576832e-02f, +5.683612192e-02f, +5.957287960e-02f, +6.110390578e-02f, +6.134861802e-02f, +6.029406760e-02f, +5.799592054e-02f, +5.457424791e-02f, +5.020451614e-02f, +4.510460865e-02f, +3.951906275e-02f, +3.370193465e-02f, +2.789978852e-02f, +2.233623773e-02f, +1.719925894e-02f, +1.263218017e-02f, +8.728849735e-03f, +5.533069809e-03f, +3.041972885e-03f, +1.212673232e-03f, -2.872747289e-05f, -7.768402239e-04f, -1.136472661e-03f, -1.212880170e-03f, -1.103578878e-03f, -8.922625006e-04f, -6.450819584e-04f, -4.092682842e-04f,
    +6.292028226e-06f, +7.501864540e-06f, +7.748421147e-06f, +6.455051086e-06f, +3.029057220e-06f, -3.071808559e-06f, -1.226532812e-05f, -2.477106051e-05f, -4.054565455e-05f, -5.923607174e-05f, -8.015849554e-05f, -1.023085737e-04f, -1.244056229e-04f, -1.449698222e-04f, -1.624276316e-04f, -1.752371429e-04f, -1.820222430e-04f, -1.817027291e-04f, -1.736071204e-04f, -1.575559798e-04f, -1.339060344e-04f, -1.035490276e-04f, -6.786367609e-05f, -2.862385418e-05f, +1.212934627e-05f, +5.224024653e-05f, +8.960185788e-05f, +1.223146305e-04f, +1.488259813e-04f, +1.680379435e-04f, +1.793736353e-04f, +1.827975304e-04f, +1.787892338e-04f, +1.682750973e-04f, +1.525260286e-04f, +1.330328344e-04f, +1.113720959e-04f, +8.907576968e-05f, +6.751649231e-05f, +4.781813497e-05f, +3.079786504e-05f, +1.694222924e-05f, +6.416043006e-06f, -9.004273601e-07f, -5.353022246e-06f, -7.442528130e-06f, -7.749749481e-06f, -6.865118852e-06f,
    +4.238877519e-04f, +9.174833459e-04f, +1.607954327e-03f, +2.395422155e-03f, +3.071798175e-03f, +3.326437498e-03f, +2.785065521e-03f, +1.082493559e-03f, -2.039964889e-03f, -6.630876333e-03f, -1.244384013e-02f, -1.889751319e-02f, -2.510107120e-02f, -2.995377308e-02f, -3.231111009e-02f, -3.119306139e-02f, -2.599641894e-02f, -1.666678955e-02f, -3.789120265e-03f, +1.143135421e-02f, +2.730516620e-02f, +4.189502473e-02f, +5.331381339e-02f, +6.003043421e-02f, +6.112567891e-02f, +5.644846596e-02f, +4.664168634e-02f, +3.303254266e-02f, +1.740903355e-02f, +1.726247516e-03f, -1.220135808e-02f, -2.296501360e-02f, -2.973856385e-02f, -3.234179823e-02f, -3.118870425e-02f, -2.714169548e-02f, -2.130915678e-02f, -1.483067357e-02f, -8.691378240e-03f, -3.595598982e-03f, +8.618150913e-05f, +2.299993471e-03f, +3.237448054e-03f, +3.236034722e-03f, +2.676771573e-03f, +1.900624117e-03f, +1.156478409e-03f, +5.836119165e-04f,
    -1.194486404e-05f, -1.866025781e-05f, -2.383242151e-05f, -2.429408800e-05f, -1.659113991e-05f, +2.075834377e-06f, +3.275761770e-05f, +7.378575245e-05f, +1.202363612e-04f, +1.640922509e-04f, +1.952351551e-04f, +2.032056088e-04f, +1.794549389e-04f, +1.196375918e-04f, +2.540531878e-05f, -9.479721092e-05f, -2.262672056e-04f, -3.499697813e-04f, -4.456003923e-04f, -4.952430311e-04f, -4.869005993e-04f, -4.171459276e-04f, -2.922857573e-04f, -1.277205798e-04f, +5.444167862e-05f, +2.290856711e-04f, +3.723833847e-04f, +4.658339177e-04f, +4.992546924e-04f, +4.721601571e-04f, +3.933126532e-04f, +2.786158599e-04f, +1.478553601e-04f, +2.099965721e-05f, -8.518285353e-05f, -1.595599860e-04f, -1.977460188e-04f, -2.018200630e-04f, -1.788839288e-04f, -1.389063463e-04f, -9.239268525e-05f, -4.838051740e-05f, -1.311578707e-05f, +1.044060700e-05f, +2.233416943e-05f, +2.478583769e-05f, +2.111122436e-05f, +1.468905343e-05f,
    /*  1,23 (48) */
    -3.239368359e-04f, -5.458799835e-04f, -7.930732373e-04f, -1.025874724e-03f, -1.185779509e-03f, -1.195907712e-03f, -9.637557625e-04f, -3.863346882e-04f, +6.424479067e-04f, +2.222590809e-03f, +4.437685062e-03f, +7.344399198e-03f, +1.096281623e-02f, +1.526870420e-02f, +2.018871199e-02f, +2.559927386e-02f, +3.132969425e-02f, +3.716949865e-02f, +4.287971454e-02f, +4.820733494e-02f, +5.290186229e-02f, +5.673257289e-02f, +5.950501592e-02f, +6.107528192e-02f, +6.136074737e-02f, +6.034630785e-02f, +5.808552240e-02f, +5.469656255e-02f, +5.035334212e-02f, +4.527264659e-02f, +3.969843638e-02f, +3.388473218e-02f, +2.807857776e-02f, +2.250451283e-02f, +1.735178496e-02f, +1.276521300e-02f, +8.840221830e-03f, +5.622145579e-03f, +3.109489377e-03f, +1.260491367e-03f, +2.070392152e-06f, -7.598979946e-04f, -1.130056618e-03f, -1.213780598e-03f, -1.108931901e-03f, -8.997050287e-04f, -6.528317079e-04f, -4.161334031e-04f,
    +6.244486575e-06f, +7.475773419e-06f, +7.760920964e-06f, +6.524720458e-06f, +3.174026850e-06f, -2.836084140e-06f, -1.192842370e-05f, -2.432979486e-05f, -4.000588521e-05f, -5.861380406e-05f, -7.948008996e-05f, -1.016099164e-04f, -1.237302304e-04f, -1.443659673e-04f, -1.619446962e-04f, -1.749215037e-04f, -1.819130706e-04f, -1.818281164e-04f, -1.739809448e-04f, -1.581758507e-04f, -1.347525789e-04f, -1.045866398e-04f, -6.904270931e-05f, -2.988408757e-05f, +1.085426828e-05f, +5.101780578e-05f, +8.849554918e-05f, +1.213792189e-04f, +1.481035659e-04f, +1.675551786e-04f, +1.791403384e-04f, +1.828067631e-04f, +1.790187932e-04f, +1.686902173e-04f, +1.530829779e-04f, +1.336830254e-04f, +1.120662859e-04f, +8.976795629e-05f, +6.816715673e-05f, +4.839658372e-05f, +3.128352883e-05f, +1.732489835e-05f, +6.695130348e-06f, -7.174115923e-07f, -5.252536049e-06f, -7.407324442e-06f, -7.761189099e-06f, -6.905229076e-06f,
    +4.119428878e-04f, +8.988230881e-04f, +1.584121905e-03f, +2.371128067e-03f, +3.055207035e-03f, +3.328513333e-03f, +2.817823139e-03f, +1.156279312e-03f, -1.919728528e-03f, -6.466784082e-03f, -1.224860498e-02f, -1.869430758e-02f, -2.492161626e-02f, -2.983413549e-02f, -3.228570477e-02f, -3.128785860e-02f, -2.622268614e-02f, -1.701675933e-02f, -4.234720657e-03f, +1.093611118e-02f, +2.681826560e-02f, +4.147787880e-02f, +5.302152764e-02f, +5.990271363e-02f, +6.118012058e-02f, +5.667755164e-02f, +4.701406972e-02f, +3.349837658e-02f, +1.790828824e-02f, +2.198407673e-03f, -1.180804543e-02f, -2.268639774e-02f, -2.959070849e-02f, -3.232079857e-02f, -3.127388711e-02f, -2.730125546e-02f, -2.150690279e-02f, -1.503249363e-02f, -8.870262169e-03f, -3.734505328e-03f, -6.211176122e-06f, +2.251612954e-03f, +3.224332267e-03f, +3.246475329e-03f, +2.699105742e-03f, +1.925409955e-03f, +1.177589633e-03f, +5.983009699e-04f,
    -1.173783863e-05f, -1.845922109e-05f, -2.372404648e-05f, -2.438583951e-05f, -1.698658485e-05f, +1.309984952e-06f, +3.162543024e-05f, +7.238741685e-05f, +1.187754937e-04f, +1.628584972e-04f, +1.945606850e-04f, +2.034007180e-04f, +1.807343748e-04f, +1.220536131e-04f, +2.880444182e-05f, -9.078005214e-05f, -2.221704064e-04f, -3.464255475e-04f, -4.432265991e-04f, -4.945268237e-04f, -4.880976622e-04f, -4.202176034e-04f, -2.968892447e-04f, -1.332566780e-04f, +4.873099576e-05f, +2.239883633e-04f, +3.685825189e-04f, +4.637935950e-04f, +4.991488536e-04f, +4.738570412e-04f, +3.964157603e-04f, +2.825505523e-04f, +1.519813755e-04f, +2.472569254e-05f, -8.230501533e-05f, -1.577782226e-04f, -1.970947142e-04f, -2.021483440e-04f, -1.799142352e-04f, -1.403072766e-04f, -9.384920717e-05f, -4.964765813e-05f, -1.404765433e-05f, +9.887878991e-06f, +2.212093478e-05f, +2.482033930e-05f, +2.128404769e-05f, +1.490211996e-05f,
    /*  1,24 (48) */
    -3.176923494e-04f, -5.384042101e-04f, -7.853123163e-04f, -1.019350004e-03f, -1.182605482e-03f, -1.198743797e-03f, -9.756841862e-04f, -4.106644831e-04f, +6.024420215e-04f, +2.163977005e-03f, +4.358204972e-03f, +7.242789281e-03f, +1.083908600e-02f, +1.512433823e-02f, +2.002676730e-02f, +2.542435236e-02f, +3.114778118e-02f, +3.698767054e-02f, +4.270573360e-02f, +4.804915909e-02f, +5.276710971e-02f, +5.662798625e-02f, +5.943597321e-02f, +6.104539784e-02f, +6.137160163e-02f, +6.039732565e-02f, +5.817401795e-02f, +5.481794176e-02f, +5.050144569e-02f, +4.544020177e-02f, +3.987757672e-02f, +3.406753894e-02f, +2.825759655e-02f, +2.267320305e-02f, +1.750486794e-02f, +1.289889603e-02f, +8.952288116e-03f, +5.711913535e-03f, +3.177656534e-03f, +1.308887951e-03f, +3.335392098e-05f, -7.425730963e-04f, -1.123361488e-03f, -1.214498009e-03f, -1.114184437e-03f, -9.071123531e-04f, -6.605928970e-04f, -4.230386322e-04f,
    +6.196522682e-06f, +7.448764252e-06f, +7.771936700e-06f, +6.592321062e-06f, +3.316389466e-06f, -2.603385740e-06f, -1.159477218e-05f, -2.389175254e-05f, -3.946900620e-05f, -5.799376832e-05f, -7.880294129e-05f, -1.009112666e-04f, -1.230533962e-04f, -1.437591249e-04f, -1.614572536e-04f, -1.745999956e-04f, -1.817969543e-04f, -1.819458831e-04f, -1.743469537e-04f, -1.587882379e-04f, -1.355924986e-04f, -1.056189673e-04f, -7.021819019e-05f, -3.114276840e-05f, +9.578625365e-06f, +4.979272550e-05f, +8.738472583e-05f, +1.204377551e-04f, +1.473740055e-04f, +1.670646871e-04f, +1.788992659e-04f, +1.828086792e-04f, +1.792419368e-04f, +1.691001640e-04f, +1.536362162e-04f, +1.343310549e-04f, +1.127598233e-04f, +9.046084446e-05f, +6.881963368e-05f, +4.897765493e-05f, +3.177229965e-05f, +1.771084180e-05f, +6.977378204e-06f, -5.315730174e-07f, -5.149718660e-06f, -7.370361214e-06f, -7.771451312e-06f, -6.944696012e-06f,
    +4.002050492e-04f, +8.803638670e-04f, +1.560397859e-03f, +2.346742228e-03f, +3.038220450e-03f, +3.329823318e-03f, +2.849448569e-03f, +1.228666729e-03f, -1.800953034e-03f, -6.303925585e-03f, -1.205404429e-02f, -1.849090686e-02f, -2.474088189e-02f, -2.971208187e-02f, -3.225690033e-02f, -3.137863865e-02f, -2.644485655e-02f, -1.736318488e-02f, -4.677947257e-03f, +1.044158436e-02f, +2.633016794e-02f, +4.105766120e-02f, +5.272463839e-02f, +5.976945695e-02f, +6.122885158e-02f, +5.690154000e-02f, +4.738265224e-02f, +3.396217017e-02f, +1.840743709e-02f, +2.672264714e-03f, -1.141162967e-02f, -2.240384718e-02f, -2.943872712e-02f, -3.229607288e-02f, -3.135619212e-02f, -2.745903369e-02f, -2.170399751e-02f, -1.523464198e-02f, -9.050176404e-03f, -3.874812605e-03f, -1.000603833e-04f, +2.201965296e-03f, +3.210284612e-03f, +3.256363208e-03f, +2.721226677e-03f, +1.950230294e-03f, +1.198873681e-03f, +6.132030899e-04f,
    -1.153167060e-05f, -1.825684027e-05f, -2.361120550e-05f, -2.446967027e-05f, -1.737124731e-05f, +5.560964085e-07f, +3.050371628e-05f, +7.099483771e-05f, +1.173125582e-04f, +1.616126915e-04f, +1.938637399e-04f, +2.035647178e-04f, +1.819781453e-04f, +1.244353095e-04f, +3.217731919e-05f, -8.677479417e-05f, -2.180667583e-04f, -3.428543174e-04f, -4.408078890e-04f, -4.937535320e-04f, -4.892339038e-04f, -4.232343676e-04f, -3.014528043e-04f, -1.387745892e-04f, +4.301364407e-05f, +2.188606756e-04f, +3.647327390e-04f, +4.616940118e-04f, +4.989830154e-04f, +4.755023974e-04f, +3.994829673e-04f, +2.864689115e-04f, +1.561108897e-04f, +2.847194725e-05f, -7.939579618e-05f, -1.559606090e-04f, -1.964095286e-04f, -2.024497358e-04f, -1.809275301e-04f, -1.417016390e-04f, -9.530816669e-05f, -5.092347434e-05f, -1.499116485e-05f, +9.323540560e-06f, +2.189829870e-05f, +2.484874698e-05f, +2.145415145e-05f, +1.511514789e-05f,
    /*  1,25 (48) */
    -3.114958267e-04f, -5.309554459e-04f, -7.775403796e-04f, -1.012757683e-03f, -1.179289092e-03f, -1.201347182e-03f, -9.872789584e-04f, -4.345562356e-04f, +5.629730153e-04f, +2.105983236e-03f, +4.279402031e-03f, +7.141878015e-03f, +1.071603260e-02f, +1.498057911e-02f, +1.986531004e-02f, +2.524975236e-02f, +3.096598422e-02f, +3.680572465e-02f, +4.253138664e-02f, +4.789037086e-02f, +5.263151721e-02f, +5.652236728e-02f, +5.936575502e-02f, +6.101425507e-02f, +6.138118026e-02f, +6.044711838e-02f, +5.826140268e-02f, +5.493837952e-02f, +5.064881970e-02f, +4.560726646e-02f, +4.005647599e-02f, +3.425034762e-02f, +2.843683849e-02f, +2.284230321e-02f, +1.765850416e-02f, +1.303322708e-02f, +9.065047940e-03f, +5.802374380e-03f, +3.246476168e-03f, +1.357865606e-03f, +6.512622063e-05f, -7.248622545e-04f, -1.116384110e-03f, -1.215029582e-03f, -1.119334155e-03f, -9.144827144e-04f, -6.683643483e-04f, -4.299833282e-04f,
    +6.148150484e-06f, +7.420853824e-06f, +7.781486633e-06f, +6.657870832e-06f, +3.456160473e-06f, -2.373702808e-06f, -1.126437005e-05f, -2.345693889e-05f, -3.893503281e-05f, -5.737599002e-05f, -7.812708446e-05f, -1.002126668e-04f, -1.223751678e-04f, -1.431493437e-04f, -1.609653496e-04f, -1.742726574e-04f, -1.816739221e-04f, -1.820560435e-04f, -1.747051455e-04f, -1.593931230e-04f, -1.364257588e-04f, -1.066459616e-04f, -7.139005983e-05f, -3.239983159e-05f, +8.302483877e-06f, +4.856506828e-05f, +8.626944199e-05f, +1.194902810e-04f, +1.466373266e-04f, +1.665664791e-04f, +1.786504114e-04f, +1.828032572e-04f, +1.794586306e-04f, +1.695048947e-04f, +1.541856957e-04f, +1.349768747e-04f, +1.134526627e-04f, +9.115439517e-05f, +6.947389279e-05f, +4.956132816e-05f, +3.226416726e-05f, +1.810005886e-05f, +7.262793860e-06f, -3.428983692e-07f, -5.044553124e-06f, -7.331620083e-06f, -7.780518386e-06f, -6.983504168e-06f,
    +3.886733786e-04f, +8.621070268e-04f, +1.536786653e-03f, +2.322272557e-03f, +3.020849203e-03f, +3.330379414e-03f, +2.879952286e-03f, +1.299661566e-03f, -1.683640476e-03f, -6.142312893e-03f, -1.186018055e-02f, -1.828734215e-02f, -2.455890374e-02f, -2.958764656e-02f, -3.222472301e-02f, -3.146541345e-02f, -2.666292331e-02f, -1.770603919e-02f, -5.118755146e-03f, +9.947830828e-03f, +2.584093403e-02f, +4.063442683e-02f, +5.242318559e-02f, +5.963068236e-02f, +6.127186522e-02f, +5.712040067e-02f, +4.774738498e-02f, +3.442386419e-02f, +1.890642011e-02f, +3.147767112e-03f, -1.101214670e-02f, -2.211737827e-02f, -2.928261623e-02f, -3.226760093e-02f, -3.143558792e-02f, -2.761499429e-02f, -2.190040704e-02f, -1.543709171e-02f, -9.231103934e-03f, -4.016514244e-03f, -1.953685500e-04f, +2.151041821e-03f, +3.195293448e-03f, +3.265686748e-03f, +2.743124976e-03f, +1.975079041e-03f, +1.220327832e-03f, +6.283182377e-04f,
    -1.132641078e-05f, -1.805320008e-05f, -2.349400520e-05f, -2.454568474e-05f, -1.774519696e-05f, -1.858320897e-07f, +2.939256978e-05f, +6.960821217e-05f, +1.158478390e-04f, +1.603551633e-04f, +1.931446308e-04f, +2.036978274e-04f, +1.831863109e-04f, +1.267825385e-04f, +3.552359748e-05f, -8.278196499e-05f, -2.139568862e-04f, -3.392567061e-04f, -4.383447518e-04f, -4.929234191e-04f, -4.903092966e-04f, -4.261958904e-04f, -3.059758495e-04f, -1.442735657e-04f, +3.729040543e-05f, +2.137032898e-04f, +3.608345123e-04f, +4.595353487e-04f, +4.987570545e-04f, +4.770958382e-04f, +4.025137075e-04f, +2.903703028e-04f, +1.602433145e-04f, +3.223797337e-05f, -7.645544584e-05f, -1.541071826e-04f, -1.956903147e-04f, -2.027239640e-04f, -1.819234847e-04f, -1.430891199e-04f, -9.676931944e-05f, -5.220782014e-05f, -1.594627439e-05f, +8.747552469e-06f, +2.166616976e-05f, +2.487095151e-05f, +2.162143767e-05f, +1.532806871e-05f,
    /*  1,26 (48) */
    -3.053476762e-04f, -5.235345920e-04f, -7.697588930e-04f, -1.006099812e-03f, -1.175832932e-03f, -1.203720885e-03f, -9.985433285e-04f, -4.580131745e-04f, +5.240379825e-04f, +2.048607246e-03f, +4.201274946e-03f, +7.041665348e-03f, +1.059365744e-02f, +1.483742976e-02f, +1.970434469e-02f, +2.507547970e-02f, +3.078431030e-02f, +3.662366861e-02f, +4.235668150e-02f, +4.773097773e-02f, +5.249509145e-02f, +5.641572132e-02f, +5.929436496e-02f, +6.098185524e-02f, +6.138948274e-02f, +6.049568345e-02f, +5.834767212e-02f, +5.505786980e-02f, +5.079545702e-02f, +4.577383294e-02f, +4.023512640e-02f, +3.443315088e-02f, +2.861629712e-02f, +2.301180811e-02f, +1.781268985e-02f, +1.316820396e-02f, +9.178500602e-03f, +5.893528775e-03f, +3.315950061e-03f, +1.407426934e-03f, +9.739038789e-05f, -7.067621956e-04f, -1.109121316e-03f, -1.215372481e-03f, -1.124378708e-03f, -9.218143344e-04f, -6.761448667e-04f, -4.369668323e-04f,
    +6.099383813e-06f, +7.392058845e-06f, +7.789589021e-06f, +6.721387745e-06f, +3.593355386e-06f, -2.147024604e-06f, -1.093721356e-05f, -2.302535893e-05f, -3.840398002e-05f, -5.676049434e-05f, -7.745255413e-05f, -9.951415924e-05f, -1.216955923e-04f, -1.425366721e-04f, -1.604690300e-04f, -1.739395284e-04f, -1.815440025e-04f, -1.821586121e-04f, -1.750555188e-04f, -1.599904879e-04f, -1.372523257e-04f, -1.076675748e-04f, -7.255825958e-05f, -3.365521214e-05f, +7.025910221e-06f, +4.733489691e-05f, +8.514975212e-05f, +1.185368387e-04f, +1.458935566e-04f, +1.660605652e-04f, +1.783937689e-04f, +1.827904761e-04f, +1.796688410e-04f, +1.699043667e-04f, +1.547313687e-04f, +1.356204362e-04f, +1.141447587e-04f, +9.184856916e-05f, +7.012990339e-05f, +5.014758269e-05f, +3.275912115e-05f, +1.849254854e-05f, +7.551384381e-06f, -1.513745344e-07f, -4.937022566e-06f, -7.291082698e-06f, -7.788372543e-06f, -7.021637960e-06f,
    +3.773469678e-04f, +8.440538267e-04f, +1.513292648e-03f, +2.297726873e-03f, +3.003104006e-03f, +3.330193582e-03f, +2.909344855e-03f, +1.369269778e-03f, -1.567792637e-03f, -5.981957730e-03f, -1.166703592e-02f, -1.808364432e-02f, -2.437571743e-02f, -2.946086403e-02f, -3.218919941e-02f, -3.154819541e-02f, -2.687688019e-02f, -1.804529590e-02f, -5.557099897e-03f, +9.454907409e-03f, +2.535062474e-02f, +4.020823094e-02f, +5.211720974e-02f, +5.948640879e-02f, +6.130915563e-02f, +5.733410396e-02f, +4.810821949e-02f, +3.488339953e-02f, +1.940517716e-02f, +3.624862950e-03f, -1.060963299e-02f, -2.182700797e-02f, -2.912237291e-02f, -3.223536296e-02f, -3.151204336e-02f, -2.776910148e-02f, -2.209609735e-02f, -1.563981567e-02f, -9.413027418e-03f, -4.159603364e-03f, -2.921378694e-04f, +2.098834001e-03f, +3.179347173e-03f, +3.274434301e-03f, +2.764791145e-03f, +1.999949993e-03f, +1.241949270e-03f, +6.436463064e-04f,
    -1.112210891e-05f, -1.784838432e-05f, -2.337255185e-05f, -2.461398792e-05f, -1.810850509e-05f, -9.158039886e-07f, +2.829208151e-05f, +6.822773425e-05f, +1.143816183e-04f, +1.590862412e-04f, +1.924036704e-04f, +2.038002702e-04f, +1.843589381e-04f, +1.290951640e-04f, +3.884292954e-05f, -7.880208811e-05f, -2.098414137e-04f, -3.356333310e-04f, -4.358376830e-04f, -4.920367567e-04f, -4.913238229e-04f, -4.291018512e-04f, -3.104578006e-04f, -1.497528627e-04f, +3.156206276e-05f, +2.085168925e-04f, +3.568883141e-04f, +4.573177959e-04f, +4.984708574e-04f, +4.786369835e-04f, +4.055074182e-04f, +2.942540920e-04f, +1.643780583e-04f, +3.602331742e-05f, -7.348422069e-05f, -1.522179874e-04f, -1.949369302e-04f, -2.029707573e-04f, -1.829017706e-04f, -1.444694044e-04f, -9.823241829e-05f, -5.350054635e-05f, -1.691293576e-05f, +8.159877660e-06f, +2.142445762e-05f, +2.488684375e-05f, +2.178580768e-05f, +1.554081285e-05f,
    /*  1,27 (48) */
    -2.992482924e-04f, -5.161425332e-04f, -7.619693040e-04f, -9.993784239e-04f, -1.172239576e-03f, -1.205867910e-03f, -1.009480542e-03f, -4.810385334e-04f, +4.856340025e-04f, +1.991846752e-03f, +4.123822392e-03f, +6.942151189e-03f, +1.047196184e-02f, +1.469489309e-02f, +1.954387566e-02f, +2.490154017e-02f, +3.060276630e-02f, +3.644151000e-02f, +4.218162598e-02f, +4.757098725e-02f, +5.235783912e-02f, +5.630805374e-02f, +5.922180670e-02f, +6.094820002e-02f, +6.139650865e-02f, +6.054301834e-02f, +5.843282187e-02f, +5.517640664e-02f, +5.094135058e-02f, +4.593989350e-02f, +4.041352017e-02f, +3.461594135e-02f, +2.879596596e-02f, +2.318171247e-02f, +1.796742122e-02f, +1.330382439e-02f, +9.292645361e-03f, +5.985377344e-03f, +3.386079964e-03f, +1.457574517e-03f, +1.301495090e-04f, -6.882696471e-04f, -1.101569931e-03f, -1.215523855e-03f, -1.129315731e-03f, -9.291054171e-04f, -6.839332393e-04f, -4.439884703e-04f,
    +6.050236397e-06f, +7.362395954e-06f, +7.796262099e-06f, +6.782889817e-06f, +3.727989835e-06f, -1.923340206e-06f, -1.061329869e-05f, -2.259701741e-05f, -3.787586248e-05f, -5.614730615e-05f, -7.677938468e-05f, -9.881578617e-05f, -1.210147169e-04f, -1.419211588e-04f, -1.599683410e-04f, -1.736006478e-04f, -1.814072243e-04f, -1.822536042e-04f, -1.753980729e-04f, -1.605803153e-04f, -1.380721657e-04f, -1.086837592e-04f, -7.372273107e-05f, -3.490884522e-05f, +5.748970827e-06f, +4.610227435e-05f, +8.402571100e-05f, +1.175774709e-04f, +1.451427229e-04f, +1.655469566e-04f, +1.781293332e-04f, +1.827703153e-04f, +1.798725349e-04f, +1.702985375e-04f, +1.552731878e-04f, +1.362616909e-04f, +1.148360655e-04f, +9.254332692e-05f, +7.078763450e-05f, +5.073639743e-05f, +3.325715046e-05f, +1.888830955e-05f, +7.843156605e-06f, +4.301144525e-08f, -4.827110191e-06f, -7.248730722e-06f, -7.794995958e-06f, -7.059081716e-06f,
    +3.662248589e-04f, +8.262054424e-04f, +1.489920096e-03f, +2.273112885e-03f, +2.984995501e-03f, +3.329277778e-03f, +2.937636937e-03f, +1.437497513e-03f, -1.453411019e-03f, -5.822871489e-03f, -1.147463225e-02f, -1.787984405e-02f, -2.419135849e-02f, -2.933176886e-02f, -3.215035648e-02f, -3.162699750e-02f, -2.708672161e-02f, -1.838092923e-02f, -5.992937580e-03f, +8.962870652e-03f, +2.485930091e-02f, +3.977912909e-02f, +5.180675194e-02f, +5.933665593e-02f, +6.134071769e-02f, +5.754262086e-02f, +4.846510781e-02f, +3.534071733e-02f, +1.990364802e-02f, +4.103499934e-03f, -1.020412557e-02f, -2.153275388e-02f, -2.895799486e-02f, -3.219933964e-02f, -3.158552758e-02f, -2.792131946e-02f, -2.229103428e-02f, -1.584278643e-02f, -9.595929189e-03f, -4.304072768e-03f, -3.903702877e-04f, +2.045333455e-03f, +3.162434237e-03f, +3.282594178e-03f, +2.786215603e-03f, +2.024836836e-03f, +1.263735077e-03f, +6.591871193e-04f,
    -1.091881357e-05f, -1.764247584e-05f, -2.324695131e-05f, -2.467468530e-05f, -1.846124455e-05f, -1.633825320e-06f, +2.720233902e-05f, +6.685359483e-05f, +1.129141757e-04f, +1.578062534e-04f, +1.916411728e-04f, +2.038722735e-04f, +1.854960989e-04f, +1.313730568e-04f, +4.213497453e-05f, -7.483568249e-05f, -2.057209625e-04f, -3.319848116e-04f, -4.332871834e-04f, -4.910938247e-04f, -4.922774745e-04f, -4.319519384e-04f, -3.148980846e-04f, -1.552117387e-04f, +2.582939980e-05f, +2.033021755e-04f, +3.528946277e-04f, +4.550415531e-04f, +4.981243193e-04f, +4.801254603e-04f, +4.084635409e-04f, +2.981196454e-04f, +1.685145269e-04f, +3.982752051e-05f, -7.048238377e-05f, -1.502930739e-04f, -1.941492378e-04f, -2.031898472e-04f, -1.838620601e-04f, -1.458421761e-04f, -9.969721340e-05f, -5.480150053e-05f, -1.789109874e-05f, +7.560481282e-06f, +2.117307309e-05f, +2.489631464e-05f, +2.194716213e-05f, +1.575330966e-05f,
    /*  1,28 (48) */
    -2.931980560e-04f, -5.087801372e-04f, -7.541730419e-04f, -9.925955341e-04f, -1.168511587e-03f, -1.207791250e-03f, -1.020093841e-03f, -5.036355508e-04f, +4.477581400e-04f, +1.935699446e-03f, +4.047043008e-03f, +6.843335402e-03f, +1.035094713e-02f, +1.455297193e-02f, +1.938390732e-02f, +2.472793953e-02f, +3.042135907e-02f, +3.625925639e-02f, +4.200622791e-02f, +4.741040693e-02f, +5.221976696e-02f, +5.619936998e-02f, +5.914808397e-02f, +6.091329118e-02f, +6.140225762e-02f, +6.058912062e-02f, +5.851684758e-02f, +5.529398411e-02f, +5.108649330e-02f, +4.610544046e-02f, +4.059164950e-02f, +3.479871167e-02f, +2.897583849e-02f, +2.335201101e-02f, +1.812269441e-02f, +1.344008609e-02f, +9.407481427e-03f, +6.077920671e-03f, +3.456867598e-03f, +1.508310914e-03f, +1.634066595e-04f, -6.693813375e-04f, -1.093726775e-03f, -1.215480844e-03f, -1.134142841e-03f, -9.363541479e-04f, -6.917282352e-04f, -4.510475520e-04f,
    +6.000721856e-06f, +7.331881716e-06f, +7.801524077e-06f, +6.842395104e-06f, +3.860079559e-06f, -1.702638511e-06f, -1.029262119e-05f, -2.217191876e-05f, -3.735069452e-05f, -5.553645002e-05f, -7.610761022e-05f, -9.811758948e-05f, -1.203325886e-04f, -1.413028526e-04f, -1.594633288e-04f, -1.732560555e-04f, -1.812636169e-04f, -1.823410354e-04f, -1.757328077e-04f, -1.611625883e-04f, -1.388852458e-04f, -1.096944677e-04f, -7.488341620e-05f, -3.616066610e-05f, +4.471732158e-06f, +4.486726377e-05f, +8.289737375e-05f, +1.166122207e-04f, +1.443848538e-04f, +1.650256649e-04f, +1.778570993e-04f, +1.827427547e-04f, +1.800696793e-04f, +1.706873651e-04f, +1.558111055e-04f, +1.369005902e-04f, +1.155265373e-04f, +9.323862873e-05f, +7.144705488e-05f, +5.132775100e-05f, +3.375824403e-05f, +1.928734033e-05f, +8.138117147e-06f, +2.402723706e-07f, -4.714799292e-06f, -7.204545832e-06f, -7.800370763e-06f, -7.095819678e-06f,
    +3.553060453e-04f, +8.085629665e-04f, +1.466673145e-03f, +2.248438199e-03f, +2.966534256e-03f, +3.327643953e-03f, +2.964839276e-03f, +1.504351108e-03f, -1.340496843e-03f, -5.665065235e-03f, -1.128299108e-02f, -1.767597177e-02f, -2.400586239e-02f, -2.920039581e-02f, -3.210822151e-02f, -3.170183318e-02f, -2.729244257e-02f, -1.871291404e-02f, -6.426224764e-03f, +8.471776828e-03f, +2.436702344e-02f, +3.934717715e-02f, +5.149185385e-02f, +5.918144419e-02f, +6.136654709e-02f, +5.774592303e-02f, +4.881800243e-02f, +3.579575888e-02f, +2.040177234e-02f, +4.583625394e-03f, -9.795662033e-03f, -2.123463423e-02f, -2.878948033e-02f, -3.215951212e-02f, -3.165600997e-02f, -2.807161254e-02f, -2.248518352e-02f, -1.604597628e-02f, -9.779791249e-03f, -4.449914944e-03f, -4.900675011e-04f, +1.990531954e-03f, +3.144543139e-03f, +3.290154659e-03f, +2.807388676e-03f, +2.049733151e-03f, +1.285682239e-03f, +6.749404290e-04f,
    -1.071657227e-05f, -1.743555650e-05f, -2.311730902e-05f, -2.472788286e-05f, -1.880348977e-05f, -2.339904673e-06f, +2.612342670e-05f, +6.548598165e-05f, +1.114457889e-04f, +1.565155274e-04f, +1.908574537e-04f, +2.039140682e-04f, +1.865978710e-04f, +1.336160942e-04f, +4.539939795e-05f, -7.088326246e-05f, -2.015961528e-04f, -3.283117689e-04f, -4.306937594e-04f, -4.900949110e-04f, -4.931702526e-04f, -4.347458496e-04f, -3.192961356e-04f, -1.606494561e-04f, +2.009320106e-05f, +1.980598351e-04f, +3.488539443e-04f, +4.527068295e-04f, +4.977173448e-04f, +4.815609030e-04f, +4.113815210e-04f, +3.019663296e-04f, +1.726521230e-04f, +4.365011838e-05f, -6.745020468e-05f, -1.483324988e-04f, -1.933271055e-04f, -2.033809683e-04f, -1.848040261e-04f, -1.472071174e-04f, -1.011634523e-04f, -5.611052704e-05f, -1.888071007e-05f, +6.949330726e-06f, +2.091192815e-05f, +2.489925524e-05f, +2.210540102e-05f, +1.596548744e-05f,
    /*  1,29 (48) */
    -2.871973341e-04f, -5.014482555e-04f, -7.463715178e-04f, -9.857531390e-04f, -1.164651507e-03f, -1.209493888e-03f, -1.030386462e-03f, -5.258074696e-04f, +4.104074455e-04f, +1.880162996e-03f, +3.970935397e-03f, +6.745217813e-03f, +1.023061454e-02f, +1.441166908e-02f, +1.922444399e-02f, +2.455468347e-02f, +3.024009546e-02f, +3.607691536e-02f, +4.183049510e-02f, +4.724924434e-02f, +5.208088171e-02f, +5.608967552e-02f, +5.907320056e-02f, +6.087713051e-02f, +6.140672936e-02f, +6.063398788e-02f, +5.859974496e-02f, +5.541059633e-02f, +5.123087815e-02f, +4.627046613e-02f, +4.076950660e-02f, +3.498145442e-02f, +2.915590817e-02f, +2.352269837e-02f, +1.827850552e-02f, +1.357698668e-02f, +9.523007964e-03f, +6.171159300e-03f, +3.528314653e-03f, +1.559638665e-03f, +1.971649035e-04f, -6.500939972e-04f, -1.085588658e-03f, -1.215240571e-03f, -1.138857640e-03f, -9.435586937e-04f, -6.995286060e-04f, -4.581433717e-04f,
    +5.950853705e-06f, +7.300532620e-06f, +7.805393139e-06f, +6.899921698e-06f, +3.989640402e-06f, -1.484908233e-06f, -9.975176579e-06f, -2.175006713e-05f, -3.682849015e-05f, -5.492795017e-05f, -7.543726457e-05f, -9.741961088e-05f, -1.196492544e-04f, -1.406818019e-04f, -1.589540398e-04f, -1.729057912e-04f, -1.811132097e-04f, -1.824209217e-04f, -1.760597234e-04f, -1.617372905e-04f, -1.396915333e-04f, -1.106996535e-04f, -7.604025715e-05f, -3.741061019e-05f, +3.194260694e-06f, +4.362992850e-05f, +8.176479580e-05f, +1.156411315e-04f, +1.436199778e-04f, +1.644967024e-04f, +1.775770628e-04f, +1.827077745e-04f, +1.802602417e-04f, +1.710708076e-04f, +1.563450745e-04f, +1.375370856e-04f, +1.162161284e-04f, +9.393443463e-05f, +7.210813297e-05f, +5.192162170e-05f, +3.426239038e-05f, +1.968963904e-05f, +8.436272395e-06f, +4.404208828e-07f, -4.600073246e-06f, -7.158509723e-06f, -7.804479049e-06f, -7.131836001e-06f,
    +3.445894731e-04f, +7.911274100e-04f, +1.443555836e-03f, +2.223710317e-03f, +2.947730766e-03f, +3.325304048e-03f, +2.990962703e-03f, +1.569837089e-03f, -1.229051054e-03f, -5.508549708e-03f, -1.109213363e-02f, -1.747205771e-02f, -2.381926452e-02f, -2.906677971e-02f, -3.206282211e-02f, -3.177271645e-02f, -2.749403872e-02f, -1.904122581e-02f, -6.856918523e-03f, +7.981681917e-03f, +2.387385319e-02f, +3.891243130e-02f, +5.117255772e-02f, +5.902079474e-02f, +6.138664029e-02f, +5.794398287e-02f, +4.916685638e-02f, +3.624846571e-02f, +2.089948969e-02f, +5.065186297e-03f, -9.384280512e-03f, -2.093266790e-02f, -2.861682821e-02f, -3.211586200e-02f, -3.172346017e-02f, -2.821994504e-02f, -2.267851063e-02f, -1.624935725e-02f, -9.964595275e-03f, -4.597122062e-03f, -5.912309534e-04f, +1.934421427e-03f, +3.125662429e-03f, +3.297103990e-03f, +2.828300604e-03f, +2.074632406e-03f, +1.307787641e-03f, +6.909059164e-04f,
    -1.051543136e-05f, -1.722770722e-05f, -2.298372996e-05f, -2.477368699e-05f, -1.913531668e-05f, -3.034053170e-06f, +2.505542575e-05f, +6.412507928e-05f, +1.099767330e-04f, +1.552143899e-04f, +1.900528304e-04f, +2.039258891e-04f, +1.876643381e-04f, +1.358241603e-04f, +4.863587167e-05f, -6.694533766e-05f, -1.974676028e-04f, -3.246148259e-04f, -4.280579225e-04f, -4.890403118e-04f, -4.940021681e-04f, -4.374832914e-04f, -3.236513949e-04f, -1.660652804e-04f, +1.435425164e-05f, +1.927905726e-04f, +3.447667631e-04f, +4.503138436e-04f, +4.972498479e-04f, +4.829429533e-04f, +4.142608086e-04f, +3.057935123e-04f, +1.767902467e-04f, +4.749064148e-05f, -6.438795966e-05f, -1.463363255e-04f, -1.924704065e-04f, -2.035438583e-04f, -1.857273426e-04f, -1.485639094e-04f, -1.026308797e-04f, -5.742746693e-05f, -1.988171347e-05f, +6.326395649e-06f, +2.064093598e-05f, +2.489555680e-05f, +2.226042371e-05f, +1.617727343e-05f,
    /*  1,30 (48) */
    -2.812464804e-04f, -4.941477229e-04f, -7.385661247e-04f, -9.788532173e-04f, -1.160661867e-03f, -1.210978797e-03f, -1.040361638e-03f, -5.475575367e-04f, +3.735789553e-04f, +1.825235046e-03f, +3.895498133e-03f, +6.647798202e-03f, +1.011096528e-02f, +1.427098728e-02f, +1.906548995e-02f, +2.438177768e-02f, +3.005898225e-02f, +3.589449444e-02f, +4.165443537e-02f, +4.708750705e-02f, +5.194119018e-02f, +5.597897586e-02f, +5.899716030e-02f, +6.083971990e-02f, +6.140992362e-02f, +6.067761781e-02f, +5.868150975e-02f, +5.552623746e-02f, +5.137449813e-02f, +4.643496283e-02f, +4.094708366e-02f, +3.516416220e-02f, +2.933616842e-02f, +2.369376918e-02f, +1.843485059e-02f, +1.371452376e-02f, +9.639224092e-03f, +6.265093734e-03f, +3.600422786e-03f, +1.611560287e-03f, +2.314272939e-04f, -6.304043582e-04f, -1.077152385e-03f, -1.214800150e-03f, -1.143457714e-03f, -9.507172034e-04f, -7.073330850e-04f, -4.652752077e-04f,
    +5.900645350e-06f, +7.268365081e-06f, +7.807887439e-06f, +6.955487723e-06f, +4.116688316e-06f, -1.270137912e-06f, -9.660960103e-06f, -2.133146638e-05f, -3.630926307e-05f, -5.432183054e-05f, -7.476838129e-05f, -9.672189189e-05f, -1.189647611e-04f, -1.400580555e-04f, -1.584405205e-04f, -1.725498952e-04f, -1.809560329e-04f, -1.824932796e-04f, -1.763788209e-04f, -1.623044060e-04f, -1.404909963e-04f, -1.116992702e-04f, -7.719319639e-05f, -3.865861306e-05f, +1.916622938e-06f, +4.239033203e-05f, +8.062803289e-05f, +1.146642473e-04f, +1.428481242e-04f, +1.639600817e-04f, +1.772892198e-04f, +1.826653555e-04f, +1.804441899e-04f, +1.714488231e-04f, +1.568750475e-04f, +1.381711284e-04f, +1.169047926e-04f, +9.463070442e-05f, +7.277083693e-05f, +5.251798750e-05f, +3.476957772e-05f, +2.009520355e-05f, +8.737628506e-06f, +6.434694612e-07f, -4.482915520e-06f, -7.110604110e-06f, -7.807302866e-06f, -7.167114757e-06f,
    +3.340740417e-04f, +7.738997028e-04f, +1.420572106e-03f, +2.198936630e-03f, +2.928595450e-03f, +3.322269995e-03f, +3.016018128e-03f, +1.633962169e-03f, -1.119074321e-03f, -5.353335318e-03f, -1.090208080e-02f, -1.726813182e-02f, -2.363160019e-02f, -2.893095555e-02f, -3.201418624e-02f, -3.183966178e-02f, -2.769150633e-02f, -1.936584064e-02f, -7.284976446e-03f, +7.492641605e-03f, +2.337985102e-02f, +3.847494801e-02f, +5.084890632e-02f, +5.885472945e-02f, +6.140099454e-02f, +5.813677344e-02f, +4.951162314e-02f, +3.669877956e-02f, +2.139673953e-02f, +5.548129250e-03f, -8.970019704e-03f, -2.062687439e-02f, -2.844003796e-02f, -3.206837136e-02f, -3.178784813e-02f, -2.836628136e-02f, -2.287098103e-02f, -1.645290111e-02f, -1.015032262e-02f, -4.745685971e-03f, -6.938618331e-04f, +1.876993960e-03f, +3.105780715e-03f, +3.303430386e-03f, +2.848941540e-03f, +2.099527963e-03f, +1.330048064e-03f, +7.070831898e-04f,
    -1.031543611e-05f, -1.701900789e-05f, -2.284631865e-05f, -2.481220449e-05f, -1.945680269e-05f, -3.716284432e-06f, +2.399841424e-05f, +6.277106912e-05f, +1.085072808e-04f, +1.539031669e-04f, +1.892276213e-04f, +2.039079747e-04f, +1.886955890e-04f, +1.379971457e-04f, +5.184407396e-05f, -6.302241295e-05f, -1.933359288e-04f, -3.208946069e-04f, -4.253801896e-04f, -4.879303311e-04f, -4.947732413e-04f, -4.401639799e-04f, -3.279633107e-04f, -1.714584810e-04f, +8.613337121e-06f, +1.874950937e-04f, +3.406335909e-04f, +4.478628235e-04f, +4.967217519e-04f, +4.842712606e-04f, +4.171008580e-04f, +3.096005616e-04f, +1.809282955e-04f, +5.134861502e-05f, -6.129593148e-05f, -1.443046239e-04f, -1.915790189e-04f, -2.036782580e-04f, -1.866316842e-04f, -1.499122321e-04f, -1.040992379e-04f, -5.875215808e-05f, -2.089404958e-05f, +5.691648011e-06f, +2.036001099e-05f, +2.488511074e-05f, +2.241212896e-05f, +1.638859383e-05f,
    /*  1,31 (48) */
    -2.753458351e-04f, -4.868793578e-04f, -7.307582372e-04f, -9.718977296e-04f, -1.156545178e-03f, -1.212248935e-03f, -1.050022599e-03f, -5.688890031e-04f, +3.372696922e-04f, +1.770913215e-03f, +3.820729751e-03f, +6.551076310e-03f, +9.992000524e-03f, +1.413092922e-02f, +1.890704943e-02f, +2.420922778e-02f, +2.987802621e-02f, +3.571200116e-02f, +4.147805655e-02f, +4.692520265e-02f, +5.180069918e-02f, +5.586727659e-02f, +5.891996710e-02f, +6.080106129e-02f, +6.141184024e-02f, +6.072000814e-02f, +5.876213779e-02f, +5.564090171e-02f, +5.151734626e-02f, +4.659892291e-02f, +4.112437288e-02f, +3.534682755e-02f, +2.951661261e-02f, +2.386521801e-02f, +1.859172564e-02f, +1.385269489e-02f, +9.756128885e-03f, +6.359724439e-03f, +3.673193623e-03f, +1.664078274e-03f, +2.661968716e-04f, -6.103091546e-04f, -1.068414757e-03f, -1.214156681e-03f, -1.147940629e-03f, -9.578278075e-04f, -7.151403879e-04f, -4.724423225e-04f,
    +5.850110091e-06f, +7.235395433e-06f, +7.809025104e-06f, +7.009111338e-06f, +4.241239355e-06f, -1.058315911e-06f, -9.349966785e-06f, -2.091612006e-05f, -3.579302665e-05f, -5.371811474e-05f, -7.410099365e-05f, -9.602447380e-05f, -1.182791553e-04f, -1.394316620e-04f, -1.579228174e-04f, -1.721884081e-04f, -1.807921168e-04f, -1.825581262e-04f, -1.766901015e-04f, -1.628639195e-04f, -1.412836031e-04f, -1.126932717e-04f, -7.834217668e-05f, -3.990461040e-05f, +6.388853996e-07f, +4.114853805e-05f, +7.948714106e-05f, +1.136816124e-04f, +1.420693226e-04f, +1.634158161e-04f, +1.769935670e-04f, +1.826154788e-04f, +1.806214921e-04f, +1.718213704e-04f, +1.574009775e-04f, +1.388026701e-04f, +1.175924836e-04f, +9.532739769e-05f, +7.343513463e-05f, +5.311682607e-05f, +3.527979396e-05f, +2.050403146e-05f, +9.042191405e-06f, +8.494304210e-07f, -4.363309672e-06f, -7.060810728e-06f, -7.808824226e-06f, -7.201639933e-06f,
    +3.237586056e-04f, +7.568806949e-04f, +1.397725787e-03f, +2.174124425e-03f, +2.909138647e-03f, +3.318553711e-03f, +3.040016543e-03f, +1.696733238e-03f, -1.010567040e-03f, -5.199432151e-03f, -1.071285317e-02f, -1.706422384e-02f, -2.344290460e-02f, -2.879295841e-02f, -3.196234216e-02f, -3.190268420e-02f, -2.788484225e-02f, -1.968673524e-02f, -7.710356635e-03f, +7.004711274e-03f, +2.288507778e-02f, +3.803478403e-02f, +5.052094301e-02f, +5.868327097e-02f, +6.140960788e-02f, +5.832426853e-02f, +4.985225673e-02f, +3.714664238e-02f, +2.189346129e-02f, +6.032400511e-03f, -8.552918846e-03f, -2.031727383e-02f, -2.825910966e-02f, -3.201702274e-02f, -3.184914406e-02f, -2.851058599e-02f, -2.306256005e-02f, -1.665657936e-02f, -1.033695430e-02f, -4.895598203e-03f, -7.979610710e-04f, +1.818241802e-03f, +3.084886666e-03f, +3.309122034e-03f, +2.869301551e-03f, +2.124413074e-03f, +1.352460193e-03f, +7.234717837e-04f,
    -1.011663066e-05f, -1.680953745e-05f, -2.270517913e-05f, -2.484354255e-05f, -1.976802667e-05f, -4.386614560e-06f, +2.295246704e-05f, +6.142412938e-05f, +1.070377027e-04f, +1.525821837e-04f, +1.883821463e-04f, +2.038605671e-04f, +1.896917185e-04f, +1.401349478e-04f, +5.502368951e-05f, -5.911498836e-05f, -1.892017453e-04f, -3.171517381e-04f, -4.226610826e-04f, -4.867652811e-04f, -4.954835019e-04f, -4.427876402e-04f, -3.322313388e-04f, -1.768283313e-04f, +2.871243403e-06f, +1.821741084e-04f, +3.364549421e-04f, +4.453540068e-04f, +4.961329892e-04f, +4.855454817e-04f, +4.199011281e-04f, +3.133868468e-04f, +1.850656642e-04f, +5.522355901e-05f, -5.817440947e-05f, -1.422374703e-04f, -1.906528266e-04f, -2.037839118e-04f, -1.875167265e-04f, -1.512517643e-04f, -1.055682666e-04f, -6.008443510e-05f, -2.191765594e-05f, +5.045062098e-06f, +2.006906889e-05f, +2.486780869e-05f, +2.256041491e-05f, +1.659937380e-05f,
    /*  2, 0 (48) */
    +2.604271951e-04f, +6.520713960e-04f, +1.184392264e-03f, +1.737066681e-03f, +2.100859845e-03f, +2.003596444e-03f, +1.168352244e-03f, -6.020526720e-04f, -3.329654867e-03f, -6.777842271e-03f, -1.040531144e-02f, -1.337949151e-02f, -1.466132590e-02f, -1.315819186e-02f, -7.924759808e-03f, +1.623190098e-03f, +1.552555605e-02f, +3.316834873e-02f, +5.328028472e-02f, +7.404900985e-02f, +9.334657971e-02f, +1.090303366e-01f, +1.192675993e-01f, +1.228249582e-01f, +1.192675993e-01f, +1.090303366e-01f, +9.334657971e-02f, +7.404900985e-02f, +5.328028472e-02f, +3.316834873e-02f, +1.552555605e-02f, +1.623190098e-03f, -7.924759808e-03f, -1.315819186e-02f, -1.466132590e-02f, -1.337949151e-02f, -1.040531144e-02f, -6.777842271e-03f, -3.329654867e-03f, -6.020526720e-04f, +1.168352244e-03f, +2.003596444e-03f, +2.100859845e-03f, +1.737066681e-03f, +1.184392264e-03f, +6.520713960e-04f, +2.604271951e-04f, +4.414624996e-05f,
    -9.397733863e-06f, -1.475159068e-05f, -1.780699796e-05f, -1.570575921e-05f, -5.894492519e-06f, +1.287546454e-05f, +3.958040364e-05f, +7.028847262e-05f, +9.813493822e-05f, +1.140815919e-04f, +1.084565141e-04f, +7.306034295e-05f, +3.434800198e-06f, -9.922656802e-05f, -2.270449294e-04f, -3.656871562e-04f, -4.960023257e-04f, -5.968946951e-04f, -6.489612978e-04f, -6.382023119e-04f, -5.590356192e-04f, -4.159420831e-04f, -2.233226464e-04f, -3.510128802e-06f, +2.167329417e-04f, +4.105735155e-04f, +5.554809118e-04f, +6.367671050e-04f, +6.496292006e-04f, +5.993511841e-04f, +4.997098643e-04f, +3.699938620e-04f, +2.313033964e-04f, +1.028991279e-04f, -7.032857366e-07f, -7.141256319e-05f, -1.078360932e-04f, -1.142811527e-04f, -9.886406891e-05f, -7.124467603e-05f, -4.050800932e-05f, -1.360250026e-05f, +5.444930471e-06f, +1.552678732e-05f, +1.783443122e-05f, +1.489615403e-05f, +9.574142015e-06f, +4.266520574e-06f,
    +7.781537535e-05f, -5.172646125e-04f, -1.673334699e-03f, -3.203343269e-03f, -4.525223175e-03f, -4.733635501e-03f, -2.892950492e-03f, +1.502882723e-03f, +8.068686861e-03f, +1.529267543e-02f, +2.072324747e-02f, +2.163579289e-02f, +1.603304991e-02f, +3.643522741e-03f, -1.349956937e-02f, -3.123170394e-02f, -4.427068528e-02f, -4.783283965e-02f, -3.933589198e-02f, -1.956599624e-02f, +7.183458326e-03f, +3.415533317e-02f, +5.408068209e-02f, +6.141247912e-02f, +5.408068209e-02f, +3.415533317e-02f, +7.183458326e-03f, -1.956599624e-02f, -3.933589198e-02f, -4.783283965e-02f, -4.427068528e-02f, -3.123170394e-02f, -1.349956937e-02f, +3.643522741e-03f, +1.603304991e-02f, +2.163579289e-02f, +2.072324747e-02f, +1.529267543e-02f, +8.068686861e-03f, +1.502882723e-03f, -2.892950492e-03f, -4.733635501e-03f, -4.525223175e-03f, -3.203343269e-03f, -1.673334699e-03f, -5.172646125e-04f, +7.781537535e-05f, +2.181178524e-04f,
    +1.021445183e-05f, +2.711764488e-05f, +4.373606909e-05f, +4.870636224e-05f, +2.965876477e-05f, -2.020862008e-05f, -9.543065144e-05f, -1.750445952e-04f, -2.258666913e-04f, -2.129807855e-04f, -1.147623742e-04f, +6.321493412e-05f, +2.820361204e-04f, +4.757918698e-04f, +5.706234531e-04f, +5.111620793e-04f, +2.849053907e-04f, -6.564268988e-05f, -4.497141734e-04f, -7.537672688e-04f, -8.781008671e-04f, -7.718669222e-04f, -4.533676142e-04f, -7.335878262e-06f, +4.407740003e-04f, +7.648400958e-04f, +8.783629926e-04f, +7.607940572e-04f, +4.610216661e-04f, +7.770478446e-05f, -2.754656586e-04f, -5.065395392e-04f, -5.712966145e-04f, -4.806170152e-04f, -2.888598211e-04f, -6.972252126e-05f, +1.102912474e-04f, +2.112555732e-04f, +2.265914423e-04f, +1.772601301e-04f, +9.800087468e-05f, +2.224447147e-05f, -2.857587745e-05f, -4.853198241e-05f, -4.413533489e-05f, -2.769009656e-05f, -1.066792104e-05f, +3.030211128e-07f,
    /*  2, 1 (48) */
    +2.510294612e-04f, +6.373198053e-04f, +1.166585266e-03f, +1.721360922e-03f, +2.094965353e-03f, +2.016471909e-03f, +1.207932647e-03f, -5.317641994e-04f, -3.231519929e-03f, -6.663760679e-03f, -1.029685493e-02f, -1.330643117e-02f, -1.465789110e-02f, -1.325741842e-02f, -8.151804737e-03f, +1.257502941e-03f, +1.502955372e-02f, +3.257145404e-02f, +5.263132342e-02f, +7.341080754e-02f, +9.278754409e-02f, +1.086143945e-01f, +1.190442767e-01f, +1.228214481e-01f, +1.194843323e-01f, +1.094409101e-01f, +9.390206062e-02f, +7.468577696e-02f, +5.392991392e-02f, +3.376769992e-02f, +1.602526591e-02f, +1.993183960e-03f, -7.693456411e-03f, -1.305529273e-02f, -1.466202918e-02f, -1.345090407e-02f, -1.051314753e-02f, -6.892123423e-03f, -3.428518936e-03f, -6.732973481e-04f, +1.127844235e-03f, +1.989993944e-03f, +2.106304776e-03f, +1.752593469e-03f, +1.202226696e-03f, +6.669675500e-04f, +2.700013371e-04f, +4.841277053e-05f,
    -9.221479075e-06f, -1.460482609e-05f, -1.777450663e-05f, -1.587709547e-05f, -6.335117472e-06f, +1.215642107e-05f, +3.865695453e-05f, +6.932966021e-05f, +9.739424462e-05f, +1.138608472e-04f, +1.090475536e-04f, +7.467422635e-05f, +6.133495444e-06f, -9.557911602e-05f, -2.227974382e-04f, -3.613724853e-04f, -4.922659171e-04f, -5.943900778e-04f, -6.482313423e-04f, -6.395698761e-04f, -5.625270708e-04f, -4.212616238e-04f, -2.298854257e-04f, -1.052996006e-05f, +2.101170941e-04f, +4.051565071e-04f, +5.518632500e-04f, +6.352642376e-04f, +6.502347371e-04f, +6.017590106e-04f, +5.033878865e-04f, +3.742919618e-04f, +2.355723082e-04f, +1.065964465e-04f, +2.060909781e-06f, -6.973082794e-05f, -1.071860828e-04f, -1.144592400e-04f, -9.958133640e-05f, -7.219801774e-05f, -4.143960274e-05f, -1.433745413e-05f, +4.986422344e-06f, +1.534011438e-05f, +1.785671677e-05f, +1.503843121e-05f, +9.750642811e-06f, +4.414790764e-06f,
    +8.802982718e-05f, -4.901469677e-04f, -1.629598630e-03f, -3.154636907e-03f, -4.495564410e-03f, -4.753844121e-03f, -2.988381144e-03f, +1.327838128e-03f, +7.842820170e-03f, +1.507969465e-02f, +2.060848510e-02f, +2.169900783e-02f, +1.631508603e-02f, +4.119314611e-03f, -1.292894591e-02f, -3.072054186e-02f, -4.398577989e-02f, -4.789848234e-02f, -3.978560615e-02f, -2.031976351e-02f, +6.305357459e-03f, +3.338346624e-02f, +5.362731448e-02f, +6.140514325e-02f, +5.452145609e-02f, +3.492017326e-02f, +8.061821318e-03f, -1.880520218e-02f, -3.887487031e-02f, -4.775513486e-02f, -4.454615094e-02f, -3.173824348e-02f, -1.407086598e-02f, +3.162905726e-03f, +1.574419009e-02f, +2.156607037e-02f, +2.083353872e-02f, +1.550393101e-02f, +8.295278303e-03f, +1.680142853e-03f, -2.794949618e-03f, -4.711391030e-03f, -4.553799053e-03f, -3.251875252e-03f, -1.717470034e-03f, -5.449547091e-04f, +6.714745431e-05f, +2.184208735e-04f,
    +9.767473893e-06f, +2.654535421e-05f, +4.332554241e-05f, +4.885683791e-05f, +3.071051883e-05f, -1.819886387e-05f, -9.286579528e-05f, -1.728011389e-04f, -2.250786348e-04f, -2.146203664e-04f, -1.191527570e-04f, +5.674957623e-05f, +2.751886761e-04f, +4.708685948e-04f, +5.697959909e-04f, +5.156170440e-04f, +2.942196033e-04f, -5.361531476e-05f, -4.383273960e-04f, -7.465608329e-04f, -8.776076910e-04f, -7.786807920e-04f, -4.658332083e-04f, -2.200554834e-05f, +4.280558673e-04f, +7.576020354e-04f, +8.783935306e-04f, +7.676386936e-04f, +4.722463287e-04f, +8.979821280e-05f, -2.659025952e-04f, -5.017498821e-04f, -5.718143049e-04f, -4.853418550e-04f, -2.956574536e-04f, -7.627062286e-05f, +1.057400680e-04f, +2.094444104e-04f, +2.272519091e-04f, +1.794465983e-04f, +1.005755783e-04f, +2.430601068e-05f, -2.746179810e-05f, -4.833335192e-05f, -4.452293401e-05f, -2.826241838e-05f, -1.112777301e-05f, +7.525040422e-08f,
    /*  2, 2 (48) */
    +2.418079821e-04f, +6.227149792e-04f, +1.148810760e-03f, +1.705483827e-03f, +2.088630235e-03f, +2.028628330e-03f, +1.246589602e-03f, -4.624345392e-04f, -3.134125684e-03f, -6.549899832e-03f, -1.018780737e-02f, -1.323175694e-02f, -1.465175760e-02f, -1.335299754e-02f, -8.374602175e-03f, +8.961304561e-04f, +1.453728781e-02f, +3.197706396e-02f, +5.198309208e-02f, +7.277123767e-02f, +9.222501702e-02f, +1.081931329e-01f, +1.188143913e-01f, +1.228109182e-01f, +1.196944494e-01f, +1.098460666e-01f, +9.445392387e-02f, +7.532104120e-02f, +5.458014866e-02f, +3.436945893e-02f, +1.652865380e-02f, +2.367475921e-03f, -7.457884103e-03f, -1.294869628e-02f, -1.465996827e-02f, -1.352063490e-02f, -1.062033362e-02f, -7.006582663e-03f, -3.528100272e-03f, -7.454953658e-04f, +1.086404632e-03f, +1.975656490e-03f, +2.111291198e-03f, +1.767933583e-03f, +1.220083412e-03f, +6.820059812e-04f, +2.797519799e-04f, +5.282756130e-05f,
    -9.045437432e-06f, -1.445594466e-05f, -1.773704708e-05f, -1.604086273e-05f, -6.766816532e-06f, +1.144544108e-05f, +3.773782790e-05f, +6.836848933e-05f, +9.664228773e-05f, +1.136192096e-04f, +1.096094236e-04f, +7.625427805e-05f, +8.799239900e-06f, -9.195711480e-05f, -2.185614491e-04f, -3.570504884e-04f, -4.885012868e-04f, -5.918378714e-04f, -6.474396557e-04f, -6.408698258e-04f, -5.659549751e-04f, -4.265315589e-04f, -2.364205011e-04f, -1.754851234e-05f, +2.034758906e-04f, +3.996916520e-04f, +5.481829449e-04f, +6.336937015e-04f, +6.507776023e-04f, +6.041176459e-04f, +5.070357475e-04f, +3.785808125e-04f, +2.398511288e-04f, +1.103181681e-04f, +4.857641601e-06f, -6.801508365e-05f, -1.065062782e-04f, -1.146155658e-04f, -1.002864397e-04f, -7.314824287e-05f, -4.237501215e-05f, -1.508024918e-05f, +4.518961403e-06f, +1.514567628e-05f, +1.787376529e-05f, +1.517833682e-05f, +9.927174596e-06f, +4.564577659e-06f,
    +9.779730107e-05f, -4.636016135e-04f, -1.586273087e-03f, -3.105780069e-03f, -4.464853891e-03f, -4.772042985e-03f, -3.081246939e-03f, +1.155036989e-03f, +7.617741535e-03f, +1.486507428e-02f, +2.048933234e-02f, +2.175575740e-02f, +1.659027470e-02f, +4.590183206e-03f, -1.235914992e-02f, -3.020492482e-02f, -4.369156029e-02f, -4.795209765e-02f, -4.022393355e-02f, -2.106632434e-02f, +5.427749768e-03f, +3.260478545e-02f, +5.316148127e-02f, +6.138313770e-02f, +5.494951196e-02f, +3.567777530e-02f, +8.940214849e-03f, -1.803756349e-02f, -3.840262399e-02f, -4.766533665e-02f, -4.481205354e-02f, -3.223999336e-02f, -1.464268029e-02f, +2.677563871e-03f, +1.544853263e-02f, +2.148979975e-02f, +2.093927879e-02f, +1.571337542e-02f, +8.522530212e-03f, +1.859589451e-03f, -2.694374039e-03f, -4.687085019e-03f, -4.581260851e-03f, -3.300208604e-03f, -1.761992968e-03f, -5.732171275e-04f, +5.601968130e-05f, +2.184961239e-04f,
    +9.327090145e-06f, +2.597351020e-05f, +4.290415923e-05f, +4.898376114e-05f, +3.173121068e-05f, -1.621559433e-05f, -9.030718001e-05f, -1.705309043e-04f, -2.242282643e-04f, -2.161746624e-04f, -1.234617384e-04f, +5.032813447e-05f, +2.683198039e-04f, +4.658493838e-04f, +5.688154408e-04f, +5.199040306e-04f, +3.034061574e-04f, -4.162602116e-05f, -4.268648926e-04f, -7.391773030e-04f, -8.768840711e-04f, -7.852800500e-04f, -4.781673233e-04f, -3.666895974e-05f, +4.152167559e-04f, +7.501545301e-04f, +8.781920142e-04f, +7.742987235e-04f, +4.833846306e-04f, +1.019195666e-04f, -2.562184377e-04f, -4.967936220e-04f, -5.721753980e-04f, -4.899642325e-04f, -3.024266850e-04f, -8.285749660e-05f, +1.011095612e-04f, +2.075470058e-04f, +2.278471264e-04f, +1.816028521e-04f, +1.031538630e-04f, +2.639281442e-05f, -2.631648037e-05f, -4.811012979e-05f, -4.489845939e-05f, -2.883431423e-05f, -1.159389361e-05f, -1.598987474e-07f,
    /*  2, 3 (48) */
    +2.327625447e-04f, +6.082590345e-04f, +1.131073713e-03f, +1.689442964e-03f, +2.081863419e-03f, +2.040073771e-03f, +1.284327430e-03f, -3.940660499e-04f, -3.037483396e-03f, -6.436280622e-03f, -1.007819795e-02f, -1.315550266e-02f, -1.464295836e-02f, -1.344495466e-02f, -8.593163625e-03f, +5.390799677e-04f, +1.404878652e-02f, +3.138522609e-02f, +5.133565242e-02f, +7.213036784e-02f, +9.165906204e-02f, +1.077666013e-01f, +1.185779707e-01f, +1.227933696e-01f, +1.198979252e-01f, +1.102457583e-01f, +9.500210682e-02f, +7.595473490e-02f, +5.523092626e-02f, +3.497357657e-02f, +1.703568955e-02f, +2.746056734e-03f, -7.218032974e-03f, -1.283837811e-02f, -1.465511063e-02f, -1.358864998e-02f, -1.072683989e-02f, -7.121198229e-03f, -3.628386712e-03f, -8.186436087e-04f, +1.044029620e-03f, +1.960576241e-03f, +2.115810160e-03f, +1.783079259e-03f, +1.237957178e-03f, +6.971843180e-04f, +2.896791545e-04f, +5.739213896e-05f,
    -8.869667763e-06f, -1.430503026e-05f, -1.769470941e-05f, -1.619712886e-05f, -7.189603096e-06f, +1.074259293e-05f, +3.682318671e-05f, +6.740520824e-05f, +9.587936640e-05f, +1.133569712e-04f, +1.101423396e-04f, +7.780056820e-05f, +1.143190856e-05f, -8.836090079e-05f, -2.143374835e-04f, -3.527218023e-04f, -4.847090843e-04f, -5.892386203e-04f, -6.465865679e-04f, -6.421021986e-04f, -5.693190501e-04f, -4.317513181e-04f, -2.429270989e-04f, -2.456493322e-05f, +1.968101222e-04f, +3.941795518e-04f, +5.444403173e-04f, +6.320554984e-04f, +6.512574993e-04f, +6.064265671e-04f, +5.106528043e-04f, +3.828597697e-04f, +2.441393179e-04f, +1.140639309e-04f, +7.686758355e-06f, -6.626528240e-05f, -1.057964787e-04f, -1.147498435e-04f, -1.009790774e-04f, -7.409509441e-05f, -4.331406289e-05f, -1.583080551e-05f, +4.042543184e-06f, +1.494341021e-05f, +1.788548775e-05f, +1.531578494e-05f, +1.010367479e-05f, +4.715850413e-06f,
    +1.071243912e-04f, -4.376281033e-04f, -1.543368928e-03f, -3.056796308e-03f, -4.433122681e-03f, -4.788258580e-03f, -3.171554119e-03f, +9.845060845e-04f, +7.393513271e-03f, +1.464889962e-02f, +2.036587060e-02f, +2.180608554e-02f, +1.685859451e-02f, +5.056032590e-03f, -1.179033448e-02f, -2.968502079e-02f, -4.338815413e-02f, -4.799372367e-02f, -4.065079844e-02f, -2.180550164e-02f, +4.550865697e-03f, +3.181950540e-02f, +5.268331394e-02f, +6.134646874e-02f, +5.536472871e-02f, +3.642792983e-02f, +9.818406863e-03f, -1.726326477e-02f, -3.791923935e-02f, -4.756341708e-02f, -4.506827197e-02f, -3.273678699e-02f, -1.521485568e-02f, +2.187599639e-03f, +1.514610595e-02f, +2.140694225e-02f, +2.104038835e-02f, +1.592092242e-02f, +8.750377339e-03f, +2.041192303e-03f, -2.591220176e-03f, -4.660692205e-03f, -4.607577331e-03f, -3.348318733e-03f, -1.806891427e-03f, -6.020514417e-04f, +4.442578769e-05f, +2.183362251e-04f,
    +8.893397928e-06f, +2.540239313e-05f, +4.247232228e-05f, +4.908748870e-05f, +3.272092345e-05f, -1.425918711e-05f, -8.775566630e-05f, -1.682350316e-04f, -2.233165834e-04f, -2.176440466e-04f, -1.276886948e-04f, +4.395226739e-05f, +2.614318102e-04f, +4.607364475e-04f, +5.676830579e-04f, +5.240226921e-04f, +3.124629637e-04f, -2.967814651e-05f, -4.153302342e-04f, -7.316192808e-04f, -8.759306836e-04f, -7.916631086e-04f, -4.903665421e-04f, -5.132194230e-05f, +4.022602460e-04f, +7.424994357e-04f, +8.777580473e-04f, +7.807717433e-04f, +4.944330571e-04f, +1.140654159e-04f, -2.464154710e-04f, -4.916713289e-04f, -5.723788116e-04f, -4.944820104e-04f, -3.091651753e-04f, -8.948137306e-05f, +9.640048616e-05f, +2.055630957e-04f, +2.283761428e-04f, +1.837277423e-04f, +1.057348169e-04f, +2.850444351e-05f, -2.513989055e-05f, -4.786198073e-05f, -4.526150288e-05f, -2.940548286e-05f, -1.206616299e-05f, -4.024611317e-07f,
    /*  2, 4 (48) */
    +2.238928769e-04f, +5.939540043e-04f, +1.113379003e-03f, +1.673245835e-03f, +2.074673816e-03f, +2.050816364e-03f, +1.321150617e-03f, -3.266608416e-04f, -2.941604030e-03f, -6.322923651e-03f, -9.968055609e-03f, -1.307770209e-02f, -1.463152645e-02f, -1.353331556e-02f, -8.807501108e-03f, +1.863581655e-04f, +1.356407744e-02f, +3.079598747e-02f, +5.068906585e-02f, +7.148826564e-02f, +9.108974299e-02f, +1.073348500e-01f, +1.183350437e-01f, +1.227688047e-01f, +1.200947354e-01f, +1.106399378e-01f, +9.554654713e-02f, +7.658679040e-02f, +5.588218376e-02f, +3.558000314e-02f, +1.754634235e-02f, +3.128916504e-03f, -6.973893657e-03f, -1.272431418e-02f, -1.464742387e-02f, -1.365491527e-02f, -1.083263637e-02f, -7.235948073e-03f, -3.729365789e-03f, -8.927387031e-04f, +1.000715557e-03f, +1.944745435e-03f, +2.119852703e-03f, +1.798022669e-03f, +1.255842665e-03f, +7.125001030e-04f, +2.997828293e-04f, +6.210798937e-05f,
    -8.694227944e-06f, -1.415216617e-05f, -1.764758391e-05f, -1.634596290e-05f, -7.603492727e-06f, +1.004794213e-05f, +3.591319099e-05f, +6.644006295e-05f, +9.510577867e-05f, +1.130744256e-04f, +1.106465203e-04f, +7.931317237e-05f, +1.403138297e-05f, -8.479080402e-05f, -2.101260580e-04f, -3.483870618e-04f, -4.808899607e-04f, -5.865928741e-04f, -6.456724169e-04f, -6.432670421e-04f, -5.726190240e-04f, -4.369203387e-04f, -2.494044498e-04f, -3.157837062e-05f, +1.901205840e-04f, +3.886208156e-04f, +5.406356977e-04f, +6.303496402e-04f, +6.516741400e-04f, +6.086852563e-04f, +5.142384158e-04f, +3.871281868e-04f, +2.484363303e-04f, +1.178333665e-04f, +1.054810206e-05f, -6.448138195e-05f, -1.050564873e-04f, -1.148617881e-04f, -1.016589473e-04f, -7.503831325e-05f, -4.425657742e-05f, -1.658904033e-05f, +3.557165526e-06f, +1.473325471e-05f, +1.789179549e-05f, +1.545068921e-05f, +1.028007989e-05f, +4.868577177e-06f,
    +1.160177891e-04f, -4.122257101e-04f, -1.500896606e-03f, -3.007708819e-03f, -4.400401757e-03f, -4.802517767e-03f, -3.259309785e-03f, +8.162710528e-04f, +7.170196687e-03f, +1.443125557e-02f, +2.023818191e-02f, +2.185003780e-02f, +1.712002632e-02f, +5.516769037e-03f, -1.122265142e-02f, -2.916099810e-02f, -4.307569117e-02f, -4.802340182e-02f, -4.106612868e-02f, -2.253712093e-02f, +3.674935013e-03f, +3.102784229e-02f, +5.219294740e-02f, +6.129514680e-02f, +5.576698896e-02f, +3.717042926e-02f, +1.069616491e-02f, -1.648249302e-02f, -3.742480630e-02f, -4.744935167e-02f, -4.531468744e-02f, -3.322845831e-02f, -1.578723449e-02f, +1.693117628e-03f, +1.483694077e-02f, +2.131746088e-02f, +2.113678884e-02f, +1.612648552e-02f, +8.978753482e-03f, +2.224920046e-03f, -2.485485359e-03f, -4.632187761e-03f, -4.632717222e-03f, -3.396180714e-03f, -1.852152930e-03f, -6.314569246e-04f, +3.235962470e-05f, +2.179337640e-04f,
    +8.466489063e-06f, +2.483227790e-05f, +4.203043254e-05f, +4.916838214e-05f, +3.367975215e-05f, -1.233000201e-05f, -8.521210150e-05f, -1.659146577e-04f, -2.223446079e-04f, -2.190289187e-04f, -1.318330365e-04f, +3.762360484e-05f, +2.545269905e-04f, +4.555320128e-04f, +5.664001392e-04f, +5.279727365e-04f, +3.213879831e-04f, -1.777500250e-05f, -4.037270028e-04f, -7.238894151e-04f, -8.747482740e-04f, -7.978284485e-04f, -5.024274914e-04f, -6.596032919e-05f, +3.891899554e-04f, +7.346386734e-04f, +8.770913041e-04f, +7.870554015e-04f, +5.053881103e-04f, +1.262323105e-04f, -2.364960278e-04f, -4.863836286e-04f, -5.724235080e-04f, -4.988930718e-04f, -3.158705776e-04f, -9.614045620e-05f, +9.161363612e-05f, +2.034924447e-04f, +2.288380210e-04f, +1.858201188e-04f, +1.083175159e-04f, +3.064044285e-05f, -2.393200775e-05f, -4.758857544e-05f, -4.561165540e-05f, -2.997561797e-05f, -1.254445566e-05f, -6.524678118e-07f,
    /*  2, 5 (48) */
    +2.151986490e-04f, +5.798018381e-04f, +1.095731419e-03f, +1.656899872e-03f, +2.067070323e-03f, +2.060864306e-03f, +1.357063808e-03f, -2.602207787e-04f, -2.846498251e-03f, -6.209849225e-03f, -9.857409088e-03f, -1.299838892e-02f, -1.461749507e-02f, -1.361810636e-02f, -9.017627166e-03f, -1.620288963e-04f, +1.308318748e-02f, +3.020939460e-02f, +5.004339344e-02f, +7.084499860e-02f, +9.051712397e-02f, +1.068979297e-01f, +1.180856392e-01f, +1.227372263e-01f, +1.202848560e-01f, +1.110285586e-01f, +9.608718283e-02f, +7.721714004e-02f, +5.653385790e-02f, +3.618868840e-02f, +1.806058077e-02f, +3.516044690e-03f, -6.725457326e-03f, -1.260648082e-02f, -1.463687577e-02f, -1.371939665e-02f, -1.093769286e-02f, -7.350809861e-03f, -3.831024737e-03f, -9.677770163e-04f, +9.564589793e-04f, +1.928156395e-03f, +2.123409868e-03f, +1.812755924e-03f, +1.273734461e-03f, +7.279507922e-04f, +3.100629092e-04f, +6.697656655e-05f,
    -8.519174888e-06f, -1.399743514e-05f, -1.759576105e-05f, -1.648743506e-05f, -8.008503125e-06f, +9.361551378e-06f, +3.500799781e-05f, +6.547329714e-05f, +9.432182171e-05f, +1.127718672e-04f, +1.111221882e-04f, +8.079217154e-05f, +1.659755120e-05f, -8.124714801e-05f, -2.059276841e-04f, -3.440468994e-04f, -4.770445681e-04f, -5.839011872e-04f, -6.446975487e-04f, -6.443644139e-04f, -5.758546346e-04f, -4.420380662e-04f, -2.558517894e-04f, -3.858797298e-05f, +1.834080748e-04f, +3.830160601e-04f, +5.367694260e-04f, +6.285761486e-04f, +6.520272446e-04f, +6.108932017e-04f, +5.177919432e-04f, +3.913854162e-04f, +2.527416165e-04f, +1.216261004e-04f, +1.344150808e-05f, -6.266334577e-05f, -1.042861110e-04f, -1.149511162e-04f, -1.023257469e-04f, -7.597763824e-05f, -4.520237532e-05f, -1.735486795e-05f, +3.062828592e-06f, +1.451514970e-05f, +1.789260018e-05f, +1.558296283e-05f, +1.045632548e-05f, +5.022725094e-06f,
    +1.244842782e-04f, -3.873934322e-04f, -1.458866173e-03f, -2.958540437e-03f, -4.366722005e-03f, -4.814847769e-03f, -3.344521887e-03f, +6.503563952e-04f, +6.947852079e-03f, +1.421222665e-02f, +2.010634887e-02f, +2.188766141e-02f, +1.737455331e-02f, +5.972301050e-03f, -1.065625128e-02f, -2.863302536e-02f, -4.275430318e-02f, -4.804117682e-02f, -4.146985568e-02f, -2.326101034e-02f, +2.800186739e-03f, +3.023001384e-02f, +5.169051991e-02f, +6.122918647e-02f, +5.615617891e-02f, +3.790506794e-02f, +1.157325621e-02f, -1.569543762e-02f, -3.691941819e-02f, -4.732311936e-02f, -4.555118347e-02f, -3.371484194e-02f, -1.635965800e-02f, +1.194224557e-03f, +1.452107019e-02f, +2.122132042e-02f, +2.122840247e-02f, +1.632997796e-02f, +9.207591503e-03f, +2.410740164e-03f, -2.377167844e-03f, -4.601547318e-03f, -4.656649229e-03f, -3.443769290e-03f, -1.897764586e-03f, -6.614325425e-04f, +1.981516904e-05f, +2.172812962e-04f,
    +8.046449887e-06f, +2.426343398e-05f, +4.157888904e-05f, +4.922680759e-05f, +3.460780348e-05f, -1.042838306e-05f, -8.267731948e-05f, -1.635709156e-04f, -2.213133645e-04f, -2.203297043e-04f, -1.358942076e-04f, +3.134374756e-05f, +2.476076295e-04f, +4.502383222e-04f, +5.649680224e-04f, +5.317539276e-04f, +3.301792273e-04f, -5.919874154e-06f, -3.920587902e-04f, -7.159904009e-04f, -8.733376566e-04f, -8.037746187e-04f, -5.143468419e-04f, -8.057995834e-05f, +3.760095383e-04f, +7.265742297e-04f, +8.761915298e-04f, +7.931473988e-04f, +5.162463108e-04f, +1.384167806e-04f, -2.264624880e-04f, -4.809312030e-04f, -5.723084953e-04f, -5.031953214e-04f, -3.225405397e-04f, -1.028329237e-04f, +8.674983814e-05f, +2.013348463e-04f, +2.292318388e-04f, +1.878788303e-04f, +1.109010239e-04f, +3.280034141e-05f, -2.269282404e-05f, -4.728959078e-05f, -4.594850717e-05f, -3.054440828e-05f, -1.302864034e-05f, -9.099460397e-07f,
    /*  2, 6 (48) */
    +2.066794741e-04f, +5.658044030e-04f, +1.078135658e-03f, +1.640412437e-03f, +2.059061820e-03f, +2.070225857e-03f, +1.392071805e-03f, -1.947474815e-04f, -2.752176430e-03f, -6.097077358e-03f, -9.746286900e-03f, -1.291759675e-02f, -1.460089752e-02f, -1.369935351e-02f, -9.223554850e-03f, -5.060757957e-04f, +1.260614291e-02f, +2.962549341e-02f, +4.939869589e-02f, +7.020063419e-02f, +8.994126933e-02f, +1.064558916e-01f, +1.178297874e-01f, +1.226986384e-01f, +1.204682640e-01f, +1.114115747e-01f, +9.662395226e-02f, +7.784571619e-02f, +5.718588514e-02f, +3.679958160e-02f, +1.857837271e-02f, +3.907430107e-03f, -6.472715710e-03f, -1.248485472e-02f, -1.462343426e-02f, -1.378205999e-02f, -1.104197897e-02f, -7.465760977e-03f, -3.933350484e-03f, -1.043754655e-03f, +9.112566040e-04f, +1.910801527e-03f, +2.126472697e-03f, +1.827271074e-03f, +1.291627061e-03f, +7.435337550e-04f, +3.205192346e-04f, +7.199929164e-05f,
    -8.344564540e-06f, -1.384091928e-05f, -1.753933143e-05f, -1.662161663e-05f, -8.404654100e-06f, +8.683480529e-06f, +3.410776128e-05f, +6.450515218e-05f, +9.352779174e-05f, +1.124495919e-04f, +1.115695688e-04f, +8.223765199e-05f, +1.913030786e-05f, -7.773024984e-05f, -2.017428681e-04f, -3.397019451e-04f, -4.731735600e-04f, -5.811641189e-04f, -6.436623173e-04f, -6.453943812e-04f, -5.790256297e-04f, -4.471039543e-04f, -2.622683581e-04f, -4.559288931e-05f, +1.766733973e-04f, +3.773659094e-04f, +5.328418520e-04f, +6.267350554e-04f, +6.523165421e-04f, +6.130498973e-04f, +5.213127495e-04f, +3.956308083e-04f, +2.570546224e-04f, +1.254417521e-04f, +1.636680517e-05f, -6.081114311e-05f, -1.034851606e-04f, -1.150175463e-04f, -1.029791733e-04f, -7.691280619e-05f, -4.615127328e-05f, -1.812819973e-05f, +2.559534897e-06f, +1.428903649e-05f, +1.788781391e-05f, +1.571251857e-05f, +1.063234626e-05f, +5.178260298e-06f,
    +1.325307281e-04f, -3.631299982e-04f, -1.417287284e-03f, -2.909313630e-03f, -4.332114202e-03f, -4.825276152e-03f, -3.427199206e-03f, +4.867854796e-04f, +6.726538715e-03f, +1.399189695e-02f, +1.997045467e-02f, +2.191900516e-02f, +1.762216094e-02f, +6.422539372e-03f, -1.009128326e-02f, -2.810127143e-02f, -4.242412396e-02f, -4.804709670e-02f, -4.186191447e-02f, -2.397700074e-02f, +1.926849082e-03f, +2.942623922e-02f, +5.117617307e-02f, +6.114860651e-02f, +5.653218845e-02f, +3.863164217e-02f, +1.244944774e-02f, -1.490229022e-02f, -3.640317188e-02f, -4.718470258e-02f, -4.577764596e-02f, -3.419577315e-02f, -1.693196650e-02f, +6.910292352e-04f, +1.419852965e-02f, +2.111848750e-02f, +2.131515231e-02f, +1.653131281e-02f, +9.436823341e-03f, +2.598618995e-03f, -2.266266820e-03f, -4.568746977e-03f, -4.679342053e-03f, -3.491058880e-03f, -1.943713093e-03f, -6.919769508e-04f, +6.786528698e-06f, +2.163713502e-04f,
    +7.633361304e-06f, +2.369612532e-05f, +4.111808869e-05f, +4.926313550e-05f, +3.550519564e-05f, -8.554658539e-06f, -8.015214039e-05f, -1.612049344e-04f, -2.202238910e-04f, -2.215468551e-04f, -1.398716859e-04f, +2.511426691e-05f, +2.406760000e-04f, +4.448576322e-04f, +5.633880856e-04f, +5.353660836e-04f, +3.388347590e-04f, +5.883981206e-06f, -3.803291967e-04f, -7.079249784e-04f, -8.716997142e-04f, -8.095002376e-04f, -5.261213105e-04f, -9.517667379e-05f, +3.627226851e-04f, +7.183081557e-04f, +8.750585407e-04f, +7.990454901e-04f, +5.270041986e-04f, +1.506153382e-04f, -2.163172775e-04f, -4.753147901e-04f, -5.720328272e-04f, -5.073866860e-04f, -3.291727038e-04f, -1.095569277e-04f, +8.180995317e-05f, +1.990901227e-04f, +2.295566890e-04f, +1.899027257e-04f, +1.134843933e-04f, +3.498365227e-05f, -2.142234465e-05f, -4.696471002e-05f, -4.627164787e-05f, -3.111153756e-05f, -1.351858005e-05f, -1.174919173e-06f,
    /*  2, 7 (48) */
    +1.983349096e-04f, +5.519634837e-04f, +1.060596327e-03f, +1.623790820e-03f, +2.050657166e-03f, +2.078909338e-03f, +1.426179567e-03f, -1.302423294e-04f, -2.658648638e-03f, -5.984627766e-03f, -9.634717331e-03f, -1.283535910e-02f, -1.458176721e-02f, -1.377708376e-02f, -9.425297718e-03f, -8.457777408e-04f, +1.213296935e-02f, +2.904432929e-02f, +4.875503357e-02f, +6.955523980e-02f, +8.936224371e-02f, +1.060087877e-01f, +1.175675191e-01f, +1.226530455e-01f, +1.206449374e-01f, +1.117889406e-01f, +9.715679411e-02f, +7.847245124e-02f, +5.783820168e-02f, +3.741263150e-02f, +1.909968546e-02f, +4.303060915e-03f, -6.215661087e-03f, -1.235941296e-02f, -1.460706746e-02f, -1.384287114e-02f, -1.114546413e-02f, -7.580778523e-03f, -4.036329657e-03f, -1.120667461e-03f, +8.651053307e-04f, +1.892673327e-03f, +2.129032232e-03f, +1.841560110e-03f, +1.309514875e-03f, +7.592462736e-04f, +3.311515809e-04f, +7.717755194e-05f,
    -8.170451874e-06f, -1.368270014e-05f, -1.747838576e-05f, -1.674858004e-05f, -8.791967543e-06f, +8.013786642e-06f, +3.321263254e-05f, +6.353586705e-05f, +9.272398405e-05f, +1.121078964e-04f, +1.119888913e-04f, +8.364970531e-05f, +2.162955402e-05f, -7.424042003e-05f, -1.975721113e-04f, -3.353528265e-04f, -4.692775907e-04f, -5.783822332e-04f, -6.425670845e-04f, -6.463570208e-04f, -5.821317669e-04f, -4.521174649e-04f, -2.686534011e-04f, -5.259226943e-05f, +1.699173576e-04f, +3.716709945e-04f, +5.288533349e-04f, +6.248264024e-04f, +6.525417699e-04f, +6.151548427e-04f, +5.248002005e-04f, +3.998637126e-04f, +2.613747898e-04f, +1.292799344e-04f, +1.932381540e-05f, -5.892474902e-05f, -1.026534512e-04f, -1.150607986e-04f, -1.036189232e-04f, -7.784355196e-05f, -4.710308517e-05f, -1.890894410e-05f, +2.047289331e-06f, +1.405485785e-05f, +1.787734921e-05f, +1.583926880e-05f, +1.080807602e-05f, +5.335147914e-06f,
    +1.401640894e-04f, -3.394338729e-04f, -1.376169196e-03f, -2.860050494e-03f, -4.296609006e-03f, -4.833830810e-03f, -3.507351347e-03f, +3.255805452e-04f, +6.506314824e-03f, +1.377035010e-02f, +1.983058298e-02f, +2.194411942e-02f, +1.786283694e-02f, +6.867397005e-03f, -9.527895176e-03f, -2.756590535e-02f, -4.208528920e-02f, -4.804121272e-02f, -4.224224367e-02f, -2.468492572e-02f, +1.055149368e-03f, +2.861673899e-02f, +5.065005176e-02f, +6.105342983e-02f, +5.689491114e-02f, +3.934995032e-02f, +1.332450628e-02f, -1.410324473e-02f, -3.587616768e-02f, -4.703408724e-02f, -4.599396324e-02f, -3.467108794e-02f, -1.750399933e-02f, +1.836425491e-04f, +1.386935695e-02f, +2.100893057e-02f, +2.139696226e-02f, +1.673040293e-02f, +9.666380030e-03f, +2.788521720e-03f, -2.152782426e-03f, -4.533763325e-03f, -4.700764398e-03f, -3.538023590e-03f, -1.989984741e-03f, -7.230884884e-04f, -6.732051356e-06f, +2.151964310e-04f,
    +7.227298826e-06f, +2.313061035e-05f, +4.064842614e-05f, +4.927774042e-05f, +3.637205811e-05f, -6.709141053e-06f, -7.763737051e-05f, -1.588178385e-04f, -2.190772355e-04f, -2.226808477e-04f, -1.437649828e-04f, +1.893670441e-05f, +2.337343623e-04f, +4.393922133e-04f, +5.616617465e-04f, +5.388090779e-04f, +3.473526926e-04f, +1.763333493e-05f, -3.685418302e-04f, -6.996959320e-04f, -8.698353975e-04f, -8.150039925e-04f, -5.377476602e-04f, -1.097463270e-04f, +3.493331199e-04f, +7.098425667e-04f, +8.736922246e-04f, +8.047474842e-04f, +5.376583343e-04f, +1.628244780e-04f, -2.060628682e-04f, -4.695351836e-04f, -5.715956042e-04f, -5.114651158e-04f, -3.357647084e-04f, -1.163105947e-04f, +7.679487601e-05f, +1.967581254e-04f, +2.298116804e-04f, +1.918906538e-04f, +1.160666647e-04f, +3.718987259e-05f, -2.012058813e-05f, -4.661362310e-05f, -4.658066683e-05f, -3.167668481e-05f, -1.401413201e-05f, -1.447406595e-06f,
    /*  2, 8 (48) */
    +1.901644577e-04f, +5.382807835e-04f, +1.043117941e-03f, +1.607042240e-03f, +2.041865198e-03f, +2.086923125e-03f, +1.459392199e-03f, -6.670646231e-05f, -2.565924654e-03f, -5.872519870e-03f, -9.522728440e-03f, -1.275170939e-02f, -1.456013766e-02f, -1.385132418e-02f, -9.622869830e-03f, -1.181130567e-03f, +1.166369176e-02f, +2.846594706e-02f, +4.811246649e-02f, +6.890888278e-02f, +8.878011194e-02f, +1.055566702e-01f, +1.172988657e-01f, +1.226004532e-01f, +1.208148548e-01f, +1.121606116e-01f, +9.768564744e-02f, +7.909727764e-02f, +5.849074345e-02f, +3.802778634e-02f, +1.962448566e-02f, +4.702924628e-03f, -5.954286298e-03f, -1.223013303e-02f, -1.458774364e-02f, -1.390179589e-02f, -1.124811758e-02f, -7.695839322e-03f, -4.139948580e-03f, -1.198511013e-03f, +8.180022455e-04f, +1.873764383e-03f, +2.131079521e-03f, +1.855614968e-03f, +1.327392224e-03f, +7.750855424e-04f, +3.419596569e-04f, +8.251269985e-05f,
    -7.996890882e-06f, -1.352285859e-05f, -1.741301485e-05f, -1.686839873e-05f, -9.170467399e-06f, +7.352523987e-06f, +3.232275977e-05f, +6.256567834e-05f, +9.191069286e-05f, +1.117470784e-04f, +1.123803877e-04f, +8.502842828e-05f, +2.409519724e-05f, -7.077796261e-05f, -1.934159098e-04f, -3.310001687e-04f, -4.653573154e-04f, -5.755560987e-04f, -6.414122198e-04f, -6.472524196e-04f, -5.851728139e-04f, -4.570780681e-04f, -2.750061691e-04f, -5.958526404e-05f, +1.631407655e-04f, +3.659319540e-04f, +5.248042432e-04f, +6.228502412e-04f, +6.527026745e-04f, +6.172075439e-04f, +5.282536639e-04f, +4.040834770e-04f, +2.657015558e-04f, +1.331402544e-04f, +2.231235421e-05f, -5.700414440e-05f, -1.017908016e-04f, -1.150805950e-04f, -1.042446931e-04f, -7.876960845e-05f, -4.805762199e-05f, -1.969700654e-05f, +1.526099187e-06f, +1.381255800e-05f, +1.786111905e-05f, +1.596312552e-05f, +1.098344767e-05f, +5.493352053e-06f,
    +1.473913882e-04f, -3.163032626e-04f, -1.335520770e-03f, -2.810772754e-03f, -4.260236948e-03f, -4.840539951e-03f, -3.584988717e-03f, +1.667627067e-04f, +6.287237588e-03f, +1.354766925e-02f, +1.968681800e-02f, +2.196305613e-02f, +1.809657130e-02f, +7.306789218e-03f, -8.966233429e-03f, -2.702709627e-02f, -4.173793651e-02f, -4.802357938e-02f, -4.261078550e-02f, -2.538462165e-02f, +1.853139707e-04f, +2.780173499e-02f, +5.011230410e-02f, +6.094368351e-02f, +5.724424426e-02f, +4.005979289e-02f, +1.419819851e-02f, -1.329849725e-02f, -3.533850934e-02f, -4.687126276e-02f, -4.620002611e-02f, -3.514062312e-02f, -1.807559493e-02f, -3.278225666e-04f, +1.353359224e-02f, +2.089261998e-02f, +2.147375714e-02f, +1.692716106e-02f, +9.896191711e-03f, +2.980412374e-03f, -2.036715762e-03f, -4.496573452e-03f, -4.720884986e-03f, -3.584637213e-03f, -2.036565407e-03f, -7.547651732e-04f, -2.074618336e-05f, +2.137490244e-04f,
    +6.828332627e-06f, +2.256714189e-05f, +4.017029362e-05f, +4.927100079e-05f, +3.720853147e-05f, -4.892127566e-06f, -7.513380208e-05f, -1.564107476e-04f, -2.178744558e-04f, -2.237321840e-04f, -1.475736432e-04f, +1.281257153e-05f, +2.267849633e-04f, +4.338443485e-04f, +5.597904616e-04f, +5.420828385e-04f, +3.557311946e-04f, +2.932498800e-05f, -3.567003045e-04f, -6.913060890e-04f, -8.677457248e-04f, -8.202846407e-04f, -5.492227019e-04f, -1.242847781e-04f, +3.358446005e-04f, +7.011796411e-04f, +8.720925403e-04f, +8.102512456e-04f, +5.482053006e-04f, +1.750406785e-04f, -1.957017770e-04f, -4.635932335e-04f, -5.709959738e-04f, -5.154285844e-04f, -3.423141883e-04f, -1.230920268e-04f, +7.170553526e-05f, +1.943387355e-04f, +2.299959380e-04f, +1.938414640e-04f, +1.186468676e-04f, +3.941848368e-05f, -1.878758649e-05f, -4.623602683e-05f, -4.687515319e-05f, -3.223952423e-05f, -1.451514763e-05f, -1.727423627e-06f,
    /*  2, 9 (48) */
    +1.821675668e-04f, +5.247579250e-04f, +1.025704926e-03f, +1.590173842e-03f, +2.032694731e-03f, +2.094275649e-03f, +1.491714959e-03f, -4.140783970e-06f, -2.474013961e-03f, -5.760772791e-03f, -9.410348052e-03f, -1.266668096e-02f, -1.453604246e-02f, -1.392210214e-02f, -9.816285739e-03f, -1.512130736e-03f, +1.119833444e-02f, +2.789039096e-02f, +4.747105427e-02f, +6.826163036e-02f, +8.819493912e-02f, +1.050995921e-01f, +1.170238595e-01f, +1.225408679e-01f, +1.209779955e-01f, +1.125265436e-01f, +9.821045169e-02f, +7.972012788e-02f, +5.914344613e-02f, +3.864499388e-02f, +2.015273933e-02f, +5.107008105e-03f, -5.688584742e-03f, -1.209699277e-02f, -1.456543129e-02f, -1.395880003e-02f, -1.134990838e-02f, -7.810919917e-03f, -4.244193273e-03f, -1.277280621e-03f, +7.699446236e-04f, +1.854067377e-03f, +2.132605620e-03f, +1.869427526e-03f, +1.345253343e-03f, +7.910486679e-04f, +3.529431046e-04f, +8.800605191e-05f,
    -7.823934576e-06f, -1.336147488e-05f, -1.734330956e-05f, -1.698114718e-05f, -9.540179638e-06f, +6.699744060e-06f, +3.143828816e-05f, +6.159482021e-05f, +9.108821130e-05f, +1.113674365e-04f, +1.127442933e-04f, +8.637392289e-05f, +2.652715154e-05f, -6.734317504e-05f, -1.892747545e-04f, -3.266445939e-04f, -4.614133903e-04f, -5.726862885e-04f, -6.401981006e-04f, -6.480806737e-04f, -5.881485482e-04f, -4.619852426e-04f, -2.813259176e-04f, -6.657102488e-05f, +1.563444340e-04f, +3.601494334e-04f, +5.206949552e-04f, +6.208066337e-04f, +6.527990109e-04f, +6.192075126e-04f, +5.316725104e-04f, +4.082894485e-04f, +2.700343538e-04f, +1.370223128e-04f, +2.533223037e-05f, -5.504931606e-05f, -1.008970351e-04f, -1.150766596e-04f, -1.048561792e-04f, -7.969070668e-05f, -4.901469194e-05f, -2.049228958e-05f, +9.959741817e-07f, +1.356208269e-05f, +1.783903691e-05f, +1.608400036e-05f, +1.115839327e-05f, +5.652835814e-06f,
    +1.542197209e-04f, -2.937361207e-04f, -1.295350476e-03f, -2.761501753e-03f, -4.223028416e-03f, -4.845432079e-03f, -3.660122519e-03f, +1.035195909e-05f, +6.069363132e-03f, +1.332393706e-02f, +1.953924435e-02f, +2.197586870e-02f, +1.832335626e-02f, +7.740633566e-03f, -8.406442968e-03f, -2.648501343e-02f, -4.138220531e-02f, -4.799425439e-02f, -4.296748580e-02f, -2.607592774e-02f, -6.824317540e-04f, +2.698145035e-02f, +4.956308140e-02f, +6.081939873e-02f, +5.758008886e-02f, +4.076097253e-02f, +1.507029105e-02f, -1.248824600e-02f, -3.479030404e-02f, -4.669622208e-02f, -4.639572788e-02f, -3.560421635e-02f, -1.864659090e-02f, -8.432511510e-04f, +1.319127805e-02f, +2.076952795e-02f, +2.154546268e-02f, +1.712149979e-02f, +1.012618765e-02f, +3.174253838e-03f, -1.918068894e-03f, -4.457154968e-03f, -4.739672573e-03f, -3.630873240e-03f, -2.083440561e-03f, -7.870046974e-04f, -3.526133099e-05f, +2.120216008e-04f,
    +6.436527589e-06f, +2.200596715e-05f, +3.968408078e-05f, +4.924329868e-05f, +3.801476720e-05f, -3.103899478e-06f, -7.264221312e-05f, -1.539847759e-04f, -2.166166192e-04f, -2.247013900e-04f, -1.512972455e-04f, +6.743349257e-06f, +2.198300360e-04f, +4.282163328e-04f, +5.577757256e-04f, +5.451873476e-04f, +3.639684837e-04f, +4.095577201e-05f, -3.448082387e-04f, -6.827583192e-04f, -8.654317815e-04f, -8.253410091e-04f, -5.605432950e-04f, -1.387878976e-04f, +3.222609165e-04f, +6.923216202e-04f, +8.702595184e-04f, +8.155546947e-04f, +5.586417028e-04f, +1.872604035e-04f, -1.852365655e-04f, -4.574898456e-04f, -5.702331310e-04f, -5.192750907e-04f, -3.488187759e-04f, -1.298993015e-04f, +6.654289323e-05f, +1.918318640e-04f, +2.301086035e-04f, +1.957540069e-04f, +1.212240206e-04f, +4.166895100e-05f, -1.742338539e-05f, -4.583162515e-05f, -4.715469618e-05f, -3.279972542e-05f, -1.502147253e-05f, -2.014981454e-06f,
    /*  2,10 (48) */
    +1.743436322e-04f, +5.113964501e-04f, +1.008361617e-03f, +1.573192694e-03f, +2.023154551e-03f, +2.100975393e-03f, +1.523153247e-03f, +5.745403624e-05f, -2.382925750e-03f, -5.649405355e-03f, -9.297603759e-03f, -1.258030704e-02f, -1.450951531e-02f, -1.398944532e-02f, -1.000556049e-02f, -1.838775330e-03f, +1.073692105e-02f, +2.731770467e-02f, +4.683085617e-02f, +6.761354969e-02f, +8.760679058e-02f, +1.046376069e-01f, +1.167425336e-01f, +1.224742969e-01f, +1.211343400e-01f, +1.128866930e-01f, +9.873114664e-02f, +8.034093452e-02f, +5.979624514e-02f, +3.926420140e-02f, +2.068441184e-02f, +5.515297553e-03f, -5.418550388e-03f, -1.195997046e-02f, -1.454009906e-02f, -1.401384935e-02f, -1.145080542e-02f, -7.925996577e-03f, -4.349049452e-03f, -1.356971328e-03f, +7.209299316e-04f, +1.833575087e-03f, +2.133601595e-03f, +1.882989609e-03f, +1.363092380e-03f, +8.071326683e-04f, +3.641014979e-04f, +9.365888772e-05f,
    -7.651634979e-06f, -1.319862861e-05f, -1.726936079e-05f, -1.708690087e-05f, -9.901132222e-06f, +6.055495601e-06f, +3.055935993e-05f, +6.062352435e-05f, +9.025683137e-05f, +1.109692702e-04f, +1.130808466e-04f, +8.768629623e-05f, +2.892533735e-05f, -6.393634822e-05f, -1.851491307e-04f, -3.222867216e-04f, -4.574464721e-04f, -5.697733800e-04f, -6.389251117e-04f, -6.488418893e-04f, -5.910587572e-04f, -4.668384753e-04f, -2.876119077e-04f, -7.354870489e-05f, +1.495291793e-04f, +3.543240851e-04f, +5.165258583e-04f, +6.186956518e-04f, +6.528305431e-04f, +6.211542671e-04f, +5.350561130e-04f, +4.124809731e-04f, +2.743726128e-04f, +1.409257044e-04f, +2.838324597e-05f, -5.306025672e-05f, -9.997197899e-05f, -1.150487184e-04f, -1.054530775e-04f, -8.060657581e-05f, -4.997410040e-05f, -2.129469280e-05f, +4.569264820e-07f, +1.330337920e-05f, +1.781101677e-05f, +1.620180464e-05f, +1.133284398e-05f, +5.813561281e-06f,
    +1.606562484e-04f, -2.717301535e-04f, -1.255666395e-03f, -2.712258454e-03f, -4.185013649e-03f, -4.848535978e-03f, -3.732764732e-03f, -1.436328168e-04f, +5.852746513e-03f, +1.309923567e-02f, +1.938794711e-02f, +2.198261205e-02f, +1.854318630e-02f, +8.168849899e-03f, -7.848667242e-03f, -2.593982609e-02f, -4.101823683e-02f, -4.795329862e-02f, -4.331229404e-02f, -2.675868606e-02f, -1.547863536e-03f, +2.615610935e-02f, +4.900253810e-02f, +6.068061083e-02f, +5.790234977e-02f, +4.145329415e-02f, +1.594055057e-02f, -1.167269131e-02f, -3.423166234e-02f, -4.650896168e-02f, -4.658096445e-02f, -3.606170620e-02f, -1.921682403e-02f, -1.362526242e-03f, +1.284245928e-02f, +2.063962865e-02f, +2.161200557e-02f, +1.731333166e-02f, +1.035629625e-02f, +3.370007845e-03f, -1.796844873e-03f, -4.415486017e-03f, -4.757095958e-03f, -3.676704865e-03f, -2.130595257e-03f, -8.198044229e-04f, -5.028280352e-05f, +2.100066193e-04f,
    +6.051943364e-06f, +2.144732766e-05f, +3.919017456e-05f, +4.919501962e-05f, +3.879092743e-05f, -1.344722690e-06f, -7.016336728e-05f, -1.515410319e-04f, -2.153048015e-04f, -2.255890162e-04f, -1.549354012e-04f, +7.304878903e-07f, +2.128717986e-04f, +4.225104719e-04f, +5.556190707e-04f, +5.481226416e-04f, +3.720628316e-04f, +5.252255007e-05f, -3.328692552e-04f, -6.740555333e-04f, -8.628947198e-04f, -8.301719951e-04f, -5.717063486e-04f, -1.532515671e-04f, +3.085858884e-04f, +6.832708074e-04f, +8.681932613e-04f, +8.206558088e-04f, +5.689641709e-04f, +1.994801026e-04f, -1.746698386e-04f, -4.512259819e-04f, -5.693063191e-04f, -5.230026589e-04f, -3.552761018e-04f, -1.367304729e-04f, +6.130794585e-05f, +1.892374520e-04f, +2.301488361e-04f, +1.976271346e-04f, +1.237971315e-04f, +4.394072422e-05f, -1.602804428e-05f, -4.540012932e-05f, -4.741888520e-05f, -3.335695340e-05f, -1.553294649e-05f, -2.310087044e-06f,
    /*  2,11 (48) */
    +1.666919973e-04f, +4.981978215e-04f, +9.910922559e-04f, +1.556105794e-03f, +2.013253419e-03f, +2.107030888e-03f, +1.553712607e-03f, +1.180775606e-04f, -2.292668918e-03f, -5.538436085e-03f, -9.184522912e-03f, -1.249262075e-02f, -1.448058997e-02f, -1.405338166e-02f, -1.019070962e-02f, -2.161062051e-03f, +1.027947458e-02f, +2.674793129e-02f, +4.619193106e-02f, +6.696470780e-02f, +8.701573182e-02f, +1.041707684e-01f, +1.164549217e-01f, +1.224007482e-01f, +1.212838692e-01f, +1.132410171e-01f, +9.924767250e-02f, +8.095963017e-02f, +6.044907568e-02f, +3.988535566e-02f, +2.121946795e-02f, +5.927778526e-03f, -5.144177775e-03f, -1.181904476e-02f, -1.451171581e-02f, -1.406690960e-02f, -1.155077740e-02f, -8.041045295e-03f, -4.454502530e-03f, -1.437577904e-03f, +6.709558312e-04f, +1.812280394e-03f, +2.134058521e-03f, +1.896292988e-03f, +1.380903397e-03f, +8.233344729e-04f, +3.754343418e-04f, +9.947244900e-05f,
    -7.480043122e-06f, -1.303439868e-05f, -1.719125943e-05f, -1.718573622e-05f, -1.025335508e-05f, +5.419824611e-06f, +2.968611429e-05f, +5.965201997e-05f, +8.941684389e-05f, +1.105528795e-04f, +1.133902888e-04f, +8.896566043e-05f, +3.128968150e-05f, -6.055776647e-05f, -1.810395187e-04f, -3.179271685e-04f, -4.534572180e-04f, -5.668179551e-04f, -6.375936455e-04f, -6.495361818e-04f, -5.939032386e-04f, -4.716372619e-04f, -2.938634059e-04f, -8.051745830e-05f, +1.426958208e-04f, +3.484565686e-04f, +5.122973493e-04f, +6.165173774e-04f, +6.527970441e-04f, +6.230473317e-04f, +5.384038478e-04f, +4.166573956e-04f, +2.787157577e-04f, +1.448500178e-04f, +3.146519645e-05f, -5.103696510e-05f, -9.901546503e-05f, -1.149964995e-04f, -1.060350840e-04f, -8.151694320e-05f, -5.093564998e-05f, -2.210411281e-05f, -9.102927193e-08f, +1.303639635e-05f, +1.777697317e-05f, +1.631644935e-05f, +1.150673014e-05f, +5.975489525e-06f,
    +1.667081918e-04f, -2.502828259e-04f, -1.216476221e-03f, -2.663063435e-03f, -4.146222722e-03f, -4.849880701e-03f, -3.802928100e-03f, -2.951738487e-04f, +5.637441712e-03f, +1.287364666e-02f, +1.923301171e-02f, +2.198334254e-02f, +1.875605810e-02f, +8.591360371e-03f, -7.293048172e-03f, -2.539170344e-02f, -4.064617400e-02f, -4.790077607e-02f, -4.364516329e-02f, -2.743274159e-02f, -2.410758255e-03f, +2.532593735e-02f, +4.843083175e-02f, +6.052735927e-02f, +5.821093566e-02f, +4.213656496e-02f, +1.680874383e-02f, -1.085203550e-02f, -3.366269817e-02f, -4.630948158e-02f, -4.675563429e-02f, -3.651293218e-02f, -1.978613035e-02f, -1.885528901e-03f, +1.248718318e-02f, +2.050289818e-02f, +2.167331351e-02f, +1.750256911e-02f, +1.058644509e-02f, +3.567634980e-03f, -1.673047742e-03f, -4.371545293e-03f, -4.773124002e-03f, -3.722104995e-03f, -2.178014142e-03f, -8.531613762e-04f, -6.581575001e-05f, +2.076965323e-04f,
    +5.674634421e-06f, +2.089145928e-05f, +3.868895900e-05f, +4.912655230e-05f, +3.953718479e-05f, +3.851523159e-07f, -6.769801371e-05f, -1.490806182e-04f, -2.139400871e-04f, -2.263956365e-04f, -1.584877552e-04f, -5.224593305e-06f, +2.059124541e-04f, +4.167290819e-04f, +5.533220657e-04f, +5.508888108e-04f, +3.800125628e-04f, +6.402221775e-05f, -3.208869794e-04f, -6.652006819e-04f, -8.601357579e-04f, -8.347765667e-04f, -5.827088224e-04f, -1.676716814e-04f, +2.948233659e-04f, +6.740295675e-04f, +8.658939429e-04f, +8.255526230e-04f, +5.791693600e-04f, +2.116962129e-04f, -1.640042448e-04f, -4.448026599e-04f, -5.682148300e-04f, -5.266093397e-04f, -3.616837955e-04f, -1.435835716e-04f, +5.600172260e-05f, +1.865554712e-04f, +2.301158125e-04f, +1.994597013e-04f, +1.263651979e-04f, +4.623323722e-05f, -1.460163653e-05f, -4.494125820e-05f, -4.766731014e-05f, -3.391086871e-05f, -1.604940348e-05f, -2.612743069e-06f,
    /*  2,12 (48) */
    +1.592119541e-04f, +4.851634228e-04f, +9.739009964e-04f, +1.538920057e-03f, +2.003000064e-03f, +2.112450713e-03f, +1.583398721e-03f, +1.777295806e-04f, -2.203252074e-03f, -5.427883205e-03f, -9.071132624e-03f, -1.240365508e-02f, -1.444930029e-02f, -1.411393943e-02f, -1.037174914e-02f, -2.478989220e-03f, +9.826017361e-03f, +2.618111333e-02f, +4.555433741e-02f, +6.631517162e-02f, +8.642182858e-02f, +1.036991311e-01f, +1.161610583e-01f, +1.223202308e-01f, +1.214265650e-01f, +1.135894736e-01f, +9.975996985e-02f, +8.157614755e-02f, +6.110187273e-02f, +4.050840299e-02f, +2.175787180e-02f, +6.344435922e-03f, -4.865462017e-03f, -1.167419474e-02f, -1.448025062e-02f, -1.411794657e-02f, -1.164979286e-02f, -8.156041794e-03f, -4.560537614e-03f, -1.519094847e-03f, +6.200201812e-04f, +1.790176281e-03f, +2.133967492e-03f, +1.909329384e-03f, +1.398680370e-03f, +8.396509222e-04f, +3.869410720e-04f, +1.054479385e-04f,
    -7.309209040e-06f, -1.286886331e-05f, -1.710909637e-05f, -1.727773059e-05f, -1.059688009e-05f, +4.792774367e-06f, +2.881868748e-05f, +5.868053377e-05f, +8.856853840e-05f, +1.101185653e-04f, +1.136728644e-04f, +9.021213267e-05f, +3.362011720e-05f, -5.720770752e-05f, -1.769463931e-04f, -3.135665484e-04f, -4.494462858e-04f, -5.638205997e-04f, -6.362041019e-04f, -6.501636765e-04f, -5.966817999e-04f, -4.763811065e-04f, -3.000796842e-04f, -8.747644082e-05f, +1.358451806e-04f, +3.425475498e-04f, +5.080098345e-04f, +6.142719023e-04f, +6.526982959e-04f, +6.248862372e-04f, +5.417150934e-04f, +4.208180602e-04f, +2.830632097e-04f, +1.487948357e-04f, +3.457787058e-05f, -4.897944593e-05f, -9.802732920e-05f, -1.149197331e-04f, -1.066018947e-04f, -8.242153441e-05f, -5.189914050e-05f, -2.292044324e-05f, -6.478759438e-07f, +1.276108460e-05f, +1.773682123e-05f, +1.642784518e-05f, +1.167998123e-05f, +6.138580599e-06f,
    +1.723828262e-04f, -2.293913666e-04f, -1.177787262e-03f, -2.613936882e-03f, -4.106685537e-03f, -4.849495549e-03f, -3.870626113e-03f, -4.442544670e-04f, +5.423501625e-03f, +1.264725102e-02f, +1.907452395e-02f, +2.197811794e-02f, +1.896197055e-02f, +9.008089453e-03f, -6.739726106e-03f, -2.484081463e-02f, -4.026616143e-02f, -4.783675385e-02f, -4.396605027e-02f, -2.809794228e-02f, -3.270894013e-03f, +2.449116078e-02f, +4.784812293e-02f, +6.035968758e-02f, +5.850575903e-02f, +4.281059452e-02f, +1.767463777e-02f, -1.002648288e-02f, -3.308352881e-02f, -4.609778536e-02f, -4.691963853e-02f, -3.695773484e-02f, -2.035434518e-02f, -2.412138240e-03f, +1.212549938e-02f, +2.035931460e-02f, +2.172931524e-02f, +1.768912458e-02f, +1.081656090e-02f, +3.767094681e-03f, -1.546682544e-03f, -4.325312056e-03f, -4.787725639e-03f, -3.767046253e-03f, -2.225681452e-03f, -8.870722450e-04f, -8.186515349e-05f, +2.050837892e-04f,
    +5.304650110e-06f, +2.033859211e-05f, +3.818081515e-05f, +4.903828840e-05f, +4.025372215e-05f, +2.085490399e-06f, -6.524688689e-05f, -1.466046309e-04f, -2.125235683e-04f, -2.271218480e-04f, -1.619539854e-04f, -1.112050636e-05f, +1.989541894e-04f, +4.108744881e-04f, +5.508863156e-04f, +5.534859988e-04f, +3.878160556e-04f, +7.545170401e-05f, -3.088650378e-04f, -6.561967548e-04f, -8.571561795e-04f, -8.391537625e-04f, -5.935477276e-04f, -1.820441491e-04f, +2.809772275e-04f, +6.646003260e-04f, +8.633618090e-04f, +8.302432309e-04f, +5.892539518e-04f, +2.239051597e-04f, -1.532424745e-04f, -4.382209531e-04f, -5.669580047e-04f, -5.300932113e-04f, -3.680394865e-04f, -1.504566055e-04f, +5.062528636e-05f, +1.837859237e-04f, +2.300087278e-04f, +2.012505635e-04f, +1.289272071e-04f, +4.854590819e-05f, -1.314424960e-05f, -4.445473845e-05f, -4.789956147e-05f, -3.446112759e-05f, -1.657067159e-05f, -2.922947826e-06f,
    /*  2,13 (48) */
    +1.519027451e-04f, +4.722945595e-04f, +9.567919001e-04f, +1.521642327e-03f, +1.992403184e-03f, +2.117243487e-03f, +1.612217409e-03f, +2.364101143e-04f, -2.114683536e-03f, -5.317764640e-03f, -8.957459759e-03f, -1.231344295e-02f, -1.441568017e-02f, -1.417114714e-02f, -1.054869554e-02f, -2.792555768e-03f, +9.376571075e-03f, +2.561729273e-02f, +4.491813331e-02f, +6.566500794e-02f, +8.582514678e-02f, +1.032227500e-01f, +1.158609786e-01f, +1.222327543e-01f, +1.215624102e-01f, +1.139320212e-01f, +1.002679797e-01f, +8.219041945e-02f, +6.175457102e-02f, +4.113328923e-02f, +2.229958689e-02f, +6.765253982e-03f, -4.582398808e-03f, -1.152539990e-02f, -1.444567275e-02f, -1.416692601e-02f, -1.174782019e-02f, -8.270961528e-03f, -4.667139508e-03f, -1.601516381e-03f, +5.681210407e-04f, +1.767255838e-03f, +2.133319616e-03f, +1.922090469e-03f, +1.416417191e-03f, +8.560787674e-04f, +3.986210532e-04f, +1.115865191e-04f,
    -7.139181769e-06f, -1.270210001e-05f, -1.702296245e-05f, -1.736296222e-05f, -1.093174100e-05f, +4.174385444e-06f, +2.795721277e-05f, +5.770928988e-05f, +8.771220318e-05f, +1.096666292e-04f, +1.139288206e-04f, +9.142583506e-05f, +3.591658402e-05f, -5.388644247e-05f, -1.728702230e-04f, -3.092054717e-04f, -4.454143335e-04f, -5.607819037e-04f, -6.347568882e-04f, -6.507245079e-04f, -5.993942585e-04f, -4.810695220e-04f, -3.062600203e-04f, -9.442480972e-05f, +1.289780839e-04f, +3.365977016e-04f, +5.036637291e-04f, +6.119593288e-04f, +6.525340894e-04f, +6.266705210e-04f, +5.449892318e-04f, +4.249623105e-04f, +2.874143859e-04f, +1.527597348e-04f, +3.772105044e-05f, -4.688770998e-05f, -9.700741192e-05f, -1.148181517e-04f, -1.071532054e-04f, -8.332007332e-05f, -5.286436904e-05f, -2.374357475e-05f, -1.213593878e-06f, +1.247739601e-05f, +1.769047668e-05f, +1.653590257e-05f, +1.185252593e-05f, +6.302793544e-06f,
    +1.776874763e-04f, -2.090527745e-04f, -1.139606446e-03f, -2.564898594e-03f, -4.066431815e-03f, -4.847410058e-03f, -3.935873000e-03f, -5.908590979e-04f, +5.210978056e-03f, +1.242012917e-02f, +1.891256997e-02f, +2.196699744e-02f, +1.916092474e-02f, +9.418963941e-03f, -6.188839790e-03f, -2.428732863e-02f, -3.987834538e-02f, -4.776130215e-02f, -4.427491531e-02f, -2.875413903e-02f, -4.128050193e-03f, +2.365200702e-02f, +4.725457520e-02f, +6.017764343e-02f, +5.878673626e-02f, +4.347519485e-02f, +1.853799958e-02f, -9.196239645e-03f, -3.249427486e-02f, -4.587388020e-02f, -4.707288101e-02f, -3.739595579e-02f, -2.092130319e-02f, -2.942231452e-03f, +1.175745989e-02f, +2.020885800e-02f, +2.177994052e-02f, +1.787291050e-02f, +1.104656963e-02f, +3.968345245e-03f, -1.417755337e-03f, -4.276766148e-03f, -4.800869888e-03f, -3.811500991e-03f, -2.273581014e-03f, -9.215333726e-04f, -9.843582508e-05f, +2.021608414e-04f,
    +4.942034718e-06f, +1.978895051e-05f, +3.766612089e-05f, +4.893062236e-05f, +4.094073241e-05f, +3.756071670e-06f, -6.281070650e-05f, -1.441141591e-04f, -2.110563443e-04f, -2.277682708e-04f, -1.653338023e-04f, -1.695589485e-05f, +1.919991747e-04f, +4.049490240e-04f, +5.483134604e-04f, +5.559144026e-04f, +3.954717418e-04f, +8.680797206e-05f, -2.968070569e-04f, -6.470467794e-04f, -8.539573337e-04f, -8.433026921e-04f, -6.042201278e-04f, -1.963648945e-04f, +2.670513784e-04f, +6.549855683e-04f, +8.605971771e-04f, +8.347257851e-04f, +5.992146559e-04f, +2.361033579e-04f, -1.423872601e-04f, -4.314819906e-04f, -5.655352339e-04f, -5.334523797e-04f, -3.743408051e-04f, -1.573475604e-04f, +4.517973332e-05f, +1.809288428e-04f, +2.298267956e-04f, +2.029985807e-04f, +1.314821367e-04f, +5.087813966e-05f, -1.165598518e-05f, -4.394030475e-05f, -4.811523052e-05f, -3.500738196e-05f, -1.709657307e-05f, -3.240695165e-06f,
    /*  2,14 (48) */
    +1.447635633e-04f, +4.595924595e-04f, +9.397689376e-04f, +1.504279365e-03f, +1.981471443e-03f, +2.121417873e-03f, +1.640174622e-03f, +2.941194042e-04f, -2.026971333e-03f, -5.208098011e-03f, -8.843530939e-03f, -1.222201712e-02f, -1.437976359e-02f, -1.422503358e-02f, -1.072156576e-02f, -3.101761240e-03f, +8.931156742e-03f, +2.505651083e-02f, +4.428337642e-02f, +6.501428343e-02f, +8.522575252e-02f, +1.027416805e-01f, +1.155547185e-01f, +1.221383295e-01f, +1.216913882e-01f, +1.142686189e-01f, +1.007716434e-01f, +8.280237878e-02f, +6.240710511e-02f, +4.175995975e-02f, +2.284457612e-02f, +7.190216292e-03f, -4.294984422e-03f, -1.137264017e-02f, -1.440795170e-02f, -1.421381372e-02f, -1.184482760e-02f, -8.385779679e-03f, -4.774292714e-03f, -1.684836455e-03f, +5.152566717e-04f, +1.743512263e-03f, +2.132106022e-03f, +1.934567865e-03f, +1.434107668e-03f, +8.726146700e-04f, +4.104735791e-04f, +1.178893127e-04f,
    -6.970009343e-06f, -1.253418557e-05f, -1.693294841e-05f, -1.744151023e-05f, -1.125797349e-05f, +3.564695732e-06f, +2.710182039e-05f, +5.673850988e-05f, +8.684812514e-05f, +1.091973731e-04f, +1.141584072e-04f, +9.260689457e-05f, +3.817902783e-05f, -5.059423580e-05f, -1.688114720e-04f, -3.048445460e-04f, -4.413620194e-04f, -5.577024609e-04f, -6.332524186e-04f, -6.512188202e-04f, -6.020404421e-04f, -4.857020300e-04f, -3.124036978e-04f, -1.013617240e-04f, +1.220953584e-04f, +3.306077033e-04f, +4.992594577e-04f, +6.095797688e-04f, +6.523042246e-04f, +6.283997270e-04f, +5.482256479e-04f, +4.290894893e-04f, +2.917686997e-04f, +1.567442859e-04f, +4.089451147e-05f, -4.476177412e-05f, -9.595555809e-05f, -1.146914900e-04f, -1.076887123e-04f, -8.421228209e-05f, -5.383112996e-05f, -2.457339501e-05f, -1.788160879e-06f, +1.218528431e-05f, +1.763785591e-05f, +1.664053171e-05f, +1.202429206e-05f, +6.468086385e-06f,
    +1.826295111e-04f, -1.892638240e-04f, -1.101940326e-03f, -2.515967971e-03f, -4.025491083e-03f, -4.843653987e-03f, -3.998683707e-03f, -7.349732570e-04f, +4.999921712e-03f, +1.219236090e-02f, +1.874723616e-02f, +2.195004154e-02f, +1.935292392e-02f, +9.823912965e-03f, -5.640526330e-03f, -2.373141423e-02f, -3.948287364e-02f, -4.767449418e-02f, -4.457172237e-02f, -2.940118581e-02f, -4.982007526e-03f, +2.280870433e-02f, +4.665035507e-02f, +5.998127854e-02f, +5.905378763e-02f, +4.413018042e-02f, +1.939859676e-02f, -8.361513860e-03f, -3.189506020e-02f, -4.563777685e-02f, -4.721526827e-02f, -3.782743778e-02f, -2.148683842e-02f, -3.475683831e-03f, +1.138311909e-02f, +2.005151044e-02f, +2.182512026e-02f, +1.805383935e-02f, +1.127639642e-02f, +4.171343825e-03f, -1.286273200e-03f, -4.225888008e-03f, -4.812525874e-03f, -3.855441296e-03f, -2.321696244e-03f, -9.565407545e-04f, -1.155323981e-04f, +1.989201462e-04f,
    +4.586827532e-06f, +1.924275306e-05f, +3.714525083e-05f, +4.880395116e-05f, +4.159841831e-05f, +5.396691400e-06f, -6.039017732e-05f, -1.416102850e-04f, -2.095395216e-04f, -2.283355473e-04f, -1.686269495e-04f, -2.272943417e-05f, +1.850495629e-04f, +3.989550309e-04f, +5.456051746e-04f, +5.581742720e-04f, +4.029781075e-04f, +9.808802026e-05f, -2.847166625e-04f, -6.377538201e-04f, -8.505406338e-04f, -8.472225364e-04f, -6.147231401e-04f, -2.106298584e-04f, +2.530497498e-04f, +6.451878390e-04f, +8.576004368e-04f, +8.389984984e-04f, +6.090482106e-04f, +2.482872132e-04f, -1.314413747e-04f, -4.245869572e-04f, -5.639459584e-04f, -5.366849801e-04f, -3.805853830e-04f, -1.642544006e-04f, +3.966619283e-05f, +1.779842931e-04f, +2.295692488e-04f, +2.047026160e-04f, +1.340289548e-04f, +5.322931859e-05f, -1.013695931e-05f, -4.339770006e-05f, -4.831390965e-05f, -3.554927965e-05f, -1.762692433e-05f, -3.565974415e-06f,
    /*  2,15 (48) */
    +1.377935540e-04f, +4.470582739e-04f, +9.228359892e-04f, +1.486837854e-03f, +1.970213469e-03f, +2.124982568e-03f, +1.667276442e-03f, +3.508579141e-04f, -1.940123208e-03f, -5.098900637e-03f, -8.729372531e-03f, -1.212941022e-02f, -1.434158456e-02f, -1.427562782e-02f, -1.089037723e-02f, -3.406605786e-03f, +8.489794722e-03f, +2.449880837e-02f, +4.365012400e-02f, +6.436306461e-02f, +8.462371208e-02f, +1.022559785e-01f, +1.152423148e-01f, +1.220369678e-01f, +1.218134836e-01f, +1.145992266e-01f, +1.012709029e-01f, +8.341195855e-02f, +6.305940934e-02f, +4.238835948e-02f, +2.339280177e-02f, +7.619305782e-03f, -4.003215722e-03f, -1.121589588e-02f, -1.436705718e-02f, -1.425857550e-02f, -1.194078316e-02f, -8.500471169e-03f, -4.881981426e-03f, -1.769048737e-03f, +4.614255417e-04f, +1.718938868e-03f, +2.130317861e-03f, +1.946753149e-03f, +1.451745524e-03f, +8.892552017e-04f, +4.224978712e-04f, +1.243573991e-04f,
    -6.801738791e-06f, -1.236519602e-05f, -1.683914494e-05f, -1.751345456e-05f, -1.157561503e-05f, +2.963740453e-06f, +2.625263763e-05f, +5.576841276e-05f, +8.597658981e-05f, +1.087110996e-04f, +1.143618770e-04f, +9.375544306e-05f, +4.040740079e-05f, -4.733134538e-05f, -1.647705983e-04f, -3.004843754e-04f, -4.372900018e-04f, -5.545828692e-04f, -6.316911150e-04f, -6.516467669e-04f, -6.046201882e-04f, -4.902781610e-04f, -3.185100062e-04f, -1.082863446e-04f, +1.151978344e-04f, +3.245782408e-04f, +4.947974541e-04f, +6.071333445e-04f, +6.520085110e-04f, +6.300734059e-04f, +5.514237298e-04f, +4.331989390e-04f, +2.961255608e-04f, +1.607480540e-04f, +4.409802242e-05f, -4.260166134e-05f, -9.487161712e-05f, -1.145394853e-04f, -1.082081116e-04f, -8.509788127e-05f, -5.479921488e-05f, -2.540978874e-05f, -2.371552186e-06f, +1.188470494e-05f, +1.757887595e-05f, +1.674164258e-05f, +1.219520668e-05f, +6.634416134e-06f,
    +1.872163386e-04f, -1.700210709e-04f, -1.064795075e-03f, -2.467164020e-03f, -3.983892664e-03f, -4.838257295e-03f, -4.059073884e-03f, -8.765835420e-04f, +4.790382190e-03f, +1.196402535e-02f, +1.857860921e-02f, +2.192731211e-02f, +1.953797348e-02f, +1.022286800e-02f, -5.094921155e-03f, -2.317323996e-02f, -3.907989553e-02f, -4.757640616e-02f, -4.485643903e-02f, -3.003893963e-02f, -5.832548160e-03f, +2.196148179e-02f, +4.603563193e-02f, +5.977064868e-02f, +5.930683738e-02f, +4.477536826e-02f, +2.025619720e-02f, -7.522515361e-03f, -3.128601199e-02f, -4.538948963e-02f, -4.734670964e-02f, -3.825202474e-02f, -2.205078438e-02f, -4.012368812e-03f, +1.100253371e-02f, +1.988725604e-02f, +2.186478645e-02f, +1.823182364e-02f, +1.150596567e-02f, +4.376046441e-03f, -1.152244245e-03f, -4.172658690e-03f, -4.822662833e-03f, -3.898838996e-03f, -2.370010154e-03f, -9.920900342e-04f, -1.331593225e-04f, +1.953541718e-04f,
    +4.239062902e-06f, +1.870021254e-05f, +3.661857613e-05f, +4.865867407e-05f, +4.222699221e-05f, +7.007159918e-06f, -5.798598908e-05f, -1.390940832e-04f, -2.079742128e-04f, -2.288243418e-04f, -1.718332028e-04f, -2.843983174e-05f, +1.781074890e-04f, +3.928948564e-04f, +5.427631665e-04f, +5.602659095e-04f, +4.103336929e-04f, +1.092888830e-04f, -2.725974779e-04f, -6.283209769e-04f, -8.469075570e-04f, -8.509125476e-04f, -6.250539358e-04f, -2.248349998e-04f, +2.389762973e-04f, +6.352097412e-04f, +8.543720493e-04f, +8.430596442e-04f, +6.187513844e-04f, +2.604531230e-04f, -1.204076315e-04f, -4.175370929e-04f, -5.621896695e-04f, -5.397891773e-04f, -3.867708543e-04f, -1.711750692e-04f, +3.408582724e-05f, +1.749523706e-04f, +2.292353400e-04f, +2.063615363e-04f, +1.365666202e-04f, +5.559881639e-05f, -8.587302511e-06f, -4.282667583e-05f, -4.849519248e-05f, -3.608646442e-05f, -1.816153592e-05f, -3.898770305e-06f,
    /*  2,16 (48) */
    +1.309918152e-04f, +4.346930779e-04f, +9.059968443e-04f, +1.469324400e-03f, +1.958637854e-03f, +2.127946309e-03f, +1.693529080e-03f, +4.066263268e-04f, -1.854146618e-03f, -4.990189538e-03f, -8.615010654e-03f, -1.203565478e-02f, -1.430117716e-02f, -1.432295916e-02f, -1.105514783e-02f, -3.707090161e-03f, +8.052504721e-03f, +2.394422550e-02f, +4.301843289e-02f, +6.371141785e-02f, +8.401909189e-02f, +1.017657003e-01f, +1.149238048e-01f, +1.219286814e-01f, +1.219286814e-01f, +1.149238048e-01f, +1.017657003e-01f, +8.401909189e-02f, +6.371141785e-02f, +4.301843289e-02f, +2.394422550e-02f, +8.052504721e-03f, -3.707090161e-03f, -1.105514783e-02f, -1.432295916e-02f, -1.430117716e-02f, -1.203565478e-02f, -8.615010654e-03f, -4.990189538e-03f, -1.854146618e-03f, +4.066263268e-04f, +1.693529080e-03f, +2.127946309e-03f, +1.958637854e-03f, +1.469324400e-03f, +9.059968443e-04f, +4.346930779e-04f, +1.309918152e-04f,
    -6.634416134e-06f, -1.219520668e-05f, -1.674164258e-05f, -1.757887595e-05f, -1.188470494e-05f, +2.371552186e-06f, +2.540978874e-05f, +5.479921488e-05f, +8.509788127e-05f, +1.082081116e-04f, +1.145394853e-04f, +9.487161712e-05f, +4.260166134e-05f, -4.409802242e-05f, -1.607480540e-04f, -2.961255608e-04f, -4.331989390e-04f, -5.514237298e-04f, -6.300734059e-04f, -6.520085110e-04f, -6.071333445e-04f, -4.947974541e-04f, -3.245782408e-04f, -1.151978344e-04f, +1.082863446e-04f, +3.185100062e-04f, +4.902781610e-04f, +6.046201882e-04f, +6.516467669e-04f, +6.316911150e-04f, +5.545828692e-04f, +4.372900018e-04f, +3.004843754e-04f, +1.647705983e-04f, +4.733134538e-05f, -4.040740079e-05f, -9.375544306e-05f, -1.143618770e-04f, -1.087110996e-04f, -8.597658981e-05f, -5.576841276e-05f, -2.625263763e-05f, -2.963740453e-06f, +1.157561503e-05f, +1.751345456e-05f, +1.683914494e-05f, +1.236519602e-05f, +6.801738791e-06f,
    +1.914554015e-04f, -1.513208584e-04f, -1.028176499e-03f, -2.418505346e-03f, -3.941665672e-03f, -4.831250135e-03f, -4.117059873e-03f, -1.015677625e-03f, +4.582407978e-03f, +1.173520101e-02f, +1.840677601e-02f, +2.189887228e-02f, +1.971608097e-02f, +1.061576285e-02f, -4.552157989e-03f, -2.261297405e-02f, -3.866956183e-02f, -4.746711727e-02f, -4.512903651e-02f, -3.066726061e-02f, -6.679455717e-03f, +2.111056924e-02f, +4.541057800e-02f, +5.954581368e-02f, +5.954581368e-02f, +4.541057800e-02f, +2.111056924e-02f, -6.679455717e-03f, -3.066726061e-02f, -4.512903651e-02f, -4.746711727e-02f, -3.866956183e-02f, -2.261297405e-02f, -4.552157989e-03f, +1.061576285e-02f, +1.971608097e-02f, +2.189887228e-02f, +1.840677601e-02f, +1.173520101e-02f, +4.582407978e-03f, -1.015677625e-03f, -4.117059873e-03f, -4.831250135e-03f, -3.941665672e-03f, -2.418505346e-03f, -1.028176499e-03f, -1.513208584e-04f, +1.914554015e-04f,
    +3.898770305e-06f, +1.816153592e-05f, +3.608646442e-05f, +4.849519248e-05f, +4.282667583e-05f, +8.587302511e-06f, -5.559881639e-05f, -1.365666202e-04f, -2.063615363e-04f, -2.292353400e-04f, -1.749523706e-04f, -3.408582724e-05f, +1.711750692e-04f, +3.867708543e-04f, +5.397891773e-04f, +5.621896695e-04f, +4.175370929e-04f, +1.204076315e-04f, -2.604531230e-04f, -6.187513844e-04f, -8.430596442e-04f, -8.543720493e-04f, -6.352097412e-04f, -2.389762973e-04f, +2.248349998e-04f, +6.250539358e-04f, +8.509125476e-04f, +8.469075570e-04f, +6.283209769e-04f, +2.725974779e-04f, -1.092888830e-04f, -4.103336929e-04f, -5.602659095e-04f, -5.427631665e-04f, -3.928948564e-04f, -1.781074890e-04f, +2.843983174e-05f, +1.718332028e-04f, +2.288243418e-04f, +2.079742128e-04f, +1.390940832e-04f, +5.798598908e-05f, -7.007159918e-06f, -4.222699221e-05f, -4.865867407e-05f, -3.661857613e-05f, -1.870021254e-05f, -4.239062902e-06f,
    /*  2,17 (48) */
    +1.243573991e-04f, +4.224978712e-04f, +8.892552017e-04f, +1.451745524e-03f, +1.946753149e-03f, +2.130317861e-03f, +1.718938868e-03f, +4.614255417e-04f, -1.769048737e-03f, -4.881981426e-03f, -8.500471169e-03f, -1.194078316e-02f, -1.425857550e-02f, -1.436705718e-02f, -1.121589588e-02f, -4.003215722e-03f, +7.619305782e-03f, +2.339280177e-02f, +4.238835948e-02f, +6.305940934e-02f, +8.341195855e-02f, +1.012709029e-01f, +1.145992266e-01f, +1.218134836e-01f, +1.220369678e-01f, +1.152423148e-01f, +1.022559785e-01f, +8.462371208e-02f, +6.436306461e-02f, +4.365012400e-02f, +2.449880837e-02f, +8.489794722e-03f, -3.406605786e-03f, -1.089037723e-02f, -1.427562782e-02f, -1.434158456e-02f, -1.212941022e-02f, -8.729372531e-03f, -5.098900637e-03f, -1.940123208e-03f, +3.508579141e-04f, +1.667276442e-03f, +2.124982568e-03f, +1.970213469e-03f, +1.486837854e-03f, +9.228359892e-04f, +4.470582739e-04f, +1.377935540e-04f,
    -6.468086385e-06f, -1.202429206e-05f, -1.664053171e-05f, -1.763785591e-05f, -1.218528431e-05f, +1.788160879e-06f, +2.457339501e-05f, +5.383112996e-05f, +8.421228209e-05f, +1.076887123e-04f, +1.146914900e-04f, +9.595555809e-05f, +4.476177412e-05f, -4.089451147e-05f, -1.567442859e-04f, -2.917686997e-04f, -4.290894893e-04f, -5.482256479e-04f, -6.283997270e-04f, -6.523042246e-04f, -6.095797688e-04f, -4.992594577e-04f, -3.306077033e-04f, -1.220953584e-04f, +1.013617240e-04f, +3.124036978e-04f, +4.857020300e-04f, +6.020404421e-04f, +6.512188202e-04f, +6.332524186e-04f, +5.577024609e-04f, +4.413620194e-04f, +3.048445460e-04f, +1.688114720e-04f, +5.059423580e-05f, -3.817902783e-05f, -9.260689457e-05f, -1.141584072e-04f, -1.091973731e-04f, -8.684812514e-05f, -5.673850988e-05f, -2.710182039e-05f, -3.564695732e-06f, +1.125797349e-05f, +1.744151023e-05f, +1.693294841e-05f, +1.253418557e-05f, +6.970009343e-06f,
    +1.953541718e-04f, -1.331593225e-04f, -9.920900342e-04f, -2.370010154e-03f, -3.898838996e-03f, -4.822662833e-03f, -4.172658690e-03f, -1.152244245e-03f, +4.376046441e-03f, +1.150596567e-02f, +1.823182364e-02f, +2.186478645e-02f, +1.988725604e-02f, +1.100253371e-02f, -4.012368812e-03f, -2.205078438e-02f, -3.825202474e-02f, -4.734670964e-02f, -4.538948963e-02f, -3.128601199e-02f, -7.522515361e-03f, +2.025619720e-02f, +4.477536826e-02f, +5.930683738e-02f, +5.977064868e-02f, +4.603563193e-02f, +2.196148179e-02f, -5.832548160e-03f, -3.003893963e-02f, -4.485643903e-02f, -4.757640616e-02f, -3.907989553e-02f, -2.317323996e-02f, -5.094921155e-03f, +1.022286800e-02f, +1.953797348e-02f, +2.192731211e-02f, +1.857860921e-02f, +1.196402535e-02f, +4.790382190e-03f, -8.765835420e-04f, -4.059073884e-03f, -4.838257295e-03f, -3.983892664e-03f, -2.467164020e-03f, -1.064795075e-03f, -1.700210709e-04f, +1.872163386e-04f,
    +3.565974415e-06f, +1.762692433e-05f, +3.554927965e-05f, +4.831390965e-05f, +4.339770006e-05f, +1.013695931e-05f, -5.322931859e-05f, -1.340289548e-04f, -2.047026160e-04f, -2.295692488e-04f, -1.779842931e-04f, -3.966619283e-05f, +1.642544006e-04f, +3.805853830e-04f, +5.366849801e-04f, +5.639459584e-04f, +4.245869572e-04f, +1.314413747e-04f, -2.482872132e-04f, -6.090482106e-04f, -8.389984984e-04f, -8.576004368e-04f, -6.451878390e-04f, -2.530497498e-04f, +2.106298584e-04f, +6.147231401e-04f, +8.472225364e-04f, +8.505406338e-04f, +6.377538201e-04f, +2.847166625e-04f, -9.808802026e-05f, -4.029781075e-04f, -5.581742720e-04f, -5.456051746e-04f, -3.989550309e-04f, -1.850495629e-04f, +2.272943417e-05f, +1.686269495e-04f, +2.283355473e-04f, +2.095395216e-04f, +1.416102850e-04f, +6.039017732e-05f, -5.396691400e-06f, -4.159841831e-05f, -4.880395116e-05f, -3.714525083e-05f, -1.924275306e-05f, -4.586827532e-06f,
    /*  2,18 (48) */
    +1.178893127e-04f, +4.104735791e-04f, +8.726146700e-04f, +1.434107668e-03f, +1.934567865e-03f, +2.132106022e-03f, +1.743512263e-03f, +5.152566717e-04f, -1.684836455e-03f, -4.774292714e-03f, -8.385779679e-03f, -1.184482760e-02f, -1.421381372e-02f, -1.440795170e-02f, -1.137264017e-02f, -4.294984422e-03f, +7.190216292e-03f, +2.284457612e-02f, +4.175995975e-02f, +6.240710511e-02f, +8.280237878e-02f, +1.007716434e-01f, +1.142686189e-01f, +1.216913882e-01f, +1.221383295e-01f, +1.155547185e-01f, +1.027416805e-01f, +8.522575252e-02f, +6.501428343e-02f, +4.428337642e-02f, +2.505651083e-02f, +8.931156742e-03f, -3.101761240e-03f, -1.072156576e-02f, -1.422503358e-02f, -1.437976359e-02f, -1.222201712e-02f, -8.843530939e-03f, -5.208098011e-03f, -2.026971333e-03f, +2.941194042e-04f, +1.640174622e-03f, +2.121417873e-03f, +1.981471443e-03f, +1.504279365e-03f, +9.397689376e-04f, +4.595924595e-04f, +1.447635633e-04f,
    -6.302793544e-06f, -1.185252593e-05f, -1.653590257e-05f, -1.769047668e-05f, -1.247739601e-05f, +1.213593878e-06f, +2.374357475e-05f, +5.286436904e-05f, +8.332007332e-05f, +1.071532054e-04f, +1.148181517e-04f, +9.700741192e-05f, +4.688770998e-05f, -3.772105044e-05f, -1.527597348e-04f, -2.874143859e-04f, -4.249623105e-04f, -5.449892318e-04f, -6.266705210e-04f, -6.525340894e-04f, -6.119593288e-04f, -5.036637291e-04f, -3.365977016e-04f, -1.289780839e-04f, +9.442480972e-05f, +3.062600203e-04f, +4.810695220e-04f, +5.993942585e-04f, +6.507245079e-04f, +6.347568882e-04f, +5.607819037e-04f, +4.454143335e-04f, +3.092054717e-04f, +1.728702230e-04f, +5.388644247e-05f, -3.591658402e-05f, -9.142583506e-05f, -1.139288206e-04f, -1.096666292e-04f, -8.771220318e-05f, -5.770928988e-05f, -2.795721277e-05f, -4.174385444e-06f, +1.093174100e-05f, +1.736296222e-05f, +1.702296245e-05f, +1.270210001e-05f, +7.139181769e-06f,
    +1.989201462e-04f, -1.155323981e-04f, -9.565407545e-04f, -2.321696244e-03f, -3.855441296e-03f, -4.812525874e-03f, -4.225888008e-03f, -1.286273200e-03f, +4.171343825e-03f, +1.127639642e-02f, +1.805383935e-02f, +2.182512026e-02f, +2.005151044e-02f, +1.138311909e-02f, -3.475683831e-03f, -2.148683842e-02f, -3.782743778e-02f, -4.721526827e-02f, -4.563777685e-02f, -3.189506020e-02f, -8.361513860e-03f, +1.939859676e-02f, +4.413018042e-02f, +5.905378763e-02f, +5.998127854e-02f, +4.665035507e-02f, +2.280870433e-02f, -4.982007526e-03f, -2.940118581e-02f, -4.457172237e-02f, -4.767449418e-02f, -3.948287364e-02f, -2.373141423e-02f, -5.640526330e-03f, +9.823912965e-03f, +1.935292392e-02f, +2.195004154e-02f, +1.874723616e-02f, +1.219236090e-02f, +4.999921712e-03f, -7.349732570e-04f, -3.998683707e-03f, -4.843653987e-03f, -4.025491083e-03f, -2.515967971e-03f, -1.101940326e-03f, -1.892638240e-04f, +1.826295111e-04f,
    +3.240695165e-06f, +1.709657307e-05f, +3.500738196e-05f, +4.811523052e-05f, +4.394030475e-05f, +1.165598518e-05f, -5.087813966e-05f, -1.314821367e-04f, -2.029985807e-04f, -2.298267956e-04f, -1.809288428e-04f, -4.517973332e-05f, +1.573475604e-04f, +3.743408051e-04f, +5.334523797e-04f, +5.655352339e-04f, +4.314819906e-04f, +1.423872601e-04f, -2.361033579e-04f, -5.992146559e-04f, -8.347257851e-04f, -8.605971771e-04f, -6.549855683e-04f, -2.670513784e-04f, +1.963648945e-04f, +6.042201278e-04f, +8.433026921e-04f, +8.539573337e-04f, +6.470467794e-04f, +2.968070569e-04f, -8.680797206e-05f, -3.954717418e-04f, -5.559144026e-04f, -5.483134604e-04f, -4.049490240e-04f, -1.919991747e-04f, +1.695589485e-05f, +1.653338023e-04f, +2.277682708e-04f, +2.110563443e-04f, +1.441141591e-04f, +6.281070650e-05f, -3.756071670e-06f, -4.094073241e-05f, -4.893062236e-05f, -3.766612089e-05f, -1.978895051e-05f, -4.942034718e-06f,
    /*  2,19 (48) */
    +1.115865191e-04f, +3.986210532e-04f, +8.560787674e-04f, +1.416417191e-03f, +1.922090469e-03f, +2.133319616e-03f, +1.767255838e-03f, +5.681210407e-04f, -1.601516381e-03f, -4.667139508e-03f, -8.270961528e-03f, -1.174782019e-02f, -1.416692601e-02f, -1.444567275e-02f, -1.152539990e-02f, -4.582398808e-03f, +6.765253982e-03f, +2.229958689e-02f, +4.113328923e-02f, +6.175457102e-02f, +8.219041945e-02f, +1.002679797e-01f, +1.139320212e-01f, +1.215624102e-01f, +1.222327543e-01f, +1.158609786e-01f, +1.032227500e-01f, +8.582514678e-02f, +6.566500794e-02f, +4.491813331e-02f, +2.561729273e-02f, +9.376571075e-03f, -2.792555768e-03f, -1.054869554e-02f, -1.417114714e-02f, -1.441568017e-02f, -1.231344295e-02f, -8.957459759e-03f, -5.317764640e-03f, -2.114683536e-03f, +2.364101143e-04f, +1.612217409e-03f, +2.117243487e-03f, +1.992403184e-03f, +1.521642327e-03f, +9.567919001e-04f, +4.722945595e-04f, +1.519027451e-04f,
    -6.138580599e-06f, -1.167998123e-05f, -1.642784518e-05f, -1.773682123e-05f, -1.276108460e-05f, +6.478759438e-07f, +2.292044324e-05f, +5.189914050e-05f, +8.242153441e-05f, +1.066018947e-04f, +1.149197331e-04f, +9.802732920e-05f, +4.897944593e-05f, -3.457787058e-05f, -1.487948357e-04f, -2.830632097e-04f, -4.208180602e-04f, -5.417150934e-04f, -6.248862372e-04f, -6.526982959e-04f, -6.142719023e-04f, -5.080098345e-04f, -3.425475498e-04f, -1.358451806e-04f, +8.747644082e-05f, +3.000796842e-04f, +4.763811065e-04f, +5.966817999e-04f, +6.501636765e-04f, +6.362041019e-04f, +5.638205997e-04f, +4.494462858e-04f, +3.135665484e-04f, +1.769463931e-04f, +5.720770752e-05f, -3.362011720e-05f, -9.021213267e-05f, -1.136728644e-04f, -1.101185653e-04f, -8.856853840e-05f, -5.868053377e-05f, -2.881868748e-05f, -4.792774367e-06f, +1.059688009e-05f, +1.727773059e-05f, +1.710909637e-05f, +1.286886331e-05f, +7.309209040e-06f,
    +2.021608414e-04f, -9.843582508e-05f, -9.215333726e-04f, -2.273581014e-03f, -3.811500991e-03f, -4.800869888e-03f, -4.276766148e-03f, -1.417755337e-03f, +3.968345245e-03f, +1.104656963e-02f, +1.787291050e-02f, +2.177994052e-02f, +2.020885800e-02f, +1.175745989e-02f, -2.942231452e-03f, -2.092130319e-02f, -3.739595579e-02f, -4.707288101e-02f, -4.587388020e-02f, -3.249427486e-02f, -9.196239645e-03f, +1.853799958e-02f, +4.347519485e-02f, +5.878673626e-02f, +6.017764343e-02f, +4.725457520e-02f, +2.365200702e-02f, -4.128050193e-03f, -2.875413903e-02f, -4.427491531e-02f, -4.776130215e-02f, -3.987834538e-02f, -2.428732863e-02f, -6.188839790e-03f, +9.418963941e-03f, +1.916092474e-02f, +2.196699744e-02f, +1.891256997e-02f, +1.242012917e-02f, +5.210978056e-03f, -5.908590979e-04f, -3.935873000e-03f, -4.847410058e-03f, -4.066431815e-03f, -2.564898594e-03f, -1.139606446e-03f, -2.090527745e-04f, +1.776874763e-04f,
    +2.922947826e-06f, +1.657067159e-05f, +3.446112759e-05f, +4.789956147e-05f, +4.445473845e-05f, +1.314424960e-05f, -4.854590819e-05f, -1.289272071e-04f, -2.012505635e-04f, -2.300087278e-04f, -1.837859237e-04f, -5.062528636e-05f, +1.504566055e-04f, +3.680394865e-04f, +5.300932113e-04f, +5.669580047e-04f, +4.382209531e-04f, +1.532424745e-04f, -2.239051597e-04f, -5.892539518e-04f, -8.302432309e-04f, -8.633618090e-04f, -6.646003260e-04f, -2.809772275e-04f, +1.820441491e-04f, +5.935477276e-04f, +8.391537625e-04f, +8.571561795e-04f, +6.561967548e-04f, +3.088650378e-04f, -7.545170401e-05f, -3.878160556e-04f, -5.534859988e-04f, -5.508863156e-04f, -4.108744881e-04f, -1.989541894e-04f, +1.112050636e-05f, +1.619539854e-04f, +2.271218480e-04f, +2.125235683e-04f, +1.466046309e-04f, +6.524688689e-05f, -2.085490399e-06f, -4.025372215e-05f, -4.903828840e-05f, -3.818081515e-05f, -2.033859211e-05f, -5.304650110e-06f,
    /*  2,20 (48) */
    +1.054479385e-04f, +3.869410720e-04f, +8.396509222e-04f, +1.398680370e-03f, +1.909329384e-03f, +2.133967492e-03f, +1.790176281e-03f, +6.200201812e-04f, -1.519094847e-03f, -4.560537614e-03f, -8.156041794e-03f, -1.164979286e-02f, -1.411794657e-02f, -1.448025062e-02f, -1.167419474e-02f, -4.865462017e-03f, +6.344435922e-03f, +2.175787180e-02f, +4.050840299e-02f, +6.110187273e-02f, +8.157614755e-02f, +9.975996985e-02f, +1.135894736e-01f, +1.214265650e-01f, +1.223202308e-01f, +1.161610583e-01f, +1.036991311e-01f, +8.642182858e-02f, +6.631517162e-02f, +4.555433741e-02f, +2.618111333e-02f, +9.826017361e-03f, -2.478989220e-03f, -1.037174914e-02f, -1.411393943e-02f, -1.444930029e-02f, -1.240365508e-02f, -9.071132624e-03f, -5.427883205e-03f, -2.203252074e-03f, +1.777295806e-04f, +1.583398721e-03f, +2.112450713e-03f, +2.003000064e-03f, +1.538920057e-03f, +9.739009964e-04f, +4.851634228e-04f, +1.592119541e-04f,
    -5.975489525e-06f, -1.150673014e-05f, -1.631644935e-05f, -1.777697317e-05f, -1.303639635e-05f, +9.102927193e-08f, +2.210411281e-05f, +5.093564998e-05f, +8.151694320e-05f, +1.060350840e-04f, +1.149964995e-04f, +9.901546503e-05f, +5.103696510e-05f, -3.146519645e-05f, -1.448500178e-04f, -2.787157577e-04f, -4.166573956e-04f, -5.384038478e-04f, -6.230473317e-04f, -6.527970441e-04f, -6.165173774e-04f, -5.122973493e-04f, -3.484565686e-04f, -1.426958208e-04f, +8.051745830e-05f, +2.938634059e-04f, +4.716372619e-04f, +5.939032386e-04f, +6.495361818e-04f, +6.375936455e-04f, +5.668179551e-04f, +4.534572180e-04f, +3.179271685e-04f, +1.810395187e-04f, +6.055776647e-05f, -3.128968150e-05f, -8.896566043e-05f, -1.133902888e-04f, -1.105528795e-04f, -8.941684389e-05f, -5.965201997e-05f, -2.968611429e-05f, -5.419824611e-06f, +1.025335508e-05f, +1.718573622e-05f, +1.719125943e-05f, +1.303439868e-05f, +7.480043122e-06f,
    +2.050837892e-04f, -8.186515349e-05f, -8.870722450e-04f, -2.225681452e-03f, -3.767046253e-03f, -4.787725639e-03f, -4.325312056e-03f, -1.546682544e-03f, +3.767094681e-03f, +1.081656090e-02f, +1.768912458e-02f, +2.172931524e-02f, +2.035931460e-02f, +1.212549938e-02f, -2.412138240e-03f, -2.035434518e-02f, -3.695773484e-02f, -4.691963853e-02f, -4.609778536e-02f, -3.308352881e-02f, -1.002648288e-02f, +1.767463777e-02f, +4.281059452e-02f, +5.850575903e-02f, +6.035968758e-02f, +4.784812293e-02f, +2.449116078e-02f, -3.270894013e-03f, -2.809794228e-02f, -4.396605027e-02f, -4.783675385e-02f, -4.026616143e-02f, -2.484081463e-02f, -6.739726106e-03f, +9.008089453e-03f, +1.896197055e-02f, +2.197811794e-02f, +1.907452395e-02f, +1.264725102e-02f, +5.423501625e-03f, -4.442544670e-04f, -3.870626113e-03f, -4.849495549e-03f, -4.106685537e-03f, -2.613936882e-03f, -1.177787262e-03f, -2.293913666e-04f, +1.723828262e-04f,
    +2.612743069e-06f, +1.604940348e-05f, +3.391086871e-05f, +4.766731014e-05f, +4.494125820e-05f, +1.460163653e-05f, -4.623323722e-05f, -1.263651979e-04f, -1.994597013e-04f, -2.301158125e-04f, -1.865554712e-04f, -5.600172260e-05f, +1.435835716e-04f, +3.616837955e-04f, +5.266093397e-04f, +5.682148300e-04f, +4.448026599e-04f, +1.640042448e-04f, -2.116962129e-04f, -5.791693600e-04f, -8.255526230e-04f, -8.658939429e-04f, -6.740295675e-04f, -2.948233659e-04f, +1.676716814e-04f, +5.827088224e-04f, +8.347765667e-04f, +8.601357579e-04f, +6.652006819e-04f, +3.208869794e-04f, -6.402221775e-05f, -3.800125628e-04f, -5.508888108e-04f, -5.533220657e-04f, -4.167290819e-04f, -2.059124541e-04f, +5.224593305e-06f, +1.584877552e-04f, +2.263956365e-04f, +2.139400871e-04f, +1.490806182e-04f, +6.769801371e-05f, -3.851523159e-07f, -3.953718479e-05f, -4.912655230e-05f, -3.868895900e-05f, -2.089145928e-05f, -5.674634421e-06f,
    /*  2,21 (48) */
    +9.947244900e-05f, +3.754343418e-04f, +8.233344729e-04f, +1.380903397e-03f, +1.896292988e-03f, +2.134058521e-03f, +1.812280394e-03f, +6.709558312e-04f, -1.437577904e-03f, -4.454502530e-03f, -8.041045295e-03f, -1.155077740e-02f, -1.406690960e-02f, -1.451171581e-02f, -1.181904476e-02f, -5.144177775e-03f, +5.927778526e-03f, +2.121946795e-02f, +3.988535566e-02f, +6.044907568e-02f, +8.095963017e-02f, +9.924767250e-02f, +1.132410171e-01f, +1.212838692e-01f, +1.224007482e-01f, +1.164549217e-01f, +1.041707684e-01f, +8.701573182e-02f, +6.696470780e-02f, +4.619193106e-02f, +2.674793129e-02f, +1.027947458e-02f, -2.161062051e-03f, -1.019070962e-02f, -1.405338166e-02f, -1.448058997e-02f, -1.249262075e-02f, -9.184522912e-03f, -5.538436085e-03f, -2.292668918e-03f, +1.180775606e-04f, +1.553712607e-03f, +2.107030888e-03f, +2.013253419e-03f, +1.556105794e-03f, +9.910922559e-04f, +4.981978215e-04f, +1.666919973e-04f,
    -5.813561281e-06f, -1.133284398e-05f, -1.620180464e-05f, -1.781101677e-05f, -1.330337920e-05f, -4.569264820e-07f, +2.129469280e-05f, +4.997410040e-05f, +8.060657581e-05f, +1.054530775e-04f, +1.150487184e-04f, +9.997197899e-05f, +5.306025672e-05f, -2.838324597e-05f, -1.409257044e-04f, -2.743726128e-04f, -4.124809731e-04f, -5.350561130e-04f, -6.211542671e-04f, -6.528305431e-04f, -6.186956518e-04f, -5.165258583e-04f, -3.543240851e-04f, -1.495291793e-04f, +7.354870489e-05f, +2.876119077e-04f, +4.668384753e-04f, +5.910587572e-04f, +6.488418893e-04f, +6.389251117e-04f, +5.697733800e-04f, +4.574464721e-04f, +3.222867216e-04f, +1.851491307e-04f, +6.393634822e-05f, -2.892533735e-05f, -8.768629623e-05f, -1.130808466e-04f, -1.109692702e-04f, -9.025683137e-05f, -6.062352435e-05f, -3.055935993e-05f, -6.055495601e-06f, +9.901132222e-06f, +1.708690087e-05f, +1.726936079e-05f, +1.319862861e-05f, +7.651634979e-06f,
    +2.076965323e-04f, -6.581575001e-05f, -8.531613762e-04f, -2.178014142e-03f, -3.722104995e-03f, -4.773124002e-03f, -4.371545293e-03f, -1.673047742e-03f, +3.567634980e-03f, +1.058644509e-02f, +1.750256911e-02f, +2.167331351e-02f, +2.050289818e-02f, +1.248718318e-02f, -1.885528901e-03f, -1.978613035e-02f, -3.651293218e-02f, -4.675563429e-02f, -4.630948158e-02f, -3.366269817e-02f, -1.085203550e-02f, +1.680874383e-02f, +4.213656496e-02f, +5.821093566e-02f, +6.052735927e-02f, +4.843083175e-02f, +2.532593735e-02f, -2.410758255e-03f, -2.743274159e-02f, -4.364516329e-02f, -4.790077607e-02f, -4.064617400e-02f, -2.539170344e-02f, -7.293048172e-03f, +8.591360371e-03f, +1.875605810e-02f, +2.198334254e-02f, +1.923301171e-02f, +1.287364666e-02f, +5.637441712e-03f, -2.951738487e-04f, -3.802928100e-03f, -4.849880701e-03f, -4.146222722e-03f, -2.663063435e-03f, -1.216476221e-03f, -2.502828259e-04f, +1.667081918e-04f,
    +2.310087044e-06f, +1.553294649e-05f, +3.335695340e-05f, +4.741888520e-05f, +4.540012932e-05f, +1.602804428e-05f, -4.394072422e-05f, -1.237971315e-04f, -1.976271346e-04f, -2.301488361e-04f, -1.892374520e-04f, -6.130794585e-05f, +1.367304729e-04f, +3.552761018e-04f, +5.230026589e-04f, +5.693063191e-04f, +4.512259819e-04f, +1.746698386e-04f, -1.994801026e-04f, -5.689641709e-04f, -8.206558088e-04f, -8.681932613e-04f, -6.832708074e-04f, -3.085858884e-04f, +1.532515671e-04f, +5.717063486e-04f, +8.301719951e-04f, +8.628947198e-04f, +6.740555333e-04f, +3.328692552e-04f, -5.252255007e-05f, -3.720628316e-04f, -5.481226416e-04f, -5.556190707e-04f, -4.225104719e-04f, -2.128717986e-04f, -7.304878903e-07f, +1.549354012e-04f, +2.255890162e-04f, +2.153048015e-04f, +1.515410319e-04f, +7.016336728e-05f, +1.344722690e-06f, -3.879092743e-05f, -4.919501962e-05f, -3.919017456e-05f, -2.144732766e-05f, -6.051943364e-06f,
    /*  2,22 (48) */
    +9.365888772e-05f, +3.641014979e-04f, +8.071326683e-04f, +1.363092380e-03f, +1.882989609e-03f, +2.133601595e-03f, +1.833575087e-03f, +7.209299316e-04f, -1.356971328e-03f, -4.349049452e-03f, -7.925996577e-03f, -1.145080542e-02f, -1.401384935e-02f, -1.454009906e-02f, -1.195997046e-02f, -5.418550388e-03f, +5.515297553e-03f, +2.068441184e-02f, +3.926420140e-02f, +5.979624514e-02f, +8.034093452e-02f, +9.873114664e-02f, +1.128866930e-01f, +1.211343400e-01f, +1.224742969e-01f, +1.167425336e-01f, +1.046376069e-01f, +8.760679058e-02f, +6.761354969e-02f, +4.683085617e-02f, +2.731770467e-02f, +1.073692105e-02f, -1.838775330e-03f, -1.000556049e-02f, -1.398944532e-02f, -1.450951531e-02f, -1.258030704e-02f, -9.297603759e-03f, -5.649405355e-03f, -2.382925750e-03f, +5.745403624e-05f, +1.523153247e-03f, +2.100975393e-03f, +2.023154551e-03f, +1.573192694e-03f, +1.008361617e-03f, +5.113964501e-04f, +1.743436322e-04f,
    -5.652835814e-06f, -1.115839327e-05f, -1.608400036e-05f, -1.783903691e-05f, -1.356208269e-05f, -9.959741817e-07f, +2.049228958e-05f, +4.901469194e-05f, +7.969070668e-05f, +1.048561792e-04f, +1.150766596e-04f, +1.008970351e-04f, +5.504931606e-05f, -2.533223037e-05f, -1.370223128e-04f, -2.700343538e-04f, -4.082894485e-04f, -5.316725104e-04f, -6.192075126e-04f, -6.527990109e-04f, -6.208066337e-04f, -5.206949552e-04f, -3.601494334e-04f, -1.563444340e-04f, +6.657102488e-05f, +2.813259176e-04f, +4.619852426e-04f, +5.881485482e-04f, +6.480806737e-04f, +6.401981006e-04f, +5.726862885e-04f, +4.614133903e-04f, +3.266445939e-04f, +1.892747545e-04f, +6.734317504e-05f, -2.652715154e-05f, -8.637392289e-05f, -1.127442933e-04f, -1.113674365e-04f, -9.108821130e-05f, -6.159482021e-05f, -3.143828816e-05f, -6.699744060e-06f, +9.540179638e-06f, +1.698114718e-05f, +1.734330956e-05f, +1.336147488e-05f, +7.823934576e-06f,
    +2.100066193e-04f, -5.028280352e-05f, -8.198044229e-04f, -2.130595257e-03f, -3.676704865e-03f, -4.757095958e-03f, -4.415486017e-03f, -1.796844873e-03f, +3.370007845e-03f, +1.035629625e-02f, +1.731333166e-02f, +2.161200557e-02f, +2.063962865e-02f, +1.284245928e-02f, -1.362526242e-03f, -1.921682403e-02f, -3.606170620e-02f, -4.658096445e-02f, -4.650896168e-02f, -3.423166234e-02f, -1.167269131e-02f, +1.594055057e-02f, +4.145329415e-02f, +5.790234977e-02f, +6.068061083e-02f, +4.900253810e-02f, +2.615610935e-02f, -1.547863536e-03f, -2.675868606e-02f, -4.331229404e-02f, -4.795329862e-02f, -4.101823683e-02f, -2.593982609e-02f, -7.848667242e-03f, +8.168849899e-03f, +1.854318630e-02f, +2.198261205e-02f, +1.938794711e-02f, +1.309923567e-02f, +5.852746513e-03f, -1.436328168e-04f, -3.732764732e-03f, -4.848535978e-03f, -4.185013649e-03f, -2.712258454e-03f, -1.255666395e-03f, -2.717301535e-04f, +1.606562484e-04f,
    +2.014981454e-06f, +1.502147253e-05f, +3.279972542e-05f, +4.715469618e-05f, +4.583162515e-05f, +1.742338539e-05f, -4.166895100e-05f, -1.212240206e-04f, -1.957540069e-04f, -2.301086035e-04f, -1.918318640e-04f, -6.654289323e-05f, +1.298993015e-04f, +3.488187759e-04f, +5.192750907e-04f, +5.702331310e-04f, +4.574898456e-04f, +1.852365655e-04f, -1.872604035e-04f, -5.586417028e-04f, -8.155546947e-04f, -8.702595184e-04f, -6.923216202e-04f, -3.222609165e-04f, +1.387878976e-04f, +5.605432950e-04f, +8.253410091e-04f, +8.654317815e-04f, +6.827583192e-04f, +3.448082387e-04f, -4.095577201e-05f, -3.639684837e-04f, -5.451873476e-04f, -5.577757256e-04f, -4.282163328e-04f, -2.198300360e-04f, -6.743349257e-06f, +1.512972455e-04f, +2.247013900e-04f, +2.166166192e-04f, +1.539847759e-04f, +7.264221312e-05f, +3.103899478e-06f, -3.801476720e-05f, -4.924329868e-05f, -3.968408078e-05f, -2.200596715e-05f, -6.436527589e-06f,
    /*  2,23 (48) */
    +8.800605191e-05f, +3.529431046e-04f, +7.910486679e-04f, +1.345253343e-03f, +1.869427526e-03f, +2.132605620e-03f, +1.854067377e-03f, +7.699446236e-04f, -1.277280621e-03f, -4.244193273e-03f, -7.810919917e-03f, -1.134990838e-02f, -1.395880003e-02f, -1.456543129e-02f, -1.209699277e-02f, -5.688584742e-03f, +5.107008105e-03f, +2.015273933e-02f, +3.864499388e-02f, +5.914344613e-02f, +7.972012788e-02f, +9.821045169e-02f, +1.125265436e-01f, +1.209779955e-01f, +1.225408679e-01f, +1.170238595e-01f, +1.050995921e-01f, +8.819493912e-02f, +6.826163036e-02f, +4.747105427e-02f, +2.789039096e-02f, +1.119833444e-02f, -1.512130736e-03f, -9.816285739e-03f, -1.392210214e-02f, -1.453604246e-02f, -1.266668096e-02f, -9.410348052e-03f, -5.760772791e-03f, -2.474013961e-03f, -4.140783970e-06f, +1.491714959e-03f, +2.094275649e-03f, +2.032694731e-03f, +1.590173842e-03f, +1.025704926e-03f, +5.247579250e-04f, +1.821675668e-04f,
    -5.493352053e-06f, -1.098344767e-05f, -1.596312552e-05f, -1.786111905e-05f, -1.381255800e-05f, -1.526099187e-06f, +1.969700654e-05f, +4.805762199e-05f, +7.876960845e-05f, +1.042446931e-04f, +1.150805950e-04f, +1.017908016e-04f, +5.700414440e-05f, -2.231235421e-05f, -1.331402544e-04f, -2.657015558e-04f, -4.040834770e-04f, -5.282536639e-04f, -6.172075439e-04f, -6.527026745e-04f, -6.228502412e-04f, -5.248042432e-04f, -3.659319540e-04f, -1.631407655e-04f, +5.958526404e-05f, +2.750061691e-04f, +4.570780681e-04f, +5.851728139e-04f, +6.472524196e-04f, +6.414122198e-04f, +5.755560987e-04f, +4.653573154e-04f, +3.310001687e-04f, +1.934159098e-04f, +7.077796261e-05f, -2.409519724e-05f, -8.502842828e-05f, -1.123803877e-04f, -1.117470784e-04f, -9.191069286e-05f, -6.256567834e-05f, -3.232275977e-05f, -7.352523987e-06f, +9.170467399e-06f, +1.686839873e-05f, +1.741301485e-05f, +1.352285859e-05f, +7.996890882e-06f,
    +2.120216008e-04f, -3.526133099e-05f, -7.870046974e-04f, -2.083440561e-03f, -3.630873240e-03f, -4.739672573e-03f, -4.457154968e-03f, -1.918068894e-03f, +3.174253838e-03f, +1.012618765e-02f, +1.712149979e-02f, +2.154546268e-02f, +2.076952795e-02f, +1.319127805e-02f, -8.432511510e-04f, -1.864659090e-02f, -3.560421635e-02f, -4.639572788e-02f, -4.669622208e-02f, -3.479030404e-02f, -1.248824600e-02f, +1.507029105e-02f, +4.076097253e-02f, +5.758008886e-02f, +6.081939873e-02f, +4.956308140e-02f, +2.698145035e-02f, -6.824317540e-04f, -2.607592774e-02f, -4.296748580e-02f, -4.799425439e-02f, -4.138220531e-02f, -2.648501343e-02f, -8.406442968e-03f, +7.740633566e-03f, +1.832335626e-02f, +2.197586870e-02f, +1.953924435e-02f, +1.332393706e-02f, +6.069363132e-03f, +1.035195909e-05f, -3.660122519e-03f, -4.845432079e-03f, -4.223028416e-03f, -2.761501753e-03f, -1.295350476e-03f, -2.937361207e-04f, +1.542197209e-04f,
    +1.727423627e-06f, +1.451514763e-05f, +3.223952423e-05f, +4.687515319e-05f, +4.623602683e-05f, +1.878758649e-05f, -3.941848368e-05f, -1.186468676e-04f, -1.938414640e-04f, -2.299959380e-04f, -1.943387355e-04f, -7.170553526e-05f, +1.230920268e-04f, +3.423141883e-04f, +5.154285844e-04f, +5.709959738e-04f, +4.635932335e-04f, +1.957017770e-04f, -1.750406785e-04f, -5.482053006e-04f, -8.102512456e-04f, -8.720925403e-04f, -7.011796411e-04f, -3.358446005e-04f, +1.242847781e-04f, +5.492227019e-04f, +8.202846407e-04f, +8.677457248e-04f, +6.913060890e-04f, +3.567003045e-04f, -2.932498800e-05f, -3.557311946e-04f, -5.420828385e-04f, -5.597904616e-04f, -4.338443485e-04f, -2.267849633e-04f, -1.281257153e-05f, +1.475736432e-04f, +2.237321840e-04f, +2.178744558e-04f, +1.564107476e-04f, +7.513380208e-05f, +4.892127566e-06f, -3.720853147e-05f, -4.927100079e-05f, -4.017029362e-05f, -2.256714189e-05f, -6.828332627e-06f,
    /*  2,24 (48) */
    +8.251269985e-05f, +3.419596569e-04f, +7.750855424e-04f, +1.327392224e-03f, +1.855614968e-03f, +2.131079521e-03f, +1.873764383e-03f, +8.180022455e-04f, -1.198511013e-03f, -4.139948580e-03f, -7.695839322e-03f, -1.124811758e-02f, -1.390179589e-02f, -1.458774364e-02f, -1.223013303e-02f, -5.954286298e-03f, +4.702924628e-03f, +1.962448566e-02f, +3.802778634e-02f, +5.849074345e-02f, +7.909727764e-02f, +9.768564744e-02f, +1.121606116e-01f, +1.208148548e-01f, +1.226004532e-01f, +1.172988657e-01f, +1.055566702e-01f, +8.878011194e-02f, +6.890888278e-02f, +4.811246649e-02f, +2.846594706e-02f, +1.166369176e-02f, -1.181130567e-03f, -9.622869830e-03f, -1.385132418e-02f, -1.456013766e-02f, -1.275170939e-02f, -9.522728440e-03f, -5.872519870e-03f, -2.565924654e-03f, -6.670646231e-05f, +1.459392199e-03f, +2.086923125e-03f, +2.041865198e-03f, +1.607042240e-03f, +1.043117941e-03f, +5.382807835e-04f, +1.901644577e-04f,
    -5.335147914e-06f, -1.080807602e-05f, -1.583926880e-05f, -1.787734921e-05f, -1.405485785e-05f, -2.047289331e-06f, +1.890894410e-05f, +4.710308517e-05f, +7.784355196e-05f, +1.036189232e-04f, +1.150607986e-04f, +1.026534512e-04f, +5.892474902e-05f, -1.932381540e-05f, -1.292799344e-04f, -2.613747898e-04f, -3.998637126e-04f, -5.248002005e-04f, -6.151548427e-04f, -6.525417699e-04f, -6.248264024e-04f, -5.288533349e-04f, -3.716709945e-04f, -1.699173576e-04f, +5.259226943e-05f, +2.686534011e-04f, +4.521174649e-04f, +5.821317669e-04f, +6.463570208e-04f, +6.425670845e-04f, +5.783822332e-04f, +4.692775907e-04f, +3.353528265e-04f, +1.975721113e-04f, +7.424042003e-05f, -2.162955402e-05f, -8.364970531e-05f, -1.119888913e-04f, -1.121078964e-04f, -9.272398405e-05f, -6.353586705e-05f, -3.321263254e-05f, -8.013786642e-06f, +8.791967543e-06f, +1.674858004e-05f, +1.747838576e-05f, +1.368270014e-05f, +8.170451874e-06f,
    +2.137490244e-04f, -2.074618336e-05f, -7.547651732e-04f, -2.036565407e-03f, -3.584637213e-03f, -4.720884986e-03f, -4.496573452e-03f, -2.036715762e-03f, +2.980412374e-03f, +9.896191711e-03f, +1.692716106e-02f, +2.147375714e-02f, +2.089261998e-02f, +1.353359224e-02f, -3.278225666e-04f, -1.807559493e-02f, -3.514062312e-02f, -4.620002611e-02f, -4.687126276e-02f, -3.533850934e-02f, -1.329849725e-02f, +1.419819851e-02f, +4.005979289e-02f, +5.724424426e-02f, +6.094368351e-02f, +5.011230410e-02f, +2.780173499e-02f, +1.853139707e-04f, -2.538462165e-02f, -4.261078550e-02f, -4.802357938e-02f, -4.173793651e-02f, -2.702709627e-02f, -8.966233429e-03f, +7.306789218e-03f, +1.809657130e-02f, +2.196305613e-02f, +1.968681800e-02f, +1.354766925e-02f, +6.287237588e-03f, +1.667627067e-04f, -3.584988717e-03f, -4.840539951e-03f, -4.260236948e-03f, -2.810772754e-03f, -1.335520770e-03f, -3.163032626e-04f, +1.473913882e-04f,
    +1.447406595e-06f, +1.401413201e-05f, +3.167668481e-05f, +4.658066683e-05f, +4.661362310e-05f, +2.012058813e-05f, -3.718987259e-05f, -1.160666647e-04f, -1.918906538e-04f, -2.298116804e-04f, -1.967581254e-04f, -7.679487601e-05f, +1.163105947e-04f, +3.357647084e-04f, +5.114651158e-04f, +5.715956042e-04f, +4.695351836e-04f, +2.060628682e-04f, -1.628244780e-04f, -5.376583343e-04f, -8.047474842e-04f, -8.736922246e-04f, -7.098425667e-04f, -3.493331199e-04f, +1.097463270e-04f, +5.377476602e-04f, +8.150039925e-04f, +8.698353975e-04f, +6.996959320e-04f, +3.685418302e-04f, -1.763333493e-05f, -3.473526926e-04f, -5.388090779e-04f, -5.616617465e-04f, -4.393922133e-04f, -2.337343623e-04f, -1.893670441e-05f, +1.437649828e-04f, +2.226808477e-04f, +2.190772355e-04f, +1.588178385e-04f, +7.763737051e-05f, +6.709141053e-06f, -3.637205811e-05f, -4.927774042e-05f, -4.064842614e-05f, -2.313061035e-05f, -7.227298826e-06f,
    /*  2,25 (48) */
    +7.717755194e-05f, +3.311515809e-04f, +7.592462736e-04f, +1.309514875e-03f, +1.841560110e-03f, +2.129032232e-03f, +1.892673327e-03f, +8.651053307e-04f, -1.120667461e-03f, -4.036329657e-03f, -7.580778523e-03f, -1.114546413e-02f, -1.384287114e-02f, -1.460706746e-02f, -1.235941296e-02f, -6.215661087e-03f, +4.303060915e-03f, +1.909968546e-02f, +3.741263150e-02f, +5.783820168e-02f, +7.847245124e-02f, +9.715679411e-02f, +1.117889406e-01f, +1.206449374e-01f, +1.226530455e-01f, +1.175675191e-01f, +1.060087877e-01f, +8.936224371e-02f, +6.955523980e-02f, +4.875503357e-02f, +2.904432929e-02f, +1.213296935e-02f, -8.457777408e-04f, -9.425297718e-03f, -1.377708376e-02f, -1.458176721e-02f, -1.283535910e-02f, -9.634717331e-03f, -5.984627766e-03f, -2.658648638e-03f, -1.302423294e-04f, +1.426179567e-03f, +2.078909338e-03f, +2.050657166e-03f, +1.623790820e-03f, +1.060596327e-03f, +5.519634837e-04f, +1.983349096e-04f,
    -5.178260298e-06f, -1.063234626e-05f, -1.571251857e-05f, -1.788781391e-05f, -1.428903649e-05f, -2.559534897e-06f, +1.812819973e-05f, +4.615127328e-05f, +7.691280619e-05f, +1.029791733e-04f, +1.150175463e-04f, +1.034851606e-04f, +6.081114311e-05f, -1.636680517e-05f, -1.254417521e-04f, -2.570546224e-04f, -3.956308083e-04f, -5.213127495e-04f, -6.130498973e-04f, -6.523165421e-04f, -6.267350554e-04f, -5.328418520e-04f, -3.773659094e-04f, -1.766733973e-04f, +4.559288931e-05f, +2.622683581e-04f, +4.471039543e-04f, +5.790256297e-04f, +6.453943812e-04f, +6.436623173e-04f, +5.811641189e-04f, +4.731735600e-04f, +3.397019451e-04f, +2.017428681e-04f, +7.773024984e-05f, -1.913030786e-05f, -8.223765199e-05f, -1.115695688e-04f, -1.124495919e-04f, -9.352779174e-05f, -6.450515218e-05f, -3.410776128e-05f, -8.683480529e-06f, +8.404654100e-06f, +1.662161663e-05f, +1.753933143e-05f, +1.384091928e-05f, +8.344564540e-06f,
    +2.151964310e-04f, -6.732051356e-06f, -7.230884884e-04f, -1.989984741e-03f, -3.538023590e-03f, -4.700764398e-03f, -4.533763325e-03f, -2.152782426e-03f, +2.788521720e-03f, +9.666380030e-03f, +1.673040293e-02f, +2.139696226e-02f, +2.100893057e-02f, +1.386935695e-02f, +1.836425491e-04f, -1.750399933e-02f, -3.467108794e-02f, -4.599396324e-02f, -4.703408724e-02f, -3.587616768e-02f, -1.410324473e-02f, +1.332450628e-02f, +3.934995032e-02f, +5.689491114e-02f, +6.105342983e-02f, +5.065005176e-02f, +2.861673899e-02f, +1.055149368e-03f, -2.468492572e-02f, -4.224224367e-02f, -4.804121272e-02f, -4.208528920e-02f, -2.756590535e-02f, -9.527895176e-03f, +6.867397005e-03f, +1.786283694e-02f, +2.194411942e-02f, +1.983058298e-02f, +1.377035010e-02f, +6.506314824e-03f, +3.255805452e-04f, -3.507351347e-03f, -4.833830810e-03f, -4.296609006e-03f, -2.860050494e-03f, -1.376169196e-03f, -3.394338729e-04f, +1.401640894e-04f,
    +1.174919173e-06f, +1.351858005e-05f, +3.111153756e-05f, +4.627164787e-05f, +4.696471002e-05f, +2.142234465e-05f, -3.498365227e-05f, -1.134843933e-04f, -1.899027257e-04f, -2.295566890e-04f, -1.990901227e-04f, -8.180995317e-05f, +1.095569277e-04f, +3.291727038e-04f, +5.073866860e-04f, +5.720328272e-04f, +4.753147901e-04f, +2.163172775e-04f, -1.506153382e-04f, -5.270041986e-04f, -7.990454901e-04f, -8.750585407e-04f, -7.183081557e-04f, -3.627226851e-04f, +9.517667379e-05f, +5.261213105e-04f, +8.095002376e-04f, +8.716997142e-04f, +7.079249784e-04f, +3.803291967e-04f, -5.883981206e-06f, -3.388347590e-04f, -5.353660836e-04f, -5.633880856e-04f, -4.448576322e-04f, -2.406760000e-04f, -2.511426691e-05f, +1.398716859e-04f, +2.215468551e-04f, +2.202238910e-04f, +1.612049344e-04f, +8.015214039e-05f, +8.554658539e-06f, -3.550519564e-05f, -4.926313550e-05f, -4.111808869e-05f, -2.369612532e-05f, -7.633361304e-06f,
    /*  2,26 (48) */
    +7.199929164e-05f, +3.205192346e-04f, +7.435337550e-04f, +1.291627061e-03f, +1.827271074e-03f, +2.126472697e-03f, +1.910801527e-03f, +9.112566040e-04f, -1.043754655e-03f, -3.933350484e-03f, -7.465760977e-03f, -1.104197897e-02f, -1.378205999e-02f, -1.462343426e-02f, -1.248485472e-02f, -6.472715710e-03f, +3.907430107e-03f, +1.857837271e-02f, +3.679958160e-02f, +5.718588514e-02f, +7.784571619e-02f, +9.662395226e-02f, +1.114115747e-01f, +1.204682640e-01f, +1.226986384e-01f, +1.178297874e-01f, +1.064558916e-01f, +8.994126933e-02f, +7.020063419e-02f, +4.939869589e-02f, +2.962549341e-02f, +1.260614291e-02f, -5.060757957e-04f, -9.223554850e-03f, -1.369935351e-02f, -1.460089752e-02f, -1.291759675e-02f, -9.746286900e-03f, -6.097077358e-03f, -2.752176430e-03f, -1.947474815e-04f, +1.392071805e-03f, +2.070225857e-03f, +2.059061820e-03f, +1.640412437e-03f, +1.078135658e-03f, +5.658044030e-04f, +2.066794741e-04f,
    -5.022725094e-06f, -1.045632548e-05f, -1.558296283e-05f, -1.789260018e-05f, -1.451514970e-05f, -3.062828592e-06f, +1.735486795e-05f, +4.520237532e-05f, +7.597763824e-05f, +1.023257469e-04f, +1.149511162e-04f, +1.042861110e-04f, +6.266334577e-05f, -1.344150808e-05f, -1.216261004e-04f, -2.527416165e-04f, -3.913854162e-04f, -5.177919432e-04f, -6.108932017e-04f, -6.520272446e-04f, -6.285761486e-04f, -5.367694260e-04f, -3.830160601e-04f, -1.834080748e-04f, +3.858797298e-05f, +2.558517894e-04f, +4.420380662e-04f, +5.758546346e-04f, +6.443644139e-04f, +6.446975487e-04f, +5.839011872e-04f, +4.770445681e-04f, +3.440468994e-04f, +2.059276841e-04f, +8.124714801e-05f, -1.659755120e-05f, -8.079217154e-05f, -1.111221882e-04f, -1.127718672e-04f, -9.432182171e-05f, -6.547329714e-05f, -3.500799781e-05f, -9.361551378e-06f, +8.008503125e-06f, +1.648743506e-05f, +1.759576105e-05f, +1.399743514e-05f, +8.519174888e-06f,
    +2.163713502e-04f, +6.786528698e-06f, -6.919769508e-04f, -1.943713093e-03f, -3.491058880e-03f, -4.679342053e-03f, -4.568746977e-03f, -2.266266820e-03f, +2.598618995e-03f, +9.436823341e-03f, +1.653131281e-02f, +2.131515231e-02f, +2.111848750e-02f, +1.419852965e-02f, +6.910292352e-04f, -1.693196650e-02f, -3.419577315e-02f, -4.577764596e-02f, -4.718470258e-02f, -3.640317188e-02f, -1.490229022e-02f, +1.244944774e-02f, +3.863164217e-02f, +5.653218845e-02f, +6.114860651e-02f, +5.117617307e-02f, +2.942623922e-02f, +1.926849082e-03f, -2.397700074e-02f, -4.186191447e-02f, -4.804709670e-02f, -4.242412396e-02f, -2.810127143e-02f, -1.009128326e-02f, +6.422539372e-03f, +1.762216094e-02f, +2.191900516e-02f, +1.997045467e-02f, +1.399189695e-02f, +6.726538715e-03f, +4.867854796e-04f, -3.427199206e-03f, -4.825276152e-03f, -4.332114202e-03f, -2.909313630e-03f, -1.417287284e-03f, -3.631299982e-04f, +1.325307281e-04f,
    +9.099460397e-07f, +1.302864034e-05f, +3.054440828e-05f, +4.594850717e-05f, +4.728959078e-05f, +2.269282404e-05f, -3.280034141e-05f, -1.109010239e-04f, -1.878788303e-04f, -2.292318388e-04f, -2.013348463e-04f, -8.674983814e-05f, +1.028329237e-04f, +3.225405397e-04f, +5.031953214e-04f, +5.723084953e-04f, +4.809312030e-04f, +2.264624880e-04f, -1.384167806e-04f, -5.162463108e-04f, -7.931473988e-04f, -8.761915298e-04f, -7.265742297e-04f, -3.760095383e-04f, +8.057995834e-05f, +5.143468419e-04f, +8.037746187e-04f, +8.733376566e-04f, +7.159904009e-04f, +3.920587902e-04f, +5.919874154e-06f, -3.301792273e-04f, -5.317539276e-04f, -5.649680224e-04f, -4.502383222e-04f, -2.476076295e-04f, -3.134374756e-05f, +1.358942076e-04f, +2.203297043e-04f, +2.213133645e-04f, +1.635709156e-04f, +8.267731948e-05f, +1.042838306e-05f, -3.460780348e-05f, -4.922680759e-05f, -4.157888904e-05f, -2.426343398e-05f, -8.046449887e-06f,
    /*  2,27 (48) */
    +6.697656655e-05f, +3.100629092e-04f, +7.279507922e-04f, +1.273734461e-03f, +1.812755924e-03f, +2.123409868e-03f, +1.928156395e-03f, +9.564589793e-04f, -9.677770163e-04f, -3.831024737e-03f, -7.350809861e-03f, -1.093769286e-02f, -1.371939665e-02f, -1.463687577e-02f, -1.260648082e-02f, -6.725457326e-03f, +3.516044690e-03f, +1.806058077e-02f, +3.618868840e-02f, +5.653385790e-02f, +7.721714004e-02f, +9.608718283e-02f, +1.110285586e-01f, +1.202848560e-01f, +1.227372263e-01f, +1.180856392e-01f, +1.068979297e-01f, +9.051712397e-02f, +7.084499860e-02f, +5.004339344e-02f, +3.020939460e-02f, +1.308318748e-02f, -1.620288963e-04f, -9.017627166e-03f, -1.361810636e-02f, -1.461749507e-02f, -1.299838892e-02f, -9.857409088e-03f, -6.209849225e-03f, -2.846498251e-03f, -2.602207787e-04f, +1.357063808e-03f, +2.060864306e-03f, +2.067070323e-03f, +1.656899872e-03f, +1.095731419e-03f, +5.798018381e-04f, +2.151986490e-04f,
    -4.868577177e-06f, -1.028007989e-05f, -1.545068921e-05f, -1.789179549e-05f, -1.473325471e-05f, -3.557165526e-06f, +1.658904033e-05f, +4.425657742e-05f, +7.503831325e-05f, +1.016589473e-04f, +1.148617881e-04f, +1.050564873e-04f, +6.448138195e-05f, -1.054810206e-05f, -1.178333665e-04f, -2.484363303e-04f, -3.871281868e-04f, -5.142384158e-04f, -6.086852563e-04f, -6.516741400e-04f, -6.303496402e-04f, -5.406356977e-04f, -3.886208156e-04f, -1.901205840e-04f, +3.157837062e-05f, +2.494044498e-04f, +4.369203387e-04f, +5.726190240e-04f, +6.432670421e-04f, +6.456724169e-04f, +5.865928741e-04f, +4.808899607e-04f, +3.483870618e-04f, +2.101260580e-04f, +8.479080402e-05f, -1.403138297e-05f, -7.931317237e-05f, -1.106465203e-04f, -1.130744256e-04f, -9.510577867e-05f, -6.644006295e-05f, -3.591319099e-05f, -1.004794213e-05f, +7.603492727e-06f, +1.634596290e-05f, +1.764758391e-05f, +1.415216617e-05f, +8.694227944e-06f,
    +2.172812962e-04f, +1.981516904e-05f, -6.614325425e-04f, -1.897764586e-03f, -3.443769290e-03f, -4.656649229e-03f, -4.601547318e-03f, -2.377167844e-03f, +2.410740164e-03f, +9.207591503e-03f, +1.632997796e-02f, +2.122840247e-02f, +2.122132042e-02f, +1.452107019e-02f, +1.194224557e-03f, -1.635965800e-02f, -3.371484194e-02f, -4.555118347e-02f, -4.732311936e-02f, -3.691941819e-02f, -1.569543762e-02f, +1.157325621e-02f, +3.790506794e-02f, +5.615617891e-02f, +6.122918647e-02f, +5.169051991e-02f, +3.023001384e-02f, +2.800186739e-03f, -2.326101034e-02f, -4.146985568e-02f, -4.804117682e-02f, -4.275430318e-02f, -2.863302536e-02f, -1.065625128e-02f, +5.972301050e-03f, +1.737455331e-02f, +2.188766141e-02f, +2.010634887e-02f, +1.421222665e-02f, +6.947852079e-03f, +6.503563952e-04f, -3.344521887e-03f, -4.814847769e-03f, -4.366722005e-03f, -2.958540437e-03f, -1.458866173e-03f, -3.873934322e-04f, +1.244842782e-04f,
    +6.524678118e-07f, +1.254445566e-05f, +2.997561797e-05f, +4.561165540e-05f, +4.758857544e-05f, +2.393200775e-05f, -3.064044285e-05f, -1.083175159e-04f, -1.858201188e-04f, -2.288380210e-04f, -2.034924447e-04f, -9.161363612e-05f, +9.614045620e-05f, +3.158705776e-04f, +4.988930718e-04f, +5.724235080e-04f, +4.863836286e-04f, +2.364960278e-04f, -1.262323105e-04f, -5.053881103e-04f, -7.870554015e-04f, -8.770913041e-04f, -7.346386734e-04f, -3.891899554e-04f, +6.596032919e-05f, +5.024274914e-04f, +7.978284485e-04f, +8.747482740e-04f, +7.238894151e-04f, +4.037270028e-04f, +1.777500250e-05f, -3.213879831e-04f, -5.279727365e-04f, -5.664001392e-04f, -4.555320128e-04f, -2.545269905e-04f, -3.762360484e-05f, +1.318330365e-04f, +2.190289187e-04f, +2.223446079e-04f, +1.659146577e-04f, +8.521210150e-05f, +1.233000201e-05f, -3.367975215e-05f, -4.916838214e-05f, -4.203043254e-05f, -2.483227790e-05f, -8.466489063e-06f,
    /*  2,28 (48) */
    +6.210798937e-05f, +2.997828293e-04f, +7.125001030e-04f, +1.255842665e-03f, +1.798022669e-03f, +2.119852703e-03f, +1.944745435e-03f, +1.000715557e-03f, -8.927387031e-04f, -3.729365789e-03f, -7.235948073e-03f, -1.083263637e-02f, -1.365491527e-02f, -1.464742387e-02f, -1.272431418e-02f, -6.973893657e-03f, +3.128916504e-03f, +1.754634235e-02f, +3.558000314e-02f, +5.588218376e-02f, +7.658679040e-02f, +9.554654713e-02f, +1.106399378e-01f, +1.200947354e-01f, +1.227688047e-01f, +1.183350437e-01f, +1.073348500e-01f, +9.108974299e-02f, +7.148826564e-02f, +5.068906585e-02f, +3.079598747e-02f, +1.356407744e-02f, +1.863581655e-04f, -8.807501108e-03f, -1.353331556e-02f, -1.463152645e-02f, -1.307770209e-02f, -9.968055609e-03f, -6.322923651e-03f, -2.941604030e-03f, -3.266608416e-04f, +1.321150617e-03f, +2.050816364e-03f, +2.074673816e-03f, +1.673245835e-03f, +1.113379003e-03f, +5.939540043e-04f, +2.238928769e-04f,
    -4.715850413e-06f, -1.010367479e-05f, -1.531578494e-05f, -1.788548775e-05f, -1.494341021e-05f, -4.042543184e-06f, +1.583080551e-05f, +4.331406289e-05f, +7.409509441e-05f, +1.009790774e-04f, +1.147498435e-04f, +1.057964787e-04f, +6.626528240e-05f, -7.686758355e-06f, -1.140639309e-04f, -2.441393179e-04f, -3.828597697e-04f, -5.106528043e-04f, -6.064265671e-04f, -6.512574993e-04f, -6.320554984e-04f, -5.444403173e-04f, -3.941795518e-04f, -1.968101222e-04f, +2.456493322e-05f, +2.429270989e-04f, +4.317513181e-04f, +5.693190501e-04f, +6.421021986e-04f, +6.465865679e-04f, +5.892386203e-04f, +4.847090843e-04f, +3.527218023e-04f, +2.143374835e-04f, +8.836090079e-05f, -1.143190856e-05f, -7.780056820e-05f, -1.101423396e-04f, -1.133569712e-04f, -9.587936640e-05f, -6.740520824e-05f, -3.682318671e-05f, -1.074259293e-05f, +7.189603096e-06f, +1.619712886e-05f, +1.769470941e-05f, +1.430503026e-05f, +8.869667763e-06f,
    +2.179337640e-04f, +3.235962470e-05f, -6.314569246e-04f, -1.852152930e-03f, -3.396180714e-03f, -4.632717222e-03f, -4.632187761e-03f, -2.485485359e-03f, +2.224920046e-03f, +8.978753482e-03f, +1.612648552e-02f, +2.113678884e-02f, +2.131746088e-02f, +1.483694077e-02f, +1.693117628e-03f, -1.578723449e-02f, -3.322845831e-02f, -4.531468744e-02f, -4.744935167e-02f, -3.742480630e-02f, -1.648249302e-02f, +1.069616491e-02f, +3.717042926e-02f, +5.576698896e-02f, +6.129514680e-02f, +5.219294740e-02f, +3.102784229e-02f, +3.674935013e-03f, -2.253712093e-02f, -4.106612868e-02f, -4.802340182e-02f, -4.307569117e-02f, -2.916099810e-02f, -1.122265142e-02f, +5.516769037e-03f, +1.712002632e-02f, +2.185003780e-02f, +2.023818191e-02f, +1.443125557e-02f, +7.170196687e-03f, +8.162710528e-04f, -3.259309785e-03f, -4.802517767e-03f, -4.400401757e-03f, -3.007708819e-03f, -1.500896606e-03f, -4.122257101e-04f, +1.160177891e-04f,
    +4.024611317e-07f, +1.206616299e-05f, +2.940548286e-05f, +4.526150288e-05f, +4.786198073e-05f, +2.513989055e-05f, -2.850444351e-05f, -1.057348169e-04f, -1.837277423e-04f, -2.283761428e-04f, -2.055630957e-04f, -9.640048616e-05f, +8.948137306e-05f, +3.091651753e-04f, +4.944820104e-04f, +5.723788116e-04f, +4.916713289e-04f, +2.464154710e-04f, -1.140654159e-04f, -4.944330571e-04f, -7.807717433e-04f, -8.777580473e-04f, -7.424994357e-04f, -4.022602460e-04f, +5.132194230e-05f, +4.903665421e-04f, +7.916631086e-04f, +8.759306836e-04f, +7.316192808e-04f, +4.153302342e-04f, +2.967814651e-05f, -3.124629637e-04f, -5.240226921e-04f, -5.676830579e-04f, -4.607364475e-04f, -2.614318102e-04f, -4.395226739e-05f, +1.276886948e-04f, +2.176440466e-04f, +2.233165834e-04f, +1.682350316e-04f, +8.775566630e-05f, +1.425918711e-05f, -3.272092345e-05f, -4.908748870e-05f, -4.247232228e-05f, -2.540239313e-05f, -8.893397928e-06f,
    /*  2,29 (48) */
    +5.739213896e-05f, +2.896791545e-04f, +6.971843180e-04f, +1.237957178e-03f, +1.783079259e-03f, +2.115810160e-03f, +1.960576241e-03f, +1.044029620e-03f, -8.186436087e-04f, -3.628386712e-03f, -7.121198229e-03f, -1.072683989e-02f, -1.358864998e-02f, -1.465511063e-02f, -1.283837811e-02f, -7.218032974e-03f, +2.746056734e-03f, +1.703568955e-02f, +3.497357657e-02f, +5.523092626e-02f, +7.595473490e-02f, +9.500210682e-02f, +1.102457583e-01f, +1.198979252e-01f, +1.227933696e-01f, +1.185779707e-01f, +1.077666013e-01f, +9.165906204e-02f, +7.213036784e-02f, +5.133565242e-02f, +3.138522609e-02f, +1.404878652e-02f, +5.390799677e-04f, -8.593163625e-03f, -1.344495466e-02f, -1.464295836e-02f, -1.315550266e-02f, -1.007819795e-02f, -6.436280622e-03f, -3.037483396e-03f, -3.940660499e-04f, +1.284327430e-03f, +2.040073771e-03f, +2.081863419e-03f, +1.689442964e-03f, +1.131073713e-03f, +6.082590345e-04f, +2.327625447e-04f,
    -4.564577659e-06f, -9.927174596e-06f, -1.517833682e-05f, -1.787376529e-05f, -1.514567628e-05f, -4.518961403e-06f, +1.508024918e-05f, +4.237501215e-05f, +7.314824287e-05f, +1.002864397e-04f, +1.146155658e-04f, +1.065062782e-04f, +6.801508365e-05f, -4.857641601e-06f, -1.103181681e-04f, -2.398511288e-04f, -3.785808125e-04f, -5.070357475e-04f, -6.041176459e-04f, -6.507776023e-04f, -6.336937015e-04f, -5.481829449e-04f, -3.996916520e-04f, -2.034758906e-04f, +1.754851234e-05f, +2.364205011e-04f, +4.265315589e-04f, +5.659549751e-04f, +6.408698258e-04f, +6.474396557e-04f, +5.918378714e-04f, +4.885012868e-04f, +3.570504884e-04f, +2.185614491e-04f, +9.195711480e-05f, -8.799239900e-06f, -7.625427805e-05f, -1.096094236e-04f, -1.136192096e-04f, -9.664228773e-05f, -6.836848933e-05f, -3.773782790e-05f, -1.144544108e-05f, +6.766816532e-06f, +1.604086273e-05f, +1.773704708e-05f, +1.445594466e-05f, +9.045437432e-06f,
    +2.183362251e-04f, +4.442578769e-05f, -6.020514417e-04f, -1.806891427e-03f, -3.348318733e-03f, -4.607577331e-03f, -4.660692205e-03f, -2.591220176e-03f, +2.041192303e-03f, +8.750377339e-03f, +1.592092242e-02f, +2.104038835e-02f, +2.140694225e-02f, +1.514610595e-02f, +2.187599639e-03f, -1.521485568e-02f, -3.273678699e-02f, -4.506827197e-02f, -4.756341708e-02f, -3.791923935e-02f, -1.726326477e-02f, +9.818406863e-03f, +3.642792983e-02f, +5.536472871e-02f, +6.134646874e-02f, +5.268331394e-02f, +3.181950540e-02f, +4.550865697e-03f, -2.180550164e-02f, -4.065079844e-02f, -4.799372367e-02f, -4.338815413e-02f, -2.968502079e-02f, -1.179033448e-02f, +5.056032590e-03f, +1.685859451e-02f, +2.180608554e-02f, +2.036587060e-02f, +1.464889962e-02f, +7.393513271e-03f, +9.845060845e-04f, -3.171554119e-03f, -4.788258580e-03f, -4.433122681e-03f, -3.056796308e-03f, -1.543368928e-03f, -4.376281033e-04f, +1.071243912e-04f,
    +1.598987474e-07f, +1.159389361e-05f, +2.883431423e-05f, +4.489845939e-05f, +4.811012979e-05f, +2.631648037e-05f, -2.639281442e-05f, -1.031538630e-04f, -1.816028521e-04f, -2.278471264e-04f, -2.075470058e-04f, -1.011095612e-04f, +8.285749660e-05f, +3.024266850e-04f, +4.899642325e-04f, +5.721753980e-04f, +4.967936220e-04f, +2.562184377e-04f, -1.019195666e-04f, -4.833846306e-04f, -7.742987235e-04f, -8.781920142e-04f, -7.501545301e-04f, -4.152167559e-04f, +3.666895974e-05f, +4.781673233e-04f, +7.852800500e-04f, +8.768840711e-04f, +7.391773030e-04f, +4.268648926e-04f, +4.162602116e-05f, -3.034061574e-04f, -5.199040306e-04f, -5.688154408e-04f, -4.658493838e-04f, -2.683198039e-04f, -5.032813447e-05f, +1.234617384e-04f, +2.161746624e-04f, +2.242282643e-04f, +1.705309043e-04f, +9.030718001e-05f, +1.621559433e-05f, -3.173121068e-05f, -4.898376114e-05f, -4.290415923e-05f, -2.597351020e-05f, -9.327090145e-06f,
    /*  2,30 (48) */
    +5.282756130e-05f, +2.797519799e-04f, +6.820059812e-04f, +1.220083412e-03f, +1.767933583e-03f, +2.111291198e-03f, +1.975656490e-03f, +1.086404632e-03f, -7.454953658e-04f, -3.528100272e-03f, -7.006582663e-03f, -1.062033362e-02f, -1.352063490e-02f, -1.465996827e-02f, -1.294869628e-02f, -7.457884103e-03f, +2.367475921e-03f, +1.652865380e-02f, +3.436945893e-02f, +5.458014866e-02f, +7.532104120e-02f, +9.445392387e-02f, +1.098460666e-01f, +1.196944494e-01f, +1.228109182e-01f, +1.188143913e-01f, +1.081931329e-01f, +9.222501702e-02f, +7.277123767e-02f, +5.198309208e-02f, +3.197706396e-02f, +1.453728781e-02f, +8.961304561e-04f, -8.374602175e-03f, -1.335299754e-02f, -1.465175760e-02f, -1.323175694e-02f, -1.018780737e-02f, -6.549899832e-03f, -3.134125684e-03f, -4.624345392e-04f, +1.246589602e-03f, +2.028628330e-03f, +2.088630235e-03f, +1.705483827e-03f, +1.148810760e-03f, +6.227149792e-04f, +2.418079821e-04f,
    -4.414790764e-06f, -9.750642811e-06f, -1.503843121e-05f, -1.785671677e-05f, -1.534011438e-05f, -4.986422344e-06f, +1.433745413e-05f, +4.143960274e-05f, +7.219801774e-05f, +9.958133640e-05f, +1.144592400e-04f, +1.071860828e-04f, +6.973082794e-05f, -2.060909781e-06f, -1.065964465e-04f, -2.355723082e-04f, -3.742919618e-04f, -5.033878865e-04f, -6.017590106e-04f, -6.502347371e-04f, -6.352642376e-04f, -5.518632500e-04f, -4.051565071e-04f, -2.101170941e-04f, +1.052996006e-05f, +2.298854257e-04f, +4.212616238e-04f, +5.625270708e-04f, +6.395698761e-04f, +6.482313423e-04f, +5.943900778e-04f, +4.922659171e-04f, +3.613724853e-04f, +2.227974382e-04f, +9.557911602e-05f, -6.133495444e-06f, -7.467422635e-05f, -1.090475536e-04f, -1.138608472e-04f, -9.739424462e-05f, -6.932966021e-05f, -3.865695453e-05f, -1.215642107e-05f, +6.335117472e-06f, +1.587709547e-05f, +1.777450663e-05f, +1.460482609e-05f, +9.221479075e-06f,
    +2.184961239e-04f, +5.601968130e-05f, -5.732171275e-04f, -1.761992968e-03f, -3.300208604e-03f, -4.581260851e-03f, -4.687085019e-03f, -2.694374039e-03f, +1.859589451e-03f, +8.522530212e-03f, +1.571337542e-02f, +2.093927879e-02f, +2.148979975e-02f, +1.544853263e-02f, +2.677563871e-03f, -1.464268029e-02f, -3.223999336e-02f, -4.481205354e-02f, -4.766533665e-02f, -3.840262399e-02f, -1.803756349e-02f, +8.940214849e-03f, +3.567777530e-02f, +5.494951196e-02f, +6.138313770e-02f, +5.316148127e-02f, +3.260478545e-02f, +5.427749768e-03f, -2.106632434e-02f, -4.022393355e-02f, -4.795209765e-02f, -4.369156029e-02f, -3.020492482e-02f, -1.235914992e-02f, +4.590183206e-03f, +1.659027470e-02f, +2.175575740e-02f, +2.048933234e-02f, +1.486507428e-02f, +7.617741535e-03f, +1.155036989e-03f, -3.081246939e-03f, -4.772042985e-03f, -4.464853891e-03f, -3.105780069e-03f, -1.586273087e-03f, -4.636016135e-04f, +9.779730107e-05f,
    -7.525040422e-08f, +1.112777301e-05f, +2.826241838e-05f, +4.452293401e-05f, +4.833335192e-05f, +2.746179810e-05f, -2.430601068e-05f, -1.005755783e-04f, -1.794465983e-04f, -2.272519091e-04f, -2.094444104e-04f, -1.057400680e-04f, +7.627062286e-05f, +2.956574536e-04f, +4.853418550e-04f, +5.718143049e-04f, +5.017498821e-04f, +2.659025952e-04f, -8.979821280e-05f, -4.722463287e-04f, -7.676386936e-04f, -8.783935306e-04f, -7.576020354e-04f, -4.280558673e-04f, +2.200554834e-05f, +4.658332083e-04f, +7.786807920e-04f, +8.776076910e-04f, +7.465608329e-04f, +4.383273960e-04f, +5.361531476e-05f, -2.942196033e-04f, -5.156170440e-04f, -5.697959909e-04f, -4.708685948e-04f, -2.751886761e-04f, -5.674957623e-05f, +1.191527570e-04f, +2.146203664e-04f, +2.250786348e-04f, +1.728011389e-04f, +9.286579528e-05f, +1.819886387e-05f, -3.071051883e-05f, -4.885683791e-05f, -4.332554241e-05f, -2.654535421e-05f, -9.767473893e-06f,
    /*  2,31 (48) */
    +4.841277053e-05f, +2.700013371e-04f, +6.669675500e-04f, +1.202226696e-03f, +1.752593469e-03f, +2.106304776e-03f, +1.989993944e-03f, +1.127844235e-03f, -6.732973481e-04f, -3.428518936e-03f, -6.892123423e-03f, -1.051314753e-02f, -1.345090407e-02f, -1.466202918e-02f, -1.305529273e-02f, -7.693456411e-03f, +1.993183960e-03f, +1.602526591e-02f, +3.376769992e-02f, +5.392991392e-02f, +7.468577696e-02f, +9.390206062e-02f, +1.094409101e-01f, +1.194843323e-01f, +1.228214481e-01f, +1.190442767e-01f, +1.086143945e-01f, +9.278754409e-02f, +7.341080754e-02f, +5.263132342e-02f, +3.257145404e-02f, +1.502955372e-02f, +1.257502941e-03f, -8.151804737e-03f, -1.325741842e-02f, -1.465789110e-02f, -1.330643117e-02f, -1.029685493e-02f, -6.663760679e-03f, -3.231519929e-03f, -5.317641994e-04f, +1.207932647e-03f, +2.016471909e-03f, +2.094965353e-03f, +1.721360922e-03f, +1.166585266e-03f, +6.373198053e-04f, +2.510294612e-04f,
    -4.266520574e-06f, -9.574142015e-06f, -1.489615403e-05f, -1.783443122e-05f, -1.552678732e-05f, -5.444930471e-06f, +1.360250026e-05f, +4.050800932e-05f, +7.124467603e-05f, +9.886406891e-05f, +1.142811527e-04f, +1.078360932e-04f, +7.141256319e-05f, +7.032857366e-07f, -1.028991279e-04f, -2.313033964e-04f, -3.699938620e-04f, -4.997098643e-04f, -5.993511841e-04f, -6.496292006e-04f, -6.367671050e-04f, -5.554809118e-04f, -4.105735155e-04f, -2.167329417e-04f, +3.510128802e-06f, +2.233226464e-04f, +4.159420831e-04f, +5.590356192e-04f, +6.382023119e-04f, +6.489612978e-04f, +5.968946951e-04f, +4.960023257e-04f, +3.656871562e-04f, +2.270449294e-04f, +9.922656802e-05f, -3.434800198e-06f, -7.306034295e-05f, -1.084565141e-04f, -1.140815919e-04f, -9.813493822e-05f, -7.028847262e-05f, -3.958040364e-05f, -1.287546454e-05f, +5.894492519e-06f, +1.570575921e-05f, +1.780699796e-05f, +1.475159068e-05f, +9.397733863e-06f,
    +2.184208735e-04f, +6.714745431e-05f, -5.449547091e-04f, -1.717470034e-03f, -3.251875252e-03f, -4.553799053e-03f, -4.711391030e-03f, -2.794949618e-03f, +1.680142853e-03f, +8.295278303e-03f, +1.550393101e-02f, +2.083353872e-02f, +2.156607037e-02f, +1.574419009e-02f, +3.162905726e-03f, -1.407086598e-02f, -3.173824348e-02f, -4.454615094e-02f, -4.775513486e-02f, -3.887487031e-02f, -1.880520218e-02f, +8.061821318e-03f, +3.492017326e-02f, +5.452145609e-02f, +6.140514325e-02f, +5.362731448e-02f, +3.338346624e-02f, +6.305357459e-03f, -2.031976351e-02f, -3.978560615e-02f, -4.789848234e-02f, -4.398577989e-02f, -3.072054186e-02f, -1.292894591e-02f, +4.119314611e-03f, +1.631508603e-02f, +2.169900783e-02f, +2.060848510e-02f, +1.507969465e-02f, +7.842820170e-03f, +1.327838128e-03f, -2.988381144e-03f, -4.753844121e-03f, -4.495564410e-03f, -3.154636907e-03f, -1.629598630e-03f, -4.901469677e-04f, +8.802982718e-05f,
    -3.030211128e-07f, +1.066792104e-05f, +2.769009656e-05f, +4.413533489e-05f, +4.853198241e-05f, +2.857587745e-05f, -2.224447147e-05f, -9.800087468e-05f, -1.772601301e-04f, -2.265914423e-04f, -2.112555732e-04f, -1.102912474e-04f, +6.972252126e-05f, +2.888598211e-04f, +4.806170152e-04f, +5.712966145e-04f, +5.065395392e-04f, +2.754656586e-04f, -7.770478446e-05f, -4.610216661e-04f, -7.607940572e-04f, -8.783629926e-04f, -7.648400958e-04f, -4.407740003e-04f, +7.335878262e-06f, +4.533676142e-04f, +7.718669222e-04f, +8.781008671e-04f, +7.537672688e-04f, +4.497141734e-04f, +6.564268988e-05f, -2.849053907e-04f, -5.111620793e-04f, -5.706234531e-04f, -4.757918698e-04f, -2.820361204e-04f, -6.321493412e-05f, +1.147623742e-04f, +2.129807855e-04f, +2.258666913e-04f, +1.750445952e-04f, +9.543065144e-05f, +2.020862008e-05f, -2.965876477e-05f, -4.870636224e-05f, -4.373606909e-05f, -2.711764488e-05f, -1.021445183e-05f,
    /*  3, 0 (48) */
    +3.382425704e-04f, +1.348067834e-04f, -4.889424346e-04f, -1.466276588e-03f, -2.424363330e-03f, -2.730039057e-03f, -1.724598248e-03f, +9.008300509e-04f, +4.739031994e-03f, +8.514833164e-03f, +1.031793603e-02f, +8.256301383e-03f, +1.371724009e-03f, -9.514669115e-03f, -2.142432917e-02f, -2.960851385e-02f, -2.874512923e-02f, -1.466449091e-02f, +1.394439274e-02f, +5.448301361e-02f, +1.005300380e-01f, +1.431856698e-01f, +1.733482814e-01f, +1.842374374e-01f, +1.733482814e-01f, +1.431856698e-01f, +1.005300380e-01f, +5.448301361e-02f, +1.394439274e-02f, -1.466449091e-02f, -2.874512923e-02f, -2.960851385e-02f, -2.142432917e-02f, -9.514669115e-03f, +1.371724009e-03f, +8.256301383e-03f, +1.031793603e-02f, +8.514833164e-03f, +4.739031994e-03f, +9.008300509e-04f, -1.724598248e-03f, -2.730039057e-03f, -2.424363330e-03f, -1.466276588e-03f, -4.889424346e-04f, +1.348067834e-04f, +3.382425704e-04f, +2.622641023e-04f,
    +8.167179641e-07f, +1.236605420e-05f, +2.592907112e-05f, +3.300060303e-05f, +2.376427225e-05f, -7.333155539e-06f, -5.585024780e-05f, -1.047561226e-04f, -1.277317531e-04f, -9.889919355e-05f, -6.305860108e-06f, +1.362752771e-04f, +2.854709206e-04f, +3.765653018e-04f, +3.435785237e-04f, +1.454749231e-04f, -2.110969350e-04f, -6.625373850e-04f, -1.098675471e-03f, -1.391969581e-03f, -1.437136486e-03f, -1.187809005e-03f, -6.766902606e-04f, -1.084600706e-05f, +6.575069420e-04f, +1.175413611e-03f, +1.433843904e-03f, +1.397561162e-03f, +1.110650867e-03f, +6.770559685e-04f, +2.242442057e-04f, -1.365456772e-04f, -3.399932180e-04f, -3.777178872e-04f, -2.895631068e-04f, -1.411350845e-04f, +2.455154195e-06f, +9.697442048e-05f, +1.277273734e-04f, +1.060154541e-04f, +5.749286536e-05f, +8.641971212e-06f, -2.313094698e-05f, -3.300519509e-05f, -2.630090367e-05f, -1.279394254e-05f, -1.093779023e-06f, +4.569541687e-06f,
    -7.823217465e-04f, -9.084685290e-04f, -9.527730581e-05f, +1.939581772e-03f, +4.521325238e-03f, +5.889778654e-03f, +3.972523948e-03f, -2.097746258e-03f, -1.059839761e-02f, -1.714075782e-02f, -1.654476645e-02f, -6.064599171e-03f, +1.185220802e-02f, +2.935028356e-02f, +3.641246564e-02f, +2.636698292e-02f, +6.586074871e-04f, -3.028063400e-02f, -5.133665227e-02f, -5.043564613e-02f, -2.556515975e-02f, +1.309926646e-02f, +4.764810534e-02f, +6.141247912e-02f, +4.764810534e-02f, +1.309926646e-02f, -2.556515975e-02f, -5.043564613e-02f, -5.133665227e-02f, -3.028063400e-02f, +6.586074871e-04f, +2.636698292e-02f, +3.641246564e-02f, +2.935028356e-02f, +1.185220802e-02f, -6.064599171e-03f, -1.654476645e-02f, -1.714075782e-02f, -1.059839761e-02f, -2.097746258e-03f, +3.972523948e-03f, +5.889778654e-03f, +4.521325238e-03f, +1.939581772e-03f, -9.527730581e-05f, -9.084685290e-04f, -7.823217465e-04f, -3.493719860e-04f,
    +1.207582970e-05f, -7.181807980e-06f, -4.436800841e-05f, -7.843946816e-05f, -7.358044464e-05f, -2.500652728e-06f, +1.238811450e-04f, +2.431713521e-04f, +2.638049775e-04f, +1.207343630e-04f, -1.652856064e-04f, -4.682220434e-04f, -6.050322369e-04f, -4.385471672e-04f, +2.078504744e-05f, +5.833325336e-04f, +9.558098825e-04f, +8.968475170e-04f, +3.682537994e-04f, -4.129216663e-04f, -1.066580545e-03f, -1.246399629e-03f, -8.336386060e-04f, -1.403262768e-05f, +8.124734222e-04f, +1.242276557e-03f, +1.080734367e-03f, +4.373988820e-04f, -3.459355243e-04f, -8.869413989e-04f, -9.613405219e-04f, -5.994210138e-04f, -3.819750226e-05f, +4.280763606e-04f, +6.048271801e-04f, +4.759656788e-04f, +1.753901006e-04f, -1.135609871e-04f, -2.619740203e-04f, -2.457850786e-04f, -1.281625351e-04f, -8.067819448e-07f, +7.243049474e-05f, +7.907266217e-05f, +4.564423467e-05f, +8.126265744e-06f, -1.179589871e-05f, -1.279054036e-05f,
    /*  3, 1 (48) */
    +3.390592884e-04f, +1.471728376e-04f, -4.630133635e-04f, -1.433275985e-03f, -2.400599057e-03f, -2.737372213e-03f, -1.780448496e-03f, +7.960739283e-04f, +4.611300241e-03f, +8.415933970e-03f, +1.031163017e-02f, +8.392576660e-03f, +1.657194930e-03f, -9.138103813e-03f, -2.108075065e-02f, -2.946303892e-02f, -2.895622617e-02f, -1.532702830e-02f, +1.284571727e-02f, +5.309104403e-02f, +9.909290155e-02f, +1.419978608e-01f, +1.726715912e-01f, +1.842265914e-01f, +1.740057884e-01f, +1.443610834e-01f, +1.019638819e-01f, +5.588057478e-02f, +1.505504361e-02f, -1.398743494e-02f, -2.852088503e-02f, -2.974505952e-02f, -2.176432239e-02f, -9.892387002e-03f, +1.082160902e-03f, +8.115166299e-03f, +1.032039119e-02f, +8.611807584e-03f, +4.866759367e-03f, +1.006845505e-03f, -1.667105383e-03f, -2.721397086e-03f, -2.447494277e-03f, -1.499281783e-03f, -5.152433383e-04f, +1.220128409e-04f, +3.371487914e-04f, +2.668336440e-04f,
    +5.459948177e-07f, +1.194052812e-05f, +2.555103579e-05f, +3.297974244e-05f, +2.437540135e-05f, -6.042442799e-06f, -5.420884075e-05f, -1.034714787e-04f, -1.276843902e-04f, -1.007595192e-04f, -1.010520338e-05f, +1.314238026e-04f, +2.813221715e-04f, +3.752894788e-04f, +3.469985528e-04f, +1.542445587e-04f, -1.980463138e-04f, -6.480053926e-04f, -1.086558738e-03f, -1.386130709e-03f, -1.440134762e-03f, -1.199942416e-03f, -6.957186340e-04f, -3.253550840e-05f, +6.381729614e-04f, +1.162758543e-03f, +1.430256781e-03f, +1.402902931e-03f, +1.122481066e-03f, +6.915572233e-04f, +2.374852913e-04f, -1.274579203e-04f, -3.362419967e-04f, -3.787454085e-04f, -2.935965438e-04f, -1.460014508e-04f, -1.446014787e-06f, +9.498517043e-05f, +1.276705727e-04f, +1.072485805e-04f, +5.913597559e-05f, +9.968556543e-06f, -2.247537575e-05f, -3.299323754e-05f, -2.666621724e-05f, -1.322398717e-05f, -1.377130203e-06f, +4.490041168e-06f,
    -7.702459168e-04f, -9.156503370e-04f, -1.396453142e-04f, +1.861142303e-03f, +4.447744793e-03f, +5.887278001e-03f, +4.096405093e-03f, -1.854574906e-03f, -1.033459263e-02f, -1.702002346e-02f, -1.671005206e-02f, -6.532821215e-03f, +1.124717579e-02f, +2.891173640e-02f, +3.643325068e-02f, +2.695031545e-02f, +1.614417370e-03f, -2.938378648e-02f, -5.096839847e-02f, -5.084856780e-02f, -2.663174030e-02f, +1.185286683e-02f, +4.681446674e-02f, +6.139844650e-02f, +4.846057877e-02f, +1.434154302e-02f, -2.448442539e-02f, -4.999824725e-02f, -5.168258780e-02f, -3.116757540e-02f, -3.027330347e-04f, +2.576756190e-02f, +3.637426813e-02f, +2.977835992e-02f, +1.245703520e-02f, -5.588633492e-03f, -1.636937635e-02f, -1.725431881e-02f, -1.086037163e-02f, -2.343531337e-03f, +3.844361413e-03f, +5.888971872e-03f, +4.593755732e-03f, +2.018654434e-03f, -4.963307114e-05f, -9.003422633e-04f, -7.941176452e-04f, -3.621625263e-04f,
    +1.233653283e-05f, -6.256675746e-06f, -4.309016406e-05f, -7.776765626e-05f, -7.466243631e-05f, -5.749470101e-06f, +1.195956183e-04f, +2.404591937e-04f, +2.654686322e-04f, +1.277587669e-04f, -1.552029443e-04f, -4.603124626e-04f, -6.049282845e-04f, -4.487161370e-04f, +3.482797389e-06f, +5.670541940e-04f, +9.498402261e-04f, +9.062725306e-04f, +3.903108881e-04f, -3.883171580e-04f, -1.051944096e-03f, -1.249917253e-03f, -8.543876214e-04f, -4.209082247e-05f, +7.909024357e-04f, +1.237549266e-03f, +1.094397381e-03f, +4.617360196e-04f, -3.233665128e-04f, -8.765571829e-04f, -9.664270613e-04f, -6.153101469e-04f, -5.571174430e-05f, +4.173070169e-04f, +6.043106357e-04f, +4.835375958e-04f, +1.855110352e-04f, -1.062410242e-04f, -2.599747520e-04f, -2.482974822e-04f, -1.324370954e-04f, -4.171674522e-06f, +7.121214734e-05f, +7.966604217e-05f, +4.691785108e-05f, +9.089735452e-06f, -1.149649446e-05f, -1.295244630e-05f,
    /*  3, 2 (48) */
    +3.396052832e-04f, +1.591133657e-04f, -4.374623277e-04f, -1.400296242e-03f, -2.376223656e-03f, -2.743414655e-03f, -1.834657337e-03f, +6.926024496e-04f, +4.483615851e-03f, +8.315174451e-03f, +1.030152497e-02f, +8.524000463e-03f, +1.938517101e-03f, -8.762814334e-03f, -2.073375210e-02f, -2.930879436e-02f, -2.915427248e-02f, -1.597503369e-02f, +1.175915853e-02f, +5.170491332e-02f, +9.765276679e-02f, +1.407979183e-01f, +1.719758725e-01f, +1.841940559e-01f, +1.746439613e-01f, +1.455238419e-01f, +1.033941387e-01f, +5.728347771e-02f, +1.617752467e-02f, -1.329587772e-02f, -2.828339973e-02f, -2.987251744e-02f, -2.210056439e-02f, -1.027113241e-02f, +7.885643586e-04f, +7.969164848e-03f, +1.031894517e-02f, +8.706792755e-03f, +4.994429940e-03f, +1.114094085e-03f, -1.607969408e-03f, -2.711428529e-03f, -2.469969652e-03f, -1.532275021e-03f, -5.419095556e-04f, +1.087888537e-04f, +3.357716612e-04f, +2.713236852e-04f,
    +2.816527132e-07f, +1.151756553e-05f, +2.516711215e-05f, +3.294289841e-05f, +2.496439415e-05f, -4.770153257e-06f, -5.256935211e-05f, -1.021624150e-04f, -1.275859766e-04f, -1.025554528e-04f, -1.385231473e-05f, +1.265824125e-04f, +2.771190438e-04f, +3.738922690e-04f, +3.502539917e-04f, +1.628535423e-04f, -1.850951294e-04f, -6.334638925e-04f, -1.074304548e-03f, -1.380047129e-03f, -1.442839046e-03f, -1.211811609e-03f, -7.145878244e-04f, -5.421747208e-05f, +6.186926465e-04f, +1.149846182e-03f, +1.426374959e-03f, +1.407992425e-03f, +1.134162233e-03f, +7.060372125e-04f, +2.508173099e-04f, -1.182128095e-04f, -3.323242692e-04f, -3.796460644e-04f, -2.975690434e-04f, -1.508725802e-04f, -5.396717026e-06f, +9.293143999e-05f, +1.275606867e-04f, +1.084546092e-04f, +6.077885086e-05f, +1.131256524e-05f, -2.179751896e-05f, -3.296445351e-05f, -2.702469411e-05f, -1.365597741e-05f, -1.666719010e-06f, +4.404678912e-06f,
    -7.579093840e-04f, -9.219070127e-04f, -1.827354783e-04f, +1.783374647e-03f, +4.373082357e-03f, +5.881528531e-03f, +4.216000711e-03f, -1.614115712e-03f, -1.006912400e-02f, -1.689226469e-02f, -1.686525500e-02f, -6.993133677e-03f, +1.064224750e-02f, +2.846302026e-02f, +3.643673348e-02f, +2.751736964e-02f, +2.564257596e-03f, -2.847751395e-02f, -5.057808759e-02f, -5.123688496e-02f, -2.768368439e-02f, +1.060294958e-02f, +4.596007912e-02f, +6.135635567e-02f, +4.925148120e-02f, +1.557909228e-02f, -2.339002800e-02f, -4.953651123e-02f, -5.200595431e-02f, -3.204413258e-02f, -1.269160096e-03f, +2.515225176e-02f, +3.631855639e-02f, +3.019566694e-02f, +1.306134584e-02f, -5.105095897e-03f, -1.618386532e-02f, -1.736055983e-02f, -1.112034638e-02f, -2.591828819e-03f, +3.711924318e-03f, +5.884800197e-03f, +4.664967880e-03f, +2.098320476e-03f, -2.715220056e-06f, -8.912525278e-04f, -8.056141397e-04f, -3.751149726e-04f,
    +1.257826480e-05f, -5.351160797e-06f, -4.181167602e-05f, -7.705842929e-05f, -7.567694817e-05f, -8.938566172e-06f, +1.153086141e-04f, +2.376515187e-04f, +2.669660816e-04f, +1.346319256e-04f, -1.451474416e-04f, -4.522427527e-04f, -6.045179545e-04f, -4.585801599e-04f, -1.370094375e-05f, +5.505955327e-04f, +9.434368467e-04f, +9.152137016e-04f, +4.120965150e-04f, -3.635981751e-04f, -1.036833437e-03f, -1.252828523e-03f, -8.747103281e-04f, -7.012783938e-05f, +7.689362327e-04f, +1.232219304e-03f, +1.107561650e-03f, +4.859203331e-04f, -3.005573838e-04f, -8.656981442e-04f, -9.710646329e-04f, -6.309905005e-04f, -7.331924678e-05f, +4.062426254e-04f, +6.034802808e-04f, +4.909320686e-04f, +1.956429568e-04f, -9.877697198e-05f, -2.578062539e-04f, -2.507056983e-04f, -1.367021002e-04f, -7.592810238e-06f, +6.992500318e-05f, +8.021841976e-05f, +4.818784893e-05f, +1.007188154e-05f, -1.117738321e-05f, -1.310576536e-05f,
    /*  3, 3 (48) */
    +3.398869359e-04f, +1.706309313e-04f, -4.122952156e-04f, -1.367353344e-03f, -2.351259262e-03f, -2.748184809e-03f, -1.887226689e-03f, +5.904400346e-04f, +4.356029874e-03f, +8.212618998e-03f, +1.028767266e-02f, +8.650582875e-03f, +2.215636145e-03f, -8.388922065e-03f, -2.038349811e-02f, -2.914594082e-02f, -2.933936761e-02f, -1.660849758e-02f, +1.068485398e-02f, +5.032486620e-02f, +9.620992774e-02f, +1.395861067e-01f, +1.712612847e-01f, +1.841398384e-01f, +1.752626540e-01f, +1.466736881e-01f, +1.048205137e-01f, +5.869147013e-02f, +1.731168690e-02f, -1.258984051e-02f, -2.803258242e-02f, -2.999073025e-02f, -2.243288866e-02f, -1.065077847e-02f, +4.909953152e-04f, +7.818292268e-03f, +1.031354846e-02f, +8.799724195e-03f, +5.121990627e-03f, +1.222548695e-03f, -1.547190557e-03f, -2.700115964e-03f, -2.491767171e-03f, -1.565239474e-03f, -5.689342497e-04f, +9.513287631e-05f, +3.341049422e-04f, +2.757283641e-04f,
    +2.373016503e-08f, +1.109736287e-05f, +2.477761287e-05f, +3.289035984e-05f, +2.553132036e-05f, -3.516594185e-06f, -5.093247959e-05f, -1.008298234e-04f, -1.274372170e-04f, -1.042870754e-04f, -1.754635521e-05f, +1.217528356e-04f, +2.728637187e-04f, +3.723755467e-04f, +3.533455744e-04f, +1.713008898e-04f, -1.722461206e-04f, -6.189167668e-04f, -1.061916802e-03f, -1.373721479e-03f, -1.445249734e-03f, -1.223414427e-03f, -7.332936410e-04f, -7.588687551e-05f, +5.990703682e-04f, +1.136678987e-03f, +1.422198365e-03f, +1.412827242e-03f, +1.145690556e-03f, +7.204919830e-04f, +2.642373334e-04f, -1.088115592e-04f, -3.282394937e-04f, -3.804180795e-04f, -3.014784169e-04f, -1.557466555e-04f, -9.395992526e-06f, +9.081325215e-05f, +1.273970654e-04f, +1.096326479e-04f, +6.242075398e-05f, +1.267363801e-05f, -2.109734737e-05f, -3.291857052e-05f, -2.737601512e-05f, -1.408969792e-05f, -1.962488206e-06f, +4.313389282e-06f,
    -7.453311192e-04f, -9.272581735e-04f, -2.245471543e-04f, +1.706316218e-03f, +4.297405409e-03f, +5.872589965e-03f, +4.331309326e-03f, -1.376464193e-03f, -9.802157915e-03f, -1.675763276e-02f, -1.701040245e-02f, -7.445376430e-03f, +1.003772955e-02f, +2.800444010e-02f, +3.642303254e-02f, +2.806796518e-02f, +3.507694442e-03f, -2.756230025e-02f, -5.016599107e-02f, -5.160048313e-02f, -2.872051783e-02f, +9.350121055e-03f, +4.508536879e-02f, +6.128622784e-02f, +5.002041744e-02f, +1.681131159e-02f, -2.228246635e-02f, -4.905059090e-02f, -5.230651169e-02f, -3.290983073e-02f, -2.240224729e-03f, +2.452126126e-02f, +3.624523714e-02f, +3.060190957e-02f, +1.366482612e-02f, -4.614163828e-03f, -1.598822236e-02f, -1.745933680e-02f, -1.137815263e-02f, -2.842534517e-03f, +3.575222217e-03f, +5.877207387e-03f, +4.734892883e-03f, +2.178538896e-03f, +4.547262888e-05f, -8.811806463e-04f, -8.167915229e-04f, -3.882207380e-04f,
    +1.280129310e-05f, -4.465533215e-06f, -4.053350083e-05f, -7.631299584e-05f, -7.662449684e-05f, -1.206689233e-05f, +1.110227562e-04f, +2.347512644e-04f, +2.682985099e-04f, +1.413516791e-04f, -1.351243585e-04f, -4.440187700e-04f, -6.038040284e-04f, -4.681363162e-04f, -3.075798926e-05f, +5.339661313e-04f, +9.366052454e-04f, +9.236685619e-04f, +4.336005838e-04f, -3.387775609e-04f, -1.021257219e-03f, -1.255132848e-03f, -8.945968170e-04f, -9.812957267e-05f, +7.465856134e-04f, +1.226288538e-03f, +1.120219483e-03f, +5.099391233e-04f, -2.775189198e-04f, -8.543678256e-04f, -9.752485870e-04f, -6.464527035e-04f, -9.101137782e-05f, +3.948868638e-04f, +6.023339503e-04f, +4.981434225e-04f, +2.057803530e-04f, -9.117143940e-05f, -2.554676994e-04f, -2.530068907e-04f, -1.409547922e-04f, -1.106891903e-05f, +6.856870388e-05f, +8.072861528e-05f, +4.945320309e-05f, +1.107234635e-05f, -1.083834336e-05f, -1.325010149e-05f,
    /*  3, 4 (48) */
    +3.399106661e-04f, +1.817282941e-04f, -3.875176027e-04f, -1.334462984e-03f, -2.325727942e-03f, -2.751701403e-03f, -1.938159169e-03f, +4.896102112e-04f, +4.228592657e-03f, +8.108331923e-03f, +1.027012630e-02f, +8.772335711e-03f, +2.488499864e-03f, -8.016546519e-03f, -2.003015253e-02f, -2.897463993e-02f, -2.951161373e-02f, -1.722741435e-02f, +9.622937179e-03f, +4.895114472e-02f, +9.476467801e-02f, +1.383626923e-01f, +1.705279911e-01f, +1.840639515e-01f, +1.758617243e-01f, +1.478103671e-01f, +1.062427120e-01f, +6.010429737e-02f, +1.845737746e-02f, -1.186934853e-02f, -2.776834509e-02f, -3.009954181e-02f, -2.276112815e-02f, -1.103119655e-02f, +1.895168983e-04f, +7.662545612e-03f, +1.030415246e-02f, +8.890537447e-03f, +5.249387692e-03f, +1.332181343e-03f, -1.484769803e-03f, -2.687442326e-03f, -2.512864519e-03f, -1.598158045e-03f, -5.963102648e-04f, +8.104317839e-05f, +3.321424540e-04f, +2.800417534e-04f,
    -2.277388815e-07f, +1.068011173e-05f, +2.438284863e-05f, +3.282241924e-05f, +2.607625943e-05f, -2.282059878e-06f, -4.929891051e-05f, -9.947459474e-05f, -1.272388292e-04f, -1.059544931e-04f, -2.118651621e-05f, +1.169367772e-04f, +2.685583734e-04f, +3.707412088e-04f, +3.562740812e-04f, +1.795856748e-04f, -1.595019776e-04f, -6.043678766e-04f, -1.049399420e-03f, -1.367156457e-03f, -1.447367298e-03f, -1.234748787e-03f, -7.518319412e-04f, -9.753869981e-05f, +5.793105393e-04f, +1.123259489e-03f, +1.417727002e-03f, +1.417405042e-03f, +1.157062250e-03f, +7.349175668e-04f, +2.777423880e-04f, -9.925544176e-05f, -3.239871777e-04f, -3.810597053e-04f, -3.053224756e-04f, -1.606218381e-04f, -1.344285118e-05f, +8.863065662e-05f, +1.271790738e-04f, +1.107818055e-04f, +6.406093845e-05f, +1.405140252e-05f, -2.037484222e-05f, -3.285532073e-05f, -2.771985991e-05f, -1.452492876e-05f, -2.264375771e-06f, +4.216109366e-06f,
    -7.325298261e-04f, -9.317237067e-04f, -2.650806551e-04f, +1.630003222e-03f, +4.220780912e-03f, +5.860523072e-03f, +4.442332082e-03f, -1.141712929e-03f, -9.533859405e-03f, -1.661628108e-02f, -1.714552680e-02f, -7.889395200e-03f, +9.433925520e-03f, +2.753630378e-02f, +3.639227455e-02f, +2.860193131e-02f, +4.444299688e-03f, -2.663863169e-02f, -4.973239049e-02f, -5.193926069e-02f, -2.974177505e-02f, +8.094988206e-03f, +4.419077197e-02f, +6.118809826e-02f, +5.076700305e-02f, +1.803760013e-02f, -2.116224687e-02f, -4.854065178e-02f, -5.258403061e-02f, -3.376419855e-02f, -3.215473316e-03f, +2.387480855e-02f, +3.615422576e-02f, +3.099679643e-02f, +1.426716007e-02f, -4.116020405e-03f, -1.578244201e-02f, -1.755050824e-02f, -1.163362033e-02f, -3.095541408e-03f, +3.434267425e-03f, +5.866138468e-03f, +4.803461587e-03f, +2.259267511e-03f, +9.492583196e-05f, -8.701082999e-04f, -8.276298662e-04f, -4.014708395e-04f,
    +1.300589560e-05f, -3.600041585e-06f, -3.925657677e-05f, -7.553256929e-05f, -7.750563625e-05f, -1.513345528e-05f, +1.067406320e-04f, +2.317613882e-04f, +2.694671867e-04f, +1.479159801e-04f, -1.251388857e-04f, -4.356464065e-04f, -6.027894352e-04f, -4.773818773e-04f, -4.768027379e-05f, +5.171756103e-04f, +9.293511264e-04f, +9.316349126e-04f, +4.548131826e-04f, -3.138681769e-04f, -1.005224319e-03f, -1.256829962e-03f, -9.140374150e-04f, -1.260819359e-04f, +7.238615871e-04f, +1.219759154e-03f, +1.132363442e-03f, +5.337797449e-04f, -2.542620618e-04f, -8.425700365e-04f, -9.789744964e-04f, -6.616874512e-04f, -1.087794048e-04f, +3.832435974e-04f, +6.008696396e-04f, +5.051660376e-04f, +2.159176551e-04f, -8.342714677e-05f, -2.529583551e-04f, -2.551982542e-04f, -1.451923846e-04f, -1.459867564e-05f, +6.714293286e-05f, +8.119545879e-05f, +5.071287250e-05f, +1.209074997e-05f, -1.047916587e-05f, -1.338505782e-05f,
    /*  3, 5 (48) */
    +3.396829272e-04f, +1.924084059e-04f, -3.631347541e-04f, -1.301640565e-03f, -2.299651682e-03f, -2.753983463e-03f, -1.987458079e-03f, +3.901356165e-04f, +4.101353828e-03f, +8.002377430e-03f, +1.024893978e-02f, +8.889272488e-03f, +2.757058237e-03f, -7.645805310e-03f, -1.967387845e-02f, -2.879505426e-02f, -2.967111571e-02f, -1.783178223e-02f, +8.573537759e-03f, +4.758398826e-02f, +9.331731071e-02f, +1.371279435e-01f, +1.697761591e-01f, +1.839664128e-01f, +1.764410349e-01f, +1.489336266e-01f, +1.076604390e-01f, +6.152170242e-02f, +1.961443971e-02f, -1.113443096e-02f, -2.749060270e-02f, -3.019879725e-02f, -2.308511533e-02f, -1.141225626e-02f, -1.158055773e-04f, +7.501923774e-03f, +1.029070961e-02f, +8.979168103e-03f, +5.376566766e-03f, +1.442963148e-03f, -1.420708864e-03f, -2.673390924e-03f, -2.533239361e-03f, -1.631013365e-03f, -6.240301247e-04f, +6.651824963e-05f, +3.298780782e-04f, +2.842578627e-04f,
    -4.727250007e-07f, +1.026599884e-05f, +2.398312798e-05f, +3.273937254e-05f, +2.659930036e-05f, -1.066831678e-06f, -4.766932167e-05f, -9.809761845e-05f, -1.269915428e-04f, -1.075578371e-04f, -2.477201947e-05f, +1.121359191e-04f, +2.642051807e-04f, +3.689911742e-04f, +3.590403383e-04f, +1.877070282e-04f, -1.468653409e-04f, -5.898210613e-04f, -1.036756339e-03f, -1.360354815e-03f, -1.449192291e-03f, -1.245812685e-03f, -7.701986314e-04f, -1.191679313e-04f, +5.594176131e-04f, +1.109590290e-03f, +1.412960956e-03f, +1.421723547e-03f, +1.168273555e-03f, +7.493099823e-04f, +2.913294552e-04f, -8.954578688e-05f, -3.195668788e-04f, -3.815692209e-04f, -3.090990316e-04f, -1.654962695e-04f, -1.753627284e-05f, +8.638373006e-05f, +1.269060919e-04f, +1.119011921e-04f, +6.569864863e-05f, +1.544547346e-05f, -1.962999545e-05f, -3.277444107e-05f, -2.805590700e-05f, -1.496144545e-05f, -2.572314865e-06f, +4.112779054e-06f,
    -7.195239305e-04f, -9.353237483e-04f, -3.043372319e-04f, +1.554470653e-03f, +4.143275275e-03f, +5.845389617e-03f, +4.549072714e-03f, -9.099515406e-04f, -9.264392218e-03f, -1.646836510e-02f, -1.727066569e-02f, -8.325041607e-03f, +8.831136085e-03f, +2.705892191e-02f, +3.634459427e-02f, +2.911910692e-02f, +5.373650814e-03f, -2.570699678e-02f, -4.927757730e-02f, -5.225312887e-02f, -3.074699937e-02f, +6.838158244e-03f, +4.327673456e-02f, +6.106201633e-02f, +5.149086464e-02f, +1.925735928e-02f, -2.002988343e-02f, -4.800687203e-02f, -5.283829268e-02f, -3.460676859e-02f, -4.194447812e-03f, +2.321312110e-02f, +3.604544636e-02f, +3.138004003e-02f, +1.486802971e-02f, -3.610854368e-03f, -1.556652435e-02f, -1.763393539e-02f, -1.188657869e-02f, -3.350739662e-03f, +3.289075041e-03f, +5.851539792e-03f, +4.870604520e-03f, +2.340462970e-03f, +1.456387045e-04f, -8.580175499e-04f, -8.381090321e-04f, -4.148558973e-04f,
    +1.319236015e-05f, -2.754913188e-06f, -3.798182344e-05f, -7.471836679e-05f, -7.832095665e-05f, -1.813731700e-05f, +1.024647908e-04f, +2.286848653e-04f, +2.704734651e-04f, +1.543228943e-04f, -1.151961420e-04f, -4.271315862e-04f, -6.014772487e-04f, -4.863143052e-04f, -6.445985719e-05f, +5.002336227e-04f, +9.216803928e-04f, +9.391108251e-04f, +4.757245889e-04f, -2.888828959e-04f, -9.887438369e-04f, -1.257919916e-03f, -9.330226906e-04f, -1.539708695e-04f, +7.007753656e-04f, +1.212633655e-03f, +1.143986344e-03f, +5.574296133e-04f, -2.307979033e-04f, -8.303088519e-04f, -9.822381595e-04f, -6.766855115e-04f, -1.266144987e-04f, +3.713168784e-04f, +5.990855072e-04f, +5.119943527e-04f, +2.260492410e-04f, -7.554692499e-05f, -2.502775821e-04f, -2.572770162e-04f, -1.494120619e-04f, -1.818069976e-05f, +6.564741609e-05f, +8.161779110e-05f, +5.196580074e-05f, +1.312669022e-05f, -1.009965468e-05f, -1.351023705e-05f,
    /*  3, 6 (48) */
    +3.392102022e-04f, +2.026744047e-04f, -3.391516261e-04f, -1.268901192e-03f, -2.273052382e-03f, -2.755050294e-03f, -2.035127401e-03f, +2.920379980e-04f, +3.974362285e-03f, +7.894819592e-03f, +1.022416777e-02f, +9.001408407e-03f, +3.021263418e-03f, -7.276814136e-03f, -1.931483811e-02f, -2.860734723e-02f, -2.981798105e-02f, -1.842160329e-02f, +7.536781420e-03f, +4.622363344e-02f, +9.186811842e-02f, +1.358821308e-01f, +1.690059605e-01f, +1.838472449e-01f, +1.770004525e-01f, +1.500432169e-01f, +1.090734000e-01f, +6.294342596e-02f, +2.078271327e-02f, -1.038512098e-02f, -2.719927325e-02f, -3.028834304e-02f, -2.340468221e-02f, -1.179382548e-02f, -4.249046089e-04f, +7.336427504e-03f, +1.027317334e-02f, +9.065551833e-03f, +5.503472858e-03f, +1.554864340e-03f, -1.355010216e-03f, -2.657945450e-03f, -2.552869356e-03f, -1.663787806e-03f, -6.520860317e-04f, +5.155680418e-05f, +3.273057633e-04f, +2.883706418e-04f,
    -7.112032361e-07f, +9.855206040e-06f, +2.357875726e-05f, +3.264151887e-05f, +2.710054154e-05f, +1.288219903e-07f, -4.604437911e-05f, -9.669978219e-05f, -1.266960993e-04f, -1.090972631e-04f, -2.830211710e-05f, +1.073519189e-04f, +2.598063079e-04f, +3.671273824e-04f, +3.616452175e-04f, +1.956641385e-04f, -1.343388010e-04f, -5.752801377e-04f, -1.023991514e-03f, -1.353319360e-03f, -1.450725344e-03f, -1.256604192e-03f, -7.883896686e-04f, -1.407695631e-04f, +5.393960823e-04f, +1.095674065e-03f, +1.407900393e-03f, +1.425780546e-03f, +1.179320741e-03f, +7.636652355e-04f, +3.049954720e-04f, -7.968398176e-05f, -3.149782048e-04f, -3.819449340e-04f, -3.128058986e-04f, -1.703680708e-04f, -2.167520746e-05f, +8.407257635e-05f, +1.265775157e-04f, +1.129899195e-04f, +6.733312003e-05f, +1.685545253e-05f, -1.886280976e-05f, -3.267567353e-05f, -2.838383397e-05f, -1.539901900e-05f, -2.886233797e-06f, +4.003341125e-06f,
    -7.063315703e-04f, -9.380786615e-04f, -3.423190553e-04f, +1.479752286e-03f, +4.064954319e-03f, +5.827252300e-03f, +4.651537505e-03f, -6.812666753e-04f, -8.993918753e-03f, -1.631404221e-02f, -1.738586183e-02f, -8.752173193e-03f, +8.229658837e-03f, +2.657260760e-02f, +3.628013442e-02f, +2.961934054e-02f, +6.295331207e-03f, -2.476788595e-02f, -4.880185272e-02f, -5.254201177e-02f, -3.173574321e-02f, +5.580238328e-03f, +4.234371187e-02f, +6.090804546e-02f, +5.219164000e-02f, +2.046999293e-02f, -1.888589709e-02f, -4.744944242e-02f, -5.306909058e-02f, -3.543707744e-02f, -5.176685972e-03f, +2.253643559e-02f, +3.591883186e-02f, +3.175135691e-02f, +1.546711522e-02f, -3.098860015e-03f, -1.534047511e-02f, -1.770948231e-02f, -1.213685627e-02f, -3.608016678e-03f, +3.139662979e-03f, +5.833359092e-03f, +4.936251936e-03f, +2.422080761e-03f, +1.976045052e-04f, -8.448908597e-04f, -8.482086868e-04f, -4.283661344e-04f,
    +1.336098404e-05f, -1.930354200e-06f, -3.671014137e-05f, -7.387160839e-05f, -7.907108373e-05f, -2.107759459e-05f, +9.819774306e-05f, +2.255246866e-04f, +2.713187798e-04f, +1.605706006e-04f, -1.053011715e-04f, -4.184802618e-04f, -5.998706843e-04f, -4.949312534e-04f, -8.108892828e-05f, +4.831498493e-04f, +9.135991424e-04f, +9.460946405e-04f, +4.963252740e-04f, -2.638345942e-04f, -9.718250891e-04f, -1.258403080e-03f, -9.515434587e-04f, -1.817823486e-04f, +6.773383576e-04f, +1.204914861e-03f, +1.155081271e-03f, +5.808762122e-04f, -2.071376851e-04f, -8.175886110e-04f, -9.850356039e-04f, -6.914377299e-04f, -1.445077386e-04f, +3.591109445e-04f, +5.969798764e-04f, +5.186228688e-04f, +2.361694382e-04f, -6.753371491e-05f, -2.474248378e-04f, -2.592404393e-04f, -1.536109821e-04f, -2.181355622e-05f, +6.408192298e-05f, +8.199446477e-05f, +5.321091650e-05f, +1.417974247e-05f, -9.699627145e-06f, -1.362524182e-05f,
    /*  3, 7 (48) */
    +3.384989990e-04f, +2.125296108e-04f, -3.155728688e-04f, -1.236259674e-03f, -2.245951840e-03f, -2.754921472e-03f, -2.081171780e-03f, +1.953382158e-04f, +3.847666186e-03f, +7.785722329e-03f, +1.019586565e-02f, +9.108760326e-03f, +3.281069726e-03f, -6.909686753e-03f, -1.895319289e-02f, -2.841168309e-02f, -2.995231985e-02f, -1.899688343e-02f, +6.512789906e-03f, +4.487031408e-02f, +9.041739307e-02f, +1.346255266e-01f, +1.682175708e-01f, +1.837064753e-01f, +1.775398486e-01f, +1.511388909e-01f, +1.104813004e-01f, +6.436920651e-02f, +2.196203401e-02f, -9.621455742e-03f, -2.689427778e-02f, -3.036802702e-02f, -2.371966041e-02f, -1.217577041e-02f, -7.377105075e-04f, +7.166059434e-03f, +1.025149813e-02f, +9.149624410e-03f, +5.630050374e-03f, +1.667854260e-03f, -1.287677096e-03f, -2.641089998e-03f, -2.571732166e-03f, -1.696463480e-03f, -6.804698657e-04f, +3.615778519e-05f, +3.244195295e-04f, +2.923739829e-04f,
    -9.431530473e-07f, +9.447910213e-06f, +2.317004037e-05f, +3.252916038e-05f, +2.758009056e-05f, +1.304645589e-06f, -4.442473797e-05f, -9.528197147e-05f, -1.263532515e-04f, -1.105729513e-04f, -3.177609154e-05f, +1.025864097e-04f, +2.553639164e-04f, +3.651517933e-04f, +3.640896352e-04f, +2.034562514e-04f, -1.219248981e-04f, -5.607488983e-04f, -1.011108915e-03f, -1.346052953e-03f, -1.451967164e-03f, -1.267121457e-03f, -8.064010613e-04f, -1.623385964e-04f, +5.192504775e-04f, +1.081513561e-03f, +1.402545559e-03f, +1.429573887e-03f, +1.190200104e-03f, +7.779793207e-04f, +3.187373323e-04f, -6.967147102e-05f, -3.102208145e-04f, -3.821851813e-04f, -3.164408930e-04f, -1.752353437e-04f, -2.585857515e-05f, +8.169732682e-05f, +1.261927572e-04f, +1.140471018e-04f, +6.896357953e-05f, +1.828092849e-05f, -1.807329880e-05f, -3.255876525e-05f, -2.870331762e-05f, -1.583741601e-05f, -3.206055989e-06f, +3.887741319e-06f,
    -6.929705863e-04f, -9.400090157e-04f, -3.790291967e-04f, +1.405880678e-03f, +3.985883235e-03f, +5.806174705e-03f, +4.749735248e-03f, -4.557419887e-04f, -8.722599973e-03f, -1.615347161e-02f, -1.749116300e-02f, -9.170653454e-03f, +7.629788152e-03f, +2.607767635e-02f, +3.619904549e-02f, +3.010249039e-02f, +7.208930350e-03f, -2.382179131e-02f, -4.830552744e-02f, -5.280584636e-02f, -3.270756830e-02f, +4.321835247e-03f, +4.139216841e-02f, +6.072626311e-02f, +5.286897836e-02f, +2.167490780e-02f, -1.773081582e-02f, -4.686856621e-02f, -5.327622826e-02f, -3.625466605e-02f, -6.161721576e-03f, +2.184499786e-02f, +3.577432412e-02f, +3.211046785e-02f, +1.606409509e-02f, -2.580237146e-03f, -1.510430567e-02f, -1.777701603e-02f, -1.238428111e-02f, -3.867257117e-03f, +2.986051997e-03f, +5.811545536e-03f, +5.000333859e-03f, +2.504075226e-03f, +2.508154217e-04f, -8.307111173e-04f, -8.579083139e-04f, -4.419913762e-04f,
    +1.351207367e-05f, -1.126549914e-06f, -3.544241166e-05f, -7.299351605e-05f, -7.975667761e-05f, -2.395346008e-05f, +9.394195902e-05f, +2.222838567e-04f, +2.720046459e-04f, +1.666573908e-04f, -9.545894178e-05f, -4.096984102e-04f, -5.979730964e-04f, -5.032305666e-04f, -9.755980851e-05f, +4.659339923e-04f, +9.051136635e-04f, +9.525849697e-04f, +5.166059077e-04f, -2.387361456e-04f, -9.544776028e-04f, -1.258280144e-03f, -9.695907853e-04f, -2.095023907e-04f, +6.535621626e-04f, +1.196605909e-03f, +1.165641565e-03f, +6.041071003e-04f, -1.832927891e-04f, -8.044139162e-04f, -9.873630894e-04f, -7.059350357e-04f, -1.624501163e-04f, +3.466302178e-04f, +5.945512379e-04f, +5.250461533e-04f, +2.462725265e-04f, -5.939056664e-05f, -2.443996772e-04f, -2.610858231e-04f, -1.577862775e-04f, -2.549575523e-05f, +6.244626716e-05f, +8.232434518e-05f, +5.444713427e-05f, +1.524945968e-05f, -9.278914423e-06f, -1.372967500e-05f,
    /*  3, 8 (48) */
    +3.375558459e-04f, +2.219775210e-04f, -2.924028285e-04f, -1.203730513e-03f, -2.218371750e-03f, -2.753616827e-03f, -2.125596518e-03f, +1.000562444e-04f, +3.721312934e-03f, +7.675149378e-03f, +1.016408956e-02f, +9.211346736e-03f, +3.536433642e-03f, -6.544534960e-03f, -1.858910326e-02f, -2.820822684e-02f, -3.007424475e-02f, -1.955763232e-02f, +5.501680991e-03f, +4.352426113e-02f, +8.896542591e-02f, +1.333584052e-01f, +1.674111697e-01f, +1.835441367e-01f, +1.780590990e-01f, +1.522204045e-01f, +1.118838460e-01f, +6.579878040e-02f, +2.315223411e-02f, -8.843476421e-03f, -2.657554044e-02f, -3.043769849e-02f, -2.402988123e-02f, -1.255795560e-02f, -1.054151401e-03f, +6.990824090e-03f, +1.022563956e-02f, +9.231321737e-03f, +5.756243131e-03f, +1.781901362e-03f, -1.218713516e-03f, -2.622809069e-03f, -2.589805465e-03f, -1.729022245e-03f, -7.091731833e-04f, +2.032036918e-05f, +3.212134736e-04f, +2.962617242e-04f,
    -1.168558256e-06f, +9.044283303e-06f, +2.275727877e-05f, +3.240260206e-05f, +2.803806407e-05f, +2.460396421e-06f, -4.281104231e-05f, -9.384506926e-05f, -1.259637630e-04f, -1.119851055e-04f, -3.519325555e-05f, +9.784099981e-05f, +2.508801606e-04f, +3.630663859e-04f, +3.663745517e-04f, +2.110826698e-04f, -1.096261208e-04f, -5.462311107e-04f, -9.981125244e-04f, -1.338558509e-03f, -1.452918539e-03f, -1.277362709e-03f, -8.242288710e-04f, -1.838700421e-04f, +4.989853661e-04f, +1.067111595e-03f, +1.396896783e-03f, +1.433101487e-03f, +1.200907975e-03f, +7.922482224e-04f, +3.325518869e-04f, -5.950975647e-05f, -3.052944180e-04f, -3.822883300e-04f, -3.200018341e-04f, -1.800961712e-04f, -3.008526632e-05f, +7.925814052e-05f, +1.257512449e-04f, +1.150718556e-04f, +7.058924562e-05f, +1.972147714e-05f, -1.726148731e-05f, -3.242346883e-05f, -2.901403414e-05f, -1.627639872e-05f, -3.531699954e-06f, +3.765928427e-06f,
    -6.794585126e-04f, -9.411355656e-04f, -4.144716084e-04f, +1.332887162e-03f, +3.906126557e-03f, +5.782221245e-03f, +4.843677207e-03f, -2.334581321e-04f, -8.450595327e-03f, -1.598681422e-02f, -1.758662195e-02f, -9.580351865e-03f, +7.031815056e-03f, +2.557444578e-02f, +3.610148568e-02f, +3.056842438e-02f, +8.114044013e-03f, -2.286920634e-02f, -4.778892153e-02f, -5.304458251e-02f, -3.366204590e-02f, +3.063555103e-03f, +4.042257762e-02f, +6.051676072e-02f, +5.352254052e-02f, +2.287151370e-02f, -1.656517425e-02f, -4.626445911e-02f, -5.345952105e-02f, -3.705907997e-02f, -7.149084665e-03f, +2.113906282e-02f, +3.561187401e-02f, +3.245709807e-02f, +1.665864633e-02f, -2.055190993e-03f, -1.485803315e-02f, -1.783640660e-02f, -1.262868078e-02f, -4.128342940e-03f, +2.828265719e-03f, +5.786049781e-03f, +5.062780126e-03f, +2.586399571e-03f, +3.052625560e-04f, -8.154616576e-04f, -8.671872283e-04f, -4.557210512e-04f,
    +1.364594403e-05f, -3.436649713e-07f, -3.417949566e-05f, -7.208531271e-05f, -8.037843185e-05f, -2.676414031e-05f, +8.969986767e-05f, +2.189653917e-04f, +2.725326564e-04f, +1.725816699e-04f, -8.567434117e-05f, -4.007920296e-04f, -5.957879751e-04f, -5.112102807e-04f, -1.138649555e-04f, +4.485957701e-04f, +8.962304303e-04f, +9.585806927e-04f, +5.365573630e-04f, -2.136004132e-04f, -9.367111105e-04f, -1.257552114e-03f, -9.871559923e-04f, -2.371170630e-04f, +6.294585642e-04f, +1.187710250e-03f, +1.175660842e-03f, +6.271099183e-04f, -1.592747329e-04f, -7.907896309e-04f, -9.892171113e-04f, -7.201684470e-04f, -1.804325406e-04f, +3.338793035e-04f, +5.917982521e-04f, +5.312588432e-04f, +2.563527416e-04f, -5.112063874e-05f, -2.412017540e-04f, -2.628105067e-04f, -1.619350567e-04f, -2.922575262e-05f, +6.074030726e-05f, +8.260631152e-05f, +5.567335481e-05f, +1.633537227e-05f, -8.837361929e-06f, -1.382314016e-05f,
    /*  3, 9 (48) */
    +3.363872877e-04f, +2.310218043e-04f, -2.696455497e-04f, -1.171327911e-03f, -2.190333686e-03f, -2.751156430e-03f, -2.168407560e-03f, +6.211175117e-06f, +3.595349171e-03f, +7.563164272e-03f, +1.012889630e-02f, +9.309187736e-03f, +3.787313803e-03f, -6.181468574e-03f, -1.822272871e-02f, -2.799714417e-02f, -3.018387087e-02f, -2.010386343e-02f, +4.503568467e-03f, +4.218570262e-02f, +8.751250737e-02f, +1.320810425e-01f, +1.665869409e-01f, +1.833602667e-01f, +1.785580844e-01f, +1.532875161e-01f, +1.132807427e-01f, +6.723188188e-02f, +2.435314209e-02f, -8.051228198e-03f, -2.624298856e-02f, -3.049720825e-02f, -2.433517564e-02f, -1.294024393e-02f, -1.374153235e-03f, +6.810727919e-03f, +1.019555429e-02f, +9.310579877e-03f, +5.881994376e-03f, +1.896973217e-03f, -1.148124270e-03f, -2.603087592e-03f, -2.607066952e-03f, -1.761445714e-03f, -7.381872174e-04f, +4.043970461e-06f, +3.176817736e-04f, +3.000276527e-04f,
    -1.387406987e-06f, +8.644492266e-06f, +2.234077122e-05f, +3.226215150e-05f, +2.847458756e-05f, +3.595844583e-06f, -4.120392496e-05f, -9.238995567e-05f, -1.255284079e-04f, -1.133339535e-04f, -3.855295216e-05f, +9.311727215e-05f, +2.463571875e-04f, +3.608731577e-04f, +3.685009711e-04f, +2.185427537e-04f, -9.744490656e-05f, -5.317305164e-04f, -9.850063393e-04f, -1.330838993e-03f, -1.453580330e-03f, -1.287326252e-03f, -8.418692126e-04f, -2.053589224e-04f, +4.786053506e-04f, +1.052471054e-03f, +1.390954474e-03f, +1.436361328e-03f, +1.211440714e-03f, +8.064679161e-04f, +3.464359449e-04f, -4.920039709e-05f, -3.001987772e-04f, -3.822527779e-04f, -3.234865456e-04f, -1.849486176e-04f, -3.435414183e-05f, +7.675520442e-05f, +1.252524243e-04f, +1.160633002e-04f, +7.220932865e-05f, +2.117666142e-05f, -1.642741121e-05f, -3.226954245e-05f, -2.931565927e-05f, -1.671572506e-05f, -3.863079261e-06f, +3.637854360e-06f,
    -6.658125686e-04f, -9.414792306e-04f, -4.486511040e-04f, +1.260801849e-03f, +3.825748126e-03f, +5.755457105e-03f, +4.933377074e-03f, -1.449274037e-05f, -8.178062671e-03f, -1.581423255e-02f, -1.767229629e-02f, -9.981143894e-03f, +6.436027081e-03f, +2.506323550e-02f, +3.598762072e-02f, +3.101702015e-02f, +9.010274443e-03f, -2.191062565e-02f, -4.725236417e-02f, -5.325818292e-02f, -3.459875701e-02f, +1.806002989e-03f, +3.943542163e-02f, +6.027964365e-02f, +5.415199909e-02f, +2.405922395e-02f, -1.538951341e-02f, -4.563734919e-02f, -5.361879579e-02f, -3.784986960e-02f, -8.138301776e-03f, +2.041889438e-02f, +3.543144146e-02f, +3.279097737e-02f, +1.725044458e-02f, -1.523932150e-03f, -1.460168041e-02f, -1.788752723e-02f, -1.286988254e-02f, -4.391153447e-03f, +2.666330662e-03f, +5.756824028e-03f, +5.123520433e-03f, +2.669005882e-03f, +3.609359108e-04f, -7.991262853e-04f, -8.760245903e-04f, -4.695441913e-04f,
    +1.376291828e-05f, +4.181563958e-07f, -3.292223457e-05f, -7.114822141e-05f, -8.093707251e-05f, -2.950891663e-05f, +8.547385565e-05f, +2.155723173e-04f, +2.729044808e-04f, +1.783419554e-04f, -7.595217688e-05f, -3.917671351e-04f, -5.933189432e-04f, -5.188686224e-04f, -1.299969664e-04f, +4.311449117e-04f, +8.869560984e-04f, +9.640809589e-04f, +5.561707202e-04f, -1.884402431e-04f, -9.185355443e-04f, -1.256220314e-03f, -1.004230662e-03f, -2.646124904e-04f, +6.050395244e-04f, +1.178231646e-03f, +1.185132988e-03f, +6.498723961e-04f, -1.350951634e-04f, -7.767208785e-04f, -9.905944033e-04f, -7.341290765e-04f, -1.984458425e-04f, +3.208629886e-04f, +5.887197505e-04f, +5.372556494e-04f, +2.664042772e-04f, -4.272719737e-05f, -2.378308219e-04f, -2.644118708e-04f, -1.660544062e-04f, -3.300195016e-05f, +5.896394766e-05f, +8.283925787e-05f, +5.688846585e-05f, +1.743698814e-05f, -8.374829719e-06f, -1.390524188e-05f,
    /*  3,10 (48) */
    +3.349998807e-04f, +2.396662965e-04f, -2.473047785e-04f, -1.139065760e-03f, -2.161859098e-03f, -2.747560586e-03f, -2.209611485e-03f, -8.617878055e-05f, +3.469820763e-03f, +7.449830319e-03f, +1.009034335e-02f, +9.402305008e-03f, +4.033670990e-03f, -5.820595416e-03f, -1.785422774e-02f, -2.777860141e-02f, -3.028131578e-02f, -2.063559395e-02f, +3.518562128e-03f, +4.085486363e-02f, +8.605892704e-02f, +1.307937162e-01f, +1.657450717e-01f, +1.831549078e-01f, +1.790366898e-01f, +1.543399871e-01f, +1.146716972e-01f, +6.866824321e-02f, +2.556458280e-02f, -7.244760282e-03f, -2.589655261e-02f, -3.054640865e-02f, -2.463537442e-02f, -1.332249670e-02f, -1.697639780e-03f, +6.625779301e-03f, +1.016120015e-02f, +9.387335081e-03f, +6.007246800e-03f, +2.013036517e-03f, -1.075914942e-03f, -2.581910930e-03f, -2.623494363e-03f, -1.793715256e-03f, -7.675028767e-04f, -1.267175460e-05f, +3.138186943e-04f, +3.036655070e-04f,
    -1.599691615e-06f, +8.248699053e-06f, +2.192081377e-05f, +3.210811875e-05f, +2.888979521e-05f, +4.710772911e-06f, -3.960400736e-05f, -9.091750758e-05f, -1.250479701e-04f, -1.146197461e-04f, -4.185455463e-05f, +8.841678412e-05f, +2.417971359e-04f, +3.585741237e-04f, +3.704699399e-04f, +2.258359200e-04f, -8.538364049e-05f, -5.172508300e-04f, -9.717943669e-04f, -1.322897423e-03f, -1.453953477e-03f, -1.297010470e-03f, -8.593182563e-04f, -2.268002720e-04f, +4.581150677e-04f, +1.037594893e-03f, +1.384719120e-03f, +1.439351461e-03f, +1.221794714e-03f, +8.206343697e-04f, +3.603862744e-04f, -3.874500880e-05f, -2.949337063e-04f, -3.820769545e-04f, -3.268928558e-04f, -1.897907297e-04f, -3.866403314e-05f, +7.418873365e-05f, +1.246957586e-04f, +1.170205588e-04f, +7.382303112e-05f, +2.264603142e-05f, -1.557111780e-05f, -3.209675012e-05f, -2.960786843e-05f, -1.715514875e-05f, -4.200102517e-06f, +3.503474237e-06f,
    -6.520496503e-04f, -9.410610742e-04f, -4.815733386e-04f, +1.189653627e-03f, +3.744811053e-03f, +5.725948188e-03f, +5.018850930e-03f, +2.010795769e-04f, -7.905158190e-03f, -1.563589059e-02f, -1.774824846e-02f, -1.037291103e-02f, +5.842708137e-03f, +2.454436688e-02f, +3.585762376e-02f, +3.144816507e-02f, +9.897230542e-03f, -2.094654469e-02f, -4.669619345e-02f, -5.344662316e-02f, -3.551729255e-02f, +5.497826750e-04f, +3.843119097e-02f, +6.001503116e-02f, +5.475703861e-02f, +2.523745560e-02f, -1.420438042e-02f, -4.498747679e-02f, -5.375389095e-02f, -3.862659048e-02f, -9.128896180e-03f, +1.968476530e-02f, +3.523299562e-02f, +3.311184036e-02f, +1.783916434e-02f, -9.866765005e-04f, -1.433527613e-02f, -1.793025443e-02f, -1.310771336e-02f, -4.655565318e-03f, +2.500276256e-03f, +5.723822078e-03f, +5.182484381e-03f, +2.751845140e-03f, +4.178243766e-04f, -7.816892972e-04f, -8.843994200e-04f, -4.834494332e-04f,
    +1.386332733e-05f, +1.158790106e-06f, -3.167144923e-05f, -7.018346438e-05f, -8.143335712e-05f, -3.218712466e-05f, +8.126626625e-05f, +2.121076666e-04f, +2.731218630e-04f, +1.839368776e-04f, -6.629717269e-05f, -3.826297553e-04f, -5.905697532e-04f, -5.262040092e-04f, -1.459485814e-04f, +4.135911510e-04f, +8.772975004e-04f, +9.690851856e-04f, +5.754372713e-04f, -1.632684572e-04f, -8.999610301e-04f, -1.254286383e-03f, -1.020806642e-03f, -2.919748629e-04f, +5.803171765e-04f, +1.168174171e-03f, +1.194052169e-03f, +6.723823597e-04f, -1.107658511e-04f, -7.622130399e-04f, -9.914919407e-04f, -7.478081370e-04f, -2.164807795e-04f, +3.075862399e-04f, +5.853147382e-04f, +5.430313600e-04f, +2.764212891e-04f, -3.421361529e-05f, -2.342867362e-04f, -2.658873395e-04f, -1.701413919e-04f, -3.682269594e-05f, +5.711713924e-05f, +8.302209420e-05f, +5.809134268e-05f, +1.855379262e-05f, -7.891192903e-06f, -1.397558619e-05f,
    /*  3,11 (48) */
    +3.334001891e-04f, +2.479149956e-04f, -2.253839647e-04f, -1.106957641e-03f, -2.132969303e-03f, -2.742849813e-03f, -2.249215493e-03f, -1.770962881e-04f, +3.344772793e-03f, +7.335210573e-03f, +1.004848879e-02f, +9.490721792e-03f, +4.275468126e-03f, -5.462021293e-03f, -1.748375780e-02f, -2.755276549e-02f, -3.036669942e-02f, -2.115284478e-02f, +2.546767761e-03f, +3.953196621e-02f, +8.460497356e-02f, +1.294967058e-01f, +1.648857534e-01f, +1.829281075e-01f, +1.794948048e-01f, +1.553775820e-01f, +1.160564163e-01f, +7.010759467e-02f, +2.678637751e-02f, -6.424125913e-03f, -2.553616634e-02f, -3.058515366e-02f, -2.493030813e-02f, -1.370457366e-02f, -2.024532636e-03f, +6.435988572e-03f, +1.012253612e-02f, +9.461523815e-03f, +6.131942559e-03f, +2.130057076e-03f, -1.002091911e-03f, -2.559264899e-03f, -2.639065481e-03f, -1.825812007e-03f, -7.971107451e-04f, -2.982690335e-05f, +3.096185918e-04f, +3.071689813e-04f,
    -1.805408701e-06f, +7.857060596e-06f, +2.149769957e-05f, +3.194081607e-05f, +2.928382971e-05f, +5.804976927e-06f, -3.801189943e-05f, -8.942859827e-05f, -1.245232433e-04f, -1.158427570e-04f, -4.509746638e-05f, +8.374106713e-05f, +2.372021356e-04f, +3.561713154e-04f, +3.722825470e-04f, +2.329616422e-04f, -7.344465519e-05f, -5.027957374e-04f, -9.584806249e-04f, -1.314736864e-03f, -1.454038996e-03f, -1.306413829e-03f, -8.765722283e-04f, -2.481891397e-04f, +4.375191867e-04f, +1.022486136e-03f, +1.378191292e-03f, +1.442070000e-03f, +1.231966404e-03f, +8.347435446e-04f, +3.743996030e-04f, -2.814526430e-05f, -2.894990723e-04f, -3.817593219e-04f, -3.302185990e-04f, -1.946205367e-04f, -4.301374243e-05f, +7.155897168e-05f, +1.240807285e-04f, +1.179427581e-04f, +7.542954791e-05f, +2.412912441e-05f, -1.469266580e-05f, -3.190486185e-05f, -2.989033697e-05f, -1.759441937e-05f, -4.542673343e-06f, +3.362746456e-06f,
    -6.381863229e-04f, -9.399022841e-04f, -5.132447878e-04f, +1.119470163e-03f, +3.663377696e-03f, +5.693761064e-03f, +5.100117196e-03f, +4.131872435e-04f, -7.632036327e-03f, -1.545195372e-02f, -1.781454564e-02f, -1.075554078e-02f, +5.252138384e-03f, +2.401816287e-02f, +3.571167518e-02f, +3.186175622e-02f, +1.077452804e-02f, -1.997745950e-02f, -4.612075618e-02f, -5.360989162e-02f, -3.641725358e-02f, -7.045037083e-04f, +3.741038433e-02f, +5.972305630e-02f, +5.533735579e-02f, +2.640562977e-02f, -1.301032825e-02f, -4.431509443e-02f, -5.386465680e-02f, -3.938880352e-02f, -1.012038812e-02f, +1.893695716e-02f, +3.501651484e-02f, +3.341942660e-02f, +1.842447907e-02f, -4.436451405e-04f, -1.405885484e-02f, -1.796446805e-02f, -1.334200010e-02f, -4.921452657e-03f, +2.330134864e-03f, +5.686999382e-03f, +5.239601520e-03f, +2.834867234e-03f, +4.759157193e-04f, -7.631355045e-04f, -8.922906129e-04f, -4.974250194e-04f,
    +1.394750936e-05f, +1.878131958e-06f, -3.042793978e-05f, -6.919226211e-05f, -8.186807367e-05f, -3.479815397e-05f, +7.707939839e-05f, +2.085744781e-04f, +2.731866196e-04f, +1.893651790e-04f, -5.671396693e-05f, -3.733859286e-04f, -5.875442840e-04f, -5.332150490e-04f, -1.617126870e-04f, +3.959442215e-04f, +8.672616412e-04f, +9.735930579e-04f, +5.943485240e-04f, -1.380978459e-04f, -8.809978815e-04f, -1.251752275e-03f, -1.036876048e-03f, -3.191904429e-04f, +5.553038192e-04f, +1.157542210e-03f, +1.202412830e-03f, +6.946277381e-04f, -8.629868392e-05f, -7.472717518e-04f, -9.919069428e-04f, -7.611969468e-04f, -2.345280409e-04f, +2.940542028e-04f, +5.815823955e-04f, +5.485808445e-04f, +2.863978978e-04f, -2.558337091e-05f, -2.305694545e-04f, -2.672343829e-04f, -1.741930608e-04f, -4.068628472e-05f, +5.519988007e-05f, +8.315374743e-05f, +5.928084880e-05f, +1.968524855e-05f, -7.386342037e-06f, -1.403378090e-05f,
    /*  3,12 (48) */
    +3.315947804e-04f, +2.557720562e-04f, -2.038862651e-04f, -1.075016825e-03f, -2.103685473e-03f, -2.737044836e-03f, -2.287227392e-03f, -2.665248864e-04f, +3.220249550e-03f, +7.219367816e-03f, +1.000339133e-02f, +9.574462859e-03f, +4.512670262e-03f, -5.105849977e-03f, -1.711147525e-02f, -2.731980385e-02f, -3.044014407e-02f, -2.165564052e-02f, +1.588287136e-03f, +3.821722934e-02f, +8.315093457e-02f, +1.281902919e-01f, +1.640091812e-01f, +1.826799183e-01f, +1.799323240e-01f, +1.564000682e-01f, +1.174346076e-01f, +7.154966467e-02f, +2.801834392e-02f, -5.589382368e-03f, -2.516176673e-02f, -3.061329892e-02f, -2.521980720e-02f, -1.408633298e-02f, -2.354751235e-03f, +6.241368035e-03f, +1.007952237e-02f, +9.533082787e-03f, +6.256023287e-03f, +2.247999834e-03f, -9.266623627e-04f, -2.535135775e-03f, -2.653758147e-03f, -1.857716868e-03f, -8.270010821e-04f, -4.742132272e-05f, +3.050759185e-04f, +3.105317277e-04f,
    -2.004558929e-06f, +7.469728793e-06f, +2.107171878e-05f, +3.176055781e-05f, +2.965684206e-05f, +6.878264766e-06f, -3.642819940e-05f, -8.792409713e-05f, -1.239550299e-04f, -1.170032827e-04f, -4.828112092e-05f, +7.909162632e-05f, +2.325743066e-04f, +3.536667805e-04f, +3.739399226e-04f, +2.399194504e-04f, -6.163023022e-05f, -4.883688957e-04f, -9.450691397e-04f, -1.306360431e-03f, -1.453837979e-03f, -1.315534869e-03f, -8.936274118e-04f, -2.695205899e-04f, +4.168224081e-04f, +1.007147876e-03f, +1.371371643e-03f, +1.444515133e-03f, +1.241952248e-03f, +8.487913969e-04f, +3.884726189e-04f, -1.740289287e-05f, -2.838947950e-04f, -3.812983756e-04f, -3.334616159e-04f, -1.994360514e-04f, -4.740204284e-05f, +6.886619058e-05f, +1.234068331e-04f, +1.188290291e-04f, +7.702806658e-05f, +2.562546495e-05f, -1.379212554e-05f, -3.169365385e-05f, -3.016274024e-05f, -1.803328241e-05f, -4.890690353e-06f, +3.215632773e-06f,
    -6.242388136e-04f, -9.380241521e-04f, -5.436727276e-04f, +1.050277901e-03f, +3.581509622e-03f, +5.658962910e-03f, +5.177196595e-03f, +6.217617216e-04f, -7.358849707e-03f, -1.526258854e-02f, -1.787125960e-02f, -1.112892671e-02f, +4.664594100e-03f, +2.348494782e-02f, +3.554996249e-02f, +3.225770044e-02f, +1.164178968e-02f, -1.900386645e-02f, -4.552640766e-02f, -5.374798947e-02f, -3.729825146e-02f, -1.956255983e-03f, +3.637350828e-02f, +5.940386586e-02f, +5.589265961e-02f, +2.756317198e-02f, -1.180791542e-02f, -4.362046669e-02f, -5.395095548e-02f, -4.013607527e-02f, -1.111229506e-02f, +1.817576022e-02f, +3.478198680e-02f, +3.371348080e-02f, +1.900606147e-02f, +1.049357040e-04f, -1.377245694e-02f, -1.799005142e-02f, -1.357256955e-02f, -5.188687040e-03f, +2.155941804e-03f, +5.646313098e-03f, +5.294801400e-03f, +2.918020982e-03f, +5.351965681e-04f, -7.434502560e-04f, -8.996769549e-04f, -5.114588003e-04f,
    +1.401580941e-05f, +2.576097353e-06f, -2.919248539e-05f, -6.817583254e-05f, -8.224203962e-05f, -3.734144779e-05f, +7.291550570e-05f, +2.049757937e-04f, +2.731006376e-04f, +1.946257141e-04f, -4.720711048e-05f, -3.640416994e-04f, -5.842465376e-04f, -5.399005393e-04f, -1.772823189e-04f, +3.782138509e-04f, +8.568556929e-04f, +9.776045272e-04f, +6.128962056e-04f, -1.129411618e-04f, -8.616565938e-04f, -1.248620255e-03f, -1.052431269e-03f, -3.462455733e-04f, +5.300119093e-04f, +1.146340453e-03f, +1.210209701e-03f, +7.165965704e-04f, -6.170566071e-05f, -7.319029046e-04f, -9.918368755e-04f, -7.742869352e-04f, -2.525782520e-04f, +2.802721994e-04f, +5.775220799e-04f, +5.538990566e-04f, +2.963281919e-04f, -1.684004711e-05f, -2.266790381e-04f, -2.684505191e-04f, -1.782064426e-04f, -4.459095839e-05f, +5.321221614e-05f, +8.323316251e-05f, +6.045583661e-05f, +2.083079621e-05f, -6.860183518e-06f, -1.407943605e-05f,
    /*  3,13 (48) */
    +3.295902214e-04f, +2.632417850e-04f, -1.828145464e-04f, -1.043256267e-03f, -2.074028631e-03f, -2.730166571e-03f, -2.323655591e-03f, -3.544489835e-04f, +3.096294520e-03f, +7.102364533e-03f, +9.955110207e-03f, +9.653554485e-03f, +4.745244568e-03f, -4.752183197e-03f, -1.673753533e-02f, -2.707988440e-02f, -3.050177430e-02f, -2.214400941e-02f, +6.432179961e-04f, +3.691086891e-02f, +8.169709659e-02f, +1.268747571e-01f, +1.631155538e-01f, +1.824103978e-01f, +1.803491464e-01f, +1.574072160e-01f, +1.188059793e-01f, +7.299417980e-02f, +2.926029617e-02f, -4.740590971e-03f, -2.477329412e-02f, -3.063070181e-02f, -2.550370200e-02f, -1.446763136e-02f, -2.688212851e-03f, +6.041931983e-03f, +1.003212033e-02f, +9.601948977e-03f, +6.379430120e-03f, +2.366828863e-03f, -8.496342961e-04f, -2.509510310e-03f, -2.667550273e-03f, -1.889410522e-03f, -8.571638223e-04f, -6.545460513e-05f, +3.001852281e-04f, +3.137473605e-04f,
    -2.197147050e-06f, +7.086850493e-06f, +2.064315845e-05f, +3.156766014e-05f, +3.000899140e-05f, +7.930457114e-06f, -3.485349373e-05f, -8.640486925e-05f, -1.233441411e-04f, -1.181016416e-04f, -5.140498176e-05f, +7.446994021e-05f, +2.279157587e-04f, +3.510625815e-04f, +3.754432374e-04f, +2.467089309e-04f, -4.994259172e-05f, -4.739739316e-04f, -9.315639451e-04f, -1.297771287e-03f, -1.453351592e-03f, -1.324372214e-03f, -9.104801481e-04f, -2.907897042e-04f, +3.960294623e-04f, +9.915832698e-04f, +1.364260906e-03f, +1.446685114e-03f, +1.251748745e-03f, +8.627738789e-04f, +4.026019717e-04f, -6.519680158e-06f, -2.781208480e-04f, -3.806926450e-04f, -3.366197546e-04f, -2.042352704e-04f, -5.182767860e-05f, +6.611069114e-05f, +1.226735902e-04f, +1.196785074e-04f, +7.861776763e-05f, +2.713456492e-05f, -1.286957906e-05f, -3.146290874e-05f, -3.042475383e-05f, -1.847147940e-05f, -5.244047141e-06f, +3.062098378e-06f,
    -6.102230042e-04f, -9.354480548e-04f, -5.728652130e-04f, +9.821020684e-04f, +3.499267583e-03f, +5.621621462e-03f, +5.250112100e-03f, +8.267375154e-04f, -7.085749070e-03f, -1.506796282e-02f, -1.791846671e-02f, -1.149296841e-02f, +4.080347563e-03f, +2.294504728e-02f, +3.537268017e-02f, +3.263591429e-02f, +1.249864538e-02f, -1.802626192e-02f, -4.491351145e-02f, -5.386093063e-02f, -3.815990806e-02f, -3.204876238e-03f, +3.532107701e-02f, +5.905762029e-02f, +5.642267152e-02f, +2.870951243e-02f, -1.059770572e-02f, -4.290387012e-02f, -5.401266115e-02f, -4.086797817e-02f, -1.210413194e-02f, +1.740147328e-02f, +3.452940855e-02f, +3.399375300e-02f, +1.958358355e-02f, +6.588347606e-04f, -1.347612875e-02f, -1.800689146e-02f, -1.379924859e-02f, -5.457137559e-03f, +1.977735361e-03f, +5.601722139e-03f, +5.348013616e-03f, +3.001254144e-03f, +5.956524047e-04f, -7.226194598e-04f, -9.065371384e-04f, -5.255382364e-04f,
    +1.406857895e-05f, +3.252620996e-06f, -2.796584406e-05f, -6.713539017e-05f, -8.255610087e-05f, -3.981650256e-05f, +6.877679563e-05f, +2.013146568e-04f, +2.728658730e-04f, +1.997174486e-04f, -3.778106486e-05f, -3.546031149e-04f, -5.806806360e-04f, -5.462594666e-04f, -1.926506653e-04f, +3.604097550e-04f, +8.460869904e-04f, +9.811198106e-04f, +6.310722668e-04f, -8.781111195e-05f, -8.419478380e-04f, -1.244892900e-03f, -1.067464972e-03f, -3.731266840e-04f, +5.044540557e-04f, +1.134573895e-03f, +1.217437800e-03f, +7.382770122e-04f, -3.699888530e-05f, -7.161126399e-04f, -9.912794543e-04f, -7.870696480e-04f, -2.706219801e-04f, +2.662457264e-04f, +5.731333272e-04f, +5.589810390e-04f, +3.062062311e-04f, -7.987330131e-06f, -2.226156529e-04f, -2.695333162e-04f, -1.821785519e-04f, -4.853490644e-05f, +5.115424196e-05f, +8.325930343e-05f, +6.161514808e-05f, +2.198985344e-05f, -6.312639966e-06f, -1.411216429e-05f,
    /*  3,14 (48) */
    +3.273930744e-04f, +2.703286355e-04f, -1.621713879e-04f, -1.011688607e-03f, -2.044019640e-03f, -2.722236114e-03f, -2.358509085e-03f, -4.408538528e-04f, +2.972950379e-03f, +6.984262892e-03f, +9.903705225e-03f, +9.728024426e-03f, +4.973160327e-03f, -4.401120615e-03f, -1.636209209e-02f, -2.683317547e-02f, -3.055171689e-02f, -2.261798335e-02f, -2.883459489e-04f, +3.561309763e-02f, +8.024374500e-02f, +1.255503848e-01f, +1.622050736e-01f, +1.821196081e-01f, +1.807451759e-01f, +1.583987993e-01f, +1.201702402e-01f, +7.444086492e-02f, +3.051204491e-02f, -3.877817092e-03f, -2.437069214e-02f, -3.063722149e-02f, -2.578182284e-02f, -1.484832400e-02f, -3.024832606e-03f, +5.837696713e-03f, +9.980292652e-03f, +9.668059669e-03f, +6.502103710e-03f, +2.486507371e-03f, -7.710165285e-04f, -2.482375745e-03f, -2.680419852e-03f, -1.920873431e-03f, -8.875885761e-04f, -8.392608453e-05f, +2.949411810e-04f, +3.168094589e-04f,
    -2.383181810e-06f, +6.708567489e-06f, +2.021230241e-05f, +3.136244093e-05f, +3.034044483e-05f, +8.961387132e-06f, -3.328835692e-05f, -8.487177515e-05f, -1.226913964e-04f, -1.191381742e-04f, -5.446854234e-05f, +6.987746041e-05f, +2.232285908e-04f, +3.483607951e-04f, +3.767937026e-04f, +2.533297261e-04f, -3.838391195e-05f, -4.596144407e-04f, -9.179690811e-04f, -1.288972640e-03f, -1.452581076e-03f, -1.332924566e-03f, -9.271268379e-04f, -3.119915824e-04f, +3.751451082e-04f, +9.757955423e-04f, +1.356859895e-03f, +1.448578267e-03f, +1.261352435e-03f, +8.766869402e-04f, +4.167842732e-04f, +4.502532065e-06f, -2.721772587e-04f, -3.799406942e-04f, -3.396908715e-04f, -2.090161747e-04f, -5.628936525e-05f, +6.329280311e-05f, +1.218805365e-04f, +1.204903340e-04f, +8.019782480e-05f, +2.865592357e-05f, -1.192512019e-05f, -3.121241575e-05f, -3.067605374e-05f, -1.890874794e-05f, -5.602632266e-06f, +2.902111970e-06f,
    -5.961544252e-04f, -9.321954338e-04f, -6.008310570e-04f, +9.149666782e-04f, +3.416711482e-03f, +5.581804959e-03f, +5.318888896e-03f, +1.028052172e-03f, -6.812883197e-03f, -1.486824537e-02f, -1.795624778e-02f, -1.184757153e-02f, +3.499666927e-03f, +2.239878781e-02f, +3.518002950e-02f, +3.299632404e-02f, +1.334473237e-02f, -1.704514211e-02f, -4.428243918e-02f, -5.394874174e-02f, -3.900185590e-02f, -4.449769137e-03f, +3.425361204e-02f, +5.868449360e-02f, +5.692712557e-02f, +2.984408633e-02f, -9.380267921e-03f, -4.216559311e-02f, -5.404966003e-02f, -4.158409081e-02f, -1.309541139e-02f, +1.661440363e-02f, +3.425878657e-02f, +3.425999873e-02f, +2.015671688e-02f, +1.217815800e-03f, -1.316992252e-02f, -1.801487879e-02f, -1.402186424e-02f, -5.726670876e-03f, +1.795556809e-03f, +5.553187233e-03f, +5.399167858e-03f, +3.084513448e-03f, +6.572675528e-04f, -7.006296063e-04f, -9.128497784e-04f, -5.396504007e-04f,
    +1.410617540e-05f, +3.907656596e-06f, -2.674875237e-05f, -6.607214521e-05f, -8.281113071e-05f, -4.222286763e-05f, +6.466542856e-05f, +1.975941101e-04f, +2.724843481e-04f, +2.046394595e-04f, -2.844020036e-05f, -3.450762209e-04f, -5.768508178e-04f, -5.522910060e-04f, -2.078110696e-04f, +3.425416332e-04f, +8.349630263e-04f, +9.841393894e-04f, +6.488688858e-04f, -6.272035180e-05f, -8.218824541e-04f, -1.240573095e-03f, -1.081970105e-03f, -3.998203004e-04f, +4.786430117e-04f, +1.122247835e-03f, +1.224092438e-03f, +7.596573427e-04f, -1.219055996e-05f, -6.999073479e-04f, -9.902326461e-04f, -7.995367523e-04f, -2.886497384e-04f, +2.519804530e-04f, +5.684158539e-04f, +5.638219262e-04f, +3.160260501e-04f, +9.709917061e-07f, -2.183795704e-04f, -2.704803945e-04f, -1.861063893e-04f, -5.251626648e-05f, +4.902610125e-05f, +8.323115426e-05f, +6.275761546e-05f, +2.316181566e-05f, -5.743650604e-06f, -1.413158128e-05f,
    /*  3,15 (48) */
    +3.250098926e-04f, +2.770372030e-04f, -1.419590855e-04f, -9.803261659e-04f, -2.013679195e-03f, -2.713274727e-03f, -2.391797442e-03f, -5.257256279e-04f, +2.850258983e-03f, +6.865124717e-03f, +9.849236683e-03f, +9.797901886e-03f, +5.196388918e-03f, -4.052759820e-03f, -1.598529839e-02f, -2.657984575e-02f, -3.059010081e-02f, -2.307759779e-02f, -1.206315030e-03f, +3.432412499e-02f, +7.879116392e-02f, +1.242174603e-01f, +1.612779468e-01f, +1.818076165e-01f, +1.811203210e-01f, +1.593745949e-01f, +1.215271001e-01f, +7.588944319e-02f, +3.177339735e-02f, -3.001130152e-03f, -2.395390787e-02f, -3.063271896e-02f, -2.605400010e-02f, -1.522826470e-02f, -3.364523477e-03f, +5.628680538e-03f, +9.924003287e-03f, +9.731352472e-03f, +6.623984247e-03f, +2.606997705e-03f, -6.908187037e-04f, -2.453719821e-03f, -2.692344972e-03f, -1.952085847e-03f, -9.182646299e-04f, -1.028348325e-04f, +2.893385487e-04f, +3.197115708e-04f,
    -2.562675888e-06f, +6.335016514e-06f, +1.977943119e-05f, +3.114521951e-05f, +3.065137718e-05f, +9.970900371e-06f, -3.173335146e-05f, -8.332567041e-05f, -1.219976229e-04f, -1.201132422e-04f, -5.747132589e-05f, +6.531561133e-05f, +2.185148898e-04f, +3.455635110e-04f, +3.779925682e-04f, +2.597815341e-04f, -2.695630896e-05f, -4.452939862e-04f, -9.042885929e-04f, -1.279967744e-03f, -1.451527745e-03f, -1.341190709e-03f, -9.435639419e-04f, -3.331213445e-04f, +3.541741317e-04f, +9.597879820e-04f, +1.349169503e-03f, +1.450192989e-03f, +1.270759895e-03f, +8.905265289e-04f, +4.310160983e-04f, +1.566184617e-05f, -2.660641087e-04f, -3.790411232e-04f, -3.426728319e-04f, -2.137767305e-04f, -6.078578988e-05f, +6.041288532e-05f, +1.210272284e-04f, +1.212636550e-04f, +8.176740537e-05f, +3.018902766e-05f, -1.095885470e-05f, -3.094197089e-05f, -3.091631653e-05f, -1.934482185e-05f, -5.966329238e-06f, +2.735645829e-06f,
    -5.820482498e-04f, -9.282877772e-04f, -6.275798094e-04f, +8.488945330e-04f, +3.333900351e-03f, +5.539582092e-03f, +5.383554324e-03f, +1.225646282e-03f, -6.540398849e-03f, -1.466360591e-02f, -1.798468798e-02f, -1.219264775e-02f, +2.922816109e-03f, +2.184649681e-02f, +3.497221844e-02f, +3.333886568e-02f, +1.417969539e-02f, -1.606100272e-02f, -4.363357030e-02f, -5.401146209e-02f, -3.982373835e-02f, -5.690342233e-03f, +3.317164193e-02f, +5.828467330e-02f, +5.740576858e-02f, +3.096633416e-02f, -8.156175483e-03f, -4.140593577e-02f, -5.406185059e-02f, -4.228399816e-02f, -1.408564404e-02f, +1.581486688e-02f, +3.397013683e-02f, +3.451197918e-02f, +2.072513273e-02f, +1.781637726e-03f, -1.285389647e-02f, -1.801390780e-02f, -1.424024381e-02f, -5.997151270e-03f, +1.609450420e-03f, +5.500670966e-03f, +5.448193960e-03f, +3.167744602e-03f, +7.200251683e-04f, -6.774677907e-04f, -9.185934290e-04f, -5.537819819e-04f,
    +1.412896176e-05f, +4.541176552e-06f, -2.554192529e-05f, -6.498730276e-05f, -8.300802883e-05f, -4.456014472e-05f, +6.058351699e-05f, +1.938171938e-04f, +2.719581501e-04f, +2.093909339e-04f, -1.918879431e-05f, -3.354670587e-04f, -5.727614348e-04f, -5.579945201e-04f, -2.227570335e-04f, +3.246191624e-04f, +8.234914461e-04f, +9.866640079e-04f, +6.662784709e-04f, -3.768147783e-05f, -8.014714454e-04f, -1.235664035e-03f, -1.095939898e-03f, -4.263130497e-04f, +4.525916689e-04f, +1.109367871e-03f, +1.230169216e-03f, +7.807259716e-04f, +1.270702101e-05f, -6.832936650e-04f, -9.886946717e-04f, -8.116800428e-04f, -3.066519920e-04f, +2.374822193e-04f, +5.633695578e-04f, +5.684169483e-04f, +3.257816614e-04f, +1.003102933e-05f, -2.139711689e-04f, -2.712894287e-04f, -1.899869437e-04f, -5.653312481e-05f, +4.682798754e-05f, +8.314772024e-05f, +6.388206201e-05f, +2.434605598e-05f, -5.153171625e-06f, -1.413730612e-05f,
    /*  3,16 (48) */
    +3.224472167e-04f, +2.833722195e-04f, -1.221796543e-04f, -9.491809464e-04f, -1.983027818e-03f, -2.703303827e-03f, -2.423530794e-03f, -6.090512983e-04f, +2.728261360e-03f, +6.745011475e-03f, +9.791765357e-03f, +9.863217497e-03f, +5.414903808e-03f, -3.707196309e-03f, -1.560730582e-02f, -2.632006421e-02f, -3.061705711e-02f, -2.352289177e-02f, -2.110603623e-03f, +3.304415724e-02f, +7.733963617e-02f, +1.228762696e-01f, +1.603343828e-01f, +1.814744951e-01f, +1.814744951e-01f, +1.603343828e-01f, +1.228762696e-01f, +7.733963617e-02f, +3.304415724e-02f, -2.110603623e-03f, -2.352289177e-02f, -3.061705711e-02f, -2.632006421e-02f, -1.560730582e-02f, -3.707196309e-03f, +5.414903808e-03f, +9.863217497e-03f, +9.791765357e-03f, +6.745011475e-03f, +2.728261360e-03f, -6.090512983e-04f, -2.423530794e-03f, -2.703303827e-03f, -1.983027818e-03f, -9.491809464e-04f, -1.221796543e-04f, +2.833722195e-04f, +3.224472167e-04f,
    -2.735645829e-06f, +5.966329238e-06f, +1.934482185e-05f, +3.091631653e-05f, +3.094197089e-05f, +1.095885470e-05f, -3.018902766e-05f, -8.176740537e-05f, -1.212636550e-04f, -1.210272284e-04f, -6.041288532e-05f, +6.078578988e-05f, +2.137767305e-04f, +3.426728319e-04f, +3.790411232e-04f, +2.660641087e-04f, -1.566184617e-05f, -4.310160983e-04f, -8.905265289e-04f, -1.270759895e-03f, -1.450192989e-03f, -1.349169503e-03f, -9.597879820e-04f, -3.541741317e-04f, +3.331213445e-04f, +9.435639419e-04f, +1.341190709e-03f, +1.451527745e-03f, +1.279967744e-03f, +9.042885929e-04f, +4.452939862e-04f, +2.695630896e-05f, -2.597815341e-04f, -3.779925682e-04f, -3.455635110e-04f, -2.185148898e-04f, -6.531561133e-05f, +5.747132589e-05f, +1.201132422e-04f, +1.219976229e-04f, +8.332567041e-05f, +3.173335146e-05f, -9.970900371e-06f, -3.065137718e-05f, -3.114521951e-05f, -1.977943119e-05f, -6.335016514e-06f, +2.562675888e-06f,
    -5.679192881e-04f, -9.237466006e-04f, -6.531217347e-04f, +7.839072303e-04f, +3.250892322e-03f, +5.495021947e-03f, +5.444137841e-03f, +1.419463476e-03f, -6.268440699e-03f, -1.445421498e-02f, -1.800387677e-02f, -1.252811481e-02f, +2.350054674e-03f, +2.128850229e-02f, +3.474946140e-02f, +3.366348484e-02f, +1.500318684e-02f, -1.507433871e-02f, -4.296729183e-02f, -5.404914357e-02f, -4.062520980e-02f, -6.926006268e-03f, +3.207570204e-02f, +5.785836025e-02f, +5.785836025e-02f, +3.207570204e-02f, -6.926006268e-03f, -4.062520980e-02f, -5.404914357e-02f, -4.296729183e-02f, -1.507433871e-02f, +1.500318684e-02f, +3.366348484e-02f, +3.474946140e-02f, +2.128850229e-02f, +2.350054674e-03f, -1.252811481e-02f, -1.800387677e-02f, -1.445421498e-02f, -6.268440699e-03f, +1.419463476e-03f, +5.444137841e-03f, +5.495021947e-03f, +3.250892322e-03f, +7.839072303e-04f, -6.531217347e-04f, -9.237466006e-04f, -5.679192881e-04f,
    +1.413730612e-05f, +5.153171625e-06f, -2.434605598e-05f, -6.388206201e-05f, -8.314772024e-05f, -4.682798754e-05f, +5.653312481e-05f, +1.899869437e-04f, +2.712894287e-04f, +2.139711689e-04f, -1.003102933e-05f, -3.257816614e-04f, -5.684169483e-04f, -5.633695578e-04f, -2.374822193e-04f, +3.066519920e-04f, +8.116800428e-04f, +9.886946717e-04f, +6.832936650e-04f, -1.270702101e-05f, -7.807259716e-04f, -1.230169216e-03f, -1.109367871e-03f, -4.525916689e-04f, +4.263130497e-04f, +1.095939898e-03f, +1.235664035e-03f, +8.014714454e-04f, +3.768147783e-05f, -6.662784709e-04f, -9.866640079e-04f, -8.234914461e-04f, -3.246191624e-04f, +2.227570335e-04f, +5.579945201e-04f, +5.727614348e-04f, +3.354670587e-04f, +1.918879431e-05f, -2.093909339e-04f, -2.719581501e-04f, -1.938171938e-04f, -6.058351699e-05f, +4.456014472e-05f, +8.300802883e-05f, +6.498730276e-05f, +2.554192529e-05f, -4.541176552e-06f, -1.412896176e-05f,
    /*  3,17 (48) */
    +3.197115708e-04f, +2.893385487e-04f, -1.028348325e-04f, -9.182646299e-04f, -1.952085847e-03f, -2.692344972e-03f, -2.453719821e-03f, -6.908187037e-04f, +2.606997705e-03f, +6.623984247e-03f, +9.731352472e-03f, +9.924003287e-03f, +5.628680538e-03f, -3.364523477e-03f, -1.522826470e-02f, -2.605400010e-02f, -3.063271896e-02f, -2.395390787e-02f, -3.001130152e-03f, +3.177339735e-02f, +7.588944319e-02f, +1.215271001e-01f, +1.593745949e-01f, +1.811203210e-01f, +1.818076165e-01f, +1.612779468e-01f, +1.242174603e-01f, +7.879116392e-02f, +3.432412499e-02f, -1.206315030e-03f, -2.307759779e-02f, -3.059010081e-02f, -2.657984575e-02f, -1.598529839e-02f, -4.052759820e-03f, +5.196388918e-03f, +9.797901886e-03f, +9.849236683e-03f, +6.865124717e-03f, +2.850258983e-03f, -5.257256279e-04f, -2.391797442e-03f, -2.713274727e-03f, -2.013679195e-03f, -9.803261659e-04f, -1.419590855e-04f, +2.770372030e-04f, +3.250098926e-04f,
    -2.902111970e-06f, +5.602632266e-06f, +1.890874794e-05f, +3.067605374e-05f, +3.121241575e-05f, +1.192512019e-05f, -2.865592357e-05f, -8.019782480e-05f, -1.204903340e-04f, -1.218805365e-04f, -6.329280311e-05f, +5.628936525e-05f, +2.090161747e-04f, +3.396908715e-04f, +3.799406942e-04f, +2.721772587e-04f, -4.502532065e-06f, -4.167842732e-04f, -8.766869402e-04f, -1.261352435e-03f, -1.448578267e-03f, -1.356859895e-03f, -9.757955423e-04f, -3.751451082e-04f, +3.119915824e-04f, +9.271268379e-04f, +1.332924566e-03f, +1.452581076e-03f, +1.288972640e-03f, +9.179690811e-04f, +4.596144407e-04f, +3.838391195e-05f, -2.533297261e-04f, -3.767937026e-04f, -3.483607951e-04f, -2.232285908e-04f, -6.987746041e-05f, +5.446854234e-05f, +1.191381742e-04f, +1.226913964e-04f, +8.487177515e-05f, +3.328835692e-05f, -8.961387132e-06f, -3.034044483e-05f, -3.136244093e-05f, -2.021230241e-05f, -6.708567489e-06f, +2.383181810e-06f,
    -5.537819819e-04f, -9.185934290e-04f, -6.774677907e-04f, +7.200251683e-04f, +3.167744602e-03f, +5.448193960e-03f, +5.500670966e-03f, +1.609450420e-03f, -5.997151270e-03f, -1.424024381e-02f, -1.801390780e-02f, -1.285389647e-02f, +1.781637726e-03f, +2.072513273e-02f, +3.451197918e-02f, +3.397013683e-02f, +1.581486688e-02f, -1.408564404e-02f, -4.228399816e-02f, -5.406185059e-02f, -4.140593577e-02f, -8.156175483e-03f, +3.096633416e-02f, +5.740576858e-02f, +5.828467330e-02f, +3.317164193e-02f, -5.690342233e-03f, -3.982373835e-02f, -5.401146209e-02f, -4.363357030e-02f, -1.606100272e-02f, +1.417969539e-02f, +3.333886568e-02f, +3.497221844e-02f, +2.184649681e-02f, +2.922816109e-03f, -1.219264775e-02f, -1.798468798e-02f, -1.466360591e-02f, -6.540398849e-03f, +1.225646282e-03f, +5.383554324e-03f, +5.539582092e-03f, +3.333900351e-03f, +8.488945330e-04f, -6.275798094e-04f, -9.282877772e-04f, -5.820482498e-04f,
    +1.413158128e-05f, +5.743650604e-06f, -2.316181566e-05f, -6.275761546e-05f, -8.323115426e-05f, -4.902610125e-05f, +5.251626648e-05f, +1.861063893e-04f, +2.704803945e-04f, +2.183795704e-04f, -9.709917061e-07f, -3.160260501e-04f, -5.638219262e-04f, -5.684158539e-04f, -2.519804530e-04f, +2.886497384e-04f, +7.995367523e-04f, +9.902326461e-04f, +6.999073479e-04f, +1.219055996e-05f, -7.596573427e-04f, -1.224092438e-03f, -1.122247835e-03f, -4.786430117e-04f, +3.998203004e-04f, +1.081970105e-03f, +1.240573095e-03f, +8.218824541e-04f, +6.272035180e-05f, -6.488688858e-04f, -9.841393894e-04f, -8.349630263e-04f, -3.425416332e-04f, +2.078110696e-04f, +5.522910060e-04f, +5.768508178e-04f, +3.450762209e-04f, +2.844020036e-05f, -2.046394595e-04f, -2.724843481e-04f, -1.975941101e-04f, -6.466542856e-05f, +4.222286763e-05f, +8.281113071e-05f, +6.607214521e-05f, +2.674875237e-05f, -3.907656596e-06f, -1.410617540e-05f,
    /*  3,18 (48) */
    +3.168094589e-04f, +2.949411810e-04f, -8.392608453e-05f, -8.875885761e-04f, -1.920873431e-03f, -2.680419852e-03f, -2.482375745e-03f, -7.710165285e-04f, +2.486507371e-03f, +6.502103710e-03f, +9.668059669e-03f, +9.980292652e-03f, +5.837696713e-03f, -3.024832606e-03f, -1.484832400e-02f, -2.578182284e-02f, -3.063722149e-02f, -2.437069214e-02f, -3.877817092e-03f, +3.051204491e-02f, +7.444086492e-02f, +1.201702402e-01f, +1.583987993e-01f, +1.807451759e-01f, +1.821196081e-01f, +1.622050736e-01f, +1.255503848e-01f, +8.024374500e-02f, +3.561309763e-02f, -2.883459489e-04f, -2.261798335e-02f, -3.055171689e-02f, -2.683317547e-02f, -1.636209209e-02f, -4.401120615e-03f, +4.973160327e-03f, +9.728024426e-03f, +9.903705225e-03f, +6.984262892e-03f, +2.972950379e-03f, -4.408538528e-04f, -2.358509085e-03f, -2.722236114e-03f, -2.044019640e-03f, -1.011688607e-03f, -1.621713879e-04f, +2.703286355e-04f, +3.273930744e-04f,
    -3.062098378e-06f, +5.244047141e-06f, +1.847147940e-05f, +3.042475383e-05f, +3.146290874e-05f, +1.286957906e-05f, -2.713456492e-05f, -7.861776763e-05f, -1.196785074e-04f, -1.226735902e-04f, -6.611069114e-05f, +5.182767860e-05f, +2.042352704e-04f, +3.366197546e-04f, +3.806926450e-04f, +2.781208480e-04f, +6.519680158e-06f, -4.026019717e-04f, -8.627738789e-04f, -1.251748745e-03f, -1.446685114e-03f, -1.364260906e-03f, -9.915832698e-04f, -3.960294623e-04f, +2.907897042e-04f, +9.104801481e-04f, +1.324372214e-03f, +1.453351592e-03f, +1.297771287e-03f, +9.315639451e-04f, +4.739739316e-04f, +4.994259172e-05f, -2.467089309e-04f, -3.754432374e-04f, -3.510625815e-04f, -2.279157587e-04f, -7.446994021e-05f, +5.140498176e-05f, +1.181016416e-04f, +1.233441411e-04f, +8.640486925e-05f, +3.485349373e-05f, -7.930457114e-06f, -3.000899140e-05f, -3.156766014e-05f, -2.064315845e-05f, -7.086850493e-06f, +2.197147050e-06f,
    -5.396504007e-04f, -9.128497784e-04f, -7.006296063e-04f, +6.572675528e-04f, +3.084513448e-03f, +5.399167858e-03f, +5.553187233e-03f, +1.795556809e-03f, -5.726670876e-03f, -1.402186424e-02f, -1.801487879e-02f, -1.316992252e-02f, +1.217815800e-03f, +2.015671688e-02f, +3.425999873e-02f, +3.425878657e-02f, +1.661440363e-02f, -1.309541139e-02f, -4.158409081e-02f, -5.404966003e-02f, -4.216559311e-02f, -9.380267921e-03f, +2.984408633e-02f, +5.692712557e-02f, +5.868449360e-02f, +3.425361204e-02f, -4.449769137e-03f, -3.900185590e-02f, -5.394874174e-02f, -4.428243918e-02f, -1.704514211e-02f, +1.334473237e-02f, +3.299632404e-02f, +3.518002950e-02f, +2.239878781e-02f, +3.499666927e-03f, -1.184757153e-02f, -1.795624778e-02f, -1.486824537e-02f, -6.812883197e-03f, +1.028052172e-03f, +5.318888896e-03f, +5.581804959e-03f, +3.416711482e-03f, +9.149666782e-04f, -6.008310570e-04f, -9.321954338e-04f, -5.961544252e-04f,
    +1.411216429e-05f, +6.312639966e-06f, -2.198985344e-05f, -6.161514808e-05f, -8.325930343e-05f, -5.115424196e-05f, +4.853490644e-05f, +1.821785519e-04f, +2.695333162e-04f, +2.226156529e-04f, +7.987330131e-06f, -3.062062311e-04f, -5.589810390e-04f, -5.731333272e-04f, -2.662457264e-04f, +2.706219801e-04f, +7.870696480e-04f, +9.912794543e-04f, +7.161126399e-04f, +3.699888530e-05f, -7.382770122e-04f, -1.217437800e-03f, -1.134573895e-03f, -5.044540557e-04f, +3.731266840e-04f, +1.067464972e-03f, +1.244892900e-03f, +8.419478380e-04f, +8.781111195e-05f, -6.310722668e-04f, -9.811198106e-04f, -8.460869904e-04f, -3.604097550e-04f, +1.926506653e-04f, +5.462594666e-04f, +5.806806360e-04f, +3.546031149e-04f, +3.778106486e-05f, -1.997174486e-04f, -2.728658730e-04f, -2.013146568e-04f, -6.877679563e-05f, +3.981650256e-05f, +8.255610087e-05f, +6.713539017e-05f, +2.796584406e-05f, -3.252620996e-06f, -1.406857895e-05f,
    /*  3,19 (48) */
    +3.137473605e-04f, +3.001852281e-04f, -6.545460513e-05f, -8.571638223e-04f, -1.889410522e-03f, -2.667550273e-03f, -2.509510310e-03f, -8.496342961e-04f, +2.366828863e-03f, +6.379430120e-03f, +9.601948977e-03f, +1.003212033e-02f, +6.041931983e-03f, -2.688212851e-03f, -1.446763136e-02f, -2.550370200e-02f, -3.063070181e-02f, -2.477329412e-02f, -4.740590971e-03f, +2.926029617e-02f, +7.299417980e-02f, +1.188059793e-01f, +1.574072160e-01f, +1.803491464e-01f, +1.824103978e-01f, +1.631155538e-01f, +1.268747571e-01f, +8.169709659e-02f, +3.691086891e-02f, +6.432179961e-04f, -2.214400941e-02f, -3.050177430e-02f, -2.707988440e-02f, -1.673753533e-02f, -4.752183197e-03f, +4.745244568e-03f, +9.653554485e-03f, +9.955110207e-03f, +7.102364533e-03f, +3.096294520e-03f, -3.544489835e-04f, -2.323655591e-03f, -2.730166571e-03f, -2.074028631e-03f, -1.043256267e-03f, -1.828145464e-04f, +2.632417850e-04f, +3.295902214e-04f,
    -3.215632773e-06f, +4.890690353e-06f, +1.803328241e-05f, +3.016274024e-05f, +3.169365385e-05f, +1.379212554e-05f, -2.562546495e-05f, -7.702806658e-05f, -1.188290291e-04f, -1.234068331e-04f, -6.886619058e-05f, +4.740204284e-05f, +1.994360514e-04f, +3.334616159e-04f, +3.812983756e-04f, +2.838947950e-04f, +1.740289287e-05f, -3.884726189e-04f, -8.487913969e-04f, -1.241952248e-03f, -1.444515133e-03f, -1.371371643e-03f, -1.007147876e-03f, -4.168224081e-04f, +2.695205899e-04f, +8.936274118e-04f, +1.315534869e-03f, +1.453837979e-03f, +1.306360431e-03f, +9.450691397e-04f, +4.883688957e-04f, +6.163023022e-05f, -2.399194504e-04f, -3.739399226e-04f, -3.536667805e-04f, -2.325743066e-04f, -7.909162632e-05f, +4.828112092e-05f, +1.170032827e-04f, +1.239550299e-04f, +8.792409713e-05f, +3.642819940e-05f, -6.878264766e-06f, -2.965684206e-05f, -3.176055781e-05f, -2.107171878e-05f, -7.469728793e-06f, +2.004558929e-06f,
    -5.255382364e-04f, -9.065371384e-04f, -7.226194598e-04f, +5.956524047e-04f, +3.001254144e-03f, +5.348013616e-03f, +5.601722139e-03f, +1.977735361e-03f, -5.457137559e-03f, -1.379924859e-02f, -1.800689146e-02f, -1.347612875e-02f, +6.588347606e-04f, +1.958358355e-02f, +3.399375300e-02f, +3.452940855e-02f, +1.740147328e-02f, -1.210413194e-02f, -4.086797817e-02f, -5.401266115e-02f, -4.290387012e-02f, -1.059770572e-02f, +2.870951243e-02f, +5.642267152e-02f, +5.905762029e-02f, +3.532107701e-02f, -3.204876238e-03f, -3.815990806e-02f, -5.386093063e-02f, -4.491351145e-02f, -1.802626192e-02f, +1.249864538e-02f, +3.263591429e-02f, +3.537268017e-02f, +2.294504728e-02f, +4.080347563e-03f, -1.149296841e-02f, -1.791846671e-02f, -1.506796282e-02f, -7.085749070e-03f, +8.267375154e-04f, +5.250112100e-03f, +5.621621462e-03f, +3.499267583e-03f, +9.821020684e-04f, -5.728652130e-04f, -9.354480548e-04f, -6.102230042e-04f,
    +1.407943605e-05f, +6.860183518e-06f, -2.083079621e-05f, -6.045583661e-05f, -8.323316251e-05f, -5.321221614e-05f, +4.459095839e-05f, +1.782064426e-04f, +2.684505191e-04f, +2.266790381e-04f, +1.684004711e-05f, -2.963281919e-04f, -5.538990566e-04f, -5.775220799e-04f, -2.802721994e-04f, +2.525782520e-04f, +7.742869352e-04f, +9.918368755e-04f, +7.319029046e-04f, +6.170566071e-05f, -7.165965704e-04f, -1.210209701e-03f, -1.146340453e-03f, -5.300119093e-04f, +3.462455733e-04f, +1.052431269e-03f, +1.248620255e-03f, +8.616565938e-04f, +1.129411618e-04f, -6.128962056e-04f, -9.776045272e-04f, -8.568556929e-04f, -3.782138509e-04f, +1.772823189e-04f, +5.399005393e-04f, +5.842465376e-04f, +3.640416994e-04f, +4.720711048e-05f, -1.946257141e-04f, -2.731006376e-04f, -2.049757937e-04f, -7.291550570e-05f, +3.734144779e-05f, +8.224203962e-05f, +6.817583254e-05f, +2.919248539e-05f, -2.576097353e-06f, -1.401580941e-05f,
    /*  3,20 (48) */
    +3.105317277e-04f, +3.050759185e-04f, -4.742132272e-05f, -8.270010821e-04f, -1.857716868e-03f, -2.653758147e-03f, -2.535135775e-03f, -9.266623627e-04f, +2.247999834e-03f, +6.256023287e-03f, +9.533082787e-03f, +1.007952237e-02f, +6.241368035e-03f, -2.354751235e-03f, -1.408633298e-02f, -2.521980720e-02f, -3.061329892e-02f, -2.516176673e-02f, -5.589382368e-03f, +2.801834392e-02f, +7.154966467e-02f, +1.174346076e-01f, +1.564000682e-01f, +1.799323240e-01f, +1.826799183e-01f, +1.640091812e-01f, +1.281902919e-01f, +8.315093457e-02f, +3.821722934e-02f, +1.588287136e-03f, -2.165564052e-02f, -3.044014407e-02f, -2.731980385e-02f, -1.711147525e-02f, -5.105849977e-03f, +4.512670262e-03f, +9.574462859e-03f, +1.000339133e-02f, +7.219367816e-03f, +3.220249550e-03f, -2.665248864e-04f, -2.287227392e-03f, -2.737044836e-03f, -2.103685473e-03f, -1.075016825e-03f, -2.038862651e-04f, +2.557720562e-04f, +3.315947804e-04f,
    -3.362746456e-06f, +4.542673343e-06f, +1.759441937e-05f, +2.989033697e-05f, +3.190486185e-05f, +1.469266580e-05f, -2.412912441e-05f, -7.542954791e-05f, -1.179427581e-04f, -1.240807285e-04f, -7.155897168e-05f, +4.301374243e-05f, +1.946205367e-04f, +3.302185990e-04f, +3.817593219e-04f, +2.894990723e-04f, +2.814526430e-05f, -3.743996030e-04f, -8.347435446e-04f, -1.231966404e-03f, -1.442070000e-03f, -1.378191292e-03f, -1.022486136e-03f, -4.375191867e-04f, +2.481891397e-04f, +8.765722283e-04f, +1.306413829e-03f, +1.454038996e-03f, +1.314736864e-03f, +9.584806249e-04f, +5.027957374e-04f, +7.344465519e-05f, -2.329616422e-04f, -3.722825470e-04f, -3.561713154e-04f, -2.372021356e-04f, -8.374106713e-05f, +4.509746638e-05f, +1.158427570e-04f, +1.245232433e-04f, +8.942859827e-05f, +3.801189943e-05f, -5.804976927e-06f, -2.928382971e-05f, -3.194081607e-05f, -2.149769957e-05f, -7.857060596e-06f, +1.805408701e-06f,
    -5.114588003e-04f, -8.996769549e-04f, -7.434502560e-04f, +5.351965681e-04f, +2.918020982e-03f, +5.294801400e-03f, +5.646313098e-03f, +2.155941804e-03f, -5.188687040e-03f, -1.357256955e-02f, -1.799005142e-02f, -1.377245694e-02f, +1.049357040e-04f, +1.900606147e-02f, +3.371348080e-02f, +3.478198680e-02f, +1.817576022e-02f, -1.111229506e-02f, -4.013607527e-02f, -5.395095548e-02f, -4.362046669e-02f, -1.180791542e-02f, +2.756317198e-02f, +5.589265961e-02f, +5.940386586e-02f, +3.637350828e-02f, -1.956255983e-03f, -3.729825146e-02f, -5.374798947e-02f, -4.552640766e-02f, -1.900386645e-02f, +1.164178968e-02f, +3.225770044e-02f, +3.554996249e-02f, +2.348494782e-02f, +4.664594100e-03f, -1.112892671e-02f, -1.787125960e-02f, -1.526258854e-02f, -7.358849707e-03f, +6.217617216e-04f, +5.177196595e-03f, +5.658962910e-03f, +3.581509622e-03f, +1.050277901e-03f, -5.436727276e-04f, -9.380241521e-04f, -6.242388136e-04f,
    +1.403378090e-05f, +7.386342037e-06f, -1.968524855e-05f, -5.928084880e-05f, -8.315374743e-05f, -5.519988007e-05f, +4.068628472e-05f, +1.741930608e-04f, +2.672343829e-04f, +2.305694545e-04f, +2.558337091e-05f, -2.863978978e-04f, -5.485808445e-04f, -5.815823955e-04f, -2.940542028e-04f, +2.345280409e-04f, +7.611969468e-04f, +9.919069428e-04f, +7.472717518e-04f, +8.629868392e-05f, -6.946277381e-04f, -1.202412830e-03f, -1.157542210e-03f, -5.553038192e-04f, +3.191904429e-04f, +1.036876048e-03f, +1.251752275e-03f, +8.809978815e-04f, +1.380978459e-04f, -5.943485240e-04f, -9.735930579e-04f, -8.672616412e-04f, -3.959442215e-04f, +1.617126870e-04f, +5.332150490e-04f, +5.875442840e-04f, +3.733859286e-04f, +5.671396693e-05f, -1.893651790e-04f, -2.731866196e-04f, -2.085744781e-04f, -7.707939839e-05f, +3.479815397e-05f, +8.186807367e-05f, +6.919226211e-05f, +3.042793978e-05f, -1.878131958e-06f, -1.394750936e-05f,
    /*  3,21 (48) */
    +3.071689813e-04f, +3.096185918e-04f, -2.982690335e-05f, -7.971107451e-04f, -1.825812007e-03f, -2.639065481e-03f, -2.559264899e-03f, -1.002091911e-03f, +2.130057076e-03f, +6.131942559e-03f, +9.461523815e-03f, +1.012253612e-02f, +6.435988572e-03f, -2.024532636e-03f, -1.370457366e-02f, -2.493030813e-02f, -3.058515366e-02f, -2.553616634e-02f, -6.424125913e-03f, +2.678637751e-02f, +7.010759467e-02f, +1.160564163e-01f, +1.553775820e-01f, +1.794948048e-01f, +1.829281075e-01f, +1.648857534e-01f, +1.294967058e-01f, +8.460497356e-02f, +3.953196621e-02f, +2.546767761e-03f, -2.115284478e-02f, -3.036669942e-02f, -2.755276549e-02f, -1.748375780e-02f, -5.462021293e-03f, +4.275468126e-03f, +9.490721792e-03f, +1.004848879e-02f, +7.335210573e-03f, +3.344772793e-03f, -1.770962881e-04f, -2.249215493e-03f, -2.742849813e-03f, -2.132969303e-03f, -1.106957641e-03f, -2.253839647e-04f, +2.479149956e-04f, +3.334001891e-04f,
    -3.503474237e-06f, +4.200102517e-06f, +1.715514875e-05f, +2.960786843e-05f, +3.209675012e-05f, +1.557111780e-05f, -2.264603142e-05f, -7.382303112e-05f, -1.170205588e-04f, -1.246957586e-04f, -7.418873365e-05f, +3.866403314e-05f, +1.897907297e-04f, +3.268928558e-04f, +3.820769545e-04f, +2.949337063e-04f, +3.874500880e-05f, -3.603862744e-04f, -8.206343697e-04f, -1.221794714e-03f, -1.439351461e-03f, -1.384719120e-03f, -1.037594893e-03f, -4.581150677e-04f, +2.268002720e-04f, +8.593182563e-04f, +1.297010470e-03f, +1.453953477e-03f, +1.322897423e-03f, +9.717943669e-04f, +5.172508300e-04f, +8.538364049e-05f, -2.258359200e-04f, -3.704699399e-04f, -3.585741237e-04f, -2.417971359e-04f, -8.841678412e-05f, +4.185455463e-05f, +1.146197461e-04f, +1.250479701e-04f, +9.091750758e-05f, +3.960400736e-05f, -4.710772911e-06f, -2.888979521e-05f, -3.210811875e-05f, -2.192081377e-05f, -8.248699053e-06f, +1.599691615e-06f,
    -4.974250194e-04f, -8.922906129e-04f, -7.631355045e-04f, +4.759157193e-04f, +2.834867234e-03f, +5.239601520e-03f, +5.686999382e-03f, +2.330134864e-03f, -4.921452657e-03f, -1.334200010e-02f, -1.796446805e-02f, -1.405885484e-02f, -4.436451405e-04f, +1.842447907e-02f, +3.341942660e-02f, +3.501651484e-02f, +1.893695716e-02f, -1.012038812e-02f, -3.938880352e-02f, -5.386465680e-02f, -4.431509443e-02f, -1.301032825e-02f, +2.640562977e-02f, +5.533735579e-02f, +5.972305630e-02f, +3.741038433e-02f, -7.045037083e-04f, -3.641725358e-02f, -5.360989162e-02f, -4.612075618e-02f, -1.997745950e-02f, +1.077452804e-02f, +3.186175622e-02f, +3.571167518e-02f, +2.401816287e-02f, +5.252138384e-03f, -1.075554078e-02f, -1.781454564e-02f, -1.545195372e-02f, -7.632036327e-03f, +4.131872435e-04f, +5.100117196e-03f, +5.693761064e-03f, +3.663377696e-03f, +1.119470163e-03f, -5.132447878e-04f, -9.399022841e-04f, -6.381863229e-04f,
    +1.397558619e-05f, +7.891192903e-06f, -1.855379262e-05f, -5.809134268e-05f, -8.302209420e-05f, -5.711713924e-05f, +3.682269594e-05f, +1.701413919e-04f, +2.658873395e-04f, +2.342867362e-04f, +3.421361529e-05f, -2.764212891e-04f, -5.430313600e-04f, -5.853147382e-04f, -3.075862399e-04f, +2.164807795e-04f, +7.478081370e-04f, +9.914919407e-04f, +7.622130399e-04f, +1.107658511e-04f, -6.723823597e-04f, -1.194052169e-03f, -1.168174171e-03f, -5.803171765e-04f, +2.919748629e-04f, +1.020806642e-03f, +1.254286383e-03f, +8.999610301e-04f, +1.632684572e-04f, -5.754372713e-04f, -9.690851856e-04f, -8.772975004e-04f, -4.135911510e-04f, +1.459485814e-04f, +5.262040092e-04f, +5.905697532e-04f, +3.826297553e-04f, +6.629717269e-05f, -1.839368776e-04f, -2.731218630e-04f, -2.121076666e-04f, -8.126626625e-05f, +3.218712466e-05f, +8.143335712e-05f, +7.018346438e-05f, +3.167144923e-05f, -1.158790106e-06f, -1.386332733e-05f,
    /*  3,22 (48) */
    +3.036655070e-04f, +3.138186943e-04f, -1.267175460e-05f, -7.675028767e-04f, -1.793715256e-03f, -2.623494363e-03f, -2.581910930e-03f, -1.075914942e-03f, +2.013036517e-03f, +6.007246800e-03f, +9.387335081e-03f, +1.016120015e-02f, +6.625779301e-03f, -1.697639780e-03f, -1.332249670e-02f, -2.463537442e-02f, -3.054640865e-02f, -2.589655261e-02f, -7.244760282e-03f, +2.556458280e-02f, +6.866824321e-02f, +1.146716972e-01f, +1.543399871e-01f, +1.790366898e-01f, +1.831549078e-01f, +1.657450717e-01f, +1.307937162e-01f, +8.605892704e-02f, +4.085486363e-02f, +3.518562128e-03f, -2.063559395e-02f, -3.028131578e-02f, -2.777860141e-02f, -1.785422774e-02f, -5.820595416e-03f, +4.033670990e-03f, +9.402305008e-03f, +1.009034335e-02f, +7.449830319e-03f, +3.469820763e-03f, -8.617878055e-05f, -2.209611485e-03f, -2.747560586e-03f, -2.161859098e-03f, -1.139065760e-03f, -2.473047785e-04f, +2.396662965e-04f, +3.349998807e-04f,
    -3.637854360e-06f, +3.863079261e-06f, +1.671572506e-05f, +2.931565927e-05f, +3.226954245e-05f, +1.642741121e-05f, -2.117666142e-05f, -7.220932865e-05f, -1.160633002e-04f, -1.252524243e-04f, -7.675520442e-05f, +3.435414183e-05f, +1.849486176e-04f, +3.234865456e-04f, +3.822527779e-04f, +3.001987772e-04f, +4.920039709e-05f, -3.464359449e-04f, -8.064679161e-04f, -1.211440714e-03f, -1.436361328e-03f, -1.390954474e-03f, -1.052471054e-03f, -4.786053506e-04f, +2.053589224e-04f, +8.418692126e-04f, +1.287326252e-03f, +1.453580330e-03f, +1.330838993e-03f, +9.850063393e-04f, +5.317305164e-04f, +9.744490656e-05f, -2.185427537e-04f, -3.685009711e-04f, -3.608731577e-04f, -2.463571875e-04f, -9.311727215e-05f, +3.855295216e-05f, +1.133339535e-04f, +1.255284079e-04f, +9.238995567e-05f, +4.120392496e-05f, -3.595844583e-06f, -2.847458756e-05f, -3.226215150e-05f, -2.234077122e-05f, -8.644492266e-06f, +1.387406987e-06f,
    -4.834494332e-04f, -8.843994200e-04f, -7.816892972e-04f, +4.178243766e-04f, +2.751845140e-03f, +5.182484381e-03f, +5.723822078e-03f, +2.500276256e-03f, -4.655565318e-03f, -1.310771336e-02f, -1.793025443e-02f, -1.433527613e-02f, -9.866765005e-04f, +1.783916434e-02f, +3.311184036e-02f, +3.523299562e-02f, +1.968476530e-02f, -9.128896180e-03f, -3.862659048e-02f, -5.375389095e-02f, -4.498747679e-02f, -1.420438042e-02f, +2.523745560e-02f, +5.475703861e-02f, +6.001503116e-02f, +3.843119097e-02f, +5.497826750e-04f, -3.551729255e-02f, -5.344662316e-02f, -4.669619345e-02f, -2.094654469e-02f, +9.897230542e-03f, +3.144816507e-02f, +3.585762376e-02f, +2.454436688e-02f, +5.842708137e-03f, -1.037291103e-02f, -1.774824846e-02f, -1.563589059e-02f, -7.905158190e-03f, +2.010795769e-04f, +5.018850930e-03f, +5.725948188e-03f, +3.744811053e-03f, +1.189653627e-03f, -4.815733386e-04f, -9.410610742e-04f, -6.520496503e-04f,
    +1.390524188e-05f, +8.374829719e-06f, -1.743698814e-05f, -5.688846585e-05f, -8.283925787e-05f, -5.896394766e-05f, +3.300195016e-05f, +1.660544062e-04f, +2.644118708e-04f, +2.378308219e-04f, +4.272719737e-05f, -2.664042772e-04f, -5.372556494e-04f, -5.887197505e-04f, -3.208629886e-04f, +1.984458425e-04f, +7.341290765e-04f, +9.905944033e-04f, +7.767208785e-04f, +1.350951634e-04f, -6.498723961e-04f, -1.185132988e-03f, -1.178231646e-03f, -6.050395244e-04f, +2.646124904e-04f, +1.004230662e-03f, +1.256220314e-03f, +9.185355443e-04f, +1.884402431e-04f, -5.561707202e-04f, -9.640809589e-04f, -8.869560984e-04f, -4.311449117e-04f, +1.299969664e-04f, +5.188686224e-04f, +5.933189432e-04f, +3.917671351e-04f, +7.595217688e-05f, -1.783419554e-04f, -2.729044808e-04f, -2.155723173e-04f, -8.547385565e-05f, +2.950891663e-05f, +8.093707251e-05f, +7.114822141e-05f, +3.292223457e-05f, -4.181563958e-07f, -1.376291828e-05f,
    /*  3,23 (48) */
    +3.000276527e-04f, +3.176817736e-04f, +4.043970461e-06f, -7.381872174e-04f, -1.761445714e-03f, -2.607066952e-03f, -2.603087592e-03f, -1.148124270e-03f, +1.896973217e-03f, +5.881994376e-03f, +9.310579877e-03f, +1.019555429e-02f, +6.810727919e-03f, -1.374153235e-03f, -1.294024393e-02f, -2.433517564e-02f, -3.049720825e-02f, -2.624298856e-02f, -8.051228198e-03f, +2.435314209e-02f, +6.723188188e-02f, +1.132807427e-01f, +1.532875161e-01f, +1.785580844e-01f, +1.833602667e-01f, +1.665869409e-01f, +1.320810425e-01f, +8.751250737e-02f, +4.218570262e-02f, +4.503568467e-03f, -2.010386343e-02f, -3.018387087e-02f, -2.799714417e-02f, -1.822272871e-02f, -6.181468574e-03f, +3.787313803e-03f, +9.309187736e-03f, +1.012889630e-02f, +7.563164272e-03f, +3.595349171e-03f, +6.211175117e-06f, -2.168407560e-03f, -2.751156430e-03f, -2.190333686e-03f, -1.171327911e-03f, -2.696455497e-04f, +2.310218043e-04f, +3.363872877e-04f,
    -3.765928427e-06f, +3.531699954e-06f, +1.627639872e-05f, +2.901403414e-05f, +3.242346883e-05f, +1.726148731e-05f, -1.972147714e-05f, -7.058924562e-05f, -1.150718556e-04f, -1.257512449e-04f, -7.925814052e-05f, +3.008526632e-05f, +1.800961712e-04f, +3.200018341e-04f, +3.822883300e-04f, +3.052944180e-04f, +5.950975647e-05f, -3.325518869e-04f, -7.922482224e-04f, -1.200907975e-03f, -1.433101487e-03f, -1.396896783e-03f, -1.067111595e-03f, -4.989853661e-04f, +1.838700421e-04f, +8.242288710e-04f, +1.277362709e-03f, +1.452918539e-03f, +1.338558509e-03f, +9.981125244e-04f, +5.462311107e-04f, +1.096261208e-04f, -2.110826698e-04f, -3.663745517e-04f, -3.630663859e-04f, -2.508801606e-04f, -9.784099981e-05f, +3.519325555e-05f, +1.119851055e-04f, +1.259637630e-04f, +9.384506926e-05f, +4.281104231e-05f, -2.460396421e-06f, -2.803806407e-05f, -3.240260206e-05f, -2.275727877e-05f, -9.044283303e-06f, +1.168558256e-06f,
    -4.695441913e-04f, -8.760245903e-04f, -7.991262853e-04f, +3.609359108e-04f, +2.669005882e-03f, +5.123520433e-03f, +5.756824028e-03f, +2.666330662e-03f, -4.391153447e-03f, -1.286988254e-02f, -1.788752723e-02f, -1.460168041e-02f, -1.523932150e-03f, +1.725044458e-02f, +3.279097737e-02f, +3.543144146e-02f, +2.041889438e-02f, -8.138301776e-03f, -3.784986960e-02f, -5.361879579e-02f, -4.563734919e-02f, -1.538951341e-02f, +2.405922395e-02f, +5.415199909e-02f, +6.027964365e-02f, +3.943542163e-02f, +1.806002989e-03f, -3.459875701e-02f, -5.325818292e-02f, -4.725236417e-02f, -2.191062565e-02f, +9.010274443e-03f, +3.101702015e-02f, +3.598762072e-02f, +2.506323550e-02f, +6.436027081e-03f, -9.981143894e-03f, -1.767229629e-02f, -1.581423255e-02f, -8.178062671e-03f, -1.449274037e-05f, +4.933377074e-03f, +5.755457105e-03f, +3.825748126e-03f, +1.260801849e-03f, -4.486511040e-04f, -9.414792306e-04f, -6.658125686e-04f,
    +1.382314016e-05f, +8.837361929e-06f, -1.633537227e-05f, -5.567335481e-05f, -8.260631152e-05f, -6.074030726e-05f, +2.922575262e-05f, +1.619350567e-04f, +2.628105067e-04f, +2.412017540e-04f, +5.112063874e-05f, -2.563527416e-04f, -5.312588432e-04f, -5.917982521e-04f, -3.338793035e-04f, +1.804325406e-04f, +7.201684470e-04f, +9.892171113e-04f, +7.907896309e-04f, +1.592747329e-04f, -6.271099183e-04f, -1.175660842e-03f, -1.187710250e-03f, -6.294585642e-04f, +2.371170630e-04f, +9.871559923e-04f, +1.257552114e-03f, +9.367111105e-04f, +2.136004132e-04f, -5.365573630e-04f, -9.585806927e-04f, -8.962304303e-04f, -4.485957701e-04f, +1.138649555e-04f, +5.112102807e-04f, +5.957879751e-04f, +4.007920296e-04f, +8.567434117e-05f, -1.725816699e-04f, -2.725326564e-04f, -2.189653917e-04f, -8.969986767e-05f, +2.676414031e-05f, +8.037843185e-05f, +7.208531271e-05f, +3.417949566e-05f, +3.436649713e-07f, -1.364594403e-05f,
    /*  3,24 (48) */
    +2.962617242e-04f, +3.212134736e-04f, +2.032036918e-05f, -7.091731833e-04f, -1.729022245e-03f, -2.589805465e-03f, -2.622809069e-03f, -1.218713516e-03f, +1.781901362e-03f, +5.756243131e-03f, +9.231321737e-03f, +1.022563956e-02f, +6.990824090e-03f, -1.054151401e-03f, -1.255795560e-02f, -2.402988123e-02f, -3.043769849e-02f, -2.657554044e-02f, -8.843476421e-03f, +2.315223411e-02f, +6.579878040e-02f, +1.118838460e-01f, +1.522204045e-01f, +1.780590990e-01f, +1.835441367e-01f, +1.674111697e-01f, +1.333584052e-01f, +8.896542591e-02f, +4.352426113e-02f, +5.501680991e-03f, -1.955763232e-02f, -3.007424475e-02f, -2.820822684e-02f, -1.858910326e-02f, -6.544534960e-03f, +3.536433642e-03f, +9.211346736e-03f, +1.016408956e-02f, +7.675149378e-03f, +3.721312934e-03f, +1.000562444e-04f, -2.125596518e-03f, -2.753616827e-03f, -2.218371750e-03f, -1.203730513e-03f, -2.924028285e-04f, +2.219775210e-04f, +3.375558459e-04f,
    -3.887741319e-06f, +3.206055989e-06f, +1.583741601e-05f, +2.870331762e-05f, +3.255876525e-05f, +1.807329880e-05f, -1.828092849e-05f, -6.896357953e-05f, -1.140471018e-04f, -1.261927572e-04f, -8.169732682e-05f, +2.585857515e-05f, +1.752353437e-04f, +3.164408930e-04f, +3.821851813e-04f, +3.102208145e-04f, +6.967147102e-05f, -3.187373323e-04f, -7.779793207e-04f, -1.190200104e-03f, -1.429573887e-03f, -1.402545559e-03f, -1.081513561e-03f, -5.192504775e-04f, +1.623385964e-04f, +8.064010613e-04f, +1.267121457e-03f, +1.451967164e-03f, +1.346052953e-03f, +1.011108915e-03f, +5.607488983e-04f, +1.219248981e-04f, -2.034562514e-04f, -3.640896352e-04f, -3.651517933e-04f, -2.553639164e-04f, -1.025864097e-04f, +3.177609154e-05f, +1.105729513e-04f, +1.263532515e-04f, +9.528197147e-05f, +4.442473797e-05f, -1.304645589e-06f, -2.758009056e-05f, -3.252916038e-05f, -2.317004037e-05f, -9.447910213e-06f, +9.431530473e-07f,
    -4.557210512e-04f, -8.671872283e-04f, -8.154616576e-04f, +3.052625560e-04f, +2.586399571e-03f, +5.062780126e-03f, +5.786049781e-03f, +2.828265719e-03f, -4.128342940e-03f, -1.262868078e-02f, -1.783640660e-02f, -1.485803315e-02f, -2.055190993e-03f, +1.665864633e-02f, +3.245709807e-02f, +3.561187401e-02f, +2.113906282e-02f, -7.149084665e-03f, -3.705907997e-02f, -5.345952105e-02f, -4.626445911e-02f, -1.656517425e-02f, +2.287151370e-02f, +5.352254052e-02f, +6.051676072e-02f, +4.042257762e-02f, +3.063555103e-03f, -3.366204590e-02f, -5.304458251e-02f, -4.778892153e-02f, -2.286920634e-02f, +8.114044013e-03f, +3.056842438e-02f, +3.610148568e-02f, +2.557444578e-02f, +7.031815056e-03f, -9.580351865e-03f, -1.758662195e-02f, -1.598681422e-02f, -8.450595327e-03f, -2.334581321e-04f, +4.843677207e-03f, +5.782221245e-03f, +3.906126557e-03f, +1.332887162e-03f, -4.144716084e-04f, -9.411355656e-04f, -6.794585126e-04f,
    +1.372967500e-05f, +9.278914423e-06f, -1.524945968e-05f, -5.444713427e-05f, -8.232434518e-05f, -6.244626716e-05f, +2.549575523e-05f, +1.577862775e-04f, +2.610858231e-04f, +2.443996772e-04f, +5.939056664e-05f, -2.462725265e-04f, -5.250461533e-04f, -5.945512379e-04f, -3.466302178e-04f, +1.624501163e-04f, +7.059350357e-04f, +9.873630894e-04f, +8.044139162e-04f, +1.832927891e-04f, -6.041071003e-04f, -1.165641565e-03f, -1.196605909e-03f, -6.535621626e-04f, +2.095023907e-04f, +9.695907853e-04f, +1.258280144e-03f, +9.544776028e-04f, +2.387361456e-04f, -5.166059077e-04f, -9.525849697e-04f, -9.051136635e-04f, -4.659339923e-04f, +9.755980851e-05f, +5.032305666e-04f, +5.979730964e-04f, +4.096984102e-04f, +9.545894178e-05f, -1.666573908e-04f, -2.720046459e-04f, -2.222838567e-04f, -9.394195902e-05f, +2.395346008e-05f, +7.975667761e-05f, +7.299351605e-05f, +3.544241166e-05f, +1.126549914e-06f, -1.351207367e-05f,
    /*  3,25 (48) */
    +2.923739829e-04f, +3.244195295e-04f, +3.615778519e-05f, -6.804698657e-04f, -1.696463480e-03f, -2.571732166e-03f, -2.641089998e-03f, -1.287677096e-03f, +1.667854260e-03f, +5.630050374e-03f, +9.149624410e-03f, +1.025149813e-02f, +7.166059434e-03f, -7.377105075e-04f, -1.217577041e-02f, -2.371966041e-02f, -3.036802702e-02f, -2.689427778e-02f, -9.621455742e-03f, +2.196203401e-02f, +6.436920651e-02f, +1.104813004e-01f, +1.511388909e-01f, +1.775398486e-01f, +1.837064753e-01f, +1.682175708e-01f, +1.346255266e-01f, +9.041739307e-02f, +4.487031408e-02f, +6.512789906e-03f, -1.899688343e-02f, -2.995231985e-02f, -2.841168309e-02f, -1.895319289e-02f, -6.909686753e-03f, +3.281069726e-03f, +9.108760326e-03f, +1.019586565e-02f, +7.785722329e-03f, +3.847666186e-03f, +1.953382158e-04f, -2.081171780e-03f, -2.754921472e-03f, -2.245951840e-03f, -1.236259674e-03f, -3.155728688e-04f, +2.125296108e-04f, +3.384989990e-04f,
    -4.003341125e-06f, +2.886233797e-06f, +1.539901900e-05f, +2.838383397e-05f, +3.267567353e-05f, +1.886280976e-05f, -1.685545253e-05f, -6.733312003e-05f, -1.129899195e-04f, -1.265775157e-04f, -8.407257635e-05f, +2.167520746e-05f, +1.703680708e-04f, +3.128058986e-04f, +3.819449340e-04f, +3.149782048e-04f, +7.968398176e-05f, -3.049954720e-04f, -7.636652355e-04f, -1.179320741e-03f, -1.425780546e-03f, -1.407900393e-03f, -1.095674065e-03f, -5.393960823e-04f, +1.407695631e-04f, +7.883896686e-04f, +1.256604192e-03f, +1.450725344e-03f, +1.353319360e-03f, +1.023991514e-03f, +5.752801377e-04f, +1.343388010e-04f, -1.956641385e-04f, -3.616452175e-04f, -3.671273824e-04f, -2.598063079e-04f, -1.073519189e-04f, +2.830211710e-05f, +1.090972631e-04f, +1.266960993e-04f, +9.669978219e-05f, +4.604437911e-05f, -1.288219903e-07f, -2.710054154e-05f, -3.264151887e-05f, -2.357875726e-05f, -9.855206040e-06f, +7.112032361e-07f,
    -4.419913762e-04f, -8.579083139e-04f, -8.307111173e-04f, +2.508154217e-04f, +2.504075226e-03f, +5.000333859e-03f, +5.811545536e-03f, +2.986051997e-03f, -3.867257117e-03f, -1.238428111e-02f, -1.777701603e-02f, -1.510430567e-02f, -2.580237146e-03f, +1.606409509e-02f, +3.211046785e-02f, +3.577432412e-02f, +2.184499786e-02f, -6.161721576e-03f, -3.625466605e-02f, -5.327622826e-02f, -4.686856621e-02f, -1.773081582e-02f, +2.167490780e-02f, +5.286897836e-02f, +6.072626311e-02f, +4.139216841e-02f, +4.321835247e-03f, -3.270756830e-02f, -5.280584636e-02f, -4.830552744e-02f, -2.382179131e-02f, +7.208930350e-03f, +3.010249039e-02f, +3.619904549e-02f, +2.607767635e-02f, +7.629788152e-03f, -9.170653454e-03f, -1.749116300e-02f, -1.615347161e-02f, -8.722599973e-03f, -4.557419887e-04f, +4.749735248e-03f, +5.806174705e-03f, +3.985883235e-03f, +1.405880678e-03f, -3.790291967e-04f, -9.400090157e-04f, -6.929705863e-04f,
    +1.362524182e-05f, +9.699627145e-06f, -1.417974247e-05f, -5.321091650e-05f, -8.199446477e-05f, -6.408192298e-05f, +2.181355622e-05f, +1.536109821e-04f, +2.592404393e-04f, +2.474248378e-04f, +6.753371491e-05f, -2.361694382e-04f, -5.186228688e-04f, -5.969798764e-04f, -3.591109445e-04f, +1.445077386e-04f, +6.914377299e-04f, +9.850356039e-04f, +8.175886110e-04f, +2.071376851e-04f, -5.808762122e-04f, -1.155081271e-03f, -1.204914861e-03f, -6.773383576e-04f, +1.817823486e-04f, +9.515434587e-04f, +1.258403080e-03f, +9.718250891e-04f, +2.638345942e-04f, -4.963252740e-04f, -9.460946405e-04f, -9.135991424e-04f, -4.831498493e-04f, +8.108892828e-05f, +4.949312534e-04f, +5.998706843e-04f, +4.184802618e-04f, +1.053011715e-04f, -1.605706006e-04f, -2.713187798e-04f, -2.255246866e-04f, -9.819774306e-05f, +2.107759459e-05f, +7.907108373e-05f, +7.387160839e-05f, +3.671014137e-05f, +1.930354200e-06f, -1.336098404e-05f,
    /*  3,26 (48) */
    +2.883706418e-04f, +3.273057633e-04f, +5.155680418e-05f, -6.520860317e-04f, -1.663787806e-03f, -2.552869356e-03f, -2.657945450e-03f, -1.355010216e-03f, +1.554864340e-03f, +5.503472858e-03f, +9.065551833e-03f, +1.027317334e-02f, +7.336427504e-03f, -4.249046089e-04f, -1.179382548e-02f, -2.340468221e-02f, -3.028834304e-02f, -2.719927325e-02f, -1.038512098e-02f, +2.078271327e-02f, +6.294342596e-02f, +1.090734000e-01f, +1.500432169e-01f, +1.770004525e-01f, +1.838472449e-01f, +1.690059605e-01f, +1.358821308e-01f, +9.186811842e-02f, +4.622363344e-02f, +7.536781420e-03f, -1.842160329e-02f, -2.981798105e-02f, -2.860734723e-02f, -1.931483811e-02f, -7.276814136e-03f, +3.021263418e-03f, +9.001408407e-03f, +1.022416777e-02f, +7.894819592e-03f, +3.974362285e-03f, +2.920379980e-04f, -2.035127401e-03f, -2.755050294e-03f, -2.273052382e-03f, -1.268901192e-03f, -3.391516261e-04f, +2.026744047e-04f, +3.392102022e-04f,
    -4.112779054e-06f, +2.572314865e-06f, +1.496144545e-05f, +2.805590700e-05f, +3.277444107e-05f, +1.962999545e-05f, -1.544547346e-05f, -6.569864863e-05f, -1.119011921e-04f, -1.269060919e-04f, -8.638373006e-05f, +1.753627284e-05f, +1.654962695e-04f, +3.090990316e-04f, +3.815692209e-04f, +3.195668788e-04f, +8.954578688e-05f, -2.913294552e-04f, -7.493099823e-04f, -1.168273555e-03f, -1.421723547e-03f, -1.412960956e-03f, -1.109590290e-03f, -5.594176131e-04f, +1.191679313e-04f, +7.701986314e-04f, +1.245812685e-03f, +1.449192291e-03f, +1.360354815e-03f, +1.036756339e-03f, +5.898210613e-04f, +1.468653409e-04f, -1.877070282e-04f, -3.590403383e-04f, -3.689911742e-04f, -2.642051807e-04f, -1.121359191e-04f, +2.477201947e-05f, +1.075578371e-04f, +1.269915428e-04f, +9.809761845e-05f, +4.766932167e-05f, +1.066831678e-06f, -2.659930036e-05f, -3.273937254e-05f, -2.398312798e-05f, -1.026599884e-05f, +4.727250007e-07f,
    -4.283661344e-04f, -8.482086868e-04f, -8.448908597e-04f, +1.976045052e-04f, +2.422080761e-03f, +4.936251936e-03f, +5.833359092e-03f, +3.139662979e-03f, -3.608016678e-03f, -1.213685627e-02f, -1.770948231e-02f, -1.534047511e-02f, -3.098860015e-03f, +1.546711522e-02f, +3.175135691e-02f, +3.591883186e-02f, +2.253643559e-02f, -5.176685972e-03f, -3.543707744e-02f, -5.306909058e-02f, -4.744944242e-02f, -1.888589709e-02f, +2.046999293e-02f, +5.219164000e-02f, +6.090804546e-02f, +4.234371187e-02f, +5.580238328e-03f, -3.173574321e-02f, -5.254201177e-02f, -4.880185272e-02f, -2.476788595e-02f, +6.295331207e-03f, +2.961934054e-02f, +3.628013442e-02f, +2.657260760e-02f, +8.229658837e-03f, -8.752173193e-03f, -1.738586183e-02f, -1.631404221e-02f, -8.993918753e-03f, -6.812666753e-04f, +4.651537505e-03f, +5.827252300e-03f, +4.064954319e-03f, +1.479752286e-03f, -3.423190553e-04f, -9.380786615e-04f, -7.063315703e-04f,
    +1.351023705e-05f, +1.009965468e-05f, -1.312669022e-05f, -5.196580074e-05f, -8.161779110e-05f, -6.564741609e-05f, +1.818069976e-05f, +1.494120619e-04f, +2.572770162e-04f, +2.502775821e-04f, +7.554692499e-05f, -2.260492410e-04f, -5.119943527e-04f, -5.990855072e-04f, -3.713168784e-04f, +1.266144987e-04f, +6.766855115e-04f, +9.822381595e-04f, +8.303088519e-04f, +2.307979033e-04f, -5.574296133e-04f, -1.143986344e-03f, -1.212633655e-03f, -7.007753656e-04f, +1.539708695e-04f, +9.330226906e-04f, +1.257919916e-03f, +9.887438369e-04f, +2.888828959e-04f, -4.757245889e-04f, -9.391108251e-04f, -9.216803928e-04f, -5.002336227e-04f, +6.445985719e-05f, +4.863143052e-04f, +6.014772487e-04f, +4.271315862e-04f, +1.151961420e-04f, -1.543228943e-04f, -2.704734651e-04f, -2.286848653e-04f, -1.024647908e-04f, +1.813731700e-05f, +7.832095665e-05f, +7.471836679e-05f, +3.798182344e-05f, +2.754913188e-06f, -1.319236015e-05f,
    /*  3,27 (48) */
    +2.842578627e-04f, +3.298780782e-04f, +6.651824963e-05f, -6.240301247e-04f, -1.631013365e-03f, -2.533239361e-03f, -2.673390924e-03f, -1.420708864e-03f, +1.442963148e-03f, +5.376566766e-03f, +8.979168103e-03f, +1.029070961e-02f, +7.501923774e-03f, -1.158055773e-04f, -1.141225626e-02f, -2.308511533e-02f, -3.019879725e-02f, -2.749060270e-02f, -1.113443096e-02f, +1.961443971e-02f, +6.152170242e-02f, +1.076604390e-01f, +1.489336266e-01f, +1.764410349e-01f, +1.839664128e-01f, +1.697761591e-01f, +1.371279435e-01f, +9.331731071e-02f, +4.758398826e-02f, +8.573537759e-03f, -1.783178223e-02f, -2.967111571e-02f, -2.879505426e-02f, -1.967387845e-02f, -7.645805310e-03f, +2.757058237e-03f, +8.889272488e-03f, +1.024893978e-02f, +8.002377430e-03f, +4.101353828e-03f, +3.901356165e-04f, -1.987458079e-03f, -2.753983463e-03f, -2.299651682e-03f, -1.301640565e-03f, -3.631347541e-04f, +1.924084059e-04f, +3.396829272e-04f,
    -4.216109366e-06f, +2.264375771e-06f, +1.452492876e-05f, +2.771985991e-05f, +3.285532073e-05f, +2.037484222e-05f, -1.405140252e-05f, -6.406093845e-05f, -1.107818055e-04f, -1.271790738e-04f, -8.863065662e-05f, +1.344285118e-05f, +1.606218381e-04f, +3.053224756e-04f, +3.810597053e-04f, +3.239871777e-04f, +9.925544176e-05f, -2.777423880e-04f, -7.349175668e-04f, -1.157062250e-03f, -1.417405042e-03f, -1.417727002e-03f, -1.123259489e-03f, -5.793105393e-04f, +9.753869981e-05f, +7.518319412e-04f, +1.234748787e-03f, +1.447367298e-03f, +1.367156457e-03f, +1.049399420e-03f, +6.043678766e-04f, +1.595019776e-04f, -1.795856748e-04f, -3.562740812e-04f, -3.707412088e-04f, -2.685583734e-04f, -1.169367772e-04f, +2.118651621e-05f, +1.059544931e-04f, +1.272388292e-04f, +9.947459474e-05f, +4.929891051e-05f, +2.282059878e-06f, -2.607625943e-05f, -3.282241924e-05f, -2.438284863e-05f, -1.068011173e-05f, +2.277388815e-07f,
    -4.148558973e-04f, -8.381090321e-04f, -8.580175499e-04f, +1.456387045e-04f, +2.340462970e-03f, +4.870604520e-03f, +5.851539792e-03f, +3.289075041e-03f, -3.350739662e-03f, -1.188657869e-02f, -1.763393539e-02f, -1.556652435e-02f, -3.610854368e-03f, +1.486802971e-02f, +3.138004003e-02f, +3.604544636e-02f, +2.321312110e-02f, -4.194447812e-03f, -3.460676859e-02f, -5.283829268e-02f, -4.800687203e-02f, -2.002988343e-02f, +1.925735928e-02f, +5.149086464e-02f, +6.106201633e-02f, +4.327673456e-02f, +6.838158244e-03f, -3.074699937e-02f, -5.225312887e-02f, -4.927757730e-02f, -2.570699678e-02f, +5.373650814e-03f, +2.911910692e-02f, +3.634459427e-02f, +2.705892191e-02f, +8.831136085e-03f, -8.325041607e-03f, -1.727066569e-02f, -1.646836510e-02f, -9.264392218e-03f, -9.099515406e-04f, +4.549072714e-03f, +5.845389617e-03f, +4.143275275e-03f, +1.554470653e-03f, -3.043372319e-04f, -9.353237483e-04f, -7.195239305e-04f,
    +1.338505782e-05f, +1.047916587e-05f, -1.209074997e-05f, -5.071287250e-05f, -8.119545879e-05f, -6.714293286e-05f, +1.459867564e-05f, +1.451923846e-04f, +2.551982542e-04f, +2.529583551e-04f, +8.342714677e-05f, -2.159176551e-04f, -5.051660376e-04f, -6.008696396e-04f, -3.832435974e-04f, +1.087794048e-04f, +6.616874512e-04f, +9.789744964e-04f, +8.425700365e-04f, +2.542620618e-04f, -5.337797449e-04f, -1.132363442e-03f, -1.219759154e-03f, -7.238615871e-04f, +1.260819359e-04f, +9.140374150e-04f, +1.256829962e-03f, +1.005224319e-03f, +3.138681769e-04f, -4.548131826e-04f, -9.316349126e-04f, -9.293511264e-04f, -5.171756103e-04f, +4.768027379e-05f, +4.773818773e-04f, +6.027894352e-04f, +4.356464065e-04f, +1.251388857e-04f, -1.479159801e-04f, -2.694671867e-04f, -2.317613882e-04f, -1.067406320e-04f, +1.513345528e-05f, +7.750563625e-05f, +7.553256929e-05f, +3.925657677e-05f, +3.600041585e-06f, -1.300589560e-05f,
    /*  3,28 (48) */
    +2.800417534e-04f, +3.321424540e-04f, +8.104317839e-05f, -5.963102648e-04f, -1.598158045e-03f, -2.512864519e-03f, -2.687442326e-03f, -1.484769803e-03f, +1.332181343e-03f, +5.249387692e-03f, +8.890537447e-03f, +1.030415246e-02f, +7.662545612e-03f, +1.895168983e-04f, -1.103119655e-02f, -2.276112815e-02f, -3.009954181e-02f, -2.776834509e-02f, -1.186934853e-02f, +1.845737746e-02f, +6.010429737e-02f, +1.062427120e-01f, +1.478103671e-01f, +1.758617243e-01f, +1.840639515e-01f, +1.705279911e-01f, +1.383626923e-01f, +9.476467801e-02f, +4.895114472e-02f, +9.622937179e-03f, -1.722741435e-02f, -2.951161373e-02f, -2.897463993e-02f, -2.003015253e-02f, -8.016546519e-03f, +2.488499864e-03f, +8.772335711e-03f, +1.027012630e-02f, +8.108331923e-03f, +4.228592657e-03f, +4.896102112e-04f, -1.938159169e-03f, -2.751701403e-03f, -2.325727942e-03f, -1.334462984e-03f, -3.875176027e-04f, +1.817282941e-04f, +3.399106661e-04f,
    -4.313389282e-06f, +1.962488206e-06f, +1.408969792e-05f, +2.737601512e-05f, +3.291857052e-05f, +2.109734737e-05f, -1.267363801e-05f, -6.242075398e-05f, -1.096326479e-04f, -1.273970654e-04f, -9.081325215e-05f, +9.395992526e-06f, +1.557466555e-04f, +3.014784169e-04f, +3.804180795e-04f, +3.282394937e-04f, +1.088115592e-04f, -2.642373334e-04f, -7.204919830e-04f, -1.145690556e-03f, -1.412827242e-03f, -1.422198365e-03f, -1.136678987e-03f, -5.990703682e-04f, +7.588687551e-05f, +7.332936410e-04f, +1.223414427e-03f, +1.445249734e-03f, +1.373721479e-03f, +1.061916802e-03f, +6.189167668e-04f, +1.722461206e-04f, -1.713008898e-04f, -3.533455744e-04f, -3.723755467e-04f, -2.728637187e-04f, -1.217528356e-04f, +1.754635521e-05f, +1.042870754e-04f, +1.274372170e-04f, +1.008298234e-04f, +5.093247959e-05f, +3.516594185e-06f, -2.553132036e-05f, -3.289035984e-05f, -2.477761287e-05f, -1.109736287e-05f, -2.373016503e-08f,
    -4.014708395e-04f, -8.276298662e-04f, -8.701082999e-04f, +9.492583196e-05f, +2.259267511e-03f, +4.803461587e-03f, +5.866138468e-03f, +3.434267425e-03f, -3.095541408e-03f, -1.163362033e-02f, -1.755050824e-02f, -1.578244201e-02f, -4.116020405e-03f, +1.426716007e-02f, +3.099679643e-02f, +3.615422576e-02f, +2.387480855e-02f, -3.215473316e-03f, -3.376419855e-02f, -5.258403061e-02f, -4.854065178e-02f, -2.116224687e-02f, +1.803760013e-02f, +5.076700305e-02f, +6.118809826e-02f, +4.419077197e-02f, +8.094988206e-03f, -2.974177505e-02f, -5.193926069e-02f, -4.973239049e-02f, -2.663863169e-02f, +4.444299688e-03f, +2.860193131e-02f, +3.639227455e-02f, +2.753630378e-02f, +9.433925520e-03f, -7.889395200e-03f, -1.714552680e-02f, -1.661628108e-02f, -9.533859405e-03f, -1.141712929e-03f, +4.442332082e-03f, +5.860523072e-03f, +4.220780912e-03f, +1.630003222e-03f, -2.650806551e-04f, -9.317237067e-04f, -7.325298261e-04f,
    +1.325010149e-05f, +1.083834336e-05f, -1.107234635e-05f, -4.945320309e-05f, -8.072861528e-05f, -6.856870388e-05f, +1.106891903e-05f, +1.409547922e-04f, +2.530068907e-04f, +2.554676994e-04f, +9.117143940e-05f, -2.057803530e-04f, -4.981434225e-04f, -6.023339503e-04f, -3.948868638e-04f, +9.101137782e-05f, +6.464527035e-04f, +9.752485870e-04f, +8.543678256e-04f, +2.775189198e-04f, -5.099391233e-04f, -1.120219483e-03f, -1.226288538e-03f, -7.465856134e-04f, +9.812957267e-05f, +8.945968170e-04f, +1.255132848e-03f, +1.021257219e-03f, +3.387775609e-04f, -4.336005838e-04f, -9.236685619e-04f, -9.366052454e-04f, -5.339661313e-04f, +3.075798926e-05f, +4.681363162e-04f, +6.038040284e-04f, +4.440187700e-04f, +1.351243585e-04f, -1.413516791e-04f, -2.682985099e-04f, -2.347512644e-04f, -1.110227562e-04f, +1.206689233e-05f, +7.662449684e-05f, +7.631299584e-05f, +4.053350083e-05f, +4.465533215e-06f, -1.280129310e-05f,
    /*  3,29 (48) */
    +2.757283641e-04f, +3.341049422e-04f, +9.513287631e-05f, -5.689342497e-04f, -1.565239474e-03f, -2.491767171e-03f, -2.700115964e-03f, -1.547190557e-03f, +1.222548695e-03f, +5.121990627e-03f, +8.799724195e-03f, +1.031354846e-02f, +7.818292268e-03f, +4.909953152e-04f, -1.065077847e-02f, -2.243288866e-02f, -2.999073025e-02f, -2.803258242e-02f, -1.258984051e-02f, +1.731168690e-02f, +5.869147013e-02f, +1.048205137e-01f, +1.466736881e-01f, +1.752626540e-01f, +1.841398384e-01f, +1.712612847e-01f, +1.395861067e-01f, +9.620992774e-02f, +5.032486620e-02f, +1.068485398e-02f, -1.660849758e-02f, -2.933936761e-02f, -2.914594082e-02f, -2.038349811e-02f, -8.388922065e-03f, +2.215636145e-03f, +8.650582875e-03f, +1.028767266e-02f, +8.212618998e-03f, +4.356029874e-03f, +5.904400346e-04f, -1.887226689e-03f, -2.748184809e-03f, -2.351259262e-03f, -1.367353344e-03f, -4.122952156e-04f, +1.706309313e-04f, +3.398869359e-04f,
    -4.404678912e-06f, +1.666719010e-06f, +1.365597741e-05f, +2.702469411e-05f, +3.296445351e-05f, +2.179751896e-05f, -1.131256524e-05f, -6.077885086e-05f, -1.084546092e-04f, -1.275606867e-04f, -9.293143999e-05f, +5.396717026e-06f, +1.508725802e-04f, +2.975690434e-04f, +3.796460644e-04f, +3.323242692e-04f, +1.182128095e-04f, -2.508173099e-04f, -7.060372125e-04f, -1.134162233e-03f, -1.407992425e-03f, -1.426374959e-03f, -1.149846182e-03f, -6.186926465e-04f, +5.421747208e-05f, +7.145878244e-04f, +1.211811609e-03f, +1.442839046e-03f, +1.380047129e-03f, +1.074304548e-03f, +6.334638925e-04f, +1.850951294e-04f, -1.628535423e-04f, -3.502539917e-04f, -3.738922690e-04f, -2.771190438e-04f, -1.265824125e-04f, +1.385231473e-05f, +1.025554528e-04f, +1.275859766e-04f, +1.021624150e-04f, +5.256935211e-05f, +4.770153257e-06f, -2.496439415e-05f, -3.294289841e-05f, -2.516711215e-05f, -1.151756553e-05f, -2.816527132e-07f,
    -3.882207380e-04f, -8.167915229e-04f, -8.811806463e-04f, +4.547262888e-05f, +2.178538896e-03f, +4.734892883e-03f, +5.877207387e-03f, +3.575222217e-03f, -2.842534517e-03f, -1.137815263e-02f, -1.745933680e-02f, -1.598822236e-02f, -4.614163828e-03f, +1.366482612e-02f, +3.060190957e-02f, +3.624523714e-02f, +2.452126126e-02f, -2.240224729e-03f, -3.290983073e-02f, -5.230651169e-02f, -4.905059090e-02f, -2.228246635e-02f, +1.681131159e-02f, +5.002041744e-02f, +6.128622784e-02f, +4.508536879e-02f, +9.350121055e-03f, -2.872051783e-02f, -5.160048313e-02f, -5.016599107e-02f, -2.756230025e-02f, +3.507694442e-03f, +2.806796518e-02f, +3.642303254e-02f, +2.800444010e-02f, +1.003772955e-02f, -7.445376430e-03f, -1.701040245e-02f, -1.675763276e-02f, -9.802157915e-03f, -1.376464193e-03f, +4.331309326e-03f, +5.872589965e-03f, +4.297405409e-03f, +1.706316218e-03f, -2.245471543e-04f, -9.272581735e-04f, -7.453311192e-04f,
    +1.310576536e-05f, +1.117738321e-05f, -1.007188154e-05f, -4.818784893e-05f, -8.021841976e-05f, -6.992500318e-05f, +7.592810238e-06f, +1.367021002e-04f, +2.507056983e-04f, +2.578062539e-04f, +9.877697198e-05f, -1.956429568e-04f, -4.909320686e-04f, -6.034802808e-04f, -4.062426254e-04f, +7.331924678e-05f, +6.309905005e-04f, +9.710646329e-04f, +8.656981442e-04f, +3.005573838e-04f, -4.859203331e-04f, -1.107561650e-03f, -1.232219304e-03f, -7.689362327e-04f, +7.012783938e-05f, +8.747103281e-04f, +1.252828523e-03f, +1.036833437e-03f, +3.635981751e-04f, -4.120965150e-04f, -9.152137016e-04f, -9.434368467e-04f, -5.505955327e-04f, +1.370094375e-05f, +4.585801599e-04f, +6.045179545e-04f, +4.522427527e-04f, +1.451474416e-04f, -1.346319256e-04f, -2.669660816e-04f, -2.376515187e-04f, -1.153086141e-04f, +8.938566172e-06f, +7.567694817e-05f, +7.705842929e-05f, +4.181167602e-05f, +5.351160797e-06f, -1.257826480e-05f,
    /*  3,30 (48) */
    +2.713236852e-04f, +3.357716612e-04f, +1.087888537e-04f, -5.419095556e-04f, -1.532275021e-03f, -2.469969652e-03f, -2.711428529e-03f, -1.607969408e-03f, +1.114094085e-03f, +4.994429940e-03f, +8.706792755e-03f, +1.031894517e-02f, +7.969164848e-03f, +7.885643586e-04f, -1.027113241e-02f, -2.210056439e-02f, -2.987251744e-02f, -2.828339973e-02f, -1.329587772e-02f, +1.617752467e-02f, +5.728347771e-02f, +1.033941387e-01f, +1.455238419e-01f, +1.746439613e-01f, +1.841940559e-01f, +1.719758725e-01f, +1.407979183e-01f, +9.765276679e-02f, +5.170491332e-02f, +1.175915853e-02f, -1.597503369e-02f, -2.915427248e-02f, -2.930879436e-02f, -2.073375210e-02f, -8.762814334e-03f, +1.938517101e-03f, +8.524000463e-03f, +1.030152497e-02f, +8.315174451e-03f, +4.483615851e-03f, +6.926024496e-04f, -1.834657337e-03f, -2.743414655e-03f, -2.376223656e-03f, -1.400296242e-03f, -4.374623277e-04f, +1.591133657e-04f, +3.396052832e-04f,
    -4.490041168e-06f, +1.377130203e-06f, +1.322398717e-05f, +2.666621724e-05f, +3.299323754e-05f, +2.247537575e-05f, -9.968556543e-06f, -5.913597559e-05f, -1.072485805e-04f, -1.276705727e-04f, -9.498517043e-05f, +1.446014787e-06f, +1.460014508e-04f, +2.935965438e-04f, +3.787454085e-04f, +3.362419967e-04f, +1.274579203e-04f, -2.374852913e-04f, -6.915572233e-04f, -1.122481066e-03f, -1.402902931e-03f, -1.430256781e-03f, -1.162758543e-03f, -6.381729614e-04f, +3.253550840e-05f, +6.957186340e-04f, +1.199942416e-03f, +1.440134762e-03f, +1.386130709e-03f, +1.086558738e-03f, +6.480053926e-04f, +1.980463138e-04f, -1.542445587e-04f, -3.469985528e-04f, -3.752894788e-04f, -2.813221715e-04f, -1.314238026e-04f, +1.010520338e-05f, +1.007595192e-04f, +1.276843902e-04f, +1.034714787e-04f, +5.420884075e-05f, +6.042442799e-06f, -2.437540135e-05f, -3.297974244e-05f, -2.555103579e-05f, -1.194052812e-05f, -5.459948177e-07f,
    -3.751149726e-04f, -8.056141397e-04f, -8.912525278e-04f, -2.715220056e-06f, +2.098320476e-03f, +4.664967880e-03f, +5.884800197e-03f, +3.711924318e-03f, -2.591828819e-03f, -1.112034638e-02f, -1.736055983e-02f, -1.618386532e-02f, -5.105095897e-03f, +1.306134584e-02f, +3.019566694e-02f, +3.631855639e-02f, +2.515225176e-02f, -1.269160096e-03f, -3.204413258e-02f, -5.200595431e-02f, -4.953651123e-02f, -2.339002800e-02f, +1.557909228e-02f, +4.925148120e-02f, +6.135635567e-02f, +4.596007912e-02f, +1.060294958e-02f, -2.768368439e-02f, -5.123688496e-02f, -5.057808759e-02f, -2.847751395e-02f, +2.564257596e-03f, +2.751736964e-02f, +3.643673348e-02f, +2.846302026e-02f, +1.064224750e-02f, -6.993133677e-03f, -1.686525500e-02f, -1.689226469e-02f, -1.006912400e-02f, -1.614115712e-03f, +4.216000711e-03f, +5.881528531e-03f, +4.373082357e-03f, +1.783374647e-03f, -1.827354783e-04f, -9.219070127e-04f, -7.579093840e-04f,
    +1.295244630e-05f, +1.149649446e-05f, -9.089735452e-06f, -4.691785108e-05f, -7.966604217e-05f, -7.121214734e-05f, +4.171674522e-06f, +1.324370954e-04f, +2.482974822e-04f, +2.599747520e-04f, +1.062410242e-04f, -1.855110352e-04f, -4.835375958e-04f, -6.043106357e-04f, -4.173070169e-04f, +5.571174430e-05f, +6.153101469e-04f, +9.664270613e-04f, +8.765571829e-04f, +3.233665128e-04f, -4.617360196e-04f, -1.094397381e-03f, -1.237549266e-03f, -7.909024357e-04f, +4.209082247e-05f, +8.543876214e-04f, +1.249917253e-03f, +1.051944096e-03f, +3.883171580e-04f, -3.903108881e-04f, -9.062725306e-04f, -9.498402261e-04f, -5.670541940e-04f, -3.482797389e-06f, +4.487161370e-04f, +6.049282845e-04f, +4.603124626e-04f, +1.552029443e-04f, -1.277587669e-04f, -2.654686322e-04f, -2.404591937e-04f, -1.195956183e-04f, +5.749470101e-06f, +7.466243631e-05f, +7.776765626e-05f, +4.309016406e-05f, +6.256675746e-06f, -1.233653283e-05f,
    /*  3,31 (48) */
    +2.668336440e-04f, +3.371487914e-04f, +1.220128409e-04f, -5.152433383e-04f, -1.499281783e-03f, -2.447494277e-03f, -2.721397086e-03f, -1.667105383e-03f, +1.006845505e-03f, +4.866759367e-03f, +8.611807584e-03f, +1.032039119e-02f, +8.115166299e-03f, +1.082160902e-03f, -9.892387002e-03f, -2.176432239e-02f, -2.974505952e-02f, -2.852088503e-02f, -1.398743494e-02f, +1.505504361e-02f, +5.588057478e-02f, +1.019638819e-01f, +1.443610834e-01f, +1.740057884e-01f, +1.842265914e-01f, +1.726715912e-01f, +1.419978608e-01f, +9.909290155e-02f, +5.309104403e-02f, +1.284571727e-02f, -1.532702830e-02f, -2.895622617e-02f, -2.946303892e-02f, -2.108075065e-02f, -9.138103813e-03f, +1.657194930e-03f, +8.392576660e-03f, +1.031163017e-02f, +8.415933970e-03f, +4.611300241e-03f, +7.960739283e-04f, -1.780448496e-03f, -2.737372213e-03f, -2.400599057e-03f, -1.433275985e-03f, -4.630133635e-04f, +1.471728376e-04f, +3.390592884e-04f,
    -4.569541687e-06f, +1.093779023e-06f, +1.279394254e-05f, +2.630090367e-05f, +3.300519509e-05f, +2.313094698e-05f, -8.641971212e-06f, -5.749286536e-05f, -1.060154541e-04f, -1.277273734e-04f, -9.697442048e-05f, -2.455154195e-06f, +1.411350845e-04f, +2.895631068e-04f, +3.777178872e-04f, +3.399932180e-04f, +1.365456772e-04f, -2.242442057e-04f, -6.770559685e-04f, -1.110650867e-03f, -1.397561162e-03f, -1.433843904e-03f, -1.175413611e-03f, -6.575069420e-04f, +1.084600706e-05f, +6.766902606e-04f, +1.187809005e-03f, +1.437136486e-03f, +1.391969581e-03f, +1.098675471e-03f, +6.625373850e-04f, +2.110969350e-04f, -1.454749231e-04f, -3.435785237e-04f, -3.765653018e-04f, -2.854709206e-04f, -1.362752771e-04f, +6.305860108e-06f, +9.889919355e-05f, +1.277317531e-04f, +1.047561226e-04f, +5.585024780e-05f, +7.333155539e-06f, -2.376427225e-05f, -3.300060303e-05f, -2.592907112e-05f, -1.236605420e-05f, -8.167179641e-07f,
    -3.621625263e-04f, -7.941176452e-04f, -9.003422633e-04f, -4.963307114e-05f, +2.018654434e-03f, +4.593755732e-03f, +5.888971872e-03f, +3.844361413e-03f, -2.343531337e-03f, -1.086037163e-02f, -1.725431881e-02f, -1.636937635e-02f, -5.588633492e-03f, +1.245703520e-02f, +2.977835992e-02f, +3.637426813e-02f, +2.576756190e-02f, -3.027330347e-04f, -3.116757540e-02f, -5.168258780e-02f, -4.999824725e-02f, -2.448442539e-02f, +1.434154302e-02f, +4.846057877e-02f, +6.139844650e-02f, +4.681446674e-02f, +1.185286683e-02f, -2.663174030e-02f, -5.084856780e-02f, -5.096839847e-02f, -2.938378648e-02f, +1.614417370e-03f, +2.695031545e-02f, +3.643325068e-02f, +2.891173640e-02f, +1.124717579e-02f, -6.532821215e-03f, -1.671005206e-02f, -1.702002346e-02f, -1.033459263e-02f, -1.854574906e-03f, +4.096405093e-03f, +5.887278001e-03f, +4.447744793e-03f, +1.861142303e-03f, -1.396453142e-04f, -9.156503370e-04f, -7.702459168e-04f,
    +1.279054036e-05f, +1.179589871e-05f, -8.126265744e-06f, -4.564423467e-05f, -7.907266217e-05f, -7.243049474e-05f, +8.067819448e-07f, +1.281625351e-04f, +2.457850786e-04f, +2.619740203e-04f, +1.135609871e-04f, -1.753901006e-04f, -4.759656788e-04f, -6.048271801e-04f, -4.280763606e-04f, +3.819750226e-05f, +5.994210138e-04f, +9.613405219e-04f, +8.869413989e-04f, +3.459355243e-04f, -4.373988820e-04f, -1.080734367e-03f, -1.242276557e-03f, -8.124734222e-04f, +1.403262768e-05f, +8.336386060e-04f, +1.246399629e-03f, +1.066580545e-03f, +4.129216663e-04f, -3.682537994e-04f, -8.968475170e-04f, -9.558098825e-04f, -5.833325336e-04f, -2.078504744e-05f, +4.385471672e-04f, +6.050322369e-04f, +4.682220434e-04f, +1.652856064e-04f, -1.207343630e-04f, -2.638049775e-04f, -2.431713521e-04f, -1.238811450e-04f, +2.500652728e-06f, +7.358044464e-05f, +7.843946816e-05f, +4.436800841e-05f, +7.181807980e-06f, -1.207582970e-05f,
    /*  4, 0 (48) */
    -4.440791761e-04f, -7.736617456e-04f, -5.842197404e-04f, +4.733051837e-04f, +2.096961908e-03f, +3.159739597e-03f, +2.247925700e-03f, -1.196916207e-03f, -5.859365612e-03f, -8.625924656e-03f, -6.226830420e-03f, +2.191702212e-03f, +1.322393203e-02f, +1.983561445e-02f, +1.498813646e-02f, -3.241530928e-03f, -2.808652174e-02f, -4.494512491e-02f, -3.739225953e-02f, +4.047367480e-03f, +7.496487828e-02f, +1.562849362e-01f, +2.209963868e-01f, +2.456499165e-01f, +2.209963868e-01f, +1.562849362e-01f, +7.496487828e-02f, +4.047367480e-03f, -3.739225953e-02f, -4.494512491e-02f, -2.808652174e-02f, -3.241530928e-03f, +1.498813646e-02f, +1.983561445e-02f, +1.322393203e-02f, +2.191702212e-03f, -6.226830420e-03f, -8.625924656e-03f, -5.859365612e-03f, -1.196916207e-03f, +2.247925700e-03f, +3.159739597e-03f, +2.096961908e-03f, +4.733051837e-04f, -5.842197404e-04f, -7.736617456e-04f, -4.440791761e-04f, -8.710788365e-05f,
    +1.289254766e-05f, +5.184246216e-06f, -1.843893728e-05f, -4.543886514e-05f, -4.981617239e-05f, -9.833808267e-06f, +6.803089721e-05f, +1.384152296e-04f, +1.360732244e-04f, +2.183516949e-05f, -1.715914665e-04f, -3.319467664e-04f, -3.195613163e-04f, -6.198186541e-05f, +3.643635712e-04f, +7.288074567e-04f, +7.447129475e-04f, +2.343101320e-04f, -7.304216719e-04f, -1.804891247e-03f, -2.503717032e-03f, -2.434208634e-03f, -1.510328867e-03f, -2.487863475e-05f, +1.469980364e-03f, +2.417690168e-03f, +2.514578272e-03f, +1.834960044e-03f, +7.647153423e-04f, -2.098854303e-04f, -7.370963161e-04f, -7.359666910e-04f, -3.781907203e-04f, +5.035847333e-05f, +3.152640733e-04f, +3.348305944e-04f, +1.778452548e-04f, -1.658656658e-05f, -1.342466470e-04f, -1.397696245e-04f, -7.066966975e-05f, +7.835189267e-06f, +4.929954776e-05f, +4.606746708e-05f, +1.934333100e-05f, -4.667676794e-06f, -1.288967773e-05f, -8.220998674e-06f,
    +3.469535659e-04f, +1.336667044e-03f, +1.790286751e-03f, +2.794767810e-04f, -3.303519821e-03f, -6.405731284e-03f, -4.976271198e-03f, +2.686342793e-03f, +1.248168983e-02f, +1.571582859e-02f, +5.946321108e-03f, -1.341789307e-02f, -2.845267002e-02f, -2.424163753e-02f, +1.494761300e-03f, +3.267286932e-02f, +4.455848173e-02f, +2.351503337e-02f, -1.915629477e-02f, -5.272885293e-02f, -4.998568337e-02f, -9.883103547e-03f, +3.944741130e-02f, +6.141247912e-02f, +3.944741130e-02f, -9.883103547e-03f, -4.998568337e-02f, -5.272885293e-02f, -1.915629477e-02f, +2.351503337e-02f, +4.455848173e-02f, +3.267286932e-02f, +1.494761300e-03f, -2.424163753e-02f, -2.845267002e-02f, -1.341789307e-02f, +5.946321108e-03f, +1.571582859e-02f, +1.248168983e-02f, +2.686342793e-03f, -4.976271198e-03f, -6.405731284e-03f, -3.303519821e-03f, +2.794767810e-04f, +1.790286751e-03f, +1.336667044e-03f, +3.469535659e-04f, -1.608870261e-04f,
    -2.571773609e-05f, -3.050953535e-05f, +9.392727151e-06f, +8.433841439e-05f, +1.247277122e-04f, +4.822503056e-05f, -1.430114735e-04f, -3.094170965e-04f, -2.554768633e-04f, +8.152129225e-05f, +4.999795024e-04f, +6.290315529e-04f, +2.366593558e-04f, -4.941058242e-04f, -1.010568477e-03f, -8.041570547e-04f, +1.137522031e-04f, +1.110810779e-03f, +1.375457392e-03f, +5.907998826e-04f, -7.311358218e-04f, -1.591834473e-03f, -1.292881518e-03f, -2.296124824e-05f, +1.264336964e-03f, +1.601633554e-03f, +7.702899258e-04f, -5.529630450e-04f, -1.366287754e-03f, -1.133732786e-03f, -1.481780446e-04f, +7.843461819e-04f, +1.016717124e-03f, +5.168134989e-04f, -2.167432336e-04f, -6.249418104e-04f, -5.103339566e-04f, -9.510474086e-05f, +2.489011455e-04f, +3.119466899e-04f, +1.496270931e-04f, -4.360734750e-05f, -1.244160341e-04f, -8.660920381e-05f, -1.142115956e-05f, +3.003560201e-05f, +2.628081681e-05f, +6.143495962e-06f,
    /*  4, 1 (48) */
    -4.311866284e-04f, -7.684774994e-04f, -6.026586777e-04f, +4.278663186e-04f, +2.047145736e-03f, +3.149905788e-03f, +2.315956597e-03f, -1.058500977e-03f, -5.723292387e-03f, -8.604089486e-03f, -6.398421886e-03f, +1.859755445e-03f, +1.290437072e-02f, +1.977363258e-02f, +1.535250003e-02f, -2.512723471e-03f, -2.734180880e-02f, -4.471081478e-02f, -3.812268121e-02f, +2.242476233e-03f, +7.246116125e-02f, +1.538507276e-01f, +2.194860579e-01f, +2.456250379e-01f, +2.224663671e-01f, +1.587026264e-01f, +7.747945655e-02f, +5.882327524e-03f, -3.662754419e-02f, -4.515501034e-02f, -2.882361806e-02f, -3.977497619e-03f, +1.460994574e-02f, +1.988597292e-02f, +1.353919611e-02f, +2.526532806e-03f, -6.048985165e-03f, -8.642511222e-03f, -5.993612259e-03f, -1.336685832e-03f, +2.177256030e-03f, +3.167574786e-03f, +2.146261456e-03f, +5.193726508e-04f, -5.648764094e-04f, -7.783294224e-04f, -4.569688538e-04f, -9.532888232e-05f,
    +1.288252765e-05f, +5.683852374e-06f, -1.753912827e-05f, -4.478791382e-05f, -5.028703496e-05f, -1.179191290e-05f, +6.538677752e-05f, +1.369877151e-04f, +1.377842419e-04f, +2.699924766e-05f, -1.653081477e-04f, -3.288886600e-04f, -3.236061130e-04f, -7.342665820e-05f, +3.504813501e-04f, +7.212987527e-04f, +7.517939123e-04f, +2.582671380e-04f, -6.962478502e-04f, -1.774447867e-03f, -2.492078858e-03f, -2.449859669e-03f, -1.550106255e-03f, -7.462633087e-05f, +1.429075397e-03f, +2.400307809e-03f, +2.524654162e-03f, +1.864638951e-03f, +7.991145529e-04f, -1.849999595e-04f, -7.289417700e-04f, -7.427680672e-04f, -3.919537410e-04f, +3.856160836e-05f, +3.107140920e-04f, +3.375361450e-04f, +1.840650204e-04f, -1.125585379e-05f, -1.323041793e-04f, -1.410489017e-04f, -7.330111985e-05f, +5.796882022e-06f, +4.873677159e-05f, +4.667280462e-05f, +2.025163384e-05f, -4.134251716e-06f, -1.287362466e-05f, -8.462405133e-06f,
    +3.212358298e-04f, +1.306157508e-03f, +1.799679478e-03f, +3.638151954e-04f, -3.178792109e-03f, -6.357506254e-03f, -5.119282672e-03f, +2.376925696e-03f, +1.222621297e-02f, +1.579734988e-02f, +6.446300611e-03f, -1.278886151e-02f, -2.821601066e-02f, -2.473574335e-02f, +4.841928232e-04f, +3.186871227e-02f, +4.467223393e-02f, +2.462584415e-02f, -1.778083738e-02f, -5.213805305e-02f, -5.071681919e-02f, -1.147493802e-02f, +3.815452979e-02f, +6.138951788e-02f, +4.071174827e-02f, -8.281469993e-03f, -4.921539345e-02f, -5.328181598e-02f, -2.052258252e-02f, +2.238130058e-02f, +4.441030368e-02f, +3.345721550e-02f, +2.511478425e-03f, -2.372482403e-02f, -2.866941325e-02f, -1.404283488e-02f, +5.435987152e-03f, +1.562072385e-02f, +1.273059098e-02f, +2.998289482e-03f, -4.826644105e-03f, -6.449338632e-03f, -3.427935855e-03f, +1.928675772e-04f, +1.778865592e-03f, +1.366702646e-03f, +3.732343827e-04f, -1.547435301e-04f,
    -2.514036432e-05f, -3.093642097e-05f, +7.404259204e-06f, +8.203562472e-05f, +1.249178960e-04f, +5.271780462e-05f, -1.363776150e-04f, -3.066609371e-04f, -2.617518459e-04f, +6.803395823e-05f, +4.893309108e-04f, +6.325743770e-04f, +2.562102288e-04f, -4.711862525e-04f, -1.003667029e-03f, -8.232157439e-04f, +7.942130382e-05f, +1.087129161e-03f, +1.383526417e-03f, +6.280668059e-04f, -6.915044642e-04f, -1.580821894e-03f, -1.320407745e-03f, -6.886550882e-05f, +1.234796034e-03f, +1.610209589e-03f, +8.089345225e-04f, -5.145848785e-04f, -1.356020827e-03f, -1.155873363e-03f, -1.826714690e-04f, +7.637947150e-04f, +1.022102766e-03f, +5.392888856e-04f, -1.964753024e-04f, -6.203033410e-04f, -5.203823168e-04f, -1.087736719e-04f, +2.420266134e-04f, +3.142442435e-04f, +1.562180990e-04f, -3.886700897e-05f, -1.239808950e-04f, -8.884499839e-05f, -1.348826031e-05f, +2.951398656e-05f, +2.682848005e-05f, +6.706631824e-06f,
    /*  4, 2 (48) */
    -4.183041008e-04f, -7.627936470e-04f, -6.201978060e-04f, +3.830784047e-04f, +1.996858701e-03f, +3.138113875e-03f, +2.381343374e-03f, -9.215132624e-04f, -5.585508145e-03f, -8.577090238e-03f, -6.563730034e-03f, +1.530866785e-03f, +1.258076460e-02f, +1.970020593e-02f, +1.570298138e-02f, -1.791424718e-03f, -2.659001489e-02f, -4.445254764e-02f, -3.881892906e-02f, +4.680283662e-04f, +6.996908239e-02f, +1.514008679e-01f, +2.179359516e-01f, +2.455504115e-01f, +2.238954425e-01f, +1.611029342e-01f, +8.000411071e-02f, +7.746966475e-03f, -3.582842964e-02f, -4.534001030e-02f, -2.955255983e-02f, -4.720265686e-03f, +1.421799200e-02f, +1.992453453e-02f, +1.384991020e-02f, +2.864068951e-03f, -5.864920145e-03f, -8.653767076e-03f, -6.125916438e-03f, -1.477734733e-03f, +2.103954910e-03f, +3.173371668e-03f, +2.194998227e-03f, +5.660454554e-04f, -5.446247756e-04f, -7.824636741e-04f, -4.698424785e-04f, -1.037912875e-04f,
    +1.285991751e-05f, +6.166404737e-06f, -1.664456387e-05f, -4.411553088e-05f, -5.071255403e-05f, -1.370871943e-05f, +6.273926195e-05f, +1.354891037e-04f, +1.393801050e-04f, +3.207647279e-05f, -1.589997563e-04f, -3.256603402e-04f, -3.273989107e-04f, -8.468789089e-05f, +3.365530480e-04f, +7.134490749e-04f, +7.583417174e-04f, +2.817498091e-04f, -6.622080333e-04f, -1.743645304e-03f, -2.479672483e-03f, -2.464640132e-03f, -1.589298153e-03f, -1.243453115e-04f, +1.387628879e-03f, +2.382065486e-03f, +2.533936609e-03f, +1.893912758e-03f, +8.336048491e-04f, -1.596609317e-04f, -7.202473230e-04f, -7.492033100e-04f, -4.056435160e-04f, +2.659656099e-05f, +3.059112374e-04f, +3.400594884e-04f, +1.902462398e-04f, -5.845531987e-06f, -1.302455672e-04f, -1.422510891e-04f, -7.592324930e-05f, +3.719755005e-06f, +4.812748421e-05f, +4.725396625e-05f, +2.116315483e-05f, -3.584095864e-06f, -1.284410222e-05f, -8.701086450e-06f,
    +2.960954655e-04f, +1.275221087e-03f, +1.807083737e-03f, +4.458508201e-04f, -3.053874213e-03f, -6.304788449e-03f, -5.255660287e-03f, +2.070264759e-03f, +1.196446112e-02f, +1.586538384e-02f, +6.935631522e-03f, -1.215628714e-02f, -2.795980043e-02f, -2.520692960e-02f, -5.194742057e-04f, +3.104549652e-02f, +4.475165524e-02f, +2.571297331e-02f, -1.639731096e-02f, -5.150998624e-02f, -5.140832366e-02f, -1.305575991e-02f, +3.683412204e-02f, +6.132065237e-02f, +4.194654430e-02f, -6.671260404e-03f, -4.840645892e-02f, -5.379640085e-02f, -2.187860335e-02f, +2.122542722e-02f, +4.422763222e-02f, +3.422101022e-02f, +3.533581191e-03f, -2.318553514e-02f, -2.886588855e-02f, -1.466313822e-02f, +4.915604835e-03f, +1.551195017e-02f, +1.297261759e-02f, +3.312533726e-03f, -4.670426006e-03f, -6.488205641e-03f, -3.551916750e-03f, +1.040225788e-04f, +1.765377331e-03f, +1.396216632e-03f, +4.000628628e-04f, -1.480368983e-04f,
    -2.454981878e-05f, -3.131693383e-05f, +5.456981773e-06f, +7.970380656e-05f, +1.249886400e-04f, +5.708357236e-05f, -1.297318172e-04f, -3.036838206e-04f, -2.677244663e-04f, +5.465316782e-05f, +4.784002737e-04f, +6.355725464e-04f, +2.753828356e-04f, -4.480752018e-04f, -9.960235479e-04f, -8.415113541e-04f, +4.521248951e-05f, +1.062710289e-03f, +1.390492424e-03f, +6.647357780e-04f, -6.514284292e-04f, -1.568606346e-03f, -1.346894540e-03f, -1.147150770e-04f, +1.204281511e-03f, +1.617554017e-03f, +8.470377077e-04f, -4.756944942e-04f, -1.344660851e-03f, -1.177211241e-03f, -2.172049221e-04f, +7.425149321e-04f, +1.026715774e-03f, +5.615116392e-04f, -1.758694164e-04f, -6.151147960e-04f, -5.301127742e-04f, -1.225172574e-04f, +2.348554835e-04f, +3.163044258e-04f, +1.627780462e-04f, -3.400642472e-05f, -1.234204187e-04f, -9.104278358e-05f, -1.559266332e-05f, +2.894409669e-05f, +2.735959138e-05f, +7.280845023e-06f,
    /*  4, 3 (48) */
    -4.054441832e-04f, -7.566272423e-04f, -6.368423699e-04f, +3.389628739e-04f, +1.946146147e-03f, +3.124405156e-03f, +2.444082636e-03f, -7.860241587e-04f, -5.446128040e-03f, -8.545013766e-03f, -6.722729790e-03f, +1.205206445e-03f, +1.225336569e-02f, +1.961551803e-02f, +1.603953443e-02f, -1.077975643e-03f, -2.583167317e-02f, -4.417079783e-02f, -3.948113709e-02f, -1.275616938e-03f, +6.748940991e-02f, +1.489362278e-01f, +2.163466535e-01f, +2.454260662e-01f, +2.252830714e-01f, +1.634849997e-01f, +8.253804732e-02f, +9.640879233e-03f, -3.499482479e-02f, -4.549967124e-02f, -3.027280715e-02f, -5.469468996e-03f, +1.381234848e-02f, +1.995113109e-02f, +1.415582144e-02f, +3.204128440e-03f, -5.674673905e-03f, -8.659612608e-03f, -6.256162005e-03f, -1.619985822e-03f, +2.028031661e-03f, +3.177091423e-03f, +2.243125712e-03f, +6.132994217e-04f, -5.234616208e-04f, -7.860477700e-04f, -4.826865807e-04f, -1.124923739e-04f,
    +1.282502326e-05f, +6.631829657e-06f, -1.575588796e-05f, -4.342263601e-05f, -5.109317649e-05f, -1.558348651e-05f, +6.009027664e-05f, +1.339214410e-04f, +1.408612929e-04f, +3.706460373e-05f, -1.526707137e-04f, -3.222659344e-04f, -3.309403096e-04f, -9.576076956e-05f, +3.225875851e-04f, +7.052670211e-04f, +7.643591248e-04f, +3.047517951e-04f, -6.283162183e-04f, -1.712499040e-03f, -2.466506952e-03f, -2.478547275e-03f, -1.627890458e-03f, -1.740164482e-04f, +1.345655982e-03f, +2.362967526e-03f, +2.542417848e-03f, +1.922766365e-03f, +8.681716366e-04f, -1.338758426e-04f, -7.110112536e-04f, -7.552642627e-04f, -4.192508715e-04f, +1.446878429e-05f, +3.008555334e-04f, +3.423967670e-04f, +1.963843605e-04f, -3.581872455e-07f, -1.280706340e-04f, -1.433742428e-04f, -7.853403820e-05f, +1.604718976e-06f, +4.747135652e-05f, +4.781004476e-05f, +2.207718797e-05f, -3.017351572e-06f, -1.280083156e-05f, -8.936712204e-06f,
    +2.715456467e-04f, +1.243904153e-03f, +1.812540719e-03f, +5.255546267e-04f, -2.928885573e-03f, -6.247704877e-03f, -5.385392104e-03f, +1.766580938e-03f, +1.169673666e-02f, +1.592003700e-02f, +7.414031795e-03f, -1.152071459e-02f, -2.768441760e-02f, -2.565500481e-02f, -1.515497754e-03f, +3.020398517e-02f, +4.479686773e-02f, +2.677568360e-02f, -1.500681854e-02f, -5.084525046e-02f, -5.205975209e-02f, -1.462436626e-02f, +3.548722750e-02f, +6.120593729e-02f, +4.315082581e-02f, -5.053706387e-03f, -4.755942122e-02f, -5.427209535e-02f, -2.322326420e-02f, +2.004821598e-02f, +4.401042729e-02f, +3.496352515e-02f, +4.560296965e-03f, -2.262402350e-02f, -2.904175797e-02f, -1.527825301e-02f, +4.385492061e-03f, +1.538943292e-02f, +1.320747308e-02f, +3.628838152e-03f, -4.507647960e-03f, -6.522212065e-03f, -3.675337169e-03f, +1.297979522e-05f, +1.749784668e-03f, +1.425160729e-03f, +4.274224541e-04f, -1.407560533e-04f,
    -2.394720634e-05f, -3.165178783e-05f, +3.552050772e-06f, +7.734590613e-05f, +1.249420826e-04f, +6.132039239e-05f, -1.230802996e-04f, -3.004914841e-04f, -2.733933896e-04f, +4.138913951e-05f, +4.671998064e-04f, +6.380287732e-04f, +2.941645902e-04f, -4.247930999e-04f, -9.876493535e-04f, -8.590336898e-04f, +1.115266394e-05f, +1.037577029e-03f, +1.396353923e-03f, +7.007793324e-04f, -6.109405869e-04f, -1.555199324e-03f, -1.372321662e-03f, -1.604735422e-04f, +1.172816986e-03f, +1.623659271e-03f, +8.845679552e-04f, -4.363215056e-04f, -1.332212982e-03f, -1.197725728e-03f, -2.517506783e-04f, +7.205197926e-04f, +1.030547109e-03f, +5.834614779e-04f, -1.549398357e-04f, -6.093752927e-04f, -5.395136800e-04f, -1.363244821e-04f, +2.273902694e-04f, +3.181220543e-04f, +1.693004253e-04f, -2.902816071e-05f, -1.227328237e-04f, -9.319952775e-05f, -1.773293279e-05f, +2.832538384e-05f, +2.787300974e-05f, +7.865645190e-06f,
    /*  4, 4 (48) */
    -3.926191600e-04f, -7.499954126e-04f, -6.525982578e-04f, +2.955402379e-04f, +1.895052970e-03f, +3.108821669e-03f, +2.504172913e-03f, -6.521027177e-04f, -5.305266748e-03f, -8.507949162e-03f, -6.875400504e-03f, +8.829405108e-04f, +1.192242538e-02f, +1.951975726e-02f, +1.636212202e-02f, -3.727086224e-04f, -2.506731404e-02f, -4.386604604e-02f, -4.010945331e-02f, -2.988115978e-03f, +6.502290296e-02f, +1.464576805e-01f, +2.147187630e-01f, +2.452520498e-01f, +2.266287274e-01f, +1.658479672e-01f, +8.508046517e-02f, +1.156364560e-02f, -3.412665315e-02f, -4.563354708e-02f, -3.098381841e-02f, -6.224733259e-03f, +1.339309761e-02f, +1.996559988e-02f, +1.445667697e-02f, +3.546525207e-03f, -5.478289544e-03f, -8.659970795e-03f, -6.384232639e-03f, -1.763360065e-03f, +1.949497623e-03f, +3.178696142e-03f, +2.290597068e-03f, +6.611094664e-04f, -5.013844328e-04f, -7.890651215e-04f, -4.954874122e-04f, -1.214290861e-04f,
    +1.277815672e-05f, +7.080070146e-06f, -1.487372814e-05f, -4.271015005e-05f, -5.142937682e-05f, -1.741551516e-05f, +5.744172148e-05f, +1.322867935e-04f, +1.422283575e-04f, +4.196148700e-05f, -1.463254020e-04f, -3.187096293e-04f, -3.342310618e-04f, -1.066406684e-04f, +3.085938074e-04f, +6.967612850e-04f, +7.698491488e-04f, +3.272670360e-04f, -5.945862371e-04f, -1.681024634e-03f, -2.452591617e-03f, -2.491578750e-03f, -1.665869356e-03f, -2.236206357e-04f, +1.303172126e-03f, +2.343018643e-03f, +2.550090443e-03f, +1.951184787e-03f, +9.028001885e-04f, -1.076524697e-04f, -7.012321084e-04f, -7.609428930e-04f, -4.327665825e-04f, +2.183892139e-06f, +2.955471640e-04f, +3.445441995e-04f, +2.024748039e-04f, +5.203509853e-06f, -1.257792813e-04f, -1.444164487e-04f, -8.113144611e-05f, -5.472731236e-07f, +4.676809063e-05f, +4.834013806e-05f, +2.299301259e-05f, -2.434178788e-06f, -1.274354164e-05f, -9.168948451e-06f,
    +2.475984404e-04f, +1.212252366e-03f, +1.816092770e-03f, +6.029005328e-04f, -2.803943490e-03f, -6.186384484e-03f, -5.508472404e-03f, +1.466089454e-03f, +1.142334327e-02f, +1.596142614e-02f, +7.881231602e-03f, -1.088268582e-02f, -2.739025301e-02f, -2.607979791e-02f, -2.503147107e-03f, +2.934495148e-02f, +4.480802039e-02f, +2.781326063e-02f, -1.361046461e-02f, -5.014447113e-02f, -5.267069267e-02f, -1.617956558e-02f, +3.411490584e-02f, +6.104546375e-02f, +4.432364280e-02f, -3.430047117e-03f, -4.667485326e-02f, -5.470841685e-02f, -2.455547718e-02f, +1.885049025e-02f, +4.375867662e-02f, +3.568404494e-02f, +5.590844074e-03f, -2.204056203e-02f, -2.919669781e-02f, -1.588762831e-02f, +3.845978381e-03f, +1.525310843e-02f, +1.343486335e-02f, +3.946960206e-03f, -4.338347535e-03f, -6.551240226e-03f, -3.798069993e-03f, -8.021973253e-05f, +1.732051735e-03f, +1.453486113e-03f, +4.552954639e-04f, -1.328904081e-04f,
    -2.333362236e-05f, -3.194173417e-05f, +1.690552013e-06f, +7.496484133e-05f, +1.247804426e-04f, +6.542647888e-05f, -1.164291964e-04f, -2.970897857e-04f, -2.787575706e-04f, +2.825187413e-05f, +4.557418356e-04f, +6.399462117e-04f, +3.125433452e-04f, -4.013603659e-04f, -9.785563028e-04f, -8.757732603e-04f, -2.273152976e-05f, +1.011752738e-03f, +1.401110338e-03f, +7.361705945e-04f, -5.700740732e-04f, -1.540613279e-03f, -1.396669752e-03f, -2.061045701e-04f, +1.140426844e-03f, +1.628518790e-03f, +9.214941434e-04f, -3.964960053e-04f, -1.318683292e-03f, -1.217396724e-03f, -2.862808627e-04f, +6.978229305e-04f, +1.033588332e-03f, +6.051182020e-04f, -1.337012165e-04f, -6.030844187e-04f, -5.485735572e-04f, -1.501841507e-04f, +2.196337826e-04f, +3.196921023e-04f, +1.757786675e-04f, -2.393493880e-05f, -1.219164262e-04f, -9.531218521e-05f, -1.990756350e-05f, +2.765734466e-05f, +2.836758865e-05f, +8.460514288e-06f,
    /*  4, 5 (48) */
    -3.798410033e-04f, -7.429153425e-04f, -6.674719860e-04f, +2.528300878e-04f, +1.843623593e-03f, +3.091406154e-03f, +2.561614635e-03f, -5.198159242e-04f, -5.163038390e-03f, -8.465987675e-03f, -7.021725906e-03f, +5.642308816e-04f, +1.158819432e-02f, +1.941311660e-02f, +1.667071582e-02f, +3.240526627e-04f, -2.429746489e-02f, -4.353877900e-02f, -4.070403955e-02f, -4.669140612e-03f, +6.257031134e-02f, +1.439661018e-01f, +2.130528937e-01f, +2.450284291e-01f, +2.279318995e-01f, +1.681909859e-01f, +8.763055561e-02f, +1.351483038e-02f, -3.322385297e-02f, -4.574119955e-02f, -3.168505052e-02f, -6.985676151e-03f, +1.296033103e-02f, +1.996778377e-02f, +1.475222413e-02f, +3.891069406e-03f, -5.275814740e-03f, -8.654767285e-03f, -6.510011921e-03f, -1.907776514e-03f, +1.868366177e-03f, +3.178148869e-03f, +2.337365159e-03f, +7.094496045e-04f, -4.783914202e-04f, -7.914993003e-04f, -5.082309539e-04f, -1.305980346e-04f,
    +1.271963515e-05f, +7.511085657e-06f, -1.399869545e-05f, -4.197899425e-05f, -5.172165629e-05f, -1.920414868e-05f, +5.479546913e-05f, +1.305872469e-04f, +1.434819223e-04f, +4.676505722e-05f, -1.399681615e-04f, -3.149956671e-04f, -3.372720680e-04f, -1.173231310e-04f, +2.945804811e-04f, +6.879406509e-04f, +7.748150519e-04f, +3.492897638e-04f, -5.610317500e-04f, -1.649237711e-03f, -2.437936128e-03f, -2.503732601e-03f, -1.703221322e-03f, -2.731388008e-04f, +1.260192979e-03f, +2.322223945e-03f, +2.556947300e-03f, +1.979153161e-03f, +9.374756521e-04f, -8.099886954e-05f, -6.909087043e-04f, -7.662312983e-04f, -4.461813775e-04f, -1.025234248e-05f, +2.899864756e-04f, +3.464980832e-04f, +2.085129681e-04f, +1.083680508e-05f, -1.233714902e-04f, -1.453758241e-04f, -8.371341332e-05f, -2.735226303e-06f, +4.601742064e-05f, +4.884335002e-05f, +2.390989374e-05f, -1.834755230e-06f, -1.267196955e-05f, -9.397458000e-06f,
    +2.242648180e-04f, +1.180310631e-03f, +1.817783322e-03f, +6.778653741e-04f, -2.679163048e-03f, -6.120958005e-03f, -5.624901600e-03f, +1.168999668e-03f, +1.114458570e-02f, +1.598967802e-02f, +8.336973437e-03f, -1.024273960e-02f, -2.707770966e-02f, -2.648115827e-02f, -3.481703410e-03f, +2.846917822e-02f, +4.478528886e-02f, +2.882501336e-02f, -1.220935428e-02f, -4.940830054e-02f, -5.324076675e-02f, -1.772017886e-02f, +3.271823609e-02f, +6.083935918e-02f, +4.546406964e-02f, -1.801528327e-03f, -4.575335912e-02f, -5.510491286e-02f, -2.587416048e-02f, +1.763309353e-02f, +4.347239575e-02f, +3.638186787e-02f, +6.624432406e-03f, -2.143544382e-02f, -2.933039902e-02f, -1.649071272e-02f, +3.297404824e-03f, +1.510292428e-02f, +1.365449713e-02f, +4.266652308e-03f, -4.162568867e-03f, -6.575175165e-03f, -3.919986419e-03f, -1.755319177e-04f, +1.712144172e-03f, +1.481143457e-03f, +4.836630525e-04f, -1.244298938e-04f,
    -2.271014949e-05f, -3.218755973e-05f, -1.264986970e-07f, +7.256349920e-05f, +1.245060156e-04f, +6.940020102e-05f, -1.097845518e-04f, -2.934846979e-04f, -2.838162517e-04f, +1.525114812e-05f, +4.440387867e-04f, +6.413284520e-04f, +3.305073988e-04f, -3.777973932e-04f, -9.687567770e-04f, -8.917212832e-04f, -5.641373053e-05f, +9.852612407e-04f, +1.404762002e-03f, +7.708833030e-04f, -5.288622618e-04f, -1.524861610e-03f, -1.419920346e-03f, -2.515719334e-04f, +1.107136239e-03f, +1.632127022e-03f, +9.577855825e-04f, -3.562485408e-04f, -1.304078768e-03f, -1.236204745e-03f, -3.207674749e-04f, +6.744386457e-04f, +1.035831615e-03f, +6.264617115e-04f, -1.121686012e-04f, -5.962422370e-04f, -5.572811128e-04f, -1.640848971e-04f, +2.115891334e-04f, +3.210097061e-04f, +1.822061507e-04f, -1.872963638e-05f, -1.209696434e-04f, -9.737769918e-05f, -2.211498118e-05f, +2.693952258e-05f, +2.884217760e-05f, +9.064906686e-06f,
    /*  4, 6 (48) */
    -3.671213681e-04f, -7.354042568e-04f, -6.814706814e-04f, +2.108510936e-04f, +1.791901937e-03f, +3.072202006e-03f, +2.616410104e-03f, -3.892286773e-04f, -5.019556468e-03f, -8.419222618e-03f, -7.161694067e-03f, +2.492352145e-04f, +1.125092225e-02f, +1.929579347e-02f, +1.696529630e-02f, +1.011993314e-03f, -2.352264984e-02f, -4.318948924e-02f, -4.126507130e-02f, -6.318378323e-03f, +6.013237521e-02f, +1.414623692e-01f, +2.113496723e-01f, +2.447552903e-01f, +2.291920925e-01f, +1.705132098e-01f, +9.018750292e-02f, +1.549398355e-02f, -3.228637731e-02f, -4.582219842e-02f, -3.237595922e-02f, -7.751907450e-03f, +1.251414965e-02f, +1.995753143e-02f, +1.504221061e-02f, +4.237567489e-03f, -5.067301772e-03f, -8.643930480e-03f, -6.633383411e-03f, -2.053152338e-03f, +1.784652763e-03f, +3.175413642e-03f, +2.383382579e-03f, +7.582929545e-04f, -4.544815265e-04f, -7.933340555e-04f, -5.209029234e-04f, -1.399954926e-04f,
    +1.264978081e-05f, +7.924851840e-06f, -1.313138411e-05f, -4.123008952e-05f, -5.197054220e-05f, -2.094877260e-05f, +5.215336394e-05f, +1.288249044e-04f, +1.446226806e-04f, +5.147333744e-05f, -1.336032886e-04f, -3.111283429e-04f, -3.400643764e-04f, -1.278038710e-04f, +2.805562892e-04f, +6.788139878e-04f, +7.792603414e-04f, +3.708145029e-04f, -5.276662400e-04f, -1.617153954e-03f, -2.422550433e-03f, -2.515007272e-03f, -1.739933127e-03f, -3.225519117e-04f, +1.216734440e-03f, +2.300588926e-03f, +2.562981663e-03f, +2.006656758e-03f, +9.721830556e-04f, -5.392337557e-05f, -6.800401319e-04f, -7.711217117e-04f, -4.594859434e-04f, -2.283398945e-05f, +2.841739777e-04f, +3.482547981e-04f, +2.144942307e-04f, +1.653886144e-05f, -1.208473221e-04f, -1.462505197e-04f, -8.627786209e-05f, -4.958103691e-06f, +4.521911322e-05f, +4.931879124e-05f, +2.482708254e-05f, -1.219276524e-06f, -1.258586094e-05f, -9.621900691e-06f,
    +2.015546685e-04f, +1.148123072e-03f, +1.817656823e-03f, +7.504288733e-04f, -2.554657032e-03f, -6.051557804e-03f, -5.734686152e-03f, +8.755149706e-04f, +1.086076945e-02f, +1.600492917e-02f, +8.781012224e-03f, -9.601411153e-03f, -2.674720226e-02f, -2.685895566e-02f, -4.450460187e-03f, +2.757745693e-02f, +4.472887513e-02f, +2.981027461e-02f, -1.080459227e-02f, -4.863741723e-02f, -5.376962901e-02f, -1.924504047e-02f, +3.129831574e-02f, +6.058778724e-02f, +4.657120588e-02f, -1.694013043e-04f, -4.479557353e-02f, -5.546116140e-02f, -2.717823924e-02f, +1.639688878e-02f, +4.315162828e-02f, +3.705630652e-02f, +7.660264021e-03f, -2.080898211e-02f, -2.944256762e-02f, -1.708695496e-02f, +2.740123711e-03f, +1.493883939e-02f, +1.386608626e-02f, +4.587662014e-03f, -3.980362717e-03f, -6.593904801e-03f, -4.040956062e-03f, -2.729096169e-04f, +1.690029190e-03f, +1.508082980e-03f, +5.125052301e-04f, -1.153649871e-04f,
    -2.207785664e-05f, -3.239008541e-05f, -1.898155368e-06f, +7.014473331e-05f, +1.241211704e-04f, +7.324008229e-05f, -1.031523155e-04f, -2.896822997e-04f, -2.885689603e-04f, +2.396506984e-06f, +4.321031721e-04f, +6.421795125e-04f, +3.480455019e-04f, -3.541245312e-04f, -9.582636675e-04f, -9.068696886e-04f, -8.986788047e-05f, +9.581268104e-04f, +1.407310159e-03f, +8.048918298e-04f, -4.873387349e-04f, -1.507958646e-03f, -1.442055892e-03f, -2.968395419e-04f, +1.072971079e-03f, +1.634479434e-03f, +9.934120415e-04f, -3.156100896e-04f, -1.288407306e-03f, -1.254130937e-03f, -3.551824120e-04f, +6.503818960e-04f, +1.037269751e-03f, +6.474720252e-04f, -9.035740848e-05f, -5.888492894e-04f, -5.656252499e-04f, -1.780151924e-04f, +2.032597318e-04f, +3.220701710e-04f, +1.885762046e-04f, -1.341528578e-05f, -1.198909969e-04f, -9.939300496e-05f, -2.435354300e-05f, +2.617150928e-05f, +2.929562340e-05f, +9.678249260e-06f,
    /*  4, 7 (48) */
    -3.544715873e-04f, -7.274794050e-04f, -6.946020655e-04f, +1.696210040e-04f, +1.739931395e-03f, +3.051253233e-03f, +2.668563468e-03f, -2.604037729e-04f, -4.874933787e-03f, -8.367749280e-03f, -7.295297356e-03f, -6.189312840e-05f, +1.091085788e-02f, +1.916798959e-02f, +1.724585259e-02f, +1.690807301e-03f, -2.274338950e-02f, -4.281867474e-02f, -4.179273754e-02f, -7.935532277e-03f, +5.770982478e-02f, +1.389473619e-01f, +2.096097392e-01f, +2.444327384e-01f, +2.304088269e-01f, +1.728137987e-01f, +9.275048458e-02f, +1.750064030e-02f, -3.131419426e-02f, -4.587612179e-02f, -3.305599935e-02f, -8.523029162e-03f, +1.205466371e-02f, +1.993469744e-02f, +1.532638459e-02f, +4.585822287e-03f, -4.852807542e-03f, -8.627391619e-03f, -6.754230733e-03f, -2.199402858e-03f, +1.698374901e-03f, +3.170455539e-03f, +2.428601693e-03f, +8.076117457e-04f, -4.296544439e-04f, -7.945533321e-04f, -5.334887844e-04f, -1.496173933e-04f,
    +1.256892063e-05f, +8.321360299e-06f, -1.227237129e-05f, -4.046435566e-05f, -5.217658705e-05f, -2.264881449e-05f, +4.951722105e-05f, +1.270018852e-04f, +1.456513944e-04f, +5.608443952e-05f, -1.272350333e-04f, -3.071120005e-04f, -3.426091801e-04f, -1.380787733e-04f, +2.665298267e-04f, +6.693902437e-04f, +7.831887655e-04f, +3.918360714e-04f, -4.945030070e-04f, -1.584789098e-03f, -2.406444767e-03f, -2.525401601e-03f, -1.775991847e-03f, -3.718409871e-04f, +1.172812640e-03f, +2.278119471e-03f, +2.568187124e-03f, +2.033680987e-03f, +1.006907315e-03f, -2.643459550e-05f, -6.686257571e-04f, -7.756065067e-04f, -4.726709308e-04f, -3.555496353e-05f, +2.781103449e-04f, +3.498108096e-04f, +2.204139514e-04f, +2.230676018e-05f, -1.182069200e-04f, -1.470387212e-04f, -8.882269798e-05f, -7.214826744e-06f, +4.437296836e-05f, +4.976557993e-05f, +2.574381665e-05f, -5.879563279e-07f, -1.248497041e-05f, -9.841933680e-06f,
    +1.794768119e-04f, +1.115732986e-03f, +1.815758668e-03f, +8.205736066e-04f, -2.430535862e-03f, -5.978317722e-03f, -5.837838467e-03f, +5.858326709e-04f, +1.057220049e-02f, +1.600732567e-02f, +9.213115396e-03f, -8.959231640e-03f, -2.639915676e-02f, -2.721308020e-02f, -5.408723854e-03f, +2.667058725e-02f, +4.463900725e-02f, +3.076840142e-02f, -9.397282114e-03f, -4.783252540e-02f, -5.425696774e-02f, -2.075299912e-02f, +2.985625985e-02f, +6.029094770e-02f, +4.764417696e-02f, +1.465078130e-03f, -4.380216149e-02f, -5.577677149e-02f, -2.846664655e-02f, +1.514275784e-02f, +4.279644587e-02f, +3.770668841e-02f, +8.697533773e-03f, -2.016151009e-02f, -2.953292503e-02f, -1.767580425e-02f, +2.174498461e-03f, +1.476082419e-02f, +1.406934599e-02f, +4.909732185e-03f, -3.791786512e-03f, -6.607320087e-03f, -4.160847059e-03f, -3.723026219e-04f, +1.665675647e-03f, +1.534254489e-03f, +5.418008535e-04f, -1.056867379e-04f,
    -2.143779791e-05f, -3.255016448e-05f, -3.623541571e-06f, +6.771136134e-05f, +1.236283455e-04f, +7.694479968e-05f, -9.653833807e-05f, -2.856887703e-04f, -2.930155053e-04f, -1.030274097e-05f, +4.199475789e-04f, +6.425038326e-04f, +3.651468636e-04f, -3.303620685e-04f, -9.470903609e-04f, -9.212111215e-04f, -1.230682455e-04f, +9.303741423e-04f, +1.408756955e-03f, +8.381711999e-04f, -4.455372552e-04f, -1.489919637e-03f, -1.463059761e-03f, -3.418714729e-04f, +1.037957999e-03f, +1.635572511e-03f, +1.028343774e-03f, -2.746120345e-04f, -1.271677709e-03f, -1.271157102e-03f, -3.894974920e-04f, +6.256682876e-04f, +1.037896166e-03f, +6.681292984e-04f, -6.828342250e-05f, -5.809066006e-04f, -5.735950795e-04f, -1.919633541e-04f, +1.946492873e-04f, +3.228689785e-04f, +1.948821172e-04f, -7.995073534e-06f, -1.186791159e-04f, -1.013550330e-04f, -2.662153812e-05f, +2.535294614e-05f, +2.972677158e-05f, +1.029994154e-05f,
    /*  4, 8 (48) */
    -3.419026667e-04f, -7.191580447e-04f, -7.068744368e-04f, +1.291566484e-04f, +1.687754808e-03f, +3.028604419e-03f, +2.718080689e-03f, -1.334018877e-04f, -4.729282393e-03f, -8.311664841e-03f, -7.422532389e-03f, -3.690051289e-04f, +1.056824870e-02f, +1.902991082e-02f, +1.751238242e-02f, +2.360197545e-03f, -2.196020074e-02f, -4.242683867e-02f, -4.228724054e-02f, -9.520321375e-03f, +5.530338001e-02f, +1.364219603e-01f, +2.078337474e-01f, +2.440608974e-01f, +2.315816396e-01f, +1.750919182e-01f, +9.531867170e-02f, +1.953432129e-02f, -3.030728694e-02f, -4.590255639e-02f, -3.372462511e-02f, -9.298635668e-03f, +1.158199278e-02f, +1.989914247e-02f, +1.560449493e-02f, +4.935633097e-03f, -4.632393590e-03f, -8.605084859e-03f, -6.872437653e-03f, -2.346441579e-03f, +1.609552203e-03f, +3.163240712e-03f, +2.472974661e-03f, +8.573773257e-04f, -4.039106273e-04f, -7.951412884e-04f, -5.459737548e-04f, -1.594593269e-04f,
    +1.247738578e-05f, +8.700618332e-06f, -1.142221689e-05f, -3.968271065e-05f, -5.234036778e-05f, -2.430374389e-05f, +4.688882536e-05f, +1.251203224e-04f, +1.465688934e-04f, +6.059656432e-05f, -1.208675967e-04f, -3.029510298e-04f, -3.449078145e-04f, -1.481438948e-04f, +2.525095963e-04f, +6.596784399e-04f, +7.866043095e-04f, +4.123495821e-04f, -4.615551614e-04f, -1.552158922e-03f, -2.389629649e-03f, -2.534914823e-03f, -1.811384863e-03f, -4.209871051e-04f, +1.128443930e-03f, +2.254821845e-03f, +2.572557625e-03f, +2.060211405e-03f, +1.041633242e-03f, +1.458591480e-06f, -6.566652244e-04f, -7.796782035e-04f, -4.857269586e-04f, -4.840902647e-05f, +2.717964180e-04f, +3.511626720e-04f, +2.262674753e-04f, +2.813750178e-05f, -1.154505091e-04f, -1.477386512e-04f, -9.134581111e-05f, -9.504275476e-06f, +4.347881995e-05f, +5.018284270e-05f, +2.665932067e-05f, +5.897355422e-08f, -1.236906188e-05f, -1.005721173e-05f,
    +1.580390140e-04f, +1.083182822e-03f, +1.812135126e-03f, +8.882849680e-04f, -2.306907516e-03f, -5.901372922e-03f, -5.934376806e-03f, +3.001439006e-04f, +1.027918498e-02f, +1.599702293e-02f, +9.633062975e-03f, -8.316727808e-03f, -2.603400990e-02f, -2.754344226e-02f, -6.355814215e-03f, +2.574937612e-02f, +4.451593900e-02f, +3.169877556e-02f, -7.988525159e-03f, -4.699435420e-02f, -5.470250500e-02f, -2.224291876e-02f, +2.839320009e-02f, +5.994907623e-02f, +4.868213496e-02f, +3.100650641e-03f, -4.277381772e-02f, -5.605138352e-02f, -2.973832426e-02f, +1.387160074e-02f, +4.240694837e-02f, +3.833235670e-02f, +9.735429939e-03f, -1.949338079e-02f, -2.960120845e-02f, -1.825671085e-02f, +1.600903381e-03f, +1.456886084e-02f, +1.426399528e-02f, +5.232601164e-03f, -3.596904395e-03f, -6.615315161e-03f, -4.279526175e-03f, -4.736576549e-04f, +1.639054109e-03f, +1.559607435e-03f, +5.715276251e-04f, -9.538679632e-05f,
    -2.079101159e-05f, -3.266868091e-05f, -5.301850104e-06f, +6.526616266e-05f, +1.230300454e-04f, +8.051318266e-05f, -8.994836685e-05f, -2.815103813e-04f, -2.971559747e-04f, -2.283753055e-05f, +4.075846569e-04f, +6.423062653e-04f, +3.818011580e-04f, -3.065302152e-04f, -9.352507246e-04f, -9.347389443e-04f, -1.559894358e-04f, +9.020283335e-04f, +1.409105432e-03f, +8.706971109e-04f, -4.034917365e-04f, -1.470760737e-03f, -1.482916267e-03f, -3.866320012e-04f, +1.002124343e-03f, +1.635403767e-03f, +1.062551544e-03f, -2.332861382e-04f, -1.253899682e-03f, -1.287265709e-03f, -4.236844779e-04f, +6.003140652e-04f, +1.037704928e-03f, +6.884138412e-04f, -4.596278178e-05f, -5.724156817e-04f, -5.811799325e-04f, -2.059175552e-04f, +1.857618093e-04f, +3.234017925e-04f, +2.011171405e-04f, -2.472339476e-06f, -1.173327403e-04f, -1.032607123e-04f, -2.891718833e-05f, +2.448352570e-05f, +3.013446780e-05f, +1.092935588e-05f,
    /*  4, 9 (48) */
    -3.294252809e-04f, -7.104574263e-04f, -7.182966537e-04f, +8.947393773e-05f, +1.635414440e-03f, +3.004300675e-03f, +2.764969514e-03f, -8.281565258e-06f, -4.582713499e-03f, -8.251068276e-03f, -7.543399986e-03f, -6.719561588e-04f, +1.022334088e-02f, +1.888176693e-02f, +1.776489202e-02f, +3.019875985e-03f, -2.117359643e-02f, -4.201448908e-02f, -4.274879570e-02f, -1.107248030e-02f, +5.291375036e-02f, +1.338870455e-01f, +2.060223625e-01f, +2.436399103e-01f, +2.327100835e-01f, +1.773467400e-01f, +9.789122933e-02f, +2.159453270e-02f, -2.926565370e-02f, -4.590109780e-02f, -3.438129033e-02f, -1.007831387e-02f, +1.109626582e-02f, +1.985073345e-02f, +1.587629135e-02f, +5.286795769e-03f, -4.406126115e-03f, -8.576947357e-03f, -6.987888162e-03f, -2.494180230e-03f, +1.518206392e-03f, +3.153736437e-03f, +2.516453481e-03f, +9.075601684e-04f, -3.772513066e-04f, -7.950823148e-04f, -5.583428167e-04f, -1.695165387e-04f,
    +1.237551130e-05f, +9.062648661e-06f, -1.058146335e-05f, -3.888606991e-05f, -5.246248495e-05f, -2.591307205e-05f, +4.426993069e-05f, +1.231823616e-04f, +1.473760729e-04f, +6.500800187e-05f, -1.145051290e-04f, -2.986498630e-04f, -3.469617557e-04f, -1.579954647e-04f, +2.385040047e-04f, +6.496876654e-04f, +7.895111918e-04f, +4.323504425e-04f, -4.288356190e-04f, -1.519279236e-03f, -2.372115874e-03f, -2.543546566e-03f, -1.846099875e-03f, -4.699714128e-04f, +1.083644875e-03f, +2.230702699e-03f, +2.576087462e-03f, +2.086233724e-03f, +1.076345550e-03f, +2.974703766e-05f, -6.441584584e-04f, -7.833294736e-04f, -4.986446197e-04f, -6.138978928e-05f, +2.652332049e-04f, +3.523070318e-04f, +2.320501354e-04f, +3.402800705e-05f, -1.125783976e-04f, -1.483485705e-04f, -9.384507757e-05f, -1.182528874e-05f, +4.253653645e-05f, +5.056971542e-05f, +2.757280659e-05f, +7.212630777e-07f, -1.223790898e-05f, -1.026738752e-05f,
    +1.372480024e-04f, +1.050514141e-03f, +1.806833276e-03f, +9.535511306e-04f, -2.183877471e-03f, -5.820859740e-03f, -6.024325172e-03f, +1.863351932e-05f, +9.982029006e-03f, +1.597418540e-02f, +1.004064763e-02f, -7.674421542e-03f, -2.565220874e-02f, -2.784997248e-02f, -7.291064940e-03f, +2.481463718e-02f, +4.435994957e-02f, +3.260080389e-02f, -6.579419727e-03f, -4.612365709e-02f, -5.510599674e-02f, -2.371367949e-02f, +2.691028382e-02f, +5.956244423e-02f, +4.968425930e-02f, +4.736054408e-03f, -4.171126617e-02f, -5.628466966e-02f, -3.099222394e-02f, +1.258433503e-02f, +4.198326390e-02f, +3.893267077e-02f, +1.077313487e-02f, -1.880496695e-02f, -2.964717124e-02f, -1.882912653e-02f, +1.019723449e-03f, +1.436294328e-02f, +1.444975709e-02f, +5.556002956e-03f, -3.395787254e-03f, -6.617787500e-03f, -4.396858915e-03f, -5.769183672e-04f, +1.610136921e-03f, +1.584090961e-03f, +6.016620929e-04f, -8.445744044e-05f,
    -2.013851916e-05f, -3.274654767e-05f, -6.932342584e-06f, +6.281187603e-05f, +1.223288367e-04f, +8.394421207e-05f, -8.338804160e-05f, -2.771534900e-04f, -3.009907318e-04f, -3.519904534e-05f, +3.950271064e-04f, +6.415920685e-04f, +3.979985283e-04f, -2.826490864e-04f, -9.227590917e-04f, -9.474472378e-04f, -1.886064256e-04f, +8.731148588e-04f, +1.408359528e-03f, +9.024459511e-04f, -3.612362155e-04f, -1.450498990e-03f, -1.501610669e-03f, -4.310856293e-04f, +9.654981397e-04f, +1.633971743e-03f, +1.096006654e-03f, -1.916645172e-04f, -1.235083830e-03f, -1.302439913e-03f, -4.577151014e-04f, +5.743361015e-04f, +1.036690754e-03f, +7.083061374e-04f, -2.341196786e-05f, -5.633785327e-04f, -5.883693712e-04f, -2.198658333e-04f, +1.766016064e-04f, +3.236644660e-04f, +2.072744965e-04f, +3.149424362e-06f, -1.158507237e-04f, -1.051069733e-04f, -3.123864879e-05f, +2.356299303e-05f, +3.051755931e-05f, +1.156583771e-05f,
    /*  4,10 (48) */
    -3.170497696e-04f, -7.013947777e-04f, -7.288781171e-04f, +5.058786781e-05f, +1.582951955e-03f, +2.978387603e-03f, +2.809239445e-03f, +1.149007964e-04f, -4.435337427e-03f, -8.186060275e-03f, -7.657905115e-03f, -9.706060217e-04f, +9.876379128e-03f, +1.872377146e-02f, +1.800339602e-02f, +3.669563650e-03f, -2.038408523e-02f, -4.158213864e-02f, -4.317763132e-02f, -1.259175953e-02f, +5.054163449e-02f, +1.313434989e-01f, +2.041762626e-01f, +2.431699389e-01f, +2.337937284e-01f, +1.795774427e-01f, +1.004673168e-01f, +2.368076642e-02f, -2.818930815e-02f, -4.587135076e-02f, -3.502544879e-02f, -1.086164335e-02f, +1.059762120e-02f, +1.978934366e-02f, +1.614152455e-02f, +5.639102801e-03f, -4.174075979e-03f, -8.542919350e-03f, -7.100466560e-03f, -2.642528801e-03f, +1.424361314e-03f, +3.141911148e-03f, +2.558990017e-03f, +9.581298838e-04f, -3.496785000e-04f, -7.943610518e-04f, -5.705807257e-04f, -1.797839262e-04f,
    +1.226363572e-05f, +9.407489159e-06f, -9.750635465e-06f, -3.807534563e-05f, -5.254356191e-05f, -2.747635175e-05f, +4.166225889e-05f, +1.211901590e-04f, +1.480738929e-04f, +6.931713154e-05f, -1.081517273e-04f, -2.942129712e-04f, -3.487726173e-04f, -1.676298856e-04f, +2.245213585e-04f, +6.394270710e-04f, +7.919138599e-04f, +4.518343557e-04f, -3.963570956e-04f, -1.486165880e-03f, -2.353914507e-03f, -2.551296854e-03f, -1.880124898e-03f, -5.187751349e-04f, +1.038432244e-03f, +2.205769064e-03f, +2.578771288e-03f, +2.111733820e-03f, +1.111028863e-03f, +5.842132989e-05f, -6.311056663e-04f, -7.865531458e-04f, -5.114144858e-04f, -7.449071459e-05f, +2.584218823e-04f, +3.532406304e-04f, +2.377572560e-04f, +3.997511835e-05f, -1.095909776e-04f, -1.488667806e-04f, -9.631836077e-05f, -1.417666452e-05f, +4.154602144e-05f, +5.092534407e-05f, +2.848347424e-05f, +1.398643874e-06f, -1.209129542e-05f, -1.047211195e-05f,
    +1.171094832e-04f, +1.017767593e-03f, +1.799900934e-03f, +1.016363007e-03f, -2.061548634e-03f, -5.736915528e-03f, -6.107713214e-03f, -2.585199707e-04f, +9.681038274e-03f, +1.593898636e-02f, +1.043567474e-02f, -7.032829474e-03f, -2.525421021e-02f, -2.813262157e-02f, -8.213824032e-03f, +2.386718994e-02f, +4.417134314e-02f, +3.347391875e-02f, -5.171060199e-03f, -4.522121114e-02f, -5.546723295e-02f, -2.516417848e-02f, +2.540867315e-02f, +5.913135860e-02f, +5.064975744e-02f, +6.370026151e-03f, -4.061525952e-02f, -5.647633418e-02f, -3.222730777e-02f, +1.128189512e-02f, +4.152554879e-02f, +3.950700687e-02f, +1.180982562e-02f, -1.809666081e-02f, -2.967058320e-02f, -1.939250507e-02f, +4.313540776e-04f, +1.414307745e-02f, +1.462635870e-02f, +5.879667422e-03f, -3.188512758e-03f, -6.614638076e-03f, -4.512709639e-03f, -6.820253404e-04f, +1.578898272e-03f, +1.607653954e-03f, +6.321796522e-04f, -7.289160273e-05f,
    -1.948132439e-05f, -3.278470509e-05f, -8.514348974e-06f, +6.035119738e-05f, +1.215273449e-04f, +8.723701883e-05f, -7.686289059e-05f, -2.726245321e-04f, -3.045204117e-04f, -4.737872311e-05f, +3.822876665e-04f, +6.403668975e-04f, +4.137295927e-04f, -2.587386849e-04f, -9.096302455e-04f, -9.593308029e-04f, -2.208945727e-04f, +8.436595480e-04f, +1.406524065e-03f, +9.333948178e-04f, -3.188048226e-04f, -1.429152316e-03f, -1.519129192e-03f, -4.751971168e-04f, +9.281080801e-04f, +1.631276012e-03f, +1.128680965e-03f, -1.497796158e-04f, -1.215241647e-03f, -1.316663576e-03f, -4.915610870e-04f, +5.477518863e-04f, +1.034849023e-03f, +7.277868621e-04f, -6.477933725e-07f, -5.537976452e-04f, -5.951532014e-04f, -2.337961005e-04f, +1.671732861e-04f, +3.236530469e-04f, +2.133473835e-04f, +8.866574981e-06f, -1.142320367e-04f, -1.068907517e-04f, -3.358400885e-05f, +2.259114707e-05f, +3.087489644e-05f, +1.220870577e-05f,
    /*  4,11 (48) */
    -3.047861339e-04f, -6.919872885e-04f, -7.386287525e-04f, +1.251252218e-05f, +1.530408393e-03f, +2.950911251e-03f, +2.850901704e-03f, +2.360909554e-04f, -4.287263534e-03f, -8.116743143e-03f, -7.766056842e-03f, -1.264818993e-03f, +9.527606511e-03f, +1.855614158e-02f, +1.822791738e-02f, +4.308990721e-03f, -1.959217137e-02f, -4.113030429e-02f, -4.357398842e-02f, -1.407792541e-02f, +4.818771998e-02f, +1.287922020e-01f, +2.022961377e-01f, +2.426511638e-01f, +2.348321606e-01f, +1.817832118e-01f, +1.030460881e-01f, +2.579250024e-02f, -2.707827929e-02f, -4.581292943e-02f, -3.565655446e-02f, -1.164819649e-02f, +1.008620671e-02f, +1.971485294e-02f, +1.639994644e-02f, +5.992343431e-03f, -3.936318723e-03f, -8.502944231e-03f, -7.210057537e-03f, -2.791395581e-03f, +1.328042954e-03f, +3.127734483e-03f, +2.600536039e-03f, +1.009055228e-03f, -3.211950258e-04f, -7.929624079e-04f, -5.826720211e-04f, -1.902560381e-04f,
    +1.214210066e-05f, +9.735192555e-06f, -8.930240209e-06f, -3.725144604e-05f, -5.258424396e-05f, -2.899317705e-05f, +3.906749896e-05f, +1.191458798e-04f, +1.486633763e-04f, +7.352242204e-05f, -1.018114333e-04f, -2.896448614e-04f, -3.503421484e-04f, -1.770437336e-04f, +2.105698600e-04f, +6.289058638e-04f, +7.938169860e-04f, +4.707973205e-04f, -3.641321009e-04f, -1.452834710e-03f, -2.335036878e-03f, -2.558166103e-03f, -1.913448276e-03f, -5.673795826e-04f, +9.928230059e-04f, +2.180028346e-03f, +2.580604122e-03f, +2.136697738e-03f, +1.145667720e-03f, +8.747179280e-05f, -6.175073398e-04f, -7.893422111e-04f, -5.240271131e-04f, -8.770511911e-05f, +2.513637965e-04f, +3.539603077e-04f, +2.433841554e-04f, +4.597560078e-05f, -1.064887260e-04f, -1.492916248e-04f, -9.876351284e-05f, -1.655716031e-05f, +4.050721427e-05f, +5.124888558e-05f, +2.939051183e-05f, +2.090829182e-06f, -1.192901538e-05f, -1.067103444e-05f,
    +9.762815885e-05f, +9.849828881e-04f, +1.791386585e-03f, +1.076714204e-03f, -1.940021289e-03f, -5.649678509e-03f, -6.184576105e-03f, -5.311445028e-04f, +9.376517862e-03f, +1.589160763e-02f, +1.081796240e-02f, -6.392462576e-03f, -2.484048062e-02f, -2.839136025e-02f, -9.123454277e-03f, +2.290785914e-02f, +4.395044857e-02f, +3.431757830e-02f, -3.764536134e-03f, -4.428781632e-02f, -5.578603777e-02f, -2.659333080e-02f, +2.388954396e-02f, +5.865616148e-02f, +5.157786552e-02f, +8.001302163e-03f, -3.948657856e-02f, -5.662611379e-02f, -3.344254942e-02f, +9.965231544e-03f, +4.103398771e-02f, +4.005475875e-02f, +1.284467464e-02f, -1.736887395e-02f, -2.967123100e-02f, -1.994630271e-02f, -1.637991238e-04f, +1.390928135e-02f, +1.479353198e-02f, +6.203320469e-03f, -2.975165374e-03f, -6.605771501e-03f, -4.626941676e-03f, -7.889160921e-04f, +1.545314263e-03f, +1.630245101e-03f, +6.630545487e-04f, -6.068289696e-05f,
    -1.882041246e-05f, -3.278411916e-05f, -1.004726703e-05f, +5.788677766e-05f, +1.206282501e-04f, +9.039088257e-05f, -7.037832680e-05f, -2.679300144e-04f, -3.077459176e-04f, -5.936826082e-05f, +3.693791032e-04f, +6.386367957e-04f, +4.289854480e-04f, -2.348188846e-04f, -8.958794037e-04f, -9.703851603e-04f, -2.528296377e-04f, +8.136885621e-04f, +1.403604744e-03f, +9.635215340e-04f, -2.762317526e-04f, -1.406739489e-03f, -1.535459032e-03f, -5.189315099e-04f, +8.899834931e-04f, +1.627317182e-03f, +1.160546927e-03f, -1.076641795e-04f, -1.194385510e-03f, -1.329921279e-03f, -5.251941758e-04f, +5.205795147e-04f, +1.032175779e-03f, +7.468369003e-04f, +2.231261017e-05f, -5.436760041e-04f, -6.015214833e-04f, -2.476961529e-04f, +1.574817538e-04f, +3.233637847e-04f, +2.193289824e-04f, +1.467531985e-05f, -1.124757694e-04f, -1.086089913e-04f, -3.595129296e-05f, +2.156784201e-05f, +3.120533410e-05f, +1.285725242e-05f,
    /*  4,12 (48) */
    -2.926440332e-04f, -6.822520959e-04f, -7.475589927e-04f, -2.473892386e-05f, +1.477824149e-03f, +2.921918074e-03f, +2.889969203e-03f, +3.552368352e-04f, -4.138600157e-03f, -8.043220721e-03f, -7.867868276e-03f, -1.554463854e-03f, +9.177264362e-03f, +1.837909784e-02f, +1.843848724e-02f, +4.937896585e-03f, -1.879835439e-02f, -4.065950696e-02f, -4.393812052e-02f, -1.553076012e-02f, +4.585268310e-02f, +1.262340359e-01f, +2.003826895e-01f, +2.420837842e-01f, +2.358249836e-01f, +1.839632402e-01f, +1.056266922e-01f, +2.792919798e-02f, -2.593261157e-02f, -4.572545764e-02f, -3.627406180e-02f, -1.243753870e-02f, +9.562179601e-03f, +1.962714782e-02f, +1.665131023e-02f, +6.346303739e-03f, -3.692934568e-03f, -8.456968631e-03f, -7.316546263e-03f, -2.940687206e-03f, +1.229279441e-03f, +3.111177323e-03f, +2.641043253e-03f, +1.060304113e-03f, -2.918045140e-04f, -7.908715787e-04f, -5.946010365e-04f, -2.009270726e-04f,
    +1.201125048e-05f, +1.004582615e-05f, -8.120766612e-06f, -3.641527474e-05f, -5.258519756e-05f, -3.046318302e-05f, +3.648730630e-05f, +1.170516966e-04f, +1.491456078e-04f, +7.762243142e-05f, -9.548823139e-05f, -2.849500731e-04f, -3.516722310e-04f, -1.862337587e-04f, +1.966576036e-04f, +6.181333013e-04f, +7.952254626e-04f, +4.892356315e-04f, -3.321729341e-04f, -1.419301593e-03f, -2.315494573e-03f, -2.564155124e-03f, -1.946058681e-03f, -6.157661632e-04f, +9.468343174e-04f, +2.153488329e-03f, +2.581581344e-03f, +2.161111704e-03f, +1.180246587e-03f, +1.168884923e-04f, -6.033642566e-04f, -7.916898281e-04f, -5.364730471e-04f, -1.010261762e-04f, +2.440604639e-04f, +3.544630052e-04f, +2.489261490e-04f, +5.202614347e-05f, -1.032722050e-04f, -1.496214900e-04f, -1.011783760e-04f, -1.896549344e-05f, +3.942009059e-05f, +5.153950867e-05f, +3.029309637e-05f, +2.797513799e-06f, -1.175087387e-05f, -1.086380328e-05f,
    +7.880774639e-05f, +9.521987690e-04f, +1.781339318e-03f, +1.134600982e-03f, -1.819393039e-03f, -5.559287626e-03f, -6.254954431e-03f, -7.990745172e-04f, +9.068771944e-03f, +1.583223937e-02f, +1.118734151e-02f, -5.753825781e-03f, -2.441149517e-02f, -2.862617914e-02f, -1.001933368e-02f, +2.193747398e-02f, +4.369761893e-02f, +3.513126686e-02f, -2.360931390e-03f, -4.332429479e-02f, -5.606226953e-02f, -2.800007029e-02f, +2.235408493e-02f, +5.813722997e-02f, +5.246784902e-02f, +9.628619345e-03f, -3.832603163e-02f, -5.673377797e-02f, -3.463693493e-02f, +8.635310265e-03f, +4.050879353e-02f, +4.057533827e-02f, +1.387685042e-02f, -1.662203705e-02f, -2.964891839e-02f, -2.048997872e-02f, -7.653206070e-04f, +1.366158520e-02f, +1.495101374e-02f, +6.526684254e-03f, -2.755836392e-03f, -6.591096181e-03f, -4.739417445e-03f, -8.975250834e-04f, +1.509362970e-03f, +1.651812943e-03f, +6.942598828e-04f, -4.782564454e-05f,
    -1.815674907e-05f, -3.274577985e-05f, -1.153056169e-05f, +5.542122079e-05f, +1.196342840e-04f, +9.340523006e-05f, -6.393964423e-05f, -2.630765080e-04f, -3.106684165e-04f, -7.115961947e-05f, +3.563141973e-04f, +6.364081860e-04f, +4.437576740e-04f, -2.109094147e-04f, -8.815222021e-04f, -9.806065503e-04f, -2.843878024e-04f, +7.832283699e-04f, +1.399608137e-03f, +9.928046655e-04f, -2.335512367e-04f, -1.383280130e-03f, -1.550588370e-03f, -5.622541709e-04f, +8.511543217e-04f, +1.622096891e-03f, +1.191577599e-03f, -6.535122827e-05f, -1.172528677e-03f, -1.342198342e-03f, -5.585861505e-04f, +4.928376748e-04f, +1.028667743e-03f, +7.654373648e-04f, +4.545180504e-05f, -5.330170897e-04f, -6.074645433e-04f, -2.615536806e-04f, +1.475322116e-04f, +3.227931365e-04f, +2.252124631e-04f, +2.057171849e-05f, -1.105811345e-04f, -1.102586480e-04f, -3.833846165e-05f, +2.049298849e-05f, +3.150773327e-05f, +1.351074403e-05f,
    /*  4,13 (48) */
    -2.806327827e-04f, -6.722062698e-04f, -7.556797593e-04f, -6.115419859e-05f, +1.425238952e-03f, +2.891454891e-03f, +2.926456509e-03f, +4.722885319e-04f, -3.989454550e-03f, -7.965598290e-03f, -7.963356507e-03f, -1.839413927e-03f, +8.825592131e-03f, +1.819286408e-02f, +1.863514484e-02f, +5.556029886e-03f, -1.800312893e-02f, -4.017027133e-02f, -4.427029345e-02f, -1.695006172e-02f, +4.353718853e-02f, +1.236698808e-01f, +1.984366308e-01f, +2.414680180e-01f, +2.367718179e-01f, +1.861167285e-01f, +1.082082735e-01f, +3.009030968e-02f, -2.475236498e-02f, -4.560856914e-02f, -3.687742605e-02f, -1.322922853e-02f, +9.025706554e-03f, +1.952612165e-02f, +1.689537070e-02f, +6.700766744e-03f, -3.444008419e-03f, -8.404942487e-03f, -7.419818468e-03f, -3.090308696e-03f, +1.128101065e-03f, +3.092211830e-03f, +2.680463344e-03f, +1.111843622e-03f, -2.615114176e-04f, -7.880740649e-04f, -6.063519103e-04f, -2.117908759e-04f,
    +1.187143190e-05f, +1.033947149e-05f, -7.322685613e-06f, -3.556773003e-05f, -5.254710946e-05f, -3.188604545e-05f, +3.392330190e-05f, +1.149097875e-04f, +1.495217318e-04f, +8.161580702e-05f, -8.918604661e-05f, -2.801331747e-04f, -3.527648773e-04f, -1.951968851e-04f, +1.827925721e-04f, +6.071186859e-04f, +7.961443986e-04f, +5.071458790e-04f, -3.004916782e-04f, -1.385582399e-03f, -2.295299430e-03f, -2.569265114e-03f, -1.977945120e-03f, -6.639163882e-04f, +9.004835180e-04f, +2.126157165e-03f, +2.581698707e-03f, +2.184962126e-03f, +1.214749860e-03f, +1.466612390e-04f, -5.886774826e-04f, -7.935893281e-04f, -5.487428281e-04f, -1.144469186e-04f, +2.365135726e-04f, +3.547457686e-04f, +2.543785525e-04f, +5.812336101e-05f, -9.994206275e-05f, -1.498548087e-04f, -1.035607843e-04f, -2.140034152e-05f, +3.828466290e-05f, +5.179639469e-05f, +3.119039424e-05f, +3.518374039e-06f, -1.155668711e-05f, -1.105006591e-05f,
    +6.065099732e-05f, +9.194529891e-04f, +1.769808756e-03f, +1.190022202e-03f, -1.699758755e-03f, -5.465882396e-03f, -6.318894076e-03f, -1.062151025e-03f, +8.758103528e-03f, +1.576107975e-02f, +1.154365571e-02f, -5.117417595e-03f, -2.396773750e-02f, -2.883708855e-02f, -1.090085588e-02f, +2.095686743e-02f, +4.341323113e-02f, +3.591449523e-02f, -9.613232535e-04f, -4.233149012e-02f, -5.629582076e-02f, -2.938335042e-02f, +2.080349656e-02f, +5.757497580e-02f, +5.331900334e-02f, +1.125071624e-02f, -3.713445403e-02f, -5.679912920e-02f, -3.580946361e-02f, +7.293111923e-03f, +3.995020738e-02f, +4.106817594e-02f, +1.490551817e-02f, -1.585659968e-02f, -2.960346658e-02f, -2.102299581e-02f, -1.372785150e-03f, +1.340003152e-02f, +1.509854595e-02f, +6.849477391e-03f, -2.530623929e-03f, -6.570524462e-03f, -4.849998580e-03f, -1.007783731e-03f, +1.471024509e-03f, +1.672305932e-03f, +7.257676160e-04f, -3.431490051e-05f,
    -1.749127965e-05f, -3.267069945e-05f, -1.296376440e-05f, +5.295708166e-05f, +1.185482258e-04f, +9.627963359e-05f, -5.755201443e-05f, -2.580706410e-04f, -3.132893352e-04f, -8.274502853e-05f, +3.431057333e-04f, +6.336878614e-04f, +4.580383367e-04f, -1.870298427e-04f, -8.665746790e-04f, -9.899919317e-04f, -3.155456883e-04f, +7.523057237e-04f, +1.394541677e-03f, +1.021223537e-03f, -1.907975127e-04f, -1.358794677e-03f, -1.564506376e-03f, -6.051308071e-04f, +8.116510977e-04f, +1.615617815e-03f, +1.221746674e-03f, -2.287402917e-05f, -1.149685270e-03f, -1.353480834e-03f, -5.917088586e-04f, +4.645456348e-04f, +1.024322317e-03f, +7.835696146e-04f, +6.875206024e-05f, -5.218248785e-04f, -6.129729854e-04f, -2.753562781e-04f, +1.373301571e-04f, +3.219377725e-04f, +2.309909909e-04f, +2.655168425e-05f, -1.085474701e-04f, -1.118366926e-04f, -4.074341266e-05f, +1.936655489e-05f, +3.178096262e-05f, +1.416842128e-05f,
    /*  4,14 (48) */
    -2.687613508e-04f, -6.618667983e-04f, -7.630024450e-04f, -9.672192862e-05f, +1.372691842e-03f, +2.859568845e-03f, +2.960379811e-03f, +5.871983194e-04f, -3.839932818e-03f, -7.883982483e-03f, -8.052542554e-03f, -2.119547102e-03f, +8.472827254e-03f, +1.799766720e-02f, +1.881793742e-02f, +6.163148572e-03f, -1.720698453e-02f, -3.966312545e-02f, -4.457078513e-02f, -1.833564411e-02f, +4.124188910e-02f, +1.211006157e-01f, +1.964586857e-01f, +2.408041017e-01f, +2.376723015e-01f, +1.882428856e-01f, +1.107899723e-01f, +3.227527181e-02f, -2.353761512e-02f, -4.546190791e-02f, -3.746610354e-02f, -1.402281786e-02f, +8.476963726e-03f, +1.941167473e-02f, +1.713188427e-02f, +7.055512513e-03f, -3.189629866e-03f, -8.346819126e-03f, -7.519760531e-03f, -3.240163505e-03f, +1.024540281e-03f, +3.070811488e-03f, +2.718748007e-03f, +1.163640017e-03f, -2.303210233e-04f, -7.845556909e-04f, -6.179085974e-04f, -2.228409418e-04f,
    +1.172299359e-05f, +1.061622408e-05f, -6.536449958e-06f, -3.470970428e-05f, -5.247068588e-05f, -3.326148050e-05f, +3.137707163e-05f, +1.127223349e-04f, +1.497929516e-04f, +8.550128532e-05f, -8.290874270e-05f, -2.751987605e-04f, -3.536222271e-04f, -2.039302110e-04f, +1.689826330e-04f, +5.958713593e-04f, +7.965791143e-04f, +5.245249488e-04f, -2.691001954e-04f, -1.351692992e-03f, -2.274463530e-03f, -2.573497662e-03f, -2.009096942e-03f, -7.118118828e-04f, +8.537881199e-04f, +2.098043378e-03f, +2.580952332e-03f, +2.208235610e-03f, +1.249161875e-03f, +1.767795924e-04f, -5.734483729e-04f, -7.950342203e-04f, -5.608269972e-04f, -1.279602412e-04f, +2.287249824e-04f, +3.548057515e-04f, +2.597366849e-04f, +6.426379482e-05f, -9.649903394e-05f, -1.499900605e-04f, -1.059085645e-04f, -2.386034291e-05f, +3.710098106e-05f, +5.201873851e-05f, +3.208156172e-05f, +4.253067716e-06f, -1.134628287e-05f, -1.122946931e-05f,
    +4.315971767e-05f, +8.867822897e-04f, +1.756844992e-03f, +1.242979284e-03f, -1.581210529e-03f, -5.369602763e-03f, -6.376446090e-03f, -1.320221666e-03f, +8.444814193e-03f, +1.567833472e-02f, +1.188676144e-02f, -4.483729733e-03f, -2.350969916e-02f, -2.902411839e-02f, -1.176743056e-02f, +1.996687550e-02f, +4.309768544e-02f, +3.666680095e-02f, +4.332184234e-04f, -4.131026659e-02f, -5.648661828e-02f, -3.074214510e-02f, +1.923899018e-02f, +5.696984499e-02f, +5.413065444e-02f, +1.286633405e-02f, -3.591270736e-02f, -5.682200323e-02f, -3.695914888e-02f, +5.939631090e-03f, +3.935849852e-02f, +4.153272158e-02f, +1.592984048e-02f, -1.507303007e-02f, -2.953471452e-02f, -2.154482068e-02f, -1.985758136e-03f, +1.312467524e-02f, +1.523587610e-02f, +7.171415163e-03f, -2.299632938e-03f, -6.543972778e-03f, -4.958546050e-03f, -1.119620424e-03f, +1.430281096e-03f, +1.691672486e-03f, +7.575485786e-04f, -2.014647924e-05f,
    -1.682492863e-05f, -3.255991088e-05f, -1.434647234e-05f, +5.049686428e-05f, +1.173728985e-04f, +9.901380912e-05f, -5.122048314e-05f, -2.529190916e-04f, -3.156103559e-04f, -9.411699013e-05f, +3.297664872e-04f, +6.304829761e-04f, +4.718199911e-04f, -1.631995593e-04f, -8.510532580e-04f, -9.985389804e-04f, -3.462803737e-04f, +7.209476360e-04f, +1.388413650e-03f, +1.048758245e-03f, -1.480047969e-04f, -1.333304376e-03f, -1.577203222e-03f, -6.475274993e-04f, +7.715049169e-04f, +1.607883660e-03f, +1.251028504e-03f, +1.973393099e-05f, -1.125870273e-03f, -1.363755593e-03f, -6.245342378e-04f, +4.357232295e-04f, +1.019137592e-03f, +8.012152726e-04f, +9.219536492e-05f, -5.101038438e-04f, -6.180377019e-04f, -2.890914543e-04f, +1.268813810e-04f, +3.207945823e-04f, +2.366577331e-04f, +3.261098626e-05f, -1.063742421e-04f, -1.133401148e-04f, -4.316398208e-05f, +1.818856848e-05f, +3.202390001e-05f, +1.482949967e-05f,
    /*  4,15 (48) */
    -2.570383573e-04f, -6.512505742e-04f, -7.695388949e-04f, -1.314316329e-04f, +1.320221156e-03f, +2.826307365e-03f, +2.991756882e-03f, +6.999206543e-04f, -3.690139866e-03f, -7.798481197e-03f, -8.135451297e-03f, -2.394745863e-03f, +8.119205027e-03f, +1.779373699e-02f, +1.898692005e-02f, +6.759019932e-03f, -1.641040541e-02f, -3.913860051e-02f, -4.483988533e-02f, -1.968733711e-02f, +3.896742557e-02f, +1.185271180e-01f, +1.944495887e-01f, +2.400922898e-01f, +2.385260896e-01f, +1.903409290e-01f, +1.133709246e-01f, +3.448350742e-02f, -2.228845324e-02f, -4.528512831e-02f, -3.803955191e-02f, -1.481785208e-02f, +7.916136729e-03f, +1.928371449e-02f, +1.736060925e-02f, +7.410318264e-03f, -2.929893182e-03f, -8.282555331e-03f, -7.616259565e-03f, -3.390153565e-03f, +9.186317160e-04f, +3.046951145e-03f, +2.755848988e-03f, +1.215658755e-03f, -1.982394616e-04f, -7.803026232e-04f, -6.292548803e-04f, -2.340704111e-04f,
    +1.156628587e-05f, +1.087619307e-05f, -5.762494102e-06f, -3.384208325e-05f, -5.235665165e-05f, -3.458924435e-05f, +2.885016553e-05f, +1.104915233e-04f, +1.499605271e-04f, +8.927769176e-05f, -7.666012020e-05f, -2.701514474e-04f, -3.542465450e-04f, -2.124310090e-04f, +1.552355348e-04f, +5.844006965e-04f, +7.965351371e-04f, +5.413700217e-04f, -2.380101219e-04f, -1.317649222e-03f, -2.252999191e-03f, -2.576854743e-03f, -2.039503840e-03f, -7.594343941e-04f, +8.067658006e-04f, +2.069155853e-03f, +2.579338719e-03f, +2.230918960e-03f, +1.283466916e-03f, +2.072328639e-04f, -5.576785734e-04f, -7.960181966e-04f, -5.727161007e-04f, -1.415589039e-04f, +2.206967259e-04f, +3.546402178e-04f, +2.649958715e-04f, +7.044391465e-05f, -9.294394045e-05f, -1.500257737e-04f, -1.082195383e-04f, -2.634409715e-05f, +3.586913284e-05f, +5.220574935e-05f, +3.296574548e-05f, +5.001234134e-06f, -1.111950086e-05f, -1.140166030e-05f,
    +2.633478904e-05f, +8.542223788e-04f, +1.742498519e-03f, +1.293476148e-03f, -1.463837631e-03f, -5.270588954e-03f, -6.427666573e-03f, -1.573140758e-03f, +8.129203837e-03f, +1.558421773e-02f, +1.221652793e-02f, -3.853246757e-03f, -2.303787917e-02f, -2.918731795e-02f, -1.261848382e-02f, +1.896833652e-02f, +4.275140507e-02f, +3.738774859e-02f, +1.821632073e-03f, -4.026150834e-02f, -5.663462307e-02f, -3.207544947e-02f, +1.766178696e-02f, +5.632231750e-02f, +5.490215935e-02f, +1.447421771e-02f, -3.466167885e-02f, -5.680226930e-02f, -3.808501915e-02f, +4.575875497e-03f, +3.873396428e-02f, +4.196844481e-02f, +1.694897807e-02f, -1.427181479e-02f, -2.944251916e-02f, -2.205492453e-02f, -2.603795838e-03f, +1.283558378e-02f, +1.536275749e-02f, +7.492209745e-03f, -2.062975205e-03f, -6.511361792e-03f, -5.064920292e-03f, -1.232960539e-03f, +1.387117114e-03f, +1.709861055e-03f, +7.895724787e-04f, -5.316979569e-06f,
    -1.615859866e-05f, -3.241446603e-05f, -1.567834766e-05f, +4.804301997e-05f, +1.161111654e-04f, +1.016076144e-04f, -4.494996720e-05f, -2.476285808e-04f, -3.176334114e-04f, -1.052682830e-04f, +3.163092155e-04f, +6.268010350e-04f, +4.850956842e-04f, -1.394377625e-04f, -8.349747314e-04f, -1.006246087e-03f, -3.765694119e-04f, +6.891813548e-04f, +1.381233184e-03f, +1.075389676e-03f, -1.052072550e-04f, -1.306831259e-03f, -1.588670087e-03f, -6.894107303e-04f, +7.307474127e-04f, +1.598899162e-03f, +1.279398121e-03f, +6.243897335e-05f, -1.101099518e-03f, -1.373010239e-03f, -6.570343398e-04f, +4.063908467e-04f, +1.013112354e-03f, +8.183562434e-04f, +1.157634420e-04f, -4.978589565e-04f, -6.226498844e-04f, -3.027466434e-04f, +1.161919659e-04f, +3.193606803e-04f, +2.422058659e-04f, +3.874525151e-05f, -1.040610471e-04f, -1.147659265e-04f, -4.559794561e-05f, +1.695911659e-05f, +3.223543411e-05f, +1.549316995e-05f,
    /*  4,16 (48) */
    -2.454720714e-04f, -6.403743812e-04f, -7.753013890e-04f, -1.652737161e-04f, +1.267864505e-03f, +2.791718120e-03f, +3.020607048e-03f, +8.104121777e-04f, -3.540179339e-03f, -7.709203505e-03f, -8.212111417e-03f, -2.664897310e-03f, +7.764958482e-03f, +1.758130598e-02f, +1.914215558e-02f, +7.343420628e-03f, -1.561387028e-02f, -3.859723048e-02f, -4.507789545e-02f, -2.100498633e-02f, +3.671442638e-02f, +1.159502633e-01f, +1.924100849e-01f, +2.393328554e-01f, +2.393328554e-01f, +1.924100849e-01f, +1.159502633e-01f, +3.671442638e-02f, -2.100498633e-02f, -4.507789545e-02f, -3.859723048e-02f, -1.561387028e-02f, +7.343420628e-03f, +1.914215558e-02f, +1.758130598e-02f, +7.764958482e-03f, -2.664897310e-03f, -8.212111417e-03f, -7.709203505e-03f, -3.540179339e-03f, +8.104121777e-04f, +3.020607048e-03f, +2.791718120e-03f, +1.267864505e-03f, -1.652737161e-04f, -7.753013890e-04f, -6.403743812e-04f, -2.454720714e-04f,
    +1.140166030e-05f, +1.111950086e-05f, -5.001234134e-06f, -3.296574548e-05f, -5.220574935e-05f, -3.586913284e-05f, +2.634409715e-05f, +1.082195383e-04f, +1.500257737e-04f, +9.294394045e-05f, -7.044391465e-05f, -2.649958715e-04f, -3.546402178e-04f, -2.206967259e-04f, +1.415589039e-04f, +5.727161007e-04f, +7.960181966e-04f, +5.576785734e-04f, -2.072328639e-04f, -1.283466916e-03f, -2.230918960e-03f, -2.579338719e-03f, -2.069155853e-03f, -8.067658006e-04f, +7.594343941e-04f, +2.039503840e-03f, +2.576854743e-03f, +2.252999191e-03f, +1.317649222e-03f, +2.380101219e-04f, -5.413700217e-04f, -7.965351371e-04f, -5.844006965e-04f, -1.552355348e-04f, +2.124310090e-04f, +3.542465450e-04f, +2.701514474e-04f, +7.666012020e-05f, -8.927769176e-05f, -1.499605271e-04f, -1.104915233e-04f, -2.885016553e-05f, +3.458924435e-05f, +5.235665165e-05f, +3.384208325e-05f, +5.762494102e-06f, -1.087619307e-05f, -1.156628587e-05f,
    +1.017619038e-05f, +8.218079128e-04f, +1.726820172e-03f, +1.341519168e-03f, -1.347726465e-03f, -5.168981339e-03f, -6.472616540e-03f, -1.820769339e-03f, +7.811570426e-03f, +1.547894945e-02f, +1.253283714e-02f, -3.226445722e-03f, -2.255278348e-02f, -2.932675571e-02f, -1.345345855e-02f, +1.796209043e-02f, +4.237483565e-02f, +3.807692994e-02f, +3.202865258e-03f, -3.918611867e-02f, -5.673983033e-02f, -3.338228073e-02f, +1.607311687e-02f, +5.563290677e-02f, +5.563290677e-02f, +1.607311687e-02f, -3.338228073e-02f, -5.673983033e-02f, -3.918611867e-02f, +3.202865258e-03f, +3.807692994e-02f, +4.237483565e-02f, +1.796209043e-02f, -1.345345855e-02f, -2.932675571e-02f, -2.255278348e-02f, -3.226445722e-03f, +1.253283714e-02f, +1.547894945e-02f, +7.811570426e-03f, -1.820769339e-03f, -6.472616540e-03f, -5.168981339e-03f, -1.347726465e-03f, +1.341519168e-03f, +1.726820172e-03f, +8.218079128e-04f, +1.017619038e-05f,
    -1.549316995e-05f, -3.223543411e-05f, -1.695911659e-05f, +4.559794561e-05f, +1.147659265e-04f, +1.040610471e-04f, -3.874525151e-05f, -2.422058659e-04f, -3.193606803e-04f, -1.161919659e-04f, +3.027466434e-04f, +6.226498844e-04f, +4.978589565e-04f, -1.157634420e-04f, -8.183562434e-04f, -1.013112354e-03f, -4.063908467e-04f, +6.570343398e-04f, +1.373010239e-03f, +1.101099518e-03f, -6.243897335e-05f, -1.279398121e-03f, -1.598899162e-03f, -7.307474127e-04f, +6.894107303e-04f, +1.588670087e-03f, +1.306831259e-03f, +1.052072550e-04f, -1.075389676e-03f, -1.381233184e-03f, -6.891813548e-04f, +3.765694119e-04f, +1.006246087e-03f, +8.349747314e-04f, +1.394377625e-04f, -4.850956842e-04f, -6.268010350e-04f, -3.163092155e-04f, +1.052682830e-04f, +3.176334114e-04f, +2.476285808e-04f, +4.494996720e-05f, -1.016076144e-04f, -1.161111654e-04f, -4.804301997e-05f, +1.567834766e-05f, +3.241446603e-05f, +1.615859866e-05f,
    /*  4,17 (48) */
    -2.340704111e-04f, -6.292548803e-04f, -7.803026232e-04f, -1.982394616e-04f, +1.215658755e-03f, +2.755848988e-03f, +3.046951145e-03f, +9.186317160e-04f, -3.390153565e-03f, -7.616259565e-03f, -8.282555331e-03f, -2.929893182e-03f, +7.410318264e-03f, +1.736060925e-02f, +1.928371449e-02f, +7.916136729e-03f, -1.481785208e-02f, -3.803955191e-02f, -4.528512831e-02f, -2.228845324e-02f, +3.448350742e-02f, +1.133709246e-01f, +1.903409290e-01f, +2.385260896e-01f, +2.400922898e-01f, +1.944495887e-01f, +1.185271180e-01f, +3.896742557e-02f, -1.968733711e-02f, -4.483988533e-02f, -3.913860051e-02f, -1.641040541e-02f, +6.759019932e-03f, +1.898692005e-02f, +1.779373699e-02f, +8.119205027e-03f, -2.394745863e-03f, -8.135451297e-03f, -7.798481197e-03f, -3.690139866e-03f, +6.999206543e-04f, +2.991756882e-03f, +2.826307365e-03f, +1.320221156e-03f, -1.314316329e-04f, -7.695388949e-04f, -6.512505742e-04f, -2.570383573e-04f,
    +1.122946931e-05f, +1.134628287e-05f, -4.253067716e-06f, -3.208156172e-05f, -5.201873851e-05f, -3.710098106e-05f, +2.386034291e-05f, +1.059085645e-04f, +1.499900605e-04f, +9.649903394e-05f, -6.426379482e-05f, -2.597366849e-04f, -3.548057515e-04f, -2.287249824e-04f, +1.279602412e-04f, +5.608269972e-04f, +7.950342203e-04f, +5.734483729e-04f, -1.767795924e-04f, -1.249161875e-03f, -2.208235610e-03f, -2.580952332e-03f, -2.098043378e-03f, -8.537881199e-04f, +7.118118828e-04f, +2.009096942e-03f, +2.573497662e-03f, +2.274463530e-03f, +1.351692992e-03f, +2.691001954e-04f, -5.245249488e-04f, -7.965791143e-04f, -5.958713593e-04f, -1.689826330e-04f, +2.039302110e-04f, +3.536222271e-04f, +2.751987605e-04f, +8.290874270e-05f, -8.550128532e-05f, -1.497929516e-04f, -1.127223349e-04f, -3.137707163e-05f, +3.326148050e-05f, +5.247068588e-05f, +3.470970428e-05f, +6.536449958e-06f, -1.061622408e-05f, -1.172299359e-05f,
    -5.316979569e-06f, +7.895724787e-04f, +1.709861055e-03f, +1.387117114e-03f, -1.232960539e-03f, -5.064920292e-03f, -6.511361792e-03f, -2.062975205e-03f, +7.492209745e-03f, +1.536275749e-02f, +1.283558378e-02f, -2.603795838e-03f, -2.205492453e-02f, -2.944251916e-02f, -1.427181479e-02f, +1.694897807e-02f, +4.196844481e-02f, +3.873396428e-02f, +4.575875497e-03f, -3.808501915e-02f, -5.680226930e-02f, -3.466167885e-02f, +1.447421771e-02f, +5.490215935e-02f, +5.632231750e-02f, +1.766178696e-02f, -3.207544947e-02f, -5.663462307e-02f, -4.026150834e-02f, +1.821632073e-03f, +3.738774859e-02f, +4.275140507e-02f, +1.896833652e-02f, -1.261848382e-02f, -2.918731795e-02f, -2.303787917e-02f, -3.853246757e-03f, +1.221652793e-02f, +1.558421773e-02f, +8.129203837e-03f, -1.573140758e-03f, -6.427666573e-03f, -5.270588954e-03f, -1.463837631e-03f, +1.293476148e-03f, +1.742498519e-03f, +8.542223788e-04f, +2.633478904e-05f,
    -1.482949967e-05f, -3.202390001e-05f, -1.818856848e-05f, +4.316398208e-05f, +1.133401148e-04f, +1.063742421e-04f, -3.261098626e-05f, -2.366577331e-04f, -3.207945823e-04f, -1.268813810e-04f, +2.890914543e-04f, +6.180377019e-04f, +5.101038438e-04f, -9.219536492e-05f, -8.012152726e-04f, -1.019137592e-03f, -4.357232295e-04f, +6.245342378e-04f, +1.363755593e-03f, +1.125870273e-03f, -1.973393099e-05f, -1.251028504e-03f, -1.607883660e-03f, -7.715049169e-04f, +6.475274993e-04f, +1.577203222e-03f, +1.333304376e-03f, +1.480047969e-04f, -1.048758245e-03f, -1.388413650e-03f, -7.209476360e-04f, +3.462803737e-04f, +9.985389804e-04f, +8.510532580e-04f, +1.631995593e-04f, -4.718199911e-04f, -6.304829761e-04f, -3.297664872e-04f, +9.411699013e-05f, +3.156103559e-04f, +2.529190916e-04f, +5.122048314e-05f, -9.901380912e-05f, -1.173728985e-04f, -5.049686428e-05f, +1.434647234e-05f, +3.255991088e-05f, +1.682492863e-05f,
    /*  4,18 (48) */
    -2.228409418e-04f, -6.179085974e-04f, -7.845556909e-04f, -2.303210233e-04f, +1.163640017e-03f, +2.718748007e-03f, +3.070811488e-03f, +1.024540281e-03f, -3.240163505e-03f, -7.519760531e-03f, -8.346819126e-03f, -3.189629866e-03f, +7.055512513e-03f, +1.713188427e-02f, +1.941167473e-02f, +8.476963726e-03f, -1.402281786e-02f, -3.746610354e-02f, -4.546190791e-02f, -2.353761512e-02f, +3.227527181e-02f, +1.107899723e-01f, +1.882428856e-01f, +2.376723015e-01f, +2.408041017e-01f, +1.964586857e-01f, +1.211006157e-01f, +4.124188910e-02f, -1.833564411e-02f, -4.457078513e-02f, -3.966312545e-02f, -1.720698453e-02f, +6.163148572e-03f, +1.881793742e-02f, +1.799766720e-02f, +8.472827254e-03f, -2.119547102e-03f, -8.052542554e-03f, -7.883982483e-03f, -3.839932818e-03f, +5.871983194e-04f, +2.960379811e-03f, +2.859568845e-03f, +1.372691842e-03f, -9.672192862e-05f, -7.630024450e-04f, -6.618667983e-04f, -2.687613508e-04f,
    +1.105006591e-05f, +1.155668711e-05f, -3.518374039e-06f, -3.119039424e-05f, -5.179639469e-05f, -3.828466290e-05f, +2.140034152e-05f, +1.035607843e-04f, +1.498548087e-04f, +9.994206275e-05f, -5.812336101e-05f, -2.543785525e-04f, -3.547457686e-04f, -2.365135726e-04f, +1.144469186e-04f, +5.487428281e-04f, +7.935893281e-04f, +5.886774826e-04f, -1.466612390e-04f, -1.214749860e-03f, -2.184962126e-03f, -2.581698707e-03f, -2.126157165e-03f, -9.004835180e-04f, +6.639163882e-04f, +1.977945120e-03f, +2.569265114e-03f, +2.295299430e-03f, +1.385582399e-03f, +3.004916782e-04f, -5.071458790e-04f, -7.961443986e-04f, -6.071186859e-04f, -1.827925721e-04f, +1.951968851e-04f, +3.527648773e-04f, +2.801331747e-04f, +8.918604661e-05f, -8.161580702e-05f, -1.495217318e-04f, -1.149097875e-04f, -3.392330190e-05f, +3.188604545e-05f, +5.254710946e-05f, +3.556773003e-05f, +7.322685613e-06f, -1.033947149e-05f, -1.187143190e-05f,
    -2.014647924e-05f, +7.575485786e-04f, +1.691672486e-03f, +1.430281096e-03f, -1.119620424e-03f, -4.958546050e-03f, -6.543972778e-03f, -2.299632938e-03f, +7.171415163e-03f, +1.523587610e-02f, +1.312467524e-02f, -1.985758136e-03f, -2.154482068e-02f, -2.953471452e-02f, -1.507303007e-02f, +1.592984048e-02f, +4.153272158e-02f, +3.935849852e-02f, +5.939631090e-03f, -3.695914888e-02f, -5.682200323e-02f, -3.591270736e-02f, +1.286633405e-02f, +5.413065444e-02f, +5.696984499e-02f, +1.923899018e-02f, -3.074214510e-02f, -5.648661828e-02f, -4.131026659e-02f, +4.332184234e-04f, +3.666680095e-02f, +4.309768544e-02f, +1.996687550e-02f, -1.176743056e-02f, -2.902411839e-02f, -2.350969916e-02f, -4.483729733e-03f, +1.188676144e-02f, +1.567833472e-02f, +8.444814193e-03f, -1.320221666e-03f, -6.376446090e-03f, -5.369602763e-03f, -1.581210529e-03f, +1.242979284e-03f, +1.756844992e-03f, +8.867822897e-04f, +4.315971767e-05f,
    -1.416842128e-05f, -3.178096262e-05f, -1.936655489e-05f, +4.074341266e-05f, +1.118366926e-04f, +1.085474701e-04f, -2.655168425e-05f, -2.309909909e-04f, -3.219377725e-04f, -1.373301571e-04f, +2.753562781e-04f, +6.129729854e-04f, +5.218248785e-04f, -6.875206024e-05f, -7.835696146e-04f, -1.024322317e-03f, -4.645456348e-04f, +5.917088586e-04f, +1.353480834e-03f, +1.149685270e-03f, +2.287402917e-05f, -1.221746674e-03f, -1.615617815e-03f, -8.116510977e-04f, +6.051308071e-04f, +1.564506376e-03f, +1.358794677e-03f, +1.907975127e-04f, -1.021223537e-03f, -1.394541677e-03f, -7.523057237e-04f, +3.155456883e-04f, +9.899919317e-04f, +8.665746790e-04f, +1.870298427e-04f, -4.580383367e-04f, -6.336878614e-04f, -3.431057333e-04f, +8.274502853e-05f, +3.132893352e-04f, +2.580706410e-04f, +5.755201443e-05f, -9.627963359e-05f, -1.185482258e-04f, -5.295708166e-05f, +1.296376440e-05f, +3.267069945e-05f, +1.749127965e-05f,
    /*  4,19 (48) */
    -2.117908759e-04f, -6.063519103e-04f, -7.880740649e-04f, -2.615114176e-04f, +1.111843622e-03f, +2.680463344e-03f, +3.092211830e-03f, +1.128101065e-03f, -3.090308696e-03f, -7.419818468e-03f, -8.404942487e-03f, -3.444008419e-03f, +6.700766744e-03f, +1.689537070e-02f, +1.952612165e-02f, +9.025706554e-03f, -1.322922853e-02f, -3.687742605e-02f, -4.560856914e-02f, -2.475236498e-02f, +3.009030968e-02f, +1.082082735e-01f, +1.861167285e-01f, +2.367718179e-01f, +2.414680180e-01f, +1.984366308e-01f, +1.236698808e-01f, +4.353718853e-02f, -1.695006172e-02f, -4.427029345e-02f, -4.017027133e-02f, -1.800312893e-02f, +5.556029886e-03f, +1.863514484e-02f, +1.819286408e-02f, +8.825592131e-03f, -1.839413927e-03f, -7.963356507e-03f, -7.965598290e-03f, -3.989454550e-03f, +4.722885319e-04f, +2.926456509e-03f, +2.891454891e-03f, +1.425238952e-03f, -6.115419859e-05f, -7.556797593e-04f, -6.722062698e-04f, -2.806327827e-04f,
    +1.086380328e-05f, +1.175087387e-05f, -2.797513799e-06f, -3.029309637e-05f, -5.153950867e-05f, -3.942009059e-05f, +1.896549344e-05f, +1.011783760e-04f, +1.496214900e-04f, +1.032722050e-04f, -5.202614347e-05f, -2.489261490e-04f, -3.544630052e-04f, -2.440604639e-04f, +1.010261762e-04f, +5.364730471e-04f, +7.916898281e-04f, +6.033642566e-04f, -1.168884923e-04f, -1.180246587e-03f, -2.161111704e-03f, -2.581581344e-03f, -2.153488329e-03f, -9.468343174e-04f, +6.157661632e-04f, +1.946058681e-03f, +2.564155124e-03f, +2.315494573e-03f, +1.419301593e-03f, +3.321729341e-04f, -4.892356315e-04f, -7.952254626e-04f, -6.181333013e-04f, -1.966576036e-04f, +1.862337587e-04f, +3.516722310e-04f, +2.849500731e-04f, +9.548823139e-05f, -7.762243142e-05f, -1.491456078e-04f, -1.170516966e-04f, -3.648730630e-05f, +3.046318302e-05f, +5.258519756e-05f, +3.641527474e-05f, +8.120766612e-06f, -1.004582615e-05f, -1.201125048e-05f,
    -3.431490051e-05f, +7.257676160e-04f, +1.672305932e-03f, +1.471024509e-03f, -1.007783731e-03f, -4.849998580e-03f, -6.570524462e-03f, -2.530623929e-03f, +6.849477391e-03f, +1.509854595e-02f, +1.340003152e-02f, -1.372785150e-03f, -2.102299581e-02f, -2.960346658e-02f, -1.585659968e-02f, +1.490551817e-02f, +4.106817594e-02f, +3.995020738e-02f, +7.293111923e-03f, -3.580946361e-02f, -5.679912920e-02f, -3.713445403e-02f, +1.125071624e-02f, +5.331900334e-02f, +5.757497580e-02f, +2.080349656e-02f, -2.938335042e-02f, -5.629582076e-02f, -4.233149012e-02f, -9.613232535e-04f, +3.591449523e-02f, +4.341323113e-02f, +2.095686743e-02f, -1.090085588e-02f, -2.883708855e-02f, -2.396773750e-02f, -5.117417595e-03f, +1.154365571e-02f, +1.576107975e-02f, +8.758103528e-03f, -1.062151025e-03f, -6.318894076e-03f, -5.465882396e-03f, -1.699758755e-03f, +1.190022202e-03f, +1.769808756e-03f, +9.194529891e-04f, +6.065099732e-05f,
    -1.351074403e-05f, -3.150773327e-05f, -2.049298849e-05f, +3.833846165e-05f, +1.102586480e-04f, +1.105811345e-04f, -2.057171849e-05f, -2.252124631e-04f, -3.227931365e-04f, -1.475322116e-04f, +2.615536806e-04f, +6.074645433e-04f, +5.330170897e-04f, -4.545180504e-05f, -7.654373648e-04f, -1.028667743e-03f, -4.928376748e-04f, +5.585861505e-04f, +1.342198342e-03f, +1.172528677e-03f, +6.535122827e-05f, -1.191577599e-03f, -1.622096891e-03f, -8.511543217e-04f, +5.622541709e-04f, +1.550588370e-03f, +1.383280130e-03f, +2.335512367e-04f, -9.928046655e-04f, -1.399608137e-03f, -7.832283699e-04f, +2.843878024e-04f, +9.806065503e-04f, +8.815222021e-04f, +2.109094147e-04f, -4.437576740e-04f, -6.364081860e-04f, -3.563141973e-04f, +7.115961947e-05f, +3.106684165e-04f, +2.630765080e-04f, +6.393964423e-05f, -9.340523006e-05f, -1.196342840e-04f, -5.542122079e-05f, +1.153056169e-05f, +3.274577985e-05f, +1.815674907e-05f,
    /*  4,20 (48) */
    -2.009270726e-04f, -5.946010365e-04f, -7.908715787e-04f, -2.918045140e-04f, +1.060304113e-03f, +2.641043253e-03f, +3.111177323e-03f, +1.229279441e-03f, -2.940687206e-03f, -7.316546263e-03f, -8.456968631e-03f, -3.692934568e-03f, +6.346303739e-03f, +1.665131023e-02f, +1.962714782e-02f, +9.562179601e-03f, -1.243753870e-02f, -3.627406180e-02f, -4.572545764e-02f, -2.593261157e-02f, +2.792919798e-02f, +1.056266922e-01f, +1.839632402e-01f, +2.358249836e-01f, +2.420837842e-01f, +2.003826895e-01f, +1.262340359e-01f, +4.585268310e-02f, -1.553076012e-02f, -4.393812052e-02f, -4.065950696e-02f, -1.879835439e-02f, +4.937896585e-03f, +1.843848724e-02f, +1.837909784e-02f, +9.177264362e-03f, -1.554463854e-03f, -7.867868276e-03f, -8.043220721e-03f, -4.138600157e-03f, +3.552368352e-04f, +2.889969203e-03f, +2.921918074e-03f, +1.477824149e-03f, -2.473892386e-05f, -7.475589927e-04f, -6.822520959e-04f, -2.926440332e-04f,
    +1.067103444e-05f, +1.192901538e-05f, -2.090829182e-06f, -2.939051183e-05f, -5.124888558e-05f, -4.050721427e-05f, +1.655716031e-05f, +9.876351284e-05f, +1.492916248e-04f, +1.064887260e-04f, -4.597560078e-05f, -2.433841554e-04f, -3.539603077e-04f, -2.513637965e-04f, +8.770511911e-05f, +5.240271131e-04f, +7.893422111e-04f, +6.175073398e-04f, -8.747179280e-05f, -1.145667720e-03f, -2.136697738e-03f, -2.580604122e-03f, -2.180028346e-03f, -9.928230059e-04f, +5.673795826e-04f, +1.913448276e-03f, +2.558166103e-03f, +2.335036878e-03f, +1.452834710e-03f, +3.641321009e-04f, -4.707973205e-04f, -7.938169860e-04f, -6.289058638e-04f, -2.105698600e-04f, +1.770437336e-04f, +3.503421484e-04f, +2.896448614e-04f, +1.018114333e-04f, -7.352242204e-05f, -1.486633763e-04f, -1.191458798e-04f, -3.906749896e-05f, +2.899317705e-05f, +5.258424396e-05f, +3.725144604e-05f, +8.930240209e-06f, -9.735192555e-06f, -1.214210066e-05f,
    -4.782564454e-05f, +6.942598828e-04f, +1.651812943e-03f, +1.509362970e-03f, -8.975250834e-04f, -4.739417445e-03f, -6.591096181e-03f, -2.755836392e-03f, +6.526684254e-03f, +1.495101374e-02f, +1.366158520e-02f, -7.653206070e-04f, -2.048997872e-02f, -2.964891839e-02f, -1.662203705e-02f, +1.387685042e-02f, +4.057533827e-02f, +4.050879353e-02f, +8.635310265e-03f, -3.463693493e-02f, -5.673377797e-02f, -3.832603163e-02f, +9.628619345e-03f, +5.246784902e-02f, +5.813722997e-02f, +2.235408493e-02f, -2.800007029e-02f, -5.606226953e-02f, -4.332429479e-02f, -2.360931390e-03f, +3.513126686e-02f, +4.369761893e-02f, +2.193747398e-02f, -1.001933368e-02f, -2.862617914e-02f, -2.441149517e-02f, -5.753825781e-03f, +1.118734151e-02f, +1.583223937e-02f, +9.068771944e-03f, -7.990745172e-04f, -6.254954431e-03f, -5.559287626e-03f, -1.819393039e-03f, +1.134600982e-03f, +1.781339318e-03f, +9.521987690e-04f, +7.880774639e-05f,
    -1.285725242e-05f, -3.120533410e-05f, -2.156784201e-05f, +3.595129296e-05f, +1.086089913e-04f, +1.124757694e-04f, -1.467531985e-05f, -2.193289824e-04f, -3.233637847e-04f, -1.574817538e-04f, +2.476961529e-04f, +6.015214833e-04f, +5.436760041e-04f, -2.231261017e-05f, -7.468369003e-04f, -1.032175779e-03f, -5.205795147e-04f, +5.251941758e-04f, +1.329921279e-03f, +1.194385510e-03f, +1.076641795e-04f, -1.160546927e-03f, -1.627317182e-03f, -8.899834931e-04f, +5.189315099e-04f, +1.535459032e-03f, +1.406739489e-03f, +2.762317526e-04f, -9.635215340e-04f, -1.403604744e-03f, -8.136885621e-04f, +2.528296377e-04f, +9.703851603e-04f, +8.958794037e-04f, +2.348188846e-04f, -4.289854480e-04f, -6.386367957e-04f, -3.693791032e-04f, +5.936826082e-05f, +3.077459176e-04f, +2.679300144e-04f, +7.037832680e-05f, -9.039088257e-05f, -1.206282501e-04f, -5.788677766e-05f, +1.004726703e-05f, +3.278411916e-05f, +1.882041246e-05f,
    /*  4,21 (48) */
    -1.902560381e-04f, -5.826720211e-04f, -7.929624079e-04f, -3.211950258e-04f, +1.009055228e-03f, +2.600536039e-03f, +3.127734483e-03f, +1.328042954e-03f, -2.791395581e-03f, -7.210057537e-03f, -8.502944231e-03f, -3.936318723e-03f, +5.992343431e-03f, +1.639994644e-02f, +1.971485294e-02f, +1.008620671e-02f, -1.164819649e-02f, -3.565655446e-02f, -4.581292943e-02f, -2.707827929e-02f, +2.579250024e-02f, +1.030460881e-01f, +1.817832118e-01f, +2.348321606e-01f, +2.426511638e-01f, +2.022961377e-01f, +1.287922020e-01f, +4.818771998e-02f, -1.407792541e-02f, -4.357398842e-02f, -4.113030429e-02f, -1.959217137e-02f, +4.308990721e-03f, +1.822791738e-02f, +1.855614158e-02f, +9.527606511e-03f, -1.264818993e-03f, -7.766056842e-03f, -8.116743143e-03f, -4.287263534e-03f, +2.360909554e-04f, +2.850901704e-03f, +2.950911251e-03f, +1.530408393e-03f, +1.251252218e-05f, -7.386287525e-04f, -6.919872885e-04f, -3.047861339e-04f,
    +1.047211195e-05f, +1.209129542e-05f, -1.398643874e-06f, -2.848347424e-05f, -5.092534407e-05f, -4.154602144e-05f, +1.417666452e-05f, +9.631836077e-05f, +1.488667806e-04f, +1.095909776e-04f, -3.997511835e-05f, -2.377572560e-04f, -3.532406304e-04f, -2.584218823e-04f, +7.449071459e-05f, +5.114144858e-04f, +7.865531458e-04f, +6.311056663e-04f, -5.842132989e-05f, -1.111028863e-03f, -2.111733820e-03f, -2.578771288e-03f, -2.205769064e-03f, -1.038432244e-03f, +5.187751349e-04f, +1.880124898e-03f, +2.551296854e-03f, +2.353914507e-03f, +1.486165880e-03f, +3.963570956e-04f, -4.518343557e-04f, -7.919138599e-04f, -6.394270710e-04f, -2.245213585e-04f, +1.676298856e-04f, +3.487726173e-04f, +2.942129712e-04f, +1.081517273e-04f, -6.931713154e-05f, -1.480738929e-04f, -1.211901590e-04f, -4.166225889e-05f, +2.747635175e-05f, +5.254356191e-05f, +3.807534563e-05f, +9.750635465e-06f, -9.407489159e-06f, -1.226363572e-05f,
    -6.068289696e-05f, +6.630545487e-04f, +1.630245101e-03f, +1.545314263e-03f, -7.889160921e-04f, -4.626941676e-03f, -6.605771501e-03f, -2.975165374e-03f, +6.203320469e-03f, +1.479353198e-02f, +1.390928135e-02f, -1.637991238e-04f, -1.994630271e-02f, -2.967123100e-02f, -1.736887395e-02f, +1.284467464e-02f, +4.005475875e-02f, +4.103398771e-02f, +9.965231544e-03f, -3.344254942e-02f, -5.662611379e-02f, -3.948657856e-02f, +8.001302163e-03f, +5.157786552e-02f, +5.865616148e-02f, +2.388954396e-02f, -2.659333080e-02f, -5.578603777e-02f, -4.428781632e-02f, -3.764536134e-03f, +3.431757830e-02f, +4.395044857e-02f, +2.290785914e-02f, -9.123454277e-03f, -2.839136025e-02f, -2.484048062e-02f, -6.392462576e-03f, +1.081796240e-02f, +1.589160763e-02f, +9.376517862e-03f, -5.311445028e-04f, -6.184576105e-03f, -5.649678509e-03f, -1.940021289e-03f, +1.076714204e-03f, +1.791386585e-03f, +9.849828881e-04f, +9.762815885e-05f,
    -1.220870577e-05f, -3.087489644e-05f, -2.259114707e-05f, +3.358400885e-05f, +1.068907517e-04f, +1.142320367e-04f, -8.866574981e-06f, -2.133473835e-04f, -3.236530469e-04f, -1.671732861e-04f, +2.337961005e-04f, +5.951532014e-04f, +5.537976452e-04f, +6.477933725e-07f, -7.277868621e-04f, -1.034849023e-03f, -5.477518863e-04f, +4.915610870e-04f, +1.316663576e-03f, +1.215241647e-03f, +1.497796158e-04f, -1.128680965e-03f, -1.631276012e-03f, -9.281080801e-04f, +4.751971168e-04f, +1.519129192e-03f, +1.429152316e-03f, +3.188048226e-04f, -9.333948178e-04f, -1.406524065e-03f, -8.436595480e-04f, +2.208945727e-04f, +9.593308029e-04f, +9.096302455e-04f, +2.587386849e-04f, -4.137295927e-04f, -6.403668975e-04f, -3.822876665e-04f, +4.737872311e-05f, +3.045204117e-04f, +2.726245321e-04f, +7.686289059e-05f, -8.723701883e-05f, -1.215273449e-04f, -6.035119738e-05f, +8.514348974e-06f, +3.278470509e-05f, +1.948132439e-05f,
    /*  4,22 (48) */
    -1.797839262e-04f, -5.705807257e-04f, -7.943610518e-04f, -3.496785000e-04f, +9.581298838e-04f, +2.558990017e-03f, +3.141911148e-03f, +1.424361314e-03f, -2.642528801e-03f, -7.100466560e-03f, -8.542919350e-03f, -4.174075979e-03f, +5.639102801e-03f, +1.614152455e-02f, +1.978934366e-02f, +1.059762120e-02f, -1.086164335e-02f, -3.502544879e-02f, -4.587135076e-02f, -2.818930815e-02f, +2.368076642e-02f, +1.004673168e-01f, +1.795774427e-01f, +2.337937284e-01f, +2.431699389e-01f, +2.041762626e-01f, +1.313434989e-01f, +5.054163449e-02f, -1.259175953e-02f, -4.317763132e-02f, -4.158213864e-02f, -2.038408523e-02f, +3.669563650e-03f, +1.800339602e-02f, +1.872377146e-02f, +9.876379128e-03f, -9.706060217e-04f, -7.657905115e-03f, -8.186060275e-03f, -4.435337427e-03f, +1.149007964e-04f, +2.809239445e-03f, +2.978387603e-03f, +1.582951955e-03f, +5.058786781e-05f, -7.288781171e-04f, -7.013947777e-04f, -3.170497696e-04f,
    +1.026738752e-05f, +1.223790898e-05f, -7.212630777e-07f, -2.757280659e-05f, -5.056971542e-05f, -4.253653645e-05f, +1.182528874e-05f, +9.384507757e-05f, +1.483485705e-04f, +1.125783976e-04f, -3.402800705e-05f, -2.320501354e-04f, -3.523070318e-04f, -2.652332049e-04f, +6.138978928e-05f, +4.986446197e-04f, +7.833294736e-04f, +6.441584584e-04f, -2.974703766e-05f, -1.076345550e-03f, -2.086233724e-03f, -2.576087462e-03f, -2.230702699e-03f, -1.083644875e-03f, +4.699714128e-04f, +1.846099875e-03f, +2.543546566e-03f, +2.372115874e-03f, +1.519279236e-03f, +4.288356190e-04f, -4.323504425e-04f, -7.895111918e-04f, -6.496876654e-04f, -2.385040047e-04f, +1.579954647e-04f, +3.469617557e-04f, +2.986498630e-04f, +1.145051290e-04f, -6.500800187e-05f, -1.473760729e-04f, -1.231823616e-04f, -4.426993069e-05f, +2.591307205e-05f, +5.246248495e-05f, +3.888606991e-05f, +1.058146335e-05f, -9.062648661e-06f, -1.237551130e-05f,
    -7.289160273e-05f, +6.321796522e-04f, +1.607653954e-03f, +1.578898272e-03f, -6.820253404e-04f, -4.512709639e-03f, -6.614638076e-03f, -3.188512758e-03f, +5.879667422e-03f, +1.462635870e-02f, +1.414307745e-02f, +4.313540776e-04f, -1.939250507e-02f, -2.967058320e-02f, -1.809666081e-02f, +1.180982562e-02f, +3.950700687e-02f, +4.152554879e-02f, +1.128189512e-02f, -3.222730777e-02f, -5.647633418e-02f, -4.061525952e-02f, +6.370026151e-03f, +5.064975744e-02f, +5.913135860e-02f, +2.540867315e-02f, -2.516417848e-02f, -5.546723295e-02f, -4.522121114e-02f, -5.171060199e-03f, +3.347391875e-02f, +4.417134314e-02f, +2.386718994e-02f, -8.213824032e-03f, -2.813262157e-02f, -2.525421021e-02f, -7.032829474e-03f, +1.043567474e-02f, +1.593898636e-02f, +9.681038274e-03f, -2.585199707e-04f, -6.107713214e-03f, -5.736915528e-03f, -2.061548634e-03f, +1.016363007e-03f, +1.799900934e-03f, +1.017767593e-03f, +1.171094832e-04f,
    -1.156583771e-05f, -3.051755931e-05f, -2.356299303e-05f, +3.123864879e-05f, +1.051069733e-04f, +1.158507237e-04f, -3.149424362e-06f, -2.072744965e-04f, -3.236644660e-04f, -1.766016064e-04f, +2.198658333e-04f, +5.883693712e-04f, +5.633785327e-04f, +2.341196786e-05f, -7.083061374e-04f, -1.036690754e-03f, -5.743361015e-04f, +4.577151014e-04f, +1.302439913e-03f, +1.235083830e-03f, +1.916645172e-04f, -1.096006654e-03f, -1.633971743e-03f, -9.654981397e-04f, +4.310856293e-04f, +1.501610669e-03f, +1.450498990e-03f, +3.612362155e-04f, -9.024459511e-04f, -1.408359528e-03f, -8.731148588e-04f, +1.886064256e-04f, +9.474472378e-04f, +9.227590917e-04f, +2.826490864e-04f, -3.979985283e-04f, -6.415920685e-04f, -3.950271064e-04f, +3.519904534e-05f, +3.009907318e-04f, +2.771534900e-04f, +8.338804160e-05f, -8.394421207e-05f, -1.223288367e-04f, -6.281187603e-05f, +6.932342584e-06f, +3.274654767e-05f, +2.013851916e-05f,
    /*  4,23 (48) */
    -1.695165387e-04f, -5.583428167e-04f, -7.950823148e-04f, -3.772513066e-04f, +9.075601684e-04f, +2.516453481e-03f, +3.153736437e-03f, +1.518206392e-03f, -2.494180230e-03f, -6.987888162e-03f, -8.576947357e-03f, -4.406126115e-03f, +5.286795769e-03f, +1.587629135e-02f, +1.985073345e-02f, +1.109626582e-02f, -1.007831387e-02f, -3.438129033e-02f, -4.590109780e-02f, -2.926565370e-02f, +2.159453270e-02f, +9.789122933e-02f, +1.773467400e-01f, +2.327100835e-01f, +2.436399103e-01f, +2.060223625e-01f, +1.338870455e-01f, +5.291375036e-02f, -1.107248030e-02f, -4.274879570e-02f, -4.201448908e-02f, -2.117359643e-02f, +3.019875985e-03f, +1.776489202e-02f, +1.888176693e-02f, +1.022334088e-02f, -6.719561588e-04f, -7.543399986e-03f, -8.251068276e-03f, -4.582713499e-03f, -8.281565258e-06f, +2.764969514e-03f, +3.004300675e-03f, +1.635414440e-03f, +8.947393773e-05f, -7.182966537e-04f, -7.104574263e-04f, -3.294252809e-04f,
    +1.005721173e-05f, +1.236906188e-05f, -5.897355422e-08f, -2.665932067e-05f, -5.018284270e-05f, -4.347881995e-05f, +9.504275476e-06f, +9.134581111e-05f, +1.477386512e-04f, +1.154505091e-04f, -2.813750178e-05f, -2.262674753e-04f, -3.511626720e-04f, -2.717964180e-04f, +4.840902647e-05f, +4.857269586e-04f, +7.796782035e-04f, +6.566652244e-04f, -1.458591480e-06f, -1.041633242e-03f, -2.060211405e-03f, -2.572557625e-03f, -2.254821845e-03f, -1.128443930e-03f, +4.209871051e-04f, +1.811384863e-03f, +2.534914823e-03f, +2.389629649e-03f, +1.552158922e-03f, +4.615551614e-04f, -4.123495821e-04f, -7.866043095e-04f, -6.596784399e-04f, -2.525095963e-04f, +1.481438948e-04f, +3.449078145e-04f, +3.029510298e-04f, +1.208675967e-04f, -6.059656432e-05f, -1.465688934e-04f, -1.251203224e-04f, -4.688882536e-05f, +2.430374389e-05f, +5.234036778e-05f, +3.968271065e-05f, +1.142221689e-05f, -8.700618332e-06f, -1.247738578e-05f,
    -8.445744044e-05f, +6.016620929e-04f, +1.584090961e-03f, +1.610136921e-03f, -5.769183672e-04f, -4.396858915e-03f, -6.617787500e-03f, -3.395787254e-03f, +5.556002956e-03f, +1.444975709e-02f, +1.436294328e-02f, +1.019723449e-03f, -1.882912653e-02f, -2.964717124e-02f, -1.880496695e-02f, +1.077313487e-02f, +3.893267077e-02f, +4.198326390e-02f, +1.258433503e-02f, -3.099222394e-02f, -5.628466966e-02f, -4.171126617e-02f, +4.736054408e-03f, +4.968425930e-02f, +5.956244423e-02f, +2.691028382e-02f, -2.371367949e-02f, -5.510599674e-02f, -4.612365709e-02f, -6.579419727e-03f, +3.260080389e-02f, +4.435994957e-02f, +2.481463718e-02f, -7.291064940e-03f, -2.784997248e-02f, -2.565220874e-02f, -7.674421542e-03f, +1.004064763e-02f, +1.597418540e-02f, +9.982029006e-03f, +1.863351932e-05f, -6.024325172e-03f, -5.820859740e-03f, -2.183877471e-03f, +9.535511306e-04f, +1.806833276e-03f, +1.050514141e-03f, +1.372480024e-04f,
    -1.092935588e-05f, -3.013446780e-05f, -2.448352570e-05f, +2.891718833e-05f, +1.032607123e-04f, +1.173327403e-04f, +2.472339476e-06f, -2.011171405e-04f, -3.234017925e-04f, -1.857618093e-04f, +2.059175552e-04f, +5.811799325e-04f, +5.724156817e-04f, +4.596278178e-05f, -6.884138412e-04f, -1.037704928e-03f, -6.003140652e-04f, +4.236844779e-04f, +1.287265709e-03f, +1.253899682e-03f, +2.332861382e-04f, -1.062551544e-03f, -1.635403767e-03f, -1.002124343e-03f, +3.866320012e-04f, +1.482916267e-03f, +1.470760737e-03f, +4.034917365e-04f, -8.706971109e-04f, -1.409105432e-03f, -9.020283335e-04f, +1.559894358e-04f, +9.347389443e-04f, +9.352507246e-04f, +3.065302152e-04f, -3.818011580e-04f, -6.423062653e-04f, -4.075846569e-04f, +2.283753055e-05f, +2.971559747e-04f, +2.815103813e-04f, +8.994836685e-05f, -8.051318266e-05f, -1.230300454e-04f, -6.526616266e-05f, +5.301850104e-06f, +3.266868091e-05f, +2.079101159e-05f,
    /*  4,24 (48) */
    -1.594593269e-04f, -5.459737548e-04f, -7.951412884e-04f, -4.039106273e-04f, +8.573773257e-04f, +2.472974661e-03f, +3.163240712e-03f, +1.609552203e-03f, -2.346441579e-03f, -6.872437653e-03f, -8.605084859e-03f, -4.632393590e-03f, +4.935633097e-03f, +1.560449493e-02f, +1.989914247e-02f, +1.158199278e-02f, -9.298635668e-03f, -3.372462511e-02f, -4.590255639e-02f, -3.030728694e-02f, +1.953432129e-02f, +9.531867170e-02f, +1.750919182e-01f, +2.315816396e-01f, +2.440608974e-01f, +2.078337474e-01f, +1.364219603e-01f, +5.530338001e-02f, -9.520321375e-03f, -4.228724054e-02f, -4.242683867e-02f, -2.196020074e-02f, +2.360197545e-03f, +1.751238242e-02f, +1.902991082e-02f, +1.056824870e-02f, -3.690051289e-04f, -7.422532389e-03f, -8.311664841e-03f, -4.729282393e-03f, -1.334018877e-04f, +2.718080689e-03f, +3.028604419e-03f, +1.687754808e-03f, +1.291566484e-04f, -7.068744368e-04f, -7.191580447e-04f, -3.419026667e-04f,
    +9.841933680e-06f, +1.248497041e-05f, +5.879563279e-07f, -2.574381665e-05f, -4.976557993e-05f, -4.437296836e-05f, +7.214826744e-06f, +8.882269798e-05f, +1.470387212e-04f, +1.182069200e-04f, -2.230676018e-05f, -2.204139514e-04f, -3.498108096e-04f, -2.781103449e-04f, +3.555496353e-05f, +4.726709308e-04f, +7.756065067e-04f, +6.686257571e-04f, +2.643459550e-05f, -1.006907315e-03f, -2.033680987e-03f, -2.568187124e-03f, -2.278119471e-03f, -1.172812640e-03f, +3.718409871e-04f, +1.775991847e-03f, +2.525401601e-03f, +2.406444767e-03f, +1.584789098e-03f, +4.945030070e-04f, -3.918360714e-04f, -7.831887655e-04f, -6.693902437e-04f, -2.665298267e-04f, +1.380787733e-04f, +3.426091801e-04f, +3.071120005e-04f, +1.272350333e-04f, -5.608443952e-05f, -1.456513944e-04f, -1.270018852e-04f, -4.951722105e-05f, +2.264881449e-05f, +5.217658705e-05f, +4.046435566e-05f, +1.227237129e-05f, -8.321360299e-06f, -1.256892063e-05f,
    -9.538679632e-05f, +5.715276251e-04f, +1.559607435e-03f, +1.639054109e-03f, -4.736576549e-04f, -4.279526175e-03f, -6.615315161e-03f, -3.596904395e-03f, +5.232601164e-03f, +1.426399528e-02f, +1.456886084e-02f, +1.600903381e-03f, -1.825671085e-02f, -2.960120845e-02f, -1.949338079e-02f, +9.735429939e-03f, +3.833235670e-02f, +4.240694837e-02f, +1.387160074e-02f, -2.973832426e-02f, -5.605138352e-02f, -4.277381772e-02f, +3.100650641e-03f, +4.868213496e-02f, +5.994907623e-02f, +2.839320009e-02f, -2.224291876e-02f, -5.470250500e-02f, -4.699435420e-02f, -7.988525159e-03f, +3.169877556e-02f, +4.451593900e-02f, +2.574937612e-02f, -6.355814215e-03f, -2.754344226e-02f, -2.603400990e-02f, -8.316727808e-03f, +9.633062975e-03f, +1.599702293e-02f, +1.027918498e-02f, +3.001439006e-04f, -5.934376806e-03f, -5.901372922e-03f, -2.306907516e-03f, +8.882849680e-04f, +1.812135126e-03f, +1.083182822e-03f, +1.580390140e-04f,
    -1.029994154e-05f, -2.972677158e-05f, -2.535294614e-05f, +2.662153812e-05f, +1.013550330e-04f, +1.186791159e-04f, +7.995073534e-06f, -1.948821172e-04f, -3.228689785e-04f, -1.946492873e-04f, +1.919633541e-04f, +5.735950795e-04f, +5.809066006e-04f, +6.828342250e-05f, -6.681292984e-04f, -1.037896166e-03f, -6.256682876e-04f, +3.894974920e-04f, +1.271157102e-03f, +1.271677709e-03f, +2.746120345e-04f, -1.028343774e-03f, -1.635572511e-03f, -1.037957999e-03f, +3.418714729e-04f, +1.463059761e-03f, +1.489919637e-03f, +4.455372552e-04f, -8.381711999e-04f, -1.408756955e-03f, -9.303741423e-04f, +1.230682455e-04f, +9.212111215e-04f, +9.470903609e-04f, +3.303620685e-04f, -3.651468636e-04f, -6.425038326e-04f, -4.199475789e-04f, +1.030274097e-05f, +2.930155053e-04f, +2.856887703e-04f, +9.653833807e-05f, -7.694479968e-05f, -1.236283455e-04f, -6.771136134e-05f, +3.623541571e-06f, +3.255016448e-05f, +2.143779791e-05f,
    /*  4,25 (48) */
    -1.496173933e-04f, -5.334887844e-04f, -7.945533321e-04f, -4.296544439e-04f, +8.076117457e-04f, +2.428601693e-03f, +3.170455539e-03f, +1.698374901e-03f, -2.199402858e-03f, -6.754230733e-03f, -8.627391619e-03f, -4.852807542e-03f, +4.585822287e-03f, +1.532638459e-02f, +1.993469744e-02f, +1.205466371e-02f, -8.523029162e-03f, -3.305599935e-02f, -4.587612179e-02f, -3.131419426e-02f, +1.750064030e-02f, +9.275048458e-02f, +1.728137987e-01f, +2.304088269e-01f, +2.444327384e-01f, +2.096097392e-01f, +1.389473619e-01f, +5.770982478e-02f, -7.935532277e-03f, -4.179273754e-02f, -4.281867474e-02f, -2.274338950e-02f, +1.690807301e-03f, +1.724585259e-02f, +1.916798959e-02f, +1.091085788e-02f, -6.189312840e-05f, -7.295297356e-03f, -8.367749280e-03f, -4.874933787e-03f, -2.604037729e-04f, +2.668563468e-03f, +3.051253233e-03f, +1.739931395e-03f, +1.696210040e-04f, -6.946020655e-04f, -7.274794050e-04f, -3.544715873e-04f,
    +9.621900691e-06f, +1.258586094e-05f, +1.219276524e-06f, -2.482708254e-05f, -4.931879124e-05f, -4.521911322e-05f, +4.958103691e-06f, +8.627786209e-05f, +1.462505197e-04f, +1.208473221e-04f, -1.653886144e-05f, -2.144942307e-04f, -3.482547981e-04f, -2.841739777e-04f, +2.283398945e-05f, +4.594859434e-04f, +7.711217117e-04f, +6.800401319e-04f, +5.392337557e-05f, -9.721830556e-04f, -2.006656758e-03f, -2.562981663e-03f, -2.300588926e-03f, -1.216734440e-03f, +3.225519117e-04f, +1.739933127e-03f, +2.515007272e-03f, +2.422550433e-03f, +1.617153954e-03f, +5.276662400e-04f, -3.708145029e-04f, -7.792603414e-04f, -6.788139878e-04f, -2.805562892e-04f, +1.278038710e-04f, +3.400643764e-04f, +3.111283429e-04f, +1.336032886e-04f, -5.147333744e-05f, -1.446226806e-04f, -1.288249044e-04f, -5.215336394e-05f, +2.094877260e-05f, +5.197054220e-05f, +4.123008952e-05f, +1.313138411e-05f, -7.924851840e-06f, -1.264978081e-05f,
    -1.056867379e-04f, +5.418008535e-04f, +1.534254489e-03f, +1.665675647e-03f, -3.723026219e-04f, -4.160847059e-03f, -6.607320087e-03f, -3.791786512e-03f, +4.909732185e-03f, +1.406934599e-02f, +1.476082419e-02f, +2.174498461e-03f, -1.767580425e-02f, -2.953292503e-02f, -2.016151009e-02f, +8.697533773e-03f, +3.770668841e-02f, +4.279644587e-02f, +1.514275784e-02f, -2.846664655e-02f, -5.577677149e-02f, -4.380216149e-02f, +1.465078130e-03f, +4.764417696e-02f, +6.029094770e-02f, +2.985625985e-02f, -2.075299912e-02f, -5.425696774e-02f, -4.783252540e-02f, -9.397282114e-03f, +3.076840142e-02f, +4.463900725e-02f, +2.667058725e-02f, -5.408723854e-03f, -2.721308020e-02f, -2.639915676e-02f, -8.959231640e-03f, +9.213115396e-03f, +1.600732567e-02f, +1.057220049e-02f, +5.858326709e-04f, -5.837838467e-03f, -5.978317722e-03f, -2.430535862e-03f, +8.205736066e-04f, +1.815758668e-03f, +1.115732986e-03f, +1.794768119e-04f,
    -9.678249260e-06f, -2.929562340e-05f, -2.617150928e-05f, +2.435354300e-05f, +9.939300496e-05f, +1.198909969e-04f, +1.341528578e-05f, -1.885762046e-04f, -3.220701710e-04f, -2.032597318e-04f, +1.780151924e-04f, +5.656252499e-04f, +5.888492894e-04f, +9.035740848e-05f, -6.474720252e-04f, -1.037269751e-03f, -6.503818960e-04f, +3.551824120e-04f, +1.254130937e-03f, +1.288407306e-03f, +3.156100896e-04f, -9.934120415e-04f, -1.634479434e-03f, -1.072971079e-03f, +2.968395419e-04f, +1.442055892e-03f, +1.507958646e-03f, +4.873387349e-04f, -8.048918298e-04f, -1.407310159e-03f, -9.581268104e-04f, +8.986788047e-05f, +9.068696886e-04f, +9.582636675e-04f, +3.541245312e-04f, -3.480455019e-04f, -6.421795125e-04f, -4.321031721e-04f, -2.396506984e-06f, +2.885689603e-04f, +2.896822997e-04f, +1.031523155e-04f, -7.324008229e-05f, -1.241211704e-04f, -7.014473331e-05f, +1.898155368e-06f, +3.239008541e-05f, +2.207785664e-05f,
    /*  4,26 (48) */
    -1.399954926e-04f, -5.209029234e-04f, -7.933340555e-04f, -4.544815265e-04f, +7.582929545e-04f, +2.383382579e-03f, +3.175413642e-03f, +1.784652763e-03f, -2.053152338e-03f, -6.633383411e-03f, -8.643930480e-03f, -5.067301772e-03f, +4.237567489e-03f, +1.504221061e-02f, +1.995753143e-02f, +1.251414965e-02f, -7.751907450e-03f, -3.237595922e-02f, -4.582219842e-02f, -3.228637731e-02f, +1.549398355e-02f, +9.018750292e-02f, +1.705132098e-01f, +2.291920925e-01f, +2.447552903e-01f, +2.113496723e-01f, +1.414623692e-01f, +6.013237521e-02f, -6.318378323e-03f, -4.126507130e-02f, -4.318948924e-02f, -2.352264984e-02f, +1.011993314e-03f, +1.696529630e-02f, +1.929579347e-02f, +1.125092225e-02f, +2.492352145e-04f, -7.161694067e-03f, -8.419222618e-03f, -5.019556468e-03f, -3.892286773e-04f, +2.616410104e-03f, +3.072202006e-03f, +1.791901937e-03f, +2.108510936e-04f, -6.814706814e-04f, -7.354042568e-04f, -3.671213681e-04f,
    +9.397458000e-06f, +1.267196955e-05f, +1.834755230e-06f, -2.390989374e-05f, -4.884335002e-05f, -4.601742064e-05f, +2.735226303e-06f, +8.371341332e-05f, +1.453758241e-04f, +1.233714902e-04f, -1.083680508e-05f, -2.085129681e-04f, -3.464980832e-04f, -2.899864756e-04f, +1.025234248e-05f, +4.461813775e-04f, +7.662312983e-04f, +6.909087043e-04f, +8.099886954e-05f, -9.374756521e-04f, -1.979153161e-03f, -2.556947300e-03f, -2.322223945e-03f, -1.260192979e-03f, +2.731388008e-04f, +1.703221322e-03f, +2.503732601e-03f, +2.437936128e-03f, +1.649237711e-03f, +5.610317500e-04f, -3.492897638e-04f, -7.748150519e-04f, -6.879406509e-04f, -2.945804811e-04f, +1.173231310e-04f, +3.372720680e-04f, +3.149956671e-04f, +1.399681615e-04f, -4.676505722e-05f, -1.434819223e-04f, -1.305872469e-04f, -5.479546913e-05f, +1.920414868e-05f, +5.172165629e-05f, +4.197899425e-05f, +1.399869545e-05f, -7.511085657e-06f, -1.271963515e-05f,
    -1.153649871e-04f, +5.125052301e-04f, +1.508082980e-03f, +1.690029190e-03f, -2.729096169e-04f, -4.040956062e-03f, -6.593904801e-03f, -3.980362717e-03f, +4.587662014e-03f, +1.386608626e-02f, +1.493883939e-02f, +2.740123711e-03f, -1.708695496e-02f, -2.944256762e-02f, -2.080898211e-02f, +7.660264021e-03f, +3.705630652e-02f, +4.315162828e-02f, +1.639688878e-02f, -2.717823924e-02f, -5.546116140e-02f, -4.479557353e-02f, -1.694013043e-04f, +4.657120588e-02f, +6.058778724e-02f, +3.129831574e-02f, -1.924504047e-02f, -5.376962901e-02f, -4.863741723e-02f, -1.080459227e-02f, +2.981027461e-02f, +4.472887513e-02f, +2.757745693e-02f, -4.450460187e-03f, -2.685895566e-02f, -2.674720226e-02f, -9.601411153e-03f, +8.781012224e-03f, +1.600492917e-02f, +1.086076945e-02f, +8.755149706e-04f, -5.734686152e-03f, -6.051557804e-03f, -2.554657032e-03f, +7.504288733e-04f, +1.817656823e-03f, +1.148123072e-03f, +2.015546685e-04f,
    -9.064906686e-06f, -2.884217760e-05f, -2.693952258e-05f, +2.211498118e-05f, +9.737769918e-05f, +1.209696434e-04f, +1.872963638e-05f, -1.822061507e-04f, -3.210097061e-04f, -2.115891334e-04f, +1.640848971e-04f, +5.572811128e-04f, +5.962422370e-04f, +1.121686012e-04f, -6.264617115e-04f, -1.035831615e-03f, -6.744386457e-04f, +3.207674749e-04f, +1.236204745e-03f, +1.304078768e-03f, +3.562485408e-04f, -9.577855825e-04f, -1.632127022e-03f, -1.107136239e-03f, +2.515719334e-04f, +1.419920346e-03f, +1.524861610e-03f, +5.288622618e-04f, -7.708833030e-04f, -1.404762002e-03f, -9.852612407e-04f, +5.641373053e-05f, +8.917212832e-04f, +9.687567770e-04f, +3.777973932e-04f, -3.305073988e-04f, -6.413284520e-04f, -4.440387867e-04f, -1.525114812e-05f, +2.838162517e-04f, +2.934846979e-04f, +1.097845518e-04f, -6.940020102e-05f, -1.245060156e-04f, -7.256349920e-05f, +1.264986970e-07f, +3.218755973e-05f, +2.271014949e-05f,
    /*  4,27 (48) */
    -1.305980346e-04f, -5.082309539e-04f, -7.914993003e-04f, -4.783914202e-04f, +7.094496045e-04f, +2.337365159e-03f, +3.178148869e-03f, +1.868366177e-03f, -1.907776514e-03f, -6.510011921e-03f, -8.654767285e-03f, -5.275814740e-03f, +3.891069406e-03f, +1.475222413e-02f, +1.996778377e-02f, +1.296033103e-02f, -6.985676151e-03f, -3.168505052e-02f, -4.574119955e-02f, -3.322385297e-02f, +1.351483038e-02f, +8.763055561e-02f, +1.681909859e-01f, +2.279318995e-01f, +2.450284291e-01f, +2.130528937e-01f, +1.439661018e-01f, +6.257031134e-02f, -4.669140612e-03f, -4.070403955e-02f, -4.353877900e-02f, -2.429746489e-02f, +3.240526627e-04f, +1.667071582e-02f, +1.941311660e-02f, +1.158819432e-02f, +5.642308816e-04f, -7.021725906e-03f, -8.465987675e-03f, -5.163038390e-03f, -5.198159242e-04f, +2.561614635e-03f, +3.091406154e-03f, +1.843623593e-03f, +2.528300878e-04f, -6.674719860e-04f, -7.429153425e-04f, -3.798410033e-04f,
    +9.168948451e-06f, +1.274354164e-05f, +2.434178788e-06f, -2.299301259e-05f, -4.834013806e-05f, -4.676809063e-05f, +5.472731236e-07f, +8.113144611e-05f, +1.444164487e-04f, +1.257792813e-04f, -5.203509853e-06f, -2.024748039e-04f, -3.445441995e-04f, -2.955471640e-04f, -2.183892139e-06f, +4.327665825e-04f, +7.609428930e-04f, +7.012321084e-04f, +1.076524697e-04f, -9.028001885e-04f, -1.951184787e-03f, -2.550090443e-03f, -2.343018643e-03f, -1.303172126e-03f, +2.236206357e-04f, +1.665869356e-03f, +2.491578750e-03f, +2.452591617e-03f, +1.681024634e-03f, +5.945862371e-04f, -3.272670360e-04f, -7.698491488e-04f, -6.967612850e-04f, -3.085938074e-04f, +1.066406684e-04f, +3.342310618e-04f, +3.187096293e-04f, +1.463254020e-04f, -4.196148700e-05f, -1.422283575e-04f, -1.322867935e-04f, -5.744172148e-05f, +1.741551516e-05f, +5.142937682e-05f, +4.271015005e-05f, +1.487372814e-05f, -7.080070146e-06f, -1.277815672e-05f,
    -1.244298938e-04f, +4.836630525e-04f, +1.481143457e-03f, +1.712144172e-03f, -1.755319177e-04f, -3.919986419e-03f, -6.575175165e-03f, -4.162568867e-03f, +4.266652308e-03f, +1.365449713e-02f, +1.510292428e-02f, +3.297404824e-03f, -1.649071272e-02f, -2.933039902e-02f, -2.143544382e-02f, +6.624432406e-03f, +3.638186787e-02f, +4.347239575e-02f, +1.763309353e-02f, -2.587416048e-02f, -5.510491286e-02f, -4.575335912e-02f, -1.801528327e-03f, +4.546406964e-02f, +6.083935918e-02f, +3.271823609e-02f, -1.772017886e-02f, -5.324076675e-02f, -4.940830054e-02f, -1.220935428e-02f, +2.882501336e-02f, +4.478528886e-02f, +2.846917822e-02f, -3.481703410e-03f, -2.648115827e-02f, -2.707770966e-02f, -1.024273960e-02f, +8.336973437e-03f, +1.598967802e-02f, +1.114458570e-02f, +1.168999668e-03f, -5.624901600e-03f, -6.120958005e-03f, -2.679163048e-03f, +6.778653741e-04f, +1.817783322e-03f, +1.180310631e-03f, +2.242648180e-04f,
    -8.460514288e-06f, -2.836758865e-05f, -2.765734466e-05f, +1.990756350e-05f, +9.531218521e-05f, +1.219164262e-04f, +2.393493880e-05f, -1.757786675e-04f, -3.196921023e-04f, -2.196337826e-04f, +1.501841507e-04f, +5.485735572e-04f, +6.030844187e-04f, +1.337012165e-04f, -6.051182020e-04f, -1.033588332e-03f, -6.978229305e-04f, +2.862808627e-04f, +1.217396724e-03f, +1.318683292e-03f, +3.964960053e-04f, -9.214941434e-04f, -1.628518790e-03f, -1.140426844e-03f, +2.061045701e-04f, +1.396669752e-03f, +1.540613279e-03f, +5.700740732e-04f, -7.361705945e-04f, -1.401110338e-03f, -1.011752738e-03f, +2.273152976e-05f, +8.757732603e-04f, +9.785563028e-04f, +4.013603659e-04f, -3.125433452e-04f, -6.399462117e-04f, -4.557418356e-04f, -2.825187413e-05f, +2.787575706e-04f, +2.970897857e-04f, +1.164291964e-04f, -6.542647888e-05f, -1.247804426e-04f, -7.496484133e-05f, -1.690552013e-06f, +3.194173417e-05f, +2.333362236e-05f,
    /*  4,28 (48) */
    -1.214290861e-04f, -4.954874122e-04f, -7.890651215e-04f, -5.013844328e-04f, +6.611094664e-04f, +2.290597068e-03f, +3.178696142e-03f, +1.949497623e-03f, -1.763360065e-03f, -6.384232639e-03f, -8.659970795e-03f, -5.478289544e-03f, +3.546525207e-03f, +1.445667697e-02f, +1.996559988e-02f, +1.339309761e-02f, -6.224733259e-03f, -3.098381841e-02f, -4.563354708e-02f, -3.412665315e-02f, +1.156364560e-02f, +8.508046517e-02f, +1.658479672e-01f, +2.266287274e-01f, +2.452520498e-01f, +2.147187630e-01f, +1.464576805e-01f, +6.502290296e-02f, -2.988115978e-03f, -4.010945331e-02f, -4.386604604e-02f, -2.506731404e-02f, -3.727086224e-04f, +1.636212202e-02f, +1.951975726e-02f, +1.192242538e-02f, +8.829405108e-04f, -6.875400504e-03f, -8.507949162e-03f, -5.305266748e-03f, -6.521027177e-04f, +2.504172913e-03f, +3.108821669e-03f, +1.895052970e-03f, +2.955402379e-04f, -6.525982578e-04f, -7.499954126e-04f, -3.926191600e-04f,
    +8.936712204e-06f, +1.280083156e-05f, +3.017351572e-06f, -2.207718797e-05f, -4.781004476e-05f, -4.747135652e-05f, -1.604718976e-06f, +7.853403820e-05f, +1.433742428e-04f, +1.280706340e-04f, +3.581872455e-07f, -1.963843605e-04f, -3.423967670e-04f, -3.008555334e-04f, -1.446878429e-05f, +4.192508715e-04f, +7.552642627e-04f, +7.110112536e-04f, +1.338758426e-04f, -8.681716366e-04f, -1.922766365e-03f, -2.542417848e-03f, -2.362967526e-03f, -1.345655982e-03f, +1.740164482e-04f, +1.627890458e-03f, +2.478547275e-03f, +2.466506952e-03f, +1.712499040e-03f, +6.283162183e-04f, -3.047517951e-04f, -7.643591248e-04f, -7.052670211e-04f, -3.225875851e-04f, +9.576076956e-05f, +3.309403096e-04f, +3.222659344e-04f, +1.526707137e-04f, -3.706460373e-05f, -1.408612929e-04f, -1.339214410e-04f, -6.009027664e-05f, +1.558348651e-05f, +5.109317649e-05f, +4.342263601e-05f, +1.575588796e-05f, -6.631829657e-06f, -1.282502326e-05f,
    -1.328904081e-04f, +4.552954639e-04f, +1.453486113e-03f, +1.732051735e-03f, -8.021973253e-05f, -3.798069993e-03f, -6.551240226e-03f, -4.338347535e-03f, +3.946960206e-03f, +1.343486335e-02f, +1.525310843e-02f, +3.845978381e-03f, -1.588762831e-02f, -2.919669781e-02f, -2.204056203e-02f, +5.590844074e-03f, +3.568404494e-02f, +4.375867662e-02f, +1.885049025e-02f, -2.455547718e-02f, -5.470841685e-02f, -4.667485326e-02f, -3.430047117e-03f, +4.432364280e-02f, +6.104546375e-02f, +3.411490584e-02f, -1.617956558e-02f, -5.267069267e-02f, -5.014447113e-02f, -1.361046461e-02f, +2.781326063e-02f, +4.480802039e-02f, +2.934495148e-02f, -2.503147107e-03f, -2.607979791e-02f, -2.739025301e-02f, -1.088268582e-02f, +7.881231602e-03f, +1.596142614e-02f, +1.142334327e-02f, +1.466089454e-03f, -5.508472404e-03f, -6.186384484e-03f, -2.803943490e-03f, +6.029005328e-04f, +1.816092770e-03f, +1.212252366e-03f, +2.475984404e-04f,
    -7.865645190e-06f, -2.787300974e-05f, -2.832538384e-05f, +1.773293279e-05f, +9.319952775e-05f, +1.227328237e-04f, +2.902816071e-05f, -1.693004253e-04f, -3.181220543e-04f, -2.273902694e-04f, +1.363244821e-04f, +5.395136800e-04f, +6.093752927e-04f, +1.549398357e-04f, -5.834614779e-04f, -1.030547109e-03f, -7.205197926e-04f, +2.517506783e-04f, +1.197725728e-03f, +1.332212982e-03f, +4.363215056e-04f, -8.845679552e-04f, -1.623659271e-03f, -1.172816986e-03f, +1.604735422e-04f, +1.372321662e-03f, +1.555199324e-03f, +6.109405869e-04f, -7.007793324e-04f, -1.396353923e-03f, -1.037577029e-03f, -1.115266394e-05f, +8.590336898e-04f, +9.876493535e-04f, +4.247930999e-04f, -2.941645902e-04f, -6.380287732e-04f, -4.671998064e-04f, -4.138913951e-05f, +2.733933896e-04f, +3.004914841e-04f, +1.230802996e-04f, -6.132039239e-05f, -1.249420826e-04f, -7.734590613e-05f, -3.552050772e-06f, +3.165178783e-05f, +2.394720634e-05f,
    /*  4,29 (48) */
    -1.124923739e-04f, -4.826865807e-04f, -7.860477700e-04f, -5.234616208e-04f, +6.132994217e-04f, +2.243125712e-03f, +3.177091423e-03f, +2.028031661e-03f, -1.619985822e-03f, -6.256162005e-03f, -8.659612608e-03f, -5.674673905e-03f, +3.204128440e-03f, +1.415582144e-02f, +1.995113109e-02f, +1.381234848e-02f, -5.469468996e-03f, -3.027280715e-02f, -4.549967124e-02f, -3.499482479e-02f, +9.640879233e-03f, +8.253804732e-02f, +1.634849997e-01f, +2.252830714e-01f, +2.454260662e-01f, +2.163466535e-01f, +1.489362278e-01f, +6.748940991e-02f, -1.275616938e-03f, -3.948113709e-02f, -4.417079783e-02f, -2.583167317e-02f, -1.077975643e-03f, +1.603953443e-02f, +1.961551803e-02f, +1.225336569e-02f, +1.205206445e-03f, -6.722729790e-03f, -8.545013766e-03f, -5.446128040e-03f, -7.860241587e-04f, +2.444082636e-03f, +3.124405156e-03f, +1.946146147e-03f, +3.389628739e-04f, -6.368423699e-04f, -7.566272423e-04f, -4.054441832e-04f,
    +8.701086450e-06f, +1.284410222e-05f, +3.584095864e-06f, -2.116315483e-05f, -4.725396625e-05f, -4.812748421e-05f, -3.719755005e-06f, +7.592324930e-05f, +1.422510891e-04f, +1.302455672e-04f, +5.845531987e-06f, -1.902462398e-04f, -3.400594884e-04f, -3.059112374e-04f, -2.659656099e-05f, +4.056435160e-04f, +7.492033100e-04f, +7.202473230e-04f, +1.596609317e-04f, -8.336048491e-04f, -1.893912758e-03f, -2.533936609e-03f, -2.382065486e-03f, -1.387628879e-03f, +1.243453115e-04f, +1.589298153e-03f, +2.464640132e-03f, +2.479672483e-03f, +1.743645304e-03f, +6.622080333e-04f, -2.817498091e-04f, -7.583417174e-04f, -7.134490749e-04f, -3.365530480e-04f, +8.468789089e-05f, +3.273989107e-04f, +3.256603402e-04f, +1.589997563e-04f, -3.207647279e-05f, -1.393801050e-04f, -1.354891037e-04f, -6.273926195e-05f, +1.370871943e-05f, +5.071255403e-05f, +4.411553088e-05f, +1.664456387e-05f, -6.166404737e-06f, -1.285991751e-05f,
    -1.407560533e-04f, +4.274224541e-04f, +1.425160729e-03f, +1.749784668e-03f, +1.297979522e-05f, -3.675337169e-03f, -6.522212065e-03f, -4.507647960e-03f, +3.628838152e-03f, +1.320747308e-02f, +1.538943292e-02f, +4.385492061e-03f, -1.527825301e-02f, -2.904175797e-02f, -2.262402350e-02f, +4.560296965e-03f, +3.496352515e-02f, +4.401042729e-02f, +2.004821598e-02f, -2.322326420e-02f, -5.427209535e-02f, -4.755942122e-02f, -5.053706387e-03f, +4.315082581e-02f, +6.120593729e-02f, +3.548722750e-02f, -1.462436626e-02f, -5.205975209e-02f, -5.084525046e-02f, -1.500681854e-02f, +2.677568360e-02f, +4.479686773e-02f, +3.020398517e-02f, -1.515497754e-03f, -2.565500481e-02f, -2.768441760e-02f, -1.152071459e-02f, +7.414031795e-03f, +1.592003700e-02f, +1.169673666e-02f, +1.766580938e-03f, -5.385392104e-03f, -6.247704877e-03f, -2.928885573e-03f, +5.255546267e-04f, +1.812540719e-03f, +1.243904153e-03f, +2.715456467e-04f,
    -7.280845023e-06f, -2.735959138e-05f, -2.894409669e-05f, +1.559266332e-05f, +9.104278358e-05f, +1.234204187e-04f, +3.400642472e-05f, -1.627780462e-04f, -3.163044258e-04f, -2.348554835e-04f, +1.225172574e-04f, +5.301127742e-04f, +6.151147960e-04f, +1.758694164e-04f, -5.615116392e-04f, -1.026715774e-03f, -7.425149321e-04f, +2.172049221e-04f, +1.177211241e-03f, +1.344660851e-03f, +4.756944942e-04f, -8.470377077e-04f, -1.617554017e-03f, -1.204281511e-03f, +1.147150770e-04f, +1.346894540e-03f, +1.568606346e-03f, +6.514284292e-04f, -6.647357780e-04f, -1.390492424e-03f, -1.062710289e-03f, -4.521248951e-05f, +8.415113541e-04f, +9.960235479e-04f, +4.480752018e-04f, -2.753828356e-04f, -6.355725464e-04f, -4.784002737e-04f, -5.465316782e-05f, +2.677244663e-04f, +3.036838206e-04f, +1.297318172e-04f, -5.708357236e-05f, -1.249886400e-04f, -7.970380656e-05f, -5.456981773e-06f, +3.131693383e-05f, +2.454981878e-05f,
    /*  4,30 (48) */
    -1.037912875e-04f, -4.698424785e-04f, -7.824636741e-04f, -5.446247756e-04f, +5.660454554e-04f, +2.194998227e-03f, +3.173371668e-03f, +2.103954910e-03f, -1.477734733e-03f, -6.125916438e-03f, -8.653767076e-03f, -5.864920145e-03f, +2.864068951e-03f, +1.384991020e-02f, +1.992453453e-02f, +1.421799200e-02f, -4.720265686e-03f, -2.955255983e-02f, -4.534001030e-02f, -3.582842964e-02f, +7.746966475e-03f, +8.000411071e-02f, +1.611029342e-01f, +2.238954425e-01f, +2.455504115e-01f, +2.179359516e-01f, +1.514008679e-01f, +6.996908239e-02f, +4.680283662e-04f, -3.881892906e-02f, -4.445254764e-02f, -2.659001489e-02f, -1.791424718e-03f, +1.570298138e-02f, +1.970020593e-02f, +1.258076460e-02f, +1.530866785e-03f, -6.563730034e-03f, -8.577090238e-03f, -5.585508145e-03f, -9.215132624e-04f, +2.381343374e-03f, +3.138113875e-03f, +1.996858701e-03f, +3.830784047e-04f, -6.201978060e-04f, -7.627936470e-04f, -4.183041008e-04f,
    +8.462405133e-06f, +1.287362466e-05f, +4.134251716e-06f, -2.025163384e-05f, -4.667280462e-05f, -4.873677159e-05f, -5.796882022e-06f, +7.330111985e-05f, +1.410489017e-04f, +1.323041793e-04f, +1.125585379e-05f, -1.840650204e-04f, -3.375361450e-04f, -3.107140920e-04f, -3.856160836e-05f, +3.919537410e-04f, +7.427680672e-04f, +7.289417700e-04f, +1.849999595e-04f, -7.991145529e-04f, -1.864638951e-03f, -2.524654162e-03f, -2.400307809e-03f, -1.429075397e-03f, +7.462633087e-05f, +1.550106255e-03f, +2.449859669e-03f, +2.492078858e-03f, +1.774447867e-03f, +6.962478502e-04f, -2.582671380e-04f, -7.517939123e-04f, -7.212987527e-04f, -3.504813501e-04f, +7.342665820e-05f, +3.236061130e-04f, +3.288886600e-04f, +1.653081477e-04f, -2.699924766e-05f, -1.377842419e-04f, -1.369877151e-04f, -6.538677752e-05f, +1.179191290e-05f, +5.028703496e-05f, +4.478791382e-05f, +1.753912827e-05f, -5.683852374e-06f, -1.288252765e-05f,
    -1.480368983e-04f, +4.000628628e-04f, +1.396216632e-03f, +1.765377331e-03f, +1.040225788e-04f, -3.551916750e-03f, -6.488205641e-03f, -4.670426006e-03f, +3.312533726e-03f, +1.297261759e-02f, +1.551195017e-02f, +4.915604835e-03f, -1.466313822e-02f, -2.886588855e-02f, -2.318553514e-02f, +3.533581191e-03f, +3.422101022e-02f, +4.422763222e-02f, +2.122542722e-02f, -2.187860335e-02f, -5.379640085e-02f, -4.840645892e-02f, -6.671260404e-03f, +4.194654430e-02f, +6.132065237e-02f, +3.683412204e-02f, -1.305575991e-02f, -5.140832366e-02f, -5.150998624e-02f, -1.639731096e-02f, +2.571297331e-02f, +4.475165524e-02f, +3.104549652e-02f, -5.194742057e-04f, -2.520692960e-02f, -2.795980043e-02f, -1.215628714e-02f, +6.935631522e-03f, +1.586538384e-02f, +1.196446112e-02f, +2.070264759e-03f, -5.255660287e-03f, -6.304788449e-03f, -3.053874213e-03f, +4.458508201e-04f, +1.807083737e-03f, +1.275221087e-03f, +2.960954655e-04f,
    -6.706631824e-06f, -2.682848005e-05f, -2.951398656e-05f, +1.348826031e-05f, +8.884499839e-05f, +1.239808950e-04f, +3.886700897e-05f, -1.562180990e-04f, -3.142442435e-04f, -2.420266134e-04f, +1.087736719e-04f, +5.203823168e-04f, +6.203033410e-04f, +1.964753024e-04f, -5.392888856e-04f, -1.022102766e-03f, -7.637947150e-04f, +1.826714690e-04f, +1.155873363e-03f, +1.356020827e-03f, +5.145848785e-04f, -8.089345225e-04f, -1.610209589e-03f, -1.234796034e-03f, +6.886550882e-05f, +1.320407745e-03f, +1.580821894e-03f, +6.915044642e-04f, -6.280668059e-04f, -1.383526417e-03f, -1.087129161e-03f, -7.942130382e-05f, +8.232157439e-04f, +1.003667029e-03f, +4.711862525e-04f, -2.562102288e-04f, -6.325743770e-04f, -4.893309108e-04f, -6.803395823e-05f, +2.617518459e-04f, +3.066609371e-04f, +1.363776150e-04f, -5.271780462e-05f, -1.249178960e-04f, -8.203562472e-05f, -7.404259204e-06f, +3.093642097e-05f, +2.514036432e-05f,
    /*  4,31 (48) */
    -9.532888232e-05f, -4.569688538e-04f, -7.783294224e-04f, -5.648764094e-04f, +5.193726508e-04f, +2.146261456e-03f, +3.167574786e-03f, +2.177256030e-03f, -1.336685832e-03f, -5.993612259e-03f, -8.642511222e-03f, -6.048985165e-03f, +2.526532806e-03f, +1.353919611e-02f, +1.988597292e-02f, +1.460994574e-02f, -3.977497619e-03f, -2.882361806e-02f, -4.515501034e-02f, -3.662754419e-02f, +5.882327524e-03f, +7.747945655e-02f, +1.587026264e-01f, +2.224663671e-01f, +2.456250379e-01f, +2.194860579e-01f, +1.538507276e-01f, +7.246116125e-02f, +2.242476233e-03f, -3.812268121e-02f, -4.471081478e-02f, -2.734180880e-02f, -2.512723471e-03f, +1.535250003e-02f, +1.977363258e-02f, +1.290437072e-02f, +1.859755445e-03f, -6.398421886e-03f, -8.604089486e-03f, -5.723292387e-03f, -1.058500977e-03f, +2.315956597e-03f, +3.149905788e-03f, +2.047145736e-03f, +4.278663186e-04f, -6.026586777e-04f, -7.684774994e-04f, -4.311866284e-04f,
    +8.220998674e-06f, +1.288967773e-05f, +4.667676794e-06f, -1.934333100e-05f, -4.606746708e-05f, -4.929954776e-05f, -7.835189267e-06f, +7.066966975e-05f, +1.397696245e-04f, +1.342466470e-04f, +1.658656658e-05f, -1.778452548e-04f, -3.348305944e-04f, -3.152640733e-04f, -5.035847333e-05f, +3.781907203e-04f, +7.359666910e-04f, +7.370963161e-04f, +2.098854303e-04f, -7.647153423e-04f, -1.834960044e-03f, -2.514578272e-03f, -2.417690168e-03f, -1.469980364e-03f, +2.487863475e-05f, +1.510328867e-03f, +2.434208634e-03f, +2.503717032e-03f, +1.804891247e-03f, +7.304216719e-04f, -2.343101320e-04f, -7.447129475e-04f, -7.288074567e-04f, -3.643635712e-04f, +6.198186541e-05f, +3.195613163e-04f, +3.319467664e-04f, +1.715914665e-04f, -2.183516949e-05f, -1.360732244e-04f, -1.384152296e-04f, -6.803089721e-05f, +9.833808267e-06f, +4.981617239e-05f, +4.543886514e-05f, +1.843893728e-05f, -5.184246216e-06f, -1.289254766e-05f,
    -1.547435301e-04f, +3.732343827e-04f, +1.366702646e-03f, +1.778865592e-03f, +1.928675772e-04f, -3.427935855e-03f, -6.449338632e-03f, -4.826644105e-03f, +2.998289482e-03f, +1.273059098e-02f, +1.562072385e-02f, +5.435987152e-03f, -1.404283488e-02f, -2.866941325e-02f, -2.372482403e-02f, +2.511478425e-03f, +3.345721550e-02f, +4.441030368e-02f, +2.238130058e-02f, -2.052258252e-02f, -5.328181598e-02f, -4.921539345e-02f, -8.281469993e-03f, +4.071174827e-02f, +6.138951788e-02f, +3.815452979e-02f, -1.147493802e-02f, -5.071681919e-02f, -5.213805305e-02f, -1.778083738e-02f, +2.462584415e-02f, +4.467223393e-02f, +3.186871227e-02f, +4.841928232e-04f, -2.473574335e-02f, -2.821601066e-02f, -1.278886151e-02f, +6.446300611e-03f, +1.579734988e-02f, +1.222621297e-02f, +2.376925696e-03f, -5.119282672e-03f, -6.357506254e-03f, -3.178792109e-03f, +3.638151954e-04f, +1.799679478e-03f, +1.306157508e-03f, +3.212358298e-04f,
    -6.143495962e-06f, -2.628081681e-05f, -3.003560201e-05f, +1.142115956e-05f, +8.660920381e-05f, +1.244160341e-04f, +4.360734750e-05f, -1.496270931e-04f, -3.119466899e-04f, -2.489011455e-04f, +9.510474086e-05f, +5.103339566e-04f, +6.249418104e-04f, +2.167432336e-04f, -5.168134989e-04f, -1.016717124e-03f, -7.843461819e-04f, +1.481780446e-04f, +1.133732786e-03f, +1.366287754e-03f, +5.529630450e-04f, -7.702899258e-04f, -1.601633554e-03f, -1.264336964e-03f, +2.296124824e-05f, +1.292881518e-03f, +1.591834473e-03f, +7.311358218e-04f, -5.907998826e-04f, -1.375457392e-03f, -1.110810779e-03f, -1.137522031e-04f, +8.041570547e-04f, +1.010568477e-03f, +4.941058242e-04f, -2.366593558e-04f, -6.290315529e-04f, -4.999795024e-04f, -8.152129225e-05f, +2.554768633e-04f, +3.094170965e-04f, +1.430114735e-04f, -4.822503056e-05f, -1.247277122e-04f, -8.433841439e-05f, -9.392727151e-06f, +3.050953535e-05f, +2.571773609e-05f,
    /*  5, 0 (48) */
    -9.712561017e-05f, +5.630052980e-04f, +1.206067011e-03f, +7.527819647e-04f, -1.206557913e-03f, -3.245991688e-03f, -2.728345499e-03f, +1.489426586e-03f, +6.622324221e-03f, +7.089903931e-03f, -2.805093114e-04f, -1.122619085e-02f, -1.522873798e-02f, -4.406023078e-03f, +1.648289776e-02f, +2.943133839e-02f, +1.647195998e-02f, -2.143009154e-02f, -5.654855430e-02f, -4.868148545e-02f, +2.497919491e-02f, +1.464018327e-01f, +2.604437981e-01f, +3.070623956e-01f, +2.604437981e-01f, +1.464018327e-01f, +2.497919491e-02f, -4.868148545e-02f, -5.654855430e-02f, -2.143009154e-02f, +1.647195998e-02f, +2.943133839e-02f, +1.648289776e-02f, -4.406023078e-03f, -1.522873798e-02f, -1.122619085e-02f, -2.805093114e-04f, +7.089903931e-03f, +6.622324221e-03f, +1.489426586e-03f, -2.728345499e-03f, -3.245991688e-03f, -1.206557913e-03f, +7.527819647e-04f, +1.206067011e-03f, +5.630052980e-04f, -9.712561017e-05f, -2.479949097e-04f,
    -1.282518843e-05f, -2.532528913e-05f, -9.046210131e-06f, +3.889954925e-05f, +7.491153978e-05f, +3.839122229e-05f, -7.498057630e-05f, -1.710018670e-04f, -1.194036389e-04f, +1.033564617e-04f, +3.283880359e-04f, +2.970847865e-04f, -8.290196051e-05f, -5.560876896e-04f, -6.462049060e-04f, -7.534959806e-05f, +8.584651506e-04f, +1.345120911e-03f, +6.450357199e-04f, -1.214091364e-03f, -3.234852854e-03f, -4.026043107e-03f, -2.803210385e-03f, -4.783988299e-05f, +2.734317328e-03f, +4.019323722e-03f, +3.284868198e-03f, +1.281996999e-03f, -6.015724119e-04f, -1.343618217e-03f, -8.852743607e-04f, +4.837949091e-05f, +6.385264040e-04f, +5.671719722e-04f, +9.852083963e-05f, -2.901112160e-04f, -3.324887018e-04f, -1.116913074e-04f, +1.146544985e-04f, +1.721770654e-04f, +7.895742338e-05f, -3.577215824e-05f, -7.511648637e-05f, -4.054173673e-05f, +7.922171439e-06f, +2.536792522e-05f, +1.339113908e-05f, -2.077502712e-06f,
    +5.939400487e-04f, -2.971519080e-04f, -2.102283883e-03f, -2.360885377e-03f, +1.198769271e-03f, +6.225411832e-03f, +5.885033052e-03f, -3.266913899e-03f, -1.360369760e-02f, -1.128997664e-02f, +6.959510654e-03f, +2.424665836e-02f, +1.796260386e-02f, -1.233743150e-02f, -3.690527276e-02f, -2.458115068e-02f, +1.881243249e-02f, +4.916511396e-02f, +2.951026661e-02f, -2.514630357e-02f, -5.812289420e-02f, -3.141212080e-02f, +2.978290985e-02f, +6.141247912e-02f, +2.978290985e-02f, -3.141212080e-02f, -5.812289420e-02f, -2.514630357e-02f, +2.951026661e-02f, +4.916511396e-02f, +1.881243249e-02f, -2.458115068e-02f, -3.690527276e-02f, -1.233743150e-02f, +1.796260386e-02f, +2.424665836e-02f, +6.959510654e-03f, -1.128997664e-02f, -1.360369760e-02f, -3.266913899e-03f, +5.885033052e-03f, +6.225411832e-03f, +1.198769271e-03f, -2.360885377e-03f, -2.102283883e-03f, -2.971519080e-04f, +5.939400487e-04f, +3.757269824e-04f,
    +5.619091256e-06f, +4.877898058e-05f, +5.001166561e-05f, -4.580540148e-05f, -1.616706026e-04f, -1.138544649e-04f, +1.507196706e-04f, +3.732587375e-04f, +1.958668817e-04f, -3.489190265e-04f, -6.864866184e-04f, -2.710473447e-04f, +6.463035710e-04f, +1.064299823e-03f, +3.066330440e-04f, -1.011454792e-03f, -1.432111537e-03f, -2.770896161e-04f, +1.375500241e-03f, +1.699573653e-03f, +1.785591216e-04f, -1.650720551e-03f, -1.793723894e-03f, -3.412141537e-05f, +1.761957904e-03f, +1.688158924e-03f, -1.142151055e-04f, -1.676686855e-03f, -1.413748698e-03f, +2.233016724e-04f, +1.418809249e-03f, +1.045542951e-03f, -2.671187145e-04f, -1.058968687e-03f, -6.727082646e-04f, +2.459798275e-04f, +6.862098894e-04f, +3.664436410e-04f, -1.825774125e-04f, -3.750921654e-04f, -1.603876878e-04f, +1.083483004e-04f, +1.635764684e-04f, +4.996526961e-05f, -4.852002281e-05f, -4.990376237e-05f, -6.801361925e-06f, +1.364337518e-05f,
    /*  5, 1 (48) */
    -1.099507986e-04f, +5.376800088e-04f, +1.197020801e-03f, +7.916815140e-04f, -1.131646373e-03f, -3.207600465e-03f, -2.803326075e-03f, +1.318424719e-03f, +6.502920583e-03f, +7.193260392e-03f, +4.787872449e-05f, -1.092910607e-02f, -1.531163994e-02f, -4.962110768e-03f, +1.583669286e-02f, +2.935598879e-02f, +1.733042513e-02f, -2.008497063e-02f, -5.590351858e-02f, -4.989557681e-02f, +2.174434206e-02f, +1.423757896e-01f, +2.576405877e-01f, +3.070145557e-01f, +2.631781154e-01f, +1.504211564e-01f, +2.826406311e-02f, -4.739948845e-02f, -5.715012672e-02f, -2.277370976e-02f, +1.558668562e-02f, +2.947971788e-02f, +1.712142417e-02f, -3.838851106e-03f, -1.513021714e-02f, -1.151630207e-02f, -6.129980132e-04f, +6.978212623e-03f, +6.736978720e-03f, +1.661603651e-03f, -2.649388075e-03f, -3.281763846e-03f, -1.281674399e-03f, +7.122402280e-04f, +1.213989182e-03f, +5.883732232e-04f, -8.373447109e-05f, -2.500724124e-04f,
    -1.225783667e-05f, -2.525256859e-05f, -1.013486907e-05f, +3.724771090e-05f, +7.463086104e-05f, +4.092589172e-05f, -7.099083746e-05f, -1.696732221e-04f, -1.239676040e-04f, +9.503320589e-05f, +3.240227631e-04f, +3.036857170e-04f, -6.739588425e-05f, -5.446129107e-04f, -6.531856788e-04f, -1.019169912e-04f, +8.312152161e-04f, +1.345396299e-03f, +6.872785669e-04f, -1.146381061e-03f, -3.183583322e-03f, -4.030681563e-03f, -2.870514001e-03f, -1.434918397e-04f, +2.663871431e-03f, +4.010517398e-03f, +3.333588684e-03f, +1.350054072e-03f, -5.569062743e-04f, -1.340873323e-03f, -9.116132390e-04f, +2.102664783e-05f, +6.301490248e-04f, +5.778504940e-04f, +1.142387896e-04f, -2.827671959e-04f, -3.363172964e-04f, -1.200295256e-04f, +1.097224341e-04f, +1.731953418e-04f, +8.291697915e-05f, -3.307012695e-05f, -7.524412339e-05f, -4.217219376e-05f, +6.763373530e-06f, +2.537973484e-05f, +1.395485539e-05f, -1.755773309e-06f,
    +5.995591399e-04f, -2.483729274e-04f, -2.052272217e-03f, -2.406690779e-03f, +1.037098668e-03f, +6.111557367e-03f, +6.035752723e-03f, -2.893655162e-03f, -1.340783072e-02f, -1.163889566e-02f, +6.273024036e-03f, +2.397561102e-02f, +1.860890744e-02f, -1.127313167e-02f, -3.659863972e-02f, -2.559260547e-02f, +1.738032095e-02f, +4.888802435e-02f, +3.088576685e-02f, -2.344672992e-02f, -5.794433508e-02f, -3.306284135e-02f, +2.798918595e-02f, +6.137835771e-02f, +3.154486775e-02f, -2.972396188e-02f, -5.823710931e-02f, -2.682299043e-02f, +2.809651791e-02f, +4.938841564e-02f, +2.023124174e-02f, -2.353560773e-02f, -3.717239147e-02f, -1.339640018e-02f, +1.728989560e-02f, +2.449263819e-02f, +7.645720544e-03f, -1.092353299e-02f, -1.378627501e-02f, -3.642006065e-03f, +5.724645364e-03f, +6.333760132e-03f, +1.362345739e-03f, -2.310920108e-03f, -2.150803906e-03f, -3.470556704e-04f, +5.871386867e-04f, +3.893703576e-04f,
    +4.466594439e-06f, +4.761327908e-05f, +5.139596134e-05f, -4.167685723e-05f, -1.595939104e-04f, -1.191183543e-04f, +1.410228537e-04f, +3.709989590e-04f, +2.087436413e-04f, -3.311930698e-04f, -6.859527169e-04f, -2.955495186e-04f, +6.193841835e-04f, +1.068359147e-03f, +3.455152596e-04f, -9.764189553e-04f, -1.443705745e-03f, -3.303161911e-04f, +1.335830847e-03f, +1.720460254e-03f, +2.425559345e-04f, -1.611465173e-03f, -1.823431103e-03f, -1.023247407e-04f, +1.728168432e-03f, +1.723734218e-03f, -4.959784783e-05f, -1.651820586e-03f, -1.450526321e-03f, +1.690127679e-04f, +1.403805461e-03f, +1.078637439e-03f, -2.270146915e-04f, -1.052362092e-03f, -6.985620449e-04f, +2.203717640e-04f, +6.851140893e-04f, +3.837428672e-04f, -1.688864313e-04f, -3.764907428e-04f, -1.700139223e-04f, +1.026029163e-04f, +1.653056012e-04f, +5.415123641e-05f, -4.692069522e-05f, -5.098474714e-05f, -8.012240443e-06f, +1.355093038e-05f,
    /*  5, 2 (48) */
    -1.222086353e-04f, +5.124274402e-04f, +1.186885931e-03f, +8.289292249e-04f, -1.057015512e-03f, -3.166674574e-03f, -2.874316912e-03f, +1.148751496e-03f, +6.378952979e-03f, +7.288293598e-03f, +3.719014876e-04f, -1.062542035e-02f, -1.537903583e-02f, -5.506723678e-03f, +1.518350718e-02f, +2.925407180e-02f, +1.816164035e-02f, -1.873957433e-02f, -5.521624002e-02f, -5.104195788e-02f, +1.856075873e-02f, +1.383451080e-01f, +2.547700737e-01f, +3.068710639e-01f, +2.658419868e-01f, +1.544316738e-01f, +3.159765179e-02f, -4.604943438e-02f, -5.770703299e-02f, -2.411458308e-02f, +1.467507238e-02f, +2.950074453e-02f, +1.775157319e-02f, -3.261000612e-03f, -1.501597835e-02f, -1.179906927e-02f, -9.493153096e-04f, +6.858183098e-03f, +6.846701154e-03f, +1.834798993e-03f, -2.566471096e-03f, -3.314833973e-03f, -1.356918523e-03f, +6.700680342e-04f, +1.220752556e-03f, +6.137529580e-04f, -6.977961571e-05f, -2.518281858e-04f,
    -1.168990126e-05f, -2.515052909e-05f, -1.118758209e-05f, +3.558827568e-05f, +7.427608600e-05f, +4.337485293e-05f, -6.699255526e-05f, -1.681947169e-04f, -1.283443613e-04f, +8.672964061e-05f, +3.194005173e-04f, +3.099122062e-04f, -5.201607505e-05f, -5.327630927e-04f, -6.594704999e-04f, -1.280622791e-04f, +8.035542069e-04f, +1.344460098e-03f, +7.282843910e-04f, -1.078909526e-03f, -3.131100912e-03f, -4.033246478e-03f, -2.936192693e-03f, -2.390603885e-04f, +2.591910390e-03f, +3.999619503e-03f, +3.380974317e-03f, +1.418218264e-03f, -5.110560018e-04f, -1.336872173e-03f, -9.374522451e-04f, -6.688377871e-06f, +6.210722581e-04f, +5.881082002e-04f, +1.300418210e-04f, -2.750553076e-04f, -3.398665344e-04f, -1.283627894e-04f, +1.046099163e-04f, +1.740533367e-04f, +8.685479693e-05f, -3.028666972e-05f, -7.529293449e-05f, -4.378881732e-05f, +5.570491509e-06f, +2.536000083e-05f, +1.451548917e-05f, -1.420241427e-06f,
    +6.040257344e-04f, -2.007596483e-04f, -2.000876256e-03f, -2.448367636e-03f, +8.775047576e-04f, +5.992439012e-03f, +6.176775576e-03f, -2.522656203e-03f, -1.319908707e-02f, -1.197008873e-02f, +5.587071319e-03f, +2.368006150e-02f, +1.922829162e-02f, -1.020477253e-02f, -3.625312446e-02f, -2.656902443e-02f, +1.593661521e-02f, +4.855770816e-02f, +3.222159770e-02f, -2.172626967e-02f, -5.770177914e-02f, -3.467430652e-02f, +2.616575485e-02f, +6.127603297e-02f, +3.327303618e-02f, -2.800022766e-02f, -5.828670715e-02f, -2.847481101e-02f, +2.664599159e-02f, +4.955742841e-02f, +2.163504720e-02f, -2.245697029e-02f, -3.739940617e-02f, -1.444876228e-02f, +1.659133356e-02f, +2.471300995e-02f, +8.330834633e-03f, -1.053979013e-02f, -1.395516144e-02f, -4.018496808e-03f, +5.554631442e-03f, +6.436363048e-03f, +1.527651340e-03f, -2.256768871e-03f, -2.197724601e-03f, -3.980404175e-04f, +5.791264463e-04f, +4.029212880e-04f,
    +3.344956610e-06f, +4.640953171e-05f, +5.267340081e-05f, -3.758471417e-05f, -1.573524280e-04f, -1.241372887e-04f, +1.313100623e-04f, +3.683217620e-04f, +2.211971578e-04f, -3.132897930e-04f, -6.846175414e-04f, -3.194624803e-04f, +5.919866399e-04f, +1.071151816e-03f, +3.837239896e-04f, -9.404822960e-04f, -1.453587369e-03f, -3.829219223e-04f, +1.294791911e-03f, +1.739328359e-03f, +3.061321530e-04f, -1.570440944e-03f, -1.851046690e-03f, -1.704095971e-04f, +1.692393190e-03f, +1.757402499e-03f, +1.521820702e-05f, -1.624997983e-03f, -1.485784786e-03f, +1.142841741e-04f, +1.387108823e-03f, +1.110693183e-03f, -1.863643975e-04f, -1.044477917e-03f, -7.238290583e-04f, +1.942488568e-04f, +6.831917134e-04f, +4.007926665e-04f, -1.548057940e-04f, -3.774464191e-04f, -1.795852487e-04f, +9.662174551e-05f, +1.668522344e-04f, +5.835793373e-05f, -4.521350195e-05f, -5.201905875e-05f, -9.250480050e-06f, +1.342746520e-05f,
    /*  5, 3 (48) */
    -1.338985365e-04f, +4.872769112e-04f, +1.175698349e-03f, +8.645175005e-04f, -9.827394263e-04f, -3.123299721e-03f, -2.941309468e-03f, +9.805567796e-04f, +6.250608617e-03f, +7.375023239e-03f, +6.913020049e-04f, -1.031550814e-02f, -1.543105190e-02f, -6.039486771e-03f, +1.452403668e-02f, +2.912600952e-02f, +1.896519456e-02f, -1.739511424e-02f, -5.448795563e-02f, -5.212086740e-02f, +1.542965782e-02f, +1.343118615e-01f, +2.518338810e-01f, +3.066320035e-01f, +2.684338972e-01f, +1.584312933e-01f, +3.497862611e-02f, -4.463121611e-02f, -5.821808899e-02f, -2.545145526e-02f, +1.373762014e-02f, +2.949405615e-02f, +1.837264545e-02f, -2.672892411e-03f, -1.488593653e-02f, -1.207412457e-02f, -1.289181844e-03f, +6.729820308e-03f, +6.951311070e-03f, +2.008852329e-03f, -2.479616299e-03f, -3.345120643e-03f, -1.432211457e-03f, +6.262792169e-04f, +1.226323047e-03f, +6.391129589e-04f, -5.526412654e-05f, -2.532484272e-04f,
    -1.112218308e-05f, -2.501995817e-05f, -1.220383718e-05f, +3.392327012e-05f, +7.384890615e-05f, +4.573690588e-05f, -6.299002298e-05f, -1.665700430e-04f, -1.325320967e-04f, +7.845374324e-05f, +3.145290927e-04f, +3.157628388e-04f, -3.677571941e-05f, -5.205538694e-04f, -6.650617683e-04f, -1.537666687e-04f, +7.755117888e-04f, +1.342328824e-03f, +7.680377050e-04f, -1.011719708e-03f, -3.077447539e-03f, -4.033746599e-03f, -3.000212120e-03f, -3.344899904e-04f, +2.518472968e-03f, +3.986626796e-03f, +3.426985803e-03f, +1.486444859e-03f, -4.640413452e-04f, -1.331601571e-03f, -9.627619319e-04f, -3.474447002e-05f, +6.112962379e-04f, +5.979302622e-04f, +1.459156977e-04f, -2.669785256e-04f, -3.431293195e-04f, -1.366826693e-04f, +9.931963539e-05f, +1.747478114e-04f, +9.076638712e-05f, -2.742344173e-05f, -7.526146721e-05f, -4.538948299e-05f, +4.344255180e-06f, +2.530803227e-05f, +1.507217817e-05f, -1.071067014e-06f,
    +6.073706910e-04f, -1.543501166e-04f, -1.948202855e-03f, -2.485952350e-03f, +7.201523296e-04f, +5.868301724e-03f, +6.308085639e-03f, -2.154334441e-03f, -1.297788992e-02f, -1.228337852e-02f, +4.902453778e-03f, +2.336059902e-02f, +1.982027826e-02f, -9.133620712e-03f, -3.586940047e-02f, -2.750950673e-02f, +1.448302784e-02f, +4.817478624e-02f, +3.351638961e-02f, -1.998694131e-02f, -5.739564699e-02f, -3.624474747e-02f, +2.431470816e-02f, +6.110562337e-02f, +3.496542937e-02f, -2.624282516e-02f, -5.827148895e-02f, -3.009980900e-02f, +2.516020681e-02f, +4.967171258e-02f, +2.302215602e-02f, -2.134627711e-02f, -3.758577056e-02f, -1.549324019e-02f, +1.586750450e-02f, +2.490725881e-02f, +9.014026346e-03f, -1.013899746e-02f, -1.410996723e-02f, -4.395943227e-03f, +5.375046193e-03f, +6.532984794e-03f, +1.694503575e-03f, -2.198410938e-03f, -2.242938103e-03f, -4.500594762e-04f, +5.698759662e-04f, +4.163487532e-04f,
    +2.255182080e-06f, +4.517060431e-05f, +5.384462416e-05f, -3.353389702e-05f, -1.549523100e-04f, -1.289089615e-04f, +1.215939488e-04f, +3.652364931e-04f, +2.332175677e-04f, -2.952331641e-04f, -6.824913432e-04f, -3.427633103e-04f, +5.641477479e-04f, +1.072684480e-03f, +4.212189541e-04f, -9.036924671e-04f, -1.461753968e-03f, -4.348483358e-04f, +1.252436269e-03f, +1.756162112e-03f, +3.692150440e-04f, -1.527698035e-03f, -1.876540307e-03f, -2.382971639e-04f, +1.654672260e-03f, +1.789122022e-03f, +8.015822091e-05f, -1.596244569e-03f, -1.519477402e-03f, +5.917795491e-05f, +1.368730061e-03f, +1.141666093e-03f, -1.452122113e-04f, -1.035315582e-03f, -7.484738657e-04f, +1.676376893e-04f, +6.804362127e-04f, +4.175690386e-04f, -1.403480063e-04f, -3.779516098e-04f, -1.890884151e-04f, +9.040859955e-05f, +1.682107523e-04f, +6.257985583e-05f, -4.339842234e-05f, -5.300382693e-05f, -1.051475348e-05f, +1.327219129e-05f,
    /*  5, 4 (48) */
    -1.450207196e-04f, +4.622569530e-04f, +1.163494512e-03f, +8.984407707e-04f, -9.088905201e-04f, -3.077562815e-03f, -3.004299491e-03f, +8.139867365e-04f, +6.118076521e-03f, +7.453476982e-03f, +1.005831098e-03f, -9.999745306e-03f, -1.546782762e-02f, -6.560040640e-03f, +1.385897491e-02f, +2.897224286e-02f, +1.974070635e-02f, -1.605278541e-02f, -5.371991792e-02f, -5.313258711e-02f, +1.235221028e-02f, +1.302781149e-01f, +2.488336689e-01f, +3.062975135e-01f, +2.709523702e-01f, +1.624179201e-01f, +3.840561191e-02f, -4.314477126e-02f, -5.868213034e-02f, -2.678305683e-02f, +1.277485821e-02f, +2.945931168e-02f, +1.898394169e-02f, -2.074962149e-03f, -1.474002084e-02f, -1.234110310e-02f, -1.632311164e-03f, +6.593137639e-03f, +7.050630706e-03f, +2.183600141e-03f, -2.388849912e-03f, -3.372544084e-03f, -1.507472925e-03f, +5.808897339e-04f, +1.230667302e-03f, +6.644209911e-04f, -4.019194836e-05f, -2.543194942e-04f,
    -1.055546563e-05f, -2.486166402e-05f, -1.318317613e-05f, +3.225469128e-05f, +7.335106579e-05f, +4.801096373e-05f, -5.898747491e-05f, -1.648029922e-04f, -1.365292130e-04f, +7.021336113e-05f, +3.094164336e-04f, +3.212365825e-04f, -2.168771654e-05f, -5.080010344e-04f, -6.699624954e-04f, -1.790119753e-04f, +7.471176191e-04f, +1.339019774e-03f, +8.065241007e-04f, -9.448540396e-04f, -3.022665690e-03f, -4.032192029e-03f, -3.062539108e-03f, -4.297252058e-04f, +2.443598970e-03f, +3.971537433e-03f, +3.471584587e-03f, +1.554688781e-03f, -4.158831038e-04f, -1.325049194e-03f, -9.875129711e-04f, -6.311996246e-05f, +6.008217499e-04f, +6.073020941e-04f, +1.618459476e-04f, -2.585402193e-04f, -3.460987533e-04f, -1.449806409e-04f, +9.385450125e-05f, +1.752756536e-04f, +9.464722144e-05f, -2.448221192e-05f, -7.514833557e-05f, -4.697204714e-05f, +3.085449097e-06f, +2.522316587e-05f, +1.562404701e-05f, -7.084341628e-07f,
    +6.096258730e-04f, -1.091795123e-04f, -1.894358231e-03f, -2.519486247e-03f, +5.652000196e-04f, +5.739392762e-03f, +6.429679587e-03f, -1.789097948e-03f, -1.274467235e-02f, -1.257861169e-02f, +4.219962434e-03f, +2.301783571e-02f, +2.038442601e-02f, -8.060936232e-03f, -3.544818151e-02f, -2.841319919e-02f, +1.302127387e-02f, +4.773993790e-02f, +3.476882588e-02f, -1.823077919e-02f, -5.702643195e-02f, -3.777244550e-02f, +2.243816785e-02f, +6.086732621e-02f, +3.662010163e-02f, -2.445370314e-02f, -5.819133072e-02f, -3.169605357e-02f, +2.364072940e-02f, +4.973089053e-02f, +2.439088608e-02f, -2.020461102e-02f, -3.773098278e-02f, -1.652855578e-02f, +1.511903063e-02f, +2.507489650e-02f, +9.694462559e-03f, -9.721428422e-03f, -1.425031524e-02f, -4.773894837e-03f, +5.185957778e-03f, +6.623393393e-03f, +1.862714327e-03f, -2.135831082e-03f, -2.286336525e-03f, -5.030633032e-04f, +5.593612128e-04f, +4.296209445e-04f,
    +1.198194503e-06f, +4.389935025e-05f, +5.491041683e-05f, -2.952917350e-05f, -1.523998194e-04f, -1.334314370e-04f, +1.118869784e-04f, +3.617528960e-04f, +2.447956822e-04f, -2.770470667e-04f, -6.795852465e-04f, -3.654300590e-04f, +5.359045371e-04f, +1.072965264e-03f, +4.579610073e-04f, -8.660978565e-04f, -1.468205161e-03f, -4.860380252e-04f, +1.208818120e-03f, +1.770948110e-03f, +4.317326185e-04f, -1.483288570e-03f, -1.899884136e-03f, -3.059088574e-04f, +1.615048053e-03f, +1.818853291e-03f, +1.451470514e-04f, -1.565588232e-03f, -1.551559172e-03f, +3.756894563e-06f, +1.348681970e-03f, +1.171513123e-03f, -1.036034182e-04f, -1.024876061e-03f, -7.724614896e-04f, +1.405657006e-04f, +6.768420109e-04f, +4.340480528e-04f, -1.255262157e-04f, -3.779992129e-04f, -1.985100593e-04f, +8.396766904e-05f, +1.693757007e-04f, +6.681136497e-05f, -4.147559932e-05f, -5.393619212e-05f, -1.180365334e-05f, +1.308435842e-05f,
    /*  5, 5 (48) */
    -1.555761852e-04f, +4.373952890e-04f, +1.150311336e-03f, +9.306954619e-04f, -8.355394543e-04f, -3.029551851e-03f, -3.063286966e-03f, +6.491837443e-04f, +5.981547307e-03f, +7.523690343e-03f, +1.315247531e-03f, -9.678508723e-03f, -1.548951534e-02f, -7.068041675e-03f, +1.318901241e-02f, +2.879323088e-02f, +2.048782397e-02f, -1.471376564e-02f, -5.291339382e-02f, -5.407744115e-02f, +9.329544592e-03f, +1.262459229e-01f, +2.457711298e-01f, +3.058677883e-01f, +2.733959691e-01f, +1.663894575e-01f, +4.187719650e-02f, -4.159008247e-02f, -5.909801344e-02f, -2.810810602e-02f, +1.178734524e-02f, +2.939619172e-02f, +1.958476344e-02f, -1.467660055e-03f, -1.457817489e-02f, -1.259964332e-02f, -1.978409917e-03f, +6.448156998e-03f, +7.144485207e-03f, +2.358875794e-03f, -2.294202691e-03f, -3.397026296e-03f, -1.582621260e-03f, +5.339176868e-04f, +1.233752751e-03f, +6.896441570e-04f, -2.456790136e-05f, -2.550279284e-04f,
    -9.990514341e-06f, -2.467647407e-05f, -1.412519415e-05f, +3.058450494e-05f, +7.278435928e-05f, +5.019605233e-05f, -5.498908266e-05f, -1.628974510e-04f, -1.403343294e-04f, +6.201620534e-05f, +3.040706252e-04f, +3.263327849e-04f, -6.764669129e-06f, -4.951205242e-04f, -6.741762959e-04f, -2.037806323e-04f, +7.184013214e-04f, +1.334551005e-03f, +8.437302523e-04f, -8.783544077e-04f, -2.966798390e-03f, -4.028594211e-03f, -3.123141668e-03f, -5.247107342e-04f, +2.367329218e-03f, +3.954350967e-03f, +3.514732883e-03f, +1.622904620e-03f, -3.666031161e-04f, -1.317203614e-03f, -1.011676179e-03f, -9.179265262e-05f, +5.896502377e-04f, +6.162093691e-04f, +1.778178744e-04f, -2.497441538e-04f, -3.487681447e-04f, -1.532480920e-04f, +8.821764323e-05f, +1.756338820e-04f, +9.849273735e-05f, -2.146486268e-05f, -7.495222276e-05f, -4.853434916e-05f, +1.794912561e-06f, +2.510476735e-05f, +1.617020805e-05f, -3.325513140e-07f,
    +6.108240676e-04f, -6.528016204e-05f, -1.839447814e-03f, -2.549015421e-03f, +4.128002002e-04f, +5.605961325e-03f, +6.541566566e-03f, -1.427345052e-03f, -1.249987667e-02f, -1.285565876e-02f, +3.540377188e-03f, +2.265240565e-02f, +2.092033054e-02f, -6.987970968e-03f, -3.499022051e-02f, -2.927929705e-02f, +1.155306871e-02f, +4.725389987e-02f, +3.597764400e-02f, -1.645983108e-02f, -5.659469933e-02f, -3.925573407e-02f, +2.053828372e-02f, +6.056141735e-02f, +3.823514968e-02f, -2.263484985e-02f, -5.804618367e-02f, -3.326164180e-02f, +2.208917023e-02f, +4.973464743e-02f, +2.573956805e-02f, -1.903309789e-02f, -3.783458619e-02f, -1.755343184e-02f, +1.434656914e-02f, +2.521546220e-02f, +1.037130457e-02f, -9.287380369e-03f, -1.437584146e-02f, -5.151894049e-03f, +4.987447719e-03f, +6.707361062e-03f, +2.032090028e-03f, -2.069019717e-03f, -2.327812125e-03f, -5.569994953e-04f, +5.475575594e-04f, +4.427053029e-04f,
    +1.748371843e-07f, +4.259860619e-05f, +5.587170545e-05f, -2.557515028e-05f, -1.497013158e-04f, -1.377031470e-04f, +1.022014149e-04f, +3.578810928e-04f, +2.559229908e-04f, -2.587552704e-04f, -6.759112251e-04f, -3.874417647e-04f, +5.072942109e-04f, +1.072003745e-03f, +4.939121784e-04f, -8.277475240e-04f, -1.472942613e-03f, -5.364347167e-04f, +1.163992963e-03f, +1.783675417e-03f, +4.936137165e-04f, -1.437266567e-03f, -1.921052916e-03f, -3.731664260e-04f, +1.573565251e-03f, +1.846559109e-03f, +2.101093419e-04f, -1.533059196e-03f, -1.581986859e-03f, -5.191557569e-05f, +1.326979411e-03f, +1.200192326e-03f, -6.158416111e-05f, -1.013161888e-03f, -7.957574627e-04f, +1.130611588e-04f, +6.724045223e-04f, +4.502058804e-04f, -1.103542023e-04f, -3.775826245e-04f, -2.078367251e-04f, +7.730352398e-05f, +1.703417977e-04f, +7.104669728e-05f, -3.944534245e-05f, -5.481331037e-05f, -1.311569267e-05f, +1.286325678e-05f,
    /*  5, 6 (48) */
    -1.655666996e-04f, +4.127188149e-04f, +1.136186142e-03f, +9.612799669e-04f, -7.627550950e-04f, -2.979355799e-03f, -3.118276048e-03f, +4.862862933e-04f, +5.841212978e-03f, +7.585706549e-03f, +1.619318156e-03f, -9.352175938e-03f, -1.549628001e-02f, -7.563162199e-03f, +1.251483612e-02f, +2.858945025e-02f, +2.120622529e-02f, -1.337921463e-02f, -5.206966357e-02f, -5.495579556e-02f, +6.362746202e-03f, +1.222173287e-01f, +2.426479881e-01f, +3.053430776e-01f, +2.757632984e-01f, +1.703438085e-01f, +4.539192938e-02f, -3.996717785e-02f, -5.946461656e-02f, -2.942530964e-02f, +1.077566906e-02f, +2.930439907e-02f, +2.017441367e-02f, -8.514506861e-04f, -1.440035701e-02f, -1.284938747e-02f, -2.327178061e-03f, +6.294908906e-03f, +7.232702850e-03f, +2.534509676e-03f, -2.195709953e-03f, -3.418491159e-03f, -1.657573483e-03f, +4.853833376e-04f, +1.235547664e-03f, +7.147489243e-04f, -8.397693308e-06f, -2.553604797e-04f,
    -9.428075830e-06f, -2.446523357e-05f, -1.502953948e-05f, +2.891464378e-05f, +7.215062819e-05f, +5.229130969e-05f, -5.099895153e-05f, -1.608573953e-04f, -1.439462797e-04f, +5.386984442e-05f, +2.984998835e-04f, +3.310511696e-04f, +7.981125454e-06f, -4.819284022e-04f, -6.777073783e-04f, -2.280557008e-04f, +6.893924609e-04f, +1.328941313e-03f, +8.796439193e-04f, -8.122621241e-04f, -2.909889168e-03f, -4.022965919e-03f, -3.181989019e-03f, -6.193914536e-04f, +2.289705519e-03f, +3.935068360e-03f, +3.556393705e-03f, +1.691046668e-03f, -3.162242503e-04f, -1.308054313e-03f, -1.035222544e-03f, -1.207398156e-04f, +5.777838078e-04f, +6.246380358e-04f, +1.938165692e-04f, -2.405944913e-04f, -3.511310192e-04f, -1.614763310e-04f, +8.241240968e-05f, +1.758196513e-04f, +1.022983425e-04f, -1.837338947e-05f, -7.467188368e-05f, -5.007421371e-05f, +4.735395420e-07f, +2.495223275e-05f, +1.670976246e-05f, +5.634856882e-08f,
    +6.109989047e-04f, -2.268155584e-05f, -1.783576109e-03f, -2.574590571e-03f, +2.630988845e-04f, +5.468258178e-03f, +6.643767981e-03f, -1.069463959e-03f, -1.224395368e-02f, -1.311441403e-02f, +2.864465963e-03f, +2.226496388e-02f, +2.142762475e-02f, -5.915967223e-03f, -3.449630833e-02f, -3.010704457e-02f, +1.008012610e-02f, +4.671746516e-02f, +3.714163696e-02f, -1.467615567e-02f, -5.610108561e-02f, -4.069300064e-02f, +1.861723080e-02f, +6.018825092e-02f, +3.980871493e-02f, -2.078829074e-02f, -5.783607433e-02f, -3.479470099e-02f, +2.050718337e-02f, +4.968273185e-02f, +2.706654746e-02f, -1.783290557e-02f, -3.789617035e-02f, -1.856659372e-02f, +1.355081168e-02f, +2.532852336e-02f, +1.104370909e-02f, -8.837174489e-03f, -1.448619566e-02f, -5.529476674e-03f, +4.779610994e-03f, +6.784664586e-03f, +2.202431825e-03f, -1.997973020e-03f, -2.367257467e-03f, -6.118128057e-04f, +5.344418668e-04f, +4.555685597e-04f,
    -8.141264825e-07f, +4.127118779e-05f, +5.672955354e-05f, -2.167626924e-05f, -1.468632456e-04f, -1.417228871e-04f, +9.254930693e-05f, +3.536315659e-04f, +2.665916643e-04f, -2.403814012e-04f, -6.714820789e-04f, -4.087784712e-04f, +4.783540991e-04f, +1.069810928e-03f, +5.290357102e-04f, -7.886911375e-04f, -1.475970030e-03f, -5.859833326e-04f, +1.118017518e-03f, +1.794335564e-03f, +5.547880913e-04f, -1.389687861e-03f, -1.940023976e-03f, -4.399920438e-04f, +1.530270760e-03f, +1.872204622e-03f, +2.749696122e-04f, -1.498689992e-03f, -1.610719037e-03f, -1.077754521e-04f, +1.303639304e-03f, +1.227662917e-03f, -1.920138852e-05f, -1.000177170e-03f, -8.183278745e-04f, +8.515313225e-05f, +6.671201672e-04f, +4.660188261e-04f, -9.484636779e-05f, -3.766957546e-04f, -2.170548800e-04f, +7.042111331e-05f, +1.711039439e-04f, +7.527996901e-05f, -3.730813087e-05f, -5.563235826e-05f, -1.444930562e-05f, +1.260821934e-05f,
    /*  5, 7 (48) */
    -1.749947754e-04f, +3.882535813e-04f, +1.121156602e-03f, +9.901946107e-04f, -6.906044669e-04f, -2.927064489e-03f, -3.169275000e-03f, +3.254288980e-04f, +5.697266698e-03f, +7.639576393e-03f, +1.917818040e-03f, -9.021124769e-03f, -1.548829888e-02f, -8.045090601e-03f, +1.183712874e-02f, +2.836139455e-02f, +2.189561775e-02f, -1.205027332e-02f, -5.119001965e-02f, -5.576805768e-02f, +3.452857034e-03f, +1.181943628e-01f, +2.394659991e-01f, +3.047236861e-01f, +2.780530039e-01f, +1.742788769e-01f, +4.894832309e-02f, -3.827613119e-02f, -5.978084081e-02f, -3.073336395e-02f, +9.740446513e-03f, +2.918365925e-02f, +2.075219748e-02f, -2.268126503e-04f, -1.420654044e-02f, -1.308998196e-02f, -2.678309081e-03f, +6.133432575e-03f, +7.315115260e-03f, +2.710329328e-03f, -2.093411611e-03f, -3.436864548e-03f, -1.732245367e-03f, +4.353091239e-04f, +1.236021203e-03f, +7.397011571e-04f, +8.312069153e-06f, -2.553041311e-04f,
    -8.868877284e-06f, -2.422880418e-05f, -1.589591286e-05f, +2.724700567e-05f, +7.145175848e-05f, +5.429598519e-05f, -4.702111702e-05f, -1.586868851e-04f, -1.473641109e-04f, +4.578169855e-05f, +2.927125456e-04f, +3.353918321e-04f, +2.253768358e-05f, -4.684408418e-04f, -6.805605342e-04f, -2.518208778e-04f, +6.601205199e-04f, +1.322210214e-03f, +9.142539476e-04f, -7.466178985e-04f, -2.851982022e-03f, -4.015321239e-03f, -3.239051608e-03f, -7.137124599e-04f, +2.210770639e-03f, +3.913691982e-03f, +3.596530898e-03f, +1.759068952e-03f, -2.647703935e-04f, -1.297591698e-03f, -1.058123249e-03f, -1.499382191e-04f, +5.652252355e-04f, +6.325743348e-04f, +2.098269225e-04f, -2.310957910e-04f, -3.531811281e-04f, -1.696565939e-04f, +7.644236730e-05f, +1.758302573e-04f, +1.060594193e-04f, -1.520990028e-05f, -7.430614754e-05f, -5.158945309e-05f, -8.777214654e-07f, +2.476498981e-05f, +1.724180117e-05f, +4.580078570e-07f,
    +6.101847783e-04f, +1.858963195e-05f, -1.726846555e-03f, -2.596266840e-03f, +1.162356389e-04f, +5.326535291e-03f, +6.736317288e-03f, -7.158323930e-04f, -1.197736201e-02f, -1.335479543e-02f, +2.192983884e-03f, +2.185618541e-02f, +2.190597885e-02f, -4.846156295e-03f, -3.396727262e-02f, -3.089573571e-02f, +8.604156065e-03f, +4.613148183e-02f, +3.825965448e-02f, -1.288182010e-02f, -5.554629752e-02f, -4.208268850e-02f, +1.667720682e-02f, +5.974825888e-02f, +4.133898570e-02f, -1.891608611e-02f, -5.756110472e-02f, -3.629339099e-02f, +1.889646434e-02f, +4.957495640e-02f, +2.837018677e-02f, -1.660524265e-02f, -3.791537174e-02f, -1.956677089e-02f, +1.273248380e-02f, +2.541367649e-02f, +1.171082926e-02f, -8.371155662e-03f, -1.458104203e-02f, -5.906172429e-03f, +4.562556114e-03f, +6.855085700e-03f, +2.373535769e-03f, -1.922693051e-03f, -2.404565598e-03f, -6.674451639e-04f, +5.199925611e-04f, +4.681767790e-04f,
    -1.768012448e-06f, +3.991988566e-05f, +5.748515713e-05f, -1.783680397e-05f, -1.438921311e-04f, -1.454898128e-04f, +8.294247518e-05f, +3.490151391e-04f, +2.767945562e-04f, -2.219489135e-04f, -6.663114089e-04f, -4.294212432e-04f, +4.491216100e-04f, +1.066399226e-03f, +5.632960958e-04f, -7.489789079e-04f, -1.477293135e-03f, -6.346300523e-04f, +1.070949660e-03f, +1.802922556e-03f, +6.151864918e-04f, -1.340610040e-03f, -1.956777258e-03f, -5.063084046e-04f, +1.485213656e-03f, +1.895757366e-03f, +3.396523490e-04f, -1.462515425e-03f, -1.637716154e-03f, -1.637582340e-04f, +1.278680614e-03f, +1.253885324e-03f, +2.349719803e-05f, -9.859275928e-04f, -8.401394188e-04f, +5.687146046e-05f, +6.609863865e-04f, +4.814633604e-04f, -7.901772440e-05f, -3.753330419e-04f, -2.261509316e-04f, +6.332576399e-05f, +1.716572328e-04f, +7.950518296e-05f, -3.506461595e-05f, -5.639053797e-05f, -1.580284829e-05f, +1.231862419e-05f,
    /*  5, 8 (48) */
    -1.838636527e-04f, +3.640247771e-04f, +1.105260690e-03f, +1.017441616e-03f, -6.191527084e-04f, -2.872768504e-03f, -3.216296117e-03f, +1.667420129e-04f, +5.549902587e-03f, +7.685358092e-03f, +2.210530586e-03f, -8.685732937e-03f, -1.546576120e-02f, -8.513531443e-03f, +1.115656820e-02f, +2.810957367e-02f, +2.255573827e-02f, -1.072806311e-02f, -5.027576570e-02f, -5.651467558e-02f, +6.008750117e-04f, +1.141790415e-01f, +2.362269475e-01f, +3.040099737e-01f, +2.802637745e-01f, +1.781925688e-01f, +5.254485398e-02f, -3.651706223e-02f, -6.004561120e-02f, -3.203095565e-02f, +8.682323264e-03f, +2.903372103e-02f, +2.131742272e-02f, +4.057616846e-04f, -1.399671352e-02f, -1.332107775e-02f, -3.031490209e-03f, +5.963775981e-03f, +7.391557627e-03f, +2.886159585e-03f, -1.987352192e-03f, -3.452074449e-03f, -1.806551514e-03f, +3.837196708e-04f, +1.235143482e-03f, +7.644661469e-04f, +2.555387032e-05f, -2.548461232e-04f,
    -8.313625809e-06f, -2.396806258e-05f, -1.672406700e-05f, +2.558345201e-05f, +7.068967762e-05f, +5.620943877e-05f, -4.305954150e-05f, -1.563900589e-04f, -1.505870813e-04f, +3.775903377e-05f, +2.867170601e-04f, +3.393552354e-04f, +3.689334343e-05f, -4.546741100e-04f, -6.827411283e-04f, -2.750605043e-04f, +6.306148736e-04f, +1.314377916e-03f, +9.475502706e-04f, -6.814618109e-04f, -2.793121386e-03f, -4.005675560e-03f, -3.294301130e-03f, -8.076191064e-04f, +2.130568273e-03f, +3.890225612e-03f, +3.635109170e-03f, +1.826925267e-03f, -2.122664403e-04f, -1.285807117e-03f, -1.080349702e-03f, -1.793641383e-04f, +5.519779693e-04f, +6.400048148e-04f, +2.258336362e-04f, -2.212530097e-04f, -3.549124572e-04f, -1.777800534e-04f, +7.031130021e-05f, +1.756631414e-04f, +1.097713294e-04f, -1.197661495e-05f, -7.385392033e-05f, -5.307786957e-05f, -2.257867657e-06f, +2.454249926e-05f, +1.776540592e-05f, +8.721441469e-07f,
    +6.084167658e-04f, +5.850951761e-05f, -1.669361398e-03f, -2.614103644e-03f, -2.765649223e-05f, +5.181045478e-03f, +6.819259763e-03f, -3.668172540e-04f, -1.170056746e-02f, -1.357674434e-02f, +1.526672475e-03f, +2.142676417e-02f, +2.235510046e-02f, -3.779757068e-03f, -3.340397652e-02f, -3.164471462e-02f, +7.126862931e-03f, +4.549685177e-02f, +3.933060414e-02f, -1.107889755e-02f, -5.493111103e-02f, -4.342329854e-02f, +1.472042957e-02f, +5.924195048e-02f, +4.282419935e-02f, -1.702032875e-02f, -5.722145237e-02f, -3.775590641e-02f, +1.725874818e-02f, +4.941119817e-02f, +2.964886738e-02f, -1.535135733e-02f, -3.789187454e-02f, -2.055269849e-02f, +1.189234439e-02f, +2.547054795e-02f, +1.237181565e-02f, -7.889692302e-03f, -1.466005975e-02f, -6.281505470e-03f, +4.336405182e-03f, +6.918411464e-03f, +2.545193002e-03f, -1.843187868e-03f, -2.439630214e-03f, -7.238357019e-04f, +5.041897128e-04f, +4.804954032e-04f,
    -2.686215319e-06f, +3.854746139e-05f, +5.813984021e-05f, -1.406085667e-05f, -1.407945597e-04f, -1.490034349e-04f, +7.339249953e-05f, +3.440429587e-04f, +2.865252041e-04f, -2.034810611e-04f, -6.604135915e-04f, -4.493521809e-04f, +4.196341833e-04f, +1.061782430e-03f, +5.966591145e-04f, -7.086615254e-04f, -1.476919655e-03f, -6.823223727e-04f, +1.022848338e-03f, +1.809432872e-03f, +6.747407438e-04f, -1.290092373e-03f, -1.971295339e-03f, -5.720388143e-04f, +1.438445122e-03f, +1.917187310e-03f, +4.040820973e-04f, -1.424572536e-03f, -1.662940582e-03f, -2.197990000e-04f, +1.252124341e-03f, +1.278821250e-03f, +6.646319794e-05f, -9.704204222e-04f, -8.611594400e-04f, +2.824672336e-05f, +6.540016554e-04f, +4.965161516e-04f, -6.288388262e-05f, -3.734894680e-04f, -2.351112459e-04f, +5.602317951e-05f, +1.719969615e-04f, +8.371623530e-05f, -3.271562375e-05f, -5.708508235e-05f, -1.717459974e-05f, +1.199389677e-05f,
    /*  5, 9 (48) */
    -1.921772785e-04f, +3.400567146e-04f, +1.088536623e-03f, +1.043025068e-03f, -5.484630308e-04f, -2.816559065e-03f, -3.259355658e-03f, +1.035195406e-05f, +5.399315506e-03f, +7.723117125e-03f, +2.497247646e-03f, -8.346377701e-03f, -1.542886786e-02f, -8.968205553e-03f, +1.047382708e-02f, +2.783451316e-02f, +2.318635314e-02f, -9.413685192e-03f, -4.932821543e-02f, -5.719613739e-02f, -2.192246374e-03f, +1.101733660e-01f, +2.329326463e-01f, +3.032023546e-01f, +2.823943428e-01f, +1.820827945e-01f, +5.617996315e-02f, -3.469013697e-02f, -6.025787764e-02f, -3.331676276e-02f, +7.601973562e-03f, +2.885435689e-02f, +2.186940069e-02f, +1.045766499e-03f, -1.377087989e-02f, -1.354233076e-02f, -3.386402666e-03f, +5.785995928e-03f, +7.461868927e-03f, +3.061822726e-03f, -1.877580862e-03f, -3.464051064e-03f, -1.880405434e-03f, +3.306418012e-04f, +1.232885614e-03f, +7.890086462e-04f, +4.331927624e-05f, -2.539739791e-04f,
    -7.763007857e-06f, -2.368389901e-05f, -1.751380594e-05f, +2.392580611e-05f, +6.986635178e-05f, +5.803114002e-05f, -3.911811091e-05f, -1.539711284e-04f, -1.536146589e-04f, +2.980895653e-05f, +2.805219773e-04f, +3.429422056e-04f, +5.103677261e-05f, -4.406445511e-04f, -6.842550870e-04f, -2.977595724e-04f, +6.009047662e-04f, +1.305465301e-03f, +9.795239089e-04f, -6.168332849e-04f, -2.733352090e-03f, -3.994045556e-03f, -3.347710544e-03f, -9.010570422e-04f, +2.049143015e-03f, +3.864674442e-03f, +3.672094116e-03f, +1.894569207e-03f, -1.587382800e-04f, -1.272692875e-03f, -1.101873560e-03f, -2.089933721e-04f, +5.380461344e-04f, +6.469163482e-04f, +2.418212370e-04f, -2.110715010e-04f, -3.563192359e-04f, -1.858378263e-04f, +6.402320883e-05f, +1.753158955e-04f, +1.134294190e-04f, -8.675864377e-06f, -7.331418729e-05f, -5.453725787e-05f, -3.665842204e-06f, +2.428425610e-05f, +1.827965033e-05f, +1.298450182e-06f,
    +6.057305505e-04f, +9.705697900e-05f, -1.611221558e-03f, -2.628164501e-03f, -1.684510519e-04f, +5.032042043e-03f, +6.892652262e-03f, -2.277429524e-05f, -1.141404225e-02f, -1.378022540e-02f, +8.662588835e-04f, +2.097741199e-02f, +2.277473465e-02f, -2.717974638e-03f, -3.280731741e-02f, -3.235337614e-02f, +5.649943275e-03f, +4.481452940e-02f, +4.035345248e-02f, -9.269464674e-03f, -5.425637028e-02f, -4.471339091e-02f, +1.274913423e-02f, +5.866991166e-02f, +4.426264447e-02f, -1.510314144e-02f, -5.681737027e-02f, -3.918047895e-02f, +1.559580760e-02f, +4.919139917e-02f, +3.090099172e-02f, -1.407253608e-02f, -3.782541135e-02f, -2.152311891e-02f, +1.103118495e-02f, +2.549879468e-02f, +1.302581730e-02f, -7.393176150e-03f, -1.472294363e-02f, -6.654994938e-03f, +4.101293936e-03f, +6.974434643e-03f, +2.717189964e-03f, -1.759471632e-03f, -2.472345838e-03f, -7.809207842e-04f, +4.870151131e-04f, +4.924893000e-04f,
    -3.568207542e-06f, +3.715664369e-05f, +5.869505005e-05f, -1.035235536e-05f, -1.375771734e-04f, -1.522636143e-04f, +6.391070698e-05f, +3.387264748e-04f, +2.957778293e-04f, -1.850008703e-04f, -6.538037531e-04f, -4.685544326e-04f, +3.899292429e-04f, +1.055975683e-03f, +6.290918642e-04f, -6.677900939e-04f, -1.474859304e-03f, -7.290091656e-04f, +9.737735056e-04f, +1.813865457e-03f, +7.333838297e-04f, -1.238195732e-03f, -1.983563450e-03f, -6.371072837e-04f, +1.390018391e-03f, +1.936466895e-03f, +4.681835516e-04f, -1.384900566e-03f, -1.686356674e-03f, -2.758324854e-04f, +1.223993503e-03f, +1.302433720e-03f, +1.096475668e-04f, -9.536645096e-04f, -8.813559796e-04f, -6.897906872e-07f, +6.461654956e-04f, +5.111540984e-04f, -4.646103780e-05f, -3.711605712e-04f, -2.439221649e-04f, +4.851943780e-05f, +1.721186407e-04f, +8.790692255e-05f, -3.026215731e-05f, -5.771326009e-05f, -1.856276310e-05f, +1.163351217e-05f,
    /*  5,10 (48) */
    -1.999402864e-04f, +3.163728156e-04f, +1.071022817e-03f, +1.066950874e-03f, -4.785966790e-04f, -2.758527925e-03f, -3.298473769e-03f, -1.436191744e-04f, +5.245700847e-03f, +7.752926082e-03f, +2.777769623e-03f, -8.003435496e-03f, -1.537783108e-02f, -9.408850104e-03f, +9.789571990e-03f, +2.753675359e-02f, +2.378725791e-02f, -8.108219891e-03f, -4.834869152e-02f, -5.781297067e-02f, -4.925598463e-03f, +1.061793204e-01f, +2.295849358e-01f, +3.023012975e-01f, +2.844434858e-01f, +1.859474689e-01f, +5.985205727e-02f, -3.279556776e-02f, -6.041661592e-02f, -3.458945564e-02f, +6.500100002e-03f, +2.864536352e-02f, +2.240744682e-02f, +1.692682847e-03f, -1.352905865e-02f, -1.375340227e-02f, -3.742721902e-03f, +5.600158101e-03f, +7.525892136e-03f, +3.237138622e-03f, -1.764151443e-03f, -3.472726928e-03f, -1.953719622e-03f, +2.761045433e-04f, +1.229219772e-03f, +8.132929023e-04f, +6.159892657e-05f, -2.526755289e-04f,
    -7.217688677e-06f, -2.337721593e-05f, -1.826498444e-05f, +2.227585175e-05f, +6.898378297e-05f, +5.976066708e-05f, -3.520063170e-05f, -1.514343731e-04f, -1.564465189e-04f, +2.193840843e-05f, +2.741359392e-04f, +3.461539264e-04f, +6.495697539e-05f, -4.263685705e-04f, -6.851088870e-04f, -3.199037319e-04f, +5.710192872e-04f, +1.295493904e-03f, +1.010166969e-03f, -5.527710620e-04f, -2.672719330e-03f, -3.980449169e-03f, -3.399254090e-03f, -9.939722517e-04f, +1.966540324e-03f, +3.837045076e-03f, +3.707452254e-03f, +1.961954204e-03f, -1.042127838e-04f, -1.258242246e-03f, -1.122666753e-03f, -2.388012594e-04f, +5.234345368e-04f, +6.532961475e-04f, +2.577740890e-04f, -2.005570148e-04f, -3.573959454e-04f, -1.938209822e-04f, +5.758230847e-05f, +1.747862663e-04f, +1.170290228e-04f, -5.310089543e-06f, -7.268601529e-05f, -5.596540759e-05f, -5.100534608e-06f, +2.398979095e-05f, +1.878360102e-05f, +1.736593812e-06f,
    +6.021623429e-04f, +1.342136227e-04f, -1.552526508e-03f, -2.638516856e-03f, -3.060282253e-04f, +4.879778429e-03f, +6.956562969e-03f, +3.159521796e-04f, -1.111826442e-02f, -1.396522627e-02f, +2.124551303e-04f, +2.050885756e-02f, +2.316466389e-02f, -1.661998956e-03f, -3.217822554e-02f, -3.302116624e-02f, +4.175083971e-03f, +4.408552023e-02f, +4.132722598e-02f, -7.455599217e-03f, -5.352298645e-02f, -4.595158665e-02f, +1.076557078e-02f, +5.803280438e-02f, +4.565266287e-02f, -1.316667454e-02f, -5.634918672e-02f, -4.056537951e-02f, +1.390945093e-02f, +4.891556668e-02f, +3.212498523e-02f, -1.277010236e-02f, -3.771576378e-02f, -2.247678342e-02f, +1.014982897e-02f, +2.549810488e-02f, +1.367198280e-02f, -6.882022052e-03f, -1.476940467e-02f, -7.026155510e-03f, +3.857371771e-03f, +7.022954081e-03f, +2.889308604e-03f, -1.671564710e-03f, -2.502607995e-03f, -8.386340443e-04f, +4.684523500e-04f, +5.041228121e-04f,
    -4.413538483e-06f, +3.575012473e-05f, +5.915235252e-05f, -6.715051279e-06f, -1.342466589e-04f, -1.552705567e-04f, +5.450816010e-05f, +3.330774214e-04f, +3.045473361e-04f, -1.665311122e-04f, -6.464977422e-04f, -4.870122059e-04f, +3.600441509e-04f, +1.048995450e-03f, +6.605627939e-04f, -6.264160665e-04f, -1.471123755e-03f, -7.746407335e-04f, +9.237860406e-04f, +1.816221724e-03f, +7.910499668e-04f, -1.184982522e-03f, -1.993569491e-03f, -7.014386192e-04f, +1.339988683e-03f, +1.953571069e-03f, +5.318816467e-04f, -1.343540912e-03f, -1.707930808e-03f, -3.317931603e-04f, +1.194313118e-03f, +1.324687140e-03f, +1.530006729e-04f, -9.356702918e-04f, -9.006978220e-04f, -2.990611803e-05f, +6.374784862e-04f, +5.253543618e-04f, -2.976595604e-05f, -3.683424601e-04f, -2.525700247e-04f, +4.082098868e-05f, +1.720180044e-04f, +9.207094896e-05f, -2.770539860e-05f, -5.827238086e-05f, -1.996546693e-05f, +1.123699732e-05f,
    /*  5,11 (48) */
    -2.071579750e-04f, +2.929955996e-04f, +1.052757832e-03f, +1.089226726e-03f, -4.096128960e-04f, -2.698767258e-03f, -3.333674401e-03f, -2.950535474e-04f, +5.089254328e-03f, +7.774864490e-03f, +3.051905562e-03f, -7.657281569e-03f, -1.531287411e-02f, -9.835218674e-03f, +9.104463103e-03f, +2.721684986e-02f, +2.435827719e-02f, -6.812725987e-03f, -4.733852455e-02f, -5.836574174e-02f, -7.598317793e-03f, +1.021988712e-01f, +2.261856817e-01f, +3.013073253e-01f, +2.864100261e-01f, +1.897845140e-01f, +6.355950952e-02f, -3.083361355e-02f, -6.052082871e-02f, -3.584769789e-02f, +5.377433249e-03f, +2.840656226e-02f, +2.293088136e-02f, +2.345978995e-03f, -1.327128456e-02f, -1.395395928e-02f, -4.100117847e-03f, +5.406337119e-03f, +7.583474445e-03f, +3.411924888e-03f, -1.647122420e-03f, -3.478037017e-03f, -2.026405637e-03f, +2.201391358e-04f, +1.224119238e-03f, +8.372826932e-04f, +8.038252759e-05f, -2.509389351e-04f,
    -6.678311802e-06f, -2.304892660e-05f, -1.897750724e-05f, +2.063533162e-05f, +6.804400617e-05f, +6.139770552e-05f, -3.131082784e-05f, -1.487841346e-04f, -1.590825413e-04f, +1.415416122e-05f, +2.675676699e-04f, +3.489919343e-04f, +7.864329961e-05f, -4.118626183e-04f, -6.853095436e-04f, -3.414792965e-04f, +5.409873483e-04f, +1.284485883e-03f, +1.039472643e-03f, -4.893131757e-04f, -2.611268631e-03f, -3.964905593e-03f, -3.448907308e-03f, -1.086311093e-03f, +1.882806499e-03f, +3.807345528e-03f, +3.741151049e-03f, +2.029033559e-03f, -4.871779011e-05f, -1.242449486e-03f, -1.142701516e-03f, -2.687626964e-04f, +5.081486657e-04f, +6.591317812e-04f, +2.736764066e-04f, -1.897156964e-04f, -3.581373279e-04f, -2.017205521e-04f, +5.099302774e-05f, +1.740721600e-04f, +1.205654696e-04f, -1.881840462e-06f, -7.196855515e-05f, -5.736010574e-05f, -6.560781128e-06f, +2.365867119e-05f, +1.927631872e-05f, +2.186217979e-06f,
    +5.977488045e-04f, +1.699637474e-04f, -1.493374155e-03f, -2.645231908e-03f, -4.402748842e-04f, +4.724507873e-03f, +7.011071129e-03f, +6.490296010e-04f, -1.081371709e-02f, -1.413175738e-02f, -4.340426119e-04f, +2.002184535e-02f, +2.352470804e-02f, -6.130035059e-04f, -3.151766275e-02f, -3.364758230e-02f, +2.703960216e-03f, +4.331087950e-02f, +4.225101202e-02f, -5.639377493e-03f, -5.273193649e-02f, -4.713656917e-02f, +8.772001286e-03f, +5.733136576e-02f, +4.699265155e-02f, -1.121310348e-02f, -5.581730507e-02f, -4.190892042e-02f, +1.220152012e-02f, +4.858377352e-02f, +3.331929834e-02f, -1.144541522e-02f, -3.756276311e-02f, -2.341245371e-02f, +9.249131144e-03f, +2.546819877e-02f, +1.430946128e-02f, -6.356667690e-03f, -1.479917063e-02f, -7.394497970e-03f, +3.604801746e-03f, +7.063775070e-03f, +3.061326609e-03f, -1.579493761e-03f, -2.530313393e-03f, -8.969064252e-04f, +4.484868831e-04f, +5.153598095e-04f,
    -5.221833379e-06f, +3.433055652e-05f, +5.951342718e-05f, -3.152516786e-06f, -1.308097366e-04f, -1.580248070e-04f, +4.519564591e-05f, +3.271077973e-04f, +3.128293097e-04f, -1.480942770e-04f, -6.385121023e-04f, -5.047107781e-04f, +3.300161610e-04f, +1.040859489e-03f, +6.910417326e-04f, -5.845911801e-04f, -1.465726618e-03f, -8.191688640e-04f, +8.729476697e-04f, +1.816505538e-03f, +8.476746833e-04f, -1.130516597e-03f, -2.001304046e-03f, -7.649585135e-04f, +1.288413138e-03f, +1.968477322e-03f, +5.951016491e-04f, -1.300537084e-03f, -1.727631438e-03f, -3.876153077e-04f, +1.163110185e-03f, +1.345547346e-03f, +1.964723545e-04f, -9.164497890e-04f, -9.191545389e-04f, -5.936965397e-05f, +6.279422738e-04f, +5.390943982e-04f, -1.281595904e-05f, -3.650318258e-04f, -2.610411744e-04f, +3.293465062e-05f, +1.716910203e-04f, +9.620193407e-05f, -2.504671030e-05f, -5.875980060e-05f, -2.138076662e-05f, +1.080393312e-05f,
    /*  5,12 (48) */
    -2.138362868e-04f, +2.699466730e-04f, +1.033780325e-03f, +1.109862058e-03f, -3.415688898e-04f, -2.637369552e-03f, -3.364985229e-03f, -4.438376820e-04f, +4.930171787e-03f, +7.789018652e-03f, +3.319473232e-03f, -7.308289635e-03f, -1.523423081e-02f, -1.024708129e-02f, +8.419153559e-03f, +2.687537056e-02f, +2.489926454e-02f, -5.528240104e-03f, -4.629905191e-02f, -5.885505491e-02f, -1.020958642e-02f, +9.823396566e-02f, +2.227367744e-01f, +3.002210142e-01f, +2.882928326e-01f, +1.935918595e-01f, +6.730066057e-02f, -2.880458000e-02f, -6.056954650e-02f, -3.709014737e-02f, +4.234731733e-03f, +2.813779957e-02f, +2.343903002e-02f, +3.005110776e-03f, -1.299760815e-02f, -1.414367498e-02f, -4.458255175e-03f, +5.204616567e-03f, +7.634467472e-03f, +3.585997048e-03f, -1.526556951e-03f, -3.479918858e-03f, -2.098374192e-03f, +1.627790300e-04f, +1.217558456e-03f, +8.609413644e-04f, +9.965884631e-05f, -2.487527171e-04f,
    -6.145498583e-06f, -2.269995370e-05f, -1.965132830e-05f, +1.900594605e-05f, +6.704908649e-05f, +6.294204704e-05f, -2.745233794e-05f, -1.460248114e-04f, -1.615228087e-04f, +6.462811949e-06f, +2.608259660e-04f, +3.514581129e-04f, +9.208544302e-05f, -3.971431734e-04f, -6.848645985e-04f, -3.624732490e-04f, +5.108376602e-04f, +1.272464001e-03f, +1.067435203e-03f, -4.264969275e-04f, -2.549045810e-03f, -3.947435253e-03f, -3.496647051e-03f, -1.178020334e-03f, +1.797988639e-03f, +3.775585220e-03f, +3.773158943e-03f, +2.095760475e-03f, +7.717910193e-06f, -1.225309849e-03f, -1.161950407e-03f, -2.988521533e-04f, +4.921946958e-04f, +6.644111886e-04f, +2.895122690e-04f, -1.785540845e-04f, -3.585383943e-04f, -2.095275372e-04f, +4.426000660e-05f, +1.731716465e-04f, +1.240340870e-04f, +1.606225050e-06f, -7.116104395e-05f, -5.871913933e-05f, -8.045365282e-06f, +2.329050229e-05f, +1.975685940e-05f, +2.646940749e-06f,
    +5.925269711e-04f, +2.042943039e-04f, -1.433860728e-03f, -2.648384424e-03f, -5.710846208e-04f, +4.566483066e-03f, +7.056266775e-03f, +9.761373983e-04f, -1.050088778e-02f, -1.427985166e-02f, -1.072554714e-03f, +1.951713457e-02f, +2.385472420e-02f, +4.278559834e-04f, -3.082662102e-02f, -3.423217348e-02f, +1.238233598e-03f, +4.249171064e-02f, +4.312395969e-02f, -3.822871955e-03f, -5.188426180e-02f, -4.826708576e-02f, +6.770697241e-03f, +5.656640725e-02f, +4.828106469e-02f, -9.244626154e-03f, -5.522220343e-02f, -4.320945751e-02f, +1.047388868e-02f, +4.819615821e-02f, +3.448240853e-02f, -1.009986787e-02f, -3.736629075e-02f, -2.432890350e-02f, +8.329976605e-03f, +2.540882911e-02f, +1.493740356e-02f, -5.817573292e-03f, -1.481198659e-02f, -7.759529796e-03f, +3.343760572e-03f, +7.096709720e-03f, +3.233017629e-03f, -1.483291827e-03f, -2.555360104e-03f, -9.556662258e-04f, +4.271061165e-04f, +5.261637426e-04f,
    -5.992792188e-06f, +3.290054749e-05f, +5.978006238e-05f, +3.318566004e-07f, -1.272731508e-04f, -1.605272429e-04f, +3.598366537e-05f, +3.208298467e-04f, +3.206200138e-04f, -1.297125478e-04f, -6.298640435e-04f, -5.216365040e-04f, +2.998823734e-04f, +1.031586820e-03f, +7.204999172e-04f, -5.423673907e-04f, -1.458683414e-03f, -8.625468812e-04f, +8.213208904e-04f, +1.814723206e-03f, +9.031948932e-04f, -1.074863185e-03f, -2.006760386e-03f, -8.275936346e-04f, +1.235350750e-03f, +1.981165714e-03f, +6.577692475e-04f, -1.255934658e-03f, -1.745429140e-03f, -4.432331034e-04f, +1.130413656e-03f, +1.364981652e-03f, +2.400119783e-04f, -8.960166017e-04f, -9.366965344e-04f, -8.904718824e-05f, +6.175595806e-04f, +5.523519909e-04f, +4.371091988e-06f, -3.612259542e-04f, -2.693219942e-04f, +2.486760706e-05f, +1.711338991e-04f, +1.002934205e-04f, -2.228763733e-05f, -5.917292671e-05f, -2.280664602e-05f, +1.033395661e-05f,
    /*  5,13 (48) */
    -2.199817854e-04f, +2.472467193e-04f, +1.014128997e-03f, +1.128868004e-03f, -2.745198034e-04f, -2.574427505e-03f, -3.392437567e-03f, -5.898624934e-04f, +4.768648978e-03f, +7.795481463e-03f, +3.580299198e-03f, -6.956831522e-03f, -1.514214537e-02f, -1.064422447e-02f, +7.734288960e-03f, +2.651289731e-02f, +2.541010220e-02f, -4.255776103e-03f, -4.523161671e-02f, -5.928155184e-02f, -1.275863223e-02f, +9.428653040e-02f, +2.192401273e-01f, +2.990429938e-01f, +2.900908213e-01f, +1.973674447e-01f, +7.107381951e-02f, -2.670881952e-02f, -6.056182859e-02f, -3.831545722e-02f, +3.072781326e-03f, +2.783894741e-02f, +2.393122472e-02f, +3.669521965e-03f, -1.270809588e-02f, -1.432222906e-02f, -4.816793569e-03f, +4.995089030e-03f, +7.678727479e-03f, +3.759168695e-03f, -1.402522864e-03f, -3.478312633e-03f, -2.169535236e-03f, +1.040598907e-04f, +1.209513091e-03f, +8.842318667e-04f, +1.194157057e-04f, -2.461057764e-04f,
    -5.619847753e-06f, -2.233122796e-05f, -2.028645001e-05f, +1.738935163e-05f, +6.600111633e-05f, +6.439358814e-05f, -2.362871253e-05f, -1.431608535e-04f, -1.637676033e-04f, -1.129221506e-06f, +2.539196867e-04f, +3.535546868e-04f, +1.052734594e-04f, -3.822267278e-04f, -6.837821069e-04f, -3.828732458e-04f, +4.805987104e-04f, +1.259451603e-03f, +1.094049999e-03f, -3.643588626e-04f, -2.486096943e-03f, -3.928059791e-03f, -3.542451496e-03f, -1.269047195e-03f, +1.712134616e-03f, +3.741774980e-03f, +3.803445380e-03f, +2.162088097e-03f, +6.506458990e-05f, -1.206819595e-03f, -1.180386341e-03f, -3.290436934e-04f, +4.755794889e-04f, +6.691226960e-04f, +3.052656328e-04f, -1.670791099e-04f, -3.585944329e-04f, -2.172329171e-04f, +3.738809433e-05f, +1.720829637e-04f, +1.274302066e-04f, +5.151342728e-06f, -7.026280721e-05f, -6.004029793e-05f, -9.553018418e-06f, +2.288492893e-05f, +2.022427551e-05f, +3.118355367e-06f,
    +5.865341789e-04f, +2.371948514e-04f, -1.374080666e-03f, -2.648052568e-03f, -6.983577715e-04f, +4.405955823e-03f, +7.092250441e-03f, +1.296967245e-03f, -1.018026776e-02f, -1.440956421e-02f, -1.702418758e-03f, +1.899549807e-02f, +2.415460658e-02f, +1.459442803e-03f, -3.010612110e-02f, -3.477454088e-02f, -2.204498169e-04f, +4.162916376e-02f, +4.394528058e-02f, -2.008148749e-03f, -5.098106691e-02f, -4.934194895e-02f, +4.763936855e-03f, +5.573881361e-02f, +4.951641544e-02f, -7.263460440e-03f, -5.456443418e-02f, -4.446539217e-02f, +8.728459539e-03f, +4.775292511e-02f, +3.561282219e-02f, -8.734886219e-03f, -3.712627877e-02f, -2.522492010e-02f, +7.393280071e-03f, +2.531978192e-02f, +1.555496314e-02f, -5.265221301e-03f, -1.480761550e-02f, -8.120755750e-03f, +3.074438578e-03f, +7.121577327e-03f, +3.404151528e-03f, -1.382998406e-03f, -2.577647741e-03f, -1.014839153e-03f, +4.042994704e-04f, +5.364976992e-04f,
    -6.726188338e-06f, +3.146265921e-05f, +5.995415024e-05f, +3.734859764e-06f, -1.236436595e-04f, -1.627790681e-04f, +2.688242340e-05f, +3.142560394e-04f, +3.279163869e-04f, -1.114077755e-04f, -6.205714137e-04f, -5.377768232e-04f, +2.696796894e-04f, +1.021197686e-03f, +7.489100181e-04f, -4.997968082e-04f, -1.450011546e-03f, -9.047296952e-04f, +7.689688922e-04f, +1.810883461e-03f, +9.575489692e-04f, -1.018088808e-03f, -2.009934480e-03f, -8.892717136e-04f, +1.180862295e-03f, +1.991618904e-03f, +7.198106432e-04f, -1.209781226e-03f, -1.761296652e-03f, -4.985806950e-04f, +1.096254414e-03f, +1.382958902e-03f, +2.835684992e-04f, -8.743859052e-04f, -9.532950886e-04f, -1.189049414e-04f, +6.063342116e-04f, +5.651052827e-04f, +2.177681319e-05f, -3.569227371e-04f, -2.773989148e-04f, +1.662740206e-05f, +1.703431041e-04f, +1.043388822e-04f, -1.942990811e-05f, -5.950922336e-05f, -2.424101926e-05f, +9.826762982e-06f,
    /*  5,14 (48) */
    -2.256016332e-04f, +2.249154914e-04f, +9.938425466e-04f, +1.146257356e-03f, -2.085186870e-04f, -2.510033917e-03f, -3.416066279e-03f, -7.330233469e-04f, +4.604881375e-03f, +7.794352242e-03f, +3.834218885e-03f, -6.603276835e-03f, -1.503687191e-02f, -1.102645119e-02f, +7.050506854e-03f, +2.613002407e-02f, +2.589070091e-02f, -2.996324500e-03f, -4.413756671e-02f, -5.964591070e-02f, -1.524472918e-02f, +9.035847061e-02f, +2.156976758e-01f, +2.977739466e-01f, +2.918029559e-01f, +2.011092197e-01f, +7.487726489e-02f, -2.454673142e-02f, -6.049676400e-02f, -3.952227682e-02f, +1.892394985e-03f, +2.750990372e-02f, +2.440680421e-02f, +4.338644661e-03f, -1.240283025e-02f, -1.448930817e-02f, -5.175388002e-03f, +4.777856113e-03f, +7.716115573e-03f, +3.931251658e-03f, -1.275092657e-03f, -3.473161290e-03f, -2.239798043e-03f, +4.401959277e-05f, +1.199960073e-03f, +9.071167956e-04f, +1.396399812e-04f, -2.429874210e-04f,
    -5.101935035e-06f, -2.194368679e-05f, -2.088292230e-05f, +1.578716000e-05f, +6.490221258e-05f, +6.575232863e-05f, -1.984341151e-05f, -1.401967567e-04f, -1.658174043e-04f, -8.615704811e-06f, +2.468577445e-04f, +3.552842156e-04f, +1.181977641e-04f, -3.671297703e-04f, -6.820706251e-04f, -4.026676212e-04f, +4.502987406e-04f, +1.245472585e-03f, +1.119313455e-03f, -3.029347472e-04f, -2.422468327e-03f, -3.906802038e-03f, -3.586300165e-03f, -1.359339382e-03f, +1.625293037e-03f, +3.705927037e-03f, +3.831980836e-03f, +2.227969541e-03f, +1.232916022e-04f, -1.186976001e-03f, -1.197982611e-03f, -3.593109908e-04f, +4.583105953e-04f, +6.732550314e-04f, +3.209203473e-04f, -1.552980924e-04f, -3.583010170e-04f, -2.248276595e-04f, +3.038234710e-05f, +1.708045217e-04f, +1.307491686e-04f, +8.750643349e-06f, -6.927326105e-05f, -6.132137632e-05f, -1.108242036e-05f, +2.244163619e-05f, +2.067761714e-05f, +3.600030357e-06f,
    +5.798079906e-04f, +2.686575106e-04f, -1.314126515e-03f, -2.644317708e-03f, -8.220014310e-04f, +4.243176755e-03f, +7.119132864e-03f, +1.611223284e-03f, -9.852351375e-03f, -1.452097198e-02f, -2.322990171e-03f, +1.845772125e-02f, +2.442428626e-02f, +2.480640490e-03f, -2.935721108e-02f, -3.527433768e-02f, -1.670461363e-03f, +4.072443406e-02f, +4.471424948e-02f, -1.972652877e-04f, -5.002351794e-02f, -5.036003776e-02f, +2.754002374e-03f, +5.484954190e-02f, +5.069727773e-02f, -5.271841536e-03f, -5.384462353e-02f, -4.567517339e-02f, +6.967162887e-03f, +4.725434442e-02f, +3.670907660e-02f, -7.351927317e-03f, -3.684271028e-02f, -2.609930601e-02f, +6.439984982e-03f, +2.520087698e-02f, +1.616129735e-02f, -4.700116019e-03f, -1.478583868e-02f, -8.477678487e-03f, +2.797039663e-03f, +7.138204729e-03f, +3.574494632e-03f, -1.278659524e-03f, -2.597077649e-03f, -1.074348376e-03f, +3.800584512e-04f, +5.463244622e-04f,
    -7.421867367e-06f, +3.001940325e-05f, +6.003768156e-05f, +7.053467277e-06f, -1.199280247e-04f, -1.647818060e-04f, +1.790181941e-05f, +3.073990511e-04f, +3.347160378e-04f, -9.320145502e-05f, -6.106526693e-04f, -5.531202657e-04f, +2.394447676e-04f, +1.009713527e-03f, +7.762461630e-04f, -4.569316317e-04f, -1.439730266e-03f, -9.456738503e-04f, +7.159554776e-04f, +1.804997449e-03f, +1.010676813e-03f, -9.602611958e-04f, -2.010824996e-03f, -9.499216317e-04f, +1.125010260e-03f, +1.999822172e-03f, +7.811526405e-04f, -1.162126342e-03f, -1.775208914e-03f, -5.535922821e-04f, +1.060665243e-03f, +1.399449515e-03f, +3.270905203e-04f, -8.515744417e-04f, -9.689224002e-04f, -1.489086026e-04f, +5.942710605e-04f, +5.773328080e-04f, +3.938231595e-05f, -3.521206831e-04f, -2.852584363e-04f, +8.221935396e-06f, +1.693153605e-04f, +1.083317326e-04f, -1.647543552e-05f, -5.976621677e-05f, -2.568173259e-05f, +9.282107604e-06f,
    /*  5,15 (48) */
    -2.307035682e-04f, +2.029718046e-04f, +9.729596243e-04f, +1.162044516e-03f, -1.436164744e-04f, -2.444281589e-03f, -3.435909691e-03f, -8.732201035e-04f, +4.439063971e-03f, +7.785736537e-03f, +4.081076629e-03f, -6.247992620e-03f, -1.491867414e-02f, -1.139358096e-02f, +6.368436228e-03f, +2.572735645e-02f, +2.634099965e-02f, -1.750851916e-03f, -4.301825325e-02f, -5.994884545e-02f, -1.766719750e-02f, +8.645166857e-02f, +2.121113757e-01f, +2.964146073e-01f, +2.934282489e-01f, +2.048151467e-01f, +7.870924573e-02f, -2.231876188e-02f, -6.037347239e-02f, -4.070925282e-02f, +6.944123742e-04f, +2.715059273e-02f, +2.486511480e-02f, +5.011899692e-03f, -1.208190990e-02f, -1.464460626e-02f, -5.533689019e-03f, +4.553028453e-03f, +7.746497920e-03f, +4.102056180e-03f, -1.144343489e-03f, -3.464410647e-03f, -2.309071304e-03f, -1.730178355e-05f, +1.188877652e-03f, +9.295584318e-04f, +1.603175984e-04f, -2.393873907e-04f,
    -4.592312781e-06f, -2.153827296e-05f, -2.144084177e-05f, +1.420093672e-05f, +6.375451373e-05f, +6.701837009e-05f, -1.609980167e-05f, -1.371370575e-04f, -1.676728842e-04f, -1.599059122e-05f, +2.396490953e-04f, +3.566495875e-04f, +1.308491393e-04f, -3.518687715e-04f, -6.797391967e-04f, -4.218453906e-04f, +4.199657252e-04f, +1.230551377e-03f, +1.143223062e-03f, -2.422595454e-04f, -2.358206446e-03f, -3.883686002e-03f, -3.628173926e-03f, -1.448845124e-03f, +1.537513213e-03f, +3.668055015e-03f, +3.858736840e-03f, +2.293357934e-03f, +1.823673981e-04f, -1.165777375e-03f, -1.214712913e-03f, -3.896273500e-04f, +4.403962535e-04f, +6.767973395e-04f, +3.364601680e-04f, -1.432187388e-04f, -3.576540129e-04f, -2.323027288e-04f, +2.324802542e-05f, +1.693349066e-04f, +1.339863276e-04f, +1.240115436e-05f, -6.819191421e-05f, -6.256017717e-05f, -1.263220012e-05f, +2.196035072e-05f, +2.111593325e-05f, +4.091509657e-06f,
    +5.723861232e-04f, +2.986769139e-04f, -1.254088834e-03f, -2.637264241e-03f, -9.419294558e-04f, +4.078394949e-03f, +7.137034683e-03f, +1.918622335e-03f, -9.517635337e-03f, -1.461417344e-02f, -2.933642841e-03f, +1.790460098e-02f, +2.466373103e-02f, +3.490354017e-03f, -2.858096492e-02f, -3.573126931e-02f, -3.110191630e-03f, +3.977876021e-02f, +4.543020495e-02f, +1.607732162e-03f, -4.901284113e-02f, -5.132029895e-02f, +7.431773778e-04f, +5.389962027e-02f, +5.182228799e-02f, -3.272019363e-03f, -5.306347089e-02f, -4.683729973e-02f, +5.191953973e-03f, +4.670075213e-02f, +3.776974184e-02f, -5.952477802e-03f, -3.651561975e-02f, -2.695088045e-02f, +5.471062582e-03f, +2.505196838e-02f, +1.675556841e-02f, -4.122783211e-03f, -1.474645637e-02f, -8.829799170e-03f, +2.511781227e-03f, +7.146426665e-03f, +3.743809993e-03f, -1.170327791e-03f, -2.613553085e-03f, -1.134114593e-03f, +3.543767186e-04f, +5.556065698e-04f,
    -8.079745468e-06f, +2.857323814e-05f, +6.003274073e-05f, +1.028483838e-05f, -1.161330024e-04f, -1.665372915e-04f, +9.051438444e-06f, +3.002717441e-04f, +3.410172403e-04f, -7.511470104e-05f, -6.001268452e-04f, -5.676564557e-04f, +2.092139797e-04f, +9.971569364e-04f, +8.024839588e-04f, -4.138240856e-04f, -1.427860644e-03f, -9.853375695e-04f, +6.623449825e-04f, +1.797078701e-03f, +1.062519925e-03f, -9.014492054e-04f, -2.009433298e-03f, -1.009473505e-03f, +1.067858769e-03f, +2.005763443e-03f, +8.417227355e-04f, -1.113021470e-03f, -1.787143111e-03f, -6.082021965e-04f, +1.023680798e-03f, +1.414425528e-03f, +3.705263544e-04f, -8.276005109e-04f, -9.835516288e-04f, -1.790233679e-04f, +5.813761142e-04f, +5.890135245e-04f, +5.716822562e-05f, -3.468189271e-04f, -2.928871472e-04f, -3.405428706e-07f, +1.680476643e-04f, +1.122653332e-04f, -1.342631768e-05f, -5.994150050e-05f, -2.712656655e-05f, +8.699807951e-06f,
    /*  5,16 (48) */
    -2.352958810e-04f, +1.814335316e-04f, +9.515187825e-04f, +1.176245452e-03f, -7.986196071e-05f, -2.377263219e-03f, -3.452009492e-03f, -1.010357161e-03f, +4.271391087e-03f, +7.769745946e-03f, +4.320725725e-03f, -5.891343032e-03f, -1.478782500e-02f, -1.174544974e-02f, +5.688697032e-03f, +2.530551106e-02f, +2.676096538e-02f, -5.203005390e-04f, -4.187503019e-02f, -6.019110499e-02f, -2.002540395e-02f, +8.256798257e-02f, +2.084832017e-01f, +2.949657621e-01f, +2.949657621e-01f, +2.084832017e-01f, +8.256798257e-02f, -2.002540395e-02f, -6.019110499e-02f, -4.187503019e-02f, -5.203005390e-04f, +2.676096538e-02f, +2.530551106e-02f, +5.688697032e-03f, -1.174544974e-02f, -1.478782500e-02f, -5.891343032e-03f, +4.320725725e-03f, +7.769745946e-03f, +4.271391087e-03f, -1.010357161e-03f, -3.452009492e-03f, -2.377263219e-03f, -7.986196071e-05f, +1.176245452e-03f, +9.515187825e-04f, +1.814335316e-04f, -2.352958810e-04f,
    -4.091509657e-06f, -2.111593325e-05f, -2.196035072e-05f, +1.263220012e-05f, +6.256017717e-05f, +6.819191421e-05f, -1.240115436e-05f, -1.339863276e-04f, -1.693349066e-04f, -2.324802542e-05f, +2.323027288e-04f, +3.576540129e-04f, +1.432187388e-04f, -3.364601680e-04f, -6.767973395e-04f, -4.403962535e-04f, +3.896273500e-04f, +1.214712913e-03f, +1.165777375e-03f, -1.823673981e-04f, -2.293357934e-03f, -3.858736840e-03f, -3.668055015e-03f, -1.537513213e-03f, +1.448845124e-03f, +3.628173926e-03f, +3.883686002e-03f, +2.358206446e-03f, +2.422595454e-04f, -1.143223062e-03f, -1.230551377e-03f, -4.199657252e-04f, +4.218453906e-04f, +6.797391967e-04f, +3.518687715e-04f, -1.308491393e-04f, -3.566495875e-04f, -2.396490953e-04f, +1.599059122e-05f, +1.676728842e-04f, +1.371370575e-04f, +1.609980167e-05f, -6.701837009e-05f, -6.375451373e-05f, -1.420093672e-05f, +2.144084177e-05f, +2.153827296e-05f, +4.592312781e-06f,
    +5.643063777e-04f, +3.272501520e-04f, -1.194056093e-03f, -2.626979402e-03f, -1.058062458e-03f, +3.911857657e-03f, +7.146086122e-03f, +2.218894080e-03f, -9.176618097e-03f, -1.468928814e-02f, -3.533769686e-03f, +1.733694452e-02f, +2.487294501e-02f, +4.487510953e-03f, -2.777848096e-02f, -3.614509340e-02f, -4.538052273e-03f, +3.879342264e-02f, +4.609254994e-02f, +3.404810862e-03f, -4.795032120e-02f, -5.222174816e-02f, -1.266255920e-03f, +5.289014676e-02f, +5.289014676e-02f, -1.266255920e-03f, -5.222174816e-02f, -4.795032120e-02f, +3.404810862e-03f, +4.609254994e-02f, +3.879342264e-02f, -4.538052273e-03f, -3.614509340e-02f, -2.777848096e-02f, +4.487510953e-03f, +2.487294501e-02f, +1.733694452e-02f, -3.533769686e-03f, -1.468928814e-02f, -9.176618097e-03f, +2.218894080e-03f, +7.146086122e-03f, +3.911857657e-03f, -1.058062458e-03f, -2.626979402e-03f, -1.194056093e-03f, +3.272501520e-04f, +5.643063777e-04f,
    -8.699807951e-06f, +2.712656655e-05f, +5.994150050e-05f, +1.342631768e-05f, -1.122653332e-04f, -1.680476643e-04f, +3.405428706e-07f, +2.928871472e-04f, +3.468189271e-04f, -5.716822562e-05f, -5.890135245e-04f, -5.813761142e-04f, +1.790233679e-04f, +9.835516288e-04f, +8.276005109e-04f, -3.705263544e-04f, -1.414425528e-03f, -1.023680798e-03f, +6.082021965e-04f, +1.787143111e-03f, +1.113021470e-03f, -8.417227355e-04f, -2.005763443e-03f, -1.067858769e-03f, +1.009473505e-03f, +2.009433298e-03f, +9.014492054e-04f, -1.062519925e-03f, -1.797078701e-03f, -6.623449825e-04f, +9.853375695e-04f, +1.427860644e-03f, +4.138240856e-04f, -8.024839588e-04f, -9.971569364e-04f, -2.092139797e-04f, +5.676564557e-04f, +6.001268452e-04f, +7.511470104e-05f, -3.410172403e-04f, -3.002717441e-04f, -9.051438444e-06f, +1.665372915e-04f, +1.161330024e-04f, -1.028483838e-05f, -6.003274073e-05f, -2.857323814e-05f, +8.079745468e-06f,
    /*  5,17 (48) */
    -2.393873907e-04f, +1.603175984e-04f, +9.295584318e-04f, +1.188877652e-03f, -1.730178355e-05f, -2.309071304e-03f, -3.464410647e-03f, -1.144343489e-03f, +4.102056180e-03f, +7.746497920e-03f, +4.553028453e-03f, -5.533689019e-03f, -1.464460626e-02f, -1.208190990e-02f, +5.011899692e-03f, +2.486511480e-02f, +2.715059273e-02f, +6.944123742e-04f, -4.070925282e-02f, -6.037347239e-02f, -2.231876188e-02f, +7.870924573e-02f, +2.048151467e-01f, +2.934282489e-01f, +2.964146073e-01f, +2.121113757e-01f, +8.645166857e-02f, -1.766719750e-02f, -5.994884545e-02f, -4.301825325e-02f, -1.750851916e-03f, +2.634099965e-02f, +2.572735645e-02f, +6.368436228e-03f, -1.139358096e-02f, -1.491867414e-02f, -6.247992620e-03f, +4.081076629e-03f, +7.785736537e-03f, +4.439063971e-03f, -8.732201035e-04f, -3.435909691e-03f, -2.444281589e-03f, -1.436164744e-04f, +1.162044516e-03f, +9.729596243e-04f, +2.029718046e-04f, -2.307035682e-04f,
    -3.600030357e-06f, -2.067761714e-05f, -2.244163619e-05f, +1.108242036e-05f, +6.132137632e-05f, +6.927326105e-05f, -8.750643349e-06f, -1.307491686e-04f, -1.708045217e-04f, -3.038234710e-05f, +2.248276595e-04f, +3.583010170e-04f, +1.552980924e-04f, -3.209203473e-04f, -6.732550314e-04f, -4.583105953e-04f, +3.593109908e-04f, +1.197982611e-03f, +1.186976001e-03f, -1.232916022e-04f, -2.227969541e-03f, -3.831980836e-03f, -3.705927037e-03f, -1.625293037e-03f, +1.359339382e-03f, +3.586300165e-03f, +3.906802038e-03f, +2.422468327e-03f, +3.029347472e-04f, -1.119313455e-03f, -1.245472585e-03f, -4.502987406e-04f, +4.026676212e-04f, +6.820706251e-04f, +3.671297703e-04f, -1.181977641e-04f, -3.552842156e-04f, -2.468577445e-04f, +8.615704811e-06f, +1.658174043e-04f, +1.401967567e-04f, +1.984341151e-05f, -6.575232863e-05f, -6.490221258e-05f, -1.578716000e-05f, +2.088292230e-05f, +2.194368679e-05f, +5.101935035e-06f,
    +5.556065698e-04f, +3.543767186e-04f, -1.134114593e-03f, -2.613553085e-03f, -1.170327791e-03f, +3.743809993e-03f, +7.146426665e-03f, +2.511781227e-03f, -8.829799170e-03f, -1.474645637e-02f, -4.122783211e-03f, +1.675556841e-02f, +2.505196838e-02f, +5.471062582e-03f, -2.695088045e-02f, -3.651561975e-02f, -5.952477802e-03f, +3.776974184e-02f, +4.670075213e-02f, +5.191953973e-03f, -4.683729973e-02f, -5.306347089e-02f, -3.272019363e-03f, +5.182228799e-02f, +5.389962027e-02f, +7.431773778e-04f, -5.132029895e-02f, -4.901284113e-02f, +1.607732162e-03f, +4.543020495e-02f, +3.977876021e-02f, -3.110191630e-03f, -3.573126931e-02f, -2.858096492e-02f, +3.490354017e-03f, +2.466373103e-02f, +1.790460098e-02f, -2.933642841e-03f, -1.461417344e-02f, -9.517635337e-03f, +1.918622335e-03f, +7.137034683e-03f, +4.078394949e-03f, -9.419294558e-04f, -2.637264241e-03f, -1.254088834e-03f, +2.986769139e-04f, +5.723861232e-04f,
    -9.282107604e-06f, +2.568173259e-05f, +5.976621677e-05f, +1.647543552e-05f, -1.083317326e-04f, -1.693153605e-04f, -8.221935396e-06f, +2.852584363e-04f, +3.521206831e-04f, -3.938231595e-05f, -5.773328080e-04f, -5.942710605e-04f, +1.489086026e-04f, +9.689224002e-04f, +8.515744417e-04f, -3.270905203e-04f, -1.399449515e-03f, -1.060665243e-03f, +5.535922821e-04f, +1.775208914e-03f, +1.162126342e-03f, -7.811526405e-04f, -1.999822172e-03f, -1.125010260e-03f, +9.499216317e-04f, +2.010824996e-03f, +9.602611958e-04f, -1.010676813e-03f, -1.804997449e-03f, -7.159554776e-04f, +9.456738503e-04f, +1.439730266e-03f, +4.569316317e-04f, -7.762461630e-04f, -1.009713527e-03f, -2.394447676e-04f, +5.531202657e-04f, +6.106526693e-04f, +9.320145502e-05f, -3.347160378e-04f, -3.073990511e-04f, -1.790181941e-05f, +1.647818060e-04f, +1.199280247e-04f, -7.053467277e-06f, -6.003768156e-05f, -3.001940325e-05f, +7.421867367e-06f,
    /*  5,18 (48) */
    -2.429874210e-04f, +1.396399812e-04f, +9.071167956e-04f, +1.199960073e-03f, +4.401959277e-05f, -2.239798043e-03f, -3.473161290e-03f, -1.275092657e-03f, +3.931251658e-03f, +7.716115573e-03f, +4.777856113e-03f, -5.175388002e-03f, -1.448930817e-02f, -1.240283025e-02f, +4.338644661e-03f, +2.440680421e-02f, +2.750990372e-02f, +1.892394985e-03f, -3.952227682e-02f, -6.049676400e-02f, -2.454673142e-02f, +7.487726489e-02f, +2.011092197e-01f, +2.918029559e-01f, +2.977739466e-01f, +2.156976758e-01f, +9.035847061e-02f, -1.524472918e-02f, -5.964591070e-02f, -4.413756671e-02f, -2.996324500e-03f, +2.589070091e-02f, +2.613002407e-02f, +7.050506854e-03f, -1.102645119e-02f, -1.503687191e-02f, -6.603276835e-03f, +3.834218885e-03f, +7.794352242e-03f, +4.604881375e-03f, -7.330233469e-04f, -3.416066279e-03f, -2.510033917e-03f, -2.085186870e-04f, +1.146257356e-03f, +9.938425466e-04f, +2.249154914e-04f, -2.256016332e-04f,
    -3.118355367e-06f, -2.022427551e-05f, -2.288492893e-05f, +9.553018418e-06f, +6.004029793e-05f, +7.026280721e-05f, -5.151342728e-06f, -1.274302066e-04f, -1.720829637e-04f, -3.738809433e-05f, +2.172329171e-04f, +3.585944329e-04f, +1.670791099e-04f, -3.052656328e-04f, -6.691226960e-04f, -4.755794889e-04f, +3.290436934e-04f, +1.180386341e-03f, +1.206819595e-03f, -6.506458990e-05f, -2.162088097e-03f, -3.803445380e-03f, -3.741774980e-03f, -1.712134616e-03f, +1.269047195e-03f, +3.542451496e-03f, +3.928059791e-03f, +2.486096943e-03f, +3.643588626e-04f, -1.094049999e-03f, -1.259451603e-03f, -4.805987104e-04f, +3.828732458e-04f, +6.837821069e-04f, +3.822267278e-04f, -1.052734594e-04f, -3.535546868e-04f, -2.539196867e-04f, +1.129221506e-06f, +1.637676033e-04f, +1.431608535e-04f, +2.362871253e-05f, -6.439358814e-05f, -6.600111633e-05f, -1.738935163e-05f, +2.028645001e-05f, +2.233122796e-05f, +5.619847753e-06f,
    +5.463244622e-04f, +3.800584512e-04f, -1.074348376e-03f, -2.597077649e-03f, -1.278659524e-03f, +3.574494632e-03f, +7.138204729e-03f, +2.797039663e-03f, -8.477678487e-03f, -1.478583868e-02f, -4.700116019e-03f, +1.616129735e-02f, +2.520087698e-02f, +6.439984982e-03f, -2.609930601e-02f, -3.684271028e-02f, -7.351927317e-03f, +3.670907660e-02f, +4.725434442e-02f, +6.967162887e-03f, -4.567517339e-02f, -5.384462353e-02f, -5.271841536e-03f, +5.069727773e-02f, +5.484954190e-02f, +2.754002374e-03f, -5.036003776e-02f, -5.002351794e-02f, -1.972652877e-04f, +4.471424948e-02f, +4.072443406e-02f, -1.670461363e-03f, -3.527433768e-02f, -2.935721108e-02f, +2.480640490e-03f, +2.442428626e-02f, +1.845772125e-02f, -2.322990171e-03f, -1.452097198e-02f, -9.852351375e-03f, +1.611223284e-03f, +7.119132864e-03f, +4.243176755e-03f, -8.220014310e-04f, -2.644317708e-03f, -1.314126515e-03f, +2.686575106e-04f, +5.798079906e-04f,
    -9.826762982e-06f, +2.424101926e-05f, +5.950922336e-05f, +1.942990811e-05f, -1.043388822e-04f, -1.703431041e-04f, -1.662740206e-05f, +2.773989148e-04f, +3.569227371e-04f, -2.177681319e-05f, -5.651052827e-04f, -6.063342116e-04f, +1.189049414e-04f, +9.532950886e-04f, +8.743859052e-04f, -2.835684992e-04f, -1.382958902e-03f, -1.096254414e-03f, +4.985806950e-04f, +1.761296652e-03f, +1.209781226e-03f, -7.198106432e-04f, -1.991618904e-03f, -1.180862295e-03f, +8.892717136e-04f, +2.009934480e-03f, +1.018088808e-03f, -9.575489692e-04f, -1.810883461e-03f, -7.689688922e-04f, +9.047296952e-04f, +1.450011546e-03f, +4.997968082e-04f, -7.489100181e-04f, -1.021197686e-03f, -2.696796894e-04f, +5.377768232e-04f, +6.205714137e-04f, +1.114077755e-04f, -3.279163869e-04f, -3.142560394e-04f, -2.688242340e-05f, +1.627790681e-04f, +1.236436595e-04f, -3.734859764e-06f, -5.995415024e-05f, -3.146265921e-05f, +6.726188338e-06f,
    /*  5,19 (48) */
    -2.461057764e-04f, +1.194157057e-04f, +8.842318667e-04f, +1.209513091e-03f, +1.040598907e-04f, -2.169535236e-03f, -3.478312633e-03f, -1.402522864e-03f, +3.759168695e-03f, +7.678727479e-03f, +4.995089030e-03f, -4.816793569e-03f, -1.432222906e-02f, -1.270809588e-02f, +3.669521965e-03f, +2.393122472e-02f, +2.783894741e-02f, +3.072781326e-03f, -3.831545722e-02f, -6.056182859e-02f, -2.670881952e-02f, +7.107381951e-02f, +1.973674447e-01f, +2.900908213e-01f, +2.990429938e-01f, +2.192401273e-01f, +9.428653040e-02f, -1.275863223e-02f, -5.928155184e-02f, -4.523161671e-02f, -4.255776103e-03f, +2.541010220e-02f, +2.651289731e-02f, +7.734288960e-03f, -1.064422447e-02f, -1.514214537e-02f, -6.956831522e-03f, +3.580299198e-03f, +7.795481463e-03f, +4.768648978e-03f, -5.898624934e-04f, -3.392437567e-03f, -2.574427505e-03f, -2.745198034e-04f, +1.128868004e-03f, +1.014128997e-03f, +2.472467193e-04f, -2.199817854e-04f,
    -2.646940749e-06f, -1.975685940e-05f, -2.329050229e-05f, +8.045365282e-06f, +5.871913933e-05f, +7.116104395e-05f, -1.606225050e-06f, -1.240340870e-04f, -1.731716465e-04f, -4.426000660e-05f, +2.095275372e-04f, +3.585383943e-04f, +1.785540845e-04f, -2.895122690e-04f, -6.644111886e-04f, -4.921946958e-04f, +2.988521533e-04f, +1.161950407e-03f, +1.225309849e-03f, -7.717910193e-06f, -2.095760475e-03f, -3.773158943e-03f, -3.775585220e-03f, -1.797988639e-03f, +1.178020334e-03f, +3.496647051e-03f, +3.947435253e-03f, +2.549045810e-03f, +4.264969275e-04f, -1.067435203e-03f, -1.272464001e-03f, -5.108376602e-04f, +3.624732490e-04f, +6.848645985e-04f, +3.971431734e-04f, -9.208544302e-05f, -3.514581129e-04f, -2.608259660e-04f, -6.462811949e-06f, +1.615228087e-04f, +1.460248114e-04f, +2.745233794e-05f, -6.294204704e-05f, -6.704908649e-05f, -1.900594605e-05f, +1.965132830e-05f, +2.269995370e-05f, +6.145498583e-06f,
    +5.364976992e-04f, +4.042994704e-04f, -1.014839153e-03f, -2.577647741e-03f, -1.382998406e-03f, +3.404151528e-03f, +7.121577327e-03f, +3.074438578e-03f, -8.120755750e-03f, -1.480761550e-02f, -5.265221301e-03f, +1.555496314e-02f, +2.531978192e-02f, +7.393280071e-03f, -2.522492010e-02f, -3.712627877e-02f, -8.734886219e-03f, +3.561282219e-02f, +4.775292511e-02f, +8.728459539e-03f, -4.446539217e-02f, -5.456443418e-02f, -7.263460440e-03f, +4.951641544e-02f, +5.573881361e-02f, +4.763936855e-03f, -4.934194895e-02f, -5.098106691e-02f, -2.008148749e-03f, +4.394528058e-02f, +4.162916376e-02f, -2.204498169e-04f, -3.477454088e-02f, -3.010612110e-02f, +1.459442803e-03f, +2.415460658e-02f, +1.899549807e-02f, -1.702418758e-03f, -1.440956421e-02f, -1.018026776e-02f, +1.296967245e-03f, +7.092250441e-03f, +4.405955823e-03f, -6.983577715e-04f, -2.648052568e-03f, -1.374080666e-03f, +2.371948514e-04f, +5.865341789e-04f,
    -1.033395661e-05f, +2.280664602e-05f, +5.917292671e-05f, +2.228763733e-05f, -1.002934205e-04f, -1.711338991e-04f, -2.486760706e-05f, +2.693219942e-04f, +3.612259542e-04f, -4.371091988e-06f, -5.523519909e-04f, -6.175595806e-04f, +8.904718824e-05f, +9.366965344e-04f, +8.960166017e-04f, -2.400119783e-04f, -1.364981652e-03f, -1.130413656e-03f, +4.432331034e-04f, +1.745429140e-03f, +1.255934658e-03f, -6.577692475e-04f, -1.981165714e-03f, -1.235350750e-03f, +8.275936346e-04f, +2.006760386e-03f, +1.074863185e-03f, -9.031948932e-04f, -1.814723206e-03f, -8.213208904e-04f, +8.625468812e-04f, +1.458683414e-03f, +5.423673907e-04f, -7.204999172e-04f, -1.031586820e-03f, -2.998823734e-04f, +5.216365040e-04f, +6.298640435e-04f, +1.297125478e-04f, -3.206200138e-04f, -3.208298467e-04f, -3.598366537e-05f, +1.605272429e-04f, +1.272731508e-04f, -3.318566004e-07f, -5.978006238e-05f, -3.290054749e-05f, +5.992792188e-06f,
    /*  5,20 (48) */
    -2.487527171e-04f, +9.965884631e-05f, +8.609413644e-04f, +1.217558456e-03f, +1.627790300e-04f, -2.098374192e-03f, -3.479918858e-03f, -1.526556951e-03f, +3.585997048e-03f, +7.634467472e-03f, +5.204616567e-03f, -4.458255175e-03f, -1.414367498e-02f, -1.299760815e-02f, +3.005110776e-03f, +2.343903002e-02f, +2.813779957e-02f, +4.234731733e-03f, -3.709014737e-02f, -6.056954650e-02f, -2.880458000e-02f, +6.730066057e-02f, +1.935918595e-01f, +2.882928326e-01f, +3.002210142e-01f, +2.227367744e-01f, +9.823396566e-02f, -1.020958642e-02f, -5.885505491e-02f, -4.629905191e-02f, -5.528240104e-03f, +2.489926454e-02f, +2.687537056e-02f, +8.419153559e-03f, -1.024708129e-02f, -1.523423081e-02f, -7.308289635e-03f, +3.319473232e-03f, +7.789018652e-03f, +4.930171787e-03f, -4.438376820e-04f, -3.364985229e-03f, -2.637369552e-03f, -3.415688898e-04f, +1.109862058e-03f, +1.033780325e-03f, +2.699466730e-04f, -2.138362868e-04f,
    -2.186217979e-06f, -1.927631872e-05f, -2.365867119e-05f, +6.560781128e-06f, +5.736010574e-05f, +7.196855515e-05f, +1.881840462e-06f, -1.205654696e-04f, -1.740721600e-04f, -5.099302774e-05f, +2.017205521e-04f, +3.581373279e-04f, +1.897156964e-04f, -2.736764066e-04f, -6.591317812e-04f, -5.081486657e-04f, +2.687626964e-04f, +1.142701516e-03f, +1.242449486e-03f, +4.871779011e-05f, -2.029033559e-03f, -3.741151049e-03f, -3.807345528e-03f, -1.882806499e-03f, +1.086311093e-03f, +3.448907308e-03f, +3.964905593e-03f, +2.611268631e-03f, +4.893131757e-04f, -1.039472643e-03f, -1.284485883e-03f, -5.409873483e-04f, +3.414792965e-04f, +6.853095436e-04f, +4.118626183e-04f, -7.864329961e-05f, -3.489919343e-04f, -2.675676699e-04f, -1.415416122e-05f, +1.590825413e-04f, +1.487841346e-04f, +3.131082784e-05f, -6.139770552e-05f, -6.804400617e-05f, -2.063533162e-05f, +1.897750724e-05f, +2.304892660e-05f, +6.678311802e-06f,
    +5.261637426e-04f, +4.271061165e-04f, -9.556662258e-04f, -2.555360104e-03f, -1.483291827e-03f, +3.233017629e-03f, +7.096709720e-03f, +3.343760572e-03f, -7.759529796e-03f, -1.481198659e-02f, -5.817573292e-03f, +1.493740356e-02f, +2.540882911e-02f, +8.329976605e-03f, -2.432890350e-02f, -3.736629075e-02f, -1.009986787e-02f, +3.448240853e-02f, +4.819615821e-02f, +1.047388868e-02f, -4.320945751e-02f, -5.522220343e-02f, -9.244626154e-03f, +4.828106469e-02f, +5.656640725e-02f, +6.770697241e-03f, -4.826708576e-02f, -5.188426180e-02f, -3.822871955e-03f, +4.312395969e-02f, +4.249171064e-02f, +1.238233598e-03f, -3.423217348e-02f, -3.082662102e-02f, +4.278559834e-04f, +2.385472420e-02f, +1.951713457e-02f, -1.072554714e-03f, -1.427985166e-02f, -1.050088778e-02f, +9.761373983e-04f, +7.056266775e-03f, +4.566483066e-03f, -5.710846208e-04f, -2.648384424e-03f, -1.433860728e-03f, +2.042943039e-04f, +5.925269711e-04f,
    -1.080393312e-05f, +2.138076662e-05f, +5.875980060e-05f, +2.504671030e-05f, -9.620193407e-05f, -1.716910203e-04f, -3.293465062e-05f, +2.610411744e-04f, +3.650318258e-04f, +1.281595904e-05f, -5.390943982e-04f, -6.279422738e-04f, +5.936965397e-05f, +9.191545389e-04f, +9.164497890e-04f, -1.964723545e-04f, -1.345547346e-03f, -1.163110185e-03f, +3.876153077e-04f, +1.727631438e-03f, +1.300537084e-03f, -5.951016491e-04f, -1.968477322e-03f, -1.288413138e-03f, +7.649585135e-04f, +2.001304046e-03f, +1.130516597e-03f, -8.476746833e-04f, -1.816505538e-03f, -8.729476697e-04f, +8.191688640e-04f, +1.465726618e-03f, +5.845911801e-04f, -6.910417326e-04f, -1.040859489e-03f, -3.300161610e-04f, +5.047107781e-04f, +6.385121023e-04f, +1.480942770e-04f, -3.128293097e-04f, -3.271077973e-04f, -4.519564591e-05f, +1.580248070e-04f, +1.308097366e-04f, +3.152516786e-06f, -5.951342718e-05f, -3.433055652e-05f, +5.221833379e-06f,
    /*  5,21 (48) */
    -2.509389351e-04f, +8.038252759e-05f, +8.372826932e-04f, +1.224119238e-03f, +2.201391358e-04f, -2.026405637e-03f, -3.478037017e-03f, -1.647122420e-03f, +3.411924888e-03f, +7.583474445e-03f, +5.406337119e-03f, -4.100117847e-03f, -1.395395928e-02f, -1.327128456e-02f, +2.345978995e-03f, +2.293088136e-02f, +2.840656226e-02f, +5.377433249e-03f, -3.584769789e-02f, -6.052082871e-02f, -3.083361355e-02f, +6.355950952e-02f, +1.897845140e-01f, +2.864100261e-01f, +3.013073253e-01f, +2.261856817e-01f, +1.021988712e-01f, -7.598317793e-03f, -5.836574174e-02f, -4.733852455e-02f, -6.812725987e-03f, +2.435827719e-02f, +2.721684986e-02f, +9.104463103e-03f, -9.835218674e-03f, -1.531287411e-02f, -7.657281569e-03f, +3.051905562e-03f, +7.774864490e-03f, +5.089254328e-03f, -2.950535474e-04f, -3.333674401e-03f, -2.698767258e-03f, -4.096128960e-04f, +1.089226726e-03f, +1.052757832e-03f, +2.929955996e-04f, -2.071579750e-04f,
    -1.736593812e-06f, -1.878360102e-05f, -2.398979095e-05f, +5.100534608e-06f, +5.596540759e-05f, +7.268601529e-05f, +5.310089543e-06f, -1.170290228e-04f, -1.747862663e-04f, -5.758230847e-05f, +1.938209822e-04f, +3.573959454e-04f, +2.005570148e-04f, -2.577740890e-04f, -6.532961475e-04f, -5.234345368e-04f, +2.388012594e-04f, +1.122666753e-03f, +1.258242246e-03f, +1.042127838e-04f, -1.961954204e-03f, -3.707452254e-03f, -3.837045076e-03f, -1.966540324e-03f, +9.939722517e-04f, +3.399254090e-03f, +3.980449169e-03f, +2.672719330e-03f, +5.527710620e-04f, -1.010166969e-03f, -1.295493904e-03f, -5.710192872e-04f, +3.199037319e-04f, +6.851088870e-04f, +4.263685705e-04f, -6.495697539e-05f, -3.461539264e-04f, -2.741359392e-04f, -2.193840843e-05f, +1.564465189e-04f, +1.514343731e-04f, +3.520063170e-05f, -5.976066708e-05f, -6.898378297e-05f, -2.227585175e-05f, +1.826498444e-05f, +2.337721593e-05f, +7.217688677e-06f,
    +5.153598095e-04f, +4.484868831e-04f, -8.969064252e-04f, -2.530313393e-03f, -1.579493761e-03f, +3.061326609e-03f, +7.063775070e-03f, +3.604801746e-03f, -7.394497970e-03f, -1.479917063e-02f, -6.356667690e-03f, +1.430946128e-02f, +2.546819877e-02f, +9.249131144e-03f, -2.341245371e-02f, -3.756276311e-02f, -1.144541522e-02f, +3.331929834e-02f, +4.858377352e-02f, +1.220152012e-02f, -4.190892042e-02f, -5.581730507e-02f, -1.121310348e-02f, +4.699265155e-02f, +5.733136576e-02f, +8.772001286e-03f, -4.713656917e-02f, -5.273193649e-02f, -5.639377493e-03f, +4.225101202e-02f, +4.331087950e-02f, +2.703960216e-03f, -3.364758230e-02f, -3.151766275e-02f, -6.130035059e-04f, +2.352470804e-02f, +2.002184535e-02f, -4.340426119e-04f, -1.413175738e-02f, -1.081371709e-02f, +6.490296010e-04f, +7.011071129e-03f, +4.724507873e-03f, -4.402748842e-04f, -2.645231908e-03f, -1.493374155e-03f, +1.699637474e-04f, +5.977488045e-04f,
    -1.123699732e-05f, +1.996546693e-05f, +5.827238086e-05f, +2.770539860e-05f, -9.207094896e-05f, -1.720180044e-04f, -4.082098868e-05f, +2.525700247e-04f, +3.683424601e-04f, +2.976595604e-05f, -5.253543618e-04f, -6.374784862e-04f, +2.990611803e-05f, +9.006978220e-04f, +9.356702918e-04f, -1.530006729e-04f, -1.324687140e-03f, -1.194313118e-03f, +3.317931603e-04f, +1.707930808e-03f, +1.343540912e-03f, -5.318816467e-04f, -1.953571069e-03f, -1.339988683e-03f, +7.014386192e-04f, +1.993569491e-03f, +1.184982522e-03f, -7.910499668e-04f, -1.816221724e-03f, -9.237860406e-04f, +7.746407335e-04f, +1.471123755e-03f, +6.264160665e-04f, -6.605627939e-04f, -1.048995450e-03f, -3.600441509e-04f, +4.870122059e-04f, +6.464977422e-04f, +1.665311122e-04f, -3.045473361e-04f, -3.330774214e-04f, -5.450816010e-05f, +1.552705567e-04f, +1.342466589e-04f, +6.715051279e-06f, -5.915235252e-05f, -3.575012473e-05f, +4.413538483e-06f,
    /*  5,22 (48) */
    -2.526755289e-04f, +6.159892657e-05f, +8.132929023e-04f, +1.229219772e-03f, +2.761045433e-04f, -1.953719622e-03f, -3.472726928e-03f, -1.764151443e-03f, +3.237138622e-03f, +7.525892136e-03f, +5.600158101e-03f, -3.742721902e-03f, -1.375340227e-02f, -1.352905865e-02f, +1.692682847e-03f, +2.240744682e-02f, +2.864536352e-02f, +6.500100002e-03f, -3.458945564e-02f, -6.041661592e-02f, -3.279556776e-02f, +5.985205727e-02f, +1.859474689e-01f, +2.844434858e-01f, +3.023012975e-01f, +2.295849358e-01f, +1.061793204e-01f, -4.925598463e-03f, -5.781297067e-02f, -4.834869152e-02f, -8.108219891e-03f, +2.378725791e-02f, +2.753675359e-02f, +9.789571990e-03f, -9.408850104e-03f, -1.537783108e-02f, -8.003435496e-03f, +2.777769623e-03f, +7.752926082e-03f, +5.245700847e-03f, -1.436191744e-04f, -3.298473769e-03f, -2.758527925e-03f, -4.785966790e-04f, +1.066950874e-03f, +1.071022817e-03f, +3.163728156e-04f, -1.999402864e-04f,
    -1.298450182e-06f, -1.827965033e-05f, -2.428425610e-05f, +3.665842204e-06f, +5.453725787e-05f, +7.331418729e-05f, +8.675864377e-06f, -1.134294190e-04f, -1.753158955e-04f, -6.402320883e-05f, +1.858378263e-04f, +3.563192359e-04f, +2.110715010e-04f, -2.418212370e-04f, -6.469163482e-04f, -5.380461344e-04f, +2.089933721e-04f, +1.101873560e-03f, +1.272692875e-03f, +1.587382800e-04f, -1.894569207e-03f, -3.672094116e-03f, -3.864674442e-03f, -2.049143015e-03f, +9.010570422e-04f, +3.347710544e-03f, +3.994045556e-03f, +2.733352090e-03f, +6.168332849e-04f, -9.795239089e-04f, -1.305465301e-03f, -6.009047662e-04f, +2.977595724e-04f, +6.842550870e-04f, +4.406445511e-04f, -5.103677261e-05f, -3.429422056e-04f, -2.805219773e-04f, -2.980895653e-05f, +1.536146589e-04f, +1.539711284e-04f, +3.911811091e-05f, -5.803114002e-05f, -6.986635178e-05f, -2.392580611e-05f, +1.751380594e-05f, +2.368389901e-05f, +7.763007857e-06f,
    +5.041228121e-04f, +4.684523500e-04f, -8.386340443e-04f, -2.502607995e-03f, -1.671564710e-03f, +2.889308604e-03f, +7.022954081e-03f, +3.857371771e-03f, -7.026155510e-03f, -1.476940467e-02f, -6.882022052e-03f, +1.367198280e-02f, +2.549810488e-02f, +1.014982897e-02f, -2.247678342e-02f, -3.771576378e-02f, -1.277010236e-02f, +3.212498523e-02f, +4.891556668e-02f, +1.390945093e-02f, -4.056537951e-02f, -5.634918672e-02f, -1.316667454e-02f, +4.565266287e-02f, +5.803280438e-02f, +1.076557078e-02f, -4.595158665e-02f, -5.352298645e-02f, -7.455599217e-03f, +4.132722598e-02f, +4.408552023e-02f, +4.175083971e-03f, -3.302116624e-02f, -3.217822554e-02f, -1.661998956e-03f, +2.316466389e-02f, +2.050885756e-02f, +2.124551303e-04f, -1.396522627e-02f, -1.111826442e-02f, +3.159521796e-04f, +6.956562969e-03f, +4.879778429e-03f, -3.060282253e-04f, -2.638516856e-03f, -1.552526508e-03f, +1.342136227e-04f, +6.021623429e-04f,
    -1.163351217e-05f, +1.856276310e-05f, +5.771326009e-05f, +3.026215731e-05f, -8.790692255e-05f, -1.721186407e-04f, -4.851943780e-05f, +2.439221649e-04f, +3.711605712e-04f, +4.646103780e-05f, -5.111540984e-04f, -6.461654956e-04f, +6.897906872e-07f, +8.813559796e-04f, +9.536645096e-04f, -1.096475668e-04f, -1.302433720e-03f, -1.223993503e-03f, +2.758324854e-04f, +1.686356674e-03f, +1.384900566e-03f, -4.681835516e-04f, -1.936466895e-03f, -1.390018391e-03f, +6.371072837e-04f, +1.983563450e-03f, +1.238195732e-03f, -7.333838297e-04f, -1.813865457e-03f, -9.737735056e-04f, +7.290091656e-04f, +1.474859304e-03f, +6.677900939e-04f, -6.290918642e-04f, -1.055975683e-03f, -3.899292429e-04f, +4.685544326e-04f, +6.538037531e-04f, +1.850008703e-04f, -2.957778293e-04f, -3.387264748e-04f, -6.391070698e-05f, +1.522636143e-04f, +1.375771734e-04f, +1.035235536e-05f, -5.869505005e-05f, -3.715664369e-05f, +3.568207542e-06f,
    /*  5,23 (48) */
    -2.539739791e-04f, +4.331927624e-05f, +7.890086462e-04f, +1.232885614e-03f, +3.306418012e-04f, -1.880405434e-03f, -3.464051064e-03f, -1.877580862e-03f, +3.061822726e-03f, +7.461868927e-03f, +5.785995928e-03f, -3.386402666e-03f, -1.354233076e-02f, -1.377087989e-02f, +1.045766499e-03f, +2.186940069e-02f, +2.885435689e-02f, +7.601973562e-03f, -3.331676276e-02f, -6.025787764e-02f, -3.469013697e-02f, +5.617996315e-02f, +1.820827945e-01f, +2.823943428e-01f, +3.032023546e-01f, +2.329326463e-01f, +1.101733660e-01f, -2.192246374e-03f, -5.719613739e-02f, -4.932821543e-02f, -9.413685192e-03f, +2.318635314e-02f, +2.783451316e-02f, +1.047382708e-02f, -8.968205553e-03f, -1.542886786e-02f, -8.346377701e-03f, +2.497247646e-03f, +7.723117125e-03f, +5.399315506e-03f, +1.035195406e-05f, -3.259355658e-03f, -2.816559065e-03f, -5.484630308e-04f, +1.043025068e-03f, +1.088536623e-03f, +3.400567146e-04f, -1.921772785e-04f,
    -8.721441469e-07f, -1.776540592e-05f, -2.454249926e-05f, +2.257867657e-06f, +5.307786957e-05f, +7.385392033e-05f, +1.197661495e-05f, -1.097713294e-04f, -1.756631414e-04f, -7.031130021e-05f, +1.777800534e-04f, +3.549124572e-04f, +2.212530097e-04f, -2.258336362e-04f, -6.400048148e-04f, -5.519779693e-04f, +1.793641383e-04f, +1.080349702e-03f, +1.285807117e-03f, +2.122664403e-04f, -1.826925267e-03f, -3.635109170e-03f, -3.890225612e-03f, -2.130568273e-03f, +8.076191064e-04f, +3.294301130e-03f, +4.005675560e-03f, +2.793121386e-03f, +6.814618109e-04f, -9.475502706e-04f, -1.314377916e-03f, -6.306148736e-04f, +2.750605043e-04f, +6.827411283e-04f, +4.546741100e-04f, -3.689334343e-05f, -3.393552354e-04f, -2.867170601e-04f, -3.775903377e-05f, +1.505870813e-04f, +1.563900589e-04f, +4.305954150e-05f, -5.620943877e-05f, -7.068967762e-05f, -2.558345201e-05f, +1.672406700e-05f, +2.396806258e-05f, +8.313625809e-06f,
    +4.924893000e-04f, +4.870151131e-04f, -7.809207842e-04f, -2.472345838e-03f, -1.759471632e-03f, +2.717189964e-03f, +6.974434643e-03f, +4.101293936e-03f, -6.654994938e-03f, -1.472294363e-02f, -7.393176150e-03f, +1.302581730e-02f, +2.549879468e-02f, +1.103118495e-02f, -2.152311891e-02f, -3.782541135e-02f, -1.407253608e-02f, +3.090099172e-02f, +4.919139917e-02f, +1.559580760e-02f, -3.918047895e-02f, -5.681737027e-02f, -1.510314144e-02f, +4.426264447e-02f, +5.866991166e-02f, +1.274913423e-02f, -4.471339091e-02f, -5.425637028e-02f, -9.269464674e-03f, +4.035345248e-02f, +4.481452940e-02f, +5.649943275e-03f, -3.235337614e-02f, -3.280731741e-02f, -2.717974638e-03f, +2.277473465e-02f, +2.097741199e-02f, +8.662588835e-04f, -1.378022540e-02f, -1.141404225e-02f, -2.277429524e-05f, +6.892652262e-03f, +5.032042043e-03f, -1.684510519e-04f, -2.628164501e-03f, -1.611221558e-03f, +9.705697900e-05f, +6.057305505e-04f,
    -1.199389677e-05f, +1.717459974e-05f, +5.708508235e-05f, +3.271562375e-05f, -8.371623530e-05f, -1.719969615e-04f, -5.602317951e-05f, +2.351112459e-04f, +3.734894680e-04f, +6.288388262e-05f, -4.965161516e-04f, -6.540016554e-04f, -2.824672336e-05f, +8.611594400e-04f, +9.704204222e-04f, -6.646319794e-05f, -1.278821250e-03f, -1.252124341e-03f, +2.197990000e-04f, +1.662940582e-03f, +1.424572536e-03f, -4.040820973e-04f, -1.917187310e-03f, -1.438445122e-03f, +5.720388143e-04f, +1.971295339e-03f, +1.290092373e-03f, -6.747407438e-04f, -1.809432872e-03f, -1.022848338e-03f, +6.823223727e-04f, +1.476919655e-03f, +7.086615254e-04f, -5.966591145e-04f, -1.061782430e-03f, -4.196341833e-04f, +4.493521809e-04f, +6.604135915e-04f, +2.034810611e-04f, -2.865252041e-04f, -3.440429587e-04f, -7.339249953e-05f, +1.490034349e-04f, +1.407945597e-04f, +1.406085667e-05f, -5.813984021e-05f, -3.854746139e-05f, +2.686215319e-06f,
    /*  5,24 (48) */
    -2.548461232e-04f, +2.555387032e-05f, +7.644661469e-04f, +1.235143482e-03f, +3.837196708e-04f, -1.806551514e-03f, -3.452074449e-03f, -1.987352192e-03f, +2.886159585e-03f, +7.391557627e-03f, +5.963775981e-03f, -3.031490209e-03f, -1.332107775e-02f, -1.399671352e-02f, +4.057616846e-04f, +2.131742272e-02f, +2.903372103e-02f, +8.682323264e-03f, -3.203095565e-02f, -6.004561120e-02f, -3.651706223e-02f, +5.254485398e-02f, +1.781925688e-01f, +2.802637745e-01f, +3.040099737e-01f, +2.362269475e-01f, +1.141790415e-01f, +6.008750117e-04f, -5.651467558e-02f, -5.027576570e-02f, -1.072806311e-02f, +2.255573827e-02f, +2.810957367e-02f, +1.115656820e-02f, -8.513531443e-03f, -1.546576120e-02f, -8.685732937e-03f, +2.210530586e-03f, +7.685358092e-03f, +5.549902587e-03f, +1.667420129e-04f, -3.216296117e-03f, -2.872768504e-03f, -6.191527084e-04f, +1.017441616e-03f, +1.105260690e-03f, +3.640247771e-04f, -1.838636527e-04f,
    -4.580078570e-07f, -1.724180117e-05f, -2.476498981e-05f, +8.777214654e-07f, +5.158945309e-05f, +7.430614754e-05f, +1.520990028e-05f, -1.060594193e-04f, -1.758302573e-04f, -7.644236730e-05f, +1.696565939e-04f, +3.531811281e-04f, +2.310957910e-04f, -2.098269225e-04f, -6.325743348e-04f, -5.652252355e-04f, +1.499382191e-04f, +1.058123249e-03f, +1.297591698e-03f, +2.647703935e-04f, -1.759068952e-03f, -3.596530898e-03f, -3.913691982e-03f, -2.210770639e-03f, +7.137124599e-04f, +3.239051608e-03f, +4.015321239e-03f, +2.851982022e-03f, +7.466178985e-04f, -9.142539476e-04f, -1.322210214e-03f, -6.601205199e-04f, +2.518208778e-04f, +6.805605342e-04f, +4.684408418e-04f, -2.253768358e-05f, -3.353918321e-04f, -2.927125456e-04f, -4.578169855e-05f, +1.473641109e-04f, +1.586868851e-04f, +4.702111702e-05f, -5.429598519e-05f, -7.145175848e-05f, -2.724700567e-05f, +1.589591286e-05f, +2.422880418e-05f, +8.868877284e-06f,
    +4.804954032e-04f, +5.041897128e-04f, -7.238357019e-04f, -2.439630214e-03f, -1.843187868e-03f, +2.545193002e-03f, +6.918411464e-03f, +4.336405182e-03f, -6.281505470e-03f, -1.466005975e-02f, -7.889692302e-03f, +1.237181565e-02f, +2.547054795e-02f, +1.189234439e-02f, -2.055269849e-02f, -3.789187454e-02f, -1.535135733e-02f, +2.964886738e-02f, +4.941119817e-02f, +1.725874818e-02f, -3.775590641e-02f, -5.722145237e-02f, -1.702032875e-02f, +4.282419935e-02f, +5.924195048e-02f, +1.472042957e-02f, -4.342329854e-02f, -5.493111103e-02f, -1.107889755e-02f, +3.933060414e-02f, +4.549685177e-02f, +7.126862931e-03f, -3.164471462e-02f, -3.340397652e-02f, -3.779757068e-03f, +2.235510046e-02f, +2.142676417e-02f, +1.526672475e-03f, -1.357674434e-02f, -1.170056746e-02f, -3.668172540e-04f, +6.819259763e-03f, +5.181045478e-03f, -2.765649223e-05f, -2.614103644e-03f, -1.669361398e-03f, +5.850951761e-05f, +6.084167658e-04f,
    -1.231862419e-05f, +1.580284829e-05f, +5.639053797e-05f, +3.506461595e-05f, -7.950518296e-05f, -1.716572328e-04f, -6.332576399e-05f, +2.261509316e-04f, +3.753330419e-04f, +7.901772440e-05f, -4.814633604e-04f, -6.609863865e-04f, -5.687146046e-05f, +8.401394188e-04f, +9.859275928e-04f, -2.349719803e-05f, -1.253885324e-03f, -1.278680614e-03f, +1.637582340e-04f, +1.637716154e-03f, +1.462515425e-03f, -3.396523490e-04f, -1.895757366e-03f, -1.485213656e-03f, +5.063084046e-04f, +1.956777258e-03f, +1.340610040e-03f, -6.151864918e-04f, -1.802922556e-03f, -1.070949660e-03f, +6.346300523e-04f, +1.477293135e-03f, +7.489789079e-04f, -5.632960958e-04f, -1.066399226e-03f, -4.491216100e-04f, +4.294212432e-04f, +6.663114089e-04f, +2.219489135e-04f, -2.767945562e-04f, -3.490151391e-04f, -8.294247518e-05f, +1.454898128e-04f, +1.438921311e-04f, +1.783680397e-05f, -5.748515713e-05f, -3.991988566e-05f, +1.768012448e-06f,
    /*  5,25 (48) */
    -2.553041311e-04f, +8.312069153e-06f, +7.397011571e-04f, +1.236021203e-03f, +4.353091239e-04f, -1.732245367e-03f, -3.436864548e-03f, -2.093411611e-03f, +2.710329328e-03f, +7.315115260e-03f, +6.133432575e-03f, -2.678309081e-03f, -1.308998196e-02f, -1.420654044e-02f, -2.268126503e-04f, +2.075219748e-02f, +2.918365925e-02f, +9.740446513e-03f, -3.073336395e-02f, -5.978084081e-02f, -3.827613119e-02f, +4.894832309e-02f, +1.742788769e-01f, +2.780530039e-01f, +3.047236861e-01f, +2.394659991e-01f, +1.181943628e-01f, +3.452857034e-03f, -5.576805768e-02f, -5.119001965e-02f, -1.205027332e-02f, +2.189561775e-02f, +2.836139455e-02f, +1.183712874e-02f, -8.045090601e-03f, -1.548829888e-02f, -9.021124769e-03f, +1.917818040e-03f, +7.639576393e-03f, +5.697266698e-03f, +3.254288980e-04f, -3.169275000e-03f, -2.927064489e-03f, -6.906044669e-04f, +9.901946107e-04f, +1.121156602e-03f, +3.882535813e-04f, -1.749947754e-04f,
    -5.634856882e-08f, -1.670976246e-05f, -2.495223275e-05f, -4.735395420e-07f, +5.007421371e-05f, +7.467188368e-05f, +1.837338947e-05f, -1.022983425e-04f, -1.758196513e-04f, -8.241240968e-05f, +1.614763310e-04f, +3.511310192e-04f, +2.405944913e-04f, -1.938165692e-04f, -6.246380358e-04f, -5.777838078e-04f, +1.207398156e-04f, +1.035222544e-03f, +1.308054313e-03f, +3.162242503e-04f, -1.691046668e-03f, -3.556393705e-03f, -3.935068360e-03f, -2.289705519e-03f, +6.193914536e-04f, +3.181989019e-03f, +4.022965919e-03f, +2.909889168e-03f, +8.122621241e-04f, -8.796439193e-04f, -1.328941313e-03f, -6.893924609e-04f, +2.280557008e-04f, +6.777073783e-04f, +4.819284022e-04f, -7.981125454e-06f, -3.310511696e-04f, -2.984998835e-04f, -5.386984442e-05f, +1.439462797e-04f, +1.608573953e-04f, +5.099895153e-05f, -5.229130969e-05f, -7.215062819e-05f, -2.891464378e-05f, +1.502953948e-05f, +2.446523357e-05f, +9.428075830e-06f,
    +4.681767790e-04f, +5.199925611e-04f, -6.674451639e-04f, -2.404565598e-03f, -1.922693051e-03f, +2.373535769e-03f, +6.855085700e-03f, +4.562556114e-03f, -5.906172429e-03f, -1.458104203e-02f, -8.371155662e-03f, +1.171082926e-02f, +2.541367649e-02f, +1.273248380e-02f, -1.956677089e-02f, -3.791537174e-02f, -1.660524265e-02f, +2.837018677e-02f, +4.957495640e-02f, +1.889646434e-02f, -3.629339099e-02f, -5.756110472e-02f, -1.891608611e-02f, +4.133898570e-02f, +5.974825888e-02f, +1.667720682e-02f, -4.208268850e-02f, -5.554629752e-02f, -1.288182010e-02f, +3.825965448e-02f, +4.613148183e-02f, +8.604156065e-03f, -3.089573571e-02f, -3.396727262e-02f, -4.846156295e-03f, +2.190597885e-02f, +2.185618541e-02f, +2.192983884e-03f, -1.335479543e-02f, -1.197736201e-02f, -7.158323930e-04f, +6.736317288e-03f, +5.326535291e-03f, +1.162356389e-04f, -2.596266840e-03f, -1.726846555e-03f, +1.858963195e-05f, +6.101847783e-04f,
    -1.260821934e-05f, +1.444930562e-05f, +5.563235826e-05f, +3.730813087e-05f, -7.527996901e-05f, -1.711039439e-04f, -7.042111331e-05f, +2.170548800e-04f, +3.766957546e-04f, +9.484636779e-05f, -4.660188261e-04f, -6.671201672e-04f, -8.515313225e-05f, +8.183278745e-04f, +1.000177170e-03f, +1.920138852e-05f, -1.227662917e-03f, -1.303639304e-03f, +1.077754521e-04f, +1.610719037e-03f, +1.498689992e-03f, -2.749696122e-04f, -1.872204622e-03f, -1.530270760e-03f, +4.399920438e-04f, +1.940023976e-03f, +1.389687861e-03f, -5.547880913e-04f, -1.794335564e-03f, -1.118017518e-03f, +5.859833326e-04f, +1.475970030e-03f, +7.886911375e-04f, -5.290357102e-04f, -1.069810928e-03f, -4.783540991e-04f, +4.087784712e-04f, +6.714820789e-04f, +2.403814012e-04f, -2.665916643e-04f, -3.536315659e-04f, -9.254930693e-05f, +1.417228871e-04f, +1.468632456e-04f, +2.167626924e-05f, -5.672955354e-05f, -4.127118779e-05f, +8.141264825e-07f,
    /*  5,26 (48) */
    -2.553604797e-04f, -8.397693308e-06f, +7.147489243e-04f, +1.235547664e-03f, +4.853833376e-04f, -1.657573483e-03f, -3.418491159e-03f, -2.195709953e-03f, +2.534509676e-03f, +7.232702850e-03f, +6.294908906e-03f, -2.327178061e-03f, -1.284938747e-02f, -1.440035701e-02f, -8.514506861e-04f, +2.017441367e-02f, +2.930439907e-02f, +1.077566906e-02f, -2.942530964e-02f, -5.946461656e-02f, -3.996717785e-02f, +4.539192938e-02f, +1.703438085e-01f, +2.757632984e-01f, +3.053430776e-01f, +2.426479881e-01f, +1.222173287e-01f, +6.362746202e-03f, -5.495579556e-02f, -5.206966357e-02f, -1.337921463e-02f, +2.120622529e-02f, +2.858945025e-02f, +1.251483612e-02f, -7.563162199e-03f, -1.549628001e-02f, -9.352175938e-03f, +1.619318156e-03f, +7.585706549e-03f, +5.841212978e-03f, +4.862862933e-04f, -3.118276048e-03f, -2.979355799e-03f, -7.627550950e-04f, +9.612799669e-04f, +1.136186142e-03f, +4.127188149e-04f, -1.655666996e-04f,
    +3.325513140e-07f, -1.617020805e-05f, -2.510476735e-05f, -1.794912561e-06f, +4.853434916e-05f, +7.495222276e-05f, +2.146486268e-05f, -9.849273735e-05f, -1.756338820e-04f, -8.821764323e-05f, +1.532480920e-04f, +3.487681447e-04f, +2.497441538e-04f, -1.778178744e-04f, -6.162093691e-04f, -5.896502377e-04f, +9.179265262e-05f, +1.011676179e-03f, +1.317203614e-03f, +3.666031161e-04f, -1.622904620e-03f, -3.514732883e-03f, -3.954350967e-03f, -2.367329218e-03f, +5.247107342e-04f, +3.123141668e-03f, +4.028594211e-03f, +2.966798390e-03f, +8.783544077e-04f, -8.437302523e-04f, -1.334551005e-03f, -7.184013214e-04f, +2.037806323e-04f, +6.741762959e-04f, +4.951205242e-04f, +6.764669129e-06f, -3.263327849e-04f, -3.040706252e-04f, -6.201620534e-05f, +1.403343294e-04f, +1.628974510e-04f, +5.498908266e-05f, -5.019605233e-05f, -7.278435928e-05f, -3.058450494e-05f, +1.412519415e-05f, +2.467647407e-05f, +9.990514341e-06f,
    +4.555685597e-04f, +5.344418668e-04f, -6.118128057e-04f, -2.367257467e-03f, -1.997973020e-03f, +2.202431825e-03f, +6.784664586e-03f, +4.779610994e-03f, -5.529476674e-03f, -1.448619566e-02f, -8.837174489e-03f, +1.104370909e-02f, +2.532852336e-02f, +1.355081168e-02f, -1.856659372e-02f, -3.789617035e-02f, -1.783290557e-02f, +2.706654746e-02f, +4.968273185e-02f, +2.050718337e-02f, -3.479470099e-02f, -5.783607433e-02f, -2.078829074e-02f, +3.980871493e-02f, +6.018825092e-02f, +1.861723080e-02f, -4.069300064e-02f, -5.610108561e-02f, -1.467615567e-02f, +3.714163696e-02f, +4.671746516e-02f, +1.008012610e-02f, -3.010704457e-02f, -3.449630833e-02f, -5.915967223e-03f, +2.142762475e-02f, +2.226496388e-02f, +2.864465963e-03f, -1.311441403e-02f, -1.224395368e-02f, -1.069463959e-03f, +6.643767981e-03f, +5.468258178e-03f, +2.630988845e-04f, -2.574590571e-03f, -1.783576109e-03f, -2.268155584e-05f, +6.109989047e-04f,
    -1.286325678e-05f, +1.311569267e-05f, +5.481331037e-05f, +3.944534245e-05f, -7.104669728e-05f, -1.703417977e-04f, -7.730352398e-05f, +2.078367251e-04f, +3.775826245e-04f, +1.103542023e-04f, -4.502058804e-04f, -6.724045223e-04f, -1.130611588e-04f, +7.957574627e-04f, +1.013161888e-03f, +6.158416111e-05f, -1.200192326e-03f, -1.326979411e-03f, +5.191557569e-05f, +1.581986859e-03f, +1.533059196e-03f, -2.101093419e-04f, -1.846559109e-03f, -1.573565251e-03f, +3.731664260e-04f, +1.921052916e-03f, +1.437266567e-03f, -4.936137165e-04f, -1.783675417e-03f, -1.163992963e-03f, +5.364347167e-04f, +1.472942613e-03f, +8.277475240e-04f, -4.939121784e-04f, -1.072003745e-03f, -5.072942109e-04f, +3.874417647e-04f, +6.759112251e-04f, +2.587552704e-04f, -2.559229908e-04f, -3.578810928e-04f, -1.022014149e-04f, +1.377031470e-04f, +1.497013158e-04f, +2.557515028e-05f, -5.587170545e-05f, -4.259860619e-05f, -1.748371843e-07f,
    /*  5,27 (48) */
    -2.550279284e-04f, -2.456790136e-05f, +6.896441570e-04f, +1.233752751e-03f, +5.339176868e-04f, -1.582621260e-03f, -3.397026296e-03f, -2.294202691e-03f, +2.358875794e-03f, +7.144485207e-03f, +6.448156998e-03f, -1.978409917e-03f, -1.259964332e-02f, -1.457817489e-02f, -1.467660055e-03f, +1.958476344e-02f, +2.939619172e-02f, +1.178734524e-02f, -2.810810602e-02f, -5.909801344e-02f, -4.159008247e-02f, +4.187719650e-02f, +1.663894575e-01f, +2.733959691e-01f, +3.058677883e-01f, +2.457711298e-01f, +1.262459229e-01f, +9.329544592e-03f, -5.407744115e-02f, -5.291339382e-02f, -1.471376564e-02f, +2.048782397e-02f, +2.879323088e-02f, +1.318901241e-02f, -7.068041675e-03f, -1.548951534e-02f, -9.678508723e-03f, +1.315247531e-03f, +7.523690343e-03f, +5.981547307e-03f, +6.491837443e-04f, -3.063286966e-03f, -3.029551851e-03f, -8.355394543e-04f, +9.306954619e-04f, +1.150311336e-03f, +4.373952890e-04f, -1.555761852e-04f,
    +7.084341628e-07f, -1.562404701e-05f, -2.522316587e-05f, -3.085449097e-06f, +4.697204714e-05f, +7.514833557e-05f, +2.448221192e-05f, -9.464722144e-05f, -1.752756536e-04f, -9.385450125e-05f, +1.449806409e-04f, +3.460987533e-04f, +2.585402193e-04f, -1.618459476e-04f, -6.073020941e-04f, -6.008217499e-04f, +6.311996246e-05f, +9.875129711e-04f, +1.325049194e-03f, +4.158831038e-04f, -1.554688781e-03f, -3.471584587e-03f, -3.971537433e-03f, -2.443598970e-03f, +4.297252058e-04f, +3.062539108e-03f, +4.032192029e-03f, +3.022665690e-03f, +9.448540396e-04f, -8.065241007e-04f, -1.339019774e-03f, -7.471176191e-04f, +1.790119753e-04f, +6.699624954e-04f, +5.080010344e-04f, +2.168771654e-05f, -3.212365825e-04f, -3.094164336e-04f, -7.021336113e-05f, +1.365292130e-04f, +1.648029922e-04f, +5.898747491e-05f, -4.801096373e-05f, -7.335106579e-05f, -3.225469128e-05f, +1.318317613e-05f, +2.486166402e-05f, +1.055546563e-05f,
    +4.427053029e-04f, +5.475575594e-04f, -5.569994953e-04f, -2.327812125e-03f, -2.069019717e-03f, +2.032090028e-03f, +6.707361062e-03f, +4.987447719e-03f, -5.151894049e-03f, -1.437584146e-02f, -9.287380369e-03f, +1.037130457e-02f, +2.521546220e-02f, +1.434656914e-02f, -1.755343184e-02f, -3.783458619e-02f, -1.903309789e-02f, +2.573956805e-02f, +4.973464743e-02f, +2.208917023e-02f, -3.326164180e-02f, -5.804618367e-02f, -2.263484985e-02f, +3.823514968e-02f, +6.056141735e-02f, +2.053828372e-02f, -3.925573407e-02f, -5.659469933e-02f, -1.645983108e-02f, +3.597764400e-02f, +4.725389987e-02f, +1.155306871e-02f, -2.927929705e-02f, -3.499022051e-02f, -6.987970968e-03f, +2.092033054e-02f, +2.265240565e-02f, +3.540377188e-03f, -1.285565876e-02f, -1.249987667e-02f, -1.427345052e-03f, +6.541566566e-03f, +5.605961325e-03f, +4.128002002e-04f, -2.549015421e-03f, -1.839447814e-03f, -6.528016204e-05f, +6.108240676e-04f,
    -1.308435842e-05f, +1.180365334e-05f, +5.393619212e-05f, +4.147559932e-05f, -6.681136497e-05f, -1.693757007e-04f, -8.396766904e-05f, +1.985100593e-04f, +3.779992129e-04f, +1.255262157e-04f, -4.340480528e-04f, -6.768420109e-04f, -1.405657006e-04f, +7.724614896e-04f, +1.024876061e-03f, +1.036034182e-04f, -1.171513123e-03f, -1.348681970e-03f, -3.756894563e-06f, +1.551559172e-03f, +1.565588232e-03f, -1.451470514e-04f, -1.818853291e-03f, -1.615048053e-03f, +3.059088574e-04f, +1.899884136e-03f, +1.483288570e-03f, -4.317326185e-04f, -1.770948110e-03f, -1.208818120e-03f, +4.860380252e-04f, +1.468205161e-03f, +8.660978565e-04f, -4.579610073e-04f, -1.072965264e-03f, -5.359045371e-04f, +3.654300590e-04f, +6.795852465e-04f, +2.770470667e-04f, -2.447956822e-04f, -3.617528960e-04f, -1.118869784e-04f, +1.334314370e-04f, +1.523998194e-04f, +2.952917350e-05f, -5.491041683e-05f, -4.389935025e-05f, -1.198194503e-06f,
    /*  5,28 (48) */
    -2.543194942e-04f, -4.019194836e-05f, +6.644209911e-04f, +1.230667302e-03f, +5.808897339e-04f, -1.507472925e-03f, -3.372544084e-03f, -2.388849912e-03f, +2.183600141e-03f, +7.050630706e-03f, +6.593137639e-03f, -1.632311164e-03f, -1.234110310e-02f, -1.474002084e-02f, -2.074962149e-03f, +1.898394169e-02f, +2.945931168e-02f, +1.277485821e-02f, -2.678305683e-02f, -5.868213034e-02f, -4.314477126e-02f, +3.840561191e-02f, +1.624179201e-01f, +2.709523702e-01f, +3.062975135e-01f, +2.488336689e-01f, +1.302781149e-01f, +1.235221028e-02f, -5.313258711e-02f, -5.371991792e-02f, -1.605278541e-02f, +1.974070635e-02f, +2.897224286e-02f, +1.385897491e-02f, -6.560040640e-03f, -1.546782762e-02f, -9.999745306e-03f, +1.005831098e-03f, +7.453476982e-03f, +6.118076521e-03f, +8.139867365e-04f, -3.004299491e-03f, -3.077562815e-03f, -9.088905201e-04f, +8.984407707e-04f, +1.163494512e-03f, +4.622569530e-04f, -1.450207196e-04f,
    +1.071067014e-06f, -1.507217817e-05f, -2.530803227e-05f, -4.344255180e-06f, +4.538948299e-05f, +7.526146721e-05f, +2.742344173e-05f, -9.076638712e-05f, -1.747478114e-04f, -9.931963539e-05f, +1.366826693e-04f, +3.431293195e-04f, +2.669785256e-04f, -1.459156977e-04f, -5.979302622e-04f, -6.112962379e-04f, +3.474447002e-05f, +9.627619319e-04f, +1.331601571e-03f, +4.640413452e-04f, -1.486444859e-03f, -3.426985803e-03f, -3.986626796e-03f, -2.518472968e-03f, +3.344899904e-04f, +3.000212120e-03f, +4.033746599e-03f, +3.077447539e-03f, +1.011719708e-03f, -7.680377050e-04f, -1.342328824e-03f, -7.755117888e-04f, +1.537666687e-04f, +6.650617683e-04f, +5.205538694e-04f, +3.677571941e-05f, -3.157628388e-04f, -3.145290927e-04f, -7.845374324e-05f, +1.325320967e-04f, +1.665700430e-04f, +6.299002298e-05f, -4.573690588e-05f, -7.384890615e-05f, -3.392327012e-05f, +1.220383718e-05f, +2.501995817e-05f, +1.112218308e-05f,
    +4.296209445e-04f, +5.593612128e-04f, -5.030633032e-04f, -2.286336525e-03f, -2.135831082e-03f, +1.862714327e-03f, +6.623393393e-03f, +5.185957778e-03f, -4.773894837e-03f, -1.425031524e-02f, -9.721428422e-03f, +9.694462559e-03f, +2.507489650e-02f, +1.511903063e-02f, -1.652855578e-02f, -3.773098278e-02f, -2.020461102e-02f, +2.439088608e-02f, +4.973089053e-02f, +2.364072940e-02f, -3.169605357e-02f, -5.819133072e-02f, -2.445370314e-02f, +3.662010163e-02f, +6.086732621e-02f, +2.243816785e-02f, -3.777244550e-02f, -5.702643195e-02f, -1.823077919e-02f, +3.476882588e-02f, +4.773993790e-02f, +1.302127387e-02f, -2.841319919e-02f, -3.544818151e-02f, -8.060936232e-03f, +2.038442601e-02f, +2.301783571e-02f, +4.219962434e-03f, -1.257861169e-02f, -1.274467235e-02f, -1.789097948e-03f, +6.429679587e-03f, +5.739392762e-03f, +5.652000196e-04f, -2.519486247e-03f, -1.894358231e-03f, -1.091795123e-04f, +6.096258730e-04f,
    -1.327219129e-05f, +1.051475348e-05f, +5.300382693e-05f, +4.339842234e-05f, -6.257985583e-05f, -1.682107523e-04f, -9.040859955e-05f, +1.890884151e-04f, +3.779516098e-04f, +1.403480063e-04f, -4.175690386e-04f, -6.804362127e-04f, -1.676376893e-04f, +7.484738657e-04f, +1.035315582e-03f, +1.452122113e-04f, -1.141666093e-03f, -1.368730061e-03f, -5.917795491e-05f, +1.519477402e-03f, +1.596244569e-03f, -8.015822091e-05f, -1.789122022e-03f, -1.654672260e-03f, +2.382971639e-04f, +1.876540307e-03f, +1.527698035e-03f, -3.692150440e-04f, -1.756162112e-03f, -1.252436269e-03f, +4.348483358e-04f, +1.461753968e-03f, +9.036924671e-04f, -4.212189541e-04f, -1.072684480e-03f, -5.641477479e-04f, +3.427633103e-04f, +6.824913432e-04f, +2.952331641e-04f, -2.332175677e-04f, -3.652364931e-04f, -1.215939488e-04f, +1.289089615e-04f, +1.549523100e-04f, +3.353389702e-05f, -5.384462416e-05f, -4.517060431e-05f, -2.255182080e-06f,
    /*  5,29 (48) */
    -2.532484272e-04f, -5.526412654e-05f, +6.391129589e-04f, +1.226323047e-03f, +6.262792169e-04f, -1.432211457e-03f, -3.345120643e-03f, -2.479616299e-03f, +2.008852329e-03f, +6.951311070e-03f, +6.729820308e-03f, -1.289181844e-03f, -1.207412457e-02f, -1.488593653e-02f, -2.672892411e-03f, +1.837264545e-02f, +2.949405615e-02f, +1.373762014e-02f, -2.545145526e-02f, -5.821808899e-02f, -4.463121611e-02f, +3.497862611e-02f, +1.584312933e-01f, +2.684338972e-01f, +3.066320035e-01f, +2.518338810e-01f, +1.343118615e-01f, +1.542965782e-02f, -5.212086740e-02f, -5.448795563e-02f, -1.739511424e-02f, +1.896519456e-02f, +2.912600952e-02f, +1.452403668e-02f, -6.039486771e-03f, -1.543105190e-02f, -1.031550814e-02f, +6.913020049e-04f, +7.375023239e-03f, +6.250608617e-03f, +9.805567796e-04f, -2.941309468e-03f, -3.123299721e-03f, -9.827394263e-04f, +8.645175005e-04f, +1.175698349e-03f, +4.872769112e-04f, -1.338985365e-04f,
    +1.420241427e-06f, -1.451548917e-05f, -2.536000083e-05f, -5.570491509e-06f, +4.378881732e-05f, +7.529293449e-05f, +3.028666972e-05f, -8.685479693e-05f, -1.740533367e-04f, -1.046099163e-04f, +1.283627894e-04f, +3.398665344e-04f, +2.750553076e-04f, -1.300418210e-04f, -5.881082002e-04f, -6.210722581e-04f, +6.688377871e-06f, +9.374522451e-04f, +1.336872173e-03f, +5.110560018e-04f, -1.418218264e-03f, -3.380974317e-03f, -3.999619503e-03f, -2.591910390e-03f, +2.390603885e-04f, +2.936192693e-03f, +4.033246478e-03f, +3.131100912e-03f, +1.078909526e-03f, -7.282843910e-04f, -1.344460098e-03f, -8.035542069e-04f, +1.280622791e-04f, +6.594704999e-04f, +5.327630927e-04f, +5.201607505e-05f, -3.099122062e-04f, -3.194005173e-04f, -8.672964061e-05f, +1.283443613e-04f, +1.681947169e-04f, +6.699255526e-05f, -4.337485293e-05f, -7.427608600e-05f, -3.558827568e-05f, +1.118758209e-05f, +2.515052909e-05f, +1.168990126e-05f,
    +4.163487532e-04f, +5.698759662e-04f, -4.500594762e-04f, -2.242938103e-03f, -2.198410938e-03f, +1.694503575e-03f, +6.532984794e-03f, +5.375046193e-03f, -4.395943227e-03f, -1.410996723e-02f, -1.013899746e-02f, +9.014026346e-03f, +2.490725881e-02f, +1.586750450e-02f, -1.549324019e-02f, -3.758577056e-02f, -2.134627711e-02f, +2.302215602e-02f, +4.967171258e-02f, +2.516020681e-02f, -3.009980900e-02f, -5.827148895e-02f, -2.624282516e-02f, +3.496542937e-02f, +6.110562337e-02f, +2.431470816e-02f, -3.624474747e-02f, -5.739564699e-02f, -1.998694131e-02f, +3.351638961e-02f, +4.817478624e-02f, +1.448302784e-02f, -2.750950673e-02f, -3.586940047e-02f, -9.133620712e-03f, +1.982027826e-02f, +2.336059902e-02f, +4.902453778e-03f, -1.228337852e-02f, -1.297788992e-02f, -2.154334441e-03f, +6.308085639e-03f, +5.868301724e-03f, +7.201523296e-04f, -2.485952350e-03f, -1.948202855e-03f, -1.543501166e-04f, +6.073706910e-04f,
    -1.342746520e-05f, +9.250480050e-06f, +5.201905875e-05f, +4.521350195e-05f, -5.835793373e-05f, -1.668522344e-04f, -9.662174551e-05f, +1.795852487e-04f, +3.774464191e-04f, +1.548057940e-04f, -4.007926665e-04f, -6.831917134e-04f, -1.942488568e-04f, +7.238290583e-04f, +1.044477917e-03f, +1.863643975e-04f, -1.110693183e-03f, -1.387108823e-03f, -1.142841741e-04f, +1.485784786e-03f, +1.624997983e-03f, -1.521820702e-05f, -1.757402499e-03f, -1.692393190e-03f, +1.704095971e-04f, +1.851046690e-03f, +1.570440944e-03f, -3.061321530e-04f, -1.739328359e-03f, -1.294791911e-03f, +3.829219223e-04f, +1.453587369e-03f, +9.404822960e-04f, -3.837239896e-04f, -1.071151816e-03f, -5.919866399e-04f, +3.194624803e-04f, +6.846175414e-04f, +3.132897930e-04f, -2.211971578e-04f, -3.683217620e-04f, -1.313100623e-04f, +1.241372887e-04f, +1.573524280e-04f, +3.758471417e-05f, -5.267340081e-05f, -4.640953171e-05f, -3.344956610e-06f,
    /*  5,30 (48) */
    -2.518281858e-04f, -6.977961571e-05f, +6.137529580e-04f, +1.220752556e-03f, +6.700680342e-04f, -1.356918523e-03f, -3.314833973e-03f, -2.566471096e-03f, +1.834798993e-03f, +6.846701154e-03f, +6.858183098e-03f, -9.493153096e-04f, -1.179906927e-02f, -1.501597835e-02f, -3.261000612e-03f, +1.775157319e-02f, +2.950074453e-02f, +1.467507238e-02f, -2.411458308e-02f, -5.770703299e-02f, -4.604943438e-02f, +3.159765179e-02f, +1.544316738e-01f, +2.658419868e-01f, +3.068710639e-01f, +2.547700737e-01f, +1.383451080e-01f, +1.856075873e-02f, -5.104195788e-02f, -5.521624002e-02f, -1.873957433e-02f, +1.816164035e-02f, +2.925407180e-02f, +1.518350718e-02f, -5.506723678e-03f, -1.537903583e-02f, -1.062542035e-02f, +3.719014876e-04f, +7.288293598e-03f, +6.378952979e-03f, +1.148751496e-03f, -2.874316912e-03f, -3.166674574e-03f, -1.057015512e-03f, +8.289292249e-04f, +1.186885931e-03f, +5.124274402e-04f, -1.222086353e-04f,
    +1.755773309e-06f, -1.395485539e-05f, -2.537973484e-05f, -6.763373530e-06f, +4.217219376e-05f, +7.524412339e-05f, +3.307012695e-05f, -8.291697915e-05f, -1.731953418e-04f, -1.097224341e-04f, +1.200295256e-04f, +3.363172964e-04f, +2.827671959e-04f, -1.142387896e-04f, -5.778504940e-04f, -6.301490248e-04f, -2.102664783e-05f, +9.116132390e-04f, +1.340873323e-03f, +5.569062743e-04f, -1.350054072e-03f, -3.333588684e-03f, -4.010517398e-03f, -2.663871431e-03f, +1.434918397e-04f, +2.870514001e-03f, +4.030681563e-03f, +3.183583322e-03f, +1.146381061e-03f, -6.872785669e-04f, -1.345396299e-03f, -8.312152161e-04f, +1.019169912e-04f, +6.531856788e-04f, +5.446129107e-04f, +6.739588425e-05f, -3.036857170e-04f, -3.240227631e-04f, -9.503320589e-05f, +1.239676040e-04f, +1.696732221e-04f, +7.099083746e-05f, -4.092589172e-05f, -7.463086104e-05f, -3.724771090e-05f, +1.013486907e-05f, +2.525256859e-05f, +1.225783667e-05f,
    +4.029212880e-04f, +5.791264463e-04f, -3.980404175e-04f, -2.197724601e-03f, -2.256768871e-03f, +1.527651340e-03f, +6.436363048e-03f, +5.554631442e-03f, -4.018496808e-03f, -1.395516144e-02f, -1.053979013e-02f, +8.330834633e-03f, +2.471300995e-02f, +1.659133356e-02f, -1.444876228e-02f, -3.739940617e-02f, -2.245697029e-02f, +2.163504720e-02f, +4.955742841e-02f, +2.664599159e-02f, -2.847481101e-02f, -5.828670715e-02f, -2.800022766e-02f, +3.327303618e-02f, +6.127603297e-02f, +2.616575485e-02f, -3.467430652e-02f, -5.770177914e-02f, -2.172626967e-02f, +3.222159770e-02f, +4.855770816e-02f, +1.593661521e-02f, -2.656902443e-02f, -3.625312446e-02f, -1.020477253e-02f, +1.922829162e-02f, +2.368006150e-02f, +5.587071319e-03f, -1.197008873e-02f, -1.319908707e-02f, -2.522656203e-03f, +6.176775576e-03f, +5.992439012e-03f, +8.775047576e-04f, -2.448367636e-03f, -2.000876256e-03f, -2.007596483e-04f, +6.040257344e-04f,
    -1.355093038e-05f, +8.012240443e-06f, +5.098474714e-05f, +4.692069522e-05f, -5.415123641e-05f, -1.653056012e-04f, -1.026029163e-04f, +1.700139223e-04f, +3.764907428e-04f, +1.688864313e-04f, -3.837428672e-04f, -6.851140893e-04f, -2.203717640e-04f, +6.985620449e-04f, +1.052362092e-03f, +2.270146915e-04f, -1.078637439e-03f, -1.403805461e-03f, -1.690127679e-04f, +1.450526321e-03f, +1.651820586e-03f, +4.959784783e-05f, -1.723734218e-03f, -1.728168432e-03f, +1.023247407e-04f, +1.823431103e-03f, +1.611465173e-03f, -2.425559345e-04f, -1.720460254e-03f, -1.335830847e-03f, +3.303161911e-04f, +1.443705745e-03f, +9.764189553e-04f, -3.455152596e-04f, -1.068359147e-03f, -6.193841835e-04f, +2.955495186e-04f, +6.859527169e-04f, +3.311930698e-04f, -2.087436413e-04f, -3.709989590e-04f, -1.410228537e-04f, +1.191183543e-04f, +1.595939104e-04f, +4.167685723e-05f, -5.139596134e-05f, -4.761327908e-05f, -4.466594439e-06f,
    /*  5,31 (48) */
    -2.500724124e-04f, -8.373447109e-05f, +5.883732232e-04f, +1.213989182e-03f, +7.122402280e-04f, -1.281674399e-03f, -3.281763846e-03f, -2.649388075e-03f, +1.661603651e-03f, +6.736978720e-03f, +6.978212623e-03f, -6.129980132e-04f, -1.151630207e-02f, -1.513021714e-02f, -3.838851106e-03f, +1.712142417e-02f, +2.947971788e-02f, +1.558668562e-02f, -2.277370976e-02f, -5.715012672e-02f, -4.739948845e-02f, +2.826406311e-02f, +1.504211564e-01f, +2.631781154e-01f, +3.070145557e-01f, +2.576405877e-01f, +1.423757896e-01f, +2.174434206e-02f, -4.989557681e-02f, -5.590351858e-02f, -2.008497063e-02f, +1.733042513e-02f, +2.935598879e-02f, +1.583669286e-02f, -4.962110768e-03f, -1.531163994e-02f, -1.092910607e-02f, +4.787872449e-05f, +7.193260392e-03f, +6.502920583e-03f, +1.318424719e-03f, -2.803326075e-03f, -3.207600465e-03f, -1.131646373e-03f, +7.916815140e-04f, +1.197020801e-03f, +5.376800088e-04f, -1.099507986e-04f,
    +2.077502712e-06f, -1.339113908e-05f, -2.536792522e-05f, -7.922171439e-06f, +4.054173673e-05f, +7.511648637e-05f, +3.577215824e-05f, -7.895742338e-05f, -1.721770654e-04f, -1.146544985e-04f, +1.116913074e-04f, +3.324887018e-04f, +2.901112160e-04f, -9.852083963e-05f, -5.671719722e-04f, -6.385264040e-04f, -4.837949091e-05f, +8.852743607e-04f, +1.343618217e-03f, +6.015724119e-04f, -1.281996999e-03f, -3.284868198e-03f, -4.019323722e-03f, -2.734317328e-03f, +4.783988299e-05f, +2.803210385e-03f, +4.026043107e-03f, +3.234852854e-03f, +1.214091364e-03f, -6.450357199e-04f, -1.345120911e-03f, -8.584651506e-04f, +7.534959806e-05f, +6.462049060e-04f, +5.560876896e-04f, +8.290196051e-05f, -2.970847865e-04f, -3.283880359e-04f, -1.033564617e-04f, +1.194036389e-04f, +1.710018670e-04f, +7.498057630e-05f, -3.839122229e-05f, -7.491153978e-05f, -3.889954925e-05f, +9.046210131e-06f, +2.532528913e-05f, +1.282518843e-05f,
    +3.893703576e-04f, +5.871386867e-04f, -3.470556704e-04f, -2.150803906e-03f, -2.310920108e-03f, +1.362345739e-03f, +6.333760132e-03f, +5.724645364e-03f, -3.642006065e-03f, -1.378627501e-02f, -1.092353299e-02f, +7.645720544e-03f, +2.449263819e-02f, +1.728989560e-02f, -1.339640018e-02f, -3.717239147e-02f, -2.353560773e-02f, +2.023124174e-02f, +4.938841564e-02f, +2.809651791e-02f, -2.682299043e-02f, -5.823710931e-02f, -2.972396188e-02f, +3.154486775e-02f, +6.137835771e-02f, +2.798918595e-02f, -3.306284135e-02f, -5.794433508e-02f, -2.344672992e-02f, +3.088576685e-02f, +4.888802435e-02f, +1.738032095e-02f, -2.559260547e-02f, -3.659863972e-02f, -1.127313167e-02f, +1.860890744e-02f, +2.397561102e-02f, +6.273024036e-03f, -1.163889566e-02f, -1.340783072e-02f, -2.893655162e-03f, +6.035752723e-03f, +6.111557367e-03f, +1.037098668e-03f, -2.406690779e-03f, -2.052272217e-03f, -2.483729274e-04f, +5.995591399e-04f,
    -1.364337518e-05f, +6.801361925e-06f, +4.990376237e-05f, +4.852002281e-05f, -4.996526961e-05f, -1.635764684e-04f, -1.083483004e-04f, +1.603876878e-04f, +3.750921654e-04f, +1.825774125e-04f, -3.664436410e-04f, -6.862098894e-04f, -2.459798275e-04f, +6.727082646e-04f, +1.058968687e-03f, +2.671187145e-04f, -1.045542951e-03f, -1.418809249e-03f, -2.233016724e-04f, +1.413748698e-03f, +1.676686855e-03f, +1.142151055e-04f, -1.688158924e-03f, -1.761957904e-03f, +3.412141537e-05f, +1.793723894e-03f, +1.650720551e-03f, -1.785591216e-04f, -1.699573653e-03f, -1.375500241e-03f, +2.770896161e-04f, +1.432111537e-03f, +1.011454792e-03f, -3.066330440e-04f, -1.064299823e-03f, -6.463035710e-04f, +2.710473447e-04f, +6.864866184e-04f, +3.489190265e-04f, -1.958668817e-04f, -3.732587375e-04f, -1.507196706e-04f, +1.138544649e-04f, +1.616706026e-04f, +4.580540148e-05f, -5.001166561e-05f, -4.877898058e-05f, -5.619091256e-06f,
    /*  6, 0 (48) */
    +4.968144385e-04f, +2.658533900e-04f, -8.962168723e-04f, -1.608103413e-03f, -7.788642489e-06f, +2.979420144e-03f, +3.156687553e-03f, -1.777487314e-03f, -6.981373376e-03f, -4.200072704e-03f, +6.679001343e-03f, +1.302046751e-02f, +2.733865881e-03f, -1.674345458e-02f, -2.042237500e-02f, +4.850187710e-03f, +3.528439247e-02f, +2.773502242e-02f, -2.703828769e-02f, -7.382778902e-02f, -3.314369929e-02f, +1.149897119e-01f, +2.902267079e-01f, +3.684748747e-01f, +2.902267079e-01f, +1.149897119e-01f, -3.314369929e-02f, -7.382778902e-02f, -2.703828769e-02f, +2.773502242e-02f, +3.528439247e-02f, +4.850187710e-03f, -2.042237500e-02f, -1.674345458e-02f, +2.733865881e-03f, +1.302046751e-02f, +6.679001343e-03f, -4.200072704e-03f, -6.981373376e-03f, -1.777487314e-03f, +3.156687553e-03f, +2.979420144e-03f, -7.788642489e-06f, -1.608103413e-03f, -8.962168723e-04f, +2.658533900e-04f, +4.968144385e-04f, +1.277320727e-04f,
    -7.206097170e-06f, +2.345369145e-05f, +4.096545548e-05f, -6.905852224e-06f, -8.675906281e-05f, -7.546324261e-05f, +7.573909431e-05f, +2.022568705e-04f, +7.646324280e-05f, -2.455625648e-04f, -3.580985825e-04f, +2.603744181e-05f, +5.634016105e-04f, +5.082121336e-04f, -3.395718620e-04f, -1.086804390e-03f, -5.736463860e-04f, +1.068031294e-03f, +2.020535961e-03f, +4.854822889e-04f, -3.056293732e-03f, -5.676763658e-03f, -4.596934279e-03f, -8.196129835e-05f, +4.496275233e-03f, +5.707482646e-03f, +3.170653092e-03f, -3.946898559e-04f, -2.015321110e-03f, -1.120316544e-03f, +5.335348884e-04f, +1.093922442e-03f, +3.714076894e-04f, -4.917967149e-04f, -5.741874250e-04f, -4.413138857e-05f, +3.537211876e-04f, +2.547523335e-04f, -6.792291394e-05f, -2.029151000e-04f, -8.143026444e-05f, +7.257614213e-05f, +8.845998205e-05f, +9.423532883e-06f, -4.059785137e-05f, -2.453583715e-05f, +6.589777155e-06f, +1.156587247e-05f,
    -4.968144385e-04f, -7.842817921e-04f, +8.994291019e-04f, +2.915640051e-03f, +8.438649895e-04f, -5.098406932e-03f, -6.009425829e-03f, +3.886651395e-03f, +1.308708603e-02f, +4.180565853e-03f, -1.651382305e-02f, -1.845487053e-02f, +9.460496445e-03f, +3.171517895e-02f, +1.017220246e-02f, -3.304107863e-02f, -3.524088677e-02f, +1.560130303e-02f, +5.143354543e-02f, +1.625027633e-02f, -4.622585189e-02f, -4.721341238e-02f, +1.858986948e-02f, +6.004110985e-02f, +1.858986948e-02f, -4.721341238e-02f, -4.622585189e-02f, +1.625027633e-02f, +5.143354543e-02f, +1.560130303e-02f, -3.524088677e-02f, -3.304107863e-02f, +1.017220246e-02f, +3.171517895e-02f, +9.460496445e-03f, -1.845487053e-02f, -1.651382305e-02f, +4.180565853e-03f, +1.308708603e-02f, +3.886651395e-03f, -6.009425829e-03f, -5.098406932e-03f, +8.438649895e-04f, +2.915640051e-03f, +8.994291019e-04f, -7.842817921e-04f, -6.202569526e-04f, -1.277320727e-04f,
    +7.206097170e-06f, -1.905086070e-05f, -7.742340156e-05f, -2.244308745e-05f, +1.497789702e-04f, +1.680758405e-04f, -1.428957736e-04f, -4.031178103e-04f, -7.079960453e-05f, +5.796643399e-04f, +5.287520583e-04f, -4.584378263e-04f, -1.058776278e-03f, -1.168871057e-04f, +1.299923556e-03f, +1.022760899e-03f, -9.173623485e-04f, -1.822672317e-03f, -1.123708632e-04f, +1.992771091e-03f, +1.381254679e-03f, -1.285058184e-03f, -2.242170783e-03f, -4.645487730e-05f, +2.215111194e-03f, +1.360178459e-03f, -1.312782922e-03f, -2.024189074e-03f, +3.287736205e-05f, +1.807031638e-03f, +9.774392195e-04f, -9.777611267e-04f, -1.325464625e-03f, +6.806222398e-05f, +1.053802351e-03f, +4.924109527e-04f, -5.086829447e-04f, -5.938112090e-04f, +5.080677731e-05f, +4.032233109e-04f, +1.552090461e-04f, -1.629782250e-04f, -1.544976859e-04f, +1.804669126e-05f, +7.810303453e-05f, +2.113479253e-05f, -2.026107605e-05f, -1.156587247e-05f,
    /*  6, 1 (48) */
    +4.896083413e-04f, +2.893070814e-04f, -8.552514168e-04f, -1.615009265e-03f, -9.454770530e-05f, +2.903956901e-03f, +3.232426648e-03f, -1.575230443e-03f, -6.904910133e-03f, -4.445635269e-03f, +6.320902760e-03f, +1.304650495e-02f, +3.297267492e-03f, -1.623524244e-02f, -2.076194686e-02f, +3.763383320e-03f, +3.471074609e-02f, +2.880305371e-02f, -2.501775173e-02f, -7.334230673e-02f, -3.619999302e-02f, +1.093129482e-01f, +2.856297736e-01f, +3.683929135e-01f, +2.947229831e-01f, +1.206971945e-01f, -2.997304620e-02f, -7.422247888e-02f, -2.905360880e-02f, +2.661470588e-02f, +3.581792736e-02f, +5.944110152e-03f, -2.005096731e-02f, -1.723525129e-02f, +2.159678456e-03f, +1.297633612e-02f, +7.032722530e-03f, -3.945320371e-03f, -7.049296290e-03f, -1.980402414e-03f, +3.075257289e-03f, +3.051996286e-03f, +8.067133956e-05f, -1.598679880e-03f, -9.368147236e-04f, +2.413175528e-04f, +5.034042156e-04f, +1.392979451e-04f,
    -7.791242229e-06f, +2.236071049e-05f, +4.126109227e-05f, -4.429146330e-06f, -8.496304936e-05f, -7.819246260e-05f, +7.003201622e-05f, +2.013257369e-04f, +8.477603732e-05f, -2.361598639e-04f, -3.619299538e-04f, +8.136198435e-06f, +5.519882992e-04f, +5.237462362e-04f, -3.076704192e-04f, -1.078335946e-03f, -6.124905293e-04f, +1.015080108e-03f, +2.023109414e-03f, +5.740791932e-04f, -2.941027388e-03f, -5.642146737e-03f, -4.693945103e-03f, -2.458165803e-04f, +4.392039864e-03f, +5.734251616e-03f, +3.283990837e-03f, -3.017665142e-04f, -2.007432595e-03f, -1.171860555e-03f, +4.921922220e-04f, +1.099664087e-03f, +4.031343334e-04f, -4.745115978e-04f, -5.843232553e-04f, -6.239543190e-05f, +3.487967929e-04f, +2.637133416e-04f, -5.916399725e-05f, -2.032954010e-04f, -8.709694318e-05f, +6.953278931e-05f, +9.006147782e-05f, +1.197904264e-05f, -4.015732169e-05f, -2.560501230e-05f, +5.942614945e-06f, +1.179515707e-05f,
    -4.896083413e-04f, -8.033326528e-04f, +8.220057003e-04f, +2.893196964e-03f, +9.936439597e-04f, -4.930331092e-03f, -6.152321602e-03f, +3.483533585e-03f, +1.301628643e-02f, +4.760230193e-03f, -1.598507100e-02f, -1.891330835e-02f, +8.401720167e-03f, +3.159829184e-02f, +1.147212602e-02f, -3.201831773e-02f, -3.615824912e-02f, +1.377863072e-02f, +5.132117457e-02f, +1.824304742e-02f, -4.484459721e-02f, -4.849847057e-02f, +1.634769870e-02f, +5.999465498e-02f, +2.080498068e-02f, -4.585323392e-02f, -4.753863481e-02f, +1.422608725e-02f, +5.146642279e-02f, +1.740833467e-02f, -3.426344755e-02f, -3.401883976e-02f, +8.846737837e-03f, +3.178324117e-02f, +1.051429880e-02f, -1.796245957e-02f, -1.702250600e-02f, +3.586754644e-03f, +1.313789281e-02f, +4.289874706e-03f, -5.854216783e-03f, -5.261385157e-03f, +6.893673036e-04f, +2.933686743e-03f, +9.775321364e-04f, -7.631469996e-04f, -6.405180286e-04f, -1.392979451e-04f,
    +7.791242229e-06f, -1.699747862e-05f, -7.662225966e-05f, -2.669496967e-05f, +1.449047117e-04f, +1.727947999e-04f, -1.305561128e-04f, -4.023534357e-04f, -9.039874540e-05f, +5.647600865e-04f, +5.477436456e-04f, -4.240808264e-04f, -1.062018502e-03f, -1.651246880e-04f, +1.272510612e-03f, +1.065857194e-03f, -8.561708638e-04f, -1.835368929e-03f, -1.913789724e-04f, +1.958317289e-03f, +1.447398043e-03f, -1.208034611e-03f, -2.265687070e-03f, -1.392905295e-04f, +2.184548817e-03f, +1.433272568e-03f, -1.242086964e-03f, -2.052511654e-03f, -4.697585680e-05f, +1.788458344e-03f, +1.036298510e-03f, -9.309185690e-04f, -1.349078811e-03f, +1.872481803e-05f, +1.047088999e-03f, +5.259403172e-04f, -4.875573858e-04f, -6.071675411e-04f, +3.044856647e-05f, +4.026596693e-04f, +1.674741398e-04f, -1.575038342e-04f, -1.590490714e-04f, +1.351057922e-05f, +7.865658953e-05f, +2.324588111e-05f, -1.989502124e-05f, -1.179515707e-05f,
    /*  6, 2 (48) */
    +4.818170991e-04f, +3.116677919e-04f, -8.139903245e-04f, -1.619438411e-03f, -1.795107547e-04f, +2.825764439e-03f, +3.302458664e-03f, -1.373904706e-03f, -6.820134096e-03f, -4.681795133e-03f, +5.958972806e-03f, +1.305464115e-02f, +3.849255791e-03f, -1.571149621e-02f, -2.106961728e-02f, +2.685047373e-03f, +3.409825556e-02f, +2.981813382e-02f, -2.299464232e-02f, -7.276822754e-02f, -3.914102041e-02f, +1.036708015e-01f, +2.809358285e-01f, +3.681470969e-01f, +2.991150230e-01f, +1.264314461e-01f, -2.668905536e-02f, -7.452424539e-02f, -3.106104140e-02f, +2.544284532e-02f, +3.631011958e-02f, +7.043774239e-03f, -1.964783298e-02f, -1.770976289e-02f, +1.575355201e-03f, +1.291394069e-02f, +7.381519323e-03f, -3.681607029e-03f, -7.108460287e-03f, -2.183697815e-03f, +2.988160346e-03f, +3.121529075e-03f, +1.707328174e-04f, -1.586700837e-03f, -9.769720453e-04f, +2.157125405e-04f, +5.093468306e-04f, +1.510931022e-04f,
    -8.344944653e-06f, +2.125900262e-05f, +4.148581872e-05f, -1.996438486e-06f, -8.307634195e-05f, -8.076243575e-05f, +6.431750700e-05f, +2.001270451e-04f, +9.285279645e-05f, -2.265601524e-04f, -3.652170240e-04f, -9.550274047e-06f, +5.399705649e-04f, +5.383887230e-04f, -2.757465103e-04f, -1.068544575e-03f, -6.500331626e-04f, +9.615381760e-04f, +2.023076302e-03f, +6.604188335e-04f, -2.824968759e-03f, -5.603687422e-03f, -4.787239382e-03f, -4.094699856e-04f, +4.284303580e-03f, +5.757022002e-03f, +3.396192524e-03f, -2.067797193e-04f, -1.996840788e-03f, -1.222587999e-03f, +4.496565782e-04f, +1.104004805e-03f, +4.347078605e-04f, -4.563697166e-04f, -5.937872373e-04f, -8.080645084e-05f, +3.433251790e-04f, +2.724298771e-04f, -5.019587769e-05f, -2.033930824e-04f, -9.273045181e-05f, +6.633507579e-05f, +9.155929989e-05f, +1.456911640e-05f, -3.964301044e-05f, -2.665905792e-05f, +5.265009118e-06f, +1.200722377e-05f,
    -4.818170991e-04f, -8.203301315e-04f, +7.453834406e-04f, +2.866501994e-03f, +1.138548671e-03f, -4.757536292e-03f, -6.282877715e-03f, +3.081180149e-03f, +1.292588768e-02f, +5.324990279e-03f, -1.543732735e-02f, -1.933738918e-02f, +7.339701665e-03f, +3.143316715e-02f, +1.274463663e-02f, -3.095246054e-02f, -3.701441998e-02f, +1.194326179e-02f, +5.112979559e-02f, +2.020136471e-02f, -4.339719917e-02f, -4.970650518e-02f, +1.408201163e-02f, +5.985536445e-02f, +2.298952949e-02f, -4.441996135e-02f, -4.878072178e-02f, +1.217357560e-02f, +5.141944693e-02f, +1.919679302e-02f, -3.322714904e-02f, -3.494975833e-02f, +7.497659026e-03f, +3.180196599e-02f, +1.156138780e-02f, -1.743651926e-02f, -1.751006338e-02f, +2.979587103e-03f, +1.316834138e-02f, +4.692534375e-03f, -5.686742643e-03f, -5.418888992e-03f, +5.303182322e-04f, +2.947197322e-03f, +1.056188726e-03f, -7.399011185e-04f, -6.604130498e-04f, -1.510931022e-04f,
    +8.344944653e-06f, -1.497788212e-05f, -7.570430487e-05f, -3.079791745e-05f, +1.398867490e-04f, +1.771339313e-04f, -1.182115470e-04f, -4.009414406e-04f, -1.095769468e-04f, +5.491324766e-04f, +5.656386610e-04f, -3.893998840e-04f, -1.063539538e-03f, -2.127017604e-04f, +1.243283477e-03f, +1.106992809e-03f, -7.939689928e-04f, -1.845114860e-03f, -2.697772798e-04f, +1.920891995e-03f, +1.511112825e-03f, -1.129233506e-03f, -2.285625305e-03f, -2.319039960e-04f, +2.150529871e-03f, +1.504220745e-03f, -1.169274842e-03f, -2.077684101e-03f, -1.270620581e-04f, +1.766968726e-03f, +1.093838693e-03f, -8.822973255e-04f, -1.370713898e-03f, -3.104888631e-05f, +1.038631332e-03f, +5.589661769e-04f, -4.653984841e-04f, -6.197011272e-04f, +9.754288189e-06f, +4.014176345e-04f, +1.796689918e-04f, -1.516552664e-04f, -1.634214139e-04f, +8.839925616e-06f, +7.907963685e-05f, +2.538057954e-05f, -1.947093683e-05f, -1.200722377e-05f,
    /*  6, 3 (48) */
    +4.734721544e-04f, +3.329267946e-04f, -7.725045058e-04f, -1.621434850e-03f, -2.625870966e-04f, +2.745002003e-03f, +3.366776171e-03f, -1.173777661e-03f, -6.727281299e-03f, -4.908355286e-03f, +5.593755782e-03f, +1.304509087e-02f, +4.389226356e-03f, -1.517310748e-02f, -2.134536379e-02f, +1.616502798e-03f, +3.344822240e-02f, +3.077967200e-02f, -2.097156602e-02f, -7.210780871e-02f, -4.196598917e-02f, +9.806711406e-02f, +2.761485891e-01f, +3.677376269e-01f, +3.033993266e-01f, +1.321884681e-01f, -2.329286284e-02f, -7.473102511e-02f, -3.305788219e-02f, +2.422025732e-02f, +3.675977616e-02f, +8.147779044e-03f, -1.921312512e-02f, -1.816613260e-02f, +9.815679637e-04f, +1.283313424e-02f, +7.724844502e-03f, -3.409177152e-03f, -7.158656165e-03f, -2.387090897e-03f, +2.895429894e-03f, +3.187864151e-03f, +2.622921173e-04f, -1.572131721e-03f, -1.016615056e-03f, +1.890534826e-04f, +5.146118397e-04f, +1.631003260e-04f,
    -8.867001001e-06f, +2.015064614e-05f, +4.164078698e-05f, +3.893731059e-07f, -8.110340390e-05f, -8.317205561e-05f, +5.860392582e-05f, +1.986664501e-04f, +1.006854710e-04f, -2.167794209e-04f, -3.679622505e-04f, -2.700047156e-05f, +5.273720285e-04f, +5.521306107e-04f, -2.438428143e-04f, -1.057459136e-03f, -6.862421796e-04f, +9.074804882e-04f, +2.020473974e-03f, +7.444424040e-04f, -2.708232495e-03f, -5.561444633e-03f, -4.876752428e-03f, -5.727871543e-04f, +4.173145228e-03f, +5.775748818e-03f, +3.507144024e-03f, -1.097997096e-04f, -1.983518747e-03f, -1.272423616e-03f, +4.059681292e-04f, +1.106921623e-03f, +4.660840266e-04f, -4.373853199e-04f, -6.025581680e-04f, -9.934083637e-05f, +3.373068931e-04f, +2.808863692e-04f, -4.102837087e-05f, -2.032037984e-04f, -9.832202803e-05f, +6.298515782e-05f, +9.294928507e-05f, +1.719037284e-05f, -3.905416716e-05f, -2.769579466e-05f, +4.557424696e-06f, +1.220112428e-05f,
    -4.734721544e-04f, -8.353080136e-04f, +6.696791358e-04f, +2.835704077e-03f, +1.278435420e-03f, -4.580402361e-03f, -6.401089262e-03f, +2.680238709e-03f, +1.281631074e-02f, +5.874122756e-03f, -1.487168869e-02f, -1.972678906e-02f, +6.276162127e-03f, +3.122046539e-02f, +1.398792011e-02f, -2.984546773e-02f, -3.780838897e-02f, +1.009814693e-02f, +5.086001831e-02f, +2.212225670e-02f, -4.188608634e-02f, -5.083573868e-02f, +1.179638632e-02f, +5.962346045e-02f, +2.514005936e-02f, -4.291574061e-02f, -4.994999662e-02f, +1.009589150e-02f, +5.129238488e-02f, +2.096376174e-02f, -3.213331035e-02f, -3.583205565e-02f, +6.126945128e-03f, +3.177091710e-02f, +1.260001913e-02f, -1.687755308e-02f, -1.797546187e-02f, +2.359885976e-03f, +1.317809567e-02f, +5.093952010e-03f, -5.507073651e-03f, -5.570544258e-03f, +3.668968183e-04f, +2.956037248e-03f, +1.135268363e-03f, -7.145205390e-04f, -6.798839867e-04f, -1.631003260e-04f,
    +8.867001001e-06f, -1.299514687e-05f, -7.467434777e-05f, -3.474788864e-05f, +1.347369482e-04f, +1.810927613e-04f, -1.058832189e-04f, -3.988940296e-04f, -1.283080387e-04f, +5.328163443e-04f, +5.824201054e-04f, -3.544548708e-04f, -1.063352654e-03f, -2.595467868e-04f, +1.212302398e-03f, +1.146114099e-03f, -7.308620442e-04f, -1.851908327e-03f, -3.474428399e-04f, +1.880564154e-03f, +1.572302999e-03f, -1.048783316e-03f, -2.301956556e-03f, -3.241475586e-04f, +2.113106202e-03f, +1.572906527e-03f, -1.094458265e-03f, -2.099656640e-03f, -2.072536508e-04f, +1.742583914e-03f, +1.149959854e-03f, -8.319648170e-04f, -1.390320562e-03f, -8.118132958e-05f, +1.028427323e-03f, +5.914290376e-04f, -4.422313454e-04f, -6.313807691e-04f, -1.124576621e-05f, +3.994890047e-04f, +1.917713026e-04f, -1.454358454e-04f, -1.676030986e-04f, +4.040278685e-06f, +7.936789852e-05f, +2.753519081e-05f, -1.898771574e-05f, -1.220112428e-05f,
    /*  6, 4 (48) */
    +4.646051534e-04f, +3.530774407e-04f, -7.308637188e-04f, -1.621045477e-03f, -3.436905005e-04f, +2.661829947e-03f, +3.425380097e-03f, -9.751112112e-04f, -6.626595828e-03f, -5.125134706e-03f, +5.225793532e-03f, +1.301809040e-02f, +4.916598384e-03f, -1.462097687e-02f, -2.158920660e-02f, +5.590436624e-04f, +3.276198022e-02f, +3.168715249e-02f, -1.895109204e-02f, -7.136336630e-02f, -4.467422166e-02f, +9.250566943e-02f, +2.712718367e-01f, +3.671648397e-01f, +3.075724718e-01f, +1.379642170e-01f, -1.978571881e-02f, -7.484082482e-02f, -3.504140093e-02f, +2.294783371e-02f, +3.716574429e-02f, +9.254700667e-03f, -1.874704109e-02f, -1.860351792e-02f, +3.790097958e-04f, +1.273379340e-02f, +8.062151396e-03f, -3.128290783e-03f, -7.199684535e-03f, -2.590294696e-03f, +2.797107866e-03f, +3.250849309e-03f, +3.552414023e-04f, -1.554941348e-03f, -1.055669223e-03f, +1.613576880e-04f, +5.191692644e-04f, +1.753014503e-04f,
    -9.357271131e-06f, +1.903768623e-05f, +4.172724070e-05f, +2.725517788e-06f, -7.904875357e-05f, -8.542047327e-05f, +5.289950351e-05f, +1.969499038e-04f, +1.082664692e-04f, -2.068337056e-04f, -3.701688128e-04f, -4.419347652e-05f, +5.142168205e-04f, +5.649642299e-04f, -2.120014881e-04f, -1.045109832e-03f, -7.210875415e-04f, +8.529817484e-04f, +2.015342221e-03f, +8.260940707e-04f, -2.590933072e-03f, -5.515480599e-03f, -4.962423244e-03f, -7.356340633e-04f, +4.058647023e-03f, +5.790390724e-03f, +3.616731638e-03f, -1.089945062e-05f, -1.967442276e-03f, -1.321292299e-03f, +3.611689990e-04f, +1.108393160e-03f, +4.972183318e-04f, -4.175739665e-04f, -6.106155420e-04f, -1.179745186e-04f, +3.307432576e-04f, +2.890674119e-04f, -3.167171449e-05f, -2.027235592e-04f, -1.038628378e-04f, +5.948545712e-05f, +9.422736517e-05f, +1.983931782e-05f, -3.839015022e-05f, -2.871302625e-05f, +3.820393667e-06f, +1.237592426e-05f,
    -4.646051534e-04f, -8.483031605e-04f, +5.950047880e-04f, +2.800956188e-03f, +1.413172369e-03f, -4.399309599e-03f, -6.506972481e-03f, +2.281344679e-03f, +1.268800270e-02f, +6.406939100e-03f, -1.428926858e-02f, -2.008124393e-02f, +5.212809473e-03f, +3.096091860e-02f, +1.520022250e-02f, -2.869935363e-02f, -3.853925102e-02f, +8.246238601e-03f, +5.051257547e-02f, +2.400282086e-02f, -4.031378334e-02f, -5.188452200e-02f, +9.494429766e-03f, +5.929931289e-02f, +2.725316557e-02f, -4.134283408e-02f, -5.104445488e-02f, +7.996234859e-03f, +5.108513123e-02f, +2.270634566e-02f, -3.098335049e-02f, -3.666402047e-02f, +4.736624566e-03f, +3.168973577e-02f, +1.362844645e-02f, -1.628612404e-02f, -1.841769321e-02f, +1.728505206e-03f, +1.316684990e-02f, +5.493441015e-03f, -5.315302348e-03f, -5.715980103e-03f, +1.992937197e-04f, +2.960077526e-03f, +1.214636261e-03f, -6.869853482e-04f, -6.988717024e-04f, -1.753014503e-04f,
    +9.357271131e-06f, -1.105218590e-05f, -7.353730115e-05f, -3.854121934e-05f, +1.294671807e-04f, +1.846715044e-04f, -9.359189777e-05f, -3.962243230e-04f, -1.465669659e-04f, +5.158472603e-04f, +5.980730325e-04f, -3.193054982e-04f, -1.061473822e-03f, -3.055900125e-04f, +1.179630067e-03f, +1.183171051e-03f, -6.669562287e-04f, -1.855752352e-03f, -4.242543686e-04f, +1.837407206e-03f, +1.630876849e-03f, -9.668149639e-04f, -2.314657752e-03f, -4.158741060e-04f, +2.072335209e-03f, +1.639216953e-03f, -1.017752442e-03f, -2.118384554e-03f, -2.874223964e-04f, +1.715329861e-03f, +1.204563872e-03f, -7.799916939e-04f, -1.407852481e-03f, -1.315937390e-04f, +1.016477841e-03f, +6.232697581e-04f, -4.180830575e-04f, -6.421763456e-04f, -3.252037081e-05f, +3.968666565e-04f, +2.037585732e-04f, -1.388496268e-04f, -1.715826333e-04f, -8.824424543e-07f, +7.951726066e-05f, +2.970587195e-05f, -1.844435346e-05f, -1.237592426e-05f,
    /*  6, 5 (48) */
    +4.552478823e-04f, +3.721151269e-04f, -6.891364781e-04f, -1.618319959e-03f, -4.227392541e-04f, +2.576409474e-03f, +3.478279600e-03f, -7.781613074e-04f, -6.518329359e-03f, -5.331968412e-03f, +4.855624719e-03f, +1.297389693e-02f, +5.430815205e-03f, -1.405601264e-02f, -2.180120809e-02f, -4.860661693e-04f, +3.204089267e-02f, +3.254013424e-02f, -1.693574982e-02f, -7.053727223e-02f, -4.726515474e-02f, +8.699018883e-02f, +2.663094135e-01f, +3.664292057e-01f, +3.116311188e-01f, +1.437546077e-01f, -1.616898718e-02f, -7.485172427e-02f, -3.700884321e-02f, +2.162654141e-02f, +3.752691329e-02f, +1.036309383e-02f, -1.824982276e-02f, -1.902109189e-02f, -2.316057463e-04f, +1.261581888e-02f, +8.392894653e-03f, -2.839223371e-03f, -7.231356250e-03f, -2.793018255e-03f, +2.693245028e-03f, +3.310334766e-03f, +4.494687675e-04f, -1.535102030e-03f, -1.094059373e-03f, +1.326446617e-04f, +5.229896581e-04f, +1.876773745e-04f,
    -9.815677156e-06f, +1.792213212e-05f, +4.174651130e-05f, +5.009354660e-06f, -7.691695648e-05f, -8.750709462e-05f, +4.721233222e-05f, +1.949836418e-04f, +1.155886614e-04f, -1.967390650e-04f, -3.718405999e-04f, -6.110897977e-05f, +5.005295418e-04f, +5.768832206e-04f, -1.802641175e-04f, -1.031528156e-03f, -7.545412919e-04f, +7.981162878e-04f, +2.007723215e-03f, +9.053210094e-04f, -2.473184673e-03f, -5.465860778e-03f, -5.044194584e-03f, -8.978771603e-04f, +3.940894468e-03f, +5.800910076e-03f, +3.724842225e-03f, +8.984542406e-05f, -1.948589975e-03f, -1.369119190e-03f, +3.153032321e-04f, +1.108399673e-03f, +5.280660766e-04f, -3.969525186e-04f, -6.179395883e-04f, -1.366829950e-04f, +3.236363777e-04f, +2.969577884e-04f, -2.213655910e-05f, -2.019487425e-04f, -1.093439878e-04f, +5.583866130e-05f, +9.538957497e-05f, +2.251234812e-05f, -3.765042989e-05f, -2.970854302e-05f, +3.054515381e-06f, +1.253070546e-05f,
    -4.552478823e-04f, -8.593553464e-04f, +5.214674869e-04f, +2.762414969e-03f, +1.542639549e-03f, -4.214638095e-03f, -6.600564379e-03f, +1.885120356e-03f, +1.254143573e-02f, +6.922786361e-03f, -1.369119555e-02f, -2.040054943e-02f, +4.151335652e-03f, +3.065532859e-02f, +1.637985257e-02f, -2.751618258e-02f, -3.920620725e-02f, +6.390486249e-03f, +5.008832111e-02f, +2.584022806e-02f, -3.868290649e-02f, -5.285133696e-02f, +7.179772015e-03f, +5.888343879e-02f, +2.932550077e-02f, -3.970361713e-02f, -5.206220732e-02f, +5.877850305e-03f, +5.079770883e-02f, +2.442167552e-02f, -2.977878662e-02f, -3.744401216e-02f, +3.328772085e-03f, +3.155814203e-02f, +1.464492429e-02f, -1.566285428e-02f, -1.883577627e-02f, +1.086328861e-03f, +1.313432953e-02f, +5.890307671e-03f, -5.111543775e-03f, -5.854829730e-03f, +2.771108642e-05f, +2.959195084e-03f, +1.294153522e-03f, -6.572794762e-04f, -7.173160559e-04f, -1.876773745e-04f,
    +9.815677156e-06f, -9.151747540e-06f, -7.229816771e-05f, -4.217462308e-05f, +1.240893005e-04f, +1.878710499e-04f, -8.135794825e-05f, -3.929463207e-04f, -1.643298167e-04f, +4.982614622e-04f, +6.125845522e-04f, -2.840112181e-04f, -1.057921668e-03f, -3.507635665e-04f, +1.145331498e-03f, +1.218117339e-03f, -6.023584774e-04f, -1.856654741e-03f, -5.000924368e-04f, +1.791498952e-03f, +1.686747109e-03f, -8.834616194e-04f, -2.323711714e-03f, -5.069373762e-04f, +2.028279749e-03f, +1.703042750e-03f, -9.392758951e-04f, -2.133828266e-03f, -3.674396180e-04f, +1.685237321e-03f, +1.257554585e-03f, -7.264517373e-04f, -1.423266428e-03f, -1.822062518e-04f, +1.002786671e-03f, +6.544296547e-04f, -3.929826645e-04f, -6.520588780e-04f, -5.403740792e-05f, +3.935445733e-04f, +2.156081422e-04f, -1.319014032e-04f, -1.753486718e-04f, -5.921951639e-06f, +7.952378569e-05f, +3.188863867e-05f, -1.783995335e-05f, -1.253070546e-05f,
    /*  6, 6 (48) */
    +4.454322052e-04f, +3.900372591e-04f, -6.473899668e-04f, -1.613310604e-03f, -4.996562106e-04f, +2.488902380e-03f, +3.525491932e-03f, -5.831776656e-04f, -6.402740698e-03f, -5.528707477e-03f, +4.483784119e-03f, +1.291278795e-02f, +5.931344747e-03f, -1.347912942e-02f, -2.198147221e-02f, -1.517594326e-03f, +3.128635138e-02f, +3.333825052e-02f, -1.492802661e-02f, -6.963195122e-02f, -4.973833941e-02f, +8.152432805e-02f, +2.612652189e-01f, +3.655313285e-01f, +3.155720133e-01f, +1.495555178e-01f, -1.244414495e-02f, -7.476187885e-02f, -3.895743318e-02f, +2.025742222e-02f, +3.784221652e-02f, +1.147149350e-02f, -1.772175668e-02f, -1.941804441e-02f, -8.495453346e-04f, +1.247913589e-02f, +8.716531031e-03f, -2.542265583e-03f, -7.253492809e-03f, -2.994966997e-03f, +2.583901040e-03f, +3.366173427e-03f, +5.448583425e-04f, -1.512589682e-03f, -1.131709803e-03f, +1.029361187e-04f, +5.260441735e-04f, +2.002080800e-04f,
    -1.024220231e-05f, +1.680595422e-05f, +4.170001406e-05f, +7.238374544e-06f, -7.471261742e-05f, -8.943157738e-05f, +4.155035540e-05f, +1.927741706e-04f, +1.226453846e-04f, -1.865115568e-04f, -3.729821955e-04f, -7.772730152e-05f, +4.863352246e-04f, +5.878825260e-04f, -1.486716681e-04f, -1.016746838e-03f, -7.865775689e-04f, +7.429579806e-04f, +1.997661437e-03f, +9.820734400e-04f, -2.355101077e-03f, -5.412653779e-03f, -5.122012995e-03f, -1.059383497e-03f, +3.819976279e-03f, +5.807272982e-03f, +3.831363317e-03f, +1.923566759e-04f, -1.926943287e-03f, -1.415829765e-03f, +2.684167601e-04f, +1.106923101e-03f, +5.585824193e-04f, -3.755391344e-04f, -6.245113053e-04f, -1.554413590e-04f, +3.159891480e-04f, +3.045424952e-04f, -1.243395811e-05f, -2.008761034e-04f, -1.147565375e-04f, +5.204772384e-05f, +9.643206018e-05f, +2.520575530e-05f, -3.683459133e-05f, -3.068012551e-05f, +2.260456842e-06f, +1.266456791e-05f,
    -4.454322052e-04f, -8.685070939e-04f, +4.491693191e-04f, +2.720240346e-03f, +1.666728850e-03f, -4.026767045e-03f, -6.681922327e-03f, +1.492174035e-03f, +1.237710592e-02f, +7.421047823e-03f, -1.307861100e-02f, -2.068456065e-02f, +3.093413984e-03f, +3.030456503e-02f, +1.752518407e-02f, -2.629806524e-02f, -3.980856572e-02f, +4.533831508e-03f, +4.958822867e-02f, +2.763172701e-02f, -3.699615939e-02f, -5.373479858e-02f, +4.856060301e-03f, +5.837650141e-02f, +3.135378052e-02f, -3.800057438e-02f, -5.300148322e-02f, +3.744022040e-03f, +5.043026921e-02f, +2.610691284e-02f, -2.852123204e-02f, -3.817046390e-02f, +1.905505657e-03f, +3.137593578e-02f, +1.564771096e-02f, -1.500842463e-02f, -1.922875894e-02f, +4.342699829e-04f, +1.308029212e-02f, +6.283852244e-03f, -4.895935633e-03f, -5.986731133e-03f, -1.476375854e-04f, +2.953273132e-03f, +1.373677308e-03f, -6.253908375e-04f, -7.351560092e-04f, -2.002080800e-04f,
    +1.024220231e-05f, -7.296413674e-06f, -7.096202782e-05f, -4.564518926e-05f, +1.186151225e-04f, +1.906929491e-04f, -6.920130012e-05f, -3.890748647e-04f, -1.815738499e-04f, +4.800957835e-04f, +6.259438306e-04f, -2.486311244e-04f, -1.052717418e-03f, -3.950015605e-04f, +1.109473904e-03f, +1.250910379e-03f, -5.371762618e-04f, -1.854628048e-03f, -5.748396599e-04f, +1.742921408e-03f, +1.739831097e-03f, -7.988584839e-04f, -2.329107182e-03f, -5.971921956e-04f, +1.981008035e-03f, +1.764278523e-03f, -8.591502741e-04f, -2.145953423e-03f, -4.471764115e-04f, +1.652341818e-03f, +1.308837966e-03f, -6.714217553e-04f, -1.436522367e-03f, -2.329380412e-04f, +9.873605329e-04f, +6.848506056e-04f, -3.669611382e-04f, -6.610005937e-04f, -7.576391290e-05f, +3.895178720e-04f, +2.272972249e-04f, -1.245967078e-04f, -1.788900391e-04f, -1.107160032e-05f, +7.938372451e-05f, +3.407937034e-05f, -1.717373175e-05f, -1.266456791e-05f,
    /*  6, 7 (48) */
    +4.351900028e-04f, +4.068432133e-04f, -6.056899527e-04f, -1.606072230e-03f, -5.743688280e-04f, +2.399470802e-03f, +3.567042288e-03f, -3.904034950e-04f, -6.280095313e-03f, -5.715219034e-03f, +4.110801924e-03f, +1.283506064e-02f, +6.417679971e-03f, -1.289124690e-02f, -2.213014388e-02f, -2.534341164e-03f, +3.049977381e-02f, +3.408120850e-02f, -1.293036517e-02f, -6.864987778e-02f, -5.209344049e-02f, +7.611167427e-02f, +2.561432059e-01f, +3.644719450e-01f, +3.193919896e-01f, +1.553627907e-01f, -8.612781634e-03f, -7.456952217e-02f, -4.088437647e-02f, +1.884159245e-02f, +3.811063328e-02f, +1.257841660e-02f, -1.716317426e-02f, -1.979358354e-02f, -1.474056640e-03f, +1.232369453e-02f, +9.032520179e-03f, -2.237723088e-03f, -7.265926767e-03f, -3.195843101e-03f, +2.469144503e-03f, +3.418221151e-03f, +6.412904027e-04f, -1.487383927e-03f, -1.168544394e-03f, +7.225599318e-05f, +5.283046303e-04f, +2.128726479e-04f,
    -1.063688973e-05f, +1.569108148e-05f, +4.158924427e-05f, +9.410201707e-06f, -7.244037263e-05f, -9.119382763e-05f, +3.592135816e-05f, +1.903282540e-04f, +1.294304454e-04f, -1.761672149e-04f, -3.735988633e-04f, -9.402941106e-05f, +4.716592936e-04f, +5.979583844e-04f, -1.172644383e-04f, -1.000799786e-03f, -8.171726146e-04f, +6.875801614e-04f, +1.985203607e-03f, +1.056304658e-03f, -2.236795531e-03f, -5.355931279e-03f, -5.195828866e-03f, -1.220020865e-03f, +3.695984295e-03f, +5.809449348e-03f, +3.936183247e-03f, +2.965535273e-04f, -1.902486547e-03f, -1.461349932e-03f, +2.205573646e-04f, +1.103947105e-03f, +5.887224336e-04f, -3.533532580e-04f, -6.303124963e-04f, -1.742243306e-04f, +3.078052584e-04f, +3.118067665e-04f, -2.575357107e-06f, -1.995027847e-04f, -1.200915124e-04f, +4.811586372e-05f, +9.735108524e-05f, +2.791572988e-05f, -3.594233741e-05f, -3.162554815e-05f, +1.438952877e-06f, +1.277663204e-05f,
    -4.351900028e-04f, -8.758035076e-04f, +3.782072913e-04f, +2.674595157e-03f, +1.785343972e-03f, -3.836074096e-03f, -6.751123627e-03f, +1.103099171e-03f, +1.219553207e-02f, +7.901143606e-03f, -1.245266717e-02f, -2.093319177e-02f, +2.040696565e-03f, +2.990956347e-02f, +1.863465797e-02f, -2.504715486e-02f, -4.034574199e-02f, +2.679203460e-03f, +4.901338901e-02f, +2.937464842e-02f, -3.525632829e-02f, -5.453365707e-02f, +2.526953119e-03f, +5.777930921e-02f, +3.333478856e-02f, -3.623629586e-02f, -5.386063349e-02f, +1.598068617e-03f, +4.998309280e-02f, +2.775925466e-02f, -2.721239407e-02f, -3.884188566e-02f, +4.689832901e-04f, +3.114299774e-02f, +1.663507149e-02f, -1.432357402e-02f, -1.959572007e-02f, -2.267306108e-04f, +1.300452821e-02f, +6.673370117e-03f, -4.668638408e-03f, -6.111327841e-03f, -3.265276245e-04f, +2.942201532e-03f, +1.453061032e-03f, -5.913114672e-04f, -7.523297410e-04f, -2.128726479e-04f,
    +1.063688973e-05f, -5.488598499e-06f, -6.953402739e-05f, -4.895038091e-05f, +1.130564007e-04f, +1.931394007e-04f, -5.714141947e-05f, -3.846256007e-04f, -1.982775184e-04f, +4.613875835e-04f, +6.381420856e-04f, -2.132238567e-04f, -1.045884839e-03f, -4.382401831e-04f, +1.072126567e-03f, +1.281511380e-03f, -4.715174124e-04f, -1.849689529e-03f, -6.483808839e-04f, +1.691760662e-03f, +1.790050839e-03f, -7.131425620e-04f, -2.330838826e-03f, -6.864947182e-04f, +1.930593536e-03f, +1.822822929e-03f, -7.775001628e-04f, -2.154730967e-03f, -5.265038580e-04f, +1.616683612e-03f, +1.358322287e-03f, -6.149814725e-04f, -1.447583542e-03f, -2.837074452e-04f, +9.702090995e-04f, +7.144751560e-04f, -3.400513450e-04f, -6.689749892e-04f, -9.766612121e-05f, +3.847828278e-04f, +2.388029525e-04f, -1.169418174e-04f, -1.821957554e-04f, -1.632438305e-05f, +7.909352851e-05f, +3.627381541e-05f, -1.644502299e-05f, -1.277663204e-05f,
    /*  6, 8 (48) */
    +4.245531131e-04f, +4.225342948e-04f, -5.641007085e-04f, -1.596662028e-03f, -6.468092006e-04f, +2.308276975e-03f, +3.602963646e-03f, -2.000752410e-04f, -6.150664868e-03f, -5.891386249e-03f, +3.737203061e-03f, +1.274103123e-02f, +6.889339265e-03f, -1.229328851e-02f, -2.224740832e-02f, -3.535140950e-03f, +2.968260120e-02f, +3.476878867e-02f, -1.094516156e-02f, -6.759357313e-02f, -5.433023602e-02f, +7.075574299e-02f, +2.509473770e-01f, +3.632519241e-01f, +3.230879739e-01f, +1.611722401e-01f, -4.676598387e-03f, -7.427296864e-02f, -4.278686302e-02f, +1.738024252e-02f, +3.833119065e-02f, +1.368236371e-02f, -1.657445183e-02f, -2.014693680e-02f, -2.104369136e-03f, +1.214947020e-02f, +9.340325437e-03f, -1.925916321e-03f, -7.268502124e-03f, -3.395345886e-03f, +2.349052990e-03f, +3.466337015e-03f, +7.386414879e-04f, -1.459468197e-03f, -1.204486732e-03f, +4.063044502e-05f, +5.297435832e-04f, +2.256492799e-04f,
    -1.099984113e-05f, +1.457939881e-05f, +4.141577321e-05f, +1.152259533e-05f, -7.010488204e-05f, -9.279399612e-05f, +3.033295803e-05f, +1.876528999e-04f, +1.359381228e-04f, -1.657220273e-04f, -3.736965314e-04f, -1.099969455e-04f, +4.565275267e-04f, +6.071083201e-04f, -8.608201384e-05f, -9.837220297e-04f, -8.463047818e-04f, +6.320555428e-04f, +1.970398609e-03f, +1.127971061e-03f, -2.118380642e-03f, -5.295767933e-03f, -5.265596469e-03f, -1.379657921e-03f, +3.569013395e-03f, +5.807412922e-03f, +4.039191267e-03f, +4.023527308e-04f, -1.875207023e-03f, -1.505606117e-03f, +1.717746382e-04f, +1.099457111e-03f, +6.184411672e-04f, -3.304156074e-04f, -6.353258038e-04f, -1.930062863e-04f, +2.990891982e-04f, +3.187360982e-04f, +7.427417591e-06f, -1.978263266e-04f, -1.253399165e-04f, +4.404656456e-05f, +9.814304120e-05f, +3.063836572e-05f, -3.497349141e-05f, -3.254258310e-05f, +5.908061777e-07f, +1.286604092e-05f,
    -4.245531131e-04f, -8.812921061e-04f, +3.086732639e-04f, +2.625644776e-03f, +1.898400373e-03f, -3.642934695e-03f, -6.808265047e-03f, +7.184735700e-04f, +1.199725455e-02f, +8.362531190e-03f, -1.181452508e-02f, -2.114641563e-02f, +9.948117267e-04f, +2.947132328e-02f, +1.970678454e-02f, -2.376564348e-02f, -4.081725940e-02f, +8.295139303e-04f, +4.836500812e-02f, +3.106640908e-02f, -3.346627745e-02f, -5.524679963e-02f, +1.961142931e-04f, +5.709281450e-02f, +3.526538209e-02f, -3.441347293e-02f, -5.463813366e-02f, -5.566623497e-04f, +4.945658894e-02f, +2.937593827e-02f, -2.585407178e-02f, -3.945686713e-02f, -9.786002519e-04f, +3.085929029e-02f, +1.760528059e-02f, -1.360909887e-02f, -1.993577142e-02f, -8.957056000e-04f, +1.290686209e-02f, +7.058152944e-03f, -4.429835456e-03f, -6.228269659e-03f, -5.087233799e-04f, +2.925877149e-03f, +1.532154561e-03f, -5.550376518e-04f, -7.687747640e-04f, -2.256492799e-04f,
    +1.099984113e-05f, -3.730547622e-06f, -6.801936589e-05f, -5.208803166e-05f, +1.074248073e-04f, +1.952132355e-04f, -4.519728111e-05f, -3.796149388e-04f, -2.144204917e-04f, +4.421746762e-04f, +6.491725796e-04f, -1.778475050e-04f, -1.037450173e-03f, -4.804177901e-04f, +1.033360712e-03f, +1.309885380e-03f, -4.054899386e-04f, -1.841861095e-03f, -7.206033657e-04f, +1.638106717e-03f, +1.837333188e-03f, -6.264524348e-04f, -2.328907250e-03f, -7.747026606e-04f, +1.877114848e-03f, +1.878578852e-03f, -6.944528796e-04f, -2.160137196e-03f, -6.052932368e-04f, +1.578307649e-03f, +1.405918285e-03f, -5.572134148e-04f, -1.456416562e-03f, -3.344320979e-04f, +9.513450014e-04f, +7.432466222e-04f, -3.122880098e-04f, -6.759568904e-04f, -1.197095174e-04f, +3.793368971e-04f, +2.501024122e-04f, -1.089437530e-04f, -1.852550607e-04f, -2.167294376e-05f, +7.864986146e-05f, +3.846759729e-05f, -1.565328426e-05f, -1.286604092e-05f,
    /*  6, 9 (48) */
    +4.135532720e-04f, +4.371136936e-04f, -5.226849353e-04f, -1.585139433e-03f, -7.169140826e-04f, +2.215482978e-03f, +3.633296604e-03f, -1.242234118e-05f, -6.014726745e-03f, -6.057108276e-03f, +3.363506529e-03f, +1.263103429e-02f, +7.345866792e-03f, -1.168618019e-02f, -2.233349033e-02f, -4.518862979e-03f, +2.883629642e-02f, +3.540084421e-02f, -8.974762953e-03f, -6.646560206e-02f, -5.644861666e-02f, +6.545997506e-02f, +2.456817806e-01f, +3.618722662e-01f, +3.266569873e-01f, +1.669796530e-01f, -6.374071197e-04f, -7.387061591e-02f, -4.466207004e-02f, +1.587463640e-02f, +3.850296528e-02f, +1.478182082e-02f, -1.595601066e-02f, -2.047735241e-02f, -2.739694940e-03f, +1.195646391e-02f, +9.639414635e-03f, -1.607180223e-03f, -7.261074707e-03f, -3.593172212e-03f, +2.223713074e-03f, +3.510383580e-03f, +8.367845291e-04f, -1.428829831e-03f, -1.239460223e-03f, +8.087861927e-06f, +5.303343893e-04f, +2.385153209e-04f,
    -1.133121540e-05f, +1.347274469e-05f, +4.118124412e-05f, +1.357345076e-05f, -6.771082165e-05f, -9.423247423e-05f, +2.479259607e-05f, +1.847553464e-04f, +1.421631704e-04f, -1.551919137e-04f, -3.732817758e-04f, -1.256122270e-04f, +4.409660155e-04f, +6.153311316e-04f, -5.516322276e-05f, -9.655496663e-04f, -8.739545383e-04f, +5.764561357e-04f, +1.953297415e-03f, +1.197032172e-03f, -1.999968260e-03f, -5.232241289e-03f, -5.331273993e-03f, -1.538164326e-03f, +3.439161406e-03f, +5.801141337e-03f, +4.140277667e-03f, +5.096686415e-04f, -1.845094954e-03f, -1.548525361e-03f, +1.221199429e-04f, +1.093440348e-03f, +6.476937013e-04f, -3.067481615e-04f, -6.395347426e-04f, -2.117612916e-04f, +2.898462597e-04f, +3.253162721e-04f, +1.756217103e-05f, -1.958446757e-04f, -1.304927459e-04f, +3.984357343e-05f, +9.880445341e-05f, +3.336966467e-05f, -3.392799952e-05f, -3.342900398e-05f, -2.831127739e-07f, +1.293196236e-05f,
    -4.135532720e-04f, -8.850226537e-04f, +2.406538980e-04f, +2.573556744e-03f, +2.005825180e-03f, -3.447721460e-03f, -6.853462328e-03f, +3.388586312e-04f, +1.178283406e-02f, +8.804705866e-03f, -1.116535250e-02f, -2.132426314e-02f, -4.263844613e-05f, +2.899090549e-02f, +2.074014525e-02f, -2.245575810e-02f, -4.122274934e-02f, -1.012347165e-03f, +4.764440476e-02f, +3.270451580e-02f, -3.162894426e-02f, -5.587325206e-02f, -2.132792957e-03f, +5.631811183e-02f, +3.714249694e-02f, -3.253489408e-02f, -5.533258654e-02f, -2.716799546e-03f, +4.885129570e-02f, +3.095424592e-02f, -2.444815350e-02f, -4.001408054e-02f, -2.435016814e-03f, +3.052485820e-02f, +1.855662560e-02f, -1.286585224e-02f, -2.024805943e-02f, -1.571662490e-03f, +1.278715257e-02f, +7.437489841e-03f, -4.179733044e-03f, -6.337213412e-03f, -6.939784406e-04f, +2.904204205e-03f, +1.610804422e-03f, -5.165700545e-04f, -7.844280482e-04f, -2.385153209e-04f,
    +1.133121540e-05f, -2.024337558e-06f, -6.642328452e-05f, -5.505634216e-05f, +1.017319127e-04f, +1.969179001e-04f, -3.338734227e-05f, -3.740600133e-04f, -2.299836744e-04f, +4.224952597e-04f, +6.590306087e-04f, -1.425595170e-04f, -1.027442075e-03f, -5.214749907e-04f, +9.932493695e-04f, +1.336001281e-03f, -3.392018486e-04f, -1.831169253e-03f, -7.913969501e-04f, +1.582053332e-03f, +1.881609933e-03f, -5.389280292e-04f, -2.323318986e-03f, -8.616755363e-04f, +1.820655579e-03f, +1.931453568e-03f, -6.101382732e-04f, -2.162153822e-03f, -6.834162386e-04f, +1.537263510e-03f, +1.451539319e-03f, -4.982027884e-04f, -1.462991477e-03f, -3.850290623e-04f, +9.307838329e-04f, +7.711091956e-04f, -2.837076758e-04f, -6.819225126e-04f, -1.418588860e-04f, +3.731787393e-04f, +2.611726881e-04f, -1.006102801e-04f, -1.880574393e-04f, -2.710958291e-05f, +7.804961113e-05f, +4.065622061e-05f, -1.479810028e-05f, -1.293196236e-05f,
    /*  6,10 (48) */
    +4.022220566e-04f, +4.505864383e-04f, -4.815036912e-04f, -1.571565982e-03f, -7.846249043e-04f, +2.121250504e-03f, +3.658089200e-03f, +1.723330052e-04f, -5.872563574e-03f, -6.212300190e-03f, +2.990224753e-03f, +1.250542206e-02f, +7.786832807e-03f, -1.107084906e-02f, -2.238865355e-02f, -5.484412646e-03f, +2.796234188e-02f, +3.597730034e-02f, -7.021465538e-03f, -6.526856989e-02f, -5.844858492e-02f, +6.022773377e-02f, +2.403505066e-01f, +3.603341019e-01f, +3.300961487e-01f, +1.727807943e-01f, +3.502870548e-03f, -7.336094727e-02f, -4.650716500e-02f, +1.432611104e-02f, +3.862508523e-02f, +1.587526117e-02f, -1.530831696e-02f, -2.078410057e-02f, -3.379229683e-03f, +1.174470262e-02f, +9.929260895e-03f, -1.281863951e-03f, -7.243512536e-03f, -3.789016888e-03f, +2.093220328e-03f, +3.550227153e-03f, +9.355889825e-04f, -1.395460166e-03f, -1.273388223e-03f, -2.534114206e-05f, +5.300512766e-04f, +2.514472832e-04f,
    -1.163122716e-05f, +1.237290880e-05f, +4.088736808e-05f, +1.556080047e-05f, -6.526287593e-05f, -9.550988961e-05f, +1.930752840e-05f, +1.816430483e-04f, +1.481008172e-04f, -1.445927038e-04f, -3.723618031e-04f, -1.408582796e-04f, +4.250011263e-04f, +6.226268793e-04f, -2.454609306e-05f, -9.463197984e-04f, -9.001044679e-04f, +5.208531702e-04f, +1.933953010e-03f, +1.263450662e-03f, -1.881669363e-03f, -5.165431691e-03f, -5.392823581e-03f, -1.695410871e-03f, +3.306529007e-03f, +5.790616145e-03f, +4.239333900e-03f, +6.184132929e-04f, -1.812143592e-03f, -1.590035406e-03f, +7.164636522e-05f, +1.085885881e-03f, +6.764352098e-04f, -2.823741443e-04f, -6.429237330e-04f, -2.304631328e-04f, +2.800825408e-04f, +3.315333797e-04f, +2.781635243e-05f, -1.935561938e-04f, -1.355410019e-04f, +3.551089913e-05f, +9.933198915e-05f, +3.610554137e-05f, -3.280593321e-05f, -3.428258992e-05f, -1.181865908e-06f, +1.297359113e-05f,
    -4.022220566e-04f, -8.870469913e-04f, +1.742306135e-04f, +2.518500402e-03f, +2.107557093e-03f, -3.250803560e-03f, -6.886849670e-03f, -3.520138210e-05f, +1.155285038e-02f, +9.227201126e-03f, -1.050632189e-02f, -2.146682265e-02f, -1.070080522e-03f, +2.846943050e-02f, +2.173339462e-02f, -2.111975682e-02f, -4.156195119e-02f, -2.843516418e-03f, +4.685300781e-02f, +3.428656913e-02f, -2.974733433e-02f, -5.641218009e-02f, -4.456111943e-03f, +5.545643630e-02f, +3.896315252e-02f, -3.060344051e-02f, -5.594272481e-02f, -4.878953368e-03f, +4.816787947e-02f, +3.249150943e-02f, -2.299661418e-02f, -4.051228333e-02f, -3.898008290e-03f, +3.013982913e-02f, +1.948740943e-02f, -1.209474305e-02f, -2.053176710e-02f, -2.253585003e-03f, +1.264529368e-02f, +7.810668581e-03f, -3.918560355e-03f, -6.437823692e-03f, -8.820358799e-04f, +2.877094622e-03f, +1.688854033e-03f, -4.759138339e-04f, -7.992261485e-04f, -2.514472832e-04f,
    +1.163122716e-05f, -3.718756133e-07f, -6.475105451e-05f, -5.785387577e-05f, +9.598916518e-05f, +1.982574397e-04f, -2.172951773e-05f, -3.679786417e-04f, -2.449492238e-04f, +4.023878455e-04f, +6.677134881e-04f, -1.074166071e-04f, -1.015891543e-03f, -5.613547283e-04f, +9.518672422e-04f, +1.359831878e-03f, -2.727609708e-04f, -1.817645040e-03f, -8.606542412e-04f, +1.523697855e-03f, +1.922817896e-03f, -4.507103864e-04f, -2.314086478e-03f, -9.472748852e-04f, +1.761304204e-03f, +1.981358900e-03f, -5.246885145e-04f, -2.160768010e-03f, -7.607451793e-04f, +1.493605346e-03f, +1.495101536e-03f, -4.380373535e-04f, -1.467281854e-03f, -4.354149662e-04f, +9.085441513e-04f, +7.980080470e-04f, -2.543486610e-04f, -6.868495175e-04f, -1.640783646e-04f, +3.663082355e-04f, +2.719909026e-04f, -9.194990665e-05f, -1.905926445e-04f, -3.262626545e-05f, +7.728990083e-05f, +4.283507783e-05f, -1.387918782e-05f, -1.297359113e-05f,
    /*  6,11 (48) */
    +3.905908294e-04f, +4.629593471e-04f, -4.406163231e-04f, -1.556005181e-03f, -8.498877802e-04f, +2.025740615e-03f, +3.677396728e-03f, +3.539760536e-04f, -5.724462757e-03f, -6.356892894e-03f, +2.617862950e-03f, +1.236456378e-02f, +8.211833933e-03f, -1.044822218e-02f, -2.241319965e-02f, -6.430732444e-03f, +2.706223741e-02f, +3.649815351e-02f, -5.087512528e-03f, -6.400511923e-02f, -6.033025428e-02f, +5.506230208e-02f, +2.349576830e-01f, +3.586386910e-01f, +3.334026777e-01f, +1.785714105e-01f, +7.742204448e-03f, -7.274253398e-02f, -4.831930859e-02f, +1.273607564e-02f, +3.869673159e-02f, +1.696114705e-02f, -1.463188175e-02f, -2.106647472e-02f, -4.022153416e-03f, +1.151423949e-02f, +1.020934344e-02f, -9.503305711e-04f, -7.215696183e-03f, -3.982573082e-03f, +1.957679326e-03f, +3.585738052e-03f, +1.034920972e-03f, -1.359354625e-03f, -1.306194156e-03f, -5.962373197e-05f, +5.288694107e-04f, +2.644208743e-04f,
    -1.190014518e-05f, +1.128162992e-05f, +4.053591994e-05f, +1.748281484e-05f, -6.276573041e-05f, -9.662710150e-05f, +1.388481807e-05f, +1.783236627e-04f, +1.537467684e-04f, -1.339401158e-04f, -3.709444324e-04f, -1.557188438e-04f, +4.086594606e-04f, +6.289968711e-04f, +5.732189004e-06f, -9.260704767e-04f, -9.247392699e-04f, +4.653170186e-04f, +1.912420313e-03f, +1.327192362e-03f, -1.763593947e-03f, -5.095422190e-03f, -5.450211354e-03f, -1.851269606e-03f, +3.171219637e-03f, +5.775822850e-03f, +4.336252698e-03f, +7.284964753e-04f, -1.776349229e-03f, -1.630064794e-03f, +2.040866966e-05f, +1.076784649e-03f, +7.046210202e-04f, -2.573180078e-04f, -6.454781322e-04f, -2.490853503e-04f, +2.698049460e-04f, +3.373738461e-04f, +3.817706870e-05f, -1.909596659e-04f, -1.404757048e-04f, +3.105281016e-05f, +9.972246519e-05f, +3.884182833e-05f, -3.160749143e-05f, -3.510112941e-05f, -2.104447899e-06f, +1.299015110e-05f,
    -3.905908294e-04f, -8.874188669e-04f, +1.094795590e-04f, +2.460646526e-03f, +2.203546258e-03f, -3.052546120e-03f, -6.908579188e-03f, -4.031800238e-04f, +1.130790116e-02f, +9.629588971e-03f, -9.838608406e-03f, -2.157423926e-02f, -2.085972064e-03f, +2.790807577e-02f, +2.268526186e-02f, -1.975992494e-02f, -4.183471216e-02f, -4.661161458e-03f, +4.599235357e-02f, +3.581026699e-02f, -2.782451643e-02f, -5.686289048e-02f, -6.770198421e-03f, +5.450916141e-02f, +4.072445673e-02f, -2.862208161e-02f, -5.646741332e-02f, -7.039721378e-03f, +4.740713429e-02f, +3.398511477e-02f, -2.150151264e-02f, -4.095032069e-02f, -5.365290145e-03f, +2.970441417e-02f, +2.039595358e-02f, -1.129673500e-02f, -2.078611577e-02f, -2.940434520e-03f, +1.248121532e-02f, +8.176976816e-03f, -3.646569453e-03f, -6.529773598e-03f, -1.072628524e-03f, +2.844468357e-03f, +1.766143934e-03f, -4.330787560e-04f, -8.131053364e-04f, -2.644208743e-04f,
    +1.190014518e-05f, +1.225099856e-06f, -6.300796565e-05f, -6.047955359e-05f, +9.020787174e-05f, +1.992364803e-04f, -1.024115626e-05f, -3.613892836e-04f, -2.593005639e-04f, +3.818911886e-04f, +6.752205347e-04f, -7.247466745e-05f, -1.002831839e-03f, -6.000023574e-04f, +9.092905707e-04f, +1.381353880e-03f, -2.062747762e-04f, -1.801323952e-03f, -9.282707680e-04f, +1.463141052e-03f, +1.960899026e-03f, -3.619414277e-04f, -2.301228055e-03f, -1.031364501e-03f, +1.699153931e-03f, +2.028211372e-03f, -4.382378834e-04f, -2.155972421e-03f, -8.371532126e-04f, +1.447391809e-03f, +1.536524015e-03f, -3.768072929e-04f, -1.469264846e-03f, -4.855061388e-04f, +8.846474702e-04f, +8.238894287e-04f, -2.242510113e-04f, -6.907170695e-04f, -1.863314983e-04f, +3.587265066e-04f, +2.825342586e-04f, -8.297188020e-05f, -1.928507229e-04f, -3.821462953e-05f, +7.636810055e-05f, +4.499945636e-05f, -1.289640005e-05f, -1.299015110e-05f,
    /*  6,12 (48) */
    +3.786906842e-04f, +4.742409770e-04f, -4.000804031e-04f, -1.538522367e-03f, -9.126535106e-04f, +1.929113513e-03f, +3.691281546e-03f, +5.322997163e-04f, -5.570715989e-03f, -6.490833009e-03f, +2.246918518e-03f, +1.220884494e-02f, +8.620493394e-03f, -9.819225309e-03f, -2.240746746e-02f, -7.356802921e-03f, +2.613749814e-02f, +3.696347053e-02f, -3.175092215e-03f, -6.267792687e-02f, -6.209384823e-02f, +4.996687989e-02f, +2.295074716e-01f, +3.567874214e-01f, +3.365738973e-01f, +1.843472333e-01f, +1.207845715e-02f, -7.201403750e-02f, -5.009565782e-02f, +1.110601084e-02f, +3.871714026e-02f, +1.803793170e-02f, -1.392726073e-02f, -2.132379272e-02f, -4.667631548e-03f, +1.126515414e-02f, +1.047914838e-02f, -6.129567250e-04f, -7.177519115e-03f, -4.173532748e-03f, +1.817203621e-03f, +3.616790862e-03f, +1.134643437e-03f, -1.320512797e-03f, -1.337801647e-03f, -9.472486139e-05f, +5.267649628e-04f, +2.774110254e-04f,
    -1.213829077e-05f, +1.020059379e-05f, +4.012873408e-05f, +1.933780265e-05f, -6.022406427e-05f, -9.758519584e-05f, +8.531327437e-06f, +1.748050353e-04f, +1.590972051e-04f, -1.232497358e-04f, -3.690380776e-04f, -1.701783911e-04f, +3.919678164e-04f, +6.344436463e-04f, +3.563531872e-05f, -9.048406397e-04f, -9.478457543e-04f, +4.099171202e-04f, +1.888756093e-03f, +1.388226278e-03f, -1.645850917e-03f, -5.022298439e-03f, -5.503407437e-03f, -2.005613969e-03f, +3.033339389e-03f, +5.756750934e-03f, +4.430928190e-03f, +8.398258175e-04f, -1.737711230e-03f, -1.668542953e-03f, -3.153675092e-05f, +1.066129499e-03f, +7.322066741e-04f, -2.316054131e-04f, -6.471842655e-04f, -2.676012728e-04f, +2.590211863e-04f, +3.428244537e-04f, +4.863109859e-05f, -1.880543077e-04f, -1.452879072e-04f, +2.647383212e-05f, +9.997285517e-05f, +4.157428121e-05f, -3.033300262e-05f, -3.588242442e-05f, -3.049786624e-06f, +1.298089736e-05f,
    -3.786906842e-04f, -8.861937670e-04f, +4.647159335e-05f, +2.400166972e-03f, +2.293754130e-03f, -2.853309640e-03f, -6.918820344e-03f, -7.645693074e-04f, +1.104860059e-02f, +1.001148016e-02f, -9.163387871e-03f, -2.164671393e-02f, -3.088803903e-03f, +2.730807342e-02f, +2.359455243e-02f, -1.837857106e-02f, -4.204098693e-02f, -6.462485410e-03f, +4.506408280e-02f, +3.727340804e-02f, -2.586361741e-02f, -5.722483191e-02f, -9.071426476e-03f, +5.347779691e-02f, +4.242361066e-02f, -2.659387024e-02f, -5.690565121e-02f, -9.195693798e-03f, +4.656998107e-02f, +3.543250658e-02f, -1.996498863e-02f, -4.132712798e-02f, -6.834554991e-03f, +2.921890803e-02f, +2.128060105e-02f, -1.047284557e-02f, -2.101036678e-02f, -3.631151590e-03f, +1.229488382e-02f, +8.535703323e-03f, -3.364035194e-03f, -6.612745479e-03f, -1.265479247e-03f, +2.806253727e-03f, +1.842512035e-03f, -3.880792997e-04f, -8.260017364e-04f, -2.774110254e-04f,
    +1.213829077e-05f, +2.765018826e-06f, -6.119931503e-05f, -6.293264893e-05f, +8.439917964e-05f, +1.998602095e-04f, +1.060981472e-06f, -3.543109979e-04f, -2.730223974e-04f, +3.610442174e-04f, +6.815530458e-04f, -3.778868120e-05f, -9.882984193e-04f, -6.373657158e-04f, +8.655969926e-04f, +1.400547921e-03f, -1.398502021e-04f, -1.782245864e-03f, -9.941451458e-04f, +1.400486931e-03f, +1.995800483e-03f, -2.727637206e-04f, -2.284767897e-03f, -1.113810654e-03f, +1.634302546e-03f, +2.071932351e-03f, -3.509225522e-04f, -2.147765234e-03f, -9.125145432e-04f, +1.398685977e-03f, +1.575728923e-03f, -3.146050762e-04f, -1.468921251e-03f, -5.352187495e-04f, +8.591182488e-04f, +8.487007769e-04f, -1.934564494e-04f, -6.935058886e-04f, -2.085812962e-04f, +3.504359284e-04f, +2.927800816e-04f, -7.368618329e-05f, -1.948220386e-04f, -4.386599617e-05f, +7.528183798e-05f, +4.714454596e-05f, -1.184973062e-05f, -1.298089736e-05f,
    /*  6,13 (48) */
    +3.665523935e-04f, +4.844415708e-04f, -3.599516690e-04f, -1.519184564e-03f, -9.728775749e-04f, +1.831528317e-03f, +3.699812874e-03f, +7.071047516e-04f, -5.411618784e-03f, -6.614082745e-03f, +1.877880440e-03f, +1.203866655e-02f, +9.012461210e-03f, -9.184781663e-03f, -2.237183214e-02f, -8.261643560e-03f, +2.518965239e-02f, +3.737338765e-02f, -1.286336122e-03f, -6.128970059e-02f, -6.373969915e-02f, +4.494458145e-02f, +2.240040642e-01f, +3.547818075e-01f, +3.396072367e-01f, +1.901039843e-01f, +1.650938534e-02f, -7.117421169e-02f, -5.183336905e-02f, +9.437467890e-03f, +3.868560351e-02f, +1.910406119e-02f, -1.319505405e-02f, -2.155539814e-02f, -5.314815813e-03f, +1.099755286e-02f, +1.073816957e-02f, -2.701322713e-04f, -7.128888016e-03f, -4.361587055e-03f, +1.671915714e-03f, +3.643264694e-03f, +1.234616292e-03f, -1.278938516e-03f, -1.368134650e-03f, -1.306072858e-04f, +5.237151761e-04f, +2.903919228e-04f,
    -1.234603609e-05f, +9.131431252e-06f, +3.966770023e-05f, +2.112421139e-05f, -5.764254316e-05f, -9.838547999e-05f, +3.253710870e-06f, +1.710951859e-04f, +1.641487836e-04f, -1.125369970e-04f, -3.666517270e-04f, -1.842221365e-04f, +3.749531488e-04f, +6.389709586e-04f, +6.512791117e-05f, -8.826700539e-04f, -9.694128361e-04f, +3.547219075e-04f, +1.863018891e-03f, +1.446524599e-03f, -1.528547974e-03f, -4.946148599e-03f, -5.552385977e-03f, -2.158318909e-03f, +2.892996910e-03f, +5.733393884e-03f, +4.523256024e-03f, +9.523068714e-04f, -1.696232062e-03f, -1.705400290e-03f, -8.413192717e-05f, +1.053915209e-03f, +7.591479881e-04f, -2.052632092e-04f, -6.480294558e-04f, -2.859840513e-04f, +2.477397787e-04f, +3.478723656e-04f, +5.916490752e-05f, -1.848397734e-04f, -1.499687083e-04f, +2.177874479e-05f, +1.000802969e-04f, +4.429858431e-05f, -2.898292652e-05f, -3.662429443e-05f, -4.016743749e-06f, +1.294511835e-05f,
    -3.665523935e-04f, -8.834287482e-04f, -1.472772168e-05f, +2.337234324e-03f, +2.378153310e-03f, -2.653449430e-03f, -6.917759363e-03f, -1.118880305e-03f, +1.077557820e-02f, +1.037252438e-02f, -8.481834825e-03f, -2.168450261e-02f, -4.077102323e-03f, +2.667070770e-02f, +2.446014943e-02f, -1.697802314e-02f, -4.218083714e-02f, -8.244731274e-03f, +4.406993765e-02f, +3.867389497e-02f, -2.386781692e-02f, -5.749759563e-02f, -1.135619437e-02f, +5.236398626e-02f, +4.405791320e-02f, -2.452193789e-02f, -5.725657376e-02f, -1.134345903e-02f, +4.565746653e-02f, +3.683119256e-02f, -1.838925970e-02f, -4.164173305e-02f, -8.303476242e-03f, +2.868368928e-02f, +2.213971930e-02f, -9.624144797e-03f, -2.120382323e-02f, -4.324657479e-03f, +1.208630252e-02f, +8.886139251e-03f, -3.071255113e-03f, -6.686431662e-03f, -1.460301286e-03f, +2.762387731e-03f, +1.917793873e-03f, -3.409347537e-04f, -8.378514670e-04f, -2.903919228e-04f,
    +1.234603609e-05f, +4.246478632e-06f, -5.933039603e-05f, -6.521278117e-05f, +7.857405835e-05f, +2.001343575e-04f, +1.216074364e-05f, -3.467634009e-04f, -2.861007156e-04f, +3.398859639e-04f, +6.867142749e-04f, -3.412638687e-06f, -9.723288509e-04f, -6.733951917e-04f, +8.208654043e-04f, +1.417398567e-03f, -7.359347869e-05f, -1.760454940e-03f, -1.058179230e-03f, +1.335842558e-03f, +2.027474710e-03f, -1.833202433e-04f, -2.264735987e-03f, -1.194482311e-03f, +1.566852253e-03f, +2.112448184e-03f, -2.628803648e-04f, -2.136150166e-03f, -9.867046377e-04f, +1.347555264e-03f, +1.612641656e-03f, -2.515253188e-04f, -1.466235570e-03f, -5.844689476e-04f, +8.319838752e-04f, +8.723908122e-04f, -1.620083209e-04f, -6.951983024e-04f, -2.307902896e-04f, +3.414401451e-04f, +3.027058630e-04f, -6.410352750e-05f, -1.964972977e-04f, -4.957137964e-05f, +7.402900911e-05f, +4.926544663e-05f, -1.073931758e-05f, -1.294511835e-05f,
    /*  6,14 (48) */
    +3.542063574e-04f, +4.935730020e-04f, -3.202839688e-04f, -1.498060353e-03f, -1.030520118e-03f, +1.733142837e-03f, +3.703066585e-03f, +8.781999375e-04f, -5.247470000e-03f, -6.726619742e-03f, +1.511228713e-03f, +1.185444441e-02f, +9.387414359e-03f, -8.545810704e-03f, -2.230670423e-02f, -9.144313614e-03f, +2.422023955e-02f, +3.772810956e-02f, +5.766827686e-04f, -5.984317599e-02f, -6.526824712e-02f, +3.999843285e-02f, +2.184516782e-01f, +3.526234885e-01f, +3.425002336e-01f, +1.958373782e-01f, +2.103264136e-02f, -7.022190482e-02f, -5.352960111e-02f, +7.732067600e-03f, +3.860147158e-02f, +2.015797640e-02f, -1.243590607e-02f, -2.176066135e-02f, -5.962845269e-03f, +1.071156881e-02f, +1.098590935e-02f, +7.774009424e-05f, -7.069723108e-03f, -4.546426829e-03f, +1.521947006e-03f, +3.665043439e-03f, +1.334696589e-03f, -1.234639931e-03f, -1.397117576e-03f, -1.672315802e-04f, +5.196984324e-04f, +3.033370412e-04f,
    -1.252380240e-05f, +8.075716455e-06f, +3.915475926e-05f, +2.284062728e-05f, -5.502581215e-05f, -9.902947732e-05f, -1.941592106e-06f, +1.672022944e-04f, +1.688986336e-04f, -1.018171598e-04f, -3.637949248e-04f, -1.978360502e-04f, +3.576425317e-04f, +6.425837567e-04f, +9.417553793e-05f, -8.595992529e-04f, -9.894315259e-04f, +2.997987345e-04f, +1.835268932e-03f, +1.502062702e-03f, -1.411791514e-03f, -4.867063234e-03f, -5.597125161e-03f, -2.309261014e-03f, +2.750303297e-03f, +5.705749210e-03f, +4.613133477e-03f, +1.065843199e-03f, -1.651917312e-03f, -1.740568283e-03f, -1.373173676e-04f, +1.040138524e-03f, +7.854011156e-04f, -1.783194103e-04f, -6.480020529e-04f, -3.042066950e-04f, +2.359700435e-04f, +3.525051485e-04f, +6.976466306e-05f, -1.813161613e-04f, -1.545092677e-04f, +1.697257874e-05f, +1.000420994e-04f, +4.701035630e-05f, -2.755785588e-05f, -3.732458058e-05f, -5.004115458e-06f, +1.288213796e-05f,
    -3.542063574e-04f, -8.791822696e-04f, -7.405811770e-05f, +2.272021542e-03f, +2.456727368e-03f, -2.453315073e-03f, -6.905598619e-03f, -1.465643706e-03f, +1.048947748e-02f, +1.071241034e-02f, -7.795120550e-03f, -2.168791525e-02f, -5.049431174e-03f, +2.599731251e-02f, +2.528101483e-02f, -1.556062457e-02f, -4.225443061e-02f, -1.000518621e-02f, +4.301175842e-02f, +4.000973753e-02f, -2.184034221e-02f, -5.768091587e-02f, -1.362093036e-02f, +5.116950395e-02f, +4.562476546e-02f, -2.240948970e-02f, -5.751945412e-02f, -1.347960920e-02f, +4.467076189e-02f, +3.817874782e-02f, -1.677661805e-02f, -4.189325837e-02f, -9.769711812e-03f, +2.809922033e-02f, +2.297170317e-02f, -8.751753984e-03f, -2.136583155e-02f, -5.019855781e-03f, +1.185551223e-02f, +9.227579396e-03f, -2.768549250e-03f, -6.750535189e-03f, -1.656798584e-03f, +2.712816351e-03f, +1.991822882e-03f, -2.916693071e-04f, -8.485907846e-04f, -3.033370412e-04f,
    +1.252380240e-05f, +5.668242641e-06f, -5.740648749e-05f, -6.731990907e-05f, +7.274328220e-05f, +2.000651765e-04f, +2.304260649e-05f, -3.387666227e-04f, -2.985228050e-04f, +3.184554961e-04f, +6.907094046e-04f, +3.060054439e-05f, -9.549627299e-04f, -7.080437859e-04f, +7.751758193e-04f, +1.431894319e-03f, -7.609956241e-06f, -1.735999543e-03f, -1.120278267e-03f, +1.269317874e-03f, +2.055879498e-03f, -9.375414920e-05f, -2.241168059e-03f, -1.273251348e-03f, +1.496909514e-03f, +2.149690319e-03f, -1.742506136e-04f, -2.121136482e-03f, -1.059600435e-03f, +1.294071328e-03f, +1.647190982e-03f, -1.876646366e-04f, -1.461196060e-03f, -6.331730036e-04f, +8.032746449e-04f, +8.949096394e-04f, -1.299515369e-04f, -6.957782950e-04f, -2.529205913e-04f, +3.317440804e-04f, +3.122893028e-04f, -5.423534605e-05f, -1.978675716e-04f, -5.532149868e-05f, +7.260778855e-05f, +5.135717680e-05f, -9.565447060e-06f, -1.288213796e-05f,
    /*  6,15 (48) */
    +3.416825550e-04f, +5.016487185e-04f, -2.811292096e-04f, -1.475219725e-03f, -1.085545930e-03f, +1.634113360e-03f, +3.701124993e-03f, +1.045402232e-03f, -5.078571367e-03f, -6.828436902e-03f, +1.147433788e-03f, +1.165660836e-02f, +9.745056891e-03f, -7.903226948e-03f, -2.221252869e-02f, -1.000391287e-02f, +2.323080802e-02f, +3.802790829e-02f, +2.411951701e-03f, -5.834111329e-02f, -6.668003863e-02f, +3.513136962e-02f, +2.128545531e-01f, +3.503142275e-01f, +3.452505369e-01f, +2.015431274e-01f, +2.564577484e-02f, -6.915606162e-02f, -5.518151842e-02f, +5.991499317e-03f, +3.846415422e-02f, +2.119811493e-02f, -1.165050495e-02f, -2.193898076e-02f, -6.610847322e-03f, +1.040736212e-02f, +1.122187939e-02f, +4.302452427e-04f, -6.999958445e-03f, -4.727742990e-03f, +1.367437738e-03f, +3.682016018e-03f, +1.434738688e-03f, -1.187629575e-03f, -1.424675432e-03f, -2.045561608e-04f, +5.146943169e-04f, +3.162191791e-04f,
    -1.267205825e-05f, +7.034965172e-06f, +3.859189896e-05f, +2.448577510e-05f, -5.237848872e-05f, -9.951892142e-05f, -7.048363227e-06f, +1.631346866e-04f, +1.733443561e-04f, -9.110529226e-05f, -3.604777500e-04f, -2.110068681e-04f, +3.400631189e-04f, +6.452881649e-04f, +1.227447621e-04f, -8.356694761e-04f, -1.007894918e-03f, +2.452138071e-04f, +1.805568045e-03f, +1.554819155e-03f, -1.295686520e-03f, -4.785135208e-03f, -5.637607225e-03f, -2.458318630e-03f, +2.605371983e-03f, +5.673818458e-03f, +4.700459576e-03f, +1.180336464e-03f, -1.604775713e-03f, -1.773979571e-03f, -1.910321154e-04f, +1.024798178e-03f, +8.109226079e-04f, -1.508031714e-04f, -6.470914609e-04f, -3.222421066e-04f, +2.237221013e-04f, +3.567107958e-04f, +8.041625104e-05f, -1.774840205e-04f, -1.589008196e-04f, +1.206061149e-05f, +9.985575014e-05f, +4.970515603e-05f, -2.605851780e-05f, -3.798114978e-05f, -6.010633299e-06f, +1.279131761e-05f,
    -3.416825550e-04f, -8.735140269e-04f, -1.314646052e-04f, +2.204701633e-03f, +2.529470650e-03f, -2.253249896e-03f, -6.882556012e-03f, -1.804410329e-03f, +1.019095468e-02f, +1.103086584e-02f, -7.104411146e-03f, -2.165731470e-02f, -6.004393903e-03f, +2.528926872e-02f, +2.605619065e-02f, -1.412873026e-02f, -4.226204057e-02f, -1.174118576e-02f, +4.189148016e-02f, +4.127905540e-02f, -1.978446272e-02f, -5.777467002e-02f, -1.586209842e-02f, +4.989625260e-02f, +4.712167497e-02f, -2.025979938e-02f, -5.769370474e-02f, -1.560074568e-02f, +4.361116146e-02f, +3.947281915e-02f, -1.512942707e-02f, -4.208092301e-02f, -1.123090787e-02f, +2.746604733e-02f, +2.377497782e-02f, -7.856844345e-03f, -2.149578308e-02f, -5.715634076e-03f, +1.160259164e-02f, +9.559323477e-03f, -2.456259947e-03f, -6.804770535e-03f, -1.854666155e-03f, +2.657494853e-03f, +2.064430670e-03f, -2.403121303e-04f, -8.581562317e-04f, -3.162191791e-04f,
    +1.267205825e-05f, +7.029238600e-06f, -5.543284324e-05f, -6.925432346e-05f, +6.691741390e-05f, +1.996594200e-04f, +3.369169212e-05f, -3.303412642e-04f, -3.102772523e-04f, +2.967918487e-04f, +6.935455157e-04f, +6.419910584e-05f, -9.362415961e-04f, -7.412671690e-04f, +7.286092271e-04f, +1.444027608e-03f, +5.799606398e-05f, -1.708932137e-03f, -1.180351032e-03f, +1.201025502e-03f, +2.080978043e-03f, -4.208531243e-06f, -2.214105531e-03f, -1.349992761e-03f, +1.424584869e-03f, +2.183595432e-03f, -8.517381261e-05f, -2.102738992e-03f, -1.131080554e-03f, +1.238309972e-03f, +1.679309172e-03f, -1.231214967e-04f, -1.453794775e-03f, -6.812474507e-04f, +7.730237344e-04f, +9.162088455e-04f, -9.733251319e-05f, -6.952315542e-04f, -2.749339573e-04f, +3.213539468e-04f, +3.215083537e-04f, -4.409378486e-05f, -1.989243212e-04f, -6.110678857e-05f, +7.101663954e-05f, +5.341468188e-05f, -8.328556656e-06f, -1.279131761e-05f,
    /*  6,16 (48) */
    +3.290104967e-04f, +5.086836836e-04f, -2.425373106e-04f, -1.450733950e-03f, -1.137924419e-03f, +1.534594438e-03f, +3.694076629e-03f, +1.208536918e-03f, -4.905227010e-03f, -6.919542194e-03f, +7.869560385e-04f, +1.144560149e-02f, +1.008512001e-02f, -7.257938783e-03f, -2.208978393e-02f, -1.083958234e-02f, +2.222291311e-02f, +3.827312210e-02f, +4.217519746e-03f, -5.678629413e-02f, -6.797572515e-02f, +3.034623441e-02f, +2.072169458e-01f, +3.478559089e-01f, +3.478559089e-01f, +2.072169458e-01f, +3.034623441e-02f, -6.797572515e-02f, -5.678629413e-02f, +4.217519746e-03f, +3.827312210e-02f, +2.222291311e-02f, -1.083958234e-02f, -2.208978393e-02f, -7.257938783e-03f, +1.008512001e-02f, +1.144560149e-02f, +7.869560385e-04f, -6.919542194e-03f, -4.905227010e-03f, +1.208536918e-03f, +3.694076629e-03f, +1.534594438e-03f, -1.137924419e-03f, -1.450733950e-03f, -2.425373106e-04f, +5.086836836e-04f, +3.290104967e-04f,
    -1.279131761e-05f, +6.010633299e-06f, +3.798114978e-05f, +2.605851780e-05f, -4.970515603e-05f, -9.985575014e-05f, -1.206061149e-05f, +1.589008196e-04f, +1.774840205e-04f, -8.041625104e-05f, -3.567107958e-04f, -2.237221013e-04f, +3.222421066e-04f, +6.470914609e-04f, +1.508031714e-04f, -8.109226079e-04f, -1.024798178e-03f, +1.910321154e-04f, +1.773979571e-03f, +1.604775713e-03f, -1.180336464e-03f, -4.700459576e-03f, -5.673818458e-03f, -2.605371983e-03f, +2.458318630e-03f, +5.637607225e-03f, +4.785135208e-03f, +1.295686520e-03f, -1.554819155e-03f, -1.805568045e-03f, -2.452138071e-04f, +1.007894918e-03f, +8.356694761e-04f, -1.227447621e-04f, -6.452881649e-04f, -3.400631189e-04f, +2.110068681e-04f, +3.604777500e-04f, +9.110529226e-05f, -1.733443561e-04f, -1.631346866e-04f, +7.048363227e-06f, +9.951892142e-05f, +5.237848872e-05f, -2.448577510e-05f, -3.859189896e-05f, -7.034965172e-06f, +1.267205825e-05f,
    -3.290104967e-04f, -8.664847883e-04f, -1.868974484e-04f, +2.135447310e-03f, +2.596388064e-03f, -2.053590476e-03f, -6.848864320e-03f, -2.134751593e-03f, +9.880677424e-03f, +1.132765769e-02f, -6.410865630e-03f, -2.159311560e-02f, -6.940635500e-03f, +2.454800155e-02f, +2.678479988e-02f, -1.268470265e-02f, -4.220404451e-02f, -1.345011789e-02f, +4.071112912e-02f, +4.248008090e-02f, -1.770348467e-02f, -5.777887855e-02f, -1.807620395e-02f, +4.854625984e-02f, +4.854625984e-02f, -1.807620395e-02f, -5.777887855e-02f, -1.770348467e-02f, +4.248008090e-02f, +4.071112912e-02f, -1.345011789e-02f, -4.220404451e-02f, -1.268470265e-02f, +2.678479988e-02f, +2.454800155e-02f, -6.940635500e-03f, -2.159311560e-02f, -6.410865630e-03f, +1.132765769e-02f, +9.880677424e-03f, -2.134751593e-03f, -6.848864320e-03f, -2.053590476e-03f, +2.596388064e-03f, +2.135447310e-03f, -1.868974484e-04f, -8.664847883e-04f, -3.290104967e-04f,
    +1.279131761e-05f, +8.328556656e-06f, -5.341468188e-05f, -7.101663954e-05f, +6.110678857e-05f, +1.989243212e-04f, +4.409378486e-05f, -3.215083537e-04f, -3.213539468e-04f, +2.749339573e-04f, +6.952315542e-04f, +9.733251319e-05f, -9.162088455e-04f, -7.730237344e-04f, +6.812474507e-04f, +1.453794775e-03f, +1.231214967e-04f, -1.679309172e-03f, -1.238309972e-03f, +1.131080554e-03f, +2.102738992e-03f, +8.517381261e-05f, -2.183595432e-03f, -1.424584869e-03f, +1.349992761e-03f, +2.214105531e-03f, +4.208531243e-06f, -2.080978043e-03f, -1.201025502e-03f, +1.180351032e-03f, +1.708932137e-03f, -5.799606398e-05f, -1.444027608e-03f, -7.286092271e-04f, +7.412671690e-04f, +9.362415961e-04f, -6.419910584e-05f, -6.935455157e-04f, -2.967918487e-04f, +3.102772523e-04f, +3.303412642e-04f, -3.369169212e-05f, -1.996594200e-04f, -6.691741390e-05f, +6.925432346e-05f, +5.543284324e-05f, -7.029238600e-06f, -1.267205825e-05f,
    /*  6,17 (48) */
    +3.162191791e-04f, +5.146943169e-04f, -2.045561608e-04f, -1.424675432e-03f, -1.187629575e-03f, +1.434738688e-03f, +3.682016018e-03f, +1.367437738e-03f, -4.727742990e-03f, -6.999958445e-03f, +4.302452427e-04f, +1.122187939e-02f, +1.040736212e-02f, -6.610847322e-03f, -2.193898076e-02f, -1.165050495e-02f, +2.119811493e-02f, +3.846415422e-02f, +5.991499317e-03f, -5.518151842e-02f, -6.915606162e-02f, +2.564577484e-02f, +2.015431274e-01f, +3.452505369e-01f, +3.503142275e-01f, +2.128545531e-01f, +3.513136962e-02f, -6.668003863e-02f, -5.834111329e-02f, +2.411951701e-03f, +3.802790829e-02f, +2.323080802e-02f, -1.000391287e-02f, -2.221252869e-02f, -7.903226948e-03f, +9.745056891e-03f, +1.165660836e-02f, +1.147433788e-03f, -6.828436902e-03f, -5.078571367e-03f, +1.045402232e-03f, +3.701124993e-03f, +1.634113360e-03f, -1.085545930e-03f, -1.475219725e-03f, -2.811292096e-04f, +5.016487185e-04f, +3.416825550e-04f,
    -1.288213796e-05f, +5.004115458e-06f, +3.732458058e-05f, +2.755785588e-05f, -4.701035630e-05f, -1.000420994e-04f, -1.697257874e-05f, +1.545092677e-04f, +1.813161613e-04f, -6.976466306e-05f, -3.525051485e-04f, -2.359700435e-04f, +3.042066950e-04f, +6.480020529e-04f, +1.783194103e-04f, -7.854011156e-04f, -1.040138524e-03f, +1.373173676e-04f, +1.740568283e-03f, +1.651917312e-03f, -1.065843199e-03f, -4.613133477e-03f, -5.705749210e-03f, -2.750303297e-03f, +2.309261014e-03f, +5.597125161e-03f, +4.867063234e-03f, +1.411791514e-03f, -1.502062702e-03f, -1.835268932e-03f, -2.997987345e-04f, +9.894315259e-04f, +8.595992529e-04f, -9.417553793e-05f, -6.425837567e-04f, -3.576425317e-04f, +1.978360502e-04f, +3.637949248e-04f, +1.018171598e-04f, -1.688986336e-04f, -1.672022944e-04f, +1.941592106e-06f, +9.902947732e-05f, +5.502581215e-05f, -2.284062728e-05f, -3.915475926e-05f, -8.075716455e-06f, +1.252380240e-05f,
    -3.162191791e-04f, -8.581562317e-04f, -2.403121303e-04f, +2.064430670e-03f, +2.657494853e-03f, -1.854666155e-03f, -6.804770535e-03f, -2.456259947e-03f, +9.559323477e-03f, +1.160259164e-02f, -5.715634076e-03f, -2.149578308e-02f, -7.856844345e-03f, +2.377497782e-02f, +2.746604733e-02f, -1.123090787e-02f, -4.208092301e-02f, -1.512942707e-02f, +3.947281915e-02f, +4.361116146e-02f, -1.560074568e-02f, -5.769370474e-02f, -2.025979938e-02f, +4.712167497e-02f, +4.989625260e-02f, -1.586209842e-02f, -5.777467002e-02f, -1.978446272e-02f, +4.127905540e-02f, +4.189148016e-02f, -1.174118576e-02f, -4.226204057e-02f, -1.412873026e-02f, +2.605619065e-02f, +2.528926872e-02f, -6.004393903e-03f, -2.165731470e-02f, -7.104411146e-03f, +1.103086584e-02f, +1.019095468e-02f, -1.804410329e-03f, -6.882556012e-03f, -2.253249896e-03f, +2.529470650e-03f, +2.204701633e-03f, -1.314646052e-04f, -8.735140269e-04f, -3.416825550e-04f,
    +1.288213796e-05f, +9.565447060e-06f, -5.135717680e-05f, -7.260778855e-05f, +5.532149868e-05f, +1.978675716e-04f, +5.423534605e-05f, -3.122893028e-04f, -3.317440804e-04f, +2.529205913e-04f, +6.957782950e-04f, +1.299515369e-04f, -8.949096394e-04f, -8.032746449e-04f, +6.331730036e-04f, +1.461196060e-03f, +1.876646366e-04f, -1.647190982e-03f, -1.294071328e-03f, +1.059600435e-03f, +2.121136482e-03f, +1.742506136e-04f, -2.149690319e-03f, -1.496909514e-03f, +1.273251348e-03f, +2.241168059e-03f, +9.375414920e-05f, -2.055879498e-03f, -1.269317874e-03f, +1.120278267e-03f, +1.735999543e-03f, +7.609956241e-06f, -1.431894319e-03f, -7.751758193e-04f, +7.080437859e-04f, +9.549627299e-04f, -3.060054439e-05f, -6.907094046e-04f, -3.184554961e-04f, +2.985228050e-04f, +3.387666227e-04f, -2.304260649e-05f, -2.000651765e-04f, -7.274328220e-05f, +6.731990907e-05f, +5.740648749e-05f, -5.668242641e-06f, -1.252380240e-05f,
    /*  6,18 (48) */
    +3.033370412e-04f, +5.196984324e-04f, -1.672315802e-04f, -1.397117576e-03f, -1.234639931e-03f, +1.334696589e-03f, +3.665043439e-03f, +1.521947006e-03f, -4.546426829e-03f, -7.069723108e-03f, +7.774009424e-05f, +1.098590935e-02f, +1.071156881e-02f, -5.962845269e-03f, -2.176066135e-02f, -1.243590607e-02f, +2.015797640e-02f, +3.860147158e-02f, +7.732067600e-03f, -5.352960111e-02f, -7.022190482e-02f, +2.103264136e-02f, +1.958373782e-01f, +3.425002336e-01f, +3.526234885e-01f, +2.184516782e-01f, +3.999843285e-02f, -6.526824712e-02f, -5.984317599e-02f, +5.766827686e-04f, +3.772810956e-02f, +2.422023955e-02f, -9.144313614e-03f, -2.230670423e-02f, -8.545810704e-03f, +9.387414359e-03f, +1.185444441e-02f, +1.511228713e-03f, -6.726619742e-03f, -5.247470000e-03f, +8.781999375e-04f, +3.703066585e-03f, +1.733142837e-03f, -1.030520118e-03f, -1.498060353e-03f, -3.202839688e-04f, +4.935730020e-04f, +3.542063574e-04f,
    -1.294511835e-05f, +4.016743749e-06f, +3.662429443e-05f, +2.898292652e-05f, -4.429858431e-05f, -1.000802969e-04f, -2.177874479e-05f, +1.499687083e-04f, +1.848397734e-04f, -5.916490752e-05f, -3.478723656e-04f, -2.477397787e-04f, +2.859840513e-04f, +6.480294558e-04f, +2.052632092e-04f, -7.591479881e-04f, -1.053915209e-03f, +8.413192717e-05f, +1.705400290e-03f, +1.696232062e-03f, -9.523068714e-04f, -4.523256024e-03f, -5.733393884e-03f, -2.892996910e-03f, +2.158318909e-03f, +5.552385977e-03f, +4.946148599e-03f, +1.528547974e-03f, -1.446524599e-03f, -1.863018891e-03f, -3.547219075e-04f, +9.694128361e-04f, +8.826700539e-04f, -6.512791117e-05f, -6.389709586e-04f, -3.749531488e-04f, +1.842221365e-04f, +3.666517270e-04f, +1.125369970e-04f, -1.641487836e-04f, -1.710951859e-04f, -3.253710870e-06f, +9.838547999e-05f, +5.764254316e-05f, -2.112421139e-05f, -3.966770023e-05f, -9.131431252e-06f, +1.234603609e-05f,
    -3.033370412e-04f, -8.485907846e-04f, -2.916693071e-04f, +1.991822882e-03f, +2.712816351e-03f, -1.656798584e-03f, -6.750535189e-03f, -2.768549250e-03f, +9.227579396e-03f, +1.185551223e-02f, -5.019855781e-03f, -2.136583155e-02f, -8.751753984e-03f, +2.297170317e-02f, +2.809922033e-02f, -9.769711812e-03f, -4.189325837e-02f, -1.677661805e-02f, +3.817874782e-02f, +4.467076189e-02f, -1.347960920e-02f, -5.751945412e-02f, -2.240948970e-02f, +4.562476546e-02f, +5.116950395e-02f, -1.362093036e-02f, -5.768091587e-02f, -2.184034221e-02f, +4.000973753e-02f, +4.301175842e-02f, -1.000518621e-02f, -4.225443061e-02f, -1.556062457e-02f, +2.528101483e-02f, +2.599731251e-02f, -5.049431174e-03f, -2.168791525e-02f, -7.795120550e-03f, +1.071241034e-02f, +1.048947748e-02f, -1.465643706e-03f, -6.905598619e-03f, -2.453315073e-03f, +2.456727368e-03f, +2.272021542e-03f, -7.405811770e-05f, -8.791822696e-04f, -3.542063574e-04f,
    +1.294511835e-05f, +1.073931758e-05f, -4.926544663e-05f, -7.402900911e-05f, +4.957137964e-05f, +1.964972977e-04f, +6.410352750e-05f, -3.027058630e-04f, -3.414401451e-04f, +2.307902896e-04f, +6.951983024e-04f, +1.620083209e-04f, -8.723908122e-04f, -8.319838752e-04f, +5.844689476e-04f, +1.466235570e-03f, +2.515253188e-04f, -1.612641656e-03f, -1.347555264e-03f, +9.867046377e-04f, +2.136150166e-03f, +2.628803648e-04f, -2.112448184e-03f, -1.566852253e-03f, +1.194482311e-03f, +2.264735987e-03f, +1.833202433e-04f, -2.027474710e-03f, -1.335842558e-03f, +1.058179230e-03f, +1.760454940e-03f, +7.359347869e-05f, -1.417398567e-03f, -8.208654043e-04f, +6.733951917e-04f, +9.723288509e-04f, +3.412638687e-06f, -6.867142749e-04f, -3.398859639e-04f, +2.861007156e-04f, +3.467634009e-04f, -1.216074364e-05f, -2.001343575e-04f, -7.857405835e-05f, +6.521278117e-05f, +5.933039603e-05f, -4.246478632e-06f, -1.234603609e-05f,
    /*  6,19 (48) */
    +2.903919228e-04f, +5.237151761e-04f, -1.306072858e-04f, -1.368134650e-03f, -1.278938516e-03f, +1.234616292e-03f, +3.643264694e-03f, +1.671915714e-03f, -4.361587055e-03f, -7.128888016e-03f, -2.701322713e-04f, +1.073816957e-02f, +1.099755286e-02f, -5.314815813e-03f, -2.155539814e-02f, -1.319505405e-02f, +1.910406119e-02f, +3.868560351e-02f, +9.437467890e-03f, -5.183336905e-02f, -7.117421169e-02f, +1.650938534e-02f, +1.901039843e-01f, +3.396072367e-01f, +3.547818075e-01f, +2.240040642e-01f, +4.494458145e-02f, -6.373969915e-02f, -6.128970059e-02f, -1.286336122e-03f, +3.737338765e-02f, +2.518965239e-02f, -8.261643560e-03f, -2.237183214e-02f, -9.184781663e-03f, +9.012461210e-03f, +1.203866655e-02f, +1.877880440e-03f, -6.614082745e-03f, -5.411618784e-03f, +7.071047516e-04f, +3.699812874e-03f, +1.831528317e-03f, -9.728775749e-04f, -1.519184564e-03f, -3.599516690e-04f, +4.844415708e-04f, +3.665523935e-04f,
    -1.298089736e-05f, +3.049786624e-06f, +3.588242442e-05f, +3.033300262e-05f, -4.157428121e-05f, -9.997285517e-05f, -2.647383212e-05f, +1.452879072e-04f, +1.880543077e-04f, -4.863109859e-05f, -3.428244537e-04f, -2.590211863e-04f, +2.676012728e-04f, +6.471842655e-04f, +2.316054131e-04f, -7.322066741e-04f, -1.066129499e-03f, +3.153675092e-05f, +1.668542953e-03f, +1.737711230e-03f, -8.398258175e-04f, -4.430928190e-03f, -5.756750934e-03f, -3.033339389e-03f, +2.005613969e-03f, +5.503407437e-03f, +5.022298439e-03f, +1.645850917e-03f, -1.388226278e-03f, -1.888756093e-03f, -4.099171202e-04f, +9.478457543e-04f, +9.048406397e-04f, -3.563531872e-05f, -6.344436463e-04f, -3.919678164e-04f, +1.701783911e-04f, +3.690380776e-04f, +1.232497358e-04f, -1.590972051e-04f, -1.748050353e-04f, -8.531327437e-06f, +9.758519584e-05f, +6.022406427e-05f, -1.933780265e-05f, -4.012873408e-05f, -1.020059379e-05f, +1.213829077e-05f,
    -2.903919228e-04f, -8.378514670e-04f, -3.409347537e-04f, +1.917793873e-03f, +2.762387731e-03f, -1.460301286e-03f, -6.686431662e-03f, -3.071255113e-03f, +8.886139251e-03f, +1.208630252e-02f, -4.324657479e-03f, -2.120382323e-02f, -9.624144797e-03f, +2.213971930e-02f, +2.868368928e-02f, -8.303476242e-03f, -4.164173305e-02f, -1.838925970e-02f, +3.683119256e-02f, +4.565746653e-02f, -1.134345903e-02f, -5.725657376e-02f, -2.452193789e-02f, +4.405791320e-02f, +5.236398626e-02f, -1.135619437e-02f, -5.749759563e-02f, -2.386781692e-02f, +3.867389497e-02f, +4.406993765e-02f, -8.244731274e-03f, -4.218083714e-02f, -1.697802314e-02f, +2.446014943e-02f, +2.667070770e-02f, -4.077102323e-03f, -2.168450261e-02f, -8.481834825e-03f, +1.037252438e-02f, +1.077557820e-02f, -1.118880305e-03f, -6.917759363e-03f, -2.653449430e-03f, +2.378153310e-03f, +2.337234324e-03f, -1.472772168e-05f, -8.834287482e-04f, -3.665523935e-04f,
    +1.298089736e-05f, +1.184973062e-05f, -4.714454596e-05f, -7.528183798e-05f, +4.386599617e-05f, +1.948220386e-04f, +7.368618329e-05f, -2.927800816e-04f, -3.504359284e-04f, +2.085812962e-04f, +6.935058886e-04f, +1.934564494e-04f, -8.487007769e-04f, -8.591182488e-04f, +5.352187495e-04f, +1.468921251e-03f, +3.146050762e-04f, -1.575728923e-03f, -1.398685977e-03f, +9.125145432e-04f, +2.147765234e-03f, +3.509225522e-04f, -2.071932351e-03f, -1.634302546e-03f, +1.113810654e-03f, +2.284767897e-03f, +2.727637206e-04f, -1.995800483e-03f, -1.400486931e-03f, +9.941451458e-04f, +1.782245864e-03f, +1.398502021e-04f, -1.400547921e-03f, -8.655969926e-04f, +6.373657158e-04f, +9.882984193e-04f, +3.778868120e-05f, -6.815530458e-04f, -3.610442174e-04f, +2.730223974e-04f, +3.543109979e-04f, -1.060981472e-06f, -1.998602095e-04f, -8.439917964e-05f, +6.293264893e-05f, +6.119931503e-05f, -2.765018826e-06f, -1.213829077e-05f,
    /*  6,20 (48) */
    +2.774110254e-04f, +5.267649628e-04f, -9.472486139e-05f, -1.337801647e-03f, -1.320512797e-03f, +1.134643437e-03f, +3.616790862e-03f, +1.817203621e-03f, -4.173532748e-03f, -7.177519115e-03f, -6.129567250e-04f, +1.047914838e-02f, +1.126515414e-02f, -4.667631548e-03f, -2.132379272e-02f, -1.392726073e-02f, +1.803793170e-02f, +3.871714026e-02f, +1.110601084e-02f, -5.009565782e-02f, -7.201403750e-02f, +1.207845715e-02f, +1.843472333e-01f, +3.365738973e-01f, +3.567874214e-01f, +2.295074716e-01f, +4.996687989e-02f, -6.209384823e-02f, -6.267792687e-02f, -3.175092215e-03f, +3.696347053e-02f, +2.613749814e-02f, -7.356802921e-03f, -2.240746746e-02f, -9.819225309e-03f, +8.620493394e-03f, +1.220884494e-02f, +2.246918518e-03f, -6.490833009e-03f, -5.570715989e-03f, +5.322997163e-04f, +3.691281546e-03f, +1.929113513e-03f, -9.126535106e-04f, -1.538522367e-03f, -4.000804031e-04f, +4.742409770e-04f, +3.786906842e-04f,
    -1.299015110e-05f, +2.104447899e-06f, +3.510112941e-05f, +3.160749143e-05f, -3.884182833e-05f, -9.972246519e-05f, -3.105281016e-05f, +1.404757048e-04f, +1.909596659e-04f, -3.817706870e-05f, -3.373738461e-04f, -2.698049460e-04f, +2.490853503e-04f, +6.454781322e-04f, +2.573180078e-04f, -7.046210202e-04f, -1.076784649e-03f, -2.040866966e-05f, +1.630064794e-03f, +1.776349229e-03f, -7.284964753e-04f, -4.336252698e-03f, -5.775822850e-03f, -3.171219637e-03f, +1.851269606e-03f, +5.450211354e-03f, +5.095422190e-03f, +1.763593947e-03f, -1.327192362e-03f, -1.912420313e-03f, -4.653170186e-04f, +9.247392699e-04f, +9.260704767e-04f, -5.732189004e-06f, -6.289968711e-04f, -4.086594606e-04f, +1.557188438e-04f, +3.709444324e-04f, +1.339401158e-04f, -1.537467684e-04f, -1.783236627e-04f, -1.388481807e-05f, +9.662710150e-05f, +6.276573041e-05f, -1.748281484e-05f, -4.053591994e-05f, -1.128162992e-05f, +1.190014518e-05f,
    -2.774110254e-04f, -8.260017364e-04f, -3.880792997e-04f, +1.842512035e-03f, +2.806253727e-03f, -1.265479247e-03f, -6.612745479e-03f, -3.364035194e-03f, +8.535703323e-03f, +1.229488382e-02f, -3.631151590e-03f, -2.101036678e-02f, -1.047284557e-02f, +2.128060105e-02f, +2.921890803e-02f, -6.834554991e-03f, -4.132712798e-02f, -1.996498863e-02f, +3.543250658e-02f, +4.656998107e-02f, -9.195693798e-03f, -5.690565121e-02f, -2.659387024e-02f, +4.242361066e-02f, +5.347779691e-02f, -9.071426476e-03f, -5.722483191e-02f, -2.586361741e-02f, +3.727340804e-02f, +4.506408280e-02f, -6.462485410e-03f, -4.204098693e-02f, -1.837857106e-02f, +2.359455243e-02f, +2.730807342e-02f, -3.088803903e-03f, -2.164671393e-02f, -9.163387871e-03f, +1.001148016e-02f, +1.104860059e-02f, -7.645693074e-04f, -6.918820344e-03f, -2.853309640e-03f, +2.293754130e-03f, +2.400166972e-03f, +4.647159335e-05f, -8.861937670e-04f, -3.786906842e-04f,
    +1.299015110e-05f, +1.289640005e-05f, -4.499945636e-05f, -7.636810055e-05f, +3.821462953e-05f, +1.928507229e-04f, +8.297188020e-05f, -2.825342586e-04f, -3.587265066e-04f, +1.863314983e-04f, +6.907170695e-04f, +2.242510113e-04f, -8.238894287e-04f, -8.846474702e-04f, +4.855061388e-04f, +1.469264846e-03f, +3.768072929e-04f, -1.536524015e-03f, -1.447391809e-03f, +8.371532126e-04f, +2.155972421e-03f, +4.382378834e-04f, -2.028211372e-03f, -1.699153931e-03f, +1.031364501e-03f, +2.301228055e-03f, +3.619414277e-04f, -1.960899026e-03f, -1.463141052e-03f, +9.282707680e-04f, +1.801323952e-03f, +2.062747762e-04f, -1.381353880e-03f, -9.092905707e-04f, +6.000023574e-04f, +1.002831839e-03f, +7.247466745e-05f, -6.752205347e-04f, -3.818911886e-04f, +2.593005639e-04f, +3.613892836e-04f, +1.024115626e-05f, -1.992364803e-04f, -9.020787174e-05f, +6.047955359e-05f, +6.300796565e-05f, -1.225099856e-06f, -1.190014518e-05f,
    /*  6,21 (48) */
    +2.644208743e-04f, +5.288694107e-04f, -5.962373197e-05f, -1.306194156e-03f, -1.359354625e-03f, +1.034920972e-03f, +3.585738052e-03f, +1.957679326e-03f, -3.982573082e-03f, -7.215696183e-03f, -9.503305711e-04f, +1.020934344e-02f, +1.151423949e-02f, -4.022153416e-03f, -2.106647472e-02f, -1.463188175e-02f, +1.696114705e-02f, +3.869673159e-02f, +1.273607564e-02f, -4.831930859e-02f, -7.274253398e-02f, +7.742204448e-03f, +1.785714105e-01f, +3.334026777e-01f, +3.586386910e-01f, +2.349576830e-01f, +5.506230208e-02f, -6.033025428e-02f, -6.400511923e-02f, -5.087512528e-03f, +3.649815351e-02f, +2.706223741e-02f, -6.430732444e-03f, -2.241319965e-02f, -1.044822218e-02f, +8.211833933e-03f, +1.236456378e-02f, +2.617862950e-03f, -6.356892894e-03f, -5.724462757e-03f, +3.539760536e-04f, +3.677396728e-03f, +2.025740615e-03f, -8.498877802e-04f, -1.556005181e-03f, -4.406163231e-04f, +4.629593471e-04f, +3.905908294e-04f,
    -1.297359113e-05f, +1.181865908e-06f, +3.428258992e-05f, +3.280593321e-05f, -3.610554137e-05f, -9.933198915e-05f, -3.551089913e-05f, +1.355410019e-04f, +1.935561938e-04f, -2.781635243e-05f, -3.315333797e-04f, -2.800825408e-04f, +2.304631328e-04f, +6.429237330e-04f, +2.823741443e-04f, -6.764352098e-04f, -1.085885881e-03f, -7.164636522e-05f, +1.590035406e-03f, +1.812143592e-03f, -6.184132929e-04f, -4.239333900e-03f, -5.790616145e-03f, -3.306529007e-03f, +1.695410871e-03f, +5.392823581e-03f, +5.165431691e-03f, +1.881669363e-03f, -1.263450662e-03f, -1.933953010e-03f, -5.208531702e-04f, +9.001044679e-04f, +9.463197984e-04f, +2.454609306e-05f, -6.226268793e-04f, -4.250011263e-04f, +1.408582796e-04f, +3.723618031e-04f, +1.445927038e-04f, -1.481008172e-04f, -1.816430483e-04f, -1.930752840e-05f, +9.550988961e-05f, +6.526287593e-05f, -1.556080047e-05f, -4.088736808e-05f, -1.237290880e-05f, +1.163122716e-05f,
    -2.644208743e-04f, -8.131053364e-04f, -4.330787560e-04f, +1.766143934e-03f, +2.844468357e-03f, -1.072628524e-03f, -6.529773598e-03f, -3.646569453e-03f, +8.176976816e-03f, +1.248121532e-02f, -2.940434520e-03f, -2.078611577e-02f, -1.129673500e-02f, +2.039595358e-02f, +2.970441417e-02f, -5.365290145e-03f, -4.095032069e-02f, -2.150151264e-02f, +3.398511477e-02f, +4.740713429e-02f, -7.039721378e-03f, -5.646741332e-02f, -2.862208161e-02f, +4.072445673e-02f, +5.450916141e-02f, -6.770198421e-03f, -5.686289048e-02f, -2.782451643e-02f, +3.581026699e-02f, +4.599235357e-02f, -4.661161458e-03f, -4.183471216e-02f, -1.975992494e-02f, +2.268526186e-02f, +2.790807577e-02f, -2.085972064e-03f, -2.157423926e-02f, -9.838608406e-03f, +9.629588971e-03f, +1.130790116e-02f, -4.031800238e-04f, -6.908579188e-03f, -3.052546120e-03f, +2.203546258e-03f, +2.460646526e-03f, +1.094795590e-04f, -8.874188669e-04f, -3.905908294e-04f,
    +1.297359113e-05f, +1.387918782e-05f, -4.283507783e-05f, -7.728990083e-05f, +3.262626545e-05f, +1.905926445e-04f, +9.194990665e-05f, -2.719909026e-04f, -3.663082355e-04f, +1.640783646e-04f, +6.868495175e-04f, +2.543486610e-04f, -7.980080470e-04f, -9.085441513e-04f, +4.354149662e-04f, +1.467281854e-03f, +4.380373535e-04f, -1.495101536e-03f, -1.493605346e-03f, +7.607451793e-04f, +2.160768010e-03f, +5.246885145e-04f, -1.981358900e-03f, -1.761304204e-03f, +9.472748852e-04f, +2.314086478e-03f, +4.507103864e-04f, -1.922817896e-03f, -1.523697855e-03f, +8.606542412e-04f, +1.817645040e-03f, +2.727609708e-04f, -1.359831878e-03f, -9.518672422e-04f, +5.613547283e-04f, +1.015891543e-03f, +1.074166071e-04f, -6.677134881e-04f, -4.023878455e-04f, +2.449492238e-04f, +3.679786417e-04f, +2.172951773e-05f, -1.982574397e-04f, -9.598916518e-05f, +5.785387577e-05f, +6.475105451e-05f, +3.718756133e-07f, -1.163122716e-05f,
    /*  6,22 (48) */
    +2.514472832e-04f, +5.300512766e-04f, -2.534114206e-05f, -1.273388223e-03f, -1.395460166e-03f, +9.355889825e-04f, +3.550227153e-03f, +2.093220328e-03f, -3.789016888e-03f, -7.243512536e-03f, -1.281863951e-03f, +9.929260895e-03f, +1.174470262e-02f, -3.379229683e-03f, -2.078410057e-02f, -1.530831696e-02f, +1.587526117e-02f, +3.862508523e-02f, +1.432611104e-02f, -4.650716500e-02f, -7.336094727e-02f, +3.502870548e-03f, +1.727807943e-01f, +3.300961487e-01f, +3.603341019e-01f, +2.403505066e-01f, +6.022773377e-02f, -5.844858492e-02f, -6.526856989e-02f, -7.021465538e-03f, +3.597730034e-02f, +2.796234188e-02f, -5.484412646e-03f, -2.238865355e-02f, -1.107084906e-02f, +7.786832807e-03f, +1.250542206e-02f, +2.990224753e-03f, -6.212300190e-03f, -5.872563574e-03f, +1.723330052e-04f, +3.658089200e-03f, +2.121250504e-03f, -7.846249043e-04f, -1.571565982e-03f, -4.815036912e-04f, +4.505864383e-04f, +4.022220566e-04f,
    -1.293196236e-05f, +2.831127739e-07f, +3.342900398e-05f, +3.392799952e-05f, -3.336966467e-05f, -9.880445341e-05f, -3.984357343e-05f, +1.304927459e-04f, +1.958446757e-04f, -1.756217103e-05f, -3.253162721e-04f, -2.898462597e-04f, +2.117612916e-04f, +6.395347426e-04f, +3.067481615e-04f, -6.476937013e-04f, -1.093440348e-03f, -1.221199429e-04f, +1.548525361e-03f, +1.845094954e-03f, -5.096686415e-04f, -4.140277667e-03f, -5.801141337e-03f, -3.439161406e-03f, +1.538164326e-03f, +5.331273993e-03f, +5.232241289e-03f, +1.999968260e-03f, -1.197032172e-03f, -1.953297415e-03f, -5.764561357e-04f, +8.739545383e-04f, +9.655496663e-04f, +5.516322276e-05f, -6.153311316e-04f, -4.409660155e-04f, +1.256122270e-04f, +3.732817758e-04f, +1.551919137e-04f, -1.421631704e-04f, -1.847553464e-04f, -2.479259607e-05f, +9.423247423e-05f, +6.771082165e-05f, -1.357345076e-05f, -4.118124412e-05f, -1.347274469e-05f, +1.133121540e-05f,
    -2.514472832e-04f, -7.992261485e-04f, -4.759138339e-04f, +1.688854033e-03f, +2.877094622e-03f, -8.820358799e-04f, -6.437823692e-03f, -3.918560355e-03f, +7.810668581e-03f, +1.264529368e-02f, -2.253585003e-03f, -2.053176710e-02f, -1.209474305e-02f, +1.948740943e-02f, +3.013982913e-02f, -3.898008290e-03f, -4.051228333e-02f, -2.299661418e-02f, +3.249150943e-02f, +4.816787947e-02f, -4.878953368e-03f, -5.594272481e-02f, -3.060344051e-02f, +3.896315252e-02f, +5.545643630e-02f, -4.456111943e-03f, -5.641218009e-02f, -2.974733433e-02f, +3.428656913e-02f, +4.685300781e-02f, -2.843516418e-03f, -4.156195119e-02f, -2.111975682e-02f, +2.173339462e-02f, +2.846943050e-02f, -1.070080522e-03f, -2.146682265e-02f, -1.050632189e-02f, +9.227201126e-03f, +1.155285038e-02f, -3.520138210e-05f, -6.886849670e-03f, -3.250803560e-03f, +2.107557093e-03f, +2.518500402e-03f, +1.742306135e-04f, -8.870469913e-04f, -4.022220566e-04f,
    +1.293196236e-05f, +1.479810028e-05f, -4.065622061e-05f, -7.804961113e-05f, +2.710958291e-05f, +1.880574393e-04f, +1.006102801e-04f, -2.611726881e-04f, -3.731787393e-04f, +1.418588860e-04f, +6.819225126e-04f, +2.837076758e-04f, -7.711091956e-04f, -9.307838329e-04f, +3.850290623e-04f, +1.462991477e-03f, +4.982027884e-04f, -1.451539319e-03f, -1.537263510e-03f, +6.834162386e-04f, +2.162153822e-03f, +6.101382732e-04f, -1.931453568e-03f, -1.820655579e-03f, +8.616755363e-04f, +2.323318986e-03f, +5.389280292e-04f, -1.881609933e-03f, -1.582053332e-03f, +7.913969501e-04f, +1.831169253e-03f, +3.392018486e-04f, -1.336001281e-03f, -9.932493695e-04f, +5.214749907e-04f, +1.027442075e-03f, +1.425595170e-04f, -6.590306087e-04f, -4.224952597e-04f, +2.299836744e-04f, +3.740600133e-04f, +3.338734227e-05f, -1.969179001e-04f, -1.017319127e-04f, +5.505634216e-05f, +6.642328452e-05f, +2.024337558e-06f, -1.133121540e-05f,
    /*  6,23 (48) */
    +2.385153209e-04f, +5.303343893e-04f, +8.087861927e-06f, -1.239460223e-03f, -1.428829831e-03f, +8.367845291e-04f, +3.510383580e-03f, +2.223713074e-03f, -3.593172212e-03f, -7.261074707e-03f, -1.607180223e-03f, +9.639414635e-03f, +1.195646391e-02f, -2.739694940e-03f, -2.047735241e-02f, -1.595601066e-02f, +1.478182082e-02f, +3.850296528e-02f, +1.587463640e-02f, -4.466207004e-02f, -7.387061591e-02f, -6.374071197e-04f, +1.669796530e-01f, +3.266569873e-01f, +3.618722662e-01f, +2.456817806e-01f, +6.545997506e-02f, -5.644861666e-02f, -6.646560206e-02f, -8.974762953e-03f, +3.540084421e-02f, +2.883629642e-02f, -4.518862979e-03f, -2.233349033e-02f, -1.168618019e-02f, +7.345866792e-03f, +1.263103429e-02f, +3.363506529e-03f, -6.057108276e-03f, -6.014726745e-03f, -1.242234118e-05f, +3.633296604e-03f, +2.215482978e-03f, -7.169140826e-04f, -1.585139433e-03f, -5.226849353e-04f, +4.371136936e-04f, +4.135532720e-04f,
    -1.286604092e-05f, -5.908061777e-07f, +3.254258310e-05f, +3.497349141e-05f, -3.063836572e-05f, -9.814304120e-05f, -4.404656456e-05f, +1.253399165e-04f, +1.978263266e-04f, -7.427417591e-06f, -3.187360982e-04f, -2.990891982e-04f, +1.930062863e-04f, +6.353258038e-04f, +3.304156074e-04f, -6.184411672e-04f, -1.099457111e-03f, -1.717746382e-04f, +1.505606117e-03f, +1.875207023e-03f, -4.023527308e-04f, -4.039191267e-03f, -5.807412922e-03f, -3.569013395e-03f, +1.379657921e-03f, +5.265596469e-03f, +5.295767933e-03f, +2.118380642e-03f, -1.127971061e-03f, -1.970398609e-03f, -6.320555428e-04f, +8.463047818e-04f, +9.837220297e-04f, +8.608201384e-05f, -6.071083201e-04f, -4.565275267e-04f, +1.099969455e-04f, +3.736965314e-04f, +1.657220273e-04f, -1.359381228e-04f, -1.876528999e-04f, -3.033295803e-05f, +9.279399612e-05f, +7.010488204e-05f, -1.152259533e-05f, -4.141577321e-05f, -1.457939881e-05f, +1.099984113e-05f,
    -2.385153209e-04f, -7.844280482e-04f, -5.165700545e-04f, +1.610804422e-03f, +2.904204205e-03f, -6.939784406e-04f, -6.337213412e-03f, -4.179733044e-03f, +7.437489841e-03f, +1.278715257e-02f, -1.571662490e-03f, -2.024805943e-02f, -1.286585224e-02f, +1.855662560e-02f, +3.052485820e-02f, -2.435016814e-03f, -4.001408054e-02f, -2.444815350e-02f, +3.095424592e-02f, +4.885129570e-02f, -2.716799546e-03f, -5.533258654e-02f, -3.253489408e-02f, +3.714249694e-02f, +5.631811183e-02f, -2.132792957e-03f, -5.587325206e-02f, -3.162894426e-02f, +3.270451580e-02f, +4.764440476e-02f, -1.012347165e-03f, -4.122274934e-02f, -2.245575810e-02f, +2.074014525e-02f, +2.899090549e-02f, -4.263844613e-05f, -2.132426314e-02f, -1.116535250e-02f, +8.804705866e-03f, +1.178283406e-02f, +3.388586312e-04f, -6.853462328e-03f, -3.447721460e-03f, +2.005825180e-03f, +2.573556744e-03f, +2.406538980e-04f, -8.850226537e-04f, -4.135532720e-04f,
    +1.286604092e-05f, +1.565328426e-05f, -3.846759729e-05f, -7.864986146e-05f, +2.167294376e-05f, +1.852550607e-04f, +1.089437530e-04f, -2.501024122e-04f, -3.793368971e-04f, +1.197095174e-04f, +6.759568904e-04f, +3.122880098e-04f, -7.432466222e-04f, -9.513450014e-04f, +3.344320979e-04f, +1.456416562e-03f, +5.572134148e-04f, -1.405918285e-03f, -1.578307649e-03f, +6.052932368e-04f, +2.160137196e-03f, +6.944528796e-04f, -1.878578852e-03f, -1.877114848e-03f, +7.747026606e-04f, +2.328907250e-03f, +6.264524348e-04f, -1.837333188e-03f, -1.638106717e-03f, +7.206033657e-04f, +1.841861095e-03f, +4.054899386e-04f, -1.309885380e-03f, -1.033360712e-03f, +4.804177901e-04f, +1.037450173e-03f, +1.778475050e-04f, -6.491725796e-04f, -4.421746762e-04f, +2.144204917e-04f, +3.796149388e-04f, +4.519728111e-05f, -1.952132355e-04f, -1.074248073e-04f, +5.208803166e-05f, +6.801936589e-05f, +3.730547622e-06f, -1.099984113e-05f,
    /*  6,24 (48) */
    +2.256492799e-04f, +5.297435832e-04f, +4.063044502e-05f, -1.204486732e-03f, -1.459468197e-03f, +7.386414879e-04f, +3.466337015e-03f, +2.349052990e-03f, -3.395345886e-03f, -7.268502124e-03f, -1.925916321e-03f, +9.340325437e-03f, +1.214947020e-02f, -2.104369136e-03f, -2.014693680e-02f, -1.657445183e-02f, +1.368236371e-02f, +3.833119065e-02f, +1.738024252e-02f, -4.278686302e-02f, -7.427296864e-02f, -4.676598387e-03f, +1.611722401e-01f, +3.230879739e-01f, +3.632519241e-01f, +2.509473770e-01f, +7.075574299e-02f, -5.433023602e-02f, -6.759357313e-02f, -1.094516156e-02f, +3.476878867e-02f, +2.968260120e-02f, -3.535140950e-03f, -2.224740832e-02f, -1.229328851e-02f, +6.889339265e-03f, +1.274103123e-02f, +3.737203061e-03f, -5.891386249e-03f, -6.150664868e-03f, -2.000752410e-04f, +3.602963646e-03f, +2.308276975e-03f, -6.468092006e-04f, -1.596662028e-03f, -5.641007085e-04f, +4.225342948e-04f, +4.245531131e-04f,
    -1.277663204e-05f, -1.438952877e-06f, +3.162554815e-05f, +3.594233741e-05f, -2.791572988e-05f, -9.735108524e-05f, -4.811586372e-05f, +1.200915124e-04f, +1.995027847e-04f, +2.575357107e-06f, -3.118067665e-04f, -3.078052584e-04f, +1.742243306e-04f, +6.303124963e-04f, +3.533532580e-04f, -5.887224336e-04f, -1.103947105e-03f, -2.205573646e-04f, +1.461349932e-03f, +1.902486547e-03f, -2.965535273e-04f, -3.936183247e-03f, -5.809449348e-03f, -3.695984295e-03f, +1.220020865e-03f, +5.195828866e-03f, +5.355931279e-03f, +2.236795531e-03f, -1.056304658e-03f, -1.985203607e-03f, -6.875801614e-04f, +8.171726146e-04f, +1.000799786e-03f, +1.172644383e-04f, -5.979583844e-04f, -4.716592936e-04f, +9.402941106e-05f, +3.735988633e-04f, +1.761672149e-04f, -1.294304454e-04f, -1.903282540e-04f, -3.592135816e-05f, +9.119382763e-05f, +7.244037263e-05f, -9.410201707e-06f, -4.158924427e-05f, -1.569108148e-05f, +1.063688973e-05f,
    -2.256492799e-04f, -7.687747640e-04f, -5.550376518e-04f, +1.532154561e-03f, +2.925877149e-03f, -5.087233799e-04f, -6.228269659e-03f, -4.429835456e-03f, +7.058152944e-03f, +1.290686209e-02f, -8.957056000e-04f, -1.993577142e-02f, -1.360909887e-02f, +1.760528059e-02f, +3.085929029e-02f, -9.786002519e-04f, -3.945686713e-02f, -2.585407178e-02f, +2.937593827e-02f, +4.945658894e-02f, -5.566623497e-04f, -5.463813366e-02f, -3.441347293e-02f, +3.526538209e-02f, +5.709281450e-02f, +1.961142931e-04f, -5.524679963e-02f, -3.346627745e-02f, +3.106640908e-02f, +4.836500812e-02f, +8.295139303e-04f, -4.081725940e-02f, -2.376564348e-02f, +1.970678454e-02f, +2.947132328e-02f, +9.948117267e-04f, -2.114641563e-02f, -1.181452508e-02f, +8.362531190e-03f, +1.199725455e-02f, +7.184735700e-04f, -6.808265047e-03f, -3.642934695e-03f, +1.898400373e-03f, +2.625644776e-03f, +3.086732639e-04f, -8.812921061e-04f, -4.245531131e-04f,
    +1.277663204e-05f, +1.644502299e-05f, -3.627381541e-05f, -7.909352851e-05f, +1.632438305e-05f, +1.821957554e-04f, +1.169418174e-04f, -2.388029525e-04f, -3.847828278e-04f, +9.766612121e-05f, +6.689749892e-04f, +3.400513450e-04f, -7.144751560e-04f, -9.702090995e-04f, +2.837074452e-04f, +1.447583542e-03f, +6.149814725e-04f, -1.358322287e-03f, -1.616683612e-03f, +5.265038580e-04f, +2.154730967e-03f, +7.775001628e-04f, -1.822822929e-03f, -1.930593536e-03f, +6.864947182e-04f, +2.330838826e-03f, +7.131425620e-04f, -1.790050839e-03f, -1.691760662e-03f, +6.483808839e-04f, +1.849689529e-03f, +4.715174124e-04f, -1.281511380e-03f, -1.072126567e-03f, +4.382401831e-04f, +1.045884839e-03f, +2.132238567e-04f, -6.381420856e-04f, -4.613875835e-04f, +1.982775184e-04f, +3.846256007e-04f, +5.714141947e-05f, -1.931394007e-04f, -1.130564007e-04f, +4.895038091e-05f, +6.953402739e-05f, +5.488598499e-06f, -1.063688973e-05f,
    /*  6,25 (48) */
    +2.128726479e-04f, +5.283046303e-04f, +7.225599318e-05f, -1.168544394e-03f, -1.487383927e-03f, +6.412904027e-04f, +3.418221151e-03f, +2.469144503e-03f, -3.195843101e-03f, -7.265926767e-03f, -2.237723088e-03f, +9.032520179e-03f, +1.232369453e-02f, -1.474056640e-03f, -1.979358354e-02f, -1.716317426e-02f, +1.257841660e-02f, +3.811063328e-02f, +1.884159245e-02f, -4.088437647e-02f, -7.456952217e-02f, -8.612781634e-03f, +1.553627907e-01f, +3.193919896e-01f, +3.644719450e-01f, +2.561432059e-01f, +7.611167427e-02f, -5.209344049e-02f, -6.864987778e-02f, -1.293036517e-02f, +3.408120850e-02f, +3.049977381e-02f, -2.534341164e-03f, -2.213014388e-02f, -1.289124690e-02f, +6.417679971e-03f, +1.283506064e-02f, +4.110801924e-03f, -5.715219034e-03f, -6.280095313e-03f, -3.904034950e-04f, +3.567042288e-03f, +2.399470802e-03f, -5.743688280e-04f, -1.606072230e-03f, -6.056899527e-04f, +4.068432133e-04f, +4.351900028e-04f,
    -1.266456791e-05f, -2.260456842e-06f, +3.068012551e-05f, +3.683459133e-05f, -2.520575530e-05f, -9.643206018e-05f, -5.204772384e-05f, +1.147565375e-04f, +2.008761034e-04f, +1.243395811e-05f, -3.045424952e-04f, -3.159891480e-04f, +1.554413590e-04f, +6.245113053e-04f, +3.755391344e-04f, -5.585824193e-04f, -1.106923101e-03f, -2.684167601e-04f, +1.415829765e-03f, +1.926943287e-03f, -1.923566759e-04f, -3.831363317e-03f, -5.807272982e-03f, -3.819976279e-03f, +1.059383497e-03f, +5.122012995e-03f, +5.412653779e-03f, +2.355101077e-03f, -9.820734400e-04f, -1.997661437e-03f, -7.429579806e-04f, +7.865775689e-04f, +1.016746838e-03f, +1.486716681e-04f, -5.878825260e-04f, -4.863352246e-04f, +7.772730152e-05f, +3.729821955e-04f, +1.865115568e-04f, -1.226453846e-04f, -1.927741706e-04f, -4.155035540e-05f, +8.943157738e-05f, +7.471261742e-05f, -7.238374544e-06f, -4.170001406e-05f, -1.680595422e-05f, +1.024220231e-05f,
    -2.128726479e-04f, -7.523297410e-04f, -5.913114672e-04f, +1.453061032e-03f, +2.942201532e-03f, -3.265276245e-04f, -6.111327841e-03f, -4.668638408e-03f, +6.673370117e-03f, +1.300452821e-02f, -2.267306108e-04f, -1.959572007e-02f, -1.432357402e-02f, +1.663507149e-02f, +3.114299774e-02f, +4.689832901e-04f, -3.884188566e-02f, -2.721239407e-02f, +2.775925466e-02f, +4.998309280e-02f, +1.598068617e-03f, -5.386063349e-02f, -3.623629586e-02f, +3.333478856e-02f, +5.777930921e-02f, +2.526953119e-03f, -5.453365707e-02f, -3.525632829e-02f, +2.937464842e-02f, +4.901338901e-02f, +2.679203460e-03f, -4.034574199e-02f, -2.504715486e-02f, +1.863465797e-02f, +2.990956347e-02f, +2.040696565e-03f, -2.093319177e-02f, -1.245266717e-02f, +7.901143606e-03f, +1.219553207e-02f, +1.103099171e-03f, -6.751123627e-03f, -3.836074096e-03f, +1.785343972e-03f, +2.674595157e-03f, +3.782072913e-04f, -8.758035076e-04f, -4.351900028e-04f,
    +1.266456791e-05f, +1.717373175e-05f, -3.407937034e-05f, -7.938372451e-05f, +1.107160032e-05f, +1.788900391e-04f, +1.245967078e-04f, -2.272972249e-04f, -3.895178720e-04f, +7.576391290e-05f, +6.610005937e-04f, +3.669611382e-04f, -6.848506056e-04f, -9.873605329e-04f, +2.329380412e-04f, +1.436522367e-03f, +6.714217553e-04f, -1.308837966e-03f, -1.652341818e-03f, +4.471764115e-04f, +2.145953423e-03f, +8.591502741e-04f, -1.764278523e-03f, -1.981008035e-03f, +5.971921956e-04f, +2.329107182e-03f, +7.988584839e-04f, -1.739831097e-03f, -1.742921408e-03f, +5.748396599e-04f, +1.854628048e-03f, +5.371762618e-04f, -1.250910379e-03f, -1.109473904e-03f, +3.950015605e-04f, +1.052717418e-03f, +2.486311244e-04f, -6.259438306e-04f, -4.800957835e-04f, +1.815738499e-04f, +3.890748647e-04f, +6.920130012e-05f, -1.906929491e-04f, -1.186151225e-04f, +4.564518926e-05f, +7.096202782e-05f, +7.296413674e-06f, -1.024220231e-05f,
    /*  6,26 (48) */
    +2.002080800e-04f, +5.260441735e-04f, +1.029361187e-04f, -1.131709803e-03f, -1.512589682e-03f, +5.448583425e-04f, +3.366173427e-03f, +2.583901040e-03f, -2.994966997e-03f, -7.253492809e-03f, -2.542265583e-03f, +8.716531031e-03f, +1.247913589e-02f, -8.495453346e-04f, -1.941804441e-02f, -1.772175668e-02f, +1.147149350e-02f, +3.784221652e-02f, +2.025742222e-02f, -3.895743318e-02f, -7.476187885e-02f, -1.244414495e-02f, +1.495555178e-01f, +3.155720133e-01f, +3.655313285e-01f, +2.612652189e-01f, +8.152432805e-02f, -4.973833941e-02f, -6.963195122e-02f, -1.492802661e-02f, +3.333825052e-02f, +3.128635138e-02f, -1.517594326e-03f, -2.198147221e-02f, -1.347912942e-02f, +5.931344747e-03f, +1.291278795e-02f, +4.483784119e-03f, -5.528707477e-03f, -6.402740698e-03f, -5.831776656e-04f, +3.525491932e-03f, +2.488902380e-03f, -4.996562106e-04f, -1.613310604e-03f, -6.473899668e-04f, +3.900372591e-04f, +4.454322052e-04f,
    -1.253070546e-05f, -3.054515381e-06f, +2.970854302e-05f, +3.765042989e-05f, -2.251234812e-05f, -9.538957497e-05f, -5.583866130e-05f, +1.093439878e-04f, +2.019487425e-04f, +2.213655910e-05f, -2.969577884e-04f, -3.236363777e-04f, +1.366829950e-04f, +6.179395883e-04f, +3.969525186e-04f, -5.280660766e-04f, -1.108399673e-03f, -3.153032321e-04f, +1.369119190e-03f, +1.948589975e-03f, -8.984542406e-05f, -3.724842225e-03f, -5.800910076e-03f, -3.940894468e-03f, +8.978771603e-04f, +5.044194584e-03f, +5.465860778e-03f, +2.473184673e-03f, -9.053210094e-04f, -2.007723215e-03f, -7.981162878e-04f, +7.545412919e-04f, +1.031528156e-03f, +1.802641175e-04f, -5.768832206e-04f, -5.005295418e-04f, +6.110897977e-05f, +3.718405999e-04f, +1.967390650e-04f, -1.155886614e-04f, -1.949836418e-04f, -4.721233222e-05f, +8.750709462e-05f, +7.691695648e-05f, -5.009354660e-06f, -4.174651130e-05f, -1.792213212e-05f, +9.815677156e-06f,
    -2.002080800e-04f, -7.351560092e-04f, -6.253908375e-04f, +1.373677308e-03f, +2.953273132e-03f, -1.476375854e-04f, -5.986731133e-03f, -4.895935633e-03f, +6.283852244e-03f, +1.308029212e-02f, +4.342699829e-04f, -1.922875894e-02f, -1.500842463e-02f, +1.564771096e-02f, +3.137593578e-02f, +1.905505657e-03f, -3.817046390e-02f, -2.852123204e-02f, +2.610691284e-02f, +5.043026921e-02f, +3.744022040e-03f, -5.300148322e-02f, -3.800057438e-02f, +3.135378052e-02f, +5.837650141e-02f, +4.856060301e-03f, -5.373479858e-02f, -3.699615939e-02f, +2.763172701e-02f, +4.958822867e-02f, +4.533831508e-03f, -3.980856572e-02f, -2.629806524e-02f, +1.752518407e-02f, +3.030456503e-02f, +3.093413984e-03f, -2.068456065e-02f, -1.307861100e-02f, +7.421047823e-03f, +1.237710592e-02f, +1.492174035e-03f, -6.681922327e-03f, -4.026767045e-03f, +1.666728850e-03f, +2.720240346e-03f, +4.491693191e-04f, -8.685070939e-04f, -4.454322052e-04f,
    +1.253070546e-05f, +1.783995335e-05f, -3.188863867e-05f, -7.952378569e-05f, +5.921951639e-06f, +1.753486718e-04f, +1.319014032e-04f, -2.156081422e-04f, -3.935445733e-04f, +5.403740792e-05f, +6.520588780e-04f, +3.929826645e-04f, -6.544296547e-04f, -1.002786671e-03f, +1.822062518e-04f, +1.423266428e-03f, +7.264517373e-04f, -1.257554585e-03f, -1.685237321e-03f, +3.674396180e-04f, +2.133828266e-03f, +9.392758951e-04f, -1.703042750e-03f, -2.028279749e-03f, +5.069373762e-04f, +2.323711714e-03f, +8.834616194e-04f, -1.686747109e-03f, -1.791498952e-03f, +5.000924368e-04f, +1.856654741e-03f, +6.023584774e-04f, -1.218117339e-03f, -1.145331498e-03f, +3.507635665e-04f, +1.057921668e-03f, +2.840112181e-04f, -6.125845522e-04f, -4.982614622e-04f, +1.643298167e-04f, +3.929463207e-04f, +8.135794825e-05f, -1.878710499e-04f, -1.240893005e-04f, +4.217462308e-05f, +7.229816771e-05f, +9.151747540e-06f, -9.815677156e-06f,
    /*  6,27 (48) */
    +1.876773745e-04f, +5.229896581e-04f, +1.326446617e-04f, -1.094059373e-03f, -1.535102030e-03f, +4.494687675e-04f, +3.310334766e-03f, +2.693245028e-03f, -2.793018255e-03f, -7.231356250e-03f, -2.839223371e-03f, +8.392894653e-03f, +1.261581888e-02f, -2.316057463e-04f, -1.902109189e-02f, -1.824982276e-02f, +1.036309383e-02f, +3.752691329e-02f, +2.162654141e-02f, -3.700884321e-02f, -7.485172427e-02f, -1.616898718e-02f, +1.437546077e-01f, +3.116311188e-01f, +3.664292057e-01f, +2.663094135e-01f, +8.699018883e-02f, -4.726515474e-02f, -7.053727223e-02f, -1.693574982e-02f, +3.254013424e-02f, +3.204089267e-02f, -4.860661693e-04f, -2.180120809e-02f, -1.405601264e-02f, +5.430815205e-03f, +1.297389693e-02f, +4.855624719e-03f, -5.331968412e-03f, -6.518329359e-03f, -7.781613074e-04f, +3.478279600e-03f, +2.576409474e-03f, -4.227392541e-04f, -1.618319959e-03f, -6.891364781e-04f, +3.721151269e-04f, +4.552478823e-04f,
    -1.237592426e-05f, -3.820393667e-06f, +2.871302625e-05f, +3.839015022e-05f, -1.983931782e-05f, -9.422736517e-05f, -5.948545712e-05f, +1.038628378e-04f, +2.027235592e-04f, +3.167171449e-05f, -2.890674119e-04f, -3.307432576e-04f, +1.179745186e-04f, +6.106155420e-04f, +4.175739665e-04f, -4.972183318e-04f, -1.108393160e-03f, -3.611689990e-04f, +1.321292299e-03f, +1.967442276e-03f, +1.089945062e-05f, -3.616731638e-03f, -5.790390724e-03f, -4.058647023e-03f, +7.356340633e-04f, +4.962423244e-03f, +5.515480599e-03f, +2.590933072e-03f, -8.260940707e-04f, -2.015342221e-03f, -8.529817484e-04f, +7.210875415e-04f, +1.045109832e-03f, +2.120014881e-04f, -5.649642299e-04f, -5.142168205e-04f, +4.419347652e-05f, +3.701688128e-04f, +2.068337056e-04f, -1.082664692e-04f, -1.969499038e-04f, -5.289950351e-05f, +8.542047327e-05f, +7.904875357e-05f, -2.725517788e-06f, -4.172724070e-05f, -1.903768623e-05f, +9.357271131e-06f,
    -1.876773745e-04f, -7.173160559e-04f, -6.572794762e-04f, +1.294153522e-03f, +2.959195084e-03f, +2.771108642e-05f, -5.854829730e-03f, -5.111543775e-03f, +5.890307671e-03f, +1.313432953e-02f, +1.086328861e-03f, -1.883577627e-02f, -1.566285428e-02f, +1.464492429e-02f, +3.155814203e-02f, +3.328772085e-03f, -3.744401216e-02f, -2.977878662e-02f, +2.442167552e-02f, +5.079770883e-02f, +5.877850305e-03f, -5.206220732e-02f, -3.970361713e-02f, +2.932550077e-02f, +5.888343879e-02f, +7.179772015e-03f, -5.285133696e-02f, -3.868290649e-02f, +2.584022806e-02f, +5.008832111e-02f, +6.390486249e-03f, -3.920620725e-02f, -2.751618258e-02f, +1.637985257e-02f, +3.065532859e-02f, +4.151335652e-03f, -2.040054943e-02f, -1.369119555e-02f, +6.922786361e-03f, +1.254143573e-02f, +1.885120356e-03f, -6.600564379e-03f, -4.214638095e-03f, +1.542639549e-03f, +2.762414969e-03f, +5.214674869e-04f, -8.593553464e-04f, -4.552478823e-04f,
    +1.237592426e-05f, +1.844435346e-05f, -2.970587195e-05f, -7.951726066e-05f, +8.824424543e-07f, +1.715826333e-04f, +1.388496268e-04f, -2.037585732e-04f, -3.968666565e-04f, +3.252037081e-05f, +6.421763456e-04f, +4.180830575e-04f, -6.232697581e-04f, -1.016477841e-03f, +1.315937390e-04f, +1.407852481e-03f, +7.799916939e-04f, -1.204563872e-03f, -1.715329861e-03f, +2.874223964e-04f, +2.118384554e-03f, +1.017752442e-03f, -1.639216953e-03f, -2.072335209e-03f, +4.158741060e-04f, +2.314657752e-03f, +9.668149639e-04f, -1.630876849e-03f, -1.837407206e-03f, +4.242543686e-04f, +1.855752352e-03f, +6.669562287e-04f, -1.183171051e-03f, -1.179630067e-03f, +3.055900125e-04f, +1.061473822e-03f, +3.193054982e-04f, -5.980730325e-04f, -5.158472603e-04f, +1.465669659e-04f, +3.962243230e-04f, +9.359189777e-05f, -1.846715044e-04f, -1.294671807e-04f, +3.854121934e-05f, +7.353730115e-05f, +1.105218590e-05f, -9.357271131e-06f,
    /*  6,28 (48) */
    +1.753014503e-04f, +5.191692644e-04f, +1.613576880e-04f, -1.055669223e-03f, -1.554941348e-03f, +3.552414023e-04f, +3.250849309e-03f, +2.797107866e-03f, -2.590294696e-03f, -7.199684535e-03f, -3.128290783e-03f, +8.062151396e-03f, +1.273379340e-02f, +3.790097958e-04f, -1.860351792e-02f, -1.874704109e-02f, +9.254700667e-03f, +3.716574429e-02f, +2.294783371e-02f, -3.504140093e-02f, -7.484082482e-02f, -1.978571881e-02f, +1.379642170e-01f, +3.075724718e-01f, +3.671648397e-01f, +2.712718367e-01f, +9.250566943e-02f, -4.467422166e-02f, -7.136336630e-02f, -1.895109204e-02f, +3.168715249e-02f, +3.276198022e-02f, +5.590436624e-04f, -2.158920660e-02f, -1.462097687e-02f, +4.916598384e-03f, +1.301809040e-02f, +5.225793532e-03f, -5.125134706e-03f, -6.626595828e-03f, -9.751112112e-04f, +3.425380097e-03f, +2.661829947e-03f, -3.436905005e-04f, -1.621045477e-03f, -7.308637188e-04f, +3.530774407e-04f, +4.646051534e-04f,
    -1.220112428e-05f, -4.557424696e-06f, +2.769579466e-05f, +3.905416716e-05f, -1.719037284e-05f, -9.294928507e-05f, -6.298515782e-05f, +9.832202803e-05f, +2.032037984e-04f, +4.102837087e-05f, -2.808863692e-04f, -3.373068931e-04f, +9.934083637e-05f, +6.025581680e-04f, +4.373853199e-04f, -4.660840266e-04f, -1.106921623e-03f, -4.059681292e-04f, +1.272423616e-03f, +1.983518747e-03f, +1.097997096e-04f, -3.507144024e-03f, -5.775748818e-03f, -4.173145228e-03f, +5.727871543e-04f, +4.876752428e-03f, +5.561444633e-03f, +2.708232495e-03f, -7.444424040e-04f, -2.020473974e-03f, -9.074804882e-04f, +6.862421796e-04f, +1.057459136e-03f, +2.438428143e-04f, -5.521306107e-04f, -5.273720285e-04f, +2.700047156e-05f, +3.679622505e-04f, +2.167794209e-04f, -1.006854710e-04f, -1.986664501e-04f, -5.860392582e-05f, +8.317205561e-05f, +8.110340390e-05f, -3.893731059e-07f, -4.164078698e-05f, -2.015064614e-05f, +8.867001001e-06f,
    -1.753014503e-04f, -6.988717024e-04f, -6.869853482e-04f, +1.214636261e-03f, +2.960077526e-03f, +1.992937197e-04f, -5.715980103e-03f, -5.315302348e-03f, +5.493441015e-03f, +1.316684990e-02f, +1.728505206e-03f, -1.841769321e-02f, -1.628612404e-02f, +1.362844645e-02f, +3.168973577e-02f, +4.736624566e-03f, -3.666402047e-02f, -3.098335049e-02f, +2.270634566e-02f, +5.108513123e-02f, +7.996234859e-03f, -5.104445488e-02f, -4.134283408e-02f, +2.725316557e-02f, +5.929931289e-02f, +9.494429766e-03f, -5.188452200e-02f, -4.031378334e-02f, +2.400282086e-02f, +5.051257547e-02f, +8.246238601e-03f, -3.853925102e-02f, -2.869935363e-02f, +1.520022250e-02f, +3.096091860e-02f, +5.212809473e-03f, -2.008124393e-02f, -1.428926858e-02f, +6.406939100e-03f, +1.268800270e-02f, +2.281344679e-03f, -6.506972481e-03f, -4.399309599e-03f, +1.413172369e-03f, +2.800956188e-03f, +5.950047880e-04f, -8.483031605e-04f, -4.646051534e-04f,
    +1.220112428e-05f, +1.898771574e-05f, -2.753519081e-05f, -7.936789852e-05f, -4.040278685e-06f, +1.676030986e-04f, +1.454358454e-04f, -1.917713026e-04f, -3.994890047e-04f, +1.124576621e-05f, +6.313807691e-04f, +4.422313454e-04f, -5.914290376e-04f, -1.028427323e-03f, +8.118132958e-05f, +1.390320562e-03f, +8.319648170e-04f, -1.149959854e-03f, -1.742583914e-03f, +2.072536508e-04f, +2.099656640e-03f, +1.094458265e-03f, -1.572906527e-03f, -2.113106202e-03f, +3.241475586e-04f, +2.301956556e-03f, +1.048783316e-03f, -1.572302999e-03f, -1.880564154e-03f, +3.474428399e-04f, +1.851908327e-03f, +7.308620442e-04f, -1.146114099e-03f, -1.212302398e-03f, +2.595467868e-04f, +1.063352654e-03f, +3.544548708e-04f, -5.824201054e-04f, -5.328163443e-04f, +1.283080387e-04f, +3.988940296e-04f, +1.058832189e-04f, -1.810927613e-04f, -1.347369482e-04f, +3.474788864e-05f, +7.467434777e-05f, +1.299514687e-05f, -8.867001001e-06f,
    /*  6,29 (48) */
    +1.631003260e-04f, +5.146118397e-04f, +1.890534826e-04f, -1.016615056e-03f, -1.572131721e-03f, +2.622921173e-04f, +3.187864151e-03f, +2.895429894e-03f, -2.387090897e-03f, -7.158656165e-03f, -3.409177152e-03f, +7.724844502e-03f, +1.283313424e-02f, +9.815679637e-04f, -1.816613260e-02f, -1.921312512e-02f, +8.147779044e-03f, +3.675977616e-02f, +2.422025732e-02f, -3.305788219e-02f, -7.473102511e-02f, -2.329286284e-02f, +1.321884681e-01f, +3.033993266e-01f, +3.677376269e-01f, +2.761485891e-01f, +9.806711406e-02f, -4.196598917e-02f, -7.210780871e-02f, -2.097156602e-02f, +3.077967200e-02f, +3.344822240e-02f, +1.616502798e-03f, -2.134536379e-02f, -1.517310748e-02f, +4.389226356e-03f, +1.304509087e-02f, +5.593755782e-03f, -4.908355286e-03f, -6.727281299e-03f, -1.173777661e-03f, +3.366776171e-03f, +2.745002003e-03f, -2.625870966e-04f, -1.621434850e-03f, -7.725045058e-04f, +3.329267946e-04f, +4.734721544e-04f,
    -1.200722377e-05f, -5.265009118e-06f, +2.665905792e-05f, +3.964301044e-05f, -1.456911640e-05f, -9.155929989e-05f, -6.633507579e-05f, +9.273045181e-05f, +2.033930824e-04f, +5.019587769e-05f, -2.724298771e-04f, -3.433251790e-04f, +8.080645084e-05f, +5.937872373e-04f, +4.563697166e-04f, -4.347078605e-04f, -1.104004805e-03f, -4.496565782e-04f, +1.222587999e-03f, +1.996840788e-03f, +2.067797193e-04f, -3.396192524e-03f, -5.757022002e-03f, -4.284303580e-03f, +4.094699856e-04f, +4.787239382e-03f, +5.603687422e-03f, +2.824968759e-03f, -6.604188335e-04f, -2.023076302e-03f, -9.615381760e-04f, +6.500331626e-04f, +1.068544575e-03f, +2.757465103e-04f, -5.383887230e-04f, -5.399705649e-04f, +9.550274047e-06f, +3.652170240e-04f, +2.265601524e-04f, -9.285279645e-05f, -2.001270451e-04f, -6.431750700e-05f, +8.076243575e-05f, +8.307634195e-05f, +1.996438486e-06f, -4.148581872e-05f, -2.125900262e-05f, +8.344944653e-06f,
    -1.631003260e-04f, -6.798839867e-04f, -7.145205390e-04f, +1.135268363e-03f, +2.956037248e-03f, +3.668968183e-04f, -5.570544258e-03f, -5.507073651e-03f, +5.093952010e-03f, +1.317809567e-02f, +2.359885976e-03f, -1.797546187e-02f, -1.687755308e-02f, +1.260001913e-02f, +3.177091710e-02f, +6.126945128e-03f, -3.583205565e-02f, -3.213331035e-02f, +2.096376174e-02f, +5.129238488e-02f, +1.009589150e-02f, -4.994999662e-02f, -4.291574061e-02f, +2.514005936e-02f, +5.962346045e-02f, +1.179638632e-02f, -5.083573868e-02f, -4.188608634e-02f, +2.212225670e-02f, +5.086001831e-02f, +1.009814693e-02f, -3.780838897e-02f, -2.984546773e-02f, +1.398792011e-02f, +3.122046539e-02f, +6.276162127e-03f, -1.972678906e-02f, -1.487168869e-02f, +5.874122756e-03f, +1.281631074e-02f, +2.680238709e-03f, -6.401089262e-03f, -4.580402361e-03f, +1.278435420e-03f, +2.835704077e-03f, +6.696791358e-04f, -8.353080136e-04f, -4.734721544e-04f,
    +1.200722377e-05f, +1.947093683e-05f, -2.538057954e-05f, -7.907963685e-05f, -8.839925616e-06f, +1.634214139e-04f, +1.516552664e-04f, -1.796689918e-04f, -4.014176345e-04f, -9.754288189e-06f, +6.197011272e-04f, +4.653984841e-04f, -5.589661769e-04f, -1.038631332e-03f, +3.104888631e-05f, +1.370713898e-03f, +8.822973255e-04f, -1.093838693e-03f, -1.766968726e-03f, +1.270620581e-04f, +2.077684101e-03f, +1.169274842e-03f, -1.504220745e-03f, -2.150529871e-03f, +2.319039960e-04f, +2.285625305e-03f, +1.129233506e-03f, -1.511112825e-03f, -1.920891995e-03f, +2.697772798e-04f, +1.845114860e-03f, +7.939689928e-04f, -1.106992809e-03f, -1.243283477e-03f, +2.127017604e-04f, +1.063539538e-03f, +3.893998840e-04f, -5.656386610e-04f, -5.491324766e-04f, +1.095769468e-04f, +4.009414406e-04f, +1.182115470e-04f, -1.771339313e-04f, -1.398867490e-04f, +3.079791745e-05f, +7.570430487e-05f, +1.497788212e-05f, -8.344944653e-06f,
    /*  6,30 (48) */
    +1.510931022e-04f, +5.093468306e-04f, +2.157125405e-04f, -9.769720453e-04f, -1.586700837e-03f, +1.707328174e-04f, +3.121529075e-03f, +2.988160346e-03f, -2.183697815e-03f, -7.108460287e-03f, -3.681607029e-03f, +7.381519323e-03f, +1.291394069e-02f, +1.575355201e-03f, -1.770976289e-02f, -1.964783298e-02f, +7.043774239e-03f, +3.631011958e-02f, +2.544284532e-02f, -3.106104140e-02f, -7.452424539e-02f, -2.668905536e-02f, +1.264314461e-01f, +2.991150230e-01f, +3.681470969e-01f, +2.809358285e-01f, +1.036708015e-01f, -3.914102041e-02f, -7.276822754e-02f, -2.299464232e-02f, +2.981813382e-02f, +3.409825556e-02f, +2.685047373e-03f, -2.106961728e-02f, -1.571149621e-02f, +3.849255791e-03f, +1.305464115e-02f, +5.958972806e-03f, -4.681795133e-03f, -6.820134096e-03f, -1.373904706e-03f, +3.302458664e-03f, +2.825764439e-03f, -1.795107547e-04f, -1.619438411e-03f, -8.139903245e-04f, +3.116677919e-04f, +4.818170991e-04f,
    -1.179515707e-05f, -5.942614945e-06f, +2.560501230e-05f, +4.015732169e-05f, -1.197904264e-05f, -9.006147782e-05f, -6.953278931e-05f, +8.709694318e-05f, +2.032954010e-04f, +5.916399725e-05f, -2.637133416e-04f, -3.487967929e-04f, +6.239543190e-05f, +5.843232553e-04f, +4.745115978e-04f, -4.031343334e-04f, -1.099664087e-03f, -4.921922220e-04f, +1.171860555e-03f, +2.007432595e-03f, +3.017665142e-04f, -3.283990837e-03f, -5.734251616e-03f, -4.392039864e-03f, +2.458165803e-04f, +4.693945103e-03f, +5.642146737e-03f, +2.941027388e-03f, -5.740791932e-04f, -2.023109414e-03f, -1.015080108e-03f, +6.124905293e-04f, +1.078335946e-03f, +3.076704192e-04f, -5.237462362e-04f, -5.519882992e-04f, -8.136198435e-06f, +3.619299538e-04f, +2.361598639e-04f, -8.477603732e-05f, -2.013257369e-04f, -7.003201622e-05f, +7.819246260e-05f, +8.496304936e-05f, +4.429146330e-06f, -4.126109227e-05f, -2.236071049e-05f, +7.791242229e-06f,
    -1.510931022e-04f, -6.604130498e-04f, -7.399011185e-04f, +1.056188726e-03f, +2.947197322e-03f, +5.303182322e-04f, -5.418888992e-03f, -5.686742643e-03f, +4.692534375e-03f, +1.316834138e-02f, +2.979587103e-03f, -1.751006338e-02f, -1.743651926e-02f, +1.156138780e-02f, +3.180196599e-02f, +7.497659026e-03f, -3.494975833e-02f, -3.322714904e-02f, +1.919679302e-02f, +5.141944693e-02f, +1.217357560e-02f, -4.878072178e-02f, -4.441996135e-02f, +2.298952949e-02f, +5.985536445e-02f, +1.408201163e-02f, -4.970650518e-02f, -4.339719917e-02f, +2.020136471e-02f, +5.112979559e-02f, +1.194326179e-02f, -3.701441998e-02f, -3.095246054e-02f, +1.274463663e-02f, +3.143316715e-02f, +7.339701665e-03f, -1.933738918e-02f, -1.543732735e-02f, +5.324990279e-03f, +1.292588768e-02f, +3.081180149e-03f, -6.282877715e-03f, -4.757536292e-03f, +1.138548671e-03f, +2.866501994e-03f, +7.453834406e-04f, -8.203301315e-04f, -4.818170991e-04f,
    +1.179515707e-05f, +1.989502124e-05f, -2.324588111e-05f, -7.865658953e-05f, -1.351057922e-05f, +1.590490714e-04f, +1.575038342e-04f, -1.674741398e-04f, -4.026596693e-04f, -3.044856647e-05f, +6.071675411e-04f, +4.875573858e-04f, -5.259403172e-04f, -1.047088999e-03f, -1.872481803e-05f, +1.349078811e-03f, +9.309185690e-04f, -1.036298510e-03f, -1.788458344e-03f, +4.697585680e-05f, +2.052511654e-03f, +1.242086964e-03f, -1.433272568e-03f, -2.184548817e-03f, +1.392905295e-04f, +2.265687070e-03f, +1.208034611e-03f, -1.447398043e-03f, -1.958317289e-03f, +1.913789724e-04f, +1.835368929e-03f, +8.561708638e-04f, -1.065857194e-03f, -1.272510612e-03f, +1.651246880e-04f, +1.062018502e-03f, +4.240808264e-04f, -5.477436456e-04f, -5.647600865e-04f, +9.039874540e-05f, +4.023534357e-04f, +1.305561128e-04f, -1.727947999e-04f, -1.449047117e-04f, +2.669496967e-05f, +7.662225966e-05f, +1.699747862e-05f, -7.791242229e-06f,
    /*  6,31 (48) */
    +1.392979451e-04f, +5.034042156e-04f, +2.413175528e-04f, -9.368147236e-04f, -1.598679880e-03f, +8.067133956e-05f, +3.051996286e-03f, +3.075257289e-03f, -1.980402414e-03f, -7.049296290e-03f, -3.945320371e-03f, +7.032722530e-03f, +1.297633612e-02f, +2.159678456e-03f, -1.723525129e-02f, -2.005096731e-02f, +5.944110152e-03f, +3.581792736e-02f, +2.661470588e-02f, -2.905360880e-02f, -7.422247888e-02f, -2.997304620e-02f, +1.206971945e-01f, +2.947229831e-01f, +3.683929135e-01f, +2.856297736e-01f, +1.093129482e-01f, -3.619999302e-02f, -7.334230673e-02f, -2.501775173e-02f, +2.880305371e-02f, +3.471074609e-02f, +3.763383320e-03f, -2.076194686e-02f, -1.623524244e-02f, +3.297267492e-03f, +1.304650495e-02f, +6.320902760e-03f, -4.445635269e-03f, -6.904910133e-03f, -1.575230443e-03f, +3.232426648e-03f, +2.903956901e-03f, -9.454770530e-05f, -1.615009265e-03f, -8.552514168e-04f, +2.893070814e-04f, +4.896083413e-04f,
    -1.156587247e-05f, -6.589777155e-06f, +2.453583715e-05f, +4.059785137e-05f, -9.423532883e-06f, -8.845998205e-05f, -7.257614213e-05f, +8.143026444e-05f, +2.029151000e-04f, +6.792291394e-05f, -2.547523335e-04f, -3.537211876e-04f, +4.413138857e-05f, +5.741874250e-04f, +4.917967149e-04f, -3.714076894e-04f, -1.093922442e-03f, -5.335348884e-04f, +1.120316544e-03f, +2.015321110e-03f, +3.946898559e-04f, -3.170653092e-03f, -5.707482646e-03f, -4.496275233e-03f, +8.196129835e-05f, +4.596934279e-03f, +5.676763658e-03f, +3.056293732e-03f, -4.854822889e-04f, -2.020535961e-03f, -1.068031294e-03f, +5.736463860e-04f, +1.086804390e-03f, +3.395718620e-04f, -5.082121336e-04f, -5.634016105e-04f, -2.603744181e-05f, +3.580985825e-04f, +2.455625648e-04f, -7.646324280e-05f, -2.022568705e-04f, -7.573909431e-05f, +7.546324261e-05f, +8.675906281e-05f, +6.905852224e-06f, -4.096545548e-05f, -2.345369145e-05f, +7.206097170e-06f,
    -1.392979451e-04f, -6.405180286e-04f, -7.631469996e-04f, +9.775321364e-04f, +2.933686743e-03f, +6.893673036e-04f, -5.261385157e-03f, -5.854216783e-03f, +4.289874706e-03f, +1.313789281e-02f, +3.586754644e-03f, -1.702250600e-02f, -1.796245957e-02f, +1.051429880e-02f, +3.178324117e-02f, +8.846737837e-03f, -3.401883976e-02f, -3.426344755e-02f, +1.740833467e-02f, +5.146642279e-02f, +1.422608725e-02f, -4.753863481e-02f, -4.585323392e-02f, +2.080498068e-02f, +5.999465498e-02f, +1.634769870e-02f, -4.849847057e-02f, -4.484459721e-02f, +1.824304742e-02f, +5.132117457e-02f, +1.377863072e-02f, -3.615824912e-02f, -3.201831773e-02f, +1.147212602e-02f, +3.159829184e-02f, +8.401720167e-03f, -1.891330835e-02f, -1.598507100e-02f, +4.760230193e-03f, +1.301628643e-02f, +3.483533585e-03f, -6.152321602e-03f, -4.930331092e-03f, +9.936439597e-04f, +2.893196964e-03f, +8.220057003e-04f, -8.033326528e-04f, -4.896083413e-04f,
    +1.156587247e-05f, +2.026107605e-05f, -2.113479253e-05f, -7.810303453e-05f, -1.804669126e-05f, +1.544976859e-04f, +1.629782250e-04f, -1.552090461e-04f, -4.032233109e-04f, -5.080677731e-05f, +5.938112090e-04f, +5.086829447e-04f, -4.924109527e-04f, -1.053802351e-03f, -6.806222398e-05f, +1.325464625e-03f, +9.777611267e-04f, -9.774392195e-04f, -1.807031638e-03f, -3.287736205e-05f, +2.024189074e-03f, +1.312782922e-03f, -1.360178459e-03f, -2.215111194e-03f, +4.645487730e-05f, +2.242170783e-03f, +1.285058184e-03f, -1.381254679e-03f, -1.992771091e-03f, +1.123708632e-04f, +1.822672317e-03f, +9.173623485e-04f, -1.022760899e-03f, -1.299923556e-03f, +1.168871057e-04f, +1.058776278e-03f, +4.584378263e-04f, -5.287520583e-04f, -5.796643399e-04f, +7.079960453e-05f, +4.031178103e-04f, +1.428957736e-04f, -1.680758405e-04f, -1.497789702e-04f, +2.244308745e-05f, +7.742340156e-05f, +1.905086070e-05f, -7.206097170e-06f,
    /*  7, 0 (48) */
    +0.000000000e+00f, -5.184284022e-04f, +3.212229602e-06f, +1.307536639e-03f, +8.360763470e-04f, -2.118986788e-03f, -2.852738276e-03f, +2.109164081e-03f, +6.105712658e-03f, -1.950685165e-05f, -9.834821711e-03f, -5.434403018e-03f, +1.219436233e-02f, +1.497172437e-02f, -1.025017254e-02f, -2.819089092e-02f, +4.350570367e-05f, +4.333632545e-02f, +2.439525774e-02f, -5.757751269e-02f, -7.936955118e-02f, +6.777629950e-02f, +3.088165774e-01f, +4.285159846e-01f, +3.088165774e-01f, +6.777629950e-02f, -7.936955118e-02f, -5.757751269e-02f, +2.439525774e-02f, +4.333632545e-02f, +4.350570367e-05f, -2.819089092e-02f, -1.025017254e-02f, +1.497172437e-02f, +1.219436233e-02f, -5.434403018e-03f, -9.834821711e-03f, -1.950685165e-05f, +6.105712658e-03f, +2.109164081e-03f, -2.852738276e-03f, -2.118986788e-03f, +8.360763470e-04f, +1.307536639e-03f, +3.212229602e-06f, -5.184284022e-04f, -1.234425141e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +4.402830756e-06f, -3.645794608e-05f, -2.934893968e-05f, +6.301990736e-05f, +9.261259788e-05f, -6.715667929e-05f, -2.008609397e-04f, +5.663638279e-06f, +3.341017752e-04f, +1.706534758e-04f, -4.324003844e-04f, -4.953746677e-04f, +3.913250279e-04f, +9.603516939e-04f, -6.404349089e-05f, -1.491008734e-03f, -7.546410229e-04f, +1.908165098e-03f, +2.478253380e-03f, -1.675039053e-03f, -6.961821842e-03f, -6.839105062e-03f, -1.284161757e-04f, +6.711386426e-03f, +7.067661105e-03f, +1.857870170e-03f, -2.418878930e-03f, -1.982443748e-03f, +6.867150942e-04f, +1.510974108e-03f, +1.161613155e-04f, -9.540569351e-04f, -4.237344909e-04f, +4.796149263e-04f, +4.482795641e-04f, -1.549617571e-04f, -3.390588754e-04f, -1.711613663e-05f, +2.003082109e-04f, +7.377878167e-05f, -9.040208288e-05f, -6.603770382e-05f, +2.747022415e-05f, +3.750518317e-05f, -3.401044618e-06f, -1.367129889e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +5.184284022e-04f, -3.212229602e-06f, -1.888597505e-03f, -1.236145466e-03f, +3.592023527e-03f, +4.047052782e-03f, -4.982450802e-03f, -8.918259580e-03f, +4.834186303e-03f, +1.556156622e-02f, -1.810767405e-03f, -2.277524083e-02f, -4.954253986e-03f, +2.859390823e-02f, +1.529315124e-02f, -3.084300852e-02f, -2.774230592e-02f, +2.793154400e-02f, +3.977726494e-02f, -1.956380632e-02f, -4.852880250e-02f, +7.038976371e-03f, +5.173229864e-02f, +7.038976371e-03f, -4.852880250e-02f, -1.956380632e-02f, +3.977726494e-02f, +2.793154400e-02f, -2.774230592e-02f, -3.084300852e-02f, +1.529315124e-02f, +2.859390823e-02f, -4.954253986e-03f, -2.277524083e-02f, -1.810767405e-03f, +1.556156622e-02f, +4.834186303e-03f, -8.918259580e-03f, -4.982450802e-03f, +4.047052782e-03f, +3.592023527e-03f, -1.236145466e-03f, -1.888597505e-03f, +7.853369693e-05f, +5.184284022e-04f, +1.234425141e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -4.402830756e-06f, +3.645794608e-05f, +4.990674596e-05f, -1.015072581e-04f, -1.466967147e-04f, +1.503045336e-04f, +3.210858882e-04f, -1.523377155e-04f, -5.718326359e-04f, +5.538729978e-05f, +8.642556210e-04f, +1.831321024e-04f, -1.130066542e-03f, -5.730390367e-04f, +1.282908753e-03f, +1.075471433e-03f, -1.246505957e-03f, -1.603675632e-03f, +9.852715527e-04f, +2.043673952e-03f, -5.241715658e-04f, -2.289024217e-03f, -5.221704922e-05f, +2.276646540e-03f, +6.230870902e-04f, -2.009071323e-03f, -1.068995934e-03f, +1.553665861e-03f, +1.308989800e-03f, -1.019137686e-03f, -1.322769487e-03f, +5.192197337e-04f, +1.150169523e-03f, -1.383111949e-04f, -8.701498844e-04f, -8.814437108e-05f, +5.697403375e-04f, +1.732332348e-04f, -3.161963751e-04f, -1.617501818e-04f, +1.422584669e-04f, +1.067364938e-04f, -4.720273898e-05f, -4.992298047e-05f, +3.401044618e-06f, +1.367129889e-05f, +0.000000000e+00f,
    /*  7, 1 (48) */
    +0.000000000e+00f, -5.140255714e-04f, -3.324571648e-05f, +1.278187699e-03f, +8.990962544e-04f, -2.026374191e-03f, -2.919894955e-03f, +1.908303142e-03f, +6.111376296e-03f, +3.145949235e-04f, -9.664168235e-03f, -5.866803403e-03f, +1.169898766e-02f, +1.536304940e-02f, -9.289820844e-03f, -2.825493441e-02f, -1.447503031e-03f, +4.258168443e-02f, +2.630342283e-02f, -5.509925932e-02f, -8.104459023e-02f, +6.081447766e-02f, +3.019774723e-01f, +4.283875684e-01f, +3.155279638e-01f, +7.484396060e-02f, -7.751168101e-02f, -5.999639162e-02f, +2.241281399e-02f, +4.402304055e-02f, +1.554479812e-03f, -2.807472961e-02f, -1.120422947e-02f, +1.454798988e-02f, +1.267397725e-02f, -4.986123454e-03f, -9.989783468e-03f, -3.585657271e-04f, +6.088596521e-03f, +2.309472292e-03f, -2.778959494e-03f, -2.209388871e-03f, +7.700386432e-04f, +1.335006863e-03f, +4.071741277e-05f, -5.218294468e-04f, -1.371138130e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +5.363231868e-06f, -3.536116739e-05f, -3.112411600e-05f, +5.994166238e-05f, +9.460233729e-05f, -6.052409654e-05f, -2.010276988e-04f, -5.622708085e-06f, +3.286002227e-04f, +1.858136918e-04f, -4.159446280e-04f, -5.100302025e-04f, +3.586215482e-04f, +9.648401929e-04f, -1.247875202e-05f, -1.468661393e-03f, -8.202888207e-04f, +1.831730441e-03f, +2.532396482e-03f, -1.493629345e-03f, -6.850181348e-03f, -6.959632173e-03f, -3.851071098e-04f, +6.576588681e-03f, +7.167524184e-03f, +2.041903873e-03f, -2.354278168e-03f, -2.054408452e-03f, +6.165977888e-04f, +1.528490732e-03f, +1.687455178e-04f, -9.459444776e-04f, -4.557867798e-04f, +4.627657440e-04f, +4.635448853e-04f, -1.387605929e-04f, -3.434541995e-04f, -2.871543078e-05f, +1.993642683e-04f, +8.037719661e-05f, -8.797104486e-05f, -6.898759360e-05f, +2.548962186e-05f, +3.849926784e-05f, -2.359131188e-06f, -1.395240629e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +5.140255714e-04f, +3.324571648e-05f, -1.838690760e-03f, -1.337652724e-03f, +3.445326813e-03f, +4.197357316e-03f, -4.661364913e-03f, -9.070597296e-03f, +4.262353667e-03f, +1.561695352e-02f, -9.465117840e-04f, -2.259210873e-02f, -6.084320528e-03f, +2.802086920e-02f, +1.657605999e-02f, -2.976753709e-02f, -2.898881188e-02f, +2.632786837e-02f, +4.076253650e-02f, -1.752013237e-02f, -4.905297407e-02f, +4.749952153e-03f, +5.168008159e-02f, +9.315622911e-03f, -4.790571541e-02f, -2.157287765e-02f, +3.870826901e-02f, +2.948520986e-02f, -2.643331612e-02f, -3.186214621e-02f, +1.397038175e-02f, +2.911312797e-02f, -3.804084463e-03f, -2.291355203e-02f, -2.680917289e-03f, +1.547342185e-02f, +5.403926640e-03f, -8.745026346e-03f, -5.298647177e-03f, +3.885302601e-03f, +3.734281994e-03f, -1.129408972e-03f, -1.935800244e-03f, +2.861071646e-05f, +5.218294468e-04f, +1.371138130e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -5.363231868e-06f, +3.536116739e-05f, +5.242115229e-05f, -9.617976463e-05f, -1.507233495e-04f, +1.387530092e-04f, +3.252146092e-04f, -1.314375733e-04f, -5.727039945e-04f, +2.291445353e-05f, +8.566381906e-04f, +2.271364703e-04f, -1.107813740e-03f, -6.252668419e-04f, +1.240686479e-03f, +1.129274547e-03f, -1.181780527e-03f, -1.650202515e-03f, +8.998052987e-04f, +2.074017417e-03f, -4.243447843e-04f, -2.296715000e-03f, -1.565431243e-04f, +2.259603869e-03f, +7.208850167e-04f, -1.970271063e-03f, -1.150799020e-03f, +1.500263071e-03f, +1.369090876e-03f, -9.603762505e-04f, -1.360169373e-03f, +4.639097211e-04f, +1.168061624e-03f, -9.276064125e-05f, -8.742896207e-04f, -1.211189995e-04f, +5.664150925e-04f, +1.940785686e-04f, -3.105441002e-04f, -1.730623710e-04f, +1.374100914e-04f, +1.118528453e-04f, -4.431058451e-05f, -5.177662578e-05f, +2.359131188e-06f, +1.395240629e-05f, +0.000000000e+00f,
    /*  7, 2 (48) */
    +0.000000000e+00f, -5.086623395e-04f, -6.860688387e-05f, +1.247063583e-03f, +9.590379168e-04f, -1.931771853e-03f, -2.980419051e-03f, +1.707275443e-03f, +6.105753588e-03f, +6.431951462e-04f, -9.478354543e-03f, -6.282748031e-03f, +1.118895746e-02f, +1.572167095e-02f, -8.324980651e-03f, -2.826741316e-02f, -2.916164424e-03f, +4.176139561e-02f, +2.813515328e-02f, -5.256686283e-02f, -8.253821958e-02f, +5.396429631e-02f, +2.950178402e-01f, +4.280024613e-01f, +3.221045525e-01f, +8.201148479e-02f, -7.546977714e-02f, -6.235066979e-02f, +2.035840554e-02f, +4.463963834e-02f, +3.082970544e-03f, -2.790598409e-02f, -1.215017395e-02f, +1.409220310e-02f, +1.313674300e-02f, -4.522578569e-03f, -1.012854406e-02f, -7.020199266e-04f, +6.059881091e-03f, +2.508836561e-03f, -2.698582297e-03f, -2.297359916e-03f, +7.010510496e-04f, +1.360496485e-03f, +7.921668061e-05f, -5.241885780e-04f, -1.510662193e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +6.281120501e-06f, -3.421848615e-05f, -3.279435594e-05f, +5.681040703e-05f, +9.637149550e-05f, -5.389403999e-05f, -2.008143956e-04f, -1.672415031e-05f, +3.225723242e-04f, +2.004216370e-04f, -3.989501581e-04f, -5.235689730e-04f, +3.256869626e-04f, +9.675369667e-04f, +3.844823356e-05f, -1.444002155e-03f, -8.835766843e-04f, +1.753299022e-03f, +2.581310828e-03f, -1.313855934e-03f, -6.732920928e-03f, -7.072864687e-03f, -6.413739816e-04f, +6.434833450e-03f, +7.261242746e-03f, +2.226917682e-03f, -2.284463820e-03f, -2.123902846e-03f, +5.443807266e-04f, +1.543495271e-03f, +2.217074795e-04f, -9.360060371e-04f, -4.874186029e-04f, +4.448440945e-04f, +4.781597261e-04f, -1.220733051e-04f, -3.472712501e-04f, -4.044158950e-05f, +1.980245521e-04f, +8.693853995e-05f, -8.532019059e-05f, -7.186211401e-05f, +2.340904202e-05f, +3.943662641e-05f, -1.278478377e-06f, -1.420592772e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +5.086623395e-04f, +6.860688387e-05f, -1.786269607e-03f, -1.433832489e-03f, +3.294603463e-03f, +4.336110325e-03f, -4.336150304e-03f, -9.202034869e-03f, +3.689649672e-03f, +1.563986797e-02f, -8.987359339e-05f, -2.236497226e-02f, -7.192134268e-03f, +2.739560235e-02f, +1.781674647e-02f, -2.863826254e-02f, -3.017059240e-02f, +2.467766585e-02f, +4.166234180e-02f, -1.544611496e-02f, -4.947731885e-02f, +2.453237153e-03f, +5.152353847e-02f, +1.157522678e-02f, -4.718483039e-02f, -2.354314871e-02f, +3.755746999e-02f, +3.098547293e-02f, -2.506422524e-02f, -3.282252246e-02f, +1.261021237e-02f, +2.957703769e-02f, -2.636022839e-03f, -2.300631267e-02f, -3.555206910e-03f, +1.535230285e-02f, +5.970341733e-03f, -8.550947777e-03f, -5.609191277e-03f, +3.712240230e-03f, +3.871692085e-03f, -1.017556127e-03f, -1.980110829e-03f, -2.316590932e-05f, +5.241885780e-04f, +1.510662193e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -6.281120501e-06f, +3.421848615e-05f, +5.474500924e-05f, -9.076854688e-05f, -1.543378622e-04f, +1.271229364e-04f, +3.285861621e-04f, -1.105777184e-04f, -5.723689113e-04f, -9.208901701e-06f, +8.473323064e-04f, +2.702399750e-04f, -1.083476215e-03f, -6.758064862e-04f, +1.196206297e-03f, +1.180449996e-03f, -1.114958710e-03f, -1.693164308e-03f, +8.127796729e-04f, +2.100049250e-03f, -3.238146663e-04f, -2.299706817e-03f, -2.605453583e-04f, +2.237927891e-03f, +8.173610248e-04f, -1.927343658e-03f, -1.230504856e-03f, +1.443564632e-03f, +1.426672350e-03f, -8.992957936e-04f, -1.395013665e-03f, +4.072137252e-04f, +1.183685991e-03f, -4.656973925e-05f, -8.766469271e-04f, -1.542432463e-04f, +5.618474442e-04f, +2.148275953e-04f, -3.041287796e-04f, -1.842133237e-04f, +1.321540652e-04f, +1.168416268e-04f, -4.123224846e-05f, -5.356478109e-05f, +1.278478377e-06f, +1.420592772e-05f, +0.000000000e+00f,
    /*  7, 3 (48) */
    +0.000000000e+00f, -5.023812190e-04f, -1.028253700e-04f, +1.214269227e-03f, +1.015848324e-03f, -1.835400358e-03f, -3.034313091e-03f, +1.506461047e-03f, +6.089029438e-03f, +9.657674704e-04f, -9.277932906e-03f, -6.681698189e-03f, +1.066538848e-02f, +1.604735791e-02f, -7.357443684e-03f, -2.822896493e-02f, -4.360166579e-03f, +4.087781893e-02f, +2.988845230e-02f, -4.998555200e-02f, -8.385207551e-02f, +4.723137538e-02f, +2.879449755e-01f, +4.273610873e-01f, +3.285393859e-01f, +8.927272753e-02f, -7.324285945e-02f, -6.463513361e-02f, +1.823450269e-02f, +4.518401906e-02f, +4.626465814e-03f, -2.768427661e-02f, -1.308617999e-02f, +1.360478450e-02f, +1.358158709e-02f, -4.044418843e-03f, -1.025061737e-02f, -1.049291177e-03f, +6.019439501e-03f, +2.706861113e-03f, -2.611643757e-03f, -2.382680107e-03f, +6.291889356e-04f, +1.383905527e-03f, +1.186533070e-04f, -5.254670563e-04f, -1.652721470e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +7.155499268e-06f, -3.303356079e-05f, -3.435851553e-05f, +5.363354428e-05f, +9.792070572e-05f, -4.727929308e-05f, -2.002275795e-04f, -2.762256769e-05f, +3.160369234e-04f, +2.144578550e-04f, -3.814553423e-04f, -5.359806252e-04f, +2.925838239e-04f, +9.684595838e-04f, +8.865496331e-05f, -1.417104224e-03f, -9.444278384e-04f, +1.673031134e-03f, +2.625006558e-03f, -1.135929496e-03f, -6.610227950e-03f, -7.178708984e-03f, -8.969347129e-04f, +6.286251430e-03f, +7.348655345e-03f, +2.412685758e-03f, -2.209456350e-03f, -2.190772398e-03f, +4.701602984e-04f, +1.555927983e-03f, +2.749568061e-04f, -9.242365355e-04f, -5.185666495e-04f, +4.258691551e-04f, +4.920882012e-04f, -1.049244523e-04f, -3.504943998e-04f, -5.227413708e-05f, +1.962852063e-04f, +9.344927460e-05f, -8.245068760e-05f, -7.465381357e-05f, +2.123065152e-05f, +4.031373136e-05f, -1.606038524e-07f, -1.443029105e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +5.023812190e-04f, +1.028253700e-04f, -1.731524598e-03f, -1.524601036e-03f, +3.140265601e-03f, +4.463233262e-03f, -4.007564142e-03f, -9.312612588e-03f, +3.117280761e-03f, +1.563065907e-02f, +7.574587130e-04f, -2.209473228e-02f, -8.275610483e-03f, +2.671979587e-02f, +1.901295276e-02f, -2.745781254e-02f, -3.128555111e-02f, +2.298450154e-02f, +4.247512147e-02f, -1.334606571e-02f, -4.980113352e-02f, +1.535303363e-04f, +5.126299311e-02f, +1.381315467e-02f, -4.636746937e-02f, -2.547049237e-02f, +3.632696513e-02f, +3.242903756e-02f, -2.363755289e-02f, -3.372181825e-02f, +1.121519871e-02f, +2.998425141e-02f, -1.452336848e-03f, -2.305288241e-02f, -4.431853837e-03f, +1.519805960e-02f, +6.532189177e-03f, -8.336120182e-03f, -5.913320056e-03f, +3.528026906e-03f, +4.003846151e-03f, -9.007144999e-04f, -2.021343077e-03f, -7.673069041e-05f, +5.254670563e-04f, +1.652721470e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -7.155499268e-06f, +3.303356079e-05f, +5.687786299e-05f, -8.528801151e-05f, -1.575407020e-04f, +1.154413295e-04f, +3.312057915e-04f, -8.980231717e-05f, -5.708443107e-04f, -4.091902851e-05f, +8.363759240e-04f, +3.123610207e-04f, -1.057122928e-03f, -7.245656074e-04f, +1.149575910e-03f, +1.228906834e-03f, -1.046189401e-03f, -1.732486615e-03f, +7.243798566e-04f, +2.121726136e-03f, -2.227902696e-04f, -2.297997438e-03f, -3.640086191e-04f, +2.211660024e-03f, +9.123132502e-04f, -1.880368423e-03f, -1.307941340e-03f, +1.383675242e-03f, +1.481602044e-03f, -8.360105083e-04f, -1.427212413e-03f, +3.492402140e-04f, +1.196990134e-03f, +1.699807130e-07f, -8.771974561e-04f, -1.874480376e-04f, +5.560305404e-04f, +2.354337306e-04f, -2.969518419e-04f, -1.951751290e-04f, +1.264938699e-04f, +1.216881284e-04f, -3.797021669e-05f, -5.528070823e-05f, +1.606038524e-07f, +1.443029105e-05f, +0.000000000e+00f,
    /*  7, 4 (48) */
    +0.000000000e+00f, -4.952257198e-04f, -1.358589308e-04f, +1.179910712e-03f, +1.069481868e-03f, -1.737479652e-03f, -3.081592384e-03f, +1.306233468e-03f, +6.061406870e-03f, +1.281804394e-03f, -9.063475051e-03f, -7.063153531e-03f, +1.012940786e-02f, +1.633994173e-02f, -6.388984100e-03f, -2.814030997e-02f, -5.777270803e-03f, +3.993339109e-02f, +3.156148343e-02f, -4.736054545e-02f, -8.498800501e-02f, +4.062114743e-02f, +2.807662665e-01f, +4.264641526e-01f, +3.348256374e-01f, +9.662138288e-02f, -7.083017370e-02f, -6.684458996e-02f, +1.604373029e-02f, +4.565417936e-02f, +6.182393798e-03f, -2.740931980e-02f, -1.401041652e-02f, +1.308621785e-02f, +1.400745625e-02f, -3.552330642e-03f, -1.035554182e-02f, -1.399785577e-03f, +5.967165364e-03f, +2.903146319e-03f, -2.518194483e-03f, -2.465130794e-03f, +5.545351220e-04f, +1.405136178e-03f, +1.589670384e-04f, -5.256276602e-04f, -1.797024380e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +7.985500330e-06f, -3.181006045e-05f, -3.581570155e-05f, +5.041842712e-05f, +9.925103113e-05f, -4.069239427e-05f, -1.992744192e-04f, -3.830049673e-05f, +3.090135547e-04f, +2.279042196e-04f, -3.634989747e-04f, -5.472570011e-04f, +2.593742174e-04f, +9.676285787e-04f, +1.380612193e-04f, -1.388043770e-03f, -1.002770603e-03f, +1.591087852e-03f, +2.663501277e-03f, -9.600562222e-04f, -6.482295563e-03f, -7.277080996e-03f, -1.151508169e-03f, +6.130982232e-03f, +7.429607677e-03f, +2.598979196e-03f, -2.129284004e-03f, -2.254864673e-03f, +3.940375622e-04f, +1.565732871e-03f, +3.284014664e-04f, -9.106341493e-04f, -5.491677055e-04f, +4.058622990e-04f, +5.052952394e-04f, -8.733979986e-05f, -3.531089337e-04f, -6.419208530e-05f, +1.941430972e-04f, +9.989573536e-05f, -7.936416972e-05f, -7.735526809e-05f, +1.895687537e-05f, +4.112711044e-05f, +9.928457007e-07f, -1.462395980e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.952257198e-04f, +1.358589308e-04f, -1.674646735e-03f, -1.609889047e-03f, +2.982724899e-03f, +4.578674591e-03f, -3.676358351e-03f, -9.402414905e-03f, +2.546436450e-03f, +1.558974004e-02f, +1.593834637e-03f, -2.178237126e-02f, -9.332733411e-03f, +2.599523026e-02f, +2.016252867e-02f, -2.622890571e-02f, -3.233174051e-02f, +2.125201493e-02f, +4.319950132e-02f, -1.122433957e-02f, -5.002392379e-02f, -2.144467102e-03f, +5.089898449e-02f, +1.602481470e-02f, -4.545515612e-02f, -2.735086079e-02f, +3.501902379e-02f, +3.381271281e-02f, -2.215595085e-02f, -3.455782876e-02f, +9.787986297e-03f, +3.033349163e-02f, -2.553467138e-04f, -2.305271243e-02f, -5.309051293e-03f, +1.501061156e-02f, +7.088219717e-03f, -8.100686451e-03f, -6.210271898e-03f, +3.332851777e-03f, +4.130340021e-03f, -7.790263715e-04f, -2.059313294e-03f, -1.320113986e-04f, +5.256276602e-04f, +1.797024380e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -7.985500330e-06f, +3.181006045e-05f, +5.881974410e-05f, -7.975240632e-05f, -1.603332576e-04f, +1.037348326e-04f, +3.330803253e-04f, -6.915470437e-05f, -5.681494757e-04f, -7.215383980e-05f, +8.238101248e-04f, +3.534208899e-04f, -1.028826526e-03f, -7.714563107e-04f, +1.100906835e-03f, +1.274560359e-03f, -9.756248546e-04f, -1.768102977e-03f, +6.347933102e-04f, +2.139013986e-03f, -1.214813444e-04f, -2.291594477e-03f, -4.667189164e-04f, +2.180851332e-03f, +1.005542717e-03f, -1.829433348e-03f, -1.382940602e-03f, +1.320706728e-03f, +1.533752739e-03f, -7.706398975e-04f, -1.456680690e-03f, +2.901011902e-04f, +1.207926078e-03f, +4.736493450e-05f, -8.759205059e-04f, -2.206633037e-04f, +5.489601822e-04f, +2.558500265e-04f, -2.890164525e-04f, -2.059198058e-04f, +1.204340034e-04f, +1.263776520e-04f, -3.452750106e-05f, -5.691766838e-05f, -9.928457007e-07f, +1.462395980e-05f, +0.000000000e+00f,
    /*  7, 5 (48) */
    +0.000000000e+00f, -4.872402194e-04f, -1.676689913e-04f, +1.144095010e-03f, +1.119900295e-03f, -1.638228621e-03f, -3.122284779e-03f, +1.106959049e-03f, +6.023106374e-03f, +1.590817949e-03f, -8.835570832e-03f, -7.426652506e-03f, +9.582150857e-03f, +1.659931595e-02f, -5.421355521e-03f, -2.800224875e-02f, -7.165314573e-03f, +3.893062048e-02f, +3.315257128e-02f, -4.469704417e-02f, -8.594806123e-02f, +3.413885187e-02f, +2.734891855e-01f, +4.253126445e-01f, +3.409566196e-01f, +1.040509906e-01f, -6.823119450e-02f, -6.897387397e-02f, +1.378886562e-02f, +4.604821692e-02f, +7.748126668e-03f, -2.708091834e-02f, -1.492105067e-02f, +1.253705014e-02f, +1.441331855e-02f, -3.047035402e-03f, -1.044288162e-02f, -1.752894510e-03f, +5.902973279e-03f, +3.097289416e-03f, -2.418298747e-03f, -2.544494964e-03f, +4.771798539e-04f, +1.424093054e-03f, +2.000941488e-04f, -5.246348145e-04f, -1.943263978e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +8.770384584e-06f, -3.055165641e-05f, -3.716526842e-05f, +4.717234406e-05f, +1.003639553e-04f, -3.414561603e-05f, -1.979626789e-04f, -4.874115534e-05f, +3.015223972e-04f, +2.407439523e-04f, -3.451201979e-04f, -5.573921262e-04f, +2.261196541e-04f, +9.650673803e-04f, +1.865891824e-04f, -1.356899769e-03f, -1.058538454e-03f, +1.507630778e-03f, +2.696819961e-03f, -7.864375643e-04f, -6.349322397e-03f, -7.367906298e-03f, -1.404814536e-03f, +5.969174217e-03f, +7.503952826e-03f, +2.785566329e-03f, -2.043982842e-03f, -2.316029593e-03f, +3.161181312e-04f, +1.572857817e-03f, +3.819479360e-04f, -8.952003513e-04f, -5.791587704e-04f, +3.848470823e-04f, +5.177466597e-04f, -6.934628683e-05f, -3.551010896e-04f, -7.617396702e-05f, +1.915958308e-04f, +1.062641544e-04f, -7.606274189e-05f, -7.995909681e-05f, +1.659039649e-05f, +4.187335580e-05f, +2.180095653e-06f, -1.478543797e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.872402194e-04f, +1.676689913e-04f, -1.615826991e-03f, -1.689641453e-03f, +2.822391641e-03f, +4.682409424e-03f, -3.343278025e-03f, -9.471569609e-03f, +1.978286975e-03f, +1.551758620e-02f, +2.417644762e-03f, -2.142895037e-02f, -1.036155994e-02f, +2.522377395e-02f, +2.126343551e-02f, -2.495434535e-02f, -3.330736537e-02f, +1.948391195e-02f, +4.383429464e-02f, -9.085325584e-03f, -5.014540513e-02f, -4.436061579e-03f, +5.043226558e-02f, +1.820566603e-02f, -4.444961340e-02f, -2.918029414e-02f, +3.363608319e-02f, +3.513341953e-02f, -2.062219811e-02f, -3.532846866e-02f, +8.331305607e-03f, +3.062359282e-02f, +9.525793645e-04f, -2.300534749e-02f, -6.184971799e-03f, +1.478994826e-02f, +7.637179899e-03f, -7.844836425e-03f, -6.499288351e-03f, +3.126931971e-03f, +4.250774024e-03f, -6.526487195e-04f, -2.093840795e-03f, -1.889290670e-04f, +5.246348145e-04f, +1.943263978e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -8.770384584e-06f, +3.055165641e-05f, +6.057115596e-05f, -7.417578898e-05f, -1.627178350e-04f, +9.202966494e-05f, +3.342181337e-04f, -4.867729821e-05f, -5.643059740e-04f, -1.028530154e-04f, +8.096789935e-04f, +3.933438867e-04f, -9.986631499e-04f, -8.163953233e-04f, +1.050314142e-03f, +1.317332257e-03f, -9.034203447e-04f, -1.799954978e-03f, +5.442093688e-04f, +2.151887982e-03f, -2.009788815e-05f, -2.280515365e-03f, -5.684638544e-04f, +2.145562425e-03f, +1.096853765e-03f, -1.774634935e-03f, -1.455339376e-03f, +1.254777836e-03f, +1.583002471e-03f, -7.033085484e-04f, -1.483338804e-03f, +2.299119763e-04f, +1.216450505e-03f, +9.491966892e-05f, -8.727991044e-04f, -2.538181231e-04f, +5.406348675e-04f, +2.760292722e-04f, -2.803275333e-04f, -2.164193667e-04f, +1.139799881e-04f, +1.308955478e-04f, -3.090764417e-05f, -5.846894037e-05f, -2.180095653e-06f, +1.478543797e-05f, +0.000000000e+00f,
    /*  7, 6 (48) */
    +0.000000000e+00f, -4.784698349e-04f, -1.982206477e-04f, +1.106929742e-03f, +1.167072639e-03f, -1.537864666e-03f, -3.156430395e-03f, +9.089963697e-04f, +5.974365218e-03f, +1.892340346e-03f, -8.594826879e-03f, -7.771772704e-03f, +9.024758730e-03f, +1.682543560e-02f, -4.456288141e-03f, -2.781565957e-02f, -8.522214343e-03f, +3.787208203e-02f, +3.466020206e-02f, -4.200022421e-02f, -8.673449879e-02f, +2.778952947e-02f, +2.661212792e-01f, +4.239078299e-01f, +3.469257938e-01f, +1.115549434e-01f, -6.544562817e-02f, -7.101785681e-02f, +1.147283603e-02f, +4.636433506e-02f, +9.320984485e-03f, -2.669897040e-02f, -1.581625102e-02f, +1.195789137e-02f, +1.479816563e-02f, -2.529288742e-03f, -1.051222790e-02f, -2.107995600e-03f, +5.826799312e-03f, +3.288885247e-03f, -2.312034593e-03f, -2.620557706e-03f, +3.972207571e-04f, +1.440683450e-03f, +2.419675046e-04f, -5.224547188e-04f, -2.091118358e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +9.509540550e-06f, -2.926201376e-05f, -3.840681472e-05f, +4.390250510e-05f, +1.012613717e-04f, -2.765094472e-05f, -1.963006941e-04f, -5.892846530e-05f, +2.935842267e-04f, +2.529616351e-04f, -3.263584260e-04f, -5.663821937e-04f, +1.928809655e-04f, +9.608022356e-04f, +2.341635411e-04f, -1.323753831e-03f, -1.111670068e-03f, +1.422821778e-03f, +2.724994848e-03f, -6.152699801e-04f, -6.211512263e-03f, -7.451120177e-03f, -1.656575693e-03f, +5.800984315e-03f, +7.571551505e-03f, +2.972213043e-03f, -1.953596747e-03f, -2.374119699e-03f, +2.365120531e-04f, +1.577254726e-03f, +4.355013456e-04f, -8.779399475e-04f, -6.084771756e-04f, +3.628492277e-04f, +5.294092466e-04f, -5.097199019e-05f, -3.564580986e-04f, -8.819787101e-05f, +1.886417687e-04f, +1.125406874e-04f, -7.254898397e-05f, -8.245797894e-05f, +1.413415498e-05f, +4.254913318e-05f, +3.399244831e-06f, -1.491327491e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.784698349e-04f, +1.982206477e-04f, -1.555255835e-03f, -1.763817242e-03f, +2.659673806e-03f, +4.774439089e-03f, -3.009059891e-03f, -9.520246907e-03f, +1.413981001e-03f, +1.541473318e-02f, +3.227323755e-03f, -2.103560649e-02f, -1.136022309e-02f, +2.440737863e-02f, +2.231374965e-02f, -2.363701309e-02f, -3.421078571e-02f, +1.768395697e-02f, +4.437850400e-02f, -6.933437601e-03f, -5.016550302e-02f, -6.716576944e-03f, +4.986380172e-02f, +2.035122845e-02f, -4.335275964e-02f, -3.095492907e-02f, +3.218074382e-02f, +3.638819737e-02f, -1.903919564e-02f, -3.603177721e-02f, +6.847966803e-03f, +3.085350479e-02f, +2.169029869e-03f, -2.291042782e-02f, -7.057770904e-03f, +1.453613013e-02f, +8.177814767e-03f, -7.568807152e-03f, -6.779615884e-03f, +2.910512605e-03f, +4.364754012e-03f, -5.217531717e-04f, -2.124748439e-03f, -2.473980074e-04f, +5.224547188e-04f, +2.091118358e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -9.509540550e-06f, +2.926201376e-05f, +6.213306230e-05f, -6.857199685e-05f, -1.646976352e-04f, +8.035156716e-05f, +3.346290863e-04f, -2.841151869e-05f, -5.593375809e-04f, -1.329581136e-04f, +7.940294904e-04f, +4.320574712e-04f, -9.667122445e-04f, -8.593041379e-04f, +9.979161819e-04f, +1.357150735e-03f, -8.297338200e-04f, -1.827992339e-03f, +4.528188339e-04f, +2.160332612e-03f, +8.115029959e-05f, -2.264787302e-03f, -6.690330814e-04f, +2.105863338e-03f, +1.186054466e-03f, -1.716078009e-03f, -1.524979356e-03f, +1.186014010e-03f, +1.629234820e-03f, -6.341458936e-04f, -1.507112506e-03f, +1.687909899e-04f, +1.222524883e-03f, +1.427370524e-04f, -8.678200852e-04f, -2.868408691e-04f, +5.310558291e-04f, +2.959240970e-04f, -2.708917795e-04f, -2.266458833e-04f, +1.071383779e-04f, +1.352272513e-04f, -2.711472282e-05f, -5.992783944e-05f, -3.399244831e-06f, +1.491327491e-05f, +0.000000000e+00f,
    /*  7, 7 (48) */
    +0.000000000e+00f, -4.689602943e-04f, -2.274826614e-04f, +1.068522927e-03f, +1.210975144e-03f, -1.436603294e-03f, -3.184081339e-03f, +7.126956756e-04f, +5.915436753e-03f, +2.185924572e-03f, -8.341865244e-03f, -8.098131130e-03f, +8.458376537e-03f, +1.701831657e-02f, -3.495485906e-03f, -2.758149602e-02f, -9.845968173e-03f, +3.676041196e-02f, +3.608302384e-02f, -3.927522936e-02f, -8.734976877e-02f, +2.157801721e-02f, +2.586701590e-01f, +4.222512542e-01f, +3.527267781e-01f, +1.191264949e-01f, -6.247341513e-02f, -7.297145356e-02f, +9.098716328e-03f, +4.660084711e-02f, +1.089823921e-02f, -2.626346905e-02f, -1.669419097e-02f, +1.134941420e-02f, +1.516101486e-02f, -1.999879496e-03f, -1.056319989e-02f, -2.464453698e-03f, +5.738601441e-03f, +3.477527016e-03f, -2.199493906e-03f, -2.693106690e-03f, +3.147627782e-04f, +1.454817605e-03f, +2.845166378e-04f, -5.190554740e-04f, -2.240251107e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.020248298e-05f, -2.794478312e-05f, -3.954017920e-05f, +4.061602803e-05f, +1.019455730e-04f, -2.122006131e-05f, -1.942973467e-04f, -6.884707305e-05f, +2.852203686e-04f, +2.645432223e-04f, -3.072532678e-04f, -5.742255451e-04f, +1.597182014e-04f, +9.548621291e-04f, +2.807115945e-04f, -1.288690027e-03f, -1.162109368e-03f, +1.336822724e-03f, +2.748065320e-03f, -4.467446921e-04f, -6.069073841e-03f, -7.526667692e-03f, -1.906515583e-03f, +5.626577831e-03f, +7.632272277e-03f, +3.158683085e-03f, -1.858177439e-03f, -2.428990405e-03f, +1.553336802e-04f, +1.578879652e-03f, +4.889656325e-04f, -8.588611084e-04f, -6.370607032e-04f, +3.398966032e-04f, +5.402508255e-04f, -3.224608662e-05f, -3.571682227e-04f, -1.002414783e-04f, +1.852800431e-04f, +1.187114401e-04f, -6.882595364e-05f, -8.484467018e-05f, +1.159134683e-05f, +4.315119110e-05f, +4.648267252e-06f, -1.500607012e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.689602943e-04f, +2.274826614e-04f, -1.493122773e-03f, -1.832389239e-03f, +2.494976171e-03f, +4.854790656e-03f, -2.674430805e-03f, -9.548658426e-03f, +8.546434197e-04f, +1.528177507e-02f, +4.021353246e-03f, -2.060354902e-02f, -1.232693533e-02f, +2.354807449e-02f, +2.331166583e-02f, -2.227986236e-02f, -3.504051953e-02f, +1.585596463e-02f, +4.483132284e-02f, -4.773104989e-03f, -5.008435272e-02f, -8.981364246e-03f, +4.919476864e-02f, +2.245709179e-02f, -4.216670517e-02f, -3.267100708e-02f, +3.065576446e-02f, +3.757421138e-02f, -1.740996082e-02f, -3.666592310e-02f, +5.340854297e-03f, +3.102229578e-02f, +3.391554752e-03f, -2.276769077e-02f, -7.925590989e-03f, +1.424928927e-02f, +8.708870596e-03f, -7.272883055e-03f, -7.050507664e-03f, +2.683866721e-03f, +4.471892390e-03f, -3.865259204e-04f, -2.151863162e-03f, -3.073258468e-04f, +5.190554740e-04f, +2.240251107e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.020248298e-05f, +2.794478312e-05f, +6.350687369e-05f, -6.295461800e-05f, -1.662767285e-04f, +6.872575091e-05f, +3.343245057e-04f, -8.397709338e-06f, -5.532701980e-04f, -1.624126768e-04f, +7.769113186e-04f, +4.694923866e-04f, -9.330563568e-04f, -9.001091448e-04f, +9.438343146e-04f, +1.393950635e-03f, -7.547255546e-04f, -1.852172990e-03f, +3.608135648e-04f, +2.164341675e-03f, +1.820540613e-04f, -2.244447194e-03f, -7.682187358e-04f, +2.061833388e-03f, +1.272957041e-03f, -1.653875520e-03f, -1.591707552e-03f, +1.114547142e-03f, +1.672339179e-03f, -5.632859609e-04f, -1.527933181e-03f, +1.068595109e-04f, +1.226115595e-03f, +1.907184711e-04f, -8.609741559e-04f, -3.196593601e-04f, +5.202270671e-04f, +3.154870750e-04f, -2.607176712e-04f, -2.365715527e-04f, +9.991676201e-05f, +1.393583212e-04f, -2.315335024e-05f, -6.128773634e-05f, -4.648267252e-06f, +1.500607012e-05f, +0.000000000e+00f,
    /*  7, 8 (48) */
    +0.000000000e+00f, -4.587578113e-04f, -2.554274445e-04f, +1.028982748e-03f, +1.251591172e-03f, -1.334657721e-03f, -3.205301401e-03f, +5.183983289e-04f, +5.846589680e-03f, +2.471144941e-03f, -8.077322022e-03f, -8.405384397e-03f, +7.884150992e-03f, +1.717803477e-02f, -2.540623776e-03f, -2.730078443e-02f, -1.113465820e-02f, +3.559830260e-02f, +3.741984656e-02f, -3.652716404e-02f, -8.779651347e-02f, +1.550894337e-02f, +2.511434913e-01f, +4.203447386e-01f, +3.583533560e-01f, +1.267587672e-01f, -5.931473204e-02f, -7.482963099e-02f, +6.669725923e-03f, +4.675618079e-02f, +1.247711886e-02f, -2.577450342e-02f, -1.755305208e-02f, +1.071235349e-02f, +1.550091146e-02f, -1.459628670e-03f, -1.059544598e-02f, -2.821621921e-03f, +5.638359962e-03f, +3.662807059e-03f, -2.080782465e-03f, -2.761932644e-03f, +2.299181080e-04f, +1.466408952e-03f, +3.276678289e-04f, -5.144072068e-04f, -2.390311808e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.084885119e-05f, -2.660359268e-05f, -4.056543633e-05f, +3.731992528e-05f, +1.024192393e-04f, -1.486432307e-05f, -1.919620389e-04f, -7.848236882e-05f, +2.764526489e-04f, +2.754760482e-04f, -2.878444504e-04f, -5.809226461e-04f, +1.266905299e-04f, +9.472786986e-04f, +3.261633500e-04f, -1.251794720e-03f, -1.209805552e-03f, +1.249795243e-03f, +2.766077777e-03f, -2.810474539e-04f, -5.922220368e-03f, -7.594503719e-03f, -2.154360581e-03f, +5.446128244e-03f, +7.685991774e-03f, +3.344738387e-03f, -1.757784465e-03f, -2.480500260e-03f, +7.270153211e-05f, +1.577692923e-03f, +5.422436965e-04f, -8.379753945e-04f, -6.648477053e-04f, +3.160191976e-04f, +5.502403358e-04f, -1.319881162e-05f, -3.572207922e-04f, -1.122820998e-04f, +1.815105706e-04f, +1.247624957e-04f, -6.489718843e-05f, -8.711201950e-05f, +8.965421965e-06f, +4.367637005e-05f, +5.925014199e-06f, -1.506247809e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.587578113e-04f, +2.554274445e-04f, -1.429615899e-03f, -1.895343857e-03f, +2.328699442e-03f, +4.923516407e-03f, -2.340106299e-03f, -9.557056136e-03f, +3.013732217e-04f, +1.511936239e-02f, +4.798264564e-03f, -2.013405663e-02f, -1.325999169e-02f, +2.264796534e-02f, +2.425550015e-02f, -2.088591172e-02f, -3.579524509e-02f, +1.400379164e-02f, +4.519213640e-02f, -2.608763314e-03f, -4.990229866e-02f, -1.122581144e-02f, +4.842654990e-02f, +2.451892518e-02f, -4.089374813e-02f, -3.432488260e-02f, +2.906405691e-02f, +3.868875852e-02f, -1.573762164e-02f, -3.722920906e-02f, +3.812921116e-03f, +3.112915529e-02f, +4.617670347e-03f, -2.257697230e-02f, -8.786565145e-03f, +1.392962991e-02f, +9.229097663e-03f, -6.957395980e-03f, -7.311225335e-03f, +2.447295169e-03f, +4.571809152e-03f, -2.471675992e-04f, -2.175016512e-03f, -3.686135832e-04f, +5.144072068e-04f, +2.390311808e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.084885119e-05f, +2.660359268e-05f, +6.469443335e-05f, -5.733696346e-05f, -1.674600283e-04f, +5.717684970e-05f, +3.333171188e-04f, +1.132493745e-05f, -5.461317680e-04f, -1.911623324e-04f, +7.583767867e-04f, +5.055827778e-04f, -8.977809330e-04f, -9.387417533e-04f, +8.881926267e-04f, +1.427673533e-03f, -6.785577956e-04f, -1.872463125e-03f, +2.683860678e-04f, +2.163918277e-03f, +2.824053234e-04f, -2.219541565e-03f, -8.658158848e-04f, +2.013561012e-03f, +1.357378262e-03f, -1.588148312e-03f, -1.655376630e-03f, +1.040515324e-03f, +1.712211021e-03f, -4.908671114e-04f, -1.545738034e-03f, +4.424144080e-05f, +1.227194049e-03f, +2.387640299e-04f, -8.522559589e-04f, -3.522010130e-04f, +5.081553750e-04f, +3.346708314e-04f, -2.498154825e-04f, -2.461687640e-04f, +9.232376686e-05f, +1.432744774e-04f, -1.902867683e-05f, -6.254207668e-05f, -5.925014199e-06f, +1.506247809e-05f, +0.000000000e+00f,
    /*  7, 9 (48) */
    +0.000000000e+00f, -4.479089601e-04f, -2.820310372e-04f, +9.884173113e-04f, +1.288911098e-03f, -1.232238482e-03f, -3.220165724e-03f, +3.264362900e-04f, +5.768107311e-03f, +2.747597590e-03f, -7.801845974e-03f, -8.693228848e-03f, +7.303228346e-03f, +1.730472530e-02f, -1.593345078e-03f, -2.697462108e-02f, -1.238645292e-02f, +3.438849704e-02f, +3.866964181e-02f, -3.376108626e-02f, -8.807756092e-02f, +9.586722998e-03f, +2.435489876e-01f, +4.181903781e-01f, +3.637994842e-01f, +1.344447589e-01f, -5.596999366e-02f, -7.658741546e-02f, +4.189225664e-03f, +4.682888232e-02f, +1.405481179e-02f, -2.523225973e-02f, -1.839102747e-02f, +1.004750579e-02f, +1.581693066e-02f, -9.093883346e-04f, -1.060864479e-02f, -3.178842713e-03f, +5.526077863e-03f, +3.844317629e-03f, -1.956019970e-03f, -2.826829832e-03f, +1.428060885e-04f, +1.475374374e-03f, +3.713441989e-04f, -5.084821926e-04f, -2.540936589e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.144840713e-05f, -2.524204041e-05f, -4.148289141e-05f, +3.402109109e-05f, +1.026854258e-04f, -8.594746194e-06f, -1.893046668e-04f, -8.782050396e-05f, +2.673033459e-04f, +2.857488329e-04f, -2.681717440e-04f, -5.864760599e-04f, +9.385614083e-05f, +9.380861467e-04f, +3.704516143e-04f, -1.213156387e-03f, -1.254713117e-03f, +1.161900464e-03f, +2.779085504e-03f, -1.183583270e-04f, -5.771169318e-03f, -7.654592979e-03f, -2.399839862e-03f, +5.259816984e-03f, +7.732594905e-03f, +3.530139394e-03f, -1.652485180e-03f, -2.528511193e-03f, -1.126185069e-05f, +1.573659262e-03f, +5.952375593e-04f, -8.152977755e-04f, -6.917772238e-04f, +2.912490903e-04f, +5.593479040e-04f, +6.138583950e-06f, -3.566062405e-04f, -1.242967150e-04f, +1.773340635e-04f, +1.306799422e-04f, -6.076670666e-05f, -8.925298590e-05f, +6.260081759e-06f, +4.412161161e-05f, +7.227216627e-06f, -1.508121306e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.479089601e-04f, +2.820310372e-04f, -1.364921466e-03f, -1.952680821e-03f, +2.161239414e-03f, +4.980693256e-03f, -2.006789181e-03f, -9.545731198e-03f, -2.447585463e-04f, +1.492820006e-02f, +5.556641351e-03f, -1.962847385e-02f, -1.415777262e-02f, +2.170922359e-02f, +2.514369277e-02f, -1.945823819e-02f, -3.647380288e-02f, +1.213132852e-02f, +4.546052247e-02f, -4.448450370e-04f, -4.961989334e-02f, -1.344535300e-02f, +4.756073402e-02f, +2.653248619e-02f, -3.953636987e-02f, -3.591303092e-02f, +2.740868028e-02f, +3.972927384e-02f, -1.402541062e-02f, -3.772007617e-02f, +2.267183082e-03f, +3.117339673e-02f, +5.844864396e-03f, -2.233820827e-02f, -9.638821104e-03f, +1.357742889e-02f, +9.737253038e-03f, -6.622725149e-03f, -7.561040817e-03f, +2.201126405e-03f, +4.664132919e-03f, -1.038931219e-04f, -2.194045189e-03f, -4.311556598e-04f, +5.084821926e-04f, +2.540936589e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.144840713e-05f, +2.524204041e-05f, +6.569800200e-05f, -5.173204069e-05f, -1.682532630e-04f, +4.572887222e-05f, +3.316210050e-04f, +3.071845145e-05f, -5.379521862e-04f, -2.191548864e-04f, +7.384806670e-04f, +5.402663004e-04f, -8.609741092e-04f, -9.751384994e-04f, +8.311176495e-04f, +1.458267827e-03f, -6.013944085e-04f, -1.888837242e-03f, +1.757290856e-04f, +2.159074794e-03f, +3.819975348e-04f, -2.190126450e-03f, -9.616229592e-04f, +1.961143586e-03f, +1.439139845e-03f, -1.519024892e-03f, -1.715845240e-03f, +9.640625692e-04f, +1.748752148e-03f, -4.170317670e-04f, -1.560470263e-03f, -1.893694541e-05f, +1.225736781e-03f, +2.867727586e-04f, -8.416641236e-04f, -3.843929989e-04f, +4.948503601e-04f, +3.534281504e-04f, -2.381972856e-04f, -2.554101662e-04f, +8.436905505e-05f, +1.469616392e-04f, -1.474638968e-05f, -6.368440066e-05f, -7.227216627e-06f, +1.508121306e-05f, +0.000000000e+00f,
    /*  7,10 (48) */
    +0.000000000e+00f, -4.364605530e-04f, -3.072730776e-04f, +9.469344199e-04f, +1.322932189e-03f, -1.129553056e-03f, -3.228760470e-03f, +1.371316231e-04f, +5.680286807e-03f, +3.014900936e-03f, -7.516097141e-03f, -8.961400592e-03f, +6.716752286e-03f, +1.739858144e-02f, -6.552589311e-04f, -2.660416947e-02f, -1.359960931e-02f, +3.313378393e-02f, +3.983154227e-02f, -3.098200076e-02f, -8.819591925e-02f, +3.815553680e-03f, +2.358943946e-01f, +4.157905382e-01f, +3.690593012e-01f, +1.421773538e-01f, -5.243985426e-02f, -7.823990064e-02f, +1.660714471e-03f, +4.681762047e-02f, +1.562847105e-02f, -2.463702217e-02f, -1.920632525e-02f, +9.355728563e-03f, +1.610817975e-02f, -3.500404306e-04f, -1.060250621e-02f, -3.535448954e-03f, +5.401781148e-03f, +4.021651693e-03f, -1.825340028e-03f, -2.887596539e-03f, +5.355310260e-05f, +1.481634456e-03f, +4.154658105e-04f, -5.012549759e-04f, -2.691748720e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.200103319e-05f, -2.386368643e-05f, -4.229307530e-05f, +3.072628925e-05f, +1.027475501e-04f, -2.421989333e-06f, -1.863355934e-04f, -9.684840658e-05f, +2.577951417e-04f, +2.953516851e-04f, -2.482748867e-04f, -5.908904165e-04f, +6.127215102e-05f, +9.273211492e-04f, +4.135120799e-04f, -1.172865439e-03f, -1.296791870e-03f, +1.073298769e-03f, +2.787148517e-03f, +4.114853267e-05f, -5.616142078e-03f, -7.706910059e-03f, -2.642685756e-03f, +5.067833211e-03f, +7.771975044e-03f, +3.714645386e-03f, -1.542354717e-03f, -2.572888771e-03f, -9.643006054e-05f, +1.566747901e-03f, +6.478485272e-04f, -7.908466446e-04f, -7.177891105e-04f, +2.656204183e-04f, +5.675449142e-04f, +2.573387983e-05f, -3.553161379e-04f, -1.362620122e-04f, +1.727520416e-04f, +1.364499007e-04f, -5.643900752e-05f, -9.126065537e-05f, +3.479275925e-06f, +4.448396762e-05f, +8.552487914e-06f, -1.506105373e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.364605530e-04f, +3.072730776e-04f, -1.299223464e-03f, -2.004412861e-03f, +1.992986151e-03f, +5.026422129e-03f, -1.675168176e-03f, -9.515012747e-03f, -7.827107325e-04f, +1.470904517e-02f, +6.295122018e-03f, -1.908820755e-02f, -1.501874673e-02f, +2.073408509e-02f, +2.597481042e-02f, -1.799997036e-02f, -3.707519729e-02f, +1.024249128e-02f, +4.563625156e-02f, +1.714229757e-03f, -4.923789580e-02f, -1.563547945e-02f, +4.659911106e-02f, +2.849362978e-02f, -3.809723002e-02f, -3.743205581e-02f, +2.569283504e-02f, +4.069333641e-02f, -1.227665847e-02f, -3.813710794e-02f, +7.067128194e-04f, +3.115445979e-02f, +7.070601177e-03f, -2.205143551e-02f, -1.048048523e-02f, +1.319303589e-02f, +1.023210340e-02f, -6.269296998e-03f, -7.799238103e-03f, +1.945716238e-03f, +4.748501974e-03f, +4.306851739e-05f, -2.208791579e-03f, -4.948400605e-04f, +5.012549759e-04f, +2.691748720e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.200103319e-05f, +2.386368643e-05f, +6.652024205e-05f, -4.615252836e-05f, -1.686629464e-04f, +3.440515789e-05f, +3.292515434e-04f, +4.974615180e-05f, -5.287632087e-04f, -2.463404129e-04f, +7.172800494e-04f, +5.734842225e-04f, -8.227264984e-04f, -1.009241144e-03f, +7.727380717e-04f, +1.485688805e-03f, -5.234005202e-04f, -1.901278162e-03f, +8.303518807e-05f, +2.149832828e-03f, +4.806261020e-04f, -2.156267264e-03f, -1.055442178e-03f, +1.904687222e-03f, +1.518068837e-03f, -1.446641169e-03f, -1.772978338e-03f, +8.853385352e-04f, +1.781870932e-03f, -3.419261273e-04f, -1.572079214e-03f, -8.254725443e-05f, +1.221725550e-03f, +3.346428214e-04f, -8.292013105e-04f, -4.161624012e-04f, +4.803244579e-04f, +3.717120835e-04f, -2.258769512e-04f, -2.642687365e-04f, +7.606332210e-05f, +1.504059649e-04f, -1.031271056e-05f, -6.470836289e-05f, -8.552487914e-06f, +1.506105373e-05f, +0.000000000e+00f,
    /*  7,11 (48) */
    +0.000000000e+00f, -4.244595198e-04f, -3.311367641e-04f, +9.046413446e-04f, +1.353658478e-03f, -1.026805506e-03f, -3.231182459e-03f, -4.920397027e-05f, +5.583438400e-03f, +3.272696078e-03f, -7.220745456e-03f, -9.209675479e-03f, +6.125861869e-03f, +1.745985359e-02f, +2.720622181e-04f, -2.619065739e-02f, -1.477247475e-02f, +3.183699206e-02f, +4.090484104e-02f, -2.819485224e-02f, -8.815477071e-02f, -1.800588398e-03f, +2.281874846e-01f, +4.131478524e-01f, +3.741271344e-01f, +1.499493289e-01f, -4.872520888e-02f, -7.978225536e-02f, -9.121743007e-04f, +4.672119041e-02f, +1.719521895e-02f, -2.398917364e-02f, -1.999717189e-02f, +8.637939453e-03f, +1.637380016e-02f, +2.175044837e-04f, -1.057677233e-02f, -3.890765092e-03f, +5.265519135e-03f, +4.194403735e-03f, -1.688890127e-03f, -2.944035546e-03f, -3.770755277e-05f, +1.485113732e-03f, +4.599497782e-04f, -4.927024880e-04f, -2.842359257e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.250672977e-05f, -2.247204570e-05f, -4.299673875e-05f, +2.744214133e-05f, +1.026093788e-04f, +3.643661803e-06f, -1.830656208e-04f, -1.055537955e-04f, +2.479510728e-04f, +3.042761023e-04f, -2.281935112e-04f, -5.941723784e-04f, +2.899451371e-05f, +9.150227597e-04f, +4.552834036e-04f, -1.131014046e-03f, -1.336006934e-03f, +9.841495448e-04f, +2.790333414e-03f, +1.973050787e-04f, -5.457363617e-03f, -7.751439409e-03f, -2.882634107e-03f, +4.870373568e-03f, +7.804034221e-03f, +3.898014814e-03f, -1.427475945e-03f, -2.613502441e-03f, -1.826729847e-04f, +1.556932685e-03f, +6.999773566e-04f, -7.646438261e-04f, -7.428241466e-04f, +2.391693380e-04f, +5.748040784e-04f, +4.555393470e-05f, -3.533432234e-04f, -1.481544296e-04f, +1.677668407e-04f, +1.420585538e-04f, -5.191907005e-05f, -9.312825770e-05f, +6.271988012e-07f, +4.476060912e-05f, +9.898326944e-06f, -1.500084795e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.244595198e-04f, +3.311367641e-04f, -1.232703222e-03f, -2.050565390e-03f, +1.824323205e-03f, +5.060827286e-03f, -1.345916632e-03f, -9.465266595e-03f, -1.311473941e-03f, +1.446270476e-02f, +7.012402067e-03f, -1.851472333e-02f, -1.584147323e-02f, +1.972484395e-02f, +2.674754850e-02f, -1.651428156e-02f, -3.759859781e-02f, +8.341213115e-03f, +4.571928674e-02f, +3.864062585e-03f, -4.875726970e-02f, -1.779174672e-02f, +4.554366888e-02f, +3.039831700e-02f, -3.657916119e-02f, -3.887869698e-02f, +2.391985670e-02f, +4.157867495e-02f, -1.049478754e-02f, -3.847903407e-02f, -8.653663943e-04f, +3.107191253e-02f, +8.292326727e-03f, -2.171679269e-02f, -1.130968654e-02f, +1.277687349e-02f, +1.071242786e-02f, -5.897584915e-03f, -8.025115054e-03f, +1.681447502e-03f, +4.824565296e-03f, +1.934744823e-04f, -2.219104290e-03f, -5.595484234e-04f, +4.927024880e-04f, +2.842359257e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.250672977e-05f, +2.247204570e-05f, +6.716420108e-05f, -4.061075246e-05f, -1.686963471e-04f, +2.322833477e-05f, +3.262253562e-04f, +6.837271040e-05f, -5.185983570e-04f, -2.726713359e-04f, +6.948341928e-04f, +6.051815166e-04f, -7.831309738e-04f, -1.040996755e-03f, +7.131844500e-04f, +1.509898702e-03f, -4.447421613e-04f, -1.909777027e-03f, -9.503635785e-06f, +2.136223136e-03f, +5.780888186e-04f, -2.118038660e-03f, -1.147079970e-03f, +1.844306549e-03f, +1.593997990e-03f, -1.371140182e-03f, -1.826647489e-03f, +8.044982205e-04f, +1.811482537e-03f, -2.656998777e-04f, -1.580520533e-03f, -1.464592362e-04f, +1.215147420e-03f, +3.822717313e-04f, -8.148742466e-04f, -4.474363760e-04f, +4.645929399e-04f, +3.894760597e-04f, -2.128701444e-04f, -2.727178485e-04f, +6.741829055e-05f, +1.535938897e-04f, -5.734392500e-06f, -6.560775245e-05f, -9.898326944e-06f, +1.500084795e-05f, +0.000000000e+00f,
    /*  7,12 (48) */
    +0.000000000e+00f, -4.119527900e-04f, -3.536088098e-04f, +8.616446058e-04f, +1.381100619e-03f, -9.241961269e-04f, -3.227538798e-03f, -2.322695911e-04f, +5.477884605e-03f, +3.520647150e-03f, -6.916469353e-03f, -9.437868990e-03f, +5.531689491e-03f, +1.748884811e-02f, +1.187084978e-03f, -2.573537398e-02f, -1.590348879e-02f, +3.050098512e-02f, +4.188899058e-02f, -2.540451883e-02f, -8.795746564e-02f, -7.257952015e-03f, +2.204360452e-01f, +4.102652183e-01f, +3.789975080e-01f, +1.577533631e-01f, -4.482719406e-02f, -8.120973130e-02f, -3.525676742e-03f, +4.653851743e-02f, +1.875215164e-02f, -2.328919628e-02f, -2.076181572e-02f, +7.895115306e-03f, +1.661296950e-02f, +7.923085621e-04f, -1.053121839e-02f, -4.244108315e-03f, +5.117364706e-03f, +4.362170575e-03f, -1.546831573e-03f, -2.995954616e-03f, -1.308358105e-04f, +1.485740930e-03f, +5.047103873e-04f, -4.828041611e-04f, -2.992367736e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.296561261e-05f, -2.107058095e-05f, -4.359484627e-05f, +2.417511538e-05f, +1.022750137e-04f, +9.592308909e-06f, -1.795059626e-04f, -1.139251923e-04f, +2.377944815e-04f, +3.125149683e-04f, -2.079670723e-04f, -5.963306029e-04f, -2.922069502e-06f, +9.012323114e-04f, +4.957072808e-04f, -1.087695956e-03f, -1.372328744e-03f, +8.946109473e-04f, +2.788713209e-03f, +3.499495666e-04f, -5.295062159e-03f, -7.788175333e-03f, -3.119424623e-03f, +4.667641934e-03f, +7.828683285e-03f, +4.080005638e-03f, -1.307939416e-03f, -2.650225773e-03f, -2.698569752e-04f, +1.544192172e-03f, +7.515244226e-04f, -7.367145768e-04f, -7.668241626e-04f, +2.119339833e-04f, +5.810995041e-04f, +6.556473697e-05f, -3.506814349e-04f, -1.599501977e-04f, +1.623816207e-04f, +1.474921745e-04f, -4.721235117e-05f, -9.484918346e-05f, -2.291714961e-06f, +4.494883537e-05f, +1.126212154e-05f, -1.489951724e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.119527900e-04f, +3.536088098e-04f, -1.165539020e-03f, -2.091176142e-03f, +1.655626858e-03f, +5.084055621e-03f, -1.019691276e-03f, -9.396893884e-03f, -1.830072298e-03f, +1.419003343e-02f, +7.707236260e-03f, -1.790954181e-02f, -1.662460420e-02f, +1.868384719e-02f, +2.746073294e-02f, -1.500438286e-02f, -3.804333997e-02f, +6.431436087e-03f, +4.570978311e-02f, +6.000285721e-03f, -4.817918088e-02f, -1.990978538e-02f, +4.439658891e-02f, +3.224262355e-02f, -3.498516320e-02f, -4.024983716e-02f, +2.209320921e-02f, +4.238317317e-02f, -8.683305000e-03f, -3.874473394e-02f, -2.445886927e-03f, +3.092545330e-02f, +9.507474147e-03f, -2.133452096e-02f, -1.212456078e-02f, +1.232943712e-02f, +1.117702080e-02f, -5.508108855e-03f, -8.237985198e-03f, +1.408729653e-03f, +4.891983586e-03f, +3.470683719e-04f, -2.224838682e-03f, -6.251561758e-04f, +4.828041611e-04f, +2.992367736e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.296561261e-05f, +2.107058095e-05f, +6.763329471e-05f, -3.511866381e-05f, -1.683614557e-04f, +1.222027980e-05f, +3.225602511e-04f, +8.656421125e-05f, -5.074928212e-04f, -2.981025057e-04f, +6.712043721e-04f, +6.353069426e-04f, -7.422824492e-04f, -1.070357785e-03f, +6.525889165e-04f, +1.530866736e-03f, -3.655859086e-04f, -1.914333292e-03f, -1.016963831e-04f, +2.118285537e-03f, +6.741862898e-04f, -2.075524354e-03f, -1.236347376e-03f, +1.780124475e-03f, +1.666766124e-03f, -1.292671811e-03f, -1.876731160e-03f, +7.217016570e-04f, +1.837509136e-03f, -1.885058871e-04f, -1.585756300e-03f, -2.105410514e-04f, +1.205994828e-03f, +4.295565671e-04f, -7.986937526e-04f, -4.781423133e-04f, +4.476739156e-04f, +4.066739952e-04f, -1.991943163e-04f, -2.807313413e-04f, +5.844670138e-05f, +1.565121654e-04f, -1.018715016e-06f, -6.637651307e-05f, -1.126212154e-05f, +1.489951724e-05f, +0.000000000e+00f,
    /*  7,13 (48) */
    +0.000000000e+00f, -3.989871774e-04f, -3.746793907e-04f, +8.180497596e-04f, +1.405275735e-03f, -8.219211132e-04f, -3.217946489e-03f, -4.117755537e-04f, +5.363959413e-03f, +3.758441632e-03f, -6.603954385e-03f, -9.645836062e-03f, +4.935358888e-03f, +1.748592604e-02f, +2.088317289e-03f, -2.523966670e-02f, -1.699118475e-02f, +2.912865638e-02f, +4.278360153e-02f, -2.261580562e-02f, -8.760751607e-02f, -1.255301417e-02f, +2.126478698e-01f, +4.071457937e-01f, +3.836651499e-01f, +1.655820464e-01f, -4.074718842e-02f, -8.251767072e-02f, -6.175902515e-03f, +4.626866045e-02f, +2.029634381e-02f, -2.253767186e-02f, -2.149853030e-02f, +7.128291144e-03f, +1.682490349e-02f, +1.373408066e-03f, -1.046565366e-02f, -4.594789750e-03f, +4.957414508e-03f, +4.524552196e-03f, -1.399339399e-03f, -3.043166967e-03f, -2.256849939e-04f, +1.483449215e-03f, +5.496592227e-04f, -4.715420395e-04f, -3.141362909e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.337790988e-05f, -1.966269580e-05f, -4.408856978e-05f, +2.093151518e-05f, +1.017488775e-04f, +1.541445451e-05f, -1.756682150e-04f, -1.219519320e-04f, +2.273489669e-04f, +3.200625479e-04f, -1.876347751e-04f, -5.973757021e-04f, -3.442423318e-05f, +8.859933155e-04f, +5.347285126e-04f, -1.043006315e-03f, -1.405733032e-03f, +8.048396605e-04f, +2.782367157e-03f, +4.989267366e-04f, -5.129468842e-03f, -7.817121964e-03f, -3.352801220e-03f, +4.459849164e-03f, +7.845842068e-03f, +4.260375659e-03f, -1.183843295e-03f, -2.682936699e-03f, -3.578450253e-04f, +1.528509729e-03f, +8.023898903e-04f, -7.070875820e-04f, -7.897321568e-04f, +1.839544194e-04f, +5.864067609e-04f, +8.573145784e-05f, -3.473259368e-04f, -1.716253821e-04f, +1.566003717e-04f, +1.527371547e-04f, -4.232478271e-05f, -9.641700079e-05f, -5.272795322e-06f, +4.504608258e-05f, +1.264115220e-05f, -1.475606133e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +3.989871774e-04f, +3.746793907e-04f, -1.097905726e-03f, -2.126294806e-03f, +1.487265402e-03f, +5.096275901e-03f, -6.971310248e-04f, -9.310329673e-03f, -2.337565119e-03f, +1.389193092e-02f, +8.378440632e-03f, -1.727423487e-02f, -1.736688665e-02f, +1.761348941e-02f, +2.811332186e-02f, -1.347351612e-02f, -3.840892588e-02f, +4.517102796e-03f, +4.560808673e-02f, +8.118571258e-03f, -4.750499459e-02f, -2.198530973e-02f, +4.316024154e-02f, +3.402274802e-02f, -3.331839707e-02f, -4.154250897e-02f, +2.021647805e-02f, +4.310487483e-02f, -6.845795863e-03f, -3.893323983e-02f, -4.031643228e-03f, +3.071491225e-02f, +1.071346897e-02f, -2.090496439e-02f, -1.292325454e-02f, +1.185129480e-02f, +1.162469471e-02f, -5.101434860e-03f, -8.437179515e-03f, +1.127998312e-03f, +4.950430288e-03f, +5.035805373e-04f, -2.225857397e-03f, -6.915326889e-04f, +4.715420395e-04f, +3.141362909e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.337790988e-05f, +1.966269580e-05f, +6.793128886e-05f, -2.968781694e-05f, -1.676669522e-04f, +1.402081619e-06f, +3.182751618e-04f, +1.042882057e-04f, -4.954833594e-04f, -3.225912690e-04f, +6.464537228e-04f, +6.638131218e-04f, -7.002776567e-04f, -1.097282124e-03f, +5.910848864e-04f, +1.548569136e-03f, -2.860985280e-04f, -1.914954680e-03f, -1.933534389e-04f, +2.096068812e-03f, +7.687223488e-04f, -2.028816945e-03f, -1.323060455e-03f, +1.712271930e-03f, +1.736218473e-03f, -1.211392477e-03f, -1.923114997e-03f, +6.371135868e-04f, +1.859880104e-03f, -1.104998981e-04f, -1.587755150e-03f, -2.746595442e-04f, +1.194265648e-03f, +4.763941934e-04f, -7.806747605e-04f, -5.082080004e-04f, +4.295883275e-04f, +4.232604045e-04f, -1.848686923e-04f, -2.882835876e-04f, +4.916230295e-05f, +1.591478992e-04f, +3.826522264e-06f, -6.700876330e-05f, -1.264115220e-05f, +1.475606133e-05f, +0.000000000e+00f,
    /*  7,14 (48) */
    +0.000000000e+00f, -3.856092675e-04f, -3.943420865e-04f, +7.739611898e-04f, +1.426207250e-03f, -7.201722357e-04f, -3.202532034e-03f, -5.874437687e-04f, +5.242007481e-03f, +3.985790599e-03f, -6.283891837e-03f, -9.833470837e-03f, +4.337983186e-03f, +1.745150180e-02f, +2.974310605e-03f, -2.470493819e-02f, -1.803419106e-02f, +2.772292335e-02f, +4.358844119e-02f, -1.983343846e-02f, -8.710858933e-02f, -1.768248302e-02f, +2.048307479e-01f, +4.037929925e-01f, +3.881249991e-01f, +1.734278885e-01f, -3.648681276e-02f, -8.370151401e-02f, -8.858839214e-03f, +4.591081542e-02f, +2.182485354e-02f, -2.173528197e-02f, -2.220561788e-02f, +6.338558987e-03f, +1.700885791e-02f, +1.959814827e-03f, -1.037992220e-02f, -4.942115687e-03f, +4.785789126e-03f, +4.681152568e-03f, -1.246602244e-03f, -3.085491750e-03f, -3.221019947e-04f, +1.478176420e-03f, +5.947053052e-04f, -4.589008873e-04f, -3.288923522e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.374395910e-05f, -1.825172823e-05f, -4.447928178e-05f, +1.771747005e-05f, +1.010356992e-04f, +2.110101439e-05f, -1.715643282e-04f, -1.296241714e-04f, +2.166383362e-04f, +3.269144798e-04f, -1.672355058e-04f, -5.973201982e-04f, -6.546002915e-05f, +8.693513573e-04f, +5.722950666e-04f, -9.970414821e-04f, -1.436200809e-03f, +7.149906656e-04f, +2.771380576e-03f, +6.440879846e-04f, -4.960817383e-03f, -7.838293220e-03f, -3.582512362e-03f, +4.247212811e-03f, +7.855439529e-03f, +4.438882863e-03f, -1.055293283e-03f, -2.711517747e-03f, -4.464969546e-04f, +1.509873614e-03f, +8.524738878e-04f, -6.757949444e-04f, -8.114924139e-04f, +1.552725920e-04f, +5.907029444e-04f, +1.060185066e-04f, -3.432731465e-04f, -1.831559283e-04f, +1.504279191e-04f, +1.577800351e-04f, -3.726276731e-05f, -9.782547217e-05f, -8.311142389e-06f, +4.504993268e-05f, +1.403259622e-05f, -1.456956252e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +3.856092675e-04f, +3.943420865e-04f, -1.029974437e-03f, -2.155982623e-03f, +1.319598450e-03f, +5.097677983e-03f, -3.788558631e-04f, -9.206041467e-03f, -2.833048479e-03f, +1.356933965e-02f, +9.024894355e-03f, -1.661042175e-02f, -1.806716431e-02f, +1.651620728e-02f, +2.870440675e-02f, -1.192494699e-02f, -3.869502441e-02f, +2.602148116e-03f, +4.541473329e-02f, +1.021464007e-02f, -4.673627224e-02f, -2.401412668e-02f, +4.183718108e-02f, +3.573501995e-02f, -3.158217860e-02f, -4.275390145e-02f, +1.829336305e-02f, +4.374198841e-02f, -4.985915759e-03f, -3.904373973e-02f, -5.619398378e-03f, +3.044025270e-02f, +1.190773462e-02f, -2.042857020e-02f, -1.370392930e-02f, +1.134308680e-02f, +1.205428304e-02f, -4.678174456e-03f, -8.622048207e-03f, +8.397147245e-04f, +4.999592591e-03f, +6.627284365e-04f, -2.222030875e-03f, -7.585414522e-04f, +4.589008873e-04f, +3.288923522e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.374395910e-05f, +1.825172823e-05f, +6.806228152e-05f, -2.432935045e-05f, -1.666221717e-04f, -9.205994243e-06f, +3.133900864e-04f, +1.215137638e-04f, -4.826081954e-04f, -3.460975324e-04f, +6.206470836e-04f, +6.906566020e-04f, -6.572149221e-04f, -1.121733156e-03f, +5.288067630e-04f, +1.562989149e-03f, -2.064466181e-04f, -1.911657141e-03f, -2.842869735e-04f, +2.069630568e-03f, +8.615044673e-04f, -1.978017705e-03f, -1.407040669e-03f, +1.640887595e-03f, +1.802207023e-03f, -1.127464817e-03f, -1.965692091e-03f, +5.509031291e-04f, +1.878532204e-03f, -3.184020880e-05f, -1.586492380e-03f, -3.386805202e-04f, +1.179963238e-03f, +5.226814836e-04f, -7.608363226e-04f, -5.375617856e-04f, +4.103599397e-04f, +4.391905107e-04f, -1.699142545e-04f, -2.953495630e-04f, +3.957983714e-05f, +1.614885928e-04f, +8.793007373e-06f, -6.749881676e-05f, -1.403259622e-05f, +1.456956252e-05f, +0.000000000e+00f,
    /*  7,15 (48) */
    +0.000000000e+00f, -3.718653085e-04f, -4.125938147e-04f, +7.294819080e-04f, +1.443924720e-03f, -6.191365365e-04f, -3.181431020e-03f, -7.590080970e-04f, +5.112383309e-03f, +4.202428935e-03f, -5.956977357e-03f, -1.000070634e-02f, +3.740662988e-03f, +1.738604177e-02f, +3.843661962e-03f, -2.413264312e-02f, -1.903123255e-02f, +2.628672254e-02f, +4.430343186e-02f, -1.706205789e-02f, -8.646450135e-02f, -2.264330040e-02f, +1.969924546e-01f, +4.002104801e-01f, +3.923722119e-01f, +1.812833280e-01f, -3.204792990e-02f, -8.475680730e-02f, -1.157035696e-02f, +4.546431847e-02f, +2.333472715e-02f, -2.088280808e-02f, -2.288141282e-02f, +5.527066573e-03f, +1.716413050e-02f, +2.550517771e-03f, -1.027390369e-02f, -5.285388833e-03f, +4.602633198e-03f, +4.831580487e-03f, -1.088822209e-03f, -3.122754517e-03f, -4.199274669e-04f, +1.469865278e-03f, +6.397552379e-04f, -4.448682911e-04f, -3.434619147e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.406420377e-05f, -1.684094428e-05f, -4.476854836e-05f, +1.453892518e-05f, +1.001404985e-04f, +2.664332890e-05f, -1.672065776e-04f, -1.369328962e-04f, +2.056865565e-04f, +3.330677657e-04f, -1.468077623e-04f, -5.961784772e-04f, -9.597900412e-05f, +8.513539892e-04f, +6.083581318e-04f, -9.498988544e-04f, -1.463718330e-03f, +6.252170128e-04f, +2.755844657e-03f, +7.852915229e-04f, -4.789343739e-03f, -7.851712756e-03f, -3.808311390e-03f, +4.029956851e-03f, +7.857413890e-03f, +4.615285763e-03f, -9.224025289e-04f, -2.735856267e-03f, -5.356695997e-04f, +1.488277057e-03f, +9.016766817e-04f, -6.428721674e-04f, -8.320506221e-04f, +1.259322736e-04f, +5.939667389e-04f, +1.263895881e-04f, -3.385207585e-04f, -1.945177063e-04f, +1.438699263e-04f, +1.626075341e-04f, -3.203317336e-05f, -9.906857111e-05f, -1.140163254e-05f, +4.495812173e-05f, +1.543353210e-05f, -1.433918995e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +3.718653085e-04f, +4.125938147e-04f, -9.619121554e-04f, -2.180311973e-03f, +1.152976278e-03f, +5.088471988e-03f, -6.546577670e-05f, -9.084527704e-03f, -3.315656674e-03f, +1.322324212e-02f, +9.645541439e-03f, -1.591976515e-02f, -1.872437923e-02f, +1.539447413e-02f, +2.923321351e-02f, -1.036195784e-02f, -3.890147103e-02f, +6.904909747e-04f, +4.513044631e-02f, +1.228427064e-02f, -4.587476777e-02f, -2.599214438e-02f, +4.043014041e-02f, +3.737590755e-02f, -2.977997158e-02f, -4.388136626e-02f, +1.632767096e-02f, +4.429289154e-02f, -3.107383555e-03f, -3.907557994e-02f, -7.205890758e-03f, +3.010157218e-02f, +1.308769786e-02f, -1.990588871e-02f, -1.446476562e-02f, +1.080552502e-02f, +1.246464298e-02f, -4.238983945e-03f, -8.791962461e-03f, +5.443651615e-04f, +5.039172428e-03f, +8.242170293e-04f, -2.213237867e-03f, -8.260402690e-04f, +4.448682911e-04f, +3.434619147e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.406420377e-05f, +1.684094428e-05f, +6.803068410e-05f, -1.905396874e-05f, -1.652370684e-04f, -1.958453755e-05f, +3.079260246e-04f, +1.382115211e-04f, -4.689069142e-04f, -3.685838193e-04f, +5.938508359e-04f, +7.157979128e-04f, -6.131939395e-04f, -1.143679789e-03f, +4.658896441e-04f, +1.574117035e-03f, -1.267962571e-04f, -1.904464776e-03f, -3.743113350e-04f, +2.039037101e-03f, +9.523441555e-04f, -1.923236358e-03f, -1.488115258e-03f, +1.566117607e-03f, +1.864590837e-03f, -1.041057354e-03f, -2.004363224e-03f, +4.632434352e-04f, +1.893409753e-03f, +4.731265204e-05f, -1.581950044e-03f, -4.024690279e-04f, +1.163096477e-03f, +5.683155438e-04f, -7.392016120e-04f, -5.661327428e-04f, +3.900153209e-04f, +4.544203565e-04f, -1.543537211e-04f, -3.019049137e-04f, +2.971502298e-05f, +1.635221805e-04f, +1.387192530e-05f, -6.784120230e-05f, -1.543353210e-05f, +1.433918995e-05f, +0.000000000e+00f,
    /*  7,16 (48) */
    +0.000000000e+00f, -3.578011047e-04f, -4.294347590e-04f, +6.847133596e-04f, +1.458463645e-03f, -5.189960380e-04f, -3.154787691e-03f, -9.262146746e-04f, +4.975450413e-03f, +4.408115492e-03f, -5.623909592e-03f, -1.014751411e-02f, +3.144484510e-03f, +1.729006277e-02f, +4.695015951e-03f, -2.352428499e-02f, -1.998113140e-02f, +2.482300421e-02f, +4.492864887e-02f, -1.430621323e-02f, -8.567920983e-02f, -2.743264414e-02f, +1.891407419e-01f, +3.964021687e-01f, +3.964021687e-01f, +1.891407419e-01f, -2.743264414e-02f, -8.567920983e-02f, -1.430621323e-02f, +4.492864887e-02f, +2.482300421e-02f, -1.998113140e-02f, -2.352428499e-02f, +4.695015951e-03f, +1.729006277e-02f, +3.144484510e-03f, -1.014751411e-02f, -5.623909592e-03f, +4.408115492e-03f, +4.975450413e-03f, -9.262146746e-04f, -3.154787691e-03f, -5.189960380e-04f, +1.458463645e-03f, +6.847133596e-04f, -4.294347590e-04f, -3.578011047e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.433918995e-05f, -1.543353210e-05f, -4.495812173e-05f, +1.140163254e-05f, +9.906857111e-05f, +3.203317336e-05f, -1.626075341e-04f, -1.438699263e-04f, +1.945177063e-04f, +3.385207585e-04f, -1.263895881e-04f, -5.939667389e-04f, -1.259322736e-04f, +8.320506221e-04f, +6.428721674e-04f, -9.016766817e-04f, -1.488277057e-03f, +5.356695997e-04f, +2.735856267e-03f, +9.224025289e-04f, -4.615285763e-03f, -7.857413890e-03f, -4.029956851e-03f, +3.808311390e-03f, +7.851712756e-03f, +4.789343739e-03f, -7.852915229e-04f, -2.755844657e-03f, -6.252170128e-04f, +1.463718330e-03f, +9.498988544e-04f, -6.083581318e-04f, -8.513539892e-04f, +9.597900412e-05f, +5.961784772e-04f, +1.468077623e-04f, -3.330677657e-04f, -2.056865565e-04f, +1.369328962e-04f, +1.672065776e-04f, -2.664332890e-05f, -1.001404985e-04f, -1.453892518e-05f, +4.476854836e-05f, +1.684094428e-05f, -1.406420377e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +3.578011047e-04f, +4.294347590e-04f, -8.938814713e-04f, -2.199365942e-03f, +9.877392098e-04f, +5.068887451e-03f, +2.424602479e-04f, -8.946316183e-03f, -3.784563588e-03f, +1.285465830e-02f, +1.023939227e-02f, -1.520396723e-02f, -1.933757317e-02f, +1.425079434e-02f, +2.969910316e-02f, -8.787840802e-03f, -3.902826729e-02f, -1.213973801e-03f, +4.475613498e-02f, +1.432330774e-02f, -4.492242362e-02f, -2.791538074e-02f, +3.894202515e-02f, +3.894202515e-02f, -2.791538074e-02f, -4.492242362e-02f, +1.432330774e-02f, +4.475613498e-02f, -1.213973801e-03f, -3.902826729e-02f, -8.787840802e-03f, +2.969910316e-02f, +1.425079434e-02f, -1.933757317e-02f, -1.520396723e-02f, +1.023939227e-02f, +1.285465830e-02f, -3.784563588e-03f, -8.946316183e-03f, +2.424602479e-04f, +5.068887451e-03f, +9.877392098e-04f, -2.199365942e-03f, -8.938814713e-04f, +4.294347590e-04f, +3.578011047e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.433918995e-05f, +1.543353210e-05f, +6.784120230e-05f, -1.387192530e-05f, -1.635221805e-04f, -2.971502298e-05f, +3.019049137e-04f, +1.543537211e-04f, -4.544203565e-04f, -3.900153209e-04f, +5.661327428e-04f, +7.392016120e-04f, -5.683155438e-04f, -1.163096477e-03f, +4.024690279e-04f, +1.581950044e-03f, -4.731265204e-05f, -1.893409753e-03f, -4.632434352e-04f, +2.004363224e-03f, +1.041057354e-03f, -1.864590837e-03f, -1.566117607e-03f, +1.488115258e-03f, +1.923236358e-03f, -9.523441555e-04f, -2.039037101e-03f, +3.743113350e-04f, +1.904464776e-03f, +1.267962571e-04f, -1.574117035e-03f, -4.658896441e-04f, +1.143679789e-03f, +6.131939395e-04f, -7.157979128e-04f, -5.938508359e-04f, +3.685838193e-04f, +4.689069142e-04f, -1.382115211e-04f, -3.079260246e-04f, +1.958453755e-05f, +1.652370684e-04f, +1.905396874e-05f, -6.803068410e-05f, -1.684094428e-05f, +1.406420377e-05f, +0.000000000e+00f,
    /*  7,17 (48) */
    +0.000000000e+00f, -3.434619147e-04f, -4.448682911e-04f, +6.397552379e-04f, +1.469865278e-03f, -4.199274669e-04f, -3.122754517e-03f, -1.088822209e-03f, +4.831580487e-03f, +4.602633198e-03f, -5.285388833e-03f, -1.027390369e-02f, +2.550517771e-03f, +1.716413050e-02f, +5.527066573e-03f, -2.288141282e-02f, -2.088280808e-02f, +2.333472715e-02f, +4.546431847e-02f, -1.157035696e-02f, -8.475680730e-02f, -3.204792990e-02f, +1.812833280e-01f, +3.923722119e-01f, +4.002104801e-01f, +1.969924546e-01f, -2.264330040e-02f, -8.646450135e-02f, -1.706205789e-02f, +4.430343186e-02f, +2.628672254e-02f, -1.903123255e-02f, -2.413264312e-02f, +3.843661962e-03f, +1.738604177e-02f, +3.740662988e-03f, -1.000070634e-02f, -5.956977357e-03f, +4.202428935e-03f, +5.112383309e-03f, -7.590080970e-04f, -3.181431020e-03f, -6.191365365e-04f, +1.443924720e-03f, +7.294819080e-04f, -4.125938147e-04f, -3.718653085e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.456956252e-05f, -1.403259622e-05f, -4.504993268e-05f, +8.311142389e-06f, +9.782547217e-05f, +3.726276731e-05f, -1.577800351e-04f, -1.504279191e-04f, +1.831559283e-04f, +3.432731465e-04f, -1.060185066e-04f, -5.907029444e-04f, -1.552725920e-04f, +8.114924139e-04f, +6.757949444e-04f, -8.524738878e-04f, -1.509873614e-03f, +4.464969546e-04f, +2.711517747e-03f, +1.055293283e-03f, -4.438882863e-03f, -7.855439529e-03f, -4.247212811e-03f, +3.582512362e-03f, +7.838293220e-03f, +4.960817383e-03f, -6.440879846e-04f, -2.771380576e-03f, -7.149906656e-04f, +1.436200809e-03f, +9.970414821e-04f, -5.722950666e-04f, -8.693513573e-04f, +6.546002915e-05f, +5.973201982e-04f, +1.672355058e-04f, -3.269144798e-04f, -2.166383362e-04f, +1.296241714e-04f, +1.715643282e-04f, -2.110101439e-05f, -1.010356992e-04f, -1.771747005e-05f, +4.447928178e-05f, +1.825172823e-05f, -1.374395910e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +3.434619147e-04f, +4.448682911e-04f, -8.260402690e-04f, -2.213237867e-03f, +8.242170293e-04f, +5.039172428e-03f, +5.443651615e-04f, -8.791962461e-03f, -4.238983945e-03f, +1.246464298e-02f, +1.080552502e-02f, -1.446476562e-02f, -1.990588871e-02f, +1.308769786e-02f, +3.010157218e-02f, -7.205890758e-03f, -3.907557994e-02f, -3.107383555e-03f, +4.429289154e-02f, +1.632767096e-02f, -4.388136626e-02f, -2.977997158e-02f, +3.737590755e-02f, +4.043014041e-02f, -2.599214438e-02f, -4.587476777e-02f, +1.228427064e-02f, +4.513044631e-02f, +6.904909747e-04f, -3.890147103e-02f, -1.036195784e-02f, +2.923321351e-02f, +1.539447413e-02f, -1.872437923e-02f, -1.591976515e-02f, +9.645541439e-03f, +1.322324212e-02f, -3.315656674e-03f, -9.084527704e-03f, -6.546577670e-05f, +5.088471988e-03f, +1.152976278e-03f, -2.180311973e-03f, -9.619121554e-04f, +4.125938147e-04f, +3.718653085e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.456956252e-05f, +1.403259622e-05f, +6.749881676e-05f, -8.793007373e-06f, -1.614885928e-04f, -3.957983714e-05f, +2.953495630e-04f, +1.699142545e-04f, -4.391905107e-04f, -4.103599397e-04f, +5.375617856e-04f, +7.608363226e-04f, -5.226814836e-04f, -1.179963238e-03f, +3.386805202e-04f, +1.586492380e-03f, +3.184020880e-05f, -1.878532204e-03f, -5.509031291e-04f, +1.965692091e-03f, +1.127464817e-03f, -1.802207023e-03f, -1.640887595e-03f, +1.407040669e-03f, +1.978017705e-03f, -8.615044673e-04f, -2.069630568e-03f, +2.842869735e-04f, +1.911657141e-03f, +2.064466181e-04f, -1.562989149e-03f, -5.288067630e-04f, +1.121733156e-03f, +6.572149221e-04f, -6.906566020e-04f, -6.206470836e-04f, +3.460975324e-04f, +4.826081954e-04f, -1.215137638e-04f, -3.133900864e-04f, +9.205994243e-06f, +1.666221717e-04f, +2.432935045e-05f, -6.806228152e-05f, -1.825172823e-05f, +1.374395910e-05f, +0.000000000e+00f,
    /*  7,18 (48) */
    +0.000000000e+00f, -3.288923522e-04f, -4.589008873e-04f, +5.947053052e-04f, +1.478176420e-03f, -3.221019947e-04f, -3.085491750e-03f, -1.246602244e-03f, +4.681152568e-03f, +4.785789126e-03f, -4.942115687e-03f, -1.037992220e-02f, +1.959814827e-03f, +1.700885791e-02f, +6.338558987e-03f, -2.220561788e-02f, -2.173528197e-02f, +2.182485354e-02f, +4.591081542e-02f, -8.858839214e-03f, -8.370151401e-02f, -3.648681276e-02f, +1.734278885e-01f, +3.881249991e-01f, +4.037929925e-01f, +2.048307479e-01f, -1.768248302e-02f, -8.710858933e-02f, -1.983343846e-02f, +4.358844119e-02f, +2.772292335e-02f, -1.803419106e-02f, -2.470493819e-02f, +2.974310605e-03f, +1.745150180e-02f, +4.337983186e-03f, -9.833470837e-03f, -6.283891837e-03f, +3.985790599e-03f, +5.242007481e-03f, -5.874437687e-04f, -3.202532034e-03f, -7.201722357e-04f, +1.426207250e-03f, +7.739611898e-04f, -3.943420865e-04f, -3.856092675e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.475606133e-05f, -1.264115220e-05f, -4.504608258e-05f, +5.272795322e-06f, +9.641700079e-05f, +4.232478271e-05f, -1.527371547e-04f, -1.566003717e-04f, +1.716253821e-04f, +3.473259368e-04f, -8.573145784e-05f, -5.864067609e-04f, -1.839544194e-04f, +7.897321568e-04f, +7.070875820e-04f, -8.023898903e-04f, -1.528509729e-03f, +3.578450253e-04f, +2.682936699e-03f, +1.183843295e-03f, -4.260375659e-03f, -7.845842068e-03f, -4.459849164e-03f, +3.352801220e-03f, +7.817121964e-03f, +5.129468842e-03f, -4.989267366e-04f, -2.782367157e-03f, -8.048396605e-04f, +1.405733032e-03f, +1.043006315e-03f, -5.347285126e-04f, -8.859933155e-04f, +3.442423318e-05f, +5.973757021e-04f, +1.876347751e-04f, -3.200625479e-04f, -2.273489669e-04f, +1.219519320e-04f, +1.756682150e-04f, -1.541445451e-05f, -1.017488775e-04f, -2.093151518e-05f, +4.408856978e-05f, +1.966269580e-05f, -1.337790988e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +3.288923522e-04f, +4.589008873e-04f, -7.585414522e-04f, -2.222030875e-03f, +6.627284365e-04f, +4.999592591e-03f, +8.397147245e-04f, -8.622048207e-03f, -4.678174456e-03f, +1.205428304e-02f, +1.134308680e-02f, -1.370392930e-02f, -2.042857020e-02f, +1.190773462e-02f, +3.044025270e-02f, -5.619398378e-03f, -3.904373973e-02f, -4.985915759e-03f, +4.374198841e-02f, +1.829336305e-02f, -4.275390145e-02f, -3.158217860e-02f, +3.573501995e-02f, +4.183718108e-02f, -2.401412668e-02f, -4.673627224e-02f, +1.021464007e-02f, +4.541473329e-02f, +2.602148116e-03f, -3.869502441e-02f, -1.192494699e-02f, +2.870440675e-02f, +1.651620728e-02f, -1.806716431e-02f, -1.661042175e-02f, +9.024894355e-03f, +1.356933965e-02f, -2.833048479e-03f, -9.206041467e-03f, -3.788558631e-04f, +5.097677983e-03f, +1.319598450e-03f, -2.155982623e-03f, -1.029974437e-03f, +3.943420865e-04f, +3.856092675e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.475606133e-05f, +1.264115220e-05f, +6.700876330e-05f, -3.826522264e-06f, -1.591478992e-04f, -4.916230295e-05f, +2.882835876e-04f, +1.848686923e-04f, -4.232604045e-04f, -4.295883275e-04f, +5.082080004e-04f, +7.806747605e-04f, -4.763941934e-04f, -1.194265648e-03f, +2.746595442e-04f, +1.587755150e-03f, +1.104998981e-04f, -1.859880104e-03f, -6.371135868e-04f, +1.923114997e-03f, +1.211392477e-03f, -1.736218473e-03f, -1.712271930e-03f, +1.323060455e-03f, +2.028816945e-03f, -7.687223488e-04f, -2.096068812e-03f, +1.933534389e-04f, +1.914954680e-03f, +2.860985280e-04f, -1.548569136e-03f, -5.910848864e-04f, +1.097282124e-03f, +7.002776567e-04f, -6.638131218e-04f, -6.464537228e-04f, +3.225912690e-04f, +4.954833594e-04f, -1.042882057e-04f, -3.182751618e-04f, -1.402081619e-06f, +1.676669522e-04f, +2.968781694e-05f, -6.793128886e-05f, -1.966269580e-05f, +1.337790988e-05f, +0.000000000e+00f,
    /*  7,19 (48) */
    +0.000000000e+00f, -3.141362909e-04f, -4.715420395e-04f, +5.496592227e-04f, +1.483449215e-03f, -2.256849939e-04f, -3.043166967e-03f, -1.399339399e-03f, +4.524552196e-03f, +4.957414508e-03f, -4.594789750e-03f, -1.046565366e-02f, +1.373408066e-03f, +1.682490349e-02f, +7.128291144e-03f, -2.149853030e-02f, -2.253767186e-02f, +2.029634381e-02f, +4.626866045e-02f, -6.175902515e-03f, -8.251767072e-02f, -4.074718842e-02f, +1.655820464e-01f, +3.836651499e-01f, +4.071457937e-01f, +2.126478698e-01f, -1.255301417e-02f, -8.760751607e-02f, -2.261580562e-02f, +4.278360153e-02f, +2.912865638e-02f, -1.699118475e-02f, -2.523966670e-02f, +2.088317289e-03f, +1.748592604e-02f, +4.935358888e-03f, -9.645836062e-03f, -6.603954385e-03f, +3.758441632e-03f, +5.363959413e-03f, -4.117755537e-04f, -3.217946489e-03f, -8.219211132e-04f, +1.405275735e-03f, +8.180497596e-04f, -3.746793907e-04f, -3.989871774e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.489951724e-05f, -1.126212154e-05f, -4.494883537e-05f, +2.291714961e-06f, +9.484918346e-05f, +4.721235117e-05f, -1.474921745e-04f, -1.623816207e-04f, +1.599501977e-04f, +3.506814349e-04f, -6.556473697e-05f, -5.810995041e-04f, -2.119339833e-04f, +7.668241626e-04f, +7.367145768e-04f, -7.515244226e-04f, -1.544192172e-03f, +2.698569752e-04f, +2.650225773e-03f, +1.307939416e-03f, -4.080005638e-03f, -7.828683285e-03f, -4.667641934e-03f, +3.119424623e-03f, +7.788175333e-03f, +5.295062159e-03f, -3.499495666e-04f, -2.788713209e-03f, -8.946109473e-04f, +1.372328744e-03f, +1.087695956e-03f, -4.957072808e-04f, -9.012323114e-04f, +2.922069502e-06f, +5.963306029e-04f, +2.079670723e-04f, -3.125149683e-04f, -2.377944815e-04f, +1.139251923e-04f, +1.795059626e-04f, -9.592308909e-06f, -1.022750137e-04f, -2.417511538e-05f, +4.359484627e-05f, +2.107058095e-05f, -1.296561261e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +3.141362909e-04f, +4.715420395e-04f, -6.915326889e-04f, -2.225857397e-03f, +5.035805373e-04f, +4.950430288e-03f, +1.127998312e-03f, -8.437179515e-03f, -5.101434860e-03f, +1.162469471e-02f, +1.185129480e-02f, -1.292325454e-02f, -2.090496439e-02f, +1.071346897e-02f, +3.071491225e-02f, -4.031643228e-03f, -3.893323983e-02f, -6.845795863e-03f, +4.310487483e-02f, +2.021647805e-02f, -4.154250897e-02f, -3.331839707e-02f, +3.402274802e-02f, +4.316024154e-02f, -2.198530973e-02f, -4.750499459e-02f, +8.118571258e-03f, +4.560808673e-02f, +4.517102796e-03f, -3.840892588e-02f, -1.347351612e-02f, +2.811332186e-02f, +1.761348941e-02f, -1.736688665e-02f, -1.727423487e-02f, +8.378440632e-03f, +1.389193092e-02f, -2.337565119e-03f, -9.310329673e-03f, -6.971310248e-04f, +5.096275901e-03f, +1.487265402e-03f, -2.126294806e-03f, -1.097905726e-03f, +3.746793907e-04f, +3.989871774e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.489951724e-05f, +1.126212154e-05f, +6.637651307e-05f, +1.018715016e-06f, -1.565121654e-04f, -5.844670138e-05f, +2.807313413e-04f, +1.991943163e-04f, -4.066739952e-04f, -4.476739156e-04f, +4.781423133e-04f, +7.986937526e-04f, -4.295565671e-04f, -1.205994828e-03f, +2.105410514e-04f, +1.585756300e-03f, +1.885058871e-04f, -1.837509136e-03f, -7.217016570e-04f, +1.876731160e-03f, +1.292671811e-03f, -1.666766124e-03f, -1.780124475e-03f, +1.236347376e-03f, +2.075524354e-03f, -6.741862898e-04f, -2.118285537e-03f, +1.016963831e-04f, +1.914333292e-03f, +3.655859086e-04f, -1.530866736e-03f, -6.525889165e-04f, +1.070357785e-03f, +7.422824492e-04f, -6.353069426e-04f, -6.712043721e-04f, +2.981025057e-04f, +5.074928212e-04f, -8.656421125e-05f, -3.225602511e-04f, -1.222027980e-05f, +1.683614557e-04f, +3.511866381e-05f, -6.763329471e-05f, -2.107058095e-05f, +1.296561261e-05f, +0.000000000e+00f,
    /*  7,20 (48) */
    +0.000000000e+00f, -2.992367736e-04f, -4.828041611e-04f, +5.047103873e-04f, +1.485740930e-03f, -1.308358105e-04f, -2.995954616e-03f, -1.546831573e-03f, +4.362170575e-03f, +5.117364706e-03f, -4.244108315e-03f, -1.053121839e-02f, +7.923085621e-04f, +1.661296950e-02f, +7.895115306e-03f, -2.076181572e-02f, -2.328919628e-02f, +1.875215164e-02f, +4.653851743e-02f, -3.525676742e-03f, -8.120973130e-02f, -4.482719406e-02f, +1.577533631e-01f, +3.789975080e-01f, +4.102652183e-01f, +2.204360452e-01f, -7.257952015e-03f, -8.795746564e-02f, -2.540451883e-02f, +4.188899058e-02f, +3.050098512e-02f, -1.590348879e-02f, -2.573537398e-02f, +1.187084978e-03f, +1.748884811e-02f, +5.531689491e-03f, -9.437868990e-03f, -6.916469353e-03f, +3.520647150e-03f, +5.477884605e-03f, -2.322695911e-04f, -3.227538798e-03f, -9.241961269e-04f, +1.381100619e-03f, +8.616446058e-04f, -3.536088098e-04f, -4.119527900e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.500084795e-05f, -9.898326944e-06f, -4.476060912e-05f, -6.271988012e-07f, +9.312825770e-05f, +5.191907005e-05f, -1.420585538e-04f, -1.677668407e-04f, +1.481544296e-04f, +3.533432234e-04f, -4.555393470e-05f, -5.748040784e-04f, -2.391693380e-04f, +7.428241466e-04f, +7.646438261e-04f, -6.999773566e-04f, -1.556932685e-03f, +1.826729847e-04f, +2.613502441e-03f, +1.427475945e-03f, -3.898014814e-03f, -7.804034221e-03f, -4.870373568e-03f, +2.882634107e-03f, +7.751439409e-03f, +5.457363617e-03f, -1.973050787e-04f, -2.790333414e-03f, -9.841495448e-04f, +1.336006934e-03f, +1.131014046e-03f, -4.552834036e-04f, -9.150227597e-04f, -2.899451371e-05f, +5.941723784e-04f, +2.281935112e-04f, -3.042761023e-04f, -2.479510728e-04f, +1.055537955e-04f, +1.830656208e-04f, -3.643661803e-06f, -1.026093788e-04f, -2.744214133e-05f, +4.299673875e-05f, +2.247204570e-05f, -1.250672977e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.992367736e-04f, +4.828041611e-04f, -6.251561758e-04f, -2.224838682e-03f, +3.470683719e-04f, +4.891983586e-03f, +1.408729653e-03f, -8.237985198e-03f, -5.508108855e-03f, +1.117702080e-02f, +1.232943712e-02f, -1.212456078e-02f, -2.133452096e-02f, +9.507474147e-03f, +3.092545330e-02f, -2.445886927e-03f, -3.874473394e-02f, -8.683305000e-03f, +4.238317317e-02f, +2.209320921e-02f, -4.024983716e-02f, -3.498516320e-02f, +3.224262355e-02f, +4.439658891e-02f, -1.990978538e-02f, -4.817918088e-02f, +6.000285721e-03f, +4.570978311e-02f, +6.431436087e-03f, -3.804333997e-02f, -1.500438286e-02f, +2.746073294e-02f, +1.868384719e-02f, -1.662460420e-02f, -1.790954181e-02f, +7.707236260e-03f, +1.419003343e-02f, -1.830072298e-03f, -9.396893884e-03f, -1.019691276e-03f, +5.084055621e-03f, +1.655626858e-03f, -2.091176142e-03f, -1.165539020e-03f, +3.536088098e-04f, +4.119527900e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.500084795e-05f, +9.898326944e-06f, +6.560775245e-05f, +5.734392500e-06f, -1.535938897e-04f, -6.741829055e-05f, +2.727178485e-04f, +2.128701444e-04f, -3.894760597e-04f, -4.645929399e-04f, +4.474363760e-04f, +8.148742466e-04f, -3.822717313e-04f, -1.215147420e-03f, +1.464592362e-04f, +1.580520533e-03f, +2.656998777e-04f, -1.811482537e-03f, -8.044982205e-04f, +1.826647489e-03f, +1.371140182e-03f, -1.593997990e-03f, -1.844306549e-03f, +1.147079970e-03f, +2.118038660e-03f, -5.780888186e-04f, -2.136223136e-03f, +9.503635785e-06f, +1.909777027e-03f, +4.447421613e-04f, -1.509898702e-03f, -7.131844500e-04f, +1.040996755e-03f, +7.831309738e-04f, -6.051815166e-04f, -6.948341928e-04f, +2.726713359e-04f, +5.185983570e-04f, -6.837271040e-05f, -3.262253562e-04f, -2.322833477e-05f, +1.686963471e-04f, +4.061075246e-05f, -6.716420108e-05f, -2.247204570e-05f, +1.250672977e-05f, +0.000000000e+00f,
    /*  7,21 (48) */
    +0.000000000e+00f, -2.842359257e-04f, -4.927024880e-04f, +4.599497782e-04f, +1.485113732e-03f, -3.770755277e-05f, -2.944035546e-03f, -1.688890127e-03f, +4.194403735e-03f, +5.265519135e-03f, -3.890765092e-03f, -1.057677233e-02f, +2.175044837e-04f, +1.637380016e-02f, +8.637939453e-03f, -1.999717189e-02f, -2.398917364e-02f, +1.719521895e-02f, +4.672119041e-02f, -9.121743007e-04f, -7.978225536e-02f, -4.872520888e-02f, +1.499493289e-01f, +3.741271344e-01f, +4.131478524e-01f, +2.281874846e-01f, -1.800588398e-03f, -8.815477071e-02f, -2.819485224e-02f, +4.090484104e-02f, +3.183699206e-02f, -1.477247475e-02f, -2.619065739e-02f, +2.720622181e-04f, +1.745985359e-02f, +6.125861869e-03f, -9.209675479e-03f, -7.220745456e-03f, +3.272696078e-03f, +5.583438400e-03f, -4.920397027e-05f, -3.231182459e-03f, -1.026805506e-03f, +1.353658478e-03f, +9.046413446e-04f, -3.311367641e-04f, -4.244595198e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.506105373e-05f, -8.552487914e-06f, -4.448396762e-05f, -3.479275925e-06f, +9.126065537e-05f, +5.643900752e-05f, -1.364499007e-04f, -1.727520416e-04f, +1.362620122e-04f, +3.553161379e-04f, -2.573387983e-05f, -5.675449142e-04f, -2.656204183e-04f, +7.177891105e-04f, +7.908466446e-04f, -6.478485272e-04f, -1.566747901e-03f, +9.643006054e-05f, +2.572888771e-03f, +1.542354717e-03f, -3.714645386e-03f, -7.771975044e-03f, -5.067833211e-03f, +2.642685756e-03f, +7.706910059e-03f, +5.616142078e-03f, -4.114853267e-05f, -2.787148517e-03f, -1.073298769e-03f, +1.296791870e-03f, +1.172865439e-03f, -4.135120799e-04f, -9.273211492e-04f, -6.127215102e-05f, +5.908904165e-04f, +2.482748867e-04f, -2.953516851e-04f, -2.577951417e-04f, +9.684840658e-05f, +1.863355934e-04f, +2.421989333e-06f, -1.027475501e-04f, -3.072628925e-05f, +4.229307530e-05f, +2.386368643e-05f, -1.200103319e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.842359257e-04f, +4.927024880e-04f, -5.595484234e-04f, -2.219104290e-03f, +1.934744823e-04f, +4.824565296e-03f, +1.681447502e-03f, -8.025115054e-03f, -5.897584915e-03f, +1.071242786e-02f, +1.277687349e-02f, -1.130968654e-02f, -2.171679269e-02f, +8.292326727e-03f, +3.107191253e-02f, -8.653663943e-04f, -3.847903407e-02f, -1.049478754e-02f, +4.157867495e-02f, +2.391985670e-02f, -3.887869698e-02f, -3.657916119e-02f, +3.039831700e-02f, +4.554366888e-02f, -1.779174672e-02f, -4.875726970e-02f, +3.864062585e-03f, +4.571928674e-02f, +8.341213115e-03f, -3.759859781e-02f, -1.651428156e-02f, +2.674754850e-02f, +1.972484395e-02f, -1.584147323e-02f, -1.851472333e-02f, +7.012402067e-03f, +1.446270476e-02f, -1.311473941e-03f, -9.465266595e-03f, -1.345916632e-03f, +5.060827286e-03f, +1.824323205e-03f, -2.050565390e-03f, -1.232703222e-03f, +3.311367641e-04f, +4.244595198e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.506105373e-05f, +8.552487914e-06f, +6.470836289e-05f, +1.031271056e-05f, -1.504059649e-04f, -7.606332210e-05f, +2.642687365e-04f, +2.258769512e-04f, -3.717120835e-04f, -4.803244579e-04f, +4.161624012e-04f, +8.292013105e-04f, -3.346428214e-04f, -1.221725550e-03f, +8.254725443e-05f, +1.572079214e-03f, +3.419261273e-04f, -1.781870932e-03f, -8.853385352e-04f, +1.772978338e-03f, +1.446641169e-03f, -1.518068837e-03f, -1.904687222e-03f, +1.055442178e-03f, +2.156267264e-03f, -4.806261020e-04f, -2.149832828e-03f, -8.303518807e-05f, +1.901278162e-03f, +5.234005202e-04f, -1.485688805e-03f, -7.727380717e-04f, +1.009241144e-03f, +8.227264984e-04f, -5.734842225e-04f, -7.172800494e-04f, +2.463404129e-04f, +5.287632087e-04f, -4.974615180e-05f, -3.292515434e-04f, -3.440515789e-05f, +1.686629464e-04f, +4.615252836e-05f, -6.652024205e-05f, -2.386368643e-05f, +1.200103319e-05f, +0.000000000e+00f,
    /*  7,22 (48) */
    +0.000000000e+00f, -2.691748720e-04f, -5.012549759e-04f, +4.154658105e-04f, +1.481634456e-03f, +5.355310260e-05f, -2.887596539e-03f, -1.825340028e-03f, +4.021651693e-03f, +5.401781148e-03f, -3.535448954e-03f, -1.060250621e-02f, -3.500404306e-04f, +1.610817975e-02f, +9.355728563e-03f, -1.920632525e-02f, -2.463702217e-02f, +1.562847105e-02f, +4.681762047e-02f, +1.660714471e-03f, -7.823990064e-02f, -5.243985426e-02f, +1.421773538e-01f, +3.690593012e-01f, +4.157905382e-01f, +2.358943946e-01f, +3.815553680e-03f, -8.819591925e-02f, -3.098200076e-02f, +3.983154227e-02f, +3.313378393e-02f, -1.359960931e-02f, -2.660416947e-02f, -6.552589311e-04f, +1.739858144e-02f, +6.716752286e-03f, -8.961400592e-03f, -7.516097141e-03f, +3.014900936e-03f, +5.680286807e-03f, +1.371316231e-04f, -3.228760470e-03f, -1.129553056e-03f, +1.322932189e-03f, +9.469344199e-04f, -3.072730776e-04f, -4.364605530e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.508121306e-05f, -7.227216627e-06f, -4.412161161e-05f, -6.260081759e-06f, +8.925298590e-05f, +6.076670666e-05f, -1.306799422e-04f, -1.773340635e-04f, +1.242967150e-04f, +3.566062405e-04f, -6.138583950e-06f, -5.593479040e-04f, -2.912490903e-04f, +6.917772238e-04f, +8.152977755e-04f, -5.952375593e-04f, -1.573659262e-03f, +1.126185069e-05f, +2.528511193e-03f, +1.652485180e-03f, -3.530139394e-03f, -7.732594905e-03f, -5.259816984e-03f, +2.399839862e-03f, +7.654592979e-03f, +5.771169318e-03f, +1.183583270e-04f, -2.779085504e-03f, -1.161900464e-03f, +1.254713117e-03f, +1.213156387e-03f, -3.704516143e-04f, -9.380861467e-04f, -9.385614083e-05f, +5.864760599e-04f, +2.681717440e-04f, -2.857488329e-04f, -2.673033459e-04f, +8.782050396e-05f, +1.893046668e-04f, +8.594746194e-06f, -1.026854258e-04f, -3.402109109e-05f, +4.148289141e-05f, +2.524204041e-05f, -1.144840713e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.691748720e-04f, +5.012549759e-04f, -4.948400605e-04f, -2.208791579e-03f, +4.306851739e-05f, +4.748501974e-03f, +1.945716238e-03f, -7.799238103e-03f, -6.269296998e-03f, +1.023210340e-02f, +1.319303589e-02f, -1.048048523e-02f, -2.205143551e-02f, +7.070601177e-03f, +3.115445979e-02f, +7.067128194e-04f, -3.813710794e-02f, -1.227665847e-02f, +4.069333641e-02f, +2.569283504e-02f, -3.743205581e-02f, -3.809723002e-02f, +2.849362978e-02f, +4.659911106e-02f, -1.563547945e-02f, -4.923789580e-02f, +1.714229757e-03f, +4.563625156e-02f, +1.024249128e-02f, -3.707519729e-02f, -1.799997036e-02f, +2.597481042e-02f, +2.073408509e-02f, -1.501874673e-02f, -1.908820755e-02f, +6.295122018e-03f, +1.470904517e-02f, -7.827107325e-04f, -9.515012747e-03f, -1.675168176e-03f, +5.026422129e-03f, +1.992986151e-03f, -2.004412861e-03f, -1.299223464e-03f, +3.072730776e-04f, +4.364605530e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.508121306e-05f, +7.227216627e-06f, +6.368440066e-05f, +1.474638968e-05f, -1.469616392e-04f, -8.436905505e-05f, +2.554101662e-04f, +2.381972856e-04f, -3.534281504e-04f, -4.948503601e-04f, +3.843929989e-04f, +8.416641236e-04f, -2.867727586e-04f, -1.225736781e-03f, +1.893694541e-05f, +1.560470263e-03f, +4.170317670e-04f, -1.748752148e-03f, -9.640625692e-04f, +1.715845240e-03f, +1.519024892e-03f, -1.439139845e-03f, -1.961143586e-03f, +9.616229592e-04f, +2.190126450e-03f, -3.819975348e-04f, -2.159074794e-03f, -1.757290856e-04f, +1.888837242e-03f, +6.013944085e-04f, -1.458267827e-03f, -8.311176495e-04f, +9.751384994e-04f, +8.609741092e-04f, -5.402663004e-04f, -7.384806670e-04f, +2.191548864e-04f, +5.379521862e-04f, -3.071845145e-05f, -3.316210050e-04f, -4.572887222e-05f, +1.682532630e-04f, +5.173204069e-05f, -6.569800200e-05f, -2.524204041e-05f, +1.144840713e-05f, +0.000000000e+00f,
    /*  7,23 (48) */
    +0.000000000e+00f, -2.540936589e-04f, -5.084821926e-04f, +3.713441989e-04f, +1.475374374e-03f, +1.428060885e-04f, -2.826829832e-03f, -1.956019970e-03f, +3.844317629e-03f, +5.526077863e-03f, -3.178842713e-03f, -1.060864479e-02f, -9.093883346e-04f, +1.581693066e-02f, +1.004750579e-02f, -1.839102747e-02f, -2.523225973e-02f, +1.405481179e-02f, +4.682888232e-02f, +4.189225664e-03f, -7.658741546e-02f, -5.596999366e-02f, +1.344447589e-01f, +3.637994842e-01f, +4.181903781e-01f, +2.435489876e-01f, +9.586722998e-03f, -8.807756092e-02f, -3.376108626e-02f, +3.866964181e-02f, +3.438849704e-02f, -1.238645292e-02f, -2.697462108e-02f, -1.593345078e-03f, +1.730472530e-02f, +7.303228346e-03f, -8.693228848e-03f, -7.801845974e-03f, +2.747597590e-03f, +5.768107311e-03f, +3.264362900e-04f, -3.220165724e-03f, -1.232238482e-03f, +1.288911098e-03f, +9.884173113e-04f, -2.820310372e-04f, -4.479089601e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.506247809e-05f, -5.925014199e-06f, -4.367637005e-05f, -8.965421965e-06f, +8.711201950e-05f, +6.489718843e-05f, -1.247624957e-04f, -1.815105706e-04f, +1.122820998e-04f, +3.572207922e-04f, +1.319881162e-05f, -5.502403358e-04f, -3.160191976e-04f, +6.648477053e-04f, +8.379753945e-04f, -5.422436965e-04f, -1.577692923e-03f, -7.270153211e-05f, +2.480500260e-03f, +1.757784465e-03f, -3.344738387e-03f, -7.685991774e-03f, -5.446128244e-03f, +2.154360581e-03f, +7.594503719e-03f, +5.922220368e-03f, +2.810474539e-04f, -2.766077777e-03f, -1.249795243e-03f, +1.209805552e-03f, +1.251794720e-03f, -3.261633500e-04f, -9.472786986e-04f, -1.266905299e-04f, +5.809226461e-04f, +2.878444504e-04f, -2.754760482e-04f, -2.764526489e-04f, +7.848236882e-05f, +1.919620389e-04f, +1.486432307e-05f, -1.024192393e-04f, -3.731992528e-05f, +4.056543633e-05f, +2.660359268e-05f, -1.084885119e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.540936589e-04f, +5.084821926e-04f, -4.311556598e-04f, -2.194045189e-03f, -1.038931219e-04f, +4.664132919e-03f, +2.201126405e-03f, -7.561040817e-03f, -6.622725149e-03f, +9.737253038e-03f, +1.357742889e-02f, -9.638821104e-03f, -2.233820827e-02f, +5.844864396e-03f, +3.117339673e-02f, +2.267183082e-03f, -3.772007617e-02f, -1.402541062e-02f, +3.972927384e-02f, +2.740868028e-02f, -3.591303092e-02f, -3.953636987e-02f, +2.653248619e-02f, +4.756073402e-02f, -1.344535300e-02f, -4.961989334e-02f, -4.448450370e-04f, +4.546052247e-02f, +1.213132852e-02f, -3.647380288e-02f, -1.945823819e-02f, +2.514369277e-02f, +2.170922359e-02f, -1.415777262e-02f, -1.962847385e-02f, +5.556641351e-03f, +1.492820006e-02f, -2.447585463e-04f, -9.545731198e-03f, -2.006789181e-03f, +4.980693256e-03f, +2.161239414e-03f, -1.952680821e-03f, -1.364921466e-03f, +2.820310372e-04f, +4.479089601e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.506247809e-05f, +5.925014199e-06f, +6.254207668e-05f, +1.902867683e-05f, -1.432744774e-04f, -9.232376686e-05f, +2.461687640e-04f, +2.498154825e-04f, -3.346708314e-04f, -5.081553750e-04f, +3.522010130e-04f, +8.522559589e-04f, -2.387640299e-04f, -1.227194049e-03f, -4.424144080e-05f, +1.545738034e-03f, +4.908671114e-04f, -1.712211021e-03f, -1.040515324e-03f, +1.655376630e-03f, +1.588148312e-03f, -1.357378262e-03f, -2.013561012e-03f, +8.658158848e-04f, +2.219541565e-03f, -2.824053234e-04f, -2.163918277e-03f, -2.683860678e-04f, +1.872463125e-03f, +6.785577956e-04f, -1.427673533e-03f, -8.881926267e-04f, +9.387417533e-04f, +8.977809330e-04f, -5.055827778e-04f, -7.583767867e-04f, +1.911623324e-04f, +5.461317680e-04f, -1.132493745e-05f, -3.333171188e-04f, -5.717684970e-05f, +1.674600283e-04f, +5.733696346e-05f, -6.469443335e-05f, -2.660359268e-05f, +1.084885119e-05f, +0.000000000e+00f,
    /*  7,24 (48) */
    +0.000000000e+00f, -2.390311808e-04f, -5.144072068e-04f, +3.276678289e-04f, +1.466408952e-03f, +2.299181080e-04f, -2.761932644e-03f, -2.080782465e-03f, +3.662807059e-03f, +5.638359962e-03f, -2.821621921e-03f, -1.059544598e-02f, -1.459628670e-03f, +1.550091146e-02f, +1.071235349e-02f, -1.755305208e-02f, -2.577450342e-02f, +1.247711886e-02f, +4.675618079e-02f, +6.669725923e-03f, -7.482963099e-02f, -5.931473204e-02f, +1.267587672e-01f, +3.583533560e-01f, +4.203447386e-01f, +2.511434913e-01f, +1.550894337e-02f, -8.779651347e-02f, -3.652716404e-02f, +3.741984656e-02f, +3.559830260e-02f, -1.113465820e-02f, -2.730078443e-02f, -2.540623776e-03f, +1.717803477e-02f, +7.884150992e-03f, -8.405384397e-03f, -8.077322022e-03f, +2.471144941e-03f, +5.846589680e-03f, +5.183983289e-04f, -3.205301401e-03f, -1.334657721e-03f, +1.251591172e-03f, +1.028982748e-03f, -2.554274445e-04f, -4.587578113e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.500607012e-05f, -4.648267252e-06f, -4.315119110e-05f, -1.159134683e-05f, +8.484467018e-05f, +6.882595364e-05f, -1.187114401e-04f, -1.852800431e-04f, +1.002414783e-04f, +3.571682227e-04f, +3.224608662e-05f, -5.402508255e-04f, -3.398966032e-04f, +6.370607032e-04f, +8.588611084e-04f, -4.889656325e-04f, -1.578879652e-03f, -1.553336802e-04f, +2.428990405e-03f, +1.858177439e-03f, -3.158683085e-03f, -7.632272277e-03f, -5.626577831e-03f, +1.906515583e-03f, +7.526667692e-03f, +6.069073841e-03f, +4.467446921e-04f, -2.748065320e-03f, -1.336822724e-03f, +1.162109368e-03f, +1.288690027e-03f, -2.807115945e-04f, -9.548621291e-04f, -1.597182014e-04f, +5.742255451e-04f, +3.072532678e-04f, -2.645432223e-04f, -2.852203686e-04f, +6.884707305e-05f, +1.942973467e-04f, +2.122006131e-05f, -1.019455730e-04f, -4.061602803e-05f, +3.954017920e-05f, +2.794478312e-05f, -1.020248298e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.390311808e-04f, +5.144072068e-04f, -3.686135832e-04f, -2.175016512e-03f, -2.471675992e-04f, +4.571809152e-03f, +2.447295169e-03f, -7.311225335e-03f, -6.957395980e-03f, +9.229097663e-03f, +1.392962991e-02f, -8.786565145e-03f, -2.257697230e-02f, +4.617670347e-03f, +3.112915529e-02f, +3.812921116e-03f, -3.722920906e-02f, -1.573762164e-02f, +3.868875852e-02f, +2.906405691e-02f, -3.432488260e-02f, -4.089374813e-02f, +2.451892518e-02f, +4.842654990e-02f, -1.122581144e-02f, -4.990229866e-02f, -2.608763314e-03f, +4.519213640e-02f, +1.400379164e-02f, -3.579524509e-02f, -2.088591172e-02f, +2.425550015e-02f, +2.264796534e-02f, -1.325999169e-02f, -2.013405663e-02f, +4.798264564e-03f, +1.511936239e-02f, +3.013732217e-04f, -9.557056136e-03f, -2.340106299e-03f, +4.923516407e-03f, +2.328699442e-03f, -1.895343857e-03f, -1.429615899e-03f, +2.554274445e-04f, +4.587578113e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.500607012e-05f, +4.648267252e-06f, +6.128773634e-05f, +2.315335024e-05f, -1.393583212e-04f, -9.991676201e-05f, +2.365715527e-04f, +2.607176712e-04f, -3.154870750e-04f, -5.202270671e-04f, +3.196593601e-04f, +8.609741559e-04f, -1.907184711e-04f, -1.226115595e-03f, -1.068595109e-04f, +1.527933181e-03f, +5.632859609e-04f, -1.672339179e-03f, -1.114547142e-03f, +1.591707552e-03f, +1.653875520e-03f, -1.272957041e-03f, -2.061833388e-03f, +7.682187358e-04f, +2.244447194e-03f, -1.820540613e-04f, -2.164341675e-03f, -3.608135648e-04f, +1.852172990e-03f, +7.547255546e-04f, -1.393950635e-03f, -9.438343146e-04f, +9.001091448e-04f, +9.330563568e-04f, -4.694923866e-04f, -7.769113186e-04f, +1.624126768e-04f, +5.532701980e-04f, +8.397709338e-06f, -3.343245057e-04f, -6.872575091e-05f, +1.662767285e-04f, +6.295461800e-05f, -6.350687369e-05f, -2.794478312e-05f, +1.020248298e-05f, +0.000000000e+00f,
    /*  7,25 (48) */
    +0.000000000e+00f, -2.240251107e-04f, -5.190554740e-04f, +2.845166378e-04f, +1.454817605e-03f, +3.147627782e-04f, -2.693106690e-03f, -2.199493906e-03f, +3.477527016e-03f, +5.738601441e-03f, -2.464453698e-03f, -1.056319989e-02f, -1.999879496e-03f, +1.516101486e-02f, +1.134941420e-02f, -1.669419097e-02f, -2.626346905e-02f, +1.089823921e-02f, +4.660084711e-02f, +9.098716328e-03f, -7.297145356e-02f, -6.247341513e-02f, +1.191264949e-01f, +3.527267781e-01f, +4.222512542e-01f, +2.586701590e-01f, +2.157801721e-02f, -8.734976877e-02f, -3.927522936e-02f, +3.608302384e-02f, +3.676041196e-02f, -9.845968173e-03f, -2.758149602e-02f, -3.495485906e-03f, +1.701831657e-02f, +8.458376537e-03f, -8.098131130e-03f, -8.341865244e-03f, +2.185924572e-03f, +5.915436753e-03f, +7.126956756e-04f, -3.184081339e-03f, -1.436603294e-03f, +1.210975144e-03f, +1.068522927e-03f, -2.274826614e-04f, -4.689602943e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.491327491e-05f, -3.399244831e-06f, -4.254913318e-05f, -1.413415498e-05f, +8.245797894e-05f, +7.254898397e-05f, -1.125406874e-04f, -1.886417687e-04f, +8.819787101e-05f, +3.564580986e-04f, +5.097199019e-05f, -5.294092466e-04f, -3.628492277e-04f, +6.084771756e-04f, +8.779399475e-04f, -4.355013456e-04f, -1.577254726e-03f, -2.365120531e-04f, +2.374119699e-03f, +1.953596747e-03f, -2.972213043e-03f, -7.571551505e-03f, -5.800984315e-03f, +1.656575693e-03f, +7.451120177e-03f, +6.211512263e-03f, +6.152699801e-04f, -2.724994848e-03f, -1.422821778e-03f, +1.111670068e-03f, +1.323753831e-03f, -2.341635411e-04f, -9.608022356e-04f, -1.928809655e-04f, +5.663821937e-04f, +3.263584260e-04f, -2.529616351e-04f, -2.935842267e-04f, +5.892846530e-05f, +1.963006941e-04f, +2.765094472e-05f, -1.012613717e-04f, -4.390250510e-05f, +3.840681472e-05f, +2.926201376e-05f, -9.509540550e-06f, +0.000000000e+00f,
    +0.000000000e+00f, +2.240251107e-04f, +5.190554740e-04f, -3.073258468e-04f, -2.151863162e-03f, -3.865259204e-04f, +4.471892390e-03f, +2.683866721e-03f, -7.050507664e-03f, -7.272883055e-03f, +8.708870596e-03f, +1.424928927e-02f, -7.925590989e-03f, -2.276769077e-02f, +3.391554752e-03f, +3.102229578e-02f, +5.340854297e-03f, -3.666592310e-02f, -1.740996082e-02f, +3.757421138e-02f, +3.065576446e-02f, -3.267100708e-02f, -4.216670517e-02f, +2.245709179e-02f, +4.919476864e-02f, -8.981364246e-03f, -5.008435272e-02f, -4.773104989e-03f, +4.483132284e-02f, +1.585596463e-02f, -3.504051953e-02f, -2.227986236e-02f, +2.331166583e-02f, +2.354807449e-02f, -1.232693533e-02f, -2.060354902e-02f, +4.021353246e-03f, +1.528177507e-02f, +8.546434197e-04f, -9.548658426e-03f, -2.674430805e-03f, +4.854790656e-03f, +2.494976171e-03f, -1.832389239e-03f, -1.493122773e-03f, +2.274826614e-04f, +4.689602943e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.491327491e-05f, +3.399244831e-06f, +5.992783944e-05f, +2.711472282e-05f, -1.352272513e-04f, -1.071383779e-04f, +2.266458833e-04f, +2.708917795e-04f, -2.959240970e-04f, -5.310558291e-04f, +2.868408691e-04f, +8.678200852e-04f, -1.427370524e-04f, -1.222524883e-03f, -1.687909899e-04f, +1.507112506e-03f, +6.341458936e-04f, -1.629234820e-03f, -1.186014010e-03f, +1.524979356e-03f, +1.716078009e-03f, -1.186054466e-03f, -2.105863338e-03f, +6.690330814e-04f, +2.264787302e-03f, -8.115029959e-05f, -2.160332612e-03f, -4.528188339e-04f, +1.827992339e-03f, +8.297338200e-04f, -1.357150735e-03f, -9.979161819e-04f, +8.593041379e-04f, +9.667122445e-04f, -4.320574712e-04f, -7.940294904e-04f, +1.329581136e-04f, +5.593375809e-04f, +2.841151869e-05f, -3.346290863e-04f, -8.035156716e-05f, +1.646976352e-04f, +6.857199685e-05f, -6.213306230e-05f, -2.926201376e-05f, +9.509540550e-06f, +0.000000000e+00f,
    /*  7,26 (48) */
    +0.000000000e+00f, -2.091118358e-04f, -5.224547188e-04f, +2.419675046e-04f, +1.440683450e-03f, +3.972207571e-04f, -2.620557706e-03f, -2.312034593e-03f, +3.288885247e-03f, +5.826799312e-03f, -2.107995600e-03f, -1.051222790e-02f, -2.529288742e-03f, +1.479816563e-02f, +1.195789137e-02f, -1.581625102e-02f, -2.669897040e-02f, +9.320984485e-03f, +4.636433506e-02f, +1.147283603e-02f, -7.101785681e-02f, -6.544562817e-02f, +1.115549434e-01f, +3.469257938e-01f, +4.239078299e-01f, +2.661212792e-01f, +2.778952947e-02f, -8.673449879e-02f, -4.200022421e-02f, +3.466020206e-02f, +3.787208203e-02f, -8.522214343e-03f, -2.781565957e-02f, -4.456288141e-03f, +1.682543560e-02f, +9.024758730e-03f, -7.771772704e-03f, -8.594826879e-03f, +1.892340346e-03f, +5.974365218e-03f, +9.089963697e-04f, -3.156430395e-03f, -1.537864666e-03f, +1.167072639e-03f, +1.106929742e-03f, -1.982206477e-04f, -4.784698349e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.478543797e-05f, -2.180095653e-06f, -4.187335580e-05f, -1.659039649e-05f, +7.995909681e-05f, +7.606274189e-05f, -1.062641544e-04f, -1.915958308e-04f, +7.617396702e-05f, +3.551010896e-04f, +6.934628683e-05f, -5.177466597e-04f, -3.848470823e-04f, +5.791587704e-04f, +8.952003513e-04f, -3.819479360e-04f, -1.572857817e-03f, -3.161181312e-04f, +2.316029593e-03f, +2.043982842e-03f, -2.785566329e-03f, -7.503952826e-03f, -5.969174217e-03f, +1.404814536e-03f, +7.367906298e-03f, +6.349322397e-03f, +7.864375643e-04f, -2.696819961e-03f, -1.507630778e-03f, +1.058538454e-03f, +1.356899769e-03f, -1.865891824e-04f, -9.650673803e-04f, -2.261196541e-04f, +5.573921262e-04f, +3.451201979e-04f, -2.407439523e-04f, -3.015223972e-04f, +4.874115534e-05f, +1.979626789e-04f, +3.414561603e-05f, -1.003639553e-04f, -4.717234406e-05f, +3.716526842e-05f, +3.055165641e-05f, -8.770384584e-06f, +0.000000000e+00f,
    +0.000000000e+00f, +2.091118358e-04f, +5.224547188e-04f, -2.473980074e-04f, -2.124748439e-03f, -5.217531717e-04f, +4.364754012e-03f, +2.910512605e-03f, -6.779615884e-03f, -7.568807152e-03f, +8.177814767e-03f, +1.453613013e-02f, -7.057770904e-03f, -2.291042782e-02f, +2.169029869e-03f, +3.085350479e-02f, +6.847966803e-03f, -3.603177721e-02f, -1.903919564e-02f, +3.638819737e-02f, +3.218074382e-02f, -3.095492907e-02f, -4.335275964e-02f, +2.035122845e-02f, +4.986380172e-02f, -6.716576944e-03f, -5.016550302e-02f, -6.933437601e-03f, +4.437850400e-02f, +1.768395697e-02f, -3.421078571e-02f, -2.363701309e-02f, +2.231374965e-02f, +2.440737863e-02f, -1.136022309e-02f, -2.103560649e-02f, +3.227323755e-03f, +1.541473318e-02f, +1.413981001e-03f, -9.520246907e-03f, -3.009059891e-03f, +4.774439089e-03f, +2.659673806e-03f, -1.763817242e-03f, -1.555255835e-03f, +1.982206477e-04f, +4.784698349e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.478543797e-05f, +2.180095653e-06f, +5.846894037e-05f, +3.090764417e-05f, -1.308955478e-04f, -1.139799881e-04f, +2.164193667e-04f, +2.803275333e-04f, -2.760292722e-04f, -5.406348675e-04f, +2.538181231e-04f, +8.727991044e-04f, -9.491966892e-05f, -1.216450505e-03f, -2.299119763e-04f, +1.483338804e-03f, +7.033085484e-04f, -1.583002471e-03f, -1.254777836e-03f, +1.455339376e-03f, +1.774634935e-03f, -1.096853765e-03f, -2.145562425e-03f, +5.684638544e-04f, +2.280515365e-03f, +2.009788815e-05f, -2.151887982e-03f, -5.442093688e-04f, +1.799954978e-03f, +9.034203447e-04f, -1.317332257e-03f, -1.050314142e-03f, +8.163953233e-04f, +9.986631499e-04f, -3.933438867e-04f, -8.096789935e-04f, +1.028530154e-04f, +5.643059740e-04f, +4.867729821e-05f, -3.342181337e-04f, -9.202966494e-05f, +1.627178350e-04f, +7.417578898e-05f, -6.057115596e-05f, -3.055165641e-05f, +8.770384584e-06f, +0.000000000e+00f,
    /*  7,27 (48) */
    +0.000000000e+00f, -1.943263978e-04f, -5.246348145e-04f, +2.000941488e-04f, +1.424093054e-03f, +4.771798539e-04f, -2.544494964e-03f, -2.418298747e-03f, +3.097289416e-03f, +5.902973279e-03f, -1.752894510e-03f, -1.044288162e-02f, -3.047035402e-03f, +1.441331855e-02f, +1.253705014e-02f, -1.492105067e-02f, -2.708091834e-02f, +7.748126668e-03f, +4.604821692e-02f, +1.378886562e-02f, -6.897387397e-02f, -6.823119450e-02f, +1.040509906e-01f, +3.409566196e-01f, +4.253126445e-01f, +2.734891855e-01f, +3.413885187e-02f, -8.594806123e-02f, -4.469704417e-02f, +3.315257128e-02f, +3.893062048e-02f, -7.165314573e-03f, -2.800224875e-02f, -5.421355521e-03f, +1.659931595e-02f, +9.582150857e-03f, -7.426652506e-03f, -8.835570832e-03f, +1.590817949e-03f, +6.023106374e-03f, +1.106959049e-03f, -3.122284779e-03f, -1.638228621e-03f, +1.119900295e-03f, +1.144095010e-03f, -1.676689913e-04f, -4.872402194e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.462395980e-05f, -9.928457007e-07f, -4.112711044e-05f, -1.895687537e-05f, +7.735526809e-05f, +7.936416972e-05f, -9.989573536e-05f, -1.941430972e-04f, +6.419208530e-05f, +3.531089337e-04f, +8.733979986e-05f, -5.052952394e-04f, -4.058622990e-04f, +5.491677055e-04f, +9.106341493e-04f, -3.284014664e-04f, -1.565732871e-03f, -3.940375622e-04f, +2.254864673e-03f, +2.129284004e-03f, -2.598979196e-03f, -7.429607677e-03f, -6.130982232e-03f, +1.151508169e-03f, +7.277080996e-03f, +6.482295563e-03f, +9.600562222e-04f, -2.663501277e-03f, -1.591087852e-03f, +1.002770603e-03f, +1.388043770e-03f, -1.380612193e-04f, -9.676285787e-04f, -2.593742174e-04f, +5.472570011e-04f, +3.634989747e-04f, -2.279042196e-04f, -3.090135547e-04f, +3.830049673e-05f, +1.992744192e-04f, +4.069239427e-05f, -9.925103113e-05f, -5.041842712e-05f, +3.581570155e-05f, +3.181006045e-05f, -7.985500330e-06f, +0.000000000e+00f,
    +0.000000000e+00f, +1.943263978e-04f, +5.246348145e-04f, -1.889290670e-04f, -2.093840795e-03f, -6.526487195e-04f, +4.250774024e-03f, +3.126931971e-03f, -6.499288351e-03f, -7.844836425e-03f, +7.637179899e-03f, +1.478994826e-02f, -6.184971799e-03f, -2.300534749e-02f, +9.525793645e-04f, +3.062359282e-02f, +8.331305607e-03f, -3.532846866e-02f, -2.062219811e-02f, +3.513341953e-02f, +3.363608319e-02f, -2.918029414e-02f, -4.444961340e-02f, +1.820566603e-02f, +5.043226558e-02f, -4.436061579e-03f, -5.014540513e-02f, -9.085325584e-03f, +4.383429464e-02f, +1.948391195e-02f, -3.330736537e-02f, -2.495434535e-02f, +2.126343551e-02f, +2.522377395e-02f, -1.036155994e-02f, -2.142895037e-02f, +2.417644762e-03f, +1.551758620e-02f, +1.978286975e-03f, -9.471569609e-03f, -3.343278025e-03f, +4.682409424e-03f, +2.822391641e-03f, -1.689641453e-03f, -1.615826991e-03f, +1.676689913e-04f, +4.872402194e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.462395980e-05f, +9.928457007e-07f, +5.691766838e-05f, +3.452750106e-05f, -1.263776520e-04f, -1.204340034e-04f, +2.059198058e-04f, +2.890164525e-04f, -2.558500265e-04f, -5.489601822e-04f, +2.206633037e-04f, +8.759205059e-04f, -4.736493450e-05f, -1.207926078e-03f, -2.901011902e-04f, +1.456680690e-03f, +7.706398975e-04f, -1.533752739e-03f, -1.320706728e-03f, +1.382940602e-03f, +1.829433348e-03f, -1.005542717e-03f, -2.180851332e-03f, +4.667189164e-04f, +2.291594477e-03f, +1.214813444e-04f, -2.139013986e-03f, -6.347933102e-04f, +1.768102977e-03f, +9.756248546e-04f, -1.274560359e-03f, -1.100906835e-03f, +7.714563107e-04f, +1.028826526e-03f, -3.534208899e-04f, -8.238101248e-04f, +7.215383980e-05f, +5.681494757e-04f, +6.915470437e-05f, -3.330803253e-04f, -1.037348326e-04f, +1.603332576e-04f, +7.975240632e-05f, -5.881974410e-05f, -3.181006045e-05f, +7.985500330e-06f, +0.000000000e+00f,
    /*  7,28 (48) */
    +0.000000000e+00f, -1.797024380e-04f, -5.256276602e-04f, +1.589670384e-04f, +1.405136178e-03f, +5.545351220e-04f, -2.465130794e-03f, -2.518194483e-03f, +2.903146319e-03f, +5.967165364e-03f, -1.399785577e-03f, -1.035554182e-02f, -3.552330642e-03f, +1.400745625e-02f, +1.308621785e-02f, -1.401041652e-02f, -2.740931980e-02f, +6.182393798e-03f, +4.565417936e-02f, +1.604373029e-02f, -6.684458996e-02f, -7.083017370e-02f, +9.662138288e-02f, +3.348256374e-01f, +4.264641526e-01f, +2.807662665e-01f, +4.062114743e-02f, -8.498800501e-02f, -4.736054545e-02f, +3.156148343e-02f, +3.993339109e-02f, -5.777270803e-03f, -2.814030997e-02f, -6.388984100e-03f, +1.633994173e-02f, +1.012940786e-02f, -7.063153531e-03f, -9.063475051e-03f, +1.281804394e-03f, +6.061406870e-03f, +1.306233468e-03f, -3.081592384e-03f, -1.737479652e-03f, +1.069481868e-03f, +1.179910712e-03f, -1.358589308e-04f, -4.952257198e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.443029105e-05f, +1.606038524e-07f, -4.031373136e-05f, -2.123065152e-05f, +7.465381357e-05f, +8.245068760e-05f, -9.344927460e-05f, -1.962852063e-04f, +5.227413708e-05f, +3.504943998e-04f, +1.049244523e-04f, -4.920882012e-04f, -4.258691551e-04f, +5.185666495e-04f, +9.242365355e-04f, -2.749568061e-04f, -1.555927983e-03f, -4.701602984e-04f, +2.190772398e-03f, +2.209456350e-03f, -2.412685758e-03f, -7.348655345e-03f, -6.286251430e-03f, +8.969347129e-04f, +7.178708984e-03f, +6.610227950e-03f, +1.135929496e-03f, -2.625006558e-03f, -1.673031134e-03f, +9.444278384e-04f, +1.417104224e-03f, -8.865496331e-05f, -9.684595838e-04f, -2.925838239e-04f, +5.359806252e-04f, +3.814553423e-04f, -2.144578550e-04f, -3.160369234e-04f, +2.762256769e-05f, +2.002275795e-04f, +4.727929308e-05f, -9.792070572e-05f, -5.363354428e-05f, +3.435851553e-05f, +3.303356079e-05f, -7.155499268e-06f, +0.000000000e+00f,
    +0.000000000e+00f, +1.797024380e-04f, +5.256276602e-04f, -1.320113986e-04f, -2.059313294e-03f, -7.790263715e-04f, +4.130340021e-03f, +3.332851777e-03f, -6.210271898e-03f, -8.100686451e-03f, +7.088219717e-03f, +1.501061156e-02f, -5.309051293e-03f, -2.305271243e-02f, -2.553467138e-04f, +3.033349163e-02f, +9.787986297e-03f, -3.455782876e-02f, -2.215595085e-02f, +3.381271281e-02f, +3.501902379e-02f, -2.735086079e-02f, -4.545515612e-02f, +1.602481470e-02f, +5.089898449e-02f, -2.144467102e-03f, -5.002392379e-02f, -1.122433957e-02f, +4.319950132e-02f, +2.125201493e-02f, -3.233174051e-02f, -2.622890571e-02f, +2.016252867e-02f, +2.599523026e-02f, -9.332733411e-03f, -2.178237126e-02f, +1.593834637e-03f, +1.558974004e-02f, +2.546436450e-03f, -9.402414905e-03f, -3.676358351e-03f, +4.578674591e-03f, +2.982724899e-03f, -1.609889047e-03f, -1.674646735e-03f, +1.358589308e-04f, +4.952257198e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.443029105e-05f, -1.606038524e-07f, +5.528070823e-05f, +3.797021669e-05f, -1.216881284e-04f, -1.264938699e-04f, +1.951751290e-04f, +2.969518419e-04f, -2.354337306e-04f, -5.560305404e-04f, +1.874480376e-04f, +8.771974561e-04f, -1.699807130e-07f, -1.196990134e-03f, -3.492402140e-04f, +1.427212413e-03f, +8.360105083e-04f, -1.481602044e-03f, -1.383675242e-03f, +1.307941340e-03f, +1.880368423e-03f, -9.123132502e-04f, -2.211660024e-03f, +3.640086191e-04f, +2.297997438e-03f, +2.227902696e-04f, -2.121726136e-03f, -7.243798566e-04f, +1.732486615e-03f, +1.046189401e-03f, -1.228906834e-03f, -1.149575910e-03f, +7.245656074e-04f, +1.057122928e-03f, -3.123610207e-04f, -8.363759240e-04f, +4.091902851e-05f, +5.708443107e-04f, +8.980231717e-05f, -3.312057915e-04f, -1.154413295e-04f, +1.575407020e-04f, +8.528801151e-05f, -5.687786299e-05f, -3.303356079e-05f, +7.155499268e-06f, +0.000000000e+00f,
    /*  7,29 (48) */
    +0.000000000e+00f, -1.652721470e-04f, -5.254670563e-04f, +1.186533070e-04f, +1.383905527e-03f, +6.291889356e-04f, -2.382680107e-03f, -2.611643757e-03f, +2.706861113e-03f, +6.019439501e-03f, -1.049291177e-03f, -1.025061737e-02f, -4.044418843e-03f, +1.358158709e-02f, +1.360478450e-02f, -1.308617999e-02f, -2.768427661e-02f, +4.626465814e-03f, +4.518401906e-02f, +1.823450269e-02f, -6.463513361e-02f, -7.324285945e-02f, +8.927272753e-02f, +3.285393859e-01f, +4.273610873e-01f, +2.879449755e-01f, +4.723137538e-02f, -8.385207551e-02f, -4.998555200e-02f, +2.988845230e-02f, +4.087781893e-02f, -4.360166579e-03f, -2.822896493e-02f, -7.357443684e-03f, +1.604735791e-02f, +1.066538848e-02f, -6.681698189e-03f, -9.277932906e-03f, +9.657674704e-04f, +6.089029438e-03f, +1.506461047e-03f, -3.034313091e-03f, -1.835400358e-03f, +1.015848324e-03f, +1.214269227e-03f, -1.028253700e-04f, -5.023812190e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.420592772e-05f, +1.278478377e-06f, -3.943662641e-05f, -2.340904202e-05f, +7.186211401e-05f, +8.532019059e-05f, -8.693853995e-05f, -1.980245521e-04f, +4.044158950e-05f, +3.472712501e-04f, +1.220733051e-04f, -4.781597261e-04f, -4.448440945e-04f, +4.874186029e-04f, +9.360060371e-04f, -2.217074795e-04f, -1.543495271e-03f, -5.443807266e-04f, +2.123902846e-03f, +2.284463820e-03f, -2.226917682e-03f, -7.261242746e-03f, -6.434833450e-03f, +6.413739816e-04f, +7.072864687e-03f, +6.732920928e-03f, +1.313855934e-03f, -2.581310828e-03f, -1.753299022e-03f, +8.835766843e-04f, +1.444002155e-03f, -3.844823356e-05f, -9.675369667e-04f, -3.256869626e-04f, +5.235689730e-04f, +3.989501581e-04f, -2.004216370e-04f, -3.225723242e-04f, +1.672415031e-05f, +2.008143956e-04f, +5.389403999e-05f, -9.637149550e-05f, -5.681040703e-05f, +3.279435594e-05f, +3.421848615e-05f, -6.281120501e-06f, +0.000000000e+00f,
    +0.000000000e+00f, +1.652721470e-04f, +5.254670563e-04f, -7.673069041e-05f, -2.021343077e-03f, -9.007144999e-04f, +4.003846151e-03f, +3.528026906e-03f, -5.913320056e-03f, -8.336120182e-03f, +6.532189177e-03f, +1.519805960e-02f, -4.431853837e-03f, -2.305288241e-02f, -1.452336848e-03f, +2.998425141e-02f, +1.121519871e-02f, -3.372181825e-02f, -2.363755289e-02f, +3.242903756e-02f, +3.632696513e-02f, -2.547049237e-02f, -4.636746937e-02f, +1.381315467e-02f, +5.126299311e-02f, +1.535303363e-04f, -4.980113352e-02f, -1.334606571e-02f, +4.247512147e-02f, +2.298450154e-02f, -3.128555111e-02f, -2.745781254e-02f, +1.901295276e-02f, +2.671979587e-02f, -8.275610483e-03f, -2.209473228e-02f, +7.574587130e-04f, +1.563065907e-02f, +3.117280761e-03f, -9.312612588e-03f, -4.007564142e-03f, +4.463233262e-03f, +3.140265601e-03f, -1.524601036e-03f, -1.731524598e-03f, +1.028253700e-04f, +5.023812190e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.420592772e-05f, -1.278478377e-06f, +5.356478109e-05f, +4.123224846e-05f, -1.168416268e-04f, -1.321540652e-04f, +1.842133237e-04f, +3.041287796e-04f, -2.148275953e-04f, -5.618474442e-04f, +1.542432463e-04f, +8.766469271e-04f, +4.656973925e-05f, -1.183685991e-03f, -4.072137252e-04f, +1.395013665e-03f, +8.992957936e-04f, -1.426672350e-03f, -1.443564632e-03f, +1.230504856e-03f, +1.927343658e-03f, -8.173610248e-04f, -2.237927891e-03f, +2.605453583e-04f, +2.299706817e-03f, +3.238146663e-04f, -2.100049250e-03f, -8.127796729e-04f, +1.693164308e-03f, +1.114958710e-03f, -1.180449996e-03f, -1.196206297e-03f, +6.758064862e-04f, +1.083476215e-03f, -2.702399750e-04f, -8.473323064e-04f, +9.208901701e-06f, +5.723689113e-04f, +1.105777184e-04f, -3.285861621e-04f, -1.271229364e-04f, +1.543378622e-04f, +9.076854688e-05f, -5.474500924e-05f, -3.421848615e-05f, +6.281120501e-06f, +0.000000000e+00f,
    /*  7,30 (48) */
    +0.000000000e+00f, -1.510662193e-04f, -5.241885780e-04f, +7.921668061e-05f, +1.360496485e-03f, +7.010510496e-04f, -2.297359916e-03f, -2.698582297e-03f, +2.508836561e-03f, +6.059881091e-03f, -7.020199266e-04f, -1.012854406e-02f, -4.522578569e-03f, +1.313674300e-02f, +1.409220310e-02f, -1.215017395e-02f, -2.790598409e-02f, +3.082970544e-03f, +4.463963834e-02f, +2.035840554e-02f, -6.235066979e-02f, -7.546977714e-02f, +8.201148479e-02f, +3.221045525e-01f, +4.280024613e-01f, +2.950178402e-01f, +5.396429631e-02f, -8.253821958e-02f, -5.256686283e-02f, +2.813515328e-02f, +4.176139561e-02f, -2.916164424e-03f, -2.826741316e-02f, -8.324980651e-03f, +1.572167095e-02f, +1.118895746e-02f, -6.282748031e-03f, -9.478354543e-03f, +6.431951462e-04f, +6.105753588e-03f, +1.707275443e-03f, -2.980419051e-03f, -1.931771853e-03f, +9.590379168e-04f, +1.247063583e-03f, -6.860688387e-05f, -5.086623395e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.395240629e-05f, +2.359131188e-06f, -3.849926784e-05f, -2.548962186e-05f, +6.898759360e-05f, +8.797104486e-05f, -8.037719661e-05f, -1.993642683e-04f, +2.871543078e-05f, +3.434541995e-04f, +1.387605929e-04f, -4.635448853e-04f, -4.627657440e-04f, +4.557867798e-04f, +9.459444776e-04f, -1.687455178e-04f, -1.528490732e-03f, -6.165977888e-04f, +2.054408452e-03f, +2.354278168e-03f, -2.041903873e-03f, -7.167524184e-03f, -6.576588681e-03f, +3.851071098e-04f, +6.959632173e-03f, +6.850181348e-03f, +1.493629345e-03f, -2.532396482e-03f, -1.831730441e-03f, +8.202888207e-04f, +1.468661393e-03f, +1.247875202e-05f, -9.648401929e-04f, -3.586215482e-04f, +5.100302025e-04f, +4.159446280e-04f, -1.858136918e-04f, -3.286002227e-04f, +5.622708085e-06f, +2.010276988e-04f, +6.052409654e-05f, -9.460233729e-05f, -5.994166238e-05f, +3.112411600e-05f, +3.536116739e-05f, -5.363231868e-06f, +0.000000000e+00f,
    +0.000000000e+00f, +1.510662193e-04f, +5.241885780e-04f, -2.316590932e-05f, -1.980110829e-03f, -1.017556127e-03f, +3.871692085e-03f, +3.712240230e-03f, -5.609191277e-03f, -8.550947777e-03f, +5.970341733e-03f, +1.535230285e-02f, -3.555206910e-03f, -2.300631267e-02f, -2.636022839e-03f, +2.957703769e-02f, +1.261021237e-02f, -3.282252246e-02f, -2.506422524e-02f, +3.098547293e-02f, +3.755746999e-02f, -2.354314871e-02f, -4.718483039e-02f, +1.157522678e-02f, +5.152353847e-02f, +2.453237153e-03f, -4.947731885e-02f, -1.544611496e-02f, +4.166234180e-02f, +2.467766585e-02f, -3.017059240e-02f, -2.863826254e-02f, +1.781674647e-02f, +2.739560235e-02f, -7.192134268e-03f, -2.236497226e-02f, -8.987359339e-05f, +1.563986797e-02f, +3.689649672e-03f, -9.202034869e-03f, -4.336150304e-03f, +4.336110325e-03f, +3.294603463e-03f, -1.433832489e-03f, -1.786269607e-03f, +6.860688387e-05f, +5.086623395e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.395240629e-05f, -2.359131188e-06f, +5.177662578e-05f, +4.431058451e-05f, -1.118528453e-04f, -1.374100914e-04f, +1.730623710e-04f, +3.105441002e-04f, -1.940785686e-04f, -5.664150925e-04f, +1.211189995e-04f, +8.742896207e-04f, +9.276064125e-05f, -1.168061624e-03f, -4.639097211e-04f, +1.360169373e-03f, +9.603762505e-04f, -1.369090876e-03f, -1.500263071e-03f, +1.150799020e-03f, +1.970271063e-03f, -7.208850167e-04f, -2.259603869e-03f, +1.565431243e-04f, +2.296715000e-03f, +4.243447843e-04f, -2.074017417e-03f, -8.998052987e-04f, +1.650202515e-03f, +1.181780527e-03f, -1.129274547e-03f, -1.240686479e-03f, +6.252668419e-04f, +1.107813740e-03f, -2.271364703e-04f, -8.566381906e-04f, -2.291445353e-05f, +5.727039945e-04f, +1.314375733e-04f, -3.252146092e-04f, -1.387530092e-04f, +1.507233495e-04f, +9.617976463e-05f, -5.242115229e-05f, -3.536116739e-05f, +5.363231868e-06f, +0.000000000e+00f,
    /*  7,31 (48) */
    +0.000000000e+00f, -1.371138130e-04f, -5.218294468e-04f, +4.071741277e-05f, +1.335006863e-03f, +7.700386432e-04f, -2.209388871e-03f, -2.778959494e-03f, +2.309472292e-03f, +6.088596521e-03f, -3.585657271e-04f, -9.989783468e-03f, -4.986123454e-03f, +1.267397725e-02f, +1.454798988e-02f, -1.120422947e-02f, -2.807472961e-02f, +1.554479812e-03f, +4.402304055e-02f, +2.241281399e-02f, -5.999639162e-02f, -7.751168101e-02f, +7.484396060e-02f, +3.155279638e-01f, +4.283875684e-01f, +3.019774723e-01f, +6.081447766e-02f, -8.104459023e-02f, -5.509925932e-02f, +2.630342283e-02f, +4.258168443e-02f, -1.447503031e-03f, -2.825493441e-02f, -9.289820844e-03f, +1.536304940e-02f, +1.169898766e-02f, -5.866803403e-03f, -9.664168235e-03f, +3.145949235e-04f, +6.111376296e-03f, +1.908303142e-03f, -2.919894955e-03f, -2.026374191e-03f, +8.990962544e-04f, +1.278187699e-03f, -3.324571648e-05f, -5.140255714e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +1.367129889e-05f, +3.401044618e-06f, -3.750518317e-05f, -2.747022415e-05f, +6.603770382e-05f, +9.040208288e-05f, -7.377878167e-05f, -2.003082109e-04f, +1.711613663e-05f, +3.390588754e-04f, +1.549617571e-04f, -4.482795641e-04f, -4.796149263e-04f, +4.237344909e-04f, +9.540569351e-04f, -1.161613155e-04f, -1.510974108e-03f, -6.867150942e-04f, +1.982443748e-03f, +2.418878930e-03f, -1.857870170e-03f, -7.067661105e-03f, -6.711386426e-03f, +1.284161757e-04f, +6.839105062e-03f, +6.961821842e-03f, +1.675039053e-03f, -2.478253380e-03f, -1.908165098e-03f, +7.546410229e-04f, +1.491008734e-03f, +6.404349089e-05f, -9.603516939e-04f, -3.913250279e-04f, +4.953746677e-04f, +4.324003844e-04f, -1.706534758e-04f, -3.341017752e-04f, -5.663638279e-06f, +2.008609397e-04f, +6.715667929e-05f, -9.261259788e-05f, -6.301990736e-05f, +2.934893968e-05f, +3.645794608e-05f, -4.402830756e-06f, +0.000000000e+00f,
    +0.000000000e+00f, +1.371138130e-04f, +5.218294468e-04f, +2.861071646e-05f, -1.935800244e-03f, -1.129408972e-03f, +3.734281994e-03f, +3.885302601e-03f, -5.298647177e-03f, -8.745026346e-03f, +5.403926640e-03f, +1.547342185e-02f, -2.680917289e-03f, -2.291355203e-02f, -3.804084463e-03f, +2.911312797e-02f, +1.397038175e-02f, -3.186214621e-02f, -2.643331612e-02f, +2.948520986e-02f, +3.870826901e-02f, -2.157287765e-02f, -4.790571541e-02f, +9.315622911e-03f, +5.168008159e-02f, +4.749952153e-03f, -4.905297407e-02f, -1.752013237e-02f, +4.076253650e-02f, +2.632786837e-02f, -2.898881188e-02f, -2.976753709e-02f, +1.657605999e-02f, +2.802086920e-02f, -6.084320528e-03f, -2.259210873e-02f, -9.465117840e-04f, +1.561695352e-02f, +4.262353667e-03f, -9.070597296e-03f, -4.661364913e-03f, +4.197357316e-03f, +3.445326813e-03f, -1.337652724e-03f, -1.838690760e-03f, +3.324571648e-05f, +5.140255714e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -1.367129889e-05f, -3.401044618e-06f, +4.992298047e-05f, +4.720273898e-05f, -1.067364938e-04f, -1.422584669e-04f, +1.617501818e-04f, +3.161963751e-04f, -1.732332348e-04f, -5.697403375e-04f, +8.814437108e-05f, +8.701498844e-04f, +1.383111949e-04f, -1.150169523e-03f, -5.192197337e-04f, +1.322769487e-03f, +1.019137686e-03f, -1.308989800e-03f, -1.553665861e-03f, +1.068995934e-03f, +2.009071323e-03f, -6.230870902e-04f, -2.276646540e-03f, +5.221704922e-05f, +2.289024217e-03f, +5.241715658e-04f, -2.043673952e-03f, -9.852715527e-04f, +1.603675632e-03f, +1.246505957e-03f, -1.075471433e-03f, -1.282908753e-03f, +5.730390367e-04f, +1.130066542e-03f, -1.831321024e-04f, -8.642556210e-04f, -5.538729978e-05f, +5.718326359e-04f, +1.523377155e-04f, -3.210858882e-04f, -1.503045336e-04f, +1.466967147e-04f, +1.015072581e-04f, -4.990674596e-05f, -3.645794608e-05f, +4.402830756e-06f, +0.000000000e+00f,
    /*  8, 0 (44) */
    +0.000000000e+00f, -5.810608668e-04f, -4.000691189e-04f, +1.473036739e-03f, +1.194314507e-03f, -2.873286720e-03f, -2.812546922e-03f, +4.814679451e-03f, +5.726744505e-03f, -7.245170423e-03f, -1.058087851e-02f, +1.001747038e-02f, +1.834373570e-02f, -1.289773969e-02f, -3.079950282e-02f, +1.559401954e-02f, +5.232680174e-02f, -1.780024775e-02f, -9.893335750e-02f, +1.924749700e-02f, +3.158555538e-01f, +4.802482832e-01f, +3.158555538e-01f, +1.924749700e-02f, -9.893335750e-02f, -1.780024775e-02f, +5.232680174e-02f, +1.559401954e-02f, -3.079950282e-02f, -1.289773969e-02f, +1.834373570e-02f, +1.001747038e-02f, -1.058087851e-02f, -7.245170423e-03f, +5.726744505e-03f, +4.814679451e-03f, -2.812546922e-03f, -2.873286720e-03f, +1.194314507e-03f, +1.473036739e-03f, -4.000691189e-04f, -5.810608668e-04f, +8.174592653e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.055780628e-05f, -3.848735070e-05f, -5.408411680e-05f, +8.314785430e-05f, +1.202249485e-04f, -1.466740772e-04f, -2.377308607e-04f, +2.260407756e-04f, +4.318552366e-04f, -3.122425653e-04f, -7.387415145e-04f, +3.873126573e-04f, +1.218865262e-03f, -4.155373014e-04f, -2.001146980e-03f, +3.044894664e-04f, +3.463524932e-03f, +3.686348989e-04f, -7.485993408e-03f, -9.128129279e-03f, -1.806332249e-04f, +8.988032967e-03f, +7.690748195e-03f, -1.512011525e-04f, -3.487874864e-03f, -4.287778866e-04f, +1.995704894e-03f, +4.918364215e-04f, -1.206608172e-03f, -4.348372014e-04f, +7.264350323e-04f, +3.413037314e-04f, -4.218703204e-04f, -2.431061282e-04f, +2.306814620e-04f, +1.561170982e-04f, -1.158881642e-04f, -8.797140009e-05f, +5.185638397e-05f, +4.069879002e-05f, -1.973251484e-05f, -1.241779730e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +5.810608668e-04f, +4.000691189e-04f, -2.174762082e-03f, -1.369356920e-03f, +4.931706478e-03f, +2.614276448e-03f, -9.249493921e-03f, -4.085126069e-03f, +1.521344320e-02f, +5.480993556e-03f, -2.257913432e-02f, -6.427039238e-03f, +3.073327098e-02f, +6.578871207e-03f, -3.875145264e-02f, -5.735049828e-03f, +4.555317997e-02f, +3.918145659e-03f, -5.012182275e-02f, -1.392488435e-03f, +5.173229864e-02f, -1.392488435e-03f, -5.012182275e-02f, +3.918145659e-03f, +4.555317997e-02f, -5.735049828e-03f, -3.875145264e-02f, +6.578871207e-03f, +3.073327098e-02f, -6.427039238e-03f, -2.257913432e-02f, +5.480993556e-03f, +1.521344320e-02f, -4.085126069e-03f, -9.249493921e-03f, +2.614276448e-03f, +4.931706478e-03f, -1.369356920e-03f, -2.174762082e-03f, +5.133746463e-04f, +5.810608668e-04f, -8.174592653e-05f, +0.000000000e+00f,
    +0.000000000e+00f, -2.055780628e-05f, +3.848735070e-05f, +7.767317955e-05f, -1.452272650e-04f, -1.550874398e-04f, +3.095240124e-04f, +2.539588194e-04f, -5.576059524e-04f, -3.584684405e-04f, +8.884770433e-04f, +4.455839699e-04f, -1.282216489e-03f, -4.906064529e-04f, +1.699715456e-03f, +4.743906180e-04f, -2.087962664e-03f, -3.898920508e-04f, +2.390160510e-03f, +2.456691656e-04f, -2.558217123e-03f, -6.486431433e-05f, +2.564123150e-03f, -1.202879539e-04f, -2.406829384e-03f, +2.767965642e-04f, +2.112517436e-03f, -3.794418868e-04f, -1.728177459e-03f, +4.167838078e-04f, +1.310459866e-03f, -3.928611841e-04f, -9.131253679e-04f, +3.243325880e-04f, +5.766242397e-04f, -2.343593103e-04f, -3.223784588e-04f, +1.455110959e-04f, +1.526349625e-04f, -7.405458027e-05f, -5.496512532e-05f, +1.973251484e-05f, +1.241779730e-05f, +0.000000000e+00f,
    /*  8, 1 (44) */
    +0.000000000e+00f, -5.605030605e-04f, -4.385564696e-04f, +1.418952622e-03f, +1.277462361e-03f, -2.753061772e-03f, -2.959221000e-03f, +4.576948590e-03f, +5.952785281e-03f, -6.813315187e-03f, -1.089312107e-02f, +9.278728870e-03f, +1.873104835e-02f, -1.167887442e-02f, -3.121504012e-02f, +1.359287256e-02f, +5.263129120e-02f, -1.433672282e-02f, -9.856472261e-02f, +1.176150359e-02f, +3.067274245e-01f, +4.800676500e-01f, +3.248435867e-01f, +2.693824519e-02f, -9.908455866e-02f, -2.128812261e-02f, +5.189802385e-02f, +1.758972443e-02f, -3.030766640e-02f, -1.410434786e-02f, +1.790889849e-02f, +1.074390542e-02f, -1.023957477e-02f, -7.667040744e-03f, +5.483638377e-03f, +5.045360913e-03f, -2.656429824e-03f, -2.989174884e-03f, +1.106343107e-03f, +1.524893123e-03f, -3.593703289e-04f, -6.007933817e-04f, +6.932812923e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.129703629e-05f, -3.623810225e-05f, -5.612101223e-05f, +7.822891266e-05f, +1.241869104e-04f, -1.370602814e-04f, -2.441037719e-04f, +2.087281453e-04f, +4.406935626e-04f, -2.828937322e-04f, -7.491921922e-04f, +3.395733510e-04f, +1.228207727e-03f, -3.393868463e-04f, -2.002069348e-03f, +1.815279258e-04f, +3.432201781e-03f, +5.803880719e-04f, -7.274526133e-03f, -9.256347174e-03f, -5.416502342e-04f, +8.836192550e-03f, +7.888409201e-03f, +7.163281020e-05f, -3.505077189e-03f, -5.541453813e-04f, +1.985688665e-03f, +5.681144816e-04f, -1.191423856e-03f, -4.820347566e-04f, +7.122748442e-04f, +3.700051028e-04f, -4.107447354e-04f, -2.598795924e-04f, +2.229608930e-04f, +1.653631379e-04f, -1.111798319e-04f, -9.268517436e-05f, +4.943904653e-05f, +4.286525175e-05f, -1.882096265e-05f, -1.327735794e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +5.605030605e-04f, +4.385564696e-04f, -2.097088902e-03f, -1.514584185e-03f, +4.776619039e-03f, +2.923800461e-03f, -8.995535102e-03f, -4.642732022e-03f, +1.485497475e-02f, +6.369470600e-03f, -2.213355035e-02f, -7.709255728e-03f, +3.024266452e-02f, +8.278586662e-03f, -3.827706203e-02f, -7.823012491e-03f, +4.516328792e-02f, +6.308306169e-03f, -4.987615359e-02f, -3.950705558e-03f, +5.166743433e-02f, +1.171634715e-03f, -5.024211071e-02f, +1.511316275e-03f, +4.582997653e-02f, -3.622532391e-03f, -3.913089453e-02f, +4.850693747e-03f, +3.115005478e-02f, -5.116579372e-03f, -2.297199551e-02f, +4.567868188e-03f, +1.553777578e-02f, -3.508501830e-03f, -9.483853231e-03f, +2.291897989e-03f, +5.077217574e-03f, -1.216721958e-03f, -2.248816662e-03f, +4.584095210e-04f, +6.007933817e-04f, -6.932812923e-05f, +0.000000000e+00f,
    +0.000000000e+00f, -2.129703629e-05f, +3.623810225e-05f, +8.096929242e-05f, -1.376061596e-04f, -1.640445681e-04f, +2.960972531e-04f, +2.725676232e-04f, -5.374266916e-04f, -3.912278939e-04f, +8.618392464e-04f, +4.966166449e-04f, -1.250960538e-03f, -5.625883596e-04f, +1.667127252e-03f, +5.675804767e-04f, -2.058226523e-03f, -5.015668458e-04f, +2.367477734e-03f, +3.701898939e-04f, -2.545828660e-03f, -1.944264780e-04f, +2.563525537e-03f, +5.633100092e-06f, -2.417424508e-03f, +1.625664531e-04f, +2.131802680e-03f, -2.829697519e-04f, -1.752411078e-03f, +3.412978666e-04f, +1.335589277e-03f, -3.385690670e-04f, -9.356957414e-04f, +2.888928305e-04f, +5.944132943e-04f, -2.138056599e-04f, -3.346144730e-04f, +1.353292048e-04f, +1.598027048e-04f, -7.011533139e-05f, -5.833250182e-05f, +1.882096265e-05f, +1.327735794e-05f, +0.000000000e+00f,
    /*  8, 2 (44) */
    +0.000000000e+00f, -5.392060243e-04f, -4.747945719e-04f, +1.362831610e-03f, +1.355691274e-03f, -2.628874861e-03f, -3.096281281e-03f, +4.332844818e-03f, +6.161513426e-03f, -6.372621624e-03f, -1.117601480e-02f, +8.529536678e-03f, +1.907062170e-02f, -1.045066670e-02f, -3.155442696e-02f, +1.159080321e-02f, +5.281281913e-02f, -1.090452104e-02f, -9.798433453e-02f, +4.486977456e-03f, +2.974710773e-01f, +4.795259998e-01f, +3.336797793e-01f, +3.482665439e-02f, -9.901292585e-02f, -2.479319980e-02f, +5.134387847e-02f, +1.957541309e-02f, -2.973955191e-02f, -1.529577171e-02f, +1.742686374e-02f, +1.145618026e-02f, -9.869569671e-03f, -8.077785479e-03f, +5.223758785e-03f, +5.268321806e-03f, -2.491066686e-03f, -3.100354716e-03f, +1.013657932e-03f, +1.574332169e-03f, -3.165050772e-04f, -6.196143443e-04f, +5.605077129e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.195065330e-05f, -3.395813985e-05f, -5.796636668e-05f, +7.322889637e-05f, +1.277717665e-04f, -1.273018687e-04f, -2.497965870e-04f, +1.912127353e-04f, +4.483821483e-04f, -2.533289979e-04f, -7.577892523e-04f, +2.917304806e-04f, +1.234654531e-03f, -2.635521593e-04f, -1.998535394e-03f, +6.013471407e-05f, +3.394090501e-03f, +7.861933153e-04f, -7.056735594e-03f, -9.372571504e-03f, -9.019193399e-04f, +8.672761342e-03f, +8.078603771e-03f, +2.995740239e-04f, -3.514968676e-03f, -6.803382136e-04f, +1.971053077e-03f, +6.441994771e-04f, -1.173306186e-03f, -5.287923119e-04f, +6.962673879e-04f, +3.982743552e-04f, -3.984872011e-04f, -2.763165514e-04f, +2.145761941e-04f, +1.743860058e-04f, -1.061042274e-04f, -9.727478371e-05f, +4.683387456e-05f, +4.497951281e-05f, -1.782320644e-05f, -1.412815468e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +5.392060243e-04f, +4.747945719e-04f, -2.016119610e-03f, -1.652190345e-03f, +4.612574470e-03f, +3.219897714e-03f, -8.722967479e-03f, -5.180158713e-03f, +1.446374686e-02f, +7.231309846e-03f, -2.163693371e-02f, -8.960216265e-03f, +2.968007616e-02f, +9.945713914e-03f, -3.770948155e-02f, -9.881239015e-03f, +4.466172107e-02f, +8.675783903e-03f, -4.950596369e-02f, -6.496534218e-03f, +5.147300785e-02f, +3.735160252e-03f, -5.023647761e-02f, -9.061082325e-04f, +4.599254299e-02f, -1.490729711e-03f, -3.941386428e-02f, +3.098282669e-03f, +3.149135265e-02f, -3.780990095e-03f, -2.331056457e-02f, +3.632172447e-03f, +1.582666861e-02f, -2.914088535e-03f, -9.697658891e-03f, +1.957283516e-03f, +5.212546779e-03f, -1.056919253e-03f, -2.318931993e-03f, +4.000770192e-04f, +6.196143443e-04f, -5.605077129e-05f, +0.000000000e+00f,
    +0.000000000e+00f, -2.195065330e-05f, +3.395813985e-05f, +8.394210187e-05f, -1.297982064e-04f, -1.723708327e-04f, +2.821450487e-04f, +2.901524419e-04f, -5.161568565e-04f, -4.225430608e-04f, +8.333047132e-04f, +5.458441169e-04f, -1.216800403e-03f, -6.325582952e-04f, +1.630525108e-03f, +6.587819237e-04f, -2.023410232e-03f, -6.115396462e-04f, +2.338856349e-03f, +4.935323277e-04f, -2.526995766e-03f, -3.234896838e-04f, +2.556419947e-03f, +1.317713624e-04f, -2.421901676e-03f, +4.749181134e-05f, +2.145743589e-03f, -1.852150214e-04f, -1.772324548e-03f, +2.643318554e-04f, +1.357510663e-03f, -2.828338165e-04f, -9.561042310e-04f, +2.522261286e-04f, +6.109072174e-04f, -1.923376664e-04f, -3.461868290e-04f, +1.245574544e-04f, +1.667040381e-04f, -6.585830902e-05f, -6.163946680e-05f, +1.782320644e-05f, +1.412815468e-05f, +0.000000000e+00f,
    /*  8, 3 (44) */
    +0.000000000e+00f, -5.172553710e-04f, -5.087527117e-04f, +1.304865243e-03f, +1.428920170e-03f, -2.501103095e-03f, -3.223583150e-03f, +4.083048231e-03f, +6.352726162e-03f, -5.924239476e-03f, -1.142934380e-02f, +7.771747426e-03f, +1.936235218e-02f, -9.216012166e-03f, -3.181797912e-02f, +9.592267814e-03f, +5.287295384e-02f, -7.510430536e-03f, -9.719814122e-02f, -2.569758138e-03f, +2.880985058e-01f, +4.786240804e-01f, +3.423525406e-01f, +4.290525816e-02f, -9.871335182e-02f, -2.830816848e-02f, +5.066354025e-02f, +2.154646617e-02f, -2.909535244e-02f, -1.646907790e-02f, +1.689807143e-02f, +1.215244765e-02f, -9.471295316e-03f, -8.476272680e-03f, +4.947442234e-03f, +5.482898000e-03f, -2.316680681e-03f, -3.206458944e-03f, +9.163831487e-04f, +1.621166044e-03f, -2.715255644e-04f, -6.374375508e-04f, +4.192261661e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.251934746e-05f, -3.165446722e-05f, -5.961999631e-05f, +6.816203638e-05f, +1.309782120e-04f, -1.174248849e-04f, -2.548073873e-04f, +1.735388265e-04f, +4.549205816e-04f, -2.236196045e-04f, -7.645391042e-04f, +2.438939764e-04f, +1.238230873e-03f, -1.881973897e-04f, -1.990617239e-03f, -5.945548166e-05f, +3.349386414e-03f, +9.857966404e-04f, -6.833018219e-03f, -9.476706422e-03f, -1.260943332e-03f, +8.497911455e-03f, +8.260968595e-03f, +5.323173350e-04f, -3.517397689e-03f, -8.070971557e-04f, +1.951762343e-03f, +7.199174749e-04f, -1.152255607e-03f, -5.749963216e-04f, +6.784234845e-04f, +4.260391358e-04f, -3.851092549e-04f, -2.923724898e-04f, +2.055361406e-04f, +1.831595935e-04f, -1.006666355e-04f, -1.017258544e-04f, +4.404318231e-05f, +4.703431483e-05f, -1.673956517e-05f, -1.496697687e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +5.172553710e-04f, +5.087527117e-04f, -1.932177508e-03f, -1.781988551e-03f, +4.440203638e-03f, +3.502042762e-03f, -8.432815037e-03f, -5.696315570e-03f, +1.404120380e-02f, +8.064614559e-03f, -2.109108959e-02f, -1.017701667e-02f, +2.904751787e-02f, +1.157623902e-02f, -3.705069963e-02f, -1.190464925e-02f, +4.405018143e-02f, +1.101464025e-02f, -4.901243137e-02f, -9.023529984e-03f, +5.114951817e-02f, +6.291580199e-03f, -5.010470624e-02f, -3.328009908e-03f, +4.604003480e-02f, +6.550138773e-04f, -3.959907930e-02f, +1.325958121e-03f, +3.175568451e-02f, -2.423479432e-03f, -2.359339839e-02f, +2.676068216e-03f, +1.607889474e-02f, -2.303181318e-03f, -9.889996558e-03f, +1.611096687e-03f, +5.337104233e-03f, -8.902152149e-04f, -2.384790302e-03f, +3.384375524e-04f, +6.374375508e-04f, -4.192261661e-05f, +0.000000000e+00f,
    +0.000000000e+00f, -2.251934746e-05f, +3.165446722e-05f, +8.659178844e-05f, -1.218299000e-04f, -1.800565991e-04f, +2.677148706e-04f, +3.066833210e-04f, -4.938687636e-04f, -4.523507860e-04f, +8.029701393e-04f, +5.931572319e-04f, -1.179851125e-03f, -7.003516420e-04f, +1.590031001e-03f, +7.477719213e-04f, -1.983627737e-03f, -7.195346339e-04f, +2.304386847e-03f, +6.153823148e-04f, -2.501773131e-03f, -4.517227478e-04f, +2.542818943e-03f, +2.578030512e-04f, -2.420232485e-03f, -6.813399060e-05f, +2.154278965e-03f, -8.642323395e-05f, -1.787836834e-03f, +1.860743392e-04f, +1.376137616e-03f, -2.257867632e-04f, -9.742717304e-04f, +2.144137544e-04f, +6.260426865e-04f, -1.699983012e-04f, -3.570513405e-04f, +1.132135465e-04f, +1.733126841e-04f, -6.128744519e-05f, -6.487345079e-05f, +1.673956517e-05f, +1.496697687e-05f, +0.000000000e+00f,
    /*  8, 4 (44) */
    +0.000000000e+00f, -4.947360235e-04f, -5.404071790e-04f, +1.245245247e-03f, +1.497082207e-03f, -2.370124883e-03f, -3.341008035e-03f, +3.828240844e-03f, +6.526264988e-03f, -5.469318894e-03f, -1.165296341e-02f, +7.007208321e-03f, +1.960624616e-02f, -7.977781293e-03f, -3.200617651e-02f, +7.601650574e-03f, +5.281349836e-02f, -4.161044122e-03f, -9.621234458e-02f, -9.402776357e-03f, +2.786217994e-01f, +4.773631371e-01f, +3.508504521e-01f, +5.116622676e-02f, -9.818103449e-02f, -3.182556617e-02f, +4.985644310e-02f, +2.349822851e-02f, -2.837543496e-02f, -1.762133351e-02f, +1.632307510e-02f, +1.283087113e-02f, -9.045256180e-03f, -8.861381935e-03f, +4.655069744e-03f, +5.688434141e-03f, -2.133521087e-03f, -3.307125579e-03f, +8.146572943e-04f, +1.665209226e-03f, -2.244912495e-04f, -6.541771159e-04f, +2.695563973e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.300404255e-05f, -2.933397920e-05f, -6.108222644e-05f, +6.304243838e-05f, +1.338059061e-04f, -1.074552011e-04f, -2.591359210e-04f, +1.557503799e-04f, +4.603111501e-04f, -1.938361112e-04f, -7.694523085e-04f, +1.961722680e-04f, +1.238968054e-03f, -1.134834115e-04f, -1.978395458e-03f, -1.770151251e-04f, +3.298294587e-03f, +1.178957764e-03f, -6.603776907e-03f, -9.568675473e-03f, -1.618227086e-03f, +8.311833564e-03f, +8.435150394e-03f, +7.695458477e-04f, -3.512224607e-03f, -9.341579451e-04f, +1.927790301e-03f, +7.950929731e-04f, -1.128279224e-03f, -6.205329591e-04f, +6.587583729e-04f, +4.532272335e-04f, -3.706252664e-04f, -3.080031036e-04f, +1.958512485e-04f, +1.916579412e-04f, -9.487335522e-05f, -1.060240704e-04f, +4.106983364e-05f, +4.902238392e-05f, -1.557062569e-05f, -1.579055794e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.947360235e-04f, +5.404071790e-04f, -1.845585719e-03f, -1.903818451e-03f, +4.260147039e-03f, +3.769757633e-03f, -8.126131716e-03f, -6.190184334e-03f, +1.358885301e-02f, +8.867584699e-03f, -2.049793236e-02f, -1.135686779e-02f, +2.834716623e-02f, +1.316627002e-02f, -3.630292770e-02f, -1.388827698e-02f, +4.333064679e-02f, +1.331902710e-02f, -4.839704905e-02f, -1.152530311e-02f, +5.069779542e-02f, +8.834399142e-03f, -4.984690319e-02f, -5.748242393e-03f, +4.597190081e-02f, +2.809292843e-03f, -3.968550254e-02f, -4.618787135e-04f, +3.194175885e-02f, -1.047341816e-03f, -2.381918515e-02f, +1.701796486e-03f, +1.629330850e-02f, -1.677138632e-03f, -1.005999486e-02f, +1.254045347e-03f, +5.450317780e-03f, -7.169025308e-04f, -2.446077748e-03f, +2.735641016e-04f, +6.541771159e-04f, -2.695563973e-05f, +0.000000000e+00f,
    +0.000000000e+00f, -2.300404255e-05f, +2.933397920e-05f, +8.891950538e-05f, -1.137275915e-04f, -1.870942350e-04f, +2.528546485e-04f, +3.221336618e-04f, -4.706364215e-04f, -4.805927579e-04f, +7.709358742e-04f, +6.384530061e-04f, -1.140234026e-03f, -7.658107828e-04f, +1.545776231e-03f, +8.343344836e-04f, -1.939005358e-03f, -8.252821801e-04f, +2.264174645e-03f, +7.354301793e-04f, -2.470231970e-03f, -5.787966648e-04f, +2.522751965e-03f, +3.834040852e-04f, -2.412404450e-03f, -1.840150670e-04f, +2.157361451e-03f, +1.315596484e-05f, -1.798877921e-03f, +1.067187602e-04f, +1.391391680e-03f, -1.675640669e-04f, -9.901242290e-04f, +1.755411240e-04f, +6.397591682e-04f, -1.468336382e-04f, -3.671650045e-04f, +1.013171845e-04f, +1.796026234e-04f, -5.640774150e-05f, -6.802174843e-05f, +1.557062569e-05f, +1.579055794e-05f, +0.000000000e+00f,
    /*  8, 5 (44) */
    +0.000000000e+00f, -4.717319809e-04f, -5.697411582e-04f, +1.184163020e-03f, +1.560124645e-03f, -2.236318977e-03f, -3.448463236e-03f, +3.569104923e-03f, +6.682015368e-03f, -5.009007744e-03f, -1.184679952e-02f, +6.237756013e-03f, +1.980241843e-02f, -6.738813239e-03f, -3.211965993e-02f, +5.623255116e-03f, +5.263648323e-02f, -8.627495342e-04f, -9.503338681e-02f, -1.600655326e-02f, +2.690531239e-01f, +4.757449100e-01f, +3.591622856e-01f, +5.960137715e-02f, -9.741148864e-02f, -3.533779078e-02f, +4.892228515e-02f, +2.542601882e-02f, -2.758034199e-02f, -1.874961273e-02f, +1.570254214e-02f, +1.348962951e-02f, -8.592028947e-03f, -9.232007201e-03f, +4.347066640e-03f, +5.884285389e-03f, -1.941863146e-03f, -3.401998934e-03f, +7.086332239e-04f, +1.706279060e-03f, -1.754688656e-04f, -6.697477416e-04f, +1.116508179e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.340588755e-05f, -2.700344492e-05f, -6.235387979e-05f, +5.788404891e-05f, +1.362554549e-04f, -9.741845355e-05f, -2.627835768e-04f, +1.378909369e-04f, +4.645587956e-04f, -1.640482395e-04f, -7.725434958e-04f, +1.486720570e-04f, +1.236903324e-03f, -3.956751245e-05f, -1.961958798e-03f, -2.923242001e-04f, +3.241029330e-03f, +1.365450418e-03f, -6.369420286e-03f, -9.648421663e-03f, -1.973278391e-03f, +8.114736642e-03f, +8.600806591e-03f, +1.010931395e-03f, -3.499322218e-03f, -1.061251757e-03f, +1.899120603e-03f, +8.695492688e-04f, -1.101390868e-03f, -6.652883750e-04f, +6.372917343e-04f, +4.797667512e-04f, -3.550524448e-04f, -3.231644100e-04f, +1.855337779e-04f, +1.998553052e-04f, -8.873170256e-05f, -1.101552123e-04f, +3.791724618e-05f, +5.093645098e-05f, -1.431724768e-05f, -1.659558457e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.717319809e-04f, +5.697411582e-04f, -1.756666214e-03f, -2.017546043e-03f, +4.073052804e-03f, +4.022612281e-03f, -7.803998054e-03f, -6.660820755e-03f, +1.310826026e-02f, +9.638520573e-03f, -1.985947935e-02f, -1.249710182e-02f, +2.758135544e-02f, +1.471204625e-02f, -3.546859322e-02f, -1.582728234e-02f, +4.250536461e-02f, +1.558320174e-02f, -4.766161887e-02f, -1.399553509e-02f, +5.011899875e-02f, +1.135715111e-02f, -4.946349911e-02f, -8.160646843e-03f, +4.578788574e-02f, +4.966654293e-03f, -3.967234657e-02f, -2.260756634e-03f, +3.204847761e-02f, +3.440498641e-04f, -2.398674922e-02f, +7.116722567e-04f, +1.646884962e-02f, -1.037379463e-03f, -1.020682850e-02f, +8.868803424e-04f, +5.551634964e-03f, -5.372999074e-04f, -2.502485489e-03f, +2.055423531e-04f, +6.697477416e-04f, -1.116508179e-05f, +0.000000000e+00f,
    +0.000000000e+00f, -2.340588755e-05f, +2.700344492e-05f, +9.092735126e-05f, -1.055174142e-04f, -1.934780934e-04f, +2.376126283e-04f, +3.364802418e-04f, -4.465353040e-04f, -5.072156049e-04f, +7.373056101e-04f, +6.816348387e-04f, -1.098076332e-03f, -8.287854638e-04f, +1.497901017e-03f, +9.182612062e-04f, -1.889681393e-03f, -9.285195307e-04f, +2.218339760e-03f, +8.533715254e-04f, -2.432459817e-03f, -7.043854709e-04f, +2.496265270e-03f, +5.082509356e-04f, -2.398421082e-03f, -2.998537883e-04f, +2.154957710e-03f, +1.132694617e-04f, -1.805389067e-03f, +2.646295790e-05f, +1.403202629e-03f, -1.083063974e-04f, -1.003593071e-03f, +1.356976152e-04f, +6.519991251e-04f, -1.228927735e-04f, -3.764861458e-04f, +8.889005515e-05f, +1.855481789e-04f, -5.122527963e-05f, -7.107155702e-05f, +1.431724768e-05f, +1.659558457e-05f, +0.000000000e+00f,
    /*  8, 6 (44) */
    +0.000000000e+00f, -4.483260934e-04f, -5.967446031e-04f, +1.121809141e-03f, +1.618008694e-03f, -2.100063522e-03f, -3.545881689e-03f, +3.306321346e-03f, +6.819906305e-03f, -4.544448948e-03f, -1.201084776e-02f, +5.465212517e-03f, +1.995109049e-02f, -5.501909915e-03f, -3.215922744e-02f, +3.661296318e-03f, +5.234415903e-02f, +2.378279796e-03f, -9.366793640e-02f, -2.237597355e-02f, +2.594047022e-01f, +4.737716316e-01f, +3.672770223e-01f, +6.820218374e-02f, -9.640055725e-02f, -3.883711299e-02f, +4.786103340e-02f, +2.732513942e-02f, -2.671079272e-02f, -1.985100360e-02f, +1.503725377e-02f, +1.412692124e-02f, -8.112262196e-03f, -9.587059646e-03f, +4.023902230e-03f, +6.069819167e-03f, -1.742007841e-03f, -3.490730637e-03f, +5.984780117e-04f, +1.744196306e-03f, -1.245324146e-04f, -6.840649893e-04f, -5.430502781e-06f, +0.000000000e+00f,
    +0.000000000e+00f, +2.372624758e-05f, -2.466949175e-05f, -6.343626354e-05f, +5.270062244e-05f, +1.383283922e-04f, -8.733998399e-05f, -2.657533541e-04f, +1.200035216e-04f, +4.676710644e-04f, -1.343247226e-04f, -7.738312790e-04f, +1.014980978e-04f, +1.232079723e-03f, +3.339690446e-05f, -1.941403888e-03f, -4.051705618e-04f, +3.177813682e-03f, +1.545062632e-03f, -6.130361963e-03f, -9.715907479e-03f, -2.325608775e-03f, +7.906847652e-03f, +8.757605971e-03f, +1.256135034e-03f, -3.478576103e-03f, -1.188105689e-03f, +1.865746873e-03f, +9.431088328e-04f, -1.071611160e-03f, -7.091489576e-04f, +6.140477072e-04f, +5.055862801e-04f, -3.384108386e-04f, -3.378128593e-04f, +1.745977306e-04f, +2.077262260e-04f, -8.225001081e-05f, -1.141051959e-04f, +3.458939389e-05f, +5.276927238e-05f, -1.298056784e-05f, -1.737870626e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.483260934e-04f, +5.967446031e-04f, -1.665738863e-03f, -2.123063457e-03f, +3.879574710e-03f, +4.260224910e-03f, -7.467517812e-03f, -7.107356059e-03f, +1.260104465e-02f, +1.037582618e-02f, -1.917784451e-02f, -1.359517815e-02f, +2.675256998e-02f, +1.620994727e-02f, -3.455033201e-02f, -1.771696373e-02f, +4.157684508e-02f, +1.780154150e-02f, -4.680824735e-02f, -1.642799490e-02f, +4.941461328e-02f, +1.385341638e-02f, -4.895524817e-02f, -1.055906793e-02f, +4.548803195e-02f, +7.121612003e-03f, -3.955907711e-02f, -4.066145701e-03f, +3.207494056e-02f, +1.747252493e-03f, -2.409505562e-02f, -2.919208143e-04f, +1.660454724e-02f, -3.853803383e-04f, -1.032972127e-02f, +5.103941965e-04f, +5.640525020e-03f, -3.517517285e-04f, -2.553710769e-03f, +1.344707961e-04f, +6.840649893e-04f, +5.430502781e-06f, +0.000000000e+00f,
    +0.000000000e+00f, -2.372624758e-05f, +2.466949175e-05f, +9.261834034e-05f, -9.722521034e-05f, -1.992044890e-04f, +2.220372295e-04f, +3.497032258e-04f, -4.216421221e-04f, -5.321709771e-04f, +7.021860642e-04f, +7.226127060e-04f, -1.053510781e-03f, -8.891331350e-04f, +1.446554062e-03f, +9.993517718e-04f, -1.835805697e-03f, -1.028991470e-03f, +2.167016456e-03f, +9.689080262e-04f, -2.388560283e-03f, -8.281670986e-04f, +2.463421819e-03f, +6.320214768e-04f, -2.378301921e-03f, -4.153515593e-04f, +2.147048585e-03f, +2.136613268e-04f, -1.807323043e-03f, -5.449132512e-05f, +1.411508730e-03f, -4.815859980e-05f, -1.014615202e-03f, +9.497637221e-05f, +6.627082172e-04f, -9.822773494e-05f, -3.849745594e-04f, +7.595580378e-05f, +1.911241015e-04f, -4.574722876e-05f, -7.401001638e-05f, +1.298056784e-05f, +1.737870626e-05f, +0.000000000e+00f,
    /*  8, 7 (44) */
    +0.000000000e+00f, -4.245998458e-04f, -6.214140948e-04f, +1.058372877e-03f, +1.670709316e-03f, -1.961735130e-03f, -3.633221673e-03f, +3.040567992e-03f, +6.939909826e-03f, -4.076777884e-03f, -1.214517248e-02f, +4.691381238e-03f, +2.005258858e-02f, -4.269830192e-03f, -3.212583053e-02f, +1.719892430e-03f, +5.193898847e-02f, +5.556093478e-03f, -9.212287376e-02f, -2.850633551e-02f, +2.496887948e-01f, +4.714460229e-01f, +3.751838699e-01f, +7.695978971e-02f, -9.514442221e-02f, -4.231568910e-02f, +4.667292771e-02f, +2.919088629e-02f, -2.576768389e-02f, -2.092261476e-02f, +1.432810481e-02f, +1.474096895e-02f, -7.606675916e-03f, -9.925470485e-03f, +3.686089371e-03f, +6.244416898e-03f, -1.534281615e-03f, -3.572980648e-03f, +4.843728157e-04f, +1.778785700e-03f, -7.176314224e-05f, -6.970455571e-04f, -2.280920904e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.396669449e-05f, -2.233858996e-05f, -6.433115545e-05f, +4.750568960e-05f, +1.400271590e-04f, -7.724478239e-05f, -2.680498294e-04f, +1.021305455e-04f, +4.696580509e-04f, -1.047331584e-04f, -7.733381554e-04f, +5.475298431e-05f, +1.224545909e-03f, +1.052606080e-04f, -1.916834922e-03f, -5.153502663e-04f, +3.108878884e-03f, +1.717596983e-03f, -5.887019779e-03f, -9.771114886e-03f, -2.674734318e-03f, +7.688411219e-03f, +8.905229318e-03f, +1.504807565e-03f, -3.449884991e-03f, -1.314443263e-03f, +1.827672860e-03f, +1.015593691e-03f, -1.038967548e-03f, -7.520015975e-04f, +5.890548917e-04f, +5.306150743e-04f, -3.207233305e-04f, -3.519054467e-04f, +1.630588444e-04f, +2.152455967e-04f, -7.543762803e-05f, -1.178601126e-04f, +3.109080837e-05f, +5.451365104e-05f, -1.156200341e-05f, -1.813654524e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.245998458e-04f, +6.214140948e-04f, -1.573120522e-03f, -2.220288667e-03f, +3.680370221e-03f, +4.482262139e-03f, -7.117814586e-03f, -7.528998181e-03f, +1.206887367e-02f, +1.107801225e-02f, -1.845523181e-02f, -1.464868893e-02f, +2.586343685e-02f, +1.765650133e-02f, -3.355098024e-02f, -1.955276943e-02f, +4.054785361e-02f, +1.996855796e-02f, -4.583933932e-02f, -1.881655519e-02f, +4.858644618e-02f, +1.631683820e-02f, -4.832322670e-02f, -1.293736985e-02f, +4.507268039e-02f, +9.268660589e-03f, -3.934541578e-02f, -5.873468744e-03f, +3.202044924e-02f, +3.158761223e-03f, -2.414321422e-02f, -1.306536016e-03f, +1.669952361e-02f, +2.773278789e-04f, -1.042794901e-02f, +1.254196371e-04f, +5.716480823e-03f, -1.606276271e-04f, -2.599457997e-03f, +6.046077973e-05f, +6.970455571e-04f, +2.280920904e-05f, +0.000000000e+00f,
    +0.000000000e+00f, -2.396669449e-05f, +2.233858996e-05f, +9.399637063e-05f, -8.887646084e-05f, -2.042716706e-04f, +2.061769061e-04f, +3.617861668e-04f, -3.960345967e-04f, -5.554156132e-04f, +6.656866567e-04f, +7.613033350e-04f, -1.006675221e-03f, -9.467192680e-04f, +1.391892103e-03f, +1.077414432e-03f, -1.777539236e-03f, -1.126450964e-03f, +2.110352850e-03f, +1.081748194e-03f, -2.338652763e-03f, -9.498242216e-04f, +2.424301130e-03f, +7.543958355e-04f, -2.352082522e-03f, -5.302096033e-04f, +2.133629210e-03f, +3.140734770e-04f, -1.804644322e-03f, -1.359389520e-04f, +1.416256979e-03f, +1.273065514e-05f, -1.023133402e-03f, +5.347409763e-05f, +6.718354979e-04f, -7.289338143e-05f, -3.925916505e-04f, +6.254000361e-05f, +1.963056544e-04f, -3.998184953e-05f, -7.682424980e-05f, +1.156200341e-05f, +1.813654524e-05f, +0.000000000e+00f,
    /*  8, 8 (44) */
    +0.000000000e+00f, -4.006331513e-04f, -6.437526848e-04f, +9.940417215e-04f, +1.718215006e-03f, -1.821707971e-03f, -3.710466456e-03f, +2.772518163e-03f, +7.042040372e-03f, -3.607119833e-03f, -1.224990564e-02f, +3.918043083e-03f, +2.010734157e-02f, -3.045284283e-03f, -3.202056993e-02f, -1.969424922e-04f, +5.142363821e-02f, +8.664972362e-03f, -9.040527678e-02f, -3.439335529e-02f, +2.399176799e-01f, +4.687712885e-01f, +3.828722811e-01f, +8.586501903e-02f, -9.363961465e-02f, -4.576557409e-02f, +4.535848444e-02f, +3.101855915e-02f, -2.475209020e-02f, -2.196158231e-02f, +1.357610321e-02f, +1.533002384e-02f, -7.076060841e-03f, -1.024619382e-02f, +3.334183924e-03f, +6.407475742e-03f, -1.319036018e-03f, -3.648418276e-03f, +3.665127031e-04f, +1.809876508e-03f, -1.724949120e-05f, -7.086075605e-04f, -4.094575428e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.412899703e-05f, -2.001703818e-05f, -6.504078892e-05f, +4.231252662e-05f, +1.413550798e-04f, -6.715743137e-05f, -2.696791191e-04f, +8.431371580e-05f, +4.705323363e-04f, -7.533986833e-05f, -7.710904031e-04f, +8.536945332e-06f, +1.214355977e-03f, +1.758788128e-04f, -1.888363348e-03f, -6.226678819e-04f, +3.034463845e-03f, +1.882870823e-03f, -5.639815044e-03f, -9.814045284e-03f, -3.020176466e-03f, +7.459689256e-03f, +9.043370036e-03f, +1.756590075e-03f, -3.413161095e-03f, -1.439984936e-03f, +1.784912553e-03f, +1.086825811e-03f, -1.003494338e-03f, -7.937339537e-04f, +5.623463434e-04f, +5.547832275e-04f, -3.020156231e-04f, -3.653998246e-04f, +1.509345828e-04f, +2.223887316e-04f, -6.830491191e-05f, -1.214062683e-04f, +2.742657843e-05f, +5.616245785e-05f, -1.006325487e-05f, -1.886570663e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +4.006331513e-04f, +6.437526848e-04f, -1.479124152e-03f, -2.309165128e-03f, +3.476098551e-03f, +4.688439045e-03f, -6.756028420e-03f, -7.925032778e-03f, +1.151345806e-02f, +1.174369890e-02f, -1.769392847e-02f, -1.565536415e-02f, +2.491671758e-02f, +1.904839344e-02f, -3.247356581e-02f, -2.133030867e-02f, +3.942140265e-02f, +2.207891081e-02f, -4.475759113e-02f, -2.115520795e-02f, +4.763662196e-02f, +1.874113933e-02f, -4.756883086e-02f, -1.528945237e-02f, +4.454247079e-02f, +1.140228980e-02f, -3.903134231e-02f, -7.678113066e-03f, +3.188451029e-02f, +4.575018202e-03f, -2.413048356e-02f, -2.329669418e-03f, +1.675299771e-02f, +9.491633768e-04f, -1.050084239e-02f, -2.671720134e-04f, +5.779020827e-03f, +3.567802731e-05f, -2.639439847e-03f, -1.636347006e-05f, +7.086075605e-04f, +4.094575428e-05f, +0.000000000e+00f,
    +0.000000000e+00f, -2.412899703e-05f, +2.001703818e-05f, +9.506618998e-05f, -8.049621737e-05f, -2.086797875e-04f, +1.900800085e-04f, +3.727159975e-04f, -3.697912301e-04f, -5.769113925e-04f, +6.279191849e-04f, +7.976303570e-04f, -9.577121940e-04f, -1.001417649e-03f, +1.334079442e-03f, +1.152266461e-03f, -1.715053605e-03f, -1.220659775e-03f, +2.048510478e-03f, +1.191608132e-03f, -2.282872110e-03f, -1.069045087e-03f, +2.378999080e-03f, +8.750572352e-04f, -2.319814411e-03f, -6.441297486e-04f, +2.114709087e-03f, +4.142463470e-04f, -1.797329261e-03f, -2.176719137e-04f, +1.417403325e-03f, +7.420923400e-05f, -1.029096508e-03f, +1.129083210e-05f, +6.793336019e-04f, -4.694729371e-05f, -3.993005730e-04f, +4.867011854e-05f, +2.010686993e-04f, -3.393849481e-05f, -7.950140619e-05f, +1.006325487e-05f, +1.886570663e-05f, +0.000000000e+00f,
    /*  8, 9 (44) */
    +0.000000000e+00f, -3.765041543e-04f, -6.637697230e-04f, +9.290009326e-04f, +1.760527533e-03f, -1.680352891e-03f, -3.777623887e-03f, +2.502839044e-03f, +7.126354088e-03f, -3.136587497e-03f, -1.232524551e-02f, +3.146952680e-03f, +2.011587851e-02f, -1.830928306e-03f, -3.184469111e-02f, -2.085305840e-03f, +5.080097032e-02f, +1.169943621e-02f, -8.852240596e-02f, -4.003317034e-02f, +2.301036346e-01f, +4.657511121e-01f, +3.903319704e-01f, +9.490838907e-02f, -9.188302457e-02f, -4.917873518e-02f, +4.391849951e-02f, +3.280347170e-02f, -2.366526438e-02f, -2.296507664e-02f, +1.278236926e-02f, +1.589237018e-02f, -6.521277614e-03f, -1.054820944e-02f, +2.968784100e-03f, +6.558410325e-03f, -1.096647286e-03f, -3.716723188e-03f, +2.451064348e-04f, +1.837303087e-03f, +3.891296665e-05f, -7.186708154e-04f, -5.981146091e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.421511060e-05f, -1.771094961e-05f, -6.556783713e-05f, +3.713412602e-05f, +1.423163382e-04f, -5.710205251e-05f, -2.706488403e-04f, +6.659394642e-05f, +4.703089230e-04f, -4.620975957e-05f, -7.671179684e-04f, -3.705235275e-05f, +1.201569264e-03f, +2.451114403e-04f, -1.856107526e-03f, -7.269367777e-04f, +2.954814590e-03f, +2.040716467e-03f, -5.389171783e-03f, -9.844719429e-03f, -3.361462821e-03f, +7.220960571e-03f, +9.171734749e-03f, +2.011114502e-03f, -3.368330420e-03f, -1.564448624e-03f, +1.737490298e-03f, +1.156627495e-03f, -9.652327035e-04f, -8.342347209e-04f, +5.339595571e-04f, +5.780218488e-04f, -2.823162196e-04f, -3.782544149e-04f, +1.382441196e-04f, +2.291314354e-04f, -6.086322209e-05f, -1.247302240e-04f, +2.360234839e-05f, +5.770865334e-05f, -8.486307925e-06f, -1.956278904e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +3.765041543e-04f, +6.637697230e-04f, -1.384057962e-03f, -2.389661345e-03f, +3.267418763e-03f, +4.878519054e-03f, -6.383312422e-03f, -8.294824008e-03f, +1.093654667e-02f, +1.237161809e-02f, -1.689629811e-02f, -1.661307635e-02f, +2.391529993e-02f, +2.038247288e-02f, -3.132129935e-02f, -2.304536227e-02f, +3.820074287e-02f, +2.412742129e-02f, -4.356598299e-02f, -2.343808006e-02f, +4.656757688e-02f, +2.112013841e-02f, -4.669377363e-02f, -1.760926678e-02f, +4.389834104e-02f, +1.351699889e-02f, -3.861709596e-02f, -9.475442327e-03f, +3.166683837e-02f, +5.992421528e-03f, -2.405627433e-02f, -3.358765927e-03f, +1.676428854e-02f, +1.628496979e-03f, -1.054778968e-02f, -6.664725864e-04f, +5.827690945e-03f, +2.367467266e-04f, -2.673378342e-03f, -9.586487626e-05f, +7.186708154e-04f, +5.981146091e-05f, +0.000000000e+00f,
    +0.000000000e+00f, -2.421511060e-05f, +1.771094961e-05f, +9.583336027e-05f, -7.210903727e-05f, -2.124308514e-04f, +1.737946493e-04f, +3.824830127e-04f, -3.429910801e-04f, -5.966253717e-04f, +5.889974946e-04f, +8.315244415e-04f, -9.067685159e-04f, -1.053110646e-03f, +1.273287459e-03f, +1.223734587e-03f, -1.648530526e-03f, -1.311389056e-03f, +1.981663839e-03f, +1.298212264e-03f, -2.221368260e-03f, -1.185524330e-03f, +2.327627661e-03f, +9.936928337e-04f, -2.281564981e-03f, -7.568152173e-04f, +2.090312125e-03f, +5.139195696e-04f, -1.785366232e-03f, -2.994798621e-04f, +1.414912861e-03f, +1.361219172e-04f, -1.032459620e-03f, -3.147027837e-05f, +6.851589268e-04f, -2.044965488e-05f, -4.050663648e-04f, +3.437545963e-05f, +2.053897813e-04f, -2.762760690e-05f, -8.202870318e-05f, +8.486307925e-06f, +1.956278904e-05f, +0.000000000e+00f,
    /*  8,10 (44) */
    +0.000000000e+00f, -3.522890437e-04f, -6.814806726e-04f, +8.634330955e-04f, +1.797661659e-03f, -1.538036552e-03f, -3.834725940e-03f, +2.232190203e-03f, +7.192948034e-03f, -2.666278574e-03f, -1.237145527e-02f, +2.379834711e-03f, +2.007882616e-02f, -6.293590427e-04f, -3.159957967e-02f, -3.941413366e-03f, +5.007403355e-02f, +1.465425080e-02f, -8.648168949e-02f, -4.542234212e-02f, +2.202589152e-01f, +4.623896493e-01f, +3.975529310e-01f, +1.040801238e-01f, -8.987191007e-02f, -5.254706560e-02f, +4.235405088e-02f, +3.454096200e-02f, -2.250863689e-02f, -2.393030935e-02f, +1.194813454e-02f, +1.642632974e-02f, -5.943255765e-03f, -1.083052566e-02f, +2.590529685e-03f, +6.696654445e-03f, -8.675158509e-04f, -3.777586410e-03f, +1.203762108e-04f, +1.860905435e-03f, +9.662161999e-05f, -7.271571233e-04f, -7.937424996e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.422716675e-05f, -1.542623912e-05f, -6.591539633e-05f, +3.198316856e-05f, +1.429159500e-04f, -4.710225478e-05f, -2.709680669e-04f, +4.901127214e-05f, +4.690051627e-04f, -1.740619401e-05f, -7.614543474e-04f, -8.191999454e-05f, +1.186250152e-03f, +3.128233666e-04f, -1.820192390e-03f, -8.279793927e-04f, +2.870183705e-03f, +2.190981361e-03f, -5.135515976e-03f, -9.863177323e-03f, -3.698127934e-03f, +6.972520433e-03f, +9.290043881e-03f, +2.268004217e-03f, -3.315333055e-03f, -1.687550236e-03f, +1.685440871e-03f, +1.224821774e-03f, -9.242306866e-04f, -8.733938990e-04f, +5.039364399e-04f, +6.002632396e-04f, -2.616563963e-04f, -3.904285214e-04f, +1.250083200e-04f, +2.354500713e-04f, -5.312490959e-05f, -1.278188358e-04f, +1.962431458e-05f, +5.914530952e-05f, -6.833434631e-06f, -2.022439527e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +3.522890437e-04f, +6.814806726e-04f, -1.288224602e-03f, -2.461770383e-03f, +3.054987912e-03f, +5.052313703e-03f, -6.000829409e-03f, -8.637815088e-03f, +1.033992130e-02f, +1.296061558e-02f, -1.606477367e-02f, -1.751984486e-02f, +2.286218928e-02f, +2.165576034e-02f, -3.009756476e-02f, -2.469389280e-02f, +3.688935382e-02f, +2.610908513e-02f, -4.226777073e-02f, -2.565944832e-02f, +4.538205255e-02f, +2.344776607e-02f, -4.570008079e-02f, -1.989083176e-02f, +4.314152582e-02f, +1.560731101e-02f, -3.810317639e-02f, -1.126080856e-02f, +3.136735851e-02f, +7.407334389e-03f, -2.392015241e-02f, -4.391225546e-03f, +1.673281826e-02f, +2.313655906e-03f, -1.056823934e-02f, -1.071538951e-03f, +5.862066405e-03f, +4.421365079e-04f, -2.701005949e-03f, -1.778935794e-04f, +7.271571233e-04f, +7.937424996e-05f, +0.000000000e+00f,
    +0.000000000e+00f, -2.422716675e-05f, +1.542623912e-05f, +9.630421979e-05f, -6.373892123e-05f, -2.155286933e-04f, +1.573685710e-04f, +3.910808416e-04f, -3.157135344e-04f, -6.145298076e-04f, +5.490371495e-04f, +8.629234091e-04f, -8.539948454e-04f, -1.101689457e-03f, +1.209694110e-03f, +1.291655395e-03f, -1.578161324e-03f, -1.398419915e-03f, +1.909999891e-03f, +1.401294039e-03f, -2.154305823e-03f, -1.298963777e-03f, +2.270314702e-03f, +1.109994551e-03f, -2.237417363e-03f, -8.679714118e-04f, +2.060476642e-03f, +6.128326608e-04f, -1.768755735e-03f, -3.811506542e-04f, +1.408759996e-03f, +1.983107871e-04f, -1.033184287e-03f, -7.470322627e-05f, +6.892718057e-04f, +6.536878019e-06f, -4.098560803e-04f, +1.968713542e-05f, +2.092462143e-04f, -2.106071123e-05f, -8.439347096e-05f, +6.833434631e-06f, +2.022439527e-05f, +0.000000000e+00f,
    /*  8,11 (44) */
    +0.000000000e+00f, -3.280618770e-04f, -6.969069117e-04f, +7.975176992e-04f, +1.829644827e-03f, -1.395120602e-03f, -3.881828194e-03f, +1.961222136e-03f, +7.241959306e-03f, -2.197273411e-03f, -1.238886146e-02f, +1.618380364e-03f, +1.999690617e-02f, +5.568911090e-04f, -3.128675631e-02f, -5.761605756e-03f, +4.924605415e-02f, +1.752443450e-02f, -8.429070813e-02f, -5.055785810e-02f, +2.103957378e-01f, +4.586915213e-01f, +4.045254514e-01f, +1.133701677e-01f, -8.760390585e-02f, -5.586239866e-02f, +4.066650065e-02f, +3.622640287e-02f, -2.128381512e-02f, -2.485454003e-02f, +1.107474064e-02f, +1.693026618e-02f, -5.342992525e-03f, -1.109218205e-02f, +2.200101163e-03f, +6.821662764e-03f, -6.320657796e-04f, -3.830711319e-03f, -7.442625010e-06f, +1.880529750e-03f, +1.557669295e-04f, -7.339905580e-04f, -9.959864522e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.416746233e-05f, -1.316861113e-05f, -6.608696828e-05f, +2.687199657e-05f, +1.431597354e-04f, -3.718108509e-05f, -2.706472842e-04f, +3.160476641e-05f, +4.666406816e-04f, +1.100913829e-05f, -7.541364601e-04f, -1.259739956e-04f, +1.168467854e-03f, +3.788846557e-04f, -1.780749095e-03f, -9.256274826e-04f, +2.780829778e-03f, +2.333528214e-03f, -4.879274799e-03f, -9.869478069e-03f, -4.029714077e-03f, +6.714680117e-03f, +9.398032212e-03f, +2.526874633e-03f, -3.254123434e-03f, -1.809004221e-03f, +1.628809553e-03f, +1.291232807e-03f, -8.805431766e-04f, -9.111030623e-04f, +4.723232733e-04f, +6.214410693e-04f, -2.400701682e-04f, -4.018824413e-04f, +1.112497165e-04f, +2.413216300e-04f, -4.510330362e-05f, -1.306592947e-04f, +1.549922050e-05f, +6.046563196e-05f, -5.107193698e-06f, -2.084714333e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +3.280618770e-04f, +6.969069117e-04f, -1.191920382e-03f, -2.525509304e-03f, +2.839459219e-03f, +5.209682274e-03f, -5.609748568e-03f, -8.953528623e-03f, +9.725391489e-03f, +1.350965273e-02f, -1.520185026e-02f, -1.837383971e-02f, +2.176049983e-02f, +2.286545445e-02f, -2.880590937e-02f, -2.627205412e-02f, +3.549093390e-02f, +2.801908502e-02f, -4.086647669e-02f, -2.781375414e-02f, +4.408308877e-02f, +2.571808077e-02f, -4.459008624e-02f, -2.212824912e-02f, +4.227355441e-02f, +1.766778765e-02f, -3.749034373e-02f, -1.302956429e-02f, +3.098620786e-02f, +8.816094385e-03f, -2.372184162e-02f, -5.424409833e-03f, +1.665811503e-02f, +3.002927711e-03f, -1.056170246e-02f, -1.481395032e-03f, +5.881753541e-03f, +6.513827222e-04f, -2.722066660e-03f, -2.622870504e-04f, +7.339905580e-04f, +9.959864522e-05f, +0.000000000e+00f,
    +0.000000000e+00f, -2.416746233e-05f, +1.316861113e-05f, +9.648584411e-05f, -5.540925410e-05f, -2.179789158e-04f, +1.408490179e-04f, +3.985064122e-04f, -2.880380885e-04f, -6.306021650e-04f, +5.081550995e-04f, +8.917723239e-04f, -7.995452478e-04f, -1.147054322e-03f, +1.143483410e-03f, +1.355875694e-03f, -1.504146369e-03f, -1.481543950e-03f, +1.833717525e-03f, +1.500596614e-03f, -2.081863637e-03f, -1.409073225e-03f, +2.207203543e-03f, +1.223659887e-03f, -2.187470241e-03f, -9.773066992e-04f, +2.025255326e-03f, +7.107257092e-04f, -1.747510474e-03f, -4.624709043e-04f, +1.398928609e-03f, +2.606156279e-04f, -1.031238692e-03f, -1.182993974e-04f, +6.916366713e-04f, +3.394731136e-05f, -4.136389188e-04f, +4.637995848e-06f, +2.126161649e-04f, -1.425040657e-05f, -8.658319699e-05f, +5.107193698e-06f, +2.084714333e-05f, +0.000000000e+00f,
    /*  8,12 (44) */
    +0.000000000e+00f, -3.038944146e-04f, -7.100755228e-04f, +7.314307309e-04f, +1.856516824e-03f, -1.251960867e-03f, -3.919009279e-03f, +1.690574852e-03f, +7.273564073e-03f, -1.730632730e-03f, -1.237785232e-02f, +8.642439036e-04f, +1.987093217e-02f, +1.725358962e-03f, -3.090787165e-02f, -7.542354851e-03f, +4.832042667e-02f, +2.030526428e-02f, -8.195717992e-02f, -5.543713289e-02f, +2.005262598e-01f, +4.546618072e-01f, +4.112401315e-01f, +1.227681999e-01f, -8.507703122e-02f, -5.911652209e-02f, +3.885749643e-02f, +3.785521243e-02f, -1.999258231e-02f, -2.573508321e-02f, +1.016363758e-02f, +1.740258945e-02f, -4.721551456e-03f, -1.133225222e-02f, +1.798218722e-03f, +6.932912481e-03f, -3.907441495e-04f, -3.875814623e-03f, -1.381019197e-04f, +1.896028970e-03f, +2.162325615e-04f, -7.390977517e-04f, -1.204457886e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +2.403844844e-05f, -1.094354843e-05f, -6.608644198e-05f, +2.181258871e-05f, +1.430542885e-04f, -2.736098108e-05f, -2.696983397e-04f, +1.441246259e-05f, +4.632372998e-04f, +3.897633968e-05f, -7.452045187e-04f, -1.691254733e-04f, +1.148296197e-03f, +4.431707792e-04f, -1.737914652e-03f, -1.019722344e-03f, +2.687016826e-03f, +2.468235104e-03f, -4.620875869e-03f, -9.863699687e-03f, -4.355771999e-03f, +6.447766409e-03f, +9.495449409e-03f, +2.787333827e-03f, -3.184670576e-03f, -1.928524116e-03f, +1.567652161e-03f, +1.355686285e-03f, -8.342318778e-04f, -9.472556282e-04f, +4.391706653e-04f, +6.414905504e-04f, -2.175942485e-04f, -4.125775763e-04f, +9.699248076e-05f, +2.467237975e-04f, -3.681269562e-05f, -1.332391668e-04f, +1.123435021e-05f, +6.166298190e-05f, -3.310429977e-06f, -2.142767771e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +3.038944146e-04f, +7.100755228e-04f, -1.095434538e-03f, -2.580918558e-03f, +2.621480303e-03f, +5.350531292e-03f, -5.211242156e-03f, -9.241566711e-03f, +9.094789324e-03f, +1.401780783e-02f, -1.431007794e-02f, -1.917338496e-02f, +2.061344550e-02f, +2.400893786e-02f, -2.745003367e-02f, -2.777620049e-02f, +3.400938995e-02f, +2.985280254e-02f, -3.936588008e-02f, -2.989561778e-02f, +4.267401554e-02f, +2.792528431e-02f, -4.336642635e-02f, -2.431571937e-02f, +4.129624771e-02f, +1.969304298e-02f, -3.677961802e-02f, -1.477707477e-02f, +3.052373695e-02f, +1.021502299e-02f, -2.346122599e-02f, -6.455648525e-03f, +1.653981564e-02f, +3.694564383e-03f, -1.052775515e-02f, -1.895033950e-03f, +5.886391536e-03f, +8.639988871e-04f, -2.736317066e-03f, -3.488702474e-04f, +7.390977517e-04f, +1.204457886e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -2.403844844e-05f, +1.094354843e-05f, +9.638600554e-05f, -4.714274876e-05f, -2.197888415e-04f, +1.242826112e-04f, +4.047599059e-04f, -2.600441250e-04f, -6.448251093e-04f, +4.664693497e-04f, +9.180235657e-04f, -7.435767528e-04f, -1.189114717e-03f, +1.074844904e-03f, +1.416252865e-03f, -1.426694509e-03f, -1.560563756e-03f, +1.753027009e-03f, +1.595873504e-03f, -2.004234274e-03f, -1.515571199e-03f, +2.138452665e-03f, +1.334392726e-03f, -2.131837634e-03f, -1.084533190e-03f, +1.984715161e-03f, +8.073400673e-04f, -1.721655398e-03f, -5.432265444e-04f, +1.385412165e-03f, +3.228743345e-04f, -1.026597802e-03f, -1.621478363e-04f, +6.922222111e-04f, +6.171446108e-05f, -4.163863488e-04f, -1.073742985e-05f, +2.154787367e-04f, -7.210351542e-06f, -8.858557120e-05f, +3.310429977e-06f, +2.142767771e-05f, +0.000000000e+00f,
    /*  8,13 (44) */
    +0.000000000e+00f, -2.798559662e-04f, -7.210190713e-04f, +6.653442889e-04f, +1.878329412e-03f, -1.108906579e-03f, -3.946370260e-03f, +1.420876512e-03f, +7.287976535e-03f, -1.267395430e-03f, -1.233887598e-02f, +1.190393849e-04f, +1.970180670e-02f, +2.873655160e-03f, -3.046470087e-02f, -9.280269503e-03f, +4.730070433e-02f, +2.299228111e-02f, -7.948894481e-02f, -6.005800876e-02f, +1.906625601e-01f, +4.503060352e-01f, +4.176878979e-01f, +1.322636493e-01f, -8.228969739e-02f, -6.230119267e-02f, +3.692897231e-02f, +3.942286459e-02f, -1.863689602e-02f, -2.656931509e-02f, +9.216381950e-03f, +1.784176012e-02f, -4.080060906e-03f, -1.154984647e-02f, +1.385641146e-03f, +7.029904962e-03f, -1.440203520e-04f, -3.912627319e-03f, -2.713410865e-04f, +1.907263320e-03f, +2.778955434e-04f, -7.424081816e-04f, -1.418734663e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +2.384271908e-05f, -8.756301760e-06f, -6.591807472e-05f, +1.681653613e-05f, +1.426069468e-04f, -1.766372628e-05f, -2.681343925e-04f, -2.528721062e-06f, +4.588189477e-04f, +6.643741972e-05f, -7.347018899e-04f, -2.112888089e-04f, +1.125813399e-03f, +5.055628209e-04f, -1.691831560e-03f, -1.110115020e-03f, +2.589013718e-03f, +2.594995548e-03f, -4.360746493e-03f, -9.845938909e-03f, -4.675861675e-03f, +6.172121094e-03f, +9.582060540e-03f, +3.048983182e-03f, -3.106958292e-03f, -2.045823112e-03f, +1.502035079e-03f, +1.418009831e-03f, -7.853652598e-04f, -9.817471263e-04f, +4.045334914e-04f, +6.603486128e-04f, -1.942679996e-04f, -4.224765426e-04f, +8.226239070e-05f, +2.516350224e-04f, -2.826832053e-05f, -1.355464329e-04f, +6.837520235e-06f, +6.273089843e-05f, -1.446273059e-06f, -2.196268072e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.798559662e-04f, +7.210190713e-04f, -9.990485321e-04f, -2.628061307e-03f, +2.401691461e-03f, +5.474813903e-03f, -4.806482250e-03f, -9.501610836e-03f, +8.449964215e-03f, +1.448427718e-02f, -1.339205437e-02f, -1.991696171e-02f, +1.942433079e-02f, +2.508378276e-02f, -2.603378081e-02f, -2.920289500e-02f, +3.244882620e-02f, +3.160582955e-02f, -3.777000657e-02f, -3.189985205e-02f, +4.115844435e-02f, +3.006373698e-02f, -4.203203363e-02f, -2.644755700e-02f, +4.021171452e-02f, +2.167775814e-02f, -3.597227795e-02f, -1.649873017e-02f, +2.998051041e-02f, +1.160043516e-02f, -2.313835166e-02f, -7.482246328e-03f, +1.637766780e-02f, +4.386786594e-03f, -1.046604069e-02f, -2.311420299e-03f, +5.875654107e-03f, +1.079477624e-03f, -2.743527418e-03f, -4.374558186e-04f, +7.424081816e-04f, +1.418734663e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -2.384271908e-05f, +8.756301760e-06f, +9.601313121e-05f, -3.896139322e-05f, -2.209674568e-04f, +1.077152281e-04f, +4.098447046e-04f, -2.318106980e-04f, -6.571864865e-04f, +4.240986292e-04f, +9.416368807e-04f, -6.862489085e-04f, -1.227789521e-03f, +1.003973129e-03f, +1.472655172e-03f, -1.346022477e-03f, -1.635293398e-03f, +1.668149396e-03f, +1.686889213e-03f, -1.921623528e-03f, -1.618185689e-03f, +2.064235287e-03f, +1.441904120e-03f, -2.070648629e-03f, -1.189367509e-03f, +1.938937307e-03f, +9.024190434e-04f, -1.691227717e-03f, -6.232033897e-04f, +1.368213823e-03f, +3.849233317e-04f, -1.019243517e-03f, -2.061355206e-04f, +6.910015121e-04f, +8.976910722e-05f, -4.180722284e-04f, -2.640300149e-05f, +2.178140521e-04f, +4.475248966e-08f, -9.038853164e-05f, +1.446273059e-06f, +2.196268072e-05f, +0.000000000e+00f,
    /*  8,14 (44) */
    +0.000000000e+00f, -2.560132471e-04f, -7.297753730e-04f, +5.994262142e-04f, +1.895145949e-03f, -9.662996318e-04f, -3.964033987e-03f, +1.152742120e-03f, +7.285447814e-03f, -8.085764820e-04f, -1.227243856e-02f, -6.156625050e-04f, +1.949051789e-02f, +3.999468559e-03f, -2.995913805e-02f, -1.097210106e-02f, +4.619058931e-02f, +2.558129482e-02f, -7.689394926e-02f, -6.441875526e-02f, +1.808166212e-01f, +4.456301736e-01f, +4.238600190e-01f, +1.418457099e-01f, -7.924071421e-02f, -6.540815096e-02f, +3.488314920e-02f, +4.092489967e-02f, -1.721888619e-02f, -2.735468035e-02f, +8.234634824e-03f, +1.824629361e-02f, -3.419712293e-03f, -1.174411447e-02f, +9.631646030e-04f, +7.112167352e-03f, +1.076146704e-04f, -3.940895639e-03f, -4.068875194e-04f, +1.914100841e-03f, +3.406264418e-04f, -7.438544547e-04f, -1.638361470e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +2.358299974e-05f, -6.611880398e-06f, -6.558647250e-05f, +1.189502014e-05f, +1.418257581e-04f, -8.110407545e-06f, -2.659698591e-04f, -1.918305259e-05f, +4.534115778e-04f, +9.333640378e-05f, -7.226749513e-04f, -2.523817992e-04f, +1.101101830e-03f, +5.659476670e-04f, -1.642647427e-03f, -1.196666476e-03f, +2.487093602e-03f, +2.713718553e-03f, -4.099312916e-03f, -9.816310925e-03f, -4.989553031e-03f, +5.888100406e-03f, +9.657646552e-03f, +3.311418047e-03f, -3.020985374e-03f, -2.160614618e-03f, +1.432035250e-03f, +1.478033405e-03f, -7.340184918e-04f, -1.014475465e-03f, +3.684708245e-04f, +6.779540756e-04f, -1.701333783e-04f, -4.315432790e-04f, +6.708679320e-05f, +2.560345824e-04f, -1.948633533e-05f, -1.375695279e-04f, +2.317069827e-06f, +6.366312058e-05f, +4.818649841e-07f, -2.244888408e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.560132471e-04f, +7.297753730e-04f, -9.030354009e-04f, -2.667022700e-03f, +2.180724004e-03f, +5.582529131e-03f, -4.396637545e-03f, -9.733421534e-03f, +7.792777728e-03f, +1.490837581e-02f, -1.245041749e-02f, -2.060321062e-02f, +1.819654127e-02f, +2.608775589e-02f, -2.456112564e-02f, -3.054891748e-02f, +3.081353280e-02f, +3.327397895e-02f, -3.608311736e-02f, -3.382147558e-02f, +3.954025866e-02f, +3.212797226e-02f, -4.059012951e-02f, -2.851820563e-02f, +3.902234701e-02f, +2.361669545e-02f, -3.506985891e-02f, -1.818995788e-02f, +2.935730702e-02f, +1.296864898e-02f, -2.275342833e-02f, -8.501489845e-03f, +1.617153228e-02f, +5.077788106e-03f, -1.037627158e-02f, -2.729492528e-03f, +5.849251105e-03f, +1.297291676e-03f, -2.743482666e-03f, -5.278443502e-04f, +7.438544547e-04f, +1.638361470e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -2.358299974e-05f, +6.611880398e-06f, +9.537626022e-05f, -3.088640110e-05f, -2.215253523e-04f, +9.119188536e-05f, +4.137673286e-04f, -2.034163201e-04f, -6.676792871e-04f, +3.811620628e-04f, +9.625794128e-04f, -6.277233333e-04f, -1.263007155e-03f, +9.310670614e-04f, +1.524962044e-03f, -1.262354277e-03f, -1.705558856e-03f, +1.579315914e-03f, +1.773419819e-03f, -1.834249851e-03f, -1.716654862e-03f, +1.984738917e-03f, +1.545913065e-03f, -2.004047085e-03f, -1.291531559e-03f, +1.888016951e-03f, +9.957085918e-04f, -1.656276876e-03f, -7.021877095e-04f, +1.347346503e-03f, +4.465980006e-04f, -1.009164789e-03f, -2.501476454e-04f, +6.879521958e-04f, +1.180401565e-04f, -4.186729204e-04f, -4.232104223e-05f, +2.196033337e-04f, +7.499182172e-06f, -9.198031050e-05f, -4.818649841e-07f, +2.244888408e-05f, +0.000000000e+00f,
    /*  8,15 (44) */
    +0.000000000e+00f, -2.324302474e-04f, -7.363872534e-04f, +5.338397417e-04f, +1.907040969e-03f, -8.244738737e-04f, -3.972144394e-03f, +8.867722608e-04f, +7.266264762e-03f, -3.551649042e-04f, -1.217910216e-02f, -1.338337456e-03f, +1.923813609e-02f, +5.100570388e-03f, -2.939319038e-02f, -1.261474849e-02f, +4.499392283e-02f, +2.806838843e-02f, -7.418023071e-02f, -6.851806817e-02f, +1.710003103e-01f, +4.406406205e-01f, +4.297481194e-01f, +1.515033564e-01f, -7.592929617e-02f, -6.842913633e-02f, +3.272253458e-02f, +4.235693492e-02f, -1.574085279e-02f, -2.808869884e-02f, +7.220159360e-03f, +1.861476443e-02f, -2.741758217e-03f, -1.191424785e-02f, +5.316213240e-04f, +7.179254146e-03f, +3.636492528e-04f, -3.960381975e-03f, -5.444570472e-04f, +1.916417910e-03f, +4.042895624e-04f, -7.433725897e-04f, -1.862850311e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +2.326213574e-05f, -4.515043563e-06f, -6.509656988e-05f, +7.058791348e-06f, +1.407194469e-04f, +1.278624870e-06f, -2.632203577e-04f, -3.551605358e-05f, +4.470430736e-04f, +1.196194356e-04f, -7.091729436e-04f, -2.923257993e-04f, +1.074247776e-03f, +6.242181808e-04f, -1.590514587e-03f, -1.279247763e-03f, +2.381533322e-03f, +2.824328624e-03f, -3.836999584e-03f, -9.774949114e-03f, -5.296426649e-03f, +5.596074459e-03f, +9.722004727e-03f, +3.574228409e-03f, -2.926765753e-03f, -2.272612832e-03f, +1.357740153e-03f, +1.535589709e-03f, -6.802733621e-04f, -1.045341195e-03f, +3.310458549e-04f, +6.942478174e-04f, -1.452348731e-04f, -4.397431547e-04f, +5.149456241e-05f, +2.599026502e-04f, -1.048379485e-05f, -1.392973795e-04f, -2.318150385e-06f, +6.445360941e-05f, +2.470292752e-06f, -2.288308057e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.324302474e-04f, +7.363872534e-04f, -8.076591407e-04f, -2.697909101e-03f, +1.959198652e-03f, +5.673721017e-03f, -3.982870217e-03f, -9.936837854e-03f, +7.125098441e-03f, +1.528953787e-02f, -1.148783808e-02f, -2.123093395e-02f, +1.693353411e-02f, +2.701882295e-02f, -2.303616359e-02f, -3.181127175e-02f, +2.910797394e-02f, +3.485329486e-02f, -3.430969754e-02f, -3.565572543e-02f, +3.782360379e-02f, +3.411271118e-02f, -3.904421644e-02f, -3.052225271e-02f, +3.773081546e-02f, +2.550471240e-02f, -3.407415032e-02f, -1.984623476e-02f, +2.865511931e-02f, +1.431599548e-02f, -2.230683033e-02f, -9.510654634e-03f, +1.592138463e-02f, +5.765740302e-03f, -1.025823142e-02f, -3.148165448e-03f, +5.806930063e-03f, +1.516895010e-03f, -2.735983483e-03f, -6.198246607e-04f, +7.433725897e-04f, +1.862850311e-04f, +0.000000000e+00f,
    +0.000000000e+00f, -2.326213574e-05f, +4.515043563e-06f, +9.448499971e-05f, -2.293816556e-05f, -2.214746593e-04f, +7.475662740e-05f, +4.165373671e-04f, -1.749387546e-04f, -6.763015984e-04f, +3.377788445e-04f, +9.808257139e-04f, -5.681632653e-04f, -1.294705690e-03f, +8.563295593e-04f, +1.573064329e-03f, -1.175920565e-03f, -1.771198429e-03f, +1.486767326e-03f, +1.855253545e-03f, -1.742343765e-03f, -1.810727743e-03f, +1.900164870e-03f, +1.646147245e-03f, -1.932191282e-03f, -1.390753267e-03f, +1.832063116e-03f, +1.086957999e-03f, -1.616864506e-03f, -7.799668001e-04f, +1.322832937e-03f, +5.077331119e-04f, -9.963577334e-04f, -2.940679154e-04f, +6.830565413e-04f, +1.464548128e-04f, -4.181674015e-04f, -5.845241879e-05f, +2.208289832e-04f, +1.513621662e-05f, -9.334948024e-05f, -2.470292752e-06f, +2.288308057e-05f, +0.000000000e+00f,
    /*  8,16 (44) */
    +0.000000000e+00f, -2.091681116e-04f, -7.409022970e-04f, +4.687431718e-04f, +1.914099760e-03f, -6.837544268e-04f, -3.970865769e-03f, +6.235519031e-04f, +7.230748708e-03f, +9.187816936e-05f, -1.205948272e-02f, -2.047510400e-03f, +1.894581029e-02f, +6.174818164e-03f, -2.876897220e-02f, -1.420526308e-02f, +4.371467507e-02f, +3.044992175e-02f, -7.135590209e-02f, -7.235506776e-02f, +1.612253611e-01f, +4.353441939e-01f, +4.353441939e-01f, +1.612253611e-01f, -7.235506776e-02f, -7.135590209e-02f, +3.044992175e-02f, +4.371467507e-02f, -1.420526308e-02f, -2.876897220e-02f, +6.174818164e-03f, +1.894581029e-02f, -2.047510400e-03f, -1.205948272e-02f, +9.187816936e-05f, +7.230748708e-03f, +6.235519031e-04f, -3.970865769e-03f, -6.837544268e-04f, +1.914099760e-03f, +4.687431718e-04f, -7.409022970e-04f, -2.091681116e-04f, +0.000000000e+00f,
    +0.000000000e+00f, +2.288308057e-05f, -2.470292752e-06f, -6.445360941e-05f, +2.318150385e-06f, +1.392973795e-04f, +1.048379485e-05f, -2.599026502e-04f, -5.149456241e-05f, +4.397431547e-04f, +1.452348731e-04f, -6.942478174e-04f, -3.310458549e-04f, +1.045341195e-03f, +6.802733621e-04f, -1.535589709e-03f, -1.357740153e-03f, +2.272612832e-03f, +2.926765753e-03f, -3.574228409e-03f, -9.722004727e-03f, -5.596074459e-03f, +5.296426649e-03f, +9.774949114e-03f, +3.836999584e-03f, -2.824328624e-03f, -2.381533322e-03f, +1.279247763e-03f, +1.590514587e-03f, -6.242181808e-04f, -1.074247776e-03f, +2.923257993e-04f, +7.091729436e-04f, -1.196194356e-04f, -4.470430736e-04f, +3.551605358e-05f, +2.632203577e-04f, -1.278624870e-06f, -1.407194469e-04f, -7.058791348e-06f, +6.509656988e-05f, +4.515043563e-06f, -2.326213574e-05f, +0.000000000e+00f,
    +0.000000000e+00f, +2.