package com.jogamp.openal.test.manual;

/**
 * Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
 * Copyright (c) 2011 JogAmp Community. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * -Redistribution of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * -Redistribution in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of Sun Microsystems, Inc. or the names of contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING
 * ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS
 * LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A
 * RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT
 * OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
 * PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY,
 * ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that this software is not designed or intended for use in the
 * design, construction, operation or maintenance of any nuclear facility.
 */
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

import com.jogamp.common.nio.Buffers;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALConstants;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.ALVersion;
import com.jogamp.openal.JoalVersion;
import com.jogamp.openal.UnsupportedAudioFileException;
import com.jogamp.openal.test.resources.ResourceLocation;
import com.jogamp.openal.util.WAVData;

/**
 * @author Athomas Goldberg, Michael Bien, et.al.
 */
public class OpenALTest {
    private static final AL al;
    private static final ALC alc;
    private ALCdevice device = null;
    private ALCcontext context = null;
    private int[] sources = null;
    private boolean initialized = false;

    static {
        alc = ALFactory.getALC();
        al = ALFactory.getAL();
    }

    public OpenALTest() {
    }

    public void init() throws UnsupportedAudioFileException, IOException {
        if( initialized ) {
            return;
        }
        System.err.println(JoalVersion.getInstance().toString(alc));

        device = alc.alcOpenDevice(null);
        context = alc.alcCreateContext(device, null);
        alc.alcMakeContextCurrent(context);
        System.out.println("ALVersion: "+new ALVersion(al).toString());

        final int[] buffers = new int[1];
        al.alGenBuffers(1, buffers, 0);

        // WAVData wd = WAVData.loadFromStream(ResourceLocation.getTestStream0(), ResourceLocation.getTestStream0Size(), 1, 8, 22050, ByteOrder.LITTLE_ENDIAN, true);
        // WAVData wd = WAVData.loadFromStream(ResourceLocation.getTestStream1(), ResourceLocation.getTestStream1Size(), 2, 16, 44100, ByteOrder.BIG_ENDIAN, true);
        final WAVData wd = WAVData.loadFromStream(ResourceLocation.getTestStream2(), ResourceLocation.getTestStream2Size(), 2, 16, 44100, ByteOrder.LITTLE_ENDIAN, true);
        // WAVData wd = WAVData.loadFromStream(ResourceLocation.getTestStream3(), ResourceLocation.getTestStream3Size(), 2, 16, 44100, ByteOrder.LITTLE_ENDIAN, true);
        System.out.println("*** size "+wd.data.limit());

        al.alBufferData(buffers[0], wd.format, wd.data, wd.size, wd.freq);

        sources = new int[1];
        al.alGenSources(1, sources, 0);
        al.alSourcei(sources[0], ALConstants.AL_BUFFER, buffers[0]);

        final int[] loopArray = new int[1];
        al.alGetSourcei(sources[0], ALConstants.AL_LOOPING, loopArray, 0);
        System.err.println("Looping 1: " + (loopArray[0] == ALConstants.AL_TRUE));

        initialized = true;
    }

    public void play() {
        if( !initialized ) {
            return;
        }
        System.out.println("play direct");
        al.alSourceRewind(sources[0]);
        al.alSourcePlay(sources[0]);
    }

    public void play3f(final float x, final float y, final float z) {
        if( !initialized ) {
            return;
        }
        System.out.println("play3f "+x+", "+y+", "+z);
        al.alSourceRewind(sources[0]);
        al.alSourcePlay(sources[0]);
        al.alSource3f(sources[0], ALConstants.AL_POSITION, x, y, z);
    }

    public void pause() {
        if( !initialized ) {
            return;
        }
        al.alSourcePause(sources[0]);
    }

    public void dispose() {
        if( !initialized ) {
            return;
        }
        if( null != sources ) {
            al.alSourceStop(sources[0]);
            al.alDeleteSources(1, sources, 0);
            sources = null;
        }
        if( null != context ) {
            alc.alcMakeContextCurrent(null);
            alc.alcDestroyContext(context);
            context = null;
        }
        if( null != device ) {
            alc.alcCloseDevice(device);
            device = null;
        }
        initialized = false;
    }

    public static void main(final String[] args) throws InterruptedException, UnsupportedAudioFileException, IOException {
        final OpenALTest demo = new OpenALTest();
        demo.init();

        demo.play();
        Thread.sleep(5000);

        demo.play3f(2f, 2f, 2f);
        Thread.sleep(5000);

        demo.play3f(3f, 3f, 3f);
        Thread.sleep(5000);

        demo.play3f(0f, 0f, 0f);
        Thread.sleep(5000);

        demo.dispose();
    }
}
