/*
 * Created on Sep 10, 2010, 6:12:26 PM
 */

package com.jogamp.opencl.util;

import com.jogamp.common.JogampRuntimeException;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;

/*
 * Icon used in the dialog is from http://lazycrazy.deviantart.com/ released under the CC attibution license.
 */

/**
 *
 * @author Michael Bien
 */
@SuppressWarnings("serial")
public class ExceptionReporter extends JDialog {

    public ExceptionReporter(Frame parent, boolean modal) {
        super(parent, "Something went wrong", modal);
        initComponents();
    }

    public static void appear(String string, JogampRuntimeException ex) {
        ExceptionReporter reporter = new ExceptionReporter(null, true);
        reporter.setLocationRelativeTo(null);
        reporter.description.setText(string);

        StringBuilder sb = new StringBuilder();
        final Writer result = new StringWriter();
        ex.printStackTrace(new PrintWriter(result));

        sb.append("<pre>").append(result.toString()).append("</pre>");
        reporter.messagePane.setText(sb.toString());
        reporter.setVisible(true);

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        JLabel icon = new JLabel();
        JButton reportButton = new JButton();
        JButton okButton = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        messagePane = new JEditorPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        description = new JTextPane();

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

        icon.setIcon(new ImageIcon(getClass().getResource("/com/jogamp/opencl/util/64_35.png"))); // NOI18N

        reportButton.setText("not at all. I file a bug!");
        reportButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                reportButtonActionPerformed(evt);
            }
        });

        okButton.setText("understood");
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        messagePane.setContentType("text/html");
        messagePane.setEditable(false);
        jScrollPane1.setViewportView(messagePane);

        description.setEditable(false);
        description.setFocusable(false);
        jScrollPane2.setViewportView(description);

        GroupLayout layout = new GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(icon)
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(Alignment.LEADING)
                            .addComponent(jScrollPane2, GroupLayout.DEFAULT_SIZE, 396, Short.MAX_VALUE)
                            .addComponent(jScrollPane1, GroupLayout.DEFAULT_SIZE, 396, Short.MAX_VALUE)))
                    .addGroup(Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(okButton)
                        .addPreferredGap(ComponentPlacement.UNRELATED)
                        .addComponent(reportButton)))
                .addContainerGap())
        );

        layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {okButton, reportButton});

        layout.setVerticalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(Alignment.LEADING)
                    .addComponent(icon)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                        .addGap(4, 4, 4)
                        .addComponent(jScrollPane1, GroupLayout.DEFAULT_SIZE, 146, Short.MAX_VALUE)))
                .addPreferredGap(ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(Alignment.BASELINE)
                    .addComponent(reportButton)
                    .addComponent(okButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void reportButtonActionPerformed(ActionEvent evt) {//GEN-FIRST:event_reportButtonActionPerformed
        try {
            Desktop.getDesktop().browse(URI.create("http://www.jogamp.org/bugzilla/"));
        } catch (IOException ex) {
            Logger.getLogger(ExceptionReporter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_reportButtonActionPerformed

    private void okButtonActionPerformed(ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        dispose();
    }//GEN-LAST:event_okButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JTextPane description;
    private JEditorPane messagePane;
    // End of variables declaration//GEN-END:variables

}
