/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import simple.xml.Attribute;
import simple.xml.Element;
import simple.xml.ElementList;
import simple.xml.load.Commit;
import simple.xml.load.Complete;
import simple.xml.load.Label;
import simple.xml.load.LabelFactory;
import simple.xml.load.LabelMap;
import simple.xml.load.Persist;
import simple.xml.load.Validate;

final class Scanner {
    private LabelMap attributes = new LabelMap();
    private LabelMap elements = new LabelMap();
    private Method commit;
    private Method validate;
    private Method persist;
    private Method complete;

    public Scanner(Class type) {
        this.scan(type);
    }

    public LabelMap getAttributes() {
        return new LabelMap(this.attributes);
    }

    public LabelMap getElements() {
        return new LabelMap(this.elements);
    }

    public Method getCommit() {
        return this.commit;
    }

    public Method getValidate() {
        return this.validate;
    }

    public Method getPersist() {
        return this.persist;
    }

    public Method getComplete() {
        return this.complete;
    }

    private void scan(Class type) {
        Class real = type;
        do {
            this.scan(real, type);
        } while ((type = type.getSuperclass()) != null);
    }

    private void scan(Class real, Class type) {
        Field[] field = type.getDeclaredFields();
        for (int i = 0; i < field.length; ++i) {
            this.scan(field[i]);
        }
        Method[] method = type.getDeclaredMethods();
        for (int i = 0; i < method.length; ++i) {
            this.scan(method[i]);
        }
    }

    private void scan(Field field) {
        Annotation[] list = field.getDeclaredAnnotations();
        for (int i = 0; i < list.length; ++i) {
            this.scan(field, list[i]);
        }
    }

    private void scan(Method method) {
        if (this.commit == null) {
            this.commit(method);
        }
        if (this.validate == null) {
            this.validate(method);
        }
        if (this.persist == null) {
            this.persist(method);
        }
        if (this.complete == null) {
            this.complete(method);
        }
    }

    private void commit(Method method) {
        Commit mark = method.getAnnotation(Commit.class);
        if (mark != null) {
            this.commit = method;
        }
    }

    private void validate(Method method) {
        Validate mark = method.getAnnotation(Validate.class);
        if (mark != null) {
            this.validate = method;
        }
    }

    private void persist(Method method) {
        Persist mark = method.getAnnotation(Persist.class);
        if (mark != null) {
            this.persist = method;
        }
    }

    private void complete(Method method) {
        Complete mark = method.getAnnotation(Complete.class);
        if (mark != null) {
            this.complete = method;
        }
    }

    private void scan(Field field, Annotation label) {
        if (label instanceof Attribute) {
            this.process(field, label, this.attributes);
        }
        if (label instanceof ElementList) {
            this.process(field, label, this.elements);
        }
        if (label instanceof Element) {
            this.process(field, label, this.elements);
        }
    }

    private void process(Field field, Annotation type, Map map) {
        Label label = LabelFactory.getInstance(field, type);
        String name = label.getName().toLowerCase();
        if (!map.containsKey(name)) {
            map.put(name, label);
        }
    }
}

