/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.stream;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import simple.xml.stream.InputAttribute;
import simple.xml.stream.InputNode;
import simple.xml.stream.Node;
import simple.xml.stream.NodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InputNodeMap
extends HashMap<String, InputNode>
implements NodeMap {
    private Node source;

    protected InputNodeMap(Node source) {
        this.source = source;
    }

    public InputNodeMap(Node source, StartElement element) {
        this.source = source;
        this.put(element);
    }

    @Override
    public String getName() {
        return this.source.getName();
    }

    private void put(StartElement element) {
        Iterator<Attribute> list = element.getAttributes();
        while (list.hasNext()) {
            Attribute event = list.next();
            if (!(event instanceof Attribute)) continue;
            this.put(event);
        }
    }

    private void put(Attribute event) {
        this.put(new InputAttribute(event));
    }

    @Override
    public void put(String name, String value) {
        this.put(new InputAttribute(name, value));
    }

    private void put(InputAttribute input) {
        this.put(input.getName(), input);
    }

    @Override
    public InputNode remove(String name) {
        return (InputNode)super.remove(name);
    }

    @Override
    public InputNode get(String name) {
        return (InputNode)super.get(name);
    }

    @Override
    public Iterator<String> iterator() {
        return this.keySet().iterator();
    }
}

