/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.font;

import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.cache.TempJarCache;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontSet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import jogamp.graph.font.FontConstructor;
import jogamp.graph.font.JavaFontLoader;
import jogamp.graph.font.UbuntuFontLoader;

public class FontFactory {
    private static final String FontConstructorPropKey = "jogamp.graph.font.ctor";
    private static final String DefaultFontConstructor = "jogamp.graph.font.typecast.TypecastFontConstructor";
    public static final int UBUNTU = 0;
    public static final int JAVA = 1;
    private static final FontConstructor fontConstr;

    public static final FontSet getDefault() {
        return FontFactory.get(0);
    }

    public static final FontSet get(int n) {
        switch (n) {
            case 1: {
                return JavaFontLoader.get();
            }
        }
        return UbuntuFontLoader.get();
    }

    public static final Font get(File file) throws IOException {
        return fontConstr.create(file);
    }

    public static final Font get(URLConnection uRLConnection) throws IOException {
        return fontConstr.create(uRLConnection);
    }

    public static final Font get(Class<?> clazz, String string, boolean bl) throws IOException {
        URLConnection uRLConnection = null;
        if (bl) {
            try {
                URI uRI = TempJarCache.getResource((String)string);
                uRLConnection = null != uRI ? uRI.toURL().openConnection() : null;
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        } else {
            uRLConnection = IOUtil.getResource(clazz, (String)string);
        }
        if (null != uRLConnection) {
            return FontFactory.get(uRLConnection);
        }
        return null;
    }

    public static boolean isPrintableChar(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        if ('\u0000' == c || Character.isISOControl(c)) {
            return false;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock != null && unicodeBlock != Character.UnicodeBlock.SPECIALS;
    }

    static {
        String string = PropertyAccess.getProperty((String)FontConstructorPropKey, (boolean)true);
        if (null == string) {
            string = DefaultFontConstructor;
        }
        fontConstr = (FontConstructor)ReflectionUtil.createInstance((String)string, (ClassLoader)FontFactory.class.getClassLoader());
    }
}

