/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.util.PropertyAccess;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.Debug;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.windows.wgl.WGLUtil;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public abstract class WindowsWGLDrawable
extends GLDrawableImpl {
    private static final boolean PROFILING;
    private static final int PROFILING_TICKS = 200;
    private int profilingSwapBuffersTicks;
    private long profilingSwapBuffersTime;

    public WindowsWGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, boolean bl) {
        super(gLDrawableFactory, nativeSurface, bl);
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            NativeSurface nativeSurface = this.getNativeSurface();
            WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
            windowsWGLGraphicsConfiguration.updateGraphicsConfiguration(this.getFactory(), nativeSurface, null);
            if (DEBUG) {
                System.err.println(WindowsWGLDrawable.getThreadName() + ": WindowsWGLDrawable.setRealized(true): " + windowsWGLGraphicsConfiguration);
            }
        }
    }

    @Override
    protected final void swapBuffersImpl(boolean bl) {
        if (bl) {
            long l = PROFILING ? System.currentTimeMillis() : 0L;
            if (!WGLUtil.SwapBuffers(this.getHandle()) && GDI.GetLastError() != 0) {
                throw new GLException("Error swapping buffers");
            }
            if (PROFILING) {
                this.profilingSwapBuffersTime += System.currentTimeMillis() - l;
                if (++this.profilingSwapBuffersTicks == 200) {
                    System.err.println("SwapBuffers calls: " + this.profilingSwapBuffersTime + " ms / " + 200 + "  calls (" + (float)this.profilingSwapBuffersTime / 200.0f + " ms/call)");
                    this.profilingSwapBuffersTime = 0L;
                    this.profilingSwapBuffersTicks = 0;
                }
            }
        }
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper() {
        return this.getFactoryImpl().getGLDynamicLookupHelper(0);
    }

    static {
        Debug.initSingleton();
        PROFILING = PropertyAccess.isPropertyDefined((String)"jogl.debug.GLDrawable.profiling", (boolean)true);
    }
}

