/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.property.adapter;

import com.sun.javafx.property.MethodHelper;
import com.sun.javafx.property.adapter.ReadOnlyPropertyDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.beans.property.Property;
import javafx.beans.property.adapter.ReadOnlyJavaBeanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class PropertyDescriptor
extends ReadOnlyPropertyDescriptor {
    private static final String ADD_VETOABLE_LISTENER_METHOD_NAME = "addVetoableChangeListener";
    private static final String REMOVE_VETOABLE_LISTENER_METHOD_NAME = "removeVetoableChangeListener";
    private static final String ADD_PREFIX = "add";
    private static final String REMOVE_PREFIX = "remove";
    private static final String SUFFIX = "Listener";
    private static final int ADD_VETOABLE_LISTENER_TAKES_NAME = 1;
    private static final int REMOVE_VETOABLE_LISTENER_TAKES_NAME = 2;
    private final Method setter;
    private final Method addVetoListener;
    private final Method removeVetoListener;
    private final int flags;

    public Method getSetter() {
        return this.setter;
    }

    public PropertyDescriptor(String propertyName, Class<?> beanClass, Method getter, Method setter) {
        super(propertyName, beanClass, getter);
        this.setter = setter;
        Method tmpAddVetoListener = null;
        Method tmpRemoveVetoListener = null;
        int tmpFlags = 0;
        String addMethodName = ADD_PREFIX + PropertyDescriptor.capitalizedName(this.name) + SUFFIX;
        try {
            tmpAddVetoListener = beanClass.getMethod(addMethodName, VetoableChangeListener.class);
        }
        catch (NoSuchMethodException e) {
            try {
                tmpAddVetoListener = beanClass.getMethod(ADD_VETOABLE_LISTENER_METHOD_NAME, String.class, VetoableChangeListener.class);
                tmpFlags |= 1;
            }
            catch (NoSuchMethodException e1) {
                try {
                    tmpAddVetoListener = beanClass.getMethod(ADD_VETOABLE_LISTENER_METHOD_NAME, VetoableChangeListener.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        String removeMethodName = REMOVE_PREFIX + PropertyDescriptor.capitalizedName(this.name) + SUFFIX;
        try {
            tmpRemoveVetoListener = beanClass.getMethod(removeMethodName, VetoableChangeListener.class);
        }
        catch (NoSuchMethodException e) {
            try {
                tmpRemoveVetoListener = beanClass.getMethod(REMOVE_VETOABLE_LISTENER_METHOD_NAME, String.class, VetoableChangeListener.class);
                tmpFlags |= 2;
            }
            catch (NoSuchMethodException e1) {
                try {
                    tmpRemoveVetoListener = beanClass.getMethod(REMOVE_VETOABLE_LISTENER_METHOD_NAME, VetoableChangeListener.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        this.addVetoListener = tmpAddVetoListener;
        this.removeVetoListener = tmpRemoveVetoListener;
        this.flags = tmpFlags;
    }

    @Override
    public void addListener(ReadOnlyPropertyDescriptor.ReadOnlyListener listener) {
        super.addListener(listener);
        if (this.addVetoListener != null) {
            try {
                if ((this.flags & 1) > 0) {
                    this.addVetoListener.invoke(listener.getBean(), this.name, listener);
                } else {
                    this.addVetoListener.invoke(listener.getBean(), listener);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeListener(ReadOnlyPropertyDescriptor.ReadOnlyListener listener) {
        super.removeListener(listener);
        if (this.removeVetoListener != null) {
            try {
                if ((this.flags & 2) > 0) {
                    this.removeVetoListener.invoke(listener.getBean(), this.name, listener);
                } else {
                    this.removeVetoListener.invoke(listener.getBean(), listener);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public class Listener<T>
    extends ReadOnlyPropertyDescriptor.ReadOnlyListener<T>
    implements ChangeListener<T>,
    VetoableChangeListener {
        private boolean updating;

        public Listener(Object bean, ReadOnlyJavaBeanProperty<T> property) {
            super(PropertyDescriptor.this, bean, property);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
            ReadOnlyJavaBeanProperty property = this.checkRef();
            if (property == null) {
                observable.removeListener(this);
            } else if (!this.updating) {
                this.updating = true;
                try {
                    MethodHelper.invoke(PropertyDescriptor.this.setter, this.bean, new Object[]{newValue});
                    property.fireValueChangedEvent();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                finally {
                    this.updating = false;
                }
            }
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            ReadOnlyJavaBeanProperty property;
            if (this.bean.equals(propertyChangeEvent.getSource()) && PropertyDescriptor.this.name.equals(propertyChangeEvent.getPropertyName()) && (property = this.checkRef()) instanceof Property && ((Property)((Object)property)).isBound() && !this.updating) {
                throw new PropertyVetoException("A bound value cannot be set.", propertyChangeEvent);
            }
        }
    }
}

