/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property.adapter;

import com.sun.javafx.property.MethodHelper;
import com.sun.javafx.property.adapter.Disposer;
import com.sun.javafx.property.adapter.ReadOnlyPropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Objects;
import javafx.beans.property.ReadOnlyStringPropertyBase;
import javafx.beans.property.adapter.DescriptorListenerCleaner;
import javafx.beans.property.adapter.ReadOnlyJavaBeanProperty;

public final class ReadOnlyJavaBeanStringProperty
extends ReadOnlyStringPropertyBase
implements ReadOnlyJavaBeanProperty<String> {
    private final ReadOnlyPropertyDescriptor descriptor;
    private final ReadOnlyPropertyDescriptor.ReadOnlyListener<String> listener;
    private final AccessControlContext acc = AccessController.getContext();

    ReadOnlyJavaBeanStringProperty(ReadOnlyPropertyDescriptor descriptor, Object bean) {
        this.descriptor = descriptor;
        ReadOnlyPropertyDescriptor readOnlyPropertyDescriptor = descriptor;
        Objects.requireNonNull(readOnlyPropertyDescriptor);
        this.listener = readOnlyPropertyDescriptor.new ReadOnlyPropertyDescriptor.ReadOnlyListener<String>(bean, this);
        descriptor.addListener(this.listener);
        Disposer.addRecord(this, new DescriptorListenerCleaner(descriptor, this.listener));
    }

    @Override
    public String get() {
        return AccessController.doPrivileged(() -> {
            try {
                return (String)MethodHelper.invoke(this.descriptor.getGetter(), this.getBean(), null);
            }
            catch (IllegalAccessException e) {
                throw new UndeclaredThrowableException(e);
            }
            catch (InvocationTargetException e) {
                throw new UndeclaredThrowableException(e);
            }
        }, this.acc);
    }

    @Override
    public Object getBean() {
        return this.listener.getBean();
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public void fireValueChangedEvent() {
        super.fireValueChangedEvent();
    }

    @Override
    public void dispose() {
        this.descriptor.removeListener(this.listener);
    }
}

