/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.animation;

import javafx.util.Duration;

public class TickCalculation {
    public static final int TICKS_PER_SECOND = 6000;
    private static final double TICKS_PER_MILI = 6.0;
    private static final double TICKS_PER_NANO = 6.0E-6;

    private TickCalculation() {
    }

    public static long add(long op1, long op2) {
        assert (op1 >= 0L);
        if (op1 == Long.MAX_VALUE || op2 == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        if (op2 == Long.MIN_VALUE) {
            return 0L;
        }
        if (op2 >= 0L) {
            long result = op1 + op2;
            return result < 0L ? Long.MAX_VALUE : result;
        }
        return Math.max(0L, op1 + op2);
    }

    public static long sub(long op1, long op2) {
        assert (op1 >= 0L);
        if (op1 == Long.MAX_VALUE || op2 == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (op2 == Long.MAX_VALUE) {
            return 0L;
        }
        if (op2 >= 0L) {
            return Math.max(0L, op1 - op2);
        }
        long result = op1 - op2;
        return result < 0L ? Long.MAX_VALUE : result;
    }

    public static long fromMillis(double millis) {
        return Math.round(6.0 * millis);
    }

    public static long fromNano(long nano) {
        return Math.round(6.0E-6 * (double)nano);
    }

    public static long fromDuration(Duration duration) {
        return TickCalculation.fromMillis(duration.toMillis());
    }

    public static long fromDuration(Duration duration, double rate) {
        return Math.round(6.0 * duration.toMillis() / Math.abs(rate));
    }

    public static Duration toDuration(long ticks) {
        return Duration.millis((double)TickCalculation.toMillis(ticks));
    }

    public static double toMillis(long ticks) {
        return (double)ticks / 6.0;
    }
}

