/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import com.sun.javafx.application.ModuleAccess;
import com.sun.javafx.application.ParametersImpl;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.stage.StageHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javafx.application.Application;
import javafx.application.Preloader;
import javafx.stage.Stage;

public class LauncherImpl {
    public static final String LAUNCH_MODE_CLASS = "LM_CLASS";
    public static final String LAUNCH_MODE_JAR = "LM_JAR";
    public static final String LAUNCH_MODE_MODULE = "LM_MODULE";
    private static final boolean trace = false;
    private static final boolean verbose;
    private static final String MF_MAIN_CLASS = "Main-Class";
    private static final String MF_JAVAFX_MAIN = "JavaFX-Application-Class";
    private static final String MF_JAVAFX_PRELOADER = "JavaFX-Preloader-Class";
    private static final String MF_JAVAFX_CLASS_PATH = "JavaFX-Class-Path";
    private static final String MF_JAVAFX_ARGUMENT_PREFIX = "JavaFX-Argument-";
    private static final String MF_JAVAFX_PARAMETER_NAME_PREFIX = "JavaFX-Parameter-Name-";
    private static final String MF_JAVAFX_PARAMETER_VALUE_PREFIX = "JavaFX-Parameter-Value-";
    private static final boolean simulateSlowProgress = false;
    private static AtomicBoolean launchCalled;
    private static final AtomicBoolean toolkitStarted;
    private static volatile RuntimeException launchException;
    private static Preloader currentPreloader;
    private static Class<? extends Preloader> savedPreloaderClass;
    private static ClassLoader savedMainCcl;
    private static volatile boolean error;
    private static volatile Throwable pConstructorError;
    private static volatile Throwable pInitError;
    private static volatile Throwable pStartError;
    private static volatile Throwable pStopError;
    private static volatile Throwable constructorError;
    private static volatile Throwable initError;
    private static volatile Throwable startError;
    private static volatile Throwable stopError;

    public static void launchApplication(Class<? extends Application> appClass, String[] args) {
        String preloaderByProperty;
        Class<Preloader> preloaderClass = savedPreloaderClass;
        if (preloaderClass == null && (preloaderByProperty = AccessController.doPrivileged(() -> System.getProperty("javafx.preloader"))) != null) {
            try {
                preloaderClass = Class.forName(preloaderByProperty, false, appClass.getClassLoader());
            }
            catch (Exception e) {
                System.err.printf("Could not load preloader class '" + preloaderByProperty + "', continuing without preloader.", new Object[0]);
                e.printStackTrace();
            }
        }
        LauncherImpl.launchApplication(appClass, preloaderClass, args);
    }

    public static void launchApplication(Class<? extends Application> appClass, Class<? extends Preloader> preloaderClass, String[] args) {
        if (launchCalled.getAndSet(true)) {
            throw new IllegalStateException("Application launch must not be called more than once");
        }
        if (!Application.class.isAssignableFrom(appClass)) {
            throw new IllegalArgumentException("Error: " + appClass.getName() + " is not a subclass of javafx.application.Application");
        }
        if (preloaderClass != null && !Preloader.class.isAssignableFrom(preloaderClass)) {
            throw new IllegalArgumentException("Error: " + preloaderClass.getName() + " is not a subclass of javafx.application.Preloader");
        }
        CountDownLatch launchLatch = new CountDownLatch(1);
        Thread launcherThread = new Thread(() -> {
            try {
                LauncherImpl.launchApplication1(appClass, preloaderClass, args);
            }
            catch (RuntimeException rte) {
                launchException = rte;
            }
            catch (Exception ex) {
                launchException = new RuntimeException("Application launch exception", ex);
            }
            catch (Error err) {
                launchException = new RuntimeException("Application launch error", err);
            }
            finally {
                launchLatch.countDown();
            }
        });
        launcherThread.setName("JavaFX-Launcher");
        launcherThread.start();
        try {
            launchLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Unexpected exception: ", ex);
        }
        if (launchException != null) {
            throw launchException;
        }
    }

    public static void launchApplication(String launchName, String launchMode, String[] args) {
        if (verbose) {
            System.err.println("JavaFX launchApplication method: launchMode=" + launchMode);
        }
        String mainClassName = null;
        String preloaderClassName = null;
        String[] appArgs = args;
        ClassLoader appLoader = null;
        ModuleAccess mainModule = null;
        if (launchMode.equals(LAUNCH_MODE_JAR)) {
            String fxClassPath;
            Attributes jarAttrs = LauncherImpl.getJarAttributes(launchName);
            if (jarAttrs == null) {
                LauncherImpl.abort(null, "Can't get manifest attributes from jar", new Object[0]);
            }
            if ((fxClassPath = jarAttrs.getValue(MF_JAVAFX_CLASS_PATH)) != null) {
                if (fxClassPath.trim().length() == 0) {
                    fxClassPath = null;
                } else {
                    if (verbose) {
                        System.err.println("WARNING: Application jar uses deprecated JavaFX-Class-Path attribute. Please use Class-Path instead.");
                    }
                    appLoader = LauncherImpl.setupJavaFXClassLoader(new File(launchName), fxClassPath);
                }
            }
            if (args.length == 0) {
                appArgs = LauncherImpl.getAppArguments(jarAttrs);
            }
            if ((mainClassName = jarAttrs.getValue(MF_JAVAFX_MAIN)) == null && (mainClassName = jarAttrs.getValue(MF_MAIN_CLASS)) == null) {
                LauncherImpl.abort(null, "JavaFX jar manifest requires a valid JavaFX-Appliation-Class or Main-Class entry", new Object[0]);
            }
            mainClassName = mainClassName.trim();
            preloaderClassName = jarAttrs.getValue(MF_JAVAFX_PRELOADER);
            if (preloaderClassName != null) {
                preloaderClassName = preloaderClassName.trim();
            }
        } else if (launchMode.equals(LAUNCH_MODE_CLASS)) {
            mainClassName = launchName;
        } else if (launchMode.equals(LAUNCH_MODE_MODULE)) {
            String moduleName;
            int i = launchName.indexOf(47);
            if (i == -1) {
                moduleName = launchName;
                mainClassName = null;
            } else {
                moduleName = launchName.substring(0, i);
                mainClassName = launchName.substring(i + 1);
            }
            mainModule = ModuleAccess.load(moduleName);
            if (mainClassName == null) {
                Optional<String> omc = mainModule.getDescriptor().mainClass();
                if (!omc.isPresent()) {
                    LauncherImpl.abort(null, "Module %1$s does not have a MainClass attribute, use -m <module>/<main-class>", moduleName);
                }
                mainClassName = omc.get();
            }
        } else {
            LauncherImpl.abort(new IllegalArgumentException("The launchMode argument must be one of LM_CLASS, LM_JAR or LM_MODULE"), "Invalid launch mode: %1$s", launchMode);
        }
        if (preloaderClassName == null) {
            preloaderClassName = System.getProperty("javafx.preloader");
        }
        if (mainClassName == null) {
            LauncherImpl.abort(null, "No main JavaFX class to launch", new Object[0]);
        }
        if (appLoader != null) {
            try {
                Class<?> launcherClass = appLoader.loadClass(LauncherImpl.class.getName());
                Method lawa = launcherClass.getMethod("launchApplicationWithArgs", ModuleAccess.class, String.class, String.class, new String[0].getClass());
                Thread.currentThread().setContextClassLoader(appLoader);
                lawa.invoke(null, null, mainClassName, preloaderClassName, appArgs);
            }
            catch (Exception e) {
                LauncherImpl.abort(e, "Exception while launching application", new Object[0]);
            }
        } else {
            LauncherImpl.launchApplicationWithArgs(mainModule, mainClassName, preloaderClassName, appArgs);
        }
    }

    private static Class<?> loadClass(ModuleAccess mainModule, String className) {
        Class<?> clz = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (mainModule != null) {
            clz = mainModule.classForName(className);
        } else {
            try {
                clz = Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        if (clz == null && System.getProperty("os.name", "").contains("OS X") && Normalizer.isNormalized(className, Normalizer.Form.NFD)) {
            String cn = Normalizer.normalize(className, Normalizer.Form.NFC);
            if (mainModule != null) {
                clz = mainModule.classForName(cn);
            } else {
                try {
                    clz = Class.forName(cn, true, loader);
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                    // empty catch block
                }
            }
        }
        return clz;
    }

    public static void launchApplicationWithArgs(ModuleAccess mainModule, String mainClassName, String preloaderClassName, String[] args) {
        try {
            LauncherImpl.startToolkit();
        }
        catch (InterruptedException ex) {
            LauncherImpl.abort(ex, "Toolkit initialization error", mainClassName);
        }
        Class preClass = null;
        Class tempAppClass = null;
        AtomicReference tmpClassRef = new AtomicReference();
        AtomicReference preClassRef = new AtomicReference();
        PlatformImpl.runAndWait(() -> {
            Class<?> clz = LauncherImpl.loadClass(mainModule, mainClassName);
            if (clz == null) {
                if (mainModule != null) {
                    LauncherImpl.abort(null, "Missing JavaFX application class %1$s in module %2$s", mainClassName, mainModule.getName());
                } else {
                    LauncherImpl.abort(null, "Missing JavaFX application class %1$s", mainClassName);
                }
            }
            tmpClassRef.set(clz);
            if (preloaderClassName != null) {
                clz = LauncherImpl.loadClass(null, preloaderClassName);
                if (clz == null) {
                    LauncherImpl.abort(null, "Missing JavaFX preloader class %1$s", preloaderClassName);
                }
                if (!Preloader.class.isAssignableFrom(clz)) {
                    LauncherImpl.abort(null, "JavaFX preloader class %1$s does not extend javafx.application.Preloader", clz.getName());
                }
                preClassRef.set(clz.asSubclass(Preloader.class));
            }
        });
        preClass = (Class)preClassRef.get();
        tempAppClass = (Class)tmpClassRef.get();
        savedPreloaderClass = preClass;
        ReflectiveOperationException theEx = null;
        try {
            Method mainMethod = tempAppClass.getMethod("main", new String[0].getClass());
            if (verbose) {
                System.err.println("Calling main(String[]) method");
            }
            savedMainCcl = Thread.currentThread().getContextClassLoader();
            mainMethod.invoke(null, new Object[]{args});
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            theEx = ex;
            savedPreloaderClass = null;
            if (verbose) {
                System.err.println("WARNING: Cannot access application main method: " + ex);
            }
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            LauncherImpl.abort(null, "Exception running application %1$s", tempAppClass.getName());
            return;
        }
        if (!Application.class.isAssignableFrom(tempAppClass)) {
            LauncherImpl.abort(theEx, "JavaFX application class %1$s does not extend javafx.application.Application", tempAppClass.getName());
        }
        Class<Application> appClass = tempAppClass.asSubclass(Application.class);
        if (verbose) {
            System.err.println("Launching application directly");
        }
        LauncherImpl.launchApplication(appClass, preClass, args);
    }

    private static URL fileToURL(File file) throws IOException {
        return file.getCanonicalFile().toURI().toURL();
    }

    private static ClassLoader setupJavaFXClassLoader(File appJar, String fxClassPath) {
        try {
            File baseDir = appJar.getParentFile();
            ArrayList<URL> jcpList = new ArrayList<URL>();
            String cp = fxClassPath;
            if (cp != null) {
                while (cp.length() > 0) {
                    File f;
                    String pathElem;
                    int pathSepIdx = cp.indexOf(" ");
                    if (pathSepIdx < 0) {
                        pathElem = cp;
                        File file = f = baseDir == null ? new File(pathElem) : new File(baseDir, pathElem);
                        if (f.exists()) {
                            jcpList.add(LauncherImpl.fileToURL(f));
                            break;
                        }
                        if (!verbose) break;
                        System.err.println("Class Path entry \"" + pathElem + "\" does not exist, ignoring");
                        break;
                    }
                    if (pathSepIdx > 0) {
                        pathElem = cp.substring(0, pathSepIdx);
                        File file = f = baseDir == null ? new File(pathElem) : new File(baseDir, pathElem);
                        if (f.exists()) {
                            jcpList.add(LauncherImpl.fileToURL(f));
                        } else if (verbose) {
                            System.err.println("Class Path entry \"" + pathElem + "\" does not exist, ignoring");
                        }
                    }
                    cp = cp.substring(pathSepIdx + 1);
                }
            }
            if (!jcpList.isEmpty()) {
                ArrayList<URL> urlList = new ArrayList<URL>();
                cp = System.getProperty("java.class.path");
                if (cp != null) {
                    while (cp.length() > 0) {
                        String pathElem;
                        int pathSepIdx = cp.indexOf(File.pathSeparatorChar);
                        if (pathSepIdx < 0) {
                            pathElem = cp;
                            urlList.add(LauncherImpl.fileToURL(new File(pathElem)));
                            break;
                        }
                        if (pathSepIdx > 0) {
                            pathElem = cp.substring(0, pathSepIdx);
                            urlList.add(LauncherImpl.fileToURL(new File(pathElem)));
                        }
                        cp = cp.substring(pathSepIdx + 1);
                    }
                }
                urlList.addAll(jcpList);
                URL[] urls = urlList.toArray(new URL[0]);
                if (verbose) {
                    System.err.println("===== URL list");
                    for (int i = 0; i < urls.length; ++i) {
                        System.err.println("" + urls[i]);
                    }
                    System.err.println("=====");
                }
                return new URLClassLoader(urls, ClassLoader.getPlatformClassLoader());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String decodeBase64(String inp) throws IOException {
        return new String(Base64.getDecoder().decode(inp));
    }

    private static String[] getAppArguments(Attributes attrs) {
        LinkedList<Object> args = new LinkedList<Object>();
        try {
            int idx = 1;
            String argNamePrefix = MF_JAVAFX_ARGUMENT_PREFIX;
            while (attrs.getValue(argNamePrefix + idx) != null) {
                args.add(LauncherImpl.decodeBase64(attrs.getValue(argNamePrefix + idx)));
                ++idx;
            }
            String paramNamePrefix = MF_JAVAFX_PARAMETER_NAME_PREFIX;
            String paramValuePrefix = MF_JAVAFX_PARAMETER_VALUE_PREFIX;
            idx = 1;
            while (attrs.getValue(paramNamePrefix + idx) != null) {
                String k = LauncherImpl.decodeBase64(attrs.getValue(paramNamePrefix + idx));
                String v = null;
                if (attrs.getValue(paramValuePrefix + idx) != null) {
                    v = LauncherImpl.decodeBase64(attrs.getValue(paramValuePrefix + idx));
                }
                args.add("--" + k + "=" + (v != null ? v : ""));
                ++idx;
            }
        }
        catch (IOException ioe) {
            if (verbose) {
                System.err.println("Failed to extract application parameters");
            }
            ioe.printStackTrace();
        }
        return args.toArray(new String[0]);
    }

    private static void abort(Throwable cause, String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        if (msg != null) {
            System.err.println(msg);
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes getJarAttributes(String jarPath) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarPath);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                LauncherImpl.abort(null, "No manifest in jar file %1$s", jarPath);
            }
            Attributes attributes = manifest.getMainAttributes();
            return attributes;
        }
        catch (IOException ioe) {
            LauncherImpl.abort(ioe, "Error launching jar file %1%s", jarPath);
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static void startToolkit() throws InterruptedException {
        if (toolkitStarted.getAndSet(true)) {
            return;
        }
        CountDownLatch startupLatch = new CountDownLatch(1);
        PlatformImpl.startup(() -> startupLatch.countDown());
        startupLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchApplication1(Class<? extends Application> appClass, Class<? extends Preloader> preloaderClass, String[] args) throws Exception {
        ClassLoader ccl;
        LauncherImpl.startToolkit();
        if (savedMainCcl != null && (ccl = Thread.currentThread().getContextClassLoader()) != null && ccl != savedMainCcl) {
            PlatformImpl.runLater(() -> Thread.currentThread().setContextClassLoader(ccl));
        }
        final AtomicBoolean pStartCalled = new AtomicBoolean(false);
        final AtomicBoolean startCalled = new AtomicBoolean(false);
        final AtomicBoolean exitCalled = new AtomicBoolean(false);
        AtomicBoolean pExitCalled = new AtomicBoolean(false);
        final CountDownLatch shutdownLatch = new CountDownLatch(1);
        final CountDownLatch pShutdownLatch = new CountDownLatch(1);
        PlatformImpl.FinishListener listener = new PlatformImpl.FinishListener(){

            @Override
            public void idle(boolean implicitExit) {
                if (!implicitExit) {
                    return;
                }
                if (startCalled.get()) {
                    shutdownLatch.countDown();
                } else if (pStartCalled.get()) {
                    pShutdownLatch.countDown();
                }
            }

            @Override
            public void exitCalled() {
                exitCalled.set(true);
                shutdownLatch.countDown();
            }
        };
        PlatformImpl.addListener(listener);
        try {
            AtomicReference pldr = new AtomicReference();
            if (preloaderClass != null) {
                PlatformImpl.runAndWait(() -> {
                    try {
                        Constructor c = preloaderClass.getConstructor(new Class[0]);
                        pldr.set((Preloader)c.newInstance(new Object[0]));
                        ParametersImpl.registerParameters((Application)pldr.get(), new ParametersImpl(args));
                    }
                    catch (Throwable t) {
                        System.err.println("Exception in Preloader constructor");
                        pConstructorError = t;
                        error = true;
                    }
                });
            }
            if ((currentPreloader = (Preloader)pldr.get()) != null && !error && !exitCalled.get()) {
                try {
                    currentPreloader.init();
                }
                catch (Throwable t) {
                    System.err.println("Exception in Preloader init method");
                    pInitError = t;
                    error = true;
                }
            }
            if (currentPreloader != null && !error && !exitCalled.get()) {
                PlatformImpl.runAndWait(() -> {
                    try {
                        pStartCalled.set(true);
                        Stage primaryStage = new Stage();
                        StageHelper.setPrimary(primaryStage, true);
                        currentPreloader.start(primaryStage);
                    }
                    catch (Throwable t) {
                        System.err.println("Exception in Preloader start method");
                        pStartError = t;
                        error = true;
                    }
                });
                if (!error && !exitCalled.get()) {
                    LauncherImpl.notifyProgress(currentPreloader, 0.0);
                }
            }
            AtomicReference app = new AtomicReference();
            if (!error && !exitCalled.get()) {
                if (currentPreloader != null) {
                    LauncherImpl.notifyProgress(currentPreloader, 1.0);
                    LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_LOAD, null);
                }
                PlatformImpl.runAndWait(() -> {
                    try {
                        Constructor c = appClass.getConstructor(new Class[0]);
                        app.set((Application)c.newInstance(new Object[0]));
                        ParametersImpl.registerParameters((Application)app.get(), new ParametersImpl(args));
                        PlatformImpl.setApplicationName(appClass);
                    }
                    catch (Throwable t) {
                        System.err.println("Exception in Application constructor");
                        constructorError = t;
                        error = true;
                    }
                });
            }
            Application theApp = (Application)app.get();
            if (!error && !exitCalled.get()) {
                if (currentPreloader != null) {
                    LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_INIT, theApp);
                }
                try {
                    theApp.init();
                }
                catch (Throwable t) {
                    System.err.println("Exception in Application init method");
                    initError = t;
                    error = true;
                }
            }
            if (!error && !exitCalled.get()) {
                if (currentPreloader != null) {
                    LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_START, theApp);
                }
                PlatformImpl.runAndWait(() -> {
                    try {
                        startCalled.set(true);
                        Stage primaryStage = new Stage();
                        StageHelper.setPrimary(primaryStage, true);
                        theApp.start(primaryStage);
                    }
                    catch (Throwable t) {
                        System.err.println("Exception in Application start method");
                        startError = t;
                        error = true;
                    }
                });
            }
            if (!error) {
                shutdownLatch.await();
            }
            if (startCalled.get()) {
                PlatformImpl.runAndWait(() -> {
                    try {
                        theApp.stop();
                    }
                    catch (Throwable t) {
                        System.err.println("Exception in Application stop method");
                        stopError = t;
                        error = true;
                    }
                });
            }
            if (error) {
                String msg;
                if (pConstructorError != null) {
                    throw new RuntimeException("Unable to construct Preloader instance: " + appClass, pConstructorError);
                }
                if (pInitError != null) {
                    throw new RuntimeException("Exception in Preloader init method", pInitError);
                }
                if (pStartError != null) {
                    throw new RuntimeException("Exception in Preloader start method", pStartError);
                }
                if (pStopError != null) {
                    throw new RuntimeException("Exception in Preloader stop method", pStopError);
                }
                if (constructorError != null) {
                    String msg2 = "Unable to construct Application instance: " + appClass;
                    if (!LauncherImpl.notifyError(msg2, constructorError)) {
                        throw new RuntimeException(msg2, constructorError);
                    }
                } else if (initError != null) {
                    String msg3 = "Exception in Application init method";
                    if (!LauncherImpl.notifyError(msg3, initError)) {
                        throw new RuntimeException(msg3, initError);
                    }
                } else if (startError != null) {
                    String msg4 = "Exception in Application start method";
                    if (!LauncherImpl.notifyError(msg4, startError)) {
                        throw new RuntimeException(msg4, startError);
                    }
                } else if (stopError != null && !LauncherImpl.notifyError(msg = "Exception in Application stop method", stopError)) {
                    throw new RuntimeException(msg, stopError);
                }
            }
        }
        finally {
            PlatformImpl.removeListener(listener);
            PlatformImpl.tkExit();
        }
    }

    private static void notifyStateChange(Preloader preloader, Preloader.StateChangeNotification.Type type, Application app) {
        PlatformImpl.runAndWait(() -> preloader.handleStateChangeNotification(new Preloader.StateChangeNotification(type, app)));
    }

    private static void notifyProgress(Preloader preloader, double d) {
        PlatformImpl.runAndWait(() -> preloader.handleProgressNotification(new Preloader.ProgressNotification(d)));
    }

    private static boolean notifyError(String msg, Throwable constructorError) {
        AtomicBoolean result = new AtomicBoolean(false);
        PlatformImpl.runAndWait(() -> {
            if (currentPreloader != null) {
                try {
                    Preloader.ErrorNotification evt = new Preloader.ErrorNotification(null, msg, constructorError);
                    boolean rval = currentPreloader.handleErrorNotification(evt);
                    result.set(rval);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        return result.get();
    }

    private static void notifyCurrentPreloader(Preloader.PreloaderNotification pe) {
        PlatformImpl.runAndWait(() -> {
            if (currentPreloader != null) {
                currentPreloader.handleApplicationNotification(pe);
            }
        });
    }

    public static void notifyPreloader(Application app, Preloader.PreloaderNotification info) {
        if (launchCalled.get()) {
            LauncherImpl.notifyCurrentPreloader(info);
            return;
        }
    }

    private LauncherImpl() {
        throw new InternalError();
    }

    static {
        launchCalled = new AtomicBoolean(false);
        toolkitStarted = new AtomicBoolean(false);
        launchException = null;
        currentPreloader = null;
        savedPreloaderClass = null;
        savedMainCcl = null;
        verbose = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.verbose"));
        error = false;
        pConstructorError = null;
        pInitError = null;
        pStartError = null;
        pStopError = null;
        constructorError = null;
        initError = null;
        startError = null;
        stopError = null;
    }
}

