/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.css.ParsedValue;
import javafx.css.Size;
import javafx.css.SizeUnits;
import javafx.css.StyleConverter;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class ParsedValueImpl<V, T>
extends ParsedValue<V, T> {
    private final boolean lookup;
    private final boolean containsLookups;
    private static int indent = 0;
    private int hash = Integer.MIN_VALUE;
    private static final byte NULL_VALUE = 0;
    private static final byte VALUE = 1;
    private static final byte VALUE_ARRAY = 2;
    private static final byte ARRAY_OF_VALUE_ARRAY = 3;
    private static final byte STRING = 4;
    private static final byte COLOR = 5;
    private static final byte ENUM = 6;
    private static final byte BOOLEAN = 7;
    private static final byte URL = 8;
    private static final byte SIZE = 9;

    @Override
    public final boolean isLookup() {
        return this.lookup;
    }

    @Override
    public final boolean isContainsLookups() {
        return this.containsLookups;
    }

    private static boolean getContainsLookupsFlag(Object obj) {
        boolean containsLookupsFlag;
        block4: {
            block6: {
                block5: {
                    block3: {
                        containsLookupsFlag = false;
                        if (!(obj instanceof Size)) break block3;
                        containsLookupsFlag = false;
                        break block4;
                    }
                    if (!(obj instanceof ParsedValueImpl)) break block5;
                    ParsedValueImpl value = (ParsedValueImpl)obj;
                    containsLookupsFlag = value.lookup || value.containsLookups;
                    break block4;
                }
                if (!(obj instanceof ParsedValueImpl[])) break block6;
                ParsedValueImpl[] values = (ParsedValueImpl[])obj;
                for (int v = 0; v < values.length && !containsLookupsFlag; ++v) {
                    if (values[v] == null) continue;
                    containsLookupsFlag = containsLookupsFlag || values[v].lookup || values[v].containsLookups;
                }
                break block4;
            }
            if (!(obj instanceof ParsedValueImpl[][])) break block4;
            ParsedValueImpl[][] values = (ParsedValueImpl[][])obj;
            for (int l = 0; l < values.length && !containsLookupsFlag; ++l) {
                if (values[l] == null) continue;
                for (int v = 0; v < values[l].length && !containsLookupsFlag; ++v) {
                    if (values[l][v] == null) continue;
                    containsLookupsFlag = containsLookupsFlag || values[l][v].lookup || values[l][v].containsLookups;
                }
            }
        }
        return containsLookupsFlag;
    }

    public static boolean containsFontRelativeSize(ParsedValue parsedValue, boolean percentUnitsAreRelative) {
        boolean needsFont;
        block4: {
            Object obj;
            block6: {
                block5: {
                    block3: {
                        needsFont = false;
                        obj = parsedValue.getValue();
                        if (!(obj instanceof Size)) break block3;
                        Size size = (Size)obj;
                        needsFont = size.getUnits() == SizeUnits.PERCENT ? percentUnitsAreRelative : !size.isAbsolute();
                        break block4;
                    }
                    if (!(obj instanceof ParsedValue)) break block5;
                    ParsedValueImpl value = (ParsedValueImpl)obj;
                    needsFont = ParsedValueImpl.containsFontRelativeSize(value, percentUnitsAreRelative);
                    break block4;
                }
                if (!(obj instanceof ParsedValue[])) break block6;
                ParsedValue[] values = (ParsedValue[])obj;
                for (int v = 0; v < values.length && !needsFont; ++v) {
                    if (values[v] == null) continue;
                    needsFont = ParsedValueImpl.containsFontRelativeSize(values[v], percentUnitsAreRelative);
                }
                break block4;
            }
            if (!(obj instanceof ParsedValueImpl[][])) break block4;
            ParsedValueImpl[][] values = (ParsedValueImpl[][])obj;
            for (int l = 0; l < values.length && !needsFont; ++l) {
                if (values[l] == null) continue;
                for (int v = 0; v < values[l].length && !needsFont; ++v) {
                    if (values[l][v] == null) continue;
                    needsFont = ParsedValueImpl.containsFontRelativeSize(values[l][v], percentUnitsAreRelative);
                }
            }
        }
        return needsFont;
    }

    public ParsedValueImpl(V value, StyleConverter<V, T> converter, boolean lookup) {
        super(value, converter);
        this.lookup = lookup;
        this.containsLookups = lookup || ParsedValueImpl.getContainsLookupsFlag(value);
    }

    public ParsedValueImpl(V value, StyleConverter<V, T> type) {
        this(value, type, false);
    }

    @Override
    public T convert(Font font) {
        return (T)(this.converter != null ? this.converter.convert(this, font) : this.value);
    }

    private static String spaces() {
        return new String(new char[indent]).replace('\u0000', ' ');
    }

    private static void indent() {
        indent += 2;
    }

    private static void outdent() {
        indent = Math.max(0, indent - 2);
    }

    public String toString() {
        String newline = System.lineSeparator();
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(ParsedValueImpl.spaces()).append(this.lookup ? "<Value lookup=\"true\">" : "<Value>").append(newline);
        ParsedValueImpl.indent();
        if (this.value != null) {
            this.appendValue(sbuf, this.value, "value");
        } else {
            this.appendValue(sbuf, "null", "value");
        }
        sbuf.append(ParsedValueImpl.spaces()).append("<converter>").append(this.converter).append("</converter>").append(newline);
        ParsedValueImpl.outdent();
        sbuf.append(ParsedValueImpl.spaces()).append("</Value>");
        return sbuf.toString();
    }

    private void appendValue(StringBuilder sbuf, Object value, String tag) {
        String newline = System.lineSeparator();
        if (value instanceof ParsedValueImpl[][]) {
            ParsedValueImpl[][] layers = (ParsedValueImpl[][])value;
            sbuf.append(ParsedValueImpl.spaces()).append('<').append(tag).append(" layers=\"").append(layers.length).append("\">").append(newline);
            ParsedValueImpl.indent();
            for (ParsedValueImpl[] layer : layers) {
                sbuf.append(ParsedValueImpl.spaces()).append("<layer>").append(newline);
                ParsedValueImpl.indent();
                if (layer == null) {
                    sbuf.append(ParsedValueImpl.spaces()).append("null").append(newline);
                    continue;
                }
                for (ParsedValueImpl val : layer) {
                    if (val == null) {
                        sbuf.append(ParsedValueImpl.spaces()).append("null").append(newline);
                        continue;
                    }
                    sbuf.append(val);
                }
                ParsedValueImpl.outdent();
                sbuf.append(ParsedValueImpl.spaces()).append("</layer>").append(newline);
            }
            ParsedValueImpl.outdent();
            sbuf.append(ParsedValueImpl.spaces()).append("</").append(tag).append('>').append(newline);
        } else if (value instanceof ParsedValueImpl[]) {
            ParsedValueImpl[] values = (ParsedValueImpl[])value;
            sbuf.append(ParsedValueImpl.spaces()).append('<').append(tag).append(" values=\"").append(values.length).append("\">").append(newline);
            ParsedValueImpl.indent();
            for (ParsedValueImpl val : values) {
                if (val == null) {
                    sbuf.append(ParsedValueImpl.spaces()).append("null").append(newline);
                    continue;
                }
                sbuf.append(val);
            }
            ParsedValueImpl.outdent();
            sbuf.append(ParsedValueImpl.spaces()).append("</").append(tag).append('>').append(newline);
        } else if (value instanceof ParsedValueImpl) {
            sbuf.append(ParsedValueImpl.spaces()).append('<').append(tag).append('>').append(newline);
            ParsedValueImpl.indent();
            sbuf.append(value);
            ParsedValueImpl.outdent();
            sbuf.append(ParsedValueImpl.spaces()).append("</").append(tag).append('>').append(newline);
        } else {
            sbuf.append(ParsedValueImpl.spaces()).append('<').append(tag).append('>');
            sbuf.append(value);
            sbuf.append("</").append(tag).append('>').append(newline);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ParsedValueImpl other = (ParsedValueImpl)obj;
        if (this.hash != other.hash) {
            return false;
        }
        if (this.value instanceof ParsedValueImpl[][]) {
            if (!(other.value instanceof ParsedValueImpl[][])) {
                return false;
            }
            ParsedValueImpl[][] thisValues = (ParsedValueImpl[][])this.value;
            ParsedValueImpl[][] otherValues = (ParsedValueImpl[][])other.value;
            if (thisValues.length != otherValues.length) {
                return false;
            }
            for (int i = 0; i < thisValues.length; ++i) {
                if (thisValues[i] == null && otherValues[i] == null) continue;
                if (thisValues[i] == null || otherValues[i] == null) {
                    return false;
                }
                if (thisValues[i].length != otherValues[i].length) {
                    return false;
                }
                for (int j = 0; j < thisValues[i].length; ++j) {
                    ParsedValueImpl thisValue = thisValues[i][j];
                    ParsedValueImpl otherValue = otherValues[i][j];
                    if (!(thisValue != null ? !thisValue.equals(otherValue) : otherValue != null)) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.value instanceof ParsedValueImpl[]) {
            if (!(other.value instanceof ParsedValueImpl[])) {
                return false;
            }
            ParsedValueImpl[] thisValues = (ParsedValueImpl[])this.value;
            ParsedValueImpl[] otherValues = (ParsedValueImpl[])other.value;
            if (thisValues.length != otherValues.length) {
                return false;
            }
            for (int i = 0; i < thisValues.length; ++i) {
                ParsedValueImpl thisValue = thisValues[i];
                ParsedValueImpl otherValue = otherValues[i];
                if (!(thisValue != null ? !thisValue.equals(otherValue) : otherValue != null)) continue;
                return false;
            }
            return true;
        }
        if (this.value instanceof String && other.value instanceof String) {
            return this.value.toString().equalsIgnoreCase(other.value.toString());
        }
        return this.value != null ? this.value.equals(other.value) : other.value == null;
    }

    public int hashCode() {
        if (this.hash == Integer.MIN_VALUE) {
            this.hash = 17;
            if (this.value instanceof ParsedValueImpl[][]) {
                ParsedValueImpl[][] values = (ParsedValueImpl[][])this.value;
                for (int i = 0; i < values.length; ++i) {
                    for (int j = 0; j < values[i].length; ++j) {
                        ParsedValueImpl val = values[i][j];
                        this.hash = 37 * this.hash + (val != null && val.value != null ? val.value.hashCode() : 0);
                    }
                }
            } else if (this.value instanceof ParsedValueImpl[]) {
                ParsedValueImpl[] values = (ParsedValueImpl[])this.value;
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null || values[i].value == null) continue;
                    ParsedValueImpl val = values[i];
                    this.hash = 37 * this.hash + (val != null && val.value != null ? val.value.hashCode() : 0);
                }
            } else {
                this.hash = 37 * this.hash + (this.value != null ? this.value.hashCode() : 0);
            }
        }
        return this.hash;
    }

    public final void writeBinary(DataOutputStream os, StyleConverter.StringStore stringStore) throws IOException {
        os.writeBoolean(this.lookup);
        if (this.converter != null) {
            os.writeBoolean(true);
            this.converter.writeBinary(os, stringStore);
        } else {
            os.writeBoolean(false);
        }
        if (this.value instanceof ParsedValue) {
            os.writeByte(1);
            ParsedValue pv = (ParsedValue)this.value;
            if (pv instanceof ParsedValueImpl) {
                ((ParsedValueImpl)pv).writeBinary(os, stringStore);
            } else {
                ParsedValueImpl impl = new ParsedValueImpl(pv.getValue(), pv.getConverter());
                impl.writeBinary(os, stringStore);
            }
        } else if (this.value instanceof ParsedValue[]) {
            os.writeByte(2);
            ParsedValue[] values = (ParsedValue[])this.value;
            if (values != null) {
                os.writeByte(1);
            } else {
                os.writeByte(0);
            }
            int nValues = values != null ? values.length : 0;
            os.writeInt(nValues);
            for (int v = 0; v < nValues; ++v) {
                if (values[v] != null) {
                    os.writeByte(1);
                    ParsedValue pv = values[v];
                    if (pv instanceof ParsedValueImpl) {
                        ((ParsedValueImpl)pv).writeBinary(os, stringStore);
                        continue;
                    }
                    ParsedValueImpl impl = new ParsedValueImpl(pv.getValue(), pv.getConverter());
                    impl.writeBinary(os, stringStore);
                    continue;
                }
                os.writeByte(0);
            }
        } else if (this.value instanceof ParsedValue[][]) {
            os.writeByte(3);
            ParsedValue[][] layers = (ParsedValue[][])this.value;
            if (layers != null) {
                os.writeByte(1);
            } else {
                os.writeByte(0);
            }
            int nLayers = layers != null ? layers.length : 0;
            os.writeInt(nLayers);
            for (int l = 0; l < nLayers; ++l) {
                ParsedValue[] values = layers[l];
                if (values != null) {
                    os.writeByte(1);
                } else {
                    os.writeByte(0);
                }
                int nValues = values != null ? values.length : 0;
                os.writeInt(nValues);
                for (int v = 0; v < nValues; ++v) {
                    if (values[v] != null) {
                        os.writeByte(1);
                        ParsedValue pv = values[v];
                        if (pv instanceof ParsedValueImpl) {
                            ((ParsedValueImpl)pv).writeBinary(os, stringStore);
                            continue;
                        }
                        ParsedValueImpl impl = new ParsedValueImpl(pv.getValue(), pv.getConverter());
                        impl.writeBinary(os, stringStore);
                        continue;
                    }
                    os.writeByte(0);
                }
            }
        } else if (this.value instanceof Color) {
            Color c = (Color)this.value;
            os.writeByte(5);
            os.writeLong(Double.doubleToLongBits(c.getRed()));
            os.writeLong(Double.doubleToLongBits(c.getGreen()));
            os.writeLong(Double.doubleToLongBits(c.getBlue()));
            os.writeLong(Double.doubleToLongBits(c.getOpacity()));
        } else if (this.value instanceof Enum) {
            Enum e = (Enum)this.value;
            int nameIndex = stringStore.addString(e.name());
            os.writeByte(6);
            os.writeShort(nameIndex);
        } else if (this.value instanceof Boolean) {
            Boolean b = (Boolean)this.value;
            os.writeByte(7);
            os.writeBoolean(b);
        } else if (this.value instanceof Size) {
            Size size = (Size)this.value;
            os.writeByte(9);
            double sz = size.getValue();
            long val = Double.doubleToLongBits(sz);
            os.writeLong(val);
            int index = stringStore.addString(size.getUnits().name());
            os.writeShort(index);
        } else if (this.value instanceof String) {
            os.writeByte(4);
            int index = stringStore.addString((String)this.value);
            os.writeShort(index);
        } else if (this.value instanceof URL) {
            os.writeByte(8);
            int index = stringStore.addString(this.value.toString());
            os.writeShort(index);
        } else if (this.value == null) {
            os.writeByte(0);
        } else {
            throw new InternalError("cannot writeBinary " + this);
        }
    }

    public static ParsedValueImpl readBinary(int bssVersion, DataInputStream is, String[] strings) throws IOException {
        boolean lookup = is.readBoolean();
        boolean hasType = is.readBoolean();
        StyleConverter<?, ?> converter = hasType ? StyleConverter.readBinary(is, strings) : null;
        byte valType = is.readByte();
        if (valType == 1) {
            ParsedValueImpl value = ParsedValueImpl.readBinary(bssVersion, is, strings);
            return new ParsedValueImpl(value, converter, lookup);
        }
        if (valType == 2) {
            int nVals;
            if (bssVersion >= 4) {
                is.readByte();
            }
            ParsedValueImpl[] values = (nVals = is.readInt()) > 0 ? new ParsedValueImpl[nVals] : null;
            for (int v = 0; v < nVals; ++v) {
                byte vtype = is.readByte();
                values[v] = vtype == 1 ? ParsedValueImpl.readBinary(bssVersion, is, strings) : null;
            }
            return new ParsedValueImpl(values, converter, lookup);
        }
        if (valType == 3) {
            int nLayers;
            if (bssVersion >= 4) {
                is.readByte();
            }
            ParsedValueImpl[][] layers = (nLayers = is.readInt()) > 0 ? new ParsedValueImpl[nLayers][0] : null;
            for (int l = 0; l < nLayers; ++l) {
                int nVals;
                if (bssVersion >= 4) {
                    is.readByte();
                }
                layers[l] = (nVals = is.readInt()) > 0 ? new ParsedValueImpl[nVals] : null;
                for (int v = 0; v < nVals; ++v) {
                    byte vtype = is.readByte();
                    layers[l][v] = vtype == 1 ? ParsedValueImpl.readBinary(bssVersion, is, strings) : null;
                }
            }
            return new ParsedValueImpl(layers, converter, lookup);
        }
        if (valType == 5) {
            double r = Double.longBitsToDouble(is.readLong());
            double g = Double.longBitsToDouble(is.readLong());
            double b = Double.longBitsToDouble(is.readLong());
            double a = Double.longBitsToDouble(is.readLong());
            return new ParsedValueImpl(Color.color(r, g, b, a), converter, lookup);
        }
        if (valType == 6) {
            short bad;
            short nameIndex = is.readShort();
            String ename = strings[nameIndex];
            if (bssVersion == 2 && (bad = is.readShort()) >= strings.length) {
                throw new IllegalArgumentException("bad version " + bssVersion);
            }
            ParsedValueImpl value = new ParsedValueImpl(ename, converter, lookup);
            return value;
        }
        if (valType == 7) {
            Boolean b = is.readBoolean();
            return new ParsedValueImpl(b, converter, lookup);
        }
        if (valType == 9) {
            double val = Double.longBitsToDouble(is.readLong());
            SizeUnits units = SizeUnits.PX;
            String unitStr = strings[is.readShort()];
            try {
                units = Enum.valueOf(SizeUnits.class, unitStr);
            }
            catch (IllegalArgumentException iae) {
                System.err.println(iae.toString());
            }
            catch (NullPointerException npe) {
                System.err.println(npe.toString());
            }
            return new ParsedValueImpl(new Size(val, units), converter, lookup);
        }
        if (valType == 4) {
            String str = strings[is.readShort()];
            return new ParsedValueImpl(str, converter, lookup);
        }
        if (valType == 8) {
            String str = strings[is.readShort()];
            try {
                URL url = new URL(str);
                return new ParsedValueImpl(url, converter, lookup);
            }
            catch (MalformedURLException malf) {
                throw new InternalError("Exception in Value.readBinary: " + malf);
            }
        }
        if (valType == 0) {
            return new ParsedValueImpl(null, converter, lookup);
        }
        throw new InternalError("unknown type: " + valType);
    }
}

