/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.BitSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.css.StyleClass;

public final class StyleClassSet
extends BitSet<StyleClass> {
    static final Map<String, Integer> styleClassMap = new HashMap<String, Integer>(64);
    static final List<StyleClass> styleClasses = new ArrayList<StyleClass>();

    public StyleClassSet() {
    }

    StyleClassSet(List<String> styleClassNames) {
        int nMax = styleClassNames != null ? styleClassNames.size() : 0;
        for (int n = 0; n < nMax; ++n) {
            String styleClass = styleClassNames.get(n);
            if (styleClass == null || styleClass.isEmpty()) continue;
            StyleClass sc = StyleClassSet.getStyleClass(styleClass);
            this.add(sc);
        }
    }

    public Object[] toArray() {
        return this.toArray(new StyleClass[this.size()]);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.size()) {
            a = new StyleClass[this.size()];
        }
        int index = 0;
        while (index < this.getBits().length) {
            long state = this.getBits()[index];
            for (int bit = 0; bit < 64; ++bit) {
                long mask = 1L << bit;
                if ((state & mask) != mask) continue;
                int n = index * 64 + bit;
                StyleClass impl = StyleClassSet.getStyleClass(n);
                a[index++] = impl;
            }
        }
        return a;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("style-classes: [");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            builder.append(((StyleClass)iter.next()).getStyleClassName());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    protected StyleClass cast(Object o) {
        if (o == null) {
            throw new NullPointerException("null arg");
        }
        StyleClass styleClass = (StyleClass)o;
        return styleClass;
    }

    @Override
    protected StyleClass getT(int index) {
        return StyleClassSet.getStyleClass(index);
    }

    @Override
    protected int getIndex(StyleClass t) {
        return t.getIndex();
    }

    public static StyleClass getStyleClass(String styleClass) {
        if (styleClass == null || styleClass.trim().isEmpty()) {
            throw new IllegalArgumentException("styleClass cannot be null or empty String");
        }
        StyleClass instance = null;
        Integer value = styleClassMap.get(styleClass);
        int index = value != null ? value : -1;
        int size = styleClasses.size();
        assert (index < size);
        if (index != -1 && index < size) {
            instance = styleClasses.get(index);
        }
        if (instance == null) {
            instance = new StyleClass(styleClass, size);
            styleClasses.add(instance);
            styleClassMap.put(styleClass, size);
        }
        return instance;
    }

    static StyleClass getStyleClass(int index) {
        if (0 <= index && index < styleClasses.size()) {
            return styleClasses.get(index);
        }
        return null;
    }
}

