/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.parser;

import com.sun.javafx.css.parser.Recognizer;

public class LexerState {
    private final int type;
    private final String name;
    private final Recognizer[] recognizers;

    public boolean accepts(int c) {
        int nRecognizers = this.recognizers != null ? this.recognizers.length : 0;
        for (int n = 0; n < nRecognizers; ++n) {
            if (!this.recognizers[n].recognize(c)) continue;
            return true;
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public LexerState(int type, String name, Recognizer recognizer, Recognizer ... others) {
        assert (name != null);
        this.type = type;
        this.name = name;
        if (recognizer != null) {
            int nRecognizers = 1 + (others != null ? others.length : 0);
            this.recognizers = new Recognizer[nRecognizers];
            this.recognizers[0] = recognizer;
            for (int n = 1; n < this.recognizers.length; ++n) {
                this.recognizers[n] = others[n - 1];
            }
        } else {
            this.recognizers = null;
        }
    }

    public LexerState(String name, Recognizer recognizer, Recognizer ... others) {
        this(0, name, recognizer, others);
    }

    private LexerState() {
        this(0, "invalid", null, new Recognizer[0]);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LexerState ? this.name.equals(((LexerState)other).name) : false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

