/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Curve;
import com.sun.javafx.geom.Order2;
import com.sun.javafx.geom.RectBounds;
import java.util.Vector;

final class Order3
extends Curve {
    private double x0;
    private double y0;
    private double cx0;
    private double cy0;
    private double cx1;
    private double cy1;
    private double x1;
    private double y1;
    private double xmin;
    private double xmax;
    private double xcoeff0;
    private double xcoeff1;
    private double xcoeff2;
    private double xcoeff3;
    private double ycoeff0;
    private double ycoeff1;
    private double ycoeff2;
    private double ycoeff3;
    private double TforY1;
    private double YforT1;
    private double TforY2;
    private double YforT2;
    private double TforY3;
    private double YforT3;

    public static void insert(Vector curves, double[] tmp, double x0, double y0, double cx0, double cy0, double cx1, double cy1, double x1, double y1, int direction) {
        int numparams = Order3.getHorizontalParams(y0, cy0, cy1, y1, tmp);
        if (numparams == 0) {
            Order3.addInstance(curves, x0, y0, cx0, cy0, cx1, cy1, x1, y1, direction);
            return;
        }
        tmp[3] = x0;
        tmp[4] = y0;
        tmp[5] = cx0;
        tmp[6] = cy0;
        tmp[7] = cx1;
        tmp[8] = cy1;
        tmp[9] = x1;
        tmp[10] = y1;
        double t = tmp[0];
        if (numparams > 1 && t > tmp[1]) {
            tmp[0] = tmp[1];
            tmp[1] = t;
            t = tmp[0];
        }
        Order3.split(tmp, 3, t);
        if (numparams > 1) {
            t = (tmp[1] - t) / (1.0 - t);
            Order3.split(tmp, 9, t);
        }
        int index = 3;
        if (direction == -1) {
            index += numparams * 6;
        }
        while (numparams >= 0) {
            Order3.addInstance(curves, tmp[index + 0], tmp[index + 1], tmp[index + 2], tmp[index + 3], tmp[index + 4], tmp[index + 5], tmp[index + 6], tmp[index + 7], direction);
            --numparams;
            if (direction == 1) {
                index += 6;
                continue;
            }
            index -= 6;
        }
    }

    public static void addInstance(Vector curves, double x0, double y0, double cx0, double cy0, double cx1, double cy1, double x1, double y1, int direction) {
        if (y0 > y1) {
            curves.add(new Order3(x1, y1, cx1, cy1, cx0, cy0, x0, y0, -direction));
        } else if (y1 > y0) {
            curves.add(new Order3(x0, y0, cx0, cy0, cx1, cy1, x1, y1, direction));
        }
    }

    public static int solveQuadratic(double[] eqn, double[] res) {
        double a = eqn[2];
        double b = eqn[1];
        double c = eqn[0];
        int roots = 0;
        if (a == 0.0) {
            if (b == 0.0) {
                return -1;
            }
            res[roots++] = -c / b;
        } else {
            double d = b * b - 4.0 * a * c;
            if (d < 0.0) {
                return 0;
            }
            d = Math.sqrt(d);
            if (b < 0.0) {
                d = -d;
            }
            double q = (b + d) / -2.0;
            res[roots++] = q / a;
            if (q != 0.0) {
                res[roots++] = c / q;
            }
        }
        return roots;
    }

    public static int getHorizontalParams(double c0, double cp0, double cp1, double c1, double[] ret) {
        if (c0 <= cp0 && cp0 <= cp1 && cp1 <= c1) {
            return 0;
        }
        c1 -= cp1;
        cp1 -= cp0;
        ret[0] = cp0 -= c0;
        ret[1] = (cp1 - cp0) * 2.0;
        ret[2] = c1 - cp1 - cp1 + cp0;
        int numroots = Order3.solveQuadratic(ret, ret);
        int j = 0;
        for (int i = 0; i < numroots; ++i) {
            double t = ret[i];
            if (!(t > 0.0) || !(t < 1.0)) continue;
            if (j < i) {
                ret[j] = t;
            }
            ++j;
        }
        return j;
    }

    public static void split(double[] coords, int pos, double t) {
        double y1;
        double x1;
        coords[pos + 12] = x1 = coords[pos + 6];
        coords[pos + 13] = y1 = coords[pos + 7];
        double cx1 = coords[pos + 4];
        double cy1 = coords[pos + 5];
        x1 = cx1 + (x1 - cx1) * t;
        y1 = cy1 + (y1 - cy1) * t;
        double x0 = coords[pos + 0];
        double y0 = coords[pos + 1];
        double cx0 = coords[pos + 2];
        double cy0 = coords[pos + 3];
        x0 += (cx0 - x0) * t;
        y0 += (cy0 - y0) * t;
        cx0 += (cx1 - cx0) * t;
        cy0 += (cy1 - cy0) * t;
        cx1 = cx0 + (x1 - cx0) * t;
        cy1 = cy0 + (y1 - cy0) * t;
        cx0 = x0 + (cx0 - x0) * t;
        cy0 = y0 + (cy0 - y0) * t;
        coords[pos + 2] = x0;
        coords[pos + 3] = y0;
        coords[pos + 4] = cx0;
        coords[pos + 5] = cy0;
        coords[pos + 6] = cx0 + (cx1 - cx0) * t;
        coords[pos + 7] = cy0 + (cy1 - cy0) * t;
        coords[pos + 8] = cx1;
        coords[pos + 9] = cy1;
        coords[pos + 10] = x1;
        coords[pos + 11] = y1;
    }

    public Order3(double x0, double y0, double cx0, double cy0, double cx1, double cy1, double x1, double y1, int direction) {
        super(direction);
        if (cy0 < y0) {
            cy0 = y0;
        }
        if (cy1 > y1) {
            cy1 = y1;
        }
        this.x0 = x0;
        this.y0 = y0;
        this.cx0 = cx0;
        this.cy0 = cy0;
        this.cx1 = cx1;
        this.cy1 = cy1;
        this.x1 = x1;
        this.y1 = y1;
        this.xmin = Math.min(Math.min(x0, x1), Math.min(cx0, cx1));
        this.xmax = Math.max(Math.max(x0, x1), Math.max(cx0, cx1));
        this.xcoeff0 = x0;
        this.xcoeff1 = (cx0 - x0) * 3.0;
        this.xcoeff2 = (cx1 - cx0 - cx0 + x0) * 3.0;
        this.xcoeff3 = x1 - (cx1 - cx0) * 3.0 - x0;
        this.ycoeff0 = y0;
        this.ycoeff1 = (cy0 - y0) * 3.0;
        this.ycoeff2 = (cy1 - cy0 - cy0 + y0) * 3.0;
        this.ycoeff3 = y1 - (cy1 - cy0) * 3.0 - y0;
        this.YforT2 = this.YforT3 = y0;
        this.YforT1 = this.YforT3;
    }

    @Override
    public int getOrder() {
        return 3;
    }

    @Override
    public double getXTop() {
        return this.x0;
    }

    @Override
    public double getYTop() {
        return this.y0;
    }

    @Override
    public double getXBot() {
        return this.x1;
    }

    @Override
    public double getYBot() {
        return this.y1;
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getX0() {
        return this.direction == 1 ? this.x0 : this.x1;
    }

    @Override
    public double getY0() {
        return this.direction == 1 ? this.y0 : this.y1;
    }

    public double getCX0() {
        return this.direction == 1 ? this.cx0 : this.cx1;
    }

    public double getCY0() {
        return this.direction == 1 ? this.cy0 : this.cy1;
    }

    public double getCX1() {
        return this.direction == -1 ? this.cx0 : this.cx1;
    }

    public double getCY1() {
        return this.direction == -1 ? this.cy0 : this.cy1;
    }

    @Override
    public double getX1() {
        return this.direction == -1 ? this.x0 : this.x1;
    }

    @Override
    public double getY1() {
        return this.direction == -1 ? this.y0 : this.y1;
    }

    @Override
    public double TforY(double y) {
        double t;
        if (y <= this.y0) {
            return 0.0;
        }
        if (y >= this.y1) {
            return 1.0;
        }
        if (y == this.YforT1) {
            return this.TforY1;
        }
        if (y == this.YforT2) {
            return this.TforY2;
        }
        if (y == this.YforT3) {
            return this.TforY3;
        }
        if (this.ycoeff3 == 0.0) {
            return Order2.TforY(y, this.ycoeff0, this.ycoeff1, this.ycoeff2);
        }
        double a = this.ycoeff2 / this.ycoeff3;
        double b = this.ycoeff1 / this.ycoeff3;
        double c = (this.ycoeff0 - y) / this.ycoeff3;
        boolean roots = false;
        double Q = (a * a - 3.0 * b) / 9.0;
        double R = (2.0 * a * a * a - 9.0 * a * b + 27.0 * c) / 54.0;
        double R2 = R * R;
        double Q3 = Q * Q * Q;
        double a_3 = a / 3.0;
        if (R2 < Q3) {
            double theta = Math.acos(R / Math.sqrt(Q3));
            t = this.refine(a, b, c, y, (Q = -2.0 * Math.sqrt(Q)) * Math.cos(theta / 3.0) - a_3);
            if (t < 0.0) {
                t = this.refine(a, b, c, y, Q * Math.cos((theta + Math.PI * 2) / 3.0) - a_3);
            }
            if (t < 0.0) {
                t = this.refine(a, b, c, y, Q * Math.cos((theta - Math.PI * 2) / 3.0) - a_3);
            }
        } else {
            boolean neg = R < 0.0;
            double S = Math.sqrt(R2 - Q3);
            if (neg) {
                R = -R;
            }
            double A = Math.pow(R + S, 0.3333333333333333);
            if (!neg) {
                A = -A;
            }
            double B = A == 0.0 ? 0.0 : Q / A;
            t = this.refine(a, b, c, y, A + B - a_3);
        }
        if (t < 0.0) {
            double t0 = 0.0;
            double t1 = 1.0;
            while ((t = (t0 + t1) / 2.0) != t0 && t != t1) {
                double yt = this.YforT(t);
                if (yt < y) {
                    t0 = t;
                    continue;
                }
                if (!(yt > y)) break;
                t1 = t;
            }
        }
        if (t >= 0.0) {
            this.TforY3 = this.TforY2;
            this.YforT3 = this.YforT2;
            this.TforY2 = this.TforY1;
            this.YforT2 = this.YforT1;
            this.TforY1 = t;
            this.YforT1 = y;
        }
        return t;
    }

    public double refine(double a, double b, double c, double target, double t) {
        double t1;
        double t0;
        if (t < -0.1 || t > 1.1) {
            return -1.0;
        }
        double y = this.YforT(t);
        if (y < target) {
            t0 = t;
            t1 = 1.0;
        } else {
            t0 = 0.0;
            t1 = t;
        }
        double origt = t;
        double origy = y;
        boolean useslope = true;
        while (y != target) {
            if (!useslope) {
                double t2 = (t0 + t1) / 2.0;
                if (t2 == t0 || t2 == t1) break;
                t = t2;
            } else {
                double slope = this.dYforT(t, 1);
                if (slope == 0.0) {
                    useslope = false;
                    continue;
                }
                double t2 = t + (target - y) / slope;
                if (t2 == t || t2 <= t0 || t2 >= t1) {
                    useslope = false;
                    continue;
                }
                t = t2;
            }
            y = this.YforT(t);
            if (y < target) {
                t0 = t;
                continue;
            }
            if (!(y > target)) break;
            t1 = t;
        }
        boolean verbose = false;
        return t > 1.0 ? -1.0 : t;
    }

    @Override
    public double XforY(double y) {
        if (y <= this.y0) {
            return this.x0;
        }
        if (y >= this.y1) {
            return this.x1;
        }
        return this.XforT(this.TforY(y));
    }

    @Override
    public double XforT(double t) {
        return ((this.xcoeff3 * t + this.xcoeff2) * t + this.xcoeff1) * t + this.xcoeff0;
    }

    @Override
    public double YforT(double t) {
        return ((this.ycoeff3 * t + this.ycoeff2) * t + this.ycoeff1) * t + this.ycoeff0;
    }

    @Override
    public double dXforT(double t, int deriv) {
        switch (deriv) {
            case 0: {
                return ((this.xcoeff3 * t + this.xcoeff2) * t + this.xcoeff1) * t + this.xcoeff0;
            }
            case 1: {
                return (3.0 * this.xcoeff3 * t + 2.0 * this.xcoeff2) * t + this.xcoeff1;
            }
            case 2: {
                return 6.0 * this.xcoeff3 * t + 2.0 * this.xcoeff2;
            }
            case 3: {
                return 6.0 * this.xcoeff3;
            }
        }
        return 0.0;
    }

    @Override
    public double dYforT(double t, int deriv) {
        switch (deriv) {
            case 0: {
                return ((this.ycoeff3 * t + this.ycoeff2) * t + this.ycoeff1) * t + this.ycoeff0;
            }
            case 1: {
                return (3.0 * this.ycoeff3 * t + 2.0 * this.ycoeff2) * t + this.ycoeff1;
            }
            case 2: {
                return 6.0 * this.ycoeff3 * t + 2.0 * this.ycoeff2;
            }
            case 3: {
                return 6.0 * this.ycoeff3;
            }
        }
        return 0.0;
    }

    @Override
    public double nextVertical(double t0, double t1) {
        double[] eqn = new double[]{this.xcoeff1, 2.0 * this.xcoeff2, 3.0 * this.xcoeff3};
        int numroots = Order3.solveQuadratic(eqn, eqn);
        for (int i = 0; i < numroots; ++i) {
            if (!(eqn[i] > t0) || !(eqn[i] < t1)) continue;
            t1 = eqn[i];
        }
        return t1;
    }

    @Override
    public void enlarge(RectBounds r) {
        r.add((float)this.x0, (float)this.y0);
        double[] eqn = new double[]{this.xcoeff1, 2.0 * this.xcoeff2, 3.0 * this.xcoeff3};
        int numroots = Order3.solveQuadratic(eqn, eqn);
        for (int i = 0; i < numroots; ++i) {
            double t = eqn[i];
            if (!(t > 0.0) || !(t < 1.0)) continue;
            r.add((float)this.XforT(t), (float)this.YforT(t));
        }
        r.add((float)this.x1, (float)this.y1);
    }

    @Override
    public Curve getSubCurve(double ystart, double yend, int dir) {
        int i;
        if (ystart <= this.y0 && yend >= this.y1) {
            return this.getWithDirection(dir);
        }
        double[] eqn = new double[14];
        double t0 = this.TforY(ystart);
        double t1 = this.TforY(yend);
        eqn[0] = this.x0;
        eqn[1] = this.y0;
        eqn[2] = this.cx0;
        eqn[3] = this.cy0;
        eqn[4] = this.cx1;
        eqn[5] = this.cy1;
        eqn[6] = this.x1;
        eqn[7] = this.y1;
        if (t0 > t1) {
            double t = t0;
            t0 = t1;
            t1 = t;
        }
        if (t1 < 1.0) {
            Order3.split(eqn, 0, t1);
        }
        if (t0 <= 0.0) {
            i = 0;
        } else {
            Order3.split(eqn, 0, t0 / t1);
            i = 6;
        }
        return new Order3(eqn[i + 0], ystart, eqn[i + 2], eqn[i + 3], eqn[i + 4], eqn[i + 5], eqn[i + 6], yend, dir);
    }

    @Override
    public Curve getReversedCurve() {
        return new Order3(this.x0, this.y0, this.cx0, this.cy0, this.cx1, this.cy1, this.x1, this.y1, -this.direction);
    }

    @Override
    public int getSegment(float[] coords) {
        if (this.direction == 1) {
            coords[0] = (float)this.cx0;
            coords[1] = (float)this.cy0;
            coords[2] = (float)this.cx1;
            coords[3] = (float)this.cy1;
            coords[4] = (float)this.x1;
            coords[5] = (float)this.y1;
        } else {
            coords[0] = (float)this.cx1;
            coords[1] = (float)this.cy1;
            coords[2] = (float)this.cx0;
            coords[3] = (float)this.cy0;
            coords[4] = (float)this.x0;
            coords[5] = (float)this.y0;
        }
        return 3;
    }

    @Override
    public String controlPointString() {
        return "(" + Order3.round(this.getCX0()) + ", " + Order3.round(this.getCY0()) + "), (" + Order3.round(this.getCX1()) + ", " + Order3.round(this.getCY1()) + "), ";
    }
}

