/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Vec2f;
import com.sun.javafx.geom.Vec3f;

public final class RectBounds
extends BaseBounds {
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;

    public RectBounds() {
        this.minY = 0.0f;
        this.minX = 0.0f;
        this.maxY = -1.0f;
        this.maxX = -1.0f;
    }

    @Override
    public BaseBounds copy() {
        return new RectBounds(this.minX, this.minY, this.maxX, this.maxY);
    }

    public RectBounds(float minX, float minY, float maxX, float maxY) {
        this.setBounds(minX, minY, maxX, maxY);
    }

    public RectBounds(RectBounds other) {
        this.setBounds(other);
    }

    public RectBounds(Rectangle other) {
        this.setBounds(other.x, other.y, other.x + other.width, other.y + other.height);
    }

    @Override
    public BaseBounds.BoundsType getBoundsType() {
        return BaseBounds.BoundsType.RECTANGLE;
    }

    @Override
    public boolean is2D() {
        return true;
    }

    @Override
    public float getWidth() {
        return this.maxX - this.minX;
    }

    @Override
    public float getHeight() {
        return this.maxY - this.minY;
    }

    @Override
    public float getDepth() {
        return 0.0f;
    }

    @Override
    public float getMinX() {
        return this.minX;
    }

    public void setMinX(float minX) {
        this.minX = minX;
    }

    @Override
    public float getMinY() {
        return this.minY;
    }

    public void setMinY(float minY) {
        this.minY = minY;
    }

    @Override
    public float getMinZ() {
        return 0.0f;
    }

    @Override
    public float getMaxX() {
        return this.maxX;
    }

    public void setMaxX(float maxX) {
        this.maxX = maxX;
    }

    @Override
    public float getMaxY() {
        return this.maxY;
    }

    public void setMaxY(float maxY) {
        this.maxY = maxY;
    }

    @Override
    public float getMaxZ() {
        return 0.0f;
    }

    @Override
    public Vec2f getMin(Vec2f min) {
        if (min == null) {
            min = new Vec2f();
        }
        min.x = this.minX;
        min.y = this.minY;
        return min;
    }

    @Override
    public Vec2f getMax(Vec2f max) {
        if (max == null) {
            max = new Vec2f();
        }
        max.x = this.maxX;
        max.y = this.maxY;
        return max;
    }

    @Override
    public Vec3f getMin(Vec3f min) {
        if (min == null) {
            min = new Vec3f();
        }
        min.x = this.minX;
        min.y = this.minY;
        min.z = 0.0f;
        return min;
    }

    @Override
    public Vec3f getMax(Vec3f max) {
        if (max == null) {
            max = new Vec3f();
        }
        max.x = this.maxX;
        max.y = this.maxY;
        max.z = 0.0f;
        return max;
    }

    @Override
    public BaseBounds deriveWithUnion(BaseBounds other) {
        if (other.getBoundsType() != BaseBounds.BoundsType.RECTANGLE) {
            if (other.getBoundsType() == BaseBounds.BoundsType.BOX) {
                BoxBounds bb = new BoxBounds((BoxBounds)other);
                bb.unionWith(this);
                return bb;
            }
            throw new UnsupportedOperationException("Unknown BoundsType");
        }
        RectBounds rb = (RectBounds)other;
        this.unionWith(rb);
        return this;
    }

    @Override
    public BaseBounds deriveWithNewBounds(Rectangle other) {
        if (other.width < 0 || other.height < 0) {
            return this.makeEmpty();
        }
        this.setBounds(other.x, other.y, other.x + other.width, other.y + other.height);
        return this;
    }

    @Override
    public BaseBounds deriveWithNewBounds(BaseBounds other) {
        if (other.isEmpty()) {
            return this.makeEmpty();
        }
        if (other.getBoundsType() != BaseBounds.BoundsType.RECTANGLE) {
            if (other.getBoundsType() == BaseBounds.BoundsType.BOX) {
                return new BoxBounds((BoxBounds)other);
            }
            throw new UnsupportedOperationException("Unknown BoundsType");
        }
        RectBounds rb = (RectBounds)other;
        this.minX = rb.getMinX();
        this.minY = rb.getMinY();
        this.maxX = rb.getMaxX();
        this.maxY = rb.getMaxY();
        return this;
    }

    @Override
    public BaseBounds deriveWithNewBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (maxX < minX || maxY < minY || maxZ < minZ) {
            return this.makeEmpty();
        }
        if (minZ == 0.0f && maxZ == 0.0f) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
            return this;
        }
        return new BoxBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public BaseBounds deriveWithNewBoundsAndSort(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (minZ == 0.0f && maxZ == 0.0f) {
            this.setBoundsAndSort(minX, minY, minZ, maxX, maxY, maxZ);
            return this;
        }
        BoxBounds bb = new BoxBounds();
        ((BaseBounds)bb).setBoundsAndSort(minX, minY, minZ, maxX, maxY, maxZ);
        return bb;
    }

    public final void setBounds(RectBounds other) {
        this.minX = other.getMinX();
        this.minY = other.getMinY();
        this.maxX = other.getMaxX();
        this.maxY = other.getMaxY();
    }

    public final void setBounds(float minX, float minY, float maxX, float maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public void setBoundsAndSort(float minX, float minY, float maxX, float maxY) {
        this.setBounds(minX, minY, maxX, maxY);
        this.sortMinMax();
    }

    @Override
    public void setBoundsAndSort(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (minZ != 0.0f || maxZ != 0.0f) {
            throw new UnsupportedOperationException("Unknown BoundsType");
        }
        this.setBounds(minX, minY, maxX, maxY);
        this.sortMinMax();
    }

    @Override
    public void setBoundsAndSort(Point2D p1, Point2D p2) {
        this.setBoundsAndSort(p1.x, p1.y, p2.x, p2.y);
    }

    @Override
    public RectBounds flattenInto(RectBounds bounds) {
        if (bounds == null) {
            bounds = new RectBounds();
        }
        if (this.isEmpty()) {
            return bounds.makeEmpty();
        }
        bounds.setBounds(this.minX, this.minY, this.maxX, this.maxY);
        return bounds;
    }

    public void unionWith(RectBounds other) {
        if (other.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.setBounds(other);
            return;
        }
        this.minX = Math.min(this.minX, other.getMinX());
        this.minY = Math.min(this.minY, other.getMinY());
        this.maxX = Math.max(this.maxX, other.getMaxX());
        this.maxY = Math.max(this.maxY, other.getMaxY());
    }

    public void unionWith(float minX, float minY, float maxX, float maxY) {
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (this.isEmpty()) {
            this.setBounds(minX, minY, maxX, maxY);
            return;
        }
        this.minX = Math.min(this.minX, minX);
        this.minY = Math.min(this.minY, minY);
        this.maxX = Math.max(this.maxX, maxX);
        this.maxY = Math.max(this.maxY, maxY);
    }

    @Override
    public void add(float x, float y, float z) {
        if (z != 0.0f) {
            throw new UnsupportedOperationException("Unknown BoundsType");
        }
        this.unionWith(x, y, x, y);
    }

    public void add(float x, float y) {
        this.unionWith(x, y, x, y);
    }

    @Override
    public void add(Point2D p) {
        this.add(p.x, p.y);
    }

    @Override
    public void intersectWith(BaseBounds other) {
        if (this.isEmpty()) {
            return;
        }
        if (other.isEmpty()) {
            this.makeEmpty();
            return;
        }
        this.minX = Math.max(this.minX, other.getMinX());
        this.minY = Math.max(this.minY, other.getMinY());
        this.maxX = Math.min(this.maxX, other.getMaxX());
        this.maxY = Math.min(this.maxY, other.getMaxY());
    }

    @Override
    public void intersectWith(Rectangle other) {
        float x = other.x;
        float y = other.y;
        this.intersectWith(x, y, x + (float)other.width, y + (float)other.height);
    }

    public void intersectWith(float minX, float minY, float maxX, float maxY) {
        if (this.isEmpty()) {
            return;
        }
        if (maxX < minX || maxY < minY) {
            this.makeEmpty();
            return;
        }
        this.minX = Math.max(this.minX, minX);
        this.minY = Math.max(this.minY, minY);
        this.maxX = Math.min(this.maxX, maxX);
        this.maxY = Math.min(this.maxY, maxY);
    }

    @Override
    public void intersectWith(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (this.isEmpty()) {
            return;
        }
        if (maxX < minX || maxY < minY || maxZ < minZ) {
            this.makeEmpty();
            return;
        }
        this.minX = Math.max(this.minX, minX);
        this.minY = Math.max(this.minY, minY);
        this.maxX = Math.min(this.maxX, maxX);
        this.maxY = Math.min(this.maxY, maxY);
    }

    @Override
    public boolean contains(Point2D p) {
        if (p == null || this.isEmpty()) {
            return false;
        }
        return p.x >= this.minX && p.x <= this.maxX && p.y >= this.minY && p.y <= this.maxY;
    }

    @Override
    public boolean contains(float x, float y) {
        if (this.isEmpty()) {
            return false;
        }
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
    }

    public boolean contains(RectBounds other) {
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        return this.minX <= other.minX && this.maxX >= other.maxX && this.minY <= other.minY && this.maxY >= other.maxY;
    }

    @Override
    public boolean intersects(float x, float y, float width, float height) {
        if (this.isEmpty()) {
            return false;
        }
        return x + width >= this.minX && y + height >= this.minY && x <= this.maxX && y <= this.maxY;
    }

    public boolean intersects(BaseBounds other) {
        if (other == null || other.isEmpty() || this.isEmpty()) {
            return false;
        }
        return other.getMaxX() >= this.minX && other.getMaxY() >= this.minY && other.getMaxZ() >= this.getMinZ() && other.getMinX() <= this.maxX && other.getMinY() <= this.maxY && other.getMinZ() <= this.getMaxZ();
    }

    @Override
    public boolean disjoint(float x, float y, float width, float height) {
        if (this.isEmpty()) {
            return true;
        }
        return x + width < this.minX || y + height < this.minY || x > this.maxX || y > this.maxY;
    }

    public boolean disjoint(RectBounds other) {
        if (other == null || other.isEmpty() || this.isEmpty()) {
            return true;
        }
        return other.getMaxX() < this.minX || other.getMaxY() < this.minY || other.getMinX() > this.maxX || other.getMinY() > this.maxY;
    }

    @Override
    public boolean isEmpty() {
        return !(this.maxX >= this.minX) || !(this.maxY >= this.minY);
    }

    @Override
    public void roundOut() {
        this.minX = (float)Math.floor(this.minX);
        this.minY = (float)Math.floor(this.minY);
        this.maxX = (float)Math.ceil(this.maxX);
        this.maxY = (float)Math.ceil(this.maxY);
    }

    public void grow(float h, float v) {
        this.minX -= h;
        this.maxX += h;
        this.minY -= v;
        this.maxY += v;
    }

    @Override
    public BaseBounds deriveWithPadding(float h, float v, float d) {
        if (d == 0.0f) {
            this.grow(h, v);
            return this;
        }
        BoxBounds bb = new BoxBounds(this.minX, this.minY, 0.0f, this.maxX, this.maxY, 0.0f);
        bb.grow(h, v, d);
        return bb;
    }

    @Override
    public RectBounds makeEmpty() {
        this.minY = 0.0f;
        this.minX = 0.0f;
        this.maxY = -1.0f;
        this.maxX = -1.0f;
        return this;
    }

    @Override
    protected void sortMinMax() {
        float tmp;
        if (this.minX > this.maxX) {
            tmp = this.maxX;
            this.maxX = this.minX;
            this.minX = tmp;
        }
        if (this.minY > this.maxY) {
            tmp = this.maxY;
            this.maxY = this.minY;
            this.minY = tmp;
        }
    }

    @Override
    public void translate(float x, float y, float z) {
        this.setMinX(this.getMinX() + x);
        this.setMinY(this.getMinY() + y);
        this.setMaxX(this.getMaxX() + x);
        this.setMaxY(this.getMaxY() + y);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RectBounds other = (RectBounds)obj;
        if (this.minX != other.getMinX()) {
            return false;
        }
        if (this.minY != other.getMinY()) {
            return false;
        }
        if (this.maxX != other.getMaxX()) {
            return false;
        }
        return this.maxY == other.getMaxY();
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Float.floatToIntBits(this.minX);
        hash = 79 * hash + Float.floatToIntBits(this.minY);
        hash = 79 * hash + Float.floatToIntBits(this.maxX);
        hash = 79 * hash + Float.floatToIntBits(this.maxY);
        return hash;
    }

    public String toString() {
        return "RectBounds { minX:" + this.minX + ", minY:" + this.minY + ", maxX:" + this.maxX + ", maxY:" + this.maxY + "} (w:" + (this.maxX - this.minX) + ", h:" + (this.maxY - this.minY) + ")";
    }
}

