/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom.transform;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.Vec3f;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.CanTransformVec3d;
import com.sun.javafx.geom.transform.SingularMatrixException;
import com.sun.javafx.geom.transform.TransformHelper;

public final class GeneralTransform3D
implements CanTransformVec3d {
    protected double[] mat = new double[16];
    private boolean identity;
    private Vec3d tempV3d;
    private static final double EPSILON_ABSOLUTE = 1.0E-5;

    public GeneralTransform3D() {
        this.setIdentity();
    }

    public boolean isAffine() {
        return !this.isInfOrNaN() && GeneralTransform3D.almostZero(this.mat[12]) && GeneralTransform3D.almostZero(this.mat[13]) && GeneralTransform3D.almostZero(this.mat[14]) && GeneralTransform3D.almostOne(this.mat[15]);
    }

    public GeneralTransform3D set(GeneralTransform3D t1) {
        System.arraycopy(t1.mat, 0, this.mat, 0, this.mat.length);
        this.updateState();
        return this;
    }

    public GeneralTransform3D set(double[] m) {
        System.arraycopy(m, 0, this.mat, 0, this.mat.length);
        this.updateState();
        return this;
    }

    public double[] get(double[] rv) {
        if (rv == null) {
            rv = new double[this.mat.length];
        }
        System.arraycopy(this.mat, 0, rv, 0, this.mat.length);
        return rv;
    }

    public double get(int index) {
        assert (index >= 0 && index < this.mat.length);
        return this.mat[index];
    }

    public BaseBounds transform(BaseBounds src, BaseBounds dst) {
        if (this.tempV3d == null) {
            this.tempV3d = new Vec3d();
        }
        return TransformHelper.general3dBoundsTransform(this, src, dst, this.tempV3d);
    }

    public Point2D transform(Point2D point, Point2D pointOut) {
        if (pointOut == null) {
            pointOut = new Point2D();
        }
        double w = this.mat[12] * (double)point.x + this.mat[13] * (double)point.y + this.mat[15];
        float outX = (float)(this.mat[0] * (double)point.x + this.mat[1] * (double)point.y + this.mat[3]);
        pointOut.y = (float)(this.mat[4] * (double)point.x + this.mat[5] * (double)point.y + this.mat[7]);
        pointOut.x = outX;
        if (w != 0.0) {
            pointOut.x = (float)((double)pointOut.x / w);
            pointOut.y = (float)((double)pointOut.y / w);
        }
        return pointOut;
    }

    @Override
    public Vec3d transform(Vec3d point, Vec3d pointOut) {
        if (pointOut == null) {
            pointOut = new Vec3d();
        }
        double w = this.mat[12] * point.x + this.mat[13] * point.y + this.mat[14] * point.z + this.mat[15];
        double outX = this.mat[0] * point.x + this.mat[1] * point.y + this.mat[2] * point.z + this.mat[3];
        double outY = this.mat[4] * point.x + this.mat[5] * point.y + this.mat[6] * point.z + this.mat[7];
        pointOut.z = this.mat[8] * point.x + this.mat[9] * point.y + this.mat[10] * point.z + this.mat[11];
        pointOut.x = outX;
        pointOut.y = outY;
        if (w != 0.0) {
            pointOut.x /= w;
            pointOut.y /= w;
            pointOut.z /= w;
        }
        return pointOut;
    }

    public Vec3d transform(Vec3d point) {
        return this.transform(point, point);
    }

    public Vec3f transformNormal(Vec3f normal, Vec3f normalOut) {
        if (normalOut == null) {
            normalOut = new Vec3f();
        }
        float outX = (float)(this.mat[0] * (double)normal.x + this.mat[1] * (double)normal.y + this.mat[2] * (double)normal.z);
        float outY = (float)(this.mat[4] * (double)normal.x + this.mat[5] * (double)normal.y + this.mat[6] * (double)normal.z);
        normalOut.z = (float)(this.mat[8] * (double)normal.x + this.mat[9] * (double)normal.y + this.mat[10] * (double)normal.z);
        normalOut.x = outX;
        normalOut.y = outY;
        return normalOut;
    }

    public Vec3f transformNormal(Vec3f normal) {
        return this.transformNormal(normal, normal);
    }

    public GeneralTransform3D perspective(boolean verticalFOV, double fov, double aspect, double zNear, double zFar) {
        double half_fov = fov * 0.5;
        double deltaZ = zFar - zNear;
        double sine = Math.sin(half_fov);
        double cotangent = Math.cos(half_fov) / sine;
        this.mat[0] = verticalFOV ? cotangent / aspect : cotangent;
        this.mat[5] = verticalFOV ? cotangent : cotangent * aspect;
        this.mat[10] = -(zFar + zNear) / deltaZ;
        this.mat[11] = -2.0 * zNear * zFar / deltaZ;
        this.mat[14] = -1.0;
        this.mat[15] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[7] = 0.0;
        this.mat[6] = 0.0;
        this.mat[4] = 0.0;
        this.mat[3] = 0.0;
        this.mat[2] = 0.0;
        this.mat[1] = 0.0;
        this.updateState();
        return this;
    }

    public GeneralTransform3D ortho(double left, double right, double bottom, double top, double near, double far) {
        double deltax = 1.0 / (right - left);
        double deltay = 1.0 / (top - bottom);
        double deltaz = 1.0 / (far - near);
        this.mat[0] = 2.0 * deltax;
        this.mat[3] = -(right + left) * deltax;
        this.mat[5] = 2.0 * deltay;
        this.mat[7] = -(top + bottom) * deltay;
        this.mat[10] = 2.0 * deltaz;
        this.mat[11] = (far + near) * deltaz;
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[6] = 0.0;
        this.mat[4] = 0.0;
        this.mat[2] = 0.0;
        this.mat[1] = 0.0;
        this.mat[15] = 1.0;
        this.updateState();
        return this;
    }

    public double computeClipZCoord() {
        double zEc = (1.0 - this.mat[15]) / this.mat[14];
        double zCc = this.mat[10] * zEc + this.mat[11];
        return zCc;
    }

    public double determinant() {
        return this.mat[0] * (this.mat[5] * (this.mat[10] * this.mat[15] - this.mat[11] * this.mat[14]) - this.mat[6] * (this.mat[9] * this.mat[15] - this.mat[11] * this.mat[13]) + this.mat[7] * (this.mat[9] * this.mat[14] - this.mat[10] * this.mat[13])) - this.mat[1] * (this.mat[4] * (this.mat[10] * this.mat[15] - this.mat[11] * this.mat[14]) - this.mat[6] * (this.mat[8] * this.mat[15] - this.mat[11] * this.mat[12]) + this.mat[7] * (this.mat[8] * this.mat[14] - this.mat[10] * this.mat[12])) + this.mat[2] * (this.mat[4] * (this.mat[9] * this.mat[15] - this.mat[11] * this.mat[13]) - this.mat[5] * (this.mat[8] * this.mat[15] - this.mat[11] * this.mat[12]) + this.mat[7] * (this.mat[8] * this.mat[13] - this.mat[9] * this.mat[12])) - this.mat[3] * (this.mat[4] * (this.mat[9] * this.mat[14] - this.mat[10] * this.mat[13]) - this.mat[5] * (this.mat[8] * this.mat[14] - this.mat[10] * this.mat[12]) + this.mat[6] * (this.mat[8] * this.mat[13] - this.mat[9] * this.mat[12]));
    }

    public GeneralTransform3D invert() {
        return this.invert(this);
    }

    private GeneralTransform3D invert(GeneralTransform3D t1) {
        double[] tmp = new double[16];
        int[] row_perm = new int[4];
        System.arraycopy(t1.mat, 0, tmp, 0, tmp.length);
        if (!GeneralTransform3D.luDecomposition(tmp, row_perm)) {
            throw new SingularMatrixException();
        }
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        GeneralTransform3D.luBacksubstitution(tmp, row_perm, this.mat);
        this.updateState();
        return this;
    }

    private static boolean luDecomposition(double[] matrix0, int[] row_perm) {
        double[] row_scale = new double[4];
        int ptr = 0;
        int rs = 0;
        int i = 4;
        while (i-- != 0) {
            double big = 0.0;
            int j = 4;
            while (j-- != 0) {
                double temp = matrix0[ptr++];
                if (!((temp = Math.abs(temp)) > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                return false;
            }
            row_scale[rs++] = 1.0 / big;
        }
        int mtx = 0;
        for (int j = 0; j < 4; ++j) {
            double temp;
            int p1;
            int k;
            int p2;
            double sum;
            int target;
            int i2;
            for (i2 = 0; i2 < j; ++i2) {
                target = mtx + 4 * i2 + j;
                sum = matrix0[target];
                int k2 = i2;
                int p12 = mtx + 4 * i2;
                p2 = mtx + j;
                while (k2-- != 0) {
                    sum -= matrix0[p12] * matrix0[p2];
                    ++p12;
                    p2 += 4;
                }
                matrix0[target] = sum;
            }
            double big = 0.0;
            int imax = -1;
            for (i2 = j; i2 < 4; ++i2) {
                double d;
                target = mtx + 4 * i2 + j;
                sum = matrix0[target];
                k = j;
                p1 = mtx + 4 * i2;
                p2 = mtx + j;
                while (k-- != 0) {
                    sum -= matrix0[p1] * matrix0[p2];
                    ++p1;
                    p2 += 4;
                }
                matrix0[target] = sum;
                temp = row_scale[i2] * Math.abs(sum);
                if (!(d >= big)) continue;
                big = temp;
                imax = i2;
            }
            if (imax < 0) {
                return false;
            }
            if (j != imax) {
                k = 4;
                p1 = mtx + 4 * imax;
                p2 = mtx + 4 * j;
                while (k-- != 0) {
                    temp = matrix0[p1];
                    matrix0[p1++] = matrix0[p2];
                    matrix0[p2++] = temp;
                }
                row_scale[imax] = row_scale[j];
            }
            row_perm[j] = imax;
            if (matrix0[mtx + 4 * j + j] == 0.0) {
                return false;
            }
            if (j == 3) continue;
            temp = 1.0 / matrix0[mtx + 4 * j + j];
            target = mtx + 4 * (j + 1) + j;
            i2 = 3 - j;
            while (i2-- != 0) {
                int n = target;
                matrix0[n] = matrix0[n] * temp;
                target += 4;
            }
        }
        return true;
    }

    private static void luBacksubstitution(double[] matrix1, int[] row_perm, double[] matrix2) {
        int rp = 0;
        for (int k = 0; k < 4; ++k) {
            int rv;
            int cv = k;
            int ii = -1;
            for (int i = 0; i < 4; ++i) {
                int ip = row_perm[rp + i];
                double sum = matrix2[cv + 4 * ip];
                matrix2[cv + 4 * ip] = matrix2[cv + 4 * i];
                if (ii >= 0) {
                    rv = i * 4;
                    for (int j = ii; j <= i - 1; ++j) {
                        sum -= matrix1[rv + j] * matrix2[cv + 4 * j];
                    }
                } else if (sum != 0.0) {
                    ii = i;
                }
                matrix2[cv + 4 * i] = sum;
            }
            rv = 12;
            int n = cv + 12;
            matrix2[n] = matrix2[n] / matrix1[rv + 3];
            matrix2[cv + 8] = (matrix2[cv + 8] - matrix1[(rv -= 4) + 3] * matrix2[cv + 12]) / matrix1[rv + 2];
            matrix2[cv + 4] = (matrix2[cv + 4] - matrix1[(rv -= 4) + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 1];
            matrix2[cv + 0] = (matrix2[cv + 0] - matrix1[(rv -= 4) + 1] * matrix2[cv + 4] - matrix1[rv + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 0];
        }
    }

    public GeneralTransform3D mul(BaseTransform t1) {
        double tmp15;
        double tmp12;
        double tmp13;
        double tmp14;
        if (t1.isIdentity()) {
            return this;
        }
        double mxx = t1.getMxx();
        double mxy = t1.getMxy();
        double mxz = t1.getMxz();
        double mxt = t1.getMxt();
        double myx = t1.getMyx();
        double myy = t1.getMyy();
        double myz = t1.getMyz();
        double myt = t1.getMyt();
        double mzx = t1.getMzx();
        double mzy = t1.getMzy();
        double mzz = t1.getMzz();
        double mzt = t1.getMzt();
        double tmp0 = this.mat[0] * mxx + this.mat[1] * myx + this.mat[2] * mzx;
        double tmp1 = this.mat[0] * mxy + this.mat[1] * myy + this.mat[2] * mzy;
        double tmp2 = this.mat[0] * mxz + this.mat[1] * myz + this.mat[2] * mzz;
        double tmp3 = this.mat[0] * mxt + this.mat[1] * myt + this.mat[2] * mzt + this.mat[3];
        double tmp4 = this.mat[4] * mxx + this.mat[5] * myx + this.mat[6] * mzx;
        double tmp5 = this.mat[4] * mxy + this.mat[5] * myy + this.mat[6] * mzy;
        double tmp6 = this.mat[4] * mxz + this.mat[5] * myz + this.mat[6] * mzz;
        double tmp7 = this.mat[4] * mxt + this.mat[5] * myt + this.mat[6] * mzt + this.mat[7];
        double tmp8 = this.mat[8] * mxx + this.mat[9] * myx + this.mat[10] * mzx;
        double tmp9 = this.mat[8] * mxy + this.mat[9] * myy + this.mat[10] * mzy;
        double tmp10 = this.mat[8] * mxz + this.mat[9] * myz + this.mat[10] * mzz;
        double tmp11 = this.mat[8] * mxt + this.mat[9] * myt + this.mat[10] * mzt + this.mat[11];
        if (this.isAffine()) {
            tmp14 = 0.0;
            tmp13 = 0.0;
            tmp12 = 0.0;
            tmp15 = 1.0;
        } else {
            tmp12 = this.mat[12] * mxx + this.mat[13] * myx + this.mat[14] * mzx;
            tmp13 = this.mat[12] * mxy + this.mat[13] * myy + this.mat[14] * mzy;
            tmp14 = this.mat[12] * mxz + this.mat[13] * myz + this.mat[14] * mzz;
            tmp15 = this.mat[12] * mxt + this.mat[13] * myt + this.mat[14] * mzt + this.mat[15];
        }
        this.mat[0] = tmp0;
        this.mat[1] = tmp1;
        this.mat[2] = tmp2;
        this.mat[3] = tmp3;
        this.mat[4] = tmp4;
        this.mat[5] = tmp5;
        this.mat[6] = tmp6;
        this.mat[7] = tmp7;
        this.mat[8] = tmp8;
        this.mat[9] = tmp9;
        this.mat[10] = tmp10;
        this.mat[11] = tmp11;
        this.mat[12] = tmp12;
        this.mat[13] = tmp13;
        this.mat[14] = tmp14;
        this.mat[15] = tmp15;
        this.updateState();
        return this;
    }

    public GeneralTransform3D scale(double sx, double sy, double sz) {
        boolean update = false;
        if (sx != 1.0) {
            this.mat[0] = this.mat[0] * sx;
            this.mat[4] = this.mat[4] * sx;
            this.mat[8] = this.mat[8] * sx;
            this.mat[12] = this.mat[12] * sx;
            update = true;
        }
        if (sy != 1.0) {
            this.mat[1] = this.mat[1] * sy;
            this.mat[5] = this.mat[5] * sy;
            this.mat[9] = this.mat[9] * sy;
            this.mat[13] = this.mat[13] * sy;
            update = true;
        }
        if (sz != 1.0) {
            this.mat[2] = this.mat[2] * sz;
            this.mat[6] = this.mat[6] * sz;
            this.mat[10] = this.mat[10] * sz;
            this.mat[14] = this.mat[14] * sz;
            update = true;
        }
        if (update) {
            this.updateState();
        }
        return this;
    }

    public GeneralTransform3D mul(GeneralTransform3D t1) {
        double tmp15;
        double tmp12;
        double tmp13;
        double tmp14;
        double tmp11;
        double tmp10;
        double tmp9;
        double tmp8;
        double tmp7;
        double tmp6;
        double tmp5;
        double tmp4;
        double tmp3;
        double tmp2;
        double tmp1;
        double tmp0;
        if (t1.isIdentity()) {
            return this;
        }
        if (t1.isAffine()) {
            tmp0 = this.mat[0] * t1.mat[0] + this.mat[1] * t1.mat[4] + this.mat[2] * t1.mat[8];
            tmp1 = this.mat[0] * t1.mat[1] + this.mat[1] * t1.mat[5] + this.mat[2] * t1.mat[9];
            tmp2 = this.mat[0] * t1.mat[2] + this.mat[1] * t1.mat[6] + this.mat[2] * t1.mat[10];
            tmp3 = this.mat[0] * t1.mat[3] + this.mat[1] * t1.mat[7] + this.mat[2] * t1.mat[11] + this.mat[3];
            tmp4 = this.mat[4] * t1.mat[0] + this.mat[5] * t1.mat[4] + this.mat[6] * t1.mat[8];
            tmp5 = this.mat[4] * t1.mat[1] + this.mat[5] * t1.mat[5] + this.mat[6] * t1.mat[9];
            tmp6 = this.mat[4] * t1.mat[2] + this.mat[5] * t1.mat[6] + this.mat[6] * t1.mat[10];
            tmp7 = this.mat[4] * t1.mat[3] + this.mat[5] * t1.mat[7] + this.mat[6] * t1.mat[11] + this.mat[7];
            tmp8 = this.mat[8] * t1.mat[0] + this.mat[9] * t1.mat[4] + this.mat[10] * t1.mat[8];
            tmp9 = this.mat[8] * t1.mat[1] + this.mat[9] * t1.mat[5] + this.mat[10] * t1.mat[9];
            tmp10 = this.mat[8] * t1.mat[2] + this.mat[9] * t1.mat[6] + this.mat[10] * t1.mat[10];
            tmp11 = this.mat[8] * t1.mat[3] + this.mat[9] * t1.mat[7] + this.mat[10] * t1.mat[11] + this.mat[11];
            if (this.isAffine()) {
                tmp14 = 0.0;
                tmp13 = 0.0;
                tmp12 = 0.0;
                tmp15 = 1.0;
            } else {
                tmp12 = this.mat[12] * t1.mat[0] + this.mat[13] * t1.mat[4] + this.mat[14] * t1.mat[8];
                tmp13 = this.mat[12] * t1.mat[1] + this.mat[13] * t1.mat[5] + this.mat[14] * t1.mat[9];
                tmp14 = this.mat[12] * t1.mat[2] + this.mat[13] * t1.mat[6] + this.mat[14] * t1.mat[10];
                tmp15 = this.mat[12] * t1.mat[3] + this.mat[13] * t1.mat[7] + this.mat[14] * t1.mat[11] + this.mat[15];
            }
        } else {
            tmp0 = this.mat[0] * t1.mat[0] + this.mat[1] * t1.mat[4] + this.mat[2] * t1.mat[8] + this.mat[3] * t1.mat[12];
            tmp1 = this.mat[0] * t1.mat[1] + this.mat[1] * t1.mat[5] + this.mat[2] * t1.mat[9] + this.mat[3] * t1.mat[13];
            tmp2 = this.mat[0] * t1.mat[2] + this.mat[1] * t1.mat[6] + this.mat[2] * t1.mat[10] + this.mat[3] * t1.mat[14];
            tmp3 = this.mat[0] * t1.mat[3] + this.mat[1] * t1.mat[7] + this.mat[2] * t1.mat[11] + this.mat[3] * t1.mat[15];
            tmp4 = this.mat[4] * t1.mat[0] + this.mat[5] * t1.mat[4] + this.mat[6] * t1.mat[8] + this.mat[7] * t1.mat[12];
            tmp5 = this.mat[4] * t1.mat[1] + this.mat[5] * t1.mat[5] + this.mat[6] * t1.mat[9] + this.mat[7] * t1.mat[13];
            tmp6 = this.mat[4] * t1.mat[2] + this.mat[5] * t1.mat[6] + this.mat[6] * t1.mat[10] + this.mat[7] * t1.mat[14];
            tmp7 = this.mat[4] * t1.mat[3] + this.mat[5] * t1.mat[7] + this.mat[6] * t1.mat[11] + this.mat[7] * t1.mat[15];
            tmp8 = this.mat[8] * t1.mat[0] + this.mat[9] * t1.mat[4] + this.mat[10] * t1.mat[8] + this.mat[11] * t1.mat[12];
            tmp9 = this.mat[8] * t1.mat[1] + this.mat[9] * t1.mat[5] + this.mat[10] * t1.mat[9] + this.mat[11] * t1.mat[13];
            tmp10 = this.mat[8] * t1.mat[2] + this.mat[9] * t1.mat[6] + this.mat[10] * t1.mat[10] + this.mat[11] * t1.mat[14];
            tmp11 = this.mat[8] * t1.mat[3] + this.mat[9] * t1.mat[7] + this.mat[10] * t1.mat[11] + this.mat[11] * t1.mat[15];
            if (this.isAffine()) {
                tmp12 = t1.mat[12];
                tmp13 = t1.mat[13];
                tmp14 = t1.mat[14];
                tmp15 = t1.mat[15];
            } else {
                tmp12 = this.mat[12] * t1.mat[0] + this.mat[13] * t1.mat[4] + this.mat[14] * t1.mat[8] + this.mat[15] * t1.mat[12];
                tmp13 = this.mat[12] * t1.mat[1] + this.mat[13] * t1.mat[5] + this.mat[14] * t1.mat[9] + this.mat[15] * t1.mat[13];
                tmp14 = this.mat[12] * t1.mat[2] + this.mat[13] * t1.mat[6] + this.mat[14] * t1.mat[10] + this.mat[15] * t1.mat[14];
                tmp15 = this.mat[12] * t1.mat[3] + this.mat[13] * t1.mat[7] + this.mat[14] * t1.mat[11] + this.mat[15] * t1.mat[15];
            }
        }
        this.mat[0] = tmp0;
        this.mat[1] = tmp1;
        this.mat[2] = tmp2;
        this.mat[3] = tmp3;
        this.mat[4] = tmp4;
        this.mat[5] = tmp5;
        this.mat[6] = tmp6;
        this.mat[7] = tmp7;
        this.mat[8] = tmp8;
        this.mat[9] = tmp9;
        this.mat[10] = tmp10;
        this.mat[11] = tmp11;
        this.mat[12] = tmp12;
        this.mat[13] = tmp13;
        this.mat[14] = tmp14;
        this.mat[15] = tmp15;
        this.updateState();
        return this;
    }

    public GeneralTransform3D setIdentity() {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.identity = true;
        return this;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    private void updateState() {
        this.identity = this.mat[0] == 1.0 && this.mat[5] == 1.0 && this.mat[10] == 1.0 && this.mat[15] == 1.0 && this.mat[1] == 0.0 && this.mat[2] == 0.0 && this.mat[3] == 0.0 && this.mat[4] == 0.0 && this.mat[6] == 0.0 && this.mat[7] == 0.0 && this.mat[8] == 0.0 && this.mat[9] == 0.0 && this.mat[11] == 0.0 && this.mat[12] == 0.0 && this.mat[13] == 0.0 && this.mat[14] == 0.0;
    }

    boolean isInfOrNaN() {
        double d = 0.0;
        for (int i = 0; i < this.mat.length; ++i) {
            d *= this.mat[i];
        }
        return d != 0.0;
    }

    static boolean almostZero(double a) {
        return a < 1.0E-5 && a > -1.0E-5;
    }

    static boolean almostOne(double a) {
        return a < 1.00001 && a > 0.99999;
    }

    public GeneralTransform3D copy() {
        GeneralTransform3D newTransform = new GeneralTransform3D();
        newTransform.set(this);
        return newTransform;
    }

    public String toString() {
        return this.mat[0] + ", " + this.mat[1] + ", " + this.mat[2] + ", " + this.mat[3] + "\n" + this.mat[4] + ", " + this.mat[5] + ", " + this.mat[6] + ", " + this.mat[7] + "\n" + this.mat[8] + ", " + this.mat[9] + ", " + this.mat[10] + ", " + this.mat[11] + "\n" + this.mat[12] + ", " + this.mat[13] + ", " + this.mat[14] + ", " + this.mat[15] + "\n";
    }
}

