/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import javafx.css.ParsedValue;
import javafx.css.Size;
import javafx.css.SizeUnits;
import javafx.css.StyleConverter;
import javafx.geometry.Side;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.text.Font;

public final class BackgroundPositionConverter
extends StyleConverter<ParsedValue[], BackgroundPosition> {
    private static final BackgroundPositionConverter BACKGROUND_POSITION_CONVERTER = new BackgroundPositionConverter();

    public static BackgroundPositionConverter getInstance() {
        return BACKGROUND_POSITION_CONVERTER;
    }

    private BackgroundPositionConverter() {
    }

    @Override
    public BackgroundPosition convert(ParsedValue<ParsedValue[], BackgroundPosition> value, Font font) {
        ParsedValue[] positions = value.getValue();
        Size top = (Size)positions[0].convert(font);
        Size right = (Size)positions[1].convert(font);
        Size bottom = (Size)positions[2].convert(font);
        Size left = (Size)positions[3].convert(font);
        boolean verticalEdgeProportional = bottom.getValue() > 0.0 && bottom.getUnits() == SizeUnits.PERCENT || top.getValue() > 0.0 && top.getUnits() == SizeUnits.PERCENT || top.getValue() == 0.0 && bottom.getValue() == 0.0;
        boolean horizontalEdgeProportional = right.getValue() > 0.0 && right.getUnits() == SizeUnits.PERCENT || left.getValue() > 0.0 && left.getUnits() == SizeUnits.PERCENT || left.getValue() == 0.0 && right.getValue() == 0.0;
        double t = top.pixels(font);
        double r = right.pixels(font);
        double b = bottom.pixels(font);
        double l = left.pixels(font);
        return new BackgroundPosition(l == 0.0 && r != 0.0 ? Side.RIGHT : Side.LEFT, l == 0.0 && r != 0.0 ? r : l, horizontalEdgeProportional, t == 0.0 && b != 0.0 ? Side.BOTTOM : Side.TOP, t == 0.0 && b != 0.0 ? b : t, verticalEdgeProportional);
    }

    public String toString() {
        return "BackgroundPositionConverter";
    }
}

