/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.scene.layout.region.BorderImageSlices;
import javafx.css.ParsedValue;
import javafx.css.Size;
import javafx.css.SizeUnits;
import javafx.css.StyleConverter;
import javafx.scene.layout.BorderWidths;
import javafx.scene.text.Font;

public final class BorderImageSliceConverter
extends StyleConverter<ParsedValue[], BorderImageSlices> {
    private static final BorderImageSliceConverter BORDER_IMAGE_SLICE_CONVERTER = new BorderImageSliceConverter();

    public static BorderImageSliceConverter getInstance() {
        return BORDER_IMAGE_SLICE_CONVERTER;
    }

    private BorderImageSliceConverter() {
    }

    @Override
    public BorderImageSlices convert(ParsedValue<ParsedValue[], BorderImageSlices> layer, Font font) {
        ParsedValue[] values = layer.getValue();
        ParsedValue[] sizes = (ParsedValue[])values[0].getValue();
        Size topSz = (Size)sizes[0].convert(font);
        Size rightSz = (Size)sizes[1].convert(font);
        Size bottomSz = (Size)sizes[2].convert(font);
        Size leftSz = (Size)sizes[3].convert(font);
        return new BorderImageSlices(new BorderWidths(topSz.pixels(font), rightSz.pixels(font), bottomSz.pixels(font), leftSz.pixels(font), topSz.getUnits() == SizeUnits.PERCENT, rightSz.getUnits() == SizeUnits.PERCENT, bottomSz.getUnits() == SizeUnits.PERCENT, leftSz.getUnits() == SizeUnits.PERCENT), (Boolean)values[1].getValue());
    }

    public String toString() {
        return "BorderImageSliceConverter";
    }
}

