/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import javafx.css.ParsedValue;
import javafx.css.Size;
import javafx.css.SizeUnits;
import javafx.css.StyleConverter;
import javafx.scene.text.Font;

public class Margins {
    final double top;
    final double right;
    final double bottom;
    final double left;
    final boolean proportional;

    public final double getTop() {
        return this.top;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getLeft() {
        return this.left;
    }

    public final boolean isProportional() {
        return this.proportional;
    }

    public Margins(double top, double right, double bottom, double left, boolean proportional) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
        this.proportional = proportional;
    }

    public String toString() {
        return "top: " + this.top + "\nright: " + this.right + "\nbottom: " + this.bottom + "\nleft: " + this.left;
    }

    public static final class SequenceConverter
    extends StyleConverter<ParsedValue<ParsedValue[], Margins>[], Margins[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_CONVERTER_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public Margins[] convert(ParsedValue<ParsedValue<ParsedValue[], Margins>[], Margins[]> value, Font font) {
            ParsedValue<ParsedValue[], Margins>[] layers = value.getValue();
            Margins[] margins = new Margins[layers.length];
            for (int layer = 0; layer < layers.length; ++layer) {
                margins[layer] = Converter.getInstance().convert((ParsedValue)layers[layer], font);
            }
            return margins;
        }

        public String toString() {
            return "MarginsSequenceConverter";
        }
    }

    public static final class Converter
    extends StyleConverter<ParsedValue[], Margins> {
        public static Converter getInstance() {
            return Holder.CONVERTER_INSTANCE;
        }

        private Converter() {
        }

        @Override
        public Margins convert(ParsedValue<ParsedValue[], Margins> value, Font font) {
            PlatformLogger LOGGER;
            boolean unitsMatch;
            ParsedValue[] sides = value.getValue();
            Size topSz = sides.length > 0 ? (Size)sides[0].convert(font) : new Size(0.0, SizeUnits.PX);
            Size rightSz = sides.length > 1 ? (Size)sides[1].convert(font) : topSz;
            Size bottomSz = sides.length > 2 ? (Size)sides[2].convert(font) : topSz;
            Size leftSz = sides.length > 3 ? (Size)sides[3].convert(font) : rightSz;
            boolean proportional = topSz.getUnits() == SizeUnits.PERCENT || rightSz.getUnits() == SizeUnits.PERCENT || bottomSz.getUnits() == SizeUnits.PERCENT || leftSz.getUnits() == SizeUnits.PERCENT;
            boolean bl = unitsMatch = !proportional || topSz.getUnits() == SizeUnits.PERCENT && rightSz.getUnits() == SizeUnits.PERCENT && bottomSz.getUnits() == SizeUnits.PERCENT && leftSz.getUnits() == SizeUnits.PERCENT;
            if (!unitsMatch && (LOGGER = Logging.getCSSLogger()).isLoggable(PlatformLogger.Level.WARNING)) {
                String msg = "units do no match: " + topSz.toString() + " ," + rightSz.toString() + " ," + bottomSz.toString() + " ," + leftSz.toString();
                LOGGER.warning(msg);
            }
            proportional = proportional && unitsMatch;
            double top = topSz.pixels(font);
            double right = rightSz.pixels(font);
            double bottom = bottomSz.pixels(font);
            double left = leftSz.pixels(font);
            return new Margins(top, right, bottom, left, proportional);
        }

        public String toString() {
            return "MarginsConverter";
        }
    }

    private static class Holder {
        static Converter CONVERTER_INSTANCE = new Converter();
        static SequenceConverter SEQUENCE_CONVERTER_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }
}

