/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;

final class TabOrderHelper {
    TabOrderHelper() {
    }

    private static Node findPreviousFocusableInList(List<Node> nodeList, int startIndex) {
        for (int i = startIndex; i >= 0; --i) {
            ParentTraversalEngine traversalEngine;
            Node prevNode = nodeList.get(i);
            if (TabOrderHelper.isDisabledOrInvisible(prevNode)) continue;
            ParentTraversalEngine parentTraversalEngine = traversalEngine = prevNode instanceof Parent ? ParentHelper.getTraversalEngine((Parent)prevNode) : null;
            if (prevNode instanceof Parent) {
                if (traversalEngine != null && traversalEngine.canTraverse()) {
                    Node selected = traversalEngine.selectLast();
                    if (selected != null) {
                        return selected;
                    }
                } else {
                    Node newNode;
                    ObservableList<Node> prevNodesList = ((Parent)prevNode).getChildrenUnmodifiable();
                    if (prevNodesList.size() > 0 && (newNode = TabOrderHelper.findPreviousFocusableInList(prevNodesList, prevNodesList.size() - 1)) != null) {
                        return newNode;
                    }
                }
            }
            if (!(traversalEngine != null ? traversalEngine.isParentTraversable() : prevNode.isFocusTraversable())) continue;
            return prevNode;
        }
        return null;
    }

    private static boolean isDisabledOrInvisible(Node prevNode) {
        return prevNode.isDisabled() || !NodeHelper.isTreeVisible(prevNode);
    }

    public static Node findPreviousFocusablePeer(Node node, Parent root) {
        Node startNode = node;
        Node newNode = null;
        List<Node> parentNodes = TabOrderHelper.findPeers(startNode);
        if (parentNodes == null) {
            ObservableList<Node> rootChildren = ((Parent)node).getChildrenUnmodifiable();
            return TabOrderHelper.findPreviousFocusableInList(rootChildren, rootChildren.size() - 1);
        }
        int ourIndex = parentNodes.indexOf(startNode);
        newNode = TabOrderHelper.findPreviousFocusableInList(parentNodes, ourIndex - 1);
        while (newNode == null && startNode.getParent() != root) {
            Parent parent = startNode.getParent();
            if (parent != null) {
                ParentTraversalEngine parentEngine = ParentHelper.getTraversalEngine(parent);
                if (parentEngine != null ? parentEngine.isParentTraversable() : parent.isFocusTraversable()) {
                    newNode = parent;
                } else {
                    List<Node> peerNodes = TabOrderHelper.findPeers(parent);
                    if (peerNodes != null) {
                        int parentIndex = peerNodes.indexOf(parent);
                        newNode = TabOrderHelper.findPreviousFocusableInList(peerNodes, parentIndex - 1);
                    }
                }
            }
            startNode = parent;
        }
        return newNode;
    }

    private static List<Node> findPeers(Node node) {
        ObservableList<Node> parentNodes = null;
        Parent parent = node.getParent();
        if (parent != null) {
            parentNodes = parent.getChildrenUnmodifiable();
        }
        return parentNodes;
    }

    private static Node findNextFocusableInList(List<Node> nodeList, int startIndex) {
        for (int i = startIndex; i < nodeList.size(); ++i) {
            Node newNode;
            ParentTraversalEngine traversalEngine;
            Node nextNode = nodeList.get(i);
            if (TabOrderHelper.isDisabledOrInvisible(nextNode)) continue;
            ParentTraversalEngine parentTraversalEngine = traversalEngine = nextNode instanceof Parent ? ParentHelper.getTraversalEngine((Parent)nextNode) : null;
            if (traversalEngine != null ? traversalEngine.isParentTraversable() : nextNode.isFocusTraversable()) {
                return nextNode;
            }
            if (!(nextNode instanceof Parent)) continue;
            if (traversalEngine != null && traversalEngine.canTraverse()) {
                Node selected = traversalEngine.selectFirst();
                if (selected == null) continue;
                return selected;
            }
            ObservableList<Node> nextNodesList = ((Parent)nextNode).getChildrenUnmodifiable();
            if (nextNodesList.size() <= 0 || (newNode = TabOrderHelper.findNextFocusableInList(nextNodesList, 0)) == null) continue;
            return newNode;
        }
        return null;
    }

    public static Node findNextFocusablePeer(Node node, Parent root, boolean traverseIntoCurrent) {
        Node startNode = node;
        Node newNode = null;
        if (traverseIntoCurrent && node instanceof Parent) {
            newNode = TabOrderHelper.findNextFocusableInList(((Parent)node).getChildrenUnmodifiable(), 0);
        }
        if (newNode == null) {
            List<Node> parentNodes = TabOrderHelper.findPeers(startNode);
            if (parentNodes == null) {
                return null;
            }
            int ourIndex = parentNodes.indexOf(startNode);
            newNode = TabOrderHelper.findNextFocusableInList(parentNodes, ourIndex + 1);
        }
        while (newNode == null && startNode.getParent() != root) {
            List<Node> peerNodes;
            Parent parent = startNode.getParent();
            if (parent != null && (peerNodes = TabOrderHelper.findPeers(parent)) != null) {
                int parentIndex = peerNodes.indexOf(parent);
                newNode = TabOrderHelper.findNextFocusableInList(peerNodes, parentIndex + 1);
            }
            startNode = parent;
        }
        return newNode;
    }

    public static Node getFirstTargetNode(Parent p) {
        Node selected;
        if (p == null || TabOrderHelper.isDisabledOrInvisible(p)) {
            return null;
        }
        ParentTraversalEngine traversalEngine = ParentHelper.getTraversalEngine(p);
        if (traversalEngine != null && traversalEngine.canTraverse() && (selected = traversalEngine.selectFirst()) != null) {
            return selected;
        }
        ObservableList<Node> parentsNodes = p.getChildrenUnmodifiable();
        for (Node n : parentsNodes) {
            Node result;
            ParentTraversalEngine parentEngine;
            if (TabOrderHelper.isDisabledOrInvisible(n)) continue;
            ParentTraversalEngine parentTraversalEngine = parentEngine = n instanceof Parent ? ParentHelper.getTraversalEngine((Parent)n) : null;
            if (parentEngine != null ? parentEngine.isParentTraversable() : n.isFocusTraversable()) {
                return n;
            }
            if (!(n instanceof Parent) || (result = TabOrderHelper.getFirstTargetNode((Parent)n)) == null) continue;
            return result;
        }
        return null;
    }

    public static Node getLastTargetNode(Parent p) {
        Node selected;
        if (p == null || TabOrderHelper.isDisabledOrInvisible(p)) {
            return null;
        }
        ParentTraversalEngine traversalEngine = ParentHelper.getTraversalEngine(p);
        if (traversalEngine != null && traversalEngine.canTraverse() && (selected = traversalEngine.selectLast()) != null) {
            return selected;
        }
        ObservableList<Node> parentsNodes = p.getChildrenUnmodifiable();
        for (int i = parentsNodes.size() - 1; i >= 0; --i) {
            ParentTraversalEngine parentEngine;
            Node result;
            Node n = (Node)parentsNodes.get(i);
            if (TabOrderHelper.isDisabledOrInvisible(n)) continue;
            if (n instanceof Parent && (result = TabOrderHelper.getLastTargetNode((Parent)n)) != null) {
                return result;
            }
            ParentTraversalEngine parentTraversalEngine = parentEngine = n instanceof Parent ? ParentHelper.getTraversalEngine((Parent)n) : null;
            if (!(parentEngine != null ? parentEngine.isParentTraversable() : n.isFocusTraversable())) continue;
            return n;
        }
        return null;
    }
}

