/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.stage;

import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.util.Utils;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.stage.PopupWindow;
import javafx.stage.Window;

public class PopupWindowHelper
extends WindowHelper {
    private static final PopupWindowHelper theInstance = new PopupWindowHelper();
    private static PopupWindowAccessor popupWindowAccessor;

    private static WindowHelper getInstance() {
        return theInstance;
    }

    public static void initHelper(PopupWindow popupWindow) {
        PopupWindowHelper.setHelper(popupWindow, PopupWindowHelper.getInstance());
    }

    @Override
    protected void visibleChangingImpl(Window window, boolean visible) {
        super.visibleChangingImpl(window, visible);
        popupWindowAccessor.doVisibleChanging(window, visible);
    }

    @Override
    protected void visibleChangedImpl(Window window, boolean visible) {
        super.visibleChangedImpl(window, visible);
        popupWindowAccessor.doVisibleChanged(window, visible);
    }

    public static ObservableList<Node> getContent(PopupWindow popupWindow) {
        return popupWindowAccessor.getContent(popupWindow);
    }

    public static void setPopupWindowAccessor(PopupWindowAccessor newAccessor) {
        if (popupWindowAccessor != null) {
            throw new IllegalStateException();
        }
        popupWindowAccessor = newAccessor;
    }

    static {
        Utils.forceInit(PopupWindow.class);
    }

    public static interface PopupWindowAccessor {
        public ObservableList<Node> getContent(PopupWindow var1);

        public void doVisibleChanging(Window var1, boolean var2);

        public void doVisibleChanged(Window var1, boolean var2);
    }
}

