/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.stage;

import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.util.Utils;
import javafx.stage.Stage;
import javafx.stage.Window;

public class StageHelper
extends WindowHelper {
    private static final StageHelper theInstance = new StageHelper();
    private static StageAccessor stageAccessor;

    private static WindowHelper getInstance() {
        return theInstance;
    }

    public static void initHelper(Stage stage) {
        StageHelper.setHelper(stage, StageHelper.getInstance());
    }

    @Override
    protected void visibleChangingImpl(Window window, boolean visible) {
        super.visibleChangingImpl(window, visible);
        stageAccessor.doVisibleChanging(window, visible);
    }

    @Override
    protected void visibleChangedImpl(Window window, boolean visible) {
        super.visibleChangedImpl(window, visible);
        stageAccessor.doVisibleChanged(window, visible);
    }

    public static void initSecurityDialog(Stage stage, boolean securityDialog) {
        stageAccessor.initSecurityDialog(stage, securityDialog);
    }

    public static void setPrimary(Stage stage, boolean primary) {
        stageAccessor.setPrimary(stage, primary);
    }

    public static void setImportant(Stage stage, boolean important) {
        stageAccessor.setImportant(stage, important);
    }

    public static void setStageAccessor(StageAccessor a) {
        if (stageAccessor != null) {
            System.out.println("Warning: Stage accessor already set: " + stageAccessor);
            Thread.dumpStack();
        }
        stageAccessor = a;
    }

    public static StageAccessor getStageAccessor() {
        return stageAccessor;
    }

    static {
        Utils.forceInit(Stage.class);
    }

    public static interface StageAccessor {
        public void doVisibleChanging(Window var1, boolean var2);

        public void doVisibleChanged(Window var1, boolean var2);

        public void initSecurityDialog(Stage var1, boolean var2);

        public void setPrimary(Stage var1, boolean var2);

        public void setImportant(Stage var1, boolean var2);
    }
}

