/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.javafx.embed.EmbeddedSceneDSInterface;
import com.sun.javafx.embed.EmbeddedSceneDTInterface;
import com.sun.javafx.tk.quantum.EmbeddedSceneDnD;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import javafx.scene.input.TransferMode;

final class EmbeddedSceneDT
implements EmbeddedSceneDTInterface {
    private final EmbeddedSceneDnD dnd;
    private final GlassSceneDnDEventHandler dndHandler;
    private EmbeddedSceneDSInterface dragSource;
    private ClipboardAssistance assistant;

    public EmbeddedSceneDT(EmbeddedSceneDnD dnd, GlassSceneDnDEventHandler dndHandler) {
        this.dnd = dnd;
        this.dndHandler = dndHandler;
    }

    private void close() {
        this.dnd.onDropTargetReleased(this);
        this.assistant = null;
    }

    @Override
    public TransferMode handleDragEnter(int x, int y, int xAbs, int yAbs, TransferMode recommendedDropAction, EmbeddedSceneDSInterface ds) {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(() -> {
            this.dragSource = ds;
            this.assistant = new EmbeddedDTAssistant(this.dragSource);
            return this.dndHandler.handleDragEnter(x, y, xAbs, yAbs, recommendedDropAction, this.assistant);
        });
    }

    @Override
    public void handleDragLeave() {
        assert (this.dnd.isHostThread());
        this.dnd.executeOnFXThread(() -> {
            assert (this.assistant != null);
            try {
                this.dndHandler.handleDragLeave(this.assistant);
            }
            finally {
                this.close();
            }
            return null;
        });
    }

    @Override
    public TransferMode handleDragDrop(int x, int y, int xAbs, int yAbs, TransferMode recommendedDropAction) {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(() -> {
            assert (this.assistant != null);
            try {
                TransferMode transferMode = this.dndHandler.handleDragDrop(x, y, xAbs, yAbs, recommendedDropAction, this.assistant);
                return transferMode;
            }
            finally {
                this.close();
            }
        });
    }

    @Override
    public TransferMode handleDragOver(int x, int y, int xAbs, int yAbs, TransferMode recommendedDropAction) {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(() -> {
            assert (this.assistant != null);
            return this.dndHandler.handleDragOver(x, y, xAbs, yAbs, recommendedDropAction, this.assistant);
        });
    }

    private static class EmbeddedDTAssistant
    extends ClipboardAssistance {
        private EmbeddedSceneDSInterface dragSource;

        EmbeddedDTAssistant(EmbeddedSceneDSInterface source) {
            super("DND-Embedded");
            this.dragSource = source;
        }

        @Override
        public void flush() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getData(String mimeType) {
            return this.dragSource.getData(mimeType);
        }

        @Override
        public int getSupportedSourceActions() {
            return QuantumClipboard.transferModesToClipboardActions(this.dragSource.getSupportedActions());
        }

        @Override
        public void setTargetAction(int actionDone) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getMimeTypes() {
            return this.dragSource.getMimeTypes();
        }
    }
}

