/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.menu.CheckMenuItemBase;
import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.menu.MenuItemBase;
import com.sun.javafx.menu.RadioMenuItemBase;
import com.sun.javafx.menu.SeparatorMenuItemBase;
import com.sun.javafx.tk.TKSystemMenu;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.GlassMenuEventHandler;
import com.sun.javafx.tk.quantum.PixelUtils;
import com.sun.prism.Image;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

class GlassSystemMenu
implements TKSystemMenu {
    private List<MenuBase> systemMenus = null;
    private MenuBar glassSystemMenuBar = null;
    private InvalidationListener visibilityListener = valueModel -> {
        if (this.systemMenus != null) {
            this.setMenus(this.systemMenus);
        }
    };

    GlassSystemMenu() {
    }

    protected void createMenuBar() {
        if (this.glassSystemMenuBar == null) {
            Application app = Application.GetApplication();
            this.glassSystemMenuBar = app.createMenuBar();
            app.installDefaultMenus(this.glassSystemMenuBar);
            if (this.systemMenus != null) {
                this.setMenus(this.systemMenus);
            }
        }
    }

    protected MenuBar getMenuBar() {
        return this.glassSystemMenuBar;
    }

    @Override
    public boolean isSupported() {
        return Application.GetApplication().supportsSystemMenu();
    }

    @Override
    public void setMenus(List<MenuBase> menus) {
        this.systemMenus = menus;
        if (this.glassSystemMenuBar != null) {
            List<Menu> existingMenus = this.glassSystemMenuBar.getMenus();
            int existingSize = existingMenus.size();
            for (int index = existingSize - 1; index >= 1; --index) {
                Menu menu = existingMenus.get(index);
                this.clearMenu(menu);
                this.glassSystemMenuBar.remove(index);
            }
            for (MenuBase menuBase : menus) {
                this.addMenu(null, menuBase);
            }
        }
    }

    private void clearMenu(Menu menu) {
        for (int i = menu.getItems().size() - 1; i >= 0; --i) {
            Object o = menu.getItems().get(i);
            if (o instanceof MenuItem) {
                ((MenuItem)o).setCallback(null);
                continue;
            }
            if (!(o instanceof Menu)) continue;
            this.clearMenu((Menu)o);
        }
        menu.setEventHandler(null);
    }

    private void addMenu(Menu parent, MenuBase mb) {
        if (parent != null) {
            this.insertMenu(parent, mb, parent.getItems().size());
        } else {
            this.insertMenu(parent, mb, this.glassSystemMenuBar.getMenus().size());
        }
    }

    private void insertMenu(Menu parent, MenuBase mb, int pos) {
        Application app = Application.GetApplication();
        Menu glassMenu = app.createMenu(this.parseText(mb), !mb.isDisable());
        glassMenu.setEventHandler(new GlassMenuEventHandler(mb));
        mb.visibleProperty().removeListener(this.visibilityListener);
        mb.visibleProperty().addListener(this.visibilityListener);
        if (!mb.isVisible()) {
            return;
        }
        ObservableList<MenuItemBase> items = mb.getItemsBase();
        items.addListener(change -> {
            while (change.next()) {
                int i;
                int from = change.getFrom();
                int to = change.getTo();
                List removed = change.getRemoved();
                for (i = from + removed.size() - 1; i >= from; --i) {
                    List<Object> menuItemList = glassMenu.getItems();
                    if (i < 0 || menuItemList.size() <= i) continue;
                    glassMenu.remove(i);
                }
                for (i = from; i < to; ++i) {
                    MenuItemBase item = (MenuItemBase)change.getList().get(i);
                    if (item instanceof MenuBase) {
                        this.insertMenu(glassMenu, (MenuBase)item, i);
                        continue;
                    }
                    this.insertMenuItem(glassMenu, item, i);
                }
            }
        });
        for (MenuItemBase item : items) {
            if (item instanceof MenuBase) {
                this.addMenu(glassMenu, (MenuBase)item);
                continue;
            }
            this.addMenuItem(glassMenu, item);
        }
        glassMenu.setPixels(this.getPixels(mb));
        this.setMenuBindings(glassMenu, mb);
        if (parent != null) {
            parent.insert(glassMenu, pos);
        } else {
            this.glassSystemMenuBar.insert(glassMenu, pos);
        }
    }

    private void setMenuBindings(Menu glassMenu, MenuBase mb) {
        mb.textProperty().addListener(valueModel -> glassMenu.setTitle(this.parseText(mb)));
        mb.disableProperty().addListener(valueModel -> glassMenu.setEnabled(!mb.isDisable()));
        mb.mnemonicParsingProperty().addListener(valueModel -> glassMenu.setTitle(this.parseText(mb)));
    }

    private void addMenuItem(Menu parent, MenuItemBase menuitem) {
        this.insertMenuItem(parent, menuitem, parent.getItems().size());
    }

    private void insertMenuItem(final Menu parent, final MenuItemBase menuitem, int pos) {
        Application app = Application.GetApplication();
        menuitem.visibleProperty().removeListener(this.visibilityListener);
        menuitem.visibleProperty().addListener(this.visibilityListener);
        if (!menuitem.isVisible()) {
            return;
        }
        if (menuitem instanceof SeparatorMenuItemBase) {
            if (menuitem.isVisible()) {
                parent.insert(MenuItem.Separator, pos);
            }
        } else {
            MenuItem.Callback callback = new MenuItem.Callback(){

                @Override
                public void action() {
                    if (menuitem instanceof CheckMenuItemBase) {
                        CheckMenuItemBase checkItem;
                        checkItem.setSelected(!(checkItem = (CheckMenuItemBase)menuitem).isSelected());
                    } else if (menuitem instanceof RadioMenuItemBase) {
                        RadioMenuItemBase radioItem = (RadioMenuItemBase)menuitem;
                        radioItem.setSelected(true);
                    }
                    menuitem.fire();
                }

                @Override
                public void validate() {
                    Menu.EventHandler meh = parent.getEventHandler();
                    GlassMenuEventHandler gmeh = (GlassMenuEventHandler)meh;
                    if (gmeh.isMenuOpen()) {
                        return;
                    }
                    menuitem.fireValidation();
                }
            };
            MenuItem glassSubMenuItem = app.createMenuItem(this.parseText(menuitem), callback);
            menuitem.textProperty().addListener(valueModel -> glassSubMenuItem.setTitle(this.parseText(menuitem)));
            glassSubMenuItem.setPixels(this.getPixels(menuitem));
            menuitem.graphicProperty().addListener(valueModel -> glassSubMenuItem.setPixels(this.getPixels(menuitem)));
            glassSubMenuItem.setEnabled(!menuitem.isDisable());
            menuitem.disableProperty().addListener(valueModel -> glassSubMenuItem.setEnabled(!menuitem.isDisable()));
            this.setShortcut(glassSubMenuItem, menuitem);
            menuitem.acceleratorProperty().addListener(valueModel -> this.setShortcut(glassSubMenuItem, menuitem));
            menuitem.mnemonicParsingProperty().addListener(valueModel -> glassSubMenuItem.setTitle(this.parseText(menuitem)));
            if (menuitem instanceof CheckMenuItemBase) {
                CheckMenuItemBase checkItem = (CheckMenuItemBase)menuitem;
                glassSubMenuItem.setChecked(checkItem.isSelected());
                checkItem.selectedProperty().addListener(valueModel -> glassSubMenuItem.setChecked(checkItem.isSelected()));
            } else if (menuitem instanceof RadioMenuItemBase) {
                RadioMenuItemBase radioItem = (RadioMenuItemBase)menuitem;
                glassSubMenuItem.setChecked(radioItem.isSelected());
                radioItem.selectedProperty().addListener(valueModel -> glassSubMenuItem.setChecked(radioItem.isSelected()));
            }
            parent.insert(glassSubMenuItem, pos);
        }
    }

    private String parseText(MenuItemBase menuItem) {
        String text = menuItem.getText();
        if (text == null) {
            return "";
        }
        if (!text.isEmpty() && menuItem.isMnemonicParsing()) {
            return text.replaceFirst("_([^_])", "$1");
        }
        return text;
    }

    private Pixels getPixels(MenuItemBase menuItem) {
        if (menuItem.getGraphic() instanceof ImageView) {
            ImageView iv = (ImageView)menuItem.getGraphic();
            javafx.scene.image.Image im = iv.getImage();
            if (im == null) {
                return null;
            }
            String url = im.getUrl();
            if (url == null || PixelUtils.supportedFormatType(url)) {
                Image pi = (Image)Toolkit.getImageAccessor().getPlatformImage(im);
                return pi == null ? null : PixelUtils.imageToPixels(pi);
            }
        }
        return null;
    }

    private void setShortcut(MenuItem glassSubMenuItem, MenuItemBase menuItem) {
        KeyCombination accelerator = menuItem.getAccelerator();
        if (accelerator == null) {
            glassSubMenuItem.setShortcut(0, 0);
        } else if (accelerator instanceof KeyCodeCombination) {
            KeyCodeCombination kcc = (KeyCodeCombination)accelerator;
            KeyCode code = kcc.getCode();
            assert (PlatformUtil.isMac() || PlatformUtil.isLinux());
            int modifier = this.glassModifiers(kcc);
            if (PlatformUtil.isMac()) {
                int finalCode = code.isLetterKey() ? (int)code.getChar().toUpperCase().charAt(0) : code.getCode();
                glassSubMenuItem.setShortcut(finalCode, modifier);
            } else if (PlatformUtil.isLinux()) {
                String lower = code.getChar().toLowerCase();
                if ((modifier & 4) != 0) {
                    glassSubMenuItem.setShortcut(lower.charAt(0), modifier);
                } else {
                    glassSubMenuItem.setShortcut(0, 0);
                }
            } else {
                glassSubMenuItem.setShortcut(0, 0);
            }
        } else if (accelerator instanceof KeyCharacterCombination) {
            KeyCharacterCombination kcc = (KeyCharacterCombination)accelerator;
            String kchar = kcc.getCharacter();
            glassSubMenuItem.setShortcut(kchar.charAt(0), this.glassModifiers(kcc));
        }
    }

    private int glassModifiers(KeyCombination kcc) {
        KeyCode kcode;
        int code;
        int ret = 0;
        if (kcc.getShift() == KeyCombination.ModifierValue.DOWN) {
            ++ret;
        }
        if (kcc.getControl() == KeyCombination.ModifierValue.DOWN) {
            ret += 4;
        }
        if (kcc.getAlt() == KeyCombination.ModifierValue.DOWN) {
            ret += 8;
        }
        if (kcc.getShortcut() == KeyCombination.ModifierValue.DOWN) {
            if (PlatformUtil.isLinux()) {
                ret += 4;
            } else if (PlatformUtil.isMac()) {
                ret += 16;
            }
        }
        if (kcc.getMeta() == KeyCombination.ModifierValue.DOWN) {
            if (PlatformUtil.isLinux()) {
                ret += 16;
            } else if (PlatformUtil.isMac()) {
                ret += 16;
            }
        }
        if (kcc instanceof KeyCodeCombination && ((code = (kcode = ((KeyCodeCombination)kcc).getCode()).getCode()) >= KeyCode.F1.getCode() && code <= KeyCode.F12.getCode() || code >= KeyCode.F13.getCode() && code <= KeyCode.F24.getCode())) {
            ret += 2;
        }
        return ret;
    }
}

