/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Window;
import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.WindowStage;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

class GlassWindowEventHandler
extends Window.EventHandler
implements PrivilegedAction<Void> {
    private final WindowStage stage;
    private Window window;
    private int type;

    public GlassWindowEventHandler(WindowStage stage) {
        this.stage = stage;
    }

    @Override
    public Void run() {
        if (this.stage == null || this.stage.stageListener == null) {
            return null;
        }
        switch (this.type) {
            case 531: {
                this.stage.stageListener.changedIconified(true);
                break;
            }
            case 532: {
                this.stage.stageListener.changedIconified(false);
                this.stage.stageListener.changedMaximized(true);
                break;
            }
            case 533: {
                this.stage.stageListener.changedIconified(false);
                this.stage.stageListener.changedMaximized(false);
                break;
            }
            case 512: {
                float newy;
                float newx;
                float wx = this.window.getX();
                float wy = this.window.getY();
                Screen screen = this.window.getScreen();
                if (screen != null) {
                    float pScaleX = screen.getPlatformScaleX();
                    float pScaleY = screen.getPlatformScaleY();
                    float sx = screen.getX();
                    float sy = screen.getY();
                    float px = screen.getPlatformX();
                    float py = screen.getPlatformY();
                    newx = sx + (wx - px) / pScaleX;
                    newy = sy + (wy - py) / pScaleY;
                } else {
                    newx = wx;
                    newy = wy;
                }
                this.stage.stageListener.changedLocation(newx, newy);
                if (Application.GetApplication().hasWindowManager()) break;
                QuantumToolkit.runWithRenderLock(() -> {
                    GlassScene scene = this.stage.getScene();
                    if (scene != null) {
                        scene.updateSceneState();
                    }
                    return null;
                });
                break;
            }
            case 511: {
                float pScaleX = this.window.getPlatformScaleX();
                float pScaleY = this.window.getPlatformScaleY();
                this.stage.stageListener.changedSize((float)this.window.getWidth() / pScaleX, (float)this.window.getHeight() / pScaleY);
                break;
            }
            case 513: {
                float outScaleX = this.window.getOutputScaleX();
                float outScaleY = this.window.getOutputScaleY();
                this.stage.stageListener.changedScale(outScaleX, outScaleY);
                QuantumToolkit.runWithRenderLock(() -> {
                    GlassScene scene = this.stage.getScene();
                    if (scene != null) {
                        scene.entireSceneNeedsRepaint();
                        scene.updateSceneState();
                    }
                    return null;
                });
                break;
            }
            case 542: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.ACTIVATED);
                break;
            }
            case 541: {
                this.stage.stageListener.changedFocused(false, FocusCause.DEACTIVATED);
                break;
            }
            case 546: {
                this.stage.stageListener.focusUngrab();
                break;
            }
            case 543: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_FORWARD);
                break;
            }
            case 544: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_BACKWARD);
                break;
            }
            case 545: {
                this.stage.handleFocusDisabled();
                break;
            }
            case 522: {
                this.stage.setPlatformWindowClosed();
                this.stage.stageListener.closed();
                break;
            }
            case 521: {
                this.stage.stageListener.closing();
                break;
            }
            default: {
                if (!QuantumToolkit.verbose) break;
                System.err.println("GlassWindowEventHandler: unknown type: " + this.type);
            }
        }
        return null;
    }

    @Override
    public void handleLevelEvent(int level) {
        QuantumToolkit.runWithoutRenderLock(() -> {
            AccessControlContext acc = this.stage.getAccessControlContext();
            return AccessController.doPrivileged(() -> {
                this.stage.stageListener.changedAlwaysOnTop(level != 1);
                return null;
            }, acc);
        });
    }

    @Override
    public void handleWindowEvent(Window window, long time, int type) {
        this.window = window;
        this.type = type;
        QuantumToolkit.runWithoutRenderLock(() -> {
            AccessControlContext acc = this.stage.getAccessControlContext();
            return AccessController.doPrivileged(this, acc);
        });
    }

    @Override
    public void handleScreenChangedEvent(Window window, long time, Screen oldScreen, Screen newScreen) {
        GlassScene scene = this.stage.getScene();
        if (scene != null) {
            QuantumToolkit.runWithRenderLock(() -> {
                scene.entireSceneNeedsRepaint();
                scene.updateSceneState();
                return null;
            });
        }
        QuantumToolkit.runWithoutRenderLock(() -> {
            AccessControlContext acc = this.stage.getAccessControlContext();
            return AccessController.doPrivileged(() -> {
                this.stage.stageListener.changedScreen(oldScreen, newScreen);
                return null;
            }, acc);
        });
    }
}

