/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.quantum.GestureRecognizer;
import com.sun.javafx.tk.quantum.ViewScene;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javafx.event.EventType;
import javafx.scene.input.SwipeEvent;

class SwipeGestureRecognizer
implements GestureRecognizer {
    private static final double TANGENT_30_DEGREES = 0.577;
    private static final double TANGENT_45_DEGREES = 1.0;
    private static final boolean VERBOSE = false;
    private static final double DISTANCE_THRESHOLD = 10.0;
    private static final double BACKWARD_DISTANCE_THRASHOLD = 5.0;
    private SwipeRecognitionState state = SwipeRecognitionState.IDLE;
    MultiTouchTracker tracker = new MultiTouchTracker();
    private ViewScene scene;

    SwipeGestureRecognizer(ViewScene scene) {
        this.scene = scene;
    }

    @Override
    public void notifyBeginTouchEvent(long time, int modifiers, boolean isDirect, int touchEventCount) {
        this.tracker.params(modifiers, isDirect);
    }

    @Override
    public void notifyNextTouchEvent(long time, int type, long touchId, int x, int y, int xAbs, int yAbs) {
        switch (type) {
            case 811: {
                this.tracker.pressed(touchId, time, x, y, xAbs, yAbs);
                break;
            }
            case 812: 
            case 814: {
                this.tracker.progress(touchId, time, xAbs, yAbs);
                break;
            }
            case 813: {
                this.tracker.released(touchId, time, x, y, xAbs, yAbs);
                break;
            }
            default: {
                throw new RuntimeException("Error in swipe gesture recognition: unknown touch state: " + this.state);
            }
        }
    }

    @Override
    public void notifyEndTouchEvent(long time) {
    }

    private EventType<SwipeEvent> calcSwipeType(TouchPointTracker tracker) {
        double lastPrimaryMovement;
        double absDistanceY;
        double distanceX = tracker.getDistanceX();
        double distanceY = tracker.getDistanceY();
        double absDistanceX = Math.abs(distanceX);
        boolean horizontal = absDistanceX > (absDistanceY = Math.abs(distanceY));
        double primaryDistance = horizontal ? distanceX : distanceY;
        double absPrimaryDistance = horizontal ? absDistanceX : absDistanceY;
        double absSecondaryDistance = horizontal ? absDistanceY : absDistanceX;
        double absPrimaryLength = horizontal ? tracker.lengthX : tracker.lengthY;
        double maxSecondaryDeviation = horizontal ? tracker.maxDeviationY : tracker.maxDeviationX;
        double d = lastPrimaryMovement = horizontal ? tracker.lastXMovement : tracker.lastYMovement;
        if (absPrimaryDistance <= 10.0) {
            return null;
        }
        if (absSecondaryDistance > absPrimaryDistance * 0.577) {
            return null;
        }
        if (maxSecondaryDeviation > absPrimaryDistance * 1.0) {
            return null;
        }
        int swipeMaxDuration = Integer.getInteger("com.sun.javafx.gestures.swipe.maxduration", 300);
        if (tracker.getDuration() > (long)swipeMaxDuration) {
            return null;
        }
        if (absPrimaryLength > absPrimaryDistance * 1.5) {
            return null;
        }
        if (Math.signum(primaryDistance) != Math.signum(lastPrimaryMovement) && Math.abs(lastPrimaryMovement) > 5.0) {
            return null;
        }
        if (horizontal) {
            return tracker.getDistanceX() < 0.0 ? SwipeEvent.SWIPE_LEFT : SwipeEvent.SWIPE_RIGHT;
        }
        return tracker.getDistanceY() < 0.0 ? SwipeEvent.SWIPE_UP : SwipeEvent.SWIPE_DOWN;
    }

    private void handleSwipeType(EventType<SwipeEvent> swipeType, CenterComputer cc, int touchCount, int modifiers, boolean isDirect) {
        if (swipeType == null) {
            return;
        }
        AccessController.doPrivileged(() -> {
            if (this.scene.sceneListener != null) {
                this.scene.sceneListener.swipeEvent(swipeType, touchCount, cc.getX(), cc.getY(), cc.getAbsX(), cc.getAbsY(), (modifiers & 1) != 0, (modifiers & 4) != 0, (modifiers & 8) != 0, (modifiers & 0x10) != 0, isDirect);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    private static enum SwipeRecognitionState {
        IDLE,
        ADDING,
        REMOVING,
        FAILURE;

    }

    private static class TouchPointTracker {
        long beginTime;
        long endTime;
        double beginX;
        double beginY;
        double endX;
        double endY;
        double beginAbsX;
        double beginAbsY;
        double endAbsX;
        double endAbsY;
        double lengthX;
        double lengthY;
        double maxDeviationX;
        double maxDeviationY;
        double lastXMovement;
        double lastYMovement;
        double lastX;
        double lastY;

        private TouchPointTracker() {
        }

        public void start(long nanos, double x, double y, double absX, double absY) {
            this.beginX = x;
            this.beginY = y;
            this.beginAbsX = absX;
            this.beginAbsY = absY;
            this.lastX = absX;
            this.lastY = absY;
            this.beginTime = nanos / 1000000L;
        }

        public void end(long nanos, double x, double y, double absX, double absY) {
            this.progress(nanos, absX, absY);
            this.endX = x;
            this.endY = y;
            this.endAbsX = absX;
            this.endAbsY = absY;
            this.endTime = nanos / 1000000L;
        }

        public void progress(long nanos, double x, double y) {
            double devY;
            double deltaX = x - this.lastX;
            double deltaY = y - this.lastY;
            this.lengthX += Math.abs(deltaX);
            this.lengthY += Math.abs(deltaY);
            this.lastX = x;
            this.lastY = y;
            double devX = Math.abs(x - this.beginAbsX);
            if (devX > this.maxDeviationX) {
                this.maxDeviationX = devX;
            }
            if ((devY = Math.abs(y - this.beginAbsY)) > this.maxDeviationY) {
                this.maxDeviationY = devY;
            }
            this.lastXMovement = Math.signum(deltaX) == Math.signum(this.lastXMovement) ? (this.lastXMovement += deltaX) : deltaX;
            this.lastYMovement = Math.signum(deltaY) == Math.signum(this.lastYMovement) ? (this.lastYMovement += deltaY) : deltaY;
        }

        public double getDistanceX() {
            return this.endX - this.beginX;
        }

        public double getDistanceY() {
            return this.endY - this.beginY;
        }

        public long getDuration() {
            return this.endTime - this.beginTime;
        }
    }

    private class MultiTouchTracker {
        SwipeRecognitionState state = SwipeRecognitionState.IDLE;
        Map<Long, TouchPointTracker> trackers = new HashMap<Long, TouchPointTracker>();
        CenterComputer cc = new CenterComputer();
        int modifiers;
        boolean direct;
        private int touchCount;
        private int currentTouchCount;
        private EventType<SwipeEvent> type;

        private MultiTouchTracker() {
        }

        public void params(int modifiers, boolean direct) {
            this.modifiers = modifiers;
            this.direct = direct;
        }

        public void pressed(long id, long nanos, int x, int y, int xAbs, int yAbs) {
            ++this.currentTouchCount;
            switch (this.state) {
                case IDLE: {
                    this.currentTouchCount = 1;
                    this.state = SwipeRecognitionState.ADDING;
                }
                case ADDING: {
                    TouchPointTracker tracker = new TouchPointTracker();
                    tracker.start(nanos, x, y, xAbs, yAbs);
                    this.trackers.put(id, tracker);
                    break;
                }
                case REMOVING: {
                    this.state = SwipeRecognitionState.FAILURE;
                    break;
                }
            }
        }

        public void released(long id, long nanos, int x, int y, int xAbs, int yAbs) {
            if (this.state != SwipeRecognitionState.FAILURE) {
                TouchPointTracker tracker = this.trackers.get(id);
                if (tracker == null) {
                    this.state = SwipeRecognitionState.FAILURE;
                    throw new RuntimeException("Error in swipe gesture recognition: released unknown touch point");
                }
                tracker.end(nanos, x, y, xAbs, yAbs);
                this.cc.add(tracker.beginX, tracker.beginY, tracker.beginAbsX, tracker.beginAbsY);
                this.cc.add(tracker.endX, tracker.endY, tracker.endAbsX, tracker.endAbsY);
                EventType swipeType = SwipeGestureRecognizer.this.calcSwipeType(tracker);
                switch (this.state) {
                    case IDLE: {
                        this.reset();
                        throw new RuntimeException("Error in swipe gesture recognition: released touch point outside of gesture");
                    }
                    case ADDING: {
                        this.state = SwipeRecognitionState.REMOVING;
                        this.touchCount = this.currentTouchCount;
                        this.type = swipeType;
                        break;
                    }
                    case REMOVING: {
                        if (this.type == swipeType) break;
                        this.state = SwipeRecognitionState.FAILURE;
                        break;
                    }
                }
                this.trackers.remove(id);
            }
            --this.currentTouchCount;
            if (this.currentTouchCount == 0) {
                if (this.state == SwipeRecognitionState.REMOVING) {
                    SwipeGestureRecognizer.this.handleSwipeType((EventType<SwipeEvent>)this.type, this.cc, this.touchCount, this.modifiers, this.direct);
                }
                this.state = SwipeRecognitionState.IDLE;
                this.reset();
            }
        }

        public void progress(long id, long nanos, int x, int y) {
            if (this.state == SwipeRecognitionState.FAILURE) {
                return;
            }
            TouchPointTracker tracker = this.trackers.get(id);
            if (tracker == null) {
                this.state = SwipeRecognitionState.FAILURE;
                throw new RuntimeException("Error in swipe gesture recognition: reported unknown touch point");
            }
            tracker.progress(nanos, x, y);
        }

        void reset() {
            this.trackers.clear();
            this.cc.reset();
            this.state = SwipeRecognitionState.IDLE;
        }
    }

    private static class CenterComputer {
        double totalAbsX = 0.0;
        double totalAbsY = 0.0;
        double totalX = 0.0;
        double totalY = 0.0;
        int count = 0;

        private CenterComputer() {
        }

        public void add(double x, double y, double xAbs, double yAbs) {
            this.totalAbsX += xAbs;
            this.totalAbsY += yAbs;
            this.totalX += x;
            this.totalY += y;
            ++this.count;
        }

        public double getX() {
            return this.count == 0 ? 0.0 : this.totalX / (double)this.count;
        }

        public double getY() {
            return this.count == 0 ? 0.0 : this.totalY / (double)this.count;
        }

        public double getAbsX() {
            return this.count == 0 ? 0.0 : this.totalAbsX / (double)this.count;
        }

        public double getAbsY() {
            return this.count == 0 ? 0.0 : this.totalAbsY / (double)this.count;
        }

        public void reset() {
            this.totalX = 0.0;
            this.totalY = 0.0;
            this.totalAbsX = 0.0;
            this.totalAbsY = 0.0;
            this.count = 0;
        }
    }
}

