/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.quantum.GestureRecognizer;
import com.sun.javafx.tk.quantum.ViewScene;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.input.ZoomEvent;
import javafx.util.Duration;

class ZoomGestureRecognizer
implements GestureRecognizer {
    private static double ZOOM_FACTOR_THRESHOLD = 0.1;
    private static boolean ZOOM_INERTIA_ENABLED = true;
    private static double MAX_ZOOMIN_VELOCITY = 3.0;
    private static double MAX_ZOOMOUT_VELOCITY = 0.3333;
    private static double ZOOM_INERTIA_MILLIS = 500.0;
    private static double MAX_ZOOM_IN_FACTOR = 10.0;
    private static double MAX_ZOOM_OUT_FACTOR = 0.1;
    private ViewScene scene;
    private Timeline inertiaTimeline = new Timeline();
    private DoubleProperty inertiaZoomVelocity = new SimpleDoubleProperty();
    private double initialInertiaZoomVelocity = 0.0;
    private double zoomStartTime = 0.0;
    private double lastTouchEventTime = 0.0;
    private ZoomRecognitionState state = ZoomRecognitionState.IDLE;
    private Map<Long, TouchPointTracker> trackers = new HashMap<Long, TouchPointTracker>();
    private int modifiers;
    private boolean direct;
    private int currentTouchCount = 0;
    private boolean touchPointsSetChanged;
    private boolean touchPointsPressed;
    private double centerX;
    private double centerY;
    private double centerAbsX;
    private double centerAbsY;
    private double currentDistance;
    private double distanceReference;
    private double zoomFactor = 1.0;
    private double totalZoomFactor = 1.0;
    double inertiaLastTime = 0.0;

    ZoomGestureRecognizer(ViewScene scene) {
        this.scene = scene;
        this.inertiaZoomVelocity.addListener(valueModel -> {
            double currentTime = this.inertiaTimeline.getCurrentTime().toSeconds();
            double timePassed = currentTime - this.inertiaLastTime;
            this.inertiaLastTime = currentTime;
            double prevTotalZoomFactor = this.totalZoomFactor;
            this.totalZoomFactor += timePassed * this.inertiaZoomVelocity.get();
            this.zoomFactor = this.totalZoomFactor / prevTotalZoomFactor;
            this.sendZoomEvent(true);
        });
    }

    @Override
    public void notifyBeginTouchEvent(long time, int modifiers, boolean isDirect, int touchEventCount) {
        this.params(modifiers, isDirect);
        this.touchPointsSetChanged = false;
        this.touchPointsPressed = false;
    }

    @Override
    public void notifyNextTouchEvent(long time, int type, long touchId, int x, int y, int xAbs, int yAbs) {
        switch (type) {
            case 811: {
                this.touchPointsSetChanged = true;
                this.touchPointsPressed = true;
                this.touchPressed(touchId, time, x, y, xAbs, yAbs);
                break;
            }
            case 814: {
                break;
            }
            case 812: {
                this.touchMoved(touchId, time, x, y, xAbs, yAbs);
                break;
            }
            case 813: {
                this.touchPointsSetChanged = true;
                this.touchReleased(touchId, time, x, y, xAbs, yAbs);
                break;
            }
            default: {
                throw new RuntimeException("Error in Zoom gesture recognition: unknown touch state: " + this.state);
            }
        }
    }

    private void calculateCenter() {
        if (this.currentTouchCount <= 0) {
            throw new RuntimeException("Error in Zoom gesture recognition: touch count is zero!");
        }
        double totalX = 0.0;
        double totalY = 0.0;
        double totalAbsX = 0.0;
        double totalAbsY = 0.0;
        for (TouchPointTracker tracker : this.trackers.values()) {
            totalX += tracker.getX();
            totalY += tracker.getY();
            totalAbsX += tracker.getAbsX();
            totalAbsY += tracker.getAbsY();
        }
        this.centerX = totalX / (double)this.currentTouchCount;
        this.centerY = totalY / (double)this.currentTouchCount;
        this.centerAbsX = totalAbsX / (double)this.currentTouchCount;
        this.centerAbsY = totalAbsY / (double)this.currentTouchCount;
    }

    private double calculateMaxDistance() {
        double maxSquareDist = 0.0;
        for (TouchPointTracker tracker : this.trackers.values()) {
            double deltaY;
            double deltaX = tracker.getAbsX() - this.centerAbsX;
            double squareDist = deltaX * deltaX + (deltaY = tracker.getAbsY() - this.centerAbsY) * deltaY;
            if (!(squareDist > maxSquareDist)) continue;
            maxSquareDist = squareDist;
        }
        return Math.sqrt(maxSquareDist);
    }

    @Override
    public void notifyEndTouchEvent(long time) {
        this.lastTouchEventTime = time;
        if (this.currentTouchCount != this.trackers.size()) {
            throw new RuntimeException("Error in Zoom gesture recognition: touch count is wrong: " + this.currentTouchCount);
        }
        if (this.currentTouchCount == 0) {
            if (this.state == ZoomRecognitionState.ACTIVE) {
                this.sendZoomFinishedEvent();
            }
            if (ZOOM_INERTIA_ENABLED && (this.state == ZoomRecognitionState.PRE_INERTIA || this.state == ZoomRecognitionState.ACTIVE)) {
                double timeFromLastZoom = ((double)time - this.zoomStartTime) / 1000000.0;
                if (this.initialInertiaZoomVelocity != 0.0 && timeFromLastZoom < 200.0) {
                    this.state = ZoomRecognitionState.INERTIA;
                    this.inertiaLastTime = 0.0;
                    double duration = ZOOM_INERTIA_MILLIS / 1000.0;
                    double newZoom = this.totalZoomFactor + this.initialInertiaZoomVelocity * duration;
                    if (this.initialInertiaZoomVelocity > 0.0) {
                        if (newZoom / this.totalZoomFactor > MAX_ZOOM_IN_FACTOR) {
                            newZoom = this.totalZoomFactor * MAX_ZOOM_IN_FACTOR;
                            duration = (newZoom - this.totalZoomFactor) / this.initialInertiaZoomVelocity;
                        }
                    } else if (newZoom / this.totalZoomFactor < MAX_ZOOM_OUT_FACTOR) {
                        newZoom = this.totalZoomFactor * MAX_ZOOM_OUT_FACTOR;
                        duration = (newZoom - this.totalZoomFactor) / this.initialInertiaZoomVelocity;
                    }
                    this.inertiaTimeline.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue(this.inertiaZoomVelocity, this.initialInertiaZoomVelocity, Interpolator.LINEAR)), new KeyFrame(Duration.seconds((double)duration), (EventHandler<ActionEvent>)((EventHandler)event -> this.reset()), new KeyValue(this.inertiaZoomVelocity, 0, Interpolator.LINEAR))});
                    this.inertiaTimeline.playFromStart();
                } else {
                    this.reset();
                }
            } else {
                this.reset();
            }
        } else {
            if (this.touchPointsPressed && this.state == ZoomRecognitionState.INERTIA) {
                this.inertiaTimeline.stop();
                this.reset();
            }
            if (this.currentTouchCount == 1) {
                if (this.state == ZoomRecognitionState.ACTIVE) {
                    this.sendZoomFinishedEvent();
                    if (ZOOM_INERTIA_ENABLED) {
                        this.state = ZoomRecognitionState.PRE_INERTIA;
                    } else {
                        this.reset();
                    }
                }
            } else {
                if (this.state == ZoomRecognitionState.IDLE) {
                    this.state = ZoomRecognitionState.TRACKING;
                    this.zoomStartTime = time;
                }
                this.calculateCenter();
                double currentDistance = this.calculateMaxDistance();
                if (this.touchPointsSetChanged) {
                    this.distanceReference = currentDistance;
                } else {
                    this.zoomFactor = currentDistance / this.distanceReference;
                    if (this.state == ZoomRecognitionState.TRACKING && Math.abs(this.zoomFactor - 1.0) > ZOOM_FACTOR_THRESHOLD) {
                        this.state = ZoomRecognitionState.ACTIVE;
                        this.sendZoomStartedEvent();
                    }
                    if (this.state == ZoomRecognitionState.ACTIVE) {
                        double prevTotalZoomFactor = this.totalZoomFactor;
                        this.totalZoomFactor *= this.zoomFactor;
                        this.sendZoomEvent(false);
                        this.distanceReference = currentDistance;
                        double timePassed = ((double)time - this.zoomStartTime) / 1.0E9;
                        if (timePassed > 1.0E-4) {
                            this.initialInertiaZoomVelocity = (this.totalZoomFactor - prevTotalZoomFactor) / timePassed;
                            this.zoomStartTime = time;
                        } else {
                            this.initialInertiaZoomVelocity = 0.0;
                        }
                    }
                }
            }
        }
    }

    private void sendZoomStartedEvent() {
        AccessController.doPrivileged(() -> {
            if (this.scene.sceneListener != null) {
                this.scene.sceneListener.zoomEvent(ZoomEvent.ZOOM_STARTED, 1.0, 1.0, this.centerX, this.centerY, this.centerAbsX, this.centerAbsY, (this.modifiers & 1) != 0, (this.modifiers & 4) != 0, (this.modifiers & 8) != 0, (this.modifiers & 0x10) != 0, this.direct, false);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    private void sendZoomEvent(boolean isInertia) {
        AccessController.doPrivileged(() -> {
            if (this.scene.sceneListener != null) {
                this.scene.sceneListener.zoomEvent(ZoomEvent.ZOOM, this.zoomFactor, this.totalZoomFactor, this.centerX, this.centerY, this.centerAbsX, this.centerAbsY, (this.modifiers & 1) != 0, (this.modifiers & 4) != 0, (this.modifiers & 8) != 0, (this.modifiers & 0x10) != 0, this.direct, isInertia);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    private void sendZoomFinishedEvent() {
        AccessController.doPrivileged(() -> {
            if (this.scene.sceneListener != null) {
                this.scene.sceneListener.zoomEvent(ZoomEvent.ZOOM_FINISHED, 1.0, this.totalZoomFactor, this.centerX, this.centerY, this.centerAbsX, this.centerAbsY, (this.modifiers & 1) != 0, (this.modifiers & 4) != 0, (this.modifiers & 8) != 0, (this.modifiers & 0x10) != 0, this.direct, false);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    public void params(int modifiers, boolean direct) {
        this.modifiers = modifiers;
        this.direct = direct;
    }

    public void touchPressed(long id, long nanos, int x, int y, int xAbs, int yAbs) {
        ++this.currentTouchCount;
        TouchPointTracker tracker = new TouchPointTracker();
        tracker.update(nanos, x, y, xAbs, yAbs);
        this.trackers.put(id, tracker);
    }

    public void touchReleased(long id, long nanos, int x, int y, int xAbs, int yAbs) {
        if (this.state != ZoomRecognitionState.FAILURE) {
            TouchPointTracker tracker = this.trackers.get(id);
            if (tracker == null) {
                this.state = ZoomRecognitionState.FAILURE;
                throw new RuntimeException("Error in Zoom gesture recognition: released unknown touch point");
            }
            this.trackers.remove(id);
        }
        --this.currentTouchCount;
    }

    public void touchMoved(long id, long nanos, int x, int y, int xAbs, int yAbs) {
        if (this.state == ZoomRecognitionState.FAILURE) {
            return;
        }
        TouchPointTracker tracker = this.trackers.get(id);
        if (tracker == null) {
            this.state = ZoomRecognitionState.FAILURE;
            throw new RuntimeException("Error in zoom gesture recognition: reported unknown touch point");
        }
        tracker.update(nanos, x, y, xAbs, yAbs);
    }

    void reset() {
        this.state = ZoomRecognitionState.IDLE;
        this.zoomFactor = 1.0;
        this.totalZoomFactor = 1.0;
    }

    static {
        AccessController.doPrivileged(() -> {
            String s = System.getProperty("com.sun.javafx.gestures.zoom.threshold");
            if (s != null) {
                ZOOM_FACTOR_THRESHOLD = Double.valueOf(s);
            }
            if ((s = System.getProperty("com.sun.javafx.gestures.zoom.inertia")) != null) {
                ZOOM_INERTIA_ENABLED = Boolean.valueOf(s);
            }
            return null;
        });
    }

    private static enum ZoomRecognitionState {
        IDLE,
        TRACKING,
        ACTIVE,
        PRE_INERTIA,
        INERTIA,
        FAILURE;

    }

    private static class TouchPointTracker {
        double x;
        double y;
        double absX;
        double absY;

        private TouchPointTracker() {
        }

        public void update(long nanos, double x, double y, double absX, double absY) {
            this.x = x;
            this.y = y;
            this.absX = absX;
            this.absY = absY;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getAbsX() {
            return this.absX;
        }

        public double getAbsY() {
            return this.absY;
        }
    }
}

