/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.javafx.geom.PathConsumer2D;

public final class CollinearSimplifier
implements PathConsumer2D {
    static final float EPS = 1.0E-4f;
    PathConsumer2D delegate;
    SimplifierState state;
    float px1;
    float py1;
    float px2;
    float py2;
    float pslope;

    CollinearSimplifier() {
    }

    public CollinearSimplifier init(PathConsumer2D delegate) {
        this.delegate = delegate;
        this.state = SimplifierState.Empty;
        return this;
    }

    @Override
    public void pathDone() {
        this.emitStashedLine();
        this.state = SimplifierState.Empty;
        this.delegate.pathDone();
    }

    @Override
    public void closePath() {
        this.emitStashedLine();
        this.state = SimplifierState.Empty;
        this.delegate.closePath();
    }

    @Override
    public void quadTo(float x1, float y1, float x2, float y2) {
        this.emitStashedLine();
        this.delegate.quadTo(x1, y1, x2, y2);
        this.state = SimplifierState.PreviousPoint;
        this.px1 = x2;
        this.py1 = y2;
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.emitStashedLine();
        this.delegate.curveTo(x1, y1, x2, y2, x3, y3);
        this.state = SimplifierState.PreviousPoint;
        this.px1 = x3;
        this.py1 = y3;
    }

    @Override
    public void moveTo(float x, float y) {
        this.emitStashedLine();
        this.delegate.moveTo(x, y);
        this.state = SimplifierState.PreviousPoint;
        this.px1 = x;
        this.py1 = y;
    }

    @Override
    public void lineTo(float x, float y) {
        switch (this.state) {
            case Empty: {
                this.delegate.lineTo(x, y);
                this.state = SimplifierState.PreviousPoint;
                this.px1 = x;
                this.py1 = y;
                return;
            }
            case PreviousPoint: {
                this.state = SimplifierState.PreviousLine;
                this.px2 = x;
                this.py2 = y;
                this.pslope = CollinearSimplifier.getSlope(this.px1, this.py1, x, y);
                return;
            }
            case PreviousLine: {
                float slope = CollinearSimplifier.getSlope(this.px2, this.py2, x, y);
                if (slope == this.pslope || Math.abs(this.pslope - slope) < 1.0E-4f) {
                    this.px2 = x;
                    this.py2 = y;
                    return;
                }
                this.delegate.lineTo(this.px2, this.py2);
                this.px1 = this.px2;
                this.py1 = this.py2;
                this.px2 = x;
                this.py2 = y;
                this.pslope = slope;
                return;
            }
        }
    }

    private void emitStashedLine() {
        if (this.state == SimplifierState.PreviousLine) {
            this.delegate.lineTo(this.px2, this.py2);
        }
    }

    private static float getSlope(float x1, float y1, float x2, float y2) {
        float dy = y2 - y1;
        if (dy == 0.0f) {
            return x2 > x1 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        return (x2 - x1) / dy;
    }

    static enum SimplifierState {
        Empty,
        PreviousPoint,
        PreviousLine;

    }
}

