/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.glass.ui.Screen;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.geom.Rectangle;
import com.sun.prism.CompositeMode;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Graphics;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.ES2RenderTarget;
import com.sun.prism.es2.GLContext;
import com.sun.prism.es2.GLDrawable;
import com.sun.prism.impl.PrismSettings;

class ES2SwapChain
implements ES2RenderTarget,
Presentable,
GraphicsResource {
    private final ES2Context context;
    private final PresentableState pState;
    private GLDrawable drawable;
    private boolean needsResize;
    private boolean opaque = false;
    private int w;
    private int h;
    private float pixelScaleFactorX;
    private float pixelScaleFactorY;
    int nativeDestHandle = 0;
    private final boolean msaa;
    private RTTexture stableBackbuffer;
    private boolean copyFullBuffer;

    @Override
    public boolean isOpaque() {
        if (this.stableBackbuffer != null) {
            return this.stableBackbuffer.isOpaque();
        }
        return this.opaque;
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        if (this.stableBackbuffer != null) {
            this.stableBackbuffer.setOpaque(isOpaque);
        } else {
            this.opaque = isOpaque;
        }
    }

    ES2SwapChain(ES2Context context, PresentableState pState) {
        this.context = context;
        this.pState = pState;
        this.pixelScaleFactorX = pState.getRenderScaleX();
        this.pixelScaleFactorY = pState.getRenderScaleY();
        this.msaa = pState.isMSAA();
        long nativeWindow = pState.getNativeWindow();
        this.drawable = ES2Pipeline.glFactory.createGLDrawable(nativeWindow, context.getPixelFormat());
    }

    @Override
    public boolean lockResources(PresentableState pState) {
        if (this.pState != pState || this.pixelScaleFactorX != pState.getRenderScaleX() || this.pixelScaleFactorY != pState.getRenderScaleY()) {
            return true;
        }
        boolean bl = this.needsResize = this.w != pState.getRenderWidth() || this.h != pState.getRenderHeight();
        if (this.stableBackbuffer != null && !this.needsResize) {
            this.stableBackbuffer.lock();
            if (this.stableBackbuffer.isSurfaceLost()) {
                this.stableBackbuffer = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean prepare(Rectangle clip) {
        try {
            ES2Graphics g = ES2Graphics.create(this.context, this);
            if (this.stableBackbuffer != null) {
                if (this.needsResize) {
                    g.forceRenderTarget();
                    this.needsResize = false;
                }
                this.w = this.pState.getRenderWidth();
                this.h = this.pState.getRenderHeight();
                int sw = this.w;
                int sh = this.h;
                int dw = this.pState.getOutputWidth();
                int dh = this.pState.getOutputHeight();
                this.copyFullBuffer = false;
                if (this.isMSAA()) {
                    this.context.flushVertexBuffer();
                    g.blit(this.stableBackbuffer, null, 0, 0, sw, sh, 0, dh, dw, 0);
                } else {
                    this.drawTexture(g, this.stableBackbuffer, 0.0f, 0.0f, dw, dh, 0.0f, 0.0f, sw, sh);
                }
                this.stableBackbuffer.unlock();
            }
            return this.drawable != null;
        }
        catch (Throwable th) {
            if (PrismSettings.verbose) {
                th.printStackTrace();
            }
            return false;
        }
    }

    private void drawTexture(ES2Graphics g, RTTexture src, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2) {
        CompositeMode savedMode = g.getCompositeMode();
        if (!this.pState.hasWindowManager()) {
            g.setExtraAlpha(this.pState.getAlpha());
            g.setCompositeMode(CompositeMode.SRC_OVER);
        } else {
            g.setCompositeMode(CompositeMode.SRC);
        }
        g.drawTexture(src, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
        this.context.flushVertexBuffer();
        g.setCompositeMode(savedMode);
    }

    @Override
    public boolean present() {
        boolean presented = this.drawable.swapBuffers(this.context.getGLContext());
        this.context.makeCurrent(null);
        return presented;
    }

    @Override
    public ES2Graphics createGraphics() {
        if (this.drawable.getNativeWindow() != this.pState.getNativeWindow()) {
            this.drawable = ES2Pipeline.glFactory.createGLDrawable(this.pState.getNativeWindow(), this.context.getPixelFormat());
        }
        this.context.makeCurrent(this.drawable);
        this.nativeDestHandle = this.pState.getNativeFrameBuffer();
        if (this.nativeDestHandle == 0) {
            GLContext glContext = this.context.getGLContext();
            this.nativeDestHandle = glContext.getBoundFBO();
        }
        boolean bl = this.needsResize = this.w != this.pState.getRenderWidth() || this.h != this.pState.getRenderHeight();
        if (this.stableBackbuffer == null || this.needsResize) {
            if (this.stableBackbuffer != null) {
                this.stableBackbuffer.dispose();
                this.stableBackbuffer = null;
            } else {
                ES2Graphics.create(this.context, this);
            }
            this.w = this.pState.getRenderWidth();
            this.h = this.pState.getRenderHeight();
            ResourceFactory factory = this.context.getResourceFactory();
            this.stableBackbuffer = factory.createRTTexture(this.w, this.h, Texture.WrapMode.CLAMP_NOT_NEEDED, this.msaa);
            if (PrismSettings.dirtyOptsEnabled) {
                this.stableBackbuffer.contentsUseful();
            }
            this.copyFullBuffer = true;
        }
        ES2Graphics g = ES2Graphics.create(this.context, this.stableBackbuffer);
        g.scale(this.pixelScaleFactorX, this.pixelScaleFactorY);
        return g;
    }

    @Override
    public int getFboID() {
        return this.nativeDestHandle;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.context.getAssociatedScreen();
    }

    @Override
    public int getPhysicalWidth() {
        return this.pState.getOutputWidth();
    }

    @Override
    public int getPhysicalHeight() {
        return this.pState.getOutputHeight();
    }

    @Override
    public int getContentX() {
        if (PlatformUtil.useEGL()) {
            return this.pState.getWindowX();
        }
        return 0;
    }

    @Override
    public int getContentY() {
        if (PlatformUtil.useEGL()) {
            return this.pState.getScreenHeight() - this.pState.getOutputHeight() - this.pState.getWindowY();
        }
        return 0;
    }

    @Override
    public int getContentWidth() {
        return this.pState.getOutputWidth();
    }

    @Override
    public int getContentHeight() {
        return this.pState.getOutputHeight();
    }

    @Override
    public float getPixelScaleFactorX() {
        return this.pixelScaleFactorX;
    }

    @Override
    public float getPixelScaleFactorY() {
        return this.pixelScaleFactorY;
    }

    @Override
    public void dispose() {
        if (this.stableBackbuffer != null) {
            this.stableBackbuffer.dispose();
            this.stableBackbuffer = null;
        }
    }

    @Override
    public boolean isMSAA() {
        return this.stableBackbuffer != null ? this.stableBackbuffer.isMSAA() : this.msaa;
    }
}

