/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.impl.ManagedResource;
import java.nio.Buffer;

public abstract class BaseTexture<T extends ManagedResource>
implements Texture {
    protected final T resource;
    private final PixelFormat format;
    private final int physicalWidth;
    private final int physicalHeight;
    private final int contentX;
    private final int contentY;
    protected int contentWidth;
    protected int contentHeight;
    private final int maxContentWidth;
    private final int maxContentHeight;
    private final Texture.WrapMode wrapMode;
    private final boolean useMipmap;
    private boolean linearFiltering = true;
    private int lastImageSerial;

    protected BaseTexture(BaseTexture<T> sharedTex, Texture.WrapMode newMode, boolean useMipmap) {
        this.resource = sharedTex.resource;
        this.format = sharedTex.format;
        this.wrapMode = newMode;
        this.physicalWidth = sharedTex.physicalWidth;
        this.physicalHeight = sharedTex.physicalHeight;
        this.contentX = sharedTex.contentX;
        this.contentY = sharedTex.contentY;
        this.contentWidth = sharedTex.contentWidth;
        this.contentHeight = sharedTex.contentHeight;
        this.maxContentWidth = sharedTex.maxContentWidth;
        this.maxContentHeight = sharedTex.maxContentHeight;
        this.useMipmap = useMipmap;
    }

    protected BaseTexture(T resource, PixelFormat format, Texture.WrapMode wrapMode, int width, int height) {
        this(resource, format, wrapMode, width, height, 0, 0, width, height, false);
    }

    protected BaseTexture(T resource, PixelFormat format, Texture.WrapMode wrapMode, int physicalWidth, int physicalHeight, int contentX, int contentY, int contentWidth, int contentHeight, boolean useMipmap) {
        this.resource = resource;
        this.format = format;
        this.wrapMode = wrapMode;
        this.physicalWidth = physicalWidth;
        this.physicalHeight = physicalHeight;
        this.contentX = contentX;
        this.contentY = contentY;
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
        this.maxContentWidth = physicalWidth;
        this.maxContentHeight = physicalHeight;
        this.useMipmap = useMipmap;
    }

    protected BaseTexture(T resource, PixelFormat format, Texture.WrapMode wrapMode, int physicalWidth, int physicalHeight, int contentX, int contentY, int contentWidth, int contentHeight, int maxContentWidth, int maxContentHeight, boolean useMipmap) {
        this.resource = resource;
        this.format = format;
        this.wrapMode = wrapMode;
        this.physicalWidth = physicalWidth;
        this.physicalHeight = physicalHeight;
        this.contentX = contentX;
        this.contentY = contentY;
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
        this.maxContentWidth = maxContentWidth;
        this.maxContentHeight = maxContentHeight;
        this.useMipmap = useMipmap;
    }

    @Override
    public final PixelFormat getPixelFormat() {
        return this.format;
    }

    @Override
    public final int getPhysicalWidth() {
        return this.physicalWidth;
    }

    @Override
    public final int getPhysicalHeight() {
        return this.physicalHeight;
    }

    @Override
    public final int getContentX() {
        return this.contentX;
    }

    @Override
    public final int getContentY() {
        return this.contentY;
    }

    @Override
    public final int getContentWidth() {
        return this.contentWidth;
    }

    @Override
    public final int getContentHeight() {
        return this.contentHeight;
    }

    @Override
    public int getMaxContentWidth() {
        return this.maxContentWidth;
    }

    @Override
    public int getMaxContentHeight() {
        return this.maxContentHeight;
    }

    @Override
    public void setContentWidth(int contentW) {
        if (contentW > this.maxContentWidth) {
            throw new IllegalArgumentException("ContentWidth must be less than or equal to maxContentWidth");
        }
        this.contentWidth = contentW;
    }

    @Override
    public void setContentHeight(int contentH) {
        if (contentH > this.maxContentHeight) {
            throw new IllegalArgumentException("ContentWidth must be less than or equal to maxContentHeight");
        }
        this.contentHeight = contentH;
    }

    @Override
    public final Texture.WrapMode getWrapMode() {
        return this.wrapMode;
    }

    @Override
    public boolean getUseMipmap() {
        return this.useMipmap;
    }

    @Override
    public Texture getSharedTexture(Texture.WrapMode altMode) {
        this.assertLocked();
        if (this.wrapMode == altMode) {
            this.lock();
            return this;
        }
        switch (altMode) {
            case REPEAT: {
                if (this.wrapMode == Texture.WrapMode.CLAMP_TO_EDGE) break;
                return null;
            }
            case CLAMP_TO_EDGE: {
                if (this.wrapMode == Texture.WrapMode.REPEAT) break;
                return null;
            }
            default: {
                return null;
            }
        }
        Texture altTex = this.createSharedTexture(altMode);
        altTex.lock();
        return altTex;
    }

    protected abstract Texture createSharedTexture(Texture.WrapMode var1);

    @Override
    public final boolean getLinearFiltering() {
        return this.linearFiltering;
    }

    @Override
    public void setLinearFiltering(boolean linear) {
        this.linearFiltering = linear;
    }

    @Override
    public final int getLastImageSerial() {
        return this.lastImageSerial;
    }

    @Override
    public final void setLastImageSerial(int serial) {
        this.lastImageSerial = serial;
    }

    @Override
    public final void lock() {
        ((ManagedResource)this.resource).lock();
    }

    @Override
    public final boolean isLocked() {
        return ((ManagedResource)this.resource).isLocked();
    }

    @Override
    public final int getLockCount() {
        return ((ManagedResource)this.resource).getLockCount();
    }

    @Override
    public final void assertLocked() {
        ((ManagedResource)this.resource).assertLocked();
    }

    @Override
    public final void unlock() {
        ((ManagedResource)this.resource).unlock();
    }

    @Override
    public final void makePermanent() {
        ((ManagedResource)this.resource).makePermanent();
    }

    @Override
    public final void contentsUseful() {
        ((ManagedResource)this.resource).contentsUseful();
    }

    @Override
    public final void contentsNotUseful() {
        ((ManagedResource)this.resource).contentsNotUseful();
    }

    @Override
    public final boolean isSurfaceLost() {
        return !((ManagedResource)this.resource).isValid();
    }

    @Override
    public final void dispose() {
        ((ManagedResource)this.resource).dispose();
    }

    @Override
    public void update(Image img) {
        this.update(img, 0, 0);
    }

    @Override
    public void update(Image img, int dstx, int dsty) {
        this.update(img, dstx, dsty, img.getWidth(), img.getHeight());
    }

    @Override
    public void update(Image img, int dstx, int dsty, int w, int h) {
        this.update(img, dstx, dsty, w, h, false);
    }

    @Override
    public void update(Image img, int dstx, int dsty, int srcw, int srch, boolean skipFlush) {
        Buffer pbuffer = img.getPixelBuffer();
        int pos = pbuffer.position();
        this.update(pbuffer, img.getPixelFormat(), dstx, dsty, img.getMinX(), img.getMinY(), srcw, srch, img.getScanlineStride(), skipFlush);
        pbuffer.position(pos);
    }

    protected void checkUpdateParams(Buffer buf, PixelFormat fmt, int dstx, int dsty, int srcx, int srcy, int srcw, int srch, int srcscan) {
        if (this.format == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("MULTI_YCbCr_420 requires multitexturing");
        }
        if (buf == null) {
            throw new IllegalArgumentException("Pixel buffer must be non-null");
        }
        if (fmt != this.format) {
            throw new IllegalArgumentException("Image format (" + fmt + ") must match texture format (" + this.format + ")");
        }
        if (dstx < 0 || dsty < 0) {
            throw new IllegalArgumentException("dstx (" + dstx + ") and dsty (" + dsty + ") must be >= 0");
        }
        if (srcx < 0 || srcy < 0) {
            throw new IllegalArgumentException("srcx (" + srcx + ") and srcy (" + srcy + ") must be >= 0");
        }
        if (srcw <= 0 || srch <= 0) {
            throw new IllegalArgumentException("srcw (" + srcw + ") and srch (" + srch + ") must be > 0");
        }
        int bytesPerPixel = fmt.getBytesPerPixelUnit();
        if (srcscan % bytesPerPixel != 0) {
            throw new IllegalArgumentException("srcscan (" + srcscan + ") must be a multiple of the pixel stride (" + bytesPerPixel + ")");
        }
        if (srcw > srcscan / bytesPerPixel) {
            throw new IllegalArgumentException("srcw (" + srcw + ") must be <= srcscan/bytesPerPixel (" + srcscan / bytesPerPixel + ")");
        }
        if (dstx + srcw > this.contentWidth || dsty + srch > this.contentHeight) {
            throw new IllegalArgumentException("Destination region (x=" + dstx + ", y=" + dsty + ", w=" + srcw + ", h=" + srch + ") must fit within texture content bounds (contentWidth=" + this.contentWidth + ", contentHeight=" + this.contentHeight + ")");
        }
        int bytesNeeded = srcx * bytesPerPixel + srcy * srcscan + (srch - 1) * srcscan + srcw * bytesPerPixel;
        int elemsNeeded = bytesNeeded / this.format.getDataType().getSizeInBytes();
        if (elemsNeeded > buf.remaining()) {
            throw new IllegalArgumentException("Upload requires " + elemsNeeded + " elements, but only " + buf.remaining() + " elements remain in the buffer");
        }
    }

    public String toString() {
        return super.toString() + " [format=" + this.format + " physicalWidth=" + this.physicalWidth + " physicalHeight=" + this.physicalHeight + " contentX=" + this.contentX + " contentY=" + this.contentY + " contentWidth=" + this.contentWidth + " contentHeight=" + this.contentHeight + " wrapMode=" + this.wrapMode + " linearFiltering=" + this.linearFiltering + "]";
    }
}

