/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.prism.PixelFormat;
import com.sun.prism.impl.BaseResourcePool;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;
import java.awt.image.BufferedImage;

class J2DTexturePool
extends BaseResourcePool<BufferedImage>
implements TextureResourcePool<BufferedImage> {
    static final J2DTexturePool instance = new J2DTexturePool();

    private static long maxVram() {
        long heapmax = Runtime.getRuntime().maxMemory();
        long setmax = PrismSettings.maxVram;
        return Math.min(heapmax / 4L, setmax);
    }

    private static long targetVram() {
        long max = J2DTexturePool.maxVram();
        return Math.min(max / 2L, PrismSettings.targetVram);
    }

    private J2DTexturePool() {
        super(null, J2DTexturePool.targetVram(), J2DTexturePool.maxVram());
    }

    @Override
    public long used() {
        Runtime r = Runtime.getRuntime();
        long heapused = r.totalMemory() - r.freeMemory();
        long heapfree = r.maxMemory() - heapused;
        long managedfree = this.max() - this.managed();
        return this.max() - Math.min(heapfree, managedfree);
    }

    static long size(int w, int h, int type) {
        long size = (long)w * (long)h;
        switch (type) {
            case 5: {
                return size * 3L;
            }
            case 10: {
                return size;
            }
            case 3: {
                return size * 4L;
            }
        }
        throw new InternalError("Unrecognized BufferedImage");
    }

    @Override
    public long size(BufferedImage resource) {
        return J2DTexturePool.size(resource.getWidth(), resource.getHeight(), resource.getType());
    }

    @Override
    public long estimateTextureSize(int width, int height, PixelFormat format) {
        int type;
        switch (format) {
            case BYTE_RGB: {
                type = 5;
                break;
            }
            case BYTE_GRAY: {
                type = 10;
                break;
            }
            case INT_ARGB_PRE: 
            case BYTE_BGRA_PRE: {
                type = 3;
                break;
            }
            default: {
                throw new InternalError("Unrecognized PixelFormat (" + format + ")!");
            }
        }
        return J2DTexturePool.size(width, height, type);
    }

    @Override
    public long estimateRTTextureSize(int width, int height, boolean hasDepth) {
        return J2DTexturePool.size(width, height, 3);
    }

    public String toString() {
        return "J2D Texture Pool";
    }
}

