/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.javafx.animation.TickCalculation;
import com.sun.scenario.animation.shared.AnimationAccessor;
import com.sun.scenario.animation.shared.ClipInterpolator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.util.Duration;

public class TimelineClipCore {
    private static final int UNDEFINED_KEYFRAME = -1;
    private static final Comparator<KeyFrame> KEY_FRAME_COMPARATOR = (kf1, kf2) -> kf1.getTime().compareTo(kf2.getTime());
    Timeline timeline;
    private KeyFrame[] keyFrames = new KeyFrame[0];
    private long[] keyFrameTicks = new long[0];
    private boolean canSkipFrames = true;
    private ClipInterpolator clipInterpolator;
    private boolean aborted = false;
    private int lastKF = -1;
    private long curTicks = 0L;

    public TimelineClipCore(Timeline timeline) {
        this.timeline = timeline;
        this.clipInterpolator = ClipInterpolator.create(this.keyFrames, this.keyFrameTicks);
    }

    public Duration setKeyFrames(Collection<KeyFrame> keyFrames) {
        int n = keyFrames.size();
        KeyFrame[] sortedKeyFrames = new KeyFrame[n];
        keyFrames.toArray(sortedKeyFrames);
        Arrays.sort(sortedKeyFrames, KEY_FRAME_COMPARATOR);
        this.canSkipFrames = true;
        this.keyFrames = sortedKeyFrames;
        this.keyFrameTicks = new long[n];
        for (int i = 0; i < n; ++i) {
            this.keyFrameTicks[i] = TickCalculation.fromDuration(this.keyFrames[i].getTime());
            if (!this.canSkipFrames || this.keyFrames[i].getOnFinished() == null) continue;
            this.canSkipFrames = false;
        }
        this.clipInterpolator = this.clipInterpolator.setKeyFrames(sortedKeyFrames, this.keyFrameTicks);
        return n == 0 ? Duration.ZERO : sortedKeyFrames[n - 1].getTime();
    }

    public void notifyCurrentRateChanged() {
        if (this.timeline.getStatus() != Animation.Status.RUNNING) {
            this.clearLastKeyFrame();
        }
    }

    public void abort() {
        this.aborted = true;
    }

    private void clearLastKeyFrame() {
        this.lastKF = -1;
    }

    public void jumpTo(long ticks, boolean forceJump) {
        this.lastKF = -1;
        this.curTicks = ticks;
        if (this.timeline.getStatus() != Animation.Status.STOPPED || forceJump) {
            if (forceJump) {
                this.clipInterpolator.validate(false);
            }
            this.clipInterpolator.interpolate(ticks);
        }
    }

    public void start(boolean forceSync) {
        this.clearLastKeyFrame();
        this.clipInterpolator.validate(forceSync);
        if (this.curTicks > 0L) {
            this.clipInterpolator.interpolate(this.curTicks);
        }
    }

    public void playTo(long ticks) {
        boolean forward;
        if (this.canSkipFrames) {
            this.clearLastKeyFrame();
            this.setTime(ticks);
            this.clipInterpolator.interpolate(ticks);
            return;
        }
        this.aborted = false;
        boolean bl = forward = this.curTicks <= ticks;
        if (forward) {
            int fromKF = this.lastKF == -1 ? 0 : (this.keyFrameTicks[this.lastKF] <= this.curTicks ? this.lastKF + 1 : this.lastKF);
            int toKF = this.keyFrames.length;
            for (int fi = fromKF; fi < toKF; ++fi) {
                long kfTicks = this.keyFrameTicks[fi];
                if (kfTicks > ticks) {
                    this.lastKF = fi - 1;
                } else {
                    if (kfTicks < this.curTicks) continue;
                    this.visitKeyFrame(fi, kfTicks);
                    if (!this.aborted) {
                        continue;
                    }
                }
                break;
            }
        } else {
            int fromKF;
            for (int fi = fromKF = this.lastKF == -1 ? this.keyFrames.length - 1 : (this.keyFrameTicks[this.lastKF] >= this.curTicks ? this.lastKF - 1 : this.lastKF); fi >= 0; --fi) {
                long kfTicks = this.keyFrameTicks[fi];
                if (kfTicks < ticks) {
                    this.lastKF = fi + 1;
                } else {
                    if (kfTicks > this.curTicks) continue;
                    this.visitKeyFrame(fi, kfTicks);
                    if (!this.aborted) {
                        continue;
                    }
                }
                break;
            }
        }
        if (!(this.aborted || this.lastKF != -1 && this.keyFrameTicks[this.lastKF] == ticks && this.keyFrames[this.lastKF].getOnFinished() != null)) {
            this.setTime(ticks);
            this.clipInterpolator.interpolate(ticks);
        }
    }

    private void setTime(long ticks) {
        this.curTicks = ticks;
        AnimationAccessor.getDefault().setCurrentTicks(this.timeline, ticks);
    }

    private void visitKeyFrame(int kfIndex, long kfTicks) {
        if (kfIndex != this.lastKF) {
            this.lastKF = kfIndex;
            KeyFrame kf = this.keyFrames[kfIndex];
            EventHandler<ActionEvent> onFinished = kf.getOnFinished();
            if (onFinished != null) {
                this.setTime(kfTicks);
                this.clipInterpolator.interpolate(kfTicks);
                try {
                    onFinished.handle((Event)new ActionEvent((Object)kf, null));
                }
                catch (Throwable ex) {
                    Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), ex);
                }
            }
        }
    }
}

