/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.Offset;
import com.sun.scenario.effect.impl.Renderer;
import java.util.HashMap;
import java.util.Map;

public class Identity
extends Effect {
    private Filterable src;
    private Point2D loc = new Point2D();
    private final Map<FilterContext, ImageData> datacache = new HashMap<FilterContext, ImageData>();

    public Identity(Filterable src) {
        this.src = src;
    }

    public final Filterable getSource() {
        return this.src;
    }

    public void setSource(Filterable src) {
        Filterable old = this.src;
        this.src = src;
        this.clearCache();
    }

    public final Point2D getLocation() {
        return this.loc;
    }

    public void setLocation(Point2D pt) {
        if (pt == null) {
            throw new IllegalArgumentException("Location must be non-null");
        }
        Point2D old = this.loc;
        this.loc.setLocation(pt);
    }

    @Override
    public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
        if (this.src == null) {
            return new RectBounds();
        }
        float srcw = (float)this.src.getPhysicalWidth() / this.src.getPixelScale();
        float srch = (float)this.src.getPhysicalHeight() / this.src.getPixelScale();
        BaseBounds r = new RectBounds(this.loc.x, this.loc.y, this.loc.x + srcw, this.loc.y + srch);
        if (transform != null && !transform.isIdentity()) {
            r = Identity.transformBounds(transform, r);
        }
        return r;
    }

    @Override
    public ImageData filter(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
        ImageData id = this.datacache.get(fctx);
        if (id != null && !id.addref()) {
            id.setReusable(false);
            this.datacache.remove(fctx);
            id.unref();
            id = null;
        }
        if (id == null) {
            Renderer r = Renderer.getRenderer(fctx);
            Filterable f = this.src;
            if (f == null) {
                f = Identity.getCompatibleImage(fctx, 1, 1);
                id = new ImageData(fctx, f, new Rectangle(1, 1));
            } else {
                id = r.createImageData(fctx, f);
            }
            if (id == null) {
                return new ImageData(fctx, null, null);
            }
            id.setReusable(true);
            this.datacache.put(fctx, id);
        }
        transform = Offset.getOffsetTransform(transform, this.loc.x, this.loc.y);
        id = id.transform(transform);
        return id;
    }

    @Override
    public Effect.AccelType getAccelType(FilterContext fctx) {
        return Effect.AccelType.INTRINSIC;
    }

    private void clearCache() {
        this.datacache.clear();
    }

    @Override
    public boolean reducesOpaquePixels() {
        return true;
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        DirtyRegionContainer drc = regionPool.checkOut();
        drc.reset();
        return drc;
    }
}

