/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javafx.animation.KeyValue;
import javafx.beans.NamedArg;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.util.Duration;

public final class KeyFrame {
    private static final EventHandler<ActionEvent> DEFAULT_ON_FINISHED = null;
    private static final String DEFAULT_NAME = null;
    private final Duration time;
    private final Set<KeyValue> values;
    private final EventHandler<ActionEvent> onFinished;
    private final String name;

    public Duration getTime() {
        return this.time;
    }

    public Set<KeyValue> getValues() {
        return this.values;
    }

    public EventHandler<ActionEvent> getOnFinished() {
        return this.onFinished;
    }

    public String getName() {
        return this.name;
    }

    public KeyFrame(@NamedArg(value="time") Duration time, @NamedArg(value="name") String name, @NamedArg(value="onFinished") EventHandler<ActionEvent> onFinished, @NamedArg(value="values") Collection<KeyValue> values) {
        if (time == null) {
            throw new NullPointerException("The time has to be specified");
        }
        if (time.lessThan(Duration.ZERO) || time.equals((Object)Duration.UNKNOWN)) {
            throw new IllegalArgumentException("The time is invalid.");
        }
        this.time = time;
        this.name = name;
        if (values != null) {
            CopyOnWriteArraySet<KeyValue> set = new CopyOnWriteArraySet<KeyValue>(values);
            set.remove(null);
            this.values = set.size() == 0 ? Collections.emptySet() : (set.size() == 1 ? Collections.singleton((KeyValue)set.iterator().next()) : Collections.unmodifiableSet(set));
        } else {
            this.values = Collections.emptySet();
        }
        this.onFinished = onFinished;
    }

    public KeyFrame(@NamedArg(value="time") Duration time, @NamedArg(value="name") String name, @NamedArg(value="onFinished") EventHandler<ActionEvent> onFinished, KeyValue ... values) {
        if (time == null) {
            throw new NullPointerException("The time has to be specified");
        }
        if (time.lessThan(Duration.ZERO) || time.equals((Object)Duration.UNKNOWN)) {
            throw new IllegalArgumentException("The time is invalid.");
        }
        this.time = time;
        this.name = name;
        if (values != null) {
            CopyOnWriteArraySet<KeyValue> set = new CopyOnWriteArraySet<KeyValue>();
            for (KeyValue keyValue : values) {
                if (keyValue == null) continue;
                set.add(keyValue);
            }
            this.values = set.size() == 0 ? Collections.emptySet() : (set.size() == 1 ? Collections.singleton((KeyValue)set.iterator().next()) : Collections.unmodifiableSet(set));
        } else {
            this.values = Collections.emptySet();
        }
        this.onFinished = onFinished;
    }

    public KeyFrame(@NamedArg(value="time") Duration time, @NamedArg(value="onFinished") EventHandler<ActionEvent> onFinished, KeyValue ... values) {
        this(time, DEFAULT_NAME, onFinished, values);
    }

    public KeyFrame(@NamedArg(value="time") Duration time, @NamedArg(value="name") String name, KeyValue ... values) {
        this(time, name, DEFAULT_ON_FINISHED, values);
    }

    public KeyFrame(@NamedArg(value="time") Duration time, KeyValue ... values) {
        this(time, DEFAULT_NAME, DEFAULT_ON_FINISHED, values);
    }

    public String toString() {
        return "KeyFrame [time=" + this.time + ", values=" + this.values + ", onFinished=" + this.onFinished + ", name=" + this.name + "]";
    }

    public int hashCode() {
        assert (this.time != null && this.values != null);
        int prime = 31;
        int result = 1;
        result = 31 * result + this.time.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.onFinished == null ? 0 : this.onFinished.hashCode());
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof KeyFrame) {
            KeyFrame kf = (KeyFrame)obj;
            assert (this.time != null && this.values != null && kf.time != null && kf.values != null);
            return this.time.equals((Object)kf.time) && (this.name == null ? kf.name == null : this.name.equals(kf.name)) && (this.onFinished == null ? kf.onFinished == null : this.onFinished.equals(kf.onFinished)) && this.values.equals(kf.values);
        }
        return false;
    }
}

