/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import javafx.animation.Transition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.util.Duration;

public final class PauseTransition
extends Transition {
    private ObjectProperty<Duration> duration;
    private static final Duration DEFAULT_DURATION = Duration.millis((double)400.0);

    public final void setDuration(Duration value) {
        if (this.duration != null || !DEFAULT_DURATION.equals((Object)value)) {
            this.durationProperty().set((Object)value);
        }
    }

    public final Duration getDuration() {
        return this.duration == null ? DEFAULT_DURATION : (Duration)this.duration.get();
    }

    public final ObjectProperty<Duration> durationProperty() {
        if (this.duration == null) {
            this.duration = new ObjectPropertyBase<Duration>(DEFAULT_DURATION){

                public void invalidated() {
                    try {
                        PauseTransition.this.setCycleDuration(PauseTransition.this.getDuration());
                    }
                    catch (IllegalArgumentException e) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(PauseTransition.this.getCycleDuration());
                        throw e;
                    }
                }

                public Object getBean() {
                    return PauseTransition.this;
                }

                public String getName() {
                    return "duration";
                }
            };
        }
        return this.duration;
    }

    public PauseTransition(Duration duration) {
        this.setDuration(duration);
        this.setCycleDuration(duration);
    }

    public PauseTransition() {
        this(DEFAULT_DURATION);
    }

    @Override
    public void interpolate(double frac) {
    }
}

