/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.collections.TrackableObservableList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.Declaration;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Stylesheet;
import javafx.scene.Node;

public final class Rule {
    private List<Selector> selectors = null;
    private List<Declaration> declarations = null;
    private Observables observables = null;
    private Stylesheet stylesheet;
    private byte[] serializedDecls;
    private final int bssVersion;

    List<Selector> getUnobservedSelectorList() {
        if (this.selectors == null) {
            this.selectors = new ArrayList<Selector>();
        }
        return this.selectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Declaration> getUnobservedDeclarationList() {
        if (this.declarations == null && this.serializedDecls != null) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(this.serializedDecls);
                DataInputStream dis = new DataInputStream(bis);
                int nDeclarations = dis.readShort();
                this.declarations = new ArrayList<Declaration>(nDeclarations);
                for (int i = 0; i < nDeclarations; ++i) {
                    Declaration decl = Declaration.readBinary(this.bssVersion, dis, this.stylesheet.getStringStore());
                    decl.rule = this;
                    if (this.stylesheet != null && this.stylesheet.getUrl() != null) {
                        String stylesheetUrl = this.stylesheet.getUrl();
                        decl.fixUrl(stylesheetUrl);
                    }
                    this.declarations.add(decl);
                }
            }
            catch (IOException ioe) {
                this.declarations = new ArrayList<Declaration>();
                assert (false);
                ioe.getMessage();
            }
            finally {
                this.serializedDecls = null;
            }
        }
        return this.declarations;
    }

    public final ObservableList<Declaration> getDeclarations() {
        if (this.observables == null) {
            this.observables = new Observables(this);
        }
        return this.observables.getDeclarations();
    }

    public final ObservableList<Selector> getSelectors() {
        if (this.observables == null) {
            this.observables = new Observables(this);
        }
        return this.observables.getSelectors();
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    void setStylesheet(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
        if (stylesheet != null && stylesheet.getUrl() != null) {
            String stylesheetUrl = stylesheet.getUrl();
            int nDeclarations = this.declarations != null ? this.declarations.size() : 0;
            for (int d = 0; d < nDeclarations; ++d) {
                this.declarations.get(d).fixUrl(stylesheetUrl);
            }
        }
    }

    public StyleOrigin getOrigin() {
        return this.stylesheet != null ? this.stylesheet.getOrigin() : null;
    }

    Rule(List<Selector> selectors, List<Declaration> declarations) {
        this.selectors = selectors;
        this.declarations = declarations;
        this.serializedDecls = null;
        this.bssVersion = 6;
        int sMax = selectors != null ? selectors.size() : 0;
        for (int i = 0; i < sMax; ++i) {
            Selector sel = selectors.get(i);
            sel.setRule(this);
        }
        int dMax = declarations != null ? declarations.size() : 0;
        for (int d = 0; d < dMax; ++d) {
            Declaration decl = declarations.get(d);
            decl.rule = this;
        }
    }

    private Rule(List<Selector> selectors, byte[] buf, int bssVersion) {
        this.selectors = selectors;
        this.declarations = null;
        this.serializedDecls = buf;
        this.bssVersion = bssVersion;
        int sMax = selectors != null ? selectors.size() : 0;
        for (int i = 0; i < sMax; ++i) {
            Selector sel = selectors.get(i);
            sel.setRule(this);
        }
    }

    long applies(Node node, Set<PseudoClass>[] triggerStates) {
        long mask = 0L;
        for (int i = 0; i < this.selectors.size(); ++i) {
            Selector sel = this.selectors.get(i);
            if (!sel.applies(node, triggerStates, 0)) continue;
            mask |= 1L << i;
        }
        return mask;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.selectors.size() > 0) {
            sb.append(this.selectors.get(0));
        }
        for (int n = 1; n < this.selectors.size(); ++n) {
            sb.append(',');
            sb.append(this.selectors.get(n));
        }
        sb.append("{\n");
        int nDeclarations = this.declarations != null ? this.declarations.size() : 0;
        for (int n = 0; n < nDeclarations; ++n) {
            sb.append("\t");
            sb.append(this.declarations.get(n));
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    final void writeBinary(DataOutputStream os, StyleConverter.StringStore stringStore) throws IOException {
        int nSelectors = this.selectors != null ? this.selectors.size() : 0;
        os.writeShort(nSelectors);
        for (int i = 0; i < nSelectors; ++i) {
            Selector sel = this.selectors.get(i);
            sel.writeBinary(os, stringStore);
        }
        List<Declaration> decls = this.getUnobservedDeclarationList();
        if (decls != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(5192);
            DataOutputStream dos = new DataOutputStream(bos);
            int nDeclarations = decls.size();
            dos.writeShort(nDeclarations);
            for (int i = 0; i < nDeclarations; ++i) {
                Declaration decl = this.declarations.get(i);
                decl.writeBinary(dos, stringStore);
            }
            os.writeInt(bos.size());
            os.write(bos.toByteArray());
        } else {
            os.writeShort(0);
        }
    }

    static Rule readBinary(int bssVersion, DataInputStream is, String[] strings) throws IOException {
        int nSelectors = is.readShort();
        ArrayList<Selector> selectors = new ArrayList<Selector>(nSelectors);
        for (int i = 0; i < nSelectors; ++i) {
            Selector s = Selector.readBinary(bssVersion, is, strings);
            selectors.add(s);
        }
        if (bssVersion < 4) {
            int nDeclarations = is.readShort();
            ArrayList<Declaration> declarations = new ArrayList<Declaration>(nDeclarations);
            for (int i = 0; i < nDeclarations; ++i) {
                Declaration d = Declaration.readBinary(bssVersion, is, strings);
                declarations.add(d);
            }
            return new Rule(selectors, declarations);
        }
        int nBytes = is.readInt();
        byte[] buf = new byte[nBytes];
        if (nBytes > 0) {
            is.readFully(buf);
        }
        return new Rule(selectors, buf, bssVersion);
    }

    private static final class Observables {
        private final Rule rule;
        private final ObservableList<Selector> selectorObservableList;
        private final ObservableList<Declaration> declarationObservableList;

        private Observables(Rule rule) {
            this.rule = rule;
            this.selectorObservableList = new TrackableObservableList<Selector>(rule.getUnobservedSelectorList()){

                protected void onChanged(ListChangeListener.Change<Selector> c) {
                    while (c.next()) {
                        Selector sel;
                        int i;
                        int max;
                        if (c.wasAdded()) {
                            List added = c.getAddedSubList();
                            max = added.size();
                            for (i = 0; i < max; ++i) {
                                sel = (Selector)added.get(i);
                                sel.setRule(rule);
                            }
                        }
                        if (!c.wasRemoved()) continue;
                        List removed = c.getAddedSubList();
                        max = removed.size();
                        for (i = 0; i < max; ++i) {
                            sel = (Selector)removed.get(i);
                            if (sel.getRule() != rule) continue;
                            sel.setRule(null);
                        }
                    }
                }
            };
            this.declarationObservableList = new TrackableObservableList<Declaration>(rule.getUnobservedDeclarationList()){

                protected void onChanged(ListChangeListener.Change<Declaration> c) {
                    while (c.next()) {
                        Declaration decl;
                        int i;
                        int max;
                        if (c.wasAdded()) {
                            List added = c.getAddedSubList();
                            max = added.size();
                            for (i = 0; i < max; ++i) {
                                decl = (Declaration)added.get(i);
                                decl.rule = rule;
                                Stylesheet stylesheet = rule.stylesheet;
                                if (stylesheet == null || stylesheet.getUrl() == null) continue;
                                String stylesheetUrl = stylesheet.getUrl();
                                decl.fixUrl(stylesheetUrl);
                            }
                        }
                        if (!c.wasRemoved()) continue;
                        List removed = c.getRemoved();
                        max = removed.size();
                        for (i = 0; i < max; ++i) {
                            decl = (Declaration)removed.get(i);
                            if (decl.rule != rule) continue;
                            decl.rule = null;
                        }
                    }
                }
            };
        }

        private ObservableList<Selector> getSelectors() {
            return this.selectorObservableList;
        }

        private ObservableList<Declaration> getDeclarations() {
            return this.declarationObservableList;
        }
    }
}

