/*
 * Decompiled with CFR 0.152.
 */
package javafx.css.converter;

import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public final class ColorConverter
extends StyleConverter<String, Color> {
    public static StyleConverter<String, Color> getInstance() {
        return Holder.COLOR_INSTANCE;
    }

    private ColorConverter() {
    }

    @Override
    public Color convert(ParsedValue<String, Color> value, Font font) {
        String val = value.getValue();
        if (val == null) {
            return null;
        }
        if (val instanceof Color) {
            return (Color)((Object)val);
        }
        if (val instanceof String) {
            String str = val;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            try {
                return Color.web(val);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        System.err.println("not a color: " + value);
        return Color.BLACK;
    }

    public String toString() {
        return "ColorConverter";
    }

    private static class Holder {
        static final ColorConverter COLOR_INSTANCE = new ColorConverter();

        private Holder() {
        }
    }
}

