/*
 * Decompiled with CFR 0.152.
 */
package javafx.print;

import javafx.print.PageOrientation;
import javafx.print.Paper;

public final class PageLayout {
    private PageOrientation orient;
    private Paper paper;
    private double lMargin;
    private double rMargin;
    private double tMargin;
    private double bMargin;

    PageLayout(Paper paper, PageOrientation orient) {
        this(paper, orient, 56.0, 56.0, 56.0, 56.0);
    }

    PageLayout(Paper paper, PageOrientation orient, double leftMargin, double rightMargin, double topMargin, double bottomMargin) {
        if (paper == null || orient == null || leftMargin < 0.0 || rightMargin < 0.0 || topMargin < 0.0 || bottomMargin < 0.0) {
            throw new IllegalArgumentException("Illegal parameters");
        }
        if (orient == PageOrientation.PORTRAIT || orient == PageOrientation.REVERSE_PORTRAIT ? leftMargin + rightMargin > paper.getWidth() || topMargin + bottomMargin > paper.getHeight() : leftMargin + rightMargin > paper.getHeight() || topMargin + bottomMargin > paper.getWidth()) {
            throw new IllegalArgumentException("Bad margins");
        }
        this.paper = paper;
        this.orient = orient;
        this.lMargin = leftMargin;
        this.rMargin = rightMargin;
        this.tMargin = topMargin;
        this.bMargin = bottomMargin;
    }

    public PageOrientation getPageOrientation() {
        return this.orient;
    }

    public Paper getPaper() {
        return this.paper;
    }

    public double getPrintableWidth() {
        double pw = 0.0;
        pw = this.orient == PageOrientation.PORTRAIT || this.orient == PageOrientation.REVERSE_PORTRAIT ? this.paper.getWidth() : this.paper.getHeight();
        if ((pw -= this.lMargin + this.rMargin) < 0.0) {
            pw = 0.0;
        }
        return pw;
    }

    public double getPrintableHeight() {
        double ph = 0.0;
        ph = this.orient == PageOrientation.PORTRAIT || this.orient == PageOrientation.REVERSE_PORTRAIT ? this.paper.getHeight() : this.paper.getWidth();
        if ((ph -= this.tMargin + this.bMargin) < 0.0) {
            ph = 0.0;
        }
        return ph;
    }

    public double getLeftMargin() {
        return this.lMargin;
    }

    public double getRightMargin() {
        return this.rMargin;
    }

    public double getTopMargin() {
        return this.tMargin;
    }

    public double getBottomMargin() {
        return this.bMargin;
    }

    public boolean equals(Object o) {
        if (o instanceof PageLayout) {
            PageLayout other = (PageLayout)o;
            return this.paper.equals(other.paper) && this.orient.equals((Object)other.orient) && this.tMargin == other.tMargin && this.bMargin == other.bMargin && this.rMargin == other.rMargin && this.lMargin == other.lMargin;
        }
        return false;
    }

    public int hashCode() {
        return this.paper.hashCode() + this.orient.hashCode() + (int)(this.tMargin + this.bMargin + this.lMargin + this.rMargin);
    }

    public String toString() {
        return "Paper=" + this.paper + " Orient=" + this.orient + " leftMargin=" + this.lMargin + " rightMargin=" + this.rMargin + " topMargin=" + this.tMargin + " bottomMargin=" + this.bMargin;
    }
}

