/*
 * Decompiled with CFR 0.152.
 */
package javafx.print;

import javafx.beans.NamedArg;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;

public final class PageRange {
    private ReadOnlyIntegerWrapper startPage;
    private ReadOnlyIntegerWrapper endPage;

    public PageRange(@NamedArg(value="startPage") int startPage, @NamedArg(value="endPage") int endPage) {
        if (startPage <= 0 || startPage > endPage) {
            throw new IllegalArgumentException("Invalid range : " + startPage + " -> " + endPage);
        }
        this.startPageImplProperty().set(startPage);
        this.endPageImplProperty().set(endPage);
    }

    private ReadOnlyIntegerWrapper startPageImplProperty() {
        if (this.startPage == null) {
            this.startPage = new ReadOnlyIntegerWrapper(this, "startPage", 1){

                public void set(int value) {
                    if (value <= 0 || PageRange.this.endPage != null && value < PageRange.this.endPage.get()) {
                        return;
                    }
                    super.set(value);
                }
            };
        }
        return this.startPage;
    }

    public ReadOnlyIntegerProperty startPageProperty() {
        return this.startPageImplProperty().getReadOnlyProperty();
    }

    public int getStartPage() {
        return this.startPageProperty().get();
    }

    private ReadOnlyIntegerWrapper endPageImplProperty() {
        if (this.endPage == null) {
            this.endPage = new ReadOnlyIntegerWrapper(this, "endPage", 9999){

                public void set(int value) {
                    if (value <= 0 || PageRange.this.startPage != null && value < PageRange.this.startPage.get()) {
                        return;
                    }
                    super.set(value);
                }
            };
        }
        return this.endPage;
    }

    public ReadOnlyIntegerProperty endPageProperty() {
        return this.endPageImplProperty().getReadOnlyProperty();
    }

    public int getEndPage() {
        return this.endPageProperty().get();
    }
}

