/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.CameraHelper;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.transform.TransformHelper;
import com.sun.javafx.sg.prism.NGCamera;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.scene.transform.Transform;

public abstract class Camera
extends Node {
    private Affine3D localToSceneTx = new Affine3D();
    private double farClipInScene;
    private double nearClipInScene;
    private Scene ownerScene;
    private SubScene ownerSubScene;
    private GeneralTransform3D projViewTx;
    private GeneralTransform3D projTx;
    private Affine3D viewTx;
    private double viewWidth;
    private double viewHeight;
    private Vec3d position;
    private boolean clipInSceneValid;
    private boolean projViewTxValid;
    private boolean localToSceneValid;
    private boolean sceneToLocalValid;
    private Affine3D sceneToLocalTx;
    private DoubleProperty nearClip;
    private DoubleProperty farClip;

    protected Camera() {
        CameraHelper.initHelper(this);
        this.ownerScene = null;
        this.ownerSubScene = null;
        this.projViewTx = new GeneralTransform3D();
        this.projTx = new GeneralTransform3D();
        this.viewTx = new Affine3D();
        this.viewWidth = 1.0;
        this.viewHeight = 1.0;
        this.position = new Vec3d();
        this.clipInSceneValid = false;
        this.projViewTxValid = false;
        this.localToSceneValid = false;
        this.sceneToLocalValid = false;
        this.sceneToLocalTx = new Affine3D();
        InvalidationListener dirtyTransformListener = observable -> NodeHelper.markDirty(this, DirtyBits.NODE_CAMERA_TRANSFORM);
        this.localToSceneTransformProperty().addListener(dirtyTransformListener);
        this.sceneProperty().addListener(dirtyTransformListener);
    }

    double getFarClipInScene() {
        this.updateClipPlane();
        return this.farClipInScene;
    }

    double getNearClipInScene() {
        this.updateClipPlane();
        return this.nearClipInScene;
    }

    private void updateClipPlane() {
        if (!this.clipInSceneValid) {
            Transform localToSceneTransform = this.getLocalToSceneTransform();
            this.nearClipInScene = localToSceneTransform.transform(0.0, 0.0, this.getNearClip()).getZ();
            this.farClipInScene = localToSceneTransform.transform(0.0, 0.0, this.getFarClip()).getZ();
            this.clipInSceneValid = true;
        }
    }

    Affine3D getSceneToLocalTransform() {
        if (!this.sceneToLocalValid) {
            this.sceneToLocalTx.setTransform(this.getCameraTransform());
            try {
                this.sceneToLocalTx.invert();
            }
            catch (NoninvertibleTransformException ex) {
                String logname = Camera.class.getName();
                PlatformLogger.getLogger((String)logname).severe("getSceneToLocalTransform", (Throwable)ex);
                this.sceneToLocalTx.setToIdentity();
            }
            this.sceneToLocalValid = true;
        }
        return this.sceneToLocalTx;
    }

    public final void setNearClip(double value) {
        this.nearClipProperty().set(value);
    }

    public final double getNearClip() {
        return this.nearClip == null ? 0.1 : this.nearClip.get();
    }

    public final DoubleProperty nearClipProperty() {
        if (this.nearClip == null) {
            this.nearClip = new SimpleDoubleProperty(this, "nearClip", 0.1){

                protected void invalidated() {
                    Camera.this.clipInSceneValid = false;
                    NodeHelper.markDirty(Camera.this, DirtyBits.NODE_CAMERA);
                }
            };
        }
        return this.nearClip;
    }

    public final void setFarClip(double value) {
        this.farClipProperty().set(value);
    }

    public final double getFarClip() {
        return this.farClip == null ? 100.0 : this.farClip.get();
    }

    public final DoubleProperty farClipProperty() {
        if (this.farClip == null) {
            this.farClip = new SimpleDoubleProperty(this, "farClip", 100.0){

                protected void invalidated() {
                    Camera.this.clipInSceneValid = false;
                    NodeHelper.markDirty(Camera.this, DirtyBits.NODE_CAMERA);
                }
            };
        }
        return this.farClip;
    }

    Camera copy() {
        return this;
    }

    private void doUpdatePeer() {
        NGCamera peer = (NGCamera)this.getPeer();
        if (!NodeHelper.isDirtyEmpty(this)) {
            if (this.isDirty(DirtyBits.NODE_CAMERA)) {
                peer.setNearClip((float)this.getNearClip());
                peer.setFarClip((float)this.getFarClip());
                peer.setViewWidth(this.getViewWidth());
                peer.setViewHeight(this.getViewHeight());
            }
            if (this.isDirty(DirtyBits.NODE_CAMERA_TRANSFORM)) {
                peer.setWorldTransform(this.getCameraTransform());
            }
            peer.setProjViewTransform(this.getProjViewTransform());
            this.position = this.computePosition(this.position);
            this.getCameraTransform().transform(this.position, this.position);
            peer.setPosition(this.position);
        }
    }

    void setViewWidth(double width) {
        this.viewWidth = width;
        NodeHelper.markDirty(this, DirtyBits.NODE_CAMERA);
    }

    double getViewWidth() {
        return this.viewWidth;
    }

    void setViewHeight(double height) {
        this.viewHeight = height;
        NodeHelper.markDirty(this, DirtyBits.NODE_CAMERA);
    }

    double getViewHeight() {
        return this.viewHeight;
    }

    void setOwnerScene(Scene s) {
        if (s == null) {
            this.ownerScene = null;
        } else if (s != this.ownerScene) {
            if (this.ownerScene != null || this.ownerSubScene != null) {
                throw new IllegalArgumentException(this + "is already set as camera in other scene or subscene");
            }
            this.ownerScene = s;
            this.markOwnerDirty();
        }
    }

    void setOwnerSubScene(SubScene s) {
        if (s == null) {
            this.ownerSubScene = null;
        } else if (s != this.ownerSubScene) {
            if (this.ownerScene != null || this.ownerSubScene != null) {
                throw new IllegalArgumentException(this + "is already set as camera in other scene or subscene");
            }
            this.ownerSubScene = s;
            this.markOwnerDirty();
        }
    }

    private void doMarkDirty(DirtyBits dirtyBit) {
        if (dirtyBit == DirtyBits.NODE_CAMERA_TRANSFORM) {
            this.localToSceneValid = false;
            this.sceneToLocalValid = false;
            this.clipInSceneValid = false;
            this.projViewTxValid = false;
        } else if (dirtyBit == DirtyBits.NODE_CAMERA) {
            this.projViewTxValid = false;
        }
        this.markOwnerDirty();
    }

    private void markOwnerDirty() {
        if (this.ownerScene != null) {
            this.ownerScene.markCameraDirty();
        }
        if (this.ownerSubScene != null) {
            this.ownerSubScene.markContentDirty();
        }
    }

    Affine3D getCameraTransform() {
        if (!this.localToSceneValid) {
            this.localToSceneTx.setToIdentity();
            TransformHelper.apply(this.getLocalToSceneTransform(), this.localToSceneTx);
            this.localToSceneValid = true;
        }
        return this.localToSceneTx;
    }

    abstract void computeProjectionTransform(GeneralTransform3D var1);

    abstract void computeViewTransform(Affine3D var1);

    GeneralTransform3D getProjViewTransform() {
        if (!this.projViewTxValid) {
            this.computeProjectionTransform(this.projTx);
            this.computeViewTransform(this.viewTx);
            this.projViewTx.set(this.projTx);
            this.projViewTx.mul(this.viewTx);
            this.projViewTx.mul(this.getSceneToLocalTransform());
            this.projViewTxValid = true;
        }
        return this.projViewTx;
    }

    private Point2D project(Point3D p) {
        Vec3d vec = this.getProjViewTransform().transform(new Vec3d(p.getX(), p.getY(), p.getZ()));
        double halfViewWidth = this.getViewWidth() / 2.0;
        double halfViewHeight = this.getViewHeight() / 2.0;
        return new Point2D(halfViewWidth * (1.0 + vec.x), halfViewHeight * (1.0 - vec.y));
    }

    private Point2D pickNodeXYPlane(Node node, double x, double y) {
        PickRay ray = this.computePickRay(x, y, null);
        Affine3D localToScene = new Affine3D();
        TransformHelper.apply(node.getLocalToSceneTransform(), localToScene);
        Vec3d o = ray.getOriginNoClone();
        Vec3d d = ray.getDirectionNoClone();
        try {
            localToScene.inverseTransform(o, o);
            localToScene.inverseDeltaTransform(d, d);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
        if (Camera.almostZero(d.z)) {
            return null;
        }
        double t = -o.z / d.z;
        return new Point2D(o.x + d.x * t, o.y + d.y * t);
    }

    Point3D pickProjectPlane(double x, double y) {
        PickRay ray = this.computePickRay(x, y, null);
        Vec3d p = new Vec3d();
        p.add(ray.getOriginNoClone(), ray.getDirectionNoClone());
        return new Point3D(p.x, p.y, p.z);
    }

    abstract PickRay computePickRay(double var1, double var3, PickRay var5);

    abstract Vec3d computePosition(Vec3d var1);

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        return new BoxBounds(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    private boolean doComputeContains(double localX, double localY) {
        return false;
    }

    static {
        CameraHelper.setCameraAccessor(new CameraHelper.CameraAccessor(){

            @Override
            public void doMarkDirty(Node node, DirtyBits dirtyBit) {
                ((Camera)node).doMarkDirty(dirtyBit);
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((Camera)node).doUpdatePeer();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((Camera)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((Camera)node).doComputeContains(localX, localY);
            }

            @Override
            public Point2D project(Camera camera, Point3D p) {
                return camera.project(p);
            }

            @Override
            public Point2D pickNodeXYPlane(Camera camera, Node node, double x, double y) {
                return camera.pickNodeXYPlane(node, x, y);
            }

            @Override
            public Point3D pickProjectPlane(Camera camera, double x, double y) {
                return camera.pickProjectPlane(x, y);
            }
        });
    }
}

