/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.css.CalculatedValue;
import com.sun.javafx.css.CascadingStyle;
import com.sun.javafx.css.ParsedValueImpl;
import com.sun.javafx.css.PseudoClassState;
import com.sun.javafx.css.StyleCache;
import com.sun.javafx.css.StyleCacheEntry;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleMap;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.CssParser;
import javafx.css.FontCssMetaData;
import javafx.css.ParsedValue;
import javafx.css.PseudoClass;
import javafx.css.Rule;
import javafx.css.Selector;
import javafx.css.Style;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.Stylesheet;
import javafx.css.converter.FontConverter;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SubScene;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

final class CssStyleHelper {
    private static final PlatformLogger LOGGER = Logging.getCSSLogger();
    private Node firstStyleableAncestor;
    private CacheContainer cacheContainer;
    private PseudoClassState triggerStates = new PseudoClassState();
    private static final Set<PseudoClass> NULL_PSEUDO_CLASS_STATE = null;
    private static final CssMetaData dummyFontProperty = new FontCssMetaData<Node>("-fx-font", Font.getDefault()){

        @Override
        public boolean isSettable(Node node) {
            return true;
        }

        @Override
        public StyleableProperty<Font> getStyleableProperty(Node node) {
            return null;
        }
    };

    private CssStyleHelper() {
    }

    static CssStyleHelper createStyleHelper(Node node) {
        int depth = 0;
        for (Styleable parent = node; parent != null; parent = parent.getStyleableParent()) {
            ++depth;
        }
        PseudoClassState[] triggerStates = new PseudoClassState[depth];
        StyleMap styleMap = StyleManager.getInstance().findMatchingStyles(node, node.getSubScene(), (Set<PseudoClass>[])triggerStates);
        if (CssStyleHelper.canReuseStyleHelper(node, styleMap)) {
            if (node.styleHelper.cacheContainer != null && node.styleHelper.isUserSetFont(node)) {
                node.styleHelper.cacheContainer.fontSizeCache.clear();
            }
            node.styleHelper.cacheContainer.forceSlowpath = true;
            node.styleHelper.triggerStates.addAll((Collection)((Object)triggerStates[0]));
            node.styleHelper.firstStyleableAncestor = CssStyleHelper.findFirstStyleableAncestor(node);
            CssStyleHelper.updateParentTriggerStates(node, depth, triggerStates);
            return node.styleHelper;
        }
        if (styleMap == null || styleMap.isEmpty()) {
            boolean mightInherit = false;
            List<CssMetaData<Styleable, ?>> props = node.getCssMetaData();
            int pMax = props != null ? props.size() : 0;
            for (int p = 0; p < pMax; ++p) {
                CssMetaData<Styleable, ?> prop = props.get(p);
                if (!prop.isInherits()) continue;
                mightInherit = true;
                break;
            }
            if (!mightInherit) {
                if (node.styleHelper != null) {
                    node.styleHelper.resetToInitialValues(node);
                }
                return null;
            }
        }
        CssStyleHelper helper = new CssStyleHelper();
        helper.triggerStates.addAll((Collection)((Object)triggerStates[0]));
        CssStyleHelper.updateParentTriggerStates(node, depth, triggerStates);
        helper.cacheContainer = new CacheContainer(node, styleMap, depth);
        helper.firstStyleableAncestor = CssStyleHelper.findFirstStyleableAncestor(node);
        if (node.styleHelper != null) {
            node.styleHelper.resetToInitialValues(node);
        }
        return helper;
    }

    private static void updateParentTriggerStates(Styleable styleable, int depth, PseudoClassState[] triggerStates) {
        Styleable parent = styleable.getStyleableParent();
        for (int n = 1; n < depth; ++n) {
            if (!(parent instanceof Node)) {
                parent = parent.getStyleableParent();
                continue;
            }
            Node parentNode = (Node)parent;
            PseudoClassState triggerState = triggerStates[n];
            if (triggerState != null && triggerState.size() > 0) {
                if (parentNode.styleHelper == null) {
                    parentNode.styleHelper = new CssStyleHelper();
                    parentNode.styleHelper.firstStyleableAncestor = CssStyleHelper.findFirstStyleableAncestor(parentNode);
                }
                parentNode.styleHelper.triggerStates.addAll((Collection)((Object)triggerState));
            }
            parent = parent.getStyleableParent();
        }
    }

    private boolean isUserSetFont(Styleable node) {
        CssMetaData fontCssMetaData;
        if (node == null) {
            return false;
        }
        CssMetaData cssMetaData = fontCssMetaData = this.cacheContainer != null ? this.cacheContainer.fontProp : null;
        if (fontCssMetaData != null) {
            StyleableProperty fontStyleableProperty;
            StyleableProperty styleableProperty = fontStyleableProperty = fontCssMetaData != null ? fontCssMetaData.getStyleableProperty(node) : null;
            if (fontStyleableProperty != null && fontStyleableProperty.getStyleOrigin() == StyleOrigin.USER) {
                return true;
            }
        }
        Node styleableParent = this.firstStyleableAncestor;
        CssStyleHelper parentStyleHelper = CssStyleHelper.getStyleHelper(this.firstStyleableAncestor);
        if (parentStyleHelper != null) {
            return parentStyleHelper.isUserSetFont(styleableParent);
        }
        return false;
    }

    private static CssStyleHelper getStyleHelper(Node n) {
        return n != null ? n.styleHelper : null;
    }

    private static Node findFirstStyleableAncestor(Styleable st) {
        Node ancestor = null;
        for (Styleable parent = st.getStyleableParent(); parent != null; parent = parent.getStyleableParent()) {
            if (!(parent instanceof Node) || ((Node)parent).styleHelper == null) continue;
            ancestor = (Node)parent;
            break;
        }
        return ancestor;
    }

    private static boolean isTrue(WritableValue<Boolean> booleanProperty) {
        return booleanProperty != null && (Boolean)booleanProperty.getValue() != false;
    }

    private static void setTrue(WritableValue<Boolean> booleanProperty) {
        if (booleanProperty != null) {
            booleanProperty.setValue((Object)true);
        }
    }

    private static boolean canReuseStyleHelper(Node node, StyleMap styleMap) {
        int[] nodeIds;
        int[] parentIds;
        if (node == null || node.styleHelper == null) {
            return false;
        }
        if (styleMap == null) {
            return false;
        }
        StyleMap currentMap = node.styleHelper.getStyleMap(node);
        if (currentMap != styleMap) {
            return false;
        }
        if (node.styleHelper.cacheContainer == null) {
            return true;
        }
        Styleable parent = node.getStyleableParent();
        if (parent == null) {
            return true;
        }
        CssStyleHelper parentHelper = CssStyleHelper.getStyleHelper(node.styleHelper.firstStyleableAncestor);
        if (parentHelper != null && parentHelper.cacheContainer != null && (parentIds = parentHelper.cacheContainer.styleCacheKey.getStyleMapIds()).length == (nodeIds = node.styleHelper.cacheContainer.styleCacheKey.getStyleMapIds()).length - 1) {
            boolean isSame = true;
            for (int i = 0; i < parentIds.length; ++i) {
                if (nodeIds[i + 1] == parentIds[i]) continue;
                isSame = false;
                break;
            }
            return isSame;
        }
        return false;
    }

    private void resetToInitialValues(Styleable styleable) {
        if (this.cacheContainer == null || this.cacheContainer.cssSetProperties == null || this.cacheContainer.cssSetProperties.isEmpty()) {
            return;
        }
        HashSet entrySet = new HashSet(this.cacheContainer.cssSetProperties.entrySet());
        this.cacheContainer.cssSetProperties.clear();
        for (Map.Entry entry : entrySet) {
            CssMetaData metaData = (CssMetaData)entry.getKey();
            StyleableProperty styleableProperty = metaData.getStyleableProperty(styleable);
            StyleOrigin styleOrigin = styleableProperty.getStyleOrigin();
            if (styleOrigin == null || styleOrigin == StyleOrigin.USER) continue;
            CalculatedValue calculatedValue = (CalculatedValue)entry.getValue();
            styleableProperty.applyStyle(calculatedValue.getOrigin(), calculatedValue.getValue());
        }
    }

    private StyleMap getStyleMap(Styleable styleable) {
        if (this.cacheContainer == null || styleable == null) {
            return null;
        }
        return this.cacheContainer.getStyleMap(styleable);
    }

    boolean pseudoClassStateChanged(PseudoClass pseudoClass) {
        return this.triggerStates.contains(pseudoClass);
    }

    private Set<PseudoClass>[] getTransitionStates(Node node) {
        Node parent;
        if (this.cacheContainer == null) {
            return null;
        }
        int depth = 0;
        for (parent = node; parent != null; parent = parent.getParent()) {
            ++depth;
        }
        PseudoClassState[] retainedStates = new PseudoClassState[depth];
        int count = 0;
        for (parent = node; parent != null; parent = parent.getParent()) {
            CssStyleHelper helper;
            CssStyleHelper cssStyleHelper = helper = parent instanceof Node ? parent.styleHelper : null;
            if (helper == null) continue;
            ObservableSet<PseudoClass> pseudoClassState = parent.pseudoClassStates;
            retainedStates[count] = new PseudoClassState();
            retainedStates[count].addAll(pseudoClassState);
            retainedStates[count].retainAll((Collection<?>)((Object)helper.triggerStates));
            ++count;
        }
        PseudoClassState[] transitionStates = new PseudoClassState[count];
        System.arraycopy(retainedStates, 0, transitionStates, 0, count);
        return transitionStates;
    }

    void transitionToState(Node node) {
        Font fontForRelativeSizes;
        StyleCacheEntry.Key cacheEntryKey;
        StyleCacheEntry cacheEntry;
        boolean fastpath;
        if (this.cacheContainer == null) {
            return;
        }
        StyleMap styleMap = this.getStyleMap(node);
        if (styleMap == null) {
            this.cacheContainer = null;
            node.reapplyCSS();
            return;
        }
        boolean inheritOnly = styleMap.isEmpty();
        StyleCache sharedCache = StyleManager.getInstance().getSharedCache(node, node.getSubScene(), this.cacheContainer.styleCacheKey);
        if (sharedCache == null) {
            this.cacheContainer = null;
            node.reapplyCSS();
            return;
        }
        Set<PseudoClass>[] transitionStates = this.getTransitionStates(node);
        StyleCacheEntry.Key fontCacheKey = new StyleCacheEntry.Key(transitionStates, Font.getDefault());
        CalculatedValue cachedFont = (CalculatedValue)this.cacheContainer.fontSizeCache.get(fontCacheKey);
        if (cachedFont == null) {
            if ((cachedFont = this.lookupFont(node, "-fx-font", styleMap, cachedFont)) == CalculatedValue.SKIP) {
                cachedFont = this.getCachedFont(node.getStyleableParent());
            }
            if (cachedFont == null) {
                cachedFont = new CalculatedValue(Font.getDefault(), null, false);
            }
            this.cacheContainer.fontSizeCache.put(fontCacheKey, cachedFont);
        }
        boolean bl = fastpath = (cacheEntry = sharedCache.getStyleCacheEntry(cacheEntryKey = new StyleCacheEntry.Key(transitionStates, fontForRelativeSizes = (Font)cachedFont.getValue()))) != null;
        if (cacheEntry == null) {
            cacheEntry = new StyleCacheEntry();
            sharedCache.addStyleCacheEntry(cacheEntryKey, cacheEntry);
        }
        List<CssMetaData<Styleable, ?>> styleables = node.getCssMetaData();
        int max = styleables.size();
        boolean isForceSlowpath = this.cacheContainer.forceSlowpath;
        this.cacheContainer.forceSlowpath = false;
        for (int n = 0; n < max; ++n) {
            StyleableProperty<?> styleableProperty;
            boolean addToCache;
            CssMetaData<Styleable, ?> cssMetaData = styleables.get(n);
            if (inheritOnly && !cssMetaData.isInherits() || !cssMetaData.isSettable(node)) continue;
            String property = cssMetaData.getProperty();
            CalculatedValue calculatedValue = cacheEntry.get(property);
            boolean forceSlowpath = fastpath && calculatedValue == null && isForceSlowpath;
            boolean bl2 = addToCache = !fastpath && calculatedValue == null || forceSlowpath;
            if (fastpath && !forceSlowpath) {
                if (calculatedValue == CalculatedValue.SKIP) {
                    continue;
                }
            } else if (calculatedValue == null && (calculatedValue = this.lookup(node, cssMetaData, styleMap, transitionStates[0], node, cachedFont)) == null) {
                assert (false) : "lookup returned null for " + property;
                continue;
            }
            try {
                if (calculatedValue == null || calculatedValue == CalculatedValue.SKIP) {
                    CalculatedValue initialValue = (CalculatedValue)this.cacheContainer.cssSetProperties.get(cssMetaData);
                    if (initialValue == null || (styleableProperty = cssMetaData.getStyleableProperty(node)).getStyleOrigin() == StyleOrigin.USER) continue;
                    styleableProperty.applyStyle(initialValue.getOrigin(), initialValue.getValue());
                    continue;
                }
                if (addToCache) {
                    cacheEntry.put(property, calculatedValue);
                }
                StyleableProperty<?> styleableProperty2 = cssMetaData.getStyleableProperty(node);
                StyleOrigin originOfCurrentValue = styleableProperty2.getStyleOrigin();
                StyleOrigin originOfCalculatedValue = calculatedValue.getOrigin();
                if (originOfCalculatedValue == null) {
                    assert (false) : styleableProperty2.toString();
                    continue;
                }
                if (originOfCurrentValue == StyleOrigin.USER && originOfCalculatedValue == StyleOrigin.USER_AGENT) continue;
                Object value = calculatedValue.getValue();
                Object currentValue = styleableProperty2.getValue();
                if (originOfCurrentValue == originOfCalculatedValue && !(currentValue != null ? !currentValue.equals(value) : value != null)) continue;
                if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
                    LOGGER.finer(property + ", call applyStyle: " + styleableProperty2 + ", value =" + String.valueOf(value) + ", originOfCalculatedValue=" + originOfCalculatedValue);
                }
                styleableProperty2.applyStyle(originOfCalculatedValue, value);
                if (this.cacheContainer.cssSetProperties.containsKey(cssMetaData)) continue;
                CalculatedValue initialValue = new CalculatedValue(currentValue, originOfCurrentValue, false);
                this.cacheContainer.cssSetProperties.put(cssMetaData, initialValue);
                continue;
            }
            catch (Exception e) {
                PlatformLogger logger;
                styleableProperty = cssMetaData.getStyleableProperty(node);
                String msg = String.format("Failed to set css [%s] on [%s] due to '%s'\n", cssMetaData.getProperty(), styleableProperty, e.getMessage());
                ObservableList<CssParser.ParseError> errors = null;
                errors = StyleManager.getErrors();
                if (errors != null) {
                    CssParser.ParseError.PropertySetError error = new CssParser.ParseError.PropertySetError(cssMetaData, node, msg);
                    errors.add(error);
                }
                if ((logger = Logging.getCSSLogger()).isLoggable(PlatformLogger.Level.WARNING)) {
                    logger.warning(msg);
                }
                cacheEntry.put(property, CalculatedValue.SKIP);
                CalculatedValue cachedValue = null;
                if (this.cacheContainer != null && this.cacheContainer.cssSetProperties != null) {
                    cachedValue = (CalculatedValue)this.cacheContainer.cssSetProperties.get(cssMetaData);
                }
                Object value = cachedValue != null ? cachedValue.getValue() : cssMetaData.getInitialValue(node);
                StyleOrigin origin = cachedValue != null ? cachedValue.getOrigin() : null;
                try {
                    styleableProperty.applyStyle(origin, value);
                    continue;
                }
                catch (Exception ebad) {
                    if (!logger.isLoggable(PlatformLogger.Level.SEVERE)) continue;
                    logger.severe(String.format("Could not reset [%s] on [%s] due to %s\n", cssMetaData.getProperty(), styleableProperty, e.getMessage()));
                }
            }
        }
    }

    private CascadingStyle getStyle(Styleable styleable, String property, StyleMap styleMap, Set<PseudoClass> states) {
        if (styleMap == null || styleMap.isEmpty()) {
            return null;
        }
        Map<String, List<CascadingStyle>> cascadingStyleMap = styleMap.getCascadingStyles();
        if (cascadingStyleMap == null || cascadingStyleMap.isEmpty()) {
            return null;
        }
        List<CascadingStyle> styles = cascadingStyleMap.get(property);
        if (styles == null || styles.isEmpty()) {
            return null;
        }
        CascadingStyle style = null;
        int max = styles == null ? 0 : styles.size();
        for (int i = 0; i < max; ++i) {
            Selector sel;
            CascadingStyle s = styles.get(i);
            Selector selector = sel = s == null ? null : s.getSelector();
            if (sel == null || !sel.stateMatches(styleable, states)) continue;
            style = s;
            break;
        }
        return style;
    }

    private CalculatedValue lookup(Styleable styleable, CssMetaData cssMetaData, StyleMap styleMap, Set<PseudoClass> states, Styleable originatingStyleable, CalculatedValue cachedFont) {
        StyleableProperty styleableProperty;
        int numSubProperties;
        if (cssMetaData.getConverter() == FontConverter.getInstance()) {
            return this.lookupFont(styleable, cssMetaData.getProperty(), styleMap, cachedFont);
        }
        String property = cssMetaData.getProperty();
        CascadingStyle style = this.getStyle(styleable, property, styleMap, states);
        List<CssMetaData<Styleable, ?>> subProperties = cssMetaData.getSubProperties();
        int n = numSubProperties = subProperties != null ? subProperties.size() : 0;
        if (style == null) {
            if (numSubProperties == 0) {
                return this.handleNoStyleFound(styleable, cssMetaData, styleMap, states, originatingStyleable, cachedFont);
            }
            HashMap subs = null;
            StyleOrigin origin = null;
            boolean isRelative = false;
            for (int i = 0; i < numSubProperties; ++i) {
                CssMetaData<Styleable, ?> subkey = subProperties.get(i);
                CalculatedValue constituent = this.lookup(styleable, subkey, styleMap, states, originatingStyleable, cachedFont);
                if (constituent == CalculatedValue.SKIP) continue;
                if (subs == null) {
                    subs = new HashMap();
                }
                subs.put(subkey, constituent.getValue());
                if (origin != null && constituent.getOrigin() != null ? origin.compareTo(constituent.getOrigin()) < 0 : constituent.getOrigin() != null) {
                    origin = constituent.getOrigin();
                }
                isRelative = isRelative || constituent.isRelative();
            }
            if (subs == null || subs.isEmpty()) {
                return this.handleNoStyleFound(styleable, cssMetaData, styleMap, states, originatingStyleable, cachedFont);
            }
            try {
                StyleConverter keyType = cssMetaData.getConverter();
                Object ret = keyType.convert(subs);
                return new CalculatedValue(ret, origin, isRelative);
            }
            catch (ClassCastException cce) {
                String msg = this.formatExceptionMessage(styleable, cssMetaData, null, cce);
                ObservableList<CssParser.ParseError> errors = null;
                errors = StyleManager.getErrors();
                if (errors != null) {
                    CssParser.ParseError.PropertySetError error = new CssParser.ParseError.PropertySetError(cssMetaData, styleable, msg);
                    errors.add(error);
                }
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(msg);
                    LOGGER.fine("caught: ", (Throwable)cce);
                    LOGGER.fine("styleable = " + cssMetaData);
                    LOGGER.fine("node = " + styleable.toString());
                }
                return CalculatedValue.SKIP;
            }
        }
        if (style.getOrigin() == StyleOrigin.USER_AGENT && (styleableProperty = cssMetaData.getStyleableProperty(originatingStyleable)) != null && styleableProperty.getStyleOrigin() == StyleOrigin.USER) {
            return CalculatedValue.SKIP;
        }
        ParsedValue cssValue = style.getParsedValue();
        if (cssValue != null && "inherit".equals(cssValue.getValue()) && (style = this.getInheritedStyle(styleable, property)) == null) {
            return CalculatedValue.SKIP;
        }
        return this.calculateValue(style, styleable, cssMetaData, styleMap, states, originatingStyleable, cachedFont);
    }

    private CalculatedValue handleNoStyleFound(Styleable styleable, CssMetaData cssMetaData, StyleMap styleMap, Set<PseudoClass> pseudoClassStates, Styleable originatingStyleable, CalculatedValue cachedFont) {
        if (cssMetaData.isInherits()) {
            StyleOrigin origin;
            StyleableProperty styleableProperty = cssMetaData.getStyleableProperty(styleable);
            StyleOrigin styleOrigin = origin = styleableProperty != null ? styleableProperty.getStyleOrigin() : null;
            if (origin == StyleOrigin.USER) {
                return CalculatedValue.SKIP;
            }
            CascadingStyle style = this.getInheritedStyle(styleable, cssMetaData.getProperty());
            if (style == null) {
                return CalculatedValue.SKIP;
            }
            CalculatedValue cv = this.calculateValue(style, styleable, cssMetaData, styleMap, pseudoClassStates, originatingStyleable, cachedFont);
            return cv;
        }
        return CalculatedValue.SKIP;
    }

    private CascadingStyle getInheritedStyle(Styleable styleable, String property) {
        ObservableSet<PseudoClass> transitionStates;
        StyleMap parentStyleMap;
        CascadingStyle cascadingStyle;
        Node parent = ((Node)styleable).styleHelper.firstStyleableAncestor;
        CssStyleHelper parentStyleHelper = CssStyleHelper.getStyleHelper(parent);
        if (parent != null && parentStyleHelper != null && (cascadingStyle = parentStyleHelper.getStyle(parent, property, parentStyleMap = parentStyleHelper.getStyleMap(parent), (Set<PseudoClass>)(transitionStates = parent.pseudoClassStates))) != null) {
            ParsedValue cssValue = cascadingStyle.getParsedValue();
            if ("inherit".equals(cssValue.getValue())) {
                return this.getInheritedStyle(parent, property);
            }
            return cascadingStyle;
        }
        return null;
    }

    private CascadingStyle resolveRef(Styleable styleable, String property, StyleMap styleMap, Set<PseudoClass> states) {
        CascadingStyle style = this.getStyle(styleable, property, styleMap, states);
        if (style != null) {
            return style;
        }
        if (states != null && states.size() > 0) {
            return this.resolveRef(styleable, property, styleMap, NULL_PSEUDO_CLASS_STATE);
        }
        Node styleableParent = ((Node)styleable).styleHelper.firstStyleableAncestor;
        CssStyleHelper parentStyleHelper = CssStyleHelper.getStyleHelper(styleableParent);
        if (styleableParent == null || parentStyleHelper == null) {
            return null;
        }
        StyleMap parentStyleMap = parentStyleHelper.getStyleMap(styleableParent);
        ObservableSet<PseudoClass> styleableParentPseudoClassStates = styleableParent instanceof Node ? styleableParent.pseudoClassStates : styleable.getPseudoClassStates();
        return parentStyleHelper.resolveRef(styleableParent, property, parentStyleMap, (Set<PseudoClass>)styleableParentPseudoClassStates);
    }

    private ParsedValue resolveLookups(Styleable styleable, ParsedValue parsedValue, StyleMap styleMap, Set<PseudoClass> states, ObjectProperty<StyleOrigin> whence, Set<ParsedValue> resolves) {
        String sval;
        Object resolved;
        Object val;
        if (parsedValue.isLookup() && (val = parsedValue.getValue()) instanceof String && (resolved = this.resolveRef(styleable, sval = ((String)val).toLowerCase(Locale.ROOT), styleMap, states)) != null) {
            if (resolves.contains(((CascadingStyle)resolved).getParsedValue())) {
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning("Loop detected in " + ((CascadingStyle)resolved).getRule().toString() + " while resolving '" + sval + "'");
                }
                throw new IllegalArgumentException("Loop detected in " + ((CascadingStyle)resolved).getRule().toString() + " while resolving '" + sval + "'");
            }
            resolves.add(parsedValue);
            StyleOrigin wOrigin = (StyleOrigin)((Object)whence.get());
            StyleOrigin rOrigin = ((CascadingStyle)resolved).getOrigin();
            if (rOrigin != null && (wOrigin == null || wOrigin.compareTo(rOrigin) < 0)) {
                whence.set((Object)rOrigin);
            }
            ParsedValue pv = this.resolveLookups(styleable, ((CascadingStyle)resolved).getParsedValue(), styleMap, states, whence, resolves);
            if (resolves != null) {
                resolves.remove(parsedValue);
            }
            return pv;
        }
        if (!parsedValue.isContainsLookups()) {
            return parsedValue;
        }
        val = parsedValue.getValue();
        if (val instanceof ParsedValue[][]) {
            ParsedValue[][] layers = (ParsedValue[][])val;
            resolved = new ParsedValue[layers.length][0];
            for (int l = 0; l < layers.length; ++l) {
                resolved[l] = new ParsedValue[layers[l].length];
                for (int ll = 0; ll < layers[l].length; ++ll) {
                    if (layers[l][ll] == null) continue;
                    resolved[l][ll] = this.resolveLookups(styleable, layers[l][ll], styleMap, states, whence, resolves);
                }
            }
            resolves.clear();
            return new ParsedValueImpl(resolved, parsedValue.getConverter(), false);
        }
        if (val instanceof ParsedValueImpl[]) {
            ParsedValue[] layer = (ParsedValue[])val;
            resolved = new ParsedValue[layer.length];
            for (int l = 0; l < layer.length; ++l) {
                if (layer[l] == null) continue;
                resolved[l] = this.resolveLookups(styleable, layer[l], styleMap, states, whence, resolves);
            }
            resolves.clear();
            return new ParsedValueImpl(resolved, parsedValue.getConverter(), false);
        }
        return parsedValue;
    }

    private String getUnresolvedLookup(ParsedValue resolved) {
        block5: {
            Object value;
            block4: {
                value = resolved.getValue();
                if (resolved.isLookup() && value instanceof String) {
                    return (String)value;
                }
                if (!(value instanceof ParsedValue[][])) break block4;
                ParsedValue[][] layers = (ParsedValue[][])value;
                for (int l = 0; l < layers.length; ++l) {
                    for (int ll = 0; ll < layers[l].length; ++ll) {
                        String unresolvedLookup;
                        if (layers[l][ll] == null || (unresolvedLookup = this.getUnresolvedLookup(layers[l][ll])) == null) continue;
                        return unresolvedLookup;
                    }
                }
                break block5;
            }
            if (!(value instanceof ParsedValue[])) break block5;
            ParsedValue[] layer = (ParsedValue[])value;
            for (int l = 0; l < layer.length; ++l) {
                String unresolvedLookup;
                if (layer[l] == null || (unresolvedLookup = this.getUnresolvedLookup(layer[l])) == null) continue;
                return unresolvedLookup;
            }
        }
        return null;
    }

    private String formatUnresolvedLookupMessage(Styleable styleable, CssMetaData cssMetaData, Style style, ParsedValue resolved, ClassCastException cce) {
        String url;
        String missingLookup = resolved != null && resolved.isContainsLookups() ? this.getUnresolvedLookup(resolved) : null;
        StringBuilder sbuf = new StringBuilder();
        if (missingLookup != null) {
            sbuf.append("Could not resolve '").append(missingLookup).append("'").append(" while resolving lookups for '").append(cssMetaData.getProperty()).append("'");
        } else {
            sbuf.append("Caught '").append(cce).append("'").append(" while converting value for '").append(cssMetaData.getProperty()).append("'");
        }
        Rule rule = style != null ? style.getDeclaration().getRule() : null;
        Stylesheet stylesheet = rule != null ? rule.getStylesheet() : null;
        String string = url = stylesheet != null ? stylesheet.getUrl() : null;
        if (url != null) {
            sbuf.append(" from rule '").append(style.getSelector()).append("' in stylesheet ").append(url);
        } else if (stylesheet != null && StyleOrigin.INLINE == stylesheet.getOrigin()) {
            sbuf.append(" from inline style on ").append(styleable.toString());
        }
        return sbuf.toString();
    }

    private String formatExceptionMessage(Styleable styleable, CssMetaData cssMetaData, Style style, Exception e) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("Caught ").append(String.valueOf(e));
        if (cssMetaData != null) {
            sbuf.append("'").append(" while calculating value for '").append(cssMetaData.getProperty()).append("'");
        }
        if (style != null) {
            String url;
            Rule rule = style.getDeclaration().getRule();
            Stylesheet stylesheet = rule != null ? rule.getStylesheet() : null;
            String string = url = stylesheet != null ? stylesheet.getUrl() : null;
            if (url != null) {
                sbuf.append(" from rule '").append(style.getSelector()).append("' in stylesheet ").append(url);
            } else if (styleable != null && stylesheet != null && StyleOrigin.INLINE == stylesheet.getOrigin()) {
                sbuf.append(" from inline style on ").append(styleable.toString());
            } else {
                sbuf.append(" from style '").append(String.valueOf(style)).append("'");
            }
        }
        return sbuf.toString();
    }

    private CalculatedValue calculateValue(CascadingStyle style, Styleable styleable, CssMetaData cssMetaData, StyleMap styleMap, Set<PseudoClass> states, Styleable originatingStyleable, CalculatedValue fontFromCacheEntry) {
        ParsedValue cssValue = style.getParsedValue();
        if (cssValue != null && !"null".equals(cssValue.getValue()) && !"none".equals(cssValue.getValue())) {
            ParsedValueImpl resolved = null;
            try {
                StyleConverter cssMetaDataConverter;
                SimpleObjectProperty whence = new SimpleObjectProperty((Object)style.getOrigin());
                resolved = this.resolveLookups(styleable, cssValue, styleMap, states, (ObjectProperty<StyleOrigin>)whence, new HashSet<ParsedValue>());
                String property = cssMetaData.getProperty();
                Object val = null;
                boolean isFontProperty = "-fx-font".equals(property) || "-fx-font-size".equals(property);
                boolean isRelative = ParsedValueImpl.containsFontRelativeSize(resolved, isFontProperty);
                Font fontForFontRelativeSizes = null;
                if (isRelative && isFontProperty && (fontFromCacheEntry == null || fontFromCacheEntry.isRelative())) {
                    Styleable parent = styleable;
                    CalculatedValue childsCachedFont = fontFromCacheEntry;
                    do {
                        CalculatedValue parentsCachedFont;
                        if ((parentsCachedFont = this.getCachedFont(parent.getStyleableParent())) == null) continue;
                        if (parentsCachedFont.isRelative()) {
                            if (childsCachedFont == null || parentsCachedFont.equals(childsCachedFont)) {
                                childsCachedFont = parentsCachedFont;
                                continue;
                            }
                            fontForFontRelativeSizes = (Font)parentsCachedFont.getValue();
                            continue;
                        }
                        fontForFontRelativeSizes = (Font)parentsCachedFont.getValue();
                    } while (fontForFontRelativeSizes == null && (parent = parent.getStyleableParent()) != null);
                }
                if (fontForFontRelativeSizes == null) {
                    fontForFontRelativeSizes = fontFromCacheEntry != null && !fontFromCacheEntry.isRelative() ? (Font)fontFromCacheEntry.getValue() : Font.getDefault();
                }
                if ((cssMetaDataConverter = cssMetaData.getConverter()) == StyleConverter.getInsetsConverter()) {
                    if (resolved.getValue() instanceof ParsedValue) {
                        resolved = new ParsedValueImpl(new ParsedValue[]{(ParsedValue)resolved.getValue()}, null, false);
                    }
                    val = cssMetaDataConverter.convert(resolved, fontForFontRelativeSizes);
                } else {
                    val = resolved.getConverter() != null ? ((ParsedValue)resolved).convert(fontForFontRelativeSizes) : cssMetaData.getConverter().convert(resolved, fontForFontRelativeSizes);
                }
                StyleOrigin origin = (StyleOrigin)((Object)whence.get());
                return new CalculatedValue(val, origin, isRelative);
            }
            catch (ClassCastException cce) {
                String msg = this.formatUnresolvedLookupMessage(styleable, cssMetaData, style.getStyle(), resolved, cce);
                ObservableList<CssParser.ParseError> errors = null;
                errors = StyleManager.getErrors();
                if (errors != null) {
                    CssParser.ParseError.PropertySetError error = new CssParser.ParseError.PropertySetError(cssMetaData, styleable, msg);
                    errors.add(error);
                }
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(msg);
                    LOGGER.fine("node = " + styleable.toString());
                    LOGGER.fine("cssMetaData = " + cssMetaData);
                    LOGGER.fine("styles = " + CssStyleHelper.getMatchingStyles(styleable, cssMetaData));
                }
                return CalculatedValue.SKIP;
            }
            catch (IllegalArgumentException iae) {
                String msg = this.formatExceptionMessage(styleable, cssMetaData, style.getStyle(), iae);
                ObservableList<CssParser.ParseError> errors = null;
                errors = StyleManager.getErrors();
                if (errors != null) {
                    CssParser.ParseError.PropertySetError error = new CssParser.ParseError.PropertySetError(cssMetaData, styleable, msg);
                    errors.add(error);
                }
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(msg);
                    LOGGER.fine("caught: ", (Throwable)iae);
                    LOGGER.fine("styleable = " + cssMetaData);
                    LOGGER.fine("node = " + styleable.toString());
                }
                return CalculatedValue.SKIP;
            }
            catch (NullPointerException npe) {
                String msg = this.formatExceptionMessage(styleable, cssMetaData, style.getStyle(), npe);
                ObservableList<CssParser.ParseError> errors = null;
                errors = StyleManager.getErrors();
                if (errors != null) {
                    CssParser.ParseError.PropertySetError error = new CssParser.ParseError.PropertySetError(cssMetaData, styleable, msg);
                    errors.add(error);
                }
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(msg);
                    LOGGER.fine("caught: ", (Throwable)npe);
                    LOGGER.fine("styleable = " + cssMetaData);
                    LOGGER.fine("node = " + styleable.toString());
                }
                return CalculatedValue.SKIP;
            }
        }
        return new CalculatedValue(null, style.getOrigin(), false);
    }

    private CalculatedValue getCachedFont(Styleable styleable) {
        if (!(styleable instanceof Node)) {
            return null;
        }
        CalculatedValue cachedFont = null;
        Node parent = (Node)styleable;
        CssStyleHelper parentHelper = parent.styleHelper;
        if (parentHelper == null || parentHelper.cacheContainer == null) {
            cachedFont = this.getCachedFont(parent.getStyleableParent());
        } else {
            CacheContainer parentCacheContainer = parentHelper.cacheContainer;
            if (parentCacheContainer != null && parentCacheContainer.fontSizeCache != null && !parentCacheContainer.fontSizeCache.isEmpty()) {
                Set<PseudoClass>[] transitionStates = parentHelper.getTransitionStates(parent);
                StyleCacheEntry.Key parentCacheEntryKey = new StyleCacheEntry.Key(transitionStates, Font.getDefault());
                cachedFont = (CalculatedValue)parentCacheContainer.fontSizeCache.get(parentCacheEntryKey);
            }
            if (cachedFont == null) {
                StyleMap smap = parentHelper.getStyleMap(parent);
                cachedFont = parentHelper.lookupFont(parent, "-fx-font", smap, null);
            }
        }
        return cachedFont != CalculatedValue.SKIP ? cachedFont : null;
    }

    FontPosture getFontPosture(Font font) {
        if (font == null) {
            return FontPosture.REGULAR;
        }
        String fontName = font.getName().toLowerCase(Locale.ROOT);
        if (fontName.contains("italic")) {
            return FontPosture.ITALIC;
        }
        return FontPosture.REGULAR;
    }

    FontWeight getFontWeight(Font font) {
        if (font == null) {
            return FontWeight.NORMAL;
        }
        String fontName = font.getName().toLowerCase(Locale.ROOT);
        if (fontName.contains("bold")) {
            if (fontName.contains("extra")) {
                return FontWeight.EXTRA_BOLD;
            }
            if (fontName.contains("ultra")) {
                return FontWeight.EXTRA_BOLD;
            }
            if (fontName.contains("semi")) {
                return FontWeight.SEMI_BOLD;
            }
            if (fontName.contains("demi")) {
                return FontWeight.SEMI_BOLD;
            }
            return FontWeight.BOLD;
        }
        if (fontName.contains("light")) {
            if (fontName.contains("extra")) {
                return FontWeight.EXTRA_LIGHT;
            }
            if (fontName.contains("ultra")) {
                return FontWeight.EXTRA_LIGHT;
            }
            return FontWeight.LIGHT;
        }
        if (fontName.contains("black")) {
            return FontWeight.BLACK;
        }
        if (fontName.contains("heavy")) {
            return FontWeight.BLACK;
        }
        if (fontName.contains("medium")) {
            return FontWeight.MEDIUM;
        }
        return FontWeight.NORMAL;
    }

    String getFontFamily(Font font) {
        if (font == null) {
            return Font.getDefault().getFamily();
        }
        return font.getFamily();
    }

    Font deriveFont(Font font, String fontFamily, FontWeight fontWeight, FontPosture fontPosture, double fontSize) {
        if (font != null && fontFamily == null) {
            fontFamily = this.getFontFamily(font);
        } else if (fontFamily != null) {
            fontFamily = Utils.stripQuotes(fontFamily);
        }
        if (font != null && fontWeight == null) {
            fontWeight = this.getFontWeight(font);
        }
        if (font != null && fontPosture == null) {
            fontPosture = this.getFontPosture(font);
        }
        if (font != null && fontSize <= 0.0) {
            fontSize = font.getSize();
        }
        return Font.font(fontFamily, fontWeight, fontPosture, fontSize);
    }

    CalculatedValue lookupFont(Styleable styleable, String property, StyleMap styleMap, CalculatedValue cachedFont) {
        CalculatedValue cv;
        CascadingStyle fontFamily;
        CalculatedValue cv2;
        CascadingStyle fontStyle;
        CalculatedValue cv3;
        CalculatedValue cv4;
        CascadingStyle fontSize;
        CalculatedValue cv5;
        CascadingStyle fontShorthand;
        CalculatedValue parentCachedFont;
        ObservableSet<PseudoClass> states;
        StyleOrigin origin = null;
        int distance = 0;
        boolean foundStyle = false;
        String family = null;
        double size = -1.0;
        FontWeight weight = null;
        FontPosture posture = null;
        CalculatedValue cvFont = cachedFont;
        ObservableSet<PseudoClass> observableSet = states = styleable instanceof Node ? ((Node)styleable).pseudoClassStates : styleable.getPseudoClassStates();
        if (this.cacheContainer.fontProp != null) {
            StyleableProperty styleableProp = this.cacheContainer.fontProp.getStyleableProperty(styleable);
            StyleOrigin fpOrigin = styleableProp.getStyleOrigin();
            Font font = (Font)styleableProp.getValue();
            if (font == null) {
                font = Font.getDefault();
            }
            if (fpOrigin == StyleOrigin.USER) {
                origin = fpOrigin;
                family = this.getFontFamily(font);
                size = font.getSize();
                weight = this.getFontWeight(font);
                posture = this.getFontPosture(font);
                cvFont = new CalculatedValue(font, fpOrigin, false);
            }
        }
        if ((parentCachedFont = this.getCachedFont(styleable.getStyleableParent())) == null) {
            parentCachedFont = new CalculatedValue(Font.getDefault(), null, false);
        }
        if ((fontShorthand = this.getStyle(styleable, property, styleMap, (Set<PseudoClass>)states)) == null && origin != StyleOrigin.USER) {
            Styleable parent;
            Styleable styleable2 = parent = styleable != null ? styleable.getStyleableParent() : null;
            while (parent != null) {
                CssStyleHelper parentStyleHelper;
                CssStyleHelper cssStyleHelper = parentStyleHelper = parent instanceof Node ? ((Node)parent).styleHelper : null;
                if (parentStyleHelper != null) {
                    ParsedValue cssValue;
                    ObservableSet<PseudoClass> transitionStates;
                    ++distance;
                    StyleMap parentStyleMap = parentStyleHelper.getStyleMap(parent);
                    CascadingStyle cascadingStyle = parentStyleHelper.getStyle(parent, property, parentStyleMap, (Set<PseudoClass>)(transitionStates = ((Node)parent).pseudoClassStates));
                    if (cascadingStyle != null && !"inherit".equals((cssValue = cascadingStyle.getParsedValue()).getValue())) {
                        fontShorthand = cascadingStyle;
                        break;
                    }
                }
                parent = parent.getStyleableParent();
            }
        }
        if (fontShorthand != null && (origin == null || origin.compareTo(fontShorthand.getOrigin()) <= 0) && (cv5 = this.calculateValue(fontShorthand, styleable, dummyFontProperty, styleMap, (Set<PseudoClass>)states, styleable, parentCachedFont)).getValue() instanceof Font) {
            origin = cv5.getOrigin();
            Font font = (Font)cv5.getValue();
            family = this.getFontFamily(font);
            size = font.getSize();
            weight = this.getFontWeight(font);
            posture = this.getFontPosture(font);
            cvFont = cv5;
            foundStyle = true;
        }
        if ((fontSize = this.getStyle(styleable, property.concat("-size"), styleMap, (Set<PseudoClass>)states)) != null) {
            if (fontShorthand != null && fontShorthand.compareTo(fontSize) < 0) {
                fontSize = null;
            } else if (origin == StyleOrigin.USER && StyleOrigin.USER.compareTo(fontSize.getOrigin()) > 0) {
                fontSize = null;
            }
        } else if (origin != StyleOrigin.USER) {
            fontSize = this.lookupInheritedFontProperty(styleable, property.concat("-size"), styleMap, distance, fontShorthand);
        }
        if (fontSize != null && (cv4 = this.calculateValue(fontSize, styleable, dummyFontProperty, styleMap, (Set<PseudoClass>)states, styleable, parentCachedFont)).getValue() instanceof Double) {
            Font font;
            boolean isRelative;
            if (origin == null || origin.compareTo(fontSize.getOrigin()) <= 0) {
                origin = cv4.getOrigin();
            }
            size = (Double)cv4.getValue();
            if (cvFont != null) {
                isRelative = cvFont.isRelative() || cv4.isRelative();
                font = this.deriveFont((Font)cvFont.getValue(), family, weight, posture, size);
                cvFont = new CalculatedValue(font, origin, isRelative);
            } else {
                isRelative = cv4.isRelative();
                font = this.deriveFont(Font.getDefault(), family, weight, posture, size);
                cvFont = new CalculatedValue(font, origin, isRelative);
            }
            foundStyle = true;
        }
        if (cachedFont == null) {
            return cvFont != null ? cvFont : CalculatedValue.SKIP;
        }
        CascadingStyle fontWeight = this.getStyle(styleable, property.concat("-weight"), styleMap, (Set<PseudoClass>)states);
        if (fontWeight != null) {
            if (fontShorthand != null && fontShorthand.compareTo(fontWeight) < 0) {
                fontWeight = null;
            }
        } else if (origin != StyleOrigin.USER) {
            fontWeight = this.lookupInheritedFontProperty(styleable, property.concat("-weight"), styleMap, distance, fontShorthand);
        }
        if (fontWeight != null && (cv3 = this.calculateValue(fontWeight, styleable, dummyFontProperty, styleMap, (Set<PseudoClass>)states, styleable, null)).getValue() instanceof FontWeight) {
            if (origin == null || origin.compareTo(fontWeight.getOrigin()) <= 0) {
                origin = cv3.getOrigin();
            }
            weight = (FontWeight)((Object)cv3.getValue());
            foundStyle = true;
        }
        if ((fontStyle = this.getStyle(styleable, property.concat("-style"), styleMap, (Set<PseudoClass>)states)) != null) {
            if (fontShorthand != null && fontShorthand.compareTo(fontStyle) < 0) {
                fontStyle = null;
            }
        } else if (origin != StyleOrigin.USER) {
            fontStyle = this.lookupInheritedFontProperty(styleable, property.concat("-style"), styleMap, distance, fontShorthand);
        }
        if (fontStyle != null && (cv2 = this.calculateValue(fontStyle, styleable, dummyFontProperty, styleMap, (Set<PseudoClass>)states, styleable, null)).getValue() instanceof FontPosture) {
            if (origin == null || origin.compareTo(fontStyle.getOrigin()) <= 0) {
                origin = cv2.getOrigin();
            }
            posture = (FontPosture)((Object)cv2.getValue());
            foundStyle = true;
        }
        if ((fontFamily = this.getStyle(styleable, property.concat("-family"), styleMap, (Set<PseudoClass>)states)) != null) {
            if (fontShorthand != null && fontShorthand.compareTo(fontFamily) < 0) {
                fontFamily = null;
            }
        } else if (origin != StyleOrigin.USER) {
            fontFamily = this.lookupInheritedFontProperty(styleable, property.concat("-family"), styleMap, distance, fontShorthand);
        }
        if (fontFamily != null && (cv = this.calculateValue(fontFamily, styleable, dummyFontProperty, styleMap, (Set<PseudoClass>)states, styleable, null)).getValue() instanceof String) {
            if (origin == null || origin.compareTo(fontFamily.getOrigin()) <= 0) {
                origin = cv.getOrigin();
            }
            family = (String)cv.getValue();
            foundStyle = true;
        }
        if (foundStyle) {
            Font font = cvFont != null ? (Font)cvFont.getValue() : Font.getDefault();
            Font derivedFont = this.deriveFont(font, family, weight, posture, size);
            return new CalculatedValue(derivedFont, origin, false);
        }
        return CalculatedValue.SKIP;
    }

    private CascadingStyle lookupInheritedFontProperty(Styleable styleable, String property, StyleMap styleMap, int distance, CascadingStyle fontShorthand) {
        int nlooks = distance;
        for (Styleable parent = styleable != null ? styleable.getStyleableParent() : null; parent != null && nlooks > 0; parent = parent.getStyleableParent()) {
            ObservableSet<PseudoClass> transitionStates;
            CssStyleHelper parentStyleHelper;
            CssStyleHelper cssStyleHelper = parentStyleHelper = parent instanceof Node ? ((Node)parent).styleHelper : null;
            if (parentStyleHelper == null) continue;
            --nlooks;
            StyleMap parentStyleMap = parentStyleHelper.getStyleMap(parent);
            CascadingStyle cascadingStyle = parentStyleHelper.getStyle(parent, property, parentStyleMap, (Set<PseudoClass>)(transitionStates = ((Node)parent).pseudoClassStates));
            if (cascadingStyle == null) continue;
            if (fontShorthand != null && nlooks == 0 && fontShorthand.compareTo(cascadingStyle) < 0) {
                return null;
            }
            ParsedValue cssValue = cascadingStyle.getParsedValue();
            if ("inherit".equals(cssValue.getValue())) continue;
            return cascadingStyle;
        }
        return null;
    }

    static List<Style> getMatchingStyles(Styleable styleable, CssMetaData styleableProperty) {
        CssStyleHelper helper;
        if (!(styleable instanceof Node)) {
            return Collections.emptyList();
        }
        Node node = (Node)styleable;
        CssStyleHelper cssStyleHelper = helper = node.styleHelper != null ? node.styleHelper : CssStyleHelper.createStyleHelper(node);
        if (helper != null) {
            return helper.getMatchingStyles(node, styleableProperty, false);
        }
        return Collections.emptyList();
    }

    static Map<StyleableProperty<?>, List<Style>> getMatchingStyles(Map<StyleableProperty<?>, List<Style>> map, Node node) {
        CssStyleHelper helper;
        CssStyleHelper cssStyleHelper = helper = node.styleHelper != null ? node.styleHelper : CssStyleHelper.createStyleHelper(node);
        if (helper != null) {
            if (map == null) {
                map = new HashMap();
            }
            for (CssMetaData cssMetaData : node.getCssMetaData()) {
                List<Style> styleList = helper.getMatchingStyles(node, cssMetaData, true);
                if (styleList == null || styleList.isEmpty()) continue;
                StyleableProperty prop = cssMetaData.getStyleableProperty(node);
                map.put(prop, styleList);
            }
        }
        if (node instanceof Parent) {
            for (Node node2 : ((Parent)node).getChildren()) {
                map = CssStyleHelper.getMatchingStyles(map, node2);
            }
        }
        return map;
    }

    private List<Style> getMatchingStyles(Styleable node, CssMetaData styleableProperty, boolean matchState) {
        ArrayList<CascadingStyle> styleList = new ArrayList<CascadingStyle>();
        this.getMatchingStyles(node, styleableProperty, styleList, matchState);
        List<CssMetaData<Styleable, ?>> subProperties = styleableProperty.getSubProperties();
        if (subProperties != null) {
            int nMax = subProperties.size();
            for (int n = 0; n < nMax; ++n) {
                CssMetaData<Styleable, ?> subProperty = subProperties.get(n);
                this.getMatchingStyles(node, subProperty, styleList, matchState);
            }
        }
        Collections.sort(styleList);
        ArrayList<Style> matchingStyles = new ArrayList<Style>(styleList.size());
        int nMax = styleList.size();
        for (int n = 0; n < nMax; ++n) {
            Style style = ((CascadingStyle)styleList.get(n)).getStyle();
            if (matchingStyles.contains(style)) continue;
            matchingStyles.add(style);
        }
        return matchingStyles;
    }

    private void getMatchingStyles(Styleable node, CssMetaData styleableProperty, List<CascadingStyle> styleList, boolean matchState) {
        if (node != null) {
            String property = styleableProperty.getProperty();
            Node _node = node instanceof Node ? (Node)node : null;
            StyleMap smap = this.getStyleMap(_node);
            if (smap == null) {
                return;
            }
            if (matchState) {
                CascadingStyle cascadingStyle = this.getStyle(node, styleableProperty.getProperty(), smap, (Set<PseudoClass>)_node.pseudoClassStates);
                if (cascadingStyle != null) {
                    styleList.add(cascadingStyle);
                    ParsedValue parsedValue = cascadingStyle.getParsedValue();
                    this.getMatchingLookupStyles(node, parsedValue, styleList, matchState);
                }
            } else {
                Map<String, List<CascadingStyle>> cascadingStyleMap = smap.getCascadingStyles();
                List<CascadingStyle> styles = cascadingStyleMap.get(property);
                if (styles != null) {
                    styleList.addAll(styles);
                    int nMax = styles.size();
                    for (int n = 0; n < nMax; ++n) {
                        CascadingStyle style = styles.get(n);
                        ParsedValue parsedValue = style.getParsedValue();
                        this.getMatchingLookupStyles(node, parsedValue, styleList, matchState);
                    }
                }
            }
            if (styleableProperty.isInherits()) {
                for (Styleable parent = node.getStyleableParent(); parent != null; parent = parent.getStyleableParent()) {
                    CssStyleHelper parentHelper;
                    CssStyleHelper cssStyleHelper = parentHelper = parent instanceof Node ? ((Node)parent).styleHelper : null;
                    if (parentHelper == null) continue;
                    parentHelper.getMatchingStyles(parent, styleableProperty, styleList, matchState);
                }
            }
        }
    }

    private void getMatchingLookupStyles(Styleable node, ParsedValue parsedValue, List<CascadingStyle> styleList, boolean matchState) {
        block12: {
            Object val;
            block11: {
                Object value;
                if (parsedValue.isLookup() && (value = parsedValue.getValue()) instanceof String) {
                    String property = (String)value;
                    Styleable parent = node;
                    do {
                        StyleMap styleMap;
                        CssStyleHelper helper;
                        Node _parent = parent instanceof Node ? (Node)parent : null;
                        CssStyleHelper cssStyleHelper = helper = _parent != null ? _parent.styleHelper : null;
                        if (helper == null || (styleMap = helper.getStyleMap(parent)) == null || styleMap.isEmpty()) continue;
                        int start = styleList.size();
                        if (matchState) {
                            CascadingStyle cascadingStyle = helper.resolveRef(_parent, property, styleMap, (Set<PseudoClass>)_parent.pseudoClassStates);
                            if (cascadingStyle != null) {
                                styleList.add(cascadingStyle);
                            }
                        } else {
                            Map<String, List<CascadingStyle>> smap = styleMap.getCascadingStyles();
                            List<CascadingStyle> styles = smap.get(property);
                            if (styles != null) {
                                styleList.addAll(styles);
                            }
                        }
                        int end = styleList.size();
                        for (int index = start; index < end; ++index) {
                            CascadingStyle style = styleList.get(index);
                            this.getMatchingLookupStyles(parent, style.getParsedValue(), styleList, matchState);
                        }
                    } while ((parent = parent.getStyleableParent()) != null);
                }
                if (!parsedValue.isContainsLookups()) {
                    return;
                }
                val = parsedValue.getValue();
                if (!(val instanceof ParsedValue[][])) break block11;
                ParsedValue[][] layers = (ParsedValue[][])val;
                for (int l = 0; l < layers.length; ++l) {
                    for (int ll = 0; ll < layers[l].length; ++ll) {
                        if (layers[l][ll] == null) continue;
                        this.getMatchingLookupStyles(node, layers[l][ll], styleList, matchState);
                    }
                }
                break block12;
            }
            if (!(val instanceof ParsedValue[])) break block12;
            ParsedValue[] layer = (ParsedValue[])val;
            for (int l = 0; l < layer.length; ++l) {
                if (layer[l] == null) continue;
                this.getMatchingLookupStyles(node, layer[l], styleList, matchState);
            }
        }
    }

    private static final class CacheContainer {
        private final StyleCache.Key styleCacheKey;
        private final CssMetaData<Styleable, Font> fontProp;
        private final int smapId;
        private final Map<StyleCacheEntry.Key, CalculatedValue> fontSizeCache;
        private final Map<CssMetaData, CalculatedValue> cssSetProperties;
        private boolean forceSlowpath = false;

        private CacheContainer(Node node, StyleMap styleMap, int depth) {
            int ctr = 0;
            int[] smapIds = new int[depth];
            smapIds[ctr++] = this.smapId = styleMap.getId();
            Styleable parent = node.getStyleableParent();
            for (int d = 1; d < depth; ++d) {
                if (parent instanceof Node) {
                    Node parentNode = (Node)parent;
                    CssStyleHelper helper = parentNode.styleHelper;
                    if (helper != null && helper.cacheContainer != null) {
                        smapIds[ctr++] = ((CssStyleHelper)helper).cacheContainer.smapId;
                    }
                }
                parent = parent.getStyleableParent();
            }
            this.styleCacheKey = new StyleCache.Key(smapIds, ctr);
            CssMetaData<Styleable, ?> styleableFontProperty = null;
            List<CssMetaData<Styleable, ?>> props = node.getCssMetaData();
            int pMax = props != null ? props.size() : 0;
            for (int p = 0; p < pMax; ++p) {
                CssMetaData<Styleable, ?> prop = props.get(p);
                if (!"-fx-font".equals(prop.getProperty())) continue;
                styleableFontProperty = prop;
                break;
            }
            this.fontProp = styleableFontProperty;
            this.fontSizeCache = new HashMap<StyleCacheEntry.Key, CalculatedValue>();
            this.cssSetProperties = new HashMap<CssMetaData, CalculatedValue>();
        }

        private StyleMap getStyleMap(Styleable styleable) {
            if (styleable != null) {
                SubScene subScene = styleable instanceof Node ? ((Node)styleable).getSubScene() : null;
                return StyleManager.getInstance().getStyleMap(styleable, subScene, this.smapId);
            }
            return StyleMap.EMPTY_MAP;
        }
    }
}

