/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.Effect;

public class ColorAdjust
extends Effect {
    private ObjectProperty<Effect> input;
    private DoubleProperty hue;
    private DoubleProperty saturation;
    private DoubleProperty brightness;
    private DoubleProperty contrast;

    public ColorAdjust() {
    }

    public ColorAdjust(double hue, double saturation, double brightness, double contrast) {
        this.setBrightness(brightness);
        this.setContrast(contrast);
        this.setHue(hue);
        this.setSaturation(saturation);
    }

    @Override
    com.sun.scenario.effect.ColorAdjust createPeer() {
        return new com.sun.scenario.effect.ColorAdjust();
    }

    public final void setInput(Effect value) {
        this.inputProperty().set((Object)value);
    }

    public final Effect getInput() {
        return this.input == null ? null : (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect.EffectInputProperty(this, "input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect e) {
        Effect localInput = this.getInput();
        if (localInput == null) {
            return false;
        }
        if (localInput == e) {
            return true;
        }
        return localInput.checkChainContains(e);
    }

    public final void setHue(double value) {
        this.hueProperty().set(value);
    }

    public final double getHue() {
        return this.hue == null ? 0.0 : this.hue.get();
    }

    public final DoubleProperty hueProperty() {
        if (this.hue == null) {
            this.hue = new DoublePropertyBase(){

                public void invalidated() {
                    ColorAdjust.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ColorAdjust.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return ColorAdjust.this;
                }

                public String getName() {
                    return "hue";
                }
            };
        }
        return this.hue;
    }

    public final void setSaturation(double value) {
        this.saturationProperty().set(value);
    }

    public final double getSaturation() {
        return this.saturation == null ? 0.0 : this.saturation.get();
    }

    public final DoubleProperty saturationProperty() {
        if (this.saturation == null) {
            this.saturation = new DoublePropertyBase(){

                public void invalidated() {
                    ColorAdjust.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ColorAdjust.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return ColorAdjust.this;
                }

                public String getName() {
                    return "saturation";
                }
            };
        }
        return this.saturation;
    }

    public final void setBrightness(double value) {
        this.brightnessProperty().set(value);
    }

    public final double getBrightness() {
        return this.brightness == null ? 0.0 : this.brightness.get();
    }

    public final DoubleProperty brightnessProperty() {
        if (this.brightness == null) {
            this.brightness = new DoublePropertyBase(){

                public void invalidated() {
                    ColorAdjust.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ColorAdjust.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return ColorAdjust.this;
                }

                public String getName() {
                    return "brightness";
                }
            };
        }
        return this.brightness;
    }

    public final void setContrast(double value) {
        this.contrastProperty().set(value);
    }

    public final double getContrast() {
        return this.contrast == null ? 0.0 : this.contrast.get();
    }

    public final DoubleProperty contrastProperty() {
        if (this.contrast == null) {
            this.contrast = new DoublePropertyBase(){

                public void invalidated() {
                    ColorAdjust.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ColorAdjust.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return ColorAdjust.this;
                }

                public String getName() {
                    return "contrast";
                }
            };
        }
        return this.contrast;
    }

    @Override
    void update() {
        Effect localInput = this.getInput();
        if (localInput != null) {
            localInput.sync();
        }
        com.sun.scenario.effect.ColorAdjust peer = (com.sun.scenario.effect.ColorAdjust)this.getPeer();
        peer.setInput(localInput == null ? null : localInput.getPeer());
        peer.setHue((float)Utils.clamp(-1.0, this.getHue(), 1.0));
        peer.setSaturation((float)Utils.clamp(-1.0, this.getSaturation(), 1.0));
        peer.setBrightness((float)Utils.clamp(-1.0, this.getBrightness(), 1.0));
        peer.setContrast((float)Utils.clamp(-1.0, this.getContrast(), 1.0));
    }

    @Override
    BaseBounds getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        return ColorAdjust.getInputBounds(bounds, tx, node, boundsAccessor, this.getInput());
    }

    @Override
    Effect copy() {
        ColorAdjust ca = new ColorAdjust(this.getHue(), this.getSaturation(), this.getBrightness(), this.getContrast());
        ca.setInput(ca.getInput());
        return ca;
    }
}

